#!/usr/bin/env perl

use strict;
use warnings;

use FindBin qw($Bin);
use lib "$Bin/../lib";
use lib "$Bin/lib";

use DBI;
use TestSchema;
use IO::Async::Loop;
use DBIx::Class::Async;
use DBIx::Class::Async::Schema;

print "1..7\n";

my $dbh = DBI->connect("dbi:SQLite:dbname=:memory:", "", "", {
    RaiseError => 1,
    PrintError => 0,
});

$dbh->do("CREATE TABLE users (id INTEGER PRIMARY KEY AUTOINCREMENT, name VARCHAR(50), email VARCHAR(100), active INTEGER DEFAULT 1)");
$dbh->do("CREATE TABLE orders (id INTEGER PRIMARY KEY AUTOINCREMENT, user_id INTEGER, amount DECIMAL(10,2), status VARCHAR(20) DEFAULT 'pending')");
$dbh->disconnect;

print "ok 1 - Database created\n";

my $loop = IO::Async::Loop->new;
print "ok 2 - Loop created\n";

my $schema;
eval {
    $schema = DBIx::Class::Async::Schema->connect(
        "dbi:SQLite:dbname=:memory:",
        undef,
        undef,
        {},
        {
            workers => 1,
            schema_class => 'TestSchema',
            loop => $loop
        }
    );
    print "ok 3 - Schema connected\n";
    1;
} or do {
    print "not ok 3 - $@\n";
    exit 1;
};

my $rs;
eval {
    $rs = $schema->resultset('User');
    print "ok 4 - Got resultset\n";
    1;
} or do {
    print "not ok 4 - $@\n";
    exit 1;
};

eval {
    my $future = $rs->create({
        name  => 'Debug Test',
        email => 'debug@example.com',
    });

    print "ok 5 - Future created\n";

    # Try to get the result
    my $result = $future->get;

    if ($result) {
        print "ok 6 - Got result: " . ref($result) . "\n";
        print "ok 7 - Test passed\n";
    } else {
        print "not ok 6 - No result\n";
        print "not ok 7 - Test failed\n";
    }

    1;
} or do {
    my $error = $@;
    print "not ok 5 - Future failed: $error\n";
    print "not ok 6 - Skipped\n";
    print "not ok 7 - Skipped\n";
};
