/* ePubReader.c generated by valac 0.56.18, the Vala compiler
 * generated from ePubReader.vala, do not modify */

/* Copyright 2017 Siddhartha Das (bablu.boy@gmail.com)
*
* This file is part of Bookworm and is used for parsing EPUB file formats
*
* Bookworm is free software: you can redistribute it
* and/or modify it under the terms of the GNU General Public License as
* published by the Free Software Foundation, either version 3 of the
* License, or (at your option) any later version.
*
* Bookworm is distributed in the hope that it will be
* useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
* Public License for more details.
*
* You should have received a copy of the GNU General Public License along
* with Bookworm. If not, see http://www.gnu.org/licenses/.
*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gee.h>
#include <granite.h>
#include <gobject/gvaluecollector.h>

#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE _ ("Problem in extracting contents of book. Ensure there is a valid eBook " \
"file here: ")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_MIMETYPE_ISSUE _ ("Invalid media type detected. Check format for this eBook: ")
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE _ ("Invalid content found. Ensure there is a valid eBook file here: ")
#define BOOKWORM_APP_CONSTANTS_bookworm_id "com.github.babluboy.bookworm"
#define BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION "/tmp/" BOOKWORM_APP_CONSTANTS_bookworm_id "/"
#define BOOKWORM_APP_CONSTANTS_EPUB_MIME_SPECIFICATION_FILENAME "mimetype"
#define BOOKWORM_APP_CONSTANTS_EPUB_MIME_SPECIFICATION_CONTENT "application/epub+zip"
#define BOOKWORM_APP_CONSTANTS_EPUB_META_INF_FILENAME "META-INF/container.xml"
#define BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE _ ("Unknown Book")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define BOOKWORM_APP_TYPE_EPUB_READER (bookworm_app_epub_reader_get_type ())
#define BOOKWORM_APP_EPUB_READER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_EPUB_READER, BookwormAppePubReader))
#define BOOKWORM_APP_EPUB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_EPUB_READER, BookwormAppePubReaderClass))
#define BOOKWORM_APP_IS_EPUB_READER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_EPUB_READER))
#define BOOKWORM_APP_IS_EPUB_READER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_EPUB_READER))
#define BOOKWORM_APP_EPUB_READER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_EPUB_READER, BookwormAppePubReaderClass))

typedef struct _BookwormAppePubReader BookwormAppePubReader;
typedef struct _BookwormAppePubReaderClass BookwormAppePubReaderClass;
typedef struct _BookwormAppePubReaderPrivate BookwormAppePubReaderPrivate;

#define BOOKWORM_APP_TYPE_BOOK (bookworm_app_book_get_type ())
#define BOOKWORM_APP_BOOK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBook))
#define BOOKWORM_APP_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))
#define BOOKWORM_APP_IS_BOOK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_IS_BOOK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_BOOK))
#define BOOKWORM_APP_BOOK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_BOOK, BookwormAppBookClass))

typedef struct _BookwormAppBook BookwormAppBook;
typedef struct _BookwormAppBookClass BookwormAppBookClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _bookworm_app_book_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_book_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_SETTINGS (bookworm_app_settings_get_type ())
#define BOOKWORM_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettings))
#define BOOKWORM_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))
#define BOOKWORM_APP_IS_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_IS_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_SETTINGS))
#define BOOKWORM_APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_SETTINGS, BookwormAppSettingsClass))

typedef struct _BookwormAppSettings BookwormAppSettings;
typedef struct _BookwormAppSettingsClass BookwormAppSettingsClass;

#define BOOKWORM_APP_TYPE_XML_DATA (bookworm_app_xml_data_get_type ())
#define BOOKWORM_APP_XML_DATA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_XML_DATA, BookwormAppXMLData))
#define BOOKWORM_APP_XML_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_XML_DATA, BookwormAppXMLDataClass))
#define BOOKWORM_APP_IS_XML_DATA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_XML_DATA))
#define BOOKWORM_APP_IS_XML_DATA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_XML_DATA))
#define BOOKWORM_APP_XML_DATA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_XML_DATA, BookwormAppXMLDataClass))

typedef struct _BookwormAppXMLData BookwormAppXMLData;
typedef struct _BookwormAppXMLDataClass BookwormAppXMLDataClass;
typedef struct _BookwormAppXMLDataPrivate BookwormAppXMLDataPrivate;
#define _bookworm_app_xml_data_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_xml_data_unref (var), NULL)))

#define BOOKWORM_APP_TYPE_XML_PARSER (bookworm_app_xml_parser_get_type ())
#define BOOKWORM_APP_XML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOOKWORM_APP_TYPE_XML_PARSER, BookwormAppXmlParser))
#define BOOKWORM_APP_XML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOOKWORM_APP_TYPE_XML_PARSER, BookwormAppXmlParserClass))
#define BOOKWORM_APP_IS_XML_PARSER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOOKWORM_APP_TYPE_XML_PARSER))
#define BOOKWORM_APP_IS_XML_PARSER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOOKWORM_APP_TYPE_XML_PARSER))
#define BOOKWORM_APP_XML_PARSER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOOKWORM_APP_TYPE_XML_PARSER, BookwormAppXmlParserClass))

typedef struct _BookwormAppXmlParser BookwormAppXmlParser;
typedef struct _BookwormAppXmlParserClass BookwormAppXmlParserClass;
#define _bookworm_app_xml_parser_unref0(var) ((var == NULL) ? NULL : (var = (bookworm_app_xml_parser_unref (var), NULL)))
typedef struct _BookwormAppParamSpecePubReader BookwormAppParamSpecePubReader;

struct _BookwormAppePubReader {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppePubReaderPrivate * priv;
};

struct _BookwormAppePubReaderClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppePubReader *self);
};

struct _BookwormAppXMLData {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BookwormAppXMLDataPrivate * priv;
	gboolean shouldExtractionStart;
	gboolean useLocalTagName;
	gboolean isContainerTagMatched;
	gchar* currentTagName;
	GString* charBuffer;
	gchar* containerTagName;
	gchar* inputTagName;
	gchar* inputAttributeName;
	gboolean isXMLExtraction;
	gboolean enforceAttributeData;
	GeeArrayList* extractedTagValues;
	GeeArrayList* extractedTagAttributes;
};

struct _BookwormAppXMLDataClass {
	GTypeClass parent_class;
	void (*finalize) (BookwormAppXMLData *self);
};

struct _BookwormAppParamSpecePubReader {
	GParamSpec parent_instance;
};

static gpointer bookworm_app_epub_reader_parent_class = NULL;
VALA_EXTERN gchar* bookworm_app_epub_reader_NCXRefInSpineData;
gchar* bookworm_app_epub_reader_NCXRefInSpineData = NULL;
VALA_EXTERN BookwormAppSettings* bookworm_app_bookworm_settings;
VALA_EXTERN gchar* bookworm_app_bookworm_bookworm_config_path;

VALA_EXTERN gpointer bookworm_app_epub_reader_ref (gpointer instance);
VALA_EXTERN void bookworm_app_epub_reader_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_epub_reader (const gchar* name,
                                                 const gchar* nick,
                                                 const gchar* blurb,
                                                 GType object_type,
                                                 GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_epub_reader (GValue* value,
                                         gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_epub_reader (GValue* value,
                                          gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_epub_reader (const GValue* value);
VALA_EXTERN GType bookworm_app_epub_reader_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppePubReader, bookworm_app_epub_reader_unref)
VALA_EXTERN gpointer bookworm_app_book_ref (gpointer instance);
VALA_EXTERN void bookworm_app_book_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_book (const gchar* name,
                                          const gchar* nick,
                                          const gchar* blurb,
                                          GType object_type,
                                          GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_book (GValue* value,
                                  gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_book (GValue* value,
                                   gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_book (const GValue* value);
VALA_EXTERN GType bookworm_app_book_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppBook, bookworm_app_book_unref)
VALA_EXTERN BookwormAppBook* bookworm_app_epub_reader_parseEPubBook (BookwormAppBook* aBook);
VALA_EXTERN gchar* bookworm_app_book_getBookLocation (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_book_getIsBookParsed (BookwormAppBook* self);
VALA_EXTERN gchar* bookworm_app_epub_reader_extractEBook (const gchar* eBookLocation);
VALA_EXTERN void bookworm_app_book_setIsBookParsed (BookwormAppBook* self,
                                        gboolean isParsed);
VALA_EXTERN void bookworm_app_book_setParsingIssue (BookwormAppBook* self,
                                        const gchar* aParsingIssue);
VALA_EXTERN void bookworm_app_book_setBookExtractionLocation (BookwormAppBook* self,
                                                  const gchar* aBookExtractionLocation);
VALA_EXTERN gboolean bookworm_app_epub_reader_isEPubFormat (const gchar* extractionLocation);
VALA_EXTERN gchar* bookworm_app_epub_reader_getOPFFileLocation (const gchar* extractionLocation);
VALA_EXTERN void bookworm_app_book_setBaseLocationOfContents (BookwormAppBook* self,
                                                  const gchar* aBaseLocationOfContents);
VALA_EXTERN BookwormAppBook* bookworm_app_epub_reader_determineToC (BookwormAppBook* aBook,
                                                        const gchar* locationOfOPFFile);
VALA_EXTERN GeeArrayList* bookworm_app_book_getBookContentList (BookwormAppBook* self);
VALA_EXTERN gboolean bookworm_app_book_getIsBookCoverImagePresent (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_epub_reader_setCoverImage (BookwormAppBook* aBook,
                                                         const gchar* locationOfOPFFile);
VALA_EXTERN BookwormAppBook* bookworm_app_epub_reader_setBookMetaData (BookwormAppBook* aBook,
                                                           const gchar* locationOfOPFFile);
VALA_EXTERN GType bookworm_app_settings_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppSettings, g_object_unref)
VALA_EXTERN BookwormAppSettings* bookworm_app_settings_get_instance (void);
VALA_EXTERN gboolean bookworm_app_settings_get_is_local_storage_enabled (BookwormAppSettings* self);
VALA_EXTERN gchar* bookworm_app_utils_fileOperations (const gchar* operation,
                                          const gchar* path,
                                          const gchar* filename,
                                          const gchar* contents);
VALA_EXTERN gchar* bookworm_app_utils_execute_sync_command (const gchar* cmd);
VALA_EXTERN gpointer bookworm_app_xml_data_ref (gpointer instance);
VALA_EXTERN void bookworm_app_xml_data_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_xml_data (const gchar* name,
                                              const gchar* nick,
                                              const gchar* blurb,
                                              GType object_type,
                                              GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_xml_data (GValue* value,
                                      gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_xml_data (GValue* value,
                                       gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_xml_data (const GValue* value);
VALA_EXTERN GType bookworm_app_xml_data_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppXMLData, bookworm_app_xml_data_unref)
VALA_EXTERN BookwormAppXMLData* bookworm_app_xml_data_new (void);
VALA_EXTERN BookwormAppXMLData* bookworm_app_xml_data_construct (GType object_type);
VALA_EXTERN gpointer bookworm_app_xml_parser_ref (gpointer instance);
VALA_EXTERN void bookworm_app_xml_parser_unref (gpointer instance);
VALA_EXTERN GParamSpec* bookworm_app_param_spec_xml_parser (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void bookworm_app_value_set_xml_parser (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void bookworm_app_value_take_xml_parser (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer bookworm_app_value_get_xml_parser (const GValue* value);
VALA_EXTERN GType bookworm_app_xml_parser_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BookwormAppXmlParser, bookworm_app_xml_parser_unref)
VALA_EXTERN BookwormAppXmlParser* bookworm_app_xml_parser_new (void);
VALA_EXTERN BookwormAppXmlParser* bookworm_app_xml_parser_construct (GType object_type);
VALA_EXTERN GeeArrayList* bookworm_app_xml_parser_extractDataFromXML (BookwormAppXmlParser* self,
                                                          const gchar* path,
                                                          GeeArrayList* inputDataList,
                                                          gboolean isXMLExtraction);
VALA_EXTERN gchar* bookworm_app_utils_getFullPathFromFilename (const gchar* rootDirectoryToSearch,
                                                   const gchar* fileName);
VALA_EXTERN gchar* bookworm_app_book_getBaseLocationOfContents (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setTOC (BookwormAppBook* self,
                               GeeHashMap* toc);
VALA_EXTERN void bookworm_app_book_clearBookContentList (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookContentList (BookwormAppBook* self,
                                           const gchar* contentList);
VALA_EXTERN void bookworm_app_book_setIsBookCoverImagePresent (BookwormAppBook* self,
                                                   gboolean isABookCoverImagePresent);
VALA_EXTERN gchar* bookworm_app_book_getBookExtractionLocation (BookwormAppBook* self);
VALA_EXTERN BookwormAppBook* bookworm_app_utils_setBookCoverImage (BookwormAppBook* aBook,
                                                       const gchar* bookCoverImageLocation);
VALA_EXTERN void bookworm_app_book_setBookTitle (BookwormAppBook* self,
                                     const gchar* aBookTitle);
VALA_EXTERN gchar* bookworm_app_utils_decodeHTMLChars (const gchar* inputString);
VALA_EXTERN gchar* bookworm_app_book_getBookTitle (BookwormAppBook* self);
VALA_EXTERN void bookworm_app_book_setBookAuthor (BookwormAppBook* self,
                                      const gchar* aBookAuthor);
VALA_EXTERN BookwormAppePubReader* bookworm_app_epub_reader_new (void);
VALA_EXTERN BookwormAppePubReader* bookworm_app_epub_reader_construct (GType object_type);
static void bookworm_app_epub_reader_finalize (BookwormAppePubReader * obj);
static GType bookworm_app_epub_reader_get_type_once (void);

static gpointer
_bookworm_app_book_ref0 (gpointer self)
{
#line 32 "../src/ePubReader.vala"
	return self ? bookworm_app_book_ref (self) : NULL;
#line 287 "ePubReader.c"
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (old != NULL, NULL);
#line 1588 "glib-2.0.vapi"
	g_return_val_if_fail (replacement != NULL, NULL);
#line 1589 "glib-2.0.vapi"
	if ((*((gchar*) self)) == '\0') {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = TRUE;
#line 309 "ePubReader.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp1_ = (*((gchar*) old)) == '\0';
#line 313 "ePubReader.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp1_) {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = TRUE;
#line 319 "ePubReader.c"
	} else {
#line 1589 "glib-2.0.vapi"
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
#line 323 "ePubReader.c"
	}
#line 1589 "glib-2.0.vapi"
	if (_tmp0_) {
#line 327 "ePubReader.c"
		gchar* _tmp2_;
#line 1590 "glib-2.0.vapi"
		_tmp2_ = g_strdup (self);
#line 1590 "glib-2.0.vapi"
		result = _tmp2_;
#line 1590 "glib-2.0.vapi"
		return result;
#line 335 "ePubReader.c"
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
#line 1593 "glib-2.0.vapi"
		_tmp3_ = g_regex_escape_string (old, -1);
#line 1593 "glib-2.0.vapi"
		_tmp4_ = _tmp3_;
#line 1593 "glib-2.0.vapi"
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
#line 1593 "glib-2.0.vapi"
		_tmp6_ = _tmp5_;
#line 1593 "glib-2.0.vapi"
		_g_free0 (_tmp4_);
#line 1593 "glib-2.0.vapi"
		regex = _tmp6_;
#line 1593 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1593 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 363 "ePubReader.c"
				goto __catch0_g_regex_error;
			}
#line 1593 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1593 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1593 "glib-2.0.vapi"
			return NULL;
#line 372 "ePubReader.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp8_ = regex;
#line 1594 "glib-2.0.vapi"
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
#line 1594 "glib-2.0.vapi"
		_tmp7_ = _tmp9_;
#line 1594 "glib-2.0.vapi"
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
#line 1594 "glib-2.0.vapi"
			_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
			if (_inner_error0_->domain == G_REGEX_ERROR) {
#line 386 "ePubReader.c"
				goto __catch0_g_regex_error;
			}
#line 1594 "glib-2.0.vapi"
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1594 "glib-2.0.vapi"
			g_clear_error (&_inner_error0_);
#line 1594 "glib-2.0.vapi"
			return NULL;
#line 395 "ePubReader.c"
		}
#line 1594 "glib-2.0.vapi"
		_tmp10_ = _tmp7_;
#line 1594 "glib-2.0.vapi"
		_tmp7_ = NULL;
#line 1594 "glib-2.0.vapi"
		result = _tmp10_;
#line 1594 "glib-2.0.vapi"
		_g_free0 (_tmp7_);
#line 1594 "glib-2.0.vapi"
		_g_regex_unref0 (regex);
#line 1594 "glib-2.0.vapi"
		return result;
#line 409 "ePubReader.c"
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
#line 1592 "glib-2.0.vapi"
		g_clear_error (&_inner_error0_);
#line 1596 "glib-2.0.vapi"
		g_assert_not_reached ();
#line 418 "ePubReader.c"
	}
	__finally0:
#line 1592 "glib-2.0.vapi"
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
#line 1592 "glib-2.0.vapi"
	g_clear_error (&_inner_error0_);
#line 1592 "glib-2.0.vapi"
	return NULL;
#line 427 "ePubReader.c"
}

BookwormAppBook*
bookworm_app_epub_reader_parseEPubBook (BookwormAppBook* aBook)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	BookwormAppBook* _tmp45_;
	BookwormAppBook* result;
#line 22 "../src/ePubReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 23 "../src/ePubReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 23 "../src/ePubReader.vala"
	_tmp1_ = _tmp0_;
#line 23 "../src/ePubReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:parseEPubBook] book.location=", _tmp1_, NULL);
#line 23 "../src/ePubReader.vala"
	_tmp3_ = _tmp2_;
#line 23 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:23: %s", _tmp3_);
#line 23 "../src/ePubReader.vala"
	_g_free0 (_tmp3_);
#line 23 "../src/ePubReader.vala"
	_g_free0 (_tmp1_);
#line 25 "../src/ePubReader.vala"
	if (!bookworm_app_book_getIsBookParsed (aBook)) {
#line 457 "ePubReader.c"
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* extractionLocation = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		const gchar* _tmp12_;
		gboolean isEPubFormat = FALSE;
		const gchar* _tmp15_;
		gchar* locationOfOPFFile = NULL;
		const gchar* _tmp17_;
		gchar* _tmp18_;
		const gchar* _tmp19_;
		gchar* baseLocationOfContents = NULL;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		GFile* _tmp23_;
		GFile* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		BookwormAppBook* _tmp30_;
		const gchar* _tmp31_;
		BookwormAppBook* _tmp32_;
		GeeArrayList* _tmp33_;
		GeeArrayList* _tmp34_;
		gint _tmp35_;
		gint _tmp36_;
		gboolean _tmp37_;
		BookwormAppBook* _tmp42_;
		const gchar* _tmp43_;
		BookwormAppBook* _tmp44_;
#line 26 "../src/ePubReader.vala"
		_tmp4_ = bookworm_app_book_getBookLocation (aBook);
#line 26 "../src/ePubReader.vala"
		_tmp5_ = _tmp4_;
#line 26 "../src/ePubReader.vala"
		_tmp6_ = g_strconcat ("Starting to parse EPub Book located at:", _tmp5_, NULL);
#line 26 "../src/ePubReader.vala"
		_tmp7_ = _tmp6_;
#line 26 "../src/ePubReader.vala"
		g_debug ("ePubReader.vala:26: %s", _tmp7_);
#line 26 "../src/ePubReader.vala"
		_g_free0 (_tmp7_);
#line 26 "../src/ePubReader.vala"
		_g_free0 (_tmp5_);
#line 28 "../src/ePubReader.vala"
		_tmp8_ = bookworm_app_book_getBookLocation (aBook);
#line 28 "../src/ePubReader.vala"
		_tmp9_ = _tmp8_;
#line 28 "../src/ePubReader.vala"
		_tmp10_ = bookworm_app_epub_reader_extractEBook (_tmp9_);
#line 28 "../src/ePubReader.vala"
		_tmp11_ = _tmp10_;
#line 28 "../src/ePubReader.vala"
		_g_free0 (_tmp9_);
#line 28 "../src/ePubReader.vala"
		extractionLocation = _tmp11_;
#line 29 "../src/ePubReader.vala"
		_tmp12_ = extractionLocation;
#line 29 "../src/ePubReader.vala"
		if (g_strcmp0 ("false", _tmp12_) == 0) {
#line 525 "ePubReader.c"
			BookwormAppBook* _tmp13_;
#line 30 "../src/ePubReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 31 "../src/ePubReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_EXTRACTION_ISSUE);
#line 32 "../src/ePubReader.vala"
			_tmp13_ = _bookworm_app_book_ref0 (aBook);
#line 32 "../src/ePubReader.vala"
			result = _tmp13_;
#line 32 "../src/ePubReader.vala"
			_g_free0 (extractionLocation);
#line 32 "../src/ePubReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 32 "../src/ePubReader.vala"
			return result;
#line 541 "ePubReader.c"
		} else {
			const gchar* _tmp14_;
#line 34 "../src/ePubReader.vala"
			_tmp14_ = extractionLocation;
#line 34 "../src/ePubReader.vala"
			bookworm_app_book_setBookExtractionLocation (aBook, _tmp14_);
#line 548 "ePubReader.c"
		}
#line 37 "../src/ePubReader.vala"
		_tmp15_ = extractionLocation;
#line 37 "../src/ePubReader.vala"
		isEPubFormat = bookworm_app_epub_reader_isEPubFormat (_tmp15_);
#line 38 "../src/ePubReader.vala"
		if (!isEPubFormat) {
#line 556 "ePubReader.c"
			BookwormAppBook* _tmp16_;
#line 39 "../src/ePubReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 40 "../src/ePubReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_MIMETYPE_ISSUE);
#line 41 "../src/ePubReader.vala"
			_tmp16_ = _bookworm_app_book_ref0 (aBook);
#line 41 "../src/ePubReader.vala"
			result = _tmp16_;
#line 41 "../src/ePubReader.vala"
			_g_free0 (extractionLocation);
#line 41 "../src/ePubReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 41 "../src/ePubReader.vala"
			return result;
#line 572 "ePubReader.c"
		}
#line 44 "../src/ePubReader.vala"
		_tmp17_ = extractionLocation;
#line 44 "../src/ePubReader.vala"
		_tmp18_ = bookworm_app_epub_reader_getOPFFileLocation (_tmp17_);
#line 44 "../src/ePubReader.vala"
		locationOfOPFFile = _tmp18_;
#line 45 "../src/ePubReader.vala"
		_tmp19_ = locationOfOPFFile;
#line 45 "../src/ePubReader.vala"
		if (g_strcmp0 ("false", _tmp19_) == 0) {
#line 584 "ePubReader.c"
			BookwormAppBook* _tmp20_;
#line 46 "../src/ePubReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 47 "../src/ePubReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE);
#line 48 "../src/ePubReader.vala"
			_tmp20_ = _bookworm_app_book_ref0 (aBook);
#line 48 "../src/ePubReader.vala"
			result = _tmp20_;
#line 48 "../src/ePubReader.vala"
			_g_free0 (locationOfOPFFile);
#line 48 "../src/ePubReader.vala"
			_g_free0 (extractionLocation);
#line 48 "../src/ePubReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 48 "../src/ePubReader.vala"
			return result;
#line 602 "ePubReader.c"
		}
#line 50 "../src/ePubReader.vala"
		_tmp21_ = locationOfOPFFile;
#line 50 "../src/ePubReader.vala"
		_tmp22_ = locationOfOPFFile;
#line 50 "../src/ePubReader.vala"
		_tmp23_ = g_file_new_for_path (_tmp22_);
#line 50 "../src/ePubReader.vala"
		_tmp24_ = _tmp23_;
#line 50 "../src/ePubReader.vala"
		_tmp25_ = g_file_get_basename (_tmp24_);
#line 50 "../src/ePubReader.vala"
		_tmp26_ = _tmp25_;
#line 50 "../src/ePubReader.vala"
		_tmp27_ = string_replace (_tmp21_, _tmp26_, "");
#line 50 "../src/ePubReader.vala"
		_tmp28_ = _tmp27_;
#line 50 "../src/ePubReader.vala"
		_g_free0 (_tmp26_);
#line 50 "../src/ePubReader.vala"
		_g_object_unref0 (_tmp24_);
#line 50 "../src/ePubReader.vala"
		baseLocationOfContents = _tmp28_;
#line 51 "../src/ePubReader.vala"
		_tmp29_ = baseLocationOfContents;
#line 51 "../src/ePubReader.vala"
		bookworm_app_book_setBaseLocationOfContents (aBook, _tmp29_);
#line 54 "../src/ePubReader.vala"
		_tmp30_ = _bookworm_app_book_ref0 (aBook);
#line 54 "../src/ePubReader.vala"
		_tmp31_ = locationOfOPFFile;
#line 54 "../src/ePubReader.vala"
		_tmp32_ = bookworm_app_epub_reader_determineToC (_tmp30_, _tmp31_);
#line 54 "../src/ePubReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 54 "../src/ePubReader.vala"
		aBook = _tmp32_;
#line 55 "../src/ePubReader.vala"
		_tmp33_ = bookworm_app_book_getBookContentList (aBook);
#line 55 "../src/ePubReader.vala"
		_tmp34_ = _tmp33_;
#line 55 "../src/ePubReader.vala"
		_tmp35_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp34_);
#line 55 "../src/ePubReader.vala"
		_tmp36_ = _tmp35_;
#line 55 "../src/ePubReader.vala"
		_tmp37_ = _tmp36_ < 1;
#line 55 "../src/ePubReader.vala"
		_g_object_unref0 (_tmp34_);
#line 55 "../src/ePubReader.vala"
		if (_tmp37_) {
#line 654 "ePubReader.c"
			BookwormAppBook* _tmp38_;
#line 56 "../src/ePubReader.vala"
			bookworm_app_book_setIsBookParsed (aBook, FALSE);
#line 57 "../src/ePubReader.vala"
			bookworm_app_book_setParsingIssue (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_CONTENT_ISSUE);
#line 58 "../src/ePubReader.vala"
			_tmp38_ = _bookworm_app_book_ref0 (aBook);
#line 58 "../src/ePubReader.vala"
			result = _tmp38_;
#line 58 "../src/ePubReader.vala"
			_g_free0 (baseLocationOfContents);
#line 58 "../src/ePubReader.vala"
			_g_free0 (locationOfOPFFile);
#line 58 "../src/ePubReader.vala"
			_g_free0 (extractionLocation);
#line 58 "../src/ePubReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 58 "../src/ePubReader.vala"
			return result;
#line 674 "ePubReader.c"
		}
#line 62 "../src/ePubReader.vala"
		if (!bookworm_app_book_getIsBookCoverImagePresent (aBook)) {
#line 678 "ePubReader.c"
			BookwormAppBook* _tmp39_;
			const gchar* _tmp40_;
			BookwormAppBook* _tmp41_;
#line 63 "../src/ePubReader.vala"
			_tmp39_ = _bookworm_app_book_ref0 (aBook);
#line 63 "../src/ePubReader.vala"
			_tmp40_ = locationOfOPFFile;
#line 63 "../src/ePubReader.vala"
			_tmp41_ = bookworm_app_epub_reader_setCoverImage (_tmp39_, _tmp40_);
#line 63 "../src/ePubReader.vala"
			_bookworm_app_book_unref0 (aBook);
#line 63 "../src/ePubReader.vala"
			aBook = _tmp41_;
#line 692 "ePubReader.c"
		}
#line 67 "../src/ePubReader.vala"
		_tmp42_ = _bookworm_app_book_ref0 (aBook);
#line 67 "../src/ePubReader.vala"
		_tmp43_ = locationOfOPFFile;
#line 67 "../src/ePubReader.vala"
		_tmp44_ = bookworm_app_epub_reader_setBookMetaData (_tmp42_, _tmp43_);
#line 67 "../src/ePubReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 67 "../src/ePubReader.vala"
		aBook = _tmp44_;
#line 68 "../src/ePubReader.vala"
		bookworm_app_book_setIsBookParsed (aBook, TRUE);
#line 25 "../src/ePubReader.vala"
		_g_free0 (baseLocationOfContents);
#line 25 "../src/ePubReader.vala"
		_g_free0 (locationOfOPFFile);
#line 25 "../src/ePubReader.vala"
		_g_free0 (extractionLocation);
#line 712 "ePubReader.c"
	}
#line 70 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:70: [END] [FUNCTION:parseEPubBook]");
#line 71 "../src/ePubReader.vala"
	_tmp45_ = _bookworm_app_book_ref0 (aBook);
#line 71 "../src/ePubReader.vala"
	result = _tmp45_;
#line 71 "../src/ePubReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 71 "../src/ePubReader.vala"
	return result;
#line 724 "ePubReader.c"
}

gchar*
bookworm_app_epub_reader_extractEBook (const gchar* eBookLocation)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* extractionLocation = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	BookwormAppSettings* _tmp5_;
	BookwormAppSettings* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gchar* status = NULL;
	gchar* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* result;
#line 74 "../src/ePubReader.vala"
	g_return_val_if_fail (eBookLocation != NULL, NULL);
#line 75 "../src/ePubReader.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:extractEBook] eBookLocation=", eBookLocation, NULL);
#line 75 "../src/ePubReader.vala"
	_tmp1_ = _tmp0_;
#line 75 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:75: %s", _tmp1_);
#line 75 "../src/ePubReader.vala"
	_g_free0 (_tmp1_);
#line 76 "../src/ePubReader.vala"
	_tmp2_ = g_strdup ("false");
#line 76 "../src/ePubReader.vala"
	extractionLocation = _tmp2_;
#line 77 "../src/ePubReader.vala"
	_tmp3_ = g_strconcat ("Initiated process for content extraction of ePub Book located at:", eBookLocation, NULL);
#line 77 "../src/ePubReader.vala"
	_tmp4_ = _tmp3_;
#line 77 "../src/ePubReader.vala"
	g_debug ("ePubReader.vala:77: %s", _tmp4_);
#line 77 "../src/ePubReader.vala"
	_g_free0 (_tmp4_);
#line 79 "../src/ePubReader.vala"
	_tmp5_ = bookworm_app_bookworm_settings;
#line 79 "../src/ePubReader.vala"
	if (_tmp5_ == NULL) {
#line 786 "ePubReader.c"
		BookwormAppSettings* _tmp6_;
#line 80 "../src/ePubReader.vala"
		_tmp6_ = bookworm_app_settings_get_instance ();
#line 80 "../src/ePubReader.vala"
		_g_object_unref0 (bookworm_app_bookworm_settings);
#line 80 "../src/ePubReader.vala"
		bookworm_app_bookworm_settings = _tmp6_;
#line 794 "ePubReader.c"
	}
#line 82 "../src/ePubReader.vala"
	_tmp7_ = bookworm_app_bookworm_settings;
#line 82 "../src/ePubReader.vala"
	_tmp8_ = bookworm_app_settings_get_is_local_storage_enabled (_tmp7_);
#line 82 "../src/ePubReader.vala"
	_tmp9_ = _tmp8_;
#line 82 "../src/ePubReader.vala"
	if (_tmp9_) {
#line 804 "ePubReader.c"
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		GFile* _tmp13_;
		GFile* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
#line 83 "../src/ePubReader.vala"
		_tmp10_ = bookworm_app_bookworm_bookworm_config_path;
#line 83 "../src/ePubReader.vala"
		_tmp11_ = g_strconcat (_tmp10_, "/books/", NULL);
#line 83 "../src/ePubReader.vala"
		_tmp12_ = _tmp11_;
#line 83 "../src/ePubReader.vala"
		_tmp13_ = g_file_new_for_path (eBookLocation);
#line 83 "../src/ePubReader.vala"
		_tmp14_ = _tmp13_;
#line 83 "../src/ePubReader.vala"
		_tmp15_ = g_file_get_basename (_tmp14_);
#line 83 "../src/ePubReader.vala"
		_tmp16_ = _tmp15_;
#line 83 "../src/ePubReader.vala"
		_tmp17_ = g_strconcat (_tmp12_, _tmp16_, NULL);
#line 83 "../src/ePubReader.vala"
		_g_free0 (extractionLocation);
#line 83 "../src/ePubReader.vala"
		extractionLocation = _tmp17_;
#line 83 "../src/ePubReader.vala"
		_g_free0 (_tmp16_);
#line 83 "../src/ePubReader.vala"
		_g_object_unref0 (_tmp14_);
#line 83 "../src/ePubReader.vala"
		_g_free0 (_tmp12_);
#line 839 "ePubReader.c"
	} else {
		GFile* _tmp18_;
		GFile* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
#line 85 "../src/ePubReader.vala"
		_tmp18_ = g_file_new_for_path (eBookLocation);
#line 85 "../src/ePubReader.vala"
		_tmp19_ = _tmp18_;
#line 85 "../src/ePubReader.vala"
		_tmp20_ = g_file_get_basename (_tmp19_);
#line 85 "../src/ePubReader.vala"
		_tmp21_ = _tmp20_;
#line 85 "../src/ePubReader.vala"
		_tmp22_ = g_strconcat (BOOKWORM_APP_CONSTANTS_EBOOK_EXTRACTION_LOCATION, _tmp21_, NULL);
#line 85 "../src/ePubReader.vala"
		_g_free0 (extractionLocation);
#line 85 "../src/ePubReader.vala"
		extractionLocation = _tmp22_;
#line 85 "../src/ePubReader.vala"
		_g_free0 (_tmp21_);
#line 85 "../src/ePubReader.vala"
		_g_object_unref0 (_tmp19_);
#line 864 "ePubReader.c"
	}
#line 88 "../src/ePubReader.vala"
	_tmp23_ = extractionLocation;
#line 88 "../src/ePubReader.vala"
	_tmp24_ = bookworm_app_utils_fileOperations ("CREATEDIR", _tmp23_, "", "");
#line 88 "../src/ePubReader.vala"
	_tmp25_ = _tmp24_;
#line 88 "../src/ePubReader.vala"
	_g_free0 (_tmp25_);
#line 90 "../src/ePubReader.vala"
	_tmp26_ = g_strconcat ("unzip -o \"", eBookLocation, NULL);
#line 90 "../src/ePubReader.vala"
	_tmp27_ = _tmp26_;
#line 90 "../src/ePubReader.vala"
	_tmp28_ = g_strconcat (_tmp27_, "\" -d \"", NULL);
#line 90 "../src/ePubReader.vala"
	_tmp29_ = _tmp28_;
#line 90 "../src/ePubReader.vala"
	_tmp30_ = extractionLocation;
#line 90 "../src/ePubReader.vala"
	_tmp31_ = g_strconcat (_tmp29_, _tmp30_, NULL);
#line 90 "../src/ePubReader.vala"
	_tmp32_ = _tmp31_;
#line 90 "../src/ePubReader.vala"
	_tmp33_ = g_strconcat (_tmp32_, "\"", NULL);
#line 90 "../src/ePubReader.vala"
	_tmp34_ = _tmp33_;
#line 90 "../src/ePubReader.vala"
	_tmp35_ = bookworm_app_utils_execute_sync_command (_tmp34_);
#line 90 "../src/ePubReader.vala"
	_tmp36_ = _tmp35_;
#line 90 "../src/ePubReader.vala"
	_g_free0 (_tmp34_);
#line 90 "../src/ePubReader.vala"
	_g_free0 (_tmp32_);
#line 90 "../src/ePubReader.vala"
	_g_free0 (_tmp29_);
#line 90 "../src/ePubReader.vala"
	_g_free0 (_tmp27_);
#line 90 "../src/ePubReader.vala"
	status = _tmp36_;
#line 91 "../src/ePubReader.vala"
	_tmp37_ = status;
#line 91 "../src/ePubReader.vala"
	if (g_strcmp0 ("false", _tmp37_) == 0) {
#line 910 "ePubReader.c"
		gchar* _tmp38_;
#line 92 "../src/ePubReader.vala"
		_tmp38_ = g_strdup ("false");
#line 92 "../src/ePubReader.vala"
		_g_free0 (extractionLocation);
#line 92 "../src/ePubReader.vala"
		extractionLocation = _tmp38_;
#line 918 "ePubReader.c"
	}
#line 94 "../src/ePubReader.vala"
	_tmp39_ = extractionLocation;
#line 94 "../src/ePubReader.vala"
	_tmp40_ = g_strconcat ("[END] [FUNCTION:extractEBook] extractionLocation=", _tmp39_, NULL);
#line 94 "../src/ePubReader.vala"
	_tmp41_ = _tmp40_;
#line 94 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:94: %s", _tmp41_);
#line 94 "../src/ePubReader.vala"
	_g_free0 (_tmp41_);
#line 95 "../src/ePubReader.vala"
	result = extractionLocation;
#line 95 "../src/ePubReader.vala"
	_g_free0 (status);
#line 95 "../src/ePubReader.vala"
	return result;
#line 936 "ePubReader.c"
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
#line 1413 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1414 "glib-2.0.vapi"
	_tmp0_ = g_strdup (self);
#line 1414 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1415 "glib-2.0.vapi"
	g_strstrip (_result_);
#line 1416 "glib-2.0.vapi"
	result = _result_;
#line 1416 "glib-2.0.vapi"
	return result;
#line 957 "ePubReader.c"
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
#line 37 "glib-2.0.vapi"
	if (self) {
#line 966 "ePubReader.c"
		gchar* _tmp0_;
#line 38 "glib-2.0.vapi"
		_tmp0_ = g_strdup ("true");
#line 38 "glib-2.0.vapi"
		result = _tmp0_;
#line 38 "glib-2.0.vapi"
		return result;
#line 974 "ePubReader.c"
	} else {
		gchar* _tmp1_;
#line 40 "glib-2.0.vapi"
		_tmp1_ = g_strdup ("false");
#line 40 "glib-2.0.vapi"
		result = _tmp1_;
#line 40 "glib-2.0.vapi"
		return result;
#line 983 "ePubReader.c"
	}
}

gboolean
bookworm_app_epub_reader_isEPubFormat (const gchar* extractionLocation)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean ePubFormat = FALSE;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* ePubMimeContents = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	const gchar* _tmp20_;
	gchar* _tmp21_;
	gchar* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	gboolean _tmp26_;
	gchar* _tmp39_;
	gchar* _tmp40_;
	gchar* _tmp41_;
	gchar* _tmp42_;
	gboolean result;
#line 98 "../src/ePubReader.vala"
	g_return_val_if_fail (extractionLocation != NULL, FALSE);
#line 99 "../src/ePubReader.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:isEPubFormat] extractionLocation=", extractionLocation, NULL);
#line 99 "../src/ePubReader.vala"
	_tmp1_ = _tmp0_;
#line 99 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:99: %s", _tmp1_);
#line 99 "../src/ePubReader.vala"
	_g_free0 (_tmp1_);
#line 100 "../src/ePubReader.vala"
	ePubFormat = FALSE;
#line 101 "../src/ePubReader.vala"
	_tmp2_ = g_strconcat ("Checking if mime type is valid ePub for contents at:", extractionLocation, NULL);
#line 101 "../src/ePubReader.vala"
	_tmp3_ = _tmp2_;
#line 101 "../src/ePubReader.vala"
	g_debug ("ePubReader.vala:101: %s", _tmp3_);
#line 101 "../src/ePubReader.vala"
	_g_free0 (_tmp3_);
#line 102 "../src/ePubReader.vala"
	_tmp4_ = bookworm_app_utils_fileOperations ("READ", extractionLocation, BOOKWORM_APP_CONSTANTS_EPUB_MIME_SPECIFICATION_FILENAME, "");
#line 102 "../src/ePubReader.vala"
	ePubMimeContents = _tmp4_;
#line 107 "../src/ePubReader.vala"
	_tmp5_ = ePubMimeContents;
#line 107 "../src/ePubReader.vala"
	if (g_strcmp0 ("false", _tmp5_) == 0) {
#line 1046 "ePubReader.c"
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
#line 109 "../src/ePubReader.vala"
		_tmp6_ = g_strconcat ("Mime Content file could not be located at expected location:", extractionLocation, NULL);
#line 109 "../src/ePubReader.vala"
		_tmp7_ = _tmp6_;
#line 109 "../src/ePubReader.vala"
		_tmp8_ = g_strconcat (_tmp7_, "/", NULL);
#line 109 "../src/ePubReader.vala"
		_tmp9_ = _tmp8_;
#line 109 "../src/ePubReader.vala"
		_tmp10_ = g_strconcat (_tmp9_, BOOKWORM_APP_CONSTANTS_EPUB_MIME_SPECIFICATION_FILENAME, NULL);
#line 109 "../src/ePubReader.vala"
		_tmp11_ = _tmp10_;
#line 109 "../src/ePubReader.vala"
		g_warning ("ePubReader.vala:109: %s", _tmp11_);
#line 109 "../src/ePubReader.vala"
		_g_free0 (_tmp11_);
#line 109 "../src/ePubReader.vala"
		_g_free0 (_tmp9_);
#line 109 "../src/ePubReader.vala"
		_g_free0 (_tmp7_);
#line 112 "../src/ePubReader.vala"
		result = FALSE;
#line 112 "../src/ePubReader.vala"
		_g_free0 (ePubMimeContents);
#line 112 "../src/ePubReader.vala"
		return result;
#line 1079 "ePubReader.c"
	}
#line 114 "../src/ePubReader.vala"
	_tmp12_ = g_strconcat ("Mime Contents found in file :", extractionLocation, NULL);
#line 114 "../src/ePubReader.vala"
	_tmp13_ = _tmp12_;
#line 114 "../src/ePubReader.vala"
	_tmp14_ = g_strconcat (_tmp13_, "/", NULL);
#line 114 "../src/ePubReader.vala"
	_tmp15_ = _tmp14_;
#line 114 "../src/ePubReader.vala"
	_tmp16_ = g_strconcat (_tmp15_, BOOKWORM_APP_CONSTANTS_EPUB_MIME_SPECIFICATION_FILENAME, NULL);
#line 114 "../src/ePubReader.vala"
	_tmp17_ = _tmp16_;
#line 114 "../src/ePubReader.vala"
	_tmp18_ = g_strconcat (_tmp17_, " is:", NULL);
#line 114 "../src/ePubReader.vala"
	_tmp19_ = _tmp18_;
#line 114 "../src/ePubReader.vala"
	_tmp20_ = ePubMimeContents;
#line 114 "../src/ePubReader.vala"
	_tmp21_ = g_strconcat (_tmp19_, _tmp20_, NULL);
#line 114 "../src/ePubReader.vala"
	_tmp22_ = _tmp21_;
#line 114 "../src/ePubReader.vala"
	g_debug ("ePubReader.vala:114: %s", _tmp22_);
#line 114 "../src/ePubReader.vala"
	_g_free0 (_tmp22_);
#line 114 "../src/ePubReader.vala"
	_g_free0 (_tmp19_);
#line 114 "../src/ePubReader.vala"
	_g_free0 (_tmp17_);
#line 114 "../src/ePubReader.vala"
	_g_free0 (_tmp15_);
#line 114 "../src/ePubReader.vala"
	_g_free0 (_tmp13_);
#line 118 "../src/ePubReader.vala"
	_tmp23_ = ePubMimeContents;
#line 118 "../src/ePubReader.vala"
	_tmp24_ = string_strip (_tmp23_);
#line 118 "../src/ePubReader.vala"
	_tmp25_ = _tmp24_;
#line 118 "../src/ePubReader.vala"
	_tmp26_ = g_strcmp0 (_tmp25_, BOOKWORM_APP_CONSTANTS_EPUB_MIME_SPECIFICATION_CONTENT) != 0;
#line 118 "../src/ePubReader.vala"
	_g_free0 (_tmp25_);
#line 118 "../src/ePubReader.vala"
	if (_tmp26_) {
#line 1127 "ePubReader.c"
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		gchar* _tmp31_;
		gchar* _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		gchar* _tmp35_;
		gchar* _tmp36_;
		gchar* _tmp37_;
		gchar* _tmp38_;
#line 119 "../src/ePubReader.vala"
		_tmp27_ = g_strconcat ("Mime Contents in file :", extractionLocation, NULL);
#line 119 "../src/ePubReader.vala"
		_tmp28_ = _tmp27_;
#line 119 "../src/ePubReader.vala"
		_tmp29_ = g_strconcat (_tmp28_, "/", NULL);
#line 119 "../src/ePubReader.vala"
		_tmp30_ = _tmp29_;
#line 119 "../src/ePubReader.vala"
		_tmp31_ = g_strconcat (_tmp30_, BOOKWORM_APP_CONSTANTS_EPUB_MIME_SPECIFICATION_FILENAME, NULL);
#line 119 "../src/ePubReader.vala"
		_tmp32_ = _tmp31_;
#line 119 "../src/ePubReader.vala"
		_tmp33_ = g_strconcat (_tmp32_, " is not :", NULL);
#line 119 "../src/ePubReader.vala"
		_tmp34_ = _tmp33_;
#line 119 "../src/ePubReader.vala"
		_tmp35_ = g_strconcat (_tmp34_, BOOKWORM_APP_CONSTANTS_EPUB_MIME_SPECIFICATION_CONTENT, NULL);
#line 119 "../src/ePubReader.vala"
		_tmp36_ = _tmp35_;
#line 119 "../src/ePubReader.vala"
		_tmp37_ = g_strconcat (_tmp36_, ". No further parsing will be done.", NULL);
#line 119 "../src/ePubReader.vala"
		_tmp38_ = _tmp37_;
#line 119 "../src/ePubReader.vala"
		g_debug ("ePubReader.vala:119: %s", _tmp38_);
#line 119 "../src/ePubReader.vala"
		_g_free0 (_tmp38_);
#line 119 "../src/ePubReader.vala"
		_g_free0 (_tmp36_);
#line 119 "../src/ePubReader.vala"
		_g_free0 (_tmp34_);
#line 119 "../src/ePubReader.vala"
		_g_free0 (_tmp32_);
#line 119 "../src/ePubReader.vala"
		_g_free0 (_tmp30_);
#line 119 "../src/ePubReader.vala"
		_g_free0 (_tmp28_);
#line 122 "../src/ePubReader.vala"
		result = FALSE;
#line 122 "../src/ePubReader.vala"
		_g_free0 (ePubMimeContents);
#line 122 "../src/ePubReader.vala"
		return result;
#line 1184 "ePubReader.c"
	} else {
#line 125 "../src/ePubReader.vala"
		ePubFormat = TRUE;
#line 1188 "ePubReader.c"
	}
#line 127 "../src/ePubReader.vala"
	_tmp39_ = bool_to_string (ePubFormat);
#line 127 "../src/ePubReader.vala"
	_tmp40_ = _tmp39_;
#line 127 "../src/ePubReader.vala"
	_tmp41_ = g_strconcat ("[END] [FUNCTION:isEPubFormat] ePubFormat=", _tmp40_, NULL);
#line 127 "../src/ePubReader.vala"
	_tmp42_ = _tmp41_;
#line 127 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:127: %s", _tmp42_);
#line 127 "../src/ePubReader.vala"
	_g_free0 (_tmp42_);
#line 127 "../src/ePubReader.vala"
	_g_free0 (_tmp40_);
#line 128 "../src/ePubReader.vala"
	result = ePubFormat;
#line 128 "../src/ePubReader.vala"
	_g_free0 (ePubMimeContents);
#line 128 "../src/ePubReader.vala"
	return result;
#line 1210 "ePubReader.c"
}

static gpointer
_g_object_ref0 (gpointer self)
{
#line 145 "../src/ePubReader.vala"
	return self ? g_object_ref (self) : NULL;
#line 1218 "ePubReader.c"
}

gchar*
bookworm_app_epub_reader_getOPFFileLocation (const gchar* extractionLocation)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* locationOfOPFFile = NULL;
	gchar* _tmp2_;
	gchar* pathToXMLFile = NULL;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GeeArrayList* inputDataList = NULL;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	BookwormAppXMLData* _tmp12_ = NULL;
	BookwormAppXMLData* _tmp13_;
	BookwormAppXmlParser* thisParser = NULL;
	BookwormAppXmlParser* _tmp14_;
	GeeArrayList* extractedDataList = NULL;
	GeeArrayList* _tmp15_;
	BookwormAppXmlParser* _tmp16_;
	const gchar* _tmp17_;
	GeeArrayList* _tmp18_;
	GeeArrayList* _tmp19_;
	GeeArrayList* _tmp20_;
	const gchar* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* result;
#line 131 "../src/ePubReader.vala"
	g_return_val_if_fail (extractionLocation != NULL, NULL);
#line 132 "../src/ePubReader.vala"
	_tmp0_ = g_strconcat ("[START] [FUNCTION:getOPFFileLocation] extractionLocation=", extractionLocation, NULL);
#line 132 "../src/ePubReader.vala"
	_tmp1_ = _tmp0_;
#line 132 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:132: %s", _tmp1_);
#line 132 "../src/ePubReader.vala"
	_g_free0 (_tmp1_);
#line 133 "../src/ePubReader.vala"
	_tmp2_ = g_strdup ("false");
#line 133 "../src/ePubReader.vala"
	locationOfOPFFile = _tmp2_;
#line 135 "../src/ePubReader.vala"
	_tmp3_ = g_strconcat (extractionLocation, "/", NULL);
#line 135 "../src/ePubReader.vala"
	_tmp4_ = _tmp3_;
#line 135 "../src/ePubReader.vala"
	_tmp5_ = g_strconcat (_tmp4_, BOOKWORM_APP_CONSTANTS_EPUB_META_INF_FILENAME, NULL);
#line 135 "../src/ePubReader.vala"
	_tmp6_ = _tmp5_;
#line 135 "../src/ePubReader.vala"
	_g_free0 (_tmp4_);
#line 135 "../src/ePubReader.vala"
	pathToXMLFile = _tmp6_;
#line 137 "../src/ePubReader.vala"
	_tmp7_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 137 "../src/ePubReader.vala"
	inputDataList = _tmp7_;
#line 138 "../src/ePubReader.vala"
	_tmp8_ = inputDataList;
#line 138 "../src/ePubReader.vala"
	_tmp9_ = g_strdup ("rootfiles");
#line 138 "../src/ePubReader.vala"
	_tmp10_ = g_strdup ("rootfile");
#line 138 "../src/ePubReader.vala"
	_tmp11_ = g_strdup ("full-path");
#line 138 "../src/ePubReader.vala"
	_tmp12_ = bookworm_app_xml_data_new ();
#line 138 "../src/ePubReader.vala"
	_g_free0 (_tmp12_->containerTagName);
#line 138 "../src/ePubReader.vala"
	_tmp12_->containerTagName = _tmp9_;
#line 138 "../src/ePubReader.vala"
	_g_free0 (_tmp12_->inputTagName);
#line 138 "../src/ePubReader.vala"
	_tmp12_->inputTagName = _tmp10_;
#line 138 "../src/ePubReader.vala"
	_g_free0 (_tmp12_->inputAttributeName);
#line 138 "../src/ePubReader.vala"
	_tmp12_->inputAttributeName = _tmp11_;
#line 138 "../src/ePubReader.vala"
	_tmp13_ = _tmp12_;
#line 138 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp13_);
#line 138 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp13_);
#line 143 "../src/ePubReader.vala"
	_tmp14_ = bookworm_app_xml_parser_new ();
#line 143 "../src/ePubReader.vala"
	thisParser = _tmp14_;
#line 144 "../src/ePubReader.vala"
	_tmp15_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 144 "../src/ePubReader.vala"
	extractedDataList = _tmp15_;
#line 145 "../src/ePubReader.vala"
	_tmp16_ = thisParser;
#line 145 "../src/ePubReader.vala"
	_tmp17_ = pathToXMLFile;
#line 145 "../src/ePubReader.vala"
	_tmp18_ = inputDataList;
#line 145 "../src/ePubReader.vala"
	_tmp19_ = _g_object_ref0 (_tmp18_);
#line 145 "../src/ePubReader.vala"
	_tmp20_ = bookworm_app_xml_parser_extractDataFromXML (_tmp16_, _tmp17_, _tmp19_, FALSE);
#line 145 "../src/ePubReader.vala"
	_g_object_unref0 (extractedDataList);
#line 145 "../src/ePubReader.vala"
	extractedDataList = _tmp20_;
#line 1334 "ePubReader.c"
	{
		GeeArrayList* _aExtractedData_list = NULL;
		GeeArrayList* _tmp21_;
		gint _aExtractedData_size = 0;
		GeeArrayList* _tmp22_;
		gint _tmp23_;
		gint _tmp24_;
		gint _aExtractedData_index = 0;
#line 147 "../src/ePubReader.vala"
		_tmp21_ = extractedDataList;
#line 147 "../src/ePubReader.vala"
		_aExtractedData_list = _tmp21_;
#line 147 "../src/ePubReader.vala"
		_tmp22_ = _aExtractedData_list;
#line 147 "../src/ePubReader.vala"
		_tmp23_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp22_);
#line 147 "../src/ePubReader.vala"
		_tmp24_ = _tmp23_;
#line 147 "../src/ePubReader.vala"
		_aExtractedData_size = _tmp24_;
#line 147 "../src/ePubReader.vala"
		_aExtractedData_index = -1;
#line 147 "../src/ePubReader.vala"
		while (TRUE) {
#line 1359 "ePubReader.c"
			gint _tmp25_;
			gint _tmp26_;
			BookwormAppXMLData* aExtractedData = NULL;
			GeeArrayList* _tmp27_;
			gpointer _tmp28_;
#line 147 "../src/ePubReader.vala"
			_aExtractedData_index = _aExtractedData_index + 1;
#line 147 "../src/ePubReader.vala"
			_tmp25_ = _aExtractedData_index;
#line 147 "../src/ePubReader.vala"
			_tmp26_ = _aExtractedData_size;
#line 147 "../src/ePubReader.vala"
			if (!(_tmp25_ < _tmp26_)) {
#line 147 "../src/ePubReader.vala"
				break;
#line 1375 "ePubReader.c"
			}
#line 147 "../src/ePubReader.vala"
			_tmp27_ = _aExtractedData_list;
#line 147 "../src/ePubReader.vala"
			_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, _aExtractedData_index);
#line 147 "../src/ePubReader.vala"
			aExtractedData = (BookwormAppXMLData*) _tmp28_;
#line 1383 "ePubReader.c"
			{
				GeeArrayList* _aAttributeValue_list = NULL;
				BookwormAppXMLData* _tmp29_;
				GeeArrayList* _tmp30_;
				gint _aAttributeValue_size = 0;
				GeeArrayList* _tmp31_;
				gint _tmp32_;
				gint _tmp33_;
				gint _aAttributeValue_index = 0;
#line 148 "../src/ePubReader.vala"
				_tmp29_ = aExtractedData;
#line 148 "../src/ePubReader.vala"
				_tmp30_ = _tmp29_->extractedTagAttributes;
#line 148 "../src/ePubReader.vala"
				_aAttributeValue_list = _tmp30_;
#line 148 "../src/ePubReader.vala"
				_tmp31_ = _aAttributeValue_list;
#line 148 "../src/ePubReader.vala"
				_tmp32_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp31_);
#line 148 "../src/ePubReader.vala"
				_tmp33_ = _tmp32_;
#line 148 "../src/ePubReader.vala"
				_aAttributeValue_size = _tmp33_;
#line 148 "../src/ePubReader.vala"
				_aAttributeValue_index = -1;
#line 148 "../src/ePubReader.vala"
				while (TRUE) {
#line 1411 "ePubReader.c"
					gint _tmp34_;
					gint _tmp35_;
					gchar* aAttributeValue = NULL;
					GeeArrayList* _tmp36_;
					gpointer _tmp37_;
					gchar* OPFFilePath = NULL;
					const gchar* _tmp38_;
					gchar* _tmp39_;
					gchar* _tmp40_;
					gchar* _tmp41_;
					const gchar* _tmp42_;
					gchar* _tmp43_;
#line 148 "../src/ePubReader.vala"
					_aAttributeValue_index = _aAttributeValue_index + 1;
#line 148 "../src/ePubReader.vala"
					_tmp34_ = _aAttributeValue_index;
#line 148 "../src/ePubReader.vala"
					_tmp35_ = _aAttributeValue_size;
#line 148 "../src/ePubReader.vala"
					if (!(_tmp34_ < _tmp35_)) {
#line 148 "../src/ePubReader.vala"
						break;
#line 1434 "ePubReader.c"
					}
#line 148 "../src/ePubReader.vala"
					_tmp36_ = _aAttributeValue_list;
#line 148 "../src/ePubReader.vala"
					_tmp37_ = gee_abstract_list_get ((GeeAbstractList*) _tmp36_, _aAttributeValue_index);
#line 148 "../src/ePubReader.vala"
					aAttributeValue = (gchar*) _tmp37_;
#line 149 "../src/ePubReader.vala"
					_tmp38_ = aAttributeValue;
#line 149 "../src/ePubReader.vala"
					_tmp39_ = g_strdup (_tmp38_);
#line 149 "../src/ePubReader.vala"
					OPFFilePath = _tmp39_;
#line 150 "../src/ePubReader.vala"
					_tmp40_ = g_strconcat (extractionLocation, "/", NULL);
#line 150 "../src/ePubReader.vala"
					_tmp41_ = _tmp40_;
#line 150 "../src/ePubReader.vala"
					_tmp42_ = OPFFilePath;
#line 150 "../src/ePubReader.vala"
					_tmp43_ = g_strconcat (_tmp41_, _tmp42_, NULL);
#line 150 "../src/ePubReader.vala"
					_g_free0 (locationOfOPFFile);
#line 150 "../src/ePubReader.vala"
					locationOfOPFFile = _tmp43_;
#line 150 "../src/ePubReader.vala"
					_g_free0 (_tmp41_);
#line 148 "../src/ePubReader.vala"
					_g_free0 (OPFFilePath);
#line 148 "../src/ePubReader.vala"
					_g_free0 (aAttributeValue);
#line 1466 "ePubReader.c"
				}
			}
#line 147 "../src/ePubReader.vala"
			_bookworm_app_xml_data_unref0 (aExtractedData);
#line 1471 "ePubReader.c"
		}
	}
#line 153 "../src/ePubReader.vala"
	_tmp44_ = locationOfOPFFile;
#line 153 "../src/ePubReader.vala"
	_tmp45_ = g_strconcat ("[END] [FUNCTION:getOPFFileLocation] locationOfOPFFile=", _tmp44_, NULL);
#line 153 "../src/ePubReader.vala"
	_tmp46_ = _tmp45_;
#line 153 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:153: %s", _tmp46_);
#line 153 "../src/ePubReader.vala"
	_g_free0 (_tmp46_);
#line 154 "../src/ePubReader.vala"
	result = locationOfOPFFile;
#line 154 "../src/ePubReader.vala"
	_g_object_unref0 (extractedDataList);
#line 154 "../src/ePubReader.vala"
	_bookworm_app_xml_parser_unref0 (thisParser);
#line 154 "../src/ePubReader.vala"
	_g_object_unref0 (inputDataList);
#line 154 "../src/ePubReader.vala"
	_g_free0 (pathToXMLFile);
#line 154 "../src/ePubReader.vala"
	return result;
#line 1496 "ePubReader.c"
}

static gint
string_index_of (const gchar* self,
                 const gchar* needle,
                 gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1184 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1185 "glib-2.0.vapi"
	_tmp0_ = strstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1185 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1187 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1187 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 1520 "ePubReader.c"
		gchar* _tmp2_;
#line 1188 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1188 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1188 "glib-2.0.vapi"
		return result;
#line 1528 "ePubReader.c"
	} else {
#line 1190 "glib-2.0.vapi"
		result = -1;
#line 1190 "glib-2.0.vapi"
		return result;
#line 1534 "ePubReader.c"
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
#line 1534 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, NULL);
#line 1535 "glib-2.0.vapi"
	_tmp0_ = strlen (self);
#line 1535 "glib-2.0.vapi"
	_tmp1_ = _tmp0_;
#line 1535 "glib-2.0.vapi"
	string_length = (glong) _tmp1_;
#line 1536 "glib-2.0.vapi"
	if (start < ((glong) 0)) {
#line 1537 "glib-2.0.vapi"
		start = string_length + start;
#line 1562 "ePubReader.c"
	}
#line 1539 "glib-2.0.vapi"
	if (end < ((glong) 0)) {
#line 1540 "glib-2.0.vapi"
		end = string_length + end;
#line 1568 "ePubReader.c"
	}
#line 1542 "glib-2.0.vapi"
	if (start >= ((glong) 0)) {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = start <= string_length;
#line 1574 "ePubReader.c"
	} else {
#line 1542 "glib-2.0.vapi"
		_tmp2_ = FALSE;
#line 1578 "ePubReader.c"
	}
#line 1542 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp2_, NULL);
#line 1543 "glib-2.0.vapi"
	if (end >= ((glong) 0)) {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = end <= string_length;
#line 1586 "ePubReader.c"
	} else {
#line 1543 "glib-2.0.vapi"
		_tmp3_ = FALSE;
#line 1590 "ePubReader.c"
	}
#line 1543 "glib-2.0.vapi"
	g_return_val_if_fail (_tmp3_, NULL);
#line 1544 "glib-2.0.vapi"
	g_return_val_if_fail (start <= end, NULL);
#line 1545 "glib-2.0.vapi"
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
#line 1545 "glib-2.0.vapi"
	result = _tmp4_;
#line 1545 "glib-2.0.vapi"
	return result;
#line 1602 "ePubReader.c"
}

BookwormAppBook*
bookworm_app_epub_reader_determineToC (BookwormAppBook* aBook,
                                       const gchar* locationOfOPFFile)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeArrayList* inputDataList = NULL;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	BookwormAppXMLData* _tmp13_ = NULL;
	BookwormAppXMLData* _tmp14_;
	GeeArrayList* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	BookwormAppXMLData* _tmp19_ = NULL;
	BookwormAppXMLData* _tmp20_;
	GeeArrayList* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	BookwormAppXMLData* _tmp25_ = NULL;
	BookwormAppXMLData* _tmp26_;
	GeeArrayList* _tmp27_;
	gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	BookwormAppXMLData* _tmp31_ = NULL;
	BookwormAppXMLData* _tmp32_;
	GeeArrayList* _tmp33_;
	gchar* _tmp34_;
	gchar* _tmp35_;
	gchar* _tmp36_;
	BookwormAppXMLData* _tmp37_ = NULL;
	BookwormAppXMLData* _tmp38_;
	BookwormAppXmlParser* thisParser = NULL;
	BookwormAppXmlParser* _tmp39_;
	GeeArrayList* opfItemsList = NULL;
	GeeArrayList* _tmp40_;
	BookwormAppXmlParser* _tmp41_;
	GeeArrayList* _tmp42_;
	GeeArrayList* _tmp43_;
	GeeArrayList* _tmp44_;
	gboolean _tmp45_ = FALSE;
	GeeArrayList* _tmp46_;
	gint _tmp47_;
	gint _tmp48_;
	BookwormAppBook* _tmp256_;
	BookwormAppBook* result;
#line 157 "../src/ePubReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 157 "../src/ePubReader.vala"
	g_return_val_if_fail (locationOfOPFFile != NULL, NULL);
#line 158 "../src/ePubReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 158 "../src/ePubReader.vala"
	_tmp1_ = _tmp0_;
#line 158 "../src/ePubReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:determineToC] book.location=", _tmp1_, NULL);
#line 158 "../src/ePubReader.vala"
	_tmp3_ = _tmp2_;
#line 158 "../src/ePubReader.vala"
	_tmp4_ = g_strconcat (_tmp3_, ", locationOfOPFFile=", NULL);
#line 158 "../src/ePubReader.vala"
	_tmp5_ = _tmp4_;
#line 158 "../src/ePubReader.vala"
	_tmp6_ = g_strconcat (_tmp5_, locationOfOPFFile, NULL);
#line 158 "../src/ePubReader.vala"
	_tmp7_ = _tmp6_;
#line 158 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:158: %s", _tmp7_);
#line 158 "../src/ePubReader.vala"
	_g_free0 (_tmp7_);
#line 158 "../src/ePubReader.vala"
	_g_free0 (_tmp5_);
#line 158 "../src/ePubReader.vala"
	_g_free0 (_tmp3_);
#line 158 "../src/ePubReader.vala"
	_g_free0 (_tmp1_);
#line 160 "../src/ePubReader.vala"
	_tmp8_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 160 "../src/ePubReader.vala"
	inputDataList = _tmp8_;
#line 161 "../src/ePubReader.vala"
	_tmp9_ = inputDataList;
#line 161 "../src/ePubReader.vala"
	_tmp10_ = g_strdup ("manifest");
#line 161 "../src/ePubReader.vala"
	_tmp11_ = g_strdup ("item");
#line 161 "../src/ePubReader.vala"
	_tmp12_ = g_strdup ("id");
#line 161 "../src/ePubReader.vala"
	_tmp13_ = bookworm_app_xml_data_new ();
#line 161 "../src/ePubReader.vala"
	_g_free0 (_tmp13_->containerTagName);
#line 161 "../src/ePubReader.vala"
	_tmp13_->containerTagName = _tmp10_;
#line 161 "../src/ePubReader.vala"
	_g_free0 (_tmp13_->inputTagName);
#line 161 "../src/ePubReader.vala"
	_tmp13_->inputTagName = _tmp11_;
#line 161 "../src/ePubReader.vala"
	_g_free0 (_tmp13_->inputAttributeName);
#line 161 "../src/ePubReader.vala"
	_tmp13_->inputAttributeName = _tmp12_;
#line 161 "../src/ePubReader.vala"
	_tmp14_ = _tmp13_;
#line 161 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp14_);
#line 161 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp14_);
#line 166 "../src/ePubReader.vala"
	_tmp15_ = inputDataList;
#line 166 "../src/ePubReader.vala"
	_tmp16_ = g_strdup ("manifest");
#line 166 "../src/ePubReader.vala"
	_tmp17_ = g_strdup ("item");
#line 166 "../src/ePubReader.vala"
	_tmp18_ = g_strdup ("href");
#line 166 "../src/ePubReader.vala"
	_tmp19_ = bookworm_app_xml_data_new ();
#line 166 "../src/ePubReader.vala"
	_g_free0 (_tmp19_->containerTagName);
#line 166 "../src/ePubReader.vala"
	_tmp19_->containerTagName = _tmp16_;
#line 166 "../src/ePubReader.vala"
	_g_free0 (_tmp19_->inputTagName);
#line 166 "../src/ePubReader.vala"
	_tmp19_->inputTagName = _tmp17_;
#line 166 "../src/ePubReader.vala"
	_g_free0 (_tmp19_->inputAttributeName);
#line 166 "../src/ePubReader.vala"
	_tmp19_->inputAttributeName = _tmp18_;
#line 166 "../src/ePubReader.vala"
	_tmp20_ = _tmp19_;
#line 166 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp20_);
#line 166 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp20_);
#line 171 "../src/ePubReader.vala"
	_tmp21_ = inputDataList;
#line 171 "../src/ePubReader.vala"
	_tmp22_ = g_strdup ("manifest");
#line 171 "../src/ePubReader.vala"
	_tmp23_ = g_strdup ("item");
#line 171 "../src/ePubReader.vala"
	_tmp24_ = g_strdup ("media-type");
#line 171 "../src/ePubReader.vala"
	_tmp25_ = bookworm_app_xml_data_new ();
#line 171 "../src/ePubReader.vala"
	_g_free0 (_tmp25_->containerTagName);
#line 171 "../src/ePubReader.vala"
	_tmp25_->containerTagName = _tmp22_;
#line 171 "../src/ePubReader.vala"
	_g_free0 (_tmp25_->inputTagName);
#line 171 "../src/ePubReader.vala"
	_tmp25_->inputTagName = _tmp23_;
#line 171 "../src/ePubReader.vala"
	_g_free0 (_tmp25_->inputAttributeName);
#line 171 "../src/ePubReader.vala"
	_tmp25_->inputAttributeName = _tmp24_;
#line 171 "../src/ePubReader.vala"
	_tmp26_ = _tmp25_;
#line 171 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp21_, _tmp26_);
#line 171 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp26_);
#line 176 "../src/ePubReader.vala"
	_tmp27_ = inputDataList;
#line 176 "../src/ePubReader.vala"
	_tmp28_ = g_strdup ("spine");
#line 176 "../src/ePubReader.vala"
	_tmp29_ = g_strdup ("itemref");
#line 176 "../src/ePubReader.vala"
	_tmp30_ = g_strdup ("idref");
#line 176 "../src/ePubReader.vala"
	_tmp31_ = bookworm_app_xml_data_new ();
#line 176 "../src/ePubReader.vala"
	_g_free0 (_tmp31_->containerTagName);
#line 176 "../src/ePubReader.vala"
	_tmp31_->containerTagName = _tmp28_;
#line 176 "../src/ePubReader.vala"
	_g_free0 (_tmp31_->inputTagName);
#line 176 "../src/ePubReader.vala"
	_tmp31_->inputTagName = _tmp29_;
#line 176 "../src/ePubReader.vala"
	_g_free0 (_tmp31_->inputAttributeName);
#line 176 "../src/ePubReader.vala"
	_tmp31_->inputAttributeName = _tmp30_;
#line 176 "../src/ePubReader.vala"
	_tmp32_ = _tmp31_;
#line 176 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp27_, _tmp32_);
#line 176 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp32_);
#line 181 "../src/ePubReader.vala"
	_tmp33_ = inputDataList;
#line 181 "../src/ePubReader.vala"
	_tmp34_ = g_strdup ("");
#line 181 "../src/ePubReader.vala"
	_tmp35_ = g_strdup ("spine");
#line 181 "../src/ePubReader.vala"
	_tmp36_ = g_strdup ("toc");
#line 181 "../src/ePubReader.vala"
	_tmp37_ = bookworm_app_xml_data_new ();
#line 181 "../src/ePubReader.vala"
	_g_free0 (_tmp37_->containerTagName);
#line 181 "../src/ePubReader.vala"
	_tmp37_->containerTagName = _tmp34_;
#line 181 "../src/ePubReader.vala"
	_g_free0 (_tmp37_->inputTagName);
#line 181 "../src/ePubReader.vala"
	_tmp37_->inputTagName = _tmp35_;
#line 181 "../src/ePubReader.vala"
	_g_free0 (_tmp37_->inputAttributeName);
#line 181 "../src/ePubReader.vala"
	_tmp37_->inputAttributeName = _tmp36_;
#line 181 "../src/ePubReader.vala"
	_tmp38_ = _tmp37_;
#line 181 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp33_, _tmp38_);
#line 181 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp38_);
#line 186 "../src/ePubReader.vala"
	_tmp39_ = bookworm_app_xml_parser_new ();
#line 186 "../src/ePubReader.vala"
	thisParser = _tmp39_;
#line 187 "../src/ePubReader.vala"
	_tmp40_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 187 "../src/ePubReader.vala"
	opfItemsList = _tmp40_;
#line 188 "../src/ePubReader.vala"
	_tmp41_ = thisParser;
#line 188 "../src/ePubReader.vala"
	_tmp42_ = inputDataList;
#line 188 "../src/ePubReader.vala"
	_tmp43_ = _g_object_ref0 (_tmp42_);
#line 188 "../src/ePubReader.vala"
	_tmp44_ = bookworm_app_xml_parser_extractDataFromXML (_tmp41_, locationOfOPFFile, _tmp43_, FALSE);
#line 188 "../src/ePubReader.vala"
	_g_object_unref0 (opfItemsList);
#line 188 "../src/ePubReader.vala"
	opfItemsList = _tmp44_;
#line 190 "../src/ePubReader.vala"
	_tmp46_ = opfItemsList;
#line 190 "../src/ePubReader.vala"
	_tmp47_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp46_);
#line 190 "../src/ePubReader.vala"
	_tmp48_ = _tmp47_;
#line 190 "../src/ePubReader.vala"
	if (_tmp48_ > 3) {
#line 1865 "ePubReader.c"
		GeeArrayList* _tmp49_;
		gpointer _tmp50_;
		BookwormAppXMLData* _tmp51_;
		GeeArrayList* _tmp52_;
		gint _tmp53_;
		gint _tmp54_;
#line 190 "../src/ePubReader.vala"
		_tmp49_ = opfItemsList;
#line 190 "../src/ePubReader.vala"
		_tmp50_ = gee_abstract_list_get ((GeeAbstractList*) _tmp49_, 4);
#line 190 "../src/ePubReader.vala"
		_tmp51_ = (BookwormAppXMLData*) _tmp50_;
#line 190 "../src/ePubReader.vala"
		_tmp52_ = _tmp51_->extractedTagAttributes;
#line 190 "../src/ePubReader.vala"
		_tmp53_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp52_);
#line 190 "../src/ePubReader.vala"
		_tmp54_ = _tmp53_;
#line 190 "../src/ePubReader.vala"
		_tmp45_ = _tmp54_ > 0;
#line 190 "../src/ePubReader.vala"
		_bookworm_app_xml_data_unref0 (_tmp51_);
#line 1888 "ePubReader.c"
	} else {
#line 190 "../src/ePubReader.vala"
		_tmp45_ = FALSE;
#line 1892 "ePubReader.c"
	}
#line 190 "../src/ePubReader.vala"
	if (_tmp45_) {
#line 1896 "ePubReader.c"
		gchar* spineNCXReference = NULL;
		GeeArrayList* _tmp55_;
		gpointer _tmp56_;
		BookwormAppXMLData* _tmp57_;
		GeeArrayList* _tmp58_;
		gpointer _tmp59_;
		gchar* _tmp60_;
		const gchar* _tmp61_;
		gchar* _tmp62_;
		gchar* _tmp63_;
		gboolean _tmp64_ = FALSE;
		GeeArrayList* _tmp65_;
		gint _tmp66_;
		gint _tmp67_;
#line 191 "../src/ePubReader.vala"
		g_debug ("ePubReader.vala:191: Successfully extracted SPINE data..");
#line 193 "../src/ePubReader.vala"
		_tmp55_ = opfItemsList;
#line 193 "../src/ePubReader.vala"
		_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, 4);
#line 193 "../src/ePubReader.vala"
		_tmp57_ = (BookwormAppXMLData*) _tmp56_;
#line 193 "../src/ePubReader.vala"
		_tmp58_ = _tmp57_->extractedTagAttributes;
#line 193 "../src/ePubReader.vala"
		_tmp59_ = gee_abstract_list_get ((GeeAbstractList*) _tmp58_, 0);
#line 193 "../src/ePubReader.vala"
		_tmp60_ = (gchar*) _tmp59_;
#line 193 "../src/ePubReader.vala"
		_bookworm_app_xml_data_unref0 (_tmp57_);
#line 193 "../src/ePubReader.vala"
		spineNCXReference = _tmp60_;
#line 194 "../src/ePubReader.vala"
		_tmp61_ = spineNCXReference;
#line 194 "../src/ePubReader.vala"
		_tmp62_ = g_strconcat ("Successfully determined NCX File Reference as:", _tmp61_, NULL);
#line 194 "../src/ePubReader.vala"
		_tmp63_ = _tmp62_;
#line 194 "../src/ePubReader.vala"
		g_debug ("ePubReader.vala:194: %s", _tmp63_);
#line 194 "../src/ePubReader.vala"
		_g_free0 (_tmp63_);
#line 196 "../src/ePubReader.vala"
		_tmp65_ = opfItemsList;
#line 196 "../src/ePubReader.vala"
		_tmp66_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp65_);
#line 196 "../src/ePubReader.vala"
		_tmp67_ = _tmp66_;
#line 196 "../src/ePubReader.vala"
		if (_tmp67_ > 0) {
#line 1947 "ePubReader.c"
			GeeArrayList* _tmp68_;
			gpointer _tmp69_;
			BookwormAppXMLData* _tmp70_;
			GeeArrayList* _tmp71_;
			const gchar* _tmp72_;
#line 196 "../src/ePubReader.vala"
			_tmp68_ = opfItemsList;
#line 196 "../src/ePubReader.vala"
			_tmp69_ = gee_abstract_list_get ((GeeAbstractList*) _tmp68_, 0);
#line 196 "../src/ePubReader.vala"
			_tmp70_ = (BookwormAppXMLData*) _tmp69_;
#line 196 "../src/ePubReader.vala"
			_tmp71_ = _tmp70_->extractedTagAttributes;
#line 196 "../src/ePubReader.vala"
			_tmp72_ = spineNCXReference;
#line 196 "../src/ePubReader.vala"
			_tmp64_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp71_, _tmp72_);
#line 196 "../src/ePubReader.vala"
			_bookworm_app_xml_data_unref0 (_tmp70_);
#line 1967 "ePubReader.c"
		} else {
#line 196 "../src/ePubReader.vala"
			_tmp64_ = FALSE;
#line 1971 "ePubReader.c"
		}
#line 196 "../src/ePubReader.vala"
		if (_tmp64_) {
#line 1975 "ePubReader.c"
			gint spineNCXPosition = 0;
			GeeArrayList* _tmp73_;
			gpointer _tmp74_;
			BookwormAppXMLData* _tmp75_;
			GeeArrayList* _tmp76_;
			const gchar* _tmp77_;
			gint _tmp78_;
			gchar* _tmp79_;
			gchar* _tmp80_;
			gchar* _tmp81_;
			gchar* _tmp82_;
			gchar* NCXFileRelativePath = NULL;
			GeeArrayList* _tmp83_;
			gpointer _tmp84_;
			BookwormAppXMLData* _tmp85_;
			GeeArrayList* _tmp86_;
			gpointer _tmp87_;
			gchar* _tmp88_;
			const gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
			gchar* ncxFilePath = NULL;
			gchar* _tmp92_;
			gchar* _tmp93_;
			const gchar* _tmp94_;
			gchar* _tmp95_;
			gchar* _tmp96_;
			gchar* _tmp97_;
			gchar* _tmp98_;
			gchar* _tmp99_;
			gchar* _tmp100_;
			const gchar* _tmp101_;
			gchar* _tmp102_;
			gchar* _tmp103_;
			gboolean _tmp104_;
#line 197 "../src/ePubReader.vala"
			g_debug ("ePubReader.vala:197: Successfully extracted MANIFEST data..");
#line 198 "../src/ePubReader.vala"
			_tmp73_ = opfItemsList;
#line 198 "../src/ePubReader.vala"
			_tmp74_ = gee_abstract_list_get ((GeeAbstractList*) _tmp73_, 0);
#line 198 "../src/ePubReader.vala"
			_tmp75_ = (BookwormAppXMLData*) _tmp74_;
#line 198 "../src/ePubReader.vala"
			_tmp76_ = _tmp75_->extractedTagAttributes;
#line 198 "../src/ePubReader.vala"
			_tmp77_ = spineNCXReference;
#line 198 "../src/ePubReader.vala"
			_tmp78_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp76_, _tmp77_);
#line 198 "../src/ePubReader.vala"
			_bookworm_app_xml_data_unref0 (_tmp75_);
#line 198 "../src/ePubReader.vala"
			spineNCXPosition = _tmp78_;
#line 199 "../src/ePubReader.vala"
			_tmp79_ = g_strdup_printf ("%i", spineNCXPosition);
#line 199 "../src/ePubReader.vala"
			_tmp80_ = _tmp79_;
#line 199 "../src/ePubReader.vala"
			_tmp81_ = g_strconcat ("Successfully matched NCX File path information on MANIFEST data at pos" \
"ition:", _tmp80_, NULL);
#line 199 "../src/ePubReader.vala"
			_tmp82_ = _tmp81_;
#line 199 "../src/ePubReader.vala"
			g_debug ("ePubReader.vala:199: %s", _tmp82_);
#line 199 "../src/ePubReader.vala"
			_g_free0 (_tmp82_);
#line 199 "../src/ePubReader.vala"
			_g_free0 (_tmp80_);
#line 201 "../src/ePubReader.vala"
			_tmp83_ = opfItemsList;
#line 201 "../src/ePubReader.vala"
			_tmp84_ = gee_abstract_list_get ((GeeAbstractList*) _tmp83_, 1);
#line 201 "../src/ePubReader.vala"
			_tmp85_ = (BookwormAppXMLData*) _tmp84_;
#line 201 "../src/ePubReader.vala"
			_tmp86_ = _tmp85_->extractedTagAttributes;
#line 201 "../src/ePubReader.vala"
			_tmp87_ = gee_abstract_list_get ((GeeAbstractList*) _tmp86_, spineNCXPosition);
#line 201 "../src/ePubReader.vala"
			_tmp88_ = (gchar*) _tmp87_;
#line 201 "../src/ePubReader.vala"
			_bookworm_app_xml_data_unref0 (_tmp85_);
#line 201 "../src/ePubReader.vala"
			NCXFileRelativePath = _tmp88_;
#line 202 "../src/ePubReader.vala"
			_tmp89_ = NCXFileRelativePath;
#line 202 "../src/ePubReader.vala"
			_tmp90_ = g_strconcat ("Extracted relative NCX file path from MANIFEST data as:", _tmp89_, NULL);
#line 202 "../src/ePubReader.vala"
			_tmp91_ = _tmp90_;
#line 202 "../src/ePubReader.vala"
			g_debug ("ePubReader.vala:202: %s", _tmp91_);
#line 202 "../src/ePubReader.vala"
			_g_free0 (_tmp91_);
#line 203 "../src/ePubReader.vala"
			_tmp92_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 203 "../src/ePubReader.vala"
			_tmp93_ = _tmp92_;
#line 203 "../src/ePubReader.vala"
			_tmp94_ = NCXFileRelativePath;
#line 203 "../src/ePubReader.vala"
			_tmp95_ = string_strip (_tmp94_);
#line 203 "../src/ePubReader.vala"
			_tmp96_ = _tmp95_;
#line 203 "../src/ePubReader.vala"
			_tmp97_ = bookworm_app_utils_getFullPathFromFilename (_tmp93_, _tmp96_);
#line 203 "../src/ePubReader.vala"
			_tmp98_ = _tmp97_;
#line 203 "../src/ePubReader.vala"
			_tmp99_ = string_strip (_tmp98_);
#line 203 "../src/ePubReader.vala"
			_tmp100_ = _tmp99_;
#line 203 "../src/ePubReader.vala"
			_g_free0 (_tmp98_);
#line 203 "../src/ePubReader.vala"
			_g_free0 (_tmp96_);
#line 203 "../src/ePubReader.vala"
			_g_free0 (_tmp93_);
#line 203 "../src/ePubReader.vala"
			ncxFilePath = _tmp100_;
#line 207 "../src/ePubReader.vala"
			_tmp101_ = ncxFilePath;
#line 207 "../src/ePubReader.vala"
			_tmp102_ = bookworm_app_utils_fileOperations ("EXISTS", "", _tmp101_, "");
#line 207 "../src/ePubReader.vala"
			_tmp103_ = _tmp102_;
#line 207 "../src/ePubReader.vala"
			_tmp104_ = g_strcmp0 ("true", _tmp103_) == 0;
#line 207 "../src/ePubReader.vala"
			_g_free0 (_tmp103_);
#line 207 "../src/ePubReader.vala"
			if (_tmp104_) {
#line 2107 "ePubReader.c"
				const gchar* _tmp105_;
				gchar* _tmp106_;
				gchar* _tmp107_;
				GeeArrayList* inputDataListForToC = NULL;
				GeeArrayList* _tmp108_;
				GeeArrayList* _tmp109_;
				gchar* _tmp110_;
				gchar* _tmp111_;
				gchar* _tmp112_;
				BookwormAppXMLData* _tmp113_ = NULL;
				BookwormAppXMLData* _tmp114_;
				GeeArrayList* _tmp115_;
				gchar* _tmp116_;
				gchar* _tmp117_;
				gchar* _tmp118_;
				BookwormAppXMLData* _tmp119_ = NULL;
				BookwormAppXMLData* _tmp120_;
				BookwormAppXmlParser* ncxParser = NULL;
				BookwormAppXmlParser* _tmp121_;
				GeeArrayList* ncxDataExtractedList = NULL;
				GeeArrayList* _tmp122_;
				BookwormAppXmlParser* _tmp123_;
				const gchar* _tmp124_;
				GeeArrayList* _tmp125_;
				GeeArrayList* _tmp126_;
				GeeArrayList* _tmp127_;
				gboolean _tmp128_ = FALSE;
				gboolean _tmp129_ = FALSE;
				GeeArrayList* _tmp130_;
				gpointer _tmp131_;
				BookwormAppXMLData* _tmp132_;
				GeeArrayList* _tmp133_;
				gint _tmp134_;
				gint _tmp135_;
				gboolean _tmp136_;
#line 208 "../src/ePubReader.vala"
				_tmp105_ = ncxFilePath;
#line 208 "../src/ePubReader.vala"
				_tmp106_ = g_strconcat ("Successfully determined NCX File Path as:", _tmp105_, NULL);
#line 208 "../src/ePubReader.vala"
				_tmp107_ = _tmp106_;
#line 208 "../src/ePubReader.vala"
				g_debug ("ePubReader.vala:208: %s", _tmp107_);
#line 208 "../src/ePubReader.vala"
				_g_free0 (_tmp107_);
#line 210 "../src/ePubReader.vala"
				_tmp108_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 210 "../src/ePubReader.vala"
				inputDataListForToC = _tmp108_;
#line 211 "../src/ePubReader.vala"
				_tmp109_ = inputDataListForToC;
#line 211 "../src/ePubReader.vala"
				_tmp110_ = g_strdup ("navLabel");
#line 211 "../src/ePubReader.vala"
				_tmp111_ = g_strdup ("text");
#line 211 "../src/ePubReader.vala"
				_tmp112_ = g_strdup ("");
#line 211 "../src/ePubReader.vala"
				_tmp113_ = bookworm_app_xml_data_new ();
#line 211 "../src/ePubReader.vala"
				_g_free0 (_tmp113_->containerTagName);
#line 211 "../src/ePubReader.vala"
				_tmp113_->containerTagName = _tmp110_;
#line 211 "../src/ePubReader.vala"
				_g_free0 (_tmp113_->inputTagName);
#line 211 "../src/ePubReader.vala"
				_tmp113_->inputTagName = _tmp111_;
#line 211 "../src/ePubReader.vala"
				_g_free0 (_tmp113_->inputAttributeName);
#line 211 "../src/ePubReader.vala"
				_tmp113_->inputAttributeName = _tmp112_;
#line 211 "../src/ePubReader.vala"
				_tmp114_ = _tmp113_;
#line 211 "../src/ePubReader.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp109_, _tmp114_);
#line 211 "../src/ePubReader.vala"
				_bookworm_app_xml_data_unref0 (_tmp114_);
#line 216 "../src/ePubReader.vala"
				_tmp115_ = inputDataListForToC;
#line 216 "../src/ePubReader.vala"
				_tmp116_ = g_strdup ("");
#line 216 "../src/ePubReader.vala"
				_tmp117_ = g_strdup ("content");
#line 216 "../src/ePubReader.vala"
				_tmp118_ = g_strdup ("src");
#line 216 "../src/ePubReader.vala"
				_tmp119_ = bookworm_app_xml_data_new ();
#line 216 "../src/ePubReader.vala"
				_g_free0 (_tmp119_->containerTagName);
#line 216 "../src/ePubReader.vala"
				_tmp119_->containerTagName = _tmp116_;
#line 216 "../src/ePubReader.vala"
				_g_free0 (_tmp119_->inputTagName);
#line 216 "../src/ePubReader.vala"
				_tmp119_->inputTagName = _tmp117_;
#line 216 "../src/ePubReader.vala"
				_g_free0 (_tmp119_->inputAttributeName);
#line 216 "../src/ePubReader.vala"
				_tmp119_->inputAttributeName = _tmp118_;
#line 216 "../src/ePubReader.vala"
				_tmp120_ = _tmp119_;
#line 216 "../src/ePubReader.vala"
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp115_, _tmp120_);
#line 216 "../src/ePubReader.vala"
				_bookworm_app_xml_data_unref0 (_tmp120_);
#line 221 "../src/ePubReader.vala"
				_tmp121_ = bookworm_app_xml_parser_new ();
#line 221 "../src/ePubReader.vala"
				ncxParser = _tmp121_;
#line 222 "../src/ePubReader.vala"
				_tmp122_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 222 "../src/ePubReader.vala"
				ncxDataExtractedList = _tmp122_;
#line 223 "../src/ePubReader.vala"
				_tmp123_ = ncxParser;
#line 223 "../src/ePubReader.vala"
				_tmp124_ = ncxFilePath;
#line 223 "../src/ePubReader.vala"
				_tmp125_ = inputDataListForToC;
#line 223 "../src/ePubReader.vala"
				_tmp126_ = _g_object_ref0 (_tmp125_);
#line 223 "../src/ePubReader.vala"
				_tmp127_ = bookworm_app_xml_parser_extractDataFromXML (_tmp123_, _tmp124_, _tmp126_, FALSE);
#line 223 "../src/ePubReader.vala"
				_g_object_unref0 (ncxDataExtractedList);
#line 223 "../src/ePubReader.vala"
				ncxDataExtractedList = _tmp127_;
#line 224 "../src/ePubReader.vala"
				_tmp130_ = ncxDataExtractedList;
#line 224 "../src/ePubReader.vala"
				_tmp131_ = gee_abstract_list_get ((GeeAbstractList*) _tmp130_, 0);
#line 224 "../src/ePubReader.vala"
				_tmp132_ = (BookwormAppXMLData*) _tmp131_;
#line 224 "../src/ePubReader.vala"
				_tmp133_ = _tmp132_->extractedTagValues;
#line 224 "../src/ePubReader.vala"
				_tmp134_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp133_);
#line 224 "../src/ePubReader.vala"
				_tmp135_ = _tmp134_;
#line 224 "../src/ePubReader.vala"
				_tmp136_ = _tmp135_ > 0;
#line 224 "../src/ePubReader.vala"
				_bookworm_app_xml_data_unref0 (_tmp132_);
#line 224 "../src/ePubReader.vala"
				if (_tmp136_) {
#line 2253 "ePubReader.c"
					GeeArrayList* _tmp137_;
					gpointer _tmp138_;
					BookwormAppXMLData* _tmp139_;
					GeeArrayList* _tmp140_;
					gint _tmp141_;
					gint _tmp142_;
#line 225 "../src/ePubReader.vala"
					_tmp137_ = ncxDataExtractedList;
#line 225 "../src/ePubReader.vala"
					_tmp138_ = gee_abstract_list_get ((GeeAbstractList*) _tmp137_, 1);
#line 225 "../src/ePubReader.vala"
					_tmp139_ = (BookwormAppXMLData*) _tmp138_;
#line 225 "../src/ePubReader.vala"
					_tmp140_ = _tmp139_->extractedTagAttributes;
#line 225 "../src/ePubReader.vala"
					_tmp141_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp140_);
#line 225 "../src/ePubReader.vala"
					_tmp142_ = _tmp141_;
#line 225 "../src/ePubReader.vala"
					_tmp129_ = _tmp142_ > 0;
#line 225 "../src/ePubReader.vala"
					_bookworm_app_xml_data_unref0 (_tmp139_);
#line 2276 "ePubReader.c"
				} else {
#line 224 "../src/ePubReader.vala"
					_tmp129_ = FALSE;
#line 2280 "ePubReader.c"
				}
#line 224 "../src/ePubReader.vala"
				if (_tmp129_) {
#line 2284 "ePubReader.c"
					GeeArrayList* _tmp143_;
					gpointer _tmp144_;
					BookwormAppXMLData* _tmp145_;
					GeeArrayList* _tmp146_;
					gint _tmp147_;
					gint _tmp148_;
					GeeArrayList* _tmp149_;
					gpointer _tmp150_;
					BookwormAppXMLData* _tmp151_;
					GeeArrayList* _tmp152_;
					gint _tmp153_;
					gint _tmp154_;
#line 226 "../src/ePubReader.vala"
					_tmp143_ = ncxDataExtractedList;
#line 226 "../src/ePubReader.vala"
					_tmp144_ = gee_abstract_list_get ((GeeAbstractList*) _tmp143_, 0);
#line 226 "../src/ePubReader.vala"
					_tmp145_ = (BookwormAppXMLData*) _tmp144_;
#line 226 "../src/ePubReader.vala"
					_tmp146_ = _tmp145_->extractedTagValues;
#line 226 "../src/ePubReader.vala"
					_tmp147_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp146_);
#line 226 "../src/ePubReader.vala"
					_tmp148_ = _tmp147_;
#line 226 "../src/ePubReader.vala"
					_tmp149_ = ncxDataExtractedList;
#line 226 "../src/ePubReader.vala"
					_tmp150_ = gee_abstract_list_get ((GeeAbstractList*) _tmp149_, 1);
#line 226 "../src/ePubReader.vala"
					_tmp151_ = (BookwormAppXMLData*) _tmp150_;
#line 226 "../src/ePubReader.vala"
					_tmp152_ = _tmp151_->extractedTagAttributes;
#line 226 "../src/ePubReader.vala"
					_tmp153_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp152_);
#line 226 "../src/ePubReader.vala"
					_tmp154_ = _tmp153_;
#line 226 "../src/ePubReader.vala"
					_tmp128_ = _tmp148_ == _tmp154_;
#line 226 "../src/ePubReader.vala"
					_bookworm_app_xml_data_unref0 (_tmp151_);
#line 226 "../src/ePubReader.vala"
					_bookworm_app_xml_data_unref0 (_tmp145_);
#line 2327 "ePubReader.c"
				} else {
#line 224 "../src/ePubReader.vala"
					_tmp128_ = FALSE;
#line 2331 "ePubReader.c"
				}
#line 224 "../src/ePubReader.vala"
				if (_tmp128_) {
#line 2335 "ePubReader.c"
					{
						gint count = 0;
#line 228 "../src/ePubReader.vala"
						count = 0;
#line 2340 "ePubReader.c"
						{
							gboolean _tmp155_ = FALSE;
#line 228 "../src/ePubReader.vala"
							_tmp155_ = TRUE;
#line 228 "../src/ePubReader.vala"
							while (TRUE) {
#line 2347 "ePubReader.c"
								GeeArrayList* _tmp157_;
								gpointer _tmp158_;
								BookwormAppXMLData* _tmp159_;
								GeeArrayList* _tmp160_;
								gint _tmp161_;
								gint _tmp162_;
								gboolean _tmp163_;
								GeeHashMap* TOCMapItem = NULL;
								GeeHashMap* _tmp164_;
								gchar* tocLocation = NULL;
								GeeArrayList* _tmp165_;
								gpointer _tmp166_;
								BookwormAppXMLData* _tmp167_;
								GeeArrayList* _tmp168_;
								gpointer _tmp169_;
								gchar* _tmp170_;
								gchar* anchorValue = NULL;
								gchar* _tmp171_;
								const gchar* _tmp172_;
								gchar* _tmp182_;
								gchar* _tmp183_;
								const gchar* _tmp184_;
								gchar* _tmp185_;
								GeeHashMap* _tmp186_;
								const gchar* _tmp187_;
								const gchar* _tmp188_;
								gchar* _tmp189_;
								gchar* _tmp190_;
								GeeArrayList* _tmp191_;
								gpointer _tmp192_;
								BookwormAppXMLData* _tmp193_;
								GeeArrayList* _tmp194_;
								gpointer _tmp195_;
								gchar* _tmp196_;
								GeeHashMap* _tmp197_;
								GeeArrayList* _tmp198_;
								gpointer _tmp199_;
								BookwormAppXMLData* _tmp200_;
								GeeArrayList* _tmp201_;
								gpointer _tmp202_;
								gchar* _tmp203_;
								gchar* _tmp204_;
								gchar* _tmp205_;
								gchar* _tmp206_;
								gchar* _tmp207_;
								const gchar* _tmp208_;
								gchar* _tmp209_;
								gchar* _tmp210_;
								const gchar* _tmp211_;
								gchar* _tmp212_;
								gchar* _tmp213_;
#line 228 "../src/ePubReader.vala"
								if (!_tmp155_) {
#line 2401 "ePubReader.c"
									gint _tmp156_;
#line 228 "../src/ePubReader.vala"
									_tmp156_ = count;
#line 228 "../src/ePubReader.vala"
									count = _tmp156_ + 1;
#line 2407 "ePubReader.c"
								}
#line 228 "../src/ePubReader.vala"
								_tmp155_ = FALSE;
#line 228 "../src/ePubReader.vala"
								_tmp157_ = ncxDataExtractedList;
#line 228 "../src/ePubReader.vala"
								_tmp158_ = gee_abstract_list_get ((GeeAbstractList*) _tmp157_, 0);
#line 228 "../src/ePubReader.vala"
								_tmp159_ = (BookwormAppXMLData*) _tmp158_;
#line 228 "../src/ePubReader.vala"
								_tmp160_ = _tmp159_->extractedTagValues;
#line 228 "../src/ePubReader.vala"
								_tmp161_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp160_);
#line 228 "../src/ePubReader.vala"
								_tmp162_ = _tmp161_;
#line 228 "../src/ePubReader.vala"
								_tmp163_ = !(count < _tmp162_);
#line 228 "../src/ePubReader.vala"
								_bookworm_app_xml_data_unref0 (_tmp159_);
#line 228 "../src/ePubReader.vala"
								if (_tmp163_) {
#line 228 "../src/ePubReader.vala"
									break;
#line 2431 "ePubReader.c"
								}
#line 229 "../src/ePubReader.vala"
								_tmp164_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
#line 229 "../src/ePubReader.vala"
								TOCMapItem = _tmp164_;
#line 230 "../src/ePubReader.vala"
								_tmp165_ = ncxDataExtractedList;
#line 230 "../src/ePubReader.vala"
								_tmp166_ = gee_abstract_list_get ((GeeAbstractList*) _tmp165_, 1);
#line 230 "../src/ePubReader.vala"
								_tmp167_ = (BookwormAppXMLData*) _tmp166_;
#line 230 "../src/ePubReader.vala"
								_tmp168_ = _tmp167_->extractedTagAttributes;
#line 230 "../src/ePubReader.vala"
								_tmp169_ = gee_abstract_list_get ((GeeAbstractList*) _tmp168_, count);
#line 230 "../src/ePubReader.vala"
								_tmp170_ = (gchar*) _tmp169_;
#line 230 "../src/ePubReader.vala"
								_bookworm_app_xml_data_unref0 (_tmp167_);
#line 230 "../src/ePubReader.vala"
								tocLocation = _tmp170_;
#line 232 "../src/ePubReader.vala"
								_tmp171_ = g_strdup ("");
#line 232 "../src/ePubReader.vala"
								anchorValue = _tmp171_;
#line 233 "../src/ePubReader.vala"
								_tmp172_ = tocLocation;
#line 233 "../src/ePubReader.vala"
								if (string_index_of (_tmp172_, "#", 0) != -1) {
#line 2461 "ePubReader.c"
									const gchar* _tmp173_;
									const gchar* _tmp174_;
									const gchar* _tmp175_;
									gint _tmp176_;
									gint _tmp177_;
									gchar* _tmp178_;
									const gchar* _tmp179_;
									const gchar* _tmp180_;
									gchar* _tmp181_;
#line 234 "../src/ePubReader.vala"
									_tmp173_ = tocLocation;
#line 234 "../src/ePubReader.vala"
									_tmp174_ = tocLocation;
#line 234 "../src/ePubReader.vala"
									_tmp175_ = tocLocation;
#line 234 "../src/ePubReader.vala"
									_tmp176_ = strlen (_tmp175_);
#line 234 "../src/ePubReader.vala"
									_tmp177_ = _tmp176_;
#line 234 "../src/ePubReader.vala"
									_tmp178_ = string_slice (_tmp173_, (glong) string_index_of (_tmp174_, "#", 0), (glong) _tmp177_);
#line 234 "../src/ePubReader.vala"
									_g_free0 (anchorValue);
#line 234 "../src/ePubReader.vala"
									anchorValue = _tmp178_;
#line 235 "../src/ePubReader.vala"
									_tmp179_ = tocLocation;
#line 235 "../src/ePubReader.vala"
									_tmp180_ = tocLocation;
#line 235 "../src/ePubReader.vala"
									_tmp181_ = string_slice (_tmp179_, (glong) 0, (glong) string_index_of (_tmp180_, "#", 0));
#line 235 "../src/ePubReader.vala"
									_g_free0 (tocLocation);
#line 235 "../src/ePubReader.vala"
									tocLocation = _tmp181_;
#line 2497 "ePubReader.c"
								}
#line 237 "../src/ePubReader.vala"
								_tmp182_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 237 "../src/ePubReader.vala"
								_tmp183_ = _tmp182_;
#line 237 "../src/ePubReader.vala"
								_tmp184_ = tocLocation;
#line 237 "../src/ePubReader.vala"
								_tmp185_ = bookworm_app_utils_getFullPathFromFilename (_tmp183_, _tmp184_);
#line 237 "../src/ePubReader.vala"
								_g_free0 (tocLocation);
#line 237 "../src/ePubReader.vala"
								tocLocation = _tmp185_;
#line 237 "../src/ePubReader.vala"
								_g_free0 (_tmp183_);
#line 238 "../src/ePubReader.vala"
								_tmp186_ = TOCMapItem;
#line 238 "../src/ePubReader.vala"
								_tmp187_ = tocLocation;
#line 238 "../src/ePubReader.vala"
								_tmp188_ = anchorValue;
#line 238 "../src/ePubReader.vala"
								_tmp189_ = g_strconcat (_tmp187_, _tmp188_, NULL);
#line 238 "../src/ePubReader.vala"
								_tmp190_ = _tmp189_;
#line 238 "../src/ePubReader.vala"
								_tmp191_ = ncxDataExtractedList;
#line 238 "../src/ePubReader.vala"
								_tmp192_ = gee_abstract_list_get ((GeeAbstractList*) _tmp191_, 0);
#line 238 "../src/ePubReader.vala"
								_tmp193_ = (BookwormAppXMLData*) _tmp192_;
#line 238 "../src/ePubReader.vala"
								_tmp194_ = _tmp193_->extractedTagValues;
#line 238 "../src/ePubReader.vala"
								_tmp195_ = gee_abstract_list_get ((GeeAbstractList*) _tmp194_, count);
#line 238 "../src/ePubReader.vala"
								_tmp196_ = (gchar*) _tmp195_;
#line 238 "../src/ePubReader.vala"
								gee_abstract_map_set ((GeeAbstractMap*) _tmp186_, _tmp190_, _tmp196_);
#line 238 "../src/ePubReader.vala"
								_g_free0 (_tmp196_);
#line 238 "../src/ePubReader.vala"
								_bookworm_app_xml_data_unref0 (_tmp193_);
#line 238 "../src/ePubReader.vala"
								_g_free0 (_tmp190_);
#line 239 "../src/ePubReader.vala"
								_tmp197_ = TOCMapItem;
#line 239 "../src/ePubReader.vala"
								bookworm_app_book_setTOC (aBook, _tmp197_);
#line 240 "../src/ePubReader.vala"
								_tmp198_ = ncxDataExtractedList;
#line 240 "../src/ePubReader.vala"
								_tmp199_ = gee_abstract_list_get ((GeeAbstractList*) _tmp198_, 0);
#line 240 "../src/ePubReader.vala"
								_tmp200_ = (BookwormAppXMLData*) _tmp199_;
#line 240 "../src/ePubReader.vala"
								_tmp201_ = _tmp200_->extractedTagValues;
#line 240 "../src/ePubReader.vala"
								_tmp202_ = gee_abstract_list_get ((GeeAbstractList*) _tmp201_, count);
#line 240 "../src/ePubReader.vala"
								_tmp203_ = (gchar*) _tmp202_;
#line 240 "../src/ePubReader.vala"
								_tmp204_ = g_strconcat ("Extracted ToC Chapter Name:", _tmp203_, NULL);
#line 240 "../src/ePubReader.vala"
								_tmp205_ = _tmp204_;
#line 240 "../src/ePubReader.vala"
								_tmp206_ = g_strconcat (_tmp205_, " at location:", NULL);
#line 240 "../src/ePubReader.vala"
								_tmp207_ = _tmp206_;
#line 240 "../src/ePubReader.vala"
								_tmp208_ = tocLocation;
#line 240 "../src/ePubReader.vala"
								_tmp209_ = g_strconcat (_tmp207_, _tmp208_, NULL);
#line 240 "../src/ePubReader.vala"
								_tmp210_ = _tmp209_;
#line 240 "../src/ePubReader.vala"
								_tmp211_ = anchorValue;
#line 240 "../src/ePubReader.vala"
								_tmp212_ = g_strconcat (_tmp210_, _tmp211_, NULL);
#line 240 "../src/ePubReader.vala"
								_tmp213_ = _tmp212_;
#line 240 "../src/ePubReader.vala"
								g_debug ("ePubReader.vala:240: %s", _tmp213_);
#line 240 "../src/ePubReader.vala"
								_g_free0 (_tmp213_);
#line 240 "../src/ePubReader.vala"
								_g_free0 (_tmp210_);
#line 240 "../src/ePubReader.vala"
								_g_free0 (_tmp207_);
#line 240 "../src/ePubReader.vala"
								_g_free0 (_tmp205_);
#line 240 "../src/ePubReader.vala"
								_g_free0 (_tmp203_);
#line 240 "../src/ePubReader.vala"
								_bookworm_app_xml_data_unref0 (_tmp200_);
#line 228 "../src/ePubReader.vala"
								_g_free0 (anchorValue);
#line 228 "../src/ePubReader.vala"
								_g_free0 (tocLocation);
#line 228 "../src/ePubReader.vala"
								_g_object_unref0 (TOCMapItem);
#line 2599 "ePubReader.c"
							}
						}
					}
				}
#line 207 "../src/ePubReader.vala"
				_g_object_unref0 (ncxDataExtractedList);
#line 207 "../src/ePubReader.vala"
				_bookworm_app_xml_parser_unref0 (ncxParser);
#line 207 "../src/ePubReader.vala"
				_g_object_unref0 (inputDataListForToC);
#line 2610 "ePubReader.c"
			}
#line 196 "../src/ePubReader.vala"
			_g_free0 (ncxFilePath);
#line 196 "../src/ePubReader.vala"
			_g_free0 (NCXFileRelativePath);
#line 2616 "ePubReader.c"
		}
#line 190 "../src/ePubReader.vala"
		_g_free0 (spineNCXReference);
#line 2620 "ePubReader.c"
	}
#line 251 "../src/ePubReader.vala"
	bookworm_app_book_clearBookContentList (aBook);
#line 2624 "ePubReader.c"
	{
		GeeArrayList* _spineIDREF_list = NULL;
		GeeArrayList* _tmp214_;
		gpointer _tmp215_;
		BookwormAppXMLData* _tmp216_;
		GeeArrayList* _tmp217_;
		GeeArrayList* _tmp218_;
		gint _spineIDREF_size = 0;
		GeeArrayList* _tmp219_;
		gint _tmp220_;
		gint _tmp221_;
		gint _spineIDREF_index = 0;
#line 253 "../src/ePubReader.vala"
		_tmp214_ = opfItemsList;
#line 253 "../src/ePubReader.vala"
		_tmp215_ = gee_abstract_list_get ((GeeAbstractList*) _tmp214_, 3);
#line 253 "../src/ePubReader.vala"
		_tmp216_ = (BookwormAppXMLData*) _tmp215_;
#line 253 "../src/ePubReader.vala"
		_tmp217_ = _tmp216_->extractedTagAttributes;
#line 253 "../src/ePubReader.vala"
		_tmp218_ = _tmp217_;
#line 253 "../src/ePubReader.vala"
		_bookworm_app_xml_data_unref0 (_tmp216_);
#line 253 "../src/ePubReader.vala"
		_spineIDREF_list = _tmp218_;
#line 253 "../src/ePubReader.vala"
		_tmp219_ = _spineIDREF_list;
#line 253 "../src/ePubReader.vala"
		_tmp220_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp219_);
#line 253 "../src/ePubReader.vala"
		_tmp221_ = _tmp220_;
#line 253 "../src/ePubReader.vala"
		_spineIDREF_size = _tmp221_;
#line 253 "../src/ePubReader.vala"
		_spineIDREF_index = -1;
#line 253 "../src/ePubReader.vala"
		while (TRUE) {
#line 2663 "ePubReader.c"
			gint _tmp222_;
			gint _tmp223_;
			gchar* spineIDREF = NULL;
			GeeArrayList* _tmp224_;
			gpointer _tmp225_;
			GeeArrayList* _tmp226_;
			gpointer _tmp227_;
			BookwormAppXMLData* _tmp228_;
			GeeArrayList* _tmp229_;
			const gchar* _tmp230_;
			gboolean _tmp231_;
#line 253 "../src/ePubReader.vala"
			_spineIDREF_index = _spineIDREF_index + 1;
#line 253 "../src/ePubReader.vala"
			_tmp222_ = _spineIDREF_index;
#line 253 "../src/ePubReader.vala"
			_tmp223_ = _spineIDREF_size;
#line 253 "../src/ePubReader.vala"
			if (!(_tmp222_ < _tmp223_)) {
#line 253 "../src/ePubReader.vala"
				break;
#line 2685 "ePubReader.c"
			}
#line 253 "../src/ePubReader.vala"
			_tmp224_ = _spineIDREF_list;
#line 253 "../src/ePubReader.vala"
			_tmp225_ = gee_abstract_list_get ((GeeAbstractList*) _tmp224_, _spineIDREF_index);
#line 253 "../src/ePubReader.vala"
			spineIDREF = (gchar*) _tmp225_;
#line 255 "../src/ePubReader.vala"
			_tmp226_ = opfItemsList;
#line 255 "../src/ePubReader.vala"
			_tmp227_ = gee_abstract_list_get ((GeeAbstractList*) _tmp226_, 0);
#line 255 "../src/ePubReader.vala"
			_tmp228_ = (BookwormAppXMLData*) _tmp227_;
#line 255 "../src/ePubReader.vala"
			_tmp229_ = _tmp228_->extractedTagAttributes;
#line 255 "../src/ePubReader.vala"
			_tmp230_ = spineIDREF;
#line 255 "../src/ePubReader.vala"
			_tmp231_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp229_, _tmp230_);
#line 255 "../src/ePubReader.vala"
			_bookworm_app_xml_data_unref0 (_tmp228_);
#line 255 "../src/ePubReader.vala"
			if (_tmp231_) {
#line 2709 "ePubReader.c"
				gint positionOfIDREF = 0;
				GeeArrayList* _tmp232_;
				gpointer _tmp233_;
				BookwormAppXMLData* _tmp234_;
				GeeArrayList* _tmp235_;
				const gchar* _tmp236_;
				gint _tmp237_;
				gchar* locationOfContentData = NULL;
				GeeArrayList* _tmp238_;
				gpointer _tmp239_;
				BookwormAppXMLData* _tmp240_;
				GeeArrayList* _tmp241_;
				gpointer _tmp242_;
				gchar* _tmp243_;
				gchar* _tmp244_;
				gchar* _tmp245_;
				const gchar* _tmp246_;
				gchar* _tmp247_;
				gchar* _tmp248_;
				gchar* _tmp249_;
				gchar* _tmp250_;
				gchar* _tmp251_;
				gchar* _tmp252_;
				const gchar* _tmp253_;
				gchar* _tmp254_;
				gchar* _tmp255_;
#line 256 "../src/ePubReader.vala"
				_tmp232_ = opfItemsList;
#line 256 "../src/ePubReader.vala"
				_tmp233_ = gee_abstract_list_get ((GeeAbstractList*) _tmp232_, 0);
#line 256 "../src/ePubReader.vala"
				_tmp234_ = (BookwormAppXMLData*) _tmp233_;
#line 256 "../src/ePubReader.vala"
				_tmp235_ = _tmp234_->extractedTagAttributes;
#line 256 "../src/ePubReader.vala"
				_tmp236_ = spineIDREF;
#line 256 "../src/ePubReader.vala"
				_tmp237_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp235_, _tmp236_);
#line 256 "../src/ePubReader.vala"
				_bookworm_app_xml_data_unref0 (_tmp234_);
#line 256 "../src/ePubReader.vala"
				positionOfIDREF = _tmp237_;
#line 258 "../src/ePubReader.vala"
				_tmp238_ = opfItemsList;
#line 258 "../src/ePubReader.vala"
				_tmp239_ = gee_abstract_list_get ((GeeAbstractList*) _tmp238_, 1);
#line 258 "../src/ePubReader.vala"
				_tmp240_ = (BookwormAppXMLData*) _tmp239_;
#line 258 "../src/ePubReader.vala"
				_tmp241_ = _tmp240_->extractedTagAttributes;
#line 258 "../src/ePubReader.vala"
				_tmp242_ = gee_abstract_list_get ((GeeAbstractList*) _tmp241_, positionOfIDREF);
#line 258 "../src/ePubReader.vala"
				_tmp243_ = (gchar*) _tmp242_;
#line 258 "../src/ePubReader.vala"
				_bookworm_app_xml_data_unref0 (_tmp240_);
#line 258 "../src/ePubReader.vala"
				locationOfContentData = _tmp243_;
#line 259 "../src/ePubReader.vala"
				_tmp244_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 259 "../src/ePubReader.vala"
				_tmp245_ = _tmp244_;
#line 259 "../src/ePubReader.vala"
				_tmp246_ = locationOfContentData;
#line 259 "../src/ePubReader.vala"
				_tmp247_ = g_strconcat (_tmp245_, _tmp246_, NULL);
#line 259 "../src/ePubReader.vala"
				_tmp248_ = _tmp247_;
#line 259 "../src/ePubReader.vala"
				bookworm_app_book_setBookContentList (aBook, _tmp248_);
#line 259 "../src/ePubReader.vala"
				_g_free0 (_tmp248_);
#line 259 "../src/ePubReader.vala"
				_g_free0 (_tmp245_);
#line 260 "../src/ePubReader.vala"
				_tmp249_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 260 "../src/ePubReader.vala"
				_tmp250_ = _tmp249_;
#line 260 "../src/ePubReader.vala"
				_tmp251_ = g_strconcat ("Book content data :", _tmp250_, NULL);
#line 260 "../src/ePubReader.vala"
				_tmp252_ = _tmp251_;
#line 260 "../src/ePubReader.vala"
				_tmp253_ = locationOfContentData;
#line 260 "../src/ePubReader.vala"
				_tmp254_ = g_strconcat (_tmp252_, _tmp253_, NULL);
#line 260 "../src/ePubReader.vala"
				_tmp255_ = _tmp254_;
#line 260 "../src/ePubReader.vala"
				g_debug ("ePubReader.vala:260: %s", _tmp255_);
#line 260 "../src/ePubReader.vala"
				_g_free0 (_tmp255_);
#line 260 "../src/ePubReader.vala"
				_g_free0 (_tmp252_);
#line 260 "../src/ePubReader.vala"
				_g_free0 (_tmp250_);
#line 255 "../src/ePubReader.vala"
				_g_free0 (locationOfContentData);
#line 2808 "ePubReader.c"
			}
#line 253 "../src/ePubReader.vala"
			_g_free0 (spineIDREF);
#line 2812 "ePubReader.c"
		}
	}
#line 263 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:263: [END] [FUNCTION:determineToC]");
#line 264 "../src/ePubReader.vala"
	_tmp256_ = _bookworm_app_book_ref0 (aBook);
#line 264 "../src/ePubReader.vala"
	result = _tmp256_;
#line 264 "../src/ePubReader.vala"
	_g_object_unref0 (opfItemsList);
#line 264 "../src/ePubReader.vala"
	_bookworm_app_xml_parser_unref0 (thisParser);
#line 264 "../src/ePubReader.vala"
	_g_object_unref0 (inputDataList);
#line 264 "../src/ePubReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 264 "../src/ePubReader.vala"
	return result;
#line 2831 "ePubReader.c"
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, FALSE);
#line 1584 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, FALSE);
#line 1585 "glib-2.0.vapi"
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
#line 1585 "glib-2.0.vapi"
	result = _tmp0_ != NULL;
#line 1585 "glib-2.0.vapi"
	return result;
#line 2850 "ePubReader.c"
}

BookwormAppBook*
bookworm_app_epub_reader_setCoverImage (BookwormAppBook* aBook,
                                        const gchar* locationOfOPFFile)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* bookCoverLocation = NULL;
	gchar* _tmp8_;
	GeeArrayList* inputDataList = NULL;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	BookwormAppXMLData* _tmp14_ = NULL;
	BookwormAppXMLData* _tmp15_;
	GeeArrayList* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	BookwormAppXMLData* _tmp20_ = NULL;
	BookwormAppXMLData* _tmp21_;
	GeeArrayList* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	BookwormAppXMLData* _tmp26_ = NULL;
	BookwormAppXMLData* _tmp27_;
	GeeArrayList* _tmp28_;
	gchar* _tmp29_;
	gchar* _tmp30_;
	gchar* _tmp31_;
	BookwormAppXMLData* _tmp32_ = NULL;
	BookwormAppXMLData* _tmp33_;
	BookwormAppXmlParser* thisParser = NULL;
	BookwormAppXmlParser* _tmp34_;
	GeeArrayList* opfItemsList = NULL;
	GeeArrayList* _tmp35_;
	BookwormAppXmlParser* _tmp36_;
	GeeArrayList* _tmp37_;
	GeeArrayList* _tmp38_;
	GeeArrayList* _tmp39_;
	gint count = 0;
	gboolean _tmp70_ = FALSE;
	const gchar* _tmp71_;
	gint _tmp72_;
	gint _tmp73_;
	gboolean _tmp107_ = FALSE;
	const gchar* _tmp108_;
	gint _tmp109_;
	gint _tmp110_;
	gchar* _tmp121_;
	gchar* _tmp122_;
	gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	gchar* _tmp126_;
	const gchar* _tmp127_;
	gchar* _tmp128_;
	gchar* _tmp129_;
	BookwormAppBook* _tmp130_;
	BookwormAppBook* result;
#line 267 "../src/ePubReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 267 "../src/ePubReader.vala"
	g_return_val_if_fail (locationOfOPFFile != NULL, NULL);
#line 268 "../src/ePubReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 268 "../src/ePubReader.vala"
	_tmp1_ = _tmp0_;
#line 268 "../src/ePubReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:setCoverImage] book.location=", _tmp1_, NULL);
#line 268 "../src/ePubReader.vala"
	_tmp3_ = _tmp2_;
#line 268 "../src/ePubReader.vala"
	_tmp4_ = g_strconcat (_tmp3_, ", locationOfOPFFile=", NULL);
#line 268 "../src/ePubReader.vala"
	_tmp5_ = _tmp4_;
#line 268 "../src/ePubReader.vala"
	_tmp6_ = g_strconcat (_tmp5_, locationOfOPFFile, NULL);
#line 268 "../src/ePubReader.vala"
	_tmp7_ = _tmp6_;
#line 268 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:268: %s", _tmp7_);
#line 268 "../src/ePubReader.vala"
	_g_free0 (_tmp7_);
#line 268 "../src/ePubReader.vala"
	_g_free0 (_tmp5_);
#line 268 "../src/ePubReader.vala"
	_g_free0 (_tmp3_);
#line 268 "../src/ePubReader.vala"
	_g_free0 (_tmp1_);
#line 269 "../src/ePubReader.vala"
	_tmp8_ = g_strdup ("");
#line 269 "../src/ePubReader.vala"
	bookCoverLocation = _tmp8_;
#line 271 "../src/ePubReader.vala"
	_tmp9_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 271 "../src/ePubReader.vala"
	inputDataList = _tmp9_;
#line 272 "../src/ePubReader.vala"
	_tmp10_ = inputDataList;
#line 272 "../src/ePubReader.vala"
	_tmp11_ = g_strdup ("manifest");
#line 272 "../src/ePubReader.vala"
	_tmp12_ = g_strdup ("item");
#line 272 "../src/ePubReader.vala"
	_tmp13_ = g_strdup ("id");
#line 272 "../src/ePubReader.vala"
	_tmp14_ = bookworm_app_xml_data_new ();
#line 272 "../src/ePubReader.vala"
	_g_free0 (_tmp14_->containerTagName);
#line 272 "../src/ePubReader.vala"
	_tmp14_->containerTagName = _tmp11_;
#line 272 "../src/ePubReader.vala"
	_g_free0 (_tmp14_->inputTagName);
#line 272 "../src/ePubReader.vala"
	_tmp14_->inputTagName = _tmp12_;
#line 272 "../src/ePubReader.vala"
	_g_free0 (_tmp14_->inputAttributeName);
#line 272 "../src/ePubReader.vala"
	_tmp14_->inputAttributeName = _tmp13_;
#line 272 "../src/ePubReader.vala"
	_tmp15_ = _tmp14_;
#line 272 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp15_);
#line 272 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp15_);
#line 277 "../src/ePubReader.vala"
	_tmp16_ = inputDataList;
#line 277 "../src/ePubReader.vala"
	_tmp17_ = g_strdup ("manifest");
#line 277 "../src/ePubReader.vala"
	_tmp18_ = g_strdup ("item");
#line 277 "../src/ePubReader.vala"
	_tmp19_ = g_strdup ("media-type");
#line 277 "../src/ePubReader.vala"
	_tmp20_ = bookworm_app_xml_data_new ();
#line 277 "../src/ePubReader.vala"
	_g_free0 (_tmp20_->containerTagName);
#line 277 "../src/ePubReader.vala"
	_tmp20_->containerTagName = _tmp17_;
#line 277 "../src/ePubReader.vala"
	_g_free0 (_tmp20_->inputTagName);
#line 277 "../src/ePubReader.vala"
	_tmp20_->inputTagName = _tmp18_;
#line 277 "../src/ePubReader.vala"
	_tmp20_->enforceAttributeData = TRUE;
#line 277 "../src/ePubReader.vala"
	_g_free0 (_tmp20_->inputAttributeName);
#line 277 "../src/ePubReader.vala"
	_tmp20_->inputAttributeName = _tmp19_;
#line 277 "../src/ePubReader.vala"
	_tmp21_ = _tmp20_;
#line 277 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp16_, _tmp21_);
#line 277 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp21_);
#line 283 "../src/ePubReader.vala"
	_tmp22_ = inputDataList;
#line 283 "../src/ePubReader.vala"
	_tmp23_ = g_strdup ("manifest");
#line 283 "../src/ePubReader.vala"
	_tmp24_ = g_strdup ("item");
#line 283 "../src/ePubReader.vala"
	_tmp25_ = g_strdup ("href");
#line 283 "../src/ePubReader.vala"
	_tmp26_ = bookworm_app_xml_data_new ();
#line 283 "../src/ePubReader.vala"
	_g_free0 (_tmp26_->containerTagName);
#line 283 "../src/ePubReader.vala"
	_tmp26_->containerTagName = _tmp23_;
#line 283 "../src/ePubReader.vala"
	_g_free0 (_tmp26_->inputTagName);
#line 283 "../src/ePubReader.vala"
	_tmp26_->inputTagName = _tmp24_;
#line 283 "../src/ePubReader.vala"
	_g_free0 (_tmp26_->inputAttributeName);
#line 283 "../src/ePubReader.vala"
	_tmp26_->inputAttributeName = _tmp25_;
#line 283 "../src/ePubReader.vala"
	_tmp27_ = _tmp26_;
#line 283 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp22_, _tmp27_);
#line 283 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp27_);
#line 288 "../src/ePubReader.vala"
	_tmp28_ = inputDataList;
#line 288 "../src/ePubReader.vala"
	_tmp29_ = g_strdup ("manifest");
#line 288 "../src/ePubReader.vala"
	_tmp30_ = g_strdup ("item");
#line 288 "../src/ePubReader.vala"
	_tmp31_ = g_strdup ("properties");
#line 288 "../src/ePubReader.vala"
	_tmp32_ = bookworm_app_xml_data_new ();
#line 288 "../src/ePubReader.vala"
	_g_free0 (_tmp32_->containerTagName);
#line 288 "../src/ePubReader.vala"
	_tmp32_->containerTagName = _tmp29_;
#line 288 "../src/ePubReader.vala"
	_g_free0 (_tmp32_->inputTagName);
#line 288 "../src/ePubReader.vala"
	_tmp32_->inputTagName = _tmp30_;
#line 288 "../src/ePubReader.vala"
	_tmp32_->enforceAttributeData = TRUE;
#line 288 "../src/ePubReader.vala"
	_g_free0 (_tmp32_->inputAttributeName);
#line 288 "../src/ePubReader.vala"
	_tmp32_->inputAttributeName = _tmp31_;
#line 288 "../src/ePubReader.vala"
	_tmp33_ = _tmp32_;
#line 288 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp28_, _tmp33_);
#line 288 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp33_);
#line 294 "../src/ePubReader.vala"
	_tmp34_ = bookworm_app_xml_parser_new ();
#line 294 "../src/ePubReader.vala"
	thisParser = _tmp34_;
#line 295 "../src/ePubReader.vala"
	_tmp35_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 295 "../src/ePubReader.vala"
	opfItemsList = _tmp35_;
#line 296 "../src/ePubReader.vala"
	_tmp36_ = thisParser;
#line 296 "../src/ePubReader.vala"
	_tmp37_ = inputDataList;
#line 296 "../src/ePubReader.vala"
	_tmp38_ = _g_object_ref0 (_tmp37_);
#line 296 "../src/ePubReader.vala"
	_tmp39_ = bookworm_app_xml_parser_extractDataFromXML (_tmp36_, locationOfOPFFile, _tmp38_, FALSE);
#line 296 "../src/ePubReader.vala"
	_g_object_unref0 (opfItemsList);
#line 296 "../src/ePubReader.vala"
	opfItemsList = _tmp39_;
#line 298 "../src/ePubReader.vala"
	count = 0;
#line 3097 "ePubReader.c"
	{
		GeeArrayList* _properties_list = NULL;
		GeeArrayList* _tmp40_;
		gpointer _tmp41_;
		BookwormAppXMLData* _tmp42_;
		GeeArrayList* _tmp43_;
		GeeArrayList* _tmp44_;
		gint _properties_size = 0;
		GeeArrayList* _tmp45_;
		gint _tmp46_;
		gint _tmp47_;
		gint _properties_index = 0;
#line 300 "../src/ePubReader.vala"
		_tmp40_ = opfItemsList;
#line 300 "../src/ePubReader.vala"
		_tmp41_ = gee_abstract_list_get ((GeeAbstractList*) _tmp40_, 3);
#line 300 "../src/ePubReader.vala"
		_tmp42_ = (BookwormAppXMLData*) _tmp41_;
#line 300 "../src/ePubReader.vala"
		_tmp43_ = _tmp42_->extractedTagAttributes;
#line 300 "../src/ePubReader.vala"
		_tmp44_ = _tmp43_;
#line 300 "../src/ePubReader.vala"
		_bookworm_app_xml_data_unref0 (_tmp42_);
#line 300 "../src/ePubReader.vala"
		_properties_list = _tmp44_;
#line 300 "../src/ePubReader.vala"
		_tmp45_ = _properties_list;
#line 300 "../src/ePubReader.vala"
		_tmp46_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp45_);
#line 300 "../src/ePubReader.vala"
		_tmp47_ = _tmp46_;
#line 300 "../src/ePubReader.vala"
		_properties_size = _tmp47_;
#line 300 "../src/ePubReader.vala"
		_properties_index = -1;
#line 300 "../src/ePubReader.vala"
		while (TRUE) {
#line 3136 "ePubReader.c"
			gint _tmp48_;
			gint _tmp49_;
			gchar* properties = NULL;
			GeeArrayList* _tmp50_;
			gpointer _tmp51_;
			const gchar* _tmp52_;
			gint _tmp69_;
#line 300 "../src/ePubReader.vala"
			_properties_index = _properties_index + 1;
#line 300 "../src/ePubReader.vala"
			_tmp48_ = _properties_index;
#line 300 "../src/ePubReader.vala"
			_tmp49_ = _properties_size;
#line 300 "../src/ePubReader.vala"
			if (!(_tmp48_ < _tmp49_)) {
#line 300 "../src/ePubReader.vala"
				break;
#line 3154 "ePubReader.c"
			}
#line 300 "../src/ePubReader.vala"
			_tmp50_ = _properties_list;
#line 300 "../src/ePubReader.vala"
			_tmp51_ = gee_abstract_list_get ((GeeAbstractList*) _tmp50_, _properties_index);
#line 300 "../src/ePubReader.vala"
			properties = (gchar*) _tmp51_;
#line 301 "../src/ePubReader.vala"
			_tmp52_ = properties;
#line 301 "../src/ePubReader.vala"
			if (string_contains (_tmp52_, "cover-image")) {
#line 3166 "ePubReader.c"
				gchar* coverMediaType = NULL;
				GeeArrayList* _tmp53_;
				gpointer _tmp54_;
				BookwormAppXMLData* _tmp55_;
				GeeArrayList* _tmp56_;
				gpointer _tmp57_;
				gchar* _tmp58_;
				const gchar* _tmp59_;
#line 303 "../src/ePubReader.vala"
				_tmp53_ = opfItemsList;
#line 303 "../src/ePubReader.vala"
				_tmp54_ = gee_abstract_list_get ((GeeAbstractList*) _tmp53_, 1);
#line 303 "../src/ePubReader.vala"
				_tmp55_ = (BookwormAppXMLData*) _tmp54_;
#line 303 "../src/ePubReader.vala"
				_tmp56_ = _tmp55_->extractedTagAttributes;
#line 303 "../src/ePubReader.vala"
				_tmp57_ = gee_abstract_list_get ((GeeAbstractList*) _tmp56_, count);
#line 303 "../src/ePubReader.vala"
				_tmp58_ = (gchar*) _tmp57_;
#line 303 "../src/ePubReader.vala"
				_bookworm_app_xml_data_unref0 (_tmp55_);
#line 303 "../src/ePubReader.vala"
				coverMediaType = _tmp58_;
#line 305 "../src/ePubReader.vala"
				_tmp59_ = coverMediaType;
#line 305 "../src/ePubReader.vala"
				if (string_index_of (_tmp59_, "image", 0) != -1) {
#line 3195 "ePubReader.c"
					GeeArrayList* _tmp60_;
					gpointer _tmp61_;
					BookwormAppXMLData* _tmp62_;
					GeeArrayList* _tmp63_;
					gpointer _tmp64_;
					gchar* _tmp65_;
					gchar* _tmp66_;
					const gchar* _tmp67_;
					gchar* _tmp68_;
#line 306 "../src/ePubReader.vala"
					_tmp60_ = opfItemsList;
#line 306 "../src/ePubReader.vala"
					_tmp61_ = gee_abstract_list_get ((GeeAbstractList*) _tmp60_, 2);
#line 306 "../src/ePubReader.vala"
					_tmp62_ = (BookwormAppXMLData*) _tmp61_;
#line 306 "../src/ePubReader.vala"
					_tmp63_ = _tmp62_->extractedTagAttributes;
#line 306 "../src/ePubReader.vala"
					_tmp64_ = gee_abstract_list_get ((GeeAbstractList*) _tmp63_, count);
#line 306 "../src/ePubReader.vala"
					_g_free0 (bookCoverLocation);
#line 306 "../src/ePubReader.vala"
					bookCoverLocation = (gchar*) _tmp64_;
#line 306 "../src/ePubReader.vala"
					_bookworm_app_xml_data_unref0 (_tmp62_);
#line 307 "../src/ePubReader.vala"
					_tmp65_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 307 "../src/ePubReader.vala"
					_tmp66_ = _tmp65_;
#line 307 "../src/ePubReader.vala"
					_tmp67_ = bookCoverLocation;
#line 307 "../src/ePubReader.vala"
					_tmp68_ = g_strconcat (_tmp66_, _tmp67_, NULL);
#line 307 "../src/ePubReader.vala"
					_g_free0 (bookCoverLocation);
#line 307 "../src/ePubReader.vala"
					bookCoverLocation = _tmp68_;
#line 307 "../src/ePubReader.vala"
					_g_free0 (_tmp66_);
#line 308 "../src/ePubReader.vala"
					_g_free0 (coverMediaType);
#line 308 "../src/ePubReader.vala"
					_g_free0 (properties);
#line 308 "../src/ePubReader.vala"
					break;
#line 3241 "ePubReader.c"
				}
#line 301 "../src/ePubReader.vala"
				_g_free0 (coverMediaType);
#line 3245 "ePubReader.c"
			}
#line 311 "../src/ePubReader.vala"
			_tmp69_ = count;
#line 311 "../src/ePubReader.vala"
			count = _tmp69_ + 1;
#line 300 "../src/ePubReader.vala"
			_g_free0 (properties);
#line 3253 "ePubReader.c"
		}
	}
#line 316 "../src/ePubReader.vala"
	_tmp71_ = bookCoverLocation;
#line 316 "../src/ePubReader.vala"
	_tmp72_ = strlen (_tmp71_);
#line 316 "../src/ePubReader.vala"
	_tmp73_ = _tmp72_;
#line 316 "../src/ePubReader.vala"
	if (_tmp73_ < 1) {
#line 3264 "ePubReader.c"
		const gchar* _tmp74_;
		gchar* _tmp75_;
		gchar* _tmp76_;
#line 317 "../src/ePubReader.vala"
		_tmp74_ = bookCoverLocation;
#line 317 "../src/ePubReader.vala"
		_tmp75_ = bookworm_app_utils_fileOperations ("EXISTS", "", _tmp74_, "");
#line 317 "../src/ePubReader.vala"
		_tmp76_ = _tmp75_;
#line 317 "../src/ePubReader.vala"
		_tmp70_ = g_strcmp0 ("true", _tmp76_) == 0;
#line 317 "../src/ePubReader.vala"
		_g_free0 (_tmp76_);
#line 3278 "ePubReader.c"
	} else {
#line 316 "../src/ePubReader.vala"
		_tmp70_ = FALSE;
#line 3282 "ePubReader.c"
	}
#line 316 "../src/ePubReader.vala"
	if (_tmp70_) {
#line 319 "../src/ePubReader.vala"
		count = 0;
#line 3288 "ePubReader.c"
		{
			GeeArrayList* _id_list = NULL;
			GeeArrayList* _tmp77_;
			gpointer _tmp78_;
			BookwormAppXMLData* _tmp79_;
			GeeArrayList* _tmp80_;
			GeeArrayList* _tmp81_;
			gint _id_size = 0;
			GeeArrayList* _tmp82_;
			gint _tmp83_;
			gint _tmp84_;
			gint _id_index = 0;
#line 320 "../src/ePubReader.vala"
			_tmp77_ = opfItemsList;
#line 320 "../src/ePubReader.vala"
			_tmp78_ = gee_abstract_list_get ((GeeAbstractList*) _tmp77_, 0);
#line 320 "../src/ePubReader.vala"
			_tmp79_ = (BookwormAppXMLData*) _tmp78_;
#line 320 "../src/ePubReader.vala"
			_tmp80_ = _tmp79_->extractedTagAttributes;
#line 320 "../src/ePubReader.vala"
			_tmp81_ = _tmp80_;
#line 320 "../src/ePubReader.vala"
			_bookworm_app_xml_data_unref0 (_tmp79_);
#line 320 "../src/ePubReader.vala"
			_id_list = _tmp81_;
#line 320 "../src/ePubReader.vala"
			_tmp82_ = _id_list;
#line 320 "../src/ePubReader.vala"
			_tmp83_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp82_);
#line 320 "../src/ePubReader.vala"
			_tmp84_ = _tmp83_;
#line 320 "../src/ePubReader.vala"
			_id_size = _tmp84_;
#line 320 "../src/ePubReader.vala"
			_id_index = -1;
#line 320 "../src/ePubReader.vala"
			while (TRUE) {
#line 3327 "ePubReader.c"
				gint _tmp85_;
				gint _tmp86_;
				gchar* id = NULL;
				GeeArrayList* _tmp87_;
				gpointer _tmp88_;
				const gchar* _tmp89_;
				gint _tmp106_;
#line 320 "../src/ePubReader.vala"
				_id_index = _id_index + 1;
#line 320 "../src/ePubReader.vala"
				_tmp85_ = _id_index;
#line 320 "../src/ePubReader.vala"
				_tmp86_ = _id_size;
#line 320 "../src/ePubReader.vala"
				if (!(_tmp85_ < _tmp86_)) {
#line 320 "../src/ePubReader.vala"
					break;
#line 3345 "ePubReader.c"
				}
#line 320 "../src/ePubReader.vala"
				_tmp87_ = _id_list;
#line 320 "../src/ePubReader.vala"
				_tmp88_ = gee_abstract_list_get ((GeeAbstractList*) _tmp87_, _id_index);
#line 320 "../src/ePubReader.vala"
				id = (gchar*) _tmp88_;
#line 321 "../src/ePubReader.vala"
				_tmp89_ = id;
#line 321 "../src/ePubReader.vala"
				if (string_contains (_tmp89_, "cover")) {
#line 3357 "ePubReader.c"
					gchar* coverMediaType = NULL;
					GeeArrayList* _tmp90_;
					gpointer _tmp91_;
					BookwormAppXMLData* _tmp92_;
					GeeArrayList* _tmp93_;
					gpointer _tmp94_;
					gchar* _tmp95_;
					const gchar* _tmp96_;
#line 323 "../src/ePubReader.vala"
					_tmp90_ = opfItemsList;
#line 323 "../src/ePubReader.vala"
					_tmp91_ = gee_abstract_list_get ((GeeAbstractList*) _tmp90_, 1);
#line 323 "../src/ePubReader.vala"
					_tmp92_ = (BookwormAppXMLData*) _tmp91_;
#line 323 "../src/ePubReader.vala"
					_tmp93_ = _tmp92_->extractedTagAttributes;
#line 323 "../src/ePubReader.vala"
					_tmp94_ = gee_abstract_list_get ((GeeAbstractList*) _tmp93_, count);
#line 323 "../src/ePubReader.vala"
					_tmp95_ = (gchar*) _tmp94_;
#line 323 "../src/ePubReader.vala"
					_bookworm_app_xml_data_unref0 (_tmp92_);
#line 323 "../src/ePubReader.vala"
					coverMediaType = _tmp95_;
#line 325 "../src/ePubReader.vala"
					_tmp96_ = coverMediaType;
#line 325 "../src/ePubReader.vala"
					if (string_index_of (_tmp96_, "image", 0) != -1) {
#line 3386 "ePubReader.c"
						GeeArrayList* _tmp97_;
						gpointer _tmp98_;
						BookwormAppXMLData* _tmp99_;
						GeeArrayList* _tmp100_;
						gpointer _tmp101_;
						gchar* _tmp102_;
						gchar* _tmp103_;
						const gchar* _tmp104_;
						gchar* _tmp105_;
#line 326 "../src/ePubReader.vala"
						_tmp97_ = opfItemsList;
#line 326 "../src/ePubReader.vala"
						_tmp98_ = gee_abstract_list_get ((GeeAbstractList*) _tmp97_, 2);
#line 326 "../src/ePubReader.vala"
						_tmp99_ = (BookwormAppXMLData*) _tmp98_;
#line 326 "../src/ePubReader.vala"
						_tmp100_ = _tmp99_->extractedTagAttributes;
#line 326 "../src/ePubReader.vala"
						_tmp101_ = gee_abstract_list_get ((GeeAbstractList*) _tmp100_, count);
#line 326 "../src/ePubReader.vala"
						_g_free0 (bookCoverLocation);
#line 326 "../src/ePubReader.vala"
						bookCoverLocation = (gchar*) _tmp101_;
#line 326 "../src/ePubReader.vala"
						_bookworm_app_xml_data_unref0 (_tmp99_);
#line 327 "../src/ePubReader.vala"
						_tmp102_ = bookworm_app_book_getBaseLocationOfContents (aBook);
#line 327 "../src/ePubReader.vala"
						_tmp103_ = _tmp102_;
#line 327 "../src/ePubReader.vala"
						_tmp104_ = bookCoverLocation;
#line 327 "../src/ePubReader.vala"
						_tmp105_ = g_strconcat (_tmp103_, _tmp104_, NULL);
#line 327 "../src/ePubReader.vala"
						_g_free0 (bookCoverLocation);
#line 327 "../src/ePubReader.vala"
						bookCoverLocation = _tmp105_;
#line 327 "../src/ePubReader.vala"
						_g_free0 (_tmp103_);
#line 328 "../src/ePubReader.vala"
						_g_free0 (coverMediaType);
#line 328 "../src/ePubReader.vala"
						_g_free0 (id);
#line 328 "../src/ePubReader.vala"
						break;
#line 3432 "ePubReader.c"
					}
#line 321 "../src/ePubReader.vala"
					_g_free0 (coverMediaType);
#line 3436 "ePubReader.c"
				}
#line 331 "../src/ePubReader.vala"
				_tmp106_ = count;
#line 331 "../src/ePubReader.vala"
				count = _tmp106_ + 1;
#line 320 "../src/ePubReader.vala"
				_g_free0 (id);
#line 3444 "ePubReader.c"
			}
		}
	}
#line 336 "../src/ePubReader.vala"
	_tmp108_ = bookCoverLocation;
#line 336 "../src/ePubReader.vala"
	_tmp109_ = strlen (_tmp108_);
#line 336 "../src/ePubReader.vala"
	_tmp110_ = _tmp109_;
#line 336 "../src/ePubReader.vala"
	if (_tmp110_ < 1) {
#line 3456 "ePubReader.c"
		const gchar* _tmp111_;
		gchar* _tmp112_;
		gchar* _tmp113_;
#line 337 "../src/ePubReader.vala"
		_tmp111_ = bookCoverLocation;
#line 337 "../src/ePubReader.vala"
		_tmp112_ = bookworm_app_utils_fileOperations ("EXISTS", "", _tmp111_, "");
#line 337 "../src/ePubReader.vala"
		_tmp113_ = _tmp112_;
#line 337 "../src/ePubReader.vala"
		_tmp107_ = g_strcmp0 ("true", _tmp113_) == 0;
#line 337 "../src/ePubReader.vala"
		_g_free0 (_tmp113_);
#line 3470 "ePubReader.c"
	} else {
#line 336 "../src/ePubReader.vala"
		_tmp107_ = FALSE;
#line 3474 "ePubReader.c"
	}
#line 336 "../src/ePubReader.vala"
	if (_tmp107_) {
#line 3478 "ePubReader.c"
		gchar* _tmp114_;
		gchar* _tmp115_;
		gchar* _tmp116_;
		gchar* _tmp117_;
#line 339 "../src/ePubReader.vala"
		bookworm_app_book_setIsBookCoverImagePresent (aBook, FALSE);
#line 340 "../src/ePubReader.vala"
		_tmp114_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 340 "../src/ePubReader.vala"
		_tmp115_ = _tmp114_;
#line 340 "../src/ePubReader.vala"
		_tmp116_ = g_strconcat ("Cover image not found for book located at:", _tmp115_, NULL);
#line 340 "../src/ePubReader.vala"
		_tmp117_ = _tmp116_;
#line 340 "../src/ePubReader.vala"
		g_debug ("ePubReader.vala:340: %s", _tmp117_);
#line 340 "../src/ePubReader.vala"
		_g_free0 (_tmp117_);
#line 340 "../src/ePubReader.vala"
		_g_free0 (_tmp115_);
#line 3499 "ePubReader.c"
	} else {
		BookwormAppBook* _tmp118_;
		const gchar* _tmp119_;
		BookwormAppBook* _tmp120_;
#line 343 "../src/ePubReader.vala"
		_tmp118_ = _bookworm_app_book_ref0 (aBook);
#line 343 "../src/ePubReader.vala"
		_tmp119_ = bookCoverLocation;
#line 343 "../src/ePubReader.vala"
		_tmp120_ = bookworm_app_utils_setBookCoverImage (_tmp118_, _tmp119_);
#line 343 "../src/ePubReader.vala"
		_bookworm_app_book_unref0 (aBook);
#line 343 "../src/ePubReader.vala"
		aBook = _tmp120_;
#line 3514 "ePubReader.c"
	}
#line 345 "../src/ePubReader.vala"
	_tmp121_ = bookworm_app_book_getBookLocation (aBook);
#line 345 "../src/ePubReader.vala"
	_tmp122_ = _tmp121_;
#line 345 "../src/ePubReader.vala"
	_tmp123_ = g_strconcat ("[END] [FUNCTION:setCoverImage] book.location=", _tmp122_, NULL);
#line 345 "../src/ePubReader.vala"
	_tmp124_ = _tmp123_;
#line 345 "../src/ePubReader.vala"
	_tmp125_ = g_strconcat (_tmp124_, ", bookCoverLocation=", NULL);
#line 345 "../src/ePubReader.vala"
	_tmp126_ = _tmp125_;
#line 345 "../src/ePubReader.vala"
	_tmp127_ = bookCoverLocation;
#line 345 "../src/ePubReader.vala"
	_tmp128_ = g_strconcat (_tmp126_, _tmp127_, NULL);
#line 345 "../src/ePubReader.vala"
	_tmp129_ = _tmp128_;
#line 345 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:345: %s", _tmp129_);
#line 345 "../src/ePubReader.vala"
	_g_free0 (_tmp129_);
#line 345 "../src/ePubReader.vala"
	_g_free0 (_tmp126_);
#line 345 "../src/ePubReader.vala"
	_g_free0 (_tmp124_);
#line 345 "../src/ePubReader.vala"
	_g_free0 (_tmp122_);
#line 346 "../src/ePubReader.vala"
	_tmp130_ = _bookworm_app_book_ref0 (aBook);
#line 346 "../src/ePubReader.vala"
	result = _tmp130_;
#line 346 "../src/ePubReader.vala"
	_g_object_unref0 (opfItemsList);
#line 346 "../src/ePubReader.vala"
	_bookworm_app_xml_parser_unref0 (thisParser);
#line 346 "../src/ePubReader.vala"
	_g_object_unref0 (inputDataList);
#line 346 "../src/ePubReader.vala"
	_g_free0 (bookCoverLocation);
#line 346 "../src/ePubReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 346 "../src/ePubReader.vala"
	return result;
#line 3560 "ePubReader.c"
}

static gint
string_last_index_of (const gchar* self,
                      const gchar* needle,
                      gint start_index)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint result;
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (self != NULL, 0);
#line 1194 "glib-2.0.vapi"
	g_return_val_if_fail (needle != NULL, 0);
#line 1195 "glib-2.0.vapi"
	_tmp0_ = g_strrstr (((gchar*) self) + start_index, (gchar*) needle);
#line 1195 "glib-2.0.vapi"
	_result_ = _tmp0_;
#line 1197 "glib-2.0.vapi"
	_tmp1_ = _result_;
#line 1197 "glib-2.0.vapi"
	if (_tmp1_ != NULL) {
#line 3584 "ePubReader.c"
		gchar* _tmp2_;
#line 1198 "glib-2.0.vapi"
		_tmp2_ = _result_;
#line 1198 "glib-2.0.vapi"
		result = (gint) (_tmp2_ - ((gchar*) self));
#line 1198 "glib-2.0.vapi"
		return result;
#line 3592 "ePubReader.c"
	} else {
#line 1200 "glib-2.0.vapi"
		result = -1;
#line 1200 "glib-2.0.vapi"
		return result;
#line 3598 "ePubReader.c"
	}
}

BookwormAppBook*
bookworm_app_epub_reader_setBookMetaData (BookwormAppBook* aBook,
                                          const gchar* locationOfOPFFile)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeArrayList* inputDataList = NULL;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	BookwormAppXMLData* _tmp13_ = NULL;
	BookwormAppXMLData* _tmp14_;
	GeeArrayList* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	BookwormAppXMLData* _tmp19_ = NULL;
	BookwormAppXMLData* _tmp20_;
	BookwormAppXmlParser* thisParser = NULL;
	BookwormAppXmlParser* _tmp21_;
	GeeArrayList* opfItemsList = NULL;
	GeeArrayList* _tmp22_;
	BookwormAppXmlParser* _tmp23_;
	GeeArrayList* _tmp24_;
	GeeArrayList* _tmp25_;
	GeeArrayList* _tmp26_;
	GeeArrayList* _tmp27_;
	gpointer _tmp28_;
	BookwormAppXMLData* _tmp29_;
	GeeArrayList* _tmp30_;
	gint _tmp31_;
	gint _tmp32_;
	gboolean _tmp33_;
	GeeArrayList* _tmp70_;
	gpointer _tmp71_;
	BookwormAppXMLData* _tmp72_;
	GeeArrayList* _tmp73_;
	gint _tmp74_;
	gint _tmp75_;
	gboolean _tmp76_;
	BookwormAppBook* _tmp92_;
	BookwormAppBook* result;
#line 349 "../src/ePubReader.vala"
	g_return_val_if_fail (aBook != NULL, NULL);
#line 349 "../src/ePubReader.vala"
	g_return_val_if_fail (locationOfOPFFile != NULL, NULL);
#line 350 "../src/ePubReader.vala"
	_tmp0_ = bookworm_app_book_getBookLocation (aBook);
#line 350 "../src/ePubReader.vala"
	_tmp1_ = _tmp0_;
#line 350 "../src/ePubReader.vala"
	_tmp2_ = g_strconcat ("[START] [FUNCTION:setBookMetaData] book.location=", _tmp1_, NULL);
#line 350 "../src/ePubReader.vala"
	_tmp3_ = _tmp2_;
#line 350 "../src/ePubReader.vala"
	_tmp4_ = g_strconcat (_tmp3_, ", locationOfOPFFile=", NULL);
#line 350 "../src/ePubReader.vala"
	_tmp5_ = _tmp4_;
#line 350 "../src/ePubReader.vala"
	_tmp6_ = g_strconcat (_tmp5_, locationOfOPFFile, NULL);
#line 350 "../src/ePubReader.vala"
	_tmp7_ = _tmp6_;
#line 350 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:350: %s", _tmp7_);
#line 350 "../src/ePubReader.vala"
	_g_free0 (_tmp7_);
#line 350 "../src/ePubReader.vala"
	_g_free0 (_tmp5_);
#line 350 "../src/ePubReader.vala"
	_g_free0 (_tmp3_);
#line 350 "../src/ePubReader.vala"
	_g_free0 (_tmp1_);
#line 352 "../src/ePubReader.vala"
	_tmp8_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 352 "../src/ePubReader.vala"
	inputDataList = _tmp8_;
#line 353 "../src/ePubReader.vala"
	_tmp9_ = inputDataList;
#line 353 "../src/ePubReader.vala"
	_tmp10_ = g_strdup ("");
#line 353 "../src/ePubReader.vala"
	_tmp11_ = g_strdup ("title");
#line 353 "../src/ePubReader.vala"
	_tmp12_ = g_strdup ("");
#line 353 "../src/ePubReader.vala"
	_tmp13_ = bookworm_app_xml_data_new ();
#line 353 "../src/ePubReader.vala"
	_g_free0 (_tmp13_->containerTagName);
#line 353 "../src/ePubReader.vala"
	_tmp13_->containerTagName = _tmp10_;
#line 353 "../src/ePubReader.vala"
	_g_free0 (_tmp13_->inputTagName);
#line 353 "../src/ePubReader.vala"
	_tmp13_->inputTagName = _tmp11_;
#line 353 "../src/ePubReader.vala"
	_g_free0 (_tmp13_->inputAttributeName);
#line 353 "../src/ePubReader.vala"
	_tmp13_->inputAttributeName = _tmp12_;
#line 353 "../src/ePubReader.vala"
	_tmp14_ = _tmp13_;
#line 353 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp14_);
#line 353 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp14_);
#line 358 "../src/ePubReader.vala"
	_tmp15_ = inputDataList;
#line 358 "../src/ePubReader.vala"
	_tmp16_ = g_strdup ("");
#line 358 "../src/ePubReader.vala"
	_tmp17_ = g_strdup ("creator");
#line 358 "../src/ePubReader.vala"
	_tmp18_ = g_strdup ("");
#line 358 "../src/ePubReader.vala"
	_tmp19_ = bookworm_app_xml_data_new ();
#line 358 "../src/ePubReader.vala"
	_g_free0 (_tmp19_->containerTagName);
#line 358 "../src/ePubReader.vala"
	_tmp19_->containerTagName = _tmp16_;
#line 358 "../src/ePubReader.vala"
	_g_free0 (_tmp19_->inputTagName);
#line 358 "../src/ePubReader.vala"
	_tmp19_->inputTagName = _tmp17_;
#line 358 "../src/ePubReader.vala"
	_g_free0 (_tmp19_->inputAttributeName);
#line 358 "../src/ePubReader.vala"
	_tmp19_->inputAttributeName = _tmp18_;
#line 358 "../src/ePubReader.vala"
	_tmp20_ = _tmp19_;
#line 358 "../src/ePubReader.vala"
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp15_, _tmp20_);
#line 358 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp20_);
#line 364 "../src/ePubReader.vala"
	_tmp21_ = bookworm_app_xml_parser_new ();
#line 364 "../src/ePubReader.vala"
	thisParser = _tmp21_;
#line 365 "../src/ePubReader.vala"
	_tmp22_ = gee_array_list_new (BOOKWORM_APP_TYPE_XML_DATA, (GBoxedCopyFunc) bookworm_app_xml_data_ref, (GDestroyNotify) bookworm_app_xml_data_unref, NULL, NULL, NULL);
#line 365 "../src/ePubReader.vala"
	opfItemsList = _tmp22_;
#line 366 "../src/ePubReader.vala"
	_tmp23_ = thisParser;
#line 366 "../src/ePubReader.vala"
	_tmp24_ = inputDataList;
#line 366 "../src/ePubReader.vala"
	_tmp25_ = _g_object_ref0 (_tmp24_);
#line 366 "../src/ePubReader.vala"
	_tmp26_ = bookworm_app_xml_parser_extractDataFromXML (_tmp23_, locationOfOPFFile, _tmp25_, FALSE);
#line 366 "../src/ePubReader.vala"
	_g_object_unref0 (opfItemsList);
#line 366 "../src/ePubReader.vala"
	opfItemsList = _tmp26_;
#line 368 "../src/ePubReader.vala"
	_tmp27_ = opfItemsList;
#line 368 "../src/ePubReader.vala"
	_tmp28_ = gee_abstract_list_get ((GeeAbstractList*) _tmp27_, 0);
#line 368 "../src/ePubReader.vala"
	_tmp29_ = (BookwormAppXMLData*) _tmp28_;
#line 368 "../src/ePubReader.vala"
	_tmp30_ = _tmp29_->extractedTagValues;
#line 368 "../src/ePubReader.vala"
	_tmp31_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp30_);
#line 368 "../src/ePubReader.vala"
	_tmp32_ = _tmp31_;
#line 368 "../src/ePubReader.vala"
	_tmp33_ = _tmp32_ > 0;
#line 368 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp29_);
#line 368 "../src/ePubReader.vala"
	if (_tmp33_) {
#line 3780 "ePubReader.c"
		gchar* bookTitle = NULL;
		GeeArrayList* _tmp34_;
		gpointer _tmp35_;
		BookwormAppXMLData* _tmp36_;
		GeeArrayList* _tmp37_;
		gpointer _tmp38_;
		gchar* _tmp39_;
		const gchar* _tmp40_;
		gint _tmp41_;
		gint _tmp42_;
#line 369 "../src/ePubReader.vala"
		_tmp34_ = opfItemsList;
#line 369 "../src/ePubReader.vala"
		_tmp35_ = gee_abstract_list_get ((GeeAbstractList*) _tmp34_, 0);
#line 369 "../src/ePubReader.vala"
		_tmp36_ = (BookwormAppXMLData*) _tmp35_;
#line 369 "../src/ePubReader.vala"
		_tmp37_ = _tmp36_->extractedTagValues;
#line 369 "../src/ePubReader.vala"
		_tmp38_ = gee_abstract_list_get ((GeeAbstractList*) _tmp37_, 0);
#line 369 "../src/ePubReader.vala"
		_tmp39_ = (gchar*) _tmp38_;
#line 369 "../src/ePubReader.vala"
		_bookworm_app_xml_data_unref0 (_tmp36_);
#line 369 "../src/ePubReader.vala"
		bookTitle = _tmp39_;
#line 370 "../src/ePubReader.vala"
		_tmp40_ = bookTitle;
#line 370 "../src/ePubReader.vala"
		_tmp41_ = strlen (_tmp40_);
#line 370 "../src/ePubReader.vala"
		_tmp42_ = _tmp41_;
#line 370 "../src/ePubReader.vala"
		if (_tmp42_ > 0) {
#line 3815 "ePubReader.c"
			const gchar* _tmp43_;
			gchar* _tmp44_;
			gchar* _tmp45_;
			const gchar* _tmp46_;
			gchar* _tmp47_;
			gchar* _tmp48_;
#line 371 "../src/ePubReader.vala"
			_tmp43_ = bookTitle;
#line 371 "../src/ePubReader.vala"
			_tmp44_ = bookworm_app_utils_decodeHTMLChars (_tmp43_);
#line 371 "../src/ePubReader.vala"
			_tmp45_ = _tmp44_;
#line 371 "../src/ePubReader.vala"
			bookworm_app_book_setBookTitle (aBook, _tmp45_);
#line 371 "../src/ePubReader.vala"
			_g_free0 (_tmp45_);
#line 372 "../src/ePubReader.vala"
			_tmp46_ = bookTitle;
#line 372 "../src/ePubReader.vala"
			_tmp47_ = g_strconcat ("Determined eBook Title as:", _tmp46_, NULL);
#line 372 "../src/ePubReader.vala"
			_tmp48_ = _tmp47_;
#line 372 "../src/ePubReader.vala"
			g_debug ("ePubReader.vala:372: %s", _tmp48_);
#line 372 "../src/ePubReader.vala"
			_g_free0 (_tmp48_);
#line 3842 "ePubReader.c"
		} else {
			gboolean _tmp49_ = FALSE;
			gchar* _tmp50_;
			gchar* _tmp51_;
			gboolean _tmp52_;
#line 375 "../src/ePubReader.vala"
			_tmp50_ = bookworm_app_book_getBookTitle (aBook);
#line 375 "../src/ePubReader.vala"
			_tmp51_ = _tmp50_;
#line 375 "../src/ePubReader.vala"
			_tmp52_ = _tmp51_ != NULL;
#line 375 "../src/ePubReader.vala"
			_g_free0 (_tmp51_);
#line 375 "../src/ePubReader.vala"
			if (_tmp52_) {
#line 3858 "ePubReader.c"
				gchar* _tmp53_;
				gchar* _tmp54_;
				gint _tmp55_;
				gint _tmp56_;
#line 375 "../src/ePubReader.vala"
				_tmp53_ = bookworm_app_book_getBookTitle (aBook);
#line 375 "../src/ePubReader.vala"
				_tmp54_ = _tmp53_;
#line 375 "../src/ePubReader.vala"
				_tmp55_ = strlen (_tmp54_);
#line 375 "../src/ePubReader.vala"
				_tmp56_ = _tmp55_;
#line 375 "../src/ePubReader.vala"
				_tmp49_ = _tmp56_ < 1;
#line 375 "../src/ePubReader.vala"
				_g_free0 (_tmp54_);
#line 3875 "ePubReader.c"
			} else {
#line 375 "../src/ePubReader.vala"
				_tmp49_ = FALSE;
#line 3879 "ePubReader.c"
			}
#line 375 "../src/ePubReader.vala"
			if (_tmp49_) {
#line 3883 "ePubReader.c"
				gchar* _tmp57_;
				gchar* _tmp58_;
				GFile* _tmp59_;
				GFile* _tmp60_;
				gchar* _tmp61_;
				const gchar* _tmp62_;
				const gchar* _tmp66_;
				const gchar* _tmp67_;
				gchar* _tmp68_;
				gchar* _tmp69_;
#line 376 "../src/ePubReader.vala"
				_tmp57_ = bookworm_app_book_getBookExtractionLocation (aBook);
#line 376 "../src/ePubReader.vala"
				_tmp58_ = _tmp57_;
#line 376 "../src/ePubReader.vala"
				_tmp59_ = g_file_new_for_path (_tmp58_);
#line 376 "../src/ePubReader.vala"
				_tmp60_ = _tmp59_;
#line 376 "../src/ePubReader.vala"
				_tmp61_ = g_file_get_basename (_tmp60_);
#line 376 "../src/ePubReader.vala"
				_g_free0 (bookTitle);
#line 376 "../src/ePubReader.vala"
				bookTitle = _tmp61_;
#line 376 "../src/ePubReader.vala"
				_g_object_unref0 (_tmp60_);
#line 376 "../src/ePubReader.vala"
				_g_free0 (_tmp58_);
#line 377 "../src/ePubReader.vala"
				_tmp62_ = bookTitle;
#line 377 "../src/ePubReader.vala"
				if (string_last_index_of (_tmp62_, ".", 0) != -1) {
#line 3916 "ePubReader.c"
					const gchar* _tmp63_;
					const gchar* _tmp64_;
					gchar* _tmp65_;
#line 378 "../src/ePubReader.vala"
					_tmp63_ = bookTitle;
#line 378 "../src/ePubReader.vala"
					_tmp64_ = bookTitle;
#line 378 "../src/ePubReader.vala"
					_tmp65_ = string_slice (_tmp63_, (glong) 0, (glong) string_last_index_of (_tmp64_, ".", 0));
#line 378 "../src/ePubReader.vala"
					_g_free0 (bookTitle);
#line 378 "../src/ePubReader.vala"
					bookTitle = _tmp65_;
#line 3930 "ePubReader.c"
				}
#line 380 "../src/ePubReader.vala"
				_tmp66_ = bookTitle;
#line 380 "../src/ePubReader.vala"
				bookworm_app_book_setBookTitle (aBook, _tmp66_);
#line 381 "../src/ePubReader.vala"
				_tmp67_ = bookTitle;
#line 381 "../src/ePubReader.vala"
				_tmp68_ = g_strconcat ("File name set as Title:", _tmp67_, NULL);
#line 381 "../src/ePubReader.vala"
				_tmp69_ = _tmp68_;
#line 381 "../src/ePubReader.vala"
				g_debug ("ePubReader.vala:381: %s", _tmp69_);
#line 381 "../src/ePubReader.vala"
				_g_free0 (_tmp69_);
#line 3946 "ePubReader.c"
			}
		}
#line 368 "../src/ePubReader.vala"
		_g_free0 (bookTitle);
#line 3951 "ePubReader.c"
	}
#line 387 "../src/ePubReader.vala"
	_tmp70_ = opfItemsList;
#line 387 "../src/ePubReader.vala"
	_tmp71_ = gee_abstract_list_get ((GeeAbstractList*) _tmp70_, 1);
#line 387 "../src/ePubReader.vala"
	_tmp72_ = (BookwormAppXMLData*) _tmp71_;
#line 387 "../src/ePubReader.vala"
	_tmp73_ = _tmp72_->extractedTagValues;
#line 387 "../src/ePubReader.vala"
	_tmp74_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp73_);
#line 387 "../src/ePubReader.vala"
	_tmp75_ = _tmp74_;
#line 387 "../src/ePubReader.vala"
	_tmp76_ = _tmp75_ > 0;
#line 387 "../src/ePubReader.vala"
	_bookworm_app_xml_data_unref0 (_tmp72_);
#line 387 "../src/ePubReader.vala"
	if (_tmp76_) {
#line 3971 "ePubReader.c"
		gchar* bookAuthor = NULL;
		GeeArrayList* _tmp77_;
		gpointer _tmp78_;
		BookwormAppXMLData* _tmp79_;
		GeeArrayList* _tmp80_;
		gpointer _tmp81_;
		gchar* _tmp82_;
		const gchar* _tmp83_;
		gint _tmp84_;
		gint _tmp85_;
#line 388 "../src/ePubReader.vala"
		_tmp77_ = opfItemsList;
#line 388 "../src/ePubReader.vala"
		_tmp78_ = gee_abstract_list_get ((GeeAbstractList*) _tmp77_, 1);
#line 388 "../src/ePubReader.vala"
		_tmp79_ = (BookwormAppXMLData*) _tmp78_;
#line 388 "../src/ePubReader.vala"
		_tmp80_ = _tmp79_->extractedTagValues;
#line 388 "../src/ePubReader.vala"
		_tmp81_ = gee_abstract_list_get ((GeeAbstractList*) _tmp80_, 0);
#line 388 "../src/ePubReader.vala"
		_tmp82_ = (gchar*) _tmp81_;
#line 388 "../src/ePubReader.vala"
		_bookworm_app_xml_data_unref0 (_tmp79_);
#line 388 "../src/ePubReader.vala"
		bookAuthor = _tmp82_;
#line 389 "../src/ePubReader.vala"
		_tmp83_ = bookAuthor;
#line 389 "../src/ePubReader.vala"
		_tmp84_ = strlen (_tmp83_);
#line 389 "../src/ePubReader.vala"
		_tmp85_ = _tmp84_;
#line 389 "../src/ePubReader.vala"
		if (_tmp85_ > 0) {
#line 4006 "ePubReader.c"
			const gchar* _tmp86_;
			gchar* _tmp87_;
			gchar* _tmp88_;
			const gchar* _tmp89_;
			gchar* _tmp90_;
			gchar* _tmp91_;
#line 390 "../src/ePubReader.vala"
			_tmp86_ = bookAuthor;
#line 390 "../src/ePubReader.vala"
			_tmp87_ = bookworm_app_utils_decodeHTMLChars (_tmp86_);
#line 390 "../src/ePubReader.vala"
			_tmp88_ = _tmp87_;
#line 390 "../src/ePubReader.vala"
			bookworm_app_book_setBookAuthor (aBook, _tmp88_);
#line 390 "../src/ePubReader.vala"
			_g_free0 (_tmp88_);
#line 391 "../src/ePubReader.vala"
			_tmp89_ = bookAuthor;
#line 391 "../src/ePubReader.vala"
			_tmp90_ = g_strconcat ("Determined eBook Author as:", _tmp89_, NULL);
#line 391 "../src/ePubReader.vala"
			_tmp91_ = _tmp90_;
#line 391 "../src/ePubReader.vala"
			g_debug ("ePubReader.vala:391: %s", _tmp91_);
#line 391 "../src/ePubReader.vala"
			_g_free0 (_tmp91_);
#line 4033 "ePubReader.c"
		} else {
#line 394 "../src/ePubReader.vala"
			bookworm_app_book_setBookAuthor (aBook, BOOKWORM_APP_CONSTANTS_TEXT_FOR_UNKNOWN_TITLE);
#line 395 "../src/ePubReader.vala"
			g_debug ("ePubReader.vala:395: Could not determine eBook Author, default Author " \
"set");
#line 4039 "ePubReader.c"
		}
#line 387 "../src/ePubReader.vala"
		_g_free0 (bookAuthor);
#line 4043 "ePubReader.c"
	}
#line 398 "../src/ePubReader.vala"
	g_info ("ePubReader.vala:398: [END] [FUNCTION:setBookMetaData]");
#line 399 "../src/ePubReader.vala"
	_tmp92_ = _bookworm_app_book_ref0 (aBook);
#line 399 "../src/ePubReader.vala"
	result = _tmp92_;
#line 399 "../src/ePubReader.vala"
	_g_object_unref0 (opfItemsList);
#line 399 "../src/ePubReader.vala"
	_bookworm_app_xml_parser_unref0 (thisParser);
#line 399 "../src/ePubReader.vala"
	_g_object_unref0 (inputDataList);
#line 399 "../src/ePubReader.vala"
	_bookworm_app_book_unref0 (aBook);
#line 399 "../src/ePubReader.vala"
	return result;
#line 4061 "ePubReader.c"
}

BookwormAppePubReader*
bookworm_app_epub_reader_construct (GType object_type)
{
	BookwormAppePubReader* self = NULL;
#line 20 "../src/ePubReader.vala"
	self = (BookwormAppePubReader*) g_type_create_instance (object_type);
#line 20 "../src/ePubReader.vala"
	return self;
#line 4072 "ePubReader.c"
}

BookwormAppePubReader*
bookworm_app_epub_reader_new (void)
{
#line 20 "../src/ePubReader.vala"
	return bookworm_app_epub_reader_construct (BOOKWORM_APP_TYPE_EPUB_READER);
#line 4080 "ePubReader.c"
}

static void
bookworm_app_value_epub_reader_init (GValue* value)
{
#line 20 "../src/ePubReader.vala"
	value->data[0].v_pointer = NULL;
#line 4088 "ePubReader.c"
}

static void
bookworm_app_value_epub_reader_free_value (GValue* value)
{
#line 20 "../src/ePubReader.vala"
	if (value->data[0].v_pointer) {
#line 20 "../src/ePubReader.vala"
		bookworm_app_epub_reader_unref (value->data[0].v_pointer);
#line 4098 "ePubReader.c"
	}
}

static void
bookworm_app_value_epub_reader_copy_value (const GValue* src_value,
                                           GValue* dest_value)
{
#line 20 "../src/ePubReader.vala"
	if (src_value->data[0].v_pointer) {
#line 20 "../src/ePubReader.vala"
		dest_value->data[0].v_pointer = bookworm_app_epub_reader_ref (src_value->data[0].v_pointer);
#line 4110 "ePubReader.c"
	} else {
#line 20 "../src/ePubReader.vala"
		dest_value->data[0].v_pointer = NULL;
#line 4114 "ePubReader.c"
	}
}

static gpointer
bookworm_app_value_epub_reader_peek_pointer (const GValue* value)
{
#line 20 "../src/ePubReader.vala"
	return value->data[0].v_pointer;
#line 4123 "ePubReader.c"
}

static gchar*
bookworm_app_value_epub_reader_collect_value (GValue* value,
                                              guint n_collect_values,
                                              GTypeCValue* collect_values,
                                              guint collect_flags)
{
#line 20 "../src/ePubReader.vala"
	if (collect_values[0].v_pointer) {
#line 4134 "ePubReader.c"
		BookwormAppePubReader * object;
		object = collect_values[0].v_pointer;
#line 20 "../src/ePubReader.vala"
		if (object->parent_instance.g_class == NULL) {
#line 20 "../src/ePubReader.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4141 "ePubReader.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 20 "../src/ePubReader.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 4145 "ePubReader.c"
		}
#line 20 "../src/ePubReader.vala"
		value->data[0].v_pointer = bookworm_app_epub_reader_ref (object);
#line 4149 "ePubReader.c"
	} else {
#line 20 "../src/ePubReader.vala"
		value->data[0].v_pointer = NULL;
#line 4153 "ePubReader.c"
	}
#line 20 "../src/ePubReader.vala"
	return NULL;
#line 4157 "ePubReader.c"
}

static gchar*
bookworm_app_value_epub_reader_lcopy_value (const GValue* value,
                                            guint n_collect_values,
                                            GTypeCValue* collect_values,
                                            guint collect_flags)
{
	BookwormAppePubReader ** object_p;
	object_p = collect_values[0].v_pointer;
#line 20 "../src/ePubReader.vala"
	if (!object_p) {
#line 20 "../src/ePubReader.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 4172 "ePubReader.c"
	}
#line 20 "../src/ePubReader.vala"
	if (!value->data[0].v_pointer) {
#line 20 "../src/ePubReader.vala"
		*object_p = NULL;
#line 4178 "ePubReader.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 20 "../src/ePubReader.vala"
		*object_p = value->data[0].v_pointer;
#line 4182 "ePubReader.c"
	} else {
#line 20 "../src/ePubReader.vala"
		*object_p = bookworm_app_epub_reader_ref (value->data[0].v_pointer);
#line 4186 "ePubReader.c"
	}
#line 20 "../src/ePubReader.vala"
	return NULL;
#line 4190 "ePubReader.c"
}

GParamSpec*
bookworm_app_param_spec_epub_reader (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags)
{
	BookwormAppParamSpecePubReader* spec;
#line 20 "../src/ePubReader.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOOKWORM_APP_TYPE_EPUB_READER), NULL);
#line 20 "../src/ePubReader.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 20 "../src/ePubReader.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 20 "../src/ePubReader.vala"
	return G_PARAM_SPEC (spec);
#line 4209 "ePubReader.c"
}

gpointer
bookworm_app_value_get_epub_reader (const GValue* value)
{
#line 20 "../src/ePubReader.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_EPUB_READER), NULL);
#line 20 "../src/ePubReader.vala"
	return value->data[0].v_pointer;
#line 4219 "ePubReader.c"
}

void
bookworm_app_value_set_epub_reader (GValue* value,
                                    gpointer v_object)
{
	BookwormAppePubReader * old;
#line 20 "../src/ePubReader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_EPUB_READER));
#line 20 "../src/ePubReader.vala"
	old = value->data[0].v_pointer;
#line 20 "../src/ePubReader.vala"
	if (v_object) {
#line 20 "../src/ePubReader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_EPUB_READER));
#line 20 "../src/ePubReader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "../src/ePubReader.vala"
		value->data[0].v_pointer = v_object;
#line 20 "../src/ePubReader.vala"
		bookworm_app_epub_reader_ref (value->data[0].v_pointer);
#line 4241 "ePubReader.c"
	} else {
#line 20 "../src/ePubReader.vala"
		value->data[0].v_pointer = NULL;
#line 4245 "ePubReader.c"
	}
#line 20 "../src/ePubReader.vala"
	if (old) {
#line 20 "../src/ePubReader.vala"
		bookworm_app_epub_reader_unref (old);
#line 4251 "ePubReader.c"
	}
}

void
bookworm_app_value_take_epub_reader (GValue* value,
                                     gpointer v_object)
{
	BookwormAppePubReader * old;
#line 20 "../src/ePubReader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOOKWORM_APP_TYPE_EPUB_READER));
#line 20 "../src/ePubReader.vala"
	old = value->data[0].v_pointer;
#line 20 "../src/ePubReader.vala"
	if (v_object) {
#line 20 "../src/ePubReader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOOKWORM_APP_TYPE_EPUB_READER));
#line 20 "../src/ePubReader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 20 "../src/ePubReader.vala"
		value->data[0].v_pointer = v_object;
#line 4272 "ePubReader.c"
	} else {
#line 20 "../src/ePubReader.vala"
		value->data[0].v_pointer = NULL;
#line 4276 "ePubReader.c"
	}
#line 20 "../src/ePubReader.vala"
	if (old) {
#line 20 "../src/ePubReader.vala"
		bookworm_app_epub_reader_unref (old);
#line 4282 "ePubReader.c"
	}
}

static void
bookworm_app_epub_reader_class_init (BookwormAppePubReaderClass * klass,
                                     gpointer klass_data)
{
	gchar* _tmp0_;
#line 20 "../src/ePubReader.vala"
	bookworm_app_epub_reader_parent_class = g_type_class_peek_parent (klass);
#line 20 "../src/ePubReader.vala"
	((BookwormAppePubReaderClass *) klass)->finalize = bookworm_app_epub_reader_finalize;
#line 21 "../src/ePubReader.vala"
	_tmp0_ = g_strdup ("");
#line 21 "../src/ePubReader.vala"
	bookworm_app_epub_reader_NCXRefInSpineData = _tmp0_;
#line 4299 "ePubReader.c"
}

static void
bookworm_app_epub_reader_instance_init (BookwormAppePubReader * self,
                                        gpointer klass)
{
#line 20 "../src/ePubReader.vala"
	self->ref_count = 1;
#line 4308 "ePubReader.c"
}

static void
bookworm_app_epub_reader_finalize (BookwormAppePubReader * obj)
{
	BookwormAppePubReader * self;
#line 20 "../src/ePubReader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOOKWORM_APP_TYPE_EPUB_READER, BookwormAppePubReader);
#line 20 "../src/ePubReader.vala"
	g_signal_handlers_destroy (self);
#line 4319 "ePubReader.c"
}

static GType
bookworm_app_epub_reader_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { bookworm_app_value_epub_reader_init, bookworm_app_value_epub_reader_free_value, bookworm_app_value_epub_reader_copy_value, bookworm_app_value_epub_reader_peek_pointer, "p", bookworm_app_value_epub_reader_collect_value, "p", bookworm_app_value_epub_reader_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BookwormAppePubReaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bookworm_app_epub_reader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BookwormAppePubReader), 0, (GInstanceInitFunc) bookworm_app_epub_reader_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType bookworm_app_epub_reader_type_id;
	bookworm_app_epub_reader_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BookwormAppePubReader", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return bookworm_app_epub_reader_type_id;
}

GType
bookworm_app_epub_reader_get_type (void)
{
	static volatile gsize bookworm_app_epub_reader_type_id__once = 0;
	if (g_once_init_enter (&bookworm_app_epub_reader_type_id__once)) {
		GType bookworm_app_epub_reader_type_id;
		bookworm_app_epub_reader_type_id = bookworm_app_epub_reader_get_type_once ();
		g_once_init_leave (&bookworm_app_epub_reader_type_id__once, bookworm_app_epub_reader_type_id);
	}
	return bookworm_app_epub_reader_type_id__once;
}

gpointer
bookworm_app_epub_reader_ref (gpointer instance)
{
	BookwormAppePubReader * self;
	self = instance;
#line 20 "../src/ePubReader.vala"
	g_atomic_int_inc (&self->ref_count);
#line 20 "../src/ePubReader.vala"
	return instance;
#line 4354 "ePubReader.c"
}

void
bookworm_app_epub_reader_unref (gpointer instance)
{
	BookwormAppePubReader * self;
	self = instance;
#line 20 "../src/ePubReader.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 20 "../src/ePubReader.vala"
		BOOKWORM_APP_EPUB_READER_GET_CLASS (self)->finalize (self);
#line 20 "../src/ePubReader.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 4368 "ePubReader.c"
	}
}

