// Copyright 2020-2025 Buf Technologies, Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.11
// 	protoc        (unknown)
// source: buf/alpha/registry/v1alpha1/display.proto

package registryv1alpha1

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type DisplayOrganizationElementsRequest struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OrganizationId string                 `protobuf:"bytes,1,opt,name=organization_id,json=organizationId,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *DisplayOrganizationElementsRequest) Reset() {
	*x = DisplayOrganizationElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayOrganizationElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayOrganizationElementsRequest) ProtoMessage() {}

func (x *DisplayOrganizationElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayOrganizationElementsRequest) GetOrganizationId() string {
	if x != nil {
		return x.xxx_hidden_OrganizationId
	}
	return ""
}

func (x *DisplayOrganizationElementsRequest) SetOrganizationId(v string) {
	x.xxx_hidden_OrganizationId = v
}

type DisplayOrganizationElementsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the organization for which to check
	// which elements should be displayed.
	OrganizationId string
}

func (b0 DisplayOrganizationElementsRequest_builder) Build() *DisplayOrganizationElementsRequest {
	m0 := &DisplayOrganizationElementsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OrganizationId = b.OrganizationId
	return m0
}

type DisplayOrganizationElementsResponse struct {
	state                       protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_CreateRepository bool                   `protobuf:"varint,1,opt,name=create_repository,json=createRepository,proto3"`
	xxx_hidden_Settings         bool                   `protobuf:"varint,4,opt,name=settings,proto3"`
	xxx_hidden_UpdateSettings   bool                   `protobuf:"varint,5,opt,name=update_settings,json=updateSettings,proto3"`
	xxx_hidden_Delete           bool                   `protobuf:"varint,6,opt,name=delete,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *DisplayOrganizationElementsResponse) Reset() {
	*x = DisplayOrganizationElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayOrganizationElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayOrganizationElementsResponse) ProtoMessage() {}

func (x *DisplayOrganizationElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayOrganizationElementsResponse) GetCreateRepository() bool {
	if x != nil {
		return x.xxx_hidden_CreateRepository
	}
	return false
}

func (x *DisplayOrganizationElementsResponse) GetSettings() bool {
	if x != nil {
		return x.xxx_hidden_Settings
	}
	return false
}

func (x *DisplayOrganizationElementsResponse) GetUpdateSettings() bool {
	if x != nil {
		return x.xxx_hidden_UpdateSettings
	}
	return false
}

func (x *DisplayOrganizationElementsResponse) GetDelete() bool {
	if x != nil {
		return x.xxx_hidden_Delete
	}
	return false
}

func (x *DisplayOrganizationElementsResponse) SetCreateRepository(v bool) {
	x.xxx_hidden_CreateRepository = v
}

func (x *DisplayOrganizationElementsResponse) SetSettings(v bool) {
	x.xxx_hidden_Settings = v
}

func (x *DisplayOrganizationElementsResponse) SetUpdateSettings(v bool) {
	x.xxx_hidden_UpdateSettings = v
}

func (x *DisplayOrganizationElementsResponse) SetDelete(v bool) {
	x.xxx_hidden_Delete = v
}

type DisplayOrganizationElementsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Display create organization repository element if true.
	CreateRepository bool
	// Display organization settings element if true.
	Settings bool
	// Display update organization settings element if true.
	UpdateSettings bool
	// Display delete organization element if true.
	Delete bool
}

func (b0 DisplayOrganizationElementsResponse_builder) Build() *DisplayOrganizationElementsResponse {
	m0 := &DisplayOrganizationElementsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_CreateRepository = b.CreateRepository
	x.xxx_hidden_Settings = b.Settings
	x.xxx_hidden_UpdateSettings = b.UpdateSettings
	x.xxx_hidden_Delete = b.Delete
	return m0
}

type DisplayRepositoryElementsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *DisplayRepositoryElementsRequest) Reset() {
	*x = DisplayRepositoryElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayRepositoryElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayRepositoryElementsRequest) ProtoMessage() {}

func (x *DisplayRepositoryElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayRepositoryElementsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *DisplayRepositoryElementsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type DisplayRepositoryElementsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// which elements should be displayed.
	RepositoryId string
}

func (b0 DisplayRepositoryElementsRequest_builder) Build() *DisplayRepositoryElementsRequest {
	m0 := &DisplayRepositoryElementsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type DisplayRepositoryElementsResponse struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Settings     bool                   `protobuf:"varint,1,opt,name=settings,proto3"`
	xxx_hidden_Delete       bool                   `protobuf:"varint,2,opt,name=delete,proto3"`
	xxx_hidden_Write        bool                   `protobuf:"varint,3,opt,name=write,proto3"`
	xxx_hidden_LimitedWrite bool                   `protobuf:"varint,4,opt,name=limited_write,json=limitedWrite,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *DisplayRepositoryElementsResponse) Reset() {
	*x = DisplayRepositoryElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayRepositoryElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayRepositoryElementsResponse) ProtoMessage() {}

func (x *DisplayRepositoryElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayRepositoryElementsResponse) GetSettings() bool {
	if x != nil {
		return x.xxx_hidden_Settings
	}
	return false
}

func (x *DisplayRepositoryElementsResponse) GetDelete() bool {
	if x != nil {
		return x.xxx_hidden_Delete
	}
	return false
}

func (x *DisplayRepositoryElementsResponse) GetWrite() bool {
	if x != nil {
		return x.xxx_hidden_Write
	}
	return false
}

func (x *DisplayRepositoryElementsResponse) GetLimitedWrite() bool {
	if x != nil {
		return x.xxx_hidden_LimitedWrite
	}
	return false
}

func (x *DisplayRepositoryElementsResponse) SetSettings(v bool) {
	x.xxx_hidden_Settings = v
}

func (x *DisplayRepositoryElementsResponse) SetDelete(v bool) {
	x.xxx_hidden_Delete = v
}

func (x *DisplayRepositoryElementsResponse) SetWrite(v bool) {
	x.xxx_hidden_Write = v
}

func (x *DisplayRepositoryElementsResponse) SetLimitedWrite(v bool) {
	x.xxx_hidden_LimitedWrite = v
}

type DisplayRepositoryElementsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Display repository settings element if true.
	Settings bool
	// Display delete repository element if true.
	Delete bool
	// Display write repository elements if true. It includes all elements from limited_write.
	Write bool
	// Display limited_write repository elements if true. This is a subset of write elements.
	LimitedWrite bool
}

func (b0 DisplayRepositoryElementsResponse_builder) Build() *DisplayRepositoryElementsResponse {
	m0 := &DisplayRepositoryElementsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Settings = b.Settings
	x.xxx_hidden_Delete = b.Delete
	x.xxx_hidden_Write = b.Write
	x.xxx_hidden_LimitedWrite = b.LimitedWrite
	return m0
}

type DisplayPluginElementsRequest struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_PluginId string                 `protobuf:"bytes,1,opt,name=plugin_id,json=pluginId,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *DisplayPluginElementsRequest) Reset() {
	*x = DisplayPluginElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayPluginElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayPluginElementsRequest) ProtoMessage() {}

func (x *DisplayPluginElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayPluginElementsRequest) GetPluginId() string {
	if x != nil {
		return x.xxx_hidden_PluginId
	}
	return ""
}

func (x *DisplayPluginElementsRequest) SetPluginId(v string) {
	x.xxx_hidden_PluginId = v
}

type DisplayPluginElementsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the plugin for which to check
	// which elements should be displayed.
	PluginId string
}

func (b0 DisplayPluginElementsRequest_builder) Build() *DisplayPluginElementsRequest {
	m0 := &DisplayPluginElementsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_PluginId = b.PluginId
	return m0
}

type DisplayPluginElementsResponse struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Settings bool                   `protobuf:"varint,1,opt,name=settings,proto3"`
	xxx_hidden_Delete   bool                   `protobuf:"varint,2,opt,name=delete,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *DisplayPluginElementsResponse) Reset() {
	*x = DisplayPluginElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayPluginElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayPluginElementsResponse) ProtoMessage() {}

func (x *DisplayPluginElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayPluginElementsResponse) GetSettings() bool {
	if x != nil {
		return x.xxx_hidden_Settings
	}
	return false
}

func (x *DisplayPluginElementsResponse) GetDelete() bool {
	if x != nil {
		return x.xxx_hidden_Delete
	}
	return false
}

func (x *DisplayPluginElementsResponse) SetSettings(v bool) {
	x.xxx_hidden_Settings = v
}

func (x *DisplayPluginElementsResponse) SetDelete(v bool) {
	x.xxx_hidden_Delete = v
}

type DisplayPluginElementsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Display plugin settings element if true.
	Settings bool
	// Display delete plugin element if true.
	Delete bool
}

func (b0 DisplayPluginElementsResponse_builder) Build() *DisplayPluginElementsResponse {
	m0 := &DisplayPluginElementsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Settings = b.Settings
	x.xxx_hidden_Delete = b.Delete
	return m0
}

type DisplayUserElementsRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DisplayUserElementsRequest) Reset() {
	*x = DisplayUserElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayUserElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayUserElementsRequest) ProtoMessage() {}

func (x *DisplayUserElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DisplayUserElementsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DisplayUserElementsRequest_builder) Build() *DisplayUserElementsRequest {
	m0 := &DisplayUserElementsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type DisplayUserElementsResponse struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Delete bool                   `protobuf:"varint,1,opt,name=delete,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *DisplayUserElementsResponse) Reset() {
	*x = DisplayUserElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayUserElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayUserElementsResponse) ProtoMessage() {}

func (x *DisplayUserElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayUserElementsResponse) GetDelete() bool {
	if x != nil {
		return x.xxx_hidden_Delete
	}
	return false
}

func (x *DisplayUserElementsResponse) SetDelete(v bool) {
	x.xxx_hidden_Delete = v
}

type DisplayUserElementsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Display delete user element if true.
	Delete bool
}

func (b0 DisplayUserElementsResponse_builder) Build() *DisplayUserElementsResponse {
	m0 := &DisplayUserElementsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Delete = b.Delete
	return m0
}

type DisplayServerElementsRequest struct {
	state         protoimpl.MessageState `protogen:"opaque.v1"`
	unknownFields protoimpl.UnknownFields
	sizeCache     protoimpl.SizeCache
}

func (x *DisplayServerElementsRequest) Reset() {
	*x = DisplayServerElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayServerElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayServerElementsRequest) ProtoMessage() {}

func (x *DisplayServerElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

type DisplayServerElementsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

}

func (b0 DisplayServerElementsRequest_builder) Build() *DisplayServerElementsRequest {
	m0 := &DisplayServerElementsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	return m0
}

type DisplayServerElementsResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_AdminPanel bool                   `protobuf:"varint,1,opt,name=admin_panel,json=adminPanel,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *DisplayServerElementsResponse) Reset() {
	*x = DisplayServerElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayServerElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayServerElementsResponse) ProtoMessage() {}

func (x *DisplayServerElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayServerElementsResponse) GetAdminPanel() bool {
	if x != nil {
		return x.xxx_hidden_AdminPanel
	}
	return false
}

func (x *DisplayServerElementsResponse) SetAdminPanel(v bool) {
	x.xxx_hidden_AdminPanel = v
}

type DisplayServerElementsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Display server admin panel element if true.
	AdminPanel bool
}

func (b0 DisplayServerElementsResponse_builder) Build() *DisplayServerElementsResponse {
	m0 := &DisplayServerElementsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_AdminPanel = b.AdminPanel
	return m0
}

type DisplayOwnerEntitledElementsRequest struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_OwnerName string                 `protobuf:"bytes,1,opt,name=owner_name,json=ownerName,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *DisplayOwnerEntitledElementsRequest) Reset() {
	*x = DisplayOwnerEntitledElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayOwnerEntitledElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayOwnerEntitledElementsRequest) ProtoMessage() {}

func (x *DisplayOwnerEntitledElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayOwnerEntitledElementsRequest) GetOwnerName() string {
	if x != nil {
		return x.xxx_hidden_OwnerName
	}
	return ""
}

func (x *DisplayOwnerEntitledElementsRequest) SetOwnerName(v string) {
	x.xxx_hidden_OwnerName = v
}

type DisplayOwnerEntitledElementsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The name of the owner for which to check
	// which elements are entitled to be displayed.
	OwnerName string
}

func (b0 DisplayOwnerEntitledElementsRequest_builder) Build() *DisplayOwnerEntitledElementsRequest {
	m0 := &DisplayOwnerEntitledElementsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_OwnerName = b.OwnerName
	return m0
}

type DisplayOwnerEntitledElementsResponse struct {
	state                              protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_CreatePrivateRepository bool                   `protobuf:"varint,1,opt,name=create_private_repository,json=createPrivateRepository,proto3"`
	unknownFields                      protoimpl.UnknownFields
	sizeCache                          protoimpl.SizeCache
}

func (x *DisplayOwnerEntitledElementsResponse) Reset() {
	*x = DisplayOwnerEntitledElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayOwnerEntitledElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayOwnerEntitledElementsResponse) ProtoMessage() {}

func (x *DisplayOwnerEntitledElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayOwnerEntitledElementsResponse) GetCreatePrivateRepository() bool {
	if x != nil {
		return x.xxx_hidden_CreatePrivateRepository
	}
	return false
}

func (x *DisplayOwnerEntitledElementsResponse) SetCreatePrivateRepository(v bool) {
	x.xxx_hidden_CreatePrivateRepository = v
}

type DisplayOwnerEntitledElementsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Display create private repository element if true.
	CreatePrivateRepository bool
}

func (b0 DisplayOwnerEntitledElementsResponse_builder) Build() *DisplayOwnerEntitledElementsResponse {
	m0 := &DisplayOwnerEntitledElementsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_CreatePrivateRepository = b.CreatePrivateRepository
	return m0
}

type DisplayRepositoryEntitledElementsRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *DisplayRepositoryEntitledElementsRequest) Reset() {
	*x = DisplayRepositoryEntitledElementsRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayRepositoryEntitledElementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayRepositoryEntitledElementsRequest) ProtoMessage() {}

func (x *DisplayRepositoryEntitledElementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayRepositoryEntitledElementsRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *DisplayRepositoryEntitledElementsRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type DisplayRepositoryEntitledElementsRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// which elements are entitled to be displayed.
	RepositoryId string
}

func (b0 DisplayRepositoryEntitledElementsRequest_builder) Build() *DisplayRepositoryEntitledElementsRequest {
	m0 := &DisplayRepositoryEntitledElementsRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type DisplayRepositoryEntitledElementsResponse struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_SetPrivate bool                   `protobuf:"varint,1,opt,name=set_private,json=setPrivate,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *DisplayRepositoryEntitledElementsResponse) Reset() {
	*x = DisplayRepositoryEntitledElementsResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DisplayRepositoryEntitledElementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DisplayRepositoryEntitledElementsResponse) ProtoMessage() {}

func (x *DisplayRepositoryEntitledElementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *DisplayRepositoryEntitledElementsResponse) GetSetPrivate() bool {
	if x != nil {
		return x.xxx_hidden_SetPrivate
	}
	return false
}

func (x *DisplayRepositoryEntitledElementsResponse) SetSetPrivate(v bool) {
	x.xxx_hidden_SetPrivate = v
}

type DisplayRepositoryEntitledElementsResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Display repository change to private setting element if true.
	SetPrivate bool
}

func (b0 DisplayRepositoryEntitledElementsResponse_builder) Build() *DisplayRepositoryEntitledElementsResponse {
	m0 := &DisplayRepositoryEntitledElementsResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_SetPrivate = b.SetPrivate
	return m0
}

type ListManageableRepositoryRolesRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ListManageableRepositoryRolesRequest) Reset() {
	*x = ListManageableRepositoryRolesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListManageableRepositoryRolesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManageableRepositoryRolesRequest) ProtoMessage() {}

func (x *ListManageableRepositoryRolesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListManageableRepositoryRolesRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *ListManageableRepositoryRolesRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

type ListManageableRepositoryRolesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// which roles should be displayed as manageable.
	RepositoryId string
}

func (b0 ListManageableRepositoryRolesRequest_builder) Build() *ListManageableRepositoryRolesRequest {
	m0 := &ListManageableRepositoryRolesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	return m0
}

type ListManageableRepositoryRolesResponse struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Roles []RepositoryRole       `protobuf:"varint,1,rep,packed,name=roles,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ListManageableRepositoryRolesResponse) Reset() {
	*x = ListManageableRepositoryRolesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListManageableRepositoryRolesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManageableRepositoryRolesResponse) ProtoMessage() {}

func (x *ListManageableRepositoryRolesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListManageableRepositoryRolesResponse) GetRoles() []RepositoryRole {
	if x != nil {
		return x.xxx_hidden_Roles
	}
	return nil
}

func (x *ListManageableRepositoryRolesResponse) SetRoles(v []RepositoryRole) {
	x.xxx_hidden_Roles = v
}

type ListManageableRepositoryRolesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of roles that should be displayed
	// to the user as manageable.
	Roles []RepositoryRole
}

func (b0 ListManageableRepositoryRolesResponse_builder) Build() *ListManageableRepositoryRolesResponse {
	m0 := &ListManageableRepositoryRolesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Roles = b.Roles
	return m0
}

type ListManageableUserRepositoryRolesRequest struct {
	state                   protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_RepositoryId string                 `protobuf:"bytes,1,opt,name=repository_id,json=repositoryId,proto3"`
	xxx_hidden_UserId       string                 `protobuf:"bytes,2,opt,name=user_id,json=userId,proto3"`
	unknownFields           protoimpl.UnknownFields
	sizeCache               protoimpl.SizeCache
}

func (x *ListManageableUserRepositoryRolesRequest) Reset() {
	*x = ListManageableUserRepositoryRolesRequest{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListManageableUserRepositoryRolesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManageableUserRepositoryRolesRequest) ProtoMessage() {}

func (x *ListManageableUserRepositoryRolesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListManageableUserRepositoryRolesRequest) GetRepositoryId() string {
	if x != nil {
		return x.xxx_hidden_RepositoryId
	}
	return ""
}

func (x *ListManageableUserRepositoryRolesRequest) GetUserId() string {
	if x != nil {
		return x.xxx_hidden_UserId
	}
	return ""
}

func (x *ListManageableUserRepositoryRolesRequest) SetRepositoryId(v string) {
	x.xxx_hidden_RepositoryId = v
}

func (x *ListManageableUserRepositoryRolesRequest) SetUserId(v string) {
	x.xxx_hidden_UserId = v
}

type ListManageableUserRepositoryRolesRequest_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The ID of the repository for which to check
	// which roles should be displayed as manageable.
	RepositoryId string
	// The ID of the target user for which to check
	// which roles are manageable.
	UserId string
}

func (b0 ListManageableUserRepositoryRolesRequest_builder) Build() *ListManageableUserRepositoryRolesRequest {
	m0 := &ListManageableUserRepositoryRolesRequest{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_RepositoryId = b.RepositoryId
	x.xxx_hidden_UserId = b.UserId
	return m0
}

type ListManageableUserRepositoryRolesResponse struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Roles []RepositoryRole       `protobuf:"varint,1,rep,packed,name=roles,proto3,enum=buf.alpha.registry.v1alpha1.RepositoryRole"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *ListManageableUserRepositoryRolesResponse) Reset() {
	*x = ListManageableUserRepositoryRolesResponse{}
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListManageableUserRepositoryRolesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListManageableUserRepositoryRolesResponse) ProtoMessage() {}

func (x *ListManageableUserRepositoryRolesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_buf_alpha_registry_v1alpha1_display_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ListManageableUserRepositoryRolesResponse) GetRoles() []RepositoryRole {
	if x != nil {
		return x.xxx_hidden_Roles
	}
	return nil
}

func (x *ListManageableUserRepositoryRolesResponse) SetRoles(v []RepositoryRole) {
	x.xxx_hidden_Roles = v
}

type ListManageableUserRepositoryRolesResponse_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// The list of roles that should be displayed
	// to the user as manageable.
	Roles []RepositoryRole
}

func (b0 ListManageableUserRepositoryRolesResponse_builder) Build() *ListManageableUserRepositoryRolesResponse {
	m0 := &ListManageableUserRepositoryRolesResponse{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Roles = b.Roles
	return m0
}

var File_buf_alpha_registry_v1alpha1_display_proto protoreflect.FileDescriptor

const file_buf_alpha_registry_v1alpha1_display_proto_rawDesc = "" +
	"\n" +
	")buf/alpha/registry/v1alpha1/display.proto\x12\x1bbuf.alpha.registry.v1alpha1\x1a&buf/alpha/registry/v1alpha1/role.proto\"M\n" +
	"\"DisplayOrganizationElementsRequest\x12'\n" +
	"\x0forganization_id\x18\x01 \x01(\tR\x0eorganizationId\"\xdb\x01\n" +
	"#DisplayOrganizationElementsResponse\x12+\n" +
	"\x11create_repository\x18\x01 \x01(\bR\x10createRepository\x12\x1a\n" +
	"\bsettings\x18\x04 \x01(\bR\bsettings\x12'\n" +
	"\x0fupdate_settings\x18\x05 \x01(\bR\x0eupdateSettings\x12\x16\n" +
	"\x06delete\x18\x06 \x01(\bR\x06deleteJ\x04\b\x02\x10\x03J\x04\b\x03\x10\x04R\rcreate_pluginR\x0fcreate_template\"G\n" +
	" DisplayRepositoryElementsRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\"\x92\x01\n" +
	"!DisplayRepositoryElementsResponse\x12\x1a\n" +
	"\bsettings\x18\x01 \x01(\bR\bsettings\x12\x16\n" +
	"\x06delete\x18\x02 \x01(\bR\x06delete\x12\x14\n" +
	"\x05write\x18\x03 \x01(\bR\x05write\x12#\n" +
	"\rlimited_write\x18\x04 \x01(\bR\flimitedWrite\";\n" +
	"\x1cDisplayPluginElementsRequest\x12\x1b\n" +
	"\tplugin_id\x18\x01 \x01(\tR\bpluginId\"S\n" +
	"\x1dDisplayPluginElementsResponse\x12\x1a\n" +
	"\bsettings\x18\x01 \x01(\bR\bsettings\x12\x16\n" +
	"\x06delete\x18\x02 \x01(\bR\x06delete\"\x1c\n" +
	"\x1aDisplayUserElementsRequest\"5\n" +
	"\x1bDisplayUserElementsResponse\x12\x16\n" +
	"\x06delete\x18\x01 \x01(\bR\x06delete\"\x1e\n" +
	"\x1cDisplayServerElementsRequest\"@\n" +
	"\x1dDisplayServerElementsResponse\x12\x1f\n" +
	"\vadmin_panel\x18\x01 \x01(\bR\n" +
	"adminPanel\"D\n" +
	"#DisplayOwnerEntitledElementsRequest\x12\x1d\n" +
	"\n" +
	"owner_name\x18\x01 \x01(\tR\townerName\"b\n" +
	"$DisplayOwnerEntitledElementsResponse\x12:\n" +
	"\x19create_private_repository\x18\x01 \x01(\bR\x17createPrivateRepository\"O\n" +
	"(DisplayRepositoryEntitledElementsRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\"L\n" +
	")DisplayRepositoryEntitledElementsResponse\x12\x1f\n" +
	"\vset_private\x18\x01 \x01(\bR\n" +
	"setPrivate\"K\n" +
	"$ListManageableRepositoryRolesRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\"j\n" +
	"%ListManageableRepositoryRolesResponse\x12A\n" +
	"\x05roles\x18\x01 \x03(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\x05roles\"h\n" +
	"(ListManageableUserRepositoryRolesRequest\x12#\n" +
	"\rrepository_id\x18\x01 \x01(\tR\frepositoryId\x12\x17\n" +
	"\auser_id\x18\x02 \x01(\tR\x06userId\"n\n" +
	")ListManageableUserRepositoryRolesResponse\x12A\n" +
	"\x05roles\x18\x01 \x03(\x0e2+.buf.alpha.registry.v1alpha1.RepositoryRoleR\x05roles2\xe3\v\n" +
	"\x0eDisplayService\x12\xa5\x01\n" +
	"\x1bDisplayOrganizationElements\x12?.buf.alpha.registry.v1alpha1.DisplayOrganizationElementsRequest\x1a@.buf.alpha.registry.v1alpha1.DisplayOrganizationElementsResponse\"\x03\x90\x02\x01\x12\x9f\x01\n" +
	"\x19DisplayRepositoryElements\x12=.buf.alpha.registry.v1alpha1.DisplayRepositoryElementsRequest\x1a>.buf.alpha.registry.v1alpha1.DisplayRepositoryElementsResponse\"\x03\x90\x02\x01\x12\x93\x01\n" +
	"\x15DisplayPluginElements\x129.buf.alpha.registry.v1alpha1.DisplayPluginElementsRequest\x1a:.buf.alpha.registry.v1alpha1.DisplayPluginElementsResponse\"\x03\x90\x02\x01\x12\x8d\x01\n" +
	"\x13DisplayUserElements\x127.buf.alpha.registry.v1alpha1.DisplayUserElementsRequest\x1a8.buf.alpha.registry.v1alpha1.DisplayUserElementsResponse\"\x03\x90\x02\x01\x12\x93\x01\n" +
	"\x15DisplayServerElements\x129.buf.alpha.registry.v1alpha1.DisplayServerElementsRequest\x1a:.buf.alpha.registry.v1alpha1.DisplayServerElementsResponse\"\x03\x90\x02\x01\x12\xa8\x01\n" +
	"\x1cDisplayOwnerEntitledElements\x12@.buf.alpha.registry.v1alpha1.DisplayOwnerEntitledElementsRequest\x1aA.buf.alpha.registry.v1alpha1.DisplayOwnerEntitledElementsResponse\"\x03\x90\x02\x01\x12\xb7\x01\n" +
	"!DisplayRepositoryEntitledElements\x12E.buf.alpha.registry.v1alpha1.DisplayRepositoryEntitledElementsRequest\x1aF.buf.alpha.registry.v1alpha1.DisplayRepositoryEntitledElementsResponse\"\x03\x90\x02\x01\x12\xab\x01\n" +
	"\x1dListManageableRepositoryRoles\x12A.buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesRequest\x1aB.buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesResponse\"\x03\x90\x02\x01\x12\xb7\x01\n" +
	"!ListManageableUserRepositoryRoles\x12E.buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesRequest\x1aF.buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesResponse\"\x03\x90\x02\x01B\x99\x02\n" +
	"\x1fcom.buf.alpha.registry.v1alpha1B\fDisplayProtoP\x01ZYgithub.com/bufbuild/buf/private/gen/proto/go/buf/alpha/registry/v1alpha1;registryv1alpha1\xa2\x02\x03BAR\xaa\x02\x1bBuf.Alpha.Registry.V1alpha1\xca\x02\x1bBuf\\Alpha\\Registry\\V1alpha1\xe2\x02'Buf\\Alpha\\Registry\\V1alpha1\\GPBMetadata\xea\x02\x1eBuf::Alpha::Registry::V1alpha1b\x06proto3"

var file_buf_alpha_registry_v1alpha1_display_proto_msgTypes = make([]protoimpl.MessageInfo, 18)
var file_buf_alpha_registry_v1alpha1_display_proto_goTypes = []any{
	(*DisplayOrganizationElementsRequest)(nil),        // 0: buf.alpha.registry.v1alpha1.DisplayOrganizationElementsRequest
	(*DisplayOrganizationElementsResponse)(nil),       // 1: buf.alpha.registry.v1alpha1.DisplayOrganizationElementsResponse
	(*DisplayRepositoryElementsRequest)(nil),          // 2: buf.alpha.registry.v1alpha1.DisplayRepositoryElementsRequest
	(*DisplayRepositoryElementsResponse)(nil),         // 3: buf.alpha.registry.v1alpha1.DisplayRepositoryElementsResponse
	(*DisplayPluginElementsRequest)(nil),              // 4: buf.alpha.registry.v1alpha1.DisplayPluginElementsRequest
	(*DisplayPluginElementsResponse)(nil),             // 5: buf.alpha.registry.v1alpha1.DisplayPluginElementsResponse
	(*DisplayUserElementsRequest)(nil),                // 6: buf.alpha.registry.v1alpha1.DisplayUserElementsRequest
	(*DisplayUserElementsResponse)(nil),               // 7: buf.alpha.registry.v1alpha1.DisplayUserElementsResponse
	(*DisplayServerElementsRequest)(nil),              // 8: buf.alpha.registry.v1alpha1.DisplayServerElementsRequest
	(*DisplayServerElementsResponse)(nil),             // 9: buf.alpha.registry.v1alpha1.DisplayServerElementsResponse
	(*DisplayOwnerEntitledElementsRequest)(nil),       // 10: buf.alpha.registry.v1alpha1.DisplayOwnerEntitledElementsRequest
	(*DisplayOwnerEntitledElementsResponse)(nil),      // 11: buf.alpha.registry.v1alpha1.DisplayOwnerEntitledElementsResponse
	(*DisplayRepositoryEntitledElementsRequest)(nil),  // 12: buf.alpha.registry.v1alpha1.DisplayRepositoryEntitledElementsRequest
	(*DisplayRepositoryEntitledElementsResponse)(nil), // 13: buf.alpha.registry.v1alpha1.DisplayRepositoryEntitledElementsResponse
	(*ListManageableRepositoryRolesRequest)(nil),      // 14: buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesRequest
	(*ListManageableRepositoryRolesResponse)(nil),     // 15: buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesResponse
	(*ListManageableUserRepositoryRolesRequest)(nil),  // 16: buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesRequest
	(*ListManageableUserRepositoryRolesResponse)(nil), // 17: buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesResponse
	(RepositoryRole)(0),                               // 18: buf.alpha.registry.v1alpha1.RepositoryRole
}
var file_buf_alpha_registry_v1alpha1_display_proto_depIdxs = []int32{
	18, // 0: buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesResponse.roles:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	18, // 1: buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesResponse.roles:type_name -> buf.alpha.registry.v1alpha1.RepositoryRole
	0,  // 2: buf.alpha.registry.v1alpha1.DisplayService.DisplayOrganizationElements:input_type -> buf.alpha.registry.v1alpha1.DisplayOrganizationElementsRequest
	2,  // 3: buf.alpha.registry.v1alpha1.DisplayService.DisplayRepositoryElements:input_type -> buf.alpha.registry.v1alpha1.DisplayRepositoryElementsRequest
	4,  // 4: buf.alpha.registry.v1alpha1.DisplayService.DisplayPluginElements:input_type -> buf.alpha.registry.v1alpha1.DisplayPluginElementsRequest
	6,  // 5: buf.alpha.registry.v1alpha1.DisplayService.DisplayUserElements:input_type -> buf.alpha.registry.v1alpha1.DisplayUserElementsRequest
	8,  // 6: buf.alpha.registry.v1alpha1.DisplayService.DisplayServerElements:input_type -> buf.alpha.registry.v1alpha1.DisplayServerElementsRequest
	10, // 7: buf.alpha.registry.v1alpha1.DisplayService.DisplayOwnerEntitledElements:input_type -> buf.alpha.registry.v1alpha1.DisplayOwnerEntitledElementsRequest
	12, // 8: buf.alpha.registry.v1alpha1.DisplayService.DisplayRepositoryEntitledElements:input_type -> buf.alpha.registry.v1alpha1.DisplayRepositoryEntitledElementsRequest
	14, // 9: buf.alpha.registry.v1alpha1.DisplayService.ListManageableRepositoryRoles:input_type -> buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesRequest
	16, // 10: buf.alpha.registry.v1alpha1.DisplayService.ListManageableUserRepositoryRoles:input_type -> buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesRequest
	1,  // 11: buf.alpha.registry.v1alpha1.DisplayService.DisplayOrganizationElements:output_type -> buf.alpha.registry.v1alpha1.DisplayOrganizationElementsResponse
	3,  // 12: buf.alpha.registry.v1alpha1.DisplayService.DisplayRepositoryElements:output_type -> buf.alpha.registry.v1alpha1.DisplayRepositoryElementsResponse
	5,  // 13: buf.alpha.registry.v1alpha1.DisplayService.DisplayPluginElements:output_type -> buf.alpha.registry.v1alpha1.DisplayPluginElementsResponse
	7,  // 14: buf.alpha.registry.v1alpha1.DisplayService.DisplayUserElements:output_type -> buf.alpha.registry.v1alpha1.DisplayUserElementsResponse
	9,  // 15: buf.alpha.registry.v1alpha1.DisplayService.DisplayServerElements:output_type -> buf.alpha.registry.v1alpha1.DisplayServerElementsResponse
	11, // 16: buf.alpha.registry.v1alpha1.DisplayService.DisplayOwnerEntitledElements:output_type -> buf.alpha.registry.v1alpha1.DisplayOwnerEntitledElementsResponse
	13, // 17: buf.alpha.registry.v1alpha1.DisplayService.DisplayRepositoryEntitledElements:output_type -> buf.alpha.registry.v1alpha1.DisplayRepositoryEntitledElementsResponse
	15, // 18: buf.alpha.registry.v1alpha1.DisplayService.ListManageableRepositoryRoles:output_type -> buf.alpha.registry.v1alpha1.ListManageableRepositoryRolesResponse
	17, // 19: buf.alpha.registry.v1alpha1.DisplayService.ListManageableUserRepositoryRoles:output_type -> buf.alpha.registry.v1alpha1.ListManageableUserRepositoryRolesResponse
	11, // [11:20] is the sub-list for method output_type
	2,  // [2:11] is the sub-list for method input_type
	2,  // [2:2] is the sub-list for extension type_name
	2,  // [2:2] is the sub-list for extension extendee
	0,  // [0:2] is the sub-list for field type_name
}

func init() { file_buf_alpha_registry_v1alpha1_display_proto_init() }
func file_buf_alpha_registry_v1alpha1_display_proto_init() {
	if File_buf_alpha_registry_v1alpha1_display_proto != nil {
		return
	}
	file_buf_alpha_registry_v1alpha1_role_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_buf_alpha_registry_v1alpha1_display_proto_rawDesc), len(file_buf_alpha_registry_v1alpha1_display_proto_rawDesc)),
			NumEnums:      0,
			NumMessages:   18,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_buf_alpha_registry_v1alpha1_display_proto_goTypes,
		DependencyIndexes: file_buf_alpha_registry_v1alpha1_display_proto_depIdxs,
		MessageInfos:      file_buf_alpha_registry_v1alpha1_display_proto_msgTypes,
	}.Build()
	File_buf_alpha_registry_v1alpha1_display_proto = out.File
	file_buf_alpha_registry_v1alpha1_display_proto_goTypes = nil
	file_buf_alpha_registry_v1alpha1_display_proto_depIdxs = nil
}
