// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package models

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	stderrors "errors"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/strfmt"
	"github.com/go-openapi/swag"
)

// NodeStatus Connectivity status of a remote cilium-health instance
//
// swagger:model NodeStatus
type NodeStatus struct {

	// DEPRECATED: Please use the health-endpoint field instead, which
	// supports reporting the status of different addresses for the endpoint
	//
	Endpoint *PathStatus `json:"endpoint,omitempty"`

	// Connectivity status to simulated endpoint on the node
	HealthEndpoint *EndpointStatus `json:"health-endpoint,omitempty"`

	// Connectivity status to cilium-health instance on node IP
	Host *HostStatus `json:"host,omitempty"`

	// Identifying name for the node
	Name string `json:"name,omitempty"`
}

// Validate validates this node status
func (m *NodeStatus) Validate(formats strfmt.Registry) error {
	var res []error

	if err := m.validateEndpoint(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHealthEndpoint(formats); err != nil {
		res = append(res, err)
	}

	if err := m.validateHost(formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeStatus) validateEndpoint(formats strfmt.Registry) error {
	if swag.IsZero(m.Endpoint) { // not required
		return nil
	}

	if m.Endpoint != nil {
		if err := m.Endpoint.Validate(formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("endpoint")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("endpoint")
			}

			return err
		}
	}

	return nil
}

func (m *NodeStatus) validateHealthEndpoint(formats strfmt.Registry) error {
	if swag.IsZero(m.HealthEndpoint) { // not required
		return nil
	}

	if m.HealthEndpoint != nil {
		if err := m.HealthEndpoint.Validate(formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("health-endpoint")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("health-endpoint")
			}

			return err
		}
	}

	return nil
}

func (m *NodeStatus) validateHost(formats strfmt.Registry) error {
	if swag.IsZero(m.Host) { // not required
		return nil
	}

	if m.Host != nil {
		if err := m.Host.Validate(formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("host")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("host")
			}

			return err
		}
	}

	return nil
}

// ContextValidate validate this node status based on the context it is used
func (m *NodeStatus) ContextValidate(ctx context.Context, formats strfmt.Registry) error {
	var res []error

	if err := m.contextValidateEndpoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHealthEndpoint(ctx, formats); err != nil {
		res = append(res, err)
	}

	if err := m.contextValidateHost(ctx, formats); err != nil {
		res = append(res, err)
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}

func (m *NodeStatus) contextValidateEndpoint(ctx context.Context, formats strfmt.Registry) error {

	if m.Endpoint != nil {

		if swag.IsZero(m.Endpoint) { // not required
			return nil
		}

		if err := m.Endpoint.ContextValidate(ctx, formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("endpoint")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("endpoint")
			}

			return err
		}
	}

	return nil
}

func (m *NodeStatus) contextValidateHealthEndpoint(ctx context.Context, formats strfmt.Registry) error {

	if m.HealthEndpoint != nil {

		if swag.IsZero(m.HealthEndpoint) { // not required
			return nil
		}

		if err := m.HealthEndpoint.ContextValidate(ctx, formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("health-endpoint")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("health-endpoint")
			}

			return err
		}
	}

	return nil
}

func (m *NodeStatus) contextValidateHost(ctx context.Context, formats strfmt.Registry) error {

	if m.Host != nil {

		if swag.IsZero(m.Host) { // not required
			return nil
		}

		if err := m.Host.ContextValidate(ctx, formats); err != nil {
			ve := new(errors.Validation)
			if stderrors.As(err, &ve) {
				return ve.ValidateName("host")
			}
			ce := new(errors.CompositeError)
			if stderrors.As(err, &ce) {
				return ce.ValidateName("host")
			}

			return err
		}
	}

	return nil
}

// MarshalBinary interface implementation
func (m *NodeStatus) MarshalBinary() ([]byte, error) {
	if m == nil {
		return nil, nil
	}
	return swag.WriteJSON(m)
}

// UnmarshalBinary interface implementation
func (m *NodeStatus) UnmarshalBinary(b []byte) error {
	var res NodeStatus
	if err := swag.ReadJSON(b, &res); err != nil {
		return err
	}
	*m = res
	return nil
}
