/* auto-generated, do not modify */
#include "config.h"

#include "fu-intel-cvs-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"

static const gchar *
fu_intel_cvs_device_state_to_string(FuIntelCvsDeviceState val)
{
    if (val == FU_INTEL_CVS_DEVICE_STATE_DEVICE_OFF)
        return "device-off";
    if (val == FU_INTEL_CVS_DEVICE_STATE_PRIVACY_ON)
        return "privacy-on";
    if (val == FU_INTEL_CVS_DEVICE_STATE_DEVICE_ON)
        return "device-on";
    if (val == FU_INTEL_CVS_DEVICE_STATE_SENSOR_OWNER)
        return "sensor-owner";
    if (val == FU_INTEL_CVS_DEVICE_STATE_DEVICE_DWNLD_STATE)
        return "device-dwnld-state";
    if (val == FU_INTEL_CVS_DEVICE_STATE_DEVICE_DWNLD_ERROR)
        return "device-dwnld-error";
    if (val == FU_INTEL_CVS_DEVICE_STATE_DEVICE_DWNLD_BUSY)
        return "device-dwnld-busy";
    return NULL;
}




static const gchar *
fu_struct_intel_cvs_dev_capability_to_string(FuStructIntelCvsDevCapability val)
{
    if (val == FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_CV_POWER_DOMAIN)
        return "cv-power-domain";
    if (val == FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_NOCAMERA_DURING_FWUPDATE)
        return "nocamera-during-fwupdate";
    if (val == FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_FWUPDATE_RESET_REQUIRED)
        return "fwupdate-reset-required";
    if (val == FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_PRIVACY2VISIONDRIVER)
        return "privacy2visiondriver";
    if (val == FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_FW_ANTIROLLBACK)
        return "fw-antirollback";
    if (val == FU_STRUCT_INTEL_CVS_DEV_CAPABILITY_HOST_MIPI_CONFIG_REQUIRED)
        return "host-mipi-config-required";
    return NULL;
}
/* getters */
/**
 * fu_struct_intel_cvs_fw_get_major: (skip):
 **/
guint32
fu_struct_intel_cvs_fw_get_major(const FuStructIntelCvsFw *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_fw_get_minor: (skip):
 **/
guint32
fu_struct_intel_cvs_fw_get_minor(const FuStructIntelCvsFw *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_fw_get_hotfix: (skip):
 **/
guint32
fu_struct_intel_cvs_fw_get_hotfix(const FuStructIntelCvsFw *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_fw_get_build: (skip):
 **/
guint32
fu_struct_intel_cvs_fw_get_build(const FuStructIntelCvsFw *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_intel_cvs_fw_to_string: (skip):
 **/
static gchar *
fu_struct_intel_cvs_fw_to_string(const FuStructIntelCvsFw *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIntelCvsFw:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  major: 0x%x\n",
                           (guint) fu_struct_intel_cvs_fw_get_major(st));
    g_string_append_printf(str, "  minor: 0x%x\n",
                           (guint) fu_struct_intel_cvs_fw_get_minor(st));
    g_string_append_printf(str, "  hotfix: 0x%x\n",
                           (guint) fu_struct_intel_cvs_fw_get_hotfix(st));
    g_string_append_printf(str, "  build: 0x%x\n",
                           (guint) fu_struct_intel_cvs_fw_get_build(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_intel_cvs_fw_validate_internal(FuStructIntelCvsFw *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/* getters */
/**
 * fu_struct_intel_cvs_id_get_vid: (skip):
 **/
guint16
fu_struct_intel_cvs_id_get_vid(const FuStructIntelCvsId *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_id_get_pid: (skip):
 **/
guint16
fu_struct_intel_cvs_id_get_pid(const FuStructIntelCvsId *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 2, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_intel_cvs_id_to_string: (skip):
 **/
static gchar *
fu_struct_intel_cvs_id_to_string(const FuStructIntelCvsId *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIntelCvsId:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_intel_cvs_id_get_vid(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_intel_cvs_id_get_pid(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_intel_cvs_id_validate_internal(FuStructIntelCvsId *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
/* getters */
/**
 * fu_struct_intel_cvs_firmware_hdr_get_magic_number: (skip):
 **/
static gchar *
fu_struct_intel_cvs_firmware_hdr_get_magic_number(const FuStructIntelCvsFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->data, st->len, 0, 8, NULL);
}
/**
 * fu_struct_intel_cvs_firmware_hdr_get_fw_version: (skip):
 **/
FuStructIntelCvsFw *
fu_struct_intel_cvs_firmware_hdr_get_fw_version(const FuStructIntelCvsFirmwareHdr *st)
{
    g_autoptr(GByteArray) buf = g_byte_array_new();
    g_return_val_if_fail(st != NULL, NULL);
    g_byte_array_append(buf, st->data + FU_STRUCT_INTEL_CVS_FIRMWARE_HDR_OFFSET_FW_VERSION, 16);
    return g_steal_pointer(&buf);
}
/**
 * fu_struct_intel_cvs_firmware_hdr_get_vid_pid: (skip):
 **/
FuStructIntelCvsId *
fu_struct_intel_cvs_firmware_hdr_get_vid_pid(const FuStructIntelCvsFirmwareHdr *st)
{
    g_autoptr(GByteArray) buf = g_byte_array_new();
    g_return_val_if_fail(st != NULL, NULL);
    g_byte_array_append(buf, st->data + FU_STRUCT_INTEL_CVS_FIRMWARE_HDR_OFFSET_VID_PID, 4);
    return g_steal_pointer(&buf);
}
/**
 * fu_struct_intel_cvs_firmware_hdr_get_fw_offset: (skip):
 **/
guint32
fu_struct_intel_cvs_firmware_hdr_get_fw_offset(const FuStructIntelCvsFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 28, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_firmware_hdr_get_header_checksum: (skip):
 **/
guint32
fu_struct_intel_cvs_firmware_hdr_get_header_checksum(const FuStructIntelCvsFirmwareHdr *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 252, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_intel_cvs_firmware_hdr_to_string: (skip):
 **/
static gchar *
fu_struct_intel_cvs_firmware_hdr_to_string(const FuStructIntelCvsFirmwareHdr *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIntelCvsFirmwareHdr:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        g_autoptr(GByteArray) st_tmp = fu_struct_intel_cvs_firmware_hdr_get_fw_version(st);
        g_autofree gchar *tmp = fu_struct_intel_cvs_fw_to_string(st_tmp);
        g_string_append_printf(str, "  fw_version: %s\n", tmp);
    }
    {
        g_autoptr(GByteArray) st_tmp = fu_struct_intel_cvs_firmware_hdr_get_vid_pid(st);
        g_autofree gchar *tmp = fu_struct_intel_cvs_id_to_string(st_tmp);
        g_string_append_printf(str, "  vid_pid: %s\n", tmp);
    }
    g_string_append_printf(str, "  fw_offset: 0x%x\n",
                           (guint) fu_struct_intel_cvs_firmware_hdr_get_fw_offset(st));
    g_string_append_printf(str, "  header_checksum: 0x%x\n",
                           (guint) fu_struct_intel_cvs_firmware_hdr_get_header_checksum(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_intel_cvs_firmware_hdr_validate_internal(FuStructIntelCvsFirmwareHdr *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->data + 0), "VISSOCFW", 8) != 0) {
        g_autofree gchar *str = fu_struct_intel_cvs_firmware_hdr_get_magic_number(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructIntelCvsFirmwareHdr.magic_number was not valid, "
                    "expected 'VISSOCFW' and got '%s'",
                    str);
        return FALSE;
    }
    {
        GByteArray st_tmp = {
            .data = (guint8*) st->data + 0x8,
            .len = 16,
        };
        if (!fu_struct_intel_cvs_fw_validate_internal(&st_tmp, error))
            return FALSE;
    }
    {
        GByteArray st_tmp = {
            .data = (guint8*) st->data + 0x18,
            .len = 4,
        };
        if (!fu_struct_intel_cvs_id_validate_internal(&st_tmp, error))
            return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_intel_cvs_firmware_hdr_validate_stream: (skip):
 **/
gboolean
fu_struct_intel_cvs_firmware_hdr_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st = fu_input_stream_read_byte_array(stream, offset, 256, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructIntelCvsFirmwareHdr failed read of 0x%x: ", (guint) 256);
        return FALSE;
    }
    if (st->len != 256) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIntelCvsFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 256,
                    (guint) st->len);
        return FALSE;
    }
    return fu_struct_intel_cvs_firmware_hdr_validate_internal(st, error);
}
static gboolean
fu_struct_intel_cvs_firmware_hdr_parse_internal(FuStructIntelCvsFirmwareHdr *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_intel_cvs_firmware_hdr_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_intel_cvs_firmware_hdr_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_intel_cvs_firmware_hdr_parse_stream: (skip):
 **/
FuStructIntelCvsFirmwareHdr *
fu_struct_intel_cvs_firmware_hdr_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = NULL;
    st = fu_input_stream_read_byte_array(stream, offset, 256, NULL, error);
    if (st == NULL) {
        g_prefix_error(error, "FuStructIntelCvsFirmwareHdr failed read of 0x%x: ", (guint) 256);
        return NULL;
    }
    if (st->len != 256) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructIntelCvsFirmwareHdr requested 0x%x and got 0x%x",
                    (guint) 256,
                    (guint) st->len);
        return NULL;
    }
    if (!fu_struct_intel_cvs_firmware_hdr_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/* getters */
/**
 * fu_struct_intel_cvs_probe_get_major: (skip):
 **/
guint32
fu_struct_intel_cvs_probe_get_major(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_minor: (skip):
 **/
guint32
fu_struct_intel_cvs_probe_get_minor(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_hotfix: (skip):
 **/
guint32
fu_struct_intel_cvs_probe_get_hotfix(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 8, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_build: (skip):
 **/
guint32
fu_struct_intel_cvs_probe_get_build(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 12, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_vid: (skip):
 **/
guint16
fu_struct_intel_cvs_probe_get_vid(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 16, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_pid: (skip):
 **/
guint16
fu_struct_intel_cvs_probe_get_pid(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_opid: (skip):
 **/
guint32
fu_struct_intel_cvs_probe_get_opid(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 20, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_probe_get_dev_capabilities: (skip):
 **/
FuStructIntelCvsDevCapability
fu_struct_intel_cvs_probe_get_dev_capabilities(const FuStructIntelCvsProbe *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 24, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_intel_cvs_probe_to_string: (skip):
 **/
static gchar *
fu_struct_intel_cvs_probe_to_string(const FuStructIntelCvsProbe *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIntelCvsProbe:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  major: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_major(st));
    g_string_append_printf(str, "  minor: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_minor(st));
    g_string_append_printf(str, "  hotfix: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_hotfix(st));
    g_string_append_printf(str, "  build: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_build(st));
    g_string_append_printf(str, "  vid: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_vid(st));
    g_string_append_printf(str, "  pid: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_pid(st));
    g_string_append_printf(str, "  opid: 0x%x\n",
                           (guint) fu_struct_intel_cvs_probe_get_opid(st));
    {
        const gchar *tmp = fu_struct_intel_cvs_dev_capability_to_string(fu_struct_intel_cvs_probe_get_dev_capabilities(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  dev_capabilities: 0x%x [%s]\n", (guint) fu_struct_intel_cvs_probe_get_dev_capabilities(st), tmp);
        } else {
            g_string_append_printf(str, "  dev_capabilities: 0x%x\n", (guint) fu_struct_intel_cvs_probe_get_dev_capabilities(st));
        }
    }
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_intel_cvs_probe_validate_internal(FuStructIntelCvsProbe *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_intel_cvs_probe_parse_internal(FuStructIntelCvsProbe *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_intel_cvs_probe_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_intel_cvs_probe_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_intel_cvs_probe_parse: (skip):
 **/
static FuStructIntelCvsProbe *
fu_struct_intel_cvs_probe_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 28, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIntelCvsProbe: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 28);
    if (!fu_struct_intel_cvs_probe_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_intel_cvs_probe_parse_bytes: (skip):
 **/
FuStructIntelCvsProbe *
fu_struct_intel_cvs_probe_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_intel_cvs_probe_parse(buf, bufsz, offset, error);
}
/* getters */

/* setters */
/**
 * fu_struct_intel_cvs_write_set_max_download_time: (skip):
 **/
void
fu_struct_intel_cvs_write_set_max_download_time(FuStructIntelCvsWrite *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_write_set_max_flash_time: (skip):
 **/
void
fu_struct_intel_cvs_write_set_max_flash_time(FuStructIntelCvsWrite *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_write_set_max_fwupd_retry_count: (skip):
 **/
void
fu_struct_intel_cvs_write_set_max_fwupd_retry_count(FuStructIntelCvsWrite *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 8, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_write_set_fw_bin_fd: (skip):
 **/
void
fu_struct_intel_cvs_write_set_fw_bin_fd(FuStructIntelCvsWrite *st, gint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->data + 12, value, G_BYTE_ORDER);
}
/**
 * fu_struct_intel_cvs_write_new: (skip):
 **/
FuStructIntelCvsWrite *
fu_struct_intel_cvs_write_new(void)
{
    FuStructIntelCvsWrite *st = g_byte_array_sized_new(16);
    fu_byte_array_set_size(st, 16, 0x0);
    return st;
}
/* getters */
/**
 * fu_struct_intel_cvs_status_get_dev_state: (skip):
 **/
FuIntelCvsDeviceState
fu_struct_intel_cvs_status_get_dev_state(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[0];
}
/**
 * fu_struct_intel_cvs_status_get_fw_upd_retries: (skip):
 **/
guint32
fu_struct_intel_cvs_status_get_fw_upd_retries(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 1, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_status_get_total_packets: (skip):
 **/
guint32
fu_struct_intel_cvs_status_get_total_packets(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 5, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_status_get_num_packets_sent: (skip):
 **/
guint32
fu_struct_intel_cvs_status_get_num_packets_sent(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 9, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_intel_cvs_status_get_fw_dl_finished: (skip):
 **/
guint8
fu_struct_intel_cvs_status_get_fw_dl_finished(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->data[13];
}
/**
 * fu_struct_intel_cvs_status_get_fw_dl_status_code: (skip):
 **/
guint32
fu_struct_intel_cvs_status_get_fw_dl_status_code(const FuStructIntelCvsStatus *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->data + 14, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_intel_cvs_status_to_string: (skip):
 **/
static gchar *
fu_struct_intel_cvs_status_to_string(const FuStructIntelCvsStatus *st)
{
    g_autoptr(GString) str = g_string_new("FuStructIntelCvsStatus:\n");
    g_return_val_if_fail(st != NULL, NULL);
    {
        const gchar *tmp = fu_intel_cvs_device_state_to_string(fu_struct_intel_cvs_status_get_dev_state(st));
        if (tmp != NULL) {
            g_string_append_printf(str, "  dev_state: 0x%x [%s]\n", (guint) fu_struct_intel_cvs_status_get_dev_state(st), tmp);
        } else {
            g_string_append_printf(str, "  dev_state: 0x%x\n", (guint) fu_struct_intel_cvs_status_get_dev_state(st));
        }
    }
    g_string_append_printf(str, "  fw_upd_retries: 0x%x\n",
                           (guint) fu_struct_intel_cvs_status_get_fw_upd_retries(st));
    g_string_append_printf(str, "  total_packets: 0x%x\n",
                           (guint) fu_struct_intel_cvs_status_get_total_packets(st));
    g_string_append_printf(str, "  num_packets_sent: 0x%x\n",
                           (guint) fu_struct_intel_cvs_status_get_num_packets_sent(st));
    g_string_append_printf(str, "  fw_dl_finished: 0x%x\n",
                           (guint) fu_struct_intel_cvs_status_get_fw_dl_finished(st));
    g_string_append_printf(str, "  fw_dl_status_code: 0x%x\n",
                           (guint) fu_struct_intel_cvs_status_get_fw_dl_status_code(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_intel_cvs_status_validate_internal(FuStructIntelCvsStatus *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_intel_cvs_status_parse_internal(FuStructIntelCvsStatus *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_intel_cvs_status_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_intel_cvs_status_validate_internal(st, error))
        return FALSE;
    return TRUE;
}

/**
 * fu_struct_intel_cvs_status_parse: (skip):
 **/
static FuStructIntelCvsStatus *
fu_struct_intel_cvs_status_parse(const guint8 *buf, gsize bufsz, gsize offset, GError **error)
{
    g_autoptr(GByteArray) st = g_byte_array_new();
    g_return_val_if_fail(buf != NULL, NULL);
    g_return_val_if_fail(error == NULL || *error == NULL, NULL);
    if (!fu_memchk_read(bufsz, offset, 18, error)) {
        g_prefix_error_literal(error, "invalid struct FuStructIntelCvsStatus: ");
        return NULL;
    }
    g_byte_array_append(st, buf + offset, 18);
    if (!fu_struct_intel_cvs_status_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_intel_cvs_status_parse_bytes: (skip):
 **/
FuStructIntelCvsStatus *
fu_struct_intel_cvs_status_parse_bytes(GBytes *blob, gsize offset, GError **error)
{
    gsize bufsz = 0;
    const guint8 *buf = g_bytes_get_data(blob, &bufsz);
    return fu_struct_intel_cvs_status_parse(buf, bufsz, offset, error);
}
