/* auto-generated, do not modify */
#include "config.h"

#include <glib.h>

#include "fu-fmap-struct.h"
#include "fu-byte-array.h"
#include "fu-mem-private.h"
#include "fu-string.h"

#ifdef G_LOG_DOMAIN
  #undef G_LOG_DOMAIN
#endif
#define G_LOG_DOMAIN "FuStruct"
/**
 * fu_struct_fmap_ref: (skip):
 **/
FuStructFmap *
fu_struct_fmap_ref(FuStructFmap *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_fmap_unref: (skip):
 **/
void
fu_struct_fmap_unref(FuStructFmap *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructFmap refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_fmap_new_internal: (skip):
 **/
static FuStructFmap *
fu_struct_fmap_new_internal(void)
{
    FuStructFmap *st = g_new0(FuStructFmap, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_fmap_get_signature: (skip):
 **/
static gchar *
fu_struct_fmap_get_signature(const FuStructFmap *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 0, 8, NULL);
}
/**
 * fu_struct_fmap_get_ver_major: (skip):
 **/
guint8
fu_struct_fmap_get_ver_major(const FuStructFmap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[8];
}
/**
 * fu_struct_fmap_get_ver_minor: (skip):
 **/
guint8
fu_struct_fmap_get_ver_minor(const FuStructFmap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return st->buf->data[9];
}
/**
 * fu_struct_fmap_get_base: (skip):
 **/
guint64
fu_struct_fmap_get_base(const FuStructFmap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint64(st->buf->data + 10, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_get_size: (skip):
 **/
guint32
fu_struct_fmap_get_size(const FuStructFmap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 18, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_get_name: (skip):
 **/
gchar *
fu_struct_fmap_get_name(const FuStructFmap *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 22, 32, NULL);
}
/**
 * fu_struct_fmap_get_nareas: (skip):
 **/
guint16
fu_struct_fmap_get_nareas(const FuStructFmap *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 54, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_fmap_set_signature: (skip):
 **/
static gboolean
fu_struct_fmap_set_signature(FuStructFmap *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 0, 0x0, 8);
        return TRUE;
    }
    len = strlen(value);
    if (len > 8) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructFmap.signature (0x%x bytes)",
                    value, (guint) len, (guint) 8);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 0, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_fmap_set_ver_major: (skip):
 **/
void
fu_struct_fmap_set_ver_major(FuStructFmap *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[8] = value;
}
/**
 * fu_struct_fmap_set_ver_minor: (skip):
 **/
void
fu_struct_fmap_set_ver_minor(FuStructFmap *st, guint8 value)
{
    g_return_if_fail(st != NULL);
    st->buf->data[9] = value;
}
/**
 * fu_struct_fmap_set_base: (skip):
 **/
void
fu_struct_fmap_set_base(FuStructFmap *st, guint64 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint64(st->buf->data + 10, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_set_size: (skip):
 **/
void
fu_struct_fmap_set_size(FuStructFmap *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 18, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_set_name: (skip):
 **/
gboolean
fu_struct_fmap_set_name(FuStructFmap *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 22, 0x0, 32);
        return TRUE;
    }
    len = strlen(value);
    if (len > 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructFmap.name (0x%x bytes)",
                    value, (guint) len, (guint) 32);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 22, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_fmap_set_nareas: (skip):
 **/
void
fu_struct_fmap_set_nareas(FuStructFmap *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 54, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_new: (skip):
 **/
FuStructFmap *
fu_struct_fmap_new(void)
{
    FuStructFmap *st = fu_struct_fmap_new_internal();
    st->buf = g_byte_array_sized_new(56);
    fu_byte_array_set_size(st->buf, 56, 0x0);
    fu_struct_fmap_set_signature(st, "__FMAP__", NULL);
    fu_struct_fmap_set_ver_major(st, 0x1);
    fu_struct_fmap_set_ver_minor(st, 0x1);
    return st;
}
/**
 * fu_struct_fmap_to_string: (skip):
 **/
static gchar *
fu_struct_fmap_to_string(const FuStructFmap *st)
{
    g_autoptr(GString) str = g_string_new("FuStructFmap:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  ver_major: 0x%x\n",
                           (guint) fu_struct_fmap_get_ver_major(st));
    g_string_append_printf(str, "  ver_minor: 0x%x\n",
                           (guint) fu_struct_fmap_get_ver_minor(st));
    g_string_append_printf(str, "  base: 0x%x\n",
                           (guint) fu_struct_fmap_get_base(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_fmap_get_size(st));
    {
        g_autofree gchar *tmp = fu_struct_fmap_get_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  nareas: 0x%x\n",
                           (guint) fu_struct_fmap_get_nareas(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_fmap_validate_internal(FuStructFmap *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    if (strncmp((const gchar *) (st->buf->data + 0), "__FMAP__", 8) != 0) {
        g_autofree gchar *str = fu_struct_fmap_get_signature(st);
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "constant FuStructFmap.signature was not valid, "
                    "expected '__FMAP__' and got '%s'",
                    str);
        return FALSE;
    }
    return TRUE;
}
/**
 * fu_struct_fmap_validate_stream: (skip):
 **/
gboolean
fu_struct_fmap_validate_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructFmap) st = fu_struct_fmap_new_internal();
    g_return_val_if_fail(G_IS_INPUT_STREAM(stream), FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    st->buf = fu_input_stream_read_byte_array(stream, offset, 56, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructFmap failed read of 0x%x: ", (guint) 56);
        return FALSE;
    }
    if (st->buf->len != 56) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructFmap requested 0x%x and got 0x%x",
                    (guint) 56,
                    (guint) st->buf->len);
        return FALSE;
    }
    return fu_struct_fmap_validate_internal(st, error);
}
static gboolean
fu_struct_fmap_parse_internal(FuStructFmap *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_fmap_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_fmap_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_fmap_parse_stream: (skip):
 **/
FuStructFmap *
fu_struct_fmap_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructFmap) st = fu_struct_fmap_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 56, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructFmap failed read of 0x%x: ", (guint) 56);
        return NULL;
    }
    if (st->buf->len != 56) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructFmap requested 0x%x and got 0x%x",
                    (guint) 56,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_fmap_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
/**
 * fu_struct_fmap_area_ref: (skip):
 **/
FuStructFmapArea *
fu_struct_fmap_area_ref(FuStructFmapArea *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    st->refcount++;
    return st;
}
/**
 * fu_struct_fmap_area_unref: (skip):
 **/
void
fu_struct_fmap_area_unref(FuStructFmapArea *st)
{
    g_return_if_fail(st != NULL);
    if (st->refcount == 0) {
        g_critical("FuStructFmapArea refcount already zero");
        return;
    }
    if (--st->refcount > 0)
        return;
    if (st->buf != NULL)
        g_byte_array_unref(st->buf);
    g_free(st);
}
/**
 * fu_struct_fmap_area_new_internal: (skip):
 **/
static FuStructFmapArea *
fu_struct_fmap_area_new_internal(void)
{
    FuStructFmapArea *st = g_new0(FuStructFmapArea, 1);
    st->refcount = 1;
    return st;
}

/* getters */
/**
 * fu_struct_fmap_area_get_offset: (skip):
 **/
guint32
fu_struct_fmap_area_get_offset(const FuStructFmapArea *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 0, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_area_get_size: (skip):
 **/
guint32
fu_struct_fmap_area_get_size(const FuStructFmapArea *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint32(st->buf->data + 4, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_area_get_name: (skip):
 **/
gchar *
fu_struct_fmap_area_get_name(const FuStructFmapArea *st)
{
    g_return_val_if_fail(st != NULL, NULL);
    return fu_memstrsafe(st->buf->data, st->buf->len, 8, 32, NULL);
}
/**
 * fu_struct_fmap_area_get_flags: (skip):
 **/
guint16
fu_struct_fmap_area_get_flags(const FuStructFmapArea *st)
{
    g_return_val_if_fail(st != NULL, 0x0);
    return fu_memread_uint16(st->buf->data + 40, G_LITTLE_ENDIAN);
}

/* setters */
/**
 * fu_struct_fmap_area_set_offset: (skip):
 **/
void
fu_struct_fmap_area_set_offset(FuStructFmapArea *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 0, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_area_set_size: (skip):
 **/
void
fu_struct_fmap_area_set_size(FuStructFmapArea *st, guint32 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint32(st->buf->data + 4, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_area_set_name: (skip):
 **/
gboolean
fu_struct_fmap_area_set_name(FuStructFmapArea *st, const gchar *value, GError **error)
{
    gsize len;
    g_return_val_if_fail(st != NULL, FALSE);
    g_return_val_if_fail(error == NULL || *error == NULL, FALSE);
    if (value == NULL) {
        memset(st->buf->data + 8, 0x0, 32);
        return TRUE;
    }
    len = strlen(value);
    if (len > 32) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "string '%s' (0x%x bytes) does not fit in FuStructFmapArea.name (0x%x bytes)",
                    value, (guint) len, (guint) 32);
        return FALSE;
    }
    return fu_memcpy_safe(st->buf->data, st->buf->len, 8, (const guint8 *)value, len, 0x0, len, error);
}
/**
 * fu_struct_fmap_area_set_flags: (skip):
 **/
void
fu_struct_fmap_area_set_flags(FuStructFmapArea *st, guint16 value)
{
    g_return_if_fail(st != NULL);
    fu_memwrite_uint16(st->buf->data + 40, value, G_LITTLE_ENDIAN);
}
/**
 * fu_struct_fmap_area_new: (skip):
 **/
FuStructFmapArea *
fu_struct_fmap_area_new(void)
{
    FuStructFmapArea *st = fu_struct_fmap_area_new_internal();
    st->buf = g_byte_array_sized_new(42);
    fu_byte_array_set_size(st->buf, 42, 0x0);
    return st;
}
/**
 * fu_struct_fmap_area_to_string: (skip):
 **/
static gchar *
fu_struct_fmap_area_to_string(const FuStructFmapArea *st)
{
    g_autoptr(GString) str = g_string_new("FuStructFmapArea:\n");
    g_return_val_if_fail(st != NULL, NULL);
    g_string_append_printf(str, "  offset: 0x%x\n",
                           (guint) fu_struct_fmap_area_get_offset(st));
    g_string_append_printf(str, "  size: 0x%x\n",
                           (guint) fu_struct_fmap_area_get_size(st));
    {
        g_autofree gchar *tmp = fu_struct_fmap_area_get_name(st);
        if (tmp != NULL)
            g_string_append_printf(str, "  name: %s\n", tmp);
    }
    g_string_append_printf(str, "  flags: 0x%x\n",
                           (guint) fu_struct_fmap_area_get_flags(st));
    if (str->len > 0)
        g_string_set_size(str, str->len - 1);
    return g_string_free(g_steal_pointer(&str), FALSE);
}
static gboolean
fu_struct_fmap_area_validate_internal(FuStructFmapArea *st, GError **error)
{
    g_return_val_if_fail(st != NULL, FALSE);
    return TRUE;
}
static gboolean
fu_struct_fmap_area_parse_internal(FuStructFmapArea *st, GError **error)
{
    if (g_getenv("FWUPD_VERBOSE") != NULL) {
        g_autofree gchar *str = fu_struct_fmap_area_to_string(st);
        g_debug("%s", str);
    }
    if (!fu_struct_fmap_area_validate_internal(st, error))
        return FALSE;
    return TRUE;
}
/**
 * fu_struct_fmap_area_parse_stream: (skip):
 **/
FuStructFmapArea *
fu_struct_fmap_area_parse_stream(GInputStream *stream, gsize offset, GError **error)
{
    g_autoptr(FuStructFmapArea) st = fu_struct_fmap_area_new_internal();
    st->buf = fu_input_stream_read_byte_array(stream, offset, 42, NULL, error);
    if (st->buf == NULL) {
        g_prefix_error(error, "FuStructFmapArea failed read of 0x%x: ", (guint) 42);
        return NULL;
    }
    if (st->buf->len != 42) {
        g_set_error(error,
                    FWUPD_ERROR,
                    FWUPD_ERROR_INVALID_DATA,
                    "FuStructFmapArea requested 0x%x and got 0x%x",
                    (guint) 42,
                    (guint) st->buf->len);
        return NULL;
    }
    if (!fu_struct_fmap_area_parse_internal(st, error))
        return NULL;
    return g_steal_pointer(&st);
}
