/* gitg-diff-view-lines-renderer.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-diff-view-lines-renderer.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2015 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtksourceview/gtksource.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <libgit2-glib/ggit.h>
#include <gtk/gtk.h>
#include "libgitg.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GITG_TYPE_DIFF_VIEW_LINES_RENDERER (gitg_diff_view_lines_renderer_get_type ())
#define GITG_DIFF_VIEW_LINES_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GITG_TYPE_DIFF_VIEW_LINES_RENDERER, GitgDiffViewLinesRenderer))
#define GITG_DIFF_VIEW_LINES_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GITG_TYPE_DIFF_VIEW_LINES_RENDERER, GitgDiffViewLinesRendererClass))
#define GITG_IS_DIFF_VIEW_LINES_RENDERER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GITG_TYPE_DIFF_VIEW_LINES_RENDERER))
#define GITG_IS_DIFF_VIEW_LINES_RENDERER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GITG_TYPE_DIFF_VIEW_LINES_RENDERER))
#define GITG_DIFF_VIEW_LINES_RENDERER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GITG_TYPE_DIFF_VIEW_LINES_RENDERER, GitgDiffViewLinesRendererClass))

typedef struct _GitgDiffViewLinesRenderer GitgDiffViewLinesRenderer;
typedef struct _GitgDiffViewLinesRendererClass GitgDiffViewLinesRendererClass;
typedef struct _GitgDiffViewLinesRendererPrivate GitgDiffViewLinesRendererPrivate;

#define GITG_DIFF_VIEW_LINES_RENDERER_TYPE_HUNK_INFO (gitg_diff_view_lines_renderer_hunk_info_get_type ())
typedef struct _GitgDiffViewLinesRendererHunkInfo GitgDiffViewLinesRendererHunkInfo;
typedef enum  {
	GITG_DIFF_VIEW_LINES_RENDERER_STYLE_OLD,
	GITG_DIFF_VIEW_LINES_RENDERER_STYLE_NEW,
	GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL,
	GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL_OLD,
	GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL_NEW
} GitgDiffViewLinesRendererStyle;

#define GITG_DIFF_VIEW_LINES_RENDERER_TYPE_STYLE (gitg_diff_view_lines_renderer_style_get_type ())
enum  {
	GITG_DIFF_VIEW_LINES_RENDERER_0_PROPERTY,
	GITG_DIFF_VIEW_LINES_RENDERER_STYLE_PROPERTY,
	GITG_DIFF_VIEW_LINES_RENDERER_MAXLINES_PROPERTY,
	GITG_DIFF_VIEW_LINES_RENDERER_BUFFER_PROPERTY,
	GITG_DIFF_VIEW_LINES_RENDERER_NUM_PROPERTIES
};
static GParamSpec* gitg_diff_view_lines_renderer_properties[GITG_DIFF_VIEW_LINES_RENDERER_NUM_PROPERTIES];
typedef enum  {
	GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_CONTEXT,
	GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_ADDED,
	GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_REMOVED,
	GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_EMPTY
} GitgDiffViewLinesRendererLine_Style;

#define GITG_DIFF_VIEW_LINES_RENDERER_TYPE_LINE_STYLE (gitg_diff_view_lines_renderer_line_style_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _gitg_diff_view_lines_renderer_hunk_info_free0(var) ((var == NULL) ? NULL : (var = (gitg_diff_view_lines_renderer_hunk_info_free (var), NULL)))
typedef struct _Block11Data Block11Data;
#define _ggit_diff_hunk_unref0(var) ((var == NULL) ? NULL : (var = (ggit_diff_hunk_unref (var), NULL)))

struct _GitgDiffViewLinesRenderer {
	GtkSourceGutterRendererText parent_instance;
	GitgDiffViewLinesRendererPrivate * priv;
};

struct _GitgDiffViewLinesRendererClass {
	GtkSourceGutterRendererTextClass parent_class;
};

struct _GitgDiffViewLinesRendererHunkInfo {
	gint start;
	gint end;
	gint hunk_line;
	GgitDiffHunk* hunk;
	gchar** line_infos;
	gint line_infos_length1;
	gint _line_infos_size_;
};

struct _GitgDiffViewLinesRendererPrivate {
	gint d_num_digits;
	gchar* d_num_digits_fill;
	gulong d_view_style_updated_id;
	GeeArrayList* d_hunks_list;
	GitgDiffViewLinesRendererStyle _style;
	gint d_maxlines;
};

struct _Block11Data {
	int _ref_count_;
	GitgDiffViewLinesRenderer* self;
	GitgDiffViewLinesRendererLine_Style origin;
};

static gint GitgDiffViewLinesRenderer_private_offset;
static gpointer gitg_diff_view_lines_renderer_parent_class = NULL;

VALA_EXTERN GType gitg_diff_view_lines_renderer_get_type (void) G_GNUC_CONST ;
static GType gitg_diff_view_lines_renderer_hunk_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GitgDiffViewLinesRendererHunkInfo* gitg_diff_view_lines_renderer_hunk_info_dup (const GitgDiffViewLinesRendererHunkInfo* self);
static void gitg_diff_view_lines_renderer_hunk_info_free (GitgDiffViewLinesRendererHunkInfo* self);
static void gitg_diff_view_lines_renderer_hunk_info_copy (const GitgDiffViewLinesRendererHunkInfo* self,
                                                   GitgDiffViewLinesRendererHunkInfo* dest);
static void gitg_diff_view_lines_renderer_hunk_info_destroy (GitgDiffViewLinesRendererHunkInfo* self);
VALA_EXTERN GType gitg_diff_view_lines_renderer_style_get_type (void) G_GNUC_CONST ;
static GType gitg_diff_view_lines_renderer_line_style_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GitgDiffViewLinesRenderer* gitg_diff_view_lines_renderer_new (GitgDiffViewLinesRendererStyle style);
VALA_EXTERN GitgDiffViewLinesRenderer* gitg_diff_view_lines_renderer_construct (GType object_type,
                                                                    GitgDiffViewLinesRendererStyle style);
static void gitg_diff_view_lines_renderer_real_query_data (GtkSourceGutterRenderer* base,
                                                    GtkTextIter* start,
                                                    GtkTextIter* end,
                                                    GtkSourceGutterRendererState state);
VALA_EXTERN GitgDiffViewLinesRendererStyle gitg_diff_view_lines_renderer_get_style (GitgDiffViewLinesRenderer* self);
static void gitg_diff_view_lines_renderer_on_view_style_updated (GitgDiffViewLinesRenderer* self);
static void gitg_diff_view_lines_renderer_recalculate_size (GitgDiffViewLinesRenderer* self);
static void gitg_diff_view_lines_renderer_real_change_view (GtkSourceGutterRenderer* base,
                                                     GtkTextView* old_view);
static void _gitg_diff_view_lines_renderer_on_view_style_updated_gtk_widget_style_updated (GtkWidget* _sender,
                                                                                    gpointer self);
static void gitg_diff_view_lines_renderer_calculate_num_digits (GitgDiffViewLinesRenderer* self);
static GitgDiffViewLinesRendererLine_Style gitg_diff_view_lines_renderer_get_origin (GitgDiffViewLinesRenderer* self,
                                                                              gint buffer_line,
                                                                              GtkSourceBuffer* buffer);
static Block11Data* block11_data_ref (Block11Data* _data11_);
static void block11_data_unref (void * _userdata_);
static void ___lambda53_ (Block11Data* _data11_,
                   GtkSourceMark* item);
static void ____lambda53__gfunc (gconstpointer data,
                          gpointer self);
static gchar** gitg_diff_view_lines_renderer_precalculate_line_strings (GitgDiffViewLinesRenderer* self,
                                                                 GgitDiffHunk* hunk,
                                                                 GtkSourceBuffer* buffer,
                                                                 gint buffer_line_start,
                                                                 gint* result_length1);
VALA_EXTERN void gitg_diff_view_lines_renderer_add_hunk (GitgDiffViewLinesRenderer* self,
                                             gint buffer_line_start,
                                             gint buffer_line_end,
                                             GgitDiffHunk* hunk,
                                             GtkSourceBuffer* buffer);
VALA_EXTERN void gitg_diff_view_lines_renderer_set_style (GitgDiffViewLinesRenderer* self,
                                              GitgDiffViewLinesRendererStyle value);
VALA_EXTERN gint gitg_diff_view_lines_renderer_get_maxlines (GitgDiffViewLinesRenderer* self);
VALA_EXTERN void gitg_diff_view_lines_renderer_set_maxlines (GitgDiffViewLinesRenderer* self,
                                                 gint value);
VALA_EXTERN GtkTextBuffer* gitg_diff_view_lines_renderer_get_buffer (GitgDiffViewLinesRenderer* self);
static gchar** _vala_array_dup15 (gchar** self,
                           gssize length);
static GObject * gitg_diff_view_lines_renderer_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static void gitg_diff_view_lines_renderer_finalize (GObject * obj);
static GType gitg_diff_view_lines_renderer_get_type_once (void);
static void _vala_gitg_diff_view_lines_renderer_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_gitg_diff_view_lines_renderer_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
gitg_diff_view_lines_renderer_get_instance_private (GitgDiffViewLinesRenderer* self)
{
	return G_STRUCT_MEMBER_P (self, GitgDiffViewLinesRenderer_private_offset);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_view_lines_renderer_style_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_DIFF_VIEW_LINES_RENDERER_STYLE_OLD, "GITG_DIFF_VIEW_LINES_RENDERER_STYLE_OLD", "old"}, {GITG_DIFF_VIEW_LINES_RENDERER_STYLE_NEW, "GITG_DIFF_VIEW_LINES_RENDERER_STYLE_NEW", "new"}, {GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL, "GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL", "symbol"}, {GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL_OLD, "GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL_OLD", "symbol-old"}, {GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL_NEW, "GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL_NEW", "symbol-new"}, {0, NULL, NULL}};
	GType gitg_diff_view_lines_renderer_style_type_id;
	gitg_diff_view_lines_renderer_style_type_id = g_enum_register_static ("GitgDiffViewLinesRendererStyle", values);
	return gitg_diff_view_lines_renderer_style_type_id;
}

GType
gitg_diff_view_lines_renderer_style_get_type (void)
{
	static gsize gitg_diff_view_lines_renderer_style_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_view_lines_renderer_style_type_id__once)) {
		GType gitg_diff_view_lines_renderer_style_type_id;
		gitg_diff_view_lines_renderer_style_type_id = gitg_diff_view_lines_renderer_style_get_type_once ();
		g_once_init_leave (&gitg_diff_view_lines_renderer_style_type_id__once, gitg_diff_view_lines_renderer_style_type_id);
	}
	return gitg_diff_view_lines_renderer_style_type_id__once;
}

 G_GNUC_NO_INLINE static GType
gitg_diff_view_lines_renderer_line_style_get_type_once (void)
{
	static const GEnumValue values[] = {{GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_CONTEXT, "GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_CONTEXT", "context"}, {GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_ADDED, "GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_ADDED", "added"}, {GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_REMOVED, "GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_REMOVED", "removed"}, {GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_EMPTY, "GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_EMPTY", "empty"}, {0, NULL, NULL}};
	GType gitg_diff_view_lines_renderer_line_style_type_id;
	gitg_diff_view_lines_renderer_line_style_type_id = g_enum_register_static ("GitgDiffViewLinesRendererLine_Style", values);
	return gitg_diff_view_lines_renderer_line_style_type_id;
}

static GType
gitg_diff_view_lines_renderer_line_style_get_type (void)
{
	static gsize gitg_diff_view_lines_renderer_line_style_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_view_lines_renderer_line_style_type_id__once)) {
		GType gitg_diff_view_lines_renderer_line_style_type_id;
		gitg_diff_view_lines_renderer_line_style_type_id = gitg_diff_view_lines_renderer_line_style_get_type_once ();
		g_once_init_leave (&gitg_diff_view_lines_renderer_line_style_type_id__once, gitg_diff_view_lines_renderer_line_style_type_id);
	}
	return gitg_diff_view_lines_renderer_line_style_type_id__once;
}

GitgDiffViewLinesRenderer*
gitg_diff_view_lines_renderer_construct (GType object_type,
                                         GitgDiffViewLinesRendererStyle style)
{
	GitgDiffViewLinesRenderer * self = NULL;
	self = (GitgDiffViewLinesRenderer*) g_object_new (object_type, "style", style, NULL);
	return self;
}

GitgDiffViewLinesRenderer*
gitg_diff_view_lines_renderer_new (GitgDiffViewLinesRendererStyle style)
{
	return gitg_diff_view_lines_renderer_construct (GITG_TYPE_DIFF_VIEW_LINES_RENDERER, style);
}

static gpointer
_gitg_diff_view_lines_renderer_hunk_info_dup0 (gpointer self)
{
	return self ? gitg_diff_view_lines_renderer_hunk_info_dup (self) : NULL;
}

static void
gitg_diff_view_lines_renderer_real_query_data (GtkSourceGutterRenderer* base,
                                               GtkTextIter* start,
                                               GtkTextIter* end,
                                               GtkSourceGutterRendererState state)
{
	GitgDiffViewLinesRenderer * self;
	gint line = 0;
	gboolean is_hunk = FALSE;
	GitgDiffViewLinesRendererHunkInfo* info = NULL;
	gboolean _tmp14_ = FALSE;
	GitgDiffViewLinesRendererHunkInfo* _tmp15_;
	self = (GitgDiffViewLinesRenderer*) base;
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	line = gtk_text_iter_get_line (start);
	is_hunk = FALSE;
	info = NULL;
	{
		GeeArrayList* _i_list = NULL;
		GeeArrayList* _tmp0_;
		gint _i_size = 0;
		GeeArrayList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _i_index = 0;
		_tmp0_ = self->priv->d_hunks_list;
		_i_list = _tmp0_;
		_tmp1_ = _i_list;
		_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_i_size = _tmp3_;
		_i_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			GitgDiffViewLinesRendererHunkInfo* i = NULL;
			GeeArrayList* _tmp6_;
			gpointer _tmp7_;
			GitgDiffViewLinesRendererHunkInfo* _tmp8_;
			_i_index = _i_index + 1;
			_tmp4_ = _i_index;
			_tmp5_ = _i_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _i_list;
			_tmp7_ = gee_abstract_list_get ((GeeAbstractList*) _tmp6_, _i_index);
			i = (GitgDiffViewLinesRendererHunkInfo*) _tmp7_;
			_tmp8_ = i;
			if (line == (*_tmp8_).hunk_line) {
				is_hunk = TRUE;
				_gitg_diff_view_lines_renderer_hunk_info_free0 (i);
				break;
			} else {
				gboolean _tmp9_ = FALSE;
				GitgDiffViewLinesRendererHunkInfo* _tmp10_;
				_tmp10_ = i;
				if (line >= (*_tmp10_).start) {
					GitgDiffViewLinesRendererHunkInfo* _tmp11_;
					_tmp11_ = i;
					_tmp9_ = line <= (*_tmp11_).end;
				} else {
					_tmp9_ = FALSE;
				}
				if (_tmp9_) {
					GitgDiffViewLinesRendererHunkInfo* _tmp12_;
					GitgDiffViewLinesRendererHunkInfo* _tmp13_;
					_tmp12_ = i;
					_tmp13_ = _gitg_diff_view_lines_renderer_hunk_info_dup0 (_tmp12_);
					_gitg_diff_view_lines_renderer_hunk_info_free0 (info);
					info = _tmp13_;
					_gitg_diff_view_lines_renderer_hunk_info_free0 (i);
					break;
				}
			}
			_gitg_diff_view_lines_renderer_hunk_info_free0 (i);
		}
	}
	_tmp15_ = info;
	if (_tmp15_ == NULL) {
		_tmp14_ = TRUE;
	} else {
		GitgDiffViewLinesRendererHunkInfo* _tmp16_;
		GitgDiffViewLinesRendererHunkInfo* _tmp17_;
		gchar** _tmp18_;
		gint _tmp18__length1;
		_tmp16_ = info;
		_tmp17_ = info;
		_tmp18_ = (*_tmp17_).line_infos;
		_tmp18__length1 = (*_tmp17_).line_infos_length1;
		_tmp14_ = (line - (*_tmp16_).start) >= _tmp18__length1;
	}
	if (_tmp14_) {
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		if (is_hunk) {
			GitgDiffViewLinesRendererStyle _tmp22_;
			_tmp22_ = self->priv->_style;
			_tmp21_ = _tmp22_ != GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL;
		} else {
			_tmp21_ = FALSE;
		}
		if (_tmp21_) {
			GitgDiffViewLinesRendererStyle _tmp23_;
			_tmp23_ = self->priv->_style;
			_tmp20_ = _tmp23_ != GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL_OLD;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			GitgDiffViewLinesRendererStyle _tmp24_;
			_tmp24_ = self->priv->_style;
			_tmp19_ = _tmp24_ != GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL_NEW;
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			gtk_source_gutter_renderer_text_set_text ((GtkSourceGutterRendererText*) self, "...", -1);
		} else {
			gtk_source_gutter_renderer_text_set_text ((GtkSourceGutterRendererText*) self, "", -1);
		}
	} else {
		GitgDiffViewLinesRendererHunkInfo* _tmp25_;
		gchar** _tmp26_;
		gint _tmp26__length1;
		GitgDiffViewLinesRendererHunkInfo* _tmp27_;
		const gchar* _tmp28_;
		_tmp25_ = info;
		_tmp26_ = (*_tmp25_).line_infos;
		_tmp26__length1 = (*_tmp25_).line_infos_length1;
		_tmp27_ = info;
		_tmp28_ = _tmp26_[gtk_text_iter_get_line (start) - (*_tmp27_).start];
		gtk_source_gutter_renderer_text_set_text ((GtkSourceGutterRendererText*) self, _tmp28_, -1);
	}
	_gitg_diff_view_lines_renderer_hunk_info_free0 (info);
}

static void
gitg_diff_view_lines_renderer_on_view_style_updated (GitgDiffViewLinesRenderer* self)
{
	g_return_if_fail (self != NULL);
	gitg_diff_view_lines_renderer_recalculate_size (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_gitg_diff_view_lines_renderer_on_view_style_updated_gtk_widget_style_updated (GtkWidget* _sender,
                                                                               gpointer self)
{
	gitg_diff_view_lines_renderer_on_view_style_updated ((GitgDiffViewLinesRenderer*) self);
}

static void
gitg_diff_view_lines_renderer_real_change_view (GtkSourceGutterRenderer* base,
                                                GtkTextView* old_view)
{
	GitgDiffViewLinesRenderer * self;
	GtkTextView* view = NULL;
	GtkTextView* _tmp0_;
	GtkTextView* _tmp1_;
	GtkTextView* _tmp2_;
	self = (GitgDiffViewLinesRenderer*) base;
	if (old_view != NULL) {
		g_signal_handler_disconnect ((GObject*) old_view, self->priv->d_view_style_updated_id);
		self->priv->d_view_style_updated_id = (gulong) 0;
	}
	_tmp0_ = gtk_source_gutter_renderer_get_view ((GtkSourceGutterRenderer*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	view = _tmp1_;
	_tmp2_ = view;
	if (_tmp2_ != NULL) {
		GtkTextView* _tmp3_;
		gulong _tmp4_;
		_tmp3_ = view;
		_tmp4_ = g_signal_connect_object ((GtkWidget*) _tmp3_, "style-updated", (GCallback) _gitg_diff_view_lines_renderer_on_view_style_updated_gtk_widget_style_updated, self, 0);
		self->priv->d_view_style_updated_id = _tmp4_;
		gitg_diff_view_lines_renderer_recalculate_size (self);
	}
	GTK_SOURCE_GUTTER_RENDERER_CLASS (gitg_diff_view_lines_renderer_parent_class)->change_view ((GtkSourceGutterRenderer*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_source_gutter_renderer_text_get_type (), GtkSourceGutterRendererText), old_view);
	_g_object_unref0 (view);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
gitg_diff_view_lines_renderer_recalculate_size (GitgDiffViewLinesRenderer* self)
{
	gint size = 0;
	gint height = 0;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	g_return_if_fail (self != NULL);
	size = 0;
	height = 0;
	_tmp0_ = self->priv->d_num_digits_fill;
	_tmp1_ = string_to_string (_tmp0_);
	gtk_source_gutter_renderer_text_measure ((GtkSourceGutterRendererText*) self, _tmp1_, &_tmp2_, &_tmp3_);
	size = _tmp2_;
	height = _tmp3_;
	gtk_source_gutter_renderer_set_size ((GtkSourceGutterRenderer*) self, size);
}

static void
gitg_diff_view_lines_renderer_calculate_num_digits (GitgDiffViewLinesRenderer* self)
{
	gint num_digits = 0;
	gboolean _tmp0_ = FALSE;
	GitgDiffViewLinesRendererStyle _tmp1_;
	gchar* _tmp20_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_style;
	if (_tmp1_ == GITG_DIFF_VIEW_LINES_RENDERER_STYLE_OLD) {
		_tmp0_ = TRUE;
	} else {
		GitgDiffViewLinesRendererStyle _tmp2_;
		_tmp2_ = self->priv->_style;
		_tmp0_ = _tmp2_ == GITG_DIFF_VIEW_LINES_RENDERER_STYLE_NEW;
	}
	if (_tmp0_) {
		num_digits = 3;
		{
			GeeArrayList* _info_list = NULL;
			GeeArrayList* _tmp3_;
			gint _info_size = 0;
			GeeArrayList* _tmp4_;
			gint _tmp5_;
			gint _tmp6_;
			gint _info_index = 0;
			_tmp3_ = self->priv->d_hunks_list;
			_info_list = _tmp3_;
			_tmp4_ = _info_list;
			_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
			_tmp6_ = _tmp5_;
			_info_size = _tmp6_;
			_info_index = -1;
			while (TRUE) {
				gint _tmp7_;
				gint _tmp8_;
				GitgDiffViewLinesRendererHunkInfo* info = NULL;
				GeeArrayList* _tmp9_;
				gpointer _tmp10_;
				gint oldn = 0;
				GitgDiffViewLinesRendererHunkInfo* _tmp11_;
				GgitDiffHunk* _tmp12_;
				GitgDiffViewLinesRendererHunkInfo* _tmp13_;
				GgitDiffHunk* _tmp14_;
				gint newn = 0;
				GitgDiffViewLinesRendererHunkInfo* _tmp15_;
				GgitDiffHunk* _tmp16_;
				GitgDiffViewLinesRendererHunkInfo* _tmp17_;
				GgitDiffHunk* _tmp18_;
				gint num = 0;
				gint hunk_digits = 0;
				_info_index = _info_index + 1;
				_tmp7_ = _info_index;
				_tmp8_ = _info_size;
				if (!(_tmp7_ < _tmp8_)) {
					break;
				}
				_tmp9_ = _info_list;
				_tmp10_ = gee_abstract_list_get ((GeeAbstractList*) _tmp9_, _info_index);
				info = (GitgDiffViewLinesRendererHunkInfo*) _tmp10_;
				_tmp11_ = info;
				_tmp12_ = (*_tmp11_).hunk;
				_tmp13_ = info;
				_tmp14_ = (*_tmp13_).hunk;
				oldn = ggit_diff_hunk_get_old_start (_tmp12_) + ggit_diff_hunk_get_old_lines (_tmp14_);
				_tmp15_ = info;
				_tmp16_ = (*_tmp15_).hunk;
				_tmp17_ = info;
				_tmp18_ = (*_tmp17_).hunk;
				newn = ggit_diff_hunk_get_new_start (_tmp16_) + ggit_diff_hunk_get_new_lines (_tmp18_);
				num = MAX (MAX (oldn, newn), self->priv->d_maxlines);
				hunk_digits = 0;
				while (TRUE) {
					gint _tmp19_;
					if (!(num > 0)) {
						break;
					}
					hunk_digits = hunk_digits + 1;
					_tmp19_ = hunk_digits;
					num /= 10;
				}
				num_digits = MAX (num_digits, hunk_digits);
				_gitg_diff_view_lines_renderer_hunk_info_free0 (info);
			}
		}
	} else {
		num_digits = 1;
	}
	self->priv->d_num_digits = num_digits;
	_tmp20_ = g_strnfill ((gsize) num_digits, ' ');
	_g_free0 (self->priv->d_num_digits_fill);
	self->priv->d_num_digits_fill = _tmp20_;
}

static Block11Data*
block11_data_ref (Block11Data* _data11_)
{
	g_atomic_int_inc (&_data11_->_ref_count_);
	return _data11_;
}

static void
block11_data_unref (void * _userdata_)
{
	Block11Data* _data11_;
	_data11_ = (Block11Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data11_->_ref_count_)) {
		GitgDiffViewLinesRenderer* self;
		self = _data11_->self;
		_g_object_unref0 (self);
		g_slice_free (Block11Data, _data11_);
	}
}

static void
___lambda53_ (Block11Data* _data11_,
              GtkSourceMark* item)
{
	GitgDiffViewLinesRenderer* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	self = _data11_->self;
	g_return_if_fail (item != NULL);
	_tmp0_ = gtk_source_mark_get_category (item);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("added")))) {
		switch (0) {
			default:
			{
				_data11_->origin = GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_ADDED;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("removed")))) {
		switch (0) {
			default:
			{
				_data11_->origin = GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_REMOVED;
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("empty")))) {
		switch (0) {
			default:
			{
				_data11_->origin = GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_EMPTY;
				break;
			}
		}
	}
}

static void
____lambda53__gfunc (gconstpointer data,
                     gpointer self)
{
	___lambda53_ (self, (GtkSourceMark*) data);
}

static GitgDiffViewLinesRendererLine_Style
gitg_diff_view_lines_renderer_get_origin (GitgDiffViewLinesRenderer* self,
                                          gint buffer_line,
                                          GtkSourceBuffer* buffer)
{
	Block11Data* _data11_;
	GSList* mark = NULL;
	GSList* _tmp0_;
	GSList* _tmp1_;
	GitgDiffViewLinesRendererLine_Style result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (buffer != NULL, 0);
	_data11_ = g_slice_new0 (Block11Data);
	_data11_->_ref_count_ = 1;
	_data11_->self = g_object_ref (self);
	_data11_->origin = GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_CONTEXT;
	_tmp0_ = gtk_source_buffer_get_source_marks_at_line (buffer, buffer_line, NULL);
	mark = _tmp0_;
	_tmp1_ = mark;
	if (_tmp1_ != NULL) {
		GSList* _tmp2_;
		_tmp2_ = mark;
		g_slist_foreach (_tmp2_, ____lambda53__gfunc, _data11_);
	}
	result = _data11_->origin;
	(mark == NULL) ? NULL : (mark = (g_slist_free (mark), NULL));
	block11_data_unref (_data11_);
	_data11_ = NULL;
	return result;
}

static gchar**
gitg_diff_view_lines_renderer_precalculate_line_strings (GitgDiffViewLinesRenderer* self,
                                                         GgitDiffHunk* hunk,
                                                         GtkSourceBuffer* buffer,
                                                         gint buffer_line_start,
                                                         gint* result_length1)
{
	gint oldn = 0;
	gint newn = 0;
	GtkTextIter iter = {0};
	GtkTextIter _tmp0_ = {0};
	gint buffer_line_end = 0;
	gchar** line_infos = NULL;
	gchar** _tmp1_;
	gint line_infos_length1;
	gint _line_infos_size_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	gchar** result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (hunk != NULL, NULL);
	g_return_val_if_fail (buffer != NULL, NULL);
	oldn = ggit_diff_hunk_get_old_start (hunk);
	newn = ggit_diff_hunk_get_new_start (hunk);
	gtk_text_buffer_get_end_iter ((GtkTextBuffer*) buffer, &_tmp0_);
	iter = _tmp0_;
	buffer_line_end = gtk_text_iter_get_line (&iter);
	_tmp1_ = g_new0 (gchar*, ((buffer_line_end - buffer_line_start) + 1) + 1);
	line_infos = _tmp1_;
	line_infos_length1 = (buffer_line_end - buffer_line_start) + 1;
	_line_infos_size_ = line_infos_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GitgDiffViewLinesRendererLine_Style origin = 0;
				gchar* ltext = NULL;
				gchar* _tmp4_;
				GitgDiffViewLinesRendererStyle _tmp5_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i <= (buffer_line_end - buffer_line_start))) {
					break;
				}
				origin = gitg_diff_view_lines_renderer_get_origin (self, buffer_line_start + i, buffer);
				_tmp4_ = g_strdup ("");
				ltext = _tmp4_;
				_tmp5_ = self->priv->_style;
				switch (_tmp5_) {
					case GITG_DIFF_VIEW_LINES_RENDERER_STYLE_NEW:
					{
						gboolean _tmp6_ = FALSE;
						if (origin == GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_CONTEXT) {
							_tmp6_ = TRUE;
						} else {
							_tmp6_ = origin == GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_ADDED;
						}
						if (_tmp6_) {
							gchar* _tmp7_;
							gint _tmp8_;
							_tmp7_ = g_strdup_printf ("%*d", self->priv->d_num_digits, newn);
							_g_free0 (ltext);
							ltext = _tmp7_;
							_tmp8_ = newn;
							newn = _tmp8_ + 1;
						}
						break;
					}
					case GITG_DIFF_VIEW_LINES_RENDERER_STYLE_OLD:
					{
						gboolean _tmp9_ = FALSE;
						if (origin == GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_CONTEXT) {
							_tmp9_ = TRUE;
						} else {
							_tmp9_ = origin == GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_REMOVED;
						}
						if (_tmp9_) {
							gchar* _tmp10_;
							gint _tmp11_;
							_tmp10_ = g_strdup_printf ("%*d", self->priv->d_num_digits, oldn);
							_g_free0 (ltext);
							ltext = _tmp10_;
							_tmp11_ = oldn;
							oldn = _tmp11_ + 1;
						}
						break;
					}
					case GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL:
					{
						if (origin == GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_ADDED) {
							gchar* _tmp12_;
							_tmp12_ = g_strdup ("+");
							_g_free0 (ltext);
							ltext = _tmp12_;
						} else {
							if (origin == GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_REMOVED) {
								gchar* _tmp13_;
								_tmp13_ = g_strdup ("-");
								_g_free0 (ltext);
								ltext = _tmp13_;
							}
						}
						break;
					}
					case GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL_OLD:
					{
						if (origin == GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_REMOVED) {
							gchar* _tmp14_;
							_tmp14_ = g_strdup ("-");
							_g_free0 (ltext);
							ltext = _tmp14_;
						}
						break;
					}
					case GITG_DIFF_VIEW_LINES_RENDERER_STYLE_SYMBOL_NEW:
					{
						if (origin == GITG_DIFF_VIEW_LINES_RENDERER_LINE_STYLE_ADDED) {
							gchar* _tmp15_;
							_tmp15_ = g_strdup ("+");
							_g_free0 (ltext);
							ltext = _tmp15_;
						}
						break;
					}
					default:
					break;
				}
				_tmp16_ = line_infos;
				_tmp16__length1 = line_infos_length1;
				_tmp17_ = ltext;
				_tmp18_ = g_strdup (_tmp17_);
				_g_free0 (_tmp16_[i]);
				_tmp16_[i] = _tmp18_;
				_g_free0 (ltext);
			}
		}
	}
	_tmp19_ = line_infos;
	_tmp19__length1 = line_infos_length1;
	if (result_length1) {
		*result_length1 = _tmp19__length1;
	}
	result = _tmp19_;
	return result;
}

static gpointer
_ggit_diff_hunk_ref0 (gpointer self)
{
	return self ? ggit_diff_hunk_ref (self) : NULL;
}

void
gitg_diff_view_lines_renderer_add_hunk (GitgDiffViewLinesRenderer* self,
                                        gint buffer_line_start,
                                        gint buffer_line_end,
                                        GgitDiffHunk* hunk,
                                        GtkSourceBuffer* buffer)
{
	GitgDiffViewLinesRendererHunkInfo info = {0};
	GgitDiffHunk* _tmp0_;
	gint _tmp1_ = 0;
	gchar** _tmp2_;
	GeeArrayList* _tmp3_;
	GitgDiffViewLinesRendererHunkInfo _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hunk != NULL);
	g_return_if_fail (buffer != NULL);
	memset (&info, 0, sizeof (GitgDiffViewLinesRendererHunkInfo));
	gitg_diff_view_lines_renderer_calculate_num_digits (self);
	info.start = buffer_line_start;
	info.end = buffer_line_end;
	info.hunk_line = buffer_line_start - 1;
	_tmp0_ = _ggit_diff_hunk_ref0 (hunk);
	_ggit_diff_hunk_unref0 (info.hunk);
	info.hunk = _tmp0_;
	_tmp2_ = gitg_diff_view_lines_renderer_precalculate_line_strings (self, hunk, buffer, buffer_line_start, &_tmp1_);
	info.line_infos = (_vala_array_free (info.line_infos, info.line_infos_length1, (GDestroyNotify) g_free), NULL);
	info.line_infos = _tmp2_;
	info.line_infos_length1 = _tmp1_;
	info._line_infos_size_ = info.line_infos_length1;
	_tmp3_ = self->priv->d_hunks_list;
	_tmp4_ = info;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp3_, &_tmp4_);
	gitg_diff_view_lines_renderer_recalculate_size (self);
	gitg_diff_view_lines_renderer_hunk_info_destroy (&info);
}

GitgDiffViewLinesRendererStyle
gitg_diff_view_lines_renderer_get_style (GitgDiffViewLinesRenderer* self)
{
	GitgDiffViewLinesRendererStyle result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_style;
	return result;
}

void
gitg_diff_view_lines_renderer_set_style (GitgDiffViewLinesRenderer* self,
                                         GitgDiffViewLinesRendererStyle value)
{
	GitgDiffViewLinesRendererStyle old_value;
	g_return_if_fail (self != NULL);
	old_value = gitg_diff_view_lines_renderer_get_style (self);
	if (old_value != value) {
		self->priv->_style = value;
		g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_lines_renderer_properties[GITG_DIFF_VIEW_LINES_RENDERER_STYLE_PROPERTY]);
	}
}

gint
gitg_diff_view_lines_renderer_get_maxlines (GitgDiffViewLinesRenderer* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->d_maxlines;
	return result;
}

void
gitg_diff_view_lines_renderer_set_maxlines (GitgDiffViewLinesRenderer* self,
                                            gint value)
{
	g_return_if_fail (self != NULL);
	if (value > self->priv->d_maxlines) {
		self->priv->d_maxlines = value;
		gitg_diff_view_lines_renderer_calculate_num_digits (self);
		gitg_diff_view_lines_renderer_recalculate_size (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gitg_diff_view_lines_renderer_properties[GITG_DIFF_VIEW_LINES_RENDERER_MAXLINES_PROPERTY]);
}

GtkTextBuffer*
gitg_diff_view_lines_renderer_get_buffer (GitgDiffViewLinesRenderer* self)
{
	GtkTextBuffer* result;
	GtkTextView* _tmp0_;
	GtkTextBuffer* _tmp1_;
	GtkTextBuffer* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_source_gutter_renderer_get_view ((GtkSourceGutterRenderer*) self);
	_tmp1_ = gtk_text_view_get_buffer (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static gchar**
_vala_array_dup15 (gchar** self,
                   gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
gitg_diff_view_lines_renderer_hunk_info_copy (const GitgDiffViewLinesRendererHunkInfo* self,
                                              GitgDiffViewLinesRendererHunkInfo* dest)
{
	GgitDiffHunk* _tmp0_;
	GgitDiffHunk* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** _tmp3_;
	gint _tmp3__length1;
	(*dest).start = (*self).start;
	(*dest).end = (*self).end;
	(*dest).hunk_line = (*self).hunk_line;
	_tmp0_ = (*self).hunk;
	_tmp1_ = _ggit_diff_hunk_ref0 (_tmp0_);
	_ggit_diff_hunk_unref0 ((*dest).hunk);
	(*dest).hunk = _tmp1_;
	_tmp2_ = (*self).line_infos;
	_tmp2__length1 = (*self).line_infos_length1;
	_tmp3_ = (_tmp2_ != NULL) ? _vala_array_dup15 (_tmp2_, _tmp2__length1) : _tmp2_;
	_tmp3__length1 = _tmp2__length1;
	(*dest).line_infos = (_vala_array_free ((*dest).line_infos, (*dest).line_infos_length1, (GDestroyNotify) g_free), NULL);
	(*dest).line_infos = _tmp3_;
	(*dest).line_infos_length1 = _tmp3__length1;
	(*dest)._line_infos_size_ = (*dest).line_infos_length1;
}

static void
gitg_diff_view_lines_renderer_hunk_info_destroy (GitgDiffViewLinesRendererHunkInfo* self)
{
	_ggit_diff_hunk_unref0 ((*self).hunk);
	(*self).line_infos = (_vala_array_free ((*self).line_infos, (*self).line_infos_length1, (GDestroyNotify) g_free), NULL);
}

static GitgDiffViewLinesRendererHunkInfo*
gitg_diff_view_lines_renderer_hunk_info_dup (const GitgDiffViewLinesRendererHunkInfo* self)
{
	GitgDiffViewLinesRendererHunkInfo* dup;
	dup = g_new0 (GitgDiffViewLinesRendererHunkInfo, 1);
	gitg_diff_view_lines_renderer_hunk_info_copy (self, dup);
	return dup;
}

static void
gitg_diff_view_lines_renderer_hunk_info_free (GitgDiffViewLinesRendererHunkInfo* self)
{
	gitg_diff_view_lines_renderer_hunk_info_destroy (self);
	g_free (self);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_view_lines_renderer_hunk_info_get_type_once (void)
{
	GType gitg_diff_view_lines_renderer_hunk_info_type_id;
	gitg_diff_view_lines_renderer_hunk_info_type_id = g_boxed_type_register_static ("GitgDiffViewLinesRendererHunkInfo", (GBoxedCopyFunc) gitg_diff_view_lines_renderer_hunk_info_dup, (GBoxedFreeFunc) gitg_diff_view_lines_renderer_hunk_info_free);
	return gitg_diff_view_lines_renderer_hunk_info_type_id;
}

static GType
gitg_diff_view_lines_renderer_hunk_info_get_type (void)
{
	static gsize gitg_diff_view_lines_renderer_hunk_info_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_view_lines_renderer_hunk_info_type_id__once)) {
		GType gitg_diff_view_lines_renderer_hunk_info_type_id;
		gitg_diff_view_lines_renderer_hunk_info_type_id = gitg_diff_view_lines_renderer_hunk_info_get_type_once ();
		g_once_init_leave (&gitg_diff_view_lines_renderer_hunk_info_type_id__once, gitg_diff_view_lines_renderer_hunk_info_type_id);
	}
	return gitg_diff_view_lines_renderer_hunk_info_type_id__once;
}

static GObject *
gitg_diff_view_lines_renderer_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgDiffViewLinesRenderer * self;
	GeeArrayList* _tmp0_;
	parent_class = G_OBJECT_CLASS (gitg_diff_view_lines_renderer_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW_LINES_RENDERER, GitgDiffViewLinesRenderer);
	_tmp0_ = gee_array_list_new (GITG_DIFF_VIEW_LINES_RENDERER_TYPE_HUNK_INFO, (GBoxedCopyFunc) gitg_diff_view_lines_renderer_hunk_info_dup, (GDestroyNotify) gitg_diff_view_lines_renderer_hunk_info_free, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_hunks_list);
	self->priv->d_hunks_list = _tmp0_;
	gtk_source_gutter_renderer_set_alignment ((GtkSourceGutterRenderer*) self, 1.0f, 0.5f);
	gitg_diff_view_lines_renderer_calculate_num_digits (self);
	return obj;
}

static void
gitg_diff_view_lines_renderer_class_init (GitgDiffViewLinesRendererClass * klass,
                                          gpointer klass_data)
{
	gitg_diff_view_lines_renderer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgDiffViewLinesRenderer_private_offset);
	((GtkSourceGutterRendererClass *) klass)->query_data = (void (*) (GtkSourceGutterRenderer*, GtkTextIter*, GtkTextIter*, GtkSourceGutterRendererState)) gitg_diff_view_lines_renderer_real_query_data;
	((GtkSourceGutterRendererClass *) klass)->change_view = (void (*) (GtkSourceGutterRenderer*, GtkTextView*)) gitg_diff_view_lines_renderer_real_change_view;
	G_OBJECT_CLASS (klass)->get_property = _vala_gitg_diff_view_lines_renderer_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gitg_diff_view_lines_renderer_set_property;
	G_OBJECT_CLASS (klass)->constructor = gitg_diff_view_lines_renderer_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_diff_view_lines_renderer_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_LINES_RENDERER_STYLE_PROPERTY, gitg_diff_view_lines_renderer_properties[GITG_DIFF_VIEW_LINES_RENDERER_STYLE_PROPERTY] = g_param_spec_enum ("style", "style", "style", GITG_DIFF_VIEW_LINES_RENDERER_TYPE_STYLE, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_LINES_RENDERER_MAXLINES_PROPERTY, gitg_diff_view_lines_renderer_properties[GITG_DIFF_VIEW_LINES_RENDERER_MAXLINES_PROPERTY] = g_param_spec_int ("maxlines", "maxlines", "maxlines", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GITG_DIFF_VIEW_LINES_RENDERER_BUFFER_PROPERTY, gitg_diff_view_lines_renderer_properties[GITG_DIFF_VIEW_LINES_RENDERER_BUFFER_PROPERTY] = g_param_spec_object ("buffer", "buffer", "buffer", gtk_text_buffer_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
gitg_diff_view_lines_renderer_instance_init (GitgDiffViewLinesRenderer * self,
                                             gpointer klass)
{
	self->priv = gitg_diff_view_lines_renderer_get_instance_private (self);
}

static void
gitg_diff_view_lines_renderer_finalize (GObject * obj)
{
	GitgDiffViewLinesRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_DIFF_VIEW_LINES_RENDERER, GitgDiffViewLinesRenderer);
	_g_free0 (self->priv->d_num_digits_fill);
	_g_object_unref0 (self->priv->d_hunks_list);
	G_OBJECT_CLASS (gitg_diff_view_lines_renderer_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_diff_view_lines_renderer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgDiffViewLinesRendererClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_diff_view_lines_renderer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgDiffViewLinesRenderer), 0, (GInstanceInitFunc) gitg_diff_view_lines_renderer_instance_init, NULL };
	GType gitg_diff_view_lines_renderer_type_id;
	gitg_diff_view_lines_renderer_type_id = g_type_register_static (gtk_source_gutter_renderer_text_get_type (), "GitgDiffViewLinesRenderer", &g_define_type_info, 0);
	GitgDiffViewLinesRenderer_private_offset = g_type_add_instance_private (gitg_diff_view_lines_renderer_type_id, sizeof (GitgDiffViewLinesRendererPrivate));
	return gitg_diff_view_lines_renderer_type_id;
}

GType
gitg_diff_view_lines_renderer_get_type (void)
{
	static gsize gitg_diff_view_lines_renderer_type_id__once = 0;
	if (g_once_init_enter (&gitg_diff_view_lines_renderer_type_id__once)) {
		GType gitg_diff_view_lines_renderer_type_id;
		gitg_diff_view_lines_renderer_type_id = gitg_diff_view_lines_renderer_get_type_once ();
		g_once_init_leave (&gitg_diff_view_lines_renderer_type_id__once, gitg_diff_view_lines_renderer_type_id);
	}
	return gitg_diff_view_lines_renderer_type_id__once;
}

static void
_vala_gitg_diff_view_lines_renderer_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GitgDiffViewLinesRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW_LINES_RENDERER, GitgDiffViewLinesRenderer);
	switch (property_id) {
		case GITG_DIFF_VIEW_LINES_RENDERER_STYLE_PROPERTY:
		g_value_set_enum (value, gitg_diff_view_lines_renderer_get_style (self));
		break;
		case GITG_DIFF_VIEW_LINES_RENDERER_MAXLINES_PROPERTY:
		g_value_set_int (value, gitg_diff_view_lines_renderer_get_maxlines (self));
		break;
		case GITG_DIFF_VIEW_LINES_RENDERER_BUFFER_PROPERTY:
		g_value_set_object (value, gitg_diff_view_lines_renderer_get_buffer (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gitg_diff_view_lines_renderer_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	GitgDiffViewLinesRenderer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GITG_TYPE_DIFF_VIEW_LINES_RENDERER, GitgDiffViewLinesRenderer);
	switch (property_id) {
		case GITG_DIFF_VIEW_LINES_RENDERER_STYLE_PROPERTY:
		gitg_diff_view_lines_renderer_set_style (self, g_value_get_enum (value));
		break;
		case GITG_DIFF_VIEW_LINES_RENDERER_MAXLINES_PROPERTY:
		gitg_diff_view_lines_renderer_set_maxlines (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

