/* recently-played-collection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from recently-played-collection.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "gnome-games.h"
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_COLLECTION (games_collection_get_type ())
#define GAMES_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_COLLECTION, GamesCollection))
#define GAMES_IS_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_COLLECTION))
#define GAMES_COLLECTION_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_COLLECTION, GamesCollectionIface))

typedef struct _GamesCollection GamesCollection;
typedef struct _GamesCollectionIface GamesCollectionIface;

#define GAMES_TYPE_GAME_MODEL (games_game_model_get_type ())
#define GAMES_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModel))
#define GAMES_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))
#define GAMES_IS_GAME_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_MODEL))
#define GAMES_IS_GAME_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_MODEL))
#define GAMES_GAME_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_MODEL, GamesGameModelClass))

typedef struct _GamesGameModel GamesGameModel;
typedef struct _GamesGameModelClass GamesGameModelClass;
typedef enum  {
	GAMES_COLLECTION_TYPE_AUTO,
	GAMES_COLLECTION_TYPE_USER,
	GAMES_COLLECTION_TYPE_PLACEHOLDER
} GamesCollectionType;

#define GAMES_TYPE_COLLECTION_TYPE (games_collection_type_get_type ())

#define GAMES_TYPE_RECENTLY_PLAYED_COLLECTION (games_recently_played_collection_get_type ())
#define GAMES_RECENTLY_PLAYED_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RECENTLY_PLAYED_COLLECTION, GamesRecentlyPlayedCollection))
#define GAMES_RECENTLY_PLAYED_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RECENTLY_PLAYED_COLLECTION, GamesRecentlyPlayedCollectionClass))
#define GAMES_IS_RECENTLY_PLAYED_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RECENTLY_PLAYED_COLLECTION))
#define GAMES_IS_RECENTLY_PLAYED_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RECENTLY_PLAYED_COLLECTION))
#define GAMES_RECENTLY_PLAYED_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RECENTLY_PLAYED_COLLECTION, GamesRecentlyPlayedCollectionClass))

typedef struct _GamesRecentlyPlayedCollection GamesRecentlyPlayedCollection;
typedef struct _GamesRecentlyPlayedCollectionClass GamesRecentlyPlayedCollectionClass;
typedef struct _GamesRecentlyPlayedCollectionPrivate GamesRecentlyPlayedCollectionPrivate;

#define GAMES_TYPE_DATABASE (games_database_get_type ())
#define GAMES_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DATABASE, GamesDatabase))
#define GAMES_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DATABASE, GamesDatabaseClass))
#define GAMES_IS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DATABASE))
#define GAMES_IS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DATABASE))
#define GAMES_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DATABASE, GamesDatabaseClass))

typedef struct _GamesDatabase GamesDatabase;
typedef struct _GamesDatabaseClass GamesDatabaseClass;
enum  {
	GAMES_RECENTLY_PLAYED_COLLECTION_0_PROPERTY,
	GAMES_RECENTLY_PLAYED_COLLECTION_IS_EMPTY_PROPERTY,
	GAMES_RECENTLY_PLAYED_COLLECTION_TITLE_PROPERTY,
	GAMES_RECENTLY_PLAYED_COLLECTION_NUM_PROPERTIES
};
static GParamSpec* games_recently_played_collection_properties[GAMES_RECENTLY_PLAYED_COLLECTION_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define GAMES_TYPE_GAME_COLLECTION (games_game_collection_get_type ())
#define GAMES_GAME_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_COLLECTION, GamesGameCollection))
#define GAMES_GAME_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_COLLECTION, GamesGameCollectionClass))
#define GAMES_IS_GAME_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_COLLECTION))
#define GAMES_IS_GAME_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_COLLECTION))
#define GAMES_GAME_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_COLLECTION, GamesGameCollectionClass))

typedef struct _GamesGameCollection GamesGameCollection;
typedef struct _GamesGameCollectionClass GamesGameCollectionClass;
typedef struct _GamesGameModelPrivate GamesGameModelPrivate;
typedef enum  {
	GAMES_GAME_MODEL_SORT_TYPE_BY_NAME,
	GAMES_GAME_MODEL_SORT_TYPE_BY_LAST_PLAYED
} GamesGameModelSortType;

#define GAMES_GAME_MODEL_TYPE_SORT_TYPE (games_game_model_sort_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block7Data Block7Data;
typedef struct _Block8Data Block8Data;

struct _GamesCollectionIface {
	GTypeInterface parent_iface;
	void (*load) (GamesCollection* self);
	gchar* (*get_id) (GamesCollection* self);
	gboolean (*get_hide_stars) (GamesCollection* self);
	GamesGameModel* (*get_game_model) (GamesCollection* self);
	GamesCollectionType (*get_collection_type) (GamesCollection* self);
	void (*add_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*remove_games) (GamesCollection* self, GamesGame** games, gint games_length1);
	void (*on_game_added) (GamesCollection* self, GamesGame* game);
	void (*on_game_removed) (GamesCollection* self, GamesGame* game);
	void (*on_game_replaced) (GamesCollection* self, GamesGame* game, GamesGame* prev_game);
	gboolean (*get_is_empty) (GamesCollection* self);
	const gchar* (*get_title) (GamesCollection* self);
};

struct _GamesRecentlyPlayedCollection {
	GObject parent_instance;
	GamesRecentlyPlayedCollectionPrivate * priv;
};

struct _GamesRecentlyPlayedCollectionClass {
	GObjectClass parent_class;
};

struct _GamesRecentlyPlayedCollectionPrivate {
	GamesGameModel* game_model;
	GamesDatabase* database;
	GHashTable* game_uids;
	gboolean _is_empty;
};

struct _GamesGameModel {
	GObject parent_instance;
	GamesGameModelPrivate * priv;
	gboolean always_replace;
};

struct _GamesGameModelClass {
	GObjectClass parent_class;
};

struct _Block7Data {
	int _ref_count_;
	GamesRecentlyPlayedCollection* self;
	GamesGame* game;
};

struct _Block8Data {
	int _ref_count_;
	GamesRecentlyPlayedCollection* self;
	GamesGame* game;
};

static gint GamesRecentlyPlayedCollection_private_offset;
static gpointer games_recently_played_collection_parent_class = NULL;
static GamesCollectionIface * games_recently_played_collection_games_collection_parent_iface = NULL;

VALA_EXTERN GType games_game_model_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_recently_played_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType games_database_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesRecentlyPlayedCollection* games_recently_played_collection_new (GamesDatabase* database);
VALA_EXTERN GamesRecentlyPlayedCollection* games_recently_played_collection_construct (GType object_type,
                                                                           GamesDatabase* database);
VALA_EXTERN GType games_game_collection_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesApplication* games_application_get_default (void);
VALA_EXTERN GamesGameCollection* games_application_get_collection (GamesApplication* self);
VALA_EXTERN void games_collection_on_game_added (GamesCollection* self,
                                     GamesGame* game);
static void _games_collection_on_game_added_games_game_collection_game_added (GamesGameCollection* _sender,
                                                                       GamesGame* game,
                                                                       gpointer self);
VALA_EXTERN void games_collection_on_game_removed (GamesCollection* self,
                                       GamesGame* game);
static void _games_collection_on_game_removed_games_game_collection_game_removed (GamesGameCollection* _sender,
                                                                           GamesGame* game,
                                                                           gpointer self);
VALA_EXTERN void games_collection_on_game_replaced (GamesCollection* self,
                                        GamesGame* game,
                                        GamesGame* prev_game);
static void _games_collection_on_game_replaced_games_game_collection_game_replaced (GamesGameCollection* _sender,
                                                                             GamesGame* game,
                                                                             GamesGame* prev_game,
                                                                             gpointer self);
VALA_EXTERN GamesGameModel* games_game_model_new (void);
VALA_EXTERN GamesGameModel* games_game_model_construct (GType object_type);
VALA_EXTERN GType games_game_model_sort_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void games_game_model_set_sort_type (GamesGameModel* self,
                                     GamesGameModelSortType value);
static void __lambda32_ (GamesRecentlyPlayedCollection* self);
static void games_recently_played_collection_set_is_empty (GamesRecentlyPlayedCollection* self,
                                                    gboolean value);
static void ___lambda32__games_game_model_game_added (GamesGameModel* _sender,
                                               GamesGame* game,
                                               gpointer self);
static void __lambda33_ (GamesRecentlyPlayedCollection* self);
static void ___lambda33__games_game_model_game_removed (GamesGameModel* _sender,
                                                 GamesGame* game,
                                                 gpointer self);
VALA_EXTERN gboolean games_collection_get_is_empty (GamesCollection* self);
static gchar* games_recently_played_collection_real_get_id (GamesCollection* base);
static GamesGameModel* games_recently_played_collection_real_get_game_model (GamesCollection* base);
static gboolean games_recently_played_collection_real_get_hide_stars (GamesCollection* base);
static GamesCollectionType games_recently_played_collection_real_get_collection_type (GamesCollection* base);
static void games_recently_played_collection_real_load (GamesCollection* base);
VALA_EXTERN GHashTable* games_database_list_recently_played_games (GamesDatabase* self,
                                                       GError** error);
static void games_recently_played_collection_real_add_games (GamesCollection* base,
                                                      GamesGame** games,
                                                      gint games_length1);
VALA_EXTERN void games_game_model_remove_game (GamesGameModel* self,
                                   GamesGame* game);
VALA_EXTERN void games_database_update_recently_played_game (GamesDatabase* self,
                                                 GamesGame* game,
                                                 gboolean remove,
                                                 GError** error);
VALA_EXTERN void games_game_model_add_game (GamesGameModel* self,
                                GamesGame* game);
static void games_recently_played_collection_real_remove_games (GamesCollection* base,
                                                         GamesGame** games,
                                                         gint games_length1);
static void games_recently_played_collection_real_on_game_added (GamesCollection* base,
                                                          GamesGame* game);
static Block7Data* block7_data_ref (Block7Data* _data7_);
static void block7_data_unref (void * _userdata_);
static void __lambda30_ (Block7Data* _data7_);
VALA_EXTERN void games_collection_add_games (GamesCollection* self,
                                 GamesGame** games,
                                 gint games_length1);
static void ___lambda30__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void games_recently_played_collection_real_on_game_removed (GamesCollection* base,
                                                            GamesGame* game);
VALA_EXTERN void games_collection_remove_games (GamesCollection* self,
                                    GamesGame** games,
                                    gint games_length1);
static void games_recently_played_collection_real_on_game_replaced (GamesCollection* base,
                                                             GamesGame* game,
                                                             GamesGame* prev_game);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
VALA_EXTERN void games_game_model_replace_game (GamesGameModel* self,
                                    GamesGame* game,
                                    GamesGame* prev_game);
static void __lambda31_ (Block8Data* _data8_);
static void ___lambda31__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
VALA_EXTERN gchar* games_collection_get_id (GamesCollection* self);
VALA_EXTERN GamesGameModel* games_collection_get_game_model (GamesCollection* self);
VALA_EXTERN gboolean games_collection_get_hide_stars (GamesCollection* self);
VALA_EXTERN GamesCollectionType games_collection_get_collection_type (GamesCollection* self);
VALA_EXTERN void games_collection_load (GamesCollection* self);
VALA_EXTERN const gchar* games_collection_get_title (GamesCollection* self);
static void games_recently_played_collection_finalize (GObject * obj);
static GType games_recently_played_collection_get_type_once (void);
static void _vala_games_recently_played_collection_get_property (GObject * object,
                                                          guint property_id,
                                                          GValue * value,
                                                          GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static inline gpointer
games_recently_played_collection_get_instance_private (GamesRecentlyPlayedCollection* self)
{
	return G_STRUCT_MEMBER_P (self, GamesRecentlyPlayedCollection_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_games_collection_on_game_added_games_game_collection_game_added (GamesGameCollection* _sender,
                                                                  GamesGame* game,
                                                                  gpointer self)
{
	games_collection_on_game_added ((GamesCollection*) self, game);
}

static void
_games_collection_on_game_removed_games_game_collection_game_removed (GamesGameCollection* _sender,
                                                                      GamesGame* game,
                                                                      gpointer self)
{
	games_collection_on_game_removed ((GamesCollection*) self, game);
}

static void
_games_collection_on_game_replaced_games_game_collection_game_replaced (GamesGameCollection* _sender,
                                                                        GamesGame* game,
                                                                        GamesGame* prev_game,
                                                                        gpointer self)
{
	games_collection_on_game_replaced ((GamesCollection*) self, game, prev_game);
}

static void
__lambda32_ (GamesRecentlyPlayedCollection* self)
{
	games_recently_played_collection_set_is_empty (self, FALSE);
}

static void
___lambda32__games_game_model_game_added (GamesGameModel* _sender,
                                          GamesGame* game,
                                          gpointer self)
{
	__lambda32_ ((GamesRecentlyPlayedCollection*) self);
}

static void
__lambda33_ (GamesRecentlyPlayedCollection* self)
{
	GamesGameModel* _tmp0_;
	_tmp0_ = self->priv->game_model;
	games_recently_played_collection_set_is_empty (self, g_list_model_get_n_items ((GListModel*) _tmp0_) == ((guint) 0));
}

static void
___lambda33__games_game_model_game_removed (GamesGameModel* _sender,
                                            GamesGame* game,
                                            gpointer self)
{
	__lambda33_ ((GamesRecentlyPlayedCollection*) self);
}

GamesRecentlyPlayedCollection*
games_recently_played_collection_construct (GType object_type,
                                            GamesDatabase* database)
{
	GamesRecentlyPlayedCollection * self = NULL;
	GamesDatabase* _tmp0_;
	GamesGameCollection* game_collection = NULL;
	GamesApplication* _tmp1_;
	GamesApplication* _tmp2_;
	GamesGameCollection* _tmp3_;
	GamesGameCollection* _tmp4_;
	GamesGameModel* _tmp5_;
	GamesGameModel* _tmp6_;
	GamesGameModel* _tmp7_;
	GamesGameModel* _tmp8_;
	GamesGameModel* _tmp9_;
	g_return_val_if_fail (database != NULL, NULL);
	self = (GamesRecentlyPlayedCollection*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (database);
	_g_object_unref0 (self->priv->database);
	self->priv->database = _tmp0_;
	_tmp1_ = games_application_get_default ();
	_tmp2_ = _tmp1_;
	_tmp3_ = games_application_get_collection (_tmp2_);
	_tmp4_ = _tmp3_;
	_g_object_unref0 (_tmp2_);
	game_collection = _tmp4_;
	g_signal_connect_object (game_collection, "game-added", (GCallback) _games_collection_on_game_added_games_game_collection_game_added, (GamesCollection*) self, 0);
	g_signal_connect_object (game_collection, "game-removed", (GCallback) _games_collection_on_game_removed_games_game_collection_game_removed, (GamesCollection*) self, 0);
	g_signal_connect_object (game_collection, "game-replaced", (GCallback) _games_collection_on_game_replaced_games_game_collection_game_replaced, (GamesCollection*) self, 0);
	_tmp5_ = games_game_model_new ();
	_g_object_unref0 (self->priv->game_model);
	self->priv->game_model = _tmp5_;
	_tmp6_ = self->priv->game_model;
	_tmp6_->always_replace = TRUE;
	_tmp7_ = self->priv->game_model;
	games_game_model_set_sort_type (_tmp7_, GAMES_GAME_MODEL_SORT_TYPE_BY_LAST_PLAYED);
	_tmp8_ = self->priv->game_model;
	g_signal_connect_object (_tmp8_, "game-added", (GCallback) ___lambda32__games_game_model_game_added, self, 0);
	_tmp9_ = self->priv->game_model;
	g_signal_connect_object (_tmp9_, "game-removed", (GCallback) ___lambda33__games_game_model_game_removed, self, 0);
	_g_object_unref0 (game_collection);
	return self;
}

GamesRecentlyPlayedCollection*
games_recently_played_collection_new (GamesDatabase* database)
{
	return games_recently_played_collection_construct (GAMES_TYPE_RECENTLY_PLAYED_COLLECTION, database);
}

static void
games_recently_played_collection_set_is_empty (GamesRecentlyPlayedCollection* self,
                                               gboolean value)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_collection_get_is_empty ((GamesCollection*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_ == value) {
		return;
	}
	self->priv->_is_empty = value;
	g_object_notify ((GObject*) self, "is-empty");
}

static gchar*
games_recently_played_collection_real_get_id (GamesCollection* base)
{
	GamesRecentlyPlayedCollection * self;
	gchar* _tmp0_;
	gchar* result;
	self = (GamesRecentlyPlayedCollection*) base;
	_tmp0_ = g_strdup ("Recently Played");
	result = _tmp0_;
	return result;
}

static GamesGameModel*
games_recently_played_collection_real_get_game_model (GamesCollection* base)
{
	GamesRecentlyPlayedCollection * self;
	GamesGameModel* _tmp0_;
	GamesGameModel* _tmp1_;
	GamesGameModel* result;
	self = (GamesRecentlyPlayedCollection*) base;
	_tmp0_ = self->priv->game_model;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
games_recently_played_collection_real_get_hide_stars (GamesCollection* base)
{
	GamesRecentlyPlayedCollection * self;
	gboolean result;
	self = (GamesRecentlyPlayedCollection*) base;
	result = FALSE;
	return result;
}

static GamesCollectionType
games_recently_played_collection_real_get_collection_type (GamesCollection* base)
{
	GamesRecentlyPlayedCollection * self;
	GamesCollectionType result;
	self = (GamesRecentlyPlayedCollection*) base;
	result = GAMES_COLLECTION_TYPE_AUTO;
	return result;
}

static void
games_recently_played_collection_real_load (GamesCollection* base)
{
	GamesRecentlyPlayedCollection * self;
	GError* _inner_error0_ = NULL;
	self = (GamesRecentlyPlayedCollection*) base;
	{
		GHashTable* _tmp0_ = NULL;
		GamesDatabase* _tmp1_;
		GHashTable* _tmp2_;
		GHashTable* _tmp3_;
		_tmp1_ = self->priv->database;
		_tmp2_ = games_database_list_recently_played_games (_tmp1_, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_hash_table_unref0 (self->priv->game_uids);
		self->priv->game_uids = _tmp3_;
		_g_hash_table_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("recently-played-collection.vala:66: Failed to load recently played gam" \
"e uids: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
games_recently_played_collection_real_add_games (GamesCollection* base,
                                                 GamesGame** games,
                                                 gint games_length1)
{
	GamesRecentlyPlayedCollection * self;
	GError* _inner_error0_ = NULL;
	self = (GamesRecentlyPlayedCollection*) base;
	{
		{
			GamesGame** game_collection = NULL;
			gint game_collection_length1 = 0;
			gint _game_collection_size_ = 0;
			gint game_it = 0;
			game_collection = games;
			game_collection_length1 = games_length1;
			for (game_it = 0; game_it < game_collection_length1; game_it = game_it + 1) {
				GamesGame* _tmp0_;
				GamesGame* game = NULL;
				_tmp0_ = _g_object_ref0 (game_collection[game_it]);
				game = _tmp0_;
				{
					GamesGameModel* _tmp1_;
					GamesGame* _tmp2_;
					GamesDatabase* _tmp3_;
					GamesGame* _tmp4_;
					GamesGameModel* _tmp5_;
					GamesGame* _tmp6_;
					_tmp1_ = self->priv->game_model;
					_tmp2_ = game;
					games_game_model_remove_game (_tmp1_, _tmp2_);
					_tmp3_ = self->priv->database;
					_tmp4_ = game;
					games_database_update_recently_played_game (_tmp3_, _tmp4_, FALSE, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (game);
						goto __catch0_g_error;
					}
					_tmp5_ = self->priv->game_model;
					_tmp6_ = game;
					games_game_model_add_game (_tmp5_, _tmp6_);
					_g_object_unref0 (game);
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_critical ("recently-played-collection.vala:80: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_emit_by_name ((GamesCollection*) self, "games-changed");
}

static void
games_recently_played_collection_real_remove_games (GamesCollection* base,
                                                    GamesGame** games,
                                                    gint games_length1)
{
	GamesRecentlyPlayedCollection * self;
	GError* _inner_error0_ = NULL;
	self = (GamesRecentlyPlayedCollection*) base;
	{
		{
			GamesGame** game_collection = NULL;
			gint game_collection_length1 = 0;
			gint _game_collection_size_ = 0;
			gint game_it = 0;
			game_collection = games;
			game_collection_length1 = games_length1;
			for (game_it = 0; game_it < game_collection_length1; game_it = game_it + 1) {
				GamesGame* _tmp0_;
				GamesGame* game = NULL;
				_tmp0_ = _g_object_ref0 (game_collection[game_it]);
				game = _tmp0_;
				{
					GamesGame* _tmp1_;
					GDateTime* _tmp2_;
					GDateTime* _tmp3_;
					GamesDatabase* _tmp4_;
					GamesGame* _tmp5_;
					GamesGameModel* _tmp6_;
					GamesGame* _tmp7_;
					_tmp1_ = game;
					_tmp2_ = games_game_get_last_played (_tmp1_);
					_tmp3_ = _tmp2_;
					if (_tmp3_ == NULL) {
						_g_object_unref0 (game);
						continue;
					}
					_tmp4_ = self->priv->database;
					_tmp5_ = game;
					games_database_update_recently_played_game (_tmp4_, _tmp5_, TRUE, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						_g_object_unref0 (game);
						goto __catch0_g_error;
					}
					_tmp6_ = self->priv->game_model;
					_tmp7_ = game;
					games_game_model_remove_game (_tmp6_, _tmp7_);
					_g_object_unref0 (game);
				}
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_critical ("recently-played-collection.vala:97: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_emit_by_name ((GamesCollection*) self, "games-changed");
}

static Block7Data*
block7_data_ref (Block7Data* _data7_)
{
	g_atomic_int_inc (&_data7_->_ref_count_);
	return _data7_;
}

static void
block7_data_unref (void * _userdata_)
{
	Block7Data* _data7_;
	_data7_ = (Block7Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data7_->_ref_count_)) {
		GamesRecentlyPlayedCollection* self;
		self = _data7_->self;
		_g_object_unref0 (_data7_->game);
		_g_object_unref0 (self);
		g_slice_free (Block7Data, _data7_);
	}
}

static void
__lambda30_ (Block7Data* _data7_)
{
	GamesRecentlyPlayedCollection* self;
	GamesGame* _tmp0_;
	GamesGame** _tmp1_;
	GamesGame** _tmp2_;
	gint _tmp2__length1;
	self = _data7_->self;
	_tmp0_ = _g_object_ref0 (_data7_->game);
	_tmp1_ = g_new0 (GamesGame*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	games_collection_add_games ((GamesCollection*) self, _tmp2_, (gint) 1);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
___lambda30__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda30_ (self);
}

static void
games_recently_played_collection_real_on_game_added (GamesCollection* base,
                                                     GamesGame* game)
{
	GamesRecentlyPlayedCollection * self;
	Block7Data* _data7_;
	GamesGame* _tmp0_;
	GHashTable* _tmp1_;
	GamesUid* _tmp2_;
	GamesUid* _tmp3_;
	self = (GamesRecentlyPlayedCollection*) base;
	g_return_if_fail (game != NULL);
	_data7_ = g_slice_new0 (Block7Data);
	_data7_->_ref_count_ = 1;
	_data7_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data7_->game);
	_data7_->game = _tmp0_;
	g_signal_connect_data ((GObject*) _data7_->game, "notify::last-played", (GCallback) ___lambda30__g_object_notify, block7_data_ref (_data7_), (GClosureNotify) block7_data_unref, 0);
	_tmp1_ = self->priv->game_uids;
	_tmp2_ = games_game_get_uid (_data7_->game);
	_tmp3_ = _tmp2_;
	if (g_hash_table_remove (_tmp1_, _tmp3_)) {
		GamesGameModel* _tmp4_;
		_tmp4_ = self->priv->game_model;
		games_game_model_add_game (_tmp4_, _data7_->game);
		g_signal_emit_by_name ((GamesCollection*) self, "games-changed");
	}
	block7_data_unref (_data7_);
	_data7_ = NULL;
}

static void
games_recently_played_collection_real_on_game_removed (GamesCollection* base,
                                                       GamesGame* game)
{
	GamesRecentlyPlayedCollection * self;
	GamesGame* _tmp0_;
	GamesGame** _tmp1_;
	GamesGame** _tmp2_;
	gint _tmp2__length1;
	self = (GamesRecentlyPlayedCollection*) base;
	g_return_if_fail (game != NULL);
	_tmp0_ = _g_object_ref0 (game);
	_tmp1_ = g_new0 (GamesGame*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	games_collection_remove_games ((GamesCollection*) self, _tmp2_, (gint) 1);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_object_unref), NULL);
	g_signal_emit_by_name ((GamesCollection*) self, "games-changed");
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		GamesRecentlyPlayedCollection* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->game);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda31_ (Block8Data* _data8_)
{
	GamesRecentlyPlayedCollection* self;
	GamesGame* _tmp0_;
	GamesGame** _tmp1_;
	GamesGame** _tmp2_;
	gint _tmp2__length1;
	self = _data8_->self;
	_tmp0_ = _g_object_ref0 (_data8_->game);
	_tmp1_ = g_new0 (GamesGame*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	games_collection_add_games ((GamesCollection*) self, _tmp2_, (gint) 1);
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_object_unref), NULL);
}

static void
___lambda31__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda31_ (self);
}

static void
games_recently_played_collection_real_on_game_replaced (GamesCollection* base,
                                                        GamesGame* game,
                                                        GamesGame* prev_game)
{
	GamesRecentlyPlayedCollection * self;
	Block8Data* _data8_;
	GamesGame* _tmp0_;
	GDateTime* _tmp1_;
	GDateTime* _tmp2_;
	self = (GamesRecentlyPlayedCollection*) base;
	g_return_if_fail (game != NULL);
	g_return_if_fail (prev_game != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (game);
	_g_object_unref0 (_data8_->game);
	_data8_->game = _tmp0_;
	_tmp1_ = games_game_get_last_played (prev_game);
	_tmp2_ = _tmp1_;
	if (_tmp2_ != NULL) {
		GDateTime* _tmp3_;
		GDateTime* _tmp4_;
		GamesGameModel* _tmp5_;
		_tmp3_ = games_game_get_last_played (prev_game);
		_tmp4_ = _tmp3_;
		games_game_set_last_played (_data8_->game, _tmp4_);
		_tmp5_ = self->priv->game_model;
		games_game_model_replace_game (_tmp5_, _data8_->game, prev_game);
	}
	g_signal_handlers_disconnect_by_data (prev_game, self);
	g_signal_connect_data ((GObject*) _data8_->game, "notify::last-played", (GCallback) ___lambda31__g_object_notify, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static gboolean
games_recently_played_collection_real_get_is_empty (GamesCollection* base)
{
	gboolean result;
	GamesRecentlyPlayedCollection* self;
	self = (GamesRecentlyPlayedCollection*) base;
	result = self->priv->_is_empty;
	return result;
}

static const gchar*
games_recently_played_collection_real_get_title (GamesCollection* base)
{
	const gchar* result;
	GamesRecentlyPlayedCollection* self;
	self = (GamesRecentlyPlayedCollection*) base;
	result = _ ("Recently Played");
	return result;
}

static void
games_recently_played_collection_class_init (GamesRecentlyPlayedCollectionClass * klass,
                                             gpointer klass_data)
{
	games_recently_played_collection_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesRecentlyPlayedCollection_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_games_recently_played_collection_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_recently_played_collection_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RECENTLY_PLAYED_COLLECTION_IS_EMPTY_PROPERTY, games_recently_played_collection_properties[GAMES_RECENTLY_PLAYED_COLLECTION_IS_EMPTY_PROPERTY] = g_param_spec_boolean ("is-empty", "is-empty", "is-empty", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RECENTLY_PLAYED_COLLECTION_TITLE_PROPERTY, games_recently_played_collection_properties[GAMES_RECENTLY_PLAYED_COLLECTION_TITLE_PROPERTY] = g_param_spec_string ("title", "title", "title", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
games_recently_played_collection_games_collection_interface_init (GamesCollectionIface * iface,
                                                                  gpointer iface_data)
{
	games_recently_played_collection_games_collection_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_id = (gchar* (*) (GamesCollection*)) games_recently_played_collection_real_get_id;
	iface->get_game_model = (GamesGameModel* (*) (GamesCollection*)) games_recently_played_collection_real_get_game_model;
	iface->get_hide_stars = (gboolean (*) (GamesCollection*)) games_recently_played_collection_real_get_hide_stars;
	iface->get_collection_type = (GamesCollectionType (*) (GamesCollection*)) games_recently_played_collection_real_get_collection_type;
	iface->load = (void (*) (GamesCollection*)) games_recently_played_collection_real_load;
	iface->add_games = (void (*) (GamesCollection*, GamesGame**, gint)) games_recently_played_collection_real_add_games;
	iface->remove_games = (void (*) (GamesCollection*, GamesGame**, gint)) games_recently_played_collection_real_remove_games;
	iface->on_game_added = (void (*) (GamesCollection*, GamesGame*)) games_recently_played_collection_real_on_game_added;
	iface->on_game_removed = (void (*) (GamesCollection*, GamesGame*)) games_recently_played_collection_real_on_game_removed;
	iface->on_game_replaced = (void (*) (GamesCollection*, GamesGame*, GamesGame*)) games_recently_played_collection_real_on_game_replaced;
	iface->get_is_empty = games_recently_played_collection_real_get_is_empty;
	iface->get_title = games_recently_played_collection_real_get_title;
}

static void
games_recently_played_collection_instance_init (GamesRecentlyPlayedCollection * self,
                                                gpointer klass)
{
	self->priv = games_recently_played_collection_get_instance_private (self);
	self->priv->_is_empty = TRUE;
}

static void
games_recently_played_collection_finalize (GObject * obj)
{
	GamesRecentlyPlayedCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RECENTLY_PLAYED_COLLECTION, GamesRecentlyPlayedCollection);
	_g_object_unref0 (self->priv->game_model);
	_g_object_unref0 (self->priv->database);
	_g_hash_table_unref0 (self->priv->game_uids);
	G_OBJECT_CLASS (games_recently_played_collection_parent_class)->finalize (obj);
}

static GType
games_recently_played_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesRecentlyPlayedCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_recently_played_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRecentlyPlayedCollection), 0, (GInstanceInitFunc) games_recently_played_collection_instance_init, NULL };
	static const GInterfaceInfo games_collection_info = { (GInterfaceInitFunc) games_recently_played_collection_games_collection_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType games_recently_played_collection_type_id;
	games_recently_played_collection_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRecentlyPlayedCollection", &g_define_type_info, 0);
	g_type_add_interface_static (games_recently_played_collection_type_id, GAMES_TYPE_COLLECTION, &games_collection_info);
	GamesRecentlyPlayedCollection_private_offset = g_type_add_instance_private (games_recently_played_collection_type_id, sizeof (GamesRecentlyPlayedCollectionPrivate));
	return games_recently_played_collection_type_id;
}

GType
games_recently_played_collection_get_type (void)
{
	static volatile gsize games_recently_played_collection_type_id__once = 0;
	if (g_once_init_enter (&games_recently_played_collection_type_id__once)) {
		GType games_recently_played_collection_type_id;
		games_recently_played_collection_type_id = games_recently_played_collection_get_type_once ();
		g_once_init_leave (&games_recently_played_collection_type_id__once, games_recently_played_collection_type_id);
	}
	return games_recently_played_collection_type_id__once;
}

static void
_vala_games_recently_played_collection_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec)
{
	GamesRecentlyPlayedCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RECENTLY_PLAYED_COLLECTION, GamesRecentlyPlayedCollection);
	switch (property_id) {
		case GAMES_RECENTLY_PLAYED_COLLECTION_IS_EMPTY_PROPERTY:
		g_value_set_boolean (value, games_collection_get_is_empty ((GamesCollection*) self));
		break;
		case GAMES_RECENTLY_PLAYED_COLLECTION_TITLE_PROPERTY:
		g_value_set_string (value, games_collection_get_title ((GamesCollection*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

