/* klotski-window.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from klotski-window.vala, do not modify */

/*
   This file is part of GNOME Klotski.

   Copyright (C) 2010-2013 Robert Ancell

   GNOME Klotski is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Klotski is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with GNOME Klotski.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <libgnome-games-support.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>
#include <gee.h>
#include <gdk/gdk.h>
#include <glib/gstdio.h>

#define KLOTSKI_WINDOW_KEY_LEVEL "level"
#define KLOTSKI_PROGRAM_NAME _ ("Klotski")
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_KLOTSKI_WINDOW (klotski_window_get_type ())
#define KLOTSKI_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_KLOTSKI_WINDOW, KlotskiWindow))
#define KLOTSKI_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_KLOTSKI_WINDOW, KlotskiWindowClass))
#define IS_KLOTSKI_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_KLOTSKI_WINDOW))
#define IS_KLOTSKI_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_KLOTSKI_WINDOW))
#define KLOTSKI_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_KLOTSKI_WINDOW, KlotskiWindowClass))

typedef struct _KlotskiWindow KlotskiWindow;
typedef struct _KlotskiWindowClass KlotskiWindowClass;
typedef struct _KlotskiWindowPrivate KlotskiWindowPrivate;

#define TYPE_PUZZLE_VIEW (puzzle_view_get_type ())
#define PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE_VIEW, PuzzleView))
#define PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE_VIEW, PuzzleViewClass))
#define IS_PUZZLE_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE_VIEW))
#define IS_PUZZLE_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE_VIEW))
#define PUZZLE_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE_VIEW, PuzzleViewClass))

typedef struct _PuzzleView PuzzleView;
typedef struct _PuzzleViewClass PuzzleViewClass;

#define TYPE_PUZZLE (puzzle_get_type ())
#define PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PUZZLE, Puzzle))
#define PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PUZZLE, PuzzleClass))
#define IS_PUZZLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PUZZLE))
#define IS_PUZZLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PUZZLE))
#define PUZZLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PUZZLE, PuzzleClass))

typedef struct _Puzzle Puzzle;
typedef struct _PuzzleClass PuzzleClass;
enum  {
	KLOTSKI_WINDOW_0_PROPERTY,
	KLOTSKI_WINDOW_NUM_PROPERTIES
};
static GParamSpec* klotski_window_properties[KLOTSKI_WINDOW_NUM_PROPERTIES];

#define KLOTSKI_WINDOW_TYPE_LEVEL_INFO (klotski_window_level_info_get_type ())
typedef struct _KlotskiWindowLevelInfo KlotskiWindowLevelInfo;
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_key_file_unref0(var) ((var == NULL) ? NULL : (var = (g_key_file_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _KlotskiWindow {
	GtkApplicationWindow parent_instance;
	KlotskiWindowPrivate * priv;
};

struct _KlotskiWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _KlotskiWindowPrivate {
	GSettings* settings;
	gint window_width;
	gint window_height;
	gboolean window_is_fullscreen;
	gboolean window_is_maximized;
	gboolean window_is_tiled;
	GtkHeaderBar* headerbar;
	GtkStack* stack_packs;
	GtkStack* stack_puzzles;
	GtkPopover* puzzles_popover;
	GtkMenuButton* game_menubutton;
	GtkMenuButton* main_menubutton;
	PuzzleView* view;
	GtkTreeView* treeview_huarong;
	GtkTreeView* treeview_challenge;
	GtkTreeView* treeview_skill;
	GtkGrid* main_grid;
	GtkButton* unfullscreen_button;
	GSimpleAction* prev_pack;
	GSimpleAction* next_pack;
	GSimpleAction* prev_puzzle;
	GSimpleAction* next_puzzle;
	GSimpleAction* start_game;
	gboolean puzzle_init_done;
	Puzzle* puzzle;
	gint current_pack;
	gint current_level;
	GamesScoresContext* scores_context;
	GtkListStore* liststore_huarong;
	GtkListStore* liststore_challenge;
	GtkListStore* liststore_skill;
	GtkTreeIter* puzzles_items;
	gint puzzles_items_length1;
	gint _puzzles_items_size_;
	GtkStyleContext* window_style_context;
	gboolean highcontrast_state;
	GtkEventControllerKey* key_controller;
};

struct _KlotskiWindowLevelInfo {
	gchar* name;
	guint8 group;
	guint8 width;
	guint8 height;
	gchar* data;
};

static gint KlotskiWindow_private_offset;
static gpointer klotski_window_parent_class = NULL;
static GeeList* klotski_window_score_categories;
static GeeList* klotski_window_score_categories = NULL;

VALA_EXTERN GType klotski_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (KlotskiWindow, g_object_unref)
VALA_EXTERN GType puzzle_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PuzzleView, g_object_unref)
VALA_EXTERN GType puzzle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Puzzle, g_object_unref)
static GType klotski_window_level_info_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static KlotskiWindowLevelInfo* klotski_window_level_info_dup (const KlotskiWindowLevelInfo* self);
static void klotski_window_level_info_free (KlotskiWindowLevelInfo* self);
static void klotski_window_level_info_copy (const KlotskiWindowLevelInfo* self,
                                     KlotskiWindowLevelInfo* dest);
static void klotski_window_level_info_destroy (KlotskiWindowLevelInfo* self);
G_DEFINE_AUTO_CLEANUP_CLEAR_FUNC (KlotskiWindowLevelInfo, klotski_window_level_info_destroy)
static void klotski_window_show_scores (KlotskiWindow* self);
static void _klotski_window_show_scores_gsimple_action_activate_callback (GSimpleAction* action,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void klotski_window_prev_pack_cb (KlotskiWindow* self);
static void _klotski_window_prev_pack_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void klotski_window_next_pack_cb (KlotskiWindow* self);
static void _klotski_window_next_pack_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                    GVariant* parameter,
                                                                    gpointer self);
static void klotski_window_prev_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_prev_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void klotski_window_next_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_next_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                      GVariant* parameter,
                                                                      gpointer self);
static void klotski_window_start_puzzle_cb (KlotskiWindow* self);
static void _klotski_window_start_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                       GVariant* parameter,
                                                                       gpointer self);
static void _gtk_window_unfullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static inline void klotski_window_help_cb (KlotskiWindow* self);
static void _klotski_window_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self);
static inline void klotski_window_about_cb (KlotskiWindow* self);
static void _klotski_window_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static gchar* klotski_window_normalize_map_name (const gchar* name);
static GamesScoresCategory* klotski_window_category_request (KlotskiWindow* self,
                                                      const gchar* key);
static void klotski_window_parse_old_score (KlotskiWindow* self,
                                     const gchar* line,
                                     GamesScoresScore** score,
                                     GamesScoresCategory** category);
static void klotski_window_lookup_non_nullable_action (KlotskiWindow* self,
                                                const gchar* name,
                                                GSimpleAction** action);
static void klotski_window_on_size_allocate (KlotskiWindow* self,
                                      GtkAllocation* allocation);
static void klotski_window_update_window_state (KlotskiWindow* self);
static void _klotski_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                GtkAllocation* allocation,
                                                                gpointer self);
static gboolean klotski_window_on_window_state_event (KlotskiWindow* self,
                                               GdkEventWindowState* event);
VALA_EXTERN void klotski_window_on_unfullscreen (KlotskiWindow* self);
VALA_EXTERN void klotski_window_on_fullscreen (KlotskiWindow* self);
static gboolean _klotski_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                              GdkEventWindowState* event,
                                                                              gpointer self);
static void klotski_window_on_destroy (KlotskiWindow* self);
static void klotski_window_save_window_state (KlotskiWindow* self);
static void _klotski_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                                    gpointer self);
static gint* _int_dup (gint* self);
static void klotski_window_update_popover (KlotskiWindow* self,
                                    gboolean make_current);
static void klotski_window_start_puzzle (KlotskiWindow* self);
static void klotski_window_start_puzzle_from_iter (KlotskiWindow* self,
                                            GtkListStore* model,
                                            GtkTreeIter* iter);
static void klotski_window_update_buttons_state (KlotskiWindow* self);
static void klotski_window_level_huarong_cb (KlotskiWindow* self,
                                      GtkTreePath* path,
                                      GtkTreeViewColumn* column);
static void klotski_window_level_cb (KlotskiWindow* self,
                              GtkListStore* liststore,
                              GtkTreePath* path,
                              GtkTreeViewColumn* column);
static void klotski_window_level_challenge_cb (KlotskiWindow* self,
                                        GtkTreePath* path,
                                        GtkTreeViewColumn* column);
static void klotski_window_level_skill_cb (KlotskiWindow* self,
                                    GtkTreePath* path,
                                    GtkTreeViewColumn* column);
VALA_EXTERN Puzzle* puzzle_new (guint8 width,
                    guint8 height,
                    const gchar* initial_map);
VALA_EXTERN Puzzle* puzzle_construct (GType object_type,
                          guint8 width,
                          guint8 height,
                          const gchar* initial_map);
static void klotski_window_puzzle_moved_cb (KlotskiWindow* self);
static void _klotski_window_puzzle_moved_cb_puzzle_moved (Puzzle* _sender,
                                                   gpointer self);
VALA_EXTERN void puzzle_view_set_puzzle (PuzzleView* self,
                             Puzzle* value);
static void klotski_window_update_moves_label (KlotskiWindow* self);
VALA_EXTERN guint16 puzzle_get_moves (Puzzle* self);
VALA_EXTERN gboolean puzzle_game_over (Puzzle* self);
static void klotski_window_game_score (KlotskiWindow* self);
static gchar* klotski_window_get_level_key (KlotskiWindow* self,
                                     gint level_number);
static void klotski_window_puzzle_solved (KlotskiWindow* self,
                                   GtkTreeIter* iter,
                                   gboolean solved);
static void __lambda4_ (KlotskiWindow* self,
                 GObject* object,
                 GAsyncResult* _result_);
static void ___lambda4__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void klotski_window_load_solved_state (KlotskiWindow* self);
static inline void klotski_window_manage_high_contrast (KlotskiWindow* self);
static void klotski_window_update_highcontrast_state (KlotskiWindow* self,
                                               GObject* gtk_settings,
                                               GParamSpec* unused);
static void _klotski_window_update_highcontrast_state_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void _klotski_window_update_highcontrast_state (KlotskiWindow* self,
                                                const gchar* theme_name);
static inline void klotski_window_init_keyboard (KlotskiWindow* self);
static inline gboolean klotski_window_on_key_pressed (KlotskiWindow* self,
                                        GtkEventControllerKey* _key_controller,
                                        guint keyval,
                                        guint keycode,
                                        GdkModifierType state);
static gboolean _klotski_window_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                              guint keyval,
                                                                              guint keycode,
                                                                              GdkModifierType state,
                                                                              gpointer self);
VALA_EXTERN KlotskiWindow* klotski_window_new (void);
VALA_EXTERN KlotskiWindow* klotski_window_construct (GType object_type);
static GObject * klotski_window_constructor (GType type,
                                      guint n_construct_properties,
                                      GObjectConstructParam * construct_properties);
static GamesScoresCategory* _klotski_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                                                  gpointer self);
static void _klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                                              GamesScoresScore** score,
                                                                                              GamesScoresCategory** category,
                                                                                              gpointer self);
static void _klotski_window_level_huarong_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                   GtkTreePath* path,
                                                                   GtkTreeViewColumn* column,
                                                                   gpointer self);
static void _klotski_window_level_challenge_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                     GtkTreePath* path,
                                                                     GtkTreeViewColumn* column,
                                                                     gpointer self);
static void _klotski_window_level_skill_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                 GtkTreePath* path,
                                                                 GtkTreeViewColumn* column,
                                                                 gpointer self);
VALA_EXTERN PuzzleView* puzzle_view_new (void);
VALA_EXTERN PuzzleView* puzzle_view_construct (GType object_type);
static void _klotski_window___lambda5_ (KlotskiWindow* self);
static void __klotski_window___lambda5__gtk_widget_show (GtkWidget* _sender,
                                                  gpointer self);
static void klotski_window_finalize (GObject * obj);
static GType klotski_window_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const KlotskiWindowLevelInfo KLOTSKI_WINDOW_levels[28] = {{N_ ("Only 18 Steps"), (guint8) 0, (guint8) 6, (guint8) 9, "######" "#a**b#" "#m**n#" "#cdef#" "#ghij#" "#k  l#" "##--##" "    .." "    .."}, {N_ ("Daisy"), (guint8) 0, (guint8) 6, (guint8) 9, "######" "#a**b#" "#a**b#" "#cdef#" "#zghi#" "#j  k#" "##--##" "    .." "    .."}, {N_ ("Violet"), (guint8) 0, (guint8) 6, (guint8) 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghi#" "#j  k#" "##--##" "    .." "    .."}, {N_ ("Poppy"), (guint8) 0, (guint8) 6, (guint8) 9, "######" "#a**b#" "#a**b#" "#cdde#" "#fghi#" "#j  k#" "##--##" "    .." "    .."}, {N_ ("Pansy"), (guint8) 0, (guint8) 6, (guint8) 9, "######" "#a**b#" "#a**b#" "#cdef#" "#cghf#" "#i  j#" "##--##" "    .." "    .."}, {N_ ("Snowdrop"), (guint8) 0, (guint8) 6, (guint8) 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfgh#" "#i  j#" "##--##" "    .." "    .."}, {N_ ("Red Donkey"), (guint8) 0, (guint8) 6, (guint8) 9, "######" "#a**b#" "#a**b#" "#cdde#" "#cfge#" "#h  i#" "##--##" "    .." "    .."}, {N_ ("Trail"), (guint8) 0, (guint8) 6, (guint8) 9, "######" "#a**c#" "#a**c#" "#eddg#" "#hffj#" "# ii #" "##--##" "    .." "    .."}, {N_ ("Ambush"), (guint8) 0, (guint8) 6, (guint8) 9, "######" "#a**c#" "#d**e#" "#dffe#" "#ghhi#" "# jj #" "##--##" "    .." "    .."}, {N_ ("Agatka"), (guint8) 1, (guint8) 7, (guint8) 7, "..     " ".      " "#####--" "#**aab-" "#*ccde#" "#fgh  #" "#######"}, {N_ ("Success"), (guint8) 1, (guint8) 9, (guint8) 6, "#######  " "#**bbc#  " "#defgh#  " "#ijkgh-  " "#llk  #  " "#######.."}, {N_ ("Bone"), (guint8) 1, (guint8) 6, (guint8) 9, "######" "#abc*#" "# dd*#" "# ee*#" "# fgh#" "##-###" "     ." "     ." "     ."}, {N_ ("Fortune"), (guint8) 1, (guint8) 7, (guint8) 10, "     .." "     . " "####-. " "#ab  - " "#ccd # " "#ccd # " "#**ee# " "#*fgh# " "#*iih# " "###### "}, {N_ ("Fool"), (guint8) 1, (guint8) 10, (guint8) 6, "  ########" "  -aabc  #" "  #aabdef#" "  #ijggef#" "  #klhh**#" "..########"}, {N_ ("Solomon"), (guint8) 1, (guint8) 7, (guint8) 9, " .     " "..     " "#--####" "#  aab#" "# cdfb#" "#hcefg#" "#hijk*#" "#hll**#" "#######"}, {N_ ("Cleopatra"), (guint8) 1, (guint8) 6, (guint8) 8, "######" "#abcd#" "#**ee#" "#f*g #" "#fh i-" "####--" "    .." "     ."}, {N_ ("Shark"), (guint8) 1, (guint8) 11, (guint8) 8, "########   " "#nrr s #   " "#n*op q#   " "#***jml#   " "#hhijkl#   " "#ffcddg-   " "#abcdde- . " "########..."}, {N_ ("Rome"), (guint8) 1, (guint8) 8, (guint8) 8, "########" "#abcc**#" "#ddeef*#" "#ddghfi#" "#   jki#" "#--#####" " ..     " "  .     "}, {N_ ("Pennant Puzzle"), (guint8) 1, (guint8) 6, (guint8) 9, "######" "#**aa#" "#**bb#" "#de  #" "#fghh#" "#fgii#" "#--###" "    .." "    .."}, {N_ ("Ithaca"), (guint8) 2, (guint8) 19, (guint8) 19, ".aaaaaaaaaaaaaaaaab" "..  cddeffffffffffb" " .. cddeffffffffffb" "  . cddeffffffffffb" "ggg-############hhb" "ggg-  ABCDEFFGH#hhb" "ggg-       FFIJ#hhb" "ggg#       KLMJ#hhb" "ggg#NNNNOOOPQMJ#hhb" "ggg#NNNNOOOP*RS#hhb" "ggg#TTTTTUVW**X#hhb" "ggg#YZ12222W3**#hhb" "ggg#YZ12222W34*#iib" "jjj#YZ155555367#klb" "jjj#############mmb" "jjjnooooooooooppppb" "jjjqooooooooooppppb" "       rrrssssppppb" "ttttttuvvvvvvvwwwwx"}, {N_ ("Pelopones"), (guint8) 2, (guint8) 9, (guint8) 8, "#########" "#abbb***#" "#abbb*c*#" "#adeefgg#" "#  eefhh#" "#... ihh#" "#. . ihh#" "#########"}, {N_ ("Transeuropa"), (guint8) 2, (guint8) 15, (guint8) 8, "    ###########" "    -AAAAABBCC#" "    -   DEFGHI#" "    #   DEFGJI#" "    #   KEFGLI#" "    #   KEFG*I#" "  . #   MM****#" "....###########"}, {N_ ("Lodzianka"), (guint8) 2, (guint8) 9, (guint8) 7, "#########" "#**abbcc#" "#**abbdd#" "#eefgh  #" "#iiijk..#" "#iiijk..#" "#########"}, {N_ ("Polonaise"), (guint8) 2, (guint8) 7, (guint8) 7, "#######" "#aab**#" "#aabc*#" "#defgg#" "#..fhh#" "# .ihh#" "#######"}, {N_ ("Baltic Sea"), (guint8) 2, (guint8) 6, (guint8) 8, "######" "#.abc#" "#.dec#" "#fggc#" "#fhhi#" "#fjk*#" "#flk*#" "######"}, {N_ ("American Pie"), (guint8) 2, (guint8) 10, (guint8) 12, "##########" "#a*bcdefg#" "#**bhhhhg#" "#*iijjkkg#" "#liimnoop#" "#qiirrr  #" "#qstuvv  #" "#qwwxvv  #" "######--##" "         ." "        .." "        . "}, {N_ ("Traffic Jam"), (guint8) 2, (guint8) 10, (guint8) 7, "########  " "#** ffi#  " "#** fgh#  " "#aacehh#  " "#bbdjlm-  " "#bddklm-.." "########.."}, {N_ ("Sunshine"), (guint8) 2, (guint8) 17, (guint8) 22, "       ...       " "      .. ..      " "      .   .      " "      .. ..      " "       ...       " "######-----######" "#hh0iilltmmpp;qq#" "#hh,iill mmpp:qq#" "#2y{45v s w89x/z#" "#jj6kkaa nnoo<rr#" "#jj7kkaaunnoo>rr#" "#33333TTJWW11111#" "#33333TTJWW11111#" "#33333GG HH11111#" "#33333YYIgg11111#" "#33333YYIgg11111#" "#ddFeeA***BffOZZ#" "#ddFee** **ffOZZ#" "#MMKQQ*   *PPS^^#" "#VVLXX** **bbRcc#" "#VVLXXD***EbbRcc#" "#################"}};
static const GActionEntry KLOTSKI_WINDOW_win_actions[9] = {{"show-scores", _klotski_window_show_scores_gsimple_action_activate_callback}, {"prev-pack", _klotski_window_prev_pack_cb_gsimple_action_activate_callback}, {"next-pack", _klotski_window_next_pack_cb_gsimple_action_activate_callback}, {"prev-puzzle", _klotski_window_prev_puzzle_cb_gsimple_action_activate_callback}, {"next-puzzle", _klotski_window_next_puzzle_cb_gsimple_action_activate_callback}, {"start-game", _klotski_window_start_puzzle_cb_gsimple_action_activate_callback}, {"unfullscreen", _gtk_window_unfullscreen_gsimple_action_activate_callback}, {"help", _klotski_window_help_cb_gsimple_action_activate_callback}, {"about", _klotski_window_about_cb_gsimple_action_activate_callback}};

static inline gpointer
klotski_window_get_instance_private (KlotskiWindow* self)
{
	return G_STRUCT_MEMBER_P (self, KlotskiWindow_private_offset);
}

static void
_klotski_window_show_scores_gsimple_action_activate_callback (GSimpleAction* action,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	klotski_window_show_scores ((KlotskiWindow*) self);
}

static void
_klotski_window_prev_pack_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	klotski_window_prev_pack_cb ((KlotskiWindow*) self);
}

static void
_klotski_window_next_pack_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                               GVariant* parameter,
                                                               gpointer self)
{
	klotski_window_next_pack_cb ((KlotskiWindow*) self);
}

static void
_klotski_window_prev_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	klotski_window_prev_puzzle_cb ((KlotskiWindow*) self);
}

static void
_klotski_window_next_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                 GVariant* parameter,
                                                                 gpointer self)
{
	klotski_window_next_puzzle_cb ((KlotskiWindow*) self);
}

static void
_klotski_window_start_puzzle_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self)
{
	klotski_window_start_puzzle_cb ((KlotskiWindow*) self);
}

static void
_gtk_window_unfullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	gtk_window_unfullscreen ((GtkWindow*) self);
}

static void
_klotski_window_help_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                          GVariant* parameter,
                                                          gpointer self)
{
	klotski_window_help_cb ((KlotskiWindow*) self);
}

static void
_klotski_window_about_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	klotski_window_about_cb ((KlotskiWindow*) self);
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
klotski_window_normalize_map_name (const gchar* name)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = g_utf8_strdown (name, (gssize) -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_replace (_tmp1_, " ", "-");
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	result = _tmp3_;
	return result;
}

static GamesScoresCategory*
klotski_window_category_request (KlotskiWindow* self,
                                 const gchar* key)
{
	GamesScoresCategory* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (key != NULL, NULL);
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				KlotskiWindowLevelInfo _tmp2_;
				const gchar* _tmp3_;
				gchar* _tmp4_;
				gchar* _tmp5_;
				gboolean _tmp6_;
				if (!_tmp0_) {
					guint8 _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(((gint) i) < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
					break;
				}
				_tmp2_ = KLOTSKI_WINDOW_levels[i];
				_tmp3_ = _tmp2_.name;
				_tmp4_ = klotski_window_normalize_map_name (_tmp3_);
				_tmp5_ = _tmp4_;
				_tmp6_ = g_strcmp0 (key, _tmp5_) == 0;
				_g_free0 (_tmp5_);
				if (_tmp6_) {
					GeeList* _tmp7_;
					gpointer _tmp8_;
					_tmp7_ = klotski_window_score_categories;
					_tmp8_ = gee_list_get (_tmp7_, (gint) i);
					result = (GamesScoresCategory*) _tmp8_;
					return result;
				}
			}
		}
	}
	result = NULL;
	return result;
}

static void
klotski_window_parse_old_score (KlotskiWindow* self,
                                const gchar* line,
                                GamesScoresScore** score,
                                GamesScoresCategory** category)
{
	GamesScoresScore* _vala_score = NULL;
	GamesScoresCategory* _vala_category = NULL;
	gchar** tokens = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint64 date = 0LL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gint level = 0;
	gchar** _tmp5_;
	gint _tmp5__length1;
	const gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gint moves = 0;
	gchar** _tmp14_;
	gint _tmp14__length1;
	const gchar* _tmp15_;
	GamesScoresScore* _tmp16_;
	GeeList* _tmp17_;
	gpointer _tmp18_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (line != NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = NULL;
	_g_object_unref0 (_vala_category);
	_vala_category = NULL;
	_tmp1_ = _tmp0_ = g_strsplit (line, " ", 0);
	tokens = _tmp1_;
	tokens_length1 = _vala_array_length (_tmp0_);
	_tokens_size_ = tokens_length1;
	_tmp2_ = tokens;
	_tmp2__length1 = tokens_length1;
	if (_tmp2__length1 != 3) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp3_ = tokens;
	_tmp3__length1 = tokens_length1;
	_tmp4_ = _tmp3_[0];
	date = games_scores_history_file_importer_parse_date (_tmp4_);
	if (date == ((gint64) 0)) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp5_ = tokens;
	_tmp5__length1 = tokens_length1;
	_tmp6_ = _tmp5_[1];
	level = atoi (_tmp6_);
	if (level == 0) {
		gchar** _tmp8_;
		gint _tmp8__length1;
		const gchar* _tmp9_;
		_tmp8_ = tokens;
		_tmp8__length1 = tokens_length1;
		_tmp9_ = _tmp8_[1];
		_tmp7_ = g_strcmp0 (_tmp9_, "0") != 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	if (level < 0) {
		_tmp10_ = TRUE;
	} else {
		GeeList* _tmp11_;
		gint _tmp12_;
		gint _tmp13_;
		_tmp11_ = klotski_window_score_categories;
		_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp10_ = level > _tmp13_;
	}
	if (_tmp10_) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp14_ = tokens;
	_tmp14__length1 = tokens_length1;
	_tmp15_ = _tmp14_[2];
	moves = atoi (_tmp15_);
	if (moves <= 0) {
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		if (score) {
			*score = _vala_score;
		} else {
			_g_object_unref0 (_vala_score);
		}
		if (category) {
			*category = _vala_category;
		} else {
			_g_object_unref0 (_vala_category);
		}
		return;
	}
	_tmp16_ = games_scores_score_new ((glong) moves, date, NULL);
	_g_object_unref0 (_vala_score);
	_vala_score = _tmp16_;
	_tmp17_ = klotski_window_score_categories;
	_tmp18_ = gee_list_get (_tmp17_, level);
	_g_object_unref0 (_vala_category);
	_vala_category = (GamesScoresCategory*) _tmp18_;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	if (score) {
		*score = _vala_score;
	} else {
		_g_object_unref0 (_vala_score);
	}
	if (category) {
		*category = _vala_category;
	} else {
		_g_object_unref0 (_vala_category);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
klotski_window_lookup_non_nullable_action (KlotskiWindow* self,
                                           const gchar* name,
                                           GSimpleAction** action)
{
	GSimpleAction* _vala_action = NULL;
	GAction* nullable_action = NULL;
	GAction* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = g_action_map_lookup_action ((GActionMap*) self, name);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	nullable_action = _tmp1_;
	if (nullable_action == NULL) {
		g_assert_not_reached ();
	}
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (nullable_action, g_action_get_type (), GAction), g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (_vala_action);
	_vala_action = _tmp2_;
	_g_object_unref0 (nullable_action);
	if (action) {
		*action = _vala_action;
	} else {
		_g_object_unref0 (_vala_action);
	}
}

static void
klotski_window_on_size_allocate (KlotskiWindow* self,
                                 GtkAllocation* allocation)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	klotski_window_update_window_state (self);
}

static void
_klotski_window_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                           GtkAllocation* allocation,
                                                           gpointer self)
{
	klotski_window_on_size_allocate ((KlotskiWindow*) self, allocation);
}

static gboolean
klotski_window_on_window_state_event (KlotskiWindow* self,
                                      GdkEventWindowState* event)
{
	gboolean window_was_fullscreen = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkWindowState tiled_state = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if ((event->changed_mask & GDK_WINDOW_STATE_MAXIMIZED) != 0) {
		self->priv->window_is_maximized = (event->new_window_state & GDK_WINDOW_STATE_MAXIMIZED) != 0;
	}
	window_was_fullscreen = self->priv->window_is_fullscreen;
	if ((event->changed_mask & GDK_WINDOW_STATE_FULLSCREEN) != 0) {
		self->priv->window_is_fullscreen = (event->new_window_state & GDK_WINDOW_STATE_FULLSCREEN) != 0;
	}
	if (window_was_fullscreen) {
		_tmp0_ = !self->priv->window_is_fullscreen;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		klotski_window_on_unfullscreen (self);
	} else {
		gboolean _tmp1_ = FALSE;
		if (!window_was_fullscreen) {
			_tmp1_ = self->priv->window_is_fullscreen;
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			klotski_window_on_fullscreen (self);
		}
	}
	tiled_state = (((GDK_WINDOW_STATE_TILED | GDK_WINDOW_STATE_TOP_TILED) | GDK_WINDOW_STATE_BOTTOM_TILED) | GDK_WINDOW_STATE_LEFT_TILED) | GDK_WINDOW_STATE_RIGHT_TILED;
	if ((event->changed_mask & tiled_state) != 0) {
		self->priv->window_is_tiled = (event->new_window_state & tiled_state) != 0;
	}
	result = FALSE;
	return result;
}

static gboolean
_klotski_window_on_window_state_event_gtk_widget_window_state_event (GtkWidget* _sender,
                                                                     GdkEventWindowState* event,
                                                                     gpointer self)
{
	gboolean result;
	result = klotski_window_on_window_state_event ((KlotskiWindow*) self, event);
	return result;
}

void
klotski_window_on_fullscreen (KlotskiWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unfullscreen_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}

void
klotski_window_on_unfullscreen (KlotskiWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->unfullscreen_button;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

static void
klotski_window_on_destroy (KlotskiWindow* self)
{
	GSettings* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_set_int (_tmp0_, KLOTSKI_WINDOW_KEY_LEVEL, self->priv->current_level);
	klotski_window_save_window_state (self);
}

static void
_klotski_window_on_destroy_gtk_widget_destroy (GtkWidget* _sender,
                                               gpointer self)
{
	klotski_window_on_destroy ((KlotskiWindow*) self);
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static void
klotski_window_update_window_state (KlotskiWindow* self)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint* _window_width = NULL;
	gint* _window_height = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_;
	gint* _tmp5_;
	gint _tmp6_;
	gint* _tmp7_;
	gboolean _tmp8_ = FALSE;
	gint* _tmp9_;
	gint* _tmp11_;
	gint* _tmp12_;
	g_return_if_fail (self != NULL);
	if (self->priv->window_is_maximized) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = self->priv->window_is_tiled;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->window_is_fullscreen;
	}
	if (_tmp0_) {
		return;
	}
	_window_width = NULL;
	_window_height = NULL;
	gtk_window_get_size ((GtkWindow*) self, &_tmp2_, &_tmp3_);
	_g_free0 (_window_width);
	_tmp4_ = _tmp2_;
	_tmp5_ = __int_dup0 (&_tmp4_);
	_window_width = _tmp5_;
	_g_free0 (_window_height);
	_tmp6_ = _tmp3_;
	_tmp7_ = __int_dup0 (&_tmp6_);
	_window_height = _tmp7_;
	_tmp9_ = _window_width;
	if (_tmp9_ == NULL) {
		_tmp8_ = TRUE;
	} else {
		gint* _tmp10_;
		_tmp10_ = _window_height;
		_tmp8_ = _tmp10_ == NULL;
	}
	if (_tmp8_) {
		_g_free0 (_window_height);
		_g_free0 (_window_width);
		return;
	}
	_tmp11_ = _window_width;
	self->priv->window_width = (gint) (*_tmp11_);
	_tmp12_ = _window_height;
	self->priv->window_height = (gint) (*_tmp12_);
	_g_free0 (_window_height);
	_g_free0 (_window_width);
}

static void
klotski_window_save_window_state (KlotskiWindow* self)
{
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	gboolean _tmp3_ = FALSE;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	g_settings_delay (_tmp0_);
	_tmp1_ = self->priv->settings;
	g_settings_set_int (_tmp1_, "window-width", self->priv->window_width);
	_tmp2_ = self->priv->settings;
	g_settings_set_int (_tmp2_, "window-height", self->priv->window_height);
	if (self->priv->window_is_maximized) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = self->priv->window_is_fullscreen;
	}
	_tmp4_ = self->priv->settings;
	g_settings_set_boolean (_tmp4_, "window-is-maximized", _tmp3_);
	_tmp5_ = self->priv->settings;
	g_settings_apply (_tmp5_);
}

static void
klotski_window_prev_pack_cb (KlotskiWindow* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->current_pack;
	self->priv->current_pack = _tmp3_ - 1;
	klotski_window_update_popover (self, FALSE);
}

static void
klotski_window_next_pack_cb (KlotskiWindow* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gint _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->current_pack;
	self->priv->current_pack = _tmp3_ + 1;
	klotski_window_update_popover (self, FALSE);
}

static void
klotski_window_prev_puzzle_cb (KlotskiWindow* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	KlotskiWindowLevelInfo _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = KLOTSKI_WINDOW_levels[self->priv->current_level];
	if (((gint) _tmp3_.group) == self->priv->current_pack) {
		gint _tmp4_;
		_tmp4_ = self->priv->current_level;
		self->priv->current_level = _tmp4_ - 1;
	} else {
		gint tmp_level = 0;
		{
			gboolean _tmp5_ = FALSE;
			tmp_level = G_N_ELEMENTS (KLOTSKI_WINDOW_levels) - 1;
			_tmp5_ = TRUE;
			while (TRUE) {
				KlotskiWindowLevelInfo _tmp7_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = tmp_level;
					tmp_level = _tmp6_ - 1;
				}
				_tmp5_ = FALSE;
				if (!(tmp_level >= 0)) {
					break;
				}
				_tmp7_ = KLOTSKI_WINDOW_levels[tmp_level];
				if (((gint) _tmp7_.group) == self->priv->current_pack) {
					break;
				}
			}
		}
		self->priv->current_level = tmp_level;
	}
	klotski_window_update_popover (self, TRUE);
	klotski_window_start_puzzle (self);
}

static void
klotski_window_next_puzzle_cb (KlotskiWindow* self)
{
	GtkPopover* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	KlotskiWindowLevelInfo _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_popover;
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = KLOTSKI_WINDOW_levels[self->priv->current_level];
	if (((gint) _tmp3_.group) == self->priv->current_pack) {
		gint _tmp4_;
		_tmp4_ = self->priv->current_level;
		self->priv->current_level = _tmp4_ + 1;
	} else {
		gint tmp_level = 0;
		{
			gboolean _tmp5_ = FALSE;
			tmp_level = 0;
			_tmp5_ = TRUE;
			while (TRUE) {
				KlotskiWindowLevelInfo _tmp7_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = tmp_level;
					tmp_level = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				if (!(tmp_level < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
					break;
				}
				_tmp7_ = KLOTSKI_WINDOW_levels[tmp_level];
				if (((gint) _tmp7_.group) == self->priv->current_pack) {
					break;
				}
			}
		}
		self->priv->current_level = tmp_level;
	}
	klotski_window_update_popover (self, TRUE);
	klotski_window_start_puzzle (self);
}

static void
klotski_window_start_puzzle_cb (KlotskiWindow* self)
{
	GtkTreeView* tree = NULL;
	GtkStack* _tmp0_;
	GList* _tmp1_;
	GList* _tmp2_;
	gconstpointer _tmp3_;
	GtkWidget* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeModel* model = NULL;
	GtkTreeModel* _tmp7_;
	GtkTreeModel* _tmp8_;
	GtkTreeModel* _tmp9_;
	GtkTreeIter iter = {0};
	GtkTreeSelection* _tmp10_;
	GtkTreeModel* _tmp11_ = NULL;
	GtkTreeIter _tmp12_ = {0};
	gboolean _tmp13_;
	GtkTreeModel* _tmp14_;
	GtkPopover* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack_puzzles;
	_tmp1_ = gtk_container_get_children ((GtkContainer*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_list_nth_data (_tmp2_, (guint) self->priv->current_pack);
	_tmp4_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp3_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_tree_view_get_type (), GtkTreeView));
	_tmp6_ = _tmp5_;
	(_tmp2_ == NULL) ? NULL : (_tmp2_ = (g_list_free (_tmp2_), NULL));
	tree = _tmp6_;
	_tmp7_ = gtk_tree_view_get_model (tree);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	model = _tmp8_;
	_tmp9_ = model;
	if (_tmp9_ == NULL) {
		g_assert_not_reached ();
	}
	_tmp10_ = gtk_tree_view_get_selection (tree);
	_tmp13_ = gtk_tree_selection_get_selected (_tmp10_, &_tmp11_, &_tmp12_);
	_g_object_unref0 (model);
	_tmp14_ = _g_object_ref0 (_tmp11_);
	model = _tmp14_;
	iter = _tmp12_;
	if (_tmp13_) {
		GtkTreeModel* _tmp15_;
		GtkTreeIter _tmp16_;
		_tmp15_ = model;
		_tmp16_ = iter;
		klotski_window_start_puzzle_from_iter (self, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_list_store_get_type (), GtkListStore), &_tmp16_);
	} else {
		klotski_window_start_puzzle (self);
	}
	_tmp17_ = self->priv->puzzles_popover;
	gtk_widget_hide ((GtkWidget*) _tmp17_);
	_g_object_unref0 (model);
	_g_object_unref0 (tree);
}

static void
klotski_window_update_popover (KlotskiWindow* self,
                               gboolean make_current)
{
	gint current_level_pack = 0;
	GtkTreeIter iter = {0};
	GtkTreeIter* _tmp0_;
	gint _tmp0__length1;
	GtkTreeIter _tmp1_;
	GtkListStore* _tmp2_;
	GtkTreeIter _tmp3_;
	GtkTreeSelection* selection = NULL;
	GtkStack* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	gconstpointer _tmp9_;
	GtkWidget* _tmp10_;
	GtkTreeSelection* _tmp11_;
	GtkTreeSelection* _tmp12_;
	GtkTreeSelection* _tmp13_;
	GtkStack* _tmp17_;
	GtkStack* _tmp18_;
	GList* _tmp19_;
	GList* _tmp20_;
	gconstpointer _tmp21_;
	GtkStack* _tmp22_;
	GtkStack* _tmp23_;
	GList* _tmp24_;
	GList* _tmp25_;
	gconstpointer _tmp26_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->puzzles_items;
	_tmp0__length1 = self->priv->puzzles_items_length1;
	_tmp1_ = _tmp0_[self->priv->current_level];
	iter = _tmp1_;
	_tmp2_ = self->priv->liststore_huarong;
	_tmp3_ = iter;
	if (gtk_list_store_iter_is_valid (_tmp2_, &_tmp3_)) {
		current_level_pack = 0;
	} else {
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->liststore_challenge;
		_tmp5_ = iter;
		if (gtk_list_store_iter_is_valid (_tmp4_, &_tmp5_)) {
			current_level_pack = 1;
		} else {
			current_level_pack = 2;
		}
	}
	if (make_current) {
		self->priv->current_pack = current_level_pack;
	}
	_tmp6_ = self->priv->stack_puzzles;
	_tmp7_ = gtk_container_get_children ((GtkContainer*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_list_nth_data (_tmp8_, (guint) self->priv->current_pack);
	_tmp10_ = gtk_bin_get_child ((GtkBin*) G_TYPE_CHECK_INSTANCE_CAST ((GtkWidget*) _tmp9_, gtk_scrolled_window_get_type (), GtkScrolledWindow));
	_tmp11_ = gtk_tree_view_get_selection (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_tree_view_get_type (), GtkTreeView));
	_tmp12_ = _g_object_ref0 (_tmp11_);
	_tmp13_ = _tmp12_;
	(_tmp8_ == NULL) ? NULL : (_tmp8_ = (g_list_free (_tmp8_), NULL));
	selection = _tmp13_;
	if (self->priv->current_pack == current_level_pack) {
		GtkTreeSelection* _tmp14_;
		GtkTreeIter _tmp15_;
		_tmp14_ = selection;
		_tmp15_ = iter;
		gtk_tree_selection_select_iter (_tmp14_, &_tmp15_);
	} else {
		GtkTreeSelection* _tmp16_;
		_tmp16_ = selection;
		gtk_tree_selection_unselect_all (_tmp16_);
	}
	klotski_window_update_buttons_state (self);
	_tmp17_ = self->priv->stack_packs;
	_tmp18_ = self->priv->stack_packs;
	_tmp19_ = gtk_container_get_children ((GtkContainer*) _tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = g_list_nth_data (_tmp20_, (guint) self->priv->current_pack);
	gtk_stack_set_visible_child (_tmp17_, (GtkWidget*) _tmp21_);
	(_tmp20_ == NULL) ? NULL : (_tmp20_ = (g_list_free (_tmp20_), NULL));
	_tmp22_ = self->priv->stack_puzzles;
	_tmp23_ = self->priv->stack_puzzles;
	_tmp24_ = gtk_container_get_children ((GtkContainer*) _tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = g_list_nth_data (_tmp25_, (guint) self->priv->current_pack);
	gtk_stack_set_visible_child (_tmp22_, (GtkWidget*) _tmp26_);
	(_tmp25_ == NULL) ? NULL : (_tmp25_ = (g_list_free (_tmp25_), NULL));
	_g_object_unref0 (selection);
}

static void
klotski_window_update_buttons_state (KlotskiWindow* self)
{
	GSimpleAction* _tmp0_;
	GSimpleAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GSimpleAction* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->prev_pack;
	g_simple_action_set_enabled (_tmp0_, self->priv->current_pack > 0);
	_tmp1_ = self->priv->next_pack;
	g_simple_action_set_enabled (_tmp1_, self->priv->current_pack < 2);
	_tmp2_ = self->priv->prev_puzzle;
	g_simple_action_set_enabled (_tmp2_, self->priv->current_level > 0);
	_tmp3_ = self->priv->next_puzzle;
	g_simple_action_set_enabled (_tmp3_, self->priv->current_level < (G_N_ELEMENTS (KLOTSKI_WINDOW_levels) - 1));
}

static void
klotski_window_level_huarong_cb (KlotskiWindow* self,
                                 GtkTreePath* path,
                                 GtkTreeViewColumn* column)
{
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = self->priv->liststore_huarong;
	klotski_window_level_cb (self, _tmp0_, path, column);
}

static void
klotski_window_level_challenge_cb (KlotskiWindow* self,
                                   GtkTreePath* path,
                                   GtkTreeViewColumn* column)
{
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = self->priv->liststore_challenge;
	klotski_window_level_cb (self, _tmp0_, path, column);
}

static void
klotski_window_level_skill_cb (KlotskiWindow* self,
                               GtkTreePath* path,
                               GtkTreeViewColumn* column)
{
	GtkListStore* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	_tmp0_ = self->priv->liststore_skill;
	klotski_window_level_cb (self, _tmp0_, path, column);
}

static void
klotski_window_level_cb (KlotskiWindow* self,
                         GtkListStore* liststore,
                         GtkTreePath* path,
                         GtkTreeViewColumn* column)
{
	GtkTreeIter iter = {0};
	GtkTreeIter _tmp0_ = {0};
	GtkTreeIter _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (liststore != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (column != NULL);
	gtk_tree_model_get_iter ((GtkTreeModel*) liststore, &_tmp0_, path);
	iter = _tmp0_;
	_tmp1_ = iter;
	klotski_window_start_puzzle_from_iter (self, liststore, &_tmp1_);
}

static void
klotski_window_start_puzzle_from_iter (KlotskiWindow* self,
                                       GtkListStore* model,
                                       GtkTreeIter* iter)
{
	GValue val = {0};
	GtkTreeIter _tmp0_;
	GValue _tmp1_ = {0};
	gint requested_level = 0;
	GValue _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get_value ((GtkTreeModel*) model, &_tmp0_, 2, &_tmp1_);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	val = _tmp1_;
	_tmp2_ = val;
	requested_level = g_value_get_int (&_tmp2_);
	if (requested_level < 0) {
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
		return;
	}
	self->priv->current_level = requested_level;
	klotski_window_update_buttons_state (self);
	klotski_window_start_puzzle (self);
	G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
}

static void
_klotski_window_puzzle_moved_cb_puzzle_moved (Puzzle* _sender,
                                              gpointer self)
{
	klotski_window_puzzle_moved_cb ((KlotskiWindow*) self);
}

static void
klotski_window_start_puzzle (KlotskiWindow* self)
{
	GtkHeaderBar* _tmp0_;
	KlotskiWindowLevelInfo _tmp1_;
	const gchar* _tmp2_;
	KlotskiWindowLevelInfo _tmp4_;
	KlotskiWindowLevelInfo _tmp5_;
	KlotskiWindowLevelInfo _tmp6_;
	const gchar* _tmp7_;
	Puzzle* _tmp8_;
	Puzzle* _tmp9_;
	PuzzleView* _tmp10_;
	Puzzle* _tmp11_;
	GtkMenuButton* _tmp12_;
	GSimpleAction* _tmp13_;
	GtkMenuButton* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = KLOTSKI_WINDOW_levels[self->priv->current_level];
	_tmp2_ = _tmp1_.name;
	gtk_header_bar_set_title (_tmp0_, _ (_tmp2_));
	if (self->priv->puzzle_init_done) {
		Puzzle* _tmp3_;
		_tmp3_ = self->priv->puzzle;
		g_signal_handlers_disconnect_by_func (_tmp3_, NULL, self);
	}
	_tmp4_ = KLOTSKI_WINDOW_levels[self->priv->current_level];
	_tmp5_ = KLOTSKI_WINDOW_levels[self->priv->current_level];
	_tmp6_ = KLOTSKI_WINDOW_levels[self->priv->current_level];
	_tmp7_ = _tmp6_.data;
	_tmp8_ = puzzle_new (_tmp4_.width, _tmp5_.height, _tmp7_);
	_g_object_unref0 (self->priv->puzzle);
	self->priv->puzzle = _tmp8_;
	self->priv->puzzle_init_done = TRUE;
	_tmp9_ = self->priv->puzzle;
	g_signal_connect_object (_tmp9_, "moved", (GCallback) _klotski_window_puzzle_moved_cb_puzzle_moved, self, 0);
	_tmp10_ = self->priv->view;
	_tmp11_ = self->priv->puzzle;
	puzzle_view_set_puzzle (_tmp10_, _tmp11_);
	klotski_window_update_moves_label (self);
	_tmp12_ = self->priv->game_menubutton;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp12_, FALSE);
	_tmp13_ = self->priv->start_game;
	g_simple_action_set_enabled (_tmp13_, FALSE);
	_tmp14_ = self->priv->game_menubutton;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp14_, FALSE);
}

static void
klotski_window_puzzle_moved_cb (KlotskiWindow* self)
{
	g_return_if_fail (self != NULL);
	klotski_window_update_moves_label (self);
}

static void
klotski_window_update_moves_label (KlotskiWindow* self)
{
	GSimpleAction* _tmp0_;
	GtkMenuButton* _tmp1_;
	GtkMenuButton* _tmp2_;
	Puzzle* _tmp3_;
	guint16 _tmp4_;
	guint16 _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	Puzzle* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->start_game;
	g_simple_action_set_enabled (_tmp0_, TRUE);
	_tmp1_ = self->priv->game_menubutton;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->game_menubutton;
	_tmp3_ = self->priv->puzzle;
	_tmp4_ = puzzle_get_moves (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("%hu", _tmp5_);
	_tmp7_ = _tmp6_;
	gtk_button_set_label ((GtkButton*) _tmp2_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = self->priv->puzzle;
	if (puzzle_game_over (_tmp8_)) {
		GtkHeaderBar* _tmp9_;
		_tmp9_ = self->priv->headerbar;
		gtk_header_bar_set_title (_tmp9_, _ ("Level completed."));
		klotski_window_game_score (self);
	}
}

static void
__lambda4_ (KlotskiWindow* self,
            GObject* object,
            GAsyncResult* _result_)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (_result_ != NULL);
	{
		GamesScoresContext* _tmp0_;
		_tmp0_ = self->priv->scores_context;
		games_scores_context_add_score_finish (_tmp0_, _result_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp1_;
		const gchar* _tmp2_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = e;
		_tmp2_ = _tmp1_->message;
		g_warning ("klotski-window.vala:940: Failed to add score: %s", _tmp2_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda4__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda4_ ((KlotskiWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
klotski_window_game_score (KlotskiWindow* self)
{
	gchar* key = NULL;
	gchar* _tmp0_;
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp1_;
	gchar* filename = NULL;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GtkTreeIter* _tmp6_;
	gint _tmp6__length1;
	GtkTreeIter _tmp7_;
	GamesScoresContext* _tmp8_;
	Puzzle* _tmp9_;
	guint16 _tmp10_;
	guint16 _tmp11_;
	GeeList* _tmp12_;
	gpointer _tmp13_;
	GamesScoresCategory* _tmp14_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = klotski_window_get_level_key (self, self->priv->current_level);
	key = _tmp0_;
	_tmp1_ = g_key_file_new ();
	keyfile = _tmp1_;
	_tmp2_ = g_get_user_data_dir ();
	_tmp3_ = g_build_filename (_tmp2_, "gnome-klotski", "levels", NULL);
	filename = _tmp3_;
	{
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (filename);
		_g_key_file_unref0 (keyfile);
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_key_file_set_boolean (keyfile, key, "solved", TRUE);
	{
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = g_key_file_to_data (keyfile, NULL, NULL);
		_tmp5_ = _tmp4_;
		g_file_set_contents (filename, _tmp5_, (gssize) -1, &_inner_error0_);
		_g_free0 (_tmp5_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (filename);
		_g_key_file_unref0 (keyfile);
		_g_free0 (key);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = self->priv->puzzles_items;
	_tmp6__length1 = self->priv->puzzles_items_length1;
	_tmp7_ = _tmp6_[self->priv->current_level];
	klotski_window_puzzle_solved (self, &_tmp7_, TRUE);
	_tmp8_ = self->priv->scores_context;
	_tmp9_ = self->priv->puzzle;
	_tmp10_ = puzzle_get_moves (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = klotski_window_score_categories;
	_tmp13_ = gee_list_get (_tmp12_, self->priv->current_level);
	_tmp14_ = (GamesScoresCategory*) _tmp13_;
	games_scores_context_add_score (_tmp8_, (glong) _tmp11_, _tmp14_, NULL, ___lambda4__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (_tmp14_);
	_g_free0 (filename);
	_g_key_file_unref0 (keyfile);
	_g_free0 (key);
}

static void
klotski_window_show_scores (KlotskiWindow* self)
{
	GamesScoresContext* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->scores_context;
	games_scores_context_run_dialog (_tmp0_);
}

static gchar
string_get (const gchar* self,
            glong index)
{
	gchar _tmp0_;
	gchar result;
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = ((gchar*) self)[index];
	result = _tmp0_;
	return result;
}

static gchar*
klotski_window_get_level_key (KlotskiWindow* self,
                              gint level_number)
{
	guint32 _result_ = 0U;
	gchar* data = NULL;
	KlotskiWindowLevelInfo _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp9_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = (guint32) 0xFFFFFFFFU;
	_tmp0_ = KLOTSKI_WINDOW_levels[level_number];
	_tmp1_ = _tmp0_.data;
	_tmp2_ = g_strdup (_tmp1_);
	data = _tmp2_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				const gchar* _tmp5_;
				gchar octet = '\0';
				const gchar* _tmp6_;
				if (!_tmp3_) {
					guint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = data;
				if (!(string_get (_tmp5_, (glong) i) != '\0')) {
					break;
				}
				_tmp6_ = data;
				octet = string_get (_tmp6_, (glong) i);
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp7_ = FALSE;
						_tmp7_ = TRUE;
						while (TRUE) {
							if (!_tmp7_) {
								guint8 _tmp8_;
								_tmp8_ = j;
								j = _tmp8_ + 1;
							}
							_tmp7_ = FALSE;
							if (!(((gint) j) < 8)) {
								break;
							}
							if (((octet >> 7) ^ (_result_ >> 31)) != 0) {
								_result_ = (_result_ << 1) ^ 0x04c11db7;
							} else {
								_result_ = _result_ << 1;
							}
							_result_ &= (guint32) 0xFFFFFFFFU;
							octet <<= (gchar) 1;
						}
					}
				}
			}
		}
	}
	_tmp9_ = g_strdup_printf ("%08X", (guint) (~_result_));
	result = _tmp9_;
	_g_free0 (data);
	return result;
}

static void
klotski_window_load_solved_state (KlotskiWindow* self)
{
	GKeyFile* keyfile = NULL;
	GKeyFile* _tmp0_;
	gchar* filename = NULL;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_key_file_new ();
	keyfile = _tmp0_;
	_tmp1_ = g_get_user_data_dir ();
	_tmp2_ = g_build_filename (_tmp1_, "gnome-klotski", "levels", NULL);
	filename = _tmp2_;
	{
		g_key_file_load_from_file (keyfile, filename, G_KEY_FILE_NONE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (filename);
		_g_key_file_unref0 (keyfile);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gchar* key = NULL;
				gchar* _tmp5_;
				gboolean is_solved = FALSE;
				GtkTreeIter* _tmp8_;
				gint _tmp8__length1;
				GtkTreeIter _tmp9_;
				if (!_tmp3_) {
					guint8 _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				if (!(((gint) i) < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
					break;
				}
				_tmp5_ = klotski_window_get_level_key (self, (gint) i);
				key = _tmp5_;
				is_solved = FALSE;
				{
					gboolean _tmp6_ = FALSE;
					const gchar* _tmp7_;
					_tmp7_ = key;
					_tmp6_ = g_key_file_get_boolean (keyfile, _tmp7_, "solved", &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch1_g_error;
					}
					is_solved = _tmp6_;
				}
				goto __finally1;
				__catch1_g_error:
				{
					g_clear_error (&_inner_error0_);
				}
				__finally1:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_free0 (key);
					_g_free0 (filename);
					_g_key_file_unref0 (keyfile);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp8_ = self->priv->puzzles_items;
				_tmp8__length1 = self->priv->puzzles_items_length1;
				_tmp9_ = _tmp8_[i];
				klotski_window_puzzle_solved (self, &_tmp9_, is_solved);
				_g_free0 (key);
			}
		}
	}
	_g_free0 (filename);
	_g_key_file_unref0 (keyfile);
}

static void
klotski_window_puzzle_solved (KlotskiWindow* self,
                              GtkTreeIter* iter,
                              gboolean solved)
{
	GtkListStore* _tmp0_;
	GtkTreeIter _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = self->priv->liststore_huarong;
	_tmp1_ = *iter;
	if (gtk_list_store_iter_is_valid (_tmp0_, &_tmp1_)) {
		GtkListStore* _tmp2_;
		GtkTreeIter _tmp3_;
		_tmp2_ = self->priv->liststore_huarong;
		_tmp3_ = *iter;
		gtk_list_store_set (_tmp2_, &_tmp3_, 1, solved, -1);
	} else {
		GtkListStore* _tmp4_;
		GtkTreeIter _tmp5_;
		_tmp4_ = self->priv->liststore_challenge;
		_tmp5_ = *iter;
		if (gtk_list_store_iter_is_valid (_tmp4_, &_tmp5_)) {
			GtkListStore* _tmp6_;
			GtkTreeIter _tmp7_;
			_tmp6_ = self->priv->liststore_challenge;
			_tmp7_ = *iter;
			gtk_list_store_set (_tmp6_, &_tmp7_, 1, solved, -1);
		} else {
			GtkListStore* _tmp8_;
			GtkTreeIter _tmp9_;
			_tmp8_ = self->priv->liststore_skill;
			_tmp9_ = *iter;
			gtk_list_store_set (_tmp8_, &_tmp9_, 1, solved, -1);
		}
	}
}

static void
_klotski_window_update_highcontrast_state_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	klotski_window_update_highcontrast_state ((KlotskiWindow*) self, _sender, pspec);
}

static inline void
klotski_window_manage_high_contrast (KlotskiWindow* self)
{
	GtkSettings* nullable_gtk_settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	GtkSettings* _tmp2_;
	GtkStyleContext* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkSettings* gtk_settings = NULL;
	GtkSettings* _tmp5_;
	GtkSettings* _tmp6_;
	GtkSettings* _tmp7_;
	GtkSettings* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	nullable_gtk_settings = _tmp1_;
	_tmp2_ = nullable_gtk_settings;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (nullable_gtk_settings);
		return;
	}
	_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->window_style_context);
	self->priv->window_style_context = _tmp4_;
	_tmp5_ = nullable_gtk_settings;
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gtk_settings_get_type (), GtkSettings));
	gtk_settings = _tmp6_;
	_tmp7_ = gtk_settings;
	g_signal_connect_object ((GObject*) _tmp7_, "notify::gtk-theme-name", (GCallback) _klotski_window_update_highcontrast_state_g_object_notify, self, 0);
	_tmp8_ = gtk_settings;
	g_object_get (_tmp8_, "gtk-theme-name", &_tmp9_, NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = _tmp10_;
	_klotski_window_update_highcontrast_state (self, _tmp11_);
	_g_free0 (_tmp11_);
	_g_object_unref0 (gtk_settings);
	_g_object_unref0 (nullable_gtk_settings);
}

static void
klotski_window_update_highcontrast_state (KlotskiWindow* self,
                                          GObject* gtk_settings,
                                          GParamSpec* unused)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (gtk_settings != NULL);
	g_return_if_fail (unused != NULL);
	g_object_get (G_TYPE_CHECK_INSTANCE_CAST (gtk_settings, gtk_settings_get_type (), GtkSettings), "gtk-theme-name", &_tmp0_, NULL);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_;
	_klotski_window_update_highcontrast_state (self, _tmp2_);
	_g_free0 (_tmp2_);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
_klotski_window_update_highcontrast_state (KlotskiWindow* self,
                                           const gchar* theme_name)
{
	gboolean highcontrast_new_state = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (theme_name != NULL);
	highcontrast_new_state = string_contains (theme_name, "HighContrast");
	if (highcontrast_new_state == self->priv->highcontrast_state) {
		return;
	}
	self->priv->highcontrast_state = highcontrast_new_state;
	if (highcontrast_new_state) {
		GtkStyleContext* _tmp0_;
		_tmp0_ = self->priv->window_style_context;
		gtk_style_context_add_class (_tmp0_, "hc-theme");
	} else {
		GtkStyleContext* _tmp1_;
		_tmp1_ = self->priv->window_style_context;
		gtk_style_context_remove_class (_tmp1_, "hc-theme");
	}
}

static gboolean
_klotski_window_on_key_pressed_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                     guint keyval,
                                                                     guint keycode,
                                                                     GdkModifierType state,
                                                                     gpointer self)
{
	gboolean result;
	result = klotski_window_on_key_pressed ((KlotskiWindow*) self, _sender, keyval, keycode, state);
	return result;
}

static inline void
klotski_window_init_keyboard (KlotskiWindow* self)
{
	GtkEventControllerKey* _tmp0_;
	GtkEventControllerKey* _tmp1_;
	GtkEventControllerKey* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp0_;
	_tmp1_ = self->priv->key_controller;
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp1_, GTK_PHASE_CAPTURE);
	_tmp2_ = self->priv->key_controller;
	g_signal_connect_object (_tmp2_, "key-pressed", (GCallback) _klotski_window_on_key_pressed_gtk_event_controller_key_key_pressed, self, 0);
}

static inline gboolean
klotski_window_on_key_pressed (KlotskiWindow* self,
                               GtkEventControllerKey* _key_controller,
                               guint keyval,
                               guint keycode,
                               GdkModifierType state)
{
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_;
	gchar* name = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (_key_controller != NULL, FALSE);
	_tmp1_ = gdk_keyval_name (keyval);
	_tmp0_ = _tmp1_;
	if (_tmp0_ == NULL) {
		_tmp0_ = "";
	}
	_tmp2_ = g_strdup ((const gchar*) _tmp0_);
	name = _tmp2_;
	_tmp3_ = name;
	if (g_strcmp0 (_tmp3_, "F1") == 0) {
		if ((state & GDK_CONTROL_MASK) != 0) {
			result = FALSE;
			_g_free0 (name);
			return result;
		}
		if ((state & GDK_SHIFT_MASK) == 0) {
			klotski_window_help_cb (self);
			result = TRUE;
			_g_free0 (name);
			return result;
		} else {
			klotski_window_about_cb (self);
			result = TRUE;
			_g_free0 (name);
			return result;
		}
	}
	_tmp4_ = name;
	if (g_strcmp0 (_tmp4_, "F10") == 0) {
		gboolean _tmp9_ = FALSE;
		GtkMenuButton* _tmp10_;
		gboolean _tmp11_;
		gboolean _tmp12_;
		if (state == 0) {
			GtkMenuButton* _tmp5_;
			GtkMenuButton* _tmp6_;
			gboolean _tmp7_;
			gboolean _tmp8_;
			_tmp5_ = self->priv->main_menubutton;
			_tmp6_ = self->priv->main_menubutton;
			_tmp7_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp6_);
			_tmp8_ = _tmp7_;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp5_, !_tmp8_);
			result = TRUE;
			_g_free0 (name);
			return result;
		}
		_tmp10_ = self->priv->game_menubutton;
		_tmp11_ = gtk_widget_get_sensitive ((GtkWidget*) _tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp12_) {
			_tmp9_ = (state & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp9_ = FALSE;
		}
		if (_tmp9_) {
			GtkMenuButton* _tmp13_;
			GtkMenuButton* _tmp14_;
			gboolean _tmp15_;
			gboolean _tmp16_;
			_tmp13_ = self->priv->game_menubutton;
			_tmp14_ = self->priv->game_menubutton;
			_tmp15_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp14_);
			_tmp16_ = _tmp15_;
			gtk_toggle_button_set_active ((GtkToggleButton*) _tmp13_, !_tmp16_);
			result = TRUE;
			_g_free0 (name);
			return result;
		}
		result = FALSE;
		_g_free0 (name);
		return result;
	}
	result = FALSE;
	_g_free0 (name);
	return result;
}

static inline void
klotski_window_help_cb (KlotskiWindow* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		gtk_show_uri_on_window ((GtkWindow*) self, "help:gnome-klotski", gtk_get_current_event_time (), &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("klotski-window.vala:1111: Failed to show help: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static inline void
klotski_window_about_cb (KlotskiWindow* self)
{
	gchar** authors = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar** _tmp3_;
	gint authors_length1;
	gint _authors_size_;
	gchar** documenters = NULL;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint documenters_length1;
	gint _documenters_size_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("Lars Rydlinge (original author)"));
	_tmp1_ = g_strdup (_ ("Robert Ancell (port to vala)"));
	_tmp2_ = g_strdup (_ ("John Cheetham (port to vala)"));
	_tmp3_ = g_new0 (gchar*, 3 + 1);
	_tmp3_[0] = _tmp0_;
	_tmp3_[1] = _tmp1_;
	_tmp3_[2] = _tmp2_;
	authors = _tmp3_;
	authors_length1 = 3;
	_authors_size_ = authors_length1;
	_tmp4_ = g_strdup (_ ("Andrew Sobala"));
	_tmp5_ = g_new0 (gchar*, 1 + 1);
	_tmp5_[0] = _tmp4_;
	documenters = _tmp5_;
	documenters_length1 = 1;
	_documenters_size_ = documenters_length1;
	_tmp6_ = g_strconcat (_ ("Copyright \xc2\xa9 1999-2008 – Lars Rydlinge"), "\n", NULL);
	_tmp7_ = _tmp6_;
	_tmp8_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Michael Catanzaro"), (guint) 2014, (guint) 2016);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp7_, _tmp9_, NULL);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
	_tmp13_ = _tmp12_;
	_tmp14_ = g_strdup_printf (_ ("Copyright \xc2\xa9 %u-%u – Arnaud Bonatti"), (guint) 2015, (guint) 2020);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strconcat (_tmp13_, _tmp15_, NULL);
	_tmp17_ = _tmp16_;
	gtk_show_about_dialog ((GtkWindow*) self, "program-name", KLOTSKI_PROGRAM_NAME, "version", VERSION, "comments", _ ("Sliding block puzzles"), "copyright", _tmp17_, "license-type", GTK_LICENSE_GPL_3_0, "authors", authors, "documenters", documenters, "logo-icon-name", "org.gnome.Klotski", "translator-credits", _ ("translator-credits"), "website", "https://wiki.gnome.org/Apps/Klotski", NULL);
	_g_free0 (_tmp17_);
	_g_free0 (_tmp15_);
	_g_free0 (_tmp13_);
	_g_free0 (_tmp11_);
	_g_free0 (_tmp9_);
	_g_free0 (_tmp7_);
	documenters = (_vala_array_free (documenters, documenters_length1, (GDestroyNotify) g_free), NULL);
	authors = (_vala_array_free (authors, authors_length1, (GDestroyNotify) g_free), NULL);
}

KlotskiWindow*
klotski_window_construct (GType object_type)
{
	KlotskiWindow * self = NULL;
	self = (KlotskiWindow*) g_object_new (object_type, NULL);
	return self;
}

KlotskiWindow*
klotski_window_new (void)
{
	return klotski_window_construct (TYPE_KLOTSKI_WINDOW);
}

static void
klotski_window_level_info_copy (const KlotskiWindowLevelInfo* self,
                                KlotskiWindowLevelInfo* dest)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = (*self).name;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).name);
	(*dest).name = _tmp1_;
	(*dest).group = (*self).group;
	(*dest).width = (*self).width;
	(*dest).height = (*self).height;
	_tmp2_ = (*self).data;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).data);
	(*dest).data = _tmp3_;
}

static void
klotski_window_level_info_destroy (KlotskiWindowLevelInfo* self)
{
	_g_free0 ((*self).name);
	_g_free0 ((*self).data);
}

static KlotskiWindowLevelInfo*
klotski_window_level_info_dup (const KlotskiWindowLevelInfo* self)
{
	KlotskiWindowLevelInfo* dup;
	dup = g_new0 (KlotskiWindowLevelInfo, 1);
	klotski_window_level_info_copy (self, dup);
	return dup;
}

static void
klotski_window_level_info_free (KlotskiWindowLevelInfo* self)
{
	klotski_window_level_info_destroy (self);
	g_free (self);
}

static GType
klotski_window_level_info_get_type_once (void)
{
	GType klotski_window_level_info_type_id;
	klotski_window_level_info_type_id = g_boxed_type_register_static ("KlotskiWindowLevelInfo", (GBoxedCopyFunc) klotski_window_level_info_dup, (GBoxedFreeFunc) klotski_window_level_info_free);
	return klotski_window_level_info_type_id;
}

static GType
klotski_window_level_info_get_type (void)
{
	static volatile gsize klotski_window_level_info_type_id__once = 0;
	if (g_once_init_enter (&klotski_window_level_info_type_id__once)) {
		GType klotski_window_level_info_type_id;
		klotski_window_level_info_type_id = klotski_window_level_info_get_type_once ();
		g_once_init_leave (&klotski_window_level_info_type_id__once, klotski_window_level_info_type_id);
	}
	return klotski_window_level_info_type_id__once;
}

static GamesScoresCategory*
_klotski_window_category_request_games_scores_context_category_request_func (const gchar* category_key,
                                                                             gpointer self)
{
	GamesScoresCategory* result;
	result = klotski_window_category_request ((KlotskiWindow*) self, category_key);
	return result;
}

static void
_klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func (const gchar* line,
                                                                                         GamesScoresScore** score,
                                                                                         GamesScoresCategory** category,
                                                                                         gpointer self)
{
	klotski_window_parse_old_score ((KlotskiWindow*) self, line, score, category);
}

static void
_klotski_window_level_huarong_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                              GtkTreePath* path,
                                                              GtkTreeViewColumn* column,
                                                              gpointer self)
{
	klotski_window_level_huarong_cb ((KlotskiWindow*) self, path, column);
}

static void
_klotski_window_level_challenge_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                                GtkTreePath* path,
                                                                GtkTreeViewColumn* column,
                                                                gpointer self)
{
	klotski_window_level_challenge_cb ((KlotskiWindow*) self, path, column);
}

static void
_klotski_window_level_skill_cb_gtk_tree_view_row_activated (GtkTreeView* _sender,
                                                            GtkTreePath* path,
                                                            GtkTreeViewColumn* column,
                                                            gpointer self)
{
	klotski_window_level_skill_cb ((KlotskiWindow*) self, path, column);
}

static void
_klotski_window___lambda5_ (KlotskiWindow* self)
{
	klotski_window_update_popover (self, TRUE);
}

static void
__klotski_window___lambda5__gtk_widget_show (GtkWidget* _sender,
                                             gpointer self)
{
	_klotski_window___lambda5_ ((KlotskiWindow*) self);
}

static GObject *
klotski_window_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	KlotskiWindow * self;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	GdkScreen* gdk_screen = NULL;
	GdkScreen* _tmp2_;
	GdkScreen* _tmp3_;
	GdkScreen* _tmp4_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GSettings* _tmp10_;
	GSimpleAction* _tmp11_ = NULL;
	GSimpleAction* _tmp12_ = NULL;
	GSimpleAction* _tmp13_ = NULL;
	GSimpleAction* _tmp14_ = NULL;
	GSimpleAction* _tmp15_ = NULL;
	GamesScoresHistoryFileImporter* _tmp16_;
	GamesScoresHistoryFileImporter* _tmp17_;
	GamesScoresContext* _tmp18_;
	GtkListStore* _tmp19_;
	GtkListStore* _tmp20_;
	GtkListStore* _tmp21_;
	GtkTreeIter* _tmp22_;
	GtkTreeView* _tmp50_;
	GtkListStore* _tmp51_;
	GtkTreeView* _tmp52_;
	GtkListStore* _tmp53_;
	GtkTreeView* _tmp54_;
	GtkListStore* _tmp55_;
	GtkTreeView* _tmp56_;
	GtkTreeView* _tmp57_;
	GtkTreeView* _tmp58_;
	PuzzleView* _tmp59_;
	PuzzleView* _tmp60_;
	PuzzleView* _tmp61_;
	PuzzleView* _tmp62_;
	PuzzleView* _tmp63_;
	PuzzleView* _tmp64_;
	GtkGrid* _tmp65_;
	PuzzleView* _tmp66_;
	GSettings* _tmp67_;
	GtkPopover* _tmp68_;
	parent_class = G_OBJECT_CLASS (klotski_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KLOTSKI_WINDOW, KlotskiWindow);
	_tmp0_ = gtk_css_provider_new ();
	css_provider = _tmp0_;
	_tmp1_ = css_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/org/gnome/Klotski/ui/klotski.css");
	_tmp2_ = gdk_screen_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	gdk_screen = _tmp3_;
	_tmp4_ = gdk_screen;
	if (_tmp4_ != NULL) {
		GdkScreen* _tmp5_;
		GtkCssProvider* _tmp6_;
		_tmp5_ = gdk_screen;
		_tmp6_ = css_provider;
		gtk_style_context_add_provider_for_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gdk_screen_get_type (), GdkScreen), (GtkStyleProvider*) _tmp6_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	}
	_tmp7_ = g_settings_new ("org.gnome.Klotski");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp7_;
	_tmp8_ = self->priv->settings;
	_tmp9_ = self->priv->settings;
	gtk_window_set_default_size ((GtkWindow*) self, g_settings_get_int (_tmp8_, "window-width"), g_settings_get_int (_tmp9_, "window-height"));
	_tmp10_ = self->priv->settings;
	if (g_settings_get_boolean (_tmp10_, "window-is-maximized")) {
		gtk_window_maximize ((GtkWindow*) self);
	}
	klotski_window_init_keyboard (self);
	klotski_window_manage_high_contrast (self);
	g_action_map_add_action_entries ((GActionMap*) self, KLOTSKI_WINDOW_win_actions, (gint) G_N_ELEMENTS (KLOTSKI_WINDOW_win_actions), self);
	klotski_window_lookup_non_nullable_action (self, "prev-pack", &_tmp11_);
	_g_object_unref0 (self->priv->prev_pack);
	self->priv->prev_pack = _tmp11_;
	klotski_window_lookup_non_nullable_action (self, "next-pack", &_tmp12_);
	_g_object_unref0 (self->priv->next_pack);
	self->priv->next_pack = _tmp12_;
	klotski_window_lookup_non_nullable_action (self, "prev-puzzle", &_tmp13_);
	_g_object_unref0 (self->priv->prev_puzzle);
	self->priv->prev_puzzle = _tmp13_;
	klotski_window_lookup_non_nullable_action (self, "next-puzzle", &_tmp14_);
	_g_object_unref0 (self->priv->next_puzzle);
	self->priv->next_puzzle = _tmp14_;
	klotski_window_lookup_non_nullable_action (self, "start-game", &_tmp15_);
	_g_object_unref0 (self->priv->start_game);
	self->priv->start_game = _tmp15_;
	_tmp16_ = games_scores_history_file_importer_new (_klotski_window_parse_old_score_games_scores_history_file_importer_history_convert_func, self);
	_tmp17_ = _tmp16_;
	_tmp18_ = games_scores_context_new_with_importer_and_icon_name ("gnome-klotski", _ ("Puzzle"), (GtkWindow*) self, _klotski_window_category_request_games_scores_context_category_request_func, self, GAMES_SCORES_STYLE_POINTS_LESS_IS_BETTER, (GamesScoresImporter*) _tmp17_, "org.gnome.Klotski");
	_g_object_unref0 (self->priv->scores_context);
	self->priv->scores_context = _tmp18_;
	_g_object_unref0 (_tmp17_);
	_tmp19_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
	_g_object_unref0 (self->priv->liststore_huarong);
	self->priv->liststore_huarong = _tmp19_;
	_tmp20_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
	_g_object_unref0 (self->priv->liststore_challenge);
	self->priv->liststore_challenge = _tmp20_;
	_tmp21_ = gtk_list_store_new (4, G_TYPE_STRING, G_TYPE_BOOLEAN, G_TYPE_INT, G_TYPE_BOOLEAN, -1);
	_g_object_unref0 (self->priv->liststore_skill);
	self->priv->liststore_skill = _tmp21_;
	_tmp22_ = g_new0 (GtkTreeIter, G_N_ELEMENTS (KLOTSKI_WINDOW_levels));
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
	self->priv->puzzles_items = _tmp22_;
	self->priv->puzzles_items_length1 = G_N_ELEMENTS (KLOTSKI_WINDOW_levels);
	self->priv->_puzzles_items_size_ = self->priv->puzzles_items_length1;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp23_ = FALSE;
			_tmp23_ = TRUE;
			while (TRUE) {
				KlotskiWindowLevelInfo _tmp25_;
				if (!_tmp23_) {
					guint8 _tmp24_;
					_tmp24_ = i;
					i = _tmp24_ + 1;
				}
				_tmp23_ = FALSE;
				if (!(((gint) i) < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
					break;
				}
				_tmp25_ = KLOTSKI_WINDOW_levels[i];
				switch (_tmp25_.group) {
					case 0:
					{
						GtkListStore* _tmp26_;
						GtkTreeIter* _tmp27_;
						gint _tmp27__length1;
						GtkTreeIter _tmp28_ = {0};
						GtkListStore* _tmp29_;
						GtkTreeIter* _tmp30_;
						gint _tmp30__length1;
						GtkTreeIter _tmp31_;
						KlotskiWindowLevelInfo _tmp32_;
						const gchar* _tmp33_;
						_tmp26_ = self->priv->liststore_huarong;
						_tmp27_ = self->priv->puzzles_items;
						_tmp27__length1 = self->priv->puzzles_items_length1;
						gtk_list_store_append (_tmp26_, &_tmp28_);
						_tmp27_[i] = _tmp28_;
						_tmp29_ = self->priv->liststore_huarong;
						_tmp30_ = self->priv->puzzles_items;
						_tmp30__length1 = self->priv->puzzles_items_length1;
						_tmp31_ = _tmp30_[i];
						_tmp32_ = KLOTSKI_WINDOW_levels[i];
						_tmp33_ = _tmp32_.name;
						gtk_list_store_set (_tmp29_, &_tmp31_, 0, _ (_tmp33_), 1, FALSE, 2, i, 3, FALSE, -1);
						break;
					}
					case 1:
					{
						GtkListStore* _tmp34_;
						GtkTreeIter* _tmp35_;
						gint _tmp35__length1;
						GtkTreeIter _tmp36_ = {0};
						GtkListStore* _tmp37_;
						GtkTreeIter* _tmp38_;
						gint _tmp38__length1;
						GtkTreeIter _tmp39_;
						KlotskiWindowLevelInfo _tmp40_;
						const gchar* _tmp41_;
						_tmp34_ = self->priv->liststore_challenge;
						_tmp35_ = self->priv->puzzles_items;
						_tmp35__length1 = self->priv->puzzles_items_length1;
						gtk_list_store_append (_tmp34_, &_tmp36_);
						_tmp35_[i] = _tmp36_;
						_tmp37_ = self->priv->liststore_challenge;
						_tmp38_ = self->priv->puzzles_items;
						_tmp38__length1 = self->priv->puzzles_items_length1;
						_tmp39_ = _tmp38_[i];
						_tmp40_ = KLOTSKI_WINDOW_levels[i];
						_tmp41_ = _tmp40_.name;
						gtk_list_store_set (_tmp37_, &_tmp39_, 0, _ (_tmp41_), 1, FALSE, 2, i, 3, FALSE, -1);
						break;
					}
					case 2:
					{
						GtkListStore* _tmp42_;
						GtkTreeIter* _tmp43_;
						gint _tmp43__length1;
						GtkTreeIter _tmp44_ = {0};
						GtkListStore* _tmp45_;
						GtkTreeIter* _tmp46_;
						gint _tmp46__length1;
						GtkTreeIter _tmp47_;
						KlotskiWindowLevelInfo _tmp48_;
						const gchar* _tmp49_;
						_tmp42_ = self->priv->liststore_skill;
						_tmp43_ = self->priv->puzzles_items;
						_tmp43__length1 = self->priv->puzzles_items_length1;
						gtk_list_store_append (_tmp42_, &_tmp44_);
						_tmp43_[i] = _tmp44_;
						_tmp45_ = self->priv->liststore_skill;
						_tmp46_ = self->priv->puzzles_items;
						_tmp46__length1 = self->priv->puzzles_items_length1;
						_tmp47_ = _tmp46_[i];
						_tmp48_ = KLOTSKI_WINDOW_levels[i];
						_tmp49_ = _tmp48_.name;
						gtk_list_store_set (_tmp45_, &_tmp47_, 0, _ (_tmp49_), 1, FALSE, 2, i, 3, FALSE, -1);
						break;
					}
					default:
					{
						g_assert_not_reached ();
					}
				}
			}
		}
	}
	_tmp50_ = self->priv->treeview_huarong;
	_tmp51_ = self->priv->liststore_huarong;
	gtk_tree_view_set_model (_tmp50_, (GtkTreeModel*) _tmp51_);
	_tmp52_ = self->priv->treeview_challenge;
	_tmp53_ = self->priv->liststore_challenge;
	gtk_tree_view_set_model (_tmp52_, (GtkTreeModel*) _tmp53_);
	_tmp54_ = self->priv->treeview_skill;
	_tmp55_ = self->priv->liststore_skill;
	gtk_tree_view_set_model (_tmp54_, (GtkTreeModel*) _tmp55_);
	_tmp56_ = self->priv->treeview_huarong;
	g_signal_connect_object (_tmp56_, "row-activated", (GCallback) _klotski_window_level_huarong_cb_gtk_tree_view_row_activated, self, 0);
	_tmp57_ = self->priv->treeview_challenge;
	g_signal_connect_object (_tmp57_, "row-activated", (GCallback) _klotski_window_level_challenge_cb_gtk_tree_view_row_activated, self, 0);
	_tmp58_ = self->priv->treeview_skill;
	g_signal_connect_object (_tmp58_, "row-activated", (GCallback) _klotski_window_level_skill_cb_gtk_tree_view_row_activated, self, 0);
	_tmp59_ = puzzle_view_new ();
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp59_;
	_tmp60_ = self->priv->view;
	gtk_widget_set_halign ((GtkWidget*) _tmp60_, GTK_ALIGN_FILL);
	_tmp61_ = self->priv->view;
	gtk_widget_set_can_focus ((GtkWidget*) _tmp61_, TRUE);
	_tmp62_ = self->priv->view;
	gtk_widget_show ((GtkWidget*) _tmp62_);
	_tmp63_ = self->priv->view;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp63_, TRUE);
	_tmp64_ = self->priv->view;
	gtk_widget_set_vexpand ((GtkWidget*) _tmp64_, TRUE);
	_tmp65_ = self->priv->main_grid;
	_tmp66_ = self->priv->view;
	gtk_container_add ((GtkContainer*) _tmp65_, (GtkWidget*) _tmp66_);
	klotski_window_load_solved_state (self);
	_tmp67_ = self->priv->settings;
	self->priv->current_level = CLAMP (g_settings_get_int (_tmp67_, KLOTSKI_WINDOW_KEY_LEVEL), 0, G_N_ELEMENTS (KLOTSKI_WINDOW_levels) - 1);
	_tmp68_ = self->priv->puzzles_popover;
	g_signal_connect_object ((GtkWidget*) _tmp68_, "show", (GCallback) __klotski_window___lambda5__gtk_widget_show, self, 0);
	klotski_window_update_popover (self, TRUE);
	klotski_window_start_puzzle (self);
	_g_object_unref0 (gdk_screen);
	_g_object_unref0 (css_provider);
	return obj;
}

static void
klotski_window_base_init (KlotskiWindowClass * klass)
{
	GeeArrayList* _tmp0_;
	_tmp0_ = gee_array_list_new (GAMES_SCORES_TYPE_CATEGORY, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	_g_object_unref0 (klotski_window_score_categories);
	klotski_window_score_categories = (GeeList*) _tmp0_;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				GeeList* _tmp3_;
				KlotskiWindowLevelInfo _tmp4_;
				const gchar* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				KlotskiWindowLevelInfo _tmp8_;
				const gchar* _tmp9_;
				GamesScoresCategory* _tmp10_;
				GamesScoresCategory* _tmp11_;
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(((gint) i) < G_N_ELEMENTS (KLOTSKI_WINDOW_levels))) {
					break;
				}
				_tmp3_ = klotski_window_score_categories;
				_tmp4_ = KLOTSKI_WINDOW_levels[i];
				_tmp5_ = _tmp4_.name;
				_tmp6_ = klotski_window_normalize_map_name (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = KLOTSKI_WINDOW_levels[i];
				_tmp9_ = _tmp8_.name;
				_tmp10_ = games_scores_category_new (_tmp7_, _ (_tmp9_));
				_tmp11_ = _tmp10_;
				gee_collection_add ((GeeCollection*) _tmp3_, _tmp11_);
				_g_object_unref0 (_tmp11_);
				_g_free0 (_tmp7_);
			}
		}
	}
}

static void
klotski_window_class_init (KlotskiWindowClass * klass,
                           gpointer klass_data)
{
	klotski_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &KlotskiWindow_private_offset);
	G_OBJECT_CLASS (klass)->constructor = klotski_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = klotski_window_finalize;
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Klotski/ui/klotski.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_packs", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, stack_packs));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack_puzzles", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, stack_puzzles));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "puzzles_popover", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, puzzles_popover));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_menubutton", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, game_menubutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_menubutton", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, main_menubutton));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_huarong", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_huarong));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_challenge", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_challenge));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "treeview_skill", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, treeview_skill));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "main_grid", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, main_grid));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "unfullscreen_button", FALSE, KlotskiWindow_private_offset + G_STRUCT_OFFSET (KlotskiWindowPrivate, unfullscreen_button));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_size_allocate", G_CALLBACK(_klotski_window_on_size_allocate_gtk_widget_size_allocate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_state_event", G_CALLBACK(_klotski_window_on_window_state_event_gtk_widget_window_state_event));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_destroy", G_CALLBACK(_klotski_window_on_destroy_gtk_widget_destroy));
}

static void
klotski_window_instance_init (KlotskiWindow * self,
                              gpointer klass)
{
	self->priv = klotski_window_get_instance_private (self);
	self->priv->window_width = 0;
	self->priv->window_height = 0;
	self->priv->window_is_fullscreen = FALSE;
	self->priv->window_is_maximized = FALSE;
	self->priv->window_is_tiled = FALSE;
	self->priv->puzzle_init_done = FALSE;
	self->priv->current_pack = -1;
	self->priv->current_level = -1;
	self->priv->highcontrast_state = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
klotski_window_finalize (GObject * obj)
{
	KlotskiWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_KLOTSKI_WINDOW, KlotskiWindow);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->prev_pack);
	_g_object_unref0 (self->priv->next_pack);
	_g_object_unref0 (self->priv->prev_puzzle);
	_g_object_unref0 (self->priv->next_puzzle);
	_g_object_unref0 (self->priv->start_game);
	_g_object_unref0 (self->priv->puzzle);
	_g_object_unref0 (self->priv->scores_context);
	_g_object_unref0 (self->priv->liststore_huarong);
	_g_object_unref0 (self->priv->liststore_challenge);
	_g_object_unref0 (self->priv->liststore_skill);
	self->priv->puzzles_items = (g_free (self->priv->puzzles_items), NULL);
	_g_object_unref0 (self->priv->window_style_context);
	_g_object_unref0 (self->priv->key_controller);
	G_OBJECT_CLASS (klotski_window_parent_class)->finalize (obj);
}

static GType
klotski_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (KlotskiWindowClass), (GBaseInitFunc) klotski_window_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) klotski_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (KlotskiWindow), 0, (GInstanceInitFunc) klotski_window_instance_init, NULL };
	GType klotski_window_type_id;
	klotski_window_type_id = g_type_register_static (gtk_application_window_get_type (), "KlotskiWindow", &g_define_type_info, 0);
	KlotskiWindow_private_offset = g_type_add_instance_private (klotski_window_type_id, sizeof (KlotskiWindowPrivate));
	return klotski_window_type_id;
}

GType
klotski_window_get_type (void)
{
	static volatile gsize klotski_window_type_id__once = 0;
	if (g_once_init_enter (&klotski_window_type_id__once)) {
		GType klotski_window_type_id;
		klotski_window_type_id = klotski_window_get_type_once ();
		g_once_init_leave (&klotski_window_type_id__once, klotski_window_type_id);
	}
	return klotski_window_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

