/* utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from utils.vala, do not modify */

/* utils.vala
 *
 * Copyright (C) 2017 Red Hat, Inc.
 * Copyright (C) 2023 Markus Göllnitz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors: Petr Štětka <pstetka@redhat.com>
 *          Markus Göllnitz <camelcasenick@bewares.it>
 */

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gobject/gvaluecollector.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define USAGE_TYPE_UTILS (usage_utils_get_type ())
#define USAGE_UTILS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_TYPE_UTILS, UsageUtils))
#define USAGE_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), USAGE_TYPE_UTILS, UsageUtilsClass))
#define USAGE_IS_UTILS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_TYPE_UTILS))
#define USAGE_IS_UTILS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), USAGE_TYPE_UTILS))
#define USAGE_UTILS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), USAGE_TYPE_UTILS, UsageUtilsClass))

typedef struct _UsageUtils UsageUtils;
typedef struct _UsageUtilsClass UsageUtilsClass;
typedef struct _UsageUtilsPrivate UsageUtilsPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _UsageParamSpecUtils UsageParamSpecUtils;
typedef enum  {
	USAGE_USER_ACCOUNT_TYPE_STANDARD,
	USAGE_USER_ACCOUNT_TYPE_ADMINISTRATOR
} UsageUserAccountType;

#define USAGE_TYPE_USER_ACCOUNT_TYPE (usage_user_account_type_get_type ())

#define USAGE_FDO_TYPE_ACCOUNTS (usage_fdo_accounts_get_type ())
#define USAGE_FDO_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_FDO_TYPE_ACCOUNTS, UsageFdoAccounts))
#define USAGE_FDO_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_FDO_TYPE_ACCOUNTS))
#define USAGE_FDO_ACCOUNTS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), USAGE_FDO_TYPE_ACCOUNTS, UsageFdoAccountsIface))

typedef struct _UsageFdoAccounts UsageFdoAccounts;
typedef struct _UsageFdoAccountsIface UsageFdoAccountsIface;

#define USAGE_FDO_TYPE_ACCOUNTS_PROXY (usage_fdo_accounts_proxy_get_type ())
typedef GDBusProxy UsageFdoAccountsProxy;
typedef GDBusProxyClass UsageFdoAccountsProxyClass;
typedef struct _usage_fdo_accounts_FindUserByIdReadyData usage_fdo_accounts_FindUserByIdReadyData;

#define USAGE_FDO_TYPE_ACCOUNTS_USER (usage_fdo_accounts_user_get_type ())
#define USAGE_FDO_ACCOUNTS_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), USAGE_FDO_TYPE_ACCOUNTS_USER, UsageFdoAccountsUser))
#define USAGE_FDO_IS_ACCOUNTS_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), USAGE_FDO_TYPE_ACCOUNTS_USER))
#define USAGE_FDO_ACCOUNTS_USER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), USAGE_FDO_TYPE_ACCOUNTS_USER, UsageFdoAccountsUserIface))

typedef struct _UsageFdoAccountsUser UsageFdoAccountsUser;
typedef struct _UsageFdoAccountsUserIface UsageFdoAccountsUserIface;

#define USAGE_FDO_TYPE_ACCOUNTS_USER_PROXY (usage_fdo_accounts_user_proxy_get_type ())
typedef GDBusProxy UsageFdoAccountsUserProxy;
typedef GDBusProxyClass UsageFdoAccountsUserProxyClass;

struct _UsageUtils {
	GTypeInstance parent_instance;
	volatile int ref_count;
	UsageUtilsPrivate * priv;
};

struct _UsageUtilsClass {
	GTypeClass parent_class;
	void (*finalize) (UsageUtils *self);
};

struct _UsageParamSpecUtils {
	GParamSpec parent_instance;
};

struct _UsageFdoAccountsIface {
	GTypeInterface parent_iface;
	void (*FindUserById) (UsageFdoAccounts* self, gint64 id, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar* (*FindUserById_finish) (UsageFdoAccounts* self, GAsyncResult* _res_, GError** error);
};

struct _usage_fdo_accounts_FindUserByIdReadyData {
	GDBusMethodInvocation* _invocation_;
	gint64 id;
};

struct _UsageFdoAccountsUserIface {
	GTypeInterface parent_iface;
	gboolean (*get_SystemAccount) (UsageFdoAccountsUser* self);
	gboolean (*get_LocalAccount) (UsageFdoAccountsUser* self);
	gint32 (*get_AccountType) (UsageFdoAccountsUser* self);
	gchar* (*get_RealName) (UsageFdoAccountsUser* self);
	gchar* (*get_UserName) (UsageFdoAccountsUser* self);
	guint64 (*get_Uid) (UsageFdoAccountsUser* self);
};

static gpointer usage_utils_parent_class = NULL;

VALA_EXTERN gpointer usage_utils_ref (gpointer instance);
VALA_EXTERN void usage_utils_unref (gpointer instance);
VALA_EXTERN GParamSpec* usage_param_spec_utils (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags);
VALA_EXTERN void usage_value_set_utils (GValue* value,
                            gpointer v_object);
VALA_EXTERN void usage_value_take_utils (GValue* value,
                             gpointer v_object);
VALA_EXTERN gpointer usage_value_get_utils (const GValue* value);
VALA_EXTERN GType usage_utils_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageUtils, usage_utils_unref)
VALA_EXTERN gchar* usage_utils_unescape (const gchar* escaped);
VALA_EXTERN gchar* usage_utils_format_size_values (guint64 value,
                                       gulong** most_significant);
static gulong* _ulong_dup (gulong* self);
VALA_EXTERN gchar* usage_utils_format_size_speed_values (guint64 value);
VALA_EXTERN void usage_utils_generate_color (GdkRGBA* default_color,
                                 guint order,
                                 guint all_count,
                                 gboolean reverse,
                                 GdkRGBA* result);
VALA_EXTERN void usage_utils_color_lighter (GdkRGBA* color,
                                gfloat percentage,
                                GdkRGBA* result);
VALA_EXTERN void usage_utils_color_darker (GdkRGBA* color,
                               gfloat percentage,
                               GdkRGBA* result);
static gfloat usage_utils_color_field_darker (gfloat field,
                                       gfloat percentage);
static gfloat usage_utils_color_field_lighter (gfloat field,
                                        gfloat percentage);
VALA_EXTERN UsageUtils* usage_utils_new (void);
VALA_EXTERN UsageUtils* usage_utils_construct (GType object_type);
static void usage_utils_finalize (UsageUtils * obj);
static GType usage_utils_get_type_once (void);
VALA_EXTERN GType usage_user_account_type_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType usage_fdo_accounts_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint usage_fdo_accounts_register_object (void* object,
                                          GDBusConnection* connection,
                                          const gchar* path,
                                          GError** error);
VALA_EXTERN GType usage_fdo_accounts_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageFdoAccounts, g_object_unref)
VALA_EXTERN void usage_fdo_accounts_FindUserById (UsageFdoAccounts* self,
                                      gint64 id,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
VALA_EXTERN gchar* usage_fdo_accounts_FindUserById_finish (UsageFdoAccounts* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static GType usage_fdo_accounts_get_type_once (void);
static void usage_fdo_accounts_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object,
                                   GAsyncResult *res,
                                   void *user_data);
static void usage_fdo_accounts_proxy_FindUserById_async (UsageFdoAccounts* self,
                                                  gint64 id,
                                                  GAsyncReadyCallback _callback_,
                                                  gpointer _user_data_);
static gchar* usage_fdo_accounts_proxy_FindUserById_finish (UsageFdoAccounts* self,
                                                     GAsyncResult* _res_,
                                                     GError** error);
static void usage_fdo_accounts_proxy_usage_fdo_accounts_interface_init (UsageFdoAccountsIface* iface);
static void _dbus_usage_fdo_accounts_FindUserById (UsageFdoAccounts* self,
                                            GVariant* _parameters_,
                                            GDBusMethodInvocation* invocation);
static void _dbus_usage_fdo_accounts_FindUserById_ready (GObject * source_object,
                                                  GAsyncResult * _res_,
                                                  gpointer _user_data_);
static void usage_fdo_accounts_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data);
static GVariant* usage_fdo_accounts_dbus_interface_get_property (GDBusConnection* connection,
                                                          const gchar* sender,
                                                          const gchar* object_path,
                                                          const gchar* interface_name,
                                                          const gchar* property_name,
                                                          GError** error,
                                                          gpointer user_data);
static gboolean usage_fdo_accounts_dbus_interface_set_property (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* property_name,
                                                         GVariant* value,
                                                         GError** error,
                                                         gpointer user_data);
static void _usage_fdo_accounts_unregister_object (gpointer user_data);
VALA_EXTERN GType usage_fdo_accounts_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (UsageFdoAccountsUser, g_object_unref)
VALA_EXTERN GType usage_fdo_accounts_user_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint usage_fdo_accounts_user_register_object (void* object,
                                               GDBusConnection* connection,
                                               const gchar* path,
                                               GError** error);
VALA_EXTERN gboolean usage_fdo_accounts_user_get_SystemAccount (UsageFdoAccountsUser* self);
VALA_EXTERN gboolean usage_fdo_accounts_user_get_LocalAccount (UsageFdoAccountsUser* self);
VALA_EXTERN gint32 usage_fdo_accounts_user_get_AccountType (UsageFdoAccountsUser* self);
VALA_EXTERN gchar* usage_fdo_accounts_user_get_RealName (UsageFdoAccountsUser* self);
VALA_EXTERN gchar* usage_fdo_accounts_user_get_UserName (UsageFdoAccountsUser* self);
VALA_EXTERN guint64 usage_fdo_accounts_user_get_Uid (UsageFdoAccountsUser* self);
static GType usage_fdo_accounts_user_get_type_once (void);
static void usage_fdo_accounts_user_proxy_g_signal (GDBusProxy* proxy,
                                             const gchar* sender_name,
                                             const gchar* signal_name,
                                             GVariant* parameters);
static gboolean usage_fdo_accounts_user_dbus_proxy_get_SystemAccount (UsageFdoAccountsUser* self);
static gboolean usage_fdo_accounts_user_dbus_proxy_get_LocalAccount (UsageFdoAccountsUser* self);
static gint32 usage_fdo_accounts_user_dbus_proxy_get_AccountType (UsageFdoAccountsUser* self);
static gchar* usage_fdo_accounts_user_dbus_proxy_get_RealName (UsageFdoAccountsUser* self);
static gchar* usage_fdo_accounts_user_dbus_proxy_get_UserName (UsageFdoAccountsUser* self);
static guint64 usage_fdo_accounts_user_dbus_proxy_get_Uid (UsageFdoAccountsUser* self);
static void usage_fdo_accounts_user_proxy_usage_fdo_accounts_user_interface_init (UsageFdoAccountsUserIface* iface);
static void usage_fdo_accounts_user_dbus_interface_method_call (GDBusConnection* connection,
                                                         const gchar* sender,
                                                         const gchar* object_path,
                                                         const gchar* interface_name,
                                                         const gchar* method_name,
                                                         GVariant* parameters,
                                                         GDBusMethodInvocation* invocation,
                                                         gpointer user_data);
static GVariant* usage_fdo_accounts_user_dbus_interface_get_property (GDBusConnection* connection,
                                                               const gchar* sender,
                                                               const gchar* object_path,
                                                               const gchar* interface_name,
                                                               const gchar* property_name,
                                                               GError** error,
                                                               gpointer user_data);
static GVariant* _dbus_usage_fdo_accounts_user_get_SystemAccount (UsageFdoAccountsUser* self);
static GVariant* _dbus_usage_fdo_accounts_user_get_LocalAccount (UsageFdoAccountsUser* self);
static GVariant* _dbus_usage_fdo_accounts_user_get_AccountType (UsageFdoAccountsUser* self);
static GVariant* _dbus_usage_fdo_accounts_user_get_RealName (UsageFdoAccountsUser* self);
static GVariant* _dbus_usage_fdo_accounts_user_get_UserName (UsageFdoAccountsUser* self);
static GVariant* _dbus_usage_fdo_accounts_user_get_Uid (UsageFdoAccountsUser* self);
static gboolean usage_fdo_accounts_user_dbus_interface_set_property (GDBusConnection* connection,
                                                              const gchar* sender,
                                                              const gchar* object_path,
                                                              const gchar* interface_name,
                                                              const gchar* property_name,
                                                              GVariant* value,
                                                              GError** error,
                                                              gpointer user_data);
static void _usage_fdo_accounts_user_unregister_object (gpointer user_data);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static const GDBusArgInfo _usage_fdo_accounts_dbus_arg_info_FindUserById_id = {-1, "id", "x", NULL};
static const GDBusArgInfo _usage_fdo_accounts_dbus_arg_info_FindUserById_result = {-1, "result", "s", NULL};
static const GDBusArgInfo * const _usage_fdo_accounts_dbus_arg_info_FindUserById_in[] = {&_usage_fdo_accounts_dbus_arg_info_FindUserById_id, NULL};
static const GDBusArgInfo * const _usage_fdo_accounts_dbus_arg_info_FindUserById_out[] = {&_usage_fdo_accounts_dbus_arg_info_FindUserById_result, NULL};
static const GDBusMethodInfo _usage_fdo_accounts_dbus_method_info_FindUserById = {-1, "FindUserById", (GDBusArgInfo **) (&_usage_fdo_accounts_dbus_arg_info_FindUserById_in), (GDBusArgInfo **) (&_usage_fdo_accounts_dbus_arg_info_FindUserById_out), NULL};
static const GDBusMethodInfo * const _usage_fdo_accounts_dbus_method_info[] = {&_usage_fdo_accounts_dbus_method_info_FindUserById, NULL};
static const GDBusSignalInfo * const _usage_fdo_accounts_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _usage_fdo_accounts_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _usage_fdo_accounts_dbus_interface_info = {-1, "org.freedesktop.Accounts", (GDBusMethodInfo **) (&_usage_fdo_accounts_dbus_method_info), (GDBusSignalInfo **) (&_usage_fdo_accounts_dbus_signal_info), (GDBusPropertyInfo **) (&_usage_fdo_accounts_dbus_property_info), NULL};
static const GDBusInterfaceVTable _usage_fdo_accounts_dbus_interface_vtable = {usage_fdo_accounts_dbus_interface_method_call, usage_fdo_accounts_dbus_interface_get_property, usage_fdo_accounts_dbus_interface_set_property};
static const GDBusMethodInfo * const _usage_fdo_accounts_user_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _usage_fdo_accounts_user_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _usage_fdo_accounts_user_dbus_property_info_SystemAccount = {-1, "SystemAccount", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _usage_fdo_accounts_user_dbus_property_info_LocalAccount = {-1, "LocalAccount", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _usage_fdo_accounts_user_dbus_property_info_AccountType = {-1, "AccountType", "i", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _usage_fdo_accounts_user_dbus_property_info_RealName = {-1, "RealName", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _usage_fdo_accounts_user_dbus_property_info_UserName = {-1, "UserName", "s", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo _usage_fdo_accounts_user_dbus_property_info_Uid = {-1, "Uid", "t", G_DBUS_PROPERTY_INFO_FLAGS_READABLE, NULL};
static const GDBusPropertyInfo * const _usage_fdo_accounts_user_dbus_property_info[] = {&_usage_fdo_accounts_user_dbus_property_info_SystemAccount, &_usage_fdo_accounts_user_dbus_property_info_LocalAccount, &_usage_fdo_accounts_user_dbus_property_info_AccountType, &_usage_fdo_accounts_user_dbus_property_info_RealName, &_usage_fdo_accounts_user_dbus_property_info_UserName, &_usage_fdo_accounts_user_dbus_property_info_Uid, NULL};
static const GDBusInterfaceInfo _usage_fdo_accounts_user_dbus_interface_info = {-1, "org.freedesktop.Accounts.User", (GDBusMethodInfo **) (&_usage_fdo_accounts_user_dbus_method_info), (GDBusSignalInfo **) (&_usage_fdo_accounts_user_dbus_signal_info), (GDBusPropertyInfo **) (&_usage_fdo_accounts_user_dbus_property_info), NULL};
static const GDBusInterfaceVTable _usage_fdo_accounts_user_dbus_interface_vtable = {usage_fdo_accounts_user_dbus_interface_method_call, usage_fdo_accounts_user_dbus_interface_get_property, usage_fdo_accounts_user_dbus_interface_set_property};

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gchar*
string_splice (const gchar* self,
               glong start,
               glong end,
               const gchar* str)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gsize str_size = 0UL;
	const gchar* _result_ = NULL;
	void* _tmp6_;
	gchar* dest = NULL;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp12_;
	const gchar* _tmp13_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	if (str == NULL) {
		str_size = (gsize) 0;
	} else {
		gint _tmp4_;
		gint _tmp5_;
		_tmp4_ = strlen ((const gchar*) str);
		_tmp5_ = _tmp4_;
		str_size = (gsize) _tmp5_;
	}
	_tmp6_ = g_malloc0 (((string_length - (end - start)) + str_size) + 1);
	_result_ = _tmp6_;
	_tmp7_ = _result_;
	dest = (gchar*) _tmp7_;
	_tmp8_ = dest;
	memcpy (_tmp8_, self, (gsize) start);
	_tmp9_ = dest;
	dest = _tmp9_ + start;
	if (str != NULL) {
		gchar* _tmp10_;
		gchar* _tmp11_;
		_tmp10_ = dest;
		memcpy (_tmp10_, str, str_size);
		_tmp11_ = dest;
		dest = _tmp11_ + str_size;
	}
	_tmp12_ = dest;
	memcpy (_tmp12_, ((gchar*) self) + end, (gsize) (string_length - end));
	_tmp13_ = _result_;
	_result_ = NULL;
	result = (gchar*) _tmp13_;
	return result;
}

gchar*
usage_utils_unescape (const gchar* escaped)
{
	gchar* unescaped = NULL;
	gchar* _tmp0_;
	gunichar c = 0U;
	gint index = 0;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* result;
	g_return_val_if_fail (escaped != NULL, NULL);
	_tmp0_ = g_strdup (escaped);
	unescaped = _tmp0_;
	c = (gunichar) 0;
	index = 0;
	while (TRUE) {
		const gchar* _tmp1_;
		gunichar _tmp2_ = 0U;
		gboolean _tmp3_;
		const gchar* _tmp4_;
		gunichar _tmp5_ = 0U;
		_tmp1_ = unescaped;
		_tmp3_ = string_get_next_char (_tmp1_, &index, &_tmp2_);
		c = _tmp2_;
		if (!_tmp3_) {
			break;
		}
		if (c != ((gunichar) '\\')) {
			continue;
		}
		_tmp4_ = unescaped;
		string_get_next_char (_tmp4_, &index, &_tmp5_);
		c = _tmp5_;
		if (c == ((gunichar) 'x')) {
			gchar* char_point = NULL;
			const gchar* _tmp6_;
			gchar* _tmp7_;
			gchar unescaped_char = '\0';
			const gchar* _tmp28_;
			gchar* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp6_ = unescaped;
			_tmp7_ = string_slice (_tmp6_, (glong) index, (glong) (index + 2));
			char_point = _tmp7_;
			unescaped_char = (gchar) 0;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp8_ = FALSE;
					_tmp8_ = TRUE;
					while (TRUE) {
						const gchar* _tmp10_;
						gint _tmp11_;
						gint _tmp12_;
						gchar offset = '\0';
						const gchar* _tmp13_;
						guint8* _tmp14_;
						gint _tmp14__length1;
						gint _tmp15_ = 0;
						guint8* _tmp16_;
						gint _tmp16__length1;
						guint8 _tmp17_;
						const gchar* _tmp18_;
						guint8* _tmp19_;
						gint _tmp19__length1;
						gint _tmp20_ = 0;
						guint8* _tmp21_;
						gint _tmp21__length1;
						guint8 _tmp22_;
						const gchar* _tmp23_;
						guint8* _tmp24_;
						gint _tmp24__length1;
						gint _tmp25_ = 0;
						guint8* _tmp26_;
						gint _tmp26__length1;
						guint8 _tmp27_;
						if (!_tmp8_) {
							gint _tmp9_;
							_tmp9_ = i;
							i = _tmp9_ + 1;
						}
						_tmp8_ = FALSE;
						_tmp10_ = char_point;
						_tmp11_ = strlen (_tmp10_);
						_tmp12_ = _tmp11_;
						if (!(i < _tmp12_)) {
							break;
						}
						offset = '0';
						_tmp13_ = char_point;
						_tmp14_ = string_get_data (_tmp13_, &_tmp15_);
						_tmp14__length1 = _tmp15_;
						_tmp16_ = _tmp14_;
						_tmp16__length1 = _tmp14__length1;
						_tmp17_ = _tmp16_[i];
						if (_tmp17_ >= ((guint8) 'A')) {
							offset = (gchar) ('A' - 10);
						}
						_tmp18_ = char_point;
						_tmp19_ = string_get_data (_tmp18_, &_tmp20_);
						_tmp19__length1 = _tmp20_;
						_tmp21_ = _tmp19_;
						_tmp21__length1 = _tmp19__length1;
						_tmp22_ = _tmp21_[i];
						if (_tmp22_ >= ((guint8) 'a')) {
							offset = (gchar) ('a' - 10);
						}
						_tmp23_ = char_point;
						_tmp24_ = string_get_data (_tmp23_, &_tmp25_);
						_tmp24__length1 = _tmp25_;
						_tmp26_ = _tmp24_;
						_tmp26__length1 = _tmp24__length1;
						_tmp27_ = _tmp26_[i];
						unescaped_char = (gchar) (((unescaped_char * 16) + _tmp27_) - offset);
					}
				}
			}
			_tmp28_ = unescaped;
			_tmp29_ = g_strdup_printf ("%c", unescaped_char);
			_tmp30_ = _tmp29_;
			_tmp31_ = string_splice (_tmp28_, (glong) (index - 2), (glong) (index + 2), _tmp30_);
			_g_free0 (unescaped);
			unescaped = _tmp31_;
			_g_free0 (_tmp30_);
			_g_free0 (char_point);
		}
	}
	_tmp32_ = unescaped;
	_tmp33_ = g_strcompress (_tmp32_);
	result = _tmp33_;
	_g_free0 (unescaped);
	return result;
}

static gulong*
_ulong_dup (gulong* self)
{
	gulong* dup;
	dup = g_new0 (gulong, 1);
	memcpy (dup, self, sizeof (gulong));
	return dup;
}

static gpointer
__ulong_dup0 (gpointer self)
{
	return self ? _ulong_dup (self) : NULL;
}

gchar*
usage_utils_format_size_values (guint64 value,
                                gulong** most_significant)
{
	gulong* _vala_most_significant = NULL;
	guint64 significant = 0ULL;
	gulong _tmp0_;
	gulong* _tmp1_;
	gchar* result;
	significant = value;
	while (TRUE) {
		if (!(significant > ((guint64) 1000))) {
			break;
		}
		significant /= (guint64) 1000;
	}
	_tmp0_ = (gulong) significant;
	_tmp1_ = __ulong_dup0 (&_tmp0_);
	_g_free0 (_vala_most_significant);
	_vala_most_significant = _tmp1_;
	if (value >= ((guint64) 1000)) {
		gchar* _tmp2_;
		_tmp2_ = g_format_size_full (value, G_FORMAT_SIZE_DEFAULT);
		result = _tmp2_;
		if (most_significant) {
			*most_significant = _vala_most_significant;
		} else {
			_g_free0 (_vala_most_significant);
		}
		return result;
	} else {
		gchar* _tmp3_;
		_tmp3_ = g_strdup_printf (_ ("%llu B"), value);
		result = _tmp3_;
		if (most_significant) {
			*most_significant = _vala_most_significant;
		} else {
			_g_free0 (_vala_most_significant);
		}
		return result;
	}
}

gchar*
usage_utils_format_size_speed_values (guint64 value)
{
	gchar* result;
	if (value >= ((guint64) 1000)) {
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = g_format_size_full (value, G_FORMAT_SIZE_DEFAULT);
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf (_ ("%s/s"), _tmp1_);
		_tmp3_ = _tmp2_;
		_g_free0 (_tmp1_);
		result = _tmp3_;
		return result;
	} else {
		gchar* _tmp4_;
		_tmp4_ = g_strdup_printf (_ ("%llu B/s"), value);
		result = _tmp4_;
		return result;
	}
}

void
usage_utils_generate_color (GdkRGBA* default_color,
                            guint order,
                            guint all_count,
                            gboolean reverse,
                            GdkRGBA* result)
{
	gfloat step = 0.0F;
	guint half_count = 0U;
	g_return_if_fail (default_color != NULL);
	step = 100 / ((gfloat) all_count);
	half_count = all_count / 2;
	if (order >= all_count) {
		order = all_count - 1;
	}
	if (order > (all_count / 2)) {
		gfloat percentage = 0.0F;
		percentage = step * (order - half_count);
		if (reverse) {
			GdkRGBA _tmp0_;
			GdkRGBA _tmp1_ = {0};
			_tmp0_ = *default_color;
			usage_utils_color_lighter (&_tmp0_, percentage, &_tmp1_);
			*result = _tmp1_;
			return;
		} else {
			GdkRGBA _tmp2_;
			GdkRGBA _tmp3_ = {0};
			_tmp2_ = *default_color;
			usage_utils_color_darker (&_tmp2_, percentage, &_tmp3_);
			*result = _tmp3_;
			return;
		}
	} else {
		gfloat percentage = 0.0F;
		percentage = step * (half_count - (order - 1));
		if (reverse) {
			GdkRGBA _tmp4_;
			GdkRGBA _tmp5_ = {0};
			_tmp4_ = *default_color;
			usage_utils_color_darker (&_tmp4_, percentage, &_tmp5_);
			*result = _tmp5_;
			return;
		} else {
			GdkRGBA _tmp6_;
			GdkRGBA _tmp7_ = {0};
			_tmp6_ = *default_color;
			usage_utils_color_lighter (&_tmp6_, percentage, &_tmp7_);
			*result = _tmp7_;
			return;
		}
	}
}

void
usage_utils_color_darker (GdkRGBA* color,
                          gfloat percentage,
                          GdkRGBA* result)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	g_return_if_fail (color != NULL);
	_tmp0_ = *color;
	(*color).red = usage_utils_color_field_darker (_tmp0_.red, percentage);
	_tmp1_ = *color;
	(*color).green = usage_utils_color_field_darker (_tmp1_.green, percentage);
	_tmp2_ = *color;
	(*color).blue = usage_utils_color_field_darker (_tmp2_.blue, percentage);
	_tmp3_ = *color;
	*result = _tmp3_;
	return;
}

void
usage_utils_color_lighter (GdkRGBA* color,
                           gfloat percentage,
                           GdkRGBA* result)
{
	GdkRGBA _tmp0_;
	GdkRGBA _tmp1_;
	GdkRGBA _tmp2_;
	GdkRGBA _tmp3_;
	g_return_if_fail (color != NULL);
	_tmp0_ = *color;
	(*color).red = usage_utils_color_field_lighter (_tmp0_.red, percentage);
	_tmp1_ = *color;
	(*color).green = usage_utils_color_field_lighter (_tmp1_.green, percentage);
	_tmp2_ = *color;
	(*color).blue = usage_utils_color_field_lighter (_tmp2_.blue, percentage);
	_tmp3_ = *color;
	*result = _tmp3_;
	return;
}

static gfloat
usage_utils_color_field_darker (gfloat field,
                                gfloat percentage)
{
	gfloat result;
	field = field * 255;
	result = (field - ((field / 100) * percentage)) / 255;
	return result;
}

static gfloat
usage_utils_color_field_lighter (gfloat field,
                                 gfloat percentage)
{
	gfloat result;
	field = field * 255;
	result = (field + (((255 - field) / 100) * percentage)) / 255;
	return result;
}

UsageUtils*
usage_utils_construct (GType object_type)
{
	UsageUtils* self = NULL;
	self = (UsageUtils*) g_type_create_instance (object_type);
	return self;
}

UsageUtils*
usage_utils_new (void)
{
	return usage_utils_construct (USAGE_TYPE_UTILS);
}

static void
usage_value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
usage_value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		usage_utils_unref (value->data[0].v_pointer);
	}
}

static void
usage_value_utils_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = usage_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
usage_value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
usage_value_utils_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		UsageUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = usage_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
usage_value_utils_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	UsageUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = usage_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
usage_param_spec_utils (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	UsageParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, USAGE_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
usage_value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
usage_value_set_utils (GValue* value,
                       gpointer v_object)
{
	UsageUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, USAGE_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		usage_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		usage_utils_unref (old);
	}
}

void
usage_value_take_utils (GValue* value,
                        gpointer v_object)
{
	UsageUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, USAGE_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, USAGE_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		usage_utils_unref (old);
	}
}

static void
usage_utils_class_init (UsageUtilsClass * klass,
                        gpointer klass_data)
{
	usage_utils_parent_class = g_type_class_peek_parent (klass);
	((UsageUtilsClass *) klass)->finalize = usage_utils_finalize;
}

static void
usage_utils_instance_init (UsageUtils * self,
                           gpointer klass)
{
	self->ref_count = 1;
}

static void
usage_utils_finalize (UsageUtils * obj)
{
	UsageUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, USAGE_TYPE_UTILS, UsageUtils);
	g_signal_handlers_destroy (self);
}

static GType
usage_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { usage_value_utils_init, usage_value_utils_free_value, usage_value_utils_copy_value, usage_value_utils_peek_pointer, "p", usage_value_utils_collect_value, "p", usage_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (UsageUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (UsageUtils), 0, (GInstanceInitFunc) usage_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType usage_utils_type_id;
	usage_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "UsageUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return usage_utils_type_id;
}

GType
usage_utils_get_type (void)
{
	static volatile gsize usage_utils_type_id__once = 0;
	if (g_once_init_enter (&usage_utils_type_id__once)) {
		GType usage_utils_type_id;
		usage_utils_type_id = usage_utils_get_type_once ();
		g_once_init_leave (&usage_utils_type_id__once, usage_utils_type_id);
	}
	return usage_utils_type_id__once;
}

gpointer
usage_utils_ref (gpointer instance)
{
	UsageUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
usage_utils_unref (gpointer instance)
{
	UsageUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		USAGE_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static GType
usage_user_account_type_get_type_once (void)
{
	static const GEnumValue values[] = {{USAGE_USER_ACCOUNT_TYPE_STANDARD, "USAGE_USER_ACCOUNT_TYPE_STANDARD", "standard"}, {USAGE_USER_ACCOUNT_TYPE_ADMINISTRATOR, "USAGE_USER_ACCOUNT_TYPE_ADMINISTRATOR", "administrator"}, {0, NULL, NULL}};
	GType usage_user_account_type_type_id;
	usage_user_account_type_type_id = g_enum_register_static ("UsageUserAccountType", values);
	return usage_user_account_type_type_id;
}

GType
usage_user_account_type_get_type (void)
{
	static volatile gsize usage_user_account_type_type_id__once = 0;
	if (g_once_init_enter (&usage_user_account_type_type_id__once)) {
		GType usage_user_account_type_type_id;
		usage_user_account_type_type_id = usage_user_account_type_get_type_once ();
		g_once_init_leave (&usage_user_account_type_type_id__once, usage_user_account_type_type_id);
	}
	return usage_user_account_type_type_id__once;
}

void
usage_fdo_accounts_FindUserById (UsageFdoAccounts* self,
                                 gint64 id,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	UsageFdoAccountsIface* _iface_;
	_iface_ = USAGE_FDO_ACCOUNTS_GET_INTERFACE (self);
	if (_iface_->FindUserById) {
		_iface_->FindUserById (self, id, _callback_, _user_data_);
	}
}

gchar*
usage_fdo_accounts_FindUserById_finish (UsageFdoAccounts* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	UsageFdoAccountsIface* _iface_;
	_iface_ = USAGE_FDO_ACCOUNTS_GET_INTERFACE (self);
	if (_iface_->FindUserById_finish) {
		return _iface_->FindUserById_finish (self, _res_, error);
	}
	return NULL;
}

static void
usage_fdo_accounts_default_init (UsageFdoAccountsIface * iface,
                                 gpointer iface_data)
{
}

static GType
usage_fdo_accounts_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageFdoAccountsIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_fdo_accounts_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType usage_fdo_accounts_type_id;
	usage_fdo_accounts_type_id = g_type_register_static (G_TYPE_INTERFACE, "UsageFdoAccounts", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (usage_fdo_accounts_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (usage_fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) usage_fdo_accounts_proxy_get_type);
	g_type_set_qdata (usage_fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Accounts");
	g_type_set_qdata (usage_fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_usage_fdo_accounts_dbus_interface_info));
	g_type_set_qdata (usage_fdo_accounts_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) usage_fdo_accounts_register_object);
	return usage_fdo_accounts_type_id;
}

GType
usage_fdo_accounts_get_type (void)
{
	static volatile gsize usage_fdo_accounts_type_id__once = 0;
	if (g_once_init_enter (&usage_fdo_accounts_type_id__once)) {
		GType usage_fdo_accounts_type_id;
		usage_fdo_accounts_type_id = usage_fdo_accounts_get_type_once ();
		g_once_init_leave (&usage_fdo_accounts_type_id__once, usage_fdo_accounts_type_id);
	}
	return usage_fdo_accounts_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (UsageFdoAccountsProxy, usage_fdo_accounts_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (USAGE_FDO_TYPE_ACCOUNTS, usage_fdo_accounts_proxy_usage_fdo_accounts_interface_init) )
static void
usage_fdo_accounts_proxy_class_init (UsageFdoAccountsProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = usage_fdo_accounts_proxy_g_signal;
}

static void
usage_fdo_accounts_proxy_g_signal (GDBusProxy* proxy,
                                   const gchar* sender_name,
                                   const gchar* signal_name,
                                   GVariant* parameters)
{
}

static void
usage_fdo_accounts_proxy_init (UsageFdoAccountsProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_usage_fdo_accounts_dbus_interface_info));
}

static void
_vala_g_async_ready_callback (GObject *source_object,
                              GAsyncResult *res,
                              void *user_data)
{
	g_task_return_pointer (user_data, g_object_ref (res), g_object_unref);
	g_object_unref (user_data);
}

static void
usage_fdo_accounts_proxy_FindUserById_async (UsageFdoAccounts* self,
                                             gint64 id,
                                             GAsyncReadyCallback _callback_,
                                             gpointer _user_data_)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "org.freedesktop.Accounts", "FindUserById");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_int64 (id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	if (_callback_ != NULL) {
		g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_task_new ((GObject *) self, NULL, _callback_, _user_data_));
	} else {
		g_dbus_message_set_flags (_message, G_DBUS_MESSAGE_FLAGS_NO_REPLY_EXPECTED);
		g_dbus_connection_send_message (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	}
	g_object_unref (_message);
}

static gchar*
usage_fdo_accounts_proxy_FindUserById_finish (UsageFdoAccounts* self,
                                              GAsyncResult* _res_,
                                              GError** error)
{
	GAsyncResult *_inner_res;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar* _result = NULL;
	GVariant* _tmp63_;
	_inner_res = g_task_propagate_pointer ((GTask *) _res_, NULL);
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), _inner_res, error);
	g_object_unref (_inner_res);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_tmp63_ = g_variant_iter_next_value (&_reply_iter);
	_result = g_variant_dup_string (_tmp63_, NULL);
	g_variant_unref (_tmp63_);
	g_object_unref (_reply_message);
	return _result;
}

static void
usage_fdo_accounts_proxy_usage_fdo_accounts_interface_init (UsageFdoAccountsIface* iface)
{
	iface->FindUserById = usage_fdo_accounts_proxy_FindUserById_async;
	iface->FindUserById_finish = usage_fdo_accounts_proxy_FindUserById_finish;
}

static void
_dbus_usage_fdo_accounts_FindUserById (UsageFdoAccounts* self,
                                       GVariant* _parameters_,
                                       GDBusMethodInvocation* invocation)
{
	GVariantIter _arguments_iter;
	usage_fdo_accounts_FindUserByIdReadyData* _ready_data;
	GVariant* _tmp64_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_ready_data = g_slice_new0 (usage_fdo_accounts_FindUserByIdReadyData);
	_ready_data->_invocation_ = invocation;
	_tmp64_ = g_variant_iter_next_value (&_arguments_iter);
	_ready_data->id = g_variant_get_int64 (_tmp64_);
	g_variant_unref (_tmp64_);
	usage_fdo_accounts_FindUserById (self, _ready_data->id, (GAsyncReadyCallback) _dbus_usage_fdo_accounts_FindUserById_ready, _ready_data);
}

static void
_dbus_usage_fdo_accounts_FindUserById_ready (GObject * source_object,
                                             GAsyncResult * _res_,
                                             gpointer _user_data_)
{
	usage_fdo_accounts_FindUserByIdReadyData* _ready_data;
	GDBusMethodInvocation* invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar* result;
	_ready_data = _user_data_;
	invocation = _ready_data->_invocation_;
	result = usage_fdo_accounts_FindUserById_finish ((UsageFdoAccounts*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_string (result));
	_g_free0 (result);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	g_slice_free (usage_fdo_accounts_FindUserByIdReadyData, _ready_data);
}

static void
usage_fdo_accounts_dbus_interface_method_call (GDBusConnection* connection,
                                               const gchar* sender,
                                               const gchar* object_path,
                                               const gchar* interface_name,
                                               const gchar* method_name,
                                               GVariant* parameters,
                                               GDBusMethodInvocation* invocation,
                                               gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "FindUserById") == 0) {
		_dbus_usage_fdo_accounts_FindUserById (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
usage_fdo_accounts_dbus_interface_get_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
usage_fdo_accounts_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
usage_fdo_accounts_register_object (gpointer object,
                                    GDBusConnection* connection,
                                    const gchar* path,
                                    GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_usage_fdo_accounts_dbus_interface_info), &_usage_fdo_accounts_dbus_interface_vtable, data, _usage_fdo_accounts_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_usage_fdo_accounts_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

gboolean
usage_fdo_accounts_user_get_SystemAccount (UsageFdoAccountsUser* self)
{
	UsageFdoAccountsUserIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = USAGE_FDO_ACCOUNTS_USER_GET_INTERFACE (self);
	if (_iface_->get_SystemAccount) {
		return _iface_->get_SystemAccount (self);
	}
	return FALSE;
}

gboolean
usage_fdo_accounts_user_get_LocalAccount (UsageFdoAccountsUser* self)
{
	UsageFdoAccountsUserIface* _iface_;
	g_return_val_if_fail (self != NULL, FALSE);
	_iface_ = USAGE_FDO_ACCOUNTS_USER_GET_INTERFACE (self);
	if (_iface_->get_LocalAccount) {
		return _iface_->get_LocalAccount (self);
	}
	return FALSE;
}

gint32
usage_fdo_accounts_user_get_AccountType (UsageFdoAccountsUser* self)
{
	UsageFdoAccountsUserIface* _iface_;
	g_return_val_if_fail (self != NULL, 0);
	_iface_ = USAGE_FDO_ACCOUNTS_USER_GET_INTERFACE (self);
	if (_iface_->get_AccountType) {
		return _iface_->get_AccountType (self);
	}
	return -1;
}

gchar*
usage_fdo_accounts_user_get_RealName (UsageFdoAccountsUser* self)
{
	UsageFdoAccountsUserIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = USAGE_FDO_ACCOUNTS_USER_GET_INTERFACE (self);
	if (_iface_->get_RealName) {
		return _iface_->get_RealName (self);
	}
	return NULL;
}

gchar*
usage_fdo_accounts_user_get_UserName (UsageFdoAccountsUser* self)
{
	UsageFdoAccountsUserIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = USAGE_FDO_ACCOUNTS_USER_GET_INTERFACE (self);
	if (_iface_->get_UserName) {
		return _iface_->get_UserName (self);
	}
	return NULL;
}

guint64
usage_fdo_accounts_user_get_Uid (UsageFdoAccountsUser* self)
{
	UsageFdoAccountsUserIface* _iface_;
	g_return_val_if_fail (self != NULL, 0ULL);
	_iface_ = USAGE_FDO_ACCOUNTS_USER_GET_INTERFACE (self);
	if (_iface_->get_Uid) {
		return _iface_->get_Uid (self);
	}
	return 0ULL;
}

static void
usage_fdo_accounts_user_default_init (UsageFdoAccountsUserIface * iface,
                                      gpointer iface_data)
{
}

static GType
usage_fdo_accounts_user_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (UsageFdoAccountsUserIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) usage_fdo_accounts_user_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType usage_fdo_accounts_user_type_id;
	usage_fdo_accounts_user_type_id = g_type_register_static (G_TYPE_INTERFACE, "UsageFdoAccountsUser", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (usage_fdo_accounts_user_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (usage_fdo_accounts_user_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) usage_fdo_accounts_user_proxy_get_type);
	g_type_set_qdata (usage_fdo_accounts_user_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.freedesktop.Accounts.User");
	g_type_set_qdata (usage_fdo_accounts_user_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_usage_fdo_accounts_user_dbus_interface_info));
	g_type_set_qdata (usage_fdo_accounts_user_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) usage_fdo_accounts_user_register_object);
	return usage_fdo_accounts_user_type_id;
}

GType
usage_fdo_accounts_user_get_type (void)
{
	static volatile gsize usage_fdo_accounts_user_type_id__once = 0;
	if (g_once_init_enter (&usage_fdo_accounts_user_type_id__once)) {
		GType usage_fdo_accounts_user_type_id;
		usage_fdo_accounts_user_type_id = usage_fdo_accounts_user_get_type_once ();
		g_once_init_leave (&usage_fdo_accounts_user_type_id__once, usage_fdo_accounts_user_type_id);
	}
	return usage_fdo_accounts_user_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (UsageFdoAccountsUserProxy, usage_fdo_accounts_user_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (USAGE_FDO_TYPE_ACCOUNTS_USER, usage_fdo_accounts_user_proxy_usage_fdo_accounts_user_interface_init) )
static void
usage_fdo_accounts_user_proxy_class_init (UsageFdoAccountsUserProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = usage_fdo_accounts_user_proxy_g_signal;
}

static void
usage_fdo_accounts_user_proxy_g_signal (GDBusProxy* proxy,
                                        const gchar* sender_name,
                                        const gchar* signal_name,
                                        GVariant* parameters)
{
}

static void
usage_fdo_accounts_user_proxy_init (UsageFdoAccountsUserProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_usage_fdo_accounts_user_dbus_interface_info));
}

static gboolean
usage_fdo_accounts_user_dbus_proxy_get_SystemAccount (UsageFdoAccountsUser* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "SystemAccount");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.Accounts.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("SystemAccount"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp65_ = FALSE;
			return _tmp65_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gboolean
usage_fdo_accounts_user_dbus_proxy_get_LocalAccount (UsageFdoAccountsUser* self)
{
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "LocalAccount");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.Accounts.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("LocalAccount"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gboolean _tmp66_ = FALSE;
			return _tmp66_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gint32
usage_fdo_accounts_user_dbus_proxy_get_AccountType (UsageFdoAccountsUser* self)
{
	GVariant *_inner_reply;
	gint32 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "AccountType");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.Accounts.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("AccountType"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			gint32 _tmp67_ = 0;
			return _tmp67_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_int32 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
usage_fdo_accounts_user_dbus_proxy_get_RealName (UsageFdoAccountsUser* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "RealName");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.Accounts.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("RealName"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static gchar*
usage_fdo_accounts_user_dbus_proxy_get_UserName (UsageFdoAccountsUser* self)
{
	GVariant *_inner_reply;
	gchar* _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "UserName");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.Accounts.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("UserName"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return NULL;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_dup_string (_inner_reply, NULL);
	g_variant_unref (_inner_reply);
	return _result;
}

static guint64
usage_fdo_accounts_user_dbus_proxy_get_Uid (UsageFdoAccountsUser* self)
{
	GVariant *_inner_reply;
	guint64 _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "Uid");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.freedesktop.Accounts.User"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("Uid"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			guint64 _tmp68_ = 0ULL;
			return _tmp68_;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_uint64 (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}

static void
usage_fdo_accounts_user_proxy_usage_fdo_accounts_user_interface_init (UsageFdoAccountsUserIface* iface)
{
	iface->get_SystemAccount = usage_fdo_accounts_user_dbus_proxy_get_SystemAccount;
	iface->get_LocalAccount = usage_fdo_accounts_user_dbus_proxy_get_LocalAccount;
	iface->get_AccountType = usage_fdo_accounts_user_dbus_proxy_get_AccountType;
	iface->get_RealName = usage_fdo_accounts_user_dbus_proxy_get_RealName;
	iface->get_UserName = usage_fdo_accounts_user_dbus_proxy_get_UserName;
	iface->get_Uid = usage_fdo_accounts_user_dbus_proxy_get_Uid;
}

static void
usage_fdo_accounts_user_dbus_interface_method_call (GDBusConnection* connection,
                                                    const gchar* sender,
                                                    const gchar* object_path,
                                                    const gchar* interface_name,
                                                    const gchar* method_name,
                                                    GVariant* parameters,
                                                    GDBusMethodInvocation* invocation,
                                                    gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}

static GVariant*
_dbus_usage_fdo_accounts_user_get_SystemAccount (UsageFdoAccountsUser* self)
{
	gboolean result;
	GVariant* _reply;
	result = usage_fdo_accounts_user_get_SystemAccount (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_usage_fdo_accounts_user_get_LocalAccount (UsageFdoAccountsUser* self)
{
	gboolean result;
	GVariant* _reply;
	result = usage_fdo_accounts_user_get_LocalAccount (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}

static GVariant*
_dbus_usage_fdo_accounts_user_get_AccountType (UsageFdoAccountsUser* self)
{
	gint32 result;
	GVariant* _reply;
	result = usage_fdo_accounts_user_get_AccountType (self);
	_reply = g_variant_new_int32 (result);
	return _reply;
}

static GVariant*
_dbus_usage_fdo_accounts_user_get_RealName (UsageFdoAccountsUser* self)
{
	gchar* result;
	GVariant* _reply;
	result = usage_fdo_accounts_user_get_RealName (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_usage_fdo_accounts_user_get_UserName (UsageFdoAccountsUser* self)
{
	gchar* result;
	GVariant* _reply;
	result = usage_fdo_accounts_user_get_UserName (self);
	_reply = g_variant_new_string (result);
	_g_free0 (result);
	return _reply;
}

static GVariant*
_dbus_usage_fdo_accounts_user_get_Uid (UsageFdoAccountsUser* self)
{
	guint64 result;
	GVariant* _reply;
	result = usage_fdo_accounts_user_get_Uid (self);
	_reply = g_variant_new_uint64 (result);
	return _reply;
}

static GVariant*
usage_fdo_accounts_user_dbus_interface_get_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "SystemAccount") == 0) {
		return _dbus_usage_fdo_accounts_user_get_SystemAccount (object);
	} else if (strcmp (property_name, "LocalAccount") == 0) {
		return _dbus_usage_fdo_accounts_user_get_LocalAccount (object);
	} else if (strcmp (property_name, "AccountType") == 0) {
		return _dbus_usage_fdo_accounts_user_get_AccountType (object);
	} else if (strcmp (property_name, "RealName") == 0) {
		return _dbus_usage_fdo_accounts_user_get_RealName (object);
	} else if (strcmp (property_name, "UserName") == 0) {
		return _dbus_usage_fdo_accounts_user_get_UserName (object);
	} else if (strcmp (property_name, "Uid") == 0) {
		return _dbus_usage_fdo_accounts_user_get_Uid (object);
	}
	return NULL;
}

static gboolean
usage_fdo_accounts_user_dbus_interface_set_property (GDBusConnection* connection,
                                                     const gchar* sender,
                                                     const gchar* object_path,
                                                     const gchar* interface_name,
                                                     const gchar* property_name,
                                                     GVariant* value,
                                                     GError** error,
                                                     gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
usage_fdo_accounts_user_register_object (gpointer object,
                                         GDBusConnection* connection,
                                         const gchar* path,
                                         GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_usage_fdo_accounts_user_dbus_interface_info), &_usage_fdo_accounts_user_dbus_interface_vtable, data, _usage_fdo_accounts_user_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_usage_fdo_accounts_user_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

