/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, analog, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_analog_probe_avg_mag_sqrd_f = R"doc(compute avg magnitude squared.

input stream 0: float


Compute a running average of the magnitude squared of the the input. The level and indication as to whether the level exceeds threshold can be retrieved with the level and unmuted accessors.

Constructor Specific Documentation:

Make a float sink that computes avg magnitude squared.

Args:
    threshold_db : Threshold for muting.
    alpha : Gain parameter for the running average filter.)doc";


static const char* __doc_gr_analog_probe_avg_mag_sqrd_f_probe_avg_mag_sqrd_f_0 =
    R"doc()doc";


static const char* __doc_gr_analog_probe_avg_mag_sqrd_f_probe_avg_mag_sqrd_f_1 =
    R"doc()doc";


static const char* __doc_gr_analog_probe_avg_mag_sqrd_f_make = R"doc(compute avg magnitude squared.

input stream 0: float


Compute a running average of the magnitude squared of the the input. The level and indication as to whether the level exceeds threshold can be retrieved with the level and unmuted accessors.

Constructor Specific Documentation:

Make a float sink that computes avg magnitude squared.

Args:
    threshold_db : Threshold for muting.
    alpha : Gain parameter for the running average filter.)doc";


static const char* __doc_gr_analog_probe_avg_mag_sqrd_f_unmuted = R"doc()doc";


static const char* __doc_gr_analog_probe_avg_mag_sqrd_f_level = R"doc()doc";


static const char* __doc_gr_analog_probe_avg_mag_sqrd_f_threshold = R"doc()doc";


static const char* __doc_gr_analog_probe_avg_mag_sqrd_f_set_alpha = R"doc()doc";


static const char* __doc_gr_analog_probe_avg_mag_sqrd_f_set_threshold = R"doc()doc";


static const char* __doc_gr_analog_probe_avg_mag_sqrd_f_reset = R"doc()doc";
