/*
 * Copyright 2020 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * SPDX-License-Identifier: GPL-3.0-or-later
 *
 */
#include "pydoc_macros.h"
#define D(...) DOC(gr, channels, __VA_ARGS__)
/*
  This file contains placeholders for docstrings for the Python bindings.
  Do not edit! These were automatically extracted during the binding process
  and will be overwritten during the build process
 */


static const char* __doc_gr_channels_dynamic_channel_model = R"doc(dynamic channel simulator

This block implements a dynamic channel model simulator that can be used to help evaluate, design, and test various signals, waveforms, and algorithms.


This model allows the user to set up an AWGN noise source, a random walk process to simulate carrier frequency drift, a random walk process to simulate sample rate offset drive, and a frequency selective fading channel response that is either Rayleigh or Ricean for a user specified power delay profile.

Constructor Specific Documentation:

Build the dynamic channel simulator.

Args:
    samp_rate : Input sample rate in Hz
    sro_std_dev : sample rate drift process standard deviation per sample in Hz
    sro_max_dev : maximum sample rate offset in Hz
    cfo_std_dev : carrier frequnecy drift process standard deviation per sample in Hz
    cfo_max_dev : maximum carrier frequency offset in Hz
    N : number of sinusoids used in frequency selective fading simulation
    doppler_freq : maximum doppler frequency used in fading simulation in Hz
    LOS_model : defines whether the fading model should include a line of site component. LOS->Rician, NLOS->Rayleigh
    K : Rician K-factor, the ratio of specular to diffuse power in the model
    delays : A list of fractional sample delays making up the power delay profile
    mags : A list of magnitudes corresponding to each delay time in the power delay profile
    ntaps_mpath : The length of the filter to interpolate the power delay profile over. Delays in the PDP must lie between 0 and ntaps_mpath, fractional delays will be sinc-interpolated only to the width of this filter.
    noise_amp : Specifies the standard deviation of the AWGN process
    noise_seed : A random number generator seed for the noise source.)doc";


static const char* __doc_gr_channels_dynamic_channel_model_dynamic_channel_model_0 =
    R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_dynamic_channel_model_1 =
    R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_make = R"doc(dynamic channel simulator

This block implements a dynamic channel model simulator that can be used to help evaluate, design, and test various signals, waveforms, and algorithms.


This model allows the user to set up an AWGN noise source, a random walk process to simulate carrier frequency drift, a random walk process to simulate sample rate offset drive, and a frequency selective fading channel response that is either Rayleigh or Ricean for a user specified power delay profile.

Constructor Specific Documentation:

Build the dynamic channel simulator.

Args:
    samp_rate : Input sample rate in Hz
    sro_std_dev : sample rate drift process standard deviation per sample in Hz
    sro_max_dev : maximum sample rate offset in Hz
    cfo_std_dev : carrier frequnecy drift process standard deviation per sample in Hz
    cfo_max_dev : maximum carrier frequency offset in Hz
    N : number of sinusoids used in frequency selective fading simulation
    doppler_freq : maximum doppler frequency used in fading simulation in Hz
    LOS_model : defines whether the fading model should include a line of site component. LOS->Rician, NLOS->Rayleigh
    K : Rician K-factor, the ratio of specular to diffuse power in the model
    delays : A list of fractional sample delays making up the power delay profile
    mags : A list of magnitudes corresponding to each delay time in the power delay profile
    ntaps_mpath : The length of the filter to interpolate the power delay profile over. Delays in the PDP must lie between 0 and ntaps_mpath, fractional delays will be sinc-interpolated only to the width of this filter.
    noise_amp : Specifies the standard deviation of the AWGN process
    noise_seed : A random number generator seed for the noise source.)doc";


static const char* __doc_gr_channels_dynamic_channel_model_samp_rate = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_sro_dev_std = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_sro_dev_max = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_cfo_dev_std = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_cfo_dev_max = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_noise_amp = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_doppler_freq = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_K = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_set_samp_rate = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_set_sro_dev_std = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_set_sro_dev_max = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_set_cfo_dev_std = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_set_cfo_dev_max = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_set_noise_amp = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_set_doppler_freq = R"doc()doc";


static const char* __doc_gr_channels_dynamic_channel_model_set_K = R"doc()doc";
