{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Provides information to interpret colors and pixels in a variety of ways.
-- 
-- They are also known as
-- <https://en.wikipedia.org/wiki/Color_space *color spaces*>.
-- 
-- Crucially, GTK knows how to convert colors from one color
-- state to another.
-- 
-- @GdkColorState@ objects are immutable and therefore threadsafe.
-- 
-- /Since: 4.16/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Structs.ColorState
    ( 

-- * Exported types
    ColorState(..)                          ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [createCicpParams]("GI.Gdk.Structs.ColorState#g:method:createCicpParams"), [equal]("GI.Gdk.Structs.ColorState#g:method:equal"), [equivalent]("GI.Gdk.Structs.ColorState#g:method:equivalent"), [ref]("GI.Gdk.Structs.ColorState#g:method:ref"), [unref]("GI.Gdk.Structs.ColorState#g:method:unref").
-- 
-- ==== Getters
-- /None/.
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveColorStateMethod                 ,
#endif

-- ** createCicpParams #method:createCicpParams#

#if defined(ENABLE_OVERLOADING)
    ColorStateCreateCicpParamsMethodInfo    ,
#endif
    colorStateCreateCicpParams              ,


-- ** equal #method:equal#

#if defined(ENABLE_OVERLOADING)
    ColorStateEqualMethodInfo               ,
#endif
    colorStateEqual                         ,


-- ** equivalent #method:equivalent#

#if defined(ENABLE_OVERLOADING)
    ColorStateEquivalentMethodInfo          ,
#endif
    colorStateEquivalent                    ,


-- ** getOklab #method:getOklab#

    colorStateGetOklab                      ,


-- ** getOklch #method:getOklch#

    colorStateGetOklch                      ,


-- ** getRec2100Linear #method:getRec2100Linear#

    colorStateGetRec2100Linear              ,


-- ** getRec2100Pq #method:getRec2100Pq#

    colorStateGetRec2100Pq                  ,


-- ** getSrgb #method:getSrgb#

    colorStateGetSrgb                       ,


-- ** getSrgbLinear #method:getSrgbLinear#

    colorStateGetSrgbLinear                 ,


-- ** ref #method:ref#

#if defined(ENABLE_OVERLOADING)
    ColorStateRefMethodInfo                 ,
#endif
    colorStateRef                           ,


-- ** unref #method:unref#

#if defined(ENABLE_OVERLOADING)
    ColorStateUnrefMethodInfo               ,
#endif
    colorStateUnref                         ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams

#else
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams

#endif

-- | Memory-managed wrapper type.
newtype ColorState = ColorState (SP.ManagedPtr ColorState)
    deriving (Eq)

instance SP.ManagedPtrNewtype ColorState where
    toManagedPtr (ColorState p) = p

foreign import ccall "gdk_color_state_get_type" c_gdk_color_state_get_type :: 
    IO GType

type instance O.ParentTypes ColorState = '[]
instance O.HasParentTypes ColorState

instance B.Types.TypedObject ColorState where
    glibType = c_gdk_color_state_get_type

instance B.Types.GBoxed ColorState

-- | Convert t'ColorState' to and from 'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe ColorState) where
    gvalueGType_ = c_gdk_color_state_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_boxed gv (FP.nullPtr :: FP.Ptr ColorState)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_boxed gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_boxed gv :: IO (Ptr ColorState)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newBoxed ColorState ptr
        else return P.Nothing
        
    


#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList ColorState
type instance O.AttributeList ColorState = ColorStateAttributeList
type ColorStateAttributeList = ('[ ] :: [(Symbol, DK.Type)])
#endif

-- method ColorState::create_cicp_params
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ColorState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkColorState`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "CicpParams" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_color_state_create_cicp_params" gdk_color_state_create_cicp_params :: 
    Ptr ColorState ->                       -- self : TInterface (Name {namespace = "Gdk", name = "ColorState"})
    IO (Ptr Gdk.CicpParams.CicpParams)

-- | Create a t'GI.Gdk.Objects.CicpParams.CicpParams' representing the colorstate.
-- 
-- It is not guaranteed that every @GdkColorState@ can be
-- represented with Cicp parameters. If that is the case,
-- this function returns @NULL@.
-- 
-- /Since: 4.16/
colorStateCreateCicpParams ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ColorState
    -- ^ /@self@/: a @GdkColorState@
    -> m (Maybe Gdk.CicpParams.CicpParams)
    -- ^ __Returns:__ A new t'GI.Gdk.Objects.CicpParams.CicpParams'
colorStateCreateCicpParams self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    result <- gdk_color_state_create_cicp_params self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (wrapObject Gdk.CicpParams.CicpParams) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data ColorStateCreateCicpParamsMethodInfo
instance (signature ~ (m (Maybe Gdk.CicpParams.CicpParams)), MonadIO m) => O.OverloadedMethod ColorStateCreateCicpParamsMethodInfo ColorState signature where
    overloadedMethod = colorStateCreateCicpParams

instance O.OverloadedMethodInfo ColorStateCreateCicpParamsMethodInfo ColorState where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ColorState.colorStateCreateCicpParams",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ColorState.html#v:colorStateCreateCicpParams"
        })


#endif

-- method ColorState::equal
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ColorState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkColorState`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "other"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ColorState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another `GdkColorStatee`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_color_state_equal" gdk_color_state_equal :: 
    Ptr ColorState ->                       -- self : TInterface (Name {namespace = "Gdk", name = "ColorState"})
    Ptr ColorState ->                       -- other : TInterface (Name {namespace = "Gdk", name = "ColorState"})
    IO CInt

-- | Compares two @GdkColorStates@ for equality.
-- 
-- Note that this function is not guaranteed to be perfect and two objects
-- describing the same color state may compare not equal. However, different
-- color states will never compare equal.
-- 
-- /Since: 4.16/
colorStateEqual ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ColorState
    -- ^ /@self@/: a @GdkColorState@
    -> ColorState
    -- ^ /@other@/: another @GdkColorStatee@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the two color states compare equal
colorStateEqual self other = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    other' <- unsafeManagedPtrGetPtr other
    result <- gdk_color_state_equal self' other'
    let result' = (/= 0) result
    touchManagedPtr self
    touchManagedPtr other
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorStateEqualMethodInfo
instance (signature ~ (ColorState -> m Bool), MonadIO m) => O.OverloadedMethod ColorStateEqualMethodInfo ColorState signature where
    overloadedMethod = colorStateEqual

instance O.OverloadedMethodInfo ColorStateEqualMethodInfo ColorState where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ColorState.colorStateEqual",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ColorState.html#v:colorStateEqual"
        })


#endif

-- method ColorState::equivalent
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ColorState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkColorState`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "other"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ColorState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "another `GdkColorStatee`"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TBoolean)
-- throws : False
-- Skip return : False

foreign import ccall "gdk_color_state_equivalent" gdk_color_state_equivalent :: 
    Ptr ColorState ->                       -- self : TInterface (Name {namespace = "Gdk", name = "ColorState"})
    Ptr ColorState ->                       -- other : TInterface (Name {namespace = "Gdk", name = "ColorState"})
    IO CInt

-- | Compares two @GdkColorStates@ for equivalence.
-- 
-- Two objects that represent the same color state should be equivalent,
-- even though they may not be equal in the sense of 'GI.Gdk.Structs.ColorState.colorStateEqual'.
-- 
-- /Since: 4.20/
colorStateEquivalent ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ColorState
    -- ^ /@self@/: a @GdkColorState@
    -> ColorState
    -- ^ /@other@/: another @GdkColorStatee@
    -> m Bool
    -- ^ __Returns:__ 'P.True' if the two color states are equivalent
colorStateEquivalent self other = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    other' <- unsafeManagedPtrGetPtr other
    result <- gdk_color_state_equivalent self' other'
    let result' = (/= 0) result
    touchManagedPtr self
    touchManagedPtr other
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorStateEquivalentMethodInfo
instance (signature ~ (ColorState -> m Bool), MonadIO m) => O.OverloadedMethod ColorStateEquivalentMethodInfo ColorState signature where
    overloadedMethod = colorStateEquivalent

instance O.OverloadedMethodInfo ColorStateEquivalentMethodInfo ColorState where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ColorState.colorStateEquivalent",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ColorState.html#v:colorStateEquivalent"
        })


#endif

-- method ColorState::ref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ColorState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkColorState`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "ColorState" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_color_state_ref" gdk_color_state_ref :: 
    Ptr ColorState ->                       -- self : TInterface (Name {namespace = "Gdk", name = "ColorState"})
    IO (Ptr ColorState)

-- | Increase the reference count of /@self@/.
-- 
-- /Since: 4.16/
colorStateRef ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ColorState
    -- ^ /@self@/: a @GdkColorState@
    -> m ColorState
    -- ^ __Returns:__ the object that was passed in
colorStateRef self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    result <- gdk_color_state_ref self'
    checkUnexpectedReturnNULL "colorStateRef" result
    result' <- (wrapBoxed ColorState) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data ColorStateRefMethodInfo
instance (signature ~ (m ColorState), MonadIO m) => O.OverloadedMethod ColorStateRefMethodInfo ColorState signature where
    overloadedMethod = colorStateRef

instance O.OverloadedMethodInfo ColorStateRefMethodInfo ColorState where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ColorState.colorStateRef",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ColorState.html#v:colorStateRef"
        })


#endif

-- method ColorState::unref
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "ColorState" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkColorState`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_color_state_unref" gdk_color_state_unref :: 
    Ptr ColorState ->                       -- self : TInterface (Name {namespace = "Gdk", name = "ColorState"})
    IO ()

-- | Decrease the reference count of /@self@/.
-- 
-- Unless /@self@/ is static, it will be freed
-- when the reference count reaches zero.
-- 
-- /Since: 4.16/
colorStateUnref ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    ColorState
    -- ^ /@self@/: a @GdkColorState@
    -> m ()
colorStateUnref self = liftIO $ do
    self' <- unsafeManagedPtrGetPtr self
    gdk_color_state_unref self'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data ColorStateUnrefMethodInfo
instance (signature ~ (m ()), MonadIO m) => O.OverloadedMethod ColorStateUnrefMethodInfo ColorState signature where
    overloadedMethod = colorStateUnref

instance O.OverloadedMethodInfo ColorStateUnrefMethodInfo ColorState where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Structs.ColorState.colorStateUnref",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Structs-ColorState.html#v:colorStateUnref"
        })


#endif

-- method ColorState::get_oklab
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "ColorState" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_color_state_get_oklab" gdk_color_state_get_oklab :: 
    IO (Ptr ColorState)

-- | Returns the color state object representing the oklab color space.
-- 
-- This is a perceptually uniform color state.
-- 
-- /Since: 4.18/
colorStateGetOklab ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ColorState
    -- ^ __Returns:__ the color state object for oklab
colorStateGetOklab  = liftIO $ do
    result <- gdk_color_state_get_oklab
    checkUnexpectedReturnNULL "colorStateGetOklab" result
    result' <- (wrapBoxed ColorState) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ColorState::get_oklch
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "ColorState" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_color_state_get_oklch" gdk_color_state_get_oklch :: 
    IO (Ptr ColorState)

-- | Returns the color state object representing the oklch color space.
-- 
-- This is the polar variant of oklab, in which the hue is encoded as
-- a polar coordinate.
-- 
-- /Since: 4.18/
colorStateGetOklch ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ColorState
    -- ^ __Returns:__ the color state object for oklch
colorStateGetOklch  = liftIO $ do
    result <- gdk_color_state_get_oklch
    checkUnexpectedReturnNULL "colorStateGetOklch" result
    result' <- (wrapBoxed ColorState) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ColorState::get_rec2100_linear
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "ColorState" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_color_state_get_rec2100_linear" gdk_color_state_get_rec2100_linear :: 
    IO (Ptr ColorState)

-- | Returns the color state object representing the linear rec2100 color space.
-- 
-- This color state uses the primaries defined by BT.2020-2 and BT.2100-0 and a linear
-- transfer function.
-- 
-- It is equivalent to the <http://developer.gnome.org/gdk/stable/class.CicpParams.html Cicp> tuple 9\/8\/0\/1.
-- 
-- See e.g. <https://drafts.csswg.org/css-color-hdr/#valdef-color-rec2100-linear the CSS HDR Module>
-- for details about this colorstate.
-- 
-- /Since: 4.16/
colorStateGetRec2100Linear ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ColorState
    -- ^ __Returns:__ the color state object for linearized rec2100
colorStateGetRec2100Linear  = liftIO $ do
    result <- gdk_color_state_get_rec2100_linear
    checkUnexpectedReturnNULL "colorStateGetRec2100Linear" result
    result' <- (wrapBoxed ColorState) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ColorState::get_rec2100_pq
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "ColorState" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_color_state_get_rec2100_pq" gdk_color_state_get_rec2100_pq :: 
    IO (Ptr ColorState)

-- | Returns the color state object representing the rec2100-pq color space.
-- 
-- This color state uses the primaries defined by BT.2020-2 and BT.2100-0 and the transfer
-- function defined by SMPTE ST 2084 and BT.2100-2.
-- 
-- It is equivalent to the <http://developer.gnome.org/gdk/stable/class.CicpParams.html Cicp> tuple 9\/16\/0\/1.
-- 
-- See e.g. <https://drafts.csswg.org/css-color-hdr/#valdef-color-rec2100-pq the CSS HDR Module>
-- for details about this colorstate.
-- 
-- /Since: 4.16/
colorStateGetRec2100Pq ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ColorState
    -- ^ __Returns:__ the color state object for rec2100-pq
colorStateGetRec2100Pq  = liftIO $ do
    result <- gdk_color_state_get_rec2100_pq
    checkUnexpectedReturnNULL "colorStateGetRec2100Pq" result
    result' <- (wrapBoxed ColorState) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ColorState::get_srgb
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "ColorState" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_color_state_get_srgb" gdk_color_state_get_srgb :: 
    IO (Ptr ColorState)

-- | Returns the color state object representing the sRGB color space.
-- 
-- This color state uses the primaries defined by BT.709-6 and the transfer function
-- defined by IEC 61966-2-1.
-- 
-- It is equivalent to the <http://developer.gnome.org/gdk/stable/class.CicpParams.html Cicp> tuple 1\/13\/0\/1.
-- 
-- See e.g. <https://www.w3.org/TR/css-color-4/#predefined-sRGB the CSS Color Module>
-- for details about this colorstate.
-- 
-- /Since: 4.16/
colorStateGetSrgb ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ColorState
    -- ^ __Returns:__ the color state object for sRGB
colorStateGetSrgb  = liftIO $ do
    result <- gdk_color_state_get_srgb
    checkUnexpectedReturnNULL "colorStateGetSrgb" result
    result' <- (wrapBoxed ColorState) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method ColorState::get_srgb_linear
-- method type : MemberFunction
-- Args: []
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "ColorState" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_color_state_get_srgb_linear" gdk_color_state_get_srgb_linear :: 
    IO (Ptr ColorState)

-- | Returns the color state object representing the linearized sRGB color space.
-- 
-- This color state uses the primaries defined by BT.709-6 and a linear transfer function.
-- 
-- It is equivalent to the <http://developer.gnome.org/gdk/stable/class.CicpParams.html Cicp> tuple 1\/8\/0\/1.
-- 
-- See e.g. <https://www.w3.org/TR/css-color-4/#predefined-sRGB-linear the CSS Color Module>
-- for details about this colorstate.
-- 
-- /Since: 4.16/
colorStateGetSrgbLinear ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    m ColorState
    -- ^ __Returns:__ the color state object for linearized sRGB
colorStateGetSrgbLinear  = liftIO $ do
    result <- gdk_color_state_get_srgb_linear
    checkUnexpectedReturnNULL "colorStateGetSrgbLinear" result
    result' <- (wrapBoxed ColorState) result
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveColorStateMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveColorStateMethod "createCicpParams" o = ColorStateCreateCicpParamsMethodInfo
    ResolveColorStateMethod "equal" o = ColorStateEqualMethodInfo
    ResolveColorStateMethod "equivalent" o = ColorStateEquivalentMethodInfo
    ResolveColorStateMethod "ref" o = ColorStateRefMethodInfo
    ResolveColorStateMethod "unref" o = ColorStateUnrefMethodInfo
    ResolveColorStateMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveColorStateMethod t ColorState, O.OverloadedMethod info ColorState p) => OL.IsLabel t (ColorState -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveColorStateMethod t ColorState, O.OverloadedMethod info ColorState p, R.HasField t ColorState p) => R.HasField t ColorState p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveColorStateMethod t ColorState, O.OverloadedMethodInfo info ColorState) => OL.IsLabel t (O.MethodProxy info ColorState) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


