{-# LANGUAGE OverloadedStrings #-}
-- | Build time configuration used during code generation.
module GI.Gdk.Config ( overrides, modules ) where

import qualified Data.Text as T
import Data.Text (Text)

-- | Overrides used when generating these bindings.
overrides :: Text
overrides = T.unlines
 [ "namespace Gdk"
 , ""
 , "# In most APIs these are used as guint, but they are declared as gint."
 , "# See https://github.com/haskell-gi/haskell-gi/issues/58"
 , "set-attr Gdk/~KEY_.*@constant/@type name guint"
 , ""
 , "# Generated from gdk 3.20.3 with xsltproc Nullable.xslt Gdk-3.0.gir"
 , "set-attr Gdk/AppLaunchContext/set_icon/@parameters/icon nullable 1"
 , "set-attr Gdk/AppLaunchContext/set_icon_name/@parameters/icon_name nullable 1"
 , "set-attr Gdk/Cursor/new_for_display/@return-value nullable 1"
 , "set-attr Gdk/Cursor/new_from_name/@return-value nullable 1"
 , "set-attr Gdk/Cursor/get_image/@return-value nullable 1"
 , "set-attr Gdk/Cursor/get_surface/@return-value nullable 1"
 , "set-attr Gdk/Device/get_associated_device/@return-value nullable 1"
 , "set-attr Gdk/Device/get_last_event_window/@return-value nullable 1"
 , "set-attr Gdk/Device/get_product_id/@return-value nullable 1"
 , "set-attr Gdk/Device/get_state/@parameters/axes nullable 1"
 , "set-attr Gdk/Device/get_vendor_id/@return-value nullable 1"
 , "set-attr Gdk/Device/get_window_at_position/@return-value nullable 1"
 , "set-attr Gdk/Device/get_window_at_position_double/@return-value nullable 1"
 , "set-attr Gdk/Device/grab/@parameters/cursor nullable 1"
 , "set-attr Gdk/Device/list_slave_devices/@return-value nullable 1"
 , "set-attr Gdk/DeviceManager/get_display/@return-value nullable 1"
 , "set-attr Gdk/Display/get_default/@return-value nullable 1"
 , "set-attr Gdk/Display/open/@return-value nullable 1"
 , "set-attr Gdk/Display/open_default_libgtk_only/@return-value nullable 1"
 , "set-attr Gdk/Display/get_device_manager/@return-value nullable 1"
 , "set-attr Gdk/Display/get_event/@return-value nullable 1"
 , "set-attr Gdk/Display/get_monitor/@return-value nullable 1"
 , "set-attr Gdk/Display/get_primary_monitor/@return-value nullable 1"
 , "set-attr Gdk/Display/get_window_at_pointer/@return-value nullable 1"
 , "set-attr Gdk/Display/peek_event/@return-value nullable 1"
 , "set-attr Gdk/Display/store_clipboard/@parameters/targets nullable 1"
 , "set-attr Gdk/DisplayManager/get_default_display/@return-value nullable 1"
 , "set-attr Gdk/DisplayManager/open_display/@return-value nullable 1"
 , "set-attr Gdk/DragContext/get_drag_window/@return-value nullable 1"
 , "set-attr Gdk/DrawingContext/get_clip/@return-value nullable 1"
 , "set-attr Gdk/Event/get_device/@return-value nullable 1"
 , "set-attr Gdk/Event/get_source_device/@return-value nullable 1"
 , "set-attr Gdk/Event/get_state/@parameters/event nullable 1"
 , "set-attr Gdk/Event/set_device_tool/@parameters/tool nullable 1"
 , "set-attr Gdk/Event/get/@return-value nullable 1"
 , "set-attr Gdk/Event/handler_set/@parameters/data nullable 1"
 , "set-attr Gdk/Event/peek/@return-value nullable 1"
 , "set-attr Gdk/EventFunc/@parameters/data nullable 1"
 , "set-attr Gdk/FilterFunc/@parameters/data nullable 1"
 , "set-attr Gdk/FrameClock/get_current_timings/@return-value nullable 1"
 , "set-attr Gdk/FrameClock/get_timings/@return-value nullable 1"
 , "set-attr Gdk/GLContext/get_current/@return-value nullable 1"
 , "set-attr Gdk/GLContext/get_display/@return-value nullable 1"
 , "set-attr Gdk/GLContext/get_required_version/@parameters/major nullable 1"
 , "set-attr Gdk/GLContext/get_required_version/@parameters/minor nullable 1"
 , "set-attr Gdk/GLContext/get_shared_context/@return-value nullable 1"
 , "set-attr Gdk/GLContext/get_window/@return-value nullable 1"
 , "set-attr Gdk/Monitor/get_manufacturer/@return-value nullable 1"
 , "set-attr Gdk/Monitor/get_model/@return-value nullable 1"
 , "set-attr Gdk/Screen/get_default/@return-value nullable 1"
 , "set-attr Gdk/Screen/get_active_window/@return-value nullable 1"
 , "set-attr Gdk/Screen/get_font_options/@return-value nullable 1"
 , "set-attr Gdk/Screen/get_monitor_plug_name/@return-value nullable 1"
 , "set-attr Gdk/Screen/get_rgba_visual/@return-value nullable 1"
 , "set-attr Gdk/Screen/get_window_stack/@return-value nullable 1"
 , "set-attr Gdk/Screen/set_font_options/@parameters/options nullable 1"
 , "set-attr Gdk/Seat/get_keyboard/@return-value nullable 1"
 , "set-attr Gdk/Seat/get_pointer/@return-value nullable 1"
 , "set-attr Gdk/Seat/grab/@parameters/cursor nullable 1"
 , "set-attr Gdk/Seat/grab/@parameters/event nullable 1"
 , "set-attr Gdk/Seat/grab/@parameters/prepare_func nullable 1"
 , "set-attr Gdk/Seat/grab/@parameters/prepare_func_data nullable 1"
 , "set-attr Gdk/SeatGrabPrepareFunc/@parameters/user_data nullable 1"
 , "set-attr Gdk/Visual/get_best_with_both/@return-value nullable 1"
 , "set-attr Gdk/Window/new/@parameters/parent nullable 1"
 , "set-attr Gdk/Window/add_filter/@parameters/window nullable 1"
 , "set-attr Gdk/Window/add_filter/@parameters/data nullable 1"
 , "set-attr Gdk/Window/create_similar_image_surface/@parameters/window nullable 1"
 , "set-attr Gdk/Window/get_background_pattern/@return-value nullable 1"
 , "set-attr Gdk/Window/get_children_with_user_data/@parameters/user_data nullable 1"
 , "set-attr Gdk/Window/get_cursor/@return-value nullable 1"
 , "set-attr Gdk/Window/get_device_cursor/@return-value nullable 1"
 , "set-attr Gdk/Window/get_device_position/@return-value nullable 1"
 , "set-attr Gdk/Window/get_device_position_double/@return-value nullable 1"
 , "set-attr Gdk/Window/get_pointer/@return-value nullable 1"
 , "set-attr Gdk/Window/get_user_data/@parameters/data nullable 1"
 , "set-attr Gdk/Window/invalidate_maybe_recurse/@parameters/child_func nullable 1"
 , "set-attr Gdk/Window/invalidate_maybe_recurse/@parameters/user_data nullable 1"
 , "set-attr Gdk/Window/invalidate_rect/@parameters/rect nullable 1"
 , "set-attr Gdk/Window/remove_filter/@parameters/data nullable 1"
 , "set-attr Gdk/Window/restack/@parameters/sibling nullable 1"
 , "set-attr Gdk/Window/set_background_pattern/@parameters/pattern nullable 1"
 , "set-attr Gdk/Window/set_cursor/@parameters/cursor nullable 1"
 , "set-attr Gdk/Window/set_group/@parameters/leader nullable 1"
 , "set-attr Gdk/Window/set_icon_name/@parameters/name nullable 1"
 , "set-attr Gdk/Window/set_opaque_region/@parameters/region nullable 1"
 , "set-attr Gdk/Window/set_user_data/@parameters/user_data nullable 1"
 , "set-attr Gdk/Window/shape_combine_region/@parameters/shape_region nullable 1"
 , "set-attr Gdk/Window/moved-to-rect/@parameters/flipped_rect nullable 1"
 , "set-attr Gdk/Window/moved-to-rect/@parameters/final_rect nullable 1"
 , "set-attr Gdk/Window/pick-embedded-child/@return-value nullable 1"
 , "set-attr Gdk/WindowChildFunc/@parameters/user_data nullable 1"
 , "set-attr Gdk/cairo_get_drawing_context/@return-value nullable 1"
 , "set-attr Gdk/cairo_surface_create_from_pixbuf/@parameters/for_window nullable 1"
 , "set-attr Gdk/event_get/@return-value nullable 1"
 , "set-attr Gdk/event_handler_set/@parameters/data nullable 1"
 , "set-attr Gdk/event_peek/@return-value nullable 1"
 , "set-attr Gdk/get_display_arg_name/@return-value nullable 1"
 , "set-attr Gdk/keyval_name/@return-value nullable 1"
 , "set-attr Gdk/offscreen_window_get_embedder/@return-value nullable 1"
 , "set-attr Gdk/offscreen_window_get_surface/@return-value nullable 1"
 , "set-attr Gdk/pixbuf_get_from_surface/@return-value nullable 1"
 , "set-attr Gdk/pixbuf_get_from_window/@return-value nullable 1"
 , "set-attr Gdk/pointer_grab/@parameters/confine_to nullable 1"
 , "set-attr Gdk/pointer_grab/@parameters/cursor nullable 1"
 , "set-attr Gdk/selection_owner_get/@return-value nullable 1"
 , "set-attr Gdk/selection_owner_get_for_display/@return-value nullable 1"
 , "set-attr Gdk/selection_owner_set/@parameters/owner nullable 1"
 , "set-attr Gdk/selection_owner_set_for_display/@parameters/owner nullable 1"
 , "set-attr Gdk/threads_add_idle/@parameters/data nullable 1"
 , "set-attr Gdk/threads_add_idle_full/@parameters/data nullable 1"
 , "set-attr Gdk/threads_add_idle_full/@parameters/notify nullable 1"
 , "set-attr Gdk/threads_add_timeout/@parameters/data nullable 1"
 , "set-attr Gdk/threads_add_timeout_full/@parameters/data nullable 1"
 , "set-attr Gdk/threads_add_timeout_full/@parameters/notify nullable 1"
 , "set-attr Gdk/threads_add_timeout_seconds/@parameters/data nullable 1"
 , "set-attr Gdk/threads_add_timeout_seconds_full/@parameters/data nullable 1"
 , "set-attr Gdk/threads_add_timeout_seconds_full/@parameters/notify nullable 1"
 , "set-attr Gdk/utf8_to_string_target/@return-value nullable 1"
 , ""
 , "set-attr cairo/FontOptions glib:get-type cairo_gobject_font_options_get_type"
 , ""]

-- | Modules in this package
modules :: [Text]
modules =  [ "GI.Gdk.Config"
 , "GI.Gdk"
 , "GI.Gdk.Callbacks"
 , "GI.Gdk.Constants"
 , "GI.Gdk.Enums"
 , "GI.Gdk.Flags"
 , "GI.Gdk.Functions"
 , "GI.Gdk.Interfaces"
 , "GI.Gdk.Interfaces.DevicePad"
 , "GI.Gdk.Objects"
 , "GI.Gdk.Objects.AppLaunchContext"
 , "GI.Gdk.Objects.Cursor"
 , "GI.Gdk.Objects.Device"
 , "GI.Gdk.Objects.DeviceManager"
 , "GI.Gdk.Objects.DeviceTool"
 , "GI.Gdk.Objects.Display"
 , "GI.Gdk.Objects.DisplayManager"
 , "GI.Gdk.Objects.DragContext"
 , "GI.Gdk.Objects.DrawingContext"
 , "GI.Gdk.Objects.FrameClock"
 , "GI.Gdk.Objects.GLContext"
 , "GI.Gdk.Objects.Keymap"
 , "GI.Gdk.Objects.Monitor"
 , "GI.Gdk.Objects.Screen"
 , "GI.Gdk.Objects.Seat"
 , "GI.Gdk.Objects.Visual"
 , "GI.Gdk.Objects.Window"
 , "GI.Gdk.Structs"
 , "GI.Gdk.Structs.Atom"
 , "GI.Gdk.Structs.Color"
 , "GI.Gdk.Structs.EventAny"
 , "GI.Gdk.Structs.EventButton"
 , "GI.Gdk.Structs.EventConfigure"
 , "GI.Gdk.Structs.EventCrossing"
 , "GI.Gdk.Structs.EventDND"
 , "GI.Gdk.Structs.EventExpose"
 , "GI.Gdk.Structs.EventFocus"
 , "GI.Gdk.Structs.EventGrabBroken"
 , "GI.Gdk.Structs.EventKey"
 , "GI.Gdk.Structs.EventMotion"
 , "GI.Gdk.Structs.EventOwnerChange"
 , "GI.Gdk.Structs.EventPadAxis"
 , "GI.Gdk.Structs.EventPadButton"
 , "GI.Gdk.Structs.EventPadGroupMode"
 , "GI.Gdk.Structs.EventProperty"
 , "GI.Gdk.Structs.EventProximity"
 , "GI.Gdk.Structs.EventScroll"
 , "GI.Gdk.Structs.EventSelection"
 , "GI.Gdk.Structs.EventSequence"
 , "GI.Gdk.Structs.EventSetting"
 , "GI.Gdk.Structs.EventTouch"
 , "GI.Gdk.Structs.EventTouchpadPinch"
 , "GI.Gdk.Structs.EventTouchpadSwipe"
 , "GI.Gdk.Structs.EventVisibility"
 , "GI.Gdk.Structs.EventWindowState"
 , "GI.Gdk.Structs.FrameTimings"
 , "GI.Gdk.Structs.Geometry"
 , "GI.Gdk.Structs.KeymapKey"
 , "GI.Gdk.Structs.Point"
 , "GI.Gdk.Structs.RGBA"
 , "GI.Gdk.Structs.Rectangle"
 , "GI.Gdk.Structs.TimeCoord"
 , "GI.Gdk.Structs.WindowAttr"
 , "GI.Gdk.Structs.WindowRedirect"
 , "GI.Gdk.Unions"
 , "GI.Gdk.Unions.Event"]
