{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Data type to hold math kerning (cut-in) information for a glyph.
-- 
-- /Since: 3.4.0/

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Structs.OtMathKernEntryT
    ( 

-- * Exported types
    OtMathKernEntryT(..)                    ,
    newZeroOtMathKernEntryT                 ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveOtMathKernEntryTMethod           ,
#endif



 -- * Properties


-- ** kernValue #attr:kernValue#
-- | The kern value of the entry

    getOtMathKernEntryTKernValue            ,
#if defined(ENABLE_OVERLOADING)
    otMathKernEntryT_kernValue              ,
#endif
    setOtMathKernEntryTKernValue            ,


-- ** maxCorrectionHeight #attr:maxCorrectionHeight#
-- | The maximum height at which this entry should be used

    getOtMathKernEntryTMaxCorrectionHeight  ,
#if defined(ENABLE_OVERLOADING)
    otMathKernEntryT_maxCorrectionHeight    ,
#endif
    setOtMathKernEntryTMaxCorrectionHeight  ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype OtMathKernEntryT = OtMathKernEntryT (SP.ManagedPtr OtMathKernEntryT)
    deriving (Eq)

instance SP.ManagedPtrNewtype OtMathKernEntryT where
    toManagedPtr (OtMathKernEntryT p) = p

instance BoxedPtr OtMathKernEntryT where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 8 >=> B.ManagedPtr.wrapPtr OtMathKernEntryT)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr OtMathKernEntryT where
    boxedPtrCalloc = callocBytes 8


-- | Construct a t'OtMathKernEntryT' struct initialized to zero.
newZeroOtMathKernEntryT :: MonadIO m => m OtMathKernEntryT
newZeroOtMathKernEntryT = liftIO $ boxedPtrCalloc >>= wrapPtr OtMathKernEntryT

instance tag ~ 'AttrSet => Constructible OtMathKernEntryT tag where
    new _ attrs = do
        o <- newZeroOtMathKernEntryT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@max_correction_height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otMathKernEntryT #maxCorrectionHeight
-- @
getOtMathKernEntryTMaxCorrectionHeight :: MonadIO m => OtMathKernEntryT -> m Int32
getOtMathKernEntryTMaxCorrectionHeight s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@max_correction_height@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otMathKernEntryT [ #maxCorrectionHeight 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtMathKernEntryTMaxCorrectionHeight :: MonadIO m => OtMathKernEntryT -> Int32 -> m ()
setOtMathKernEntryTMaxCorrectionHeight s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data OtMathKernEntryTMaxCorrectionHeightFieldInfo
instance AttrInfo OtMathKernEntryTMaxCorrectionHeightFieldInfo where
    type AttrBaseTypeConstraint OtMathKernEntryTMaxCorrectionHeightFieldInfo = (~) OtMathKernEntryT
    type AttrAllowedOps OtMathKernEntryTMaxCorrectionHeightFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtMathKernEntryTMaxCorrectionHeightFieldInfo = (~) Int32
    type AttrTransferTypeConstraint OtMathKernEntryTMaxCorrectionHeightFieldInfo = (~)Int32
    type AttrTransferType OtMathKernEntryTMaxCorrectionHeightFieldInfo = Int32
    type AttrGetType OtMathKernEntryTMaxCorrectionHeightFieldInfo = Int32
    type AttrLabel OtMathKernEntryTMaxCorrectionHeightFieldInfo = "max_correction_height"
    type AttrOrigin OtMathKernEntryTMaxCorrectionHeightFieldInfo = OtMathKernEntryT
    attrGet = getOtMathKernEntryTMaxCorrectionHeight
    attrSet = setOtMathKernEntryTMaxCorrectionHeight
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtMathKernEntryT.maxCorrectionHeight"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtMathKernEntryT.html#g:attr:maxCorrectionHeight"
        })

otMathKernEntryT_maxCorrectionHeight :: AttrLabelProxy "maxCorrectionHeight"
otMathKernEntryT_maxCorrectionHeight = AttrLabelProxy

#endif


-- | Get the value of the “@kern_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' otMathKernEntryT #kernValue
-- @
getOtMathKernEntryTKernValue :: MonadIO m => OtMathKernEntryT -> m Int32
getOtMathKernEntryTKernValue s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 4) :: IO Int32
    return val

-- | Set the value of the “@kern_value@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' otMathKernEntryT [ #kernValue 'Data.GI.Base.Attributes.:=' value ]
-- @
setOtMathKernEntryTKernValue :: MonadIO m => OtMathKernEntryT -> Int32 -> m ()
setOtMathKernEntryTKernValue s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 4) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data OtMathKernEntryTKernValueFieldInfo
instance AttrInfo OtMathKernEntryTKernValueFieldInfo where
    type AttrBaseTypeConstraint OtMathKernEntryTKernValueFieldInfo = (~) OtMathKernEntryT
    type AttrAllowedOps OtMathKernEntryTKernValueFieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint OtMathKernEntryTKernValueFieldInfo = (~) Int32
    type AttrTransferTypeConstraint OtMathKernEntryTKernValueFieldInfo = (~)Int32
    type AttrTransferType OtMathKernEntryTKernValueFieldInfo = Int32
    type AttrGetType OtMathKernEntryTKernValueFieldInfo = Int32
    type AttrLabel OtMathKernEntryTKernValueFieldInfo = "kern_value"
    type AttrOrigin OtMathKernEntryTKernValueFieldInfo = OtMathKernEntryT
    attrGet = getOtMathKernEntryTKernValue
    attrSet = setOtMathKernEntryTKernValue
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Structs.OtMathKernEntryT.kernValue"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Structs-OtMathKernEntryT.html#g:attr:kernValue"
        })

otMathKernEntryT_kernValue :: AttrLabelProxy "kernValue"
otMathKernEntryT_kernValue = AttrLabelProxy

#endif



#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList OtMathKernEntryT
type instance O.AttributeList OtMathKernEntryT = OtMathKernEntryTAttributeList
type OtMathKernEntryTAttributeList = ('[ '("maxCorrectionHeight", OtMathKernEntryTMaxCorrectionHeightFieldInfo), '("kernValue", OtMathKernEntryTKernValueFieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveOtMathKernEntryTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveOtMathKernEntryTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveOtMathKernEntryTMethod t OtMathKernEntryT, O.OverloadedMethod info OtMathKernEntryT p) => OL.IsLabel t (OtMathKernEntryT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveOtMathKernEntryTMethod t OtMathKernEntryT, O.OverloadedMethod info OtMathKernEntryT p, R.HasField t OtMathKernEntryT p) => R.HasField t OtMathKernEntryT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveOtMathKernEntryTMethod t OtMathKernEntryT, O.OverloadedMethodInfo info OtMathKernEntryT) => OL.IsLabel t (O.MethodProxy info OtMathKernEntryT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


