{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- /No description available in the introspection data./

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.HarfBuzz.Unions.VarIntT
    ( 

-- * Exported types
    VarIntT(..)                             ,
    newZeroVarIntT                          ,


 -- * Methods

#if defined(ENABLE_OVERLOADING)
    ResolveVarIntTMethod                    ,
#endif



 -- * Properties


-- ** i32 #attr:i32#
-- | /No description available in the introspection data./

    getVarIntTI32                           ,
    setVarIntTI32                           ,
#if defined(ENABLE_OVERLOADING)
    varIntT_i32                             ,
#endif


-- ** u32 #attr:u32#
-- | /No description available in the introspection data./

    getVarIntTU32                           ,
    setVarIntTU32                           ,
#if defined(ENABLE_OVERLOADING)
    varIntT_u32                             ,
#endif




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)

#else

#endif

-- | Memory-managed wrapper type.
newtype VarIntT = VarIntT (SP.ManagedPtr VarIntT)
    deriving (Eq)

instance SP.ManagedPtrNewtype VarIntT where
    toManagedPtr (VarIntT p) = p

instance BoxedPtr VarIntT where
    boxedPtrCopy = \p -> B.ManagedPtr.withManagedPtr p (copyBytes 4 >=> B.ManagedPtr.wrapPtr VarIntT)
    boxedPtrFree = \x -> SP.withManagedPtr x SP.freeMem
instance CallocPtr VarIntT where
    boxedPtrCalloc = callocBytes 4


-- | Construct a t'VarIntT' struct initialized to zero.
newZeroVarIntT :: MonadIO m => m VarIntT
newZeroVarIntT = liftIO $ boxedPtrCalloc >>= wrapPtr VarIntT

instance tag ~ 'AttrSet => Constructible VarIntT tag where
    new _ attrs = do
        o <- newZeroVarIntT
        GI.Attributes.set o attrs
        return o


-- | Get the value of the “@u32@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' varIntT #u32
-- @
getVarIntTU32 :: MonadIO m => VarIntT -> m Word32
getVarIntTU32 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Word32
    return val

-- | Set the value of the “@u32@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' varIntT [ #u32 'Data.GI.Base.Attributes.:=' value ]
-- @
setVarIntTU32 :: MonadIO m => VarIntT -> Word32 -> m ()
setVarIntTU32 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Word32)

#if defined(ENABLE_OVERLOADING)
data VarIntTU32FieldInfo
instance AttrInfo VarIntTU32FieldInfo where
    type AttrBaseTypeConstraint VarIntTU32FieldInfo = (~) VarIntT
    type AttrAllowedOps VarIntTU32FieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint VarIntTU32FieldInfo = (~) Word32
    type AttrTransferTypeConstraint VarIntTU32FieldInfo = (~)Word32
    type AttrTransferType VarIntTU32FieldInfo = Word32
    type AttrGetType VarIntTU32FieldInfo = Word32
    type AttrLabel VarIntTU32FieldInfo = "u32"
    type AttrOrigin VarIntTU32FieldInfo = VarIntT
    attrGet = getVarIntTU32
    attrSet = setVarIntTU32
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Unions.VarIntT.u32"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Unions-VarIntT.html#g:attr:u32"
        })

varIntT_u32 :: AttrLabelProxy "u32"
varIntT_u32 = AttrLabelProxy

#endif


-- | Get the value of the “@i32@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' varIntT #i32
-- @
getVarIntTI32 :: MonadIO m => VarIntT -> m Int32
getVarIntTI32 s = liftIO $ withManagedPtr s $ \ptr -> do
    val <- peek (ptr `plusPtr` 0) :: IO Int32
    return val

-- | Set the value of the “@i32@” field.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.set' varIntT [ #i32 'Data.GI.Base.Attributes.:=' value ]
-- @
setVarIntTI32 :: MonadIO m => VarIntT -> Int32 -> m ()
setVarIntTI32 s val = liftIO $ withManagedPtr s $ \ptr -> do
    poke (ptr `plusPtr` 0) (val :: Int32)

#if defined(ENABLE_OVERLOADING)
data VarIntTI32FieldInfo
instance AttrInfo VarIntTI32FieldInfo where
    type AttrBaseTypeConstraint VarIntTI32FieldInfo = (~) VarIntT
    type AttrAllowedOps VarIntTI32FieldInfo = '[ 'AttrSet, 'AttrGet]
    type AttrSetTypeConstraint VarIntTI32FieldInfo = (~) Int32
    type AttrTransferTypeConstraint VarIntTI32FieldInfo = (~)Int32
    type AttrTransferType VarIntTI32FieldInfo = Int32
    type AttrGetType VarIntTI32FieldInfo = Int32
    type AttrLabel VarIntTI32FieldInfo = "i32"
    type AttrOrigin VarIntTI32FieldInfo = VarIntT
    attrGet = getVarIntTI32
    attrSet = setVarIntTI32
    attrConstruct = undefined
    attrClear = undefined
    attrTransfer _ v = do
        return v
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.HarfBuzz.Unions.VarIntT.i32"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-harfbuzz-0.0.10/docs/GI-HarfBuzz-Unions-VarIntT.html#g:attr:i32"
        })

varIntT_i32 :: AttrLabelProxy "i32"
varIntT_i32 = AttrLabelProxy

#endif


-- XXX Skipped attribute for "VarIntT:u16"
-- Not implemented: Don't know how to unpack C array of type TCArray False 2 (-1) (TBasicType TUInt16)
-- XXX Skipped attribute for "VarIntT:i16"
-- Not implemented: Don't know how to unpack C array of type TCArray False 2 (-1) (TBasicType TInt16)
-- XXX Skipped attribute for "VarIntT:u8"
-- Not implemented: Don't know how to unpack C array of type TCArray False 4 (-1) (TBasicType TUInt8)
-- XXX Skipped attribute for "VarIntT:i8"
-- Not implemented: Don't know how to unpack C array of type TCArray False 4 (-1) (TBasicType TInt8)

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList VarIntT
type instance O.AttributeList VarIntT = VarIntTAttributeList
type VarIntTAttributeList = ('[ '("u32", VarIntTU32FieldInfo), '("i32", VarIntTI32FieldInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
type family ResolveVarIntTMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveVarIntTMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveVarIntTMethod t VarIntT, O.OverloadedMethod info VarIntT p) => OL.IsLabel t (VarIntT -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveVarIntTMethod t VarIntT, O.OverloadedMethod info VarIntT p, R.HasField t VarIntT p) => R.HasField t VarIntT p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveVarIntTMethod t VarIntT, O.OverloadedMethodInfo info VarIntT) => OL.IsLabel t (O.MethodProxy info VarIntT) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif


