/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha3

import (
	v1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// DeviceTaintRuleStatusApplyConfiguration represents a declarative configuration of the DeviceTaintRuleStatus type for use
// with apply.
//
// DeviceTaintRuleStatus provides information about an on-going pod eviction.
type DeviceTaintRuleStatusApplyConfiguration struct {
	// Conditions provide information about the state of the DeviceTaintRule
	// and the cluster at some point in time,
	// in a machine-readable and human-readable format.
	//
	// The following condition is currently defined as part of this API, more may
	// get added:
	// - Type: EvictionInProgress
	// - Status: True if there are currently pods which need to be evicted, False otherwise
	// (includes the effects which don't cause eviction).
	// - Reason: not specified, may change
	// - Message: includes information about number of pending pods and already evicted pods
	// in a human-readable format, updated periodically, may change
	//
	// For `effect: None`, the condition above gets set once for each change to
	// the spec, with the message containing information about what would happen
	// if the effect was `NoExecute`. This feedback can be used to decide whether
	// changing the effect to `NoExecute` will work as intended. It only gets
	// set once to avoid having to constantly update the status.
	//
	// Must have 8 or fewer entries.
	Conditions []v1.ConditionApplyConfiguration `json:"conditions,omitempty"`
}

// DeviceTaintRuleStatusApplyConfiguration constructs a declarative configuration of the DeviceTaintRuleStatus type for use with
// apply.
func DeviceTaintRuleStatus() *DeviceTaintRuleStatusApplyConfiguration {
	return &DeviceTaintRuleStatusApplyConfiguration{}
}

// WithConditions adds the given value to the Conditions field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Conditions field.
func (b *DeviceTaintRuleStatusApplyConfiguration) WithConditions(values ...*v1.ConditionApplyConfiguration) *DeviceTaintRuleStatusApplyConfiguration {
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithConditions")
		}
		b.Conditions = append(b.Conditions, *values[i])
	}
	return b
}
