#ifndef __HQ4x_INCLUDE_H__
#define __HQ4x_INCLUDE_H__
static const GLchar Yglprg_blit_hq4x_v[] =
"#version 310 es \n"
" layout (location = 0) in vec2 VertexCoord; \n"
" layout (location = 1) in vec2 TexCoord; \n"
" uniform vec2 DrawingSize;\n"
" out vec4 vTexCoord[4];\n"
" void main()\n"
" {\n"
" 	gl_Position = vec4(VertexCoord, 0.0, 1.0);\n"
" 	vec2 ps = 1.0/DrawingSize;\n"
"  	float dx = ps.x;\n"
" 	float dy = ps.y;\n"
"                                 \n"
" 	//   +----+----+----+\n"
" 	//   |    |    |    |\n"
" 	//   | w1 | w2 | w3 |\n"
" 	//   +----+----+----+\n"
" 	//   |    |    |    |\n"
" 	//   | w4 | w5 | w6 |\n"
" 	//   +----+----+----+\n"
" 	//   |    |    |    |\n"
" 	//   | w7 | w8 | w9 |\n"
" 	//   +----+----+----+\n"
"                                 \n"
" 	vTexCoord[0].zw = ps;\n"
" 	vTexCoord[0].xy = TexCoord.xy;\n"
" 	vTexCoord[1] = TexCoord.xxxy + vec4(-dx, 0, dx, -dy); //  w1 | w2 | w3\n"
" 	vTexCoord[2] = TexCoord.xxxy + vec4(-dx, 0, dx,   0); //  w4 | w5 | w6\n"
" 	vTexCoord[3] = TexCoord.xxxy + vec4(-dx, 0, dx,  dy); //  w7 | w8 | w9\n"
" }\n";

static const GLchar Yglprg_blit_hq4x_f[] =
"#version 310 es \n"
"#ifdef GL_ES\n"
"#ifdef GL_FRAGMENT_PRECISION_HIGH\n"
"precision highp float;\n"
"#else\n"
"precision mediump float;\n"
"#endif\n"
"#endif\n"
"#define SCALE 4.0\n" 
"\n"
"uniform sampler2D Texture;\n"
"uniform sampler2D LUT;\n"
"uniform vec2 DrawingSize;\n"
"in vec4 vTexCoord[4];\n"
"out vec4 fragColor;\n"
"const mat3 yuv_matrix = mat3(0.299, 0.587, 0.114, -0.169, -0.331, 0.5, 0.5, -0.419, -0.081);\n"
"const vec3 yuv_threshold = vec3(48.0/255.0, 7.0/255.0, 6.0/255.0);\n"
"const vec3 yuv_offset = vec3(0, 0.5, 0.5);\n"
"\n"
"bool diff(vec3 yuv1, vec3 yuv2)\n"
"{\n"
"	bvec3 res = greaterThan(abs((yuv1 + yuv_offset) - (yuv2 + yuv_offset)), yuv_threshold);\n"
"	return res.x || res.y || res.z;\n"
"}\n"
"\n"
"void main()\n"
"{\n"
"	vec2 fp = fract(vTexCoord[0].xy*DrawingSize);\n"
"	vec2 quad = sign(-0.5 + fp);\n"
"	mat3 yuv = transpose(yuv_matrix);\n"
"\n"
"	float dx = vTexCoord[0].z;\n"
"	float dy = vTexCoord[0].w;\n"
"	vec3 p1  = texture(Texture, vTexCoord[0].xy).rgb;\n"
"	vec3 p2  = texture(Texture, vTexCoord[0].xy + vec2(dx, dy) * quad).rgb;\n"
"	vec3 p3  = texture(Texture, vTexCoord[0].xy + vec2(dx, 0) * quad).rgb;\n"
"	vec3 p4  = texture(Texture, vTexCoord[0].xy + vec2(0, dy) * quad).rgb;\n"
"	mat4x3 pixels = mat4x3(p1, p2, p3, p4);\n"
"\n"
"	vec3 w1  = yuv * texture(Texture, vTexCoord[1].xw).rgb;\n"
"	vec3 w2  = yuv * texture(Texture, vTexCoord[1].yw).rgb;\n"
"	vec3 w3  = yuv * texture(Texture, vTexCoord[1].zw).rgb;\n"
"\n"
"	vec3 w4  = yuv * texture(Texture, vTexCoord[2].xw).rgb;\n"
"	vec3 w5  = yuv * p1;\n"
"	vec3 w6  = yuv * texture(Texture, vTexCoord[2].zw).rgb;\n"
"\n"
"	vec3 w7  = yuv * texture(Texture, vTexCoord[3].xw).rgb;\n"
"	vec3 w8  = yuv * texture(Texture, vTexCoord[3].yw).rgb;\n"
"	vec3 w9  = yuv * texture(Texture, vTexCoord[3].zw).rgb;\n"
"\n"
"	bvec3 pattern[3];\n"
"	pattern[0] =  bvec3(diff(w5, w1), diff(w5, w2), diff(w5, w3));\n"
"	pattern[1] =  bvec3(diff(w5, w4), false       , diff(w5, w6));\n"
"	pattern[2] =  bvec3(diff(w5, w7), diff(w5, w8), diff(w5, w9));\n"
"	bvec4 cross = bvec4(diff(w4, w2), diff(w2, w6), diff(w8, w4), diff(w6, w8));\n"
"\n"
"	vec2 index;\n"
"	index.x = dot(vec3(pattern[0]), vec3(1.0, 2.0, 4.0)) +\n"
"			  dot(vec3(pattern[1]), vec3(8.0, 0.0, 16.0)) +\n"
"			  dot(vec3(pattern[2]), vec3(32.0, 64.0, 128.0));\n"
"	index.y = dot(vec4(cross), vec4(1.0, 2.0, 4.0, 8.0)) * (SCALE * SCALE) +\n"
"	          dot(floor(fp * SCALE), vec2(1, SCALE));\n"
"\n"
"	vec2 step = 1.0 / vec2(256.0, 16.0 * (SCALE * SCALE));\n"
"	vec2 offset = step / 2.0;\n"
"	vec4 weights = texture(LUT, index * step + offset);\n"
"	float sum = dot(weights, vec4(1));\n"
"	vec3 res = pixels * (weights / sum);\n"
"\n"
"	fragColor.rgb = res;\n"
"}\n";

#endif
