/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|*  * LoongArch Disassembler                                                  *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/


#include "llvm/MC/MCInst.h"
#include "llvm/MC/MCSubtargetInfo.h"
#include "llvm/Support/DataTypes.h"
#include "llvm/Support/Debug.h"
#include "llvm/Support/LEB128.h"
#include "llvm/Support/raw_ostream.h"
#include "llvm/TargetParser/SubtargetFeature.h"
#include <assert.h>

namespace {

// Helper functions for extracting fields from encoded instructions.
// InsnType must either be integral or an APInt-like object that must:
// * be default-constructible and copy-constructible
// * Support extractBitsAsZExtValue(numBits, startBit)
// * Support the ~, &, ==, and != operators with other objects of the same type
// * Support the != and bitwise & with uint64_t
template <typename InsnType>
#if defined(_MSC_VER) && !defined(__clang__)
__declspec(noinline)
#endif
static std::enable_if_t<std::is_integral<InsnType>::value, InsnType>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  assert(startBit + numBits <= 64 && "Cannot support >64-bit extractions!");
  assert(startBit + numBits <= (sizeof(InsnType) * 8) &&
         "Instruction field out of bounds!");
  InsnType fieldMask;
  if (numBits == sizeof(InsnType) * 8)
    fieldMask = (InsnType)(-1LL);
  else
    fieldMask = (((InsnType)1 << numBits) - 1) << startBit;
  return (insn & fieldMask) >> startBit;
}

template <typename InsnType>
static std::enable_if_t<!std::is_integral<InsnType>::value, uint64_t>
fieldFromInstruction(const InsnType &insn, unsigned startBit,
                     unsigned numBits) {
  return insn.extractBitsAsZExtValue(numBits, startBit);
}

// Helper function for inserting bits extracted from an encoded instruction into
// an integer-typed field.
template <typename IntType>
static std::enable_if_t<std::is_integral_v<IntType>, void>
insertBits(IntType &field, IntType bits, unsigned startBit, unsigned numBits) {
  // Check that no bit beyond numBits is set, so that a simple bitwise |
  // is sufficient.
  assert((~(((IntType)1 << numBits) - 1) & bits) == 0 &&
           "bits has more than numBits bits set");
  assert(startBit + numBits <= sizeof(IntType) * 8);
  (void)numBits;
  field |= bits << startBit;
}

static bool Check(DecodeStatus &Out, DecodeStatus In) {
  Out = static_cast<DecodeStatus>(Out & In);
  return Out != MCDisassembler::Fail;
}

static const uint8_t DecoderTable32[] = {
/* 0 */       MCD::OPC_ExtractField, 26, 6,  // Inst{31-26} ...
/* 3 */       MCD::OPC_FilterValue, 0, 134, 13, // Skip to: 3469
/* 7 */       MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 10 */      MCD::OPC_FilterValue, 0, 246, 7, // Skip to: 2052
/* 14 */      MCD::OPC_ExtractField, 18, 4,  // Inst{21-18} ...
/* 17 */      MCD::OPC_FilterValue, 0, 209, 1, // Skip to: 486
/* 21 */      MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 24 */      MCD::OPC_FilterValue, 0, 29, 1, // Skip to: 313
/* 28 */      MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 31 */      MCD::OPC_FilterValue, 2, 8, 0, // Skip to: 43
/* 35 */      MCD::OPC_CheckFieldOrFail, 2, 3, 0, 
/* 39 */      MCD::OPC_Decode, 156, 6, 0, // Opcode: MOVGR2SCR, DecodeIdx: 0
/* 43 */      MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 55
/* 47 */      MCD::OPC_CheckFieldOrFail, 7, 3, 0, 
/* 51 */      MCD::OPC_Decode, 157, 6, 1, // Opcode: MOVSCR2GR, DecodeIdx: 1
/* 55 */      MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 63
/* 59 */      MCD::OPC_Decode, 167, 4, 2, // Opcode: CLO_W, DecodeIdx: 2
/* 63 */      MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 71
/* 67 */      MCD::OPC_Decode, 169, 4, 2, // Opcode: CLZ_W, DecodeIdx: 2
/* 71 */      MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 79
/* 75 */      MCD::OPC_Decode, 183, 4, 2, // Opcode: CTO_W, DecodeIdx: 2
/* 79 */      MCD::OPC_FilterValue, 7, 4, 0, // Skip to: 87
/* 83 */      MCD::OPC_Decode, 185, 4, 2, // Opcode: CTZ_W, DecodeIdx: 2
/* 87 */      MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 97
/* 91 */      MCD::OPC_CheckPredicateOrFail, 0, 
/* 93 */      MCD::OPC_Decode, 166, 4, 2, // Opcode: CLO_D, DecodeIdx: 2
/* 97 */      MCD::OPC_FilterValue, 9, 6, 0, // Skip to: 107
/* 101 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 103 */     MCD::OPC_Decode, 168, 4, 2, // Opcode: CLZ_D, DecodeIdx: 2
/* 107 */     MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 117
/* 111 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 113 */     MCD::OPC_Decode, 182, 4, 2, // Opcode: CTO_D, DecodeIdx: 2
/* 117 */     MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 127
/* 121 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 123 */     MCD::OPC_Decode, 184, 4, 2, // Opcode: CTZ_D, DecodeIdx: 2
/* 127 */     MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 135
/* 131 */     MCD::OPC_Decode, 187, 6, 2, // Opcode: REVB_2H, DecodeIdx: 2
/* 135 */     MCD::OPC_FilterValue, 13, 6, 0, // Skip to: 145
/* 139 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 141 */     MCD::OPC_Decode, 189, 6, 2, // Opcode: REVB_4H, DecodeIdx: 2
/* 145 */     MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 155
/* 149 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 151 */     MCD::OPC_Decode, 188, 6, 2, // Opcode: REVB_2W, DecodeIdx: 2
/* 155 */     MCD::OPC_FilterValue, 15, 6, 0, // Skip to: 165
/* 159 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 161 */     MCD::OPC_Decode, 190, 6, 2, // Opcode: REVB_D, DecodeIdx: 2
/* 165 */     MCD::OPC_FilterValue, 16, 6, 0, // Skip to: 175
/* 169 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 171 */     MCD::OPC_Decode, 191, 6, 2, // Opcode: REVH_2W, DecodeIdx: 2
/* 175 */     MCD::OPC_FilterValue, 17, 6, 0, // Skip to: 185
/* 179 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 181 */     MCD::OPC_Decode, 192, 6, 2, // Opcode: REVH_D, DecodeIdx: 2
/* 185 */     MCD::OPC_FilterValue, 18, 4, 0, // Skip to: 193
/* 189 */     MCD::OPC_Decode, 149, 4, 2, // Opcode: BITREV_4B, DecodeIdx: 2
/* 193 */     MCD::OPC_FilterValue, 19, 6, 0, // Skip to: 203
/* 197 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 199 */     MCD::OPC_Decode, 150, 4, 2, // Opcode: BITREV_8B, DecodeIdx: 2
/* 203 */     MCD::OPC_FilterValue, 20, 4, 0, // Skip to: 211
/* 207 */     MCD::OPC_Decode, 152, 4, 2, // Opcode: BITREV_W, DecodeIdx: 2
/* 211 */     MCD::OPC_FilterValue, 21, 6, 0, // Skip to: 221
/* 215 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 217 */     MCD::OPC_Decode, 151, 4, 2, // Opcode: BITREV_D, DecodeIdx: 2
/* 221 */     MCD::OPC_FilterValue, 22, 4, 0, // Skip to: 229
/* 225 */     MCD::OPC_Decode, 194, 4, 2, // Opcode: EXT_W_H, DecodeIdx: 2
/* 229 */     MCD::OPC_FilterValue, 23, 4, 0, // Skip to: 237
/* 233 */     MCD::OPC_Decode, 193, 4, 2, // Opcode: EXT_W_B, DecodeIdx: 2
/* 237 */     MCD::OPC_FilterValue, 24, 4, 0, // Skip to: 245
/* 241 */     MCD::OPC_Decode, 185, 6, 2, // Opcode: RDTIMEL_W, DecodeIdx: 2
/* 245 */     MCD::OPC_FilterValue, 25, 4, 0, // Skip to: 253
/* 249 */     MCD::OPC_Decode, 184, 6, 2, // Opcode: RDTIMEH_W, DecodeIdx: 2
/* 253 */     MCD::OPC_FilterValue, 26, 6, 0, // Skip to: 263
/* 257 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 259 */     MCD::OPC_Decode, 186, 6, 2, // Opcode: RDTIME_D, DecodeIdx: 2
/* 263 */     MCD::OPC_FilterValue, 27, 4, 0, // Skip to: 271
/* 267 */     MCD::OPC_Decode, 170, 4, 2, // Opcode: CPUCFG, DecodeIdx: 2
/* 271 */     MCD::OPC_FilterValue, 28, 12, 0, // Skip to: 287
/* 275 */     MCD::OPC_CheckFieldOrFail, 8, 2, 0, 
/* 279 */     MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 283 */     MCD::OPC_Decode, 251, 12, 3, // Opcode: X86MTTOP, DecodeIdx: 3
/* 287 */     MCD::OPC_FilterValue, 29, 8, 0, // Skip to: 299
/* 291 */     MCD::OPC_CheckFieldOrFail, 5, 5, 0, 
/* 295 */     MCD::OPC_Decode, 249, 12, 4, // Opcode: X86MFTOP, DecodeIdx: 4
/* 299 */     MCD::OPC_FilterValue, 30, 4, 0, // Skip to: 307
/* 303 */     MCD::OPC_Decode, 212, 6, 2, // Opcode: SETX86LOOPE, DecodeIdx: 2
/* 307 */     MCD::OPC_FilterValueOrFail, 31, 
/* 309 */     MCD::OPC_Decode, 213, 6, 2, // Opcode: SETX86LOOPNE, DecodeIdx: 2
/* 313 */     MCD::OPC_FilterValue, 1, 143, 0, // Skip to: 460
/* 317 */     MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 320 */     MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 332
/* 324 */     MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 328 */     MCD::OPC_Decode, 244, 12, 5, // Opcode: X86INC_B, DecodeIdx: 5
/* 332 */     MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 344
/* 336 */     MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 340 */     MCD::OPC_Decode, 246, 12, 5, // Opcode: X86INC_H, DecodeIdx: 5
/* 344 */     MCD::OPC_FilterValue, 2, 8, 0, // Skip to: 356
/* 348 */     MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 352 */     MCD::OPC_Decode, 247, 12, 5, // Opcode: X86INC_W, DecodeIdx: 5
/* 356 */     MCD::OPC_FilterValue, 3, 10, 0, // Skip to: 370
/* 360 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 362 */     MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 366 */     MCD::OPC_Decode, 245, 12, 5, // Opcode: X86INC_D, DecodeIdx: 5
/* 370 */     MCD::OPC_FilterValue, 4, 8, 0, // Skip to: 382
/* 374 */     MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 378 */     MCD::OPC_Decode, 239, 12, 5, // Opcode: X86DEC_B, DecodeIdx: 5
/* 382 */     MCD::OPC_FilterValue, 5, 8, 0, // Skip to: 394
/* 386 */     MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 390 */     MCD::OPC_Decode, 241, 12, 5, // Opcode: X86DEC_H, DecodeIdx: 5
/* 394 */     MCD::OPC_FilterValue, 6, 8, 0, // Skip to: 406
/* 398 */     MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 402 */     MCD::OPC_Decode, 242, 12, 5, // Opcode: X86DEC_W, DecodeIdx: 5
/* 406 */     MCD::OPC_FilterValue, 7, 10, 0, // Skip to: 420
/* 410 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 412 */     MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 416 */     MCD::OPC_Decode, 240, 12, 5, // Opcode: X86DEC_D, DecodeIdx: 5
/* 420 */     MCD::OPC_FilterValue, 8, 17, 0, // Skip to: 441
/* 424 */     MCD::OPC_ExtractField, 5, 10,  // Inst{14-5} ...
/* 427 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 435
/* 431 */     MCD::OPC_Decode, 173, 13, 6, // Opcode: X86SETTM, DecodeIdx: 6
/* 435 */     MCD::OPC_FilterValueOrFail, 1, 
/* 437 */     MCD::OPC_Decode, 237, 12, 6, // Opcode: X86CLRTM, DecodeIdx: 6
/* 441 */     MCD::OPC_FilterValueOrFail, 9, 
/* 443 */     MCD::OPC_ExtractField, 5, 10,  // Inst{14-5} ...
/* 446 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 454
/* 450 */     MCD::OPC_Decode, 243, 12, 6, // Opcode: X86INCTOP, DecodeIdx: 6
/* 454 */     MCD::OPC_FilterValueOrFail, 1, 
/* 456 */     MCD::OPC_Decode, 238, 12, 6, // Opcode: X86DECTOP, DecodeIdx: 6
/* 460 */     MCD::OPC_FilterValue, 2, 10, 0, // Skip to: 474
/* 464 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 466 */     MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 470 */     MCD::OPC_Decode, 141, 4, 7, // Opcode: ASRTLE_D, DecodeIdx: 7
/* 474 */     MCD::OPC_FilterValueOrFail, 3, 
/* 476 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 478 */     MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 482 */     MCD::OPC_Decode, 140, 4, 7, // Opcode: ASRTGT_D, DecodeIdx: 7
/* 486 */     MCD::OPC_FilterValue, 1, 19, 0, // Skip to: 509
/* 490 */     MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 493 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 501
/* 497 */     MCD::OPC_Decode, 189, 3, 8, // Opcode: ALSL_W, DecodeIdx: 8
/* 501 */     MCD::OPC_FilterValueOrFail, 1, 
/* 503 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 505 */     MCD::OPC_Decode, 190, 3, 8, // Opcode: ALSL_WU, DecodeIdx: 8
/* 509 */     MCD::OPC_FilterValue, 2, 8, 0, // Skip to: 521
/* 513 */     MCD::OPC_CheckFieldOrFail, 17, 1, 0, 
/* 517 */     MCD::OPC_Decode, 164, 4, 9, // Opcode: BYTEPICK_W, DecodeIdx: 9
/* 521 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 531
/* 525 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 527 */     MCD::OPC_Decode, 163, 4, 10, // Opcode: BYTEPICK_D, DecodeIdx: 10
/* 531 */     MCD::OPC_FilterValue, 4, 69, 0, // Skip to: 604
/* 535 */     MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 538 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 546
/* 542 */     MCD::OPC_Decode, 187, 3, 11, // Opcode: ADD_W, DecodeIdx: 11
/* 546 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 556
/* 550 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 552 */     MCD::OPC_Decode, 186, 3, 11, // Opcode: ADD_D, DecodeIdx: 11
/* 556 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 564
/* 560 */     MCD::OPC_Decode, 255, 6, 11, // Opcode: SUB_W, DecodeIdx: 11
/* 564 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 574
/* 568 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 570 */     MCD::OPC_Decode, 254, 6, 11, // Opcode: SUB_D, DecodeIdx: 11
/* 574 */     MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 582
/* 578 */     MCD::OPC_Decode, 220, 6, 11, // Opcode: SLT, DecodeIdx: 11
/* 582 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 590
/* 586 */     MCD::OPC_Decode, 222, 6, 11, // Opcode: SLTU, DecodeIdx: 11
/* 590 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 598
/* 594 */     MCD::OPC_Decode, 136, 6, 11, // Opcode: MASKEQZ, DecodeIdx: 11
/* 598 */     MCD::OPC_FilterValueOrFail, 7, 
/* 600 */     MCD::OPC_Decode, 137, 6, 11, // Opcode: MASKNEZ, DecodeIdx: 11
/* 604 */     MCD::OPC_FilterValue, 5, 65, 0, // Skip to: 673
/* 608 */     MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 611 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 619
/* 615 */     MCD::OPC_Decode, 166, 6, 11, // Opcode: NOR, DecodeIdx: 11
/* 619 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 627
/* 623 */     MCD::OPC_Decode, 243, 3, 11, // Opcode: AND, DecodeIdx: 11
/* 627 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 635
/* 631 */     MCD::OPC_Decode, 167, 6, 11, // Opcode: OR, DecodeIdx: 11
/* 635 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 643
/* 639 */     MCD::OPC_Decode, 208, 13, 11, // Opcode: XOR, DecodeIdx: 11
/* 643 */     MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 651
/* 647 */     MCD::OPC_Decode, 169, 6, 11, // Opcode: ORN, DecodeIdx: 11
/* 651 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 659
/* 655 */     MCD::OPC_Decode, 245, 3, 11, // Opcode: ANDN, DecodeIdx: 11
/* 659 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 667
/* 663 */     MCD::OPC_Decode, 219, 6, 11, // Opcode: SLL_W, DecodeIdx: 11
/* 667 */     MCD::OPC_FilterValueOrFail, 7, 
/* 669 */     MCD::OPC_Decode, 231, 6, 11, // Opcode: SRL_W, DecodeIdx: 11
/* 673 */     MCD::OPC_FilterValue, 6, 73, 0, // Skip to: 750
/* 677 */     MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 680 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 688
/* 684 */     MCD::OPC_Decode, 227, 6, 11, // Opcode: SRA_W, DecodeIdx: 11
/* 688 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 698
/* 692 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 694 */     MCD::OPC_Decode, 218, 6, 11, // Opcode: SLL_D, DecodeIdx: 11
/* 698 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 708
/* 702 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 704 */     MCD::OPC_Decode, 230, 6, 11, // Opcode: SRL_D, DecodeIdx: 11
/* 708 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 718
/* 712 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 714 */     MCD::OPC_Decode, 226, 6, 11, // Opcode: SRA_D, DecodeIdx: 11
/* 718 */     MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 726
/* 722 */     MCD::OPC_Decode, 197, 6, 11, // Opcode: ROTR_B, DecodeIdx: 11
/* 726 */     MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 734
/* 730 */     MCD::OPC_Decode, 199, 6, 11, // Opcode: ROTR_H, DecodeIdx: 11
/* 734 */     MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 742
/* 738 */     MCD::OPC_Decode, 200, 6, 11, // Opcode: ROTR_W, DecodeIdx: 11
/* 742 */     MCD::OPC_FilterValueOrFail, 7, 
/* 744 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 746 */     MCD::OPC_Decode, 198, 6, 11, // Opcode: ROTR_D, DecodeIdx: 11
/* 750 */     MCD::OPC_FilterValue, 7, 75, 0, // Skip to: 829
/* 754 */     MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 757 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 765
/* 761 */     MCD::OPC_Decode, 165, 6, 11, // Opcode: MUL_W, DecodeIdx: 11
/* 765 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 773
/* 769 */     MCD::OPC_Decode, 160, 6, 11, // Opcode: MULH_W, DecodeIdx: 11
/* 773 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 781
/* 777 */     MCD::OPC_Decode, 161, 6, 11, // Opcode: MULH_WU, DecodeIdx: 11
/* 781 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 791
/* 785 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 787 */     MCD::OPC_Decode, 164, 6, 11, // Opcode: MUL_D, DecodeIdx: 11
/* 791 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 801
/* 795 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 797 */     MCD::OPC_Decode, 158, 6, 11, // Opcode: MULH_D, DecodeIdx: 11
/* 801 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 811
/* 805 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 807 */     MCD::OPC_Decode, 159, 6, 11, // Opcode: MULH_DU, DecodeIdx: 11
/* 811 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 821
/* 815 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 817 */     MCD::OPC_Decode, 162, 6, 11, // Opcode: MULW_D_W, DecodeIdx: 11
/* 821 */     MCD::OPC_FilterValueOrFail, 7, 
/* 823 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 825 */     MCD::OPC_Decode, 163, 6, 11, // Opcode: MULW_D_WU, DecodeIdx: 11
/* 829 */     MCD::OPC_FilterValue, 8, 73, 0, // Skip to: 906
/* 833 */     MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 836 */     MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 844
/* 840 */     MCD::OPC_Decode, 190, 4, 11, // Opcode: DIV_W, DecodeIdx: 11
/* 844 */     MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 852
/* 848 */     MCD::OPC_Decode, 140, 6, 11, // Opcode: MOD_W, DecodeIdx: 11
/* 852 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 860
/* 856 */     MCD::OPC_Decode, 191, 4, 11, // Opcode: DIV_WU, DecodeIdx: 11
/* 860 */     MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 868
/* 864 */     MCD::OPC_Decode, 141, 6, 11, // Opcode: MOD_WU, DecodeIdx: 11
/* 868 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 878
/* 872 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 874 */     MCD::OPC_Decode, 188, 4, 11, // Opcode: DIV_D, DecodeIdx: 11
/* 878 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 888
/* 882 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 884 */     MCD::OPC_Decode, 138, 6, 11, // Opcode: MOD_D, DecodeIdx: 11
/* 888 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 898
/* 892 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 894 */     MCD::OPC_Decode, 189, 4, 11, // Opcode: DIV_DU, DecodeIdx: 11
/* 898 */     MCD::OPC_FilterValueOrFail, 7, 
/* 900 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 902 */     MCD::OPC_Decode, 139, 6, 11, // Opcode: MOD_DU, DecodeIdx: 11
/* 906 */     MCD::OPC_FilterValue, 9, 81, 0, // Skip to: 991
/* 910 */     MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 913 */     MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 923
/* 917 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 919 */     MCD::OPC_Decode, 175, 4, 11, // Opcode: CRC_W_B_W, DecodeIdx: 11
/* 923 */     MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 933
/* 927 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 929 */     MCD::OPC_Decode, 177, 4, 11, // Opcode: CRC_W_H_W, DecodeIdx: 11
/* 933 */     MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 943
/* 937 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 939 */     MCD::OPC_Decode, 178, 4, 11, // Opcode: CRC_W_W_W, DecodeIdx: 11
/* 943 */     MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 953
/* 947 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 949 */     MCD::OPC_Decode, 176, 4, 11, // Opcode: CRC_W_D_W, DecodeIdx: 11
/* 953 */     MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 963
/* 957 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 959 */     MCD::OPC_Decode, 171, 4, 11, // Opcode: CRCC_W_B_W, DecodeIdx: 11
/* 963 */     MCD::OPC_FilterValue, 5, 6, 0, // Skip to: 973
/* 967 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 969 */     MCD::OPC_Decode, 173, 4, 11, // Opcode: CRCC_W_H_W, DecodeIdx: 11
/* 973 */     MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 983
/* 977 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 979 */     MCD::OPC_Decode, 174, 4, 11, // Opcode: CRCC_W_W_W, DecodeIdx: 11
/* 983 */     MCD::OPC_FilterValueOrFail, 7, 
/* 985 */     MCD::OPC_CheckPredicateOrFail, 0, 
/* 987 */     MCD::OPC_Decode, 172, 4, 11, // Opcode: CRCC_W_D_W, DecodeIdx: 11
/* 991 */     MCD::OPC_FilterValue, 10, 51, 0, // Skip to: 1046
/* 995 */     MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 998 */     MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 1006
/* 1002 */    MCD::OPC_Decode, 184, 3, 12, // Opcode: ADDU12I_W, DecodeIdx: 12
/* 1006 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 1016
/* 1010 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1012 */    MCD::OPC_Decode, 183, 3, 12, // Opcode: ADDU12I_D, DecodeIdx: 12
/* 1016 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 1024
/* 1020 */    MCD::OPC_Decode, 158, 4, 13, // Opcode: BREAK, DecodeIdx: 13
/* 1024 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 1032
/* 1028 */    MCD::OPC_Decode, 187, 4, 13, // Opcode: DBCL, DecodeIdx: 13
/* 1032 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 1040
/* 1036 */    MCD::OPC_Decode, 128, 7, 13, // Opcode: SYSCALL, DecodeIdx: 13
/* 1040 */    MCD::OPC_FilterValueOrFail, 7, 
/* 1042 */    MCD::OPC_Decode, 212, 5, 13, // Opcode: HVCL, DecodeIdx: 13
/* 1046 */    MCD::OPC_FilterValue, 11, 10, 0, // Skip to: 1060
/* 1050 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1052 */    MCD::OPC_CheckFieldOrFail, 17, 1, 0, 
/* 1056 */    MCD::OPC_Decode, 188, 3, 8, // Opcode: ALSL_D, DecodeIdx: 8
/* 1060 */    MCD::OPC_FilterValue, 12, 69, 0, // Skip to: 1133
/* 1064 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 1067 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1075
/* 1071 */    MCD::OPC_Decode, 177, 3, 11, // Opcode: ADC_B, DecodeIdx: 11
/* 1075 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1083
/* 1079 */    MCD::OPC_Decode, 179, 3, 11, // Opcode: ADC_H, DecodeIdx: 11
/* 1083 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 1091
/* 1087 */    MCD::OPC_Decode, 180, 3, 11, // Opcode: ADC_W, DecodeIdx: 11
/* 1091 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 1101
/* 1095 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1097 */    MCD::OPC_Decode, 178, 3, 11, // Opcode: ADC_D, DecodeIdx: 11
/* 1101 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 1109
/* 1105 */    MCD::OPC_Decode, 201, 6, 11, // Opcode: SBC_B, DecodeIdx: 11
/* 1109 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 1117
/* 1113 */    MCD::OPC_Decode, 203, 6, 11, // Opcode: SBC_H, DecodeIdx: 11
/* 1117 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 1125
/* 1121 */    MCD::OPC_Decode, 204, 6, 11, // Opcode: SBC_W, DecodeIdx: 11
/* 1125 */    MCD::OPC_FilterValueOrFail, 7, 
/* 1127 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1129 */    MCD::OPC_Decode, 202, 6, 11, // Opcode: SBC_D, DecodeIdx: 11
/* 1133 */    MCD::OPC_FilterValue, 13, 100, 0, // Skip to: 1237
/* 1137 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 1140 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1148
/* 1144 */    MCD::OPC_Decode, 180, 6, 11, // Opcode: RCR_B, DecodeIdx: 11
/* 1148 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1156
/* 1152 */    MCD::OPC_Decode, 182, 6, 11, // Opcode: RCR_H, DecodeIdx: 11
/* 1156 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 1164
/* 1160 */    MCD::OPC_Decode, 183, 6, 11, // Opcode: RCR_W, DecodeIdx: 11
/* 1164 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 1174
/* 1168 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1170 */    MCD::OPC_Decode, 181, 6, 11, // Opcode: RCR_D, DecodeIdx: 11
/* 1174 */    MCD::OPC_FilterValue, 4, 8, 0, // Skip to: 1186
/* 1178 */    MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 1182 */    MCD::OPC_Decode, 250, 3, 14, // Opcode: ARMMOVE, DecodeIdx: 14
/* 1186 */    MCD::OPC_FilterValue, 5, 25, 0, // Skip to: 1215
/* 1190 */    MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 1193 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1205
/* 1197 */    MCD::OPC_CheckFieldOrFail, 5, 5, 0, 
/* 1201 */    MCD::OPC_Decode, 211, 6, 15, // Opcode: SETX86J, DecodeIdx: 15
/* 1205 */    MCD::OPC_FilterValueOrFail, 1, 
/* 1207 */    MCD::OPC_CheckFieldOrFail, 5, 5, 0, 
/* 1211 */    MCD::OPC_Decode, 210, 6, 15, // Opcode: SETARMJ, DecodeIdx: 15
/* 1215 */    MCD::OPC_FilterValue, 6, 8, 0, // Skip to: 1227
/* 1219 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1223 */    MCD::OPC_Decode, 247, 3, 16, // Opcode: ARMADD_W, DecodeIdx: 16
/* 1227 */    MCD::OPC_FilterValueOrFail, 7, 
/* 1229 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1233 */    MCD::OPC_Decode, 138, 4, 16, // Opcode: ARMSUB_W, DecodeIdx: 16
/* 1237 */    MCD::OPC_FilterValue, 14, 97, 0, // Skip to: 1338
/* 1241 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 1244 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1256
/* 1248 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1252 */    MCD::OPC_Decode, 246, 3, 16, // Opcode: ARMADC_W, DecodeIdx: 16
/* 1256 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 1268
/* 1260 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1264 */    MCD::OPC_Decode, 131, 4, 16, // Opcode: ARMSBC_W, DecodeIdx: 16
/* 1268 */    MCD::OPC_FilterValue, 2, 8, 0, // Skip to: 1280
/* 1272 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1276 */    MCD::OPC_Decode, 248, 3, 16, // Opcode: ARMAND_W, DecodeIdx: 16
/* 1280 */    MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 1292
/* 1284 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1288 */    MCD::OPC_Decode, 255, 3, 16, // Opcode: ARMOR_W, DecodeIdx: 16
/* 1292 */    MCD::OPC_FilterValue, 4, 8, 0, // Skip to: 1304
/* 1296 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1300 */    MCD::OPC_Decode, 139, 4, 16, // Opcode: ARMXOR_W, DecodeIdx: 16
/* 1304 */    MCD::OPC_FilterValue, 5, 8, 0, // Skip to: 1316
/* 1308 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1312 */    MCD::OPC_Decode, 133, 4, 16, // Opcode: ARMSLL_W, DecodeIdx: 16
/* 1316 */    MCD::OPC_FilterValue, 6, 8, 0, // Skip to: 1328
/* 1320 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1324 */    MCD::OPC_Decode, 137, 4, 16, // Opcode: ARMSRL_W, DecodeIdx: 16
/* 1328 */    MCD::OPC_FilterValueOrFail, 7, 
/* 1330 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1334 */    MCD::OPC_Decode, 135, 4, 16, // Opcode: ARMSRA_W, DecodeIdx: 16
/* 1338 */    MCD::OPC_FilterValueOrFail, 15, 
/* 1340 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 1343 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 1355
/* 1347 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1351 */    MCD::OPC_Decode, 129, 4, 16, // Opcode: ARMROTR_W, DecodeIdx: 16
/* 1355 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 1367
/* 1359 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1363 */    MCD::OPC_Decode, 132, 4, 17, // Opcode: ARMSLLI_W, DecodeIdx: 17
/* 1367 */    MCD::OPC_FilterValue, 2, 8, 0, // Skip to: 1379
/* 1371 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1375 */    MCD::OPC_Decode, 136, 4, 17, // Opcode: ARMSRLI_W, DecodeIdx: 17
/* 1379 */    MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 1391
/* 1383 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1387 */    MCD::OPC_Decode, 134, 4, 17, // Opcode: ARMSRAI_W, DecodeIdx: 17
/* 1391 */    MCD::OPC_FilterValue, 4, 8, 0, // Skip to: 1403
/* 1395 */    MCD::OPC_CheckFieldOrFail, 4, 1, 1, 
/* 1399 */    MCD::OPC_Decode, 128, 4, 17, // Opcode: ARMROTRI_W, DecodeIdx: 17
/* 1403 */    MCD::OPC_FilterValue, 5, 71, 0, // Skip to: 1478
/* 1407 */    MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 1410 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1418
/* 1414 */    MCD::OPC_Decode, 252, 12, 7, // Opcode: X86MUL_B, DecodeIdx: 7
/* 1418 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1426
/* 1422 */    MCD::OPC_Decode, 128, 13, 7, // Opcode: X86MUL_H, DecodeIdx: 7
/* 1426 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 1434
/* 1430 */    MCD::OPC_Decode, 130, 13, 7, // Opcode: X86MUL_W, DecodeIdx: 7
/* 1434 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 1444
/* 1438 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1440 */    MCD::OPC_Decode, 254, 12, 7, // Opcode: X86MUL_D, DecodeIdx: 7
/* 1444 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 1452
/* 1448 */    MCD::OPC_Decode, 253, 12, 7, // Opcode: X86MUL_BU, DecodeIdx: 7
/* 1452 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 1460
/* 1456 */    MCD::OPC_Decode, 129, 13, 7, // Opcode: X86MUL_HU, DecodeIdx: 7
/* 1460 */    MCD::OPC_FilterValue, 6, 6, 0, // Skip to: 1470
/* 1464 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1466 */    MCD::OPC_Decode, 131, 13, 7, // Opcode: X86MUL_WU, DecodeIdx: 7
/* 1470 */    MCD::OPC_FilterValueOrFail, 7, 
/* 1472 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1474 */    MCD::OPC_Decode, 255, 12, 7, // Opcode: X86MUL_DU, DecodeIdx: 7
/* 1478 */    MCD::OPC_FilterValue, 6, 23, 1, // Skip to: 1761
/* 1482 */    MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 1485 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 1495
/* 1489 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1491 */    MCD::OPC_Decode, 232, 12, 7, // Opcode: X86ADD_WU, DecodeIdx: 7
/* 1495 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 1505
/* 1499 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1501 */    MCD::OPC_Decode, 229, 12, 7, // Opcode: X86ADD_DU, DecodeIdx: 7
/* 1505 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 1515
/* 1509 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1511 */    MCD::OPC_Decode, 203, 13, 7, // Opcode: X86SUB_WU, DecodeIdx: 7
/* 1515 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 1525
/* 1519 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1521 */    MCD::OPC_Decode, 200, 13, 7, // Opcode: X86SUB_DU, DecodeIdx: 7
/* 1525 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 1533
/* 1529 */    MCD::OPC_Decode, 227, 12, 7, // Opcode: X86ADD_B, DecodeIdx: 7
/* 1533 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 1541
/* 1537 */    MCD::OPC_Decode, 230, 12, 7, // Opcode: X86ADD_H, DecodeIdx: 7
/* 1541 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 1549
/* 1545 */    MCD::OPC_Decode, 231, 12, 7, // Opcode: X86ADD_W, DecodeIdx: 7
/* 1549 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 1559
/* 1553 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1555 */    MCD::OPC_Decode, 228, 12, 7, // Opcode: X86ADD_D, DecodeIdx: 7
/* 1559 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 1567
/* 1563 */    MCD::OPC_Decode, 198, 13, 7, // Opcode: X86SUB_B, DecodeIdx: 7
/* 1567 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 1575
/* 1571 */    MCD::OPC_Decode, 201, 13, 7, // Opcode: X86SUB_H, DecodeIdx: 7
/* 1575 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 1583
/* 1579 */    MCD::OPC_Decode, 202, 13, 7, // Opcode: X86SUB_W, DecodeIdx: 7
/* 1583 */    MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 1593
/* 1587 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1589 */    MCD::OPC_Decode, 199, 13, 7, // Opcode: X86SUB_D, DecodeIdx: 7
/* 1593 */    MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 1601
/* 1597 */    MCD::OPC_Decode, 223, 12, 7, // Opcode: X86ADC_B, DecodeIdx: 7
/* 1601 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 1609
/* 1605 */    MCD::OPC_Decode, 225, 12, 7, // Opcode: X86ADC_H, DecodeIdx: 7
/* 1609 */    MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 1617
/* 1613 */    MCD::OPC_Decode, 226, 12, 7, // Opcode: X86ADC_W, DecodeIdx: 7
/* 1617 */    MCD::OPC_FilterValue, 15, 6, 0, // Skip to: 1627
/* 1621 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1623 */    MCD::OPC_Decode, 224, 12, 7, // Opcode: X86ADC_D, DecodeIdx: 7
/* 1627 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 1635
/* 1631 */    MCD::OPC_Decode, 168, 13, 7, // Opcode: X86SBC_B, DecodeIdx: 7
/* 1635 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 1643
/* 1639 */    MCD::OPC_Decode, 170, 13, 7, // Opcode: X86SBC_H, DecodeIdx: 7
/* 1643 */    MCD::OPC_FilterValue, 18, 4, 0, // Skip to: 1651
/* 1647 */    MCD::OPC_Decode, 171, 13, 7, // Opcode: X86SBC_W, DecodeIdx: 7
/* 1651 */    MCD::OPC_FilterValue, 19, 6, 0, // Skip to: 1661
/* 1655 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1657 */    MCD::OPC_Decode, 169, 13, 7, // Opcode: X86SBC_D, DecodeIdx: 7
/* 1661 */    MCD::OPC_FilterValue, 20, 4, 0, // Skip to: 1669
/* 1665 */    MCD::OPC_Decode, 178, 13, 7, // Opcode: X86SLL_B, DecodeIdx: 7
/* 1669 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 1677
/* 1673 */    MCD::OPC_Decode, 180, 13, 7, // Opcode: X86SLL_H, DecodeIdx: 7
/* 1677 */    MCD::OPC_FilterValue, 22, 4, 0, // Skip to: 1685
/* 1681 */    MCD::OPC_Decode, 181, 13, 7, // Opcode: X86SLL_W, DecodeIdx: 7
/* 1685 */    MCD::OPC_FilterValue, 23, 6, 0, // Skip to: 1695
/* 1689 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1691 */    MCD::OPC_Decode, 179, 13, 7, // Opcode: X86SLL_D, DecodeIdx: 7
/* 1695 */    MCD::OPC_FilterValue, 24, 4, 0, // Skip to: 1703
/* 1699 */    MCD::OPC_Decode, 194, 13, 7, // Opcode: X86SRL_B, DecodeIdx: 7
/* 1703 */    MCD::OPC_FilterValue, 25, 4, 0, // Skip to: 1711
/* 1707 */    MCD::OPC_Decode, 196, 13, 7, // Opcode: X86SRL_H, DecodeIdx: 7
/* 1711 */    MCD::OPC_FilterValue, 26, 4, 0, // Skip to: 1719
/* 1715 */    MCD::OPC_Decode, 197, 13, 7, // Opcode: X86SRL_W, DecodeIdx: 7
/* 1719 */    MCD::OPC_FilterValue, 27, 6, 0, // Skip to: 1729
/* 1723 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1725 */    MCD::OPC_Decode, 195, 13, 7, // Opcode: X86SRL_D, DecodeIdx: 7
/* 1729 */    MCD::OPC_FilterValue, 28, 4, 0, // Skip to: 1737
/* 1733 */    MCD::OPC_Decode, 186, 13, 7, // Opcode: X86SRA_B, DecodeIdx: 7
/* 1737 */    MCD::OPC_FilterValue, 29, 4, 0, // Skip to: 1745
/* 1741 */    MCD::OPC_Decode, 188, 13, 7, // Opcode: X86SRA_H, DecodeIdx: 7
/* 1745 */    MCD::OPC_FilterValue, 30, 4, 0, // Skip to: 1753
/* 1749 */    MCD::OPC_Decode, 189, 13, 7, // Opcode: X86SRA_W, DecodeIdx: 7
/* 1753 */    MCD::OPC_FilterValueOrFail, 31, 
/* 1755 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1757 */    MCD::OPC_Decode, 187, 13, 7, // Opcode: X86SRA_D, DecodeIdx: 7
/* 1761 */    MCD::OPC_FilterValueOrFail, 7, 
/* 1763 */    MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 1766 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 1774
/* 1770 */    MCD::OPC_Decode, 164, 13, 7, // Opcode: X86ROTR_B, DecodeIdx: 7
/* 1774 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 1782
/* 1778 */    MCD::OPC_Decode, 166, 13, 7, // Opcode: X86ROTR_H, DecodeIdx: 7
/* 1782 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 1792
/* 1786 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1788 */    MCD::OPC_Decode, 165, 13, 7, // Opcode: X86ROTR_D, DecodeIdx: 7
/* 1792 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 1800
/* 1796 */    MCD::OPC_Decode, 167, 13, 7, // Opcode: X86ROTR_W, DecodeIdx: 7
/* 1800 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 1808
/* 1804 */    MCD::OPC_Decode, 156, 13, 7, // Opcode: X86ROTL_B, DecodeIdx: 7
/* 1808 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 1816
/* 1812 */    MCD::OPC_Decode, 158, 13, 7, // Opcode: X86ROTL_H, DecodeIdx: 7
/* 1816 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 1824
/* 1820 */    MCD::OPC_Decode, 159, 13, 7, // Opcode: X86ROTL_W, DecodeIdx: 7
/* 1824 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 1834
/* 1828 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1830 */    MCD::OPC_Decode, 157, 13, 7, // Opcode: X86ROTL_D, DecodeIdx: 7
/* 1834 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 1842
/* 1838 */    MCD::OPC_Decode, 148, 13, 7, // Opcode: X86RCR_B, DecodeIdx: 7
/* 1842 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 1850
/* 1846 */    MCD::OPC_Decode, 150, 13, 7, // Opcode: X86RCR_H, DecodeIdx: 7
/* 1850 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 1858
/* 1854 */    MCD::OPC_Decode, 151, 13, 7, // Opcode: X86RCR_W, DecodeIdx: 7
/* 1858 */    MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 1868
/* 1862 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1864 */    MCD::OPC_Decode, 149, 13, 7, // Opcode: X86RCR_D, DecodeIdx: 7
/* 1868 */    MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 1876
/* 1872 */    MCD::OPC_Decode, 140, 13, 7, // Opcode: X86RCL_B, DecodeIdx: 7
/* 1876 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 1884
/* 1880 */    MCD::OPC_Decode, 142, 13, 7, // Opcode: X86RCL_H, DecodeIdx: 7
/* 1884 */    MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 1892
/* 1888 */    MCD::OPC_Decode, 143, 13, 7, // Opcode: X86RCL_W, DecodeIdx: 7
/* 1892 */    MCD::OPC_FilterValue, 15, 6, 0, // Skip to: 1902
/* 1896 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1898 */    MCD::OPC_Decode, 141, 13, 7, // Opcode: X86RCL_D, DecodeIdx: 7
/* 1902 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 1910
/* 1906 */    MCD::OPC_Decode, 233, 12, 7, // Opcode: X86AND_B, DecodeIdx: 7
/* 1910 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 1918
/* 1914 */    MCD::OPC_Decode, 235, 12, 7, // Opcode: X86AND_H, DecodeIdx: 7
/* 1918 */    MCD::OPC_FilterValue, 18, 4, 0, // Skip to: 1926
/* 1922 */    MCD::OPC_Decode, 236, 12, 7, // Opcode: X86AND_W, DecodeIdx: 7
/* 1926 */    MCD::OPC_FilterValue, 19, 6, 0, // Skip to: 1936
/* 1930 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1932 */    MCD::OPC_Decode, 234, 12, 7, // Opcode: X86AND_D, DecodeIdx: 7
/* 1936 */    MCD::OPC_FilterValue, 20, 4, 0, // Skip to: 1944
/* 1940 */    MCD::OPC_Decode, 132, 13, 7, // Opcode: X86OR_B, DecodeIdx: 7
/* 1944 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 1952
/* 1948 */    MCD::OPC_Decode, 134, 13, 7, // Opcode: X86OR_H, DecodeIdx: 7
/* 1952 */    MCD::OPC_FilterValue, 22, 4, 0, // Skip to: 1960
/* 1956 */    MCD::OPC_Decode, 135, 13, 7, // Opcode: X86OR_W, DecodeIdx: 7
/* 1960 */    MCD::OPC_FilterValue, 23, 6, 0, // Skip to: 1970
/* 1964 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 1966 */    MCD::OPC_Decode, 133, 13, 7, // Opcode: X86OR_D, DecodeIdx: 7
/* 1970 */    MCD::OPC_FilterValue, 24, 4, 0, // Skip to: 1978
/* 1974 */    MCD::OPC_Decode, 204, 13, 7, // Opcode: X86XOR_B, DecodeIdx: 7
/* 1978 */    MCD::OPC_FilterValue, 25, 4, 0, // Skip to: 1986
/* 1982 */    MCD::OPC_Decode, 206, 13, 7, // Opcode: X86XOR_H, DecodeIdx: 7
/* 1986 */    MCD::OPC_FilterValue, 26, 4, 0, // Skip to: 1994
/* 1990 */    MCD::OPC_Decode, 207, 13, 7, // Opcode: X86XOR_W, DecodeIdx: 7
/* 1994 */    MCD::OPC_FilterValue, 27, 6, 0, // Skip to: 2004
/* 1998 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2000 */    MCD::OPC_Decode, 205, 13, 7, // Opcode: X86XOR_D, DecodeIdx: 7
/* 2004 */    MCD::OPC_FilterValue, 28, 8, 0, // Skip to: 2016
/* 2008 */    MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 2012 */    MCD::OPC_Decode, 254, 3, 18, // Opcode: ARMNOT_W, DecodeIdx: 18
/* 2016 */    MCD::OPC_FilterValue, 29, 8, 0, // Skip to: 2028
/* 2020 */    MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 2024 */    MCD::OPC_Decode, 252, 3, 18, // Opcode: ARMMOV_W, DecodeIdx: 18
/* 2028 */    MCD::OPC_FilterValue, 30, 10, 0, // Skip to: 2042
/* 2032 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2034 */    MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 2038 */    MCD::OPC_Decode, 251, 3, 18, // Opcode: ARMMOV_D, DecodeIdx: 18
/* 2042 */    MCD::OPC_FilterValueOrFail, 31, 
/* 2044 */    MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 2048 */    MCD::OPC_Decode, 130, 4, 18, // Opcode: ARMRRX_W, DecodeIdx: 18
/* 2052 */    MCD::OPC_FilterValue, 1, 102, 2, // Skip to: 2670
/* 2056 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 2059 */    MCD::OPC_FilterValue, 0, 76, 2, // Skip to: 2651
/* 2063 */    MCD::OPC_ExtractField, 18, 3,  // Inst{20-18} ...
/* 2066 */    MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 2093
/* 2070 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2073 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 2085
/* 2077 */    MCD::OPC_CheckFieldOrFail, 15, 1, 1, 
/* 2081 */    MCD::OPC_Decode, 217, 6, 19, // Opcode: SLLI_W, DecodeIdx: 19
/* 2085 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2087 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2089 */    MCD::OPC_Decode, 216, 6, 20, // Opcode: SLLI_D, DecodeIdx: 20
/* 2093 */    MCD::OPC_FilterValue, 1, 23, 0, // Skip to: 2120
/* 2097 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2100 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 2112
/* 2104 */    MCD::OPC_CheckFieldOrFail, 15, 1, 1, 
/* 2108 */    MCD::OPC_Decode, 229, 6, 19, // Opcode: SRLI_W, DecodeIdx: 19
/* 2112 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2114 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2116 */    MCD::OPC_Decode, 228, 6, 20, // Opcode: SRLI_D, DecodeIdx: 20
/* 2120 */    MCD::OPC_FilterValue, 2, 23, 0, // Skip to: 2147
/* 2124 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2127 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 2139
/* 2131 */    MCD::OPC_CheckFieldOrFail, 15, 1, 1, 
/* 2135 */    MCD::OPC_Decode, 225, 6, 19, // Opcode: SRAI_W, DecodeIdx: 19
/* 2139 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2141 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2143 */    MCD::OPC_Decode, 224, 6, 20, // Opcode: SRAI_D, DecodeIdx: 20
/* 2147 */    MCD::OPC_FilterValue, 3, 49, 0, // Skip to: 2200
/* 2151 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2154 */    MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 2192
/* 2158 */    MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 2161 */    MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 2186
/* 2165 */    MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 2168 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 2180
/* 2172 */    MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 2176 */    MCD::OPC_Decode, 193, 6, 21, // Opcode: ROTRI_B, DecodeIdx: 21
/* 2180 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2182 */    MCD::OPC_Decode, 195, 6, 14, // Opcode: ROTRI_H, DecodeIdx: 14
/* 2186 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2188 */    MCD::OPC_Decode, 196, 6, 19, // Opcode: ROTRI_W, DecodeIdx: 19
/* 2192 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2194 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2196 */    MCD::OPC_Decode, 194, 6, 20, // Opcode: ROTRI_D, DecodeIdx: 20
/* 2200 */    MCD::OPC_FilterValue, 4, 49, 0, // Skip to: 2253
/* 2204 */    MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 2207 */    MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 2245
/* 2211 */    MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 2214 */    MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 2239
/* 2218 */    MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 2221 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 2233
/* 2225 */    MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 2229 */    MCD::OPC_Decode, 176, 6, 21, // Opcode: RCRI_B, DecodeIdx: 21
/* 2233 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2235 */    MCD::OPC_Decode, 178, 6, 14, // Opcode: RCRI_H, DecodeIdx: 14
/* 2239 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2241 */    MCD::OPC_Decode, 179, 6, 19, // Opcode: RCRI_W, DecodeIdx: 19
/* 2245 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2247 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2249 */    MCD::OPC_Decode, 177, 6, 20, // Opcode: RCRI_D, DecodeIdx: 20
/* 2253 */    MCD::OPC_FilterValue, 5, 95, 1, // Skip to: 2608
/* 2257 */    MCD::OPC_ExtractField, 0, 5,  // Inst{4-0} ...
/* 2260 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 2272
/* 2264 */    MCD::OPC_CheckFieldOrFail, 13, 5, 1, 
/* 2268 */    MCD::OPC_Decode, 174, 13, 22, // Opcode: X86SLLI_B, DecodeIdx: 22
/* 2272 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 2284
/* 2276 */    MCD::OPC_CheckFieldOrFail, 14, 4, 1, 
/* 2280 */    MCD::OPC_Decode, 176, 13, 18, // Opcode: X86SLLI_H, DecodeIdx: 18
/* 2284 */    MCD::OPC_FilterValue, 2, 8, 0, // Skip to: 2296
/* 2288 */    MCD::OPC_CheckFieldOrFail, 15, 3, 1, 
/* 2292 */    MCD::OPC_Decode, 177, 13, 23, // Opcode: X86SLLI_W, DecodeIdx: 23
/* 2296 */    MCD::OPC_FilterValue, 3, 10, 0, // Skip to: 2310
/* 2300 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2302 */    MCD::OPC_CheckFieldOrFail, 16, 2, 1, 
/* 2306 */    MCD::OPC_Decode, 175, 13, 24, // Opcode: X86SLLI_D, DecodeIdx: 24
/* 2310 */    MCD::OPC_FilterValue, 4, 8, 0, // Skip to: 2322
/* 2314 */    MCD::OPC_CheckFieldOrFail, 13, 5, 1, 
/* 2318 */    MCD::OPC_Decode, 190, 13, 22, // Opcode: X86SRLI_B, DecodeIdx: 22
/* 2322 */    MCD::OPC_FilterValue, 5, 8, 0, // Skip to: 2334
/* 2326 */    MCD::OPC_CheckFieldOrFail, 14, 4, 1, 
/* 2330 */    MCD::OPC_Decode, 192, 13, 18, // Opcode: X86SRLI_H, DecodeIdx: 18
/* 2334 */    MCD::OPC_FilterValue, 6, 8, 0, // Skip to: 2346
/* 2338 */    MCD::OPC_CheckFieldOrFail, 15, 3, 1, 
/* 2342 */    MCD::OPC_Decode, 193, 13, 23, // Opcode: X86SRLI_W, DecodeIdx: 23
/* 2346 */    MCD::OPC_FilterValue, 7, 10, 0, // Skip to: 2360
/* 2350 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2352 */    MCD::OPC_CheckFieldOrFail, 16, 2, 1, 
/* 2356 */    MCD::OPC_Decode, 191, 13, 24, // Opcode: X86SRLI_D, DecodeIdx: 24
/* 2360 */    MCD::OPC_FilterValue, 8, 8, 0, // Skip to: 2372
/* 2364 */    MCD::OPC_CheckFieldOrFail, 13, 5, 1, 
/* 2368 */    MCD::OPC_Decode, 182, 13, 22, // Opcode: X86SRAI_B, DecodeIdx: 22
/* 2372 */    MCD::OPC_FilterValue, 9, 8, 0, // Skip to: 2384
/* 2376 */    MCD::OPC_CheckFieldOrFail, 14, 4, 1, 
/* 2380 */    MCD::OPC_Decode, 184, 13, 18, // Opcode: X86SRAI_H, DecodeIdx: 18
/* 2384 */    MCD::OPC_FilterValue, 10, 8, 0, // Skip to: 2396
/* 2388 */    MCD::OPC_CheckFieldOrFail, 15, 3, 1, 
/* 2392 */    MCD::OPC_Decode, 185, 13, 23, // Opcode: X86SRAI_W, DecodeIdx: 23
/* 2396 */    MCD::OPC_FilterValue, 11, 10, 0, // Skip to: 2410
/* 2400 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2402 */    MCD::OPC_CheckFieldOrFail, 16, 2, 1, 
/* 2406 */    MCD::OPC_Decode, 183, 13, 24, // Opcode: X86SRAI_D, DecodeIdx: 24
/* 2410 */    MCD::OPC_FilterValue, 12, 8, 0, // Skip to: 2422
/* 2414 */    MCD::OPC_CheckFieldOrFail, 13, 5, 1, 
/* 2418 */    MCD::OPC_Decode, 160, 13, 22, // Opcode: X86ROTRI_B, DecodeIdx: 22
/* 2422 */    MCD::OPC_FilterValue, 13, 8, 0, // Skip to: 2434
/* 2426 */    MCD::OPC_CheckFieldOrFail, 14, 4, 1, 
/* 2430 */    MCD::OPC_Decode, 162, 13, 18, // Opcode: X86ROTRI_H, DecodeIdx: 18
/* 2434 */    MCD::OPC_FilterValue, 14, 8, 0, // Skip to: 2446
/* 2438 */    MCD::OPC_CheckFieldOrFail, 15, 3, 1, 
/* 2442 */    MCD::OPC_Decode, 163, 13, 23, // Opcode: X86ROTRI_W, DecodeIdx: 23
/* 2446 */    MCD::OPC_FilterValue, 15, 10, 0, // Skip to: 2460
/* 2450 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2452 */    MCD::OPC_CheckFieldOrFail, 16, 2, 1, 
/* 2456 */    MCD::OPC_Decode, 161, 13, 24, // Opcode: X86ROTRI_D, DecodeIdx: 24
/* 2460 */    MCD::OPC_FilterValue, 16, 8, 0, // Skip to: 2472
/* 2464 */    MCD::OPC_CheckFieldOrFail, 13, 5, 1, 
/* 2468 */    MCD::OPC_Decode, 144, 13, 22, // Opcode: X86RCRI_B, DecodeIdx: 22
/* 2472 */    MCD::OPC_FilterValue, 17, 8, 0, // Skip to: 2484
/* 2476 */    MCD::OPC_CheckFieldOrFail, 14, 4, 1, 
/* 2480 */    MCD::OPC_Decode, 146, 13, 18, // Opcode: X86RCRI_H, DecodeIdx: 18
/* 2484 */    MCD::OPC_FilterValue, 18, 8, 0, // Skip to: 2496
/* 2488 */    MCD::OPC_CheckFieldOrFail, 15, 3, 1, 
/* 2492 */    MCD::OPC_Decode, 147, 13, 23, // Opcode: X86RCRI_W, DecodeIdx: 23
/* 2496 */    MCD::OPC_FilterValue, 19, 10, 0, // Skip to: 2510
/* 2500 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2502 */    MCD::OPC_CheckFieldOrFail, 16, 2, 1, 
/* 2506 */    MCD::OPC_Decode, 145, 13, 24, // Opcode: X86RCRI_D, DecodeIdx: 24
/* 2510 */    MCD::OPC_FilterValue, 20, 8, 0, // Skip to: 2522
/* 2514 */    MCD::OPC_CheckFieldOrFail, 13, 5, 1, 
/* 2518 */    MCD::OPC_Decode, 152, 13, 22, // Opcode: X86ROTLI_B, DecodeIdx: 22
/* 2522 */    MCD::OPC_FilterValue, 21, 8, 0, // Skip to: 2534
/* 2526 */    MCD::OPC_CheckFieldOrFail, 14, 4, 1, 
/* 2530 */    MCD::OPC_Decode, 154, 13, 18, // Opcode: X86ROTLI_H, DecodeIdx: 18
/* 2534 */    MCD::OPC_FilterValue, 22, 8, 0, // Skip to: 2546
/* 2538 */    MCD::OPC_CheckFieldOrFail, 15, 3, 1, 
/* 2542 */    MCD::OPC_Decode, 155, 13, 23, // Opcode: X86ROTLI_W, DecodeIdx: 23
/* 2546 */    MCD::OPC_FilterValue, 23, 10, 0, // Skip to: 2560
/* 2550 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2552 */    MCD::OPC_CheckFieldOrFail, 16, 2, 1, 
/* 2556 */    MCD::OPC_Decode, 153, 13, 24, // Opcode: X86ROTLI_D, DecodeIdx: 24
/* 2560 */    MCD::OPC_FilterValue, 24, 8, 0, // Skip to: 2572
/* 2564 */    MCD::OPC_CheckFieldOrFail, 13, 5, 1, 
/* 2568 */    MCD::OPC_Decode, 136, 13, 22, // Opcode: X86RCLI_B, DecodeIdx: 22
/* 2572 */    MCD::OPC_FilterValue, 25, 8, 0, // Skip to: 2584
/* 2576 */    MCD::OPC_CheckFieldOrFail, 14, 4, 1, 
/* 2580 */    MCD::OPC_Decode, 138, 13, 18, // Opcode: X86RCLI_H, DecodeIdx: 18
/* 2584 */    MCD::OPC_FilterValue, 26, 8, 0, // Skip to: 2596
/* 2588 */    MCD::OPC_CheckFieldOrFail, 15, 3, 1, 
/* 2592 */    MCD::OPC_Decode, 139, 13, 23, // Opcode: X86RCLI_W, DecodeIdx: 23
/* 2596 */    MCD::OPC_FilterValueOrFail, 27, 
/* 2598 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2600 */    MCD::OPC_CheckFieldOrFail, 16, 2, 1, 
/* 2604 */    MCD::OPC_Decode, 137, 13, 24, // Opcode: X86RCLI_D, DecodeIdx: 24
/* 2608 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 2616
/* 2612 */    MCD::OPC_Decode, 172, 13, 25, // Opcode: X86SETTAG, DecodeIdx: 25
/* 2616 */    MCD::OPC_FilterValueOrFail, 7, 
/* 2618 */    MCD::OPC_ExtractField, 5, 5,  // Inst{9-5} ...
/* 2621 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 2629
/* 2625 */    MCD::OPC_Decode, 248, 12, 26, // Opcode: X86MFFLAG, DecodeIdx: 26
/* 2629 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 2637
/* 2633 */    MCD::OPC_Decode, 250, 12, 26, // Opcode: X86MTFLAG, DecodeIdx: 26
/* 2637 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 2645
/* 2641 */    MCD::OPC_Decode, 249, 3, 26, // Opcode: ARMMFFLAG, DecodeIdx: 26
/* 2645 */    MCD::OPC_FilterValueOrFail, 3, 
/* 2647 */    MCD::OPC_Decode, 253, 3, 26, // Opcode: ARMMTFLAG, DecodeIdx: 26
/* 2651 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2653 */    MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 2656 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 2664
/* 2660 */    MCD::OPC_Decode, 160, 4, 27, // Opcode: BSTRINS_W, DecodeIdx: 27
/* 2664 */    MCD::OPC_FilterValueOrFail, 1, 
/* 2666 */    MCD::OPC_Decode, 162, 4, 28, // Opcode: BSTRPICK_W, DecodeIdx: 28
/* 2670 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 2680
/* 2674 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2676 */    MCD::OPC_Decode, 159, 4, 29, // Opcode: BSTRINS_D, DecodeIdx: 29
/* 2680 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 2690
/* 2684 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 2686 */    MCD::OPC_Decode, 161, 4, 30, // Opcode: BSTRPICK_D, DecodeIdx: 30
/* 2690 */    MCD::OPC_FilterValue, 4, 197, 2, // Skip to: 3403
/* 2694 */    MCD::OPC_ExtractField, 15, 7,  // Inst{21-15} ...
/* 2697 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 2705
/* 2701 */    MCD::OPC_Decode, 198, 4, 31, // Opcode: FADD_S, DecodeIdx: 31
/* 2705 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 2713
/* 2709 */    MCD::OPC_Decode, 197, 4, 32, // Opcode: FADD_D, DecodeIdx: 32
/* 2713 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 2721
/* 2717 */    MCD::OPC_Decode, 187, 5, 31, // Opcode: FSUB_S, DecodeIdx: 31
/* 2721 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 2729
/* 2725 */    MCD::OPC_Decode, 186, 5, 32, // Opcode: FSUB_D, DecodeIdx: 32
/* 2729 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 2737
/* 2733 */    MCD::OPC_Decode, 155, 5, 31, // Opcode: FMUL_S, DecodeIdx: 31
/* 2737 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 2745
/* 2741 */    MCD::OPC_Decode, 154, 5, 32, // Opcode: FMUL_D, DecodeIdx: 32
/* 2745 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 2753
/* 2749 */    MCD::OPC_Decode, 253, 4, 31, // Opcode: FDIV_S, DecodeIdx: 31
/* 2753 */    MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 2761
/* 2757 */    MCD::OPC_Decode, 252, 4, 32, // Opcode: FDIV_D, DecodeIdx: 32
/* 2761 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 2769
/* 2765 */    MCD::OPC_Decode, 145, 5, 31, // Opcode: FMAX_S, DecodeIdx: 31
/* 2769 */    MCD::OPC_FilterValue, 18, 4, 0, // Skip to: 2777
/* 2773 */    MCD::OPC_Decode, 144, 5, 32, // Opcode: FMAX_D, DecodeIdx: 32
/* 2777 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 2785
/* 2781 */    MCD::OPC_Decode, 149, 5, 31, // Opcode: FMIN_S, DecodeIdx: 31
/* 2785 */    MCD::OPC_FilterValue, 22, 4, 0, // Skip to: 2793
/* 2789 */    MCD::OPC_Decode, 148, 5, 32, // Opcode: FMIN_D, DecodeIdx: 32
/* 2793 */    MCD::OPC_FilterValue, 25, 4, 0, // Skip to: 2801
/* 2797 */    MCD::OPC_Decode, 143, 5, 31, // Opcode: FMAXA_S, DecodeIdx: 31
/* 2801 */    MCD::OPC_FilterValue, 26, 4, 0, // Skip to: 2809
/* 2805 */    MCD::OPC_Decode, 142, 5, 32, // Opcode: FMAXA_D, DecodeIdx: 32
/* 2809 */    MCD::OPC_FilterValue, 29, 4, 0, // Skip to: 2817
/* 2813 */    MCD::OPC_Decode, 147, 5, 31, // Opcode: FMINA_S, DecodeIdx: 31
/* 2817 */    MCD::OPC_FilterValue, 30, 4, 0, // Skip to: 2825
/* 2821 */    MCD::OPC_Decode, 146, 5, 32, // Opcode: FMINA_D, DecodeIdx: 32
/* 2825 */    MCD::OPC_FilterValue, 33, 4, 0, // Skip to: 2833
/* 2829 */    MCD::OPC_Decode, 173, 5, 31, // Opcode: FSCALEB_S, DecodeIdx: 31
/* 2833 */    MCD::OPC_FilterValue, 34, 4, 0, // Skip to: 2841
/* 2837 */    MCD::OPC_Decode, 172, 5, 32, // Opcode: FSCALEB_D, DecodeIdx: 32
/* 2841 */    MCD::OPC_FilterValue, 37, 4, 0, // Skip to: 2849
/* 2845 */    MCD::OPC_Decode, 246, 4, 31, // Opcode: FCOPYSIGN_S, DecodeIdx: 31
/* 2849 */    MCD::OPC_FilterValue, 38, 4, 0, // Skip to: 2857
/* 2853 */    MCD::OPC_Decode, 245, 4, 32, // Opcode: FCOPYSIGN_D, DecodeIdx: 32
/* 2857 */    MCD::OPC_FilterValue, 40, 129, 0, // Skip to: 2990
/* 2861 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 2864 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 2872
/* 2868 */    MCD::OPC_Decode, 196, 4, 33, // Opcode: FABS_S, DecodeIdx: 33
/* 2872 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 2880
/* 2876 */    MCD::OPC_Decode, 195, 4, 34, // Opcode: FABS_D, DecodeIdx: 34
/* 2880 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 2888
/* 2884 */    MCD::OPC_Decode, 157, 5, 33, // Opcode: FNEG_S, DecodeIdx: 33
/* 2888 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 2896
/* 2892 */    MCD::OPC_Decode, 156, 5, 34, // Opcode: FNEG_D, DecodeIdx: 34
/* 2896 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 2904
/* 2900 */    MCD::OPC_Decode, 139, 5, 33, // Opcode: FLOGB_S, DecodeIdx: 33
/* 2904 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 2912
/* 2908 */    MCD::OPC_Decode, 138, 5, 34, // Opcode: FLOGB_D, DecodeIdx: 34
/* 2912 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 2920
/* 2916 */    MCD::OPC_Decode, 200, 4, 33, // Opcode: FCLASS_S, DecodeIdx: 33
/* 2920 */    MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 2928
/* 2924 */    MCD::OPC_Decode, 199, 4, 34, // Opcode: FCLASS_D, DecodeIdx: 34
/* 2928 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 2936
/* 2932 */    MCD::OPC_Decode, 177, 5, 33, // Opcode: FSQRT_S, DecodeIdx: 33
/* 2936 */    MCD::OPC_FilterValue, 18, 4, 0, // Skip to: 2944
/* 2940 */    MCD::OPC_Decode, 176, 5, 34, // Opcode: FSQRT_D, DecodeIdx: 34
/* 2944 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 2952
/* 2948 */    MCD::OPC_Decode, 165, 5, 33, // Opcode: FRECIP_S, DecodeIdx: 33
/* 2952 */    MCD::OPC_FilterValue, 22, 4, 0, // Skip to: 2960
/* 2956 */    MCD::OPC_Decode, 164, 5, 34, // Opcode: FRECIP_D, DecodeIdx: 34
/* 2960 */    MCD::OPC_FilterValue, 25, 4, 0, // Skip to: 2968
/* 2964 */    MCD::OPC_Decode, 171, 5, 33, // Opcode: FRSQRT_S, DecodeIdx: 33
/* 2968 */    MCD::OPC_FilterValue, 26, 4, 0, // Skip to: 2976
/* 2972 */    MCD::OPC_Decode, 170, 5, 34, // Opcode: FRSQRT_D, DecodeIdx: 34
/* 2976 */    MCD::OPC_FilterValue, 29, 4, 0, // Skip to: 2984
/* 2980 */    MCD::OPC_Decode, 163, 5, 33, // Opcode: FRECIPE_S, DecodeIdx: 33
/* 2984 */    MCD::OPC_FilterValueOrFail, 30, 
/* 2986 */    MCD::OPC_Decode, 162, 5, 34, // Opcode: FRECIPE_D, DecodeIdx: 34
/* 2990 */    MCD::OPC_FilterValue, 41, 149, 0, // Skip to: 3143
/* 2994 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 2997 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 3005
/* 3001 */    MCD::OPC_Decode, 169, 5, 33, // Opcode: FRSQRTE_S, DecodeIdx: 33
/* 3005 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 3013
/* 3009 */    MCD::OPC_Decode, 168, 5, 34, // Opcode: FRSQRTE_D, DecodeIdx: 34
/* 3013 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 3021
/* 3017 */    MCD::OPC_Decode, 151, 5, 33, // Opcode: FMOV_S, DecodeIdx: 33
/* 3021 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 3029
/* 3025 */    MCD::OPC_Decode, 150, 5, 34, // Opcode: FMOV_D, DecodeIdx: 34
/* 3029 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 3037
/* 3033 */    MCD::OPC_Decode, 154, 6, 35, // Opcode: MOVGR2FR_W, DecodeIdx: 35
/* 3037 */    MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 3047
/* 3041 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 3043 */    MCD::OPC_Decode, 153, 6, 36, // Opcode: MOVGR2FR_D, DecodeIdx: 36
/* 3047 */    MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 3055
/* 3051 */    MCD::OPC_Decode, 152, 6, 37, // Opcode: MOVGR2FRH_W, DecodeIdx: 37
/* 3055 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 3063
/* 3059 */    MCD::OPC_Decode, 147, 6, 38, // Opcode: MOVFR2GR_S, DecodeIdx: 38
/* 3063 */    MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 3073
/* 3067 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 3069 */    MCD::OPC_Decode, 146, 6, 39, // Opcode: MOVFR2GR_D, DecodeIdx: 39
/* 3073 */    MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 3081
/* 3077 */    MCD::OPC_Decode, 149, 6, 39, // Opcode: MOVFRH2GR_S, DecodeIdx: 39
/* 3081 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 3089
/* 3085 */    MCD::OPC_Decode, 151, 6, 40, // Opcode: MOVGR2FCSR, DecodeIdx: 40
/* 3089 */    MCD::OPC_FilterValue, 18, 4, 0, // Skip to: 3097
/* 3093 */    MCD::OPC_Decode, 144, 6, 41, // Opcode: MOVFCSR2GR, DecodeIdx: 41
/* 3097 */    MCD::OPC_FilterValue, 20, 4, 0, // Skip to: 3105
/* 3101 */    MCD::OPC_Decode, 145, 6, 42, // Opcode: MOVFR2CF_xS, DecodeIdx: 42
/* 3105 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 3113
/* 3109 */    MCD::OPC_Decode, 142, 6, 43, // Opcode: MOVCF2FR_xS, DecodeIdx: 43
/* 3113 */    MCD::OPC_FilterValue, 22, 4, 0, // Skip to: 3121
/* 3117 */    MCD::OPC_Decode, 150, 6, 44, // Opcode: MOVGR2CF, DecodeIdx: 44
/* 3121 */    MCD::OPC_FilterValue, 23, 4, 0, // Skip to: 3129
/* 3125 */    MCD::OPC_Decode, 143, 6, 45, // Opcode: MOVCF2GR, DecodeIdx: 45
/* 3129 */    MCD::OPC_FilterValue, 24, 4, 0, // Skip to: 3137
/* 3133 */    MCD::OPC_Decode, 249, 4, 33, // Opcode: FCVT_LD_D, DecodeIdx: 33
/* 3137 */    MCD::OPC_FilterValueOrFail, 25, 
/* 3139 */    MCD::OPC_Decode, 251, 4, 33, // Opcode: FCVT_UD_D, DecodeIdx: 33
/* 3143 */    MCD::OPC_FilterValue, 42, 4, 0, // Skip to: 3151
/* 3147 */    MCD::OPC_Decode, 247, 4, 31, // Opcode: FCVT_D_LD, DecodeIdx: 31
/* 3151 */    MCD::OPC_FilterValue, 50, 17, 0, // Skip to: 3172
/* 3155 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 3158 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 3166
/* 3162 */    MCD::OPC_Decode, 250, 4, 46, // Opcode: FCVT_S_D, DecodeIdx: 46
/* 3166 */    MCD::OPC_FilterValueOrFail, 9, 
/* 3168 */    MCD::OPC_Decode, 248, 4, 47, // Opcode: FCVT_D_S, DecodeIdx: 47
/* 3172 */    MCD::OPC_FilterValue, 52, 65, 0, // Skip to: 3241
/* 3176 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 3179 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 3187
/* 3183 */    MCD::OPC_Decode, 191, 5, 33, // Opcode: FTINTRM_W_S, DecodeIdx: 33
/* 3187 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 3195
/* 3191 */    MCD::OPC_Decode, 190, 5, 46, // Opcode: FTINTRM_W_D, DecodeIdx: 46
/* 3195 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 3203
/* 3199 */    MCD::OPC_Decode, 189, 5, 47, // Opcode: FTINTRM_L_S, DecodeIdx: 47
/* 3203 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 3211
/* 3207 */    MCD::OPC_Decode, 188, 5, 34, // Opcode: FTINTRM_L_D, DecodeIdx: 34
/* 3211 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 3219
/* 3215 */    MCD::OPC_Decode, 199, 5, 33, // Opcode: FTINTRP_W_S, DecodeIdx: 33
/* 3219 */    MCD::OPC_FilterValue, 18, 4, 0, // Skip to: 3227
/* 3223 */    MCD::OPC_Decode, 198, 5, 46, // Opcode: FTINTRP_W_D, DecodeIdx: 46
/* 3227 */    MCD::OPC_FilterValue, 25, 4, 0, // Skip to: 3235
/* 3231 */    MCD::OPC_Decode, 197, 5, 47, // Opcode: FTINTRP_L_S, DecodeIdx: 47
/* 3235 */    MCD::OPC_FilterValueOrFail, 26, 
/* 3237 */    MCD::OPC_Decode, 196, 5, 34, // Opcode: FTINTRP_L_D, DecodeIdx: 34
/* 3241 */    MCD::OPC_FilterValue, 53, 65, 0, // Skip to: 3310
/* 3245 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 3248 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 3256
/* 3252 */    MCD::OPC_Decode, 203, 5, 33, // Opcode: FTINTRZ_W_S, DecodeIdx: 33
/* 3256 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 3264
/* 3260 */    MCD::OPC_Decode, 202, 5, 46, // Opcode: FTINTRZ_W_D, DecodeIdx: 46
/* 3264 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 3272
/* 3268 */    MCD::OPC_Decode, 201, 5, 47, // Opcode: FTINTRZ_L_S, DecodeIdx: 47
/* 3272 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 3280
/* 3276 */    MCD::OPC_Decode, 200, 5, 34, // Opcode: FTINTRZ_L_D, DecodeIdx: 34
/* 3280 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 3288
/* 3284 */    MCD::OPC_Decode, 195, 5, 33, // Opcode: FTINTRNE_W_S, DecodeIdx: 33
/* 3288 */    MCD::OPC_FilterValue, 18, 4, 0, // Skip to: 3296
/* 3292 */    MCD::OPC_Decode, 194, 5, 46, // Opcode: FTINTRNE_W_D, DecodeIdx: 46
/* 3296 */    MCD::OPC_FilterValue, 25, 4, 0, // Skip to: 3304
/* 3300 */    MCD::OPC_Decode, 193, 5, 47, // Opcode: FTINTRNE_L_S, DecodeIdx: 47
/* 3304 */    MCD::OPC_FilterValueOrFail, 26, 
/* 3306 */    MCD::OPC_Decode, 192, 5, 34, // Opcode: FTINTRNE_L_D, DecodeIdx: 34
/* 3310 */    MCD::OPC_FilterValue, 54, 33, 0, // Skip to: 3347
/* 3314 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 3317 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 3325
/* 3321 */    MCD::OPC_Decode, 207, 5, 33, // Opcode: FTINT_W_S, DecodeIdx: 33
/* 3325 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 3333
/* 3329 */    MCD::OPC_Decode, 206, 5, 46, // Opcode: FTINT_W_D, DecodeIdx: 46
/* 3333 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 3341
/* 3337 */    MCD::OPC_Decode, 205, 5, 47, // Opcode: FTINT_L_S, DecodeIdx: 47
/* 3341 */    MCD::OPC_FilterValueOrFail, 10, 
/* 3343 */    MCD::OPC_Decode, 204, 5, 34, // Opcode: FTINT_L_D, DecodeIdx: 34
/* 3347 */    MCD::OPC_FilterValue, 58, 33, 0, // Skip to: 3384
/* 3351 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 3354 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 3362
/* 3358 */    MCD::OPC_Decode, 129, 5, 33, // Opcode: FFINT_S_W, DecodeIdx: 33
/* 3362 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 3370
/* 3366 */    MCD::OPC_Decode, 128, 5, 46, // Opcode: FFINT_S_L, DecodeIdx: 46
/* 3370 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 3378
/* 3374 */    MCD::OPC_Decode, 255, 4, 47, // Opcode: FFINT_D_W, DecodeIdx: 47
/* 3378 */    MCD::OPC_FilterValueOrFail, 10, 
/* 3380 */    MCD::OPC_Decode, 254, 4, 34, // Opcode: FFINT_D_L, DecodeIdx: 34
/* 3384 */    MCD::OPC_FilterValueOrFail, 60, 
/* 3386 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 3389 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 3397
/* 3393 */    MCD::OPC_Decode, 167, 5, 33, // Opcode: FRINT_S, DecodeIdx: 33
/* 3397 */    MCD::OPC_FilterValueOrFail, 18, 
/* 3399 */    MCD::OPC_Decode, 166, 5, 34, // Opcode: FRINT_D, DecodeIdx: 34
/* 3403 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 3411
/* 3407 */    MCD::OPC_Decode, 221, 6, 48, // Opcode: SLTI, DecodeIdx: 48
/* 3411 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 3419
/* 3415 */    MCD::OPC_Decode, 223, 6, 48, // Opcode: SLTUI, DecodeIdx: 48
/* 3419 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 3427
/* 3423 */    MCD::OPC_Decode, 182, 3, 48, // Opcode: ADDI_W, DecodeIdx: 48
/* 3427 */    MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 3437
/* 3431 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 3433 */    MCD::OPC_Decode, 181, 3, 48, // Opcode: ADDI_D, DecodeIdx: 48
/* 3437 */    MCD::OPC_FilterValue, 12, 6, 0, // Skip to: 3447
/* 3441 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 3443 */    MCD::OPC_Decode, 135, 6, 48, // Opcode: LU52I_D, DecodeIdx: 48
/* 3447 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 3455
/* 3451 */    MCD::OPC_Decode, 244, 3, 49, // Opcode: ANDI, DecodeIdx: 49
/* 3455 */    MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 3463
/* 3459 */    MCD::OPC_Decode, 168, 6, 49, // Opcode: ORI, DecodeIdx: 49
/* 3463 */    MCD::OPC_FilterValueOrFail, 15, 
/* 3465 */    MCD::OPC_Decode, 209, 13, 49, // Opcode: XORI, DecodeIdx: 49
/* 3469 */    MCD::OPC_FilterValue, 1, 24, 1, // Skip to: 3753
/* 3473 */    MCD::OPC_ExtractField, 24, 2,  // Inst{25-24} ...
/* 3476 */    MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 3503
/* 3480 */    MCD::OPC_ExtractField, 5, 5,  // Inst{9-5} ...
/* 3483 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 3491
/* 3487 */    MCD::OPC_Decode, 179, 4, 50, // Opcode: CSRRD, DecodeIdx: 50
/* 3491 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 3499
/* 3495 */    MCD::OPC_Decode, 180, 4, 51, // Opcode: CSRWR, DecodeIdx: 51
/* 3499 */    MCD::OPC_Decode, 181, 4, 52, // Opcode: CSRXCHG, DecodeIdx: 52
/* 3503 */    MCD::OPC_FilterValue, 1, 23, 0, // Skip to: 3530
/* 3507 */    MCD::OPC_ExtractField, 5, 5,  // Inst{9-5} ...
/* 3510 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 3518
/* 3514 */    MCD::OPC_Decode, 208, 5, 50, // Opcode: GCSRRD, DecodeIdx: 50
/* 3518 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 3526
/* 3522 */    MCD::OPC_Decode, 209, 5, 51, // Opcode: GCSRWR, DecodeIdx: 51
/* 3526 */    MCD::OPC_Decode, 210, 5, 52, // Opcode: GCSRXCHG, DecodeIdx: 52
/* 3530 */    MCD::OPC_FilterValueOrFail, 2, 
/* 3532 */    MCD::OPC_ExtractField, 22, 2,  // Inst{23-22} ...
/* 3535 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 3543
/* 3539 */    MCD::OPC_Decode, 165, 4, 53, // Opcode: CACOP, DecodeIdx: 53
/* 3543 */    MCD::OPC_FilterValueOrFail, 1, 
/* 3545 */    MCD::OPC_ExtractField, 18, 4,  // Inst{21-18} ...
/* 3548 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 3556
/* 3552 */    MCD::OPC_Decode, 227, 5, 54, // Opcode: LDDIR, DecodeIdx: 54
/* 3556 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 3568
/* 3560 */    MCD::OPC_CheckFieldOrFail, 0, 5, 0, 
/* 3564 */    MCD::OPC_Decode, 238, 5, 55, // Opcode: LDPTE, DecodeIdx: 55
/* 3568 */    MCD::OPC_FilterValueOrFail, 2, 
/* 3570 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 3573 */    MCD::OPC_FilterValue, 0, 162, 0, // Skip to: 3739
/* 3577 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 3580 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 3588
/* 3584 */    MCD::OPC_Decode, 216, 5, 2, // Opcode: IOCSRRD_B, DecodeIdx: 2
/* 3588 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 3596
/* 3592 */    MCD::OPC_Decode, 218, 5, 2, // Opcode: IOCSRRD_H, DecodeIdx: 2
/* 3596 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 3604
/* 3600 */    MCD::OPC_Decode, 219, 5, 2, // Opcode: IOCSRRD_W, DecodeIdx: 2
/* 3604 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 3614
/* 3608 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 3610 */    MCD::OPC_Decode, 217, 5, 2, // Opcode: IOCSRRD_D, DecodeIdx: 2
/* 3614 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 3622
/* 3618 */    MCD::OPC_Decode, 220, 5, 2, // Opcode: IOCSRWR_B, DecodeIdx: 2
/* 3622 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 3630
/* 3626 */    MCD::OPC_Decode, 222, 5, 2, // Opcode: IOCSRWR_H, DecodeIdx: 2
/* 3630 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 3638
/* 3634 */    MCD::OPC_Decode, 223, 5, 2, // Opcode: IOCSRWR_W, DecodeIdx: 2
/* 3638 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 3648
/* 3642 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 3644 */    MCD::OPC_Decode, 221, 5, 2, // Opcode: IOCSRWR_D, DecodeIdx: 2
/* 3648 */    MCD::OPC_FilterValue, 8, 8, 0, // Skip to: 3660
/* 3652 */    MCD::OPC_CheckFieldOrFail, 0, 10, 0, 
/* 3656 */    MCD::OPC_Decode, 129, 7, 6, // Opcode: TLBCLR, DecodeIdx: 6
/* 3660 */    MCD::OPC_FilterValue, 9, 17, 0, // Skip to: 3681
/* 3664 */    MCD::OPC_ExtractField, 0, 10,  // Inst{9-0} ...
/* 3667 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 3675
/* 3671 */    MCD::OPC_Decode, 131, 7, 6, // Opcode: TLBFLUSH, DecodeIdx: 6
/* 3675 */    MCD::OPC_FilterValueOrFail, 1, 
/* 3677 */    MCD::OPC_Decode, 211, 5, 6, // Opcode: GTLBFLUSH, DecodeIdx: 6
/* 3681 */    MCD::OPC_FilterValue, 10, 8, 0, // Skip to: 3693
/* 3685 */    MCD::OPC_CheckFieldOrFail, 0, 10, 0, 
/* 3689 */    MCD::OPC_Decode, 133, 7, 6, // Opcode: TLBSRCH, DecodeIdx: 6
/* 3693 */    MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 3705
/* 3697 */    MCD::OPC_CheckFieldOrFail, 0, 10, 0, 
/* 3701 */    MCD::OPC_Decode, 132, 7, 6, // Opcode: TLBRD, DecodeIdx: 6
/* 3705 */    MCD::OPC_FilterValue, 12, 8, 0, // Skip to: 3717
/* 3709 */    MCD::OPC_CheckFieldOrFail, 0, 10, 0, 
/* 3713 */    MCD::OPC_Decode, 134, 7, 6, // Opcode: TLBWR, DecodeIdx: 6
/* 3717 */    MCD::OPC_FilterValue, 13, 8, 0, // Skip to: 3729
/* 3721 */    MCD::OPC_CheckFieldOrFail, 0, 10, 0, 
/* 3725 */    MCD::OPC_Decode, 130, 7, 6, // Opcode: TLBFILL, DecodeIdx: 6
/* 3729 */    MCD::OPC_FilterValueOrFail, 14, 
/* 3731 */    MCD::OPC_CheckFieldOrFail, 0, 10, 0, 
/* 3735 */    MCD::OPC_Decode, 192, 4, 6, // Opcode: ERTN, DecodeIdx: 6
/* 3739 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 3747
/* 3743 */    MCD::OPC_Decode, 214, 5, 13, // Opcode: IDLE, DecodeIdx: 13
/* 3747 */    MCD::OPC_FilterValueOrFail, 3, 
/* 3749 */    MCD::OPC_Decode, 215, 5, 56, // Opcode: INVTLB, DecodeIdx: 56
/* 3753 */    MCD::OPC_FilterValue, 2, 193, 0, // Skip to: 3950
/* 3757 */    MCD::OPC_ExtractField, 20, 6,  // Inst{25-20} ...
/* 3760 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 3768
/* 3764 */    MCD::OPC_Decode, 141, 5, 57, // Opcode: FMADD_S, DecodeIdx: 57
/* 3768 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 3776
/* 3772 */    MCD::OPC_Decode, 140, 5, 58, // Opcode: FMADD_D, DecodeIdx: 58
/* 3776 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 3784
/* 3780 */    MCD::OPC_Decode, 153, 5, 57, // Opcode: FMSUB_S, DecodeIdx: 57
/* 3784 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 3792
/* 3788 */    MCD::OPC_Decode, 152, 5, 58, // Opcode: FMSUB_D, DecodeIdx: 58
/* 3792 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 3800
/* 3796 */    MCD::OPC_Decode, 159, 5, 57, // Opcode: FNMADD_S, DecodeIdx: 57
/* 3800 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 3808
/* 3804 */    MCD::OPC_Decode, 158, 5, 58, // Opcode: FNMADD_D, DecodeIdx: 58
/* 3808 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 3816
/* 3812 */    MCD::OPC_Decode, 161, 5, 57, // Opcode: FNMSUB_S, DecodeIdx: 57
/* 3816 */    MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 3824
/* 3820 */    MCD::OPC_Decode, 160, 5, 58, // Opcode: FNMSUB_D, DecodeIdx: 58
/* 3824 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 3832
/* 3828 */    MCD::OPC_Decode, 207, 8, 59, // Opcode: VFMADD_S, DecodeIdx: 59
/* 3832 */    MCD::OPC_FilterValue, 18, 4, 0, // Skip to: 3840
/* 3836 */    MCD::OPC_Decode, 206, 8, 59, // Opcode: VFMADD_D, DecodeIdx: 59
/* 3840 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 3848
/* 3844 */    MCD::OPC_Decode, 217, 8, 59, // Opcode: VFMSUB_S, DecodeIdx: 59
/* 3848 */    MCD::OPC_FilterValue, 22, 4, 0, // Skip to: 3856
/* 3852 */    MCD::OPC_Decode, 216, 8, 59, // Opcode: VFMSUB_D, DecodeIdx: 59
/* 3856 */    MCD::OPC_FilterValue, 25, 4, 0, // Skip to: 3864
/* 3860 */    MCD::OPC_Decode, 221, 8, 59, // Opcode: VFNMADD_S, DecodeIdx: 59
/* 3864 */    MCD::OPC_FilterValue, 26, 4, 0, // Skip to: 3872
/* 3868 */    MCD::OPC_Decode, 220, 8, 59, // Opcode: VFNMADD_D, DecodeIdx: 59
/* 3872 */    MCD::OPC_FilterValue, 29, 4, 0, // Skip to: 3880
/* 3876 */    MCD::OPC_Decode, 223, 8, 59, // Opcode: VFNMSUB_S, DecodeIdx: 59
/* 3880 */    MCD::OPC_FilterValue, 30, 4, 0, // Skip to: 3888
/* 3884 */    MCD::OPC_Decode, 222, 8, 59, // Opcode: VFNMSUB_D, DecodeIdx: 59
/* 3888 */    MCD::OPC_FilterValue, 33, 4, 0, // Skip to: 3896
/* 3892 */    MCD::OPC_Decode, 142, 15, 60, // Opcode: XVFMADD_S, DecodeIdx: 60
/* 3896 */    MCD::OPC_FilterValue, 34, 4, 0, // Skip to: 3904
/* 3900 */    MCD::OPC_Decode, 141, 15, 60, // Opcode: XVFMADD_D, DecodeIdx: 60
/* 3904 */    MCD::OPC_FilterValue, 37, 4, 0, // Skip to: 3912
/* 3908 */    MCD::OPC_Decode, 152, 15, 60, // Opcode: XVFMSUB_S, DecodeIdx: 60
/* 3912 */    MCD::OPC_FilterValue, 38, 4, 0, // Skip to: 3920
/* 3916 */    MCD::OPC_Decode, 151, 15, 60, // Opcode: XVFMSUB_D, DecodeIdx: 60
/* 3920 */    MCD::OPC_FilterValue, 41, 4, 0, // Skip to: 3928
/* 3924 */    MCD::OPC_Decode, 156, 15, 60, // Opcode: XVFNMADD_S, DecodeIdx: 60
/* 3928 */    MCD::OPC_FilterValue, 42, 4, 0, // Skip to: 3936
/* 3932 */    MCD::OPC_Decode, 155, 15, 60, // Opcode: XVFNMADD_D, DecodeIdx: 60
/* 3936 */    MCD::OPC_FilterValue, 45, 4, 0, // Skip to: 3944
/* 3940 */    MCD::OPC_Decode, 158, 15, 60, // Opcode: XVFNMSUB_S, DecodeIdx: 60
/* 3944 */    MCD::OPC_FilterValueOrFail, 46, 
/* 3946 */    MCD::OPC_Decode, 157, 15, 60, // Opcode: XVFNMSUB_D, DecodeIdx: 60
/* 3950 */    MCD::OPC_FilterValue, 3, 27, 5, // Skip to: 5261
/* 3954 */    MCD::OPC_ExtractField, 20, 6,  // Inst{25-20} ...
/* 3957 */    MCD::OPC_FilterValue, 1, 9, 1, // Skip to: 4226
/* 3961 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 3964 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 3976
/* 3968 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 3972 */    MCD::OPC_Decode, 202, 4, 61, // Opcode: FCMP_CAF_S, DecodeIdx: 61
/* 3976 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 3988
/* 3980 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 3984 */    MCD::OPC_Decode, 224, 4, 61, // Opcode: FCMP_SAF_S, DecodeIdx: 61
/* 3988 */    MCD::OPC_FilterValue, 2, 8, 0, // Skip to: 4000
/* 3992 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 3996 */    MCD::OPC_Decode, 208, 4, 61, // Opcode: FCMP_CLT_S, DecodeIdx: 61
/* 4000 */    MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 4012
/* 4004 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4008 */    MCD::OPC_Decode, 230, 4, 61, // Opcode: FCMP_SLT_S, DecodeIdx: 61
/* 4012 */    MCD::OPC_FilterValue, 4, 8, 0, // Skip to: 4024
/* 4016 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4020 */    MCD::OPC_Decode, 204, 4, 61, // Opcode: FCMP_CEQ_S, DecodeIdx: 61
/* 4024 */    MCD::OPC_FilterValue, 5, 8, 0, // Skip to: 4036
/* 4028 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4032 */    MCD::OPC_Decode, 226, 4, 61, // Opcode: FCMP_SEQ_S, DecodeIdx: 61
/* 4036 */    MCD::OPC_FilterValue, 6, 8, 0, // Skip to: 4048
/* 4040 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4044 */    MCD::OPC_Decode, 206, 4, 61, // Opcode: FCMP_CLE_S, DecodeIdx: 61
/* 4048 */    MCD::OPC_FilterValue, 7, 8, 0, // Skip to: 4060
/* 4052 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4056 */    MCD::OPC_Decode, 228, 4, 61, // Opcode: FCMP_SLE_S, DecodeIdx: 61
/* 4060 */    MCD::OPC_FilterValue, 8, 8, 0, // Skip to: 4072
/* 4064 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4068 */    MCD::OPC_Decode, 222, 4, 61, // Opcode: FCMP_CUN_S, DecodeIdx: 61
/* 4072 */    MCD::OPC_FilterValue, 9, 8, 0, // Skip to: 4084
/* 4076 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4080 */    MCD::OPC_Decode, 244, 4, 61, // Opcode: FCMP_SUN_S, DecodeIdx: 61
/* 4084 */    MCD::OPC_FilterValue, 10, 8, 0, // Skip to: 4096
/* 4088 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4092 */    MCD::OPC_Decode, 218, 4, 61, // Opcode: FCMP_CULT_S, DecodeIdx: 61
/* 4096 */    MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 4108
/* 4100 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4104 */    MCD::OPC_Decode, 240, 4, 61, // Opcode: FCMP_SULT_S, DecodeIdx: 61
/* 4108 */    MCD::OPC_FilterValue, 12, 8, 0, // Skip to: 4120
/* 4112 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4116 */    MCD::OPC_Decode, 214, 4, 61, // Opcode: FCMP_CUEQ_S, DecodeIdx: 61
/* 4120 */    MCD::OPC_FilterValue, 13, 8, 0, // Skip to: 4132
/* 4124 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4128 */    MCD::OPC_Decode, 236, 4, 61, // Opcode: FCMP_SUEQ_S, DecodeIdx: 61
/* 4132 */    MCD::OPC_FilterValue, 14, 8, 0, // Skip to: 4144
/* 4136 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4140 */    MCD::OPC_Decode, 216, 4, 61, // Opcode: FCMP_CULE_S, DecodeIdx: 61
/* 4144 */    MCD::OPC_FilterValue, 15, 8, 0, // Skip to: 4156
/* 4148 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4152 */    MCD::OPC_Decode, 238, 4, 61, // Opcode: FCMP_SULE_S, DecodeIdx: 61
/* 4156 */    MCD::OPC_FilterValue, 16, 8, 0, // Skip to: 4168
/* 4160 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4164 */    MCD::OPC_Decode, 210, 4, 61, // Opcode: FCMP_CNE_S, DecodeIdx: 61
/* 4168 */    MCD::OPC_FilterValue, 17, 8, 0, // Skip to: 4180
/* 4172 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4176 */    MCD::OPC_Decode, 232, 4, 61, // Opcode: FCMP_SNE_S, DecodeIdx: 61
/* 4180 */    MCD::OPC_FilterValue, 20, 8, 0, // Skip to: 4192
/* 4184 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4188 */    MCD::OPC_Decode, 212, 4, 61, // Opcode: FCMP_COR_S, DecodeIdx: 61
/* 4192 */    MCD::OPC_FilterValue, 21, 8, 0, // Skip to: 4204
/* 4196 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4200 */    MCD::OPC_Decode, 234, 4, 61, // Opcode: FCMP_SOR_S, DecodeIdx: 61
/* 4204 */    MCD::OPC_FilterValue, 24, 8, 0, // Skip to: 4216
/* 4208 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4212 */    MCD::OPC_Decode, 220, 4, 61, // Opcode: FCMP_CUNE_S, DecodeIdx: 61
/* 4216 */    MCD::OPC_FilterValueOrFail, 25, 
/* 4218 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4222 */    MCD::OPC_Decode, 242, 4, 61, // Opcode: FCMP_SUNE_S, DecodeIdx: 61
/* 4226 */    MCD::OPC_FilterValue, 2, 9, 1, // Skip to: 4495
/* 4230 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 4233 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 4245
/* 4237 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4241 */    MCD::OPC_Decode, 201, 4, 62, // Opcode: FCMP_CAF_D, DecodeIdx: 62
/* 4245 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 4257
/* 4249 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4253 */    MCD::OPC_Decode, 223, 4, 62, // Opcode: FCMP_SAF_D, DecodeIdx: 62
/* 4257 */    MCD::OPC_FilterValue, 2, 8, 0, // Skip to: 4269
/* 4261 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4265 */    MCD::OPC_Decode, 207, 4, 62, // Opcode: FCMP_CLT_D, DecodeIdx: 62
/* 4269 */    MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 4281
/* 4273 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4277 */    MCD::OPC_Decode, 229, 4, 62, // Opcode: FCMP_SLT_D, DecodeIdx: 62
/* 4281 */    MCD::OPC_FilterValue, 4, 8, 0, // Skip to: 4293
/* 4285 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4289 */    MCD::OPC_Decode, 203, 4, 62, // Opcode: FCMP_CEQ_D, DecodeIdx: 62
/* 4293 */    MCD::OPC_FilterValue, 5, 8, 0, // Skip to: 4305
/* 4297 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4301 */    MCD::OPC_Decode, 225, 4, 62, // Opcode: FCMP_SEQ_D, DecodeIdx: 62
/* 4305 */    MCD::OPC_FilterValue, 6, 8, 0, // Skip to: 4317
/* 4309 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4313 */    MCD::OPC_Decode, 205, 4, 62, // Opcode: FCMP_CLE_D, DecodeIdx: 62
/* 4317 */    MCD::OPC_FilterValue, 7, 8, 0, // Skip to: 4329
/* 4321 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4325 */    MCD::OPC_Decode, 227, 4, 62, // Opcode: FCMP_SLE_D, DecodeIdx: 62
/* 4329 */    MCD::OPC_FilterValue, 8, 8, 0, // Skip to: 4341
/* 4333 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4337 */    MCD::OPC_Decode, 221, 4, 62, // Opcode: FCMP_CUN_D, DecodeIdx: 62
/* 4341 */    MCD::OPC_FilterValue, 9, 8, 0, // Skip to: 4353
/* 4345 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4349 */    MCD::OPC_Decode, 243, 4, 62, // Opcode: FCMP_SUN_D, DecodeIdx: 62
/* 4353 */    MCD::OPC_FilterValue, 10, 8, 0, // Skip to: 4365
/* 4357 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4361 */    MCD::OPC_Decode, 217, 4, 62, // Opcode: FCMP_CULT_D, DecodeIdx: 62
/* 4365 */    MCD::OPC_FilterValue, 11, 8, 0, // Skip to: 4377
/* 4369 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4373 */    MCD::OPC_Decode, 239, 4, 62, // Opcode: FCMP_SULT_D, DecodeIdx: 62
/* 4377 */    MCD::OPC_FilterValue, 12, 8, 0, // Skip to: 4389
/* 4381 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4385 */    MCD::OPC_Decode, 213, 4, 62, // Opcode: FCMP_CUEQ_D, DecodeIdx: 62
/* 4389 */    MCD::OPC_FilterValue, 13, 8, 0, // Skip to: 4401
/* 4393 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4397 */    MCD::OPC_Decode, 235, 4, 62, // Opcode: FCMP_SUEQ_D, DecodeIdx: 62
/* 4401 */    MCD::OPC_FilterValue, 14, 8, 0, // Skip to: 4413
/* 4405 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4409 */    MCD::OPC_Decode, 215, 4, 62, // Opcode: FCMP_CULE_D, DecodeIdx: 62
/* 4413 */    MCD::OPC_FilterValue, 15, 8, 0, // Skip to: 4425
/* 4417 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4421 */    MCD::OPC_Decode, 237, 4, 62, // Opcode: FCMP_SULE_D, DecodeIdx: 62
/* 4425 */    MCD::OPC_FilterValue, 16, 8, 0, // Skip to: 4437
/* 4429 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4433 */    MCD::OPC_Decode, 209, 4, 62, // Opcode: FCMP_CNE_D, DecodeIdx: 62
/* 4437 */    MCD::OPC_FilterValue, 17, 8, 0, // Skip to: 4449
/* 4441 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4445 */    MCD::OPC_Decode, 231, 4, 62, // Opcode: FCMP_SNE_D, DecodeIdx: 62
/* 4449 */    MCD::OPC_FilterValue, 20, 8, 0, // Skip to: 4461
/* 4453 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4457 */    MCD::OPC_Decode, 211, 4, 62, // Opcode: FCMP_COR_D, DecodeIdx: 62
/* 4461 */    MCD::OPC_FilterValue, 21, 8, 0, // Skip to: 4473
/* 4465 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4469 */    MCD::OPC_Decode, 233, 4, 62, // Opcode: FCMP_SOR_D, DecodeIdx: 62
/* 4473 */    MCD::OPC_FilterValue, 24, 8, 0, // Skip to: 4485
/* 4477 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4481 */    MCD::OPC_Decode, 219, 4, 62, // Opcode: FCMP_CUNE_D, DecodeIdx: 62
/* 4485 */    MCD::OPC_FilterValueOrFail, 25, 
/* 4487 */    MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 4491 */    MCD::OPC_Decode, 241, 4, 62, // Opcode: FCMP_SUNE_D, DecodeIdx: 62
/* 4495 */    MCD::OPC_FilterValue, 5, 177, 0, // Skip to: 4676
/* 4499 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 4502 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 4510
/* 4506 */    MCD::OPC_Decode, 146, 8, 63, // Opcode: VFCMP_CAF_S, DecodeIdx: 63
/* 4510 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 4518
/* 4514 */    MCD::OPC_Decode, 168, 8, 63, // Opcode: VFCMP_SAF_S, DecodeIdx: 63
/* 4518 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 4526
/* 4522 */    MCD::OPC_Decode, 152, 8, 63, // Opcode: VFCMP_CLT_S, DecodeIdx: 63
/* 4526 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 4534
/* 4530 */    MCD::OPC_Decode, 174, 8, 63, // Opcode: VFCMP_SLT_S, DecodeIdx: 63
/* 4534 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 4542
/* 4538 */    MCD::OPC_Decode, 148, 8, 63, // Opcode: VFCMP_CEQ_S, DecodeIdx: 63
/* 4542 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 4550
/* 4546 */    MCD::OPC_Decode, 170, 8, 63, // Opcode: VFCMP_SEQ_S, DecodeIdx: 63
/* 4550 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 4558
/* 4554 */    MCD::OPC_Decode, 150, 8, 63, // Opcode: VFCMP_CLE_S, DecodeIdx: 63
/* 4558 */    MCD::OPC_FilterValue, 7, 4, 0, // Skip to: 4566
/* 4562 */    MCD::OPC_Decode, 172, 8, 63, // Opcode: VFCMP_SLE_S, DecodeIdx: 63
/* 4566 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 4574
/* 4570 */    MCD::OPC_Decode, 166, 8, 63, // Opcode: VFCMP_CUN_S, DecodeIdx: 63
/* 4574 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 4582
/* 4578 */    MCD::OPC_Decode, 188, 8, 63, // Opcode: VFCMP_SUN_S, DecodeIdx: 63
/* 4582 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 4590
/* 4586 */    MCD::OPC_Decode, 162, 8, 63, // Opcode: VFCMP_CULT_S, DecodeIdx: 63
/* 4590 */    MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 4598
/* 4594 */    MCD::OPC_Decode, 184, 8, 63, // Opcode: VFCMP_SULT_S, DecodeIdx: 63
/* 4598 */    MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 4606
/* 4602 */    MCD::OPC_Decode, 158, 8, 63, // Opcode: VFCMP_CUEQ_S, DecodeIdx: 63
/* 4606 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 4614
/* 4610 */    MCD::OPC_Decode, 180, 8, 63, // Opcode: VFCMP_SUEQ_S, DecodeIdx: 63
/* 4614 */    MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 4622
/* 4618 */    MCD::OPC_Decode, 160, 8, 63, // Opcode: VFCMP_CULE_S, DecodeIdx: 63
/* 4622 */    MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 4630
/* 4626 */    MCD::OPC_Decode, 182, 8, 63, // Opcode: VFCMP_SULE_S, DecodeIdx: 63
/* 4630 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 4638
/* 4634 */    MCD::OPC_Decode, 154, 8, 63, // Opcode: VFCMP_CNE_S, DecodeIdx: 63
/* 4638 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 4646
/* 4642 */    MCD::OPC_Decode, 176, 8, 63, // Opcode: VFCMP_SNE_S, DecodeIdx: 63
/* 4646 */    MCD::OPC_FilterValue, 20, 4, 0, // Skip to: 4654
/* 4650 */    MCD::OPC_Decode, 156, 8, 63, // Opcode: VFCMP_COR_S, DecodeIdx: 63
/* 4654 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 4662
/* 4658 */    MCD::OPC_Decode, 178, 8, 63, // Opcode: VFCMP_SOR_S, DecodeIdx: 63
/* 4662 */    MCD::OPC_FilterValue, 24, 4, 0, // Skip to: 4670
/* 4666 */    MCD::OPC_Decode, 164, 8, 63, // Opcode: VFCMP_CUNE_S, DecodeIdx: 63
/* 4670 */    MCD::OPC_FilterValueOrFail, 25, 
/* 4672 */    MCD::OPC_Decode, 186, 8, 63, // Opcode: VFCMP_SUNE_S, DecodeIdx: 63
/* 4676 */    MCD::OPC_FilterValue, 6, 177, 0, // Skip to: 4857
/* 4680 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 4683 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 4691
/* 4687 */    MCD::OPC_Decode, 145, 8, 63, // Opcode: VFCMP_CAF_D, DecodeIdx: 63
/* 4691 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 4699
/* 4695 */    MCD::OPC_Decode, 167, 8, 63, // Opcode: VFCMP_SAF_D, DecodeIdx: 63
/* 4699 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 4707
/* 4703 */    MCD::OPC_Decode, 151, 8, 63, // Opcode: VFCMP_CLT_D, DecodeIdx: 63
/* 4707 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 4715
/* 4711 */    MCD::OPC_Decode, 173, 8, 63, // Opcode: VFCMP_SLT_D, DecodeIdx: 63
/* 4715 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 4723
/* 4719 */    MCD::OPC_Decode, 147, 8, 63, // Opcode: VFCMP_CEQ_D, DecodeIdx: 63
/* 4723 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 4731
/* 4727 */    MCD::OPC_Decode, 169, 8, 63, // Opcode: VFCMP_SEQ_D, DecodeIdx: 63
/* 4731 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 4739
/* 4735 */    MCD::OPC_Decode, 149, 8, 63, // Opcode: VFCMP_CLE_D, DecodeIdx: 63
/* 4739 */    MCD::OPC_FilterValue, 7, 4, 0, // Skip to: 4747
/* 4743 */    MCD::OPC_Decode, 171, 8, 63, // Opcode: VFCMP_SLE_D, DecodeIdx: 63
/* 4747 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 4755
/* 4751 */    MCD::OPC_Decode, 165, 8, 63, // Opcode: VFCMP_CUN_D, DecodeIdx: 63
/* 4755 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 4763
/* 4759 */    MCD::OPC_Decode, 187, 8, 63, // Opcode: VFCMP_SUN_D, DecodeIdx: 63
/* 4763 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 4771
/* 4767 */    MCD::OPC_Decode, 161, 8, 63, // Opcode: VFCMP_CULT_D, DecodeIdx: 63
/* 4771 */    MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 4779
/* 4775 */    MCD::OPC_Decode, 183, 8, 63, // Opcode: VFCMP_SULT_D, DecodeIdx: 63
/* 4779 */    MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 4787
/* 4783 */    MCD::OPC_Decode, 157, 8, 63, // Opcode: VFCMP_CUEQ_D, DecodeIdx: 63
/* 4787 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 4795
/* 4791 */    MCD::OPC_Decode, 179, 8, 63, // Opcode: VFCMP_SUEQ_D, DecodeIdx: 63
/* 4795 */    MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 4803
/* 4799 */    MCD::OPC_Decode, 159, 8, 63, // Opcode: VFCMP_CULE_D, DecodeIdx: 63
/* 4803 */    MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 4811
/* 4807 */    MCD::OPC_Decode, 181, 8, 63, // Opcode: VFCMP_SULE_D, DecodeIdx: 63
/* 4811 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 4819
/* 4815 */    MCD::OPC_Decode, 153, 8, 63, // Opcode: VFCMP_CNE_D, DecodeIdx: 63
/* 4819 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 4827
/* 4823 */    MCD::OPC_Decode, 175, 8, 63, // Opcode: VFCMP_SNE_D, DecodeIdx: 63
/* 4827 */    MCD::OPC_FilterValue, 20, 4, 0, // Skip to: 4835
/* 4831 */    MCD::OPC_Decode, 155, 8, 63, // Opcode: VFCMP_COR_D, DecodeIdx: 63
/* 4835 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 4843
/* 4839 */    MCD::OPC_Decode, 177, 8, 63, // Opcode: VFCMP_SOR_D, DecodeIdx: 63
/* 4843 */    MCD::OPC_FilterValue, 24, 4, 0, // Skip to: 4851
/* 4847 */    MCD::OPC_Decode, 163, 8, 63, // Opcode: VFCMP_CUNE_D, DecodeIdx: 63
/* 4851 */    MCD::OPC_FilterValueOrFail, 25, 
/* 4853 */    MCD::OPC_Decode, 185, 8, 63, // Opcode: VFCMP_SUNE_D, DecodeIdx: 63
/* 4857 */    MCD::OPC_FilterValue, 9, 177, 0, // Skip to: 5038
/* 4861 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 4864 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 4872
/* 4868 */    MCD::OPC_Decode, 209, 14, 64, // Opcode: XVFCMP_CAF_S, DecodeIdx: 64
/* 4872 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 4880
/* 4876 */    MCD::OPC_Decode, 231, 14, 64, // Opcode: XVFCMP_SAF_S, DecodeIdx: 64
/* 4880 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 4888
/* 4884 */    MCD::OPC_Decode, 215, 14, 64, // Opcode: XVFCMP_CLT_S, DecodeIdx: 64
/* 4888 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 4896
/* 4892 */    MCD::OPC_Decode, 237, 14, 64, // Opcode: XVFCMP_SLT_S, DecodeIdx: 64
/* 4896 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 4904
/* 4900 */    MCD::OPC_Decode, 211, 14, 64, // Opcode: XVFCMP_CEQ_S, DecodeIdx: 64
/* 4904 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 4912
/* 4908 */    MCD::OPC_Decode, 233, 14, 64, // Opcode: XVFCMP_SEQ_S, DecodeIdx: 64
/* 4912 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 4920
/* 4916 */    MCD::OPC_Decode, 213, 14, 64, // Opcode: XVFCMP_CLE_S, DecodeIdx: 64
/* 4920 */    MCD::OPC_FilterValue, 7, 4, 0, // Skip to: 4928
/* 4924 */    MCD::OPC_Decode, 235, 14, 64, // Opcode: XVFCMP_SLE_S, DecodeIdx: 64
/* 4928 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 4936
/* 4932 */    MCD::OPC_Decode, 229, 14, 64, // Opcode: XVFCMP_CUN_S, DecodeIdx: 64
/* 4936 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 4944
/* 4940 */    MCD::OPC_Decode, 251, 14, 64, // Opcode: XVFCMP_SUN_S, DecodeIdx: 64
/* 4944 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 4952
/* 4948 */    MCD::OPC_Decode, 225, 14, 64, // Opcode: XVFCMP_CULT_S, DecodeIdx: 64
/* 4952 */    MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 4960
/* 4956 */    MCD::OPC_Decode, 247, 14, 64, // Opcode: XVFCMP_SULT_S, DecodeIdx: 64
/* 4960 */    MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 4968
/* 4964 */    MCD::OPC_Decode, 221, 14, 64, // Opcode: XVFCMP_CUEQ_S, DecodeIdx: 64
/* 4968 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 4976
/* 4972 */    MCD::OPC_Decode, 243, 14, 64, // Opcode: XVFCMP_SUEQ_S, DecodeIdx: 64
/* 4976 */    MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 4984
/* 4980 */    MCD::OPC_Decode, 223, 14, 64, // Opcode: XVFCMP_CULE_S, DecodeIdx: 64
/* 4984 */    MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 4992
/* 4988 */    MCD::OPC_Decode, 245, 14, 64, // Opcode: XVFCMP_SULE_S, DecodeIdx: 64
/* 4992 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 5000
/* 4996 */    MCD::OPC_Decode, 217, 14, 64, // Opcode: XVFCMP_CNE_S, DecodeIdx: 64
/* 5000 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 5008
/* 5004 */    MCD::OPC_Decode, 239, 14, 64, // Opcode: XVFCMP_SNE_S, DecodeIdx: 64
/* 5008 */    MCD::OPC_FilterValue, 20, 4, 0, // Skip to: 5016
/* 5012 */    MCD::OPC_Decode, 219, 14, 64, // Opcode: XVFCMP_COR_S, DecodeIdx: 64
/* 5016 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 5024
/* 5020 */    MCD::OPC_Decode, 241, 14, 64, // Opcode: XVFCMP_SOR_S, DecodeIdx: 64
/* 5024 */    MCD::OPC_FilterValue, 24, 4, 0, // Skip to: 5032
/* 5028 */    MCD::OPC_Decode, 227, 14, 64, // Opcode: XVFCMP_CUNE_S, DecodeIdx: 64
/* 5032 */    MCD::OPC_FilterValueOrFail, 25, 
/* 5034 */    MCD::OPC_Decode, 249, 14, 64, // Opcode: XVFCMP_SUNE_S, DecodeIdx: 64
/* 5038 */    MCD::OPC_FilterValue, 10, 177, 0, // Skip to: 5219
/* 5042 */    MCD::OPC_ExtractField, 15, 5,  // Inst{19-15} ...
/* 5045 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5053
/* 5049 */    MCD::OPC_Decode, 208, 14, 64, // Opcode: XVFCMP_CAF_D, DecodeIdx: 64
/* 5053 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 5061
/* 5057 */    MCD::OPC_Decode, 230, 14, 64, // Opcode: XVFCMP_SAF_D, DecodeIdx: 64
/* 5061 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 5069
/* 5065 */    MCD::OPC_Decode, 214, 14, 64, // Opcode: XVFCMP_CLT_D, DecodeIdx: 64
/* 5069 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 5077
/* 5073 */    MCD::OPC_Decode, 236, 14, 64, // Opcode: XVFCMP_SLT_D, DecodeIdx: 64
/* 5077 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 5085
/* 5081 */    MCD::OPC_Decode, 210, 14, 64, // Opcode: XVFCMP_CEQ_D, DecodeIdx: 64
/* 5085 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 5093
/* 5089 */    MCD::OPC_Decode, 232, 14, 64, // Opcode: XVFCMP_SEQ_D, DecodeIdx: 64
/* 5093 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 5101
/* 5097 */    MCD::OPC_Decode, 212, 14, 64, // Opcode: XVFCMP_CLE_D, DecodeIdx: 64
/* 5101 */    MCD::OPC_FilterValue, 7, 4, 0, // Skip to: 5109
/* 5105 */    MCD::OPC_Decode, 234, 14, 64, // Opcode: XVFCMP_SLE_D, DecodeIdx: 64
/* 5109 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 5117
/* 5113 */    MCD::OPC_Decode, 228, 14, 64, // Opcode: XVFCMP_CUN_D, DecodeIdx: 64
/* 5117 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 5125
/* 5121 */    MCD::OPC_Decode, 250, 14, 64, // Opcode: XVFCMP_SUN_D, DecodeIdx: 64
/* 5125 */    MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 5133
/* 5129 */    MCD::OPC_Decode, 224, 14, 64, // Opcode: XVFCMP_CULT_D, DecodeIdx: 64
/* 5133 */    MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 5141
/* 5137 */    MCD::OPC_Decode, 246, 14, 64, // Opcode: XVFCMP_SULT_D, DecodeIdx: 64
/* 5141 */    MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 5149
/* 5145 */    MCD::OPC_Decode, 220, 14, 64, // Opcode: XVFCMP_CUEQ_D, DecodeIdx: 64
/* 5149 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 5157
/* 5153 */    MCD::OPC_Decode, 242, 14, 64, // Opcode: XVFCMP_SUEQ_D, DecodeIdx: 64
/* 5157 */    MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 5165
/* 5161 */    MCD::OPC_Decode, 222, 14, 64, // Opcode: XVFCMP_CULE_D, DecodeIdx: 64
/* 5165 */    MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 5173
/* 5169 */    MCD::OPC_Decode, 244, 14, 64, // Opcode: XVFCMP_SULE_D, DecodeIdx: 64
/* 5173 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 5181
/* 5177 */    MCD::OPC_Decode, 216, 14, 64, // Opcode: XVFCMP_CNE_D, DecodeIdx: 64
/* 5181 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 5189
/* 5185 */    MCD::OPC_Decode, 238, 14, 64, // Opcode: XVFCMP_SNE_D, DecodeIdx: 64
/* 5189 */    MCD::OPC_FilterValue, 20, 4, 0, // Skip to: 5197
/* 5193 */    MCD::OPC_Decode, 218, 14, 64, // Opcode: XVFCMP_COR_D, DecodeIdx: 64
/* 5197 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 5205
/* 5201 */    MCD::OPC_Decode, 240, 14, 64, // Opcode: XVFCMP_SOR_D, DecodeIdx: 64
/* 5205 */    MCD::OPC_FilterValue, 24, 4, 0, // Skip to: 5213
/* 5209 */    MCD::OPC_Decode, 226, 14, 64, // Opcode: XVFCMP_CUNE_D, DecodeIdx: 64
/* 5213 */    MCD::OPC_FilterValueOrFail, 25, 
/* 5215 */    MCD::OPC_Decode, 248, 14, 64, // Opcode: XVFCMP_SUNE_D, DecodeIdx: 64
/* 5219 */    MCD::OPC_FilterValue, 16, 8, 0, // Skip to: 5231
/* 5223 */    MCD::OPC_CheckFieldOrFail, 18, 2, 0, 
/* 5227 */    MCD::OPC_Decode, 175, 5, 65, // Opcode: FSEL_xS, DecodeIdx: 65
/* 5231 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 5239
/* 5235 */    MCD::OPC_Decode, 216, 7, 59, // Opcode: VBITSEL_V, DecodeIdx: 59
/* 5239 */    MCD::OPC_FilterValue, 18, 4, 0, // Skip to: 5247
/* 5243 */    MCD::OPC_Decode, 163, 14, 60, // Opcode: XVBITSEL_V, DecodeIdx: 60
/* 5247 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 5255
/* 5251 */    MCD::OPC_Decode, 140, 11, 59, // Opcode: VSHUF_B, DecodeIdx: 59
/* 5255 */    MCD::OPC_FilterValueOrFail, 22, 
/* 5257 */    MCD::OPC_Decode, 210, 17, 60, // Opcode: XVSHUF_B, DecodeIdx: 60
/* 5261 */    MCD::OPC_FilterValue, 4, 6, 0, // Skip to: 5271
/* 5265 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5267 */    MCD::OPC_Decode, 185, 3, 66, // Opcode: ADDU16I_D, DecodeIdx: 66
/* 5271 */    MCD::OPC_FilterValue, 5, 19, 0, // Skip to: 5294
/* 5275 */    MCD::OPC_ExtractField, 25, 1,  // Inst{25} ...
/* 5278 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5286
/* 5282 */    MCD::OPC_Decode, 133, 6, 67, // Opcode: LU12I_W, DecodeIdx: 67
/* 5286 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5288 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5290 */    MCD::OPC_Decode, 134, 6, 68, // Opcode: LU32I_D, DecodeIdx: 68
/* 5294 */    MCD::OPC_FilterValue, 6, 17, 0, // Skip to: 5315
/* 5298 */    MCD::OPC_ExtractField, 25, 1,  // Inst{25} ...
/* 5301 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5309
/* 5305 */    MCD::OPC_Decode, 170, 6, 67, // Opcode: PCADDI, DecodeIdx: 67
/* 5309 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5311 */    MCD::OPC_Decode, 173, 6, 67, // Opcode: PCALAU12I, DecodeIdx: 67
/* 5315 */    MCD::OPC_FilterValue, 7, 19, 0, // Skip to: 5338
/* 5319 */    MCD::OPC_ExtractField, 25, 1,  // Inst{25} ...
/* 5322 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5330
/* 5326 */    MCD::OPC_Decode, 171, 6, 67, // Opcode: PCADDU12I, DecodeIdx: 67
/* 5330 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5332 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5334 */    MCD::OPC_Decode, 172, 6, 67, // Opcode: PCADDU18I, DecodeIdx: 67
/* 5338 */    MCD::OPC_FilterValue, 8, 37, 0, // Skip to: 5379
/* 5342 */    MCD::OPC_ExtractField, 24, 2,  // Inst{25-24} ...
/* 5345 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5353
/* 5349 */    MCD::OPC_Decode, 132, 6, 69, // Opcode: LL_W, DecodeIdx: 69
/* 5353 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 5361
/* 5357 */    MCD::OPC_Decode, 209, 6, 70, // Opcode: SC_W, DecodeIdx: 70
/* 5361 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 5371
/* 5365 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5367 */    MCD::OPC_Decode, 131, 6, 69, // Opcode: LL_D, DecodeIdx: 69
/* 5371 */    MCD::OPC_FilterValueOrFail, 3, 
/* 5373 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5375 */    MCD::OPC_Decode, 207, 6, 70, // Opcode: SC_D, DecodeIdx: 70
/* 5379 */    MCD::OPC_FilterValue, 9, 41, 0, // Skip to: 5424
/* 5383 */    MCD::OPC_ExtractField, 24, 2,  // Inst{25-24} ...
/* 5386 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 5396
/* 5390 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5392 */    MCD::OPC_Decode, 240, 5, 69, // Opcode: LDPTR_W, DecodeIdx: 69
/* 5396 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 5406
/* 5400 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5402 */    MCD::OPC_Decode, 243, 6, 69, // Opcode: STPTR_W, DecodeIdx: 69
/* 5406 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 5416
/* 5410 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5412 */    MCD::OPC_Decode, 239, 5, 69, // Opcode: LDPTR_D, DecodeIdx: 69
/* 5416 */    MCD::OPC_FilterValueOrFail, 3, 
/* 5418 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5420 */    MCD::OPC_Decode, 242, 6, 69, // Opcode: STPTR_D, DecodeIdx: 69
/* 5424 */    MCD::OPC_FilterValue, 10, 135, 0, // Skip to: 5563
/* 5428 */    MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 5431 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5439
/* 5435 */    MCD::OPC_Decode, 250, 5, 48, // Opcode: LD_B, DecodeIdx: 48
/* 5439 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 5447
/* 5443 */    MCD::OPC_Decode, 253, 5, 48, // Opcode: LD_H, DecodeIdx: 48
/* 5447 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 5455
/* 5451 */    MCD::OPC_Decode, 255, 5, 48, // Opcode: LD_W, DecodeIdx: 48
/* 5455 */    MCD::OPC_FilterValue, 3, 6, 0, // Skip to: 5465
/* 5459 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5461 */    MCD::OPC_Decode, 252, 5, 48, // Opcode: LD_D, DecodeIdx: 48
/* 5465 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 5473
/* 5469 */    MCD::OPC_Decode, 250, 6, 48, // Opcode: ST_B, DecodeIdx: 48
/* 5473 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 5481
/* 5477 */    MCD::OPC_Decode, 252, 6, 48, // Opcode: ST_H, DecodeIdx: 48
/* 5481 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 5489
/* 5485 */    MCD::OPC_Decode, 253, 6, 48, // Opcode: ST_W, DecodeIdx: 48
/* 5489 */    MCD::OPC_FilterValue, 7, 6, 0, // Skip to: 5499
/* 5493 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5495 */    MCD::OPC_Decode, 251, 6, 48, // Opcode: ST_D, DecodeIdx: 48
/* 5499 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 5507
/* 5503 */    MCD::OPC_Decode, 251, 5, 48, // Opcode: LD_BU, DecodeIdx: 48
/* 5507 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 5515
/* 5511 */    MCD::OPC_Decode, 254, 5, 48, // Opcode: LD_HU, DecodeIdx: 48
/* 5515 */    MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 5525
/* 5519 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5521 */    MCD::OPC_Decode, 128, 6, 48, // Opcode: LD_WU, DecodeIdx: 48
/* 5525 */    MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 5533
/* 5529 */    MCD::OPC_Decode, 174, 6, 53, // Opcode: PRELD, DecodeIdx: 53
/* 5533 */    MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 5541
/* 5537 */    MCD::OPC_Decode, 137, 5, 71, // Opcode: FLD_S, DecodeIdx: 71
/* 5541 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 5549
/* 5545 */    MCD::OPC_Decode, 185, 5, 71, // Opcode: FST_S, DecodeIdx: 71
/* 5549 */    MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 5557
/* 5553 */    MCD::OPC_Decode, 136, 5, 72, // Opcode: FLD_D, DecodeIdx: 72
/* 5557 */    MCD::OPC_FilterValueOrFail, 15, 
/* 5559 */    MCD::OPC_Decode, 184, 5, 72, // Opcode: FST_D, DecodeIdx: 72
/* 5563 */    MCD::OPC_FilterValue, 11, 105, 0, // Skip to: 5672
/* 5567 */    MCD::OPC_ExtractField, 22, 4,  // Inst{25-22} ...
/* 5570 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 5578
/* 5574 */    MCD::OPC_Decode, 179, 9, 73, // Opcode: VLD, DecodeIdx: 73
/* 5578 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 5586
/* 5582 */    MCD::OPC_Decode, 190, 12, 73, // Opcode: VST, DecodeIdx: 73
/* 5586 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 5594
/* 5590 */    MCD::OPC_Decode, 243, 15, 74, // Opcode: XVLD, DecodeIdx: 74
/* 5594 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 5602
/* 5598 */    MCD::OPC_Decode, 132, 19, 74, // Opcode: XVST, DecodeIdx: 74
/* 5602 */    MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 5610
/* 5606 */    MCD::OPC_Decode, 237, 5, 48, // Opcode: LDL_W, DecodeIdx: 48
/* 5610 */    MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 5618
/* 5614 */    MCD::OPC_Decode, 242, 5, 48, // Opcode: LDR_W, DecodeIdx: 48
/* 5618 */    MCD::OPC_FilterValue, 10, 6, 0, // Skip to: 5628
/* 5622 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5624 */    MCD::OPC_Decode, 236, 5, 48, // Opcode: LDL_D, DecodeIdx: 48
/* 5628 */    MCD::OPC_FilterValue, 11, 6, 0, // Skip to: 5638
/* 5632 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5634 */    MCD::OPC_Decode, 241, 5, 48, // Opcode: LDR_D, DecodeIdx: 48
/* 5638 */    MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 5646
/* 5642 */    MCD::OPC_Decode, 241, 6, 48, // Opcode: STL_W, DecodeIdx: 48
/* 5646 */    MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 5654
/* 5650 */    MCD::OPC_Decode, 245, 6, 48, // Opcode: STR_W, DecodeIdx: 48
/* 5654 */    MCD::OPC_FilterValue, 14, 6, 0, // Skip to: 5664
/* 5658 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5660 */    MCD::OPC_Decode, 240, 6, 48, // Opcode: STL_D, DecodeIdx: 48
/* 5664 */    MCD::OPC_FilterValueOrFail, 15, 
/* 5666 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5668 */    MCD::OPC_Decode, 244, 6, 48, // Opcode: STR_D, DecodeIdx: 48
/* 5672 */    MCD::OPC_FilterValue, 12, 194, 0, // Skip to: 5870
/* 5676 */    MCD::OPC_ExtractField, 23, 3,  // Inst{25-23} ...
/* 5679 */    MCD::OPC_FilterValue, 0, 33, 0, // Skip to: 5716
/* 5683 */    MCD::OPC_ExtractField, 21, 2,  // Inst{22-21} ...
/* 5686 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5698
/* 5690 */    MCD::OPC_CheckFieldOrFail, 19, 2, 2, 
/* 5694 */    MCD::OPC_Decode, 182, 9, 75, // Opcode: VLDREPL_D, DecodeIdx: 75
/* 5698 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 5710
/* 5702 */    MCD::OPC_CheckFieldOrFail, 20, 1, 0, 
/* 5706 */    MCD::OPC_Decode, 184, 9, 76, // Opcode: VLDREPL_W, DecodeIdx: 76
/* 5710 */    MCD::OPC_FilterValueOrFail, 2, 
/* 5712 */    MCD::OPC_Decode, 183, 9, 77, // Opcode: VLDREPL_H, DecodeIdx: 77
/* 5716 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 5728
/* 5720 */    MCD::OPC_CheckFieldOrFail, 22, 1, 0, 
/* 5724 */    MCD::OPC_Decode, 181, 9, 73, // Opcode: VLDREPL_B, DecodeIdx: 73
/* 5728 */    MCD::OPC_FilterValue, 2, 33, 0, // Skip to: 5765
/* 5732 */    MCD::OPC_ExtractField, 21, 2,  // Inst{22-21} ...
/* 5735 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5747
/* 5739 */    MCD::OPC_CheckFieldOrFail, 19, 2, 2, 
/* 5743 */    MCD::OPC_Decode, 192, 12, 78, // Opcode: VSTELM_D, DecodeIdx: 78
/* 5747 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 5759
/* 5751 */    MCD::OPC_CheckFieldOrFail, 20, 1, 0, 
/* 5755 */    MCD::OPC_Decode, 194, 12, 79, // Opcode: VSTELM_W, DecodeIdx: 79
/* 5759 */    MCD::OPC_FilterValueOrFail, 2, 
/* 5761 */    MCD::OPC_Decode, 193, 12, 80, // Opcode: VSTELM_H, DecodeIdx: 80
/* 5765 */    MCD::OPC_FilterValue, 3, 8, 0, // Skip to: 5777
/* 5769 */    MCD::OPC_CheckFieldOrFail, 22, 1, 0, 
/* 5773 */    MCD::OPC_Decode, 191, 12, 81, // Opcode: VSTELM_B, DecodeIdx: 81
/* 5777 */    MCD::OPC_FilterValue, 4, 33, 0, // Skip to: 5814
/* 5781 */    MCD::OPC_ExtractField, 21, 2,  // Inst{22-21} ...
/* 5784 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5796
/* 5788 */    MCD::OPC_CheckFieldOrFail, 19, 2, 2, 
/* 5792 */    MCD::OPC_Decode, 246, 15, 82, // Opcode: XVLDREPL_D, DecodeIdx: 82
/* 5796 */    MCD::OPC_FilterValue, 1, 8, 0, // Skip to: 5808
/* 5800 */    MCD::OPC_CheckFieldOrFail, 20, 1, 0, 
/* 5804 */    MCD::OPC_Decode, 248, 15, 83, // Opcode: XVLDREPL_W, DecodeIdx: 83
/* 5808 */    MCD::OPC_FilterValueOrFail, 2, 
/* 5810 */    MCD::OPC_Decode, 247, 15, 84, // Opcode: XVLDREPL_H, DecodeIdx: 84
/* 5814 */    MCD::OPC_FilterValue, 5, 8, 0, // Skip to: 5826
/* 5818 */    MCD::OPC_CheckFieldOrFail, 22, 1, 0, 
/* 5822 */    MCD::OPC_Decode, 245, 15, 74, // Opcode: XVLDREPL_B, DecodeIdx: 74
/* 5826 */    MCD::OPC_FilterValue, 6, 34, 0, // Skip to: 5864
/* 5830 */    MCD::OPC_ExtractField, 22, 1,  // Inst{22} ...
/* 5833 */    MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 5858
/* 5837 */    MCD::OPC_ExtractField, 21, 1,  // Inst{21} ...
/* 5840 */    MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 5852
/* 5844 */    MCD::OPC_CheckFieldOrFail, 20, 1, 1, 
/* 5848 */    MCD::OPC_Decode, 134, 19, 85, // Opcode: XVSTELM_D, DecodeIdx: 85
/* 5852 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5854 */    MCD::OPC_Decode, 136, 19, 86, // Opcode: XVSTELM_W, DecodeIdx: 86
/* 5858 */    MCD::OPC_FilterValueOrFail, 1, 
/* 5860 */    MCD::OPC_Decode, 135, 19, 87, // Opcode: XVSTELM_H, DecodeIdx: 87
/* 5864 */    MCD::OPC_FilterValueOrFail, 7, 
/* 5866 */    MCD::OPC_Decode, 133, 19, 88, // Opcode: XVSTELM_B, DecodeIdx: 88
/* 5870 */    MCD::OPC_FilterValue, 14, 60, 4, // Skip to: 6958
/* 5874 */    MCD::OPC_ExtractField, 15, 11,  // Inst{25-15} ...
/* 5877 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 5887
/* 5881 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5883 */    MCD::OPC_Decode, 243, 5, 11, // Opcode: LDX_B, DecodeIdx: 11
/* 5887 */    MCD::OPC_FilterValue, 8, 6, 0, // Skip to: 5897
/* 5891 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5893 */    MCD::OPC_Decode, 246, 5, 11, // Opcode: LDX_H, DecodeIdx: 11
/* 5897 */    MCD::OPC_FilterValue, 16, 6, 0, // Skip to: 5907
/* 5901 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5903 */    MCD::OPC_Decode, 248, 5, 11, // Opcode: LDX_W, DecodeIdx: 11
/* 5907 */    MCD::OPC_FilterValue, 24, 6, 0, // Skip to: 5917
/* 5911 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5913 */    MCD::OPC_Decode, 245, 5, 11, // Opcode: LDX_D, DecodeIdx: 11
/* 5917 */    MCD::OPC_FilterValue, 32, 6, 0, // Skip to: 5927
/* 5921 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5923 */    MCD::OPC_Decode, 246, 6, 11, // Opcode: STX_B, DecodeIdx: 11
/* 5927 */    MCD::OPC_FilterValue, 40, 6, 0, // Skip to: 5937
/* 5931 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5933 */    MCD::OPC_Decode, 248, 6, 11, // Opcode: STX_H, DecodeIdx: 11
/* 5937 */    MCD::OPC_FilterValue, 48, 6, 0, // Skip to: 5947
/* 5941 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5943 */    MCD::OPC_Decode, 249, 6, 11, // Opcode: STX_W, DecodeIdx: 11
/* 5947 */    MCD::OPC_FilterValue, 56, 6, 0, // Skip to: 5957
/* 5951 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5953 */    MCD::OPC_Decode, 247, 6, 11, // Opcode: STX_D, DecodeIdx: 11
/* 5957 */    MCD::OPC_FilterValue, 64, 6, 0, // Skip to: 5967
/* 5961 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5963 */    MCD::OPC_Decode, 244, 5, 11, // Opcode: LDX_BU, DecodeIdx: 11
/* 5967 */    MCD::OPC_FilterValue, 72, 6, 0, // Skip to: 5977
/* 5971 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5973 */    MCD::OPC_Decode, 247, 5, 11, // Opcode: LDX_HU, DecodeIdx: 11
/* 5977 */    MCD::OPC_FilterValue, 80, 6, 0, // Skip to: 5987
/* 5981 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5983 */    MCD::OPC_Decode, 249, 5, 11, // Opcode: LDX_WU, DecodeIdx: 11
/* 5987 */    MCD::OPC_FilterValue, 88, 6, 0, // Skip to: 5997
/* 5991 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 5993 */    MCD::OPC_Decode, 175, 6, 89, // Opcode: PRELDX, DecodeIdx: 89
/* 5997 */    MCD::OPC_FilterValue, 96, 4, 0, // Skip to: 6005
/* 6001 */    MCD::OPC_Decode, 135, 5, 90, // Opcode: FLDX_S, DecodeIdx: 90
/* 6005 */    MCD::OPC_FilterValue, 104, 4, 0, // Skip to: 6013
/* 6009 */    MCD::OPC_Decode, 134, 5, 91, // Opcode: FLDX_D, DecodeIdx: 91
/* 6013 */    MCD::OPC_FilterValue, 112, 4, 0, // Skip to: 6021
/* 6017 */    MCD::OPC_Decode, 183, 5, 90, // Opcode: FSTX_S, DecodeIdx: 90
/* 6021 */    MCD::OPC_FilterValue, 120, 4, 0, // Skip to: 6029
/* 6025 */    MCD::OPC_Decode, 182, 5, 91, // Opcode: FSTX_D, DecodeIdx: 91
/* 6029 */    MCD::OPC_FilterValue, 128, 1, 4, 0, // Skip to: 6038
/* 6034 */    MCD::OPC_Decode, 185, 9, 92, // Opcode: VLDX, DecodeIdx: 92
/* 6038 */    MCD::OPC_FilterValue, 136, 1, 4, 0, // Skip to: 6047
/* 6043 */    MCD::OPC_Decode, 195, 12, 92, // Opcode: VSTX, DecodeIdx: 92
/* 6047 */    MCD::OPC_FilterValue, 144, 1, 4, 0, // Skip to: 6056
/* 6052 */    MCD::OPC_Decode, 249, 15, 93, // Opcode: XVLDX, DecodeIdx: 93
/* 6056 */    MCD::OPC_FilterValue, 152, 1, 4, 0, // Skip to: 6065
/* 6061 */    MCD::OPC_Decode, 137, 19, 93, // Opcode: XVSTX, DecodeIdx: 93
/* 6065 */    MCD::OPC_FilterValue, 174, 1, 6, 0, // Skip to: 6076
/* 6070 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6072 */    MCD::OPC_Decode, 208, 6, 94, // Opcode: SC_Q, DecodeIdx: 94
/* 6076 */    MCD::OPC_FilterValue, 175, 1, 41, 0, // Skip to: 6122
/* 6081 */    MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 6084 */    MCD::OPC_FilterValue, 0, 6, 0, // Skip to: 6094
/* 6088 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6090 */    MCD::OPC_Decode, 130, 6, 2, // Opcode: LLACQ_W, DecodeIdx: 2
/* 6094 */    MCD::OPC_FilterValue, 1, 6, 0, // Skip to: 6104
/* 6098 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6100 */    MCD::OPC_Decode, 206, 6, 95, // Opcode: SCREL_W, DecodeIdx: 95
/* 6104 */    MCD::OPC_FilterValue, 2, 6, 0, // Skip to: 6114
/* 6108 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6110 */    MCD::OPC_Decode, 129, 6, 2, // Opcode: LLACQ_D, DecodeIdx: 2
/* 6114 */    MCD::OPC_FilterValueOrFail, 3, 
/* 6116 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6118 */    MCD::OPC_Decode, 205, 6, 95, // Opcode: SCREL_D, DecodeIdx: 95
/* 6122 */    MCD::OPC_FilterValue, 176, 1, 6, 0, // Skip to: 6133
/* 6127 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6129 */    MCD::OPC_Decode, 203, 3, 94, // Opcode: AMCAS_B, DecodeIdx: 94
/* 6133 */    MCD::OPC_FilterValue, 177, 1, 6, 0, // Skip to: 6144
/* 6138 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6140 */    MCD::OPC_Decode, 205, 3, 94, // Opcode: AMCAS_H, DecodeIdx: 94
/* 6144 */    MCD::OPC_FilterValue, 178, 1, 6, 0, // Skip to: 6155
/* 6149 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6151 */    MCD::OPC_Decode, 206, 3, 94, // Opcode: AMCAS_W, DecodeIdx: 94
/* 6155 */    MCD::OPC_FilterValue, 179, 1, 6, 0, // Skip to: 6166
/* 6160 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6162 */    MCD::OPC_Decode, 204, 3, 94, // Opcode: AMCAS_D, DecodeIdx: 94
/* 6166 */    MCD::OPC_FilterValue, 180, 1, 6, 0, // Skip to: 6177
/* 6171 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6173 */    MCD::OPC_Decode, 207, 3, 94, // Opcode: AMCAS__DB_B, DecodeIdx: 94
/* 6177 */    MCD::OPC_FilterValue, 181, 1, 6, 0, // Skip to: 6188
/* 6182 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6184 */    MCD::OPC_Decode, 209, 3, 94, // Opcode: AMCAS__DB_H, DecodeIdx: 94
/* 6188 */    MCD::OPC_FilterValue, 182, 1, 6, 0, // Skip to: 6199
/* 6193 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6195 */    MCD::OPC_Decode, 210, 3, 94, // Opcode: AMCAS__DB_W, DecodeIdx: 94
/* 6199 */    MCD::OPC_FilterValue, 183, 1, 6, 0, // Skip to: 6210
/* 6204 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6206 */    MCD::OPC_Decode, 208, 3, 94, // Opcode: AMCAS__DB_D, DecodeIdx: 94
/* 6210 */    MCD::OPC_FilterValue, 184, 1, 6, 0, // Skip to: 6221
/* 6215 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6217 */    MCD::OPC_Decode, 231, 3, 96, // Opcode: AMSWAP_B, DecodeIdx: 96
/* 6221 */    MCD::OPC_FilterValue, 185, 1, 6, 0, // Skip to: 6232
/* 6226 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6228 */    MCD::OPC_Decode, 233, 3, 96, // Opcode: AMSWAP_H, DecodeIdx: 96
/* 6232 */    MCD::OPC_FilterValue, 186, 1, 6, 0, // Skip to: 6243
/* 6237 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6239 */    MCD::OPC_Decode, 191, 3, 96, // Opcode: AMADD_B, DecodeIdx: 96
/* 6243 */    MCD::OPC_FilterValue, 187, 1, 6, 0, // Skip to: 6254
/* 6248 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6250 */    MCD::OPC_Decode, 193, 3, 96, // Opcode: AMADD_H, DecodeIdx: 96
/* 6254 */    MCD::OPC_FilterValue, 188, 1, 6, 0, // Skip to: 6265
/* 6259 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6261 */    MCD::OPC_Decode, 235, 3, 96, // Opcode: AMSWAP__DB_B, DecodeIdx: 96
/* 6265 */    MCD::OPC_FilterValue, 189, 1, 6, 0, // Skip to: 6276
/* 6270 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6272 */    MCD::OPC_Decode, 237, 3, 96, // Opcode: AMSWAP__DB_H, DecodeIdx: 96
/* 6276 */    MCD::OPC_FilterValue, 190, 1, 6, 0, // Skip to: 6287
/* 6281 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6283 */    MCD::OPC_Decode, 195, 3, 96, // Opcode: AMADD__DB_B, DecodeIdx: 96
/* 6287 */    MCD::OPC_FilterValue, 191, 1, 6, 0, // Skip to: 6298
/* 6292 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6294 */    MCD::OPC_Decode, 197, 3, 96, // Opcode: AMADD__DB_H, DecodeIdx: 96
/* 6298 */    MCD::OPC_FilterValue, 192, 1, 6, 0, // Skip to: 6309
/* 6303 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6305 */    MCD::OPC_Decode, 234, 3, 96, // Opcode: AMSWAP_W, DecodeIdx: 96
/* 6309 */    MCD::OPC_FilterValue, 193, 1, 6, 0, // Skip to: 6320
/* 6314 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6316 */    MCD::OPC_Decode, 232, 3, 96, // Opcode: AMSWAP_D, DecodeIdx: 96
/* 6320 */    MCD::OPC_FilterValue, 194, 1, 6, 0, // Skip to: 6331
/* 6325 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6327 */    MCD::OPC_Decode, 194, 3, 96, // Opcode: AMADD_W, DecodeIdx: 96
/* 6331 */    MCD::OPC_FilterValue, 195, 1, 6, 0, // Skip to: 6342
/* 6336 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6338 */    MCD::OPC_Decode, 192, 3, 96, // Opcode: AMADD_D, DecodeIdx: 96
/* 6342 */    MCD::OPC_FilterValue, 196, 1, 6, 0, // Skip to: 6353
/* 6347 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6349 */    MCD::OPC_Decode, 200, 3, 96, // Opcode: AMAND_W, DecodeIdx: 96
/* 6353 */    MCD::OPC_FilterValue, 197, 1, 6, 0, // Skip to: 6364
/* 6358 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6360 */    MCD::OPC_Decode, 199, 3, 96, // Opcode: AMAND_D, DecodeIdx: 96
/* 6364 */    MCD::OPC_FilterValue, 198, 1, 6, 0, // Skip to: 6375
/* 6369 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6371 */    MCD::OPC_Decode, 228, 3, 96, // Opcode: AMOR_W, DecodeIdx: 96
/* 6375 */    MCD::OPC_FilterValue, 199, 1, 6, 0, // Skip to: 6386
/* 6380 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6382 */    MCD::OPC_Decode, 227, 3, 96, // Opcode: AMOR_D, DecodeIdx: 96
/* 6386 */    MCD::OPC_FilterValue, 200, 1, 6, 0, // Skip to: 6397
/* 6391 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6393 */    MCD::OPC_Decode, 240, 3, 96, // Opcode: AMXOR_W, DecodeIdx: 96
/* 6397 */    MCD::OPC_FilterValue, 201, 1, 6, 0, // Skip to: 6408
/* 6402 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6404 */    MCD::OPC_Decode, 239, 3, 96, // Opcode: AMXOR_D, DecodeIdx: 96
/* 6408 */    MCD::OPC_FilterValue, 202, 1, 6, 0, // Skip to: 6419
/* 6413 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6415 */    MCD::OPC_Decode, 213, 3, 96, // Opcode: AMMAX_W, DecodeIdx: 96
/* 6419 */    MCD::OPC_FilterValue, 203, 1, 6, 0, // Skip to: 6430
/* 6424 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6426 */    MCD::OPC_Decode, 211, 3, 96, // Opcode: AMMAX_D, DecodeIdx: 96
/* 6430 */    MCD::OPC_FilterValue, 204, 1, 6, 0, // Skip to: 6441
/* 6435 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6437 */    MCD::OPC_Decode, 221, 3, 96, // Opcode: AMMIN_W, DecodeIdx: 96
/* 6441 */    MCD::OPC_FilterValue, 205, 1, 6, 0, // Skip to: 6452
/* 6446 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6448 */    MCD::OPC_Decode, 219, 3, 96, // Opcode: AMMIN_D, DecodeIdx: 96
/* 6452 */    MCD::OPC_FilterValue, 206, 1, 6, 0, // Skip to: 6463
/* 6457 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6459 */    MCD::OPC_Decode, 214, 3, 96, // Opcode: AMMAX_WU, DecodeIdx: 96
/* 6463 */    MCD::OPC_FilterValue, 207, 1, 6, 0, // Skip to: 6474
/* 6468 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6470 */    MCD::OPC_Decode, 212, 3, 96, // Opcode: AMMAX_DU, DecodeIdx: 96
/* 6474 */    MCD::OPC_FilterValue, 208, 1, 6, 0, // Skip to: 6485
/* 6479 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6481 */    MCD::OPC_Decode, 222, 3, 96, // Opcode: AMMIN_WU, DecodeIdx: 96
/* 6485 */    MCD::OPC_FilterValue, 209, 1, 6, 0, // Skip to: 6496
/* 6490 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6492 */    MCD::OPC_Decode, 220, 3, 96, // Opcode: AMMIN_DU, DecodeIdx: 96
/* 6496 */    MCD::OPC_FilterValue, 210, 1, 6, 0, // Skip to: 6507
/* 6501 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6503 */    MCD::OPC_Decode, 238, 3, 96, // Opcode: AMSWAP__DB_W, DecodeIdx: 96
/* 6507 */    MCD::OPC_FilterValue, 211, 1, 6, 0, // Skip to: 6518
/* 6512 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6514 */    MCD::OPC_Decode, 236, 3, 96, // Opcode: AMSWAP__DB_D, DecodeIdx: 96
/* 6518 */    MCD::OPC_FilterValue, 212, 1, 6, 0, // Skip to: 6529
/* 6523 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6525 */    MCD::OPC_Decode, 198, 3, 96, // Opcode: AMADD__DB_W, DecodeIdx: 96
/* 6529 */    MCD::OPC_FilterValue, 213, 1, 6, 0, // Skip to: 6540
/* 6534 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6536 */    MCD::OPC_Decode, 196, 3, 96, // Opcode: AMADD__DB_D, DecodeIdx: 96
/* 6540 */    MCD::OPC_FilterValue, 214, 1, 6, 0, // Skip to: 6551
/* 6545 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6547 */    MCD::OPC_Decode, 202, 3, 96, // Opcode: AMAND__DB_W, DecodeIdx: 96
/* 6551 */    MCD::OPC_FilterValue, 215, 1, 6, 0, // Skip to: 6562
/* 6556 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6558 */    MCD::OPC_Decode, 201, 3, 96, // Opcode: AMAND__DB_D, DecodeIdx: 96
/* 6562 */    MCD::OPC_FilterValue, 216, 1, 6, 0, // Skip to: 6573
/* 6567 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6569 */    MCD::OPC_Decode, 230, 3, 96, // Opcode: AMOR__DB_W, DecodeIdx: 96
/* 6573 */    MCD::OPC_FilterValue, 217, 1, 6, 0, // Skip to: 6584
/* 6578 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6580 */    MCD::OPC_Decode, 229, 3, 96, // Opcode: AMOR__DB_D, DecodeIdx: 96
/* 6584 */    MCD::OPC_FilterValue, 218, 1, 6, 0, // Skip to: 6595
/* 6589 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6591 */    MCD::OPC_Decode, 242, 3, 96, // Opcode: AMXOR__DB_W, DecodeIdx: 96
/* 6595 */    MCD::OPC_FilterValue, 219, 1, 6, 0, // Skip to: 6606
/* 6600 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6602 */    MCD::OPC_Decode, 241, 3, 96, // Opcode: AMXOR__DB_D, DecodeIdx: 96
/* 6606 */    MCD::OPC_FilterValue, 220, 1, 6, 0, // Skip to: 6617
/* 6611 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6613 */    MCD::OPC_Decode, 217, 3, 96, // Opcode: AMMAX__DB_W, DecodeIdx: 96
/* 6617 */    MCD::OPC_FilterValue, 221, 1, 6, 0, // Skip to: 6628
/* 6622 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6624 */    MCD::OPC_Decode, 215, 3, 96, // Opcode: AMMAX__DB_D, DecodeIdx: 96
/* 6628 */    MCD::OPC_FilterValue, 222, 1, 6, 0, // Skip to: 6639
/* 6633 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6635 */    MCD::OPC_Decode, 225, 3, 96, // Opcode: AMMIN__DB_W, DecodeIdx: 96
/* 6639 */    MCD::OPC_FilterValue, 223, 1, 6, 0, // Skip to: 6650
/* 6644 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6646 */    MCD::OPC_Decode, 223, 3, 96, // Opcode: AMMIN__DB_D, DecodeIdx: 96
/* 6650 */    MCD::OPC_FilterValue, 224, 1, 6, 0, // Skip to: 6661
/* 6655 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6657 */    MCD::OPC_Decode, 218, 3, 96, // Opcode: AMMAX__DB_WU, DecodeIdx: 96
/* 6661 */    MCD::OPC_FilterValue, 225, 1, 6, 0, // Skip to: 6672
/* 6666 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6668 */    MCD::OPC_Decode, 216, 3, 96, // Opcode: AMMAX__DB_DU, DecodeIdx: 96
/* 6672 */    MCD::OPC_FilterValue, 226, 1, 6, 0, // Skip to: 6683
/* 6677 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6679 */    MCD::OPC_Decode, 226, 3, 96, // Opcode: AMMIN__DB_WU, DecodeIdx: 96
/* 6683 */    MCD::OPC_FilterValue, 227, 1, 6, 0, // Skip to: 6694
/* 6688 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6690 */    MCD::OPC_Decode, 224, 3, 96, // Opcode: AMMIN__DB_DU, DecodeIdx: 96
/* 6694 */    MCD::OPC_FilterValue, 228, 1, 4, 0, // Skip to: 6703
/* 6699 */    MCD::OPC_Decode, 186, 4, 13, // Opcode: DBAR, DecodeIdx: 13
/* 6703 */    MCD::OPC_FilterValue, 229, 1, 4, 0, // Skip to: 6712
/* 6708 */    MCD::OPC_Decode, 213, 5, 13, // Opcode: IBAR, DecodeIdx: 13
/* 6712 */    MCD::OPC_FilterValue, 232, 1, 4, 0, // Skip to: 6721
/* 6717 */    MCD::OPC_Decode, 131, 5, 90, // Opcode: FLDGT_S, DecodeIdx: 90
/* 6721 */    MCD::OPC_FilterValue, 233, 1, 4, 0, // Skip to: 6730
/* 6726 */    MCD::OPC_Decode, 130, 5, 91, // Opcode: FLDGT_D, DecodeIdx: 91
/* 6730 */    MCD::OPC_FilterValue, 234, 1, 4, 0, // Skip to: 6739
/* 6735 */    MCD::OPC_Decode, 133, 5, 90, // Opcode: FLDLE_S, DecodeIdx: 90
/* 6739 */    MCD::OPC_FilterValue, 235, 1, 4, 0, // Skip to: 6748
/* 6744 */    MCD::OPC_Decode, 132, 5, 91, // Opcode: FLDLE_D, DecodeIdx: 91
/* 6748 */    MCD::OPC_FilterValue, 236, 1, 4, 0, // Skip to: 6757
/* 6753 */    MCD::OPC_Decode, 179, 5, 90, // Opcode: FSTGT_S, DecodeIdx: 90
/* 6757 */    MCD::OPC_FilterValue, 237, 1, 4, 0, // Skip to: 6766
/* 6762 */    MCD::OPC_Decode, 178, 5, 91, // Opcode: FSTGT_D, DecodeIdx: 91
/* 6766 */    MCD::OPC_FilterValue, 238, 1, 4, 0, // Skip to: 6775
/* 6771 */    MCD::OPC_Decode, 181, 5, 90, // Opcode: FSTLE_S, DecodeIdx: 90
/* 6775 */    MCD::OPC_FilterValue, 239, 1, 4, 0, // Skip to: 6784
/* 6780 */    MCD::OPC_Decode, 180, 5, 91, // Opcode: FSTLE_D, DecodeIdx: 91
/* 6784 */    MCD::OPC_FilterValue, 240, 1, 6, 0, // Skip to: 6795
/* 6789 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6791 */    MCD::OPC_Decode, 228, 5, 11, // Opcode: LDGT_B, DecodeIdx: 11
/* 6795 */    MCD::OPC_FilterValue, 241, 1, 6, 0, // Skip to: 6806
/* 6800 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6802 */    MCD::OPC_Decode, 230, 5, 11, // Opcode: LDGT_H, DecodeIdx: 11
/* 6806 */    MCD::OPC_FilterValue, 242, 1, 6, 0, // Skip to: 6817
/* 6811 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6813 */    MCD::OPC_Decode, 231, 5, 11, // Opcode: LDGT_W, DecodeIdx: 11
/* 6817 */    MCD::OPC_FilterValue, 243, 1, 6, 0, // Skip to: 6828
/* 6822 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6824 */    MCD::OPC_Decode, 229, 5, 11, // Opcode: LDGT_D, DecodeIdx: 11
/* 6828 */    MCD::OPC_FilterValue, 244, 1, 6, 0, // Skip to: 6839
/* 6833 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6835 */    MCD::OPC_Decode, 232, 5, 11, // Opcode: LDLE_B, DecodeIdx: 11
/* 6839 */    MCD::OPC_FilterValue, 245, 1, 6, 0, // Skip to: 6850
/* 6844 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6846 */    MCD::OPC_Decode, 234, 5, 11, // Opcode: LDLE_H, DecodeIdx: 11
/* 6850 */    MCD::OPC_FilterValue, 246, 1, 6, 0, // Skip to: 6861
/* 6855 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6857 */    MCD::OPC_Decode, 235, 5, 11, // Opcode: LDLE_W, DecodeIdx: 11
/* 6861 */    MCD::OPC_FilterValue, 247, 1, 6, 0, // Skip to: 6872
/* 6866 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6868 */    MCD::OPC_Decode, 233, 5, 11, // Opcode: LDLE_D, DecodeIdx: 11
/* 6872 */    MCD::OPC_FilterValue, 248, 1, 6, 0, // Skip to: 6883
/* 6877 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6879 */    MCD::OPC_Decode, 232, 6, 11, // Opcode: STGT_B, DecodeIdx: 11
/* 6883 */    MCD::OPC_FilterValue, 249, 1, 6, 0, // Skip to: 6894
/* 6888 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6890 */    MCD::OPC_Decode, 234, 6, 11, // Opcode: STGT_H, DecodeIdx: 11
/* 6894 */    MCD::OPC_FilterValue, 250, 1, 6, 0, // Skip to: 6905
/* 6899 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6901 */    MCD::OPC_Decode, 235, 6, 11, // Opcode: STGT_W, DecodeIdx: 11
/* 6905 */    MCD::OPC_FilterValue, 251, 1, 6, 0, // Skip to: 6916
/* 6910 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6912 */    MCD::OPC_Decode, 233, 6, 11, // Opcode: STGT_D, DecodeIdx: 11
/* 6916 */    MCD::OPC_FilterValue, 252, 1, 6, 0, // Skip to: 6927
/* 6921 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6923 */    MCD::OPC_Decode, 236, 6, 11, // Opcode: STLE_B, DecodeIdx: 11
/* 6927 */    MCD::OPC_FilterValue, 253, 1, 6, 0, // Skip to: 6938
/* 6932 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6934 */    MCD::OPC_Decode, 238, 6, 11, // Opcode: STLE_H, DecodeIdx: 11
/* 6938 */    MCD::OPC_FilterValue, 254, 1, 6, 0, // Skip to: 6949
/* 6943 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6945 */    MCD::OPC_Decode, 239, 6, 11, // Opcode: STLE_W, DecodeIdx: 11
/* 6949 */    MCD::OPC_FilterValueOrFail, 255, 1, 
/* 6952 */    MCD::OPC_CheckPredicateOrFail, 0, 
/* 6954 */    MCD::OPC_Decode, 237, 6, 11, // Opcode: STLE_D, DecodeIdx: 11
/* 6958 */    MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 6966
/* 6962 */    MCD::OPC_Decode, 146, 4, 97, // Opcode: BEQZ, DecodeIdx: 97
/* 6966 */    MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 6974
/* 6970 */    MCD::OPC_Decode, 157, 4, 97, // Opcode: BNEZ, DecodeIdx: 97
/* 6974 */    MCD::OPC_FilterValue, 18, 41, 0, // Skip to: 7019
/* 6978 */    MCD::OPC_ExtractField, 8, 2,  // Inst{9-8} ...
/* 6981 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 6989
/* 6985 */    MCD::OPC_Decode, 143, 4, 98, // Opcode: BCEQZ, DecodeIdx: 98
/* 6989 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 6997
/* 6993 */    MCD::OPC_Decode, 144, 4, 98, // Opcode: BCNEZ, DecodeIdx: 98
/* 6997 */    MCD::OPC_FilterValue, 2, 8, 0, // Skip to: 7009
/* 7001 */    MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 7005 */    MCD::OPC_Decode, 225, 5, 99, // Opcode: JISCR0, DecodeIdx: 99
/* 7009 */    MCD::OPC_FilterValueOrFail, 3, 
/* 7011 */    MCD::OPC_CheckFieldOrFail, 5, 3, 0, 
/* 7015 */    MCD::OPC_Decode, 226, 5, 99, // Opcode: JISCR1, DecodeIdx: 99
/* 7019 */    MCD::OPC_FilterValue, 19, 4, 0, // Skip to: 7027
/* 7023 */    MCD::OPC_Decode, 224, 5, 100, // Opcode: JIRL, DecodeIdx: 100
/* 7027 */    MCD::OPC_FilterValue, 20, 4, 0, // Skip to: 7035
/* 7031 */    MCD::OPC_Decode, 142, 4, 101, // Opcode: B, DecodeIdx: 101
/* 7035 */    MCD::OPC_FilterValue, 21, 4, 0, // Skip to: 7043
/* 7039 */    MCD::OPC_Decode, 153, 4, 101, // Opcode: BL, DecodeIdx: 101
/* 7043 */    MCD::OPC_FilterValue, 22, 4, 0, // Skip to: 7051
/* 7047 */    MCD::OPC_Decode, 145, 4, 102, // Opcode: BEQ, DecodeIdx: 102
/* 7051 */    MCD::OPC_FilterValue, 23, 4, 0, // Skip to: 7059
/* 7055 */    MCD::OPC_Decode, 156, 4, 102, // Opcode: BNE, DecodeIdx: 102
/* 7059 */    MCD::OPC_FilterValue, 24, 4, 0, // Skip to: 7067
/* 7063 */    MCD::OPC_Decode, 154, 4, 102, // Opcode: BLT, DecodeIdx: 102
/* 7067 */    MCD::OPC_FilterValue, 25, 4, 0, // Skip to: 7075
/* 7071 */    MCD::OPC_Decode, 147, 4, 102, // Opcode: BGE, DecodeIdx: 102
/* 7075 */    MCD::OPC_FilterValue, 26, 4, 0, // Skip to: 7083
/* 7079 */    MCD::OPC_Decode, 155, 4, 102, // Opcode: BLTU, DecodeIdx: 102
/* 7083 */    MCD::OPC_FilterValue, 27, 4, 0, // Skip to: 7091
/* 7087 */    MCD::OPC_Decode, 148, 4, 102, // Opcode: BGEU, DecodeIdx: 102
/* 7091 */    MCD::OPC_FilterValue, 28, 83, 24, // Skip to: 13322
/* 7095 */    MCD::OPC_ExtractField, 18, 8,  // Inst{25-18} ...
/* 7098 */    MCD::OPC_FilterValue, 0, 65, 0, // Skip to: 7167
/* 7102 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7105 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7113
/* 7109 */    MCD::OPC_Decode, 250, 10, 63, // Opcode: VSEQ_B, DecodeIdx: 63
/* 7113 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7121
/* 7117 */    MCD::OPC_Decode, 252, 10, 63, // Opcode: VSEQ_H, DecodeIdx: 63
/* 7121 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7129
/* 7125 */    MCD::OPC_Decode, 253, 10, 63, // Opcode: VSEQ_W, DecodeIdx: 63
/* 7129 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 7137
/* 7133 */    MCD::OPC_Decode, 251, 10, 63, // Opcode: VSEQ_D, DecodeIdx: 63
/* 7137 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7145
/* 7141 */    MCD::OPC_Decode, 156, 11, 63, // Opcode: VSLE_B, DecodeIdx: 63
/* 7145 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7153
/* 7149 */    MCD::OPC_Decode, 160, 11, 63, // Opcode: VSLE_H, DecodeIdx: 63
/* 7153 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7161
/* 7157 */    MCD::OPC_Decode, 162, 11, 63, // Opcode: VSLE_W, DecodeIdx: 63
/* 7161 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7163 */    MCD::OPC_Decode, 158, 11, 63, // Opcode: VSLE_D, DecodeIdx: 63
/* 7167 */    MCD::OPC_FilterValue, 1, 65, 0, // Skip to: 7236
/* 7171 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7174 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7182
/* 7178 */    MCD::OPC_Decode, 157, 11, 63, // Opcode: VSLE_BU, DecodeIdx: 63
/* 7182 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7190
/* 7186 */    MCD::OPC_Decode, 161, 11, 63, // Opcode: VSLE_HU, DecodeIdx: 63
/* 7190 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7198
/* 7194 */    MCD::OPC_Decode, 163, 11, 63, // Opcode: VSLE_WU, DecodeIdx: 63
/* 7198 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 7206
/* 7202 */    MCD::OPC_Decode, 159, 11, 63, // Opcode: VSLE_DU, DecodeIdx: 63
/* 7206 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7214
/* 7210 */    MCD::OPC_Decode, 186, 11, 63, // Opcode: VSLT_B, DecodeIdx: 63
/* 7214 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7222
/* 7218 */    MCD::OPC_Decode, 190, 11, 63, // Opcode: VSLT_H, DecodeIdx: 63
/* 7222 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7230
/* 7226 */    MCD::OPC_Decode, 192, 11, 63, // Opcode: VSLT_W, DecodeIdx: 63
/* 7230 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7232 */    MCD::OPC_Decode, 188, 11, 63, // Opcode: VSLT_D, DecodeIdx: 63
/* 7236 */    MCD::OPC_FilterValue, 2, 65, 0, // Skip to: 7305
/* 7240 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7243 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7251
/* 7247 */    MCD::OPC_Decode, 187, 11, 63, // Opcode: VSLT_BU, DecodeIdx: 63
/* 7251 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7259
/* 7255 */    MCD::OPC_Decode, 191, 11, 63, // Opcode: VSLT_HU, DecodeIdx: 63
/* 7259 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7267
/* 7263 */    MCD::OPC_Decode, 193, 11, 63, // Opcode: VSLT_WU, DecodeIdx: 63
/* 7267 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 7275
/* 7271 */    MCD::OPC_Decode, 189, 11, 63, // Opcode: VSLT_DU, DecodeIdx: 63
/* 7275 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7283
/* 7279 */    MCD::OPC_Decode, 175, 7, 63, // Opcode: VADD_B, DecodeIdx: 63
/* 7283 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7291
/* 7287 */    MCD::OPC_Decode, 177, 7, 63, // Opcode: VADD_H, DecodeIdx: 63
/* 7291 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7299
/* 7295 */    MCD::OPC_Decode, 179, 7, 63, // Opcode: VADD_W, DecodeIdx: 63
/* 7299 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7301 */    MCD::OPC_Decode, 176, 7, 63, // Opcode: VADD_D, DecodeIdx: 63
/* 7305 */    MCD::OPC_FilterValue, 3, 33, 0, // Skip to: 7342
/* 7309 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7312 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7320
/* 7316 */    MCD::OPC_Decode, 216, 12, 63, // Opcode: VSUB_B, DecodeIdx: 63
/* 7320 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7328
/* 7324 */    MCD::OPC_Decode, 218, 12, 63, // Opcode: VSUB_H, DecodeIdx: 63
/* 7328 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7336
/* 7332 */    MCD::OPC_Decode, 220, 12, 63, // Opcode: VSUB_W, DecodeIdx: 63
/* 7336 */    MCD::OPC_FilterValueOrFail, 3, 
/* 7338 */    MCD::OPC_Decode, 217, 12, 63, // Opcode: VSUB_D, DecodeIdx: 63
/* 7342 */    MCD::OPC_FilterValue, 7, 33, 0, // Skip to: 7379
/* 7346 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7349 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7357
/* 7353 */    MCD::OPC_Decode, 154, 7, 63, // Opcode: VADDWEV_H_B, DecodeIdx: 63
/* 7357 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7365
/* 7361 */    MCD::OPC_Decode, 160, 7, 63, // Opcode: VADDWEV_W_H, DecodeIdx: 63
/* 7365 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7373
/* 7369 */    MCD::OPC_Decode, 151, 7, 63, // Opcode: VADDWEV_D_W, DecodeIdx: 63
/* 7373 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7375 */    MCD::OPC_Decode, 157, 7, 63, // Opcode: VADDWEV_Q_D, DecodeIdx: 63
/* 7379 */    MCD::OPC_FilterValue, 8, 65, 0, // Skip to: 7448
/* 7383 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7386 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7394
/* 7390 */    MCD::OPC_Decode, 202, 12, 63, // Opcode: VSUBWEV_H_B, DecodeIdx: 63
/* 7394 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7402
/* 7398 */    MCD::OPC_Decode, 206, 12, 63, // Opcode: VSUBWEV_W_H, DecodeIdx: 63
/* 7402 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7410
/* 7406 */    MCD::OPC_Decode, 200, 12, 63, // Opcode: VSUBWEV_D_W, DecodeIdx: 63
/* 7410 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 7418
/* 7414 */    MCD::OPC_Decode, 204, 12, 63, // Opcode: VSUBWEV_Q_D, DecodeIdx: 63
/* 7418 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7426
/* 7422 */    MCD::OPC_Decode, 166, 7, 63, // Opcode: VADDWOD_H_B, DecodeIdx: 63
/* 7426 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7434
/* 7430 */    MCD::OPC_Decode, 172, 7, 63, // Opcode: VADDWOD_W_H, DecodeIdx: 63
/* 7434 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7442
/* 7438 */    MCD::OPC_Decode, 163, 7, 63, // Opcode: VADDWOD_D_W, DecodeIdx: 63
/* 7442 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7444 */    MCD::OPC_Decode, 169, 7, 63, // Opcode: VADDWOD_Q_D, DecodeIdx: 63
/* 7448 */    MCD::OPC_FilterValue, 9, 33, 0, // Skip to: 7485
/* 7452 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7455 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7463
/* 7459 */    MCD::OPC_Decode, 210, 12, 63, // Opcode: VSUBWOD_H_B, DecodeIdx: 63
/* 7463 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7471
/* 7467 */    MCD::OPC_Decode, 214, 12, 63, // Opcode: VSUBWOD_W_H, DecodeIdx: 63
/* 7471 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7479
/* 7475 */    MCD::OPC_Decode, 208, 12, 63, // Opcode: VSUBWOD_D_W, DecodeIdx: 63
/* 7479 */    MCD::OPC_FilterValueOrFail, 3, 
/* 7481 */    MCD::OPC_Decode, 212, 12, 63, // Opcode: VSUBWOD_Q_D, DecodeIdx: 63
/* 7485 */    MCD::OPC_FilterValue, 11, 33, 0, // Skip to: 7522
/* 7489 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7492 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7500
/* 7496 */    MCD::OPC_Decode, 155, 7, 63, // Opcode: VADDWEV_H_BU, DecodeIdx: 63
/* 7500 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7508
/* 7504 */    MCD::OPC_Decode, 161, 7, 63, // Opcode: VADDWEV_W_HU, DecodeIdx: 63
/* 7508 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7516
/* 7512 */    MCD::OPC_Decode, 152, 7, 63, // Opcode: VADDWEV_D_WU, DecodeIdx: 63
/* 7516 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7518 */    MCD::OPC_Decode, 158, 7, 63, // Opcode: VADDWEV_Q_DU, DecodeIdx: 63
/* 7522 */    MCD::OPC_FilterValue, 12, 65, 0, // Skip to: 7591
/* 7526 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7529 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7537
/* 7533 */    MCD::OPC_Decode, 203, 12, 63, // Opcode: VSUBWEV_H_BU, DecodeIdx: 63
/* 7537 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7545
/* 7541 */    MCD::OPC_Decode, 207, 12, 63, // Opcode: VSUBWEV_W_HU, DecodeIdx: 63
/* 7545 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7553
/* 7549 */    MCD::OPC_Decode, 201, 12, 63, // Opcode: VSUBWEV_D_WU, DecodeIdx: 63
/* 7553 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 7561
/* 7557 */    MCD::OPC_Decode, 205, 12, 63, // Opcode: VSUBWEV_Q_DU, DecodeIdx: 63
/* 7561 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7569
/* 7565 */    MCD::OPC_Decode, 167, 7, 63, // Opcode: VADDWOD_H_BU, DecodeIdx: 63
/* 7569 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7577
/* 7573 */    MCD::OPC_Decode, 173, 7, 63, // Opcode: VADDWOD_W_HU, DecodeIdx: 63
/* 7577 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7585
/* 7581 */    MCD::OPC_Decode, 164, 7, 63, // Opcode: VADDWOD_D_WU, DecodeIdx: 63
/* 7585 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7587 */    MCD::OPC_Decode, 170, 7, 63, // Opcode: VADDWOD_Q_DU, DecodeIdx: 63
/* 7591 */    MCD::OPC_FilterValue, 13, 33, 0, // Skip to: 7628
/* 7595 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7598 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7606
/* 7602 */    MCD::OPC_Decode, 211, 12, 63, // Opcode: VSUBWOD_H_BU, DecodeIdx: 63
/* 7606 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7614
/* 7610 */    MCD::OPC_Decode, 215, 12, 63, // Opcode: VSUBWOD_W_HU, DecodeIdx: 63
/* 7614 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7622
/* 7618 */    MCD::OPC_Decode, 209, 12, 63, // Opcode: VSUBWOD_D_WU, DecodeIdx: 63
/* 7622 */    MCD::OPC_FilterValueOrFail, 3, 
/* 7624 */    MCD::OPC_Decode, 213, 12, 63, // Opcode: VSUBWOD_Q_DU, DecodeIdx: 63
/* 7628 */    MCD::OPC_FilterValue, 15, 33, 0, // Skip to: 7665
/* 7632 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7635 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7643
/* 7639 */    MCD::OPC_Decode, 156, 7, 63, // Opcode: VADDWEV_H_BU_B, DecodeIdx: 63
/* 7643 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7651
/* 7647 */    MCD::OPC_Decode, 162, 7, 63, // Opcode: VADDWEV_W_HU_H, DecodeIdx: 63
/* 7651 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7659
/* 7655 */    MCD::OPC_Decode, 153, 7, 63, // Opcode: VADDWEV_D_WU_W, DecodeIdx: 63
/* 7659 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7661 */    MCD::OPC_Decode, 159, 7, 63, // Opcode: VADDWEV_Q_DU_D, DecodeIdx: 63
/* 7665 */    MCD::OPC_FilterValue, 16, 33, 0, // Skip to: 7702
/* 7669 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7672 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7680
/* 7676 */    MCD::OPC_Decode, 168, 7, 63, // Opcode: VADDWOD_H_BU_B, DecodeIdx: 63
/* 7680 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7688
/* 7684 */    MCD::OPC_Decode, 174, 7, 63, // Opcode: VADDWOD_W_HU_H, DecodeIdx: 63
/* 7688 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7696
/* 7692 */    MCD::OPC_Decode, 165, 7, 63, // Opcode: VADDWOD_D_WU_W, DecodeIdx: 63
/* 7696 */    MCD::OPC_FilterValueOrFail, 3, 
/* 7698 */    MCD::OPC_Decode, 171, 7, 63, // Opcode: VADDWOD_Q_DU_D, DecodeIdx: 63
/* 7702 */    MCD::OPC_FilterValue, 17, 33, 0, // Skip to: 7739
/* 7706 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7709 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7717
/* 7713 */    MCD::OPC_Decode, 230, 10, 63, // Opcode: VSADD_B, DecodeIdx: 63
/* 7717 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7725
/* 7721 */    MCD::OPC_Decode, 234, 10, 63, // Opcode: VSADD_H, DecodeIdx: 63
/* 7725 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7733
/* 7729 */    MCD::OPC_Decode, 236, 10, 63, // Opcode: VSADD_W, DecodeIdx: 63
/* 7733 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7735 */    MCD::OPC_Decode, 232, 10, 63, // Opcode: VSADD_D, DecodeIdx: 63
/* 7739 */    MCD::OPC_FilterValue, 18, 65, 0, // Skip to: 7808
/* 7743 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7746 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7754
/* 7750 */    MCD::OPC_Decode, 182, 12, 63, // Opcode: VSSUB_B, DecodeIdx: 63
/* 7754 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7762
/* 7758 */    MCD::OPC_Decode, 186, 12, 63, // Opcode: VSSUB_H, DecodeIdx: 63
/* 7762 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7770
/* 7766 */    MCD::OPC_Decode, 188, 12, 63, // Opcode: VSSUB_W, DecodeIdx: 63
/* 7770 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 7778
/* 7774 */    MCD::OPC_Decode, 184, 12, 63, // Opcode: VSSUB_D, DecodeIdx: 63
/* 7778 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7786
/* 7782 */    MCD::OPC_Decode, 231, 10, 63, // Opcode: VSADD_BU, DecodeIdx: 63
/* 7786 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7794
/* 7790 */    MCD::OPC_Decode, 235, 10, 63, // Opcode: VSADD_HU, DecodeIdx: 63
/* 7794 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7802
/* 7798 */    MCD::OPC_Decode, 237, 10, 63, // Opcode: VSADD_WU, DecodeIdx: 63
/* 7802 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7804 */    MCD::OPC_Decode, 233, 10, 63, // Opcode: VSADD_DU, DecodeIdx: 63
/* 7808 */    MCD::OPC_FilterValue, 19, 33, 0, // Skip to: 7845
/* 7812 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7815 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7823
/* 7819 */    MCD::OPC_Decode, 183, 12, 63, // Opcode: VSSUB_BU, DecodeIdx: 63
/* 7823 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7831
/* 7827 */    MCD::OPC_Decode, 187, 12, 63, // Opcode: VSSUB_HU, DecodeIdx: 63
/* 7831 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7839
/* 7835 */    MCD::OPC_Decode, 189, 12, 63, // Opcode: VSSUB_WU, DecodeIdx: 63
/* 7839 */    MCD::OPC_FilterValueOrFail, 3, 
/* 7841 */    MCD::OPC_Decode, 185, 12, 63, // Opcode: VSSUB_DU, DecodeIdx: 63
/* 7845 */    MCD::OPC_FilterValue, 21, 65, 0, // Skip to: 7914
/* 7849 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7852 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7860
/* 7856 */    MCD::OPC_Decode, 154, 9, 63, // Opcode: VHADDW_H_B, DecodeIdx: 63
/* 7860 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7868
/* 7864 */    MCD::OPC_Decode, 158, 9, 63, // Opcode: VHADDW_W_H, DecodeIdx: 63
/* 7868 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7876
/* 7872 */    MCD::OPC_Decode, 152, 9, 63, // Opcode: VHADDW_D_W, DecodeIdx: 63
/* 7876 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 7884
/* 7880 */    MCD::OPC_Decode, 156, 9, 63, // Opcode: VHADDW_Q_D, DecodeIdx: 63
/* 7884 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7892
/* 7888 */    MCD::OPC_Decode, 162, 9, 63, // Opcode: VHSUBW_H_B, DecodeIdx: 63
/* 7892 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7900
/* 7896 */    MCD::OPC_Decode, 166, 9, 63, // Opcode: VHSUBW_W_H, DecodeIdx: 63
/* 7900 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7908
/* 7904 */    MCD::OPC_Decode, 160, 9, 63, // Opcode: VHSUBW_D_W, DecodeIdx: 63
/* 7908 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7910 */    MCD::OPC_Decode, 164, 9, 63, // Opcode: VHSUBW_Q_D, DecodeIdx: 63
/* 7914 */    MCD::OPC_FilterValue, 22, 65, 0, // Skip to: 7983
/* 7918 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7921 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7929
/* 7925 */    MCD::OPC_Decode, 153, 9, 63, // Opcode: VHADDW_HU_BU, DecodeIdx: 63
/* 7929 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 7937
/* 7933 */    MCD::OPC_Decode, 157, 9, 63, // Opcode: VHADDW_WU_HU, DecodeIdx: 63
/* 7937 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 7945
/* 7941 */    MCD::OPC_Decode, 151, 9, 63, // Opcode: VHADDW_DU_WU, DecodeIdx: 63
/* 7945 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 7953
/* 7949 */    MCD::OPC_Decode, 155, 9, 63, // Opcode: VHADDW_QU_DU, DecodeIdx: 63
/* 7953 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 7961
/* 7957 */    MCD::OPC_Decode, 161, 9, 63, // Opcode: VHSUBW_HU_BU, DecodeIdx: 63
/* 7961 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 7969
/* 7965 */    MCD::OPC_Decode, 165, 9, 63, // Opcode: VHSUBW_WU_HU, DecodeIdx: 63
/* 7969 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 7977
/* 7973 */    MCD::OPC_Decode, 159, 9, 63, // Opcode: VHSUBW_DU_WU, DecodeIdx: 63
/* 7977 */    MCD::OPC_FilterValueOrFail, 7, 
/* 7979 */    MCD::OPC_Decode, 163, 9, 63, // Opcode: VHSUBW_QU_DU, DecodeIdx: 63
/* 7983 */    MCD::OPC_FilterValue, 23, 33, 0, // Skip to: 8020
/* 7987 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 7990 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 7998
/* 7994 */    MCD::OPC_Decode, 143, 7, 63, // Opcode: VADDA_B, DecodeIdx: 63
/* 7998 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8006
/* 8002 */    MCD::OPC_Decode, 145, 7, 63, // Opcode: VADDA_H, DecodeIdx: 63
/* 8006 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8014
/* 8010 */    MCD::OPC_Decode, 146, 7, 63, // Opcode: VADDA_W, DecodeIdx: 63
/* 8014 */    MCD::OPC_FilterValueOrFail, 3, 
/* 8016 */    MCD::OPC_Decode, 144, 7, 63, // Opcode: VADDA_D, DecodeIdx: 63
/* 8020 */    MCD::OPC_FilterValue, 24, 65, 0, // Skip to: 8089
/* 8024 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8027 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8035
/* 8031 */    MCD::OPC_Decode, 135, 7, 63, // Opcode: VABSD_B, DecodeIdx: 63
/* 8035 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8043
/* 8039 */    MCD::OPC_Decode, 139, 7, 63, // Opcode: VABSD_H, DecodeIdx: 63
/* 8043 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8051
/* 8047 */    MCD::OPC_Decode, 141, 7, 63, // Opcode: VABSD_W, DecodeIdx: 63
/* 8051 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8059
/* 8055 */    MCD::OPC_Decode, 137, 7, 63, // Opcode: VABSD_D, DecodeIdx: 63
/* 8059 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8067
/* 8063 */    MCD::OPC_Decode, 136, 7, 63, // Opcode: VABSD_BU, DecodeIdx: 63
/* 8067 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8075
/* 8071 */    MCD::OPC_Decode, 140, 7, 63, // Opcode: VABSD_HU, DecodeIdx: 63
/* 8075 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8083
/* 8079 */    MCD::OPC_Decode, 142, 7, 63, // Opcode: VABSD_WU, DecodeIdx: 63
/* 8083 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8085 */    MCD::OPC_Decode, 138, 7, 63, // Opcode: VABSD_DU, DecodeIdx: 63
/* 8089 */    MCD::OPC_FilterValue, 25, 65, 0, // Skip to: 8158
/* 8093 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8096 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8104
/* 8100 */    MCD::OPC_Decode, 191, 7, 63, // Opcode: VAVG_B, DecodeIdx: 63
/* 8104 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8112
/* 8108 */    MCD::OPC_Decode, 195, 7, 63, // Opcode: VAVG_H, DecodeIdx: 63
/* 8112 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8120
/* 8116 */    MCD::OPC_Decode, 197, 7, 63, // Opcode: VAVG_W, DecodeIdx: 63
/* 8120 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8128
/* 8124 */    MCD::OPC_Decode, 193, 7, 63, // Opcode: VAVG_D, DecodeIdx: 63
/* 8128 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8136
/* 8132 */    MCD::OPC_Decode, 192, 7, 63, // Opcode: VAVG_BU, DecodeIdx: 63
/* 8136 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8144
/* 8140 */    MCD::OPC_Decode, 196, 7, 63, // Opcode: VAVG_HU, DecodeIdx: 63
/* 8144 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8152
/* 8148 */    MCD::OPC_Decode, 198, 7, 63, // Opcode: VAVG_WU, DecodeIdx: 63
/* 8152 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8154 */    MCD::OPC_Decode, 194, 7, 63, // Opcode: VAVG_DU, DecodeIdx: 63
/* 8158 */    MCD::OPC_FilterValue, 26, 65, 0, // Skip to: 8227
/* 8162 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8165 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8173
/* 8169 */    MCD::OPC_Decode, 183, 7, 63, // Opcode: VAVGR_B, DecodeIdx: 63
/* 8173 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8181
/* 8177 */    MCD::OPC_Decode, 187, 7, 63, // Opcode: VAVGR_H, DecodeIdx: 63
/* 8181 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8189
/* 8185 */    MCD::OPC_Decode, 189, 7, 63, // Opcode: VAVGR_W, DecodeIdx: 63
/* 8189 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8197
/* 8193 */    MCD::OPC_Decode, 185, 7, 63, // Opcode: VAVGR_D, DecodeIdx: 63
/* 8197 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8205
/* 8201 */    MCD::OPC_Decode, 184, 7, 63, // Opcode: VAVGR_BU, DecodeIdx: 63
/* 8205 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8213
/* 8209 */    MCD::OPC_Decode, 188, 7, 63, // Opcode: VAVGR_HU, DecodeIdx: 63
/* 8213 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8221
/* 8217 */    MCD::OPC_Decode, 190, 7, 63, // Opcode: VAVGR_WU, DecodeIdx: 63
/* 8221 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8223 */    MCD::OPC_Decode, 186, 7, 63, // Opcode: VAVGR_DU, DecodeIdx: 63
/* 8227 */    MCD::OPC_FilterValue, 28, 65, 0, // Skip to: 8296
/* 8231 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8234 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8242
/* 8238 */    MCD::OPC_Decode, 222, 9, 63, // Opcode: VMAX_B, DecodeIdx: 63
/* 8242 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8250
/* 8246 */    MCD::OPC_Decode, 226, 9, 63, // Opcode: VMAX_H, DecodeIdx: 63
/* 8250 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8258
/* 8254 */    MCD::OPC_Decode, 228, 9, 63, // Opcode: VMAX_W, DecodeIdx: 63
/* 8258 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8266
/* 8262 */    MCD::OPC_Decode, 224, 9, 63, // Opcode: VMAX_D, DecodeIdx: 63
/* 8266 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8274
/* 8270 */    MCD::OPC_Decode, 238, 9, 63, // Opcode: VMIN_B, DecodeIdx: 63
/* 8274 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8282
/* 8278 */    MCD::OPC_Decode, 242, 9, 63, // Opcode: VMIN_H, DecodeIdx: 63
/* 8282 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8290
/* 8286 */    MCD::OPC_Decode, 244, 9, 63, // Opcode: VMIN_W, DecodeIdx: 63
/* 8290 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8292 */    MCD::OPC_Decode, 240, 9, 63, // Opcode: VMIN_D, DecodeIdx: 63
/* 8296 */    MCD::OPC_FilterValue, 29, 65, 0, // Skip to: 8365
/* 8300 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8303 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8311
/* 8307 */    MCD::OPC_Decode, 223, 9, 63, // Opcode: VMAX_BU, DecodeIdx: 63
/* 8311 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8319
/* 8315 */    MCD::OPC_Decode, 227, 9, 63, // Opcode: VMAX_HU, DecodeIdx: 63
/* 8319 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8327
/* 8323 */    MCD::OPC_Decode, 229, 9, 63, // Opcode: VMAX_WU, DecodeIdx: 63
/* 8327 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8335
/* 8331 */    MCD::OPC_Decode, 225, 9, 63, // Opcode: VMAX_DU, DecodeIdx: 63
/* 8335 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8343
/* 8339 */    MCD::OPC_Decode, 239, 9, 63, // Opcode: VMIN_BU, DecodeIdx: 63
/* 8343 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8351
/* 8347 */    MCD::OPC_Decode, 243, 9, 63, // Opcode: VMIN_HU, DecodeIdx: 63
/* 8351 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8359
/* 8355 */    MCD::OPC_Decode, 245, 9, 63, // Opcode: VMIN_WU, DecodeIdx: 63
/* 8359 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8361 */    MCD::OPC_Decode, 241, 9, 63, // Opcode: VMIN_DU, DecodeIdx: 63
/* 8365 */    MCD::OPC_FilterValue, 33, 65, 0, // Skip to: 8434
/* 8369 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8372 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8380
/* 8376 */    MCD::OPC_Decode, 168, 10, 63, // Opcode: VMUL_B, DecodeIdx: 63
/* 8380 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8388
/* 8384 */    MCD::OPC_Decode, 170, 10, 63, // Opcode: VMUL_H, DecodeIdx: 63
/* 8388 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8396
/* 8392 */    MCD::OPC_Decode, 171, 10, 63, // Opcode: VMUL_W, DecodeIdx: 63
/* 8396 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8404
/* 8400 */    MCD::OPC_Decode, 169, 10, 63, // Opcode: VMUL_D, DecodeIdx: 63
/* 8404 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8412
/* 8408 */    MCD::OPC_Decode, 136, 10, 63, // Opcode: VMUH_B, DecodeIdx: 63
/* 8412 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8420
/* 8416 */    MCD::OPC_Decode, 140, 10, 63, // Opcode: VMUH_H, DecodeIdx: 63
/* 8420 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8428
/* 8424 */    MCD::OPC_Decode, 142, 10, 63, // Opcode: VMUH_W, DecodeIdx: 63
/* 8428 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8430 */    MCD::OPC_Decode, 138, 10, 63, // Opcode: VMUH_D, DecodeIdx: 63
/* 8434 */    MCD::OPC_FilterValue, 34, 33, 0, // Skip to: 8471
/* 8438 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8441 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8449
/* 8445 */    MCD::OPC_Decode, 137, 10, 63, // Opcode: VMUH_BU, DecodeIdx: 63
/* 8449 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8457
/* 8453 */    MCD::OPC_Decode, 141, 10, 63, // Opcode: VMUH_HU, DecodeIdx: 63
/* 8457 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8465
/* 8461 */    MCD::OPC_Decode, 143, 10, 63, // Opcode: VMUH_WU, DecodeIdx: 63
/* 8465 */    MCD::OPC_FilterValueOrFail, 3, 
/* 8467 */    MCD::OPC_Decode, 139, 10, 63, // Opcode: VMUH_DU, DecodeIdx: 63
/* 8471 */    MCD::OPC_FilterValue, 36, 65, 0, // Skip to: 8540
/* 8475 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8478 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8486
/* 8482 */    MCD::OPC_Decode, 147, 10, 63, // Opcode: VMULWEV_H_B, DecodeIdx: 63
/* 8486 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8494
/* 8490 */    MCD::OPC_Decode, 153, 10, 63, // Opcode: VMULWEV_W_H, DecodeIdx: 63
/* 8494 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8502
/* 8498 */    MCD::OPC_Decode, 144, 10, 63, // Opcode: VMULWEV_D_W, DecodeIdx: 63
/* 8502 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8510
/* 8506 */    MCD::OPC_Decode, 150, 10, 63, // Opcode: VMULWEV_Q_D, DecodeIdx: 63
/* 8510 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8518
/* 8514 */    MCD::OPC_Decode, 159, 10, 63, // Opcode: VMULWOD_H_B, DecodeIdx: 63
/* 8518 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8526
/* 8522 */    MCD::OPC_Decode, 165, 10, 63, // Opcode: VMULWOD_W_H, DecodeIdx: 63
/* 8526 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8534
/* 8530 */    MCD::OPC_Decode, 156, 10, 63, // Opcode: VMULWOD_D_W, DecodeIdx: 63
/* 8534 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8536 */    MCD::OPC_Decode, 162, 10, 63, // Opcode: VMULWOD_Q_D, DecodeIdx: 63
/* 8540 */    MCD::OPC_FilterValue, 38, 65, 0, // Skip to: 8609
/* 8544 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8547 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8555
/* 8551 */    MCD::OPC_Decode, 148, 10, 63, // Opcode: VMULWEV_H_BU, DecodeIdx: 63
/* 8555 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8563
/* 8559 */    MCD::OPC_Decode, 154, 10, 63, // Opcode: VMULWEV_W_HU, DecodeIdx: 63
/* 8563 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8571
/* 8567 */    MCD::OPC_Decode, 145, 10, 63, // Opcode: VMULWEV_D_WU, DecodeIdx: 63
/* 8571 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8579
/* 8575 */    MCD::OPC_Decode, 151, 10, 63, // Opcode: VMULWEV_Q_DU, DecodeIdx: 63
/* 8579 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8587
/* 8583 */    MCD::OPC_Decode, 160, 10, 63, // Opcode: VMULWOD_H_BU, DecodeIdx: 63
/* 8587 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8595
/* 8591 */    MCD::OPC_Decode, 166, 10, 63, // Opcode: VMULWOD_W_HU, DecodeIdx: 63
/* 8595 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8603
/* 8599 */    MCD::OPC_Decode, 157, 10, 63, // Opcode: VMULWOD_D_WU, DecodeIdx: 63
/* 8603 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8605 */    MCD::OPC_Decode, 163, 10, 63, // Opcode: VMULWOD_Q_DU, DecodeIdx: 63
/* 8609 */    MCD::OPC_FilterValue, 40, 65, 0, // Skip to: 8678
/* 8613 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8616 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8624
/* 8620 */    MCD::OPC_Decode, 149, 10, 63, // Opcode: VMULWEV_H_BU_B, DecodeIdx: 63
/* 8624 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8632
/* 8628 */    MCD::OPC_Decode, 155, 10, 63, // Opcode: VMULWEV_W_HU_H, DecodeIdx: 63
/* 8632 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8640
/* 8636 */    MCD::OPC_Decode, 146, 10, 63, // Opcode: VMULWEV_D_WU_W, DecodeIdx: 63
/* 8640 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8648
/* 8644 */    MCD::OPC_Decode, 152, 10, 63, // Opcode: VMULWEV_Q_DU_D, DecodeIdx: 63
/* 8648 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8656
/* 8652 */    MCD::OPC_Decode, 161, 10, 63, // Opcode: VMULWOD_H_BU_B, DecodeIdx: 63
/* 8656 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8664
/* 8660 */    MCD::OPC_Decode, 167, 10, 63, // Opcode: VMULWOD_W_HU_H, DecodeIdx: 63
/* 8664 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8672
/* 8668 */    MCD::OPC_Decode, 158, 10, 63, // Opcode: VMULWOD_D_WU_W, DecodeIdx: 63
/* 8672 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8674 */    MCD::OPC_Decode, 164, 10, 63, // Opcode: VMULWOD_Q_DU_D, DecodeIdx: 63
/* 8678 */    MCD::OPC_FilterValue, 42, 65, 0, // Skip to: 8747
/* 8682 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8685 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8693
/* 8689 */    MCD::OPC_Decode, 210, 9, 103, // Opcode: VMADD_B, DecodeIdx: 103
/* 8693 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8701
/* 8697 */    MCD::OPC_Decode, 212, 9, 103, // Opcode: VMADD_H, DecodeIdx: 103
/* 8701 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8709
/* 8705 */    MCD::OPC_Decode, 213, 9, 103, // Opcode: VMADD_W, DecodeIdx: 103
/* 8709 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8717
/* 8713 */    MCD::OPC_Decode, 211, 9, 103, // Opcode: VMADD_D, DecodeIdx: 103
/* 8717 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8725
/* 8721 */    MCD::OPC_Decode, 132, 10, 103, // Opcode: VMSUB_B, DecodeIdx: 103
/* 8725 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8733
/* 8729 */    MCD::OPC_Decode, 134, 10, 103, // Opcode: VMSUB_H, DecodeIdx: 103
/* 8733 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8741
/* 8737 */    MCD::OPC_Decode, 135, 10, 103, // Opcode: VMSUB_W, DecodeIdx: 103
/* 8741 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8743 */    MCD::OPC_Decode, 133, 10, 103, // Opcode: VMSUB_D, DecodeIdx: 103
/* 8747 */    MCD::OPC_FilterValue, 43, 65, 0, // Skip to: 8816
/* 8751 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8754 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8762
/* 8758 */    MCD::OPC_Decode, 189, 9, 103, // Opcode: VMADDWEV_H_B, DecodeIdx: 103
/* 8762 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8770
/* 8766 */    MCD::OPC_Decode, 195, 9, 103, // Opcode: VMADDWEV_W_H, DecodeIdx: 103
/* 8770 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8778
/* 8774 */    MCD::OPC_Decode, 186, 9, 103, // Opcode: VMADDWEV_D_W, DecodeIdx: 103
/* 8778 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8786
/* 8782 */    MCD::OPC_Decode, 192, 9, 103, // Opcode: VMADDWEV_Q_D, DecodeIdx: 103
/* 8786 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8794
/* 8790 */    MCD::OPC_Decode, 201, 9, 103, // Opcode: VMADDWOD_H_B, DecodeIdx: 103
/* 8794 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8802
/* 8798 */    MCD::OPC_Decode, 207, 9, 103, // Opcode: VMADDWOD_W_H, DecodeIdx: 103
/* 8802 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8810
/* 8806 */    MCD::OPC_Decode, 198, 9, 103, // Opcode: VMADDWOD_D_W, DecodeIdx: 103
/* 8810 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8812 */    MCD::OPC_Decode, 204, 9, 103, // Opcode: VMADDWOD_Q_D, DecodeIdx: 103
/* 8816 */    MCD::OPC_FilterValue, 45, 65, 0, // Skip to: 8885
/* 8820 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8823 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8831
/* 8827 */    MCD::OPC_Decode, 190, 9, 103, // Opcode: VMADDWEV_H_BU, DecodeIdx: 103
/* 8831 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8839
/* 8835 */    MCD::OPC_Decode, 196, 9, 103, // Opcode: VMADDWEV_W_HU, DecodeIdx: 103
/* 8839 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8847
/* 8843 */    MCD::OPC_Decode, 187, 9, 103, // Opcode: VMADDWEV_D_WU, DecodeIdx: 103
/* 8847 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8855
/* 8851 */    MCD::OPC_Decode, 193, 9, 103, // Opcode: VMADDWEV_Q_DU, DecodeIdx: 103
/* 8855 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8863
/* 8859 */    MCD::OPC_Decode, 202, 9, 103, // Opcode: VMADDWOD_H_BU, DecodeIdx: 103
/* 8863 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8871
/* 8867 */    MCD::OPC_Decode, 208, 9, 103, // Opcode: VMADDWOD_W_HU, DecodeIdx: 103
/* 8871 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8879
/* 8875 */    MCD::OPC_Decode, 199, 9, 103, // Opcode: VMADDWOD_D_WU, DecodeIdx: 103
/* 8879 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8881 */    MCD::OPC_Decode, 205, 9, 103, // Opcode: VMADDWOD_Q_DU, DecodeIdx: 103
/* 8885 */    MCD::OPC_FilterValue, 47, 65, 0, // Skip to: 8954
/* 8889 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8892 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8900
/* 8896 */    MCD::OPC_Decode, 191, 9, 103, // Opcode: VMADDWEV_H_BU_B, DecodeIdx: 103
/* 8900 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8908
/* 8904 */    MCD::OPC_Decode, 197, 9, 103, // Opcode: VMADDWEV_W_HU_H, DecodeIdx: 103
/* 8908 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8916
/* 8912 */    MCD::OPC_Decode, 188, 9, 103, // Opcode: VMADDWEV_D_WU_W, DecodeIdx: 103
/* 8916 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8924
/* 8920 */    MCD::OPC_Decode, 194, 9, 103, // Opcode: VMADDWEV_Q_DU_D, DecodeIdx: 103
/* 8924 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 8932
/* 8928 */    MCD::OPC_Decode, 203, 9, 103, // Opcode: VMADDWOD_H_BU_B, DecodeIdx: 103
/* 8932 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 8940
/* 8936 */    MCD::OPC_Decode, 209, 9, 103, // Opcode: VMADDWOD_W_HU_H, DecodeIdx: 103
/* 8940 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 8948
/* 8944 */    MCD::OPC_Decode, 200, 9, 103, // Opcode: VMADDWOD_D_WU_W, DecodeIdx: 103
/* 8948 */    MCD::OPC_FilterValueOrFail, 7, 
/* 8950 */    MCD::OPC_Decode, 206, 9, 103, // Opcode: VMADDWOD_Q_DU_D, DecodeIdx: 103
/* 8954 */    MCD::OPC_FilterValue, 56, 65, 0, // Skip to: 9023
/* 8958 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 8961 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 8969
/* 8965 */    MCD::OPC_Decode, 235, 7, 63, // Opcode: VDIV_B, DecodeIdx: 63
/* 8969 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 8977
/* 8973 */    MCD::OPC_Decode, 239, 7, 63, // Opcode: VDIV_H, DecodeIdx: 63
/* 8977 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 8985
/* 8981 */    MCD::OPC_Decode, 241, 7, 63, // Opcode: VDIV_W, DecodeIdx: 63
/* 8985 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 8993
/* 8989 */    MCD::OPC_Decode, 237, 7, 63, // Opcode: VDIV_D, DecodeIdx: 63
/* 8993 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 9001
/* 8997 */    MCD::OPC_Decode, 246, 9, 63, // Opcode: VMOD_B, DecodeIdx: 63
/* 9001 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9009
/* 9005 */    MCD::OPC_Decode, 250, 9, 63, // Opcode: VMOD_H, DecodeIdx: 63
/* 9009 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9017
/* 9013 */    MCD::OPC_Decode, 252, 9, 63, // Opcode: VMOD_W, DecodeIdx: 63
/* 9017 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9019 */    MCD::OPC_Decode, 248, 9, 63, // Opcode: VMOD_D, DecodeIdx: 63
/* 9023 */    MCD::OPC_FilterValue, 57, 65, 0, // Skip to: 9092
/* 9027 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9030 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 9038
/* 9034 */    MCD::OPC_Decode, 236, 7, 63, // Opcode: VDIV_BU, DecodeIdx: 63
/* 9038 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9046
/* 9042 */    MCD::OPC_Decode, 240, 7, 63, // Opcode: VDIV_HU, DecodeIdx: 63
/* 9046 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9054
/* 9050 */    MCD::OPC_Decode, 242, 7, 63, // Opcode: VDIV_WU, DecodeIdx: 63
/* 9054 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9062
/* 9058 */    MCD::OPC_Decode, 238, 7, 63, // Opcode: VDIV_DU, DecodeIdx: 63
/* 9062 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 9070
/* 9066 */    MCD::OPC_Decode, 247, 9, 63, // Opcode: VMOD_BU, DecodeIdx: 63
/* 9070 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9078
/* 9074 */    MCD::OPC_Decode, 251, 9, 63, // Opcode: VMOD_HU, DecodeIdx: 63
/* 9078 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9086
/* 9082 */    MCD::OPC_Decode, 253, 9, 63, // Opcode: VMOD_WU, DecodeIdx: 63
/* 9086 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9088 */    MCD::OPC_Decode, 249, 9, 63, // Opcode: VMOD_DU, DecodeIdx: 63
/* 9092 */    MCD::OPC_FilterValue, 58, 65, 0, // Skip to: 9161
/* 9096 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9099 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 9107
/* 9103 */    MCD::OPC_Decode, 174, 11, 63, // Opcode: VSLL_B, DecodeIdx: 63
/* 9107 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9115
/* 9111 */    MCD::OPC_Decode, 176, 11, 63, // Opcode: VSLL_H, DecodeIdx: 63
/* 9115 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9123
/* 9119 */    MCD::OPC_Decode, 177, 11, 63, // Opcode: VSLL_W, DecodeIdx: 63
/* 9123 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9131
/* 9127 */    MCD::OPC_Decode, 175, 11, 63, // Opcode: VSLL_D, DecodeIdx: 63
/* 9131 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 9139
/* 9135 */    MCD::OPC_Decode, 250, 11, 63, // Opcode: VSRL_B, DecodeIdx: 63
/* 9139 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9147
/* 9143 */    MCD::OPC_Decode, 252, 11, 63, // Opcode: VSRL_H, DecodeIdx: 63
/* 9147 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9155
/* 9151 */    MCD::OPC_Decode, 253, 11, 63, // Opcode: VSRL_W, DecodeIdx: 63
/* 9155 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9157 */    MCD::OPC_Decode, 251, 11, 63, // Opcode: VSRL_D, DecodeIdx: 63
/* 9161 */    MCD::OPC_FilterValue, 59, 65, 0, // Skip to: 9230
/* 9165 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9168 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 9176
/* 9172 */    MCD::OPC_Decode, 220, 11, 63, // Opcode: VSRA_B, DecodeIdx: 63
/* 9176 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9184
/* 9180 */    MCD::OPC_Decode, 222, 11, 63, // Opcode: VSRA_H, DecodeIdx: 63
/* 9184 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9192
/* 9188 */    MCD::OPC_Decode, 223, 11, 63, // Opcode: VSRA_W, DecodeIdx: 63
/* 9192 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9200
/* 9196 */    MCD::OPC_Decode, 221, 11, 63, // Opcode: VSRA_D, DecodeIdx: 63
/* 9200 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 9208
/* 9204 */    MCD::OPC_Decode, 226, 10, 63, // Opcode: VROTR_B, DecodeIdx: 63
/* 9208 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9216
/* 9212 */    MCD::OPC_Decode, 228, 10, 63, // Opcode: VROTR_H, DecodeIdx: 63
/* 9216 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9224
/* 9220 */    MCD::OPC_Decode, 229, 10, 63, // Opcode: VROTR_W, DecodeIdx: 63
/* 9224 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9226 */    MCD::OPC_Decode, 227, 10, 63, // Opcode: VROTR_D, DecodeIdx: 63
/* 9230 */    MCD::OPC_FilterValue, 60, 65, 0, // Skip to: 9299
/* 9234 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9237 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 9245
/* 9241 */    MCD::OPC_Decode, 246, 11, 63, // Opcode: VSRLR_B, DecodeIdx: 63
/* 9245 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9253
/* 9249 */    MCD::OPC_Decode, 248, 11, 63, // Opcode: VSRLR_H, DecodeIdx: 63
/* 9253 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9261
/* 9257 */    MCD::OPC_Decode, 249, 11, 63, // Opcode: VSRLR_W, DecodeIdx: 63
/* 9261 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9269
/* 9265 */    MCD::OPC_Decode, 247, 11, 63, // Opcode: VSRLR_D, DecodeIdx: 63
/* 9269 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 9277
/* 9273 */    MCD::OPC_Decode, 216, 11, 63, // Opcode: VSRAR_B, DecodeIdx: 63
/* 9277 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9285
/* 9281 */    MCD::OPC_Decode, 218, 11, 63, // Opcode: VSRAR_H, DecodeIdx: 63
/* 9285 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9293
/* 9289 */    MCD::OPC_Decode, 219, 11, 63, // Opcode: VSRAR_W, DecodeIdx: 63
/* 9293 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9295 */    MCD::OPC_Decode, 217, 11, 63, // Opcode: VSRAR_D, DecodeIdx: 63
/* 9299 */    MCD::OPC_FilterValue, 61, 49, 0, // Skip to: 9352
/* 9303 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9306 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9314
/* 9310 */    MCD::OPC_Decode, 232, 11, 63, // Opcode: VSRLN_B_H, DecodeIdx: 63
/* 9314 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9322
/* 9318 */    MCD::OPC_Decode, 233, 11, 63, // Opcode: VSRLN_H_W, DecodeIdx: 63
/* 9322 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9330
/* 9326 */    MCD::OPC_Decode, 234, 11, 63, // Opcode: VSRLN_W_D, DecodeIdx: 63
/* 9330 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9338
/* 9334 */    MCD::OPC_Decode, 202, 11, 63, // Opcode: VSRAN_B_H, DecodeIdx: 63
/* 9338 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9346
/* 9342 */    MCD::OPC_Decode, 203, 11, 63, // Opcode: VSRAN_H_W, DecodeIdx: 63
/* 9346 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9348 */    MCD::OPC_Decode, 204, 11, 63, // Opcode: VSRAN_W_D, DecodeIdx: 63
/* 9352 */    MCD::OPC_FilterValue, 62, 49, 0, // Skip to: 9405
/* 9356 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9359 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9367
/* 9363 */    MCD::OPC_Decode, 243, 11, 63, // Opcode: VSRLRN_B_H, DecodeIdx: 63
/* 9367 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9375
/* 9371 */    MCD::OPC_Decode, 244, 11, 63, // Opcode: VSRLRN_H_W, DecodeIdx: 63
/* 9375 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9383
/* 9379 */    MCD::OPC_Decode, 245, 11, 63, // Opcode: VSRLRN_W_D, DecodeIdx: 63
/* 9383 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9391
/* 9387 */    MCD::OPC_Decode, 213, 11, 63, // Opcode: VSRARN_B_H, DecodeIdx: 63
/* 9391 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9399
/* 9395 */    MCD::OPC_Decode, 214, 11, 63, // Opcode: VSRARN_H_W, DecodeIdx: 63
/* 9399 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9401 */    MCD::OPC_Decode, 215, 11, 63, // Opcode: VSRARN_W_D, DecodeIdx: 63
/* 9405 */    MCD::OPC_FilterValue, 63, 49, 0, // Skip to: 9458
/* 9409 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9412 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9420
/* 9416 */    MCD::OPC_Decode, 163, 12, 63, // Opcode: VSSRLN_B_H, DecodeIdx: 63
/* 9420 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9428
/* 9424 */    MCD::OPC_Decode, 165, 12, 63, // Opcode: VSSRLN_H_W, DecodeIdx: 63
/* 9428 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9436
/* 9432 */    MCD::OPC_Decode, 167, 12, 63, // Opcode: VSSRLN_W_D, DecodeIdx: 63
/* 9436 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9444
/* 9440 */    MCD::OPC_Decode, 135, 12, 63, // Opcode: VSSRAN_B_H, DecodeIdx: 63
/* 9444 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9452
/* 9448 */    MCD::OPC_Decode, 137, 12, 63, // Opcode: VSSRAN_H_W, DecodeIdx: 63
/* 9452 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9454 */    MCD::OPC_Decode, 139, 12, 63, // Opcode: VSSRAN_W_D, DecodeIdx: 63
/* 9458 */    MCD::OPC_FilterValue, 64, 49, 0, // Skip to: 9511
/* 9462 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9465 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9473
/* 9469 */    MCD::OPC_Decode, 177, 12, 63, // Opcode: VSSRLRN_B_H, DecodeIdx: 63
/* 9473 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9481
/* 9477 */    MCD::OPC_Decode, 179, 12, 63, // Opcode: VSSRLRN_H_W, DecodeIdx: 63
/* 9481 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9489
/* 9485 */    MCD::OPC_Decode, 181, 12, 63, // Opcode: VSSRLRN_W_D, DecodeIdx: 63
/* 9489 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9497
/* 9493 */    MCD::OPC_Decode, 149, 12, 63, // Opcode: VSSRARN_B_H, DecodeIdx: 63
/* 9497 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9505
/* 9501 */    MCD::OPC_Decode, 151, 12, 63, // Opcode: VSSRARN_H_W, DecodeIdx: 63
/* 9505 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9507 */    MCD::OPC_Decode, 153, 12, 63, // Opcode: VSSRARN_W_D, DecodeIdx: 63
/* 9511 */    MCD::OPC_FilterValue, 65, 49, 0, // Skip to: 9564
/* 9515 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9518 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9526
/* 9522 */    MCD::OPC_Decode, 162, 12, 63, // Opcode: VSSRLN_BU_H, DecodeIdx: 63
/* 9526 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9534
/* 9530 */    MCD::OPC_Decode, 164, 12, 63, // Opcode: VSSRLN_HU_W, DecodeIdx: 63
/* 9534 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9542
/* 9538 */    MCD::OPC_Decode, 166, 12, 63, // Opcode: VSSRLN_WU_D, DecodeIdx: 63
/* 9542 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9550
/* 9546 */    MCD::OPC_Decode, 134, 12, 63, // Opcode: VSSRAN_BU_H, DecodeIdx: 63
/* 9550 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9558
/* 9554 */    MCD::OPC_Decode, 136, 12, 63, // Opcode: VSSRAN_HU_W, DecodeIdx: 63
/* 9558 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9560 */    MCD::OPC_Decode, 138, 12, 63, // Opcode: VSSRAN_WU_D, DecodeIdx: 63
/* 9564 */    MCD::OPC_FilterValue, 66, 49, 0, // Skip to: 9617
/* 9568 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9571 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9579
/* 9575 */    MCD::OPC_Decode, 176, 12, 63, // Opcode: VSSRLRN_BU_H, DecodeIdx: 63
/* 9579 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9587
/* 9583 */    MCD::OPC_Decode, 178, 12, 63, // Opcode: VSSRLRN_HU_W, DecodeIdx: 63
/* 9587 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9595
/* 9591 */    MCD::OPC_Decode, 180, 12, 63, // Opcode: VSSRLRN_WU_D, DecodeIdx: 63
/* 9595 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9603
/* 9599 */    MCD::OPC_Decode, 148, 12, 63, // Opcode: VSSRARN_BU_H, DecodeIdx: 63
/* 9603 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9611
/* 9607 */    MCD::OPC_Decode, 150, 12, 63, // Opcode: VSSRARN_HU_W, DecodeIdx: 63
/* 9611 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9613 */    MCD::OPC_Decode, 152, 12, 63, // Opcode: VSSRARN_WU_D, DecodeIdx: 63
/* 9617 */    MCD::OPC_FilterValue, 67, 65, 0, // Skip to: 9686
/* 9621 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9624 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 9632
/* 9628 */    MCD::OPC_Decode, 203, 7, 63, // Opcode: VBITCLR_B, DecodeIdx: 63
/* 9632 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9640
/* 9636 */    MCD::OPC_Decode, 205, 7, 63, // Opcode: VBITCLR_H, DecodeIdx: 63
/* 9640 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9648
/* 9644 */    MCD::OPC_Decode, 206, 7, 63, // Opcode: VBITCLR_W, DecodeIdx: 63
/* 9648 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9656
/* 9652 */    MCD::OPC_Decode, 204, 7, 63, // Opcode: VBITCLR_D, DecodeIdx: 63
/* 9656 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 9664
/* 9660 */    MCD::OPC_Decode, 221, 7, 63, // Opcode: VBITSET_B, DecodeIdx: 63
/* 9664 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9672
/* 9668 */    MCD::OPC_Decode, 223, 7, 63, // Opcode: VBITSET_H, DecodeIdx: 63
/* 9672 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9680
/* 9676 */    MCD::OPC_Decode, 224, 7, 63, // Opcode: VBITSET_W, DecodeIdx: 63
/* 9680 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9682 */    MCD::OPC_Decode, 222, 7, 63, // Opcode: VBITSET_D, DecodeIdx: 63
/* 9686 */    MCD::OPC_FilterValue, 68, 33, 0, // Skip to: 9723
/* 9690 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9693 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 9701
/* 9697 */    MCD::OPC_Decode, 211, 7, 63, // Opcode: VBITREV_B, DecodeIdx: 63
/* 9701 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9709
/* 9705 */    MCD::OPC_Decode, 213, 7, 63, // Opcode: VBITREV_H, DecodeIdx: 63
/* 9709 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9717
/* 9713 */    MCD::OPC_Decode, 214, 7, 63, // Opcode: VBITREV_W, DecodeIdx: 63
/* 9717 */    MCD::OPC_FilterValueOrFail, 3, 
/* 9719 */    MCD::OPC_Decode, 212, 7, 63, // Opcode: VBITREV_D, DecodeIdx: 63
/* 9723 */    MCD::OPC_FilterValue, 69, 33, 0, // Skip to: 9760
/* 9727 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9730 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 9738
/* 9734 */    MCD::OPC_Decode, 181, 10, 63, // Opcode: VPACKEV_B, DecodeIdx: 63
/* 9738 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9746
/* 9742 */    MCD::OPC_Decode, 183, 10, 63, // Opcode: VPACKEV_H, DecodeIdx: 63
/* 9746 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9754
/* 9750 */    MCD::OPC_Decode, 184, 10, 63, // Opcode: VPACKEV_W, DecodeIdx: 63
/* 9754 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9756 */    MCD::OPC_Decode, 182, 10, 63, // Opcode: VPACKEV_D, DecodeIdx: 63
/* 9760 */    MCD::OPC_FilterValue, 70, 65, 0, // Skip to: 9829
/* 9764 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9767 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 9775
/* 9771 */    MCD::OPC_Decode, 185, 10, 63, // Opcode: VPACKOD_B, DecodeIdx: 63
/* 9775 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9783
/* 9779 */    MCD::OPC_Decode, 187, 10, 63, // Opcode: VPACKOD_H, DecodeIdx: 63
/* 9783 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9791
/* 9787 */    MCD::OPC_Decode, 188, 10, 63, // Opcode: VPACKOD_W, DecodeIdx: 63
/* 9791 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9799
/* 9795 */    MCD::OPC_Decode, 186, 10, 63, // Opcode: VPACKOD_D, DecodeIdx: 63
/* 9799 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 9807
/* 9803 */    MCD::OPC_Decode, 171, 9, 63, // Opcode: VILVL_B, DecodeIdx: 63
/* 9807 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9815
/* 9811 */    MCD::OPC_Decode, 173, 9, 63, // Opcode: VILVL_H, DecodeIdx: 63
/* 9815 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9823
/* 9819 */    MCD::OPC_Decode, 174, 9, 63, // Opcode: VILVL_W, DecodeIdx: 63
/* 9823 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9825 */    MCD::OPC_Decode, 172, 9, 63, // Opcode: VILVL_D, DecodeIdx: 63
/* 9829 */    MCD::OPC_FilterValue, 71, 65, 0, // Skip to: 9898
/* 9833 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9836 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 9844
/* 9840 */    MCD::OPC_Decode, 167, 9, 63, // Opcode: VILVH_B, DecodeIdx: 63
/* 9844 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9852
/* 9848 */    MCD::OPC_Decode, 169, 9, 63, // Opcode: VILVH_H, DecodeIdx: 63
/* 9852 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9860
/* 9856 */    MCD::OPC_Decode, 170, 9, 63, // Opcode: VILVH_W, DecodeIdx: 63
/* 9860 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9868
/* 9864 */    MCD::OPC_Decode, 168, 9, 63, // Opcode: VILVH_D, DecodeIdx: 63
/* 9868 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 9876
/* 9872 */    MCD::OPC_Decode, 194, 10, 63, // Opcode: VPICKEV_B, DecodeIdx: 63
/* 9876 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9884
/* 9880 */    MCD::OPC_Decode, 196, 10, 63, // Opcode: VPICKEV_H, DecodeIdx: 63
/* 9884 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9892
/* 9888 */    MCD::OPC_Decode, 197, 10, 63, // Opcode: VPICKEV_W, DecodeIdx: 63
/* 9892 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9894 */    MCD::OPC_Decode, 195, 10, 63, // Opcode: VPICKEV_D, DecodeIdx: 63
/* 9898 */    MCD::OPC_FilterValue, 72, 65, 0, // Skip to: 9967
/* 9902 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9905 */    MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 9913
/* 9909 */    MCD::OPC_Decode, 198, 10, 63, // Opcode: VPICKOD_B, DecodeIdx: 63
/* 9913 */    MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 9921
/* 9917 */    MCD::OPC_Decode, 200, 10, 63, // Opcode: VPICKOD_H, DecodeIdx: 63
/* 9921 */    MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 9929
/* 9925 */    MCD::OPC_Decode, 201, 10, 63, // Opcode: VPICKOD_W, DecodeIdx: 63
/* 9929 */    MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 9937
/* 9933 */    MCD::OPC_Decode, 199, 10, 63, // Opcode: VPICKOD_D, DecodeIdx: 63
/* 9937 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 9945
/* 9941 */    MCD::OPC_Decode, 218, 10, 104, // Opcode: VREPLVE_B, DecodeIdx: 104
/* 9945 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9953
/* 9949 */    MCD::OPC_Decode, 220, 10, 104, // Opcode: VREPLVE_H, DecodeIdx: 104
/* 9953 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9961
/* 9957 */    MCD::OPC_Decode, 221, 10, 104, // Opcode: VREPLVE_W, DecodeIdx: 104
/* 9961 */    MCD::OPC_FilterValueOrFail, 7, 
/* 9963 */    MCD::OPC_Decode, 219, 10, 104, // Opcode: VREPLVE_D, DecodeIdx: 104
/* 9967 */    MCD::OPC_FilterValue, 73, 33, 0, // Skip to: 10004
/* 9971 */    MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 9974 */    MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 9982
/* 9978 */    MCD::OPC_Decode, 182, 7, 63, // Opcode: VAND_V, DecodeIdx: 63
/* 9982 */    MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 9990
/* 9986 */    MCD::OPC_Decode, 180, 10, 63, // Opcode: VOR_V, DecodeIdx: 63
/* 9990 */    MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 9998
/* 9994 */    MCD::OPC_Decode, 222, 12, 63, // Opcode: VXOR_V, DecodeIdx: 63
/* 9998 */    MCD::OPC_FilterValueOrFail, 7, 
/* 10000 */   MCD::OPC_Decode, 177, 10, 63, // Opcode: VNOR_V, DecodeIdx: 63
/* 10004 */   MCD::OPC_FilterValue, 74, 33, 0, // Skip to: 10041
/* 10008 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10011 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 10019
/* 10015 */   MCD::OPC_Decode, 181, 7, 63, // Opcode: VANDN_V, DecodeIdx: 63
/* 10019 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10027
/* 10023 */   MCD::OPC_Decode, 179, 10, 63, // Opcode: VORN_V, DecodeIdx: 63
/* 10027 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 10035
/* 10031 */   MCD::OPC_Decode, 244, 8, 103, // Opcode: VFRSTP_B, DecodeIdx: 103
/* 10035 */   MCD::OPC_FilterValueOrFail, 7, 
/* 10037 */   MCD::OPC_Decode, 245, 8, 103, // Opcode: VFRSTP_H, DecodeIdx: 103
/* 10041 */   MCD::OPC_FilterValue, 75, 49, 0, // Skip to: 10094
/* 10045 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10048 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10056
/* 10052 */   MCD::OPC_Decode, 178, 7, 63, // Opcode: VADD_Q, DecodeIdx: 63
/* 10056 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 10064
/* 10060 */   MCD::OPC_Decode, 219, 12, 63, // Opcode: VSUB_Q, DecodeIdx: 63
/* 10064 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 10072
/* 10068 */   MCD::OPC_Decode, 144, 11, 63, // Opcode: VSIGNCOV_B, DecodeIdx: 63
/* 10072 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10080
/* 10076 */   MCD::OPC_Decode, 146, 11, 63, // Opcode: VSIGNCOV_H, DecodeIdx: 63
/* 10080 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 10088
/* 10084 */   MCD::OPC_Decode, 147, 11, 63, // Opcode: VSIGNCOV_W, DecodeIdx: 63
/* 10088 */   MCD::OPC_FilterValueOrFail, 7, 
/* 10090 */   MCD::OPC_Decode, 145, 11, 63, // Opcode: VSIGNCOV_D, DecodeIdx: 63
/* 10094 */   MCD::OPC_FilterValue, 76, 33, 0, // Skip to: 10131
/* 10098 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10101 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10109
/* 10105 */   MCD::OPC_Decode, 142, 8, 63, // Opcode: VFADD_S, DecodeIdx: 63
/* 10109 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10117
/* 10113 */   MCD::OPC_Decode, 141, 8, 63, // Opcode: VFADD_D, DecodeIdx: 63
/* 10117 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10125
/* 10121 */   MCD::OPC_Decode, 249, 8, 63, // Opcode: VFSUB_S, DecodeIdx: 63
/* 10125 */   MCD::OPC_FilterValueOrFail, 6, 
/* 10127 */   MCD::OPC_Decode, 248, 8, 63, // Opcode: VFSUB_D, DecodeIdx: 63
/* 10131 */   MCD::OPC_FilterValue, 78, 33, 0, // Skip to: 10168
/* 10135 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10138 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10146
/* 10142 */   MCD::OPC_Decode, 219, 8, 63, // Opcode: VFMUL_S, DecodeIdx: 63
/* 10146 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10154
/* 10150 */   MCD::OPC_Decode, 218, 8, 63, // Opcode: VFMUL_D, DecodeIdx: 63
/* 10154 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10162
/* 10158 */   MCD::OPC_Decode, 196, 8, 63, // Opcode: VFDIV_S, DecodeIdx: 63
/* 10162 */   MCD::OPC_FilterValueOrFail, 6, 
/* 10164 */   MCD::OPC_Decode, 195, 8, 63, // Opcode: VFDIV_D, DecodeIdx: 63
/* 10168 */   MCD::OPC_FilterValue, 79, 33, 0, // Skip to: 10205
/* 10172 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10175 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10183
/* 10179 */   MCD::OPC_Decode, 211, 8, 63, // Opcode: VFMAX_S, DecodeIdx: 63
/* 10183 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10191
/* 10187 */   MCD::OPC_Decode, 210, 8, 63, // Opcode: VFMAX_D, DecodeIdx: 63
/* 10191 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10199
/* 10195 */   MCD::OPC_Decode, 215, 8, 63, // Opcode: VFMIN_S, DecodeIdx: 63
/* 10199 */   MCD::OPC_FilterValueOrFail, 6, 
/* 10201 */   MCD::OPC_Decode, 214, 8, 63, // Opcode: VFMIN_D, DecodeIdx: 63
/* 10205 */   MCD::OPC_FilterValue, 80, 33, 0, // Skip to: 10242
/* 10209 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10212 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10220
/* 10216 */   MCD::OPC_Decode, 209, 8, 63, // Opcode: VFMAXA_S, DecodeIdx: 63
/* 10220 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10228
/* 10224 */   MCD::OPC_Decode, 208, 8, 63, // Opcode: VFMAXA_D, DecodeIdx: 63
/* 10228 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10236
/* 10232 */   MCD::OPC_Decode, 213, 8, 63, // Opcode: VFMINA_S, DecodeIdx: 63
/* 10236 */   MCD::OPC_FilterValueOrFail, 6, 
/* 10238 */   MCD::OPC_Decode, 212, 8, 63, // Opcode: VFMINA_D, DecodeIdx: 63
/* 10242 */   MCD::OPC_FilterValue, 81, 17, 0, // Skip to: 10263
/* 10246 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10249 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 10257
/* 10253 */   MCD::OPC_Decode, 193, 8, 63, // Opcode: VFCVT_H_S, DecodeIdx: 63
/* 10257 */   MCD::OPC_FilterValueOrFail, 5, 
/* 10259 */   MCD::OPC_Decode, 194, 8, 63, // Opcode: VFCVT_S_D, DecodeIdx: 63
/* 10263 */   MCD::OPC_FilterValue, 82, 49, 0, // Skip to: 10316
/* 10267 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10270 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 10278
/* 10274 */   MCD::OPC_Decode, 201, 8, 63, // Opcode: VFFINT_S_L, DecodeIdx: 63
/* 10278 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 10286
/* 10282 */   MCD::OPC_Decode, 149, 9, 63, // Opcode: VFTINT_W_D, DecodeIdx: 63
/* 10286 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 10294
/* 10290 */   MCD::OPC_Decode, 255, 8, 63, // Opcode: VFTINTRM_W_D, DecodeIdx: 63
/* 10294 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10302
/* 10298 */   MCD::OPC_Decode, 137, 9, 63, // Opcode: VFTINTRP_W_D, DecodeIdx: 63
/* 10302 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 10310
/* 10306 */   MCD::OPC_Decode, 144, 9, 63, // Opcode: VFTINTRZ_W_D, DecodeIdx: 63
/* 10310 */   MCD::OPC_FilterValueOrFail, 7, 
/* 10312 */   MCD::OPC_Decode, 132, 9, 63, // Opcode: VFTINTRNE_W_D, DecodeIdx: 63
/* 10316 */   MCD::OPC_FilterValue, 94, 25, 0, // Skip to: 10345
/* 10320 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10323 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10331
/* 10327 */   MCD::OPC_Decode, 142, 11, 103, // Opcode: VSHUF_H, DecodeIdx: 103
/* 10331 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 10339
/* 10335 */   MCD::OPC_Decode, 143, 11, 103, // Opcode: VSHUF_W, DecodeIdx: 103
/* 10339 */   MCD::OPC_FilterValueOrFail, 7, 
/* 10341 */   MCD::OPC_Decode, 141, 11, 103, // Opcode: VSHUF_D, DecodeIdx: 103
/* 10345 */   MCD::OPC_FilterValue, 160, 1, 65, 0, // Skip to: 10415
/* 10350 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10353 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 10361
/* 10357 */   MCD::OPC_Decode, 246, 10, 105, // Opcode: VSEQI_B, DecodeIdx: 105
/* 10361 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10369
/* 10365 */   MCD::OPC_Decode, 248, 10, 105, // Opcode: VSEQI_H, DecodeIdx: 105
/* 10369 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10377
/* 10373 */   MCD::OPC_Decode, 249, 10, 105, // Opcode: VSEQI_W, DecodeIdx: 105
/* 10377 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 10385
/* 10381 */   MCD::OPC_Decode, 247, 10, 105, // Opcode: VSEQI_D, DecodeIdx: 105
/* 10385 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 10393
/* 10389 */   MCD::OPC_Decode, 148, 11, 105, // Opcode: VSLEI_B, DecodeIdx: 105
/* 10393 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10401
/* 10397 */   MCD::OPC_Decode, 152, 11, 105, // Opcode: VSLEI_H, DecodeIdx: 105
/* 10401 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 10409
/* 10405 */   MCD::OPC_Decode, 154, 11, 105, // Opcode: VSLEI_W, DecodeIdx: 105
/* 10409 */   MCD::OPC_FilterValueOrFail, 7, 
/* 10411 */   MCD::OPC_Decode, 150, 11, 105, // Opcode: VSLEI_D, DecodeIdx: 105
/* 10415 */   MCD::OPC_FilterValue, 161, 1, 65, 0, // Skip to: 10485
/* 10420 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10423 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 10431
/* 10427 */   MCD::OPC_Decode, 149, 11, 106, // Opcode: VSLEI_BU, DecodeIdx: 106
/* 10431 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10439
/* 10435 */   MCD::OPC_Decode, 153, 11, 106, // Opcode: VSLEI_HU, DecodeIdx: 106
/* 10439 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10447
/* 10443 */   MCD::OPC_Decode, 155, 11, 106, // Opcode: VSLEI_WU, DecodeIdx: 106
/* 10447 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 10455
/* 10451 */   MCD::OPC_Decode, 151, 11, 106, // Opcode: VSLEI_DU, DecodeIdx: 106
/* 10455 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 10463
/* 10459 */   MCD::OPC_Decode, 178, 11, 105, // Opcode: VSLTI_B, DecodeIdx: 105
/* 10463 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10471
/* 10467 */   MCD::OPC_Decode, 182, 11, 105, // Opcode: VSLTI_H, DecodeIdx: 105
/* 10471 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 10479
/* 10475 */   MCD::OPC_Decode, 184, 11, 105, // Opcode: VSLTI_W, DecodeIdx: 105
/* 10479 */   MCD::OPC_FilterValueOrFail, 7, 
/* 10481 */   MCD::OPC_Decode, 180, 11, 105, // Opcode: VSLTI_D, DecodeIdx: 105
/* 10485 */   MCD::OPC_FilterValue, 162, 1, 65, 0, // Skip to: 10555
/* 10490 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10493 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 10501
/* 10497 */   MCD::OPC_Decode, 179, 11, 106, // Opcode: VSLTI_BU, DecodeIdx: 106
/* 10501 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10509
/* 10505 */   MCD::OPC_Decode, 183, 11, 106, // Opcode: VSLTI_HU, DecodeIdx: 106
/* 10509 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10517
/* 10513 */   MCD::OPC_Decode, 185, 11, 106, // Opcode: VSLTI_WU, DecodeIdx: 106
/* 10517 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 10525
/* 10521 */   MCD::OPC_Decode, 181, 11, 106, // Opcode: VSLTI_DU, DecodeIdx: 106
/* 10525 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 10533
/* 10529 */   MCD::OPC_Decode, 147, 7, 106, // Opcode: VADDI_BU, DecodeIdx: 106
/* 10533 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10541
/* 10537 */   MCD::OPC_Decode, 149, 7, 106, // Opcode: VADDI_HU, DecodeIdx: 106
/* 10541 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 10549
/* 10545 */   MCD::OPC_Decode, 150, 7, 106, // Opcode: VADDI_WU, DecodeIdx: 106
/* 10549 */   MCD::OPC_FilterValueOrFail, 7, 
/* 10551 */   MCD::OPC_Decode, 148, 7, 106, // Opcode: VADDI_DU, DecodeIdx: 106
/* 10555 */   MCD::OPC_FilterValue, 163, 1, 49, 0, // Skip to: 10609
/* 10560 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10563 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 10571
/* 10567 */   MCD::OPC_Decode, 196, 12, 106, // Opcode: VSUBI_BU, DecodeIdx: 106
/* 10571 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10579
/* 10575 */   MCD::OPC_Decode, 198, 12, 106, // Opcode: VSUBI_HU, DecodeIdx: 106
/* 10579 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10587
/* 10583 */   MCD::OPC_Decode, 199, 12, 106, // Opcode: VSUBI_WU, DecodeIdx: 106
/* 10587 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 10595
/* 10591 */   MCD::OPC_Decode, 197, 12, 106, // Opcode: VSUBI_DU, DecodeIdx: 106
/* 10595 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 10603
/* 10599 */   MCD::OPC_Decode, 225, 7, 106, // Opcode: VBSLL_V, DecodeIdx: 106
/* 10603 */   MCD::OPC_FilterValueOrFail, 5, 
/* 10605 */   MCD::OPC_Decode, 226, 7, 106, // Opcode: VBSRL_V, DecodeIdx: 106
/* 10609 */   MCD::OPC_FilterValue, 164, 1, 65, 0, // Skip to: 10679
/* 10614 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10617 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 10625
/* 10621 */   MCD::OPC_Decode, 214, 9, 105, // Opcode: VMAXI_B, DecodeIdx: 105
/* 10625 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10633
/* 10629 */   MCD::OPC_Decode, 218, 9, 105, // Opcode: VMAXI_H, DecodeIdx: 105
/* 10633 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10641
/* 10637 */   MCD::OPC_Decode, 220, 9, 105, // Opcode: VMAXI_W, DecodeIdx: 105
/* 10641 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 10649
/* 10645 */   MCD::OPC_Decode, 216, 9, 105, // Opcode: VMAXI_D, DecodeIdx: 105
/* 10649 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 10657
/* 10653 */   MCD::OPC_Decode, 230, 9, 105, // Opcode: VMINI_B, DecodeIdx: 105
/* 10657 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10665
/* 10661 */   MCD::OPC_Decode, 234, 9, 105, // Opcode: VMINI_H, DecodeIdx: 105
/* 10665 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 10673
/* 10669 */   MCD::OPC_Decode, 236, 9, 105, // Opcode: VMINI_W, DecodeIdx: 105
/* 10673 */   MCD::OPC_FilterValueOrFail, 7, 
/* 10675 */   MCD::OPC_Decode, 232, 9, 105, // Opcode: VMINI_D, DecodeIdx: 105
/* 10679 */   MCD::OPC_FilterValue, 165, 1, 65, 0, // Skip to: 10749
/* 10684 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10687 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 10695
/* 10691 */   MCD::OPC_Decode, 215, 9, 106, // Opcode: VMAXI_BU, DecodeIdx: 106
/* 10695 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10703
/* 10699 */   MCD::OPC_Decode, 219, 9, 106, // Opcode: VMAXI_HU, DecodeIdx: 106
/* 10703 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10711
/* 10707 */   MCD::OPC_Decode, 221, 9, 106, // Opcode: VMAXI_WU, DecodeIdx: 106
/* 10711 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 10719
/* 10715 */   MCD::OPC_Decode, 217, 9, 106, // Opcode: VMAXI_DU, DecodeIdx: 106
/* 10719 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 10727
/* 10723 */   MCD::OPC_Decode, 231, 9, 106, // Opcode: VMINI_BU, DecodeIdx: 106
/* 10727 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10735
/* 10731 */   MCD::OPC_Decode, 235, 9, 106, // Opcode: VMINI_HU, DecodeIdx: 106
/* 10735 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 10743
/* 10739 */   MCD::OPC_Decode, 237, 9, 106, // Opcode: VMINI_WU, DecodeIdx: 106
/* 10743 */   MCD::OPC_FilterValueOrFail, 7, 
/* 10745 */   MCD::OPC_Decode, 233, 9, 106, // Opcode: VMINI_DU, DecodeIdx: 106
/* 10749 */   MCD::OPC_FilterValue, 166, 1, 17, 0, // Skip to: 10771
/* 10754 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 10757 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 10765
/* 10761 */   MCD::OPC_Decode, 242, 8, 107, // Opcode: VFRSTPI_B, DecodeIdx: 107
/* 10765 */   MCD::OPC_FilterValueOrFail, 5, 
/* 10767 */   MCD::OPC_Decode, 243, 8, 107, // Opcode: VFRSTPI_H, DecodeIdx: 107
/* 10771 */   MCD::OPC_FilterValue, 167, 1, 131, 3, // Skip to: 11675
/* 10776 */   MCD::OPC_ExtractField, 10, 8,  // Inst{17-10} ...
/* 10779 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 10787
/* 10783 */   MCD::OPC_Decode, 227, 7, 108, // Opcode: VCLO_B, DecodeIdx: 108
/* 10787 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 10795
/* 10791 */   MCD::OPC_Decode, 229, 7, 108, // Opcode: VCLO_H, DecodeIdx: 108
/* 10795 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 10803
/* 10799 */   MCD::OPC_Decode, 230, 7, 108, // Opcode: VCLO_W, DecodeIdx: 108
/* 10803 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 10811
/* 10807 */   MCD::OPC_Decode, 228, 7, 108, // Opcode: VCLO_D, DecodeIdx: 108
/* 10811 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 10819
/* 10815 */   MCD::OPC_Decode, 231, 7, 108, // Opcode: VCLZ_B, DecodeIdx: 108
/* 10819 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 10827
/* 10823 */   MCD::OPC_Decode, 233, 7, 108, // Opcode: VCLZ_H, DecodeIdx: 108
/* 10827 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 10835
/* 10831 */   MCD::OPC_Decode, 234, 7, 108, // Opcode: VCLZ_W, DecodeIdx: 108
/* 10835 */   MCD::OPC_FilterValue, 7, 4, 0, // Skip to: 10843
/* 10839 */   MCD::OPC_Decode, 232, 7, 108, // Opcode: VCLZ_D, DecodeIdx: 108
/* 10843 */   MCD::OPC_FilterValue, 8, 4, 0, // Skip to: 10851
/* 10847 */   MCD::OPC_Decode, 189, 10, 108, // Opcode: VPCNT_B, DecodeIdx: 108
/* 10851 */   MCD::OPC_FilterValue, 9, 4, 0, // Skip to: 10859
/* 10855 */   MCD::OPC_Decode, 191, 10, 108, // Opcode: VPCNT_H, DecodeIdx: 108
/* 10859 */   MCD::OPC_FilterValue, 10, 4, 0, // Skip to: 10867
/* 10863 */   MCD::OPC_Decode, 192, 10, 108, // Opcode: VPCNT_W, DecodeIdx: 108
/* 10867 */   MCD::OPC_FilterValue, 11, 4, 0, // Skip to: 10875
/* 10871 */   MCD::OPC_Decode, 190, 10, 108, // Opcode: VPCNT_D, DecodeIdx: 108
/* 10875 */   MCD::OPC_FilterValue, 12, 4, 0, // Skip to: 10883
/* 10879 */   MCD::OPC_Decode, 172, 10, 108, // Opcode: VNEG_B, DecodeIdx: 108
/* 10883 */   MCD::OPC_FilterValue, 13, 4, 0, // Skip to: 10891
/* 10887 */   MCD::OPC_Decode, 174, 10, 108, // Opcode: VNEG_H, DecodeIdx: 108
/* 10891 */   MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 10899
/* 10895 */   MCD::OPC_Decode, 175, 10, 108, // Opcode: VNEG_W, DecodeIdx: 108
/* 10899 */   MCD::OPC_FilterValue, 15, 4, 0, // Skip to: 10907
/* 10903 */   MCD::OPC_Decode, 173, 10, 108, // Opcode: VNEG_D, DecodeIdx: 108
/* 10907 */   MCD::OPC_FilterValue, 16, 4, 0, // Skip to: 10915
/* 10911 */   MCD::OPC_Decode, 255, 9, 108, // Opcode: VMSKLTZ_B, DecodeIdx: 108
/* 10915 */   MCD::OPC_FilterValue, 17, 4, 0, // Skip to: 10923
/* 10919 */   MCD::OPC_Decode, 129, 10, 108, // Opcode: VMSKLTZ_H, DecodeIdx: 108
/* 10923 */   MCD::OPC_FilterValue, 18, 4, 0, // Skip to: 10931
/* 10927 */   MCD::OPC_Decode, 130, 10, 108, // Opcode: VMSKLTZ_W, DecodeIdx: 108
/* 10931 */   MCD::OPC_FilterValue, 19, 4, 0, // Skip to: 10939
/* 10935 */   MCD::OPC_Decode, 128, 10, 108, // Opcode: VMSKLTZ_D, DecodeIdx: 108
/* 10939 */   MCD::OPC_FilterValue, 20, 4, 0, // Skip to: 10947
/* 10943 */   MCD::OPC_Decode, 254, 9, 108, // Opcode: VMSKGEZ_B, DecodeIdx: 108
/* 10947 */   MCD::OPC_FilterValue, 24, 4, 0, // Skip to: 10955
/* 10951 */   MCD::OPC_Decode, 131, 10, 108, // Opcode: VMSKNZ_B, DecodeIdx: 108
/* 10955 */   MCD::OPC_FilterValue, 38, 8, 0, // Skip to: 10967
/* 10959 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 10963 */   MCD::OPC_Decode, 134, 11, 109, // Opcode: VSETEQZ_V, DecodeIdx: 109
/* 10967 */   MCD::OPC_FilterValue, 39, 8, 0, // Skip to: 10979
/* 10971 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 10975 */   MCD::OPC_Decode, 135, 11, 109, // Opcode: VSETNEZ_V, DecodeIdx: 109
/* 10979 */   MCD::OPC_FilterValue, 40, 8, 0, // Skip to: 10991
/* 10983 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 10987 */   MCD::OPC_Decode, 130, 11, 109, // Opcode: VSETANYEQZ_B, DecodeIdx: 109
/* 10991 */   MCD::OPC_FilterValue, 41, 8, 0, // Skip to: 11003
/* 10995 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 10999 */   MCD::OPC_Decode, 132, 11, 109, // Opcode: VSETANYEQZ_H, DecodeIdx: 109
/* 11003 */   MCD::OPC_FilterValue, 42, 8, 0, // Skip to: 11015
/* 11007 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 11011 */   MCD::OPC_Decode, 133, 11, 109, // Opcode: VSETANYEQZ_W, DecodeIdx: 109
/* 11015 */   MCD::OPC_FilterValue, 43, 8, 0, // Skip to: 11027
/* 11019 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 11023 */   MCD::OPC_Decode, 131, 11, 109, // Opcode: VSETANYEQZ_D, DecodeIdx: 109
/* 11027 */   MCD::OPC_FilterValue, 44, 8, 0, // Skip to: 11039
/* 11031 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 11035 */   MCD::OPC_Decode, 254, 10, 109, // Opcode: VSETALLNEZ_B, DecodeIdx: 109
/* 11039 */   MCD::OPC_FilterValue, 45, 8, 0, // Skip to: 11051
/* 11043 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 11047 */   MCD::OPC_Decode, 128, 11, 109, // Opcode: VSETALLNEZ_H, DecodeIdx: 109
/* 11051 */   MCD::OPC_FilterValue, 46, 8, 0, // Skip to: 11063
/* 11055 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 11059 */   MCD::OPC_Decode, 129, 11, 109, // Opcode: VSETALLNEZ_W, DecodeIdx: 109
/* 11063 */   MCD::OPC_FilterValue, 47, 8, 0, // Skip to: 11075
/* 11067 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 11071 */   MCD::OPC_Decode, 255, 10, 109, // Opcode: VSETALLNEZ_D, DecodeIdx: 109
/* 11075 */   MCD::OPC_FilterValue, 49, 4, 0, // Skip to: 11083
/* 11079 */   MCD::OPC_Decode, 205, 8, 108, // Opcode: VFLOGB_S, DecodeIdx: 108
/* 11083 */   MCD::OPC_FilterValue, 50, 4, 0, // Skip to: 11091
/* 11087 */   MCD::OPC_Decode, 204, 8, 108, // Opcode: VFLOGB_D, DecodeIdx: 108
/* 11091 */   MCD::OPC_FilterValue, 53, 4, 0, // Skip to: 11099
/* 11095 */   MCD::OPC_Decode, 144, 8, 108, // Opcode: VFCLASS_S, DecodeIdx: 108
/* 11099 */   MCD::OPC_FilterValue, 54, 4, 0, // Skip to: 11107
/* 11103 */   MCD::OPC_Decode, 143, 8, 108, // Opcode: VFCLASS_D, DecodeIdx: 108
/* 11107 */   MCD::OPC_FilterValue, 57, 4, 0, // Skip to: 11115
/* 11111 */   MCD::OPC_Decode, 247, 8, 108, // Opcode: VFSQRT_S, DecodeIdx: 108
/* 11115 */   MCD::OPC_FilterValue, 58, 4, 0, // Skip to: 11123
/* 11119 */   MCD::OPC_Decode, 246, 8, 108, // Opcode: VFSQRT_D, DecodeIdx: 108
/* 11123 */   MCD::OPC_FilterValue, 61, 4, 0, // Skip to: 11131
/* 11127 */   MCD::OPC_Decode, 227, 8, 108, // Opcode: VFRECIP_S, DecodeIdx: 108
/* 11131 */   MCD::OPC_FilterValue, 62, 4, 0, // Skip to: 11139
/* 11135 */   MCD::OPC_Decode, 226, 8, 108, // Opcode: VFRECIP_D, DecodeIdx: 108
/* 11139 */   MCD::OPC_FilterValue, 65, 4, 0, // Skip to: 11147
/* 11143 */   MCD::OPC_Decode, 241, 8, 108, // Opcode: VFRSQRT_S, DecodeIdx: 108
/* 11147 */   MCD::OPC_FilterValue, 66, 4, 0, // Skip to: 11155
/* 11151 */   MCD::OPC_Decode, 240, 8, 108, // Opcode: VFRSQRT_D, DecodeIdx: 108
/* 11155 */   MCD::OPC_FilterValue, 69, 4, 0, // Skip to: 11163
/* 11159 */   MCD::OPC_Decode, 225, 8, 108, // Opcode: VFRECIPE_S, DecodeIdx: 108
/* 11163 */   MCD::OPC_FilterValue, 70, 4, 0, // Skip to: 11171
/* 11167 */   MCD::OPC_Decode, 224, 8, 108, // Opcode: VFRECIPE_D, DecodeIdx: 108
/* 11171 */   MCD::OPC_FilterValue, 73, 4, 0, // Skip to: 11179
/* 11175 */   MCD::OPC_Decode, 239, 8, 108, // Opcode: VFRSQRTE_S, DecodeIdx: 108
/* 11179 */   MCD::OPC_FilterValue, 74, 4, 0, // Skip to: 11187
/* 11183 */   MCD::OPC_Decode, 238, 8, 108, // Opcode: VFRSQRTE_D, DecodeIdx: 108
/* 11187 */   MCD::OPC_FilterValue, 77, 4, 0, // Skip to: 11195
/* 11191 */   MCD::OPC_Decode, 237, 8, 108, // Opcode: VFRINT_S, DecodeIdx: 108
/* 11195 */   MCD::OPC_FilterValue, 78, 4, 0, // Skip to: 11203
/* 11199 */   MCD::OPC_Decode, 236, 8, 108, // Opcode: VFRINT_D, DecodeIdx: 108
/* 11203 */   MCD::OPC_FilterValue, 81, 4, 0, // Skip to: 11211
/* 11207 */   MCD::OPC_Decode, 229, 8, 108, // Opcode: VFRINTRM_S, DecodeIdx: 108
/* 11211 */   MCD::OPC_FilterValue, 82, 4, 0, // Skip to: 11219
/* 11215 */   MCD::OPC_Decode, 228, 8, 108, // Opcode: VFRINTRM_D, DecodeIdx: 108
/* 11219 */   MCD::OPC_FilterValue, 85, 4, 0, // Skip to: 11227
/* 11223 */   MCD::OPC_Decode, 233, 8, 108, // Opcode: VFRINTRP_S, DecodeIdx: 108
/* 11227 */   MCD::OPC_FilterValue, 86, 4, 0, // Skip to: 11235
/* 11231 */   MCD::OPC_Decode, 232, 8, 108, // Opcode: VFRINTRP_D, DecodeIdx: 108
/* 11235 */   MCD::OPC_FilterValue, 89, 4, 0, // Skip to: 11243
/* 11239 */   MCD::OPC_Decode, 235, 8, 108, // Opcode: VFRINTRZ_S, DecodeIdx: 108
/* 11243 */   MCD::OPC_FilterValue, 90, 4, 0, // Skip to: 11251
/* 11247 */   MCD::OPC_Decode, 234, 8, 108, // Opcode: VFRINTRZ_D, DecodeIdx: 108
/* 11251 */   MCD::OPC_FilterValue, 93, 4, 0, // Skip to: 11259
/* 11255 */   MCD::OPC_Decode, 231, 8, 108, // Opcode: VFRINTRNE_S, DecodeIdx: 108
/* 11259 */   MCD::OPC_FilterValue, 94, 4, 0, // Skip to: 11267
/* 11263 */   MCD::OPC_Decode, 230, 8, 108, // Opcode: VFRINTRNE_D, DecodeIdx: 108
/* 11267 */   MCD::OPC_FilterValue, 122, 4, 0, // Skip to: 11275
/* 11271 */   MCD::OPC_Decode, 192, 8, 108, // Opcode: VFCVTL_S_H, DecodeIdx: 108
/* 11275 */   MCD::OPC_FilterValue, 123, 4, 0, // Skip to: 11283
/* 11279 */   MCD::OPC_Decode, 190, 8, 108, // Opcode: VFCVTH_S_H, DecodeIdx: 108
/* 11283 */   MCD::OPC_FilterValue, 124, 4, 0, // Skip to: 11291
/* 11287 */   MCD::OPC_Decode, 191, 8, 108, // Opcode: VFCVTL_D_S, DecodeIdx: 108
/* 11291 */   MCD::OPC_FilterValue, 125, 4, 0, // Skip to: 11299
/* 11295 */   MCD::OPC_Decode, 189, 8, 108, // Opcode: VFCVTH_D_S, DecodeIdx: 108
/* 11299 */   MCD::OPC_FilterValue, 128, 1, 4, 0, // Skip to: 11308
/* 11304 */   MCD::OPC_Decode, 202, 8, 108, // Opcode: VFFINT_S_W, DecodeIdx: 108
/* 11308 */   MCD::OPC_FilterValue, 129, 1, 4, 0, // Skip to: 11317
/* 11313 */   MCD::OPC_Decode, 203, 8, 108, // Opcode: VFFINT_S_WU, DecodeIdx: 108
/* 11317 */   MCD::OPC_FilterValue, 130, 1, 4, 0, // Skip to: 11326
/* 11322 */   MCD::OPC_Decode, 199, 8, 108, // Opcode: VFFINT_D_L, DecodeIdx: 108
/* 11326 */   MCD::OPC_FilterValue, 131, 1, 4, 0, // Skip to: 11335
/* 11331 */   MCD::OPC_Decode, 200, 8, 108, // Opcode: VFFINT_D_LU, DecodeIdx: 108
/* 11335 */   MCD::OPC_FilterValue, 132, 1, 4, 0, // Skip to: 11344
/* 11340 */   MCD::OPC_Decode, 198, 8, 108, // Opcode: VFFINTL_D_W, DecodeIdx: 108
/* 11344 */   MCD::OPC_FilterValue, 133, 1, 4, 0, // Skip to: 11353
/* 11349 */   MCD::OPC_Decode, 197, 8, 108, // Opcode: VFFINTH_D_W, DecodeIdx: 108
/* 11353 */   MCD::OPC_FilterValue, 140, 1, 4, 0, // Skip to: 11362
/* 11358 */   MCD::OPC_Decode, 150, 9, 108, // Opcode: VFTINT_W_S, DecodeIdx: 108
/* 11362 */   MCD::OPC_FilterValue, 141, 1, 4, 0, // Skip to: 11371
/* 11367 */   MCD::OPC_Decode, 147, 9, 108, // Opcode: VFTINT_L_D, DecodeIdx: 108
/* 11371 */   MCD::OPC_FilterValue, 142, 1, 4, 0, // Skip to: 11380
/* 11376 */   MCD::OPC_Decode, 128, 9, 108, // Opcode: VFTINTRM_W_S, DecodeIdx: 108
/* 11380 */   MCD::OPC_FilterValue, 143, 1, 4, 0, // Skip to: 11389
/* 11385 */   MCD::OPC_Decode, 254, 8, 108, // Opcode: VFTINTRM_L_D, DecodeIdx: 108
/* 11389 */   MCD::OPC_FilterValue, 144, 1, 4, 0, // Skip to: 11398
/* 11394 */   MCD::OPC_Decode, 138, 9, 108, // Opcode: VFTINTRP_W_S, DecodeIdx: 108
/* 11398 */   MCD::OPC_FilterValue, 145, 1, 4, 0, // Skip to: 11407
/* 11403 */   MCD::OPC_Decode, 136, 9, 108, // Opcode: VFTINTRP_L_D, DecodeIdx: 108
/* 11407 */   MCD::OPC_FilterValue, 146, 1, 4, 0, // Skip to: 11416
/* 11412 */   MCD::OPC_Decode, 145, 9, 108, // Opcode: VFTINTRZ_W_S, DecodeIdx: 108
/* 11416 */   MCD::OPC_FilterValue, 147, 1, 4, 0, // Skip to: 11425
/* 11421 */   MCD::OPC_Decode, 142, 9, 108, // Opcode: VFTINTRZ_L_D, DecodeIdx: 108
/* 11425 */   MCD::OPC_FilterValue, 148, 1, 4, 0, // Skip to: 11434
/* 11430 */   MCD::OPC_Decode, 133, 9, 108, // Opcode: VFTINTRNE_W_S, DecodeIdx: 108
/* 11434 */   MCD::OPC_FilterValue, 149, 1, 4, 0, // Skip to: 11443
/* 11439 */   MCD::OPC_Decode, 131, 9, 108, // Opcode: VFTINTRNE_L_D, DecodeIdx: 108
/* 11443 */   MCD::OPC_FilterValue, 150, 1, 4, 0, // Skip to: 11452
/* 11448 */   MCD::OPC_Decode, 148, 9, 108, // Opcode: VFTINT_WU_S, DecodeIdx: 108
/* 11452 */   MCD::OPC_FilterValue, 151, 1, 4, 0, // Skip to: 11461
/* 11457 */   MCD::OPC_Decode, 146, 9, 108, // Opcode: VFTINT_LU_D, DecodeIdx: 108
/* 11461 */   MCD::OPC_FilterValue, 156, 1, 4, 0, // Skip to: 11470
/* 11466 */   MCD::OPC_Decode, 143, 9, 108, // Opcode: VFTINTRZ_WU_S, DecodeIdx: 108
/* 11470 */   MCD::OPC_FilterValue, 157, 1, 4, 0, // Skip to: 11479
/* 11475 */   MCD::OPC_Decode, 141, 9, 108, // Opcode: VFTINTRZ_LU_D, DecodeIdx: 108
/* 11479 */   MCD::OPC_FilterValue, 160, 1, 4, 0, // Skip to: 11488
/* 11484 */   MCD::OPC_Decode, 251, 8, 108, // Opcode: VFTINTL_L_S, DecodeIdx: 108
/* 11488 */   MCD::OPC_FilterValue, 161, 1, 4, 0, // Skip to: 11497
/* 11493 */   MCD::OPC_Decode, 250, 8, 108, // Opcode: VFTINTH_L_S, DecodeIdx: 108
/* 11497 */   MCD::OPC_FilterValue, 162, 1, 4, 0, // Skip to: 11506
/* 11502 */   MCD::OPC_Decode, 253, 8, 108, // Opcode: VFTINTRML_L_S, DecodeIdx: 108
/* 11506 */   MCD::OPC_FilterValue, 163, 1, 4, 0, // Skip to: 11515
/* 11511 */   MCD::OPC_Decode, 252, 8, 108, // Opcode: VFTINTRMH_L_S, DecodeIdx: 108
/* 11515 */   MCD::OPC_FilterValue, 164, 1, 4, 0, // Skip to: 11524
/* 11520 */   MCD::OPC_Decode, 135, 9, 108, // Opcode: VFTINTRPL_L_S, DecodeIdx: 108
/* 11524 */   MCD::OPC_FilterValue, 165, 1, 4, 0, // Skip to: 11533
/* 11529 */   MCD::OPC_Decode, 134, 9, 108, // Opcode: VFTINTRPH_L_S, DecodeIdx: 108
/* 11533 */   MCD::OPC_FilterValue, 166, 1, 4, 0, // Skip to: 11542
/* 11538 */   MCD::OPC_Decode, 140, 9, 108, // Opcode: VFTINTRZL_L_S, DecodeIdx: 108
/* 11542 */   MCD::OPC_FilterValue, 167, 1, 4, 0, // Skip to: 11551
/* 11547 */   MCD::OPC_Decode, 139, 9, 108, // Opcode: VFTINTRZH_L_S, DecodeIdx: 108
/* 11551 */   MCD::OPC_FilterValue, 168, 1, 4, 0, // Skip to: 11560
/* 11556 */   MCD::OPC_Decode, 130, 9, 108, // Opcode: VFTINTRNEL_L_S, DecodeIdx: 108
/* 11560 */   MCD::OPC_FilterValue, 169, 1, 4, 0, // Skip to: 11569
/* 11565 */   MCD::OPC_Decode, 129, 9, 108, // Opcode: VFTINTRNEH_L_S, DecodeIdx: 108
/* 11569 */   MCD::OPC_FilterValue, 184, 1, 4, 0, // Skip to: 11578
/* 11574 */   MCD::OPC_Decode, 130, 8, 108, // Opcode: VEXTH_H_B, DecodeIdx: 108
/* 11578 */   MCD::OPC_FilterValue, 185, 1, 4, 0, // Skip to: 11587
/* 11583 */   MCD::OPC_Decode, 134, 8, 108, // Opcode: VEXTH_W_H, DecodeIdx: 108
/* 11587 */   MCD::OPC_FilterValue, 186, 1, 4, 0, // Skip to: 11596
/* 11592 */   MCD::OPC_Decode, 128, 8, 108, // Opcode: VEXTH_D_W, DecodeIdx: 108
/* 11596 */   MCD::OPC_FilterValue, 187, 1, 4, 0, // Skip to: 11605
/* 11601 */   MCD::OPC_Decode, 132, 8, 108, // Opcode: VEXTH_Q_D, DecodeIdx: 108
/* 11605 */   MCD::OPC_FilterValue, 188, 1, 4, 0, // Skip to: 11614
/* 11610 */   MCD::OPC_Decode, 129, 8, 108, // Opcode: VEXTH_HU_BU, DecodeIdx: 108
/* 11614 */   MCD::OPC_FilterValue, 189, 1, 4, 0, // Skip to: 11623
/* 11619 */   MCD::OPC_Decode, 133, 8, 108, // Opcode: VEXTH_WU_HU, DecodeIdx: 108
/* 11623 */   MCD::OPC_FilterValue, 190, 1, 4, 0, // Skip to: 11632
/* 11628 */   MCD::OPC_Decode, 255, 7, 108, // Opcode: VEXTH_DU_WU, DecodeIdx: 108
/* 11632 */   MCD::OPC_FilterValue, 191, 1, 4, 0, // Skip to: 11641
/* 11637 */   MCD::OPC_Decode, 131, 8, 108, // Opcode: VEXTH_QU_DU, DecodeIdx: 108
/* 11641 */   MCD::OPC_FilterValue, 192, 1, 4, 0, // Skip to: 11650
/* 11646 */   MCD::OPC_Decode, 210, 10, 110, // Opcode: VREPLGR2VR_B, DecodeIdx: 110
/* 11650 */   MCD::OPC_FilterValue, 193, 1, 4, 0, // Skip to: 11659
/* 11655 */   MCD::OPC_Decode, 212, 10, 110, // Opcode: VREPLGR2VR_H, DecodeIdx: 110
/* 11659 */   MCD::OPC_FilterValue, 194, 1, 4, 0, // Skip to: 11668
/* 11664 */   MCD::OPC_Decode, 213, 10, 110, // Opcode: VREPLGR2VR_W, DecodeIdx: 110
/* 11668 */   MCD::OPC_FilterValueOrFail, 195, 1, 
/* 11671 */   MCD::OPC_Decode, 211, 10, 110, // Opcode: VREPLGR2VR_D, DecodeIdx: 110
/* 11675 */   MCD::OPC_FilterValue, 168, 1, 47, 0, // Skip to: 11727
/* 11680 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 11683 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 11721
/* 11687 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 11690 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 11715
/* 11694 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 11697 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 11709
/* 11701 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 11705 */   MCD::OPC_Decode, 222, 10, 111, // Opcode: VROTRI_B, DecodeIdx: 111
/* 11709 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11711 */   MCD::OPC_Decode, 224, 10, 112, // Opcode: VROTRI_H, DecodeIdx: 112
/* 11715 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11717 */   MCD::OPC_Decode, 225, 10, 106, // Opcode: VROTRI_W, DecodeIdx: 106
/* 11721 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11723 */   MCD::OPC_Decode, 223, 10, 113, // Opcode: VROTRI_D, DecodeIdx: 113
/* 11727 */   MCD::OPC_FilterValue, 169, 1, 47, 0, // Skip to: 11779
/* 11732 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 11735 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 11773
/* 11739 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 11742 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 11767
/* 11746 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 11749 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 11761
/* 11753 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 11757 */   MCD::OPC_Decode, 235, 11, 111, // Opcode: VSRLRI_B, DecodeIdx: 111
/* 11761 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11763 */   MCD::OPC_Decode, 237, 11, 112, // Opcode: VSRLRI_H, DecodeIdx: 112
/* 11767 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11769 */   MCD::OPC_Decode, 238, 11, 106, // Opcode: VSRLRI_W, DecodeIdx: 106
/* 11773 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11775 */   MCD::OPC_Decode, 236, 11, 113, // Opcode: VSRLRI_D, DecodeIdx: 113
/* 11779 */   MCD::OPC_FilterValue, 170, 1, 47, 0, // Skip to: 11831
/* 11784 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 11787 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 11825
/* 11791 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 11794 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 11819
/* 11798 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 11801 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 11813
/* 11805 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 11809 */   MCD::OPC_Decode, 205, 11, 111, // Opcode: VSRARI_B, DecodeIdx: 111
/* 11813 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11815 */   MCD::OPC_Decode, 207, 11, 112, // Opcode: VSRARI_H, DecodeIdx: 112
/* 11819 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11821 */   MCD::OPC_Decode, 208, 11, 106, // Opcode: VSRARI_W, DecodeIdx: 106
/* 11825 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11827 */   MCD::OPC_Decode, 206, 11, 113, // Opcode: VSRARI_D, DecodeIdx: 113
/* 11831 */   MCD::OPC_FilterValue, 186, 1, 47, 0, // Skip to: 11883
/* 11836 */   MCD::OPC_ExtractField, 14, 4,  // Inst{17-14} ...
/* 11839 */   MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 11847
/* 11843 */   MCD::OPC_Decode, 175, 9, 114, // Opcode: VINSGR2VR_B, DecodeIdx: 114
/* 11847 */   MCD::OPC_FilterValueOrFail, 15, 
/* 11849 */   MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 11852 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 11860
/* 11856 */   MCD::OPC_Decode, 177, 9, 115, // Opcode: VINSGR2VR_H, DecodeIdx: 115
/* 11860 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11862 */   MCD::OPC_ExtractField, 12, 1,  // Inst{12} ...
/* 11865 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 11873
/* 11869 */   MCD::OPC_Decode, 178, 9, 116, // Opcode: VINSGR2VR_W, DecodeIdx: 116
/* 11873 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11875 */   MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 11879 */   MCD::OPC_Decode, 176, 9, 117, // Opcode: VINSGR2VR_D, DecodeIdx: 117
/* 11883 */   MCD::OPC_FilterValue, 187, 1, 47, 0, // Skip to: 11935
/* 11888 */   MCD::OPC_ExtractField, 14, 4,  // Inst{17-14} ...
/* 11891 */   MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 11899
/* 11895 */   MCD::OPC_Decode, 202, 10, 118, // Opcode: VPICKVE2GR_B, DecodeIdx: 118
/* 11899 */   MCD::OPC_FilterValueOrFail, 15, 
/* 11901 */   MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 11904 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 11912
/* 11908 */   MCD::OPC_Decode, 206, 10, 119, // Opcode: VPICKVE2GR_H, DecodeIdx: 119
/* 11912 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11914 */   MCD::OPC_ExtractField, 12, 1,  // Inst{12} ...
/* 11917 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 11925
/* 11921 */   MCD::OPC_Decode, 208, 10, 120, // Opcode: VPICKVE2GR_W, DecodeIdx: 120
/* 11925 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11927 */   MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 11931 */   MCD::OPC_Decode, 204, 10, 121, // Opcode: VPICKVE2GR_D, DecodeIdx: 121
/* 11935 */   MCD::OPC_FilterValue, 188, 1, 47, 0, // Skip to: 11987
/* 11940 */   MCD::OPC_ExtractField, 14, 4,  // Inst{17-14} ...
/* 11943 */   MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 11951
/* 11947 */   MCD::OPC_Decode, 203, 10, 118, // Opcode: VPICKVE2GR_BU, DecodeIdx: 118
/* 11951 */   MCD::OPC_FilterValueOrFail, 15, 
/* 11953 */   MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 11956 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 11964
/* 11960 */   MCD::OPC_Decode, 207, 10, 119, // Opcode: VPICKVE2GR_HU, DecodeIdx: 119
/* 11964 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11966 */   MCD::OPC_ExtractField, 12, 1,  // Inst{12} ...
/* 11969 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 11977
/* 11973 */   MCD::OPC_Decode, 209, 10, 120, // Opcode: VPICKVE2GR_WU, DecodeIdx: 120
/* 11977 */   MCD::OPC_FilterValueOrFail, 1, 
/* 11979 */   MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 11983 */   MCD::OPC_Decode, 205, 10, 121, // Opcode: VPICKVE2GR_DU, DecodeIdx: 121
/* 11987 */   MCD::OPC_FilterValue, 189, 1, 47, 0, // Skip to: 12039
/* 11992 */   MCD::OPC_ExtractField, 14, 4,  // Inst{17-14} ...
/* 11995 */   MCD::OPC_FilterValue, 14, 4, 0, // Skip to: 12003
/* 11999 */   MCD::OPC_Decode, 214, 10, 112, // Opcode: VREPLVEI_B, DecodeIdx: 112
/* 12003 */   MCD::OPC_FilterValueOrFail, 15, 
/* 12005 */   MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 12008 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 12016
/* 12012 */   MCD::OPC_Decode, 216, 10, 111, // Opcode: VREPLVEI_H, DecodeIdx: 111
/* 12016 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12018 */   MCD::OPC_ExtractField, 12, 1,  // Inst{12} ...
/* 12021 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 12029
/* 12025 */   MCD::OPC_Decode, 217, 10, 122, // Opcode: VREPLVEI_W, DecodeIdx: 122
/* 12029 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12031 */   MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 12035 */   MCD::OPC_Decode, 215, 10, 123, // Opcode: VREPLVEI_D, DecodeIdx: 123
/* 12039 */   MCD::OPC_FilterValue, 194, 1, 46, 0, // Skip to: 12090
/* 12044 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12047 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12072
/* 12051 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 12054 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12066
/* 12058 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 12062 */   MCD::OPC_Decode, 171, 11, 111, // Opcode: VSLLWIL_H_B, DecodeIdx: 111
/* 12066 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12068 */   MCD::OPC_Decode, 173, 11, 112, // Opcode: VSLLWIL_W_H, DecodeIdx: 112
/* 12072 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 12080
/* 12076 */   MCD::OPC_Decode, 169, 11, 106, // Opcode: VSLLWIL_D_W, DecodeIdx: 106
/* 12080 */   MCD::OPC_FilterValueOrFail, 2, 
/* 12082 */   MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 12086 */   MCD::OPC_Decode, 136, 8, 108, // Opcode: VEXTL_Q_D, DecodeIdx: 108
/* 12090 */   MCD::OPC_FilterValue, 195, 1, 46, 0, // Skip to: 12141
/* 12095 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 12098 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12123
/* 12102 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 12105 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12117
/* 12109 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 12113 */   MCD::OPC_Decode, 170, 11, 111, // Opcode: VSLLWIL_HU_BU, DecodeIdx: 111
/* 12117 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12119 */   MCD::OPC_Decode, 172, 11, 112, // Opcode: VSLLWIL_WU_HU, DecodeIdx: 112
/* 12123 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 12131
/* 12127 */   MCD::OPC_Decode, 168, 11, 106, // Opcode: VSLLWIL_DU_WU, DecodeIdx: 106
/* 12131 */   MCD::OPC_FilterValueOrFail, 2, 
/* 12133 */   MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 12137 */   MCD::OPC_Decode, 135, 8, 108, // Opcode: VEXTL_QU_DU, DecodeIdx: 108
/* 12141 */   MCD::OPC_FilterValue, 196, 1, 47, 0, // Skip to: 12193
/* 12146 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 12149 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12187
/* 12153 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12156 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12181
/* 12160 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 12163 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12175
/* 12167 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 12171 */   MCD::OPC_Decode, 199, 7, 111, // Opcode: VBITCLRI_B, DecodeIdx: 111
/* 12175 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12177 */   MCD::OPC_Decode, 201, 7, 112, // Opcode: VBITCLRI_H, DecodeIdx: 112
/* 12181 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12183 */   MCD::OPC_Decode, 202, 7, 106, // Opcode: VBITCLRI_W, DecodeIdx: 106
/* 12187 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12189 */   MCD::OPC_Decode, 200, 7, 113, // Opcode: VBITCLRI_D, DecodeIdx: 113
/* 12193 */   MCD::OPC_FilterValue, 197, 1, 47, 0, // Skip to: 12245
/* 12198 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 12201 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12239
/* 12205 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12208 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12233
/* 12212 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 12215 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12227
/* 12219 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 12223 */   MCD::OPC_Decode, 217, 7, 111, // Opcode: VBITSETI_B, DecodeIdx: 111
/* 12227 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12229 */   MCD::OPC_Decode, 219, 7, 112, // Opcode: VBITSETI_H, DecodeIdx: 112
/* 12233 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12235 */   MCD::OPC_Decode, 220, 7, 106, // Opcode: VBITSETI_W, DecodeIdx: 106
/* 12239 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12241 */   MCD::OPC_Decode, 218, 7, 113, // Opcode: VBITSETI_D, DecodeIdx: 113
/* 12245 */   MCD::OPC_FilterValue, 198, 1, 47, 0, // Skip to: 12297
/* 12250 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 12253 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12291
/* 12257 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12260 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12285
/* 12264 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 12267 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12279
/* 12271 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 12275 */   MCD::OPC_Decode, 207, 7, 111, // Opcode: VBITREVI_B, DecodeIdx: 111
/* 12279 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12281 */   MCD::OPC_Decode, 209, 7, 112, // Opcode: VBITREVI_H, DecodeIdx: 112
/* 12285 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12287 */   MCD::OPC_Decode, 210, 7, 106, // Opcode: VBITREVI_W, DecodeIdx: 106
/* 12291 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12293 */   MCD::OPC_Decode, 208, 7, 113, // Opcode: VBITREVI_D, DecodeIdx: 113
/* 12297 */   MCD::OPC_FilterValue, 201, 1, 47, 0, // Skip to: 12349
/* 12302 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 12305 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12343
/* 12309 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12312 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12337
/* 12316 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 12319 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12331
/* 12323 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 12327 */   MCD::OPC_Decode, 238, 10, 111, // Opcode: VSAT_B, DecodeIdx: 111
/* 12331 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12333 */   MCD::OPC_Decode, 242, 10, 112, // Opcode: VSAT_H, DecodeIdx: 112
/* 12337 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12339 */   MCD::OPC_Decode, 244, 10, 106, // Opcode: VSAT_W, DecodeIdx: 106
/* 12343 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12345 */   MCD::OPC_Decode, 240, 10, 113, // Opcode: VSAT_D, DecodeIdx: 113
/* 12349 */   MCD::OPC_FilterValue, 202, 1, 47, 0, // Skip to: 12401
/* 12354 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 12357 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12395
/* 12361 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12364 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12389
/* 12368 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 12371 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12383
/* 12375 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 12379 */   MCD::OPC_Decode, 239, 10, 111, // Opcode: VSAT_BU, DecodeIdx: 111
/* 12383 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12385 */   MCD::OPC_Decode, 243, 10, 112, // Opcode: VSAT_HU, DecodeIdx: 112
/* 12389 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12391 */   MCD::OPC_Decode, 245, 10, 106, // Opcode: VSAT_WU, DecodeIdx: 106
/* 12395 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12397 */   MCD::OPC_Decode, 241, 10, 113, // Opcode: VSAT_DU, DecodeIdx: 113
/* 12401 */   MCD::OPC_FilterValue, 203, 1, 47, 0, // Skip to: 12453
/* 12406 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 12409 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12447
/* 12413 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12416 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12441
/* 12420 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 12423 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12435
/* 12427 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 12431 */   MCD::OPC_Decode, 164, 11, 111, // Opcode: VSLLI_B, DecodeIdx: 111
/* 12435 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12437 */   MCD::OPC_Decode, 166, 11, 112, // Opcode: VSLLI_H, DecodeIdx: 112
/* 12441 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12443 */   MCD::OPC_Decode, 167, 11, 106, // Opcode: VSLLI_W, DecodeIdx: 106
/* 12447 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12449 */   MCD::OPC_Decode, 165, 11, 113, // Opcode: VSLLI_D, DecodeIdx: 113
/* 12453 */   MCD::OPC_FilterValue, 204, 1, 47, 0, // Skip to: 12505
/* 12458 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 12461 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12499
/* 12465 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12468 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12493
/* 12472 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 12475 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12487
/* 12479 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 12483 */   MCD::OPC_Decode, 224, 11, 111, // Opcode: VSRLI_B, DecodeIdx: 111
/* 12487 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12489 */   MCD::OPC_Decode, 226, 11, 112, // Opcode: VSRLI_H, DecodeIdx: 112
/* 12493 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12495 */   MCD::OPC_Decode, 227, 11, 106, // Opcode: VSRLI_W, DecodeIdx: 106
/* 12499 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12501 */   MCD::OPC_Decode, 225, 11, 113, // Opcode: VSRLI_D, DecodeIdx: 113
/* 12505 */   MCD::OPC_FilterValue, 205, 1, 47, 0, // Skip to: 12557
/* 12510 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 12513 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12551
/* 12517 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12520 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12545
/* 12524 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 12527 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12539
/* 12531 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 12535 */   MCD::OPC_Decode, 194, 11, 111, // Opcode: VSRAI_B, DecodeIdx: 111
/* 12539 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12541 */   MCD::OPC_Decode, 196, 11, 112, // Opcode: VSRAI_H, DecodeIdx: 112
/* 12545 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12547 */   MCD::OPC_Decode, 197, 11, 106, // Opcode: VSRAI_W, DecodeIdx: 106
/* 12551 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12553 */   MCD::OPC_Decode, 195, 11, 113, // Opcode: VSRAI_D, DecodeIdx: 113
/* 12557 */   MCD::OPC_FilterValue, 208, 1, 47, 0, // Skip to: 12609
/* 12562 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 12565 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12603
/* 12569 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 12572 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12597
/* 12576 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12579 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12591
/* 12583 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 12587 */   MCD::OPC_Decode, 228, 11, 124, // Opcode: VSRLNI_B_H, DecodeIdx: 124
/* 12591 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12593 */   MCD::OPC_Decode, 230, 11, 107, // Opcode: VSRLNI_H_W, DecodeIdx: 107
/* 12597 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12599 */   MCD::OPC_Decode, 231, 11, 125, // Opcode: VSRLNI_W_D, DecodeIdx: 125
/* 12603 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12605 */   MCD::OPC_Decode, 229, 11, 126, // Opcode: VSRLNI_D_Q, DecodeIdx: 126
/* 12609 */   MCD::OPC_FilterValue, 209, 1, 47, 0, // Skip to: 12661
/* 12614 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 12617 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12655
/* 12621 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 12624 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12649
/* 12628 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12631 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12643
/* 12635 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 12639 */   MCD::OPC_Decode, 239, 11, 124, // Opcode: VSRLRNI_B_H, DecodeIdx: 124
/* 12643 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12645 */   MCD::OPC_Decode, 241, 11, 107, // Opcode: VSRLRNI_H_W, DecodeIdx: 107
/* 12649 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12651 */   MCD::OPC_Decode, 242, 11, 125, // Opcode: VSRLRNI_W_D, DecodeIdx: 125
/* 12655 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12657 */   MCD::OPC_Decode, 240, 11, 126, // Opcode: VSRLRNI_D_Q, DecodeIdx: 126
/* 12661 */   MCD::OPC_FilterValue, 210, 1, 47, 0, // Skip to: 12713
/* 12666 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 12669 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12707
/* 12673 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 12676 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12701
/* 12680 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12683 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12695
/* 12687 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 12691 */   MCD::OPC_Decode, 155, 12, 124, // Opcode: VSSRLNI_B_H, DecodeIdx: 124
/* 12695 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12697 */   MCD::OPC_Decode, 159, 12, 107, // Opcode: VSSRLNI_H_W, DecodeIdx: 107
/* 12701 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12703 */   MCD::OPC_Decode, 161, 12, 125, // Opcode: VSSRLNI_W_D, DecodeIdx: 125
/* 12707 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12709 */   MCD::OPC_Decode, 157, 12, 126, // Opcode: VSSRLNI_D_Q, DecodeIdx: 126
/* 12713 */   MCD::OPC_FilterValue, 211, 1, 47, 0, // Skip to: 12765
/* 12718 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 12721 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12759
/* 12725 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 12728 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12753
/* 12732 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12735 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12747
/* 12739 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 12743 */   MCD::OPC_Decode, 154, 12, 124, // Opcode: VSSRLNI_BU_H, DecodeIdx: 124
/* 12747 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12749 */   MCD::OPC_Decode, 158, 12, 107, // Opcode: VSSRLNI_HU_W, DecodeIdx: 107
/* 12753 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12755 */   MCD::OPC_Decode, 160, 12, 125, // Opcode: VSSRLNI_WU_D, DecodeIdx: 125
/* 12759 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12761 */   MCD::OPC_Decode, 156, 12, 126, // Opcode: VSSRLNI_DU_Q, DecodeIdx: 126
/* 12765 */   MCD::OPC_FilterValue, 212, 1, 47, 0, // Skip to: 12817
/* 12770 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 12773 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12811
/* 12777 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 12780 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12805
/* 12784 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12787 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12799
/* 12791 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 12795 */   MCD::OPC_Decode, 169, 12, 124, // Opcode: VSSRLRNI_B_H, DecodeIdx: 124
/* 12799 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12801 */   MCD::OPC_Decode, 173, 12, 107, // Opcode: VSSRLRNI_H_W, DecodeIdx: 107
/* 12805 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12807 */   MCD::OPC_Decode, 175, 12, 125, // Opcode: VSSRLRNI_W_D, DecodeIdx: 125
/* 12811 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12813 */   MCD::OPC_Decode, 171, 12, 126, // Opcode: VSSRLRNI_D_Q, DecodeIdx: 126
/* 12817 */   MCD::OPC_FilterValue, 213, 1, 47, 0, // Skip to: 12869
/* 12822 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 12825 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12863
/* 12829 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 12832 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12857
/* 12836 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12839 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12851
/* 12843 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 12847 */   MCD::OPC_Decode, 168, 12, 124, // Opcode: VSSRLRNI_BU_H, DecodeIdx: 124
/* 12851 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12853 */   MCD::OPC_Decode, 172, 12, 107, // Opcode: VSSRLRNI_HU_W, DecodeIdx: 107
/* 12857 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12859 */   MCD::OPC_Decode, 174, 12, 125, // Opcode: VSSRLRNI_WU_D, DecodeIdx: 125
/* 12863 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12865 */   MCD::OPC_Decode, 170, 12, 126, // Opcode: VSSRLRNI_DU_Q, DecodeIdx: 126
/* 12869 */   MCD::OPC_FilterValue, 214, 1, 47, 0, // Skip to: 12921
/* 12874 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 12877 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12915
/* 12881 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 12884 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12909
/* 12888 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12891 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12903
/* 12895 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 12899 */   MCD::OPC_Decode, 198, 11, 124, // Opcode: VSRANI_B_H, DecodeIdx: 124
/* 12903 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12905 */   MCD::OPC_Decode, 200, 11, 107, // Opcode: VSRANI_H_W, DecodeIdx: 107
/* 12909 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12911 */   MCD::OPC_Decode, 201, 11, 125, // Opcode: VSRANI_W_D, DecodeIdx: 125
/* 12915 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12917 */   MCD::OPC_Decode, 199, 11, 126, // Opcode: VSRANI_D_Q, DecodeIdx: 126
/* 12921 */   MCD::OPC_FilterValue, 215, 1, 47, 0, // Skip to: 12973
/* 12926 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 12929 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 12967
/* 12933 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 12936 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 12961
/* 12940 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12943 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 12955
/* 12947 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 12951 */   MCD::OPC_Decode, 209, 11, 124, // Opcode: VSRARNI_B_H, DecodeIdx: 124
/* 12955 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12957 */   MCD::OPC_Decode, 211, 11, 107, // Opcode: VSRARNI_H_W, DecodeIdx: 107
/* 12961 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12963 */   MCD::OPC_Decode, 212, 11, 125, // Opcode: VSRARNI_W_D, DecodeIdx: 125
/* 12967 */   MCD::OPC_FilterValueOrFail, 1, 
/* 12969 */   MCD::OPC_Decode, 210, 11, 126, // Opcode: VSRARNI_D_Q, DecodeIdx: 126
/* 12973 */   MCD::OPC_FilterValue, 216, 1, 47, 0, // Skip to: 13025
/* 12978 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 12981 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 13019
/* 12985 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 12988 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 13013
/* 12992 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 12995 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 13007
/* 12999 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 13003 */   MCD::OPC_Decode, 255, 11, 124, // Opcode: VSSRANI_B_H, DecodeIdx: 124
/* 13007 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13009 */   MCD::OPC_Decode, 131, 12, 107, // Opcode: VSSRANI_H_W, DecodeIdx: 107
/* 13013 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13015 */   MCD::OPC_Decode, 133, 12, 125, // Opcode: VSSRANI_W_D, DecodeIdx: 125
/* 13019 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13021 */   MCD::OPC_Decode, 129, 12, 126, // Opcode: VSSRANI_D_Q, DecodeIdx: 126
/* 13025 */   MCD::OPC_FilterValue, 217, 1, 47, 0, // Skip to: 13077
/* 13030 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 13033 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 13071
/* 13037 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 13040 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 13065
/* 13044 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 13047 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 13059
/* 13051 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 13055 */   MCD::OPC_Decode, 254, 11, 124, // Opcode: VSSRANI_BU_H, DecodeIdx: 124
/* 13059 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13061 */   MCD::OPC_Decode, 130, 12, 107, // Opcode: VSSRANI_HU_W, DecodeIdx: 107
/* 13065 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13067 */   MCD::OPC_Decode, 132, 12, 125, // Opcode: VSSRANI_WU_D, DecodeIdx: 125
/* 13071 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13073 */   MCD::OPC_Decode, 128, 12, 126, // Opcode: VSSRANI_DU_Q, DecodeIdx: 126
/* 13077 */   MCD::OPC_FilterValue, 218, 1, 47, 0, // Skip to: 13129
/* 13082 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 13085 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 13123
/* 13089 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 13092 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 13117
/* 13096 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 13099 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 13111
/* 13103 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 13107 */   MCD::OPC_Decode, 141, 12, 124, // Opcode: VSSRARNI_B_H, DecodeIdx: 124
/* 13111 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13113 */   MCD::OPC_Decode, 145, 12, 107, // Opcode: VSSRARNI_H_W, DecodeIdx: 107
/* 13117 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13119 */   MCD::OPC_Decode, 147, 12, 125, // Opcode: VSSRARNI_W_D, DecodeIdx: 125
/* 13123 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13125 */   MCD::OPC_Decode, 143, 12, 126, // Opcode: VSSRARNI_D_Q, DecodeIdx: 126
/* 13129 */   MCD::OPC_FilterValue, 219, 1, 47, 0, // Skip to: 13181
/* 13134 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 13137 */   MCD::OPC_FilterValue, 0, 34, 0, // Skip to: 13175
/* 13141 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 13144 */   MCD::OPC_FilterValue, 0, 21, 0, // Skip to: 13169
/* 13148 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 13151 */   MCD::OPC_FilterValue, 0, 8, 0, // Skip to: 13163
/* 13155 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 13159 */   MCD::OPC_Decode, 140, 12, 124, // Opcode: VSSRARNI_BU_H, DecodeIdx: 124
/* 13163 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13165 */   MCD::OPC_Decode, 144, 12, 107, // Opcode: VSSRARNI_HU_W, DecodeIdx: 107
/* 13169 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13171 */   MCD::OPC_Decode, 146, 12, 125, // Opcode: VSSRARNI_WU_D, DecodeIdx: 125
/* 13175 */   MCD::OPC_FilterValueOrFail, 1, 
/* 13177 */   MCD::OPC_Decode, 142, 12, 126, // Opcode: VSSRARNI_DU_Q, DecodeIdx: 126
/* 13181 */   MCD::OPC_FilterValue, 224, 1, 4, 0, // Skip to: 13190
/* 13186 */   MCD::OPC_Decode, 138, 8, 127, // Opcode: VEXTRINS_D, DecodeIdx: 127
/* 13190 */   MCD::OPC_FilterValue, 225, 1, 4, 0, // Skip to: 13199
/* 13195 */   MCD::OPC_Decode, 140, 8, 127, // Opcode: VEXTRINS_W, DecodeIdx: 127
/* 13199 */   MCD::OPC_FilterValue, 226, 1, 4, 0, // Skip to: 13208
/* 13204 */   MCD::OPC_Decode, 139, 8, 127, // Opcode: VEXTRINS_H, DecodeIdx: 127
/* 13208 */   MCD::OPC_FilterValue, 227, 1, 4, 0, // Skip to: 13217
/* 13213 */   MCD::OPC_Decode, 137, 8, 127, // Opcode: VEXTRINS_B, DecodeIdx: 127
/* 13217 */   MCD::OPC_FilterValue, 228, 1, 5, 0, // Skip to: 13227
/* 13222 */   MCD::OPC_Decode, 136, 11, 128, 1, // Opcode: VSHUF4I_B, DecodeIdx: 128
/* 13227 */   MCD::OPC_FilterValue, 229, 1, 5, 0, // Skip to: 13237
/* 13232 */   MCD::OPC_Decode, 138, 11, 128, 1, // Opcode: VSHUF4I_H, DecodeIdx: 128
/* 13237 */   MCD::OPC_FilterValue, 230, 1, 5, 0, // Skip to: 13247
/* 13242 */   MCD::OPC_Decode, 139, 11, 128, 1, // Opcode: VSHUF4I_W, DecodeIdx: 128
/* 13247 */   MCD::OPC_FilterValue, 231, 1, 4, 0, // Skip to: 13256
/* 13252 */   MCD::OPC_Decode, 137, 11, 127, // Opcode: VSHUF4I_D, DecodeIdx: 127
/* 13256 */   MCD::OPC_FilterValue, 241, 1, 4, 0, // Skip to: 13265
/* 13261 */   MCD::OPC_Decode, 215, 7, 127, // Opcode: VBITSELI_B, DecodeIdx: 127
/* 13265 */   MCD::OPC_FilterValue, 244, 1, 5, 0, // Skip to: 13275
/* 13270 */   MCD::OPC_Decode, 180, 7, 128, 1, // Opcode: VANDI_B, DecodeIdx: 128
/* 13275 */   MCD::OPC_FilterValue, 245, 1, 5, 0, // Skip to: 13285
/* 13280 */   MCD::OPC_Decode, 178, 10, 128, 1, // Opcode: VORI_B, DecodeIdx: 128
/* 13285 */   MCD::OPC_FilterValue, 246, 1, 5, 0, // Skip to: 13295
/* 13290 */   MCD::OPC_Decode, 221, 12, 128, 1, // Opcode: VXORI_B, DecodeIdx: 128
/* 13295 */   MCD::OPC_FilterValue, 247, 1, 5, 0, // Skip to: 13305
/* 13300 */   MCD::OPC_Decode, 176, 10, 128, 1, // Opcode: VNORI_B, DecodeIdx: 128
/* 13305 */   MCD::OPC_FilterValue, 248, 1, 5, 0, // Skip to: 13315
/* 13310 */   MCD::OPC_Decode, 180, 9, 129, 1, // Opcode: VLDI, DecodeIdx: 129
/* 13315 */   MCD::OPC_FilterValueOrFail, 249, 1, 
/* 13318 */   MCD::OPC_Decode, 193, 10, 127, // Opcode: VPERMI_W, DecodeIdx: 127
/* 13322 */   MCD::OPC_FilterValueOrFail, 29, 
/* 13324 */   MCD::OPC_ExtractField, 18, 8,  // Inst{25-18} ...
/* 13327 */   MCD::OPC_FilterValue, 0, 65, 0, // Skip to: 13396
/* 13331 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13334 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 13342
/* 13338 */   MCD::OPC_Decode, 192, 17, 64, // Opcode: XVSEQ_B, DecodeIdx: 64
/* 13342 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 13350
/* 13346 */   MCD::OPC_Decode, 194, 17, 64, // Opcode: XVSEQ_H, DecodeIdx: 64
/* 13350 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 13358
/* 13354 */   MCD::OPC_Decode, 195, 17, 64, // Opcode: XVSEQ_W, DecodeIdx: 64
/* 13358 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 13366
/* 13362 */   MCD::OPC_Decode, 193, 17, 64, // Opcode: XVSEQ_D, DecodeIdx: 64
/* 13366 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 13374
/* 13370 */   MCD::OPC_Decode, 226, 17, 64, // Opcode: XVSLE_B, DecodeIdx: 64
/* 13374 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 13382
/* 13378 */   MCD::OPC_Decode, 230, 17, 64, // Opcode: XVSLE_H, DecodeIdx: 64
/* 13382 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 13390
/* 13386 */   MCD::OPC_Decode, 232, 17, 64, // Opcode: XVSLE_W, DecodeIdx: 64
/* 13390 */   MCD::OPC_FilterValueOrFail, 7, 
/* 13392 */   MCD::OPC_Decode, 228, 17, 64, // Opcode: XVSLE_D, DecodeIdx: 64
/* 13396 */   MCD::OPC_FilterValue, 1, 65, 0, // Skip to: 13465
/* 13400 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13403 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 13411
/* 13407 */   MCD::OPC_Decode, 227, 17, 64, // Opcode: XVSLE_BU, DecodeIdx: 64
/* 13411 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 13419
/* 13415 */   MCD::OPC_Decode, 231, 17, 64, // Opcode: XVSLE_HU, DecodeIdx: 64
/* 13419 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 13427
/* 13423 */   MCD::OPC_Decode, 233, 17, 64, // Opcode: XVSLE_WU, DecodeIdx: 64
/* 13427 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 13435
/* 13431 */   MCD::OPC_Decode, 229, 17, 64, // Opcode: XVSLE_DU, DecodeIdx: 64
/* 13435 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 13443
/* 13439 */   MCD::OPC_Decode, 128, 18, 64, // Opcode: XVSLT_B, DecodeIdx: 64
/* 13443 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 13451
/* 13447 */   MCD::OPC_Decode, 132, 18, 64, // Opcode: XVSLT_H, DecodeIdx: 64
/* 13451 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 13459
/* 13455 */   MCD::OPC_Decode, 134, 18, 64, // Opcode: XVSLT_W, DecodeIdx: 64
/* 13459 */   MCD::OPC_FilterValueOrFail, 7, 
/* 13461 */   MCD::OPC_Decode, 130, 18, 64, // Opcode: XVSLT_D, DecodeIdx: 64
/* 13465 */   MCD::OPC_FilterValue, 2, 65, 0, // Skip to: 13534
/* 13469 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13472 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 13480
/* 13476 */   MCD::OPC_Decode, 129, 18, 64, // Opcode: XVSLT_BU, DecodeIdx: 64
/* 13480 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 13488
/* 13484 */   MCD::OPC_Decode, 133, 18, 64, // Opcode: XVSLT_HU, DecodeIdx: 64
/* 13488 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 13496
/* 13492 */   MCD::OPC_Decode, 135, 18, 64, // Opcode: XVSLT_WU, DecodeIdx: 64
/* 13496 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 13504
/* 13500 */   MCD::OPC_Decode, 131, 18, 64, // Opcode: XVSLT_DU, DecodeIdx: 64
/* 13504 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 13512
/* 13508 */   MCD::OPC_Decode, 250, 13, 64, // Opcode: XVADD_B, DecodeIdx: 64
/* 13512 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 13520
/* 13516 */   MCD::OPC_Decode, 252, 13, 64, // Opcode: XVADD_H, DecodeIdx: 64
/* 13520 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 13528
/* 13524 */   MCD::OPC_Decode, 254, 13, 64, // Opcode: XVADD_W, DecodeIdx: 64
/* 13528 */   MCD::OPC_FilterValueOrFail, 7, 
/* 13530 */   MCD::OPC_Decode, 251, 13, 64, // Opcode: XVADD_D, DecodeIdx: 64
/* 13534 */   MCD::OPC_FilterValue, 3, 33, 0, // Skip to: 13571
/* 13538 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13541 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 13549
/* 13545 */   MCD::OPC_Decode, 158, 19, 64, // Opcode: XVSUB_B, DecodeIdx: 64
/* 13549 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 13557
/* 13553 */   MCD::OPC_Decode, 160, 19, 64, // Opcode: XVSUB_H, DecodeIdx: 64
/* 13557 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 13565
/* 13561 */   MCD::OPC_Decode, 162, 19, 64, // Opcode: XVSUB_W, DecodeIdx: 64
/* 13565 */   MCD::OPC_FilterValueOrFail, 3, 
/* 13567 */   MCD::OPC_Decode, 159, 19, 64, // Opcode: XVSUB_D, DecodeIdx: 64
/* 13571 */   MCD::OPC_FilterValue, 7, 33, 0, // Skip to: 13608
/* 13575 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13578 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 13586
/* 13582 */   MCD::OPC_Decode, 229, 13, 64, // Opcode: XVADDWEV_H_B, DecodeIdx: 64
/* 13586 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 13594
/* 13590 */   MCD::OPC_Decode, 235, 13, 64, // Opcode: XVADDWEV_W_H, DecodeIdx: 64
/* 13594 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 13602
/* 13598 */   MCD::OPC_Decode, 226, 13, 64, // Opcode: XVADDWEV_D_W, DecodeIdx: 64
/* 13602 */   MCD::OPC_FilterValueOrFail, 7, 
/* 13604 */   MCD::OPC_Decode, 232, 13, 64, // Opcode: XVADDWEV_Q_D, DecodeIdx: 64
/* 13608 */   MCD::OPC_FilterValue, 8, 65, 0, // Skip to: 13677
/* 13612 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13615 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 13623
/* 13619 */   MCD::OPC_Decode, 144, 19, 64, // Opcode: XVSUBWEV_H_B, DecodeIdx: 64
/* 13623 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 13631
/* 13627 */   MCD::OPC_Decode, 148, 19, 64, // Opcode: XVSUBWEV_W_H, DecodeIdx: 64
/* 13631 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 13639
/* 13635 */   MCD::OPC_Decode, 142, 19, 64, // Opcode: XVSUBWEV_D_W, DecodeIdx: 64
/* 13639 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 13647
/* 13643 */   MCD::OPC_Decode, 146, 19, 64, // Opcode: XVSUBWEV_Q_D, DecodeIdx: 64
/* 13647 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 13655
/* 13651 */   MCD::OPC_Decode, 241, 13, 64, // Opcode: XVADDWOD_H_B, DecodeIdx: 64
/* 13655 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 13663
/* 13659 */   MCD::OPC_Decode, 247, 13, 64, // Opcode: XVADDWOD_W_H, DecodeIdx: 64
/* 13663 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 13671
/* 13667 */   MCD::OPC_Decode, 238, 13, 64, // Opcode: XVADDWOD_D_W, DecodeIdx: 64
/* 13671 */   MCD::OPC_FilterValueOrFail, 7, 
/* 13673 */   MCD::OPC_Decode, 244, 13, 64, // Opcode: XVADDWOD_Q_D, DecodeIdx: 64
/* 13677 */   MCD::OPC_FilterValue, 9, 33, 0, // Skip to: 13714
/* 13681 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13684 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 13692
/* 13688 */   MCD::OPC_Decode, 152, 19, 64, // Opcode: XVSUBWOD_H_B, DecodeIdx: 64
/* 13692 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 13700
/* 13696 */   MCD::OPC_Decode, 156, 19, 64, // Opcode: XVSUBWOD_W_H, DecodeIdx: 64
/* 13700 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 13708
/* 13704 */   MCD::OPC_Decode, 150, 19, 64, // Opcode: XVSUBWOD_D_W, DecodeIdx: 64
/* 13708 */   MCD::OPC_FilterValueOrFail, 3, 
/* 13710 */   MCD::OPC_Decode, 154, 19, 64, // Opcode: XVSUBWOD_Q_D, DecodeIdx: 64
/* 13714 */   MCD::OPC_FilterValue, 11, 33, 0, // Skip to: 13751
/* 13718 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13721 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 13729
/* 13725 */   MCD::OPC_Decode, 230, 13, 64, // Opcode: XVADDWEV_H_BU, DecodeIdx: 64
/* 13729 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 13737
/* 13733 */   MCD::OPC_Decode, 236, 13, 64, // Opcode: XVADDWEV_W_HU, DecodeIdx: 64
/* 13737 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 13745
/* 13741 */   MCD::OPC_Decode, 227, 13, 64, // Opcode: XVADDWEV_D_WU, DecodeIdx: 64
/* 13745 */   MCD::OPC_FilterValueOrFail, 7, 
/* 13747 */   MCD::OPC_Decode, 233, 13, 64, // Opcode: XVADDWEV_Q_DU, DecodeIdx: 64
/* 13751 */   MCD::OPC_FilterValue, 12, 65, 0, // Skip to: 13820
/* 13755 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13758 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 13766
/* 13762 */   MCD::OPC_Decode, 145, 19, 64, // Opcode: XVSUBWEV_H_BU, DecodeIdx: 64
/* 13766 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 13774
/* 13770 */   MCD::OPC_Decode, 149, 19, 64, // Opcode: XVSUBWEV_W_HU, DecodeIdx: 64
/* 13774 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 13782
/* 13778 */   MCD::OPC_Decode, 143, 19, 64, // Opcode: XVSUBWEV_D_WU, DecodeIdx: 64
/* 13782 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 13790
/* 13786 */   MCD::OPC_Decode, 147, 19, 64, // Opcode: XVSUBWEV_Q_DU, DecodeIdx: 64
/* 13790 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 13798
/* 13794 */   MCD::OPC_Decode, 242, 13, 64, // Opcode: XVADDWOD_H_BU, DecodeIdx: 64
/* 13798 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 13806
/* 13802 */   MCD::OPC_Decode, 248, 13, 64, // Opcode: XVADDWOD_W_HU, DecodeIdx: 64
/* 13806 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 13814
/* 13810 */   MCD::OPC_Decode, 239, 13, 64, // Opcode: XVADDWOD_D_WU, DecodeIdx: 64
/* 13814 */   MCD::OPC_FilterValueOrFail, 7, 
/* 13816 */   MCD::OPC_Decode, 245, 13, 64, // Opcode: XVADDWOD_Q_DU, DecodeIdx: 64
/* 13820 */   MCD::OPC_FilterValue, 13, 33, 0, // Skip to: 13857
/* 13824 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13827 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 13835
/* 13831 */   MCD::OPC_Decode, 153, 19, 64, // Opcode: XVSUBWOD_H_BU, DecodeIdx: 64
/* 13835 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 13843
/* 13839 */   MCD::OPC_Decode, 157, 19, 64, // Opcode: XVSUBWOD_W_HU, DecodeIdx: 64
/* 13843 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 13851
/* 13847 */   MCD::OPC_Decode, 151, 19, 64, // Opcode: XVSUBWOD_D_WU, DecodeIdx: 64
/* 13851 */   MCD::OPC_FilterValueOrFail, 3, 
/* 13853 */   MCD::OPC_Decode, 155, 19, 64, // Opcode: XVSUBWOD_Q_DU, DecodeIdx: 64
/* 13857 */   MCD::OPC_FilterValue, 15, 33, 0, // Skip to: 13894
/* 13861 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13864 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 13872
/* 13868 */   MCD::OPC_Decode, 231, 13, 64, // Opcode: XVADDWEV_H_BU_B, DecodeIdx: 64
/* 13872 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 13880
/* 13876 */   MCD::OPC_Decode, 237, 13, 64, // Opcode: XVADDWEV_W_HU_H, DecodeIdx: 64
/* 13880 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 13888
/* 13884 */   MCD::OPC_Decode, 228, 13, 64, // Opcode: XVADDWEV_D_WU_W, DecodeIdx: 64
/* 13888 */   MCD::OPC_FilterValueOrFail, 7, 
/* 13890 */   MCD::OPC_Decode, 234, 13, 64, // Opcode: XVADDWEV_Q_DU_D, DecodeIdx: 64
/* 13894 */   MCD::OPC_FilterValue, 16, 33, 0, // Skip to: 13931
/* 13898 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13901 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 13909
/* 13905 */   MCD::OPC_Decode, 243, 13, 64, // Opcode: XVADDWOD_H_BU_B, DecodeIdx: 64
/* 13909 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 13917
/* 13913 */   MCD::OPC_Decode, 249, 13, 64, // Opcode: XVADDWOD_W_HU_H, DecodeIdx: 64
/* 13917 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 13925
/* 13921 */   MCD::OPC_Decode, 240, 13, 64, // Opcode: XVADDWOD_D_WU_W, DecodeIdx: 64
/* 13925 */   MCD::OPC_FilterValueOrFail, 3, 
/* 13927 */   MCD::OPC_Decode, 246, 13, 64, // Opcode: XVADDWOD_Q_DU_D, DecodeIdx: 64
/* 13931 */   MCD::OPC_FilterValue, 17, 33, 0, // Skip to: 13968
/* 13935 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13938 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 13946
/* 13942 */   MCD::OPC_Decode, 172, 17, 64, // Opcode: XVSADD_B, DecodeIdx: 64
/* 13946 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 13954
/* 13950 */   MCD::OPC_Decode, 176, 17, 64, // Opcode: XVSADD_H, DecodeIdx: 64
/* 13954 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 13962
/* 13958 */   MCD::OPC_Decode, 178, 17, 64, // Opcode: XVSADD_W, DecodeIdx: 64
/* 13962 */   MCD::OPC_FilterValueOrFail, 7, 
/* 13964 */   MCD::OPC_Decode, 174, 17, 64, // Opcode: XVSADD_D, DecodeIdx: 64
/* 13968 */   MCD::OPC_FilterValue, 18, 65, 0, // Skip to: 14037
/* 13972 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 13975 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 13983
/* 13979 */   MCD::OPC_Decode, 252, 18, 64, // Opcode: XVSSUB_B, DecodeIdx: 64
/* 13983 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 13991
/* 13987 */   MCD::OPC_Decode, 128, 19, 64, // Opcode: XVSSUB_H, DecodeIdx: 64
/* 13991 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 13999
/* 13995 */   MCD::OPC_Decode, 130, 19, 64, // Opcode: XVSSUB_W, DecodeIdx: 64
/* 13999 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14007
/* 14003 */   MCD::OPC_Decode, 254, 18, 64, // Opcode: XVSSUB_D, DecodeIdx: 64
/* 14007 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14015
/* 14011 */   MCD::OPC_Decode, 173, 17, 64, // Opcode: XVSADD_BU, DecodeIdx: 64
/* 14015 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14023
/* 14019 */   MCD::OPC_Decode, 177, 17, 64, // Opcode: XVSADD_HU, DecodeIdx: 64
/* 14023 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14031
/* 14027 */   MCD::OPC_Decode, 179, 17, 64, // Opcode: XVSADD_WU, DecodeIdx: 64
/* 14031 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14033 */   MCD::OPC_Decode, 175, 17, 64, // Opcode: XVSADD_DU, DecodeIdx: 64
/* 14037 */   MCD::OPC_FilterValue, 19, 33, 0, // Skip to: 14074
/* 14041 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14044 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14052
/* 14048 */   MCD::OPC_Decode, 253, 18, 64, // Opcode: XVSSUB_BU, DecodeIdx: 64
/* 14052 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14060
/* 14056 */   MCD::OPC_Decode, 129, 19, 64, // Opcode: XVSSUB_HU, DecodeIdx: 64
/* 14060 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14068
/* 14064 */   MCD::OPC_Decode, 131, 19, 64, // Opcode: XVSSUB_WU, DecodeIdx: 64
/* 14068 */   MCD::OPC_FilterValueOrFail, 3, 
/* 14070 */   MCD::OPC_Decode, 255, 18, 64, // Opcode: XVSSUB_DU, DecodeIdx: 64
/* 14074 */   MCD::OPC_FilterValue, 21, 65, 0, // Skip to: 14143
/* 14078 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14081 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14089
/* 14085 */   MCD::OPC_Decode, 217, 15, 64, // Opcode: XVHADDW_H_B, DecodeIdx: 64
/* 14089 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14097
/* 14093 */   MCD::OPC_Decode, 221, 15, 64, // Opcode: XVHADDW_W_H, DecodeIdx: 64
/* 14097 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14105
/* 14101 */   MCD::OPC_Decode, 215, 15, 64, // Opcode: XVHADDW_D_W, DecodeIdx: 64
/* 14105 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14113
/* 14109 */   MCD::OPC_Decode, 219, 15, 64, // Opcode: XVHADDW_Q_D, DecodeIdx: 64
/* 14113 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14121
/* 14117 */   MCD::OPC_Decode, 226, 15, 64, // Opcode: XVHSUBW_H_B, DecodeIdx: 64
/* 14121 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14129
/* 14125 */   MCD::OPC_Decode, 230, 15, 64, // Opcode: XVHSUBW_W_H, DecodeIdx: 64
/* 14129 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14137
/* 14133 */   MCD::OPC_Decode, 224, 15, 64, // Opcode: XVHSUBW_D_W, DecodeIdx: 64
/* 14137 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14139 */   MCD::OPC_Decode, 228, 15, 64, // Opcode: XVHSUBW_Q_D, DecodeIdx: 64
/* 14143 */   MCD::OPC_FilterValue, 22, 65, 0, // Skip to: 14212
/* 14147 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14150 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14158
/* 14154 */   MCD::OPC_Decode, 216, 15, 64, // Opcode: XVHADDW_HU_BU, DecodeIdx: 64
/* 14158 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14166
/* 14162 */   MCD::OPC_Decode, 220, 15, 64, // Opcode: XVHADDW_WU_HU, DecodeIdx: 64
/* 14166 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14174
/* 14170 */   MCD::OPC_Decode, 214, 15, 64, // Opcode: XVHADDW_DU_WU, DecodeIdx: 64
/* 14174 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14182
/* 14178 */   MCD::OPC_Decode, 218, 15, 64, // Opcode: XVHADDW_QU_DU, DecodeIdx: 64
/* 14182 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14190
/* 14186 */   MCD::OPC_Decode, 225, 15, 64, // Opcode: XVHSUBW_HU_BU, DecodeIdx: 64
/* 14190 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14198
/* 14194 */   MCD::OPC_Decode, 229, 15, 64, // Opcode: XVHSUBW_WU_HU, DecodeIdx: 64
/* 14198 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14206
/* 14202 */   MCD::OPC_Decode, 223, 15, 64, // Opcode: XVHSUBW_DU_WU, DecodeIdx: 64
/* 14206 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14208 */   MCD::OPC_Decode, 227, 15, 64, // Opcode: XVHSUBW_QU_DU, DecodeIdx: 64
/* 14212 */   MCD::OPC_FilterValue, 23, 33, 0, // Skip to: 14249
/* 14216 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14219 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14227
/* 14223 */   MCD::OPC_Decode, 218, 13, 64, // Opcode: XVADDA_B, DecodeIdx: 64
/* 14227 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14235
/* 14231 */   MCD::OPC_Decode, 220, 13, 64, // Opcode: XVADDA_H, DecodeIdx: 64
/* 14235 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14243
/* 14239 */   MCD::OPC_Decode, 221, 13, 64, // Opcode: XVADDA_W, DecodeIdx: 64
/* 14243 */   MCD::OPC_FilterValueOrFail, 3, 
/* 14245 */   MCD::OPC_Decode, 219, 13, 64, // Opcode: XVADDA_D, DecodeIdx: 64
/* 14249 */   MCD::OPC_FilterValue, 24, 65, 0, // Skip to: 14318
/* 14253 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14256 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14264
/* 14260 */   MCD::OPC_Decode, 210, 13, 64, // Opcode: XVABSD_B, DecodeIdx: 64
/* 14264 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14272
/* 14268 */   MCD::OPC_Decode, 214, 13, 64, // Opcode: XVABSD_H, DecodeIdx: 64
/* 14272 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14280
/* 14276 */   MCD::OPC_Decode, 216, 13, 64, // Opcode: XVABSD_W, DecodeIdx: 64
/* 14280 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14288
/* 14284 */   MCD::OPC_Decode, 212, 13, 64, // Opcode: XVABSD_D, DecodeIdx: 64
/* 14288 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14296
/* 14292 */   MCD::OPC_Decode, 211, 13, 64, // Opcode: XVABSD_BU, DecodeIdx: 64
/* 14296 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14304
/* 14300 */   MCD::OPC_Decode, 215, 13, 64, // Opcode: XVABSD_HU, DecodeIdx: 64
/* 14304 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14312
/* 14308 */   MCD::OPC_Decode, 217, 13, 64, // Opcode: XVABSD_WU, DecodeIdx: 64
/* 14312 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14314 */   MCD::OPC_Decode, 213, 13, 64, // Opcode: XVABSD_DU, DecodeIdx: 64
/* 14318 */   MCD::OPC_FilterValue, 25, 65, 0, // Skip to: 14387
/* 14322 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14325 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14333
/* 14329 */   MCD::OPC_Decode, 138, 14, 64, // Opcode: XVAVG_B, DecodeIdx: 64
/* 14333 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14341
/* 14337 */   MCD::OPC_Decode, 142, 14, 64, // Opcode: XVAVG_H, DecodeIdx: 64
/* 14341 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14349
/* 14345 */   MCD::OPC_Decode, 144, 14, 64, // Opcode: XVAVG_W, DecodeIdx: 64
/* 14349 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14357
/* 14353 */   MCD::OPC_Decode, 140, 14, 64, // Opcode: XVAVG_D, DecodeIdx: 64
/* 14357 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14365
/* 14361 */   MCD::OPC_Decode, 139, 14, 64, // Opcode: XVAVG_BU, DecodeIdx: 64
/* 14365 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14373
/* 14369 */   MCD::OPC_Decode, 143, 14, 64, // Opcode: XVAVG_HU, DecodeIdx: 64
/* 14373 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14381
/* 14377 */   MCD::OPC_Decode, 145, 14, 64, // Opcode: XVAVG_WU, DecodeIdx: 64
/* 14381 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14383 */   MCD::OPC_Decode, 141, 14, 64, // Opcode: XVAVG_DU, DecodeIdx: 64
/* 14387 */   MCD::OPC_FilterValue, 26, 65, 0, // Skip to: 14456
/* 14391 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14394 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14402
/* 14398 */   MCD::OPC_Decode, 130, 14, 64, // Opcode: XVAVGR_B, DecodeIdx: 64
/* 14402 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14410
/* 14406 */   MCD::OPC_Decode, 134, 14, 64, // Opcode: XVAVGR_H, DecodeIdx: 64
/* 14410 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14418
/* 14414 */   MCD::OPC_Decode, 136, 14, 64, // Opcode: XVAVGR_W, DecodeIdx: 64
/* 14418 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14426
/* 14422 */   MCD::OPC_Decode, 132, 14, 64, // Opcode: XVAVGR_D, DecodeIdx: 64
/* 14426 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14434
/* 14430 */   MCD::OPC_Decode, 131, 14, 64, // Opcode: XVAVGR_BU, DecodeIdx: 64
/* 14434 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14442
/* 14438 */   MCD::OPC_Decode, 135, 14, 64, // Opcode: XVAVGR_HU, DecodeIdx: 64
/* 14442 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14450
/* 14446 */   MCD::OPC_Decode, 137, 14, 64, // Opcode: XVAVGR_WU, DecodeIdx: 64
/* 14450 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14452 */   MCD::OPC_Decode, 133, 14, 64, // Opcode: XVAVGR_DU, DecodeIdx: 64
/* 14456 */   MCD::OPC_FilterValue, 28, 65, 0, // Skip to: 14525
/* 14460 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14463 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14471
/* 14467 */   MCD::OPC_Decode, 158, 16, 64, // Opcode: XVMAX_B, DecodeIdx: 64
/* 14471 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14479
/* 14475 */   MCD::OPC_Decode, 162, 16, 64, // Opcode: XVMAX_H, DecodeIdx: 64
/* 14479 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14487
/* 14483 */   MCD::OPC_Decode, 164, 16, 64, // Opcode: XVMAX_W, DecodeIdx: 64
/* 14487 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14495
/* 14491 */   MCD::OPC_Decode, 160, 16, 64, // Opcode: XVMAX_D, DecodeIdx: 64
/* 14495 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14503
/* 14499 */   MCD::OPC_Decode, 174, 16, 64, // Opcode: XVMIN_B, DecodeIdx: 64
/* 14503 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14511
/* 14507 */   MCD::OPC_Decode, 178, 16, 64, // Opcode: XVMIN_H, DecodeIdx: 64
/* 14511 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14519
/* 14515 */   MCD::OPC_Decode, 180, 16, 64, // Opcode: XVMIN_W, DecodeIdx: 64
/* 14519 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14521 */   MCD::OPC_Decode, 176, 16, 64, // Opcode: XVMIN_D, DecodeIdx: 64
/* 14525 */   MCD::OPC_FilterValue, 29, 65, 0, // Skip to: 14594
/* 14529 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14532 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14540
/* 14536 */   MCD::OPC_Decode, 159, 16, 64, // Opcode: XVMAX_BU, DecodeIdx: 64
/* 14540 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14548
/* 14544 */   MCD::OPC_Decode, 163, 16, 64, // Opcode: XVMAX_HU, DecodeIdx: 64
/* 14548 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14556
/* 14552 */   MCD::OPC_Decode, 165, 16, 64, // Opcode: XVMAX_WU, DecodeIdx: 64
/* 14556 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14564
/* 14560 */   MCD::OPC_Decode, 161, 16, 64, // Opcode: XVMAX_DU, DecodeIdx: 64
/* 14564 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14572
/* 14568 */   MCD::OPC_Decode, 175, 16, 64, // Opcode: XVMIN_BU, DecodeIdx: 64
/* 14572 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14580
/* 14576 */   MCD::OPC_Decode, 179, 16, 64, // Opcode: XVMIN_HU, DecodeIdx: 64
/* 14580 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14588
/* 14584 */   MCD::OPC_Decode, 181, 16, 64, // Opcode: XVMIN_WU, DecodeIdx: 64
/* 14588 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14590 */   MCD::OPC_Decode, 177, 16, 64, // Opcode: XVMIN_DU, DecodeIdx: 64
/* 14594 */   MCD::OPC_FilterValue, 33, 65, 0, // Skip to: 14663
/* 14598 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14601 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14609
/* 14605 */   MCD::OPC_Decode, 232, 16, 64, // Opcode: XVMUL_B, DecodeIdx: 64
/* 14609 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14617
/* 14613 */   MCD::OPC_Decode, 234, 16, 64, // Opcode: XVMUL_H, DecodeIdx: 64
/* 14617 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14625
/* 14621 */   MCD::OPC_Decode, 235, 16, 64, // Opcode: XVMUL_W, DecodeIdx: 64
/* 14625 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14633
/* 14629 */   MCD::OPC_Decode, 233, 16, 64, // Opcode: XVMUL_D, DecodeIdx: 64
/* 14633 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14641
/* 14637 */   MCD::OPC_Decode, 200, 16, 64, // Opcode: XVMUH_B, DecodeIdx: 64
/* 14641 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14649
/* 14645 */   MCD::OPC_Decode, 204, 16, 64, // Opcode: XVMUH_H, DecodeIdx: 64
/* 14649 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14657
/* 14653 */   MCD::OPC_Decode, 206, 16, 64, // Opcode: XVMUH_W, DecodeIdx: 64
/* 14657 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14659 */   MCD::OPC_Decode, 202, 16, 64, // Opcode: XVMUH_D, DecodeIdx: 64
/* 14663 */   MCD::OPC_FilterValue, 34, 33, 0, // Skip to: 14700
/* 14667 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14670 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14678
/* 14674 */   MCD::OPC_Decode, 201, 16, 64, // Opcode: XVMUH_BU, DecodeIdx: 64
/* 14678 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14686
/* 14682 */   MCD::OPC_Decode, 205, 16, 64, // Opcode: XVMUH_HU, DecodeIdx: 64
/* 14686 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14694
/* 14690 */   MCD::OPC_Decode, 207, 16, 64, // Opcode: XVMUH_WU, DecodeIdx: 64
/* 14694 */   MCD::OPC_FilterValueOrFail, 3, 
/* 14696 */   MCD::OPC_Decode, 203, 16, 64, // Opcode: XVMUH_DU, DecodeIdx: 64
/* 14700 */   MCD::OPC_FilterValue, 36, 65, 0, // Skip to: 14769
/* 14704 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14707 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14715
/* 14711 */   MCD::OPC_Decode, 211, 16, 64, // Opcode: XVMULWEV_H_B, DecodeIdx: 64
/* 14715 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14723
/* 14719 */   MCD::OPC_Decode, 217, 16, 64, // Opcode: XVMULWEV_W_H, DecodeIdx: 64
/* 14723 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14731
/* 14727 */   MCD::OPC_Decode, 208, 16, 64, // Opcode: XVMULWEV_D_W, DecodeIdx: 64
/* 14731 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14739
/* 14735 */   MCD::OPC_Decode, 214, 16, 64, // Opcode: XVMULWEV_Q_D, DecodeIdx: 64
/* 14739 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14747
/* 14743 */   MCD::OPC_Decode, 223, 16, 64, // Opcode: XVMULWOD_H_B, DecodeIdx: 64
/* 14747 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14755
/* 14751 */   MCD::OPC_Decode, 229, 16, 64, // Opcode: XVMULWOD_W_H, DecodeIdx: 64
/* 14755 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14763
/* 14759 */   MCD::OPC_Decode, 220, 16, 64, // Opcode: XVMULWOD_D_W, DecodeIdx: 64
/* 14763 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14765 */   MCD::OPC_Decode, 226, 16, 64, // Opcode: XVMULWOD_Q_D, DecodeIdx: 64
/* 14769 */   MCD::OPC_FilterValue, 38, 65, 0, // Skip to: 14838
/* 14773 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14776 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14784
/* 14780 */   MCD::OPC_Decode, 212, 16, 64, // Opcode: XVMULWEV_H_BU, DecodeIdx: 64
/* 14784 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14792
/* 14788 */   MCD::OPC_Decode, 218, 16, 64, // Opcode: XVMULWEV_W_HU, DecodeIdx: 64
/* 14792 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14800
/* 14796 */   MCD::OPC_Decode, 209, 16, 64, // Opcode: XVMULWEV_D_WU, DecodeIdx: 64
/* 14800 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14808
/* 14804 */   MCD::OPC_Decode, 215, 16, 64, // Opcode: XVMULWEV_Q_DU, DecodeIdx: 64
/* 14808 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14816
/* 14812 */   MCD::OPC_Decode, 224, 16, 64, // Opcode: XVMULWOD_H_BU, DecodeIdx: 64
/* 14816 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14824
/* 14820 */   MCD::OPC_Decode, 230, 16, 64, // Opcode: XVMULWOD_W_HU, DecodeIdx: 64
/* 14824 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14832
/* 14828 */   MCD::OPC_Decode, 221, 16, 64, // Opcode: XVMULWOD_D_WU, DecodeIdx: 64
/* 14832 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14834 */   MCD::OPC_Decode, 227, 16, 64, // Opcode: XVMULWOD_Q_DU, DecodeIdx: 64
/* 14838 */   MCD::OPC_FilterValue, 40, 65, 0, // Skip to: 14907
/* 14842 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14845 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 14853
/* 14849 */   MCD::OPC_Decode, 213, 16, 64, // Opcode: XVMULWEV_H_BU_B, DecodeIdx: 64
/* 14853 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 14861
/* 14857 */   MCD::OPC_Decode, 219, 16, 64, // Opcode: XVMULWEV_W_HU_H, DecodeIdx: 64
/* 14861 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 14869
/* 14865 */   MCD::OPC_Decode, 210, 16, 64, // Opcode: XVMULWEV_D_WU_W, DecodeIdx: 64
/* 14869 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 14877
/* 14873 */   MCD::OPC_Decode, 216, 16, 64, // Opcode: XVMULWEV_Q_DU_D, DecodeIdx: 64
/* 14877 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 14885
/* 14881 */   MCD::OPC_Decode, 225, 16, 64, // Opcode: XVMULWOD_H_BU_B, DecodeIdx: 64
/* 14885 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 14893
/* 14889 */   MCD::OPC_Decode, 231, 16, 64, // Opcode: XVMULWOD_W_HU_H, DecodeIdx: 64
/* 14893 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 14901
/* 14897 */   MCD::OPC_Decode, 222, 16, 64, // Opcode: XVMULWOD_D_WU_W, DecodeIdx: 64
/* 14901 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14903 */   MCD::OPC_Decode, 228, 16, 64, // Opcode: XVMULWOD_Q_DU_D, DecodeIdx: 64
/* 14907 */   MCD::OPC_FilterValue, 42, 73, 0, // Skip to: 14984
/* 14911 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14914 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 14923
/* 14918 */   MCD::OPC_Decode, 146, 16, 130, 1, // Opcode: XVMADD_B, DecodeIdx: 130
/* 14923 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 14932
/* 14927 */   MCD::OPC_Decode, 148, 16, 130, 1, // Opcode: XVMADD_H, DecodeIdx: 130
/* 14932 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 14941
/* 14936 */   MCD::OPC_Decode, 149, 16, 130, 1, // Opcode: XVMADD_W, DecodeIdx: 130
/* 14941 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 14950
/* 14945 */   MCD::OPC_Decode, 147, 16, 130, 1, // Opcode: XVMADD_D, DecodeIdx: 130
/* 14950 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 14959
/* 14954 */   MCD::OPC_Decode, 196, 16, 130, 1, // Opcode: XVMSUB_B, DecodeIdx: 130
/* 14959 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 14968
/* 14963 */   MCD::OPC_Decode, 198, 16, 130, 1, // Opcode: XVMSUB_H, DecodeIdx: 130
/* 14968 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 14977
/* 14972 */   MCD::OPC_Decode, 199, 16, 130, 1, // Opcode: XVMSUB_W, DecodeIdx: 130
/* 14977 */   MCD::OPC_FilterValueOrFail, 7, 
/* 14979 */   MCD::OPC_Decode, 197, 16, 130, 1, // Opcode: XVMSUB_D, DecodeIdx: 130
/* 14984 */   MCD::OPC_FilterValue, 43, 73, 0, // Skip to: 15061
/* 14988 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 14991 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 15000
/* 14995 */   MCD::OPC_Decode, 253, 15, 130, 1, // Opcode: XVMADDWEV_H_B, DecodeIdx: 130
/* 15000 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 15009
/* 15004 */   MCD::OPC_Decode, 131, 16, 130, 1, // Opcode: XVMADDWEV_W_H, DecodeIdx: 130
/* 15009 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 15018
/* 15013 */   MCD::OPC_Decode, 250, 15, 130, 1, // Opcode: XVMADDWEV_D_W, DecodeIdx: 130
/* 15018 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 15027
/* 15022 */   MCD::OPC_Decode, 128, 16, 130, 1, // Opcode: XVMADDWEV_Q_D, DecodeIdx: 130
/* 15027 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 15036
/* 15031 */   MCD::OPC_Decode, 137, 16, 130, 1, // Opcode: XVMADDWOD_H_B, DecodeIdx: 130
/* 15036 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 15045
/* 15040 */   MCD::OPC_Decode, 143, 16, 130, 1, // Opcode: XVMADDWOD_W_H, DecodeIdx: 130
/* 15045 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 15054
/* 15049 */   MCD::OPC_Decode, 134, 16, 130, 1, // Opcode: XVMADDWOD_D_W, DecodeIdx: 130
/* 15054 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15056 */   MCD::OPC_Decode, 140, 16, 130, 1, // Opcode: XVMADDWOD_Q_D, DecodeIdx: 130
/* 15061 */   MCD::OPC_FilterValue, 45, 73, 0, // Skip to: 15138
/* 15065 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15068 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 15077
/* 15072 */   MCD::OPC_Decode, 254, 15, 130, 1, // Opcode: XVMADDWEV_H_BU, DecodeIdx: 130
/* 15077 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 15086
/* 15081 */   MCD::OPC_Decode, 132, 16, 130, 1, // Opcode: XVMADDWEV_W_HU, DecodeIdx: 130
/* 15086 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 15095
/* 15090 */   MCD::OPC_Decode, 251, 15, 130, 1, // Opcode: XVMADDWEV_D_WU, DecodeIdx: 130
/* 15095 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 15104
/* 15099 */   MCD::OPC_Decode, 129, 16, 130, 1, // Opcode: XVMADDWEV_Q_DU, DecodeIdx: 130
/* 15104 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 15113
/* 15108 */   MCD::OPC_Decode, 138, 16, 130, 1, // Opcode: XVMADDWOD_H_BU, DecodeIdx: 130
/* 15113 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 15122
/* 15117 */   MCD::OPC_Decode, 144, 16, 130, 1, // Opcode: XVMADDWOD_W_HU, DecodeIdx: 130
/* 15122 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 15131
/* 15126 */   MCD::OPC_Decode, 135, 16, 130, 1, // Opcode: XVMADDWOD_D_WU, DecodeIdx: 130
/* 15131 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15133 */   MCD::OPC_Decode, 141, 16, 130, 1, // Opcode: XVMADDWOD_Q_DU, DecodeIdx: 130
/* 15138 */   MCD::OPC_FilterValue, 47, 73, 0, // Skip to: 15215
/* 15142 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15145 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 15154
/* 15149 */   MCD::OPC_Decode, 255, 15, 130, 1, // Opcode: XVMADDWEV_H_BU_B, DecodeIdx: 130
/* 15154 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 15163
/* 15158 */   MCD::OPC_Decode, 133, 16, 130, 1, // Opcode: XVMADDWEV_W_HU_H, DecodeIdx: 130
/* 15163 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 15172
/* 15167 */   MCD::OPC_Decode, 252, 15, 130, 1, // Opcode: XVMADDWEV_D_WU_W, DecodeIdx: 130
/* 15172 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 15181
/* 15176 */   MCD::OPC_Decode, 130, 16, 130, 1, // Opcode: XVMADDWEV_Q_DU_D, DecodeIdx: 130
/* 15181 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 15190
/* 15185 */   MCD::OPC_Decode, 139, 16, 130, 1, // Opcode: XVMADDWOD_H_BU_B, DecodeIdx: 130
/* 15190 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 15199
/* 15194 */   MCD::OPC_Decode, 145, 16, 130, 1, // Opcode: XVMADDWOD_W_HU_H, DecodeIdx: 130
/* 15199 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 15208
/* 15203 */   MCD::OPC_Decode, 136, 16, 130, 1, // Opcode: XVMADDWOD_D_WU_W, DecodeIdx: 130
/* 15208 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15210 */   MCD::OPC_Decode, 142, 16, 130, 1, // Opcode: XVMADDWOD_Q_DU_D, DecodeIdx: 130
/* 15215 */   MCD::OPC_FilterValue, 56, 65, 0, // Skip to: 15284
/* 15219 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15222 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 15230
/* 15226 */   MCD::OPC_Decode, 182, 14, 64, // Opcode: XVDIV_B, DecodeIdx: 64
/* 15230 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15238
/* 15234 */   MCD::OPC_Decode, 186, 14, 64, // Opcode: XVDIV_H, DecodeIdx: 64
/* 15238 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15246
/* 15242 */   MCD::OPC_Decode, 188, 14, 64, // Opcode: XVDIV_W, DecodeIdx: 64
/* 15246 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15254
/* 15250 */   MCD::OPC_Decode, 184, 14, 64, // Opcode: XVDIV_D, DecodeIdx: 64
/* 15254 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 15262
/* 15258 */   MCD::OPC_Decode, 182, 16, 64, // Opcode: XVMOD_B, DecodeIdx: 64
/* 15262 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15270
/* 15266 */   MCD::OPC_Decode, 186, 16, 64, // Opcode: XVMOD_H, DecodeIdx: 64
/* 15270 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15278
/* 15274 */   MCD::OPC_Decode, 188, 16, 64, // Opcode: XVMOD_W, DecodeIdx: 64
/* 15278 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15280 */   MCD::OPC_Decode, 184, 16, 64, // Opcode: XVMOD_D, DecodeIdx: 64
/* 15284 */   MCD::OPC_FilterValue, 57, 65, 0, // Skip to: 15353
/* 15288 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15291 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 15299
/* 15295 */   MCD::OPC_Decode, 183, 14, 64, // Opcode: XVDIV_BU, DecodeIdx: 64
/* 15299 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15307
/* 15303 */   MCD::OPC_Decode, 187, 14, 64, // Opcode: XVDIV_HU, DecodeIdx: 64
/* 15307 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15315
/* 15311 */   MCD::OPC_Decode, 189, 14, 64, // Opcode: XVDIV_WU, DecodeIdx: 64
/* 15315 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15323
/* 15319 */   MCD::OPC_Decode, 185, 14, 64, // Opcode: XVDIV_DU, DecodeIdx: 64
/* 15323 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 15331
/* 15327 */   MCD::OPC_Decode, 183, 16, 64, // Opcode: XVMOD_BU, DecodeIdx: 64
/* 15331 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15339
/* 15335 */   MCD::OPC_Decode, 187, 16, 64, // Opcode: XVMOD_HU, DecodeIdx: 64
/* 15339 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15347
/* 15343 */   MCD::OPC_Decode, 189, 16, 64, // Opcode: XVMOD_WU, DecodeIdx: 64
/* 15347 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15349 */   MCD::OPC_Decode, 185, 16, 64, // Opcode: XVMOD_DU, DecodeIdx: 64
/* 15353 */   MCD::OPC_FilterValue, 58, 65, 0, // Skip to: 15422
/* 15357 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15360 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 15368
/* 15364 */   MCD::OPC_Decode, 244, 17, 64, // Opcode: XVSLL_B, DecodeIdx: 64
/* 15368 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15376
/* 15372 */   MCD::OPC_Decode, 246, 17, 64, // Opcode: XVSLL_H, DecodeIdx: 64
/* 15376 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15384
/* 15380 */   MCD::OPC_Decode, 247, 17, 64, // Opcode: XVSLL_W, DecodeIdx: 64
/* 15384 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15392
/* 15388 */   MCD::OPC_Decode, 245, 17, 64, // Opcode: XVSLL_D, DecodeIdx: 64
/* 15392 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 15400
/* 15396 */   MCD::OPC_Decode, 192, 18, 64, // Opcode: XVSRL_B, DecodeIdx: 64
/* 15400 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15408
/* 15404 */   MCD::OPC_Decode, 194, 18, 64, // Opcode: XVSRL_H, DecodeIdx: 64
/* 15408 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15416
/* 15412 */   MCD::OPC_Decode, 195, 18, 64, // Opcode: XVSRL_W, DecodeIdx: 64
/* 15416 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15418 */   MCD::OPC_Decode, 193, 18, 64, // Opcode: XVSRL_D, DecodeIdx: 64
/* 15422 */   MCD::OPC_FilterValue, 59, 65, 0, // Skip to: 15491
/* 15426 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15429 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 15437
/* 15433 */   MCD::OPC_Decode, 162, 18, 64, // Opcode: XVSRA_B, DecodeIdx: 64
/* 15437 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15445
/* 15441 */   MCD::OPC_Decode, 164, 18, 64, // Opcode: XVSRA_H, DecodeIdx: 64
/* 15445 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15453
/* 15449 */   MCD::OPC_Decode, 165, 18, 64, // Opcode: XVSRA_W, DecodeIdx: 64
/* 15453 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15461
/* 15457 */   MCD::OPC_Decode, 163, 18, 64, // Opcode: XVSRA_D, DecodeIdx: 64
/* 15461 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 15469
/* 15465 */   MCD::OPC_Decode, 168, 17, 64, // Opcode: XVROTR_B, DecodeIdx: 64
/* 15469 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15477
/* 15473 */   MCD::OPC_Decode, 170, 17, 64, // Opcode: XVROTR_H, DecodeIdx: 64
/* 15477 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15485
/* 15481 */   MCD::OPC_Decode, 171, 17, 64, // Opcode: XVROTR_W, DecodeIdx: 64
/* 15485 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15487 */   MCD::OPC_Decode, 169, 17, 64, // Opcode: XVROTR_D, DecodeIdx: 64
/* 15491 */   MCD::OPC_FilterValue, 60, 65, 0, // Skip to: 15560
/* 15495 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15498 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 15506
/* 15502 */   MCD::OPC_Decode, 188, 18, 64, // Opcode: XVSRLR_B, DecodeIdx: 64
/* 15506 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15514
/* 15510 */   MCD::OPC_Decode, 190, 18, 64, // Opcode: XVSRLR_H, DecodeIdx: 64
/* 15514 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15522
/* 15518 */   MCD::OPC_Decode, 191, 18, 64, // Opcode: XVSRLR_W, DecodeIdx: 64
/* 15522 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15530
/* 15526 */   MCD::OPC_Decode, 189, 18, 64, // Opcode: XVSRLR_D, DecodeIdx: 64
/* 15530 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 15538
/* 15534 */   MCD::OPC_Decode, 158, 18, 64, // Opcode: XVSRAR_B, DecodeIdx: 64
/* 15538 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15546
/* 15542 */   MCD::OPC_Decode, 160, 18, 64, // Opcode: XVSRAR_H, DecodeIdx: 64
/* 15546 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15554
/* 15550 */   MCD::OPC_Decode, 161, 18, 64, // Opcode: XVSRAR_W, DecodeIdx: 64
/* 15554 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15556 */   MCD::OPC_Decode, 159, 18, 64, // Opcode: XVSRAR_D, DecodeIdx: 64
/* 15560 */   MCD::OPC_FilterValue, 61, 49, 0, // Skip to: 15613
/* 15564 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15567 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15575
/* 15571 */   MCD::OPC_Decode, 174, 18, 64, // Opcode: XVSRLN_B_H, DecodeIdx: 64
/* 15575 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15583
/* 15579 */   MCD::OPC_Decode, 175, 18, 64, // Opcode: XVSRLN_H_W, DecodeIdx: 64
/* 15583 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15591
/* 15587 */   MCD::OPC_Decode, 176, 18, 64, // Opcode: XVSRLN_W_D, DecodeIdx: 64
/* 15591 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15599
/* 15595 */   MCD::OPC_Decode, 144, 18, 64, // Opcode: XVSRAN_B_H, DecodeIdx: 64
/* 15599 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15607
/* 15603 */   MCD::OPC_Decode, 145, 18, 64, // Opcode: XVSRAN_H_W, DecodeIdx: 64
/* 15607 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15609 */   MCD::OPC_Decode, 146, 18, 64, // Opcode: XVSRAN_W_D, DecodeIdx: 64
/* 15613 */   MCD::OPC_FilterValue, 62, 49, 0, // Skip to: 15666
/* 15617 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15620 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15628
/* 15624 */   MCD::OPC_Decode, 185, 18, 64, // Opcode: XVSRLRN_B_H, DecodeIdx: 64
/* 15628 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15636
/* 15632 */   MCD::OPC_Decode, 186, 18, 64, // Opcode: XVSRLRN_H_W, DecodeIdx: 64
/* 15636 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15644
/* 15640 */   MCD::OPC_Decode, 187, 18, 64, // Opcode: XVSRLRN_W_D, DecodeIdx: 64
/* 15644 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15652
/* 15648 */   MCD::OPC_Decode, 155, 18, 64, // Opcode: XVSRARN_B_H, DecodeIdx: 64
/* 15652 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15660
/* 15656 */   MCD::OPC_Decode, 156, 18, 64, // Opcode: XVSRARN_H_W, DecodeIdx: 64
/* 15660 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15662 */   MCD::OPC_Decode, 157, 18, 64, // Opcode: XVSRARN_W_D, DecodeIdx: 64
/* 15666 */   MCD::OPC_FilterValue, 63, 49, 0, // Skip to: 15719
/* 15670 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15673 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15681
/* 15677 */   MCD::OPC_Decode, 233, 18, 64, // Opcode: XVSSRLN_B_H, DecodeIdx: 64
/* 15681 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15689
/* 15685 */   MCD::OPC_Decode, 235, 18, 64, // Opcode: XVSSRLN_H_W, DecodeIdx: 64
/* 15689 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15697
/* 15693 */   MCD::OPC_Decode, 237, 18, 64, // Opcode: XVSSRLN_W_D, DecodeIdx: 64
/* 15697 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15705
/* 15701 */   MCD::OPC_Decode, 205, 18, 64, // Opcode: XVSSRAN_B_H, DecodeIdx: 64
/* 15705 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15713
/* 15709 */   MCD::OPC_Decode, 207, 18, 64, // Opcode: XVSSRAN_H_W, DecodeIdx: 64
/* 15713 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15715 */   MCD::OPC_Decode, 209, 18, 64, // Opcode: XVSSRAN_W_D, DecodeIdx: 64
/* 15719 */   MCD::OPC_FilterValue, 64, 49, 0, // Skip to: 15772
/* 15723 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15726 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15734
/* 15730 */   MCD::OPC_Decode, 247, 18, 64, // Opcode: XVSSRLRN_B_H, DecodeIdx: 64
/* 15734 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15742
/* 15738 */   MCD::OPC_Decode, 249, 18, 64, // Opcode: XVSSRLRN_H_W, DecodeIdx: 64
/* 15742 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15750
/* 15746 */   MCD::OPC_Decode, 251, 18, 64, // Opcode: XVSSRLRN_W_D, DecodeIdx: 64
/* 15750 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15758
/* 15754 */   MCD::OPC_Decode, 219, 18, 64, // Opcode: XVSSRARN_B_H, DecodeIdx: 64
/* 15758 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15766
/* 15762 */   MCD::OPC_Decode, 221, 18, 64, // Opcode: XVSSRARN_H_W, DecodeIdx: 64
/* 15766 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15768 */   MCD::OPC_Decode, 223, 18, 64, // Opcode: XVSSRARN_W_D, DecodeIdx: 64
/* 15772 */   MCD::OPC_FilterValue, 65, 49, 0, // Skip to: 15825
/* 15776 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15779 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15787
/* 15783 */   MCD::OPC_Decode, 232, 18, 64, // Opcode: XVSSRLN_BU_H, DecodeIdx: 64
/* 15787 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15795
/* 15791 */   MCD::OPC_Decode, 234, 18, 64, // Opcode: XVSSRLN_HU_W, DecodeIdx: 64
/* 15795 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15803
/* 15799 */   MCD::OPC_Decode, 236, 18, 64, // Opcode: XVSSRLN_WU_D, DecodeIdx: 64
/* 15803 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15811
/* 15807 */   MCD::OPC_Decode, 204, 18, 64, // Opcode: XVSSRAN_BU_H, DecodeIdx: 64
/* 15811 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15819
/* 15815 */   MCD::OPC_Decode, 206, 18, 64, // Opcode: XVSSRAN_HU_W, DecodeIdx: 64
/* 15819 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15821 */   MCD::OPC_Decode, 208, 18, 64, // Opcode: XVSSRAN_WU_D, DecodeIdx: 64
/* 15825 */   MCD::OPC_FilterValue, 66, 49, 0, // Skip to: 15878
/* 15829 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15832 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15840
/* 15836 */   MCD::OPC_Decode, 246, 18, 64, // Opcode: XVSSRLRN_BU_H, DecodeIdx: 64
/* 15840 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15848
/* 15844 */   MCD::OPC_Decode, 248, 18, 64, // Opcode: XVSSRLRN_HU_W, DecodeIdx: 64
/* 15848 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15856
/* 15852 */   MCD::OPC_Decode, 250, 18, 64, // Opcode: XVSSRLRN_WU_D, DecodeIdx: 64
/* 15856 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15864
/* 15860 */   MCD::OPC_Decode, 218, 18, 64, // Opcode: XVSSRARN_BU_H, DecodeIdx: 64
/* 15864 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15872
/* 15868 */   MCD::OPC_Decode, 220, 18, 64, // Opcode: XVSSRARN_HU_W, DecodeIdx: 64
/* 15872 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15874 */   MCD::OPC_Decode, 222, 18, 64, // Opcode: XVSSRARN_WU_D, DecodeIdx: 64
/* 15878 */   MCD::OPC_FilterValue, 67, 65, 0, // Skip to: 15947
/* 15882 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15885 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 15893
/* 15889 */   MCD::OPC_Decode, 150, 14, 64, // Opcode: XVBITCLR_B, DecodeIdx: 64
/* 15893 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15901
/* 15897 */   MCD::OPC_Decode, 152, 14, 64, // Opcode: XVBITCLR_H, DecodeIdx: 64
/* 15901 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15909
/* 15905 */   MCD::OPC_Decode, 153, 14, 64, // Opcode: XVBITCLR_W, DecodeIdx: 64
/* 15909 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 15917
/* 15913 */   MCD::OPC_Decode, 151, 14, 64, // Opcode: XVBITCLR_D, DecodeIdx: 64
/* 15917 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 15925
/* 15921 */   MCD::OPC_Decode, 168, 14, 64, // Opcode: XVBITSET_B, DecodeIdx: 64
/* 15925 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 15933
/* 15929 */   MCD::OPC_Decode, 170, 14, 64, // Opcode: XVBITSET_H, DecodeIdx: 64
/* 15933 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 15941
/* 15937 */   MCD::OPC_Decode, 171, 14, 64, // Opcode: XVBITSET_W, DecodeIdx: 64
/* 15941 */   MCD::OPC_FilterValueOrFail, 7, 
/* 15943 */   MCD::OPC_Decode, 169, 14, 64, // Opcode: XVBITSET_D, DecodeIdx: 64
/* 15947 */   MCD::OPC_FilterValue, 68, 33, 0, // Skip to: 15984
/* 15951 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15954 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 15962
/* 15958 */   MCD::OPC_Decode, 158, 14, 64, // Opcode: XVBITREV_B, DecodeIdx: 64
/* 15962 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 15970
/* 15966 */   MCD::OPC_Decode, 160, 14, 64, // Opcode: XVBITREV_H, DecodeIdx: 64
/* 15970 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 15978
/* 15974 */   MCD::OPC_Decode, 161, 14, 64, // Opcode: XVBITREV_W, DecodeIdx: 64
/* 15978 */   MCD::OPC_FilterValueOrFail, 3, 
/* 15980 */   MCD::OPC_Decode, 159, 14, 64, // Opcode: XVBITREV_D, DecodeIdx: 64
/* 15984 */   MCD::OPC_FilterValue, 69, 33, 0, // Skip to: 16021
/* 15988 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 15991 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 15999
/* 15995 */   MCD::OPC_Decode, 245, 16, 64, // Opcode: XVPACKEV_B, DecodeIdx: 64
/* 15999 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 16007
/* 16003 */   MCD::OPC_Decode, 247, 16, 64, // Opcode: XVPACKEV_H, DecodeIdx: 64
/* 16007 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 16015
/* 16011 */   MCD::OPC_Decode, 248, 16, 64, // Opcode: XVPACKEV_W, DecodeIdx: 64
/* 16015 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16017 */   MCD::OPC_Decode, 246, 16, 64, // Opcode: XVPACKEV_D, DecodeIdx: 64
/* 16021 */   MCD::OPC_FilterValue, 70, 65, 0, // Skip to: 16090
/* 16025 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16028 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 16036
/* 16032 */   MCD::OPC_Decode, 249, 16, 64, // Opcode: XVPACKOD_B, DecodeIdx: 64
/* 16036 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 16044
/* 16040 */   MCD::OPC_Decode, 251, 16, 64, // Opcode: XVPACKOD_H, DecodeIdx: 64
/* 16044 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 16052
/* 16048 */   MCD::OPC_Decode, 252, 16, 64, // Opcode: XVPACKOD_W, DecodeIdx: 64
/* 16052 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 16060
/* 16056 */   MCD::OPC_Decode, 250, 16, 64, // Opcode: XVPACKOD_D, DecodeIdx: 64
/* 16060 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 16068
/* 16064 */   MCD::OPC_Decode, 235, 15, 64, // Opcode: XVILVL_B, DecodeIdx: 64
/* 16068 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 16076
/* 16072 */   MCD::OPC_Decode, 237, 15, 64, // Opcode: XVILVL_H, DecodeIdx: 64
/* 16076 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 16084
/* 16080 */   MCD::OPC_Decode, 238, 15, 64, // Opcode: XVILVL_W, DecodeIdx: 64
/* 16084 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16086 */   MCD::OPC_Decode, 236, 15, 64, // Opcode: XVILVL_D, DecodeIdx: 64
/* 16090 */   MCD::OPC_FilterValue, 71, 65, 0, // Skip to: 16159
/* 16094 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16097 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 16105
/* 16101 */   MCD::OPC_Decode, 231, 15, 64, // Opcode: XVILVH_B, DecodeIdx: 64
/* 16105 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 16113
/* 16109 */   MCD::OPC_Decode, 233, 15, 64, // Opcode: XVILVH_H, DecodeIdx: 64
/* 16113 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 16121
/* 16117 */   MCD::OPC_Decode, 234, 15, 64, // Opcode: XVILVH_W, DecodeIdx: 64
/* 16121 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 16129
/* 16125 */   MCD::OPC_Decode, 232, 15, 64, // Opcode: XVILVH_D, DecodeIdx: 64
/* 16129 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 16137
/* 16133 */   MCD::OPC_Decode, 133, 17, 64, // Opcode: XVPICKEV_B, DecodeIdx: 64
/* 16137 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 16145
/* 16141 */   MCD::OPC_Decode, 135, 17, 64, // Opcode: XVPICKEV_H, DecodeIdx: 64
/* 16145 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 16153
/* 16149 */   MCD::OPC_Decode, 136, 17, 64, // Opcode: XVPICKEV_W, DecodeIdx: 64
/* 16153 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16155 */   MCD::OPC_Decode, 134, 17, 64, // Opcode: XVPICKEV_D, DecodeIdx: 64
/* 16159 */   MCD::OPC_FilterValue, 72, 69, 0, // Skip to: 16232
/* 16163 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16166 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 16174
/* 16170 */   MCD::OPC_Decode, 137, 17, 64, // Opcode: XVPICKOD_B, DecodeIdx: 64
/* 16174 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 16182
/* 16178 */   MCD::OPC_Decode, 139, 17, 64, // Opcode: XVPICKOD_H, DecodeIdx: 64
/* 16182 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 16190
/* 16186 */   MCD::OPC_Decode, 140, 17, 64, // Opcode: XVPICKOD_W, DecodeIdx: 64
/* 16190 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 16198
/* 16194 */   MCD::OPC_Decode, 138, 17, 64, // Opcode: XVPICKOD_D, DecodeIdx: 64
/* 16198 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 16207
/* 16202 */   MCD::OPC_Decode, 160, 17, 131, 1, // Opcode: XVREPLVE_B, DecodeIdx: 131
/* 16207 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 16216
/* 16211 */   MCD::OPC_Decode, 162, 17, 131, 1, // Opcode: XVREPLVE_H, DecodeIdx: 131
/* 16216 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 16225
/* 16220 */   MCD::OPC_Decode, 163, 17, 131, 1, // Opcode: XVREPLVE_W, DecodeIdx: 131
/* 16225 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16227 */   MCD::OPC_Decode, 161, 17, 131, 1, // Opcode: XVREPLVE_D, DecodeIdx: 131
/* 16232 */   MCD::OPC_FilterValue, 73, 33, 0, // Skip to: 16269
/* 16236 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16239 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 16247
/* 16243 */   MCD::OPC_Decode, 129, 14, 64, // Opcode: XVAND_V, DecodeIdx: 64
/* 16247 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 16255
/* 16251 */   MCD::OPC_Decode, 244, 16, 64, // Opcode: XVOR_V, DecodeIdx: 64
/* 16255 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 16263
/* 16259 */   MCD::OPC_Decode, 164, 19, 64, // Opcode: XVXOR_V, DecodeIdx: 64
/* 16263 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16265 */   MCD::OPC_Decode, 241, 16, 64, // Opcode: XVNOR_V, DecodeIdx: 64
/* 16269 */   MCD::OPC_FilterValue, 74, 35, 0, // Skip to: 16308
/* 16273 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16276 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 16284
/* 16280 */   MCD::OPC_Decode, 128, 14, 64, // Opcode: XVANDN_V, DecodeIdx: 64
/* 16284 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 16292
/* 16288 */   MCD::OPC_Decode, 243, 16, 64, // Opcode: XVORN_V, DecodeIdx: 64
/* 16292 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 16301
/* 16296 */   MCD::OPC_Decode, 179, 15, 130, 1, // Opcode: XVFRSTP_B, DecodeIdx: 130
/* 16301 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16303 */   MCD::OPC_Decode, 180, 15, 130, 1, // Opcode: XVFRSTP_H, DecodeIdx: 130
/* 16308 */   MCD::OPC_FilterValue, 75, 49, 0, // Skip to: 16361
/* 16312 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16315 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 16323
/* 16319 */   MCD::OPC_Decode, 253, 13, 64, // Opcode: XVADD_Q, DecodeIdx: 64
/* 16323 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 16331
/* 16327 */   MCD::OPC_Decode, 161, 19, 64, // Opcode: XVSUB_Q, DecodeIdx: 64
/* 16331 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 16339
/* 16335 */   MCD::OPC_Decode, 214, 17, 64, // Opcode: XVSIGNCOV_B, DecodeIdx: 64
/* 16339 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 16347
/* 16343 */   MCD::OPC_Decode, 216, 17, 64, // Opcode: XVSIGNCOV_H, DecodeIdx: 64
/* 16347 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 16355
/* 16351 */   MCD::OPC_Decode, 217, 17, 64, // Opcode: XVSIGNCOV_W, DecodeIdx: 64
/* 16355 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16357 */   MCD::OPC_Decode, 215, 17, 64, // Opcode: XVSIGNCOV_D, DecodeIdx: 64
/* 16361 */   MCD::OPC_FilterValue, 76, 33, 0, // Skip to: 16398
/* 16365 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16368 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 16376
/* 16372 */   MCD::OPC_Decode, 205, 14, 64, // Opcode: XVFADD_S, DecodeIdx: 64
/* 16376 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 16384
/* 16380 */   MCD::OPC_Decode, 204, 14, 64, // Opcode: XVFADD_D, DecodeIdx: 64
/* 16384 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 16392
/* 16388 */   MCD::OPC_Decode, 184, 15, 64, // Opcode: XVFSUB_S, DecodeIdx: 64
/* 16392 */   MCD::OPC_FilterValueOrFail, 6, 
/* 16394 */   MCD::OPC_Decode, 183, 15, 64, // Opcode: XVFSUB_D, DecodeIdx: 64
/* 16398 */   MCD::OPC_FilterValue, 78, 33, 0, // Skip to: 16435
/* 16402 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16405 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 16413
/* 16409 */   MCD::OPC_Decode, 154, 15, 64, // Opcode: XVFMUL_S, DecodeIdx: 64
/* 16413 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 16421
/* 16417 */   MCD::OPC_Decode, 153, 15, 64, // Opcode: XVFMUL_D, DecodeIdx: 64
/* 16421 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 16429
/* 16425 */   MCD::OPC_Decode, 131, 15, 64, // Opcode: XVFDIV_S, DecodeIdx: 64
/* 16429 */   MCD::OPC_FilterValueOrFail, 6, 
/* 16431 */   MCD::OPC_Decode, 130, 15, 64, // Opcode: XVFDIV_D, DecodeIdx: 64
/* 16435 */   MCD::OPC_FilterValue, 79, 33, 0, // Skip to: 16472
/* 16439 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16442 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 16450
/* 16446 */   MCD::OPC_Decode, 146, 15, 64, // Opcode: XVFMAX_S, DecodeIdx: 64
/* 16450 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 16458
/* 16454 */   MCD::OPC_Decode, 145, 15, 64, // Opcode: XVFMAX_D, DecodeIdx: 64
/* 16458 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 16466
/* 16462 */   MCD::OPC_Decode, 150, 15, 64, // Opcode: XVFMIN_S, DecodeIdx: 64
/* 16466 */   MCD::OPC_FilterValueOrFail, 6, 
/* 16468 */   MCD::OPC_Decode, 149, 15, 64, // Opcode: XVFMIN_D, DecodeIdx: 64
/* 16472 */   MCD::OPC_FilterValue, 80, 33, 0, // Skip to: 16509
/* 16476 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16479 */   MCD::OPC_FilterValue, 1, 4, 0, // Skip to: 16487
/* 16483 */   MCD::OPC_Decode, 144, 15, 64, // Opcode: XVFMAXA_S, DecodeIdx: 64
/* 16487 */   MCD::OPC_FilterValue, 2, 4, 0, // Skip to: 16495
/* 16491 */   MCD::OPC_Decode, 143, 15, 64, // Opcode: XVFMAXA_D, DecodeIdx: 64
/* 16495 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 16503
/* 16499 */   MCD::OPC_Decode, 148, 15, 64, // Opcode: XVFMINA_S, DecodeIdx: 64
/* 16503 */   MCD::OPC_FilterValueOrFail, 6, 
/* 16505 */   MCD::OPC_Decode, 147, 15, 64, // Opcode: XVFMINA_D, DecodeIdx: 64
/* 16509 */   MCD::OPC_FilterValue, 81, 17, 0, // Skip to: 16530
/* 16513 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16516 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 16524
/* 16520 */   MCD::OPC_Decode, 128, 15, 64, // Opcode: XVFCVT_H_S, DecodeIdx: 64
/* 16524 */   MCD::OPC_FilterValueOrFail, 5, 
/* 16526 */   MCD::OPC_Decode, 129, 15, 64, // Opcode: XVFCVT_S_D, DecodeIdx: 64
/* 16530 */   MCD::OPC_FilterValue, 82, 49, 0, // Skip to: 16583
/* 16534 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16537 */   MCD::OPC_FilterValue, 0, 4, 0, // Skip to: 16545
/* 16541 */   MCD::OPC_Decode, 136, 15, 64, // Opcode: XVFFINT_S_L, DecodeIdx: 64
/* 16545 */   MCD::OPC_FilterValue, 3, 4, 0, // Skip to: 16553
/* 16549 */   MCD::OPC_Decode, 212, 15, 64, // Opcode: XVFTINT_W_D, DecodeIdx: 64
/* 16553 */   MCD::OPC_FilterValue, 4, 4, 0, // Skip to: 16561
/* 16557 */   MCD::OPC_Decode, 190, 15, 64, // Opcode: XVFTINTRM_W_D, DecodeIdx: 64
/* 16561 */   MCD::OPC_FilterValue, 5, 4, 0, // Skip to: 16569
/* 16565 */   MCD::OPC_Decode, 200, 15, 64, // Opcode: XVFTINTRP_W_D, DecodeIdx: 64
/* 16569 */   MCD::OPC_FilterValue, 6, 4, 0, // Skip to: 16577
/* 16573 */   MCD::OPC_Decode, 207, 15, 64, // Opcode: XVFTINTRZ_W_D, DecodeIdx: 64
/* 16577 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16579 */   MCD::OPC_Decode, 195, 15, 64, // Opcode: XVFTINTRNE_W_D, DecodeIdx: 64
/* 16583 */   MCD::OPC_FilterValue, 94, 28, 0, // Skip to: 16615
/* 16587 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16590 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 16599
/* 16594 */   MCD::OPC_Decode, 212, 17, 130, 1, // Opcode: XVSHUF_H, DecodeIdx: 130
/* 16599 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 16608
/* 16603 */   MCD::OPC_Decode, 213, 17, 130, 1, // Opcode: XVSHUF_W, DecodeIdx: 130
/* 16608 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16610 */   MCD::OPC_Decode, 211, 17, 130, 1, // Opcode: XVSHUF_D, DecodeIdx: 130
/* 16615 */   MCD::OPC_FilterValue, 95, 8, 0, // Skip to: 16627
/* 16619 */   MCD::OPC_CheckFieldOrFail, 15, 3, 2, 
/* 16623 */   MCD::OPC_Decode, 132, 17, 64, // Opcode: XVPERM_W, DecodeIdx: 64
/* 16627 */   MCD::OPC_FilterValue, 160, 1, 73, 0, // Skip to: 16705
/* 16632 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16635 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 16644
/* 16639 */   MCD::OPC_Decode, 188, 17, 132, 1, // Opcode: XVSEQI_B, DecodeIdx: 132
/* 16644 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 16653
/* 16648 */   MCD::OPC_Decode, 190, 17, 132, 1, // Opcode: XVSEQI_H, DecodeIdx: 132
/* 16653 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 16662
/* 16657 */   MCD::OPC_Decode, 191, 17, 132, 1, // Opcode: XVSEQI_W, DecodeIdx: 132
/* 16662 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 16671
/* 16666 */   MCD::OPC_Decode, 189, 17, 132, 1, // Opcode: XVSEQI_D, DecodeIdx: 132
/* 16671 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 16680
/* 16675 */   MCD::OPC_Decode, 218, 17, 132, 1, // Opcode: XVSLEI_B, DecodeIdx: 132
/* 16680 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 16689
/* 16684 */   MCD::OPC_Decode, 222, 17, 132, 1, // Opcode: XVSLEI_H, DecodeIdx: 132
/* 16689 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 16698
/* 16693 */   MCD::OPC_Decode, 224, 17, 132, 1, // Opcode: XVSLEI_W, DecodeIdx: 132
/* 16698 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16700 */   MCD::OPC_Decode, 220, 17, 132, 1, // Opcode: XVSLEI_D, DecodeIdx: 132
/* 16705 */   MCD::OPC_FilterValue, 161, 1, 73, 0, // Skip to: 16783
/* 16710 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16713 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 16722
/* 16717 */   MCD::OPC_Decode, 219, 17, 133, 1, // Opcode: XVSLEI_BU, DecodeIdx: 133
/* 16722 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 16731
/* 16726 */   MCD::OPC_Decode, 223, 17, 133, 1, // Opcode: XVSLEI_HU, DecodeIdx: 133
/* 16731 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 16740
/* 16735 */   MCD::OPC_Decode, 225, 17, 133, 1, // Opcode: XVSLEI_WU, DecodeIdx: 133
/* 16740 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 16749
/* 16744 */   MCD::OPC_Decode, 221, 17, 133, 1, // Opcode: XVSLEI_DU, DecodeIdx: 133
/* 16749 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 16758
/* 16753 */   MCD::OPC_Decode, 248, 17, 132, 1, // Opcode: XVSLTI_B, DecodeIdx: 132
/* 16758 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 16767
/* 16762 */   MCD::OPC_Decode, 252, 17, 132, 1, // Opcode: XVSLTI_H, DecodeIdx: 132
/* 16767 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 16776
/* 16771 */   MCD::OPC_Decode, 254, 17, 132, 1, // Opcode: XVSLTI_W, DecodeIdx: 132
/* 16776 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16778 */   MCD::OPC_Decode, 250, 17, 132, 1, // Opcode: XVSLTI_D, DecodeIdx: 132
/* 16783 */   MCD::OPC_FilterValue, 162, 1, 73, 0, // Skip to: 16861
/* 16788 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16791 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 16800
/* 16795 */   MCD::OPC_Decode, 249, 17, 133, 1, // Opcode: XVSLTI_BU, DecodeIdx: 133
/* 16800 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 16809
/* 16804 */   MCD::OPC_Decode, 253, 17, 133, 1, // Opcode: XVSLTI_HU, DecodeIdx: 133
/* 16809 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 16818
/* 16813 */   MCD::OPC_Decode, 255, 17, 133, 1, // Opcode: XVSLTI_WU, DecodeIdx: 133
/* 16818 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 16827
/* 16822 */   MCD::OPC_Decode, 251, 17, 133, 1, // Opcode: XVSLTI_DU, DecodeIdx: 133
/* 16827 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 16836
/* 16831 */   MCD::OPC_Decode, 222, 13, 133, 1, // Opcode: XVADDI_BU, DecodeIdx: 133
/* 16836 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 16845
/* 16840 */   MCD::OPC_Decode, 224, 13, 133, 1, // Opcode: XVADDI_HU, DecodeIdx: 133
/* 16845 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 16854
/* 16849 */   MCD::OPC_Decode, 225, 13, 133, 1, // Opcode: XVADDI_WU, DecodeIdx: 133
/* 16854 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16856 */   MCD::OPC_Decode, 223, 13, 133, 1, // Opcode: XVADDI_DU, DecodeIdx: 133
/* 16861 */   MCD::OPC_FilterValue, 163, 1, 55, 0, // Skip to: 16921
/* 16866 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16869 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 16878
/* 16873 */   MCD::OPC_Decode, 138, 19, 133, 1, // Opcode: XVSUBI_BU, DecodeIdx: 133
/* 16878 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 16887
/* 16882 */   MCD::OPC_Decode, 140, 19, 133, 1, // Opcode: XVSUBI_HU, DecodeIdx: 133
/* 16887 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 16896
/* 16891 */   MCD::OPC_Decode, 141, 19, 133, 1, // Opcode: XVSUBI_WU, DecodeIdx: 133
/* 16896 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 16905
/* 16900 */   MCD::OPC_Decode, 139, 19, 133, 1, // Opcode: XVSUBI_DU, DecodeIdx: 133
/* 16905 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 16914
/* 16909 */   MCD::OPC_Decode, 172, 14, 133, 1, // Opcode: XVBSLL_V, DecodeIdx: 133
/* 16914 */   MCD::OPC_FilterValueOrFail, 5, 
/* 16916 */   MCD::OPC_Decode, 173, 14, 133, 1, // Opcode: XVBSRL_V, DecodeIdx: 133
/* 16921 */   MCD::OPC_FilterValue, 164, 1, 73, 0, // Skip to: 16999
/* 16926 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 16929 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 16938
/* 16933 */   MCD::OPC_Decode, 150, 16, 132, 1, // Opcode: XVMAXI_B, DecodeIdx: 132
/* 16938 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 16947
/* 16942 */   MCD::OPC_Decode, 154, 16, 132, 1, // Opcode: XVMAXI_H, DecodeIdx: 132
/* 16947 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 16956
/* 16951 */   MCD::OPC_Decode, 156, 16, 132, 1, // Opcode: XVMAXI_W, DecodeIdx: 132
/* 16956 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 16965
/* 16960 */   MCD::OPC_Decode, 152, 16, 132, 1, // Opcode: XVMAXI_D, DecodeIdx: 132
/* 16965 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 16974
/* 16969 */   MCD::OPC_Decode, 166, 16, 132, 1, // Opcode: XVMINI_B, DecodeIdx: 132
/* 16974 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 16983
/* 16978 */   MCD::OPC_Decode, 170, 16, 132, 1, // Opcode: XVMINI_H, DecodeIdx: 132
/* 16983 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 16992
/* 16987 */   MCD::OPC_Decode, 172, 16, 132, 1, // Opcode: XVMINI_W, DecodeIdx: 132
/* 16992 */   MCD::OPC_FilterValueOrFail, 7, 
/* 16994 */   MCD::OPC_Decode, 168, 16, 132, 1, // Opcode: XVMINI_D, DecodeIdx: 132
/* 16999 */   MCD::OPC_FilterValue, 165, 1, 73, 0, // Skip to: 17077
/* 17004 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17007 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 17016
/* 17011 */   MCD::OPC_Decode, 151, 16, 133, 1, // Opcode: XVMAXI_BU, DecodeIdx: 133
/* 17016 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 17025
/* 17020 */   MCD::OPC_Decode, 155, 16, 133, 1, // Opcode: XVMAXI_HU, DecodeIdx: 133
/* 17025 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 17034
/* 17029 */   MCD::OPC_Decode, 157, 16, 133, 1, // Opcode: XVMAXI_WU, DecodeIdx: 133
/* 17034 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 17043
/* 17038 */   MCD::OPC_Decode, 153, 16, 133, 1, // Opcode: XVMAXI_DU, DecodeIdx: 133
/* 17043 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 17052
/* 17047 */   MCD::OPC_Decode, 167, 16, 133, 1, // Opcode: XVMINI_BU, DecodeIdx: 133
/* 17052 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 17061
/* 17056 */   MCD::OPC_Decode, 171, 16, 133, 1, // Opcode: XVMINI_HU, DecodeIdx: 133
/* 17061 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 17070
/* 17065 */   MCD::OPC_Decode, 173, 16, 133, 1, // Opcode: XVMINI_WU, DecodeIdx: 133
/* 17070 */   MCD::OPC_FilterValueOrFail, 7, 
/* 17072 */   MCD::OPC_Decode, 169, 16, 133, 1, // Opcode: XVMINI_DU, DecodeIdx: 133
/* 17077 */   MCD::OPC_FilterValue, 166, 1, 19, 0, // Skip to: 17101
/* 17082 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17085 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 17094
/* 17089 */   MCD::OPC_Decode, 177, 15, 134, 1, // Opcode: XVFRSTPI_B, DecodeIdx: 134
/* 17094 */   MCD::OPC_FilterValueOrFail, 5, 
/* 17096 */   MCD::OPC_Decode, 178, 15, 134, 1, // Opcode: XVFRSTPI_H, DecodeIdx: 134
/* 17101 */   MCD::OPC_FilterValue, 167, 1, 87, 4, // Skip to: 18217
/* 17106 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 17109 */   MCD::OPC_FilterValue, 0, 199, 0, // Skip to: 17312
/* 17113 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 17116 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 17125
/* 17120 */   MCD::OPC_Decode, 174, 14, 135, 1, // Opcode: XVCLO_B, DecodeIdx: 135
/* 17125 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 17134
/* 17129 */   MCD::OPC_Decode, 176, 14, 135, 1, // Opcode: XVCLO_H, DecodeIdx: 135
/* 17134 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 17143
/* 17138 */   MCD::OPC_Decode, 177, 14, 135, 1, // Opcode: XVCLO_W, DecodeIdx: 135
/* 17143 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 17152
/* 17147 */   MCD::OPC_Decode, 175, 14, 135, 1, // Opcode: XVCLO_D, DecodeIdx: 135
/* 17152 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 17161
/* 17156 */   MCD::OPC_Decode, 178, 14, 135, 1, // Opcode: XVCLZ_B, DecodeIdx: 135
/* 17161 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 17170
/* 17165 */   MCD::OPC_Decode, 180, 14, 135, 1, // Opcode: XVCLZ_H, DecodeIdx: 135
/* 17170 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 17179
/* 17174 */   MCD::OPC_Decode, 181, 14, 135, 1, // Opcode: XVCLZ_W, DecodeIdx: 135
/* 17179 */   MCD::OPC_FilterValue, 7, 5, 0, // Skip to: 17188
/* 17183 */   MCD::OPC_Decode, 179, 14, 135, 1, // Opcode: XVCLZ_D, DecodeIdx: 135
/* 17188 */   MCD::OPC_FilterValue, 8, 5, 0, // Skip to: 17197
/* 17192 */   MCD::OPC_Decode, 253, 16, 135, 1, // Opcode: XVPCNT_B, DecodeIdx: 135
/* 17197 */   MCD::OPC_FilterValue, 9, 5, 0, // Skip to: 17206
/* 17201 */   MCD::OPC_Decode, 255, 16, 135, 1, // Opcode: XVPCNT_H, DecodeIdx: 135
/* 17206 */   MCD::OPC_FilterValue, 10, 5, 0, // Skip to: 17215
/* 17210 */   MCD::OPC_Decode, 128, 17, 135, 1, // Opcode: XVPCNT_W, DecodeIdx: 135
/* 17215 */   MCD::OPC_FilterValue, 11, 5, 0, // Skip to: 17224
/* 17219 */   MCD::OPC_Decode, 254, 16, 135, 1, // Opcode: XVPCNT_D, DecodeIdx: 135
/* 17224 */   MCD::OPC_FilterValue, 12, 5, 0, // Skip to: 17233
/* 17228 */   MCD::OPC_Decode, 236, 16, 135, 1, // Opcode: XVNEG_B, DecodeIdx: 135
/* 17233 */   MCD::OPC_FilterValue, 13, 5, 0, // Skip to: 17242
/* 17237 */   MCD::OPC_Decode, 238, 16, 135, 1, // Opcode: XVNEG_H, DecodeIdx: 135
/* 17242 */   MCD::OPC_FilterValue, 14, 5, 0, // Skip to: 17251
/* 17246 */   MCD::OPC_Decode, 239, 16, 135, 1, // Opcode: XVNEG_W, DecodeIdx: 135
/* 17251 */   MCD::OPC_FilterValue, 15, 5, 0, // Skip to: 17260
/* 17255 */   MCD::OPC_Decode, 237, 16, 135, 1, // Opcode: XVNEG_D, DecodeIdx: 135
/* 17260 */   MCD::OPC_FilterValue, 16, 5, 0, // Skip to: 17269
/* 17264 */   MCD::OPC_Decode, 191, 16, 135, 1, // Opcode: XVMSKLTZ_B, DecodeIdx: 135
/* 17269 */   MCD::OPC_FilterValue, 17, 5, 0, // Skip to: 17278
/* 17273 */   MCD::OPC_Decode, 193, 16, 135, 1, // Opcode: XVMSKLTZ_H, DecodeIdx: 135
/* 17278 */   MCD::OPC_FilterValue, 18, 5, 0, // Skip to: 17287
/* 17282 */   MCD::OPC_Decode, 194, 16, 135, 1, // Opcode: XVMSKLTZ_W, DecodeIdx: 135
/* 17287 */   MCD::OPC_FilterValue, 19, 5, 0, // Skip to: 17296
/* 17291 */   MCD::OPC_Decode, 192, 16, 135, 1, // Opcode: XVMSKLTZ_D, DecodeIdx: 135
/* 17296 */   MCD::OPC_FilterValue, 20, 5, 0, // Skip to: 17305
/* 17300 */   MCD::OPC_Decode, 190, 16, 135, 1, // Opcode: XVMSKGEZ_B, DecodeIdx: 135
/* 17305 */   MCD::OPC_FilterValueOrFail, 24, 
/* 17307 */   MCD::OPC_Decode, 195, 16, 135, 1, // Opcode: XVMSKNZ_B, DecodeIdx: 135
/* 17312 */   MCD::OPC_FilterValue, 1, 203, 0, // Skip to: 17519
/* 17316 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 17319 */   MCD::OPC_FilterValue, 6, 9, 0, // Skip to: 17332
/* 17323 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 17327 */   MCD::OPC_Decode, 204, 17, 136, 1, // Opcode: XVSETEQZ_V, DecodeIdx: 136
/* 17332 */   MCD::OPC_FilterValue, 7, 9, 0, // Skip to: 17345
/* 17336 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 17340 */   MCD::OPC_Decode, 205, 17, 136, 1, // Opcode: XVSETNEZ_V, DecodeIdx: 136
/* 17345 */   MCD::OPC_FilterValue, 8, 9, 0, // Skip to: 17358
/* 17349 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 17353 */   MCD::OPC_Decode, 200, 17, 136, 1, // Opcode: XVSETANYEQZ_B, DecodeIdx: 136
/* 17358 */   MCD::OPC_FilterValue, 9, 9, 0, // Skip to: 17371
/* 17362 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 17366 */   MCD::OPC_Decode, 202, 17, 136, 1, // Opcode: XVSETANYEQZ_H, DecodeIdx: 136
/* 17371 */   MCD::OPC_FilterValue, 10, 9, 0, // Skip to: 17384
/* 17375 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 17379 */   MCD::OPC_Decode, 203, 17, 136, 1, // Opcode: XVSETANYEQZ_W, DecodeIdx: 136
/* 17384 */   MCD::OPC_FilterValue, 11, 9, 0, // Skip to: 17397
/* 17388 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 17392 */   MCD::OPC_Decode, 201, 17, 136, 1, // Opcode: XVSETANYEQZ_D, DecodeIdx: 136
/* 17397 */   MCD::OPC_FilterValue, 12, 9, 0, // Skip to: 17410
/* 17401 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 17405 */   MCD::OPC_Decode, 196, 17, 136, 1, // Opcode: XVSETALLNEZ_B, DecodeIdx: 136
/* 17410 */   MCD::OPC_FilterValue, 13, 9, 0, // Skip to: 17423
/* 17414 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 17418 */   MCD::OPC_Decode, 198, 17, 136, 1, // Opcode: XVSETALLNEZ_H, DecodeIdx: 136
/* 17423 */   MCD::OPC_FilterValue, 14, 9, 0, // Skip to: 17436
/* 17427 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 17431 */   MCD::OPC_Decode, 199, 17, 136, 1, // Opcode: XVSETALLNEZ_W, DecodeIdx: 136
/* 17436 */   MCD::OPC_FilterValue, 15, 9, 0, // Skip to: 17449
/* 17440 */   MCD::OPC_CheckFieldOrFail, 3, 2, 0, 
/* 17444 */   MCD::OPC_Decode, 197, 17, 136, 1, // Opcode: XVSETALLNEZ_D, DecodeIdx: 136
/* 17449 */   MCD::OPC_FilterValue, 17, 5, 0, // Skip to: 17458
/* 17453 */   MCD::OPC_Decode, 140, 15, 135, 1, // Opcode: XVFLOGB_S, DecodeIdx: 135
/* 17458 */   MCD::OPC_FilterValue, 18, 5, 0, // Skip to: 17467
/* 17462 */   MCD::OPC_Decode, 139, 15, 135, 1, // Opcode: XVFLOGB_D, DecodeIdx: 135
/* 17467 */   MCD::OPC_FilterValue, 21, 5, 0, // Skip to: 17476
/* 17471 */   MCD::OPC_Decode, 207, 14, 135, 1, // Opcode: XVFCLASS_S, DecodeIdx: 135
/* 17476 */   MCD::OPC_FilterValue, 22, 5, 0, // Skip to: 17485
/* 17480 */   MCD::OPC_Decode, 206, 14, 135, 1, // Opcode: XVFCLASS_D, DecodeIdx: 135
/* 17485 */   MCD::OPC_FilterValue, 25, 5, 0, // Skip to: 17494
/* 17489 */   MCD::OPC_Decode, 182, 15, 135, 1, // Opcode: XVFSQRT_S, DecodeIdx: 135
/* 17494 */   MCD::OPC_FilterValue, 26, 5, 0, // Skip to: 17503
/* 17498 */   MCD::OPC_Decode, 181, 15, 135, 1, // Opcode: XVFSQRT_D, DecodeIdx: 135
/* 17503 */   MCD::OPC_FilterValue, 29, 5, 0, // Skip to: 17512
/* 17507 */   MCD::OPC_Decode, 162, 15, 135, 1, // Opcode: XVFRECIP_S, DecodeIdx: 135
/* 17512 */   MCD::OPC_FilterValueOrFail, 30, 
/* 17514 */   MCD::OPC_Decode, 161, 15, 135, 1, // Opcode: XVFRECIP_D, DecodeIdx: 135
/* 17519 */   MCD::OPC_FilterValue, 2, 145, 0, // Skip to: 17668
/* 17523 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 17526 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 17535
/* 17530 */   MCD::OPC_Decode, 176, 15, 135, 1, // Opcode: XVFRSQRT_S, DecodeIdx: 135
/* 17535 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 17544
/* 17539 */   MCD::OPC_Decode, 175, 15, 135, 1, // Opcode: XVFRSQRT_D, DecodeIdx: 135
/* 17544 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 17553
/* 17548 */   MCD::OPC_Decode, 160, 15, 135, 1, // Opcode: XVFRECIPE_S, DecodeIdx: 135
/* 17553 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 17562
/* 17557 */   MCD::OPC_Decode, 159, 15, 135, 1, // Opcode: XVFRECIPE_D, DecodeIdx: 135
/* 17562 */   MCD::OPC_FilterValue, 9, 5, 0, // Skip to: 17571
/* 17566 */   MCD::OPC_Decode, 174, 15, 135, 1, // Opcode: XVFRSQRTE_S, DecodeIdx: 135
/* 17571 */   MCD::OPC_FilterValue, 10, 5, 0, // Skip to: 17580
/* 17575 */   MCD::OPC_Decode, 173, 15, 135, 1, // Opcode: XVFRSQRTE_D, DecodeIdx: 135
/* 17580 */   MCD::OPC_FilterValue, 13, 5, 0, // Skip to: 17589
/* 17584 */   MCD::OPC_Decode, 172, 15, 135, 1, // Opcode: XVFRINT_S, DecodeIdx: 135
/* 17589 */   MCD::OPC_FilterValue, 14, 5, 0, // Skip to: 17598
/* 17593 */   MCD::OPC_Decode, 171, 15, 135, 1, // Opcode: XVFRINT_D, DecodeIdx: 135
/* 17598 */   MCD::OPC_FilterValue, 17, 5, 0, // Skip to: 17607
/* 17602 */   MCD::OPC_Decode, 164, 15, 135, 1, // Opcode: XVFRINTRM_S, DecodeIdx: 135
/* 17607 */   MCD::OPC_FilterValue, 18, 5, 0, // Skip to: 17616
/* 17611 */   MCD::OPC_Decode, 163, 15, 135, 1, // Opcode: XVFRINTRM_D, DecodeIdx: 135
/* 17616 */   MCD::OPC_FilterValue, 21, 5, 0, // Skip to: 17625
/* 17620 */   MCD::OPC_Decode, 168, 15, 135, 1, // Opcode: XVFRINTRP_S, DecodeIdx: 135
/* 17625 */   MCD::OPC_FilterValue, 22, 5, 0, // Skip to: 17634
/* 17629 */   MCD::OPC_Decode, 167, 15, 135, 1, // Opcode: XVFRINTRP_D, DecodeIdx: 135
/* 17634 */   MCD::OPC_FilterValue, 25, 5, 0, // Skip to: 17643
/* 17638 */   MCD::OPC_Decode, 170, 15, 135, 1, // Opcode: XVFRINTRZ_S, DecodeIdx: 135
/* 17643 */   MCD::OPC_FilterValue, 26, 5, 0, // Skip to: 17652
/* 17647 */   MCD::OPC_Decode, 169, 15, 135, 1, // Opcode: XVFRINTRZ_D, DecodeIdx: 135
/* 17652 */   MCD::OPC_FilterValue, 29, 5, 0, // Skip to: 17661
/* 17656 */   MCD::OPC_Decode, 166, 15, 135, 1, // Opcode: XVFRINTRNE_S, DecodeIdx: 135
/* 17661 */   MCD::OPC_FilterValueOrFail, 30, 
/* 17663 */   MCD::OPC_Decode, 165, 15, 135, 1, // Opcode: XVFRINTRNE_D, DecodeIdx: 135
/* 17668 */   MCD::OPC_FilterValue, 3, 37, 0, // Skip to: 17709
/* 17672 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 17675 */   MCD::OPC_FilterValue, 26, 5, 0, // Skip to: 17684
/* 17679 */   MCD::OPC_Decode, 255, 14, 135, 1, // Opcode: XVFCVTL_S_H, DecodeIdx: 135
/* 17684 */   MCD::OPC_FilterValue, 27, 5, 0, // Skip to: 17693
/* 17688 */   MCD::OPC_Decode, 253, 14, 135, 1, // Opcode: XVFCVTH_S_H, DecodeIdx: 135
/* 17693 */   MCD::OPC_FilterValue, 28, 5, 0, // Skip to: 17702
/* 17697 */   MCD::OPC_Decode, 254, 14, 135, 1, // Opcode: XVFCVTL_D_S, DecodeIdx: 135
/* 17702 */   MCD::OPC_FilterValueOrFail, 29, 
/* 17704 */   MCD::OPC_Decode, 252, 14, 135, 1, // Opcode: XVFCVTH_D_S, DecodeIdx: 135
/* 17709 */   MCD::OPC_FilterValue, 4, 181, 0, // Skip to: 17894
/* 17713 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 17716 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 17725
/* 17720 */   MCD::OPC_Decode, 137, 15, 135, 1, // Opcode: XVFFINT_S_W, DecodeIdx: 135
/* 17725 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 17734
/* 17729 */   MCD::OPC_Decode, 138, 15, 135, 1, // Opcode: XVFFINT_S_WU, DecodeIdx: 135
/* 17734 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 17743
/* 17738 */   MCD::OPC_Decode, 134, 15, 135, 1, // Opcode: XVFFINT_D_L, DecodeIdx: 135
/* 17743 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 17752
/* 17747 */   MCD::OPC_Decode, 135, 15, 135, 1, // Opcode: XVFFINT_D_LU, DecodeIdx: 135
/* 17752 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 17761
/* 17756 */   MCD::OPC_Decode, 133, 15, 135, 1, // Opcode: XVFFINTL_D_W, DecodeIdx: 135
/* 17761 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 17770
/* 17765 */   MCD::OPC_Decode, 132, 15, 135, 1, // Opcode: XVFFINTH_D_W, DecodeIdx: 135
/* 17770 */   MCD::OPC_FilterValue, 12, 5, 0, // Skip to: 17779
/* 17774 */   MCD::OPC_Decode, 213, 15, 135, 1, // Opcode: XVFTINT_W_S, DecodeIdx: 135
/* 17779 */   MCD::OPC_FilterValue, 13, 5, 0, // Skip to: 17788
/* 17783 */   MCD::OPC_Decode, 210, 15, 135, 1, // Opcode: XVFTINT_L_D, DecodeIdx: 135
/* 17788 */   MCD::OPC_FilterValue, 14, 5, 0, // Skip to: 17797
/* 17792 */   MCD::OPC_Decode, 191, 15, 135, 1, // Opcode: XVFTINTRM_W_S, DecodeIdx: 135
/* 17797 */   MCD::OPC_FilterValue, 15, 5, 0, // Skip to: 17806
/* 17801 */   MCD::OPC_Decode, 189, 15, 135, 1, // Opcode: XVFTINTRM_L_D, DecodeIdx: 135
/* 17806 */   MCD::OPC_FilterValue, 16, 5, 0, // Skip to: 17815
/* 17810 */   MCD::OPC_Decode, 201, 15, 135, 1, // Opcode: XVFTINTRP_W_S, DecodeIdx: 135
/* 17815 */   MCD::OPC_FilterValue, 17, 5, 0, // Skip to: 17824
/* 17819 */   MCD::OPC_Decode, 199, 15, 135, 1, // Opcode: XVFTINTRP_L_D, DecodeIdx: 135
/* 17824 */   MCD::OPC_FilterValue, 18, 5, 0, // Skip to: 17833
/* 17828 */   MCD::OPC_Decode, 208, 15, 135, 1, // Opcode: XVFTINTRZ_W_S, DecodeIdx: 135
/* 17833 */   MCD::OPC_FilterValue, 19, 5, 0, // Skip to: 17842
/* 17837 */   MCD::OPC_Decode, 205, 15, 135, 1, // Opcode: XVFTINTRZ_L_D, DecodeIdx: 135
/* 17842 */   MCD::OPC_FilterValue, 20, 5, 0, // Skip to: 17851
/* 17846 */   MCD::OPC_Decode, 196, 15, 135, 1, // Opcode: XVFTINTRNE_W_S, DecodeIdx: 135
/* 17851 */   MCD::OPC_FilterValue, 21, 5, 0, // Skip to: 17860
/* 17855 */   MCD::OPC_Decode, 194, 15, 135, 1, // Opcode: XVFTINTRNE_L_D, DecodeIdx: 135
/* 17860 */   MCD::OPC_FilterValue, 22, 5, 0, // Skip to: 17869
/* 17864 */   MCD::OPC_Decode, 211, 15, 135, 1, // Opcode: XVFTINT_WU_S, DecodeIdx: 135
/* 17869 */   MCD::OPC_FilterValue, 23, 5, 0, // Skip to: 17878
/* 17873 */   MCD::OPC_Decode, 209, 15, 135, 1, // Opcode: XVFTINT_LU_D, DecodeIdx: 135
/* 17878 */   MCD::OPC_FilterValue, 28, 5, 0, // Skip to: 17887
/* 17882 */   MCD::OPC_Decode, 206, 15, 135, 1, // Opcode: XVFTINTRZ_WU_S, DecodeIdx: 135
/* 17887 */   MCD::OPC_FilterValueOrFail, 29, 
/* 17889 */   MCD::OPC_Decode, 204, 15, 135, 1, // Opcode: XVFTINTRZ_LU_D, DecodeIdx: 135
/* 17894 */   MCD::OPC_FilterValue, 5, 163, 0, // Skip to: 18061
/* 17898 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 17901 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 17910
/* 17905 */   MCD::OPC_Decode, 186, 15, 135, 1, // Opcode: XVFTINTL_L_S, DecodeIdx: 135
/* 17910 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 17919
/* 17914 */   MCD::OPC_Decode, 185, 15, 135, 1, // Opcode: XVFTINTH_L_S, DecodeIdx: 135
/* 17919 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 17928
/* 17923 */   MCD::OPC_Decode, 188, 15, 135, 1, // Opcode: XVFTINTRML_L_S, DecodeIdx: 135
/* 17928 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 17937
/* 17932 */   MCD::OPC_Decode, 187, 15, 135, 1, // Opcode: XVFTINTRMH_L_S, DecodeIdx: 135
/* 17937 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 17946
/* 17941 */   MCD::OPC_Decode, 198, 15, 135, 1, // Opcode: XVFTINTRPL_L_S, DecodeIdx: 135
/* 17946 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 17955
/* 17950 */   MCD::OPC_Decode, 197, 15, 135, 1, // Opcode: XVFTINTRPH_L_S, DecodeIdx: 135
/* 17955 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 17964
/* 17959 */   MCD::OPC_Decode, 203, 15, 135, 1, // Opcode: XVFTINTRZL_L_S, DecodeIdx: 135
/* 17964 */   MCD::OPC_FilterValue, 7, 5, 0, // Skip to: 17973
/* 17968 */   MCD::OPC_Decode, 202, 15, 135, 1, // Opcode: XVFTINTRZH_L_S, DecodeIdx: 135
/* 17973 */   MCD::OPC_FilterValue, 8, 5, 0, // Skip to: 17982
/* 17977 */   MCD::OPC_Decode, 193, 15, 135, 1, // Opcode: XVFTINTRNEL_L_S, DecodeIdx: 135
/* 17982 */   MCD::OPC_FilterValue, 9, 5, 0, // Skip to: 17991
/* 17986 */   MCD::OPC_Decode, 192, 15, 135, 1, // Opcode: XVFTINTRNEH_L_S, DecodeIdx: 135
/* 17991 */   MCD::OPC_FilterValue, 24, 5, 0, // Skip to: 18000
/* 17995 */   MCD::OPC_Decode, 193, 14, 135, 1, // Opcode: XVEXTH_H_B, DecodeIdx: 135
/* 18000 */   MCD::OPC_FilterValue, 25, 5, 0, // Skip to: 18009
/* 18004 */   MCD::OPC_Decode, 197, 14, 135, 1, // Opcode: XVEXTH_W_H, DecodeIdx: 135
/* 18009 */   MCD::OPC_FilterValue, 26, 5, 0, // Skip to: 18018
/* 18013 */   MCD::OPC_Decode, 191, 14, 135, 1, // Opcode: XVEXTH_D_W, DecodeIdx: 135
/* 18018 */   MCD::OPC_FilterValue, 27, 5, 0, // Skip to: 18027
/* 18022 */   MCD::OPC_Decode, 195, 14, 135, 1, // Opcode: XVEXTH_Q_D, DecodeIdx: 135
/* 18027 */   MCD::OPC_FilterValue, 28, 5, 0, // Skip to: 18036
/* 18031 */   MCD::OPC_Decode, 192, 14, 135, 1, // Opcode: XVEXTH_HU_BU, DecodeIdx: 135
/* 18036 */   MCD::OPC_FilterValue, 29, 5, 0, // Skip to: 18045
/* 18040 */   MCD::OPC_Decode, 196, 14, 135, 1, // Opcode: XVEXTH_WU_HU, DecodeIdx: 135
/* 18045 */   MCD::OPC_FilterValue, 30, 5, 0, // Skip to: 18054
/* 18049 */   MCD::OPC_Decode, 190, 14, 135, 1, // Opcode: XVEXTH_DU_WU, DecodeIdx: 135
/* 18054 */   MCD::OPC_FilterValueOrFail, 31, 
/* 18056 */   MCD::OPC_Decode, 194, 14, 135, 1, // Opcode: XVEXTH_QU_DU, DecodeIdx: 135
/* 18061 */   MCD::OPC_FilterValue, 6, 145, 0, // Skip to: 18210
/* 18065 */   MCD::OPC_ExtractField, 10, 5,  // Inst{14-10} ...
/* 18068 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 18077
/* 18072 */   MCD::OPC_Decode, 151, 17, 137, 1, // Opcode: XVREPLGR2VR_B, DecodeIdx: 137
/* 18077 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 18086
/* 18081 */   MCD::OPC_Decode, 153, 17, 137, 1, // Opcode: XVREPLGR2VR_H, DecodeIdx: 137
/* 18086 */   MCD::OPC_FilterValue, 2, 5, 0, // Skip to: 18095
/* 18090 */   MCD::OPC_Decode, 154, 17, 137, 1, // Opcode: XVREPLGR2VR_W, DecodeIdx: 137
/* 18095 */   MCD::OPC_FilterValue, 3, 5, 0, // Skip to: 18104
/* 18099 */   MCD::OPC_Decode, 152, 17, 137, 1, // Opcode: XVREPLGR2VR_D, DecodeIdx: 137
/* 18104 */   MCD::OPC_FilterValue, 4, 5, 0, // Skip to: 18113
/* 18108 */   MCD::OPC_Decode, 250, 7, 135, 1, // Opcode: VEXT2XV_H_B, DecodeIdx: 135
/* 18113 */   MCD::OPC_FilterValue, 5, 5, 0, // Skip to: 18122
/* 18117 */   MCD::OPC_Decode, 253, 7, 135, 1, // Opcode: VEXT2XV_W_B, DecodeIdx: 135
/* 18122 */   MCD::OPC_FilterValue, 6, 5, 0, // Skip to: 18131
/* 18126 */   MCD::OPC_Decode, 246, 7, 135, 1, // Opcode: VEXT2XV_D_B, DecodeIdx: 135
/* 18131 */   MCD::OPC_FilterValue, 7, 5, 0, // Skip to: 18140
/* 18135 */   MCD::OPC_Decode, 254, 7, 135, 1, // Opcode: VEXT2XV_W_H, DecodeIdx: 135
/* 18140 */   MCD::OPC_FilterValue, 8, 5, 0, // Skip to: 18149
/* 18144 */   MCD::OPC_Decode, 247, 7, 135, 1, // Opcode: VEXT2XV_D_H, DecodeIdx: 135
/* 18149 */   MCD::OPC_FilterValue, 9, 5, 0, // Skip to: 18158
/* 18153 */   MCD::OPC_Decode, 248, 7, 135, 1, // Opcode: VEXT2XV_D_W, DecodeIdx: 135
/* 18158 */   MCD::OPC_FilterValue, 10, 5, 0, // Skip to: 18167
/* 18162 */   MCD::OPC_Decode, 249, 7, 135, 1, // Opcode: VEXT2XV_HU_BU, DecodeIdx: 135
/* 18167 */   MCD::OPC_FilterValue, 11, 5, 0, // Skip to: 18176
/* 18171 */   MCD::OPC_Decode, 251, 7, 135, 1, // Opcode: VEXT2XV_WU_BU, DecodeIdx: 135
/* 18176 */   MCD::OPC_FilterValue, 12, 5, 0, // Skip to: 18185
/* 18180 */   MCD::OPC_Decode, 243, 7, 135, 1, // Opcode: VEXT2XV_DU_BU, DecodeIdx: 135
/* 18185 */   MCD::OPC_FilterValue, 13, 5, 0, // Skip to: 18194
/* 18189 */   MCD::OPC_Decode, 252, 7, 135, 1, // Opcode: VEXT2XV_WU_HU, DecodeIdx: 135
/* 18194 */   MCD::OPC_FilterValue, 14, 5, 0, // Skip to: 18203
/* 18198 */   MCD::OPC_Decode, 244, 7, 135, 1, // Opcode: VEXT2XV_DU_HU, DecodeIdx: 135
/* 18203 */   MCD::OPC_FilterValueOrFail, 15, 
/* 18205 */   MCD::OPC_Decode, 245, 7, 135, 1, // Opcode: VEXT2XV_DU_WU, DecodeIdx: 135
/* 18210 */   MCD::OPC_FilterValueOrFail, 7, 
/* 18212 */   MCD::OPC_Decode, 222, 15, 133, 1, // Opcode: XVHSELI_D, DecodeIdx: 133
/* 18217 */   MCD::OPC_FilterValue, 168, 1, 51, 0, // Skip to: 18273
/* 18222 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 18225 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 18266
/* 18229 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 18232 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 18259
/* 18236 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 18239 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 18252
/* 18243 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 18247 */   MCD::OPC_Decode, 164, 17, 138, 1, // Opcode: XVROTRI_B, DecodeIdx: 138
/* 18252 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18254 */   MCD::OPC_Decode, 166, 17, 139, 1, // Opcode: XVROTRI_H, DecodeIdx: 139
/* 18259 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18261 */   MCD::OPC_Decode, 167, 17, 133, 1, // Opcode: XVROTRI_W, DecodeIdx: 133
/* 18266 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18268 */   MCD::OPC_Decode, 165, 17, 140, 1, // Opcode: XVROTRI_D, DecodeIdx: 140
/* 18273 */   MCD::OPC_FilterValue, 169, 1, 51, 0, // Skip to: 18329
/* 18278 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 18281 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 18322
/* 18285 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 18288 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 18315
/* 18292 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 18295 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 18308
/* 18299 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 18303 */   MCD::OPC_Decode, 177, 18, 138, 1, // Opcode: XVSRLRI_B, DecodeIdx: 138
/* 18308 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18310 */   MCD::OPC_Decode, 179, 18, 139, 1, // Opcode: XVSRLRI_H, DecodeIdx: 139
/* 18315 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18317 */   MCD::OPC_Decode, 180, 18, 133, 1, // Opcode: XVSRLRI_W, DecodeIdx: 133
/* 18322 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18324 */   MCD::OPC_Decode, 178, 18, 140, 1, // Opcode: XVSRLRI_D, DecodeIdx: 140
/* 18329 */   MCD::OPC_FilterValue, 170, 1, 51, 0, // Skip to: 18385
/* 18334 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 18337 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 18378
/* 18341 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 18344 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 18371
/* 18348 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 18351 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 18364
/* 18355 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 18359 */   MCD::OPC_Decode, 147, 18, 138, 1, // Opcode: XVSRARI_B, DecodeIdx: 138
/* 18364 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18366 */   MCD::OPC_Decode, 149, 18, 139, 1, // Opcode: XVSRARI_H, DecodeIdx: 139
/* 18371 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18373 */   MCD::OPC_Decode, 150, 18, 133, 1, // Opcode: XVSRARI_W, DecodeIdx: 133
/* 18378 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18380 */   MCD::OPC_Decode, 148, 18, 140, 1, // Opcode: XVSRARI_D, DecodeIdx: 140
/* 18385 */   MCD::OPC_FilterValue, 186, 1, 23, 0, // Skip to: 18413
/* 18390 */   MCD::OPC_ExtractField, 13, 5,  // Inst{17-13} ...
/* 18393 */   MCD::OPC_FilterValue, 30, 5, 0, // Skip to: 18402
/* 18397 */   MCD::OPC_Decode, 240, 15, 141, 1, // Opcode: XVINSGR2VR_W, DecodeIdx: 141
/* 18402 */   MCD::OPC_FilterValueOrFail, 31, 
/* 18404 */   MCD::OPC_CheckFieldOrFail, 12, 1, 0, 
/* 18408 */   MCD::OPC_Decode, 239, 15, 142, 1, // Opcode: XVINSGR2VR_D, DecodeIdx: 142
/* 18413 */   MCD::OPC_FilterValue, 187, 1, 23, 0, // Skip to: 18441
/* 18418 */   MCD::OPC_ExtractField, 13, 5,  // Inst{17-13} ...
/* 18421 */   MCD::OPC_FilterValue, 30, 5, 0, // Skip to: 18430
/* 18425 */   MCD::OPC_Decode, 143, 17, 143, 1, // Opcode: XVPICKVE2GR_W, DecodeIdx: 143
/* 18430 */   MCD::OPC_FilterValueOrFail, 31, 
/* 18432 */   MCD::OPC_CheckFieldOrFail, 12, 1, 0, 
/* 18436 */   MCD::OPC_Decode, 141, 17, 144, 1, // Opcode: XVPICKVE2GR_D, DecodeIdx: 144
/* 18441 */   MCD::OPC_FilterValue, 188, 1, 23, 0, // Skip to: 18469
/* 18446 */   MCD::OPC_ExtractField, 13, 5,  // Inst{17-13} ...
/* 18449 */   MCD::OPC_FilterValue, 30, 5, 0, // Skip to: 18458
/* 18453 */   MCD::OPC_Decode, 144, 17, 143, 1, // Opcode: XVPICKVE2GR_WU, DecodeIdx: 143
/* 18458 */   MCD::OPC_FilterValueOrFail, 31, 
/* 18460 */   MCD::OPC_CheckFieldOrFail, 12, 1, 0, 
/* 18464 */   MCD::OPC_Decode, 142, 17, 144, 1, // Opcode: XVPICKVE2GR_DU, DecodeIdx: 144
/* 18469 */   MCD::OPC_FilterValue, 189, 1, 51, 0, // Skip to: 18525
/* 18474 */   MCD::OPC_ExtractField, 14, 4,  // Inst{17-14} ...
/* 18477 */   MCD::OPC_FilterValue, 14, 5, 0, // Skip to: 18486
/* 18481 */   MCD::OPC_Decode, 147, 17, 139, 1, // Opcode: XVREPL128VEI_B, DecodeIdx: 139
/* 18486 */   MCD::OPC_FilterValueOrFail, 15, 
/* 18488 */   MCD::OPC_ExtractField, 13, 1,  // Inst{13} ...
/* 18491 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 18500
/* 18495 */   MCD::OPC_Decode, 149, 17, 138, 1, // Opcode: XVREPL128VEI_H, DecodeIdx: 138
/* 18500 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18502 */   MCD::OPC_ExtractField, 12, 1,  // Inst{12} ...
/* 18505 */   MCD::OPC_FilterValue, 0, 5, 0, // Skip to: 18514
/* 18509 */   MCD::OPC_Decode, 150, 17, 145, 1, // Opcode: XVREPL128VEI_W, DecodeIdx: 145
/* 18514 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18516 */   MCD::OPC_CheckFieldOrFail, 11, 1, 0, 
/* 18520 */   MCD::OPC_Decode, 148, 17, 146, 1, // Opcode: XVREPL128VEI_D, DecodeIdx: 146
/* 18525 */   MCD::OPC_FilterValue, 191, 1, 23, 0, // Skip to: 18553
/* 18530 */   MCD::OPC_ExtractField, 13, 5,  // Inst{17-13} ...
/* 18533 */   MCD::OPC_FilterValue, 30, 5, 0, // Skip to: 18542
/* 18537 */   MCD::OPC_Decode, 242, 15, 147, 1, // Opcode: XVINSVE0_W, DecodeIdx: 147
/* 18542 */   MCD::OPC_FilterValueOrFail, 31, 
/* 18544 */   MCD::OPC_CheckFieldOrFail, 12, 1, 0, 
/* 18548 */   MCD::OPC_Decode, 241, 15, 148, 1, // Opcode: XVINSVE0_D, DecodeIdx: 148
/* 18553 */   MCD::OPC_FilterValue, 192, 1, 23, 0, // Skip to: 18581
/* 18558 */   MCD::OPC_ExtractField, 13, 5,  // Inst{17-13} ...
/* 18561 */   MCD::OPC_FilterValue, 30, 5, 0, // Skip to: 18570
/* 18565 */   MCD::OPC_Decode, 146, 17, 138, 1, // Opcode: XVPICKVE_W, DecodeIdx: 138
/* 18570 */   MCD::OPC_FilterValueOrFail, 31, 
/* 18572 */   MCD::OPC_CheckFieldOrFail, 12, 1, 0, 
/* 18576 */   MCD::OPC_Decode, 145, 17, 145, 1, // Opcode: XVPICKVE_D, DecodeIdx: 145
/* 18581 */   MCD::OPC_FilterValue, 193, 1, 51, 0, // Skip to: 18637
/* 18586 */   MCD::OPC_ExtractField, 10, 8,  // Inst{17-10} ...
/* 18589 */   MCD::OPC_FilterValue, 192, 1, 5, 0, // Skip to: 18599
/* 18594 */   MCD::OPC_Decode, 155, 17, 135, 1, // Opcode: XVREPLVE0_B, DecodeIdx: 135
/* 18599 */   MCD::OPC_FilterValue, 224, 1, 5, 0, // Skip to: 18609
/* 18604 */   MCD::OPC_Decode, 157, 17, 135, 1, // Opcode: XVREPLVE0_H, DecodeIdx: 135
/* 18609 */   MCD::OPC_FilterValue, 240, 1, 5, 0, // Skip to: 18619
/* 18614 */   MCD::OPC_Decode, 159, 17, 135, 1, // Opcode: XVREPLVE0_W, DecodeIdx: 135
/* 18619 */   MCD::OPC_FilterValue, 248, 1, 5, 0, // Skip to: 18629
/* 18624 */   MCD::OPC_Decode, 156, 17, 135, 1, // Opcode: XVREPLVE0_D, DecodeIdx: 135
/* 18629 */   MCD::OPC_FilterValueOrFail, 252, 1, 
/* 18632 */   MCD::OPC_Decode, 158, 17, 135, 1, // Opcode: XVREPLVE0_Q, DecodeIdx: 135
/* 18637 */   MCD::OPC_FilterValue, 194, 1, 50, 0, // Skip to: 18692
/* 18642 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18645 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 18672
/* 18649 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 18652 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 18665
/* 18656 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 18660 */   MCD::OPC_Decode, 241, 17, 138, 1, // Opcode: XVSLLWIL_H_B, DecodeIdx: 138
/* 18665 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18667 */   MCD::OPC_Decode, 243, 17, 139, 1, // Opcode: XVSLLWIL_W_H, DecodeIdx: 139
/* 18672 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 18681
/* 18676 */   MCD::OPC_Decode, 239, 17, 133, 1, // Opcode: XVSLLWIL_D_W, DecodeIdx: 133
/* 18681 */   MCD::OPC_FilterValueOrFail, 2, 
/* 18683 */   MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 18687 */   MCD::OPC_Decode, 199, 14, 135, 1, // Opcode: XVEXTL_Q_D, DecodeIdx: 135
/* 18692 */   MCD::OPC_FilterValue, 195, 1, 50, 0, // Skip to: 18747
/* 18697 */   MCD::OPC_ExtractField, 15, 3,  // Inst{17-15} ...
/* 18700 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 18727
/* 18704 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 18707 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 18720
/* 18711 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 18715 */   MCD::OPC_Decode, 240, 17, 138, 1, // Opcode: XVSLLWIL_HU_BU, DecodeIdx: 138
/* 18720 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18722 */   MCD::OPC_Decode, 242, 17, 139, 1, // Opcode: XVSLLWIL_WU_HU, DecodeIdx: 139
/* 18727 */   MCD::OPC_FilterValue, 1, 5, 0, // Skip to: 18736
/* 18731 */   MCD::OPC_Decode, 238, 17, 133, 1, // Opcode: XVSLLWIL_DU_WU, DecodeIdx: 133
/* 18736 */   MCD::OPC_FilterValueOrFail, 2, 
/* 18738 */   MCD::OPC_CheckFieldOrFail, 10, 5, 0, 
/* 18742 */   MCD::OPC_Decode, 198, 14, 135, 1, // Opcode: XVEXTL_QU_DU, DecodeIdx: 135
/* 18747 */   MCD::OPC_FilterValue, 196, 1, 51, 0, // Skip to: 18803
/* 18752 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 18755 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 18796
/* 18759 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 18762 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 18789
/* 18766 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 18769 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 18782
/* 18773 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 18777 */   MCD::OPC_Decode, 146, 14, 138, 1, // Opcode: XVBITCLRI_B, DecodeIdx: 138
/* 18782 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18784 */   MCD::OPC_Decode, 148, 14, 139, 1, // Opcode: XVBITCLRI_H, DecodeIdx: 139
/* 18789 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18791 */   MCD::OPC_Decode, 149, 14, 133, 1, // Opcode: XVBITCLRI_W, DecodeIdx: 133
/* 18796 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18798 */   MCD::OPC_Decode, 147, 14, 140, 1, // Opcode: XVBITCLRI_D, DecodeIdx: 140
/* 18803 */   MCD::OPC_FilterValue, 197, 1, 51, 0, // Skip to: 18859
/* 18808 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 18811 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 18852
/* 18815 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 18818 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 18845
/* 18822 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 18825 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 18838
/* 18829 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 18833 */   MCD::OPC_Decode, 164, 14, 138, 1, // Opcode: XVBITSETI_B, DecodeIdx: 138
/* 18838 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18840 */   MCD::OPC_Decode, 166, 14, 139, 1, // Opcode: XVBITSETI_H, DecodeIdx: 139
/* 18845 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18847 */   MCD::OPC_Decode, 167, 14, 133, 1, // Opcode: XVBITSETI_W, DecodeIdx: 133
/* 18852 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18854 */   MCD::OPC_Decode, 165, 14, 140, 1, // Opcode: XVBITSETI_D, DecodeIdx: 140
/* 18859 */   MCD::OPC_FilterValue, 198, 1, 51, 0, // Skip to: 18915
/* 18864 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 18867 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 18908
/* 18871 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 18874 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 18901
/* 18878 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 18881 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 18894
/* 18885 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 18889 */   MCD::OPC_Decode, 154, 14, 138, 1, // Opcode: XVBITREVI_B, DecodeIdx: 138
/* 18894 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18896 */   MCD::OPC_Decode, 156, 14, 139, 1, // Opcode: XVBITREVI_H, DecodeIdx: 139
/* 18901 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18903 */   MCD::OPC_Decode, 157, 14, 133, 1, // Opcode: XVBITREVI_W, DecodeIdx: 133
/* 18908 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18910 */   MCD::OPC_Decode, 155, 14, 140, 1, // Opcode: XVBITREVI_D, DecodeIdx: 140
/* 18915 */   MCD::OPC_FilterValue, 201, 1, 51, 0, // Skip to: 18971
/* 18920 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 18923 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 18964
/* 18927 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 18930 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 18957
/* 18934 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 18937 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 18950
/* 18941 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 18945 */   MCD::OPC_Decode, 180, 17, 138, 1, // Opcode: XVSAT_B, DecodeIdx: 138
/* 18950 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18952 */   MCD::OPC_Decode, 184, 17, 139, 1, // Opcode: XVSAT_H, DecodeIdx: 139
/* 18957 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18959 */   MCD::OPC_Decode, 186, 17, 133, 1, // Opcode: XVSAT_W, DecodeIdx: 133
/* 18964 */   MCD::OPC_FilterValueOrFail, 1, 
/* 18966 */   MCD::OPC_Decode, 182, 17, 140, 1, // Opcode: XVSAT_D, DecodeIdx: 140
/* 18971 */   MCD::OPC_FilterValue, 202, 1, 51, 0, // Skip to: 19027
/* 18976 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 18979 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19020
/* 18983 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 18986 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19013
/* 18990 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 18993 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19006
/* 18997 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 19001 */   MCD::OPC_Decode, 181, 17, 138, 1, // Opcode: XVSAT_BU, DecodeIdx: 138
/* 19006 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19008 */   MCD::OPC_Decode, 185, 17, 139, 1, // Opcode: XVSAT_HU, DecodeIdx: 139
/* 19013 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19015 */   MCD::OPC_Decode, 187, 17, 133, 1, // Opcode: XVSAT_WU, DecodeIdx: 133
/* 19020 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19022 */   MCD::OPC_Decode, 183, 17, 140, 1, // Opcode: XVSAT_DU, DecodeIdx: 140
/* 19027 */   MCD::OPC_FilterValue, 203, 1, 51, 0, // Skip to: 19083
/* 19032 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 19035 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19076
/* 19039 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19042 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19069
/* 19046 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 19049 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19062
/* 19053 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 19057 */   MCD::OPC_Decode, 234, 17, 138, 1, // Opcode: XVSLLI_B, DecodeIdx: 138
/* 19062 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19064 */   MCD::OPC_Decode, 236, 17, 139, 1, // Opcode: XVSLLI_H, DecodeIdx: 139
/* 19069 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19071 */   MCD::OPC_Decode, 237, 17, 133, 1, // Opcode: XVSLLI_W, DecodeIdx: 133
/* 19076 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19078 */   MCD::OPC_Decode, 235, 17, 140, 1, // Opcode: XVSLLI_D, DecodeIdx: 140
/* 19083 */   MCD::OPC_FilterValue, 204, 1, 51, 0, // Skip to: 19139
/* 19088 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 19091 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19132
/* 19095 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19098 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19125
/* 19102 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 19105 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19118
/* 19109 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 19113 */   MCD::OPC_Decode, 166, 18, 138, 1, // Opcode: XVSRLI_B, DecodeIdx: 138
/* 19118 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19120 */   MCD::OPC_Decode, 168, 18, 139, 1, // Opcode: XVSRLI_H, DecodeIdx: 139
/* 19125 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19127 */   MCD::OPC_Decode, 169, 18, 133, 1, // Opcode: XVSRLI_W, DecodeIdx: 133
/* 19132 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19134 */   MCD::OPC_Decode, 167, 18, 140, 1, // Opcode: XVSRLI_D, DecodeIdx: 140
/* 19139 */   MCD::OPC_FilterValue, 205, 1, 51, 0, // Skip to: 19195
/* 19144 */   MCD::OPC_ExtractField, 16, 2,  // Inst{17-16} ...
/* 19147 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19188
/* 19151 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19154 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19181
/* 19158 */   MCD::OPC_ExtractField, 14, 1,  // Inst{14} ...
/* 19161 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19174
/* 19165 */   MCD::OPC_CheckFieldOrFail, 13, 1, 1, 
/* 19169 */   MCD::OPC_Decode, 136, 18, 138, 1, // Opcode: XVSRAI_B, DecodeIdx: 138
/* 19174 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19176 */   MCD::OPC_Decode, 138, 18, 139, 1, // Opcode: XVSRAI_H, DecodeIdx: 139
/* 19181 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19183 */   MCD::OPC_Decode, 139, 18, 133, 1, // Opcode: XVSRAI_W, DecodeIdx: 133
/* 19188 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19190 */   MCD::OPC_Decode, 137, 18, 140, 1, // Opcode: XVSRAI_D, DecodeIdx: 140
/* 19195 */   MCD::OPC_FilterValue, 208, 1, 51, 0, // Skip to: 19251
/* 19200 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19203 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19244
/* 19207 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19210 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19237
/* 19214 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19217 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19230
/* 19221 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19225 */   MCD::OPC_Decode, 170, 18, 149, 1, // Opcode: XVSRLNI_B_H, DecodeIdx: 149
/* 19230 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19232 */   MCD::OPC_Decode, 172, 18, 134, 1, // Opcode: XVSRLNI_H_W, DecodeIdx: 134
/* 19237 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19239 */   MCD::OPC_Decode, 173, 18, 150, 1, // Opcode: XVSRLNI_W_D, DecodeIdx: 150
/* 19244 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19246 */   MCD::OPC_Decode, 171, 18, 151, 1, // Opcode: XVSRLNI_D_Q, DecodeIdx: 151
/* 19251 */   MCD::OPC_FilterValue, 209, 1, 51, 0, // Skip to: 19307
/* 19256 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19259 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19300
/* 19263 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19266 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19293
/* 19270 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19273 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19286
/* 19277 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19281 */   MCD::OPC_Decode, 181, 18, 149, 1, // Opcode: XVSRLRNI_B_H, DecodeIdx: 149
/* 19286 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19288 */   MCD::OPC_Decode, 183, 18, 134, 1, // Opcode: XVSRLRNI_H_W, DecodeIdx: 134
/* 19293 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19295 */   MCD::OPC_Decode, 184, 18, 150, 1, // Opcode: XVSRLRNI_W_D, DecodeIdx: 150
/* 19300 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19302 */   MCD::OPC_Decode, 182, 18, 151, 1, // Opcode: XVSRLRNI_D_Q, DecodeIdx: 151
/* 19307 */   MCD::OPC_FilterValue, 210, 1, 51, 0, // Skip to: 19363
/* 19312 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19315 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19356
/* 19319 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19322 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19349
/* 19326 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19329 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19342
/* 19333 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19337 */   MCD::OPC_Decode, 225, 18, 149, 1, // Opcode: XVSSRLNI_B_H, DecodeIdx: 149
/* 19342 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19344 */   MCD::OPC_Decode, 229, 18, 134, 1, // Opcode: XVSSRLNI_H_W, DecodeIdx: 134
/* 19349 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19351 */   MCD::OPC_Decode, 231, 18, 150, 1, // Opcode: XVSSRLNI_W_D, DecodeIdx: 150
/* 19356 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19358 */   MCD::OPC_Decode, 227, 18, 151, 1, // Opcode: XVSSRLNI_D_Q, DecodeIdx: 151
/* 19363 */   MCD::OPC_FilterValue, 211, 1, 51, 0, // Skip to: 19419
/* 19368 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19371 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19412
/* 19375 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19378 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19405
/* 19382 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19385 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19398
/* 19389 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19393 */   MCD::OPC_Decode, 224, 18, 149, 1, // Opcode: XVSSRLNI_BU_H, DecodeIdx: 149
/* 19398 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19400 */   MCD::OPC_Decode, 228, 18, 134, 1, // Opcode: XVSSRLNI_HU_W, DecodeIdx: 134
/* 19405 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19407 */   MCD::OPC_Decode, 230, 18, 150, 1, // Opcode: XVSSRLNI_WU_D, DecodeIdx: 150
/* 19412 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19414 */   MCD::OPC_Decode, 226, 18, 151, 1, // Opcode: XVSSRLNI_DU_Q, DecodeIdx: 151
/* 19419 */   MCD::OPC_FilterValue, 212, 1, 51, 0, // Skip to: 19475
/* 19424 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19427 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19468
/* 19431 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19434 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19461
/* 19438 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19441 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19454
/* 19445 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19449 */   MCD::OPC_Decode, 239, 18, 149, 1, // Opcode: XVSSRLRNI_B_H, DecodeIdx: 149
/* 19454 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19456 */   MCD::OPC_Decode, 243, 18, 134, 1, // Opcode: XVSSRLRNI_H_W, DecodeIdx: 134
/* 19461 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19463 */   MCD::OPC_Decode, 245, 18, 150, 1, // Opcode: XVSSRLRNI_W_D, DecodeIdx: 150
/* 19468 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19470 */   MCD::OPC_Decode, 241, 18, 151, 1, // Opcode: XVSSRLRNI_D_Q, DecodeIdx: 151
/* 19475 */   MCD::OPC_FilterValue, 213, 1, 51, 0, // Skip to: 19531
/* 19480 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19483 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19524
/* 19487 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19490 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19517
/* 19494 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19497 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19510
/* 19501 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19505 */   MCD::OPC_Decode, 238, 18, 149, 1, // Opcode: XVSSRLRNI_BU_H, DecodeIdx: 149
/* 19510 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19512 */   MCD::OPC_Decode, 242, 18, 134, 1, // Opcode: XVSSRLRNI_HU_W, DecodeIdx: 134
/* 19517 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19519 */   MCD::OPC_Decode, 244, 18, 150, 1, // Opcode: XVSSRLRNI_WU_D, DecodeIdx: 150
/* 19524 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19526 */   MCD::OPC_Decode, 240, 18, 151, 1, // Opcode: XVSSRLRNI_DU_Q, DecodeIdx: 151
/* 19531 */   MCD::OPC_FilterValue, 214, 1, 51, 0, // Skip to: 19587
/* 19536 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19539 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19580
/* 19543 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19546 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19573
/* 19550 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19553 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19566
/* 19557 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19561 */   MCD::OPC_Decode, 140, 18, 149, 1, // Opcode: XVSRANI_B_H, DecodeIdx: 149
/* 19566 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19568 */   MCD::OPC_Decode, 142, 18, 134, 1, // Opcode: XVSRANI_H_W, DecodeIdx: 134
/* 19573 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19575 */   MCD::OPC_Decode, 143, 18, 150, 1, // Opcode: XVSRANI_W_D, DecodeIdx: 150
/* 19580 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19582 */   MCD::OPC_Decode, 141, 18, 151, 1, // Opcode: XVSRANI_D_Q, DecodeIdx: 151
/* 19587 */   MCD::OPC_FilterValue, 215, 1, 51, 0, // Skip to: 19643
/* 19592 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19595 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19636
/* 19599 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19602 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19629
/* 19606 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19609 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19622
/* 19613 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19617 */   MCD::OPC_Decode, 151, 18, 149, 1, // Opcode: XVSRARNI_B_H, DecodeIdx: 149
/* 19622 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19624 */   MCD::OPC_Decode, 153, 18, 134, 1, // Opcode: XVSRARNI_H_W, DecodeIdx: 134
/* 19629 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19631 */   MCD::OPC_Decode, 154, 18, 150, 1, // Opcode: XVSRARNI_W_D, DecodeIdx: 150
/* 19636 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19638 */   MCD::OPC_Decode, 152, 18, 151, 1, // Opcode: XVSRARNI_D_Q, DecodeIdx: 151
/* 19643 */   MCD::OPC_FilterValue, 216, 1, 51, 0, // Skip to: 19699
/* 19648 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19651 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19692
/* 19655 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19658 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19685
/* 19662 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19665 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19678
/* 19669 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19673 */   MCD::OPC_Decode, 197, 18, 149, 1, // Opcode: XVSSRANI_B_H, DecodeIdx: 149
/* 19678 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19680 */   MCD::OPC_Decode, 201, 18, 134, 1, // Opcode: XVSSRANI_H_W, DecodeIdx: 134
/* 19685 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19687 */   MCD::OPC_Decode, 203, 18, 150, 1, // Opcode: XVSSRANI_W_D, DecodeIdx: 150
/* 19692 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19694 */   MCD::OPC_Decode, 199, 18, 151, 1, // Opcode: XVSSRANI_D_Q, DecodeIdx: 151
/* 19699 */   MCD::OPC_FilterValue, 217, 1, 51, 0, // Skip to: 19755
/* 19704 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19707 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19748
/* 19711 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19714 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19741
/* 19718 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19721 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19734
/* 19725 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19729 */   MCD::OPC_Decode, 196, 18, 149, 1, // Opcode: XVSSRANI_BU_H, DecodeIdx: 149
/* 19734 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19736 */   MCD::OPC_Decode, 200, 18, 134, 1, // Opcode: XVSSRANI_HU_W, DecodeIdx: 134
/* 19741 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19743 */   MCD::OPC_Decode, 202, 18, 150, 1, // Opcode: XVSSRANI_WU_D, DecodeIdx: 150
/* 19748 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19750 */   MCD::OPC_Decode, 198, 18, 151, 1, // Opcode: XVSSRANI_DU_Q, DecodeIdx: 151
/* 19755 */   MCD::OPC_FilterValue, 218, 1, 51, 0, // Skip to: 19811
/* 19760 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19763 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19804
/* 19767 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19770 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19797
/* 19774 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19777 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19790
/* 19781 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19785 */   MCD::OPC_Decode, 211, 18, 149, 1, // Opcode: XVSSRARNI_B_H, DecodeIdx: 149
/* 19790 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19792 */   MCD::OPC_Decode, 215, 18, 134, 1, // Opcode: XVSSRARNI_H_W, DecodeIdx: 134
/* 19797 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19799 */   MCD::OPC_Decode, 217, 18, 150, 1, // Opcode: XVSSRARNI_W_D, DecodeIdx: 150
/* 19804 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19806 */   MCD::OPC_Decode, 213, 18, 151, 1, // Opcode: XVSSRARNI_D_Q, DecodeIdx: 151
/* 19811 */   MCD::OPC_FilterValue, 219, 1, 51, 0, // Skip to: 19867
/* 19816 */   MCD::OPC_ExtractField, 17, 1,  // Inst{17} ...
/* 19819 */   MCD::OPC_FilterValue, 0, 37, 0, // Skip to: 19860
/* 19823 */   MCD::OPC_ExtractField, 16, 1,  // Inst{16} ...
/* 19826 */   MCD::OPC_FilterValue, 0, 23, 0, // Skip to: 19853
/* 19830 */   MCD::OPC_ExtractField, 15, 1,  // Inst{15} ...
/* 19833 */   MCD::OPC_FilterValue, 0, 9, 0, // Skip to: 19846
/* 19837 */   MCD::OPC_CheckFieldOrFail, 14, 1, 1, 
/* 19841 */   MCD::OPC_Decode, 210, 18, 149, 1, // Opcode: XVSSRARNI_BU_H, DecodeIdx: 149
/* 19846 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19848 */   MCD::OPC_Decode, 214, 18, 134, 1, // Opcode: XVSSRARNI_HU_W, DecodeIdx: 134
/* 19853 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19855 */   MCD::OPC_Decode, 216, 18, 150, 1, // Opcode: XVSSRARNI_WU_D, DecodeIdx: 150
/* 19860 */   MCD::OPC_FilterValueOrFail, 1, 
/* 19862 */   MCD::OPC_Decode, 212, 18, 151, 1, // Opcode: XVSSRARNI_DU_Q, DecodeIdx: 151
/* 19867 */   MCD::OPC_FilterValue, 224, 1, 5, 0, // Skip to: 19877
/* 19872 */   MCD::OPC_Decode, 201, 14, 152, 1, // Opcode: XVEXTRINS_D, DecodeIdx: 152
/* 19877 */   MCD::OPC_FilterValue, 225, 1, 5, 0, // Skip to: 19887
/* 19882 */   MCD::OPC_Decode, 203, 14, 152, 1, // Opcode: XVEXTRINS_W, DecodeIdx: 152
/* 19887 */   MCD::OPC_FilterValue, 226, 1, 5, 0, // Skip to: 19897
/* 19892 */   MCD::OPC_Decode, 202, 14, 152, 1, // Opcode: XVEXTRINS_H, DecodeIdx: 152
/* 19897 */   MCD::OPC_FilterValue, 227, 1, 5, 0, // Skip to: 19907
/* 19902 */   MCD::OPC_Decode, 200, 14, 152, 1, // Opcode: XVEXTRINS_B, DecodeIdx: 152
/* 19907 */   MCD::OPC_FilterValue, 228, 1, 5, 0, // Skip to: 19917
/* 19912 */   MCD::OPC_Decode, 206, 17, 153, 1, // Opcode: XVSHUF4I_B, DecodeIdx: 153
/* 19917 */   MCD::OPC_FilterValue, 229, 1, 5, 0, // Skip to: 19927
/* 19922 */   MCD::OPC_Decode, 208, 17, 153, 1, // Opcode: XVSHUF4I_H, DecodeIdx: 153
/* 19927 */   MCD::OPC_FilterValue, 230, 1, 5, 0, // Skip to: 19937
/* 19932 */   MCD::OPC_Decode, 209, 17, 153, 1, // Opcode: XVSHUF4I_W, DecodeIdx: 153
/* 19937 */   MCD::OPC_FilterValue, 231, 1, 5, 0, // Skip to: 19947
/* 19942 */   MCD::OPC_Decode, 207, 17, 152, 1, // Opcode: XVSHUF4I_D, DecodeIdx: 152
/* 19947 */   MCD::OPC_FilterValue, 241, 1, 5, 0, // Skip to: 19957
/* 19952 */   MCD::OPC_Decode, 162, 14, 152, 1, // Opcode: XVBITSELI_B, DecodeIdx: 152
/* 19957 */   MCD::OPC_FilterValue, 244, 1, 5, 0, // Skip to: 19967
/* 19962 */   MCD::OPC_Decode, 255, 13, 153, 1, // Opcode: XVANDI_B, DecodeIdx: 153
/* 19967 */   MCD::OPC_FilterValue, 245, 1, 5, 0, // Skip to: 19977
/* 19972 */   MCD::OPC_Decode, 242, 16, 153, 1, // Opcode: XVORI_B, DecodeIdx: 153
/* 19977 */   MCD::OPC_FilterValue, 246, 1, 5, 0, // Skip to: 19987
/* 19982 */   MCD::OPC_Decode, 163, 19, 153, 1, // Opcode: XVXORI_B, DecodeIdx: 153
/* 19987 */   MCD::OPC_FilterValue, 247, 1, 5, 0, // Skip to: 19997
/* 19992 */   MCD::OPC_Decode, 240, 16, 153, 1, // Opcode: XVNORI_B, DecodeIdx: 153
/* 19997 */   MCD::OPC_FilterValue, 248, 1, 5, 0, // Skip to: 20007
/* 20002 */   MCD::OPC_Decode, 244, 15, 154, 1, // Opcode: XVLDI, DecodeIdx: 154
/* 20007 */   MCD::OPC_FilterValue, 249, 1, 5, 0, // Skip to: 20017
/* 20012 */   MCD::OPC_Decode, 131, 17, 152, 1, // Opcode: XVPERMI_W, DecodeIdx: 152
/* 20017 */   MCD::OPC_FilterValue, 250, 1, 5, 0, // Skip to: 20027
/* 20022 */   MCD::OPC_Decode, 129, 17, 153, 1, // Opcode: XVPERMI_D, DecodeIdx: 153
/* 20027 */   MCD::OPC_FilterValueOrFail, 251, 1, 
/* 20030 */   MCD::OPC_Decode, 130, 17, 152, 1, // Opcode: XVPERMI_Q, DecodeIdx: 152
/* 20035 */   MCD::OPC_Fail,
  0
};

static bool checkDecoderPredicate(unsigned Idx, const FeatureBitset &Bits) {
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    return (Bits[LoongArch::Feature64Bit]);
  }
}

// Handling 155 cases.
template <typename InsnType>
static DecodeStatus decodeToMCInst(unsigned Idx, DecodeStatus S, InsnType insn, MCInst &MI, uint64_t Address, const MCDisassembler *Decoder, bool &DecodeComplete) {
  DecodeComplete = true;
  using TmpType = std::conditional_t<std::is_integral<InsnType>::value, InsnType, uint64_t>;
  TmpType tmp;
  switch (Idx) {
  default: llvm_unreachable("Invalid index!");
  case 0:
    tmp = fieldFromInstruction(insn, 0, 2);
    if (!Check(S, DecodeSCRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 1:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 2);
    if (!Check(S, DecodeSCRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 2:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 3:
    tmp = fieldFromInstruction(insn, 5, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 4:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 5:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 6:
    return S;
  case 7:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 8:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 2);
    if (!Check(S, decodeUImmOperand<2, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 9:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 10:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 11:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 12:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, decodeSImmOperand<5>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 13:
    tmp = fieldFromInstruction(insn, 0, 15);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 14:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 15:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 16:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 17:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 0, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 18:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 19:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 20:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 21:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 22:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 23:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 24:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 25:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 26:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 27:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 28:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 29:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 30:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 16, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 31:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 32:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 33:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 34:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 35:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 36:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 37:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 38:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 39:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 40:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFCSRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 41:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFCSRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 42:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 43:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 44:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 45:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 46:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 47:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 48:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 49:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeUImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 50:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 14);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 51:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 14);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 52:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRNoR0R1RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 14);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 53:
    tmp = fieldFromInstruction(insn, 0, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 54:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 55:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 56:
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 57:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 58:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 59:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 60:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 61:
    tmp = fieldFromInstruction(insn, 0, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 62:
    tmp = fieldFromInstruction(insn, 0, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 63:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 64:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 65:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 15, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 66:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 16);
    if (!Check(S, decodeSImmOperand<16>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 67:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 20);
    if (!Check(S, decodeSImmOperand<20>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 68:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 20);
    if (!Check(S, decodeSImmOperand<20>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 69:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 14);
    if (!Check(S, decodeSImmOperand<14, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 70:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 14);
    if (!Check(S, decodeSImmOperand<14, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 71:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 72:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 73:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 74:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 12);
    if (!Check(S, decodeSImmOperand<12>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 75:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 9);
    if (!Check(S, decodeSImmOperand<9, 3>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 76:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 10);
    if (!Check(S, decodeSImmOperand<10, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 77:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 11);
    if (!Check(S, decodeSImmOperand<11, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 78:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8, 3>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 79:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 80:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 81:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 82:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 9);
    if (!Check(S, decodeSImmOperand<9, 3>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 83:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 10);
    if (!Check(S, decodeSImmOperand<10, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 84:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 11);
    if (!Check(S, decodeSImmOperand<11, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 85:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8, 3>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 86:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 87:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8, 1>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 88:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    if (!Check(S, decodeSImmOperand<8>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 18, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 89:
    tmp = fieldFromInstruction(insn, 0, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 90:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR32RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 91:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeFPR64RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 92:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 93:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 94:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 95:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 96:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 97:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 5), 16, 5);
    insertBits(tmp, fieldFromInstruction(insn, 10, 16), 0, 16);
    if (!Check(S, decodeSImmOperand<21, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 98:
    tmp = fieldFromInstruction(insn, 5, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 5), 16, 5);
    insertBits(tmp, fieldFromInstruction(insn, 10, 16), 0, 16);
    if (!Check(S, decodeSImmOperand<21, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 99:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 5), 16, 5);
    insertBits(tmp, fieldFromInstruction(insn, 10, 16), 0, 16);
    if (!Check(S, decodeSImmOperand<21, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 100:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 16);
    if (!Check(S, decodeSImmOperand<16, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 101:
    tmp = 0x0;
    insertBits(tmp, fieldFromInstruction(insn, 0, 10), 16, 10);
    insertBits(tmp, fieldFromInstruction(insn, 10, 16), 0, 16);
    if (!Check(S, decodeSImmOperand<26, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 102:
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 16);
    if (!Check(S, decodeSImmOperand<16, 2>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 103:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 104:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 105:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, decodeSImmOperand<5>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 106:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 107:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 108:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 109:
    tmp = fieldFromInstruction(insn, 0, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 110:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 111:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 112:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 113:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 114:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 115:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 116:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 117:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 118:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 119:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 120:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 121:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 122:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 123:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 124:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 125:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 126:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 7);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 127:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 128:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 129:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLSX128RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 13);
    if (!Check(S, decodeSImmOperand<13>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 130:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 131:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 132:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    if (!Check(S, decodeSImmOperand<5>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 133:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 134:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 5);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 135:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 136:
    tmp = fieldFromInstruction(insn, 0, 3);
    if (!Check(S, DecodeCFRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 137:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  case 138:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 139:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 140:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 141:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 142:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 143:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 144:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeGPRRegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 145:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 146:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 1);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 147:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 3);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 148:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 2);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 149:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 4);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 150:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 6);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 151:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 7);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 152:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 153:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 10, 8);
    MI.addOperand(MCOperand::createImm(tmp));
    return S;
  case 154:
    tmp = fieldFromInstruction(insn, 0, 5);
    if (!Check(S, DecodeLASX256RegisterClass(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    tmp = fieldFromInstruction(insn, 5, 13);
    if (!Check(S, decodeSImmOperand<13>(MI, tmp, Address, Decoder))) { return MCDisassembler::Fail; }
    return S;
  }
}

static unsigned decodeNumToSkip(const uint8_t *&Ptr) {
  unsigned NumToSkip = *Ptr++;
  NumToSkip |= (*Ptr++) << 8;
  return NumToSkip;
}

template <typename InsnType>
static DecodeStatus decodeInstruction(const uint8_t DecodeTable[], MCInst &MI,
                                      InsnType insn, uint64_t Address,
                                      const MCDisassembler *DisAsm,
                                      const MCSubtargetInfo &STI) {
  const FeatureBitset &Bits = STI.getFeatureBits();

  const uint8_t *Ptr = DecodeTable;
  uint64_t CurFieldValue = 0;
  DecodeStatus S = MCDisassembler::Success;
  while (true) {
    ptrdiff_t Loc = Ptr - DecodeTable;
    const uint8_t DecoderOp = *Ptr++;
    switch (DecoderOp) {
    default:
      errs() << Loc << ": Unexpected decode table opcode: "
             << (int)DecoderOp << '\n';
      return MCDisassembler::Fail;
    case MCD::OPC_ExtractField: {
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr++;
      CurFieldValue = fieldFromInstruction(insn, Start, Len);
      LLVM_DEBUG(dbgs() << Loc << ": OPC_ExtractField(" << Start << ", "
                   << Len << "): " << CurFieldValue << "\n");
      break;
    }
    case MCD::OPC_FilterValue:
    case MCD::OPC_FilterValueOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_FilterValueOrFail;
      // Decode the field value.
      uint64_t Val = decodeULEB128AndIncUnsafe(Ptr);
      bool Failed = Val != CurFieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      // Note: Print NumToSkip even for OPC_FilterValueOrFail to simplify debug
      // prints.
      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_FilterValueOrFail" : "OPC_FilterValue";
        dbgs() << Loc << ": " << OpName << '(' << Val << ", " << NumToSkip
                << ") " << (Failed ? "FAIL:" : "PASS:")
                << " continuing at " << (Ptr - DecodeTable) << '\n';
      });

      // Perform the filter operation.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckField:
    case MCD::OPC_CheckFieldOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckFieldOrFail;
      // Decode the start value.
      unsigned Start = decodeULEB128AndIncUnsafe(Ptr);
      unsigned Len = *Ptr;
      uint64_t FieldValue = fieldFromInstruction(insn, Start, Len);
      // Decode the field value.
      unsigned PtrLen = 0;
      uint64_t ExpectedValue = decodeULEB128(++Ptr, &PtrLen);
      Ptr += PtrLen;
      bool Failed = ExpectedValue != FieldValue;
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckFieldOrFail" : "OPC_CheckField";
        dbgs() << Loc << ": " << OpName << '(' << Start << ", " << Len << ", "
                << ExpectedValue << ", " << NumToSkip << "): FieldValue = "
                << FieldValue << ", ExpectedValue = " << ExpectedValue << ": "
                << (Failed ? "FAIL\n" : "PASS\n");
      });

      // If the actual and expected values don't match, skip or fail.
      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_CheckPredicate:
    case MCD::OPC_CheckPredicateOrFail: {
      bool IsFail = DecoderOp == MCD::OPC_CheckPredicateOrFail;
      // Decode the Predicate Index value.
      unsigned PIdx = decodeULEB128AndIncUnsafe(Ptr);
      unsigned NumToSkip = IsFail ? 0 : decodeNumToSkip(Ptr);
      // Check the predicate.
      bool Failed = !checkDecoderPredicate(PIdx, Bits);

      LLVM_DEBUG({
        StringRef OpName = IsFail ? "OPC_CheckPredicateOrFail" : "OPC_CheckPredicate";
        dbgs() << Loc << ": " << OpName << '(' << PIdx << ", " << NumToSkip
               << "): " << (Failed ? "FAIL\n" : "PASS\n");
      });

      if (Failed) {
        if (IsFail)
          return MCDisassembler::Fail;
        Ptr += NumToSkip;
      }
      break;
    }
    case MCD::OPC_Decode: {
      // Decode the Opcode value.
      unsigned Opc = decodeULEB128AndIncUnsafe(Ptr);
      unsigned DecodeIdx = decodeULEB128AndIncUnsafe(Ptr);

      MI.clear();
      MI.setOpcode(Opc);
      bool DecodeComplete;
      S = decodeToMCInst(DecodeIdx, S, insn, MI, Address, DisAsm, DecodeComplete);
      assert(DecodeComplete);

      LLVM_DEBUG(dbgs() << Loc << ": OPC_Decode: opcode " << Opc
                   << ", using decoder " << DecodeIdx << ": "
                   << (S != MCDisassembler::Fail ? "PASS\n" : "FAIL\n"));
      return S;
    }
    case MCD::OPC_Fail: {
      LLVM_DEBUG(dbgs() << Loc << ": OPC_Fail\n");
      return MCDisassembler::Fail;
    }
    }
  }
  llvm_unreachable("bogosity detected in disassembler state machine!");
}


} // namespace
