/*===- TableGen'erated file -------------------------------------*- C++ -*-===*\
|*                                                                            *|
|* Global Instruction Selector for the SPIRV target                           *|
|*                                                                            *|
|* Automatically generated file, do not edit!                                 *|
|*                                                                            *|
\*===----------------------------------------------------------------------===*/

#ifdef GET_GLOBALISEL_PREDICATE_BITSET
const unsigned MAX_SUBTARGET_PREDICATES = 0;
using PredicateBitset = llvm::Bitset<MAX_SUBTARGET_PREDICATES>;
#endif // ifdef GET_GLOBALISEL_PREDICATE_BITSET

#ifdef GET_GLOBALISEL_TEMPORARIES_DECL
  mutable MatcherState State;
  typedef ComplexRendererFns(SPIRVInstructionSelector::*ComplexMatcherMemFn)(MachineOperand &) const;
  typedef void(SPIRVInstructionSelector::*CustomRendererFn)(MachineInstrBuilder &, const MachineInstr &, int) const;
  const ExecInfoTy<PredicateBitset, ComplexMatcherMemFn, CustomRendererFn> ExecInfo;
  static SPIRVInstructionSelector::ComplexMatcherMemFn ComplexPredicateFns[];
  static SPIRVInstructionSelector::CustomRendererFn CustomRenderers[];
  bool testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const override;
  bool testImmPredicate_APInt(unsigned PredicateID, const APInt &Imm) const override;
  bool testImmPredicate_APFloat(unsigned PredicateID, const APFloat &Imm) const override;
  const uint8_t *getMatchTable() const override;
  bool testMIPredicate_MI(unsigned PredicateID, const MachineInstr &MI, const MatcherState &State) const override;
  bool testMOPredicate_MO(unsigned PredicateID, const MachineOperand &MO, const MatcherState &State) const override;
  bool testSimplePredicate(unsigned PredicateID) const override;
  bool runCustomAction(unsigned FnID, const MatcherState &State, NewMIVector &OutMIs) const override;
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_DECL

#ifdef GET_GLOBALISEL_TEMPORARIES_INIT
, State(0),
ExecInfo(TypeObjects, NumTypeObjects, FeatureBitsets, ComplexPredicateFns, CustomRenderers)
#endif // ifdef GET_GLOBALISEL_TEMPORARIES_INIT

#ifdef GET_GLOBALISEL_IMPL
// LLT Objects.
enum {
  GILLT_p0s64,
  GILLT_s64,
  GILLT_v2s64,
};
const static size_t NumTypeObjects = 3;
const static LLT TypeObjects[] = {
  LLT::pointer(0, 64),
  LLT::scalar(64),
  LLT::vector(ElementCount::getFixed(2), 64),
};

// Bits for subtarget features that participate in instruction matching.
enum SubtargetFeatureBits : uint8_t {
};

PredicateBitset SPIRVInstructionSelector::
computeAvailableModuleFeatures(const SPIRVSubtarget *Subtarget) const {
  PredicateBitset Features{};
  return Features;
}

void SPIRVInstructionSelector::setupGeneratedPerFunctionState(MachineFunction &MF) {
  AvailableFunctionFeatures = computeAvailableFunctionFeatures((const SPIRVSubtarget *)&MF.getSubtarget(), &MF);
}
PredicateBitset SPIRVInstructionSelector::
computeAvailableFunctionFeatures(const SPIRVSubtarget *Subtarget, const MachineFunction *MF) const {
  PredicateBitset Features{};
  return Features;
}

// Feature bitsets.
enum {
  GIFBS_Invalid,
};
constexpr static PredicateBitset FeatureBitsets[] {
  {}, // GIFBS_Invalid
};

// ComplexPattern predicates.
enum {
  GICP_Invalid,
};
// See constructor for table contents

SPIRVInstructionSelector::ComplexMatcherMemFn
SPIRVInstructionSelector::ComplexPredicateFns[] = {
  nullptr, // GICP_Invalid
};

// PatFrag predicates.
enum {
  GICXXPred_MI_Predicate_or_disjoint = GICXXPred_Invalid + 1,
};
bool SPIRVInstructionSelector::testMIPredicate_MI(unsigned PredicateID, const MachineInstr & MI, const MatcherState &State) const {
  const MachineFunction &MF = *MI.getParent()->getParent();
  const MachineRegisterInfo &MRI = MF.getRegInfo();
  const auto &Operands = State.RecordedOperands;
  (void)Operands;
  (void)MRI;
  switch (PredicateID) {
  case GICXXPred_MI_Predicate_or_disjoint: {
    
        return MI.getFlag(MachineInstr::Disjoint);
      
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool SPIRVInstructionSelector::testMOPredicate_MO(unsigned PredicateID, const MachineOperand & MO, const MatcherState &State) const {
  const auto &Operands = State.RecordedOperands;
  Register Reg = MO.getReg();
  (void)Operands;
  (void)Reg;
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool SPIRVInstructionSelector::testImmPredicate_I64(unsigned PredicateID, int64_t Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
bool SPIRVInstructionSelector::testImmPredicate_APFloat(unsigned PredicateID, const APFloat & Imm) const {
  llvm_unreachable("Unknown predicate");
  return false;
}
// PatFrag predicates.
enum {
  GICXXPred_APInt_Predicate_ConstPseudoFalse = GICXXPred_Invalid + 1,
  GICXXPred_APInt_Predicate_ConstPseudoTrue,
};
bool SPIRVInstructionSelector::testImmPredicate_APInt(unsigned PredicateID, const APInt & Imm) const {
  switch (PredicateID) {
  case GICXXPred_APInt_Predicate_ConstPseudoFalse: {
     return Imm.getBitWidth() == 1 && Imm.getZExtValue() == 0; 
  }
  case GICXXPred_APInt_Predicate_ConstPseudoTrue: {
     return Imm.getBitWidth() == 1 && Imm.getZExtValue() == 1; 
  }
  }
  llvm_unreachable("Unknown predicate");
  return false;
}
bool SPIRVInstructionSelector::testSimplePredicate(unsigned) const {
    llvm_unreachable("SPIRVInstructionSelector does not support simple predicates!");
  return false;
}
// Custom renderers.
enum {
  GICR_Invalid,
};
SPIRVInstructionSelector::CustomRendererFn
SPIRVInstructionSelector::CustomRenderers[] = {
  nullptr, // GICR_Invalid
};

bool SPIRVInstructionSelector::selectImpl(MachineInstr &I, CodeGenCoverage &CoverageInfo) const {
  const PredicateBitset AvailableFeatures = getAvailableFeatures();
  MachineIRBuilder B(I);
  State.MIs.clear();
  State.MIs.push_back(&I);

  if (executeMatchTable(*this, State, ExecInfo, B, getMatchTable(), TII, MF->getRegInfo(), TRI, RBI, AvailableFeatures, &CoverageInfo)) {
    return true;
  }

  return false;
}

bool SPIRVInstructionSelector::runCustomAction(unsigned, const MatcherState&, NewMIVector &) const {
    llvm_unreachable("SPIRVInstructionSelector does not support custom C++ actions!");
}
#if __BYTE_ORDER__ == __ORDER_LITTLE_ENDIAN__
#define GIMT_Encode2(Val) uint8_t(Val), uint8_t((uint16_t)Val >> 8)
#define GIMT_Encode4(Val) uint8_t(Val), uint8_t((uint32_t)Val >> 8), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 24)
#define GIMT_Encode8(Val) uint8_t(Val), uint8_t((uint64_t)Val >> 8), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 24),  uint8_t((uint64_t)Val >> 32), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 56)
#else
#define GIMT_Encode2(Val) uint8_t((uint16_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode4(Val) uint8_t((uint32_t)Val >> 24), uint8_t((uint32_t)Val >> 16), uint8_t((uint32_t)Val >> 8), uint8_t(Val)
#define GIMT_Encode8(Val) uint8_t((uint64_t)Val >> 56), uint8_t((uint64_t)Val >> 48), uint8_t((uint64_t)Val >> 40), uint8_t((uint64_t)Val >> 32),  uint8_t((uint64_t)Val >> 24), uint8_t((uint64_t)Val >> 16), uint8_t((uint64_t)Val >> 8), uint8_t(Val)
#endif
const uint8_t *SPIRVInstructionSelector::getMatchTable() const {
  constexpr static uint8_t MatchTable0[] = {
     /*    0 */ GIM_Try, /*On fail goto*//*Label 0*/ GIMT_Encode4(3746),
     /*    5 */   GIM_CheckOpcode, /*MI*/0, GIMT_Encode2(SPIRV::ASSIGN_TYPE),
     /*    9 */   GIM_SwitchType, /*MI*/0, /*Op*/0, /*[*/GIMT_Encode2(0), GIMT_Encode2(3), /*)*//*default:*//*Label 4*/ GIMT_Encode4(3745),
     /*   20 */   /*GILLT_p0s64*//*Label 1*/ GIMT_Encode4(32),
     /*   24 */   /*GILLT_s64*//*Label 2*/ GIMT_Encode4(179),
     /*   28 */   /*GILLT_v2s64*//*Label 3*/ GIMT_Encode4(2069),
     /*   32 */   // Label 1: @32
     /*   32 */   GIM_Try, /*On fail goto*//*Label 5*/ GIMT_Encode4(178),
     /*   37 */     GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_p0s64,
     /*   40 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*   43 */     GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::pIDRegClassID),
     /*   47 */     GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*   51 */     GIM_Try, /*On fail goto*//*Label 6*/ GIMT_Encode4(114), // Rule ID 54 //
     /*   56 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*   60 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*   64 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*   68 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_p0s64,
     /*   72 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_p0s64,
     /*   76 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*   81 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::pIDRegClassID),
     /*   86 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::pIDRegClassID),
     /*   91 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*   93 */       // (assigntype:{ *:[i64] } (select:{ *:[i64] } iID:{ *:[i64] }:$cond, pID:{ *:[i64] }:$src1, pID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSPSCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, pID:{ *:[i64] }:$src1, pID:{ *:[i64] }:$src2)
     /*   93 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSPSCond),
     /*   96 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*   98 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  100 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /*  104 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  108 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /*  112 */       GIR_RootConstrainSelectedInstOperands,
     /*  113 */       // GIR_Coverage, 54,
     /*  113 */       GIR_EraseRootFromParent_Done,
     /*  114 */     // Label 6: @114
     /*  114 */     GIM_Try, /*On fail goto*//*Label 7*/ GIMT_Encode4(177), // Rule ID 55 //
     /*  119 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  123 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  127 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  131 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_p0s64,
     /*  135 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_p0s64,
     /*  139 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /*  144 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::pIDRegClassID),
     /*  149 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::pIDRegClassID),
     /*  154 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  156 */       // (assigntype:{ *:[i64] } (select:{ *:[i64] } vID:{ *:[v2i64] }:$cond, pID:{ *:[i64] }:$src1, pID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSPVCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, pID:{ *:[i64] }:$src1, pID:{ *:[i64] }:$src2)
     /*  156 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSPVCond),
     /*  159 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  161 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  163 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /*  167 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  171 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /*  175 */       GIR_RootConstrainSelectedInstOperands,
     /*  176 */       // GIR_Coverage, 55,
     /*  176 */       GIR_EraseRootFromParent_Done,
     /*  177 */     // Label 7: @177
     /*  177 */     GIM_Reject,
     /*  178 */   // Label 5: @178
     /*  178 */   GIM_Reject,
     /*  179 */   // Label 2: @179
     /*  179 */   GIM_Try, /*On fail goto*//*Label 8*/ GIMT_Encode4(2068),
     /*  184 */     GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_s64,
     /*  187 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /*  190 */     GIM_Try, /*On fail goto*//*Label 9*/ GIMT_Encode4(226), // Rule ID 0 //
     /*  195 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  199 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  203 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  207 */       GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_ConstPseudoTrue),
     /*  211 */       // MIs[1] Operand 1
     /*  211 */       // No operand predicates
     /*  211 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  215 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  217 */       // (assigntype:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_ConstPseudoTrue>>, TYPE:{ *:[i64] }:$src_ty)  =>  (OpConstantTrue:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty)
     /*  217 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpConstantTrue),
     /*  220 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  222 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  224 */       GIR_RootConstrainSelectedInstOperands,
     /*  225 */       // GIR_Coverage, 0,
     /*  225 */       GIR_EraseRootFromParent_Done,
     /*  226 */     // Label 9: @226
     /*  226 */     GIM_Try, /*On fail goto*//*Label 10*/ GIMT_Encode4(262), // Rule ID 1 //
     /*  231 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  235 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  239 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_CONSTANT),
     /*  243 */       GIM_CheckAPIntImmPredicate, /*MI*/1, /*Predicate*/GIMT_Encode2(GICXXPred_APInt_Predicate_ConstPseudoFalse),
     /*  247 */       // MIs[1] Operand 1
     /*  247 */       // No operand predicates
     /*  247 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  251 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  253 */       // (assigntype:{ *:[i64] } (imm:{ *:[i64] })<<P:Predicate_ConstPseudoFalse>>, TYPE:{ *:[i64] }:$src_ty)  =>  (OpConstantFalse:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty)
     /*  253 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpConstantFalse),
     /*  256 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  258 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  260 */       GIR_RootConstrainSelectedInstOperands,
     /*  261 */       // GIR_Coverage, 1,
     /*  261 */       GIR_EraseRootFromParent_Done,
     /*  262 */     // Label 10: @262
     /*  262 */     GIM_Try, /*On fail goto*//*Label 11*/ GIMT_Encode4(333), // Rule ID 56 //
     /*  267 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  271 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  275 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  279 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  283 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  287 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /*  291 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  296 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  301 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  306 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  310 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  312 */       // (assigntype:{ *:[i64] } (select:{ *:[i64] } iID:{ *:[i64] }:$cond, iID:{ *:[i64] }:$src1, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSISCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, iID:{ *:[i64] }:$src1, iID:{ *:[i64] }:$src2)
     /*  312 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSISCond),
     /*  315 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  317 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  319 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /*  323 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  327 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /*  331 */       GIR_RootConstrainSelectedInstOperands,
     /*  332 */       // GIR_Coverage, 56,
     /*  332 */       GIR_EraseRootFromParent_Done,
     /*  333 */     // Label 11: @333
     /*  333 */     GIM_Try, /*On fail goto*//*Label 12*/ GIMT_Encode4(404), // Rule ID 57 //
     /*  338 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  342 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  346 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  350 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  354 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  358 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /*  362 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /*  367 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  372 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  377 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  381 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  383 */       // (assigntype:{ *:[i64] } (select:{ *:[i64] } vID:{ *:[v2i64] }:$cond, iID:{ *:[i64] }:$src1, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSIVCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, iID:{ *:[i64] }:$src1, iID:{ *:[i64] }:$src2)
     /*  383 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSIVCond),
     /*  386 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  388 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  390 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /*  394 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  398 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /*  402 */       GIR_RootConstrainSelectedInstOperands,
     /*  403 */       // GIR_Coverage, 57,
     /*  403 */       GIR_EraseRootFromParent_Done,
     /*  404 */     // Label 12: @404
     /*  404 */     GIM_Try, /*On fail goto*//*Label 13*/ GIMT_Encode4(475), // Rule ID 58 //
     /*  409 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  413 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  417 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  421 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  425 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  429 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /*  433 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  438 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  443 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  448 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  452 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  454 */       // (assigntype:{ *:[f64] } (select:{ *:[f64] } iID:{ *:[i64] }:$cond, fID:{ *:[f64] }:$src1, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSFSCond:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, fID:{ *:[f64] }:$src1, fID:{ *:[f64] }:$src2)
     /*  454 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSFSCond),
     /*  457 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  459 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  461 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /*  465 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  469 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /*  473 */       GIR_RootConstrainSelectedInstOperands,
     /*  474 */       // GIR_Coverage, 58,
     /*  474 */       GIR_EraseRootFromParent_Done,
     /*  475 */     // Label 13: @475
     /*  475 */     GIM_Try, /*On fail goto*//*Label 14*/ GIMT_Encode4(546), // Rule ID 59 //
     /*  480 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  484 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  488 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  492 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  496 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  500 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /*  504 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /*  509 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  514 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  519 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  523 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  525 */       // (assigntype:{ *:[f64] } (select:{ *:[f64] } vID:{ *:[v2i64] }:$cond, fID:{ *:[f64] }:$src1, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectSFVCond:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, fID:{ *:[f64] }:$src1, fID:{ *:[f64] }:$src2)
     /*  525 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectSFVCond),
     /*  528 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  530 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  532 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /*  536 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  540 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /*  544 */       GIR_RootConstrainSelectedInstOperands,
     /*  545 */       // GIR_Coverage, 59,
     /*  545 */       GIR_EraseRootFromParent_Done,
     /*  546 */     // Label 14: @546
     /*  546 */     GIM_Try, /*On fail goto*//*Label 15*/ GIMT_Encode4(617), // Rule ID 60 //
     /*  551 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
     /*  555 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  559 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  563 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  567 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  571 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /*  575 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  580 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
     /*  585 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
     /*  590 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  594 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  596 */       // (assigntype:{ *:[i64] } (select:{ *:[i64] } iID:{ *:[i64] }:$cond, vpID:{ *:[i64] }:$src1, vpID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVPSCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, vpID:{ *:[i64] }:$src1, vpID:{ *:[i64] }:$src2)
     /*  596 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVPSCond),
     /*  599 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  601 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  603 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /*  607 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  611 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /*  615 */       GIR_RootConstrainSelectedInstOperands,
     /*  616 */       // GIR_Coverage, 60,
     /*  616 */       GIR_EraseRootFromParent_Done,
     /*  617 */     // Label 15: @617
     /*  617 */     GIM_Try, /*On fail goto*//*Label 16*/ GIMT_Encode4(688), // Rule ID 61 //
     /*  622 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
     /*  626 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  630 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /*  634 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /*  638 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  642 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_s64,
     /*  646 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /*  651 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
     /*  656 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vpIDRegClassID),
     /*  661 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  665 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  667 */       // (assigntype:{ *:[i64] } (select:{ *:[i64] } vID:{ *:[v2i64] }:$cond, vpID:{ *:[i64] }:$src1, vpID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVPVCond:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, vpID:{ *:[i64] }:$src1, vpID:{ *:[i64] }:$src2)
     /*  667 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVPVCond),
     /*  670 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  672 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  674 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /*  678 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /*  682 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /*  686 */       GIR_RootConstrainSelectedInstOperands,
     /*  687 */       // GIR_Coverage, 61,
     /*  687 */       GIR_EraseRootFromParent_Done,
     /*  688 */     // Label 16: @688
     /*  688 */     GIM_Try, /*On fail goto*//*Label 17*/ GIMT_Encode4(746), // Rule ID 4 //
     /*  693 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  697 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  701 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /*  705 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  709 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  713 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  718 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  723 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  727 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  729 */       // (assigntype:{ *:[i64] } (add:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpIAddS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /*  729 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpIAddS),
     /*  732 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  734 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  736 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  740 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  744 */       GIR_RootConstrainSelectedInstOperands,
     /*  745 */       // GIR_Coverage, 4,
     /*  745 */       GIR_EraseRootFromParent_Done,
     /*  746 */     // Label 17: @746
     /*  746 */     GIM_Try, /*On fail goto*//*Label 18*/ GIMT_Encode4(804), // Rule ID 52 //
     /*  751 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  755 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  759 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /*  763 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  767 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  771 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  776 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  781 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  785 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  787 */       // (assigntype:{ *:[i64] } (and:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseAndS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /*  787 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseAndS),
     /*  790 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  792 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  794 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  798 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  802 */       GIR_RootConstrainSelectedInstOperands,
     /*  803 */       // GIR_Coverage, 52,
     /*  803 */       GIR_EraseRootFromParent_Done,
     /*  804 */     // Label 18: @804
     /*  804 */     GIM_Try, /*On fail goto*//*Label 19*/ GIMT_Encode4(862), // Rule ID 44 //
     /*  809 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  813 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  817 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
     /*  821 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  825 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  829 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  834 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /*  839 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  843 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  845 */       // (assigntype:{ *:[i64] } (sra:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftRightArithmeticS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /*  845 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftRightArithmeticS),
     /*  848 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  850 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  852 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  856 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  860 */       GIR_RootConstrainSelectedInstOperands,
     /*  861 */       // GIR_Coverage, 44,
     /*  861 */       GIR_EraseRootFromParent_Done,
     /*  862 */     // Label 19: @862
     /*  862 */     GIM_Try, /*On fail goto*//*Label 20*/ GIMT_Encode4(920), // Rule ID 6 //
     /*  867 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  871 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  875 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FADD),
     /*  879 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  883 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  887 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  892 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  897 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  901 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  903 */       // (assigntype:{ *:[f64] } (fadd:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFAddS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
     /*  903 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFAddS),
     /*  906 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  908 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  910 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  914 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  918 */       GIR_RootConstrainSelectedInstOperands,
     /*  919 */       // GIR_Coverage, 6,
     /*  919 */       GIR_EraseRootFromParent_Done,
     /*  920 */     // Label 20: @920
     /*  920 */     GIM_Try, /*On fail goto*//*Label 21*/ GIMT_Encode4(978), // Rule ID 26 //
     /*  925 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  929 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  933 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FDIV),
     /*  937 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  941 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /*  945 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  950 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  955 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /*  959 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /*  961 */       // (assigntype:{ *:[f64] } (fdiv:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFDivS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
     /*  961 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFDivS),
     /*  964 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /*  966 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /*  968 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /*  972 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /*  976 */       GIR_RootConstrainSelectedInstOperands,
     /*  977 */       // GIR_Coverage, 26,
     /*  977 */       GIR_EraseRootFromParent_Done,
     /*  978 */     // Label 21: @978
     /*  978 */     GIM_Try, /*On fail goto*//*Label 22*/ GIMT_Encode4(1036), // Rule ID 18 //
     /*  983 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /*  987 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /*  991 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FMUL),
     /*  995 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /*  999 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1003 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1008 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1013 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1017 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1019 */       // (assigntype:{ *:[f64] } (fmul:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFMulS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
     /* 1019 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFMulS),
     /* 1022 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1024 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1026 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1030 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1034 */       GIR_RootConstrainSelectedInstOperands,
     /* 1035 */       // GIR_Coverage, 18,
     /* 1035 */       GIR_EraseRootFromParent_Done,
     /* 1036 */     // Label 22: @1036
     /* 1036 */     GIM_Try, /*On fail goto*//*Label 23*/ GIMT_Encode4(1094), // Rule ID 34 //
     /* 1041 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1045 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1049 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FREM),
     /* 1053 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1057 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1061 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1066 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1071 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1075 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1077 */       // (assigntype:{ *:[f64] } (frem:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFRemS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
     /* 1077 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFRemS),
     /* 1080 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1082 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1084 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1088 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1092 */       GIR_RootConstrainSelectedInstOperands,
     /* 1093 */       // GIR_Coverage, 34,
     /* 1093 */       GIR_EraseRootFromParent_Done,
     /* 1094 */     // Label 23: @1094
     /* 1094 */     GIM_Try, /*On fail goto*//*Label 24*/ GIMT_Encode4(1152), // Rule ID 12 //
     /* 1099 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1103 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1107 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FSUB),
     /* 1111 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1115 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1119 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1124 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1129 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1133 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1135 */       // (assigntype:{ *:[f64] } (fsub:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFSubS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
     /* 1135 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFSubS),
     /* 1138 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1140 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1142 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1146 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1150 */       GIR_RootConstrainSelectedInstOperands,
     /* 1151 */       // GIR_Coverage, 12,
     /* 1151 */       GIR_EraseRootFromParent_Done,
     /* 1152 */     // Label 24: @1152
     /* 1152 */     GIM_Try, /*On fail goto*//*Label 25*/ GIMT_Encode4(1210), // Rule ID 42 //
     /* 1157 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1161 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1165 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 1169 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1173 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1177 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1182 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1187 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1191 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1193 */       // (assigntype:{ *:[i64] } (srl:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftRightLogicalS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /* 1193 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftRightLogicalS),
     /* 1196 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1198 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1200 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1204 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1208 */       GIR_RootConstrainSelectedInstOperands,
     /* 1209 */       // GIR_Coverage, 42,
     /* 1209 */       GIR_EraseRootFromParent_Done,
     /* 1210 */     // Label 25: @1210
     /* 1210 */     GIM_Try, /*On fail goto*//*Label 26*/ GIMT_Encode4(1268), // Rule ID 16 //
     /* 1215 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1219 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1223 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /* 1227 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1231 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1235 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1240 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1245 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1249 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1251 */       // (assigntype:{ *:[i64] } (mul:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpIMulS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /* 1251 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpIMulS),
     /* 1254 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1256 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1258 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1262 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1266 */       GIR_RootConstrainSelectedInstOperands,
     /* 1267 */       // GIR_Coverage, 16,
     /* 1267 */       GIR_EraseRootFromParent_Done,
     /* 1268 */     // Label 26: @1268
     /* 1268 */     GIM_Try, /*On fail goto*//*Label 27*/ GIMT_Encode4(1326), // Rule ID 48 //
     /* 1273 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1277 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1281 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /* 1285 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1289 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1293 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1298 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1303 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1307 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1309 */       // (assigntype:{ *:[i64] } (or:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseOrS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /* 1309 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseOrS),
     /* 1312 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1314 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1316 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1320 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1324 */       GIR_RootConstrainSelectedInstOperands,
     /* 1325 */       // GIR_Coverage, 48,
     /* 1325 */       GIR_EraseRootFromParent_Done,
     /* 1326 */     // Label 27: @1326
     /* 1326 */     GIM_Try, /*On fail goto*//*Label 28*/ GIMT_Encode4(1384), // Rule ID 24 //
     /* 1331 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1335 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1339 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SDIV),
     /* 1343 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1347 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1351 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1356 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1361 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1365 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1367 */       // (assigntype:{ *:[i64] } (sdiv:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSDivS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /* 1367 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSDivS),
     /* 1370 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1372 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1374 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1378 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1382 */       GIR_RootConstrainSelectedInstOperands,
     /* 1383 */       // GIR_Coverage, 24,
     /* 1383 */       GIR_EraseRootFromParent_Done,
     /* 1384 */     // Label 28: @1384
     /* 1384 */     GIM_Try, /*On fail goto*//*Label 29*/ GIMT_Encode4(1442), // Rule ID 46 //
     /* 1389 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1393 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1397 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 1401 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1405 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1409 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1414 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1419 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1423 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1425 */       // (assigntype:{ *:[i64] } (shl:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftLeftLogicalS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /* 1425 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftLeftLogicalS),
     /* 1428 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1430 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1432 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1436 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1440 */       GIR_RootConstrainSelectedInstOperands,
     /* 1441 */       // GIR_Coverage, 46,
     /* 1441 */       GIR_EraseRootFromParent_Done,
     /* 1442 */     // Label 29: @1442
     /* 1442 */     GIM_Try, /*On fail goto*//*Label 30*/ GIMT_Encode4(1500), // Rule ID 32 //
     /* 1447 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1451 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1455 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SREM),
     /* 1459 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1463 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1467 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1472 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1477 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1481 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1483 */       // (assigntype:{ *:[i64] } (srem:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSRemS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /* 1483 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSRemS),
     /* 1486 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1488 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1490 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1494 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1498 */       GIR_RootConstrainSelectedInstOperands,
     /* 1499 */       // GIR_Coverage, 32,
     /* 1499 */       GIR_EraseRootFromParent_Done,
     /* 1500 */     // Label 30: @1500
     /* 1500 */     GIM_Try, /*On fail goto*//*Label 31*/ GIMT_Encode4(1558), // Rule ID 8 //
     /* 1505 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1509 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1513 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FADD),
     /* 1517 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1521 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1525 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1530 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1535 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1539 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1541 */       // (assigntype:{ *:[f64] } (strict_fadd:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFAddS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
     /* 1541 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFAddS),
     /* 1544 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1546 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1548 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1552 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1556 */       GIR_RootConstrainSelectedInstOperands,
     /* 1557 */       // GIR_Coverage, 8,
     /* 1557 */       GIR_EraseRootFromParent_Done,
     /* 1558 */     // Label 31: @1558
     /* 1558 */     GIM_Try, /*On fail goto*//*Label 32*/ GIMT_Encode4(1616), // Rule ID 28 //
     /* 1563 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1567 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1571 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FDIV),
     /* 1575 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1579 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1583 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1588 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1593 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1597 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1599 */       // (assigntype:{ *:[f64] } (strict_fdiv:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFDivS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
     /* 1599 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFDivS),
     /* 1602 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1604 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1606 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1610 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1614 */       GIR_RootConstrainSelectedInstOperands,
     /* 1615 */       // GIR_Coverage, 28,
     /* 1615 */       GIR_EraseRootFromParent_Done,
     /* 1616 */     // Label 32: @1616
     /* 1616 */     GIM_Try, /*On fail goto*//*Label 33*/ GIMT_Encode4(1674), // Rule ID 20 //
     /* 1621 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1625 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1629 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FMUL),
     /* 1633 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1637 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1641 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1646 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1651 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1655 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1657 */       // (assigntype:{ *:[f64] } (strict_fmul:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFMulS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
     /* 1657 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFMulS),
     /* 1660 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1662 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1664 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1668 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1672 */       GIR_RootConstrainSelectedInstOperands,
     /* 1673 */       // GIR_Coverage, 20,
     /* 1673 */       GIR_EraseRootFromParent_Done,
     /* 1674 */     // Label 33: @1674
     /* 1674 */     GIM_Try, /*On fail goto*//*Label 34*/ GIMT_Encode4(1732), // Rule ID 36 //
     /* 1679 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1683 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1687 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FREM),
     /* 1691 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1695 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1699 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1704 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1709 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1713 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1715 */       // (assigntype:{ *:[f64] } (strict_frem:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFRemS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
     /* 1715 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFRemS),
     /* 1718 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1720 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1722 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1726 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1730 */       GIR_RootConstrainSelectedInstOperands,
     /* 1731 */       // GIR_Coverage, 36,
     /* 1731 */       GIR_EraseRootFromParent_Done,
     /* 1732 */     // Label 34: @1732
     /* 1732 */     GIM_Try, /*On fail goto*//*Label 35*/ GIMT_Encode4(1790), // Rule ID 14 //
     /* 1737 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1741 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1745 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FSUB),
     /* 1749 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1753 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1757 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1762 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 1767 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1771 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1773 */       // (assigntype:{ *:[f64] } (strict_fsub:{ *:[f64] } fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFSubS:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src, fID:{ *:[f64] }:$src2)
     /* 1773 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFSubS),
     /* 1776 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1778 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1780 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1784 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1788 */       GIR_RootConstrainSelectedInstOperands,
     /* 1789 */       // GIR_Coverage, 14,
     /* 1789 */       GIR_EraseRootFromParent_Done,
     /* 1790 */     // Label 35: @1790
     /* 1790 */     GIM_Try, /*On fail goto*//*Label 36*/ GIMT_Encode4(1848), // Rule ID 10 //
     /* 1795 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1799 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1803 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 1807 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1811 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1815 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1820 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1825 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1829 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1831 */       // (assigntype:{ *:[i64] } (sub:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpISubS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /* 1831 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpISubS),
     /* 1834 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1836 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1838 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1842 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1846 */       GIR_RootConstrainSelectedInstOperands,
     /* 1847 */       // GIR_Coverage, 10,
     /* 1847 */       GIR_EraseRootFromParent_Done,
     /* 1848 */     // Label 36: @1848
     /* 1848 */     GIM_Try, /*On fail goto*//*Label 37*/ GIMT_Encode4(1906), // Rule ID 22 //
     /* 1853 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1857 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1861 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UDIV),
     /* 1865 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1869 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1873 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1878 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1883 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1887 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1889 */       // (assigntype:{ *:[i64] } (udiv:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpUDivS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /* 1889 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpUDivS),
     /* 1892 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1894 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1896 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1900 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1904 */       GIR_RootConstrainSelectedInstOperands,
     /* 1905 */       // GIR_Coverage, 22,
     /* 1905 */       GIR_EraseRootFromParent_Done,
     /* 1906 */     // Label 37: @1906
     /* 1906 */     GIM_Try, /*On fail goto*//*Label 38*/ GIMT_Encode4(1964), // Rule ID 30 //
     /* 1911 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1915 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1919 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UREM),
     /* 1923 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1927 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1931 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1936 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1941 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 1945 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 1947 */       // (assigntype:{ *:[i64] } (urem:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpUModS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /* 1947 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpUModS),
     /* 1950 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 1952 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 1954 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 1958 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 1962 */       GIR_RootConstrainSelectedInstOperands,
     /* 1963 */       // GIR_Coverage, 30,
     /* 1963 */       GIR_EraseRootFromParent_Done,
     /* 1964 */     // Label 38: @1964
     /* 1964 */     GIM_Try, /*On fail goto*//*Label 39*/ GIMT_Encode4(2022), // Rule ID 50 //
     /* 1969 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1973 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 1977 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /* 1981 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 1985 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_s64,
     /* 1989 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1994 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 1999 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2003 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2005 */       // (assigntype:{ *:[i64] } (xor:{ *:[i64] } iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseXorS:{ *:[i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$src, iID:{ *:[i64] }:$src2)
     /* 2005 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseXorS),
     /* 2008 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2010 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2012 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2016 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 2020 */       GIR_RootConstrainSelectedInstOperands,
     /* 2021 */       // GIR_Coverage, 50,
     /* 2021 */       GIR_EraseRootFromParent_Done,
     /* 2022 */     // Label 39: @2022
     /* 2022 */     GIM_Try, /*On fail goto*//*Label 40*/ GIMT_Encode4(2067), // Rule ID 2 //
     /* 2027 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 2031 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2035 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 2039 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 2043 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::fIDRegClassID),
     /* 2048 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2052 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2054 */       // (assigntype:{ *:[f64] } (fneg:{ *:[f64] } fID:{ *:[f64] }:$src), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFNegate:{ *:[f64] } TYPE:{ *:[i64] }:$src_ty, fID:{ *:[f64] }:$src)
     /* 2054 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFNegate),
     /* 2057 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2059 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2061 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2065 */       GIR_RootConstrainSelectedInstOperands,
     /* 2066 */       // GIR_Coverage, 2,
     /* 2066 */       GIR_EraseRootFromParent_Done,
     /* 2067 */     // Label 40: @2067
     /* 2067 */     GIM_Reject,
     /* 2068 */   // Label 8: @2068
     /* 2068 */   GIM_Reject,
     /* 2069 */   // Label 3: @2069
     /* 2069 */   GIM_Try, /*On fail goto*//*Label 41*/ GIMT_Encode4(3744),
     /* 2074 */     GIM_RootCheckType, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2077 */     GIM_RootCheckType, /*Op*/2, /*Type*/GILLT_s64,
     /* 2080 */     GIM_Try, /*On fail goto*//*Label 42*/ GIMT_Encode4(2151), // Rule ID 62 //
     /* 2085 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2089 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2093 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 2097 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 2101 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2105 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 2109 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 2114 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2119 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2124 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2128 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2130 */       // (assigntype:{ *:[v2i64] } (select:{ *:[v2i64] } iID:{ *:[i64] }:$cond, vID:{ *:[v2i64] }:$src1, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVISCond:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, vID:{ *:[v2i64] }:$src1, vID:{ *:[v2i64] }:$src2)
     /* 2130 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVISCond),
     /* 2133 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2135 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2137 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /* 2141 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /* 2145 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /* 2149 */       GIR_RootConstrainSelectedInstOperands,
     /* 2150 */       // GIR_Coverage, 62,
     /* 2150 */       GIR_EraseRootFromParent_Done,
     /* 2151 */     // Label 42: @2151
     /* 2151 */     GIM_Try, /*On fail goto*//*Label 43*/ GIMT_Encode4(2222), // Rule ID 63 //
     /* 2156 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2160 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2164 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 2168 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2172 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2176 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 2180 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2185 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2190 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2195 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2199 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2201 */       // (assigntype:{ *:[v2i64] } (select:{ *:[v2i64] } vID:{ *:[v2i64] }:$cond, vID:{ *:[v2i64] }:$src1, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVIVCond:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, vID:{ *:[v2i64] }:$src1, vID:{ *:[v2i64] }:$src2)
     /* 2201 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVIVCond),
     /* 2204 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2206 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2208 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /* 2212 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /* 2216 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /* 2220 */       GIR_RootConstrainSelectedInstOperands,
     /* 2221 */       // GIR_Coverage, 63,
     /* 2221 */       GIR_EraseRootFromParent_Done,
     /* 2222 */     // Label 43: @2222
     /* 2222 */     GIM_Try, /*On fail goto*//*Label 44*/ GIMT_Encode4(2293), // Rule ID 64 //
     /* 2227 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2231 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2235 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 2239 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_s64,
     /* 2243 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2247 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 2251 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::iIDRegClassID),
     /* 2256 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2261 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2266 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2270 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2272 */       // (assigntype:{ *:[v2f64] } (select:{ *:[v2f64] } iID:{ *:[i64] }:$cond, vfID:{ *:[v2f64] }:$src1, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVFSCond:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, iID:{ *:[i64] }:$cond, vfID:{ *:[v2f64] }:$src1, vfID:{ *:[v2f64] }:$src2)
     /* 2272 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVFSCond),
     /* 2275 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2277 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2279 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /* 2283 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /* 2287 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /* 2291 */       GIR_RootConstrainSelectedInstOperands,
     /* 2292 */       // GIR_Coverage, 64,
     /* 2292 */       GIR_EraseRootFromParent_Done,
     /* 2293 */     // Label 44: @2293
     /* 2293 */     GIM_Try, /*On fail goto*//*Label 45*/ GIMT_Encode4(2364), // Rule ID 65 //
     /* 2298 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2302 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2306 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SELECT),
     /* 2310 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2314 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2318 */       GIM_CheckType, /*MI*/1, /*Op*/3, /*Type*/GILLT_v2s64,
     /* 2322 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2327 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2332 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/3, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2337 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2341 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2343 */       // (assigntype:{ *:[v2f64] } (select:{ *:[v2f64] } vID:{ *:[v2i64] }:$cond, vfID:{ *:[v2f64] }:$src1, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSelectVFVCond:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$cond, vfID:{ *:[v2f64] }:$src1, vfID:{ *:[v2f64] }:$src2)
     /* 2343 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSelectVFVCond),
     /* 2346 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2348 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2350 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // cond
     /* 2354 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src1
     /* 2358 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/3, // src2
     /* 2362 */       GIR_RootConstrainSelectedInstOperands,
     /* 2363 */       // GIR_Coverage, 65,
     /* 2363 */       GIR_EraseRootFromParent_Done,
     /* 2364 */     // Label 45: @2364
     /* 2364 */     GIM_Try, /*On fail goto*//*Label 46*/ GIMT_Encode4(2422), // Rule ID 5 //
     /* 2369 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2373 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2377 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ADD),
     /* 2381 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2385 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2389 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2394 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2399 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2403 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2405 */       // (assigntype:{ *:[v2i64] } (add:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpIAddV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 2405 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpIAddV),
     /* 2408 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2410 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2412 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2416 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 2420 */       GIR_RootConstrainSelectedInstOperands,
     /* 2421 */       // GIR_Coverage, 5,
     /* 2421 */       GIR_EraseRootFromParent_Done,
     /* 2422 */     // Label 46: @2422
     /* 2422 */     GIM_Try, /*On fail goto*//*Label 47*/ GIMT_Encode4(2480), // Rule ID 53 //
     /* 2427 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2431 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2435 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_AND),
     /* 2439 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2443 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2447 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2452 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2457 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2461 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2463 */       // (assigntype:{ *:[v2i64] } (and:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseAndV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 2463 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseAndV),
     /* 2466 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2468 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2470 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2474 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 2478 */       GIR_RootConstrainSelectedInstOperands,
     /* 2479 */       // GIR_Coverage, 53,
     /* 2479 */       GIR_EraseRootFromParent_Done,
     /* 2480 */     // Label 47: @2480
     /* 2480 */     GIM_Try, /*On fail goto*//*Label 48*/ GIMT_Encode4(2538), // Rule ID 45 //
     /* 2485 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2489 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2493 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_ASHR),
     /* 2497 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2501 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2505 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2510 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2515 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2519 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2521 */       // (assigntype:{ *:[v2i64] } (sra:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftRightArithmeticV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 2521 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftRightArithmeticV),
     /* 2524 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2526 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2528 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2532 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 2536 */       GIR_RootConstrainSelectedInstOperands,
     /* 2537 */       // GIR_Coverage, 45,
     /* 2537 */       GIR_EraseRootFromParent_Done,
     /* 2538 */     // Label 48: @2538
     /* 2538 */     GIM_Try, /*On fail goto*//*Label 49*/ GIMT_Encode4(2596), // Rule ID 7 //
     /* 2543 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2547 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2551 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FADD),
     /* 2555 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2559 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2563 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2568 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2573 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2577 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2579 */       // (assigntype:{ *:[v2f64] } (fadd:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFAddV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
     /* 2579 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFAddV),
     /* 2582 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2584 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2586 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2590 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 2594 */       GIR_RootConstrainSelectedInstOperands,
     /* 2595 */       // GIR_Coverage, 7,
     /* 2595 */       GIR_EraseRootFromParent_Done,
     /* 2596 */     // Label 49: @2596
     /* 2596 */     GIM_Try, /*On fail goto*//*Label 50*/ GIMT_Encode4(2654), // Rule ID 27 //
     /* 2601 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2605 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2609 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FDIV),
     /* 2613 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2617 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2621 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2626 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2631 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2635 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2637 */       // (assigntype:{ *:[v2f64] } (fdiv:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFDivV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
     /* 2637 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFDivV),
     /* 2640 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2642 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2644 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2648 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 2652 */       GIR_RootConstrainSelectedInstOperands,
     /* 2653 */       // GIR_Coverage, 27,
     /* 2653 */       GIR_EraseRootFromParent_Done,
     /* 2654 */     // Label 50: @2654
     /* 2654 */     GIM_Try, /*On fail goto*//*Label 51*/ GIMT_Encode4(2712), // Rule ID 19 //
     /* 2659 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2663 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2667 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FMUL),
     /* 2671 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2675 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2679 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2684 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2689 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2693 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2695 */       // (assigntype:{ *:[v2f64] } (fmul:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFMulV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
     /* 2695 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFMulV),
     /* 2698 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2700 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2702 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2706 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 2710 */       GIR_RootConstrainSelectedInstOperands,
     /* 2711 */       // GIR_Coverage, 19,
     /* 2711 */       GIR_EraseRootFromParent_Done,
     /* 2712 */     // Label 51: @2712
     /* 2712 */     GIM_Try, /*On fail goto*//*Label 52*/ GIMT_Encode4(2770), // Rule ID 35 //
     /* 2717 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2721 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2725 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FREM),
     /* 2729 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2733 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2737 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2742 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2747 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2751 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2753 */       // (assigntype:{ *:[v2f64] } (frem:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFRemV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
     /* 2753 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFRemV),
     /* 2756 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2758 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2760 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2764 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 2768 */       GIR_RootConstrainSelectedInstOperands,
     /* 2769 */       // GIR_Coverage, 35,
     /* 2769 */       GIR_EraseRootFromParent_Done,
     /* 2770 */     // Label 52: @2770
     /* 2770 */     GIM_Try, /*On fail goto*//*Label 53*/ GIMT_Encode4(2828), // Rule ID 13 //
     /* 2775 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2779 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2783 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FSUB),
     /* 2787 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2791 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2795 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2800 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 2805 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2809 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2811 */       // (assigntype:{ *:[v2f64] } (fsub:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFSubV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
     /* 2811 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFSubV),
     /* 2814 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2816 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2818 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2822 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 2826 */       GIR_RootConstrainSelectedInstOperands,
     /* 2827 */       // GIR_Coverage, 13,
     /* 2827 */       GIR_EraseRootFromParent_Done,
     /* 2828 */     // Label 53: @2828
     /* 2828 */     GIM_Try, /*On fail goto*//*Label 54*/ GIMT_Encode4(2886), // Rule ID 43 //
     /* 2833 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2837 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2841 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_LSHR),
     /* 2845 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2849 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2853 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2858 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2863 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2867 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2869 */       // (assigntype:{ *:[v2i64] } (srl:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftRightLogicalV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 2869 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftRightLogicalV),
     /* 2872 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2874 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2876 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2880 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 2884 */       GIR_RootConstrainSelectedInstOperands,
     /* 2885 */       // GIR_Coverage, 43,
     /* 2885 */       GIR_EraseRootFromParent_Done,
     /* 2886 */     // Label 54: @2886
     /* 2886 */     GIM_Try, /*On fail goto*//*Label 55*/ GIMT_Encode4(2944), // Rule ID 17 //
     /* 2891 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2895 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2899 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_MUL),
     /* 2903 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2907 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2911 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2916 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2921 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2925 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2927 */       // (assigntype:{ *:[v2i64] } (mul:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpIMulV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 2927 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpIMulV),
     /* 2930 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2932 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2934 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2938 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 2942 */       GIR_RootConstrainSelectedInstOperands,
     /* 2943 */       // GIR_Coverage, 17,
     /* 2943 */       GIR_EraseRootFromParent_Done,
     /* 2944 */     // Label 55: @2944
     /* 2944 */     GIM_Try, /*On fail goto*//*Label 56*/ GIMT_Encode4(3002), // Rule ID 49 //
     /* 2949 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2953 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 2957 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_OR),
     /* 2961 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 2965 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 2969 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2974 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 2979 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 2983 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 2985 */       // (assigntype:{ *:[v2i64] } (or:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseOrV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 2985 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseOrV),
     /* 2988 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 2990 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 2992 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 2996 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3000 */       GIR_RootConstrainSelectedInstOperands,
     /* 3001 */       // GIR_Coverage, 49,
     /* 3001 */       GIR_EraseRootFromParent_Done,
     /* 3002 */     // Label 56: @3002
     /* 3002 */     GIM_Try, /*On fail goto*//*Label 57*/ GIMT_Encode4(3060), // Rule ID 25 //
     /* 3007 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3011 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3015 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SDIV),
     /* 3019 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3023 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3027 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3032 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3037 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3041 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3043 */       // (assigntype:{ *:[v2i64] } (sdiv:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSDivV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 3043 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSDivV),
     /* 3046 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3048 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3050 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3054 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3058 */       GIR_RootConstrainSelectedInstOperands,
     /* 3059 */       // GIR_Coverage, 25,
     /* 3059 */       GIR_EraseRootFromParent_Done,
     /* 3060 */     // Label 57: @3060
     /* 3060 */     GIM_Try, /*On fail goto*//*Label 58*/ GIMT_Encode4(3118), // Rule ID 47 //
     /* 3065 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3069 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3073 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SHL),
     /* 3077 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3081 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3085 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3090 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3095 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3099 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3101 */       // (assigntype:{ *:[v2i64] } (shl:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpShiftLeftLogicalV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 3101 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpShiftLeftLogicalV),
     /* 3104 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3106 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3108 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3112 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3116 */       GIR_RootConstrainSelectedInstOperands,
     /* 3117 */       // GIR_Coverage, 47,
     /* 3117 */       GIR_EraseRootFromParent_Done,
     /* 3118 */     // Label 58: @3118
     /* 3118 */     GIM_Try, /*On fail goto*//*Label 59*/ GIMT_Encode4(3176), // Rule ID 33 //
     /* 3123 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3127 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3131 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SREM),
     /* 3135 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3139 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3143 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3148 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3153 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3157 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3159 */       // (assigntype:{ *:[v2i64] } (srem:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpSRemV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 3159 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpSRemV),
     /* 3162 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3164 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3166 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3170 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3174 */       GIR_RootConstrainSelectedInstOperands,
     /* 3175 */       // GIR_Coverage, 33,
     /* 3175 */       GIR_EraseRootFromParent_Done,
     /* 3176 */     // Label 59: @3176
     /* 3176 */     GIM_Try, /*On fail goto*//*Label 60*/ GIMT_Encode4(3234), // Rule ID 9 //
     /* 3181 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3185 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3189 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FADD),
     /* 3193 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3197 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3201 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3206 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3211 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3215 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3217 */       // (assigntype:{ *:[v2f64] } (strict_fadd:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFAddV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
     /* 3217 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFAddV),
     /* 3220 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3222 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3224 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3228 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3232 */       GIR_RootConstrainSelectedInstOperands,
     /* 3233 */       // GIR_Coverage, 9,
     /* 3233 */       GIR_EraseRootFromParent_Done,
     /* 3234 */     // Label 60: @3234
     /* 3234 */     GIM_Try, /*On fail goto*//*Label 61*/ GIMT_Encode4(3292), // Rule ID 29 //
     /* 3239 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3243 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3247 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FDIV),
     /* 3251 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3255 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3259 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3264 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3269 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3273 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3275 */       // (assigntype:{ *:[v2f64] } (strict_fdiv:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFDivV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
     /* 3275 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFDivV),
     /* 3278 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3280 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3282 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3286 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3290 */       GIR_RootConstrainSelectedInstOperands,
     /* 3291 */       // GIR_Coverage, 29,
     /* 3291 */       GIR_EraseRootFromParent_Done,
     /* 3292 */     // Label 61: @3292
     /* 3292 */     GIM_Try, /*On fail goto*//*Label 62*/ GIMT_Encode4(3350), // Rule ID 21 //
     /* 3297 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3301 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3305 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FMUL),
     /* 3309 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3313 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3317 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3322 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3327 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3331 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3333 */       // (assigntype:{ *:[v2f64] } (strict_fmul:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFMulV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
     /* 3333 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFMulV),
     /* 3336 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3338 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3340 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3344 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3348 */       GIR_RootConstrainSelectedInstOperands,
     /* 3349 */       // GIR_Coverage, 21,
     /* 3349 */       GIR_EraseRootFromParent_Done,
     /* 3350 */     // Label 62: @3350
     /* 3350 */     GIM_Try, /*On fail goto*//*Label 63*/ GIMT_Encode4(3408), // Rule ID 37 //
     /* 3355 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3359 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3363 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FREM),
     /* 3367 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3371 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3375 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3380 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3385 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3389 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3391 */       // (assigntype:{ *:[v2f64] } (strict_frem:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFRemV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
     /* 3391 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFRemV),
     /* 3394 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3396 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3398 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3402 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3406 */       GIR_RootConstrainSelectedInstOperands,
     /* 3407 */       // GIR_Coverage, 37,
     /* 3407 */       GIR_EraseRootFromParent_Done,
     /* 3408 */     // Label 63: @3408
     /* 3408 */     GIM_Try, /*On fail goto*//*Label 64*/ GIMT_Encode4(3466), // Rule ID 15 //
     /* 3413 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3417 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3421 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_STRICT_FSUB),
     /* 3425 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3429 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3433 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3438 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3443 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3447 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3449 */       // (assigntype:{ *:[v2f64] } (strict_fsub:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpStrictFSubV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src, vfID:{ *:[v2f64] }:$src2)
     /* 3449 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpStrictFSubV),
     /* 3452 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3454 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3456 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3460 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3464 */       GIR_RootConstrainSelectedInstOperands,
     /* 3465 */       // GIR_Coverage, 15,
     /* 3465 */       GIR_EraseRootFromParent_Done,
     /* 3466 */     // Label 64: @3466
     /* 3466 */     GIM_Try, /*On fail goto*//*Label 65*/ GIMT_Encode4(3524), // Rule ID 11 //
     /* 3471 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3475 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3479 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_SUB),
     /* 3483 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3487 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3491 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3496 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3501 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3505 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3507 */       // (assigntype:{ *:[v2i64] } (sub:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpISubV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 3507 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpISubV),
     /* 3510 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3512 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3514 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3518 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3522 */       GIR_RootConstrainSelectedInstOperands,
     /* 3523 */       // GIR_Coverage, 11,
     /* 3523 */       GIR_EraseRootFromParent_Done,
     /* 3524 */     // Label 65: @3524
     /* 3524 */     GIM_Try, /*On fail goto*//*Label 66*/ GIMT_Encode4(3582), // Rule ID 23 //
     /* 3529 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3533 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3537 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UDIV),
     /* 3541 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3545 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3549 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3554 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3559 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3563 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3565 */       // (assigntype:{ *:[v2i64] } (udiv:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpUDivV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 3565 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpUDivV),
     /* 3568 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3570 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3572 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3576 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3580 */       GIR_RootConstrainSelectedInstOperands,
     /* 3581 */       // GIR_Coverage, 23,
     /* 3581 */       GIR_EraseRootFromParent_Done,
     /* 3582 */     // Label 66: @3582
     /* 3582 */     GIM_Try, /*On fail goto*//*Label 67*/ GIMT_Encode4(3640), // Rule ID 31 //
     /* 3587 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3591 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3595 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_UREM),
     /* 3599 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3603 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3607 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3612 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3617 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3621 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3623 */       // (assigntype:{ *:[v2i64] } (urem:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpUModV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 3623 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpUModV),
     /* 3626 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3628 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3630 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3634 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3638 */       GIR_RootConstrainSelectedInstOperands,
     /* 3639 */       // GIR_Coverage, 31,
     /* 3639 */       GIR_EraseRootFromParent_Done,
     /* 3640 */     // Label 67: @3640
     /* 3640 */     GIM_Try, /*On fail goto*//*Label 68*/ GIMT_Encode4(3698), // Rule ID 51 //
     /* 3645 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3649 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3653 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_XOR),
     /* 3657 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3661 */       GIM_CheckType, /*MI*/1, /*Op*/2, /*Type*/GILLT_v2s64,
     /* 3665 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3670 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::vIDRegClassID),
     /* 3675 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3679 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3681 */       // (assigntype:{ *:[v2i64] } (xor:{ *:[v2i64] } vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2), TYPE:{ *:[i64] }:$src_ty)  =>  (OpBitwiseXorV:{ *:[v2i64] } TYPE:{ *:[i64] }:$src_ty, vID:{ *:[v2i64] }:$src, vID:{ *:[v2i64] }:$src2)
     /* 3681 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpBitwiseXorV),
     /* 3684 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3686 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3688 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3692 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/2, // src2
     /* 3696 */       GIR_RootConstrainSelectedInstOperands,
     /* 3697 */       // GIR_Coverage, 51,
     /* 3697 */       GIR_EraseRootFromParent_Done,
     /* 3698 */     // Label 68: @3698
     /* 3698 */     GIM_Try, /*On fail goto*//*Label 69*/ GIMT_Encode4(3743), // Rule ID 3 //
     /* 3703 */       GIM_RootCheckRegBankForClass, /*Op*/0, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3707 */       GIM_RecordInsn, /*DefineMI*/1, /*MI*/0, /*OpIdx*/1, // MIs[1]
     /* 3711 */       GIM_CheckOpcode, /*MI*/1, GIMT_Encode2(TargetOpcode::G_FNEG),
     /* 3715 */       GIM_CheckType, /*MI*/1, /*Op*/1, /*Type*/GILLT_v2s64,
     /* 3719 */       GIM_CheckRegBankForClass, /*MI*/1, /*Op*/1, /*RC*/GIMT_Encode2(SPIRV::vfIDRegClassID),
     /* 3724 */       GIM_RootCheckRegBankForClass, /*Op*/2, /*RC*/GIMT_Encode2(SPIRV::TYPERegClassID),
     /* 3728 */       GIM_CheckIsSafeToFold, /*NumInsns*/1,
     /* 3730 */       // (assigntype:{ *:[v2f64] } (fneg:{ *:[v2f64] } vfID:{ *:[v2f64] }:$src), TYPE:{ *:[i64] }:$src_ty)  =>  (OpFNegateV:{ *:[v2f64] } TYPE:{ *:[i64] }:$src_ty, vfID:{ *:[v2f64] }:$src)
     /* 3730 */       GIR_BuildRootMI, /*Opcode*/GIMT_Encode2(SPIRV::OpFNegateV),
     /* 3733 */       GIR_RootToRootCopy, /*OpIdx*/0, // DstI[dst]
     /* 3735 */       GIR_RootToRootCopy, /*OpIdx*/2, // src_ty
     /* 3737 */       GIR_Copy, /*NewInsnID*/0, /*OldInsnID*/1, /*OpIdx*/1, // src
     /* 3741 */       GIR_RootConstrainSelectedInstOperands,
     /* 3742 */       // GIR_Coverage, 3,
     /* 3742 */       GIR_EraseRootFromParent_Done,
     /* 3743 */     // Label 69: @3743
     /* 3743 */     GIM_Reject,
     /* 3744 */   // Label 41: @3744
     /* 3744 */   GIM_Reject,
     /* 3745 */   // Label 4: @3745
     /* 3745 */   GIM_Reject,
     /* 3746 */ // Label 0: @3746
     /* 3746 */ GIM_Reject,
     /* 3747 */ }; // Size: 3747 bytes
  return MatchTable0;
}
#undef GIMT_Encode2
#undef GIMT_Encode4
#undef GIMT_Encode8

#endif // ifdef GET_GLOBALISEL_IMPL

#ifdef GET_GLOBALISEL_PREDICATES_DECL
PredicateBitset AvailableModuleFeatures;
mutable PredicateBitset AvailableFunctionFeatures;
PredicateBitset getAvailableFeatures() const {
  return AvailableModuleFeatures | AvailableFunctionFeatures;
}
PredicateBitset
computeAvailableModuleFeatures(const SPIRVSubtarget *Subtarget) const;
PredicateBitset
computeAvailableFunctionFeatures(const SPIRVSubtarget *Subtarget,
                                 const MachineFunction *MF) const;
void setupGeneratedPerFunctionState(MachineFunction &MF) override;
#endif // ifdef GET_GLOBALISEL_PREDICATES_DECL
#ifdef GET_GLOBALISEL_PREDICATES_INIT
AvailableModuleFeatures(computeAvailableModuleFeatures(&STI)),
AvailableFunctionFeatures()
#endif // ifdef GET_GLOBALISEL_PREDICATES_INIT
