// This file is @generated by prost-build.
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct ApiVersion {
    #[prost(uint32, required, tag = "1")]
    pub major: u32,
    #[prost(uint32, required, tag = "2")]
    pub minor: u32,
    #[prost(uint32, optional, tag = "3")]
    pub patch: ::core::option::Option<u32>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, ::prost::Message)]
pub struct Process {
    #[prost(enumeration = "process::Kind", optional, tag = "1")]
    pub kind: ::core::option::Option<i32>,
    #[prost(uint64, optional, tag = "2")]
    pub memory_usage_bytes: ::core::option::Option<u64>,
    #[prost(float, optional, tag = "3")]
    pub gpu_usage_percent: ::core::option::Option<f32>,
    #[prost(float, optional, tag = "4")]
    pub encode_usage_percent: ::core::option::Option<f32>,
    #[prost(float, optional, tag = "5")]
    pub decode_usage_percent: ::core::option::Option<f32>,
}
/// Nested message and enum types in `Process`.
pub mod process {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(
        Clone,
        Copy,
        Debug,
        PartialEq,
        Eq,
        Hash,
        PartialOrd,
        Ord,
        ::prost::Enumeration
    )]
    #[repr(i32)]
    pub enum Kind {
        Graphical = 0,
        Compute = 1,
        GraphicalCompute = 2,
    }
    impl Kind {
        /// String value of the enum field names used in the ProtoBuf definition.
        ///
        /// The values are not transformed in any way and thus are considered stable
        /// (if the ProtoBuf definition does not change) and safe for programmatic use.
        pub fn as_str_name(&self) -> &'static str {
            match self {
                Self::Graphical => "Graphical",
                Self::Compute => "Compute",
                Self::GraphicalCompute => "GraphicalCompute",
            }
        }
        /// Creates an enum from field names used in the ProtoBuf definition.
        pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
            match value {
                "Graphical" => Some(Self::Graphical),
                "Compute" => Some(Self::Compute),
                "GraphicalCompute" => Some(Self::GraphicalCompute),
                _ => None,
            }
        }
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct Gpu {
    #[prost(string, required, tag = "1")]
    pub id: ::prost::alloc::string::String,
    #[prost(string, optional, tag = "2")]
    pub device_name: ::core::option::Option<::prost::alloc::string::String>,
    #[prost(uint32, required, tag = "3")]
    pub vendor_id: u32,
    #[prost(uint32, required, tag = "4")]
    pub device_id: u32,
    #[prost(float, optional, tag = "5")]
    pub temperature_c: ::core::option::Option<f32>,
    #[prost(float, optional, tag = "6")]
    pub fan_speed_percent: ::core::option::Option<f32>,
    #[prost(float, optional, tag = "7")]
    pub utilization_percent: ::core::option::Option<f32>,
    #[prost(float, optional, tag = "8")]
    pub power_draw_watts: ::core::option::Option<f32>,
    #[prost(float, optional, tag = "9")]
    pub max_power_draw_watts: ::core::option::Option<f32>,
    #[prost(uint32, optional, tag = "10")]
    pub clock_speed_mhz: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "11")]
    pub max_clock_speed_mhz: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "12")]
    pub memory_speed_mhz: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "13")]
    pub max_memory_speed_mhz: ::core::option::Option<u32>,
    #[prost(uint64, optional, tag = "14")]
    pub total_memory: ::core::option::Option<u64>,
    #[prost(uint64, optional, tag = "15")]
    pub used_memory: ::core::option::Option<u64>,
    #[prost(uint64, optional, tag = "16")]
    pub total_shared_memory: ::core::option::Option<u64>,
    #[prost(uint64, optional, tag = "17")]
    pub used_shared_memory: ::core::option::Option<u64>,
    #[prost(float, optional, tag = "18")]
    pub encoder_percent: ::core::option::Option<f32>,
    #[prost(float, optional, tag = "19")]
    pub decoder_percent: ::core::option::Option<f32>,
    #[prost(uint32, optional, tag = "20")]
    pub pcie_gen: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "21")]
    pub pcie_lanes: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "22")]
    pub max_pcie_gen: ::core::option::Option<u32>,
    #[prost(uint32, optional, tag = "23")]
    pub max_pcie_lanes: ::core::option::Option<u32>,
    #[prost(enumeration = "OpenGlVariant", optional, tag = "24")]
    pub opengl_variant: ::core::option::Option<i32>,
    #[prost(message, optional, tag = "25")]
    pub opengl_version: ::core::option::Option<ApiVersion>,
    #[prost(message, optional, tag = "26")]
    pub vulkan_version: ::core::option::Option<ApiVersion>,
    #[prost(message, optional, tag = "27")]
    pub metal_version: ::core::option::Option<ApiVersion>,
    #[prost(message, optional, tag = "28")]
    pub directx_version: ::core::option::Option<ApiVersion>,
    #[prost(message, optional, tag = "29")]
    pub opencl_version: ::core::option::Option<ApiVersion>,
    #[prost(message, optional, tag = "30")]
    pub cuda_version: ::core::option::Option<ApiVersion>,
    #[prost(bool, required, tag = "32")]
    pub encode_decode_shared: bool,
    #[prost(map = "uint32, message", tag = "33")]
    pub processes: ::std::collections::HashMap<u32, Process>,
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GpusRequest {}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, PartialEq, ::prost::Message)]
pub struct GpusResponse {
    #[prost(oneof = "gpus_response::Response", tags = "1, 2")]
    pub response: ::core::option::Option<gpus_response::Response>,
}
/// Nested message and enum types in `GpusResponse`.
pub mod gpus_response {
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(Clone, PartialEq, ::prost::Message)]
    pub struct GpuMap {
        #[prost(map = "string, message", tag = "1")]
        pub gpus: ::std::collections::HashMap<
            ::prost::alloc::string::String,
            super::Gpu,
        >,
    }
    #[derive(serde::Serialize, serde::Deserialize)]
    #[serde(rename_all = "snake_case")]
    #[derive(strum::EnumIter)]
    #[derive(Clone, PartialEq, ::prost::Oneof)]
    pub enum Response {
        #[prost(message, tag = "1")]
        Gpus(GpuMap),
        #[prost(message, tag = "2")]
        Error(super::GpusResponseError),
    }
}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(Clone, Copy, PartialEq, Eq, Hash, ::prost::Message)]
pub struct GpusResponseError {}
#[derive(serde::Serialize, serde::Deserialize)]
#[serde(rename_all = "snake_case")]
#[derive(strum::EnumIter)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord, ::prost::Enumeration)]
#[repr(i32)]
pub enum OpenGlVariant {
    OpenGl = 0,
    OpenGles = 1,
    Invalid = 255,
}
impl OpenGlVariant {
    /// String value of the enum field names used in the ProtoBuf definition.
    ///
    /// The values are not transformed in any way and thus are considered stable
    /// (if the ProtoBuf definition does not change) and safe for programmatic use.
    pub fn as_str_name(&self) -> &'static str {
        match self {
            Self::OpenGl => "OpenGL",
            Self::OpenGles => "OpenGLES",
            Self::Invalid => "Invalid",
        }
    }
    /// Creates an enum from field names used in the ProtoBuf definition.
    pub fn from_str_name(value: &str) -> ::core::option::Option<Self> {
        match value {
            "OpenGL" => Some(Self::OpenGl),
            "OpenGLES" => Some(Self::OpenGles),
            "Invalid" => Some(Self::Invalid),
            _ => None,
        }
    }
}
