/* Dimensions.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Dimensions.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gtk/gtk.h>
#include <cairo-gobject.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define SCALING_NO_SCALE 0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

static void scaling_init (Scaling *self,
                   ScaleConstraint constraint,
                   gint scale,
                   Dimensions* viewport,
                   gboolean scale_up);
static gint scaling_scale_to_pixels (Scaling *self);
VALA_EXTERN GdkPixbuf* scale_pixbuf (GdkPixbuf* pixbuf,
                         gint scale,
                         GdkInterpType interp,
                         gboolean scale_up);
VALA_EXTERN GdkPixbuf* resize_pixbuf (GdkPixbuf* pixbuf,
                          Dimensions* resized,
                          GdkInterpType interp);
static void zoom_state_compute_zoom_factors (ZoomState *self);
static void zoom_state_center_viewport (ZoomState *self);
static void zoom_state_clamp_viewport_center (ZoomState *self);

gchar*
scale_constraint_to_string (ScaleConstraint self)
{
	gchar* result;
	switch (self) {
		case SCALE_CONSTRAINT_ORIGINAL:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Original size"));
			result = _tmp0_;
			return result;
		}
		case SCALE_CONSTRAINT_DIMENSIONS:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("Width or height"));
			result = _tmp1_;
			return result;
		}
		case SCALE_CONSTRAINT_WIDTH:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Width"));
			result = _tmp2_;
			return result;
		}
		case SCALE_CONSTRAINT_HEIGHT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Height"));
			result = _tmp3_;
			return result;
		}
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("Fill Viewport");
			result = _tmp4_;
			return result;
		}
		default:
		break;
	}
	g_warn_if_reached ();
	result = NULL;
	return result;
}

static GType
scale_constraint_get_type_once (void)
{
	static const GEnumValue values[] = {{SCALE_CONSTRAINT_ORIGINAL, "SCALE_CONSTRAINT_ORIGINAL", "original"}, {SCALE_CONSTRAINT_DIMENSIONS, "SCALE_CONSTRAINT_DIMENSIONS", "dimensions"}, {SCALE_CONSTRAINT_WIDTH, "SCALE_CONSTRAINT_WIDTH", "width"}, {SCALE_CONSTRAINT_HEIGHT, "SCALE_CONSTRAINT_HEIGHT", "height"}, {SCALE_CONSTRAINT_FILL_VIEWPORT, "SCALE_CONSTRAINT_FILL_VIEWPORT", "fill-viewport"}, {0, NULL, NULL}};
	GType scale_constraint_type_id;
	scale_constraint_type_id = g_enum_register_static ("ScaleConstraint", values);
	return scale_constraint_type_id;
}

GType
scale_constraint_get_type (void)
{
	static volatile gsize scale_constraint_type_id__once = 0;
	if (g_once_init_enter (&scale_constraint_type_id__once)) {
		GType scale_constraint_type_id;
		scale_constraint_type_id = scale_constraint_get_type_once ();
		g_once_init_leave (&scale_constraint_type_id__once, scale_constraint_type_id);
	}
	return scale_constraint_type_id__once;
}

void
dimensions_init (Dimensions *self,
                 gint width,
                 gint height)
{
	gboolean _tmp0_ = FALSE;
	memset (self, 0, sizeof (Dimensions));
	if (width < 0) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = height < 0;
	}
	if (_tmp0_) {
		g_warning ("Dimensions.vala:58: Tried to construct a Dimensions object with negati" \
"ve width or height - forcing sensible default values.");
	}
	(*self).width = CLAMP (width, 0, width);
	(*self).height = CLAMP (height, 0, height);
}

void
dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                       Dimensions* result)
{
	Dimensions _tmp0_ = {0};
	g_return_if_fail (pixbuf != NULL);
	dimensions_init (&_tmp0_, gdk_pixbuf_get_width (pixbuf), gdk_pixbuf_get_height (pixbuf));
	*result = _tmp0_;
	return;
}

void
dimensions_for_allocation (GtkAllocation* allocation,
                           Dimensions* result)
{
	GtkAllocation _tmp0_;
	GtkAllocation _tmp1_;
	Dimensions _tmp2_ = {0};
	g_return_if_fail (allocation != NULL);
	_tmp0_ = *allocation;
	_tmp1_ = *allocation;
	dimensions_init (&_tmp2_, _tmp0_.width, _tmp1_.height);
	*result = _tmp2_;
	return;
}

void
dimensions_for_widget_allocation (GtkWidget* widget,
                                  Dimensions* result)
{
	GtkAllocation allocation = {0};
	GtkAllocation _tmp0_ = {0};
	gint scale_factor = 0;
	gint _tmp1_;
	gint _tmp2_;
	GtkAllocation _tmp3_;
	GtkAllocation _tmp4_;
	Dimensions _tmp5_ = {0};
	g_return_if_fail (widget != NULL);
	gtk_widget_get_allocation (widget, &_tmp0_);
	allocation = _tmp0_;
	_tmp1_ = gtk_widget_get_scale_factor (widget);
	_tmp2_ = _tmp1_;
	scale_factor = _tmp2_;
	_tmp3_ = allocation;
	_tmp4_ = allocation;
	dimensions_init (&_tmp5_, _tmp3_.width * scale_factor, _tmp4_.height * scale_factor);
	*result = _tmp5_;
	return;
}

void
dimensions_for_rectangle (GdkRectangle* rect,
                          Dimensions* result)
{
	GdkRectangle _tmp0_;
	GdkRectangle _tmp1_;
	Dimensions _tmp2_ = {0};
	g_return_if_fail (rect != NULL);
	_tmp0_ = *rect;
	_tmp1_ = *rect;
	dimensions_init (&_tmp2_, _tmp0_.width, _tmp1_.height);
	*result = _tmp2_;
	return;
}

gboolean
dimensions_has_area (Dimensions *self)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if ((*self).width > 0) {
		_tmp0_ = (*self).height > 0;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

void
dimensions_floor (Dimensions *self,
                  Dimensions* min,
                  Dimensions* result)
{
	gint _tmp0_ = 0;
	Dimensions _tmp1_;
	gint _tmp3_ = 0;
	Dimensions _tmp4_;
	Dimensions _tmp6_ = {0};
	g_return_if_fail (min != NULL);
	_tmp1_ = *min;
	if ((*self).width > _tmp1_.width) {
		_tmp0_ = (*self).width;
	} else {
		Dimensions _tmp2_;
		_tmp2_ = *min;
		_tmp0_ = _tmp2_.width;
	}
	_tmp4_ = *min;
	if ((*self).height > _tmp4_.height) {
		_tmp3_ = (*self).height;
	} else {
		Dimensions _tmp5_;
		_tmp5_ = *min;
		_tmp3_ = _tmp5_.height;
	}
	dimensions_init (&_tmp6_, _tmp0_, _tmp3_);
	*result = _tmp6_;
	return;
}

gchar*
dimensions_to_string (Dimensions *self)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf ("%dx%d", (*self).width, (*self).height);
	result = _tmp0_;
	return result;
}

gboolean
dimensions_equals (Dimensions *self,
                   Dimensions* dim)
{
	gboolean _tmp0_ = FALSE;
	Dimensions _tmp1_;
	gboolean result;
	g_return_val_if_fail (dim != NULL, FALSE);
	_tmp1_ = *dim;
	if ((*self).width == _tmp1_.width) {
		Dimensions _tmp2_;
		_tmp2_ = *dim;
		_tmp0_ = (*self).height == _tmp2_.height;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
dimensions_approx_equals (Dimensions *self,
                          Dimensions* dim,
                          gint fudge)
{
	gboolean _tmp0_ = FALSE;
	Dimensions _tmp1_;
	gboolean result;
	g_return_val_if_fail (dim != NULL, FALSE);
	_tmp1_ = *dim;
	if (abs ((*self).width - _tmp1_.width) <= fudge) {
		Dimensions _tmp2_;
		_tmp2_ = *dim;
		_tmp0_ = abs ((*self).height - _tmp2_.height) <= fudge;
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gboolean
dimensions_approx_scaled (Dimensions *self,
                          gint scale,
                          gint fudge)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	if ((*self).width <= (scale + fudge)) {
		_tmp0_ = (*self).height <= (scale + fudge);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

gint
dimensions_major_axis (Dimensions *self)
{
	gint result;
	result = MAX ((*self).width, (*self).height);
	return result;
}

gint
dimensions_minor_axis (Dimensions *self)
{
	gint result;
	result = MIN ((*self).width, (*self).height);
	return result;
}

void
dimensions_with_min (Dimensions *self,
                     gint min_width,
                     gint min_height,
                     Dimensions* result)
{
	Dimensions _tmp0_ = {0};
	dimensions_init (&_tmp0_, MAX ((*self).width, min_width), MAX ((*self).height, min_height));
	*result = _tmp0_;
	return;
}

void
dimensions_with_max (Dimensions *self,
                     gint max_width,
                     gint max_height,
                     Dimensions* result)
{
	Dimensions _tmp0_ = {0};
	dimensions_init (&_tmp0_, MIN ((*self).width, max_width), MIN ((*self).height, max_height));
	*result = _tmp0_;
	return;
}

void
dimensions_get_scaled (Dimensions *self,
                       gint scale,
                       gboolean scale_up,
                       Dimensions* result)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp4_ = FALSE;
	_vala_assert (scale > 0, "scale > 0");
	if ((*self).width == scale) {
		_tmp1_ = (*self).height < scale;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp2_ = FALSE;
		if ((*self).height == scale) {
			_tmp2_ = (*self).width < scale;
		} else {
			_tmp2_ = FALSE;
		}
		_tmp0_ = _tmp2_;
	}
	if (_tmp0_) {
		Dimensions _tmp3_ = {0};
		dimensions_init (&_tmp3_, (*self).width, (*self).height);
		*result = _tmp3_;
		return;
	}
	if (!scale_up) {
		gboolean _tmp5_ = FALSE;
		if ((*self).width < scale) {
			_tmp5_ = (*self).height < scale;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp4_ = _tmp5_;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Dimensions _tmp6_ = {0};
		dimensions_init (&_tmp6_, (*self).width, (*self).height);
		*result = _tmp6_;
		return;
	}
	if (((*self).width - scale) > ((*self).height - scale)) {
		Dimensions _tmp7_ = {0};
		dimensions_get_scaled_by_width (&(*self), scale, &_tmp7_);
		*result = _tmp7_;
		return;
	} else {
		Dimensions _tmp8_ = {0};
		dimensions_get_scaled_by_height (&(*self), scale, &_tmp8_);
		*result = _tmp8_;
		return;
	}
}

void
dimensions_get_scale_ratios (Dimensions *self,
                             Dimensions* scaled,
                             gdouble* width_ratio,
                             gdouble* height_ratio)
{
	gdouble _vala_width_ratio = 0.0;
	gdouble _vala_height_ratio = 0.0;
	Dimensions _tmp0_;
	Dimensions _tmp1_;
	g_return_if_fail (scaled != NULL);
	_tmp0_ = *scaled;
	_vala_width_ratio = ((gdouble) _tmp0_.width) / ((gdouble) (*self).width);
	_tmp1_ = *scaled;
	_vala_height_ratio = ((gdouble) _tmp1_.height) / ((gdouble) (*self).height);
	if (width_ratio) {
		*width_ratio = _vala_width_ratio;
	}
	if (height_ratio) {
		*height_ratio = _vala_height_ratio;
	}
}

gdouble
dimensions_get_aspect_ratio (Dimensions *self)
{
	gdouble result;
	result = ((gdouble) (*self).width) / (*self).height;
	return result;
}

void
dimensions_get_scaled_proportional (Dimensions *self,
                                    Dimensions* viewport,
                                    Dimensions* result)
{
	gdouble width_ratio = 0.0;
	gdouble height_ratio = 0.0;
	Dimensions _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble scaled_width = 0.0;
	gdouble scaled_height = 0.0;
	Dimensions scaled = {0};
	Dimensions _tmp5_ = {0};
	Dimensions _tmp6_ = {0};
	Dimensions _tmp7_ = {0};
	Dimensions _tmp8_;
	Dimensions _tmp9_;
	Dimensions _tmp10_;
	Dimensions _tmp11_;
	g_return_if_fail (viewport != NULL);
	_tmp0_ = *viewport;
	dimensions_get_scale_ratios (&(*self), &_tmp0_, &_tmp1_, &_tmp2_);
	width_ratio = _tmp1_;
	height_ratio = _tmp2_;
	if (width_ratio < height_ratio) {
		Dimensions _tmp3_;
		_tmp3_ = *viewport;
		scaled_width = (gdouble) _tmp3_.width;
		scaled_height = ((gdouble) (*self).height) * width_ratio;
	} else {
		Dimensions _tmp4_;
		scaled_width = ((gdouble) (*self).width) * height_ratio;
		_tmp4_ = *viewport;
		scaled_height = (gdouble) _tmp4_.height;
	}
	dimensions_init (&_tmp5_, (gint) round (scaled_width), (gint) round (scaled_height));
	dimensions_init (&_tmp6_, 1, 1);
	dimensions_floor (&_tmp5_, &_tmp6_, &_tmp7_);
	scaled = _tmp7_;
	_tmp8_ = scaled;
	_tmp9_ = *viewport;
	_vala_assert (_tmp8_.height <= _tmp9_.height, "scaled.height <= viewport.height");
	_tmp10_ = scaled;
	_tmp11_ = *viewport;
	_vala_assert (_tmp10_.width <= _tmp11_.width, "scaled.width <= viewport.width");
	*result = scaled;
	return;
}

void
dimensions_get_scaled_to_fill_viewport (Dimensions *self,
                                        Dimensions* viewport,
                                        Dimensions* result)
{
	gdouble width_ratio = 0.0;
	gdouble height_ratio = 0.0;
	Dimensions _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble scaled_width = 0.0;
	gdouble scaled_height = 0.0;
	gboolean _tmp3_ = FALSE;
	Dimensions _tmp4_;
	Dimensions _tmp11_ = {0};
	Dimensions _tmp12_ = {0};
	Dimensions _tmp13_ = {0};
	g_return_if_fail (viewport != NULL);
	_tmp0_ = *viewport;
	dimensions_get_scale_ratios (&(*self), &_tmp0_, &_tmp1_, &_tmp2_);
	width_ratio = _tmp1_;
	height_ratio = _tmp2_;
	_tmp4_ = *viewport;
	if ((*self).width < _tmp4_.width) {
		Dimensions _tmp5_;
		_tmp5_ = *viewport;
		_tmp3_ = (*self).height >= _tmp5_.height;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		Dimensions _tmp6_;
		_tmp6_ = *viewport;
		scaled_width = (gdouble) _tmp6_.width;
		scaled_height = ((gdouble) (*self).height) * width_ratio;
	} else {
		gboolean _tmp7_ = FALSE;
		Dimensions _tmp8_;
		_tmp8_ = *viewport;
		if ((*self).width >= _tmp8_.width) {
			Dimensions _tmp9_;
			_tmp9_ = *viewport;
			_tmp7_ = (*self).height < _tmp9_.height;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			Dimensions _tmp10_;
			scaled_width = ((gdouble) (*self).width) * height_ratio;
			_tmp10_ = *viewport;
			scaled_height = (gdouble) _tmp10_.height;
		} else {
			gdouble ratio = 0.0;
			ratio = MAX (width_ratio, height_ratio);
			scaled_width = ((gdouble) (*self).width) * ratio;
			scaled_height = ((gdouble) (*self).height) * ratio;
		}
	}
	dimensions_init (&_tmp11_, (gint) round (scaled_width), (gint) round (scaled_height));
	dimensions_init (&_tmp12_, 1, 1);
	dimensions_floor (&_tmp11_, &_tmp12_, &_tmp13_);
	*result = _tmp13_;
	return;
}

void
dimensions_get_scaled_rectangle (Dimensions *self,
                                 Dimensions* scaled,
                                 GdkRectangle* rect,
                                 GdkRectangle* result)
{
	gdouble x_scale = 0.0;
	gdouble y_scale = 0.0;
	Dimensions _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	GdkRectangle scaled_rect = {0};
	GdkRectangle _tmp3_;
	GdkRectangle _tmp4_;
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	GdkRectangle _tmp8_;
	g_return_if_fail (scaled != NULL);
	g_return_if_fail (rect != NULL);
	_tmp0_ = *scaled;
	dimensions_get_scale_ratios (&(*self), &_tmp0_, &_tmp1_, &_tmp2_);
	x_scale = _tmp1_;
	y_scale = _tmp2_;
	memset (&scaled_rect, 0, sizeof (GdkRectangle));
	_tmp3_ = *rect;
	scaled_rect.x = (gint) round (((gdouble) _tmp3_.x) * x_scale);
	_tmp4_ = *rect;
	scaled_rect.y = (gint) round (((gdouble) _tmp4_.y) * y_scale);
	_tmp5_ = *rect;
	scaled_rect.width = (gint) round (((gdouble) _tmp5_.width) * x_scale);
	_tmp6_ = *rect;
	scaled_rect.height = (gint) round (((gdouble) _tmp6_.height) * y_scale);
	_tmp7_ = scaled_rect;
	if (_tmp7_.width <= 0) {
		scaled_rect.width = 1;
	}
	_tmp8_ = scaled_rect;
	if (_tmp8_.height <= 0) {
		scaled_rect.height = 1;
	}
	*result = scaled_rect;
	return;
}

void
dimensions_get_scaled_similar (Dimensions *self,
                               Dimensions* original,
                               Dimensions* scaled,
                               Dimensions* result)
{
	gdouble x_scale = 0.0;
	gdouble y_scale = 0.0;
	Dimensions _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	gdouble scale = 0.0;
	Dimensions _tmp3_ = {0};
	Dimensions _tmp4_ = {0};
	Dimensions _tmp5_ = {0};
	g_return_if_fail (original != NULL);
	g_return_if_fail (scaled != NULL);
	_tmp0_ = *scaled;
	dimensions_get_scale_ratios (original, &_tmp0_, &_tmp1_, &_tmp2_);
	x_scale = _tmp1_;
	y_scale = _tmp2_;
	scale = MIN (x_scale, y_scale);
	dimensions_init (&_tmp3_, (gint) round (((gdouble) (*self).width) * scale), (gint) round (((gdouble) (*self).height) * scale));
	dimensions_init (&_tmp4_, 1, 1);
	dimensions_floor (&_tmp3_, &_tmp4_, &_tmp5_);
	*result = _tmp5_;
	return;
}

void
dimensions_get_scaled_by_width (Dimensions *self,
                                gint scale,
                                Dimensions* result)
{
	gdouble ratio = 0.0;
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	Dimensions _tmp2_ = {0};
	_vala_assert (scale > 0, "scale > 0");
	ratio = ((gdouble) scale) / ((gdouble) (*self).width);
	dimensions_init (&_tmp0_, scale, (gint) round (((gdouble) (*self).height) * ratio));
	dimensions_init (&_tmp1_, 1, 1);
	dimensions_floor (&_tmp0_, &_tmp1_, &_tmp2_);
	*result = _tmp2_;
	return;
}

void
dimensions_get_scaled_by_height (Dimensions *self,
                                 gint scale,
                                 Dimensions* result)
{
	gdouble ratio = 0.0;
	Dimensions _tmp0_ = {0};
	Dimensions _tmp1_ = {0};
	Dimensions _tmp2_ = {0};
	_vala_assert (scale > 0, "scale > 0");
	ratio = ((gdouble) scale) / ((gdouble) (*self).height);
	dimensions_init (&_tmp0_, (gint) round (((gdouble) (*self).width) * ratio), scale);
	dimensions_init (&_tmp1_, 1, 1);
	dimensions_floor (&_tmp0_, &_tmp1_, &_tmp2_);
	*result = _tmp2_;
	return;
}

void
dimensions_get_scaled_by_constraint (Dimensions *self,
                                     gint scale,
                                     ScaleConstraint constraint,
                                     Dimensions* result)
{
	switch (constraint) {
		case SCALE_CONSTRAINT_ORIGINAL:
		{
			Dimensions _tmp0_ = {0};
			dimensions_init (&_tmp0_, (*self).width, (*self).height);
			*result = _tmp0_;
			return;
		}
		case SCALE_CONSTRAINT_DIMENSIONS:
		{
			Dimensions _tmp1_ = {0};
			if ((*self).width >= (*self).height) {
				Dimensions _tmp2_ = {0};
				dimensions_get_scaled_by_width (&(*self), scale, &_tmp2_);
				_tmp1_ = _tmp2_;
			} else {
				Dimensions _tmp3_ = {0};
				dimensions_get_scaled_by_height (&(*self), scale, &_tmp3_);
				_tmp1_ = _tmp3_;
			}
			*result = _tmp1_;
			return;
		}
		case SCALE_CONSTRAINT_WIDTH:
		{
			Dimensions _tmp4_ = {0};
			dimensions_get_scaled_by_width (&(*self), scale, &_tmp4_);
			*result = _tmp4_;
			return;
		}
		case SCALE_CONSTRAINT_HEIGHT:
		{
			Dimensions _tmp5_ = {0};
			dimensions_get_scaled_by_height (&(*self), scale, &_tmp5_);
			*result = _tmp5_;
			return;
		}
		default:
		{
			Dimensions _tmp6_ = {0};
			g_critical ("Dimensions.vala:258: Bad constraint: %d; returning original", (gint) constraint);
			dimensions_init (&_tmp6_, (*self).width, (*self).height);
			*result = _tmp6_;
			return;
		}
	}
}

Dimensions*
dimensions_dup (const Dimensions* self)
{
	Dimensions* dup;
	dup = g_new0 (Dimensions, 1);
	memcpy (dup, self, sizeof (Dimensions));
	return dup;
}

void
dimensions_free (Dimensions* self)
{
	g_free (self);
}

static GType
dimensions_get_type_once (void)
{
	GType dimensions_type_id;
	dimensions_type_id = g_boxed_type_register_static ("Dimensions", (GBoxedCopyFunc) dimensions_dup, (GBoxedFreeFunc) dimensions_free);
	return dimensions_type_id;
}

GType
dimensions_get_type (void)
{
	static volatile gsize dimensions_type_id__once = 0;
	if (g_once_init_enter (&dimensions_type_id__once)) {
		GType dimensions_type_id;
		dimensions_type_id = dimensions_get_type_once ();
		g_once_init_leave (&dimensions_type_id__once, dimensions_type_id);
	}
	return dimensions_type_id__once;
}

static void
scaling_init (Scaling *self,
              ScaleConstraint constraint,
              gint scale,
              Dimensions* viewport,
              gboolean scale_up)
{
	Dimensions _tmp0_;
	g_return_if_fail (viewport != NULL);
	memset (self, 0, sizeof (Scaling));
	(*self).constraint = constraint;
	(*self).scale = scale;
	_tmp0_ = *viewport;
	(*self).viewport = _tmp0_;
	(*self).scale_up = scale_up;
}

void
scaling_for_original (Scaling* result)
{
	Dimensions _tmp0_ = {0};
	Scaling _tmp1_ = {0};
	dimensions_init (&_tmp0_, 0, 0);
	scaling_init (&_tmp1_, SCALE_CONSTRAINT_ORIGINAL, SCALING_NO_SCALE, &_tmp0_, FALSE);
	*result = _tmp1_;
	return;
}

void
scaling_for_screen (GtkWindow* window,
                    gboolean scale_up,
                    Scaling* result)
{
	Dimensions _tmp0_ = {0};
	Scaling _tmp1_ = {0};
	g_return_if_fail (window != NULL);
	scaling_get_screen_dimensions (window, &_tmp0_);
	scaling_for_viewport (&_tmp0_, scale_up, &_tmp1_);
	*result = _tmp1_;
	return;
}

void
scaling_for_best_fit (gint pixels,
                      gboolean scale_up,
                      Scaling* result)
{
	Dimensions _tmp0_ = {0};
	Scaling _tmp1_ = {0};
	_vala_assert (pixels > 0, "pixels > 0");
	dimensions_init (&_tmp0_, 0, 0);
	scaling_init (&_tmp1_, SCALE_CONSTRAINT_DIMENSIONS, pixels, &_tmp0_, scale_up);
	*result = _tmp1_;
	return;
}

void
scaling_for_viewport (Dimensions* viewport,
                      gboolean scale_up,
                      Scaling* result)
{
	Dimensions _tmp0_;
	Scaling _tmp1_ = {0};
	g_return_if_fail (viewport != NULL);
	_vala_assert (dimensions_has_area (viewport), "viewport.has_area ()");
	_tmp0_ = *viewport;
	scaling_init (&_tmp1_, SCALE_CONSTRAINT_DIMENSIONS, SCALING_NO_SCALE, &_tmp0_, scale_up);
	*result = _tmp1_;
	return;
}

void
scaling_for_widget (GtkWidget* widget,
                    gboolean scale_up,
                    Scaling* result)
{
	Dimensions viewport = {0};
	Dimensions _tmp0_ = {0};
	gint scale_factor = 0;
	gint _tmp1_;
	gint _tmp2_;
	gboolean _tmp3_ = FALSE;
	Dimensions _tmp4_;
	Dimensions _tmp7_;
	Scaling _tmp8_ = {0};
	g_return_if_fail (widget != NULL);
	dimensions_for_widget_allocation (widget, &_tmp0_);
	viewport = _tmp0_;
	_tmp1_ = gtk_widget_get_scale_factor (widget);
	_tmp2_ = _tmp1_;
	scale_factor = _tmp2_;
	_tmp4_ = viewport;
	if (_tmp4_.width <= (1 * scale_factor)) {
		_tmp3_ = TRUE;
	} else {
		Dimensions _tmp5_;
		_tmp5_ = viewport;
		_tmp3_ = _tmp5_.height <= (1 * scale_factor);
	}
	if (_tmp3_) {
		Scaling _tmp6_ = {0};
		scaling_for_original (&_tmp6_);
		*result = _tmp6_;
		return;
	}
	_tmp7_ = viewport;
	scaling_init (&_tmp8_, SCALE_CONSTRAINT_DIMENSIONS, SCALING_NO_SCALE, &_tmp7_, scale_up);
	*result = _tmp8_;
	return;
}

void
scaling_to_fill_viewport (Dimensions* viewport,
                          Scaling* result)
{
	gboolean _tmp0_ = FALSE;
	Dimensions _tmp1_;
	Dimensions _tmp4_;
	Scaling _tmp5_ = {0};
	g_return_if_fail (viewport != NULL);
	_tmp1_ = *viewport;
	if (_tmp1_.width <= 1) {
		_tmp0_ = TRUE;
	} else {
		Dimensions _tmp2_;
		_tmp2_ = *viewport;
		_tmp0_ = _tmp2_.height <= 1;
	}
	if (_tmp0_) {
		Scaling _tmp3_ = {0};
		scaling_for_original (&_tmp3_);
		*result = _tmp3_;
		return;
	}
	_tmp4_ = *viewport;
	scaling_init (&_tmp5_, SCALE_CONSTRAINT_FILL_VIEWPORT, SCALING_NO_SCALE, &_tmp4_, TRUE);
	*result = _tmp5_;
	return;
}

void
scaling_to_fill_screen (GtkWindow* window,
                        Scaling* result)
{
	Dimensions _tmp0_ = {0};
	Scaling _tmp1_ = {0};
	g_return_if_fail (window != NULL);
	scaling_get_screen_dimensions (window, &_tmp0_);
	scaling_to_fill_viewport (&_tmp0_, &_tmp1_);
	*result = _tmp1_;
	return;
}

void
scaling_for_constraint (ScaleConstraint constraint,
                        gint scale,
                        gboolean scale_up,
                        Scaling* result)
{
	Dimensions _tmp0_ = {0};
	Scaling _tmp1_ = {0};
	dimensions_init (&_tmp0_, 0, 0);
	scaling_init (&_tmp1_, constraint, scale, &_tmp0_, scale_up);
	*result = _tmp1_;
	return;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

void
scaling_get_screen_dimensions (GtkWindow* window,
                               Dimensions* result)
{
	GdkDisplay* display = NULL;
	GdkWindow* _tmp0_;
	GdkDisplay* _tmp1_;
	GdkDisplay* _tmp2_;
	GdkMonitor* monitor = NULL;
	GdkWindow* _tmp3_;
	GdkMonitor* _tmp4_;
	GdkMonitor* _tmp5_;
	GdkRectangle geometry = {0};
	GdkRectangle _tmp6_ = {0};
	gint scale_factor = 0;
	gint _tmp7_;
	gint _tmp8_;
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_;
	Dimensions _tmp11_ = {0};
	g_return_if_fail (window != NULL);
	_tmp0_ = gtk_widget_get_window ((GtkWidget*) window);
	_tmp1_ = gdk_window_get_display (_tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	display = _tmp2_;
	_tmp3_ = gtk_widget_get_window ((GtkWidget*) window);
	_tmp4_ = gdk_display_get_monitor_at_window (display, _tmp3_);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	monitor = _tmp5_;
	gdk_monitor_get_geometry (monitor, &_tmp6_);
	geometry = _tmp6_;
	_tmp7_ = gtk_widget_get_scale_factor ((GtkWidget*) window);
	_tmp8_ = _tmp7_;
	scale_factor = _tmp8_;
	_tmp9_ = geometry;
	_tmp10_ = geometry;
	dimensions_init (&_tmp11_, _tmp9_.width * scale_factor, _tmp10_.height * scale_factor);
	*result = _tmp11_;
	_g_object_unref0 (monitor);
	_g_object_unref0 (display);
	return;
}

static gint
scaling_scale_to_pixels (Scaling *self)
{
	gint _tmp0_ = 0;
	gint result;
	if ((*self).scale >= 0) {
		_tmp0_ = (*self).scale;
	} else {
		_tmp0_ = 0;
	}
	result = _tmp0_;
	return result;
}

gboolean
scaling_is_unscaled (Scaling *self)
{
	gboolean result;
	result = (*self).constraint == SCALE_CONSTRAINT_ORIGINAL;
	return result;
}

gboolean
scaling_is_best_fit (Scaling *self,
                     Dimensions* original,
                     gint* pixels)
{
	gint _vala_pixels = 0;
	gboolean result;
	g_return_val_if_fail (original != NULL, FALSE);
	_vala_pixels = 0;
	if ((*self).scale == SCALING_NO_SCALE) {
		result = FALSE;
		if (pixels) {
			*pixels = _vala_pixels;
		}
		return result;
	}
	switch ((*self).constraint) {
		case SCALE_CONSTRAINT_ORIGINAL:
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
		{
			result = FALSE;
			if (pixels) {
				*pixels = _vala_pixels;
			}
			return result;
		}
		default:
		{
			_vala_pixels = scaling_scale_to_pixels (&(*self));
			_vala_assert (_vala_pixels > 0, "pixels > 0");
			result = TRUE;
			if (pixels) {
				*pixels = _vala_pixels;
			}
			return result;
		}
	}
}

gboolean
scaling_is_best_fit_dimensions (Scaling *self,
                                Dimensions* original,
                                Dimensions* scaled)
{
	Dimensions _vala_scaled = {0};
	gboolean result;
	g_return_val_if_fail (original != NULL, FALSE);
	dimensions_init (&_vala_scaled, 0, 0);
	if ((*self).scale == SCALING_NO_SCALE) {
		result = FALSE;
		if (scaled) {
			*scaled = _vala_scaled;
		}
		return result;
	}
	switch ((*self).constraint) {
		case SCALE_CONSTRAINT_ORIGINAL:
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
		{
			result = FALSE;
			if (scaled) {
				*scaled = _vala_scaled;
			}
			return result;
		}
		default:
		{
			gint pixels = 0;
			Dimensions _tmp0_ = {0};
			pixels = scaling_scale_to_pixels (&(*self));
			_vala_assert (pixels > 0, "pixels > 0");
			dimensions_get_scaled_by_constraint (original, pixels, (*self).constraint, &_tmp0_);
			_vala_scaled = _tmp0_;
			result = TRUE;
			if (scaled) {
				*scaled = _vala_scaled;
			}
			return result;
		}
	}
}

gboolean
scaling_is_for_viewport (Scaling *self,
                         Dimensions* original,
                         Dimensions* scaled)
{
	Dimensions _vala_scaled = {0};
	gboolean result;
	g_return_val_if_fail (original != NULL, FALSE);
	dimensions_init (&_vala_scaled, 0, 0);
	if ((*self).scale != SCALING_NO_SCALE) {
		result = FALSE;
		if (scaled) {
			*scaled = _vala_scaled;
		}
		return result;
	}
	switch ((*self).constraint) {
		case SCALE_CONSTRAINT_ORIGINAL:
		case SCALE_CONSTRAINT_FILL_VIEWPORT:
		{
			result = FALSE;
			if (scaled) {
				*scaled = _vala_scaled;
			}
			return result;
		}
		default:
		{
			gboolean _tmp0_ = FALSE;
			gboolean _tmp1_ = FALSE;
			_vala_assert (dimensions_has_area (&(*self).viewport), "viewport.has_area ()");
			if (!(*self).scale_up) {
				Dimensions _tmp2_;
				Dimensions _tmp3_;
				_tmp2_ = *original;
				_tmp3_ = (*self).viewport;
				_tmp1_ = _tmp2_.width < _tmp3_.width;
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				Dimensions _tmp4_;
				Dimensions _tmp5_;
				_tmp4_ = *original;
				_tmp5_ = (*self).viewport;
				_tmp0_ = _tmp4_.height < _tmp5_.height;
			} else {
				_tmp0_ = FALSE;
			}
			if (_tmp0_) {
				Dimensions _tmp6_;
				_tmp6_ = *original;
				_vala_scaled = _tmp6_;
			} else {
				Dimensions _tmp7_;
				Dimensions _tmp8_ = {0};
				_tmp7_ = (*self).viewport;
				dimensions_get_scaled_proportional (original, &_tmp7_, &_tmp8_);
				_vala_scaled = _tmp8_;
			}
			result = TRUE;
			if (scaled) {
				*scaled = _vala_scaled;
			}
			return result;
		}
	}
}

gboolean
scaling_is_fill_viewport (Scaling *self,
                          Dimensions* original,
                          Dimensions* scaled)
{
	Dimensions _vala_scaled = {0};
	Dimensions _tmp0_;
	Dimensions _tmp1_ = {0};
	gboolean result;
	g_return_val_if_fail (original != NULL, FALSE);
	dimensions_init (&_vala_scaled, 0, 0);
	if ((*self).constraint != SCALE_CONSTRAINT_FILL_VIEWPORT) {
		result = FALSE;
		if (scaled) {
			*scaled = _vala_scaled;
		}
		return result;
	}
	_vala_assert (dimensions_has_area (&(*self).viewport), "viewport.has_area ()");
	_tmp0_ = (*self).viewport;
	dimensions_get_scaled_to_fill_viewport (original, &_tmp0_, &_tmp1_);
	_vala_scaled = _tmp1_;
	result = TRUE;
	if (scaled) {
		*scaled = _vala_scaled;
	}
	return result;
}

void
scaling_get_scaled_dimensions (Scaling *self,
                               Dimensions* original,
                               Dimensions* result)
{
	Dimensions scaled = {0};
	Dimensions _tmp1_;
	Dimensions _tmp2_ = {0};
	gboolean _tmp3_;
	Dimensions _tmp4_;
	Dimensions _tmp5_ = {0};
	gboolean _tmp6_;
	gboolean is_viewport = FALSE;
	Dimensions _tmp7_;
	Dimensions _tmp8_ = {0};
	gboolean _tmp9_;
	g_return_if_fail (original != NULL);
	if (scaling_is_unscaled (&(*self))) {
		Dimensions _tmp0_;
		_tmp0_ = *original;
		*result = _tmp0_;
		return;
	}
	_tmp1_ = *original;
	_tmp3_ = scaling_is_fill_viewport (&(*self), &_tmp1_, &_tmp2_);
	scaled = _tmp2_;
	if (_tmp3_) {
		*result = scaled;
		return;
	}
	_tmp4_ = *original;
	_tmp6_ = scaling_is_best_fit_dimensions (&(*self), &_tmp4_, &_tmp5_);
	scaled = _tmp5_;
	if (_tmp6_) {
		*result = scaled;
		return;
	}
	_tmp7_ = *original;
	_tmp9_ = scaling_is_for_viewport (&(*self), &_tmp7_, &_tmp8_);
	scaled = _tmp8_;
	is_viewport = _tmp9_;
	_vala_assert (is_viewport, "is_viewport");
	*result = scaled;
	return;
}

GdkPixbuf*
scaling_perform_on_pixbuf (Scaling *self,
                           GdkPixbuf* pixbuf,
                           GdkInterpType interp,
                           gboolean scale_up)
{
	Dimensions pixbuf_dim = {0};
	Dimensions _tmp1_ = {0};
	gint pixels = 0;
	Dimensions _tmp2_;
	gint _tmp3_ = 0;
	gboolean _tmp4_;
	Dimensions scaled = {0};
	Dimensions _tmp6_;
	Dimensions _tmp7_ = {0};
	gboolean _tmp8_;
	gboolean is_viewport = FALSE;
	Dimensions _tmp11_;
	Dimensions _tmp12_ = {0};
	gboolean _tmp13_;
	Dimensions _tmp14_;
	GdkPixbuf* _tmp15_;
	GdkPixbuf* result;
	g_return_val_if_fail (pixbuf != NULL, NULL);
	if (scaling_is_unscaled (&(*self))) {
		GdkPixbuf* _tmp0_;
		_tmp0_ = _g_object_ref0 (pixbuf);
		result = _tmp0_;
		return result;
	}
	dimensions_for_pixbuf (pixbuf, &_tmp1_);
	pixbuf_dim = _tmp1_;
	_tmp2_ = pixbuf_dim;
	_tmp4_ = scaling_is_best_fit (&(*self), &_tmp2_, &_tmp3_);
	pixels = _tmp3_;
	if (_tmp4_) {
		GdkPixbuf* _tmp5_;
		_tmp5_ = scale_pixbuf (pixbuf, pixels, interp, scale_up);
		result = _tmp5_;
		return result;
	}
	_tmp6_ = pixbuf_dim;
	_tmp8_ = scaling_is_fill_viewport (&(*self), &_tmp6_, &_tmp7_);
	scaled = _tmp7_;
	if (_tmp8_) {
		Dimensions _tmp9_;
		GdkPixbuf* _tmp10_;
		_tmp9_ = scaled;
		_tmp10_ = resize_pixbuf (pixbuf, &_tmp9_, interp);
		result = _tmp10_;
		return result;
	}
	_tmp11_ = pixbuf_dim;
	_tmp13_ = scaling_is_for_viewport (&(*self), &_tmp11_, &_tmp12_);
	scaled = _tmp12_;
	is_viewport = _tmp13_;
	_vala_assert (is_viewport, "is_viewport");
	_tmp14_ = scaled;
	_tmp15_ = resize_pixbuf (pixbuf, &_tmp14_, interp);
	result = _tmp15_;
	return result;
}

gchar*
scaling_to_string (Scaling *self)
{
	gchar* result;
	if ((*self).constraint == SCALE_CONSTRAINT_ORIGINAL) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("scaling: UNSCALED");
		result = _tmp0_;
		return result;
	} else {
		if ((*self).constraint == SCALE_CONSTRAINT_FILL_VIEWPORT) {
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			gchar* _tmp4_;
			_tmp1_ = dimensions_to_string (&(*self).viewport);
			_tmp2_ = _tmp1_;
			_tmp3_ = g_strdup_printf ("scaling: fill viewport %s", _tmp2_);
			_tmp4_ = _tmp3_;
			_g_free0 (_tmp2_);
			result = _tmp4_;
			return result;
		} else {
			if ((*self).scale != SCALING_NO_SCALE) {
				const gchar* _tmp5_ = NULL;
				gchar* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				gchar* _tmp9_;
				if ((*self).scale_up) {
					_tmp5_ = "scaled up";
				} else {
					_tmp5_ = "not scaled up";
				}
				_tmp6_ = scale_constraint_to_string ((*self).constraint);
				_tmp7_ = _tmp6_;
				_tmp8_ = g_strdup_printf ("scaling: best-fit (%s %d pixels %s)", _tmp7_, scaling_scale_to_pixels (&(*self)), _tmp5_);
				_tmp9_ = _tmp8_;
				_g_free0 (_tmp7_);
				result = _tmp9_;
				return result;
			} else {
				const gchar* _tmp10_ = NULL;
				gchar* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				gchar* _tmp14_;
				if ((*self).scale_up) {
					_tmp10_ = "scaled up";
				} else {
					_tmp10_ = "not scaled up";
				}
				_tmp11_ = dimensions_to_string (&(*self).viewport);
				_tmp12_ = _tmp11_;
				_tmp13_ = g_strdup_printf ("scaling: viewport %s (%s)", _tmp12_, _tmp10_);
				_tmp14_ = _tmp13_;
				_g_free0 (_tmp12_);
				result = _tmp14_;
				return result;
			}
		}
	}
}

gboolean
scaling_equals (Scaling *self,
                Scaling* scaling)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Scaling _tmp2_;
	gboolean result;
	g_return_val_if_fail (scaling != NULL, FALSE);
	_tmp2_ = *scaling;
	if ((*self).constraint == _tmp2_.constraint) {
		Scaling _tmp3_;
		_tmp3_ = *scaling;
		_tmp1_ = (*self).scale == _tmp3_.scale;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		Scaling _tmp4_;
		Dimensions _tmp5_;
		_tmp4_ = *scaling;
		_tmp5_ = _tmp4_.viewport;
		_tmp0_ = dimensions_equals (&(*self).viewport, &_tmp5_);
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

Scaling*
scaling_dup (const Scaling* self)
{
	Scaling* dup;
	dup = g_new0 (Scaling, 1);
	memcpy (dup, self, sizeof (Scaling));
	return dup;
}

void
scaling_free (Scaling* self)
{
	g_free (self);
}

static GType
scaling_get_type_once (void)
{
	GType scaling_type_id;
	scaling_type_id = g_boxed_type_register_static ("Scaling", (GBoxedCopyFunc) scaling_dup, (GBoxedFreeFunc) scaling_free);
	return scaling_type_id;
}

GType
scaling_get_type (void)
{
	static volatile gsize scaling_type_id__once = 0;
	if (g_once_init_enter (&scaling_type_id__once)) {
		GType scaling_type_id;
		scaling_type_id = scaling_get_type_once ();
		g_once_init_leave (&scaling_type_id__once, scaling_type_id);
	}
	return scaling_type_id__once;
}

void
zoom_state_init (ZoomState *self,
                 Dimensions* content_dimensions,
                 Dimensions* viewport_dimensions,
                 gdouble slider_val,
                 GdkPoint* viewport_center)
{
	Dimensions _tmp0_;
	Dimensions _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (content_dimensions != NULL);
	g_return_if_fail (viewport_dimensions != NULL);
	memset (self, 0, sizeof (ZoomState));
	_tmp0_ = *content_dimensions;
	(*self).content_dimensions = _tmp0_;
	_tmp1_ = *viewport_dimensions;
	(*self).viewport_dimensions = _tmp1_;
	(*self).interpolation_factor = slider_val;
	zoom_state_compute_zoom_factors (&(*self));
	if (viewport_center == NULL) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if ((*viewport_center).x == 0) {
			_tmp4_ = (*viewport_center).y == 0;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp3_ = _tmp4_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = slider_val == 0.0;
	}
	if (_tmp2_) {
		zoom_state_center_viewport (&(*self));
	} else {
		(*self).viewport_center = *viewport_center;
		zoom_state_clamp_viewport_center (&(*self));
	}
}

void
zoom_state_init_rescale (ZoomState *self,
                         ZoomState* existing,
                         gdouble new_slider_val)
{
	ZoomState _tmp0_;
	Dimensions _tmp1_;
	ZoomState _tmp2_;
	Dimensions _tmp3_;
	g_return_if_fail (existing != NULL);
	memset (self, 0, sizeof (ZoomState));
	_tmp0_ = *existing;
	_tmp1_ = _tmp0_.content_dimensions;
	(*self).content_dimensions = _tmp1_;
	_tmp2_ = *existing;
	_tmp3_ = _tmp2_.viewport_dimensions;
	(*self).viewport_dimensions = _tmp3_;
	(*self).interpolation_factor = new_slider_val;
	zoom_state_compute_zoom_factors (&(*self));
	if (new_slider_val == 0.0) {
		zoom_state_center_viewport (&(*self));
	} else {
		ZoomState _tmp4_;
		GdkPoint _tmp5_;
		ZoomState _tmp6_;
		ZoomState _tmp7_;
		GdkPoint _tmp8_;
		ZoomState _tmp9_;
		_tmp4_ = *existing;
		_tmp5_ = _tmp4_.viewport_center;
		_tmp6_ = *existing;
		(*self).viewport_center.x = (gint) ((*self).zoom_factor * (_tmp5_.x / _tmp6_.zoom_factor));
		_tmp7_ = *existing;
		_tmp8_ = _tmp7_.viewport_center;
		_tmp9_ = *existing;
		(*self).viewport_center.y = (gint) ((*self).zoom_factor * (_tmp8_.y / _tmp9_.zoom_factor));
		zoom_state_clamp_viewport_center (&(*self));
	}
}

void
zoom_state_init_rescale_to_isomorphic (ZoomState *self,
                                       ZoomState* existing)
{
	ZoomState _tmp0_;
	Dimensions _tmp1_;
	ZoomState _tmp2_;
	Dimensions _tmp3_;
	ZoomState _tmp4_;
	ZoomState _tmp5_;
	ZoomState _tmp6_;
	g_return_if_fail (existing != NULL);
	memset (self, 0, sizeof (ZoomState));
	_tmp0_ = *existing;
	_tmp1_ = _tmp0_.content_dimensions;
	(*self).content_dimensions = _tmp1_;
	_tmp2_ = *existing;
	_tmp3_ = _tmp2_.viewport_dimensions;
	(*self).viewport_dimensions = _tmp3_;
	_tmp4_ = *existing;
	_tmp5_ = *existing;
	_tmp6_ = *existing;
	(*self).interpolation_factor = log (1.0 / _tmp4_.min_factor) / log (_tmp5_.max_factor / _tmp6_.min_factor);
	zoom_state_compute_zoom_factors (&(*self));
	if ((*self).interpolation_factor == 0.0) {
		zoom_state_center_viewport (&(*self));
	} else {
		ZoomState _tmp7_;
		GdkPoint _tmp8_;
		ZoomState _tmp9_;
		ZoomState _tmp10_;
		GdkPoint _tmp11_;
		ZoomState _tmp12_;
		_tmp7_ = *existing;
		_tmp8_ = _tmp7_.viewport_center;
		_tmp9_ = *existing;
		(*self).viewport_center.x = (gint) ((*self).zoom_factor * (_tmp8_.x / _tmp9_.zoom_factor));
		_tmp10_ = *existing;
		_tmp11_ = _tmp10_.viewport_center;
		_tmp12_ = *existing;
		(*self).viewport_center.y = (gint) ((*self).zoom_factor * (_tmp11_.y / _tmp12_.zoom_factor));
		zoom_state_clamp_viewport_center (&(*self));
	}
}

void
zoom_state_init_pan (ZoomState *self,
                     ZoomState* existing,
                     GdkPoint* new_viewport_center)
{
	ZoomState _tmp0_;
	Dimensions _tmp1_;
	ZoomState _tmp2_;
	Dimensions _tmp3_;
	ZoomState _tmp4_;
	GdkPoint _tmp5_;
	g_return_if_fail (existing != NULL);
	g_return_if_fail (new_viewport_center != NULL);
	memset (self, 0, sizeof (ZoomState));
	_tmp0_ = *existing;
	_tmp1_ = _tmp0_.content_dimensions;
	(*self).content_dimensions = _tmp1_;
	_tmp2_ = *existing;
	_tmp3_ = _tmp2_.viewport_dimensions;
	(*self).viewport_dimensions = _tmp3_;
	_tmp4_ = *existing;
	(*self).interpolation_factor = _tmp4_.interpolation_factor;
	zoom_state_compute_zoom_factors (&(*self));
	_tmp5_ = *new_viewport_center;
	(*self).viewport_center = _tmp5_;
	zoom_state_clamp_viewport_center (&(*self));
}

static void
zoom_state_clamp_viewport_center (ZoomState *self)
{
	gint zoomed_width = 0;
	gint zoomed_height = 0;
	GdkPoint _tmp0_;
	Dimensions _tmp1_;
	Dimensions _tmp2_;
	GdkPoint _tmp3_;
	Dimensions _tmp4_;
	Dimensions _tmp5_;
	zoomed_width = zoom_state_get_zoomed_width (&(*self));
	zoomed_height = zoom_state_get_zoomed_height (&(*self));
	_tmp0_ = (*self).viewport_center;
	_tmp1_ = (*self).viewport_dimensions;
	_tmp2_ = (*self).viewport_dimensions;
	(*self).viewport_center.x = CLAMP (_tmp0_.x, _tmp1_.width / 2, (zoomed_width - (_tmp2_.width / 2)) - 1);
	_tmp3_ = (*self).viewport_center;
	_tmp4_ = (*self).viewport_dimensions;
	_tmp5_ = (*self).viewport_dimensions;
	(*self).viewport_center.y = CLAMP (_tmp3_.y, _tmp4_.height / 2, (zoomed_height - (_tmp5_.height / 2)) - 1);
}

static void
zoom_state_center_viewport (ZoomState *self)
{
	(*self).viewport_center.x = zoom_state_get_zoomed_width (&(*self)) / 2;
	(*self).viewport_center.y = zoom_state_get_zoomed_height (&(*self)) / 2;
}

static void
zoom_state_compute_zoom_factors (ZoomState *self)
{
	gdouble viewport_to_content_x = 0.0;
	gdouble viewport_to_content_y = 0.0;
	Dimensions _tmp0_;
	gdouble _tmp1_ = 0.0;
	gdouble _tmp2_ = 0.0;
	(*self).max_factor = 10.0;
	_tmp0_ = (*self).viewport_dimensions;
	dimensions_get_scale_ratios (&(*self).content_dimensions, &_tmp0_, &_tmp1_, &_tmp2_);
	viewport_to_content_x = _tmp1_;
	viewport_to_content_y = _tmp2_;
	(*self).min_factor = MIN (viewport_to_content_x, viewport_to_content_y);
	if ((*self).min_factor > 1.0) {
		(*self).min_factor = 1.0;
	}
	(*self).zoom_factor = (*self).min_factor * pow ((*self).max_factor / (*self).min_factor, (*self).interpolation_factor);
}

gdouble
zoom_state_get_interpolation_factor (ZoomState *self)
{
	gdouble result;
	result = (*self).interpolation_factor;
	return result;
}

void
zoom_state_get_viewing_rectangle_wrt_content (ZoomState *self,
                                              GdkRectangle* result)
{
	gint zoomed_width = 0;
	gint zoomed_height = 0;
	GdkRectangle _result_ = {0};
	Dimensions _tmp0_;
	GdkRectangle _tmp4_;
	Dimensions _tmp5_;
	GdkRectangle _tmp9_;
	gint right = 0;
	GdkRectangle _tmp10_;
	Dimensions _tmp11_;
	GdkRectangle _tmp12_;
	gint bottom = 0;
	GdkRectangle _tmp13_;
	Dimensions _tmp14_;
	GdkRectangle _tmp15_;
	GdkRectangle _tmp16_;
	GdkRectangle _tmp17_;
	zoomed_width = zoom_state_get_zoomed_width (&(*self));
	zoomed_height = zoom_state_get_zoomed_height (&(*self));
	memset (&_result_, 0, sizeof (GdkRectangle));
	_tmp0_ = (*self).viewport_dimensions;
	if (_tmp0_.width < zoomed_width) {
		GdkPoint _tmp1_;
		Dimensions _tmp2_;
		_tmp1_ = (*self).viewport_center;
		_tmp2_ = (*self).viewport_dimensions;
		_result_.x = _tmp1_.x - (_tmp2_.width / 2);
	} else {
		Dimensions _tmp3_;
		_tmp3_ = (*self).viewport_dimensions;
		_result_.x = (zoomed_width - _tmp3_.width) / 2;
	}
	_tmp4_ = _result_;
	if (_tmp4_.x < 0) {
		_result_.x = 0;
	}
	_tmp5_ = (*self).viewport_dimensions;
	if (_tmp5_.height < zoomed_height) {
		GdkPoint _tmp6_;
		Dimensions _tmp7_;
		_tmp6_ = (*self).viewport_center;
		_tmp7_ = (*self).viewport_dimensions;
		_result_.y = _tmp6_.y - (_tmp7_.height / 2);
	} else {
		Dimensions _tmp8_;
		_tmp8_ = (*self).viewport_dimensions;
		_result_.y = (zoomed_height - _tmp8_.height) / 2;
	}
	_tmp9_ = _result_;
	if (_tmp9_.y < 0) {
		_result_.y = 0;
	}
	_tmp10_ = _result_;
	_tmp11_ = (*self).viewport_dimensions;
	right = _tmp10_.x + _tmp11_.width;
	if (right > zoomed_width) {
		right = zoomed_width;
	}
	_tmp12_ = _result_;
	_result_.width = right - _tmp12_.x;
	_tmp13_ = _result_;
	_tmp14_ = (*self).viewport_dimensions;
	bottom = _tmp13_.y + _tmp14_.height;
	if (bottom > zoomed_height) {
		bottom = zoomed_height;
	}
	_tmp15_ = _result_;
	_result_.height = bottom - _tmp15_.y;
	_tmp16_ = _result_;
	_result_.width = CLAMP (_tmp16_.width, 1, G_MAXINT);
	_tmp17_ = _result_;
	_result_.height = CLAMP (_tmp17_.height, 1, G_MAXINT);
	*result = _result_;
	return;
}

void
zoom_state_get_viewing_rectangle_wrt_screen (ZoomState *self,
                                             GdkRectangle* result)
{
	GdkRectangle wrt_content = {0};
	GdkRectangle _tmp0_ = {0};
	GdkRectangle _result_ = {0};
	Dimensions _tmp1_;
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	Dimensions _tmp4_;
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	GdkRectangle _tmp7_;
	GdkRectangle _tmp8_;
	zoom_state_get_viewing_rectangle_wrt_content (&(*self), &_tmp0_);
	wrt_content = _tmp0_;
	memset (&_result_, 0, sizeof (GdkRectangle));
	_tmp1_ = (*self).viewport_dimensions;
	_tmp2_ = wrt_content;
	_result_.x = (_tmp1_.width / 2) - (_tmp2_.width / 2);
	_tmp3_ = _result_;
	if (_tmp3_.x < 0) {
		_result_.x = 0;
	}
	_tmp4_ = (*self).viewport_dimensions;
	_tmp5_ = wrt_content;
	_result_.y = (_tmp4_.height / 2) - (_tmp5_.height / 2);
	_tmp6_ = _result_;
	if (_tmp6_.y < 0) {
		_result_.y = 0;
	}
	_tmp7_ = wrt_content;
	_result_.width = _tmp7_.width;
	_tmp8_ = wrt_content;
	_result_.height = _tmp8_.height;
	*result = _result_;
	return;
}

void
zoom_state_get_viewing_rectangle_projection (ZoomState *self,
                                             GdkPixbuf* for_pixbuf,
                                             GdkRectangle* result)
{
	gdouble zoomed_width = 0.0;
	gdouble zoomed_height = 0.0;
	gdouble horiz_scale = 0.0;
	gint _tmp0_;
	gint _tmp1_;
	gdouble vert_scale = 0.0;
	gint _tmp2_;
	gint _tmp3_;
	gdouble scale = 0.0;
	GdkRectangle viewing_rectangle = {0};
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _result_ = {0};
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	gint _tmp7_;
	gint _tmp8_;
	GdkRectangle _tmp9_;
	GdkRectangle _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	gint right = 0;
	GdkRectangle _tmp13_;
	GdkRectangle _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint bottom = 0;
	GdkRectangle _tmp17_;
	GdkRectangle _tmp18_;
	gint _tmp19_;
	gint _tmp20_;
	GdkRectangle _tmp21_;
	GdkRectangle _tmp22_;
	g_return_if_fail (for_pixbuf != NULL);
	zoomed_width = (gdouble) zoom_state_get_zoomed_width (&(*self));
	zoomed_height = (gdouble) zoom_state_get_zoomed_height (&(*self));
	_tmp0_ = gdk_pixbuf_get_width (for_pixbuf);
	_tmp1_ = _tmp0_;
	horiz_scale = _tmp1_ / zoomed_width;
	_tmp2_ = gdk_pixbuf_get_height (for_pixbuf);
	_tmp3_ = _tmp2_;
	vert_scale = _tmp3_ / zoomed_height;
	scale = (horiz_scale + vert_scale) / 2.0;
	zoom_state_get_viewing_rectangle_wrt_content (&(*self), &_tmp4_);
	viewing_rectangle = _tmp4_;
	memset (&_result_, 0, sizeof (GdkRectangle));
	_tmp5_ = viewing_rectangle;
	_result_.x = (gint) (_tmp5_.x * scale);
	_tmp6_ = _result_;
	_tmp7_ = gdk_pixbuf_get_width (for_pixbuf);
	_tmp8_ = _tmp7_;
	_result_.x = CLAMP (_tmp6_.x, 0, _tmp8_);
	_tmp9_ = viewing_rectangle;
	_result_.y = (gint) (_tmp9_.y * scale);
	_tmp10_ = _result_;
	_tmp11_ = gdk_pixbuf_get_height (for_pixbuf);
	_tmp12_ = _tmp11_;
	_result_.y = CLAMP (_tmp10_.y, 0, _tmp12_);
	_tmp13_ = viewing_rectangle;
	_tmp14_ = viewing_rectangle;
	right = (gint) ((_tmp13_.x + _tmp14_.width) * scale);
	_tmp15_ = gdk_pixbuf_get_width (for_pixbuf);
	_tmp16_ = _tmp15_;
	right = CLAMP (right, 0, _tmp16_);
	_tmp17_ = viewing_rectangle;
	_tmp18_ = viewing_rectangle;
	bottom = (gint) ((_tmp17_.y + _tmp18_.height) * scale);
	_tmp19_ = gdk_pixbuf_get_height (for_pixbuf);
	_tmp20_ = _tmp19_;
	bottom = CLAMP (bottom, 0, _tmp20_);
	_tmp21_ = _result_;
	_result_.width = right - _tmp21_.x;
	_tmp22_ = _result_;
	_result_.height = bottom - _tmp22_.y;
	*result = _result_;
	return;
}

gdouble
zoom_state_get_zoom_factor (ZoomState *self)
{
	gdouble result;
	result = (*self).zoom_factor;
	return result;
}

gint
zoom_state_get_zoomed_width (ZoomState *self)
{
	Dimensions _tmp0_;
	gint result;
	_tmp0_ = (*self).content_dimensions;
	result = (gint) (_tmp0_.width * (*self).zoom_factor);
	return result;
}

gint
zoom_state_get_zoomed_height (ZoomState *self)
{
	Dimensions _tmp0_;
	gint result;
	_tmp0_ = (*self).content_dimensions;
	result = (gint) (_tmp0_.height * (*self).zoom_factor);
	return result;
}

void
zoom_state_get_viewport_center (ZoomState *self,
                                GdkPoint* result)
{
	GdkPoint _tmp0_;
	_tmp0_ = (*self).viewport_center;
	*result = _tmp0_;
	return;
}

gchar*
zoom_state_to_string (ZoomState *self)
{
	gchar* named_modes = NULL;
	gchar* _tmp0_;
	const gchar* _tmp17_;
	GdkRectangle viewing_rect = {0};
	GdkRectangle _tmp19_ = {0};
	Dimensions _tmp20_;
	Dimensions _tmp21_;
	Dimensions _tmp22_;
	Dimensions _tmp23_;
	const gchar* _tmp24_;
	GdkRectangle _tmp25_;
	GdkRectangle _tmp26_;
	GdkRectangle _tmp27_;
	GdkRectangle _tmp28_;
	GdkPoint _tmp29_;
	GdkPoint _tmp30_;
	gchar* _tmp31_;
	gchar* result;
	_tmp0_ = g_strdup ("");
	named_modes = _tmp0_;
	if (zoom_state_is_min (&(*self))) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp2_ = named_modes;
		if (g_strcmp0 (_tmp2_, "") == 0) {
			_tmp1_ = "MIN";
		} else {
			_tmp1_ = ", MIN";
		}
		_tmp3_ = named_modes;
		_tmp4_ = g_strconcat (_tmp3_, _tmp1_, NULL);
		_g_free0 (named_modes);
		named_modes = _tmp4_;
	}
	if (zoom_state_is_default (&(*self))) {
		const gchar* _tmp5_ = NULL;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = named_modes;
		if (g_strcmp0 (_tmp6_, "") == 0) {
			_tmp5_ = "DEFAULT";
		} else {
			_tmp5_ = ", DEFAULT";
		}
		_tmp7_ = named_modes;
		_tmp8_ = g_strconcat (_tmp7_, _tmp5_, NULL);
		_g_free0 (named_modes);
		named_modes = _tmp8_;
	}
	if (zoom_state_is_isomorphic (&(*self))) {
		const gchar* _tmp9_ = NULL;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		_tmp10_ = named_modes;
		if (g_strcmp0 (_tmp10_, "") == 0) {
			_tmp9_ = "ISOMORPHIC";
		} else {
			_tmp9_ = ", ISOMORPHIC";
		}
		_tmp11_ = named_modes;
		_tmp12_ = g_strconcat (_tmp11_, _tmp9_, NULL);
		_g_free0 (named_modes);
		named_modes = _tmp12_;
	}
	if (zoom_state_is_max (&(*self))) {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		_tmp14_ = named_modes;
		if (g_strcmp0 (_tmp14_, "") == 0) {
			_tmp13_ = "MAX";
		} else {
			_tmp13_ = ", MAX";
		}
		_tmp15_ = named_modes;
		_tmp16_ = g_strconcat (_tmp15_, _tmp13_, NULL);
		_g_free0 (named_modes);
		named_modes = _tmp16_;
	}
	_tmp17_ = named_modes;
	if (g_strcmp0 (_tmp17_, "") == 0) {
		gchar* _tmp18_;
		_tmp18_ = g_strdup ("(none)");
		_g_free0 (named_modes);
		named_modes = _tmp18_;
	}
	zoom_state_get_viewing_rectangle_wrt_content (&(*self), &_tmp19_);
	viewing_rect = _tmp19_;
	_tmp20_ = (*self).content_dimensions;
	_tmp21_ = (*self).content_dimensions;
	_tmp22_ = (*self).viewport_dimensions;
	_tmp23_ = (*self).viewport_dimensions;
	_tmp24_ = named_modes;
	_tmp25_ = viewing_rect;
	_tmp26_ = viewing_rect;
	_tmp27_ = viewing_rect;
	_tmp28_ = viewing_rect;
	_tmp29_ = (*self).viewport_center;
	_tmp30_ = (*self).viewport_center;
	_tmp31_ = g_strdup_printf ("ZoomState {\n" \
"    content dimensions = %d x %d;\n" \
"    viewport dimensions = " "%d x %d;\n" \
"    min factor = %f;\n" \
"    max factor = %f;\n" \
"    current factor = %f;" "\n" \
"    zoomed width = %d;\n" \
"    zoomed height = %d;\n" \
"    named modes = %s;" "\n    viewing rectangle = { x: %d, y: %d, width: %d, height: %d };" "\n    viewport center = (%d, %d);\n}\n", _tmp20_.width, _tmp21_.height, _tmp22_.width, _tmp23_.height, (*self).min_factor, (*self).max_factor, (*self).zoom_factor, zoom_state_get_zoomed_width (&(*self)), zoom_state_get_zoomed_height (&(*self)), _tmp24_, _tmp25_.x, _tmp26_.y, _tmp27_.width, _tmp28_.height, _tmp29_.x, _tmp30_.y);
	result = _tmp31_;
	_g_free0 (named_modes);
	return result;
}

gboolean
zoom_state_is_min (ZoomState *self)
{
	gboolean result;
	result = (*self).zoom_factor == (*self).min_factor;
	return result;
}

gboolean
zoom_state_is_default (ZoomState *self)
{
	gboolean result;
	result = zoom_state_is_min (&(*self));
	return result;
}

gboolean
zoom_state_is_max (ZoomState *self)
{
	gboolean result;
	result = (*self).zoom_factor == (*self).max_factor;
	return result;
}

gboolean
zoom_state_is_isomorphic (ZoomState *self)
{
	gboolean result;
	result = (*self).zoom_factor == 1.0;
	return result;
}

gboolean
zoom_state_equals (ZoomState *self,
                   ZoomState* other)
{
	ZoomState _tmp0_;
	Dimensions _tmp1_;
	ZoomState _tmp2_;
	Dimensions _tmp3_;
	ZoomState _tmp4_;
	ZoomState _tmp5_;
	ZoomState _tmp6_;
	GdkPoint _tmp7_;
	ZoomState _tmp8_;
	GdkPoint _tmp9_;
	GdkPoint _tmp10_;
	ZoomState _tmp11_;
	GdkPoint _tmp12_;
	gboolean result;
	g_return_val_if_fail (other != NULL, FALSE);
	_tmp0_ = *other;
	_tmp1_ = _tmp0_.content_dimensions;
	if (!dimensions_equals (&(*self).content_dimensions, &_tmp1_)) {
		result = FALSE;
		return result;
	}
	_tmp2_ = *other;
	_tmp3_ = _tmp2_.viewport_dimensions;
	if (!dimensions_equals (&(*self).viewport_dimensions, &_tmp3_)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = *other;
	if ((*self).zoom_factor != _tmp4_.zoom_factor) {
		result = FALSE;
		return result;
	}
	_tmp5_ = *other;
	if ((*self).min_factor != _tmp5_.min_factor) {
		result = FALSE;
		return result;
	}
	_tmp6_ = *other;
	if ((*self).max_factor != _tmp6_.max_factor) {
		result = FALSE;
		return result;
	}
	_tmp7_ = (*self).viewport_center;
	_tmp8_ = *other;
	_tmp9_ = _tmp8_.viewport_center;
	if (_tmp7_.x != _tmp9_.x) {
		result = FALSE;
		return result;
	}
	_tmp10_ = (*self).viewport_center;
	_tmp11_ = *other;
	_tmp12_ = _tmp11_.viewport_center;
	if (_tmp10_.y != _tmp12_.y) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

ZoomState*
zoom_state_dup (const ZoomState* self)
{
	ZoomState* dup;
	dup = g_new0 (ZoomState, 1);
	memcpy (dup, self, sizeof (ZoomState));
	return dup;
}

void
zoom_state_free (ZoomState* self)
{
	g_free (self);
}

static GType
zoom_state_get_type_once (void)
{
	GType zoom_state_type_id;
	zoom_state_type_id = g_boxed_type_register_static ("ZoomState", (GBoxedCopyFunc) zoom_state_dup, (GBoxedFreeFunc) zoom_state_free);
	return zoom_state_type_id;
}

GType
zoom_state_get_type (void)
{
	static volatile gsize zoom_state_type_id__once = 0;
	if (g_once_init_enter (&zoom_state_type_id__once)) {
		GType zoom_state_type_id;
		zoom_state_type_id = zoom_state_get_type_once ();
		g_once_init_leave (&zoom_state_type_id__once, zoom_state_type_id);
	}
	return zoom_state_type_id__once;
}

