/* ScheduledView.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ScheduledView.vala, do not modify */

/*
 * Copyright 2019-2023 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <granite-7.h>
#include <glib-object.h>
#include <gee.h>
#include <libedataserver/libedataserver.h>
#include <libecal/libecal.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <libical-glib/libical-glib.h>
#include <glib/gi18n-lib.h>
#include <pango/pango.h>
#include <float.h>
#include <math.h>
#include <adwaita.h>

#define TASKS_SCHEDULED_VIEW_QUERY "AND (NOT is-completed?) (has-start?)"
#define TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST "action-delete-selected-list"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TASKS_TYPE_SCHEDULED_VIEW (tasks_scheduled_view_get_type ())
#define TASKS_SCHEDULED_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_SCHEDULED_VIEW, TasksScheduledView))
#define TASKS_SCHEDULED_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_SCHEDULED_VIEW, TasksScheduledViewClass))
#define TASKS_IS_SCHEDULED_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_SCHEDULED_VIEW))
#define TASKS_IS_SCHEDULED_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_SCHEDULED_VIEW))
#define TASKS_SCHEDULED_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_SCHEDULED_VIEW, TasksScheduledViewClass))

typedef struct _TasksScheduledView TasksScheduledView;
typedef struct _TasksScheduledViewClass TasksScheduledViewClass;
typedef struct _TasksScheduledViewPrivate TasksScheduledViewPrivate;

#define TASKS_TYPE_TASK_MODEL (tasks_task_model_get_type ())
#define TASKS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModel))
#define TASKS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))
#define TASKS_IS_TASK_MODEL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_TASK_MODEL))
#define TASKS_IS_TASK_MODEL_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_TASK_MODEL))
#define TASKS_TASK_MODEL_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_TASK_MODEL, TasksTaskModelClass))

typedef struct _TasksTaskModel TasksTaskModel;
typedef struct _TasksTaskModelClass TasksTaskModelClass;
enum  {
	TASKS_SCHEDULED_VIEW_0_PROPERTY,
	TASKS_SCHEDULED_VIEW_MODEL_PROPERTY,
	TASKS_SCHEDULED_VIEW_NUM_PROPERTIES
};
static GParamSpec* tasks_scheduled_view_properties[TASKS_SCHEDULED_VIEW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef void (*TasksTaskModelTasksAddedFunc) (GeeCollection* tasks, ESource* task_list, gpointer user_data);
typedef void (*TasksTaskModelTasksModifiedFunc) (GeeCollection* tasks, gpointer user_data);
typedef void (*TasksTaskModelTasksRemovedFunc) (GSList* cids, gpointer user_data);
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TASKS_WIDGETS_TYPE_TASK_ROW (tasks_widgets_task_row_get_type ())
#define TASKS_WIDGETS_TASK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow))
#define TASKS_WIDGETS_TASK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRowClass))
#define TASKS_WIDGETS_IS_TASK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_WIDGETS_TYPE_TASK_ROW))
#define TASKS_WIDGETS_IS_TASK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_WIDGETS_TYPE_TASK_ROW))
#define TASKS_WIDGETS_TASK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRowClass))

typedef struct _TasksWidgetsTaskRow TasksWidgetsTaskRow;
typedef struct _TasksWidgetsTaskRowClass TasksWidgetsTaskRowClass;

#define TASKS_TYPE_MAIN_WINDOW (tasks_main_window_get_type ())
#define TASKS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TASKS_TYPE_MAIN_WINDOW, TasksMainWindow))
#define TASKS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TASKS_TYPE_MAIN_WINDOW, TasksMainWindowClass))
#define TASKS_IS_MAIN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TASKS_TYPE_MAIN_WINDOW))
#define TASKS_IS_MAIN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TASKS_TYPE_MAIN_WINDOW))
#define TASKS_MAIN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TASKS_TYPE_MAIN_WINDOW, TasksMainWindowClass))

typedef struct _TasksMainWindow TasksMainWindow;
typedef struct _TasksMainWindowClass TasksMainWindowClass;
#define __vala_ECalComponentDateTime_free0(var) ((var == NULL) ? NULL : (var = (_vala_ECalComponentDateTime_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
typedef struct _Block29Data Block29Data;
typedef struct _Block30Data Block30Data;
typedef struct _Block31Data Block31Data;
typedef struct _Block32Data Block32Data;

struct _TasksScheduledView {
	GraniteBin parent_instance;
	TasksScheduledViewPrivate * priv;
};

struct _TasksScheduledViewClass {
	GraniteBinClass parent_class;
};

struct _TasksScheduledViewPrivate {
	GeeMap* views;
	GRecMutex __lock_views;
	TasksTaskModel* _model;
	GtkLabel* scheduled_title;
	GtkListBox* task_list;
};

struct _Block29Data {
	int _ref_count_;
	TasksScheduledView* self;
	ESource* source;
};

struct _Block30Data {
	int _ref_count_;
	TasksScheduledView* self;
	GraniteMessageDialog* error_dialog;
};

struct _Block31Data {
	int _ref_count_;
	TasksScheduledView* self;
	GraniteMessageDialog* error_dialog;
};

struct _Block32Data {
	int _ref_count_;
	TasksScheduledView* self;
	GraniteMessageDialog* error_dialog;
};

static gint TasksScheduledView_private_offset;
static gpointer tasks_scheduled_view_parent_class = NULL;
VALA_EXTERN TasksTaskModel* tasks_application_model;

VALA_EXTERN GType tasks_scheduled_view_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksScheduledView, g_object_unref)
VALA_EXTERN GType tasks_task_model_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksTaskModel, g_object_unref)
static void tasks_scheduled_view_add_view (TasksScheduledView* self,
                                    ESource* source,
                                    const gchar* query);
VALA_EXTERN TasksTaskModel* tasks_scheduled_view_get_model (TasksScheduledView* self);
VALA_EXTERN ECalClientView* tasks_task_model_create_task_list_view (TasksTaskModel* self,
                                                        ESource* task_list,
                                                        const gchar* query,
                                                        TasksTaskModelTasksAddedFunc on_tasks_added,
                                                        gpointer on_tasks_added_target,
                                                        TasksTaskModelTasksModifiedFunc on_tasks_modified,
                                                        gpointer on_tasks_modified_target,
                                                        TasksTaskModelTasksRemovedFunc on_tasks_removed,
                                                        gpointer on_tasks_removed_target,
                                                        GError** error);
static void tasks_scheduled_view_on_tasks_added (TasksScheduledView* self,
                                          GeeCollection* tasks,
                                          ESource* source);
static void _tasks_scheduled_view_on_tasks_added_tasks_task_model_tasks_added_func (GeeCollection* tasks,
                                                                             ESource* task_list,
                                                                             gpointer self);
static void tasks_scheduled_view_on_tasks_modified (TasksScheduledView* self,
                                             GeeCollection* tasks);
static void _tasks_scheduled_view_on_tasks_modified_tasks_task_model_tasks_modified_func (GeeCollection* tasks,
                                                                                   gpointer self);
static void tasks_scheduled_view_on_tasks_removed (TasksScheduledView* self,
                                            GSList* cids);
static void _tasks_scheduled_view_on_tasks_removed_tasks_task_model_tasks_removed_func (GSList* cids,
                                                                                 gpointer self);
static void tasks_scheduled_view_remove_view (TasksScheduledView* self,
                                       ESource* source);
VALA_EXTERN GType tasks_widgets_task_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksWidgetsTaskRow, g_object_unref)
VALA_EXTERN ESource* tasks_widgets_task_row_get_source (TasksWidgetsTaskRow* self);
VALA_EXTERN void tasks_task_model_destroy_task_list_view (TasksTaskModel* self,
                                              ECalClientView* view);
VALA_EXTERN TasksScheduledView* tasks_scheduled_view_new (TasksTaskModel* model);
VALA_EXTERN TasksScheduledView* tasks_scheduled_view_construct (GType object_type,
                                                    TasksTaskModel* model);
static void tasks_scheduled_view_add_task_list (TasksScheduledView* self,
                                         ESource* task_list);
static void tasks_scheduled_view_modify_task_list (TasksScheduledView* self,
                                            ESource* task_list);
static void tasks_scheduled_view_remove_task_list (TasksScheduledView* self,
                                            ESource* task_list);
static void tasks_scheduled_view_on_row_activated (TasksScheduledView* self,
                                            GtkListBoxRow* row);
VALA_EXTERN void tasks_widgets_task_row_reveal_child_request (TasksWidgetsTaskRow* self,
                                                  gboolean value);
VALA_EXTERN GType tasks_main_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TasksMainWindow, g_object_unref)
static void tasks_scheduled_view_on_row_unselect (TasksScheduledView* self,
                                           GtkListBoxRow* row);
static gint tasks_scheduled_view_sort_function (GtkListBoxRow* row1,
                                         GtkListBoxRow* row2,
                                         TasksScheduledView* self);
VALA_EXTERN ECalComponent* tasks_widgets_task_row_get_task (TasksWidgetsTaskRow* self);
static void _vala_ECalComponentDateTime_free (ECalComponentDateTime* self);
static void tasks_scheduled_view_header_function (TasksScheduledView* self,
                                           GtkListBoxRow* lbrow,
                                           GtkListBoxRow* lbbefore);
VALA_EXTERN GDateTime* tasks_util_ical_to_date_time_local (ICalTime* date);
VALA_EXTERN gchar* tasks_util_get_relative_date (GDateTime* date_time);
static Block29Data* block29_data_ref (Block29Data* _data29_);
static void block29_data_unref (void * _userdata_);
static gboolean __lambda101_ (Block29Data* _data29_,
                       ECalComponent* task);
VALA_EXTERN TasksWidgetsTaskRow* tasks_widgets_task_row_new_for_component (ECalComponent* task,
                                                               ESource* source,
                                                               gboolean is_scheduled_view);
VALA_EXTERN TasksWidgetsTaskRow* tasks_widgets_task_row_construct_for_component (GType object_type,
                                                                     ECalComponent* task,
                                                                     ESource* source,
                                                                     gboolean is_scheduled_view);
static void _tasks_scheduled_view_on_row_unselect_tasks_widgets_task_row_unselect (TasksWidgetsTaskRow* _sender,
                                                                            GtkListBoxRow* row,
                                                                            gpointer self);
static void __lambda102_ (Block29Data* _data29_,
                   ECalComponent* task);
VALA_EXTERN void tasks_task_model_complete_task (TasksTaskModel* self,
                                     ESource* list,
                                     ECalComponent* task,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
VALA_EXTERN void tasks_task_model_complete_task_finish (TasksTaskModel* self,
                                            GAsyncResult* _res_,
                                            GError** error);
static void __lambda103_ (TasksScheduledView* self,
                   GObject* obj,
                   GAsyncResult* res);
static Block30Data* block30_data_ref (Block30Data* _data30_);
static void block30_data_unref (void * _userdata_);
static void ___lambda104_ (Block30Data* _data30_);
static void ____lambda104__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
static void ___lambda103__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda102__tasks_widgets_task_row_task_completed (TasksWidgetsTaskRow* _sender,
                                                          ECalComponent* task,
                                                          gpointer self);
static void __lambda105_ (Block29Data* _data29_,
                   ECalComponent* task);
VALA_EXTERN void tasks_task_model_update_task (TasksTaskModel* self,
                                   ESource* list,
                                   ECalComponent* task,
                                   ECalObjModType mod_type,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void tasks_task_model_update_task_finish (TasksTaskModel* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static void __lambda106_ (TasksScheduledView* self,
                   GObject* obj,
                   GAsyncResult* res);
static Block31Data* block31_data_ref (Block31Data* _data31_);
static void block31_data_unref (void * _userdata_);
static void ___lambda107_ (Block31Data* _data31_);
static void ____lambda107__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
static void ___lambda106__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda105__tasks_widgets_task_row_task_changed (TasksWidgetsTaskRow* _sender,
                                                        ECalComponent* task,
                                                        gpointer self);
static void __lambda108_ (Block29Data* _data29_,
                   ECalComponent* task);
VALA_EXTERN void tasks_task_model_remove_task (TasksTaskModel* self,
                                   ESource* list,
                                   ECalComponent* task,
                                   ECalObjModType mod_type,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
VALA_EXTERN void tasks_task_model_remove_task_finish (TasksTaskModel* self,
                                          GAsyncResult* _res_,
                                          GError** error);
static void __lambda109_ (TasksScheduledView* self,
                   GObject* obj,
                   GAsyncResult* res);
static Block32Data* block32_data_ref (Block32Data* _data32_);
static void block32_data_unref (void * _userdata_);
static void ___lambda110_ (Block32Data* _data32_);
static void ____lambda110__gtk_dialog_response (GtkDialog* _sender,
                                         gint response_id,
                                         gpointer self);
static void ___lambda109__gasync_ready_callback (GObject* source_object,
                                          GAsyncResult* res,
                                          gpointer self);
static void ___lambda108__tasks_widgets_task_row_task_removed (TasksWidgetsTaskRow* _sender,
                                                        ECalComponent* task,
                                                        gpointer self);
static gboolean ___lambda101__gee_forall_func (gpointer g,
                                        gpointer self);
static gboolean __lambda111_ (TasksScheduledView* self);
static gboolean ___lambda111__gsource_func (gpointer self);
VALA_EXTERN gboolean tasks_util_calcomponent_equal_func (ECalComponent* a,
                                             ECalComponent* b);
VALA_EXTERN void tasks_widgets_task_row_set_task (TasksWidgetsTaskRow* self,
                                      ECalComponent* value);
static gboolean __lambda112_ (TasksScheduledView* self);
static gboolean ___lambda112__gsource_func (gpointer self);
static gboolean __lambda113_ (TasksScheduledView* self);
static gboolean ___lambda113__gsource_func (gpointer self);
static void tasks_scheduled_view_set_model (TasksScheduledView* self,
                                     TasksTaskModel* value);
static GObject * tasks_scheduled_view_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static gint _tasks_scheduled_view_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                                 GtkListBoxRow* row2,
                                                                 gpointer self);
static void _tasks_scheduled_view_header_function_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                            GtkListBoxRow* before,
                                                                            gpointer self);
static void _tasks_scheduled_view_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                        GtkListBoxRow* row,
                                                                        gpointer self);
static void _tasks_scheduled_view_add_task_list_tasks_task_model_task_list_added (TasksTaskModel* _sender,
                                                                           ESource* task_list,
                                                                           gpointer self);
static void _tasks_scheduled_view_modify_task_list_tasks_task_model_task_list_modified (TasksTaskModel* _sender,
                                                                                 ESource* task_list,
                                                                                 gpointer self);
static void _tasks_scheduled_view_remove_task_list_tasks_task_model_task_list_removed (TasksTaskModel* _sender,
                                                                                ESource* task_list,
                                                                                gpointer self);
VALA_EXTERN void tasks_task_model_get_registry (TasksTaskModel* self,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
VALA_EXTERN ESourceRegistry* tasks_task_model_get_registry_finish (TasksTaskModel* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void _tasks_scheduled_view___lambda114_ (TasksScheduledView* self,
                                         GObject* obj,
                                         GAsyncResult* res);
static void __lambda115_ (TasksScheduledView* self,
                   ESource* source);
static void ___lambda115__gfunc (gconstpointer data,
                          gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __tasks_scheduled_view___lambda114__gasync_ready_callback (GObject* source_object,
                                                                GAsyncResult* res,
                                                                gpointer self);
static void tasks_scheduled_view_finalize (GObject * obj);
static GType tasks_scheduled_view_get_type_once (void);
static void _vala_tasks_scheduled_view_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_tasks_scheduled_view_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);

static inline gpointer
tasks_scheduled_view_get_instance_private (TasksScheduledView* self)
{
	return G_STRUCT_MEMBER_P (self, TasksScheduledView_private_offset);
}

static void
_tasks_scheduled_view_on_tasks_added_tasks_task_model_tasks_added_func (GeeCollection* tasks,
                                                                        ESource* task_list,
                                                                        gpointer self)
{
	tasks_scheduled_view_on_tasks_added ((TasksScheduledView*) self, tasks, task_list);
}

static void
_tasks_scheduled_view_on_tasks_modified_tasks_task_model_tasks_modified_func (GeeCollection* tasks,
                                                                              gpointer self)
{
	tasks_scheduled_view_on_tasks_modified ((TasksScheduledView*) self, tasks);
}

static void
_tasks_scheduled_view_on_tasks_removed_tasks_task_model_tasks_removed_func (GSList* cids,
                                                                            gpointer self)
{
	tasks_scheduled_view_on_tasks_removed ((TasksScheduledView*) self, cids);
}

static void
tasks_scheduled_view_add_view (TasksScheduledView* self,
                               ESource* source,
                               const gchar* query)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_return_if_fail (query != NULL);
	{
		ECalClientView* view = NULL;
		TasksTaskModel* _tmp0_;
		ECalClientView* _tmp1_;
		_tmp0_ = self->priv->_model;
		_tmp1_ = tasks_task_model_create_task_list_view (_tmp0_, source, query, _tasks_scheduled_view_on_tasks_added_tasks_task_model_tasks_added_func, self, _tasks_scheduled_view_on_tasks_modified_tasks_task_model_tasks_modified_func, self, _tasks_scheduled_view_on_tasks_removed_tasks_task_model_tasks_removed_func, self, &_inner_error0_);
		view = _tmp1_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		{
			GeeMap* _tmp2_;
			_tmp2_ = self->priv->views;
			g_rec_mutex_lock (&self->priv->__lock_views);
			{
				GeeMap* _tmp3_;
				ECalClientView* _tmp4_;
				_tmp3_ = self->priv->views;
				_tmp4_ = view;
				gee_map_set (_tmp3_, source, _tmp4_);
			}
			__finally1:
			{
				GeeMap* _tmp5_;
				_tmp5_ = self->priv->views;
				g_rec_mutex_unlock (&self->priv->__lock_views);
			}
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (view);
				goto __catch0_g_error;
			}
		}
		_g_object_unref0 (view);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_critical ("ScheduledView.vala:31: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
tasks_scheduled_view_remove_view (TasksScheduledView* self,
                                  ESource* source)
{
	gint index = 0;
	GtkListBoxRow* row = NULL;
	GtkListBox* _tmp0_;
	GtkListBoxRow* _tmp1_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	index = 0;
	_tmp0_ = self->priv->task_list;
	_tmp1_ = gtk_list_box_get_row_at_index (_tmp0_, 0);
	row = _tmp1_;
	while (TRUE) {
		GtkListBoxRow* _tmp2_;
		gboolean _tmp3_ = FALSE;
		GtkListBoxRow* _tmp4_;
		GtkListBox* _tmp11_;
		GtkListBoxRow* _tmp12_;
		_tmp2_ = row;
		if (!(_tmp2_ != NULL)) {
			break;
		}
		_tmp4_ = row;
		if (TASKS_WIDGETS_IS_TASK_ROW (_tmp4_)) {
			GtkListBoxRow* _tmp5_;
			ESource* _tmp6_;
			ESource* _tmp7_;
			_tmp5_ = row;
			_tmp6_ = tasks_widgets_task_row_get_source (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
			_tmp7_ = _tmp6_;
			_tmp3_ = _tmp7_ == source;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GtkListBox* _tmp8_;
			GtkListBoxRow* _tmp9_;
			_tmp8_ = self->priv->task_list;
			_tmp9_ = row;
			gtk_list_box_remove (_tmp8_, (GtkWidget*) _tmp9_);
		} else {
			gint _tmp10_;
			_tmp10_ = index;
			index = _tmp10_ + 1;
		}
		_tmp11_ = self->priv->task_list;
		_tmp12_ = gtk_list_box_get_row_at_index (_tmp11_, index);
		row = _tmp12_;
	}
	{
		GeeMap* _tmp13_;
		_tmp13_ = self->priv->views;
		g_rec_mutex_lock (&self->priv->__lock_views);
		{
			ECalClientView* view = NULL;
			GeeMap* _tmp14_;
			gpointer _tmp15_ = NULL;
			gboolean _tmp16_;
			_tmp14_ = self->priv->views;
			_tmp16_ = gee_map_unset (_tmp14_, source, &_tmp15_);
			_g_object_unref0 (view);
			view = (ECalClientView*) _tmp15_;
			if (_tmp16_) {
				TasksTaskModel* _tmp17_;
				ECalClientView* _tmp18_;
				_tmp17_ = self->priv->_model;
				_tmp18_ = view;
				tasks_task_model_destroy_task_list_view (_tmp17_, _tmp18_);
			}
			_g_object_unref0 (view);
		}
		__finally0:
		{
			GeeMap* _tmp19_;
			_tmp19_ = self->priv->views;
			g_rec_mutex_unlock (&self->priv->__lock_views);
		}
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

TasksScheduledView*
tasks_scheduled_view_construct (GType object_type,
                                TasksTaskModel* model)
{
	TasksScheduledView * self = NULL;
	g_return_val_if_fail (model != NULL, NULL);
	self = (TasksScheduledView*) g_object_new (object_type, "model", model, NULL);
	return self;
}

TasksScheduledView*
tasks_scheduled_view_new (TasksTaskModel* model)
{
	return tasks_scheduled_view_construct (TASKS_TYPE_SCHEDULED_VIEW, model);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
tasks_scheduled_view_add_task_list (TasksScheduledView* self,
                                    ESource* task_list)
{
	ESourceTaskList* list = NULL;
	ESourceExtension* _tmp0_;
	ESourceTaskList* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	ESourceTaskList* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (task_list != NULL);
	if (!e_source_has_extension (task_list, E_SOURCE_EXTENSION_TASK_LIST)) {
		return;
	}
	_tmp0_ = e_source_get_extension (task_list, E_SOURCE_EXTENSION_TASK_LIST);
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, e_source_task_list_get_type (), ESourceTaskList));
	list = _tmp1_;
	_tmp4_ = list;
	_tmp5_ = e_source_selectable_get_selected ((ESourceSelectable*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == TRUE) {
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp7_ = e_source_get_enabled (task_list);
		_tmp8_ = _tmp7_;
		_tmp3_ = _tmp8_ == TRUE;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = !e_source_has_extension (task_list, E_SOURCE_EXTENSION_COLLECTION);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		tasks_scheduled_view_add_view (self, task_list, TASKS_SCHEDULED_VIEW_QUERY);
	}
	_g_object_unref0 (list);
}

static void
tasks_scheduled_view_modify_task_list (TasksScheduledView* self,
                                       ESource* task_list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (task_list != NULL);
	tasks_scheduled_view_remove_task_list (self, task_list);
	tasks_scheduled_view_add_task_list (self, task_list);
}

static void
tasks_scheduled_view_remove_task_list (TasksScheduledView* self,
                                       ESource* task_list)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (task_list != NULL);
	tasks_scheduled_view_remove_view (self, task_list);
}

static void
tasks_scheduled_view_on_row_activated (TasksScheduledView* self,
                                       GtkListBoxRow* row)
{
	TasksWidgetsTaskRow* task_row = NULL;
	TasksWidgetsTaskRow* _tmp0_;
	TasksWidgetsTaskRow* _tmp1_;
	TasksMainWindow* main_window = NULL;
	GtkRoot* _tmp2_;
	TasksMainWindow* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
	task_row = _tmp0_;
	_tmp1_ = task_row;
	tasks_widgets_task_row_reveal_child_request (_tmp1_, TRUE);
	_tmp2_ = gtk_widget_get_root ((GtkWidget*) self);
	main_window = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, TASKS_TYPE_MAIN_WINDOW, TasksMainWindow);
	_tmp3_ = main_window;
	if (_tmp3_ != NULL) {
		TasksMainWindow* _tmp4_;
		GAction* _tmp5_;
		_tmp4_ = main_window;
		_tmp5_ = g_action_map_lookup_action ((GActionMap*) _tmp4_, TASKS_MAIN_WINDOW_ACTION_DELETE_SELECTED_LIST);
		g_simple_action_set_enabled (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction), FALSE);
	}
	_g_object_unref0 (task_row);
}

static void
tasks_scheduled_view_on_row_unselect (TasksScheduledView* self,
                                      GtkListBoxRow* row)
{
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (row != NULL);
	_tmp0_ = gtk_widget_get_parent ((GtkWidget*) row);
	_tmp1_ = _tmp0_;
	if (G_TYPE_CHECK_INSTANCE_TYPE (_tmp1_, gtk_list_box_get_type ())) {
		GtkWidget* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = gtk_widget_get_parent ((GtkWidget*) row);
		_tmp3_ = _tmp2_;
		gtk_list_box_unselect_row (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_list_box_get_type (), GtkListBox), row);
	}
}

static void
_vala_ECalComponentDateTime_free (ECalComponentDateTime* self)
{
	g_boxed_free (e_cal_component_datetime_get_type (), self);
}

static gint
tasks_scheduled_view_sort_function (GtkListBoxRow* row1,
                                    GtkListBoxRow* row2,
                                    TasksScheduledView* self)
{
	TasksWidgetsTaskRow* row_a = NULL;
	TasksWidgetsTaskRow* _tmp0_;
	TasksWidgetsTaskRow* row_b = NULL;
	TasksWidgetsTaskRow* _tmp1_;
	ECalComponent* _tmp2_;
	ECalComponent* _tmp3_;
	ECalComponentDateTime* _tmp4_;
	ECalComponentDateTime* _tmp5_;
	ICalTime* _tmp6_;
	ECalComponent* _tmp7_;
	ECalComponent* _tmp8_;
	ECalComponentDateTime* _tmp9_;
	ECalComponentDateTime* _tmp10_;
	ICalTime* _tmp11_;
	gint _tmp12_;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (row1 != NULL, 0);
	g_return_val_if_fail (row2 != NULL, 0);
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row1, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
	row_a = _tmp0_;
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (row2, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
	row_b = _tmp1_;
	_tmp2_ = tasks_widgets_task_row_get_task (row_a);
	_tmp3_ = _tmp2_;
	_tmp4_ = e_cal_component_get_due (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = e_cal_component_datetime_get_value (_tmp5_);
	_tmp7_ = tasks_widgets_task_row_get_task (row_b);
	_tmp8_ = _tmp7_;
	_tmp9_ = e_cal_component_get_due (_tmp8_);
	_tmp10_ = _tmp9_;
	_tmp11_ = e_cal_component_datetime_get_value (_tmp10_);
	_tmp12_ = i_cal_time_compare (_tmp6_, _tmp11_);
	__vala_ECalComponentDateTime_free0 (_tmp10_);
	__vala_ECalComponentDateTime_free0 (_tmp5_);
	result = _tmp12_;
	_g_object_unref0 (row_b);
	_g_object_unref0 (row_a);
	return result;
}

static void
tasks_scheduled_view_header_function (TasksScheduledView* self,
                                      GtkListBoxRow* lbrow,
                                      GtkListBoxRow* lbbefore)
{
	TasksWidgetsTaskRow* row = NULL;
	TasksWidgetsTaskRow* _tmp0_;
	ICalComponent* comp = NULL;
	TasksWidgetsTaskRow* _tmp1_;
	ECalComponent* _tmp2_;
	ECalComponent* _tmp3_;
	ICalComponent* _tmp4_;
	ICalComponent* _tmp5_;
	ICalTime* _tmp6_;
	ICalTime* _tmp7_;
	gboolean _tmp8_;
	GDateTime* due_date_time = NULL;
	ICalComponent* _tmp21_;
	ICalTime* _tmp22_;
	ICalTime* _tmp23_;
	GDateTime* _tmp24_;
	GDateTime* _tmp25_;
	GraniteHeaderLabel* header_label = NULL;
	GDateTime* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	GraniteHeaderLabel* _tmp29_ = NULL;
	GraniteHeaderLabel* _tmp30_;
	TasksWidgetsTaskRow* _tmp31_;
	GraniteHeaderLabel* _tmp32_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (lbrow != NULL);
	if (!TASKS_WIDGETS_IS_TASK_ROW (lbrow)) {
		return;
	}
	_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbrow, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
	row = _tmp0_;
	_tmp1_ = row;
	_tmp2_ = tasks_widgets_task_row_get_task (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = e_cal_component_get_icalcomponent (_tmp3_);
	comp = _tmp4_;
	_tmp5_ = comp;
	_tmp6_ = i_cal_component_get_due (_tmp5_);
	_tmp7_ = _tmp6_;
	_tmp8_ = i_cal_time_is_null_time (_tmp7_);
	_g_object_unref0 (_tmp7_);
	if (_tmp8_) {
		_g_object_unref0 (row);
		return;
	}
	if (lbbefore != NULL) {
		TasksWidgetsTaskRow* before = NULL;
		TasksWidgetsTaskRow* _tmp9_;
		ICalComponent* comp_before = NULL;
		TasksWidgetsTaskRow* _tmp10_;
		ECalComponent* _tmp11_;
		ECalComponent* _tmp12_;
		ICalComponent* _tmp13_;
		ICalComponent* _tmp14_;
		ICalTime* _tmp15_;
		ICalTime* _tmp16_;
		ICalComponent* _tmp17_;
		ICalTime* _tmp18_;
		ICalTime* _tmp19_;
		gboolean _tmp20_;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (lbbefore, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
		before = _tmp9_;
		_tmp10_ = before;
		_tmp11_ = tasks_widgets_task_row_get_task (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp13_ = e_cal_component_get_icalcomponent (_tmp12_);
		comp_before = _tmp13_;
		_tmp14_ = comp_before;
		_tmp15_ = i_cal_component_get_due (_tmp14_);
		_tmp16_ = _tmp15_;
		_tmp17_ = comp;
		_tmp18_ = i_cal_component_get_due (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp20_ = i_cal_time_compare_date_only (_tmp16_, _tmp19_) == 0;
		_g_object_unref0 (_tmp19_);
		_g_object_unref0 (_tmp16_);
		if (_tmp20_) {
			_g_object_unref0 (before);
			_g_object_unref0 (row);
			return;
		}
		_g_object_unref0 (before);
	}
	_tmp21_ = comp;
	_tmp22_ = i_cal_component_get_due (_tmp21_);
	_tmp23_ = _tmp22_;
	_tmp24_ = tasks_util_ical_to_date_time_local (_tmp23_);
	_tmp25_ = _tmp24_;
	_g_object_unref0 (_tmp23_);
	due_date_time = _tmp25_;
	_tmp26_ = due_date_time;
	_tmp27_ = tasks_util_get_relative_date (_tmp26_);
	_tmp28_ = _tmp27_;
	_tmp29_ = granite_header_label_new (_tmp28_);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp29_, 12);
	g_object_ref_sink (_tmp29_);
	_tmp30_ = _tmp29_;
	_g_free0 (_tmp28_);
	header_label = _tmp30_;
	_tmp31_ = row;
	_tmp32_ = header_label;
	gtk_list_box_row_set_header ((GtkListBoxRow*) _tmp31_, (GtkWidget*) _tmp32_);
	_g_object_unref0 (header_label);
	_g_date_time_unref0 (due_date_time);
	_g_object_unref0 (row);
}

static Block29Data*
block29_data_ref (Block29Data* _data29_)
{
	g_atomic_int_inc (&_data29_->_ref_count_);
	return _data29_;
}

static void
block29_data_unref (void * _userdata_)
{
	Block29Data* _data29_;
	_data29_ = (Block29Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data29_->_ref_count_)) {
		TasksScheduledView* self;
		self = _data29_->self;
		_g_object_unref0 (_data29_->source);
		_g_object_unref0 (self);
		g_slice_free (Block29Data, _data29_);
	}
}

static void
_tasks_scheduled_view_on_row_unselect_tasks_widgets_task_row_unselect (TasksWidgetsTaskRow* _sender,
                                                                       GtkListBoxRow* row,
                                                                       gpointer self)
{
	tasks_scheduled_view_on_row_unselect ((TasksScheduledView*) self, row);
}

static Block30Data*
block30_data_ref (Block30Data* _data30_)
{
	g_atomic_int_inc (&_data30_->_ref_count_);
	return _data30_;
}

static void
block30_data_unref (void * _userdata_)
{
	Block30Data* _data30_;
	_data30_ = (Block30Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data30_->_ref_count_)) {
		TasksScheduledView* self;
		self = _data30_->self;
		_g_object_unref0 (_data30_->error_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block30Data, _data30_);
	}
}

static void
___lambda104_ (Block30Data* _data30_)
{
	TasksScheduledView* self;
	GraniteMessageDialog* _tmp0_;
	self = _data30_->self;
	_tmp0_ = _data30_->error_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
____lambda104__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	___lambda104_ (self);
}

static void
__lambda103_ (TasksScheduledView* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_complete_task_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		Block30Data* _data30_;
		GThemedIcon* _tmp1_;
		GThemedIcon* _tmp2_;
		GraniteMessageDialog* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GraniteMessageDialog* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_data30_ = g_slice_new0 (Block30Data);
		_data30_->_ref_count_ = 1;
		_data30_->self = g_object_ref (self);
		_tmp1_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp2_ = _tmp1_;
		_tmp3_ = granite_message_dialog_new (_ ("Completing task failed"), _ ("The task registry may be unavailable or unable to be written to."), (GIcon*) _tmp2_, GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_data30_->error_dialog = _tmp4_;
		_tmp5_ = _data30_->error_dialog;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		granite_message_dialog_show_error_details (_tmp5_, _tmp7_);
		_tmp8_ = _data30_->error_dialog;
		gtk_window_present ((GtkWindow*) _tmp8_);
		_tmp9_ = _data30_->error_dialog;
		g_signal_connect_data ((GtkDialog*) _tmp9_, "response", (GCallback) ____lambda104__gtk_dialog_response, block30_data_ref (_data30_), (GClosureNotify) block30_data_unref, 0);
		_g_error_free0 (e);
		block30_data_unref (_data30_);
		_data30_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda103__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda103_ ((TasksScheduledView*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda102_ (Block29Data* _data29_,
              ECalComponent* task)
{
	TasksScheduledView* self;
	TasksTaskModel* _tmp0_;
	self = _data29_->self;
	g_return_if_fail (task != NULL);
	_tmp0_ = tasks_application_model;
	tasks_task_model_complete_task (_tmp0_, _data29_->source, task, ___lambda103__gasync_ready_callback, g_object_ref (self));
}

static void
___lambda102__tasks_widgets_task_row_task_completed (TasksWidgetsTaskRow* _sender,
                                                     ECalComponent* task,
                                                     gpointer self)
{
	__lambda102_ (self, task);
}

static Block31Data*
block31_data_ref (Block31Data* _data31_)
{
	g_atomic_int_inc (&_data31_->_ref_count_);
	return _data31_;
}

static void
block31_data_unref (void * _userdata_)
{
	Block31Data* _data31_;
	_data31_ = (Block31Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data31_->_ref_count_)) {
		TasksScheduledView* self;
		self = _data31_->self;
		_g_object_unref0 (_data31_->error_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block31Data, _data31_);
	}
}

static void
___lambda107_ (Block31Data* _data31_)
{
	TasksScheduledView* self;
	GraniteMessageDialog* _tmp0_;
	self = _data31_->self;
	_tmp0_ = _data31_->error_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
____lambda107__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	___lambda107_ (self);
}

static void
__lambda106_ (TasksScheduledView* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_update_task_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		Block31Data* _data31_;
		GThemedIcon* _tmp1_;
		GThemedIcon* _tmp2_;
		GraniteMessageDialog* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GraniteMessageDialog* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_data31_ = g_slice_new0 (Block31Data);
		_data31_->_ref_count_ = 1;
		_data31_->self = g_object_ref (self);
		_tmp1_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp2_ = _tmp1_;
		_tmp3_ = granite_message_dialog_new (_ ("Updating task failed"), _ ("The task registry may be unavailable or unable to be written to."), (GIcon*) _tmp2_, GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_data31_->error_dialog = _tmp4_;
		_tmp5_ = _data31_->error_dialog;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		granite_message_dialog_show_error_details (_tmp5_, _tmp7_);
		_tmp8_ = _data31_->error_dialog;
		gtk_window_present ((GtkWindow*) _tmp8_);
		_tmp9_ = _data31_->error_dialog;
		g_signal_connect_data ((GtkDialog*) _tmp9_, "response", (GCallback) ____lambda107__gtk_dialog_response, block31_data_ref (_data31_), (GClosureNotify) block31_data_unref, 0);
		_g_error_free0 (e);
		block31_data_unref (_data31_);
		_data31_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda106__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda106_ ((TasksScheduledView*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda105_ (Block29Data* _data29_,
              ECalComponent* task)
{
	TasksScheduledView* self;
	TasksTaskModel* _tmp0_;
	self = _data29_->self;
	g_return_if_fail (task != NULL);
	_tmp0_ = tasks_application_model;
	tasks_task_model_update_task (_tmp0_, _data29_->source, task, E_CAL_OBJ_MOD_THIS_AND_FUTURE, ___lambda106__gasync_ready_callback, g_object_ref (self));
}

static void
___lambda105__tasks_widgets_task_row_task_changed (TasksWidgetsTaskRow* _sender,
                                                   ECalComponent* task,
                                                   gpointer self)
{
	__lambda105_ (self, task);
}

static Block32Data*
block32_data_ref (Block32Data* _data32_)
{
	g_atomic_int_inc (&_data32_->_ref_count_);
	return _data32_;
}

static void
block32_data_unref (void * _userdata_)
{
	Block32Data* _data32_;
	_data32_ = (Block32Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data32_->_ref_count_)) {
		TasksScheduledView* self;
		self = _data32_->self;
		_g_object_unref0 (_data32_->error_dialog);
		_g_object_unref0 (self);
		g_slice_free (Block32Data, _data32_);
	}
}

static void
___lambda110_ (Block32Data* _data32_)
{
	TasksScheduledView* self;
	GraniteMessageDialog* _tmp0_;
	self = _data32_->self;
	_tmp0_ = _data32_->error_dialog;
	gtk_window_destroy ((GtkWindow*) _tmp0_);
}

static void
____lambda110__gtk_dialog_response (GtkDialog* _sender,
                                    gint response_id,
                                    gpointer self)
{
	___lambda110_ (self);
}

static void
__lambda109_ (TasksScheduledView* self,
              GObject* obj,
              GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		TasksTaskModel* _tmp0_;
		_tmp0_ = tasks_application_model;
		tasks_task_model_remove_task_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		Block32Data* _data32_;
		GThemedIcon* _tmp1_;
		GThemedIcon* _tmp2_;
		GraniteMessageDialog* _tmp3_;
		GraniteMessageDialog* _tmp4_;
		GraniteMessageDialog* _tmp5_;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GraniteMessageDialog* _tmp8_;
		GraniteMessageDialog* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_data32_ = g_slice_new0 (Block32Data);
		_data32_->_ref_count_ = 1;
		_data32_->self = g_object_ref (self);
		_tmp1_ = (GThemedIcon*) g_themed_icon_new ("dialog-error");
		_tmp2_ = _tmp1_;
		_tmp3_ = granite_message_dialog_new (_ ("Removing task failed"), _ ("The task registry may be unavailable or unable to be written to."), (GIcon*) _tmp2_, GTK_BUTTONS_CLOSE);
		g_object_ref_sink (_tmp3_);
		_tmp4_ = _tmp3_;
		_g_object_unref0 (_tmp2_);
		_data32_->error_dialog = _tmp4_;
		_tmp5_ = _data32_->error_dialog;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		granite_message_dialog_show_error_details (_tmp5_, _tmp7_);
		_tmp8_ = _data32_->error_dialog;
		gtk_window_present ((GtkWindow*) _tmp8_);
		_tmp9_ = _data32_->error_dialog;
		g_signal_connect_data ((GtkDialog*) _tmp9_, "response", (GCallback) ____lambda110__gtk_dialog_response, block32_data_ref (_data32_), (GClosureNotify) block32_data_unref, 0);
		_g_error_free0 (e);
		block32_data_unref (_data32_);
		_data32_ = NULL;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda109__gasync_ready_callback (GObject* source_object,
                                     GAsyncResult* res,
                                     gpointer self)
{
	__lambda109_ ((TasksScheduledView*) self, source_object, res);
	g_object_unref (self);
}

static void
__lambda108_ (Block29Data* _data29_,
              ECalComponent* task)
{
	TasksScheduledView* self;
	TasksTaskModel* _tmp0_;
	self = _data29_->self;
	g_return_if_fail (task != NULL);
	_tmp0_ = tasks_application_model;
	tasks_task_model_remove_task (_tmp0_, _data29_->source, task, E_CAL_OBJ_MOD_ALL, ___lambda109__gasync_ready_callback, g_object_ref (self));
}

static void
___lambda108__tasks_widgets_task_row_task_removed (TasksWidgetsTaskRow* _sender,
                                                   ECalComponent* task,
                                                   gpointer self)
{
	__lambda108_ (self, task);
}

static gboolean
__lambda101_ (Block29Data* _data29_,
              ECalComponent* task)
{
	TasksScheduledView* self;
	TasksWidgetsTaskRow* task_row = NULL;
	TasksWidgetsTaskRow* _tmp0_;
	GtkListBox* _tmp1_;
	gboolean result;
	self = _data29_->self;
	g_return_val_if_fail (task != NULL, FALSE);
	_tmp0_ = tasks_widgets_task_row_new_for_component (task, _data29_->source, TRUE);
	g_object_ref_sink (_tmp0_);
	task_row = _tmp0_;
	g_signal_connect_object (task_row, "unselect", (GCallback) _tasks_scheduled_view_on_row_unselect_tasks_widgets_task_row_unselect, self, 0);
	g_signal_connect_data (task_row, "task-completed", (GCallback) ___lambda102__tasks_widgets_task_row_task_completed, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	g_signal_connect_data (task_row, "task-changed", (GCallback) ___lambda105__tasks_widgets_task_row_task_changed, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	g_signal_connect_data (task_row, "task-removed", (GCallback) ___lambda108__tasks_widgets_task_row_task_removed, block29_data_ref (_data29_), (GClosureNotify) block29_data_unref, 0);
	_tmp1_ = self->priv->task_list;
	gtk_list_box_append (_tmp1_, (GtkWidget*) task_row);
	result = TRUE;
	_g_object_unref0 (task_row);
	_g_object_unref0 (task);
	return result;
}

static gboolean
___lambda101__gee_forall_func (gpointer g,
                               gpointer self)
{
	gboolean result;
	result = __lambda101_ (self, (ECalComponent*) g);
	return result;
}

static gboolean
__lambda111_ (TasksScheduledView* self)
{
	GtkListBox* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->task_list;
	gtk_list_box_invalidate_sort (_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda111__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda111_ ((TasksScheduledView*) self);
	return result;
}

static void
tasks_scheduled_view_on_tasks_added (TasksScheduledView* self,
                                     GeeCollection* tasks,
                                     ESource* source)
{
	Block29Data* _data29_;
	ESource* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tasks != NULL);
	g_return_if_fail (source != NULL);
	_data29_ = g_slice_new0 (Block29Data);
	_data29_->_ref_count_ = 1;
	_data29_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (source);
	_g_object_unref0 (_data29_->source);
	_data29_->source = _tmp0_;
	gee_traversable_foreach ((GeeTraversable*) tasks, ___lambda101__gee_forall_func, _data29_);
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda111__gsource_func, g_object_ref (self), g_object_unref);
	block29_data_unref (_data29_);
	_data29_ = NULL;
}

static gboolean
__lambda112_ (TasksScheduledView* self)
{
	GtkListBox* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->task_list;
	gtk_list_box_invalidate_sort (_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda112__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda112_ ((TasksScheduledView*) self);
	return result;
}

static void
tasks_scheduled_view_on_tasks_modified (TasksScheduledView* self,
                                        GeeCollection* tasks)
{
	TasksWidgetsTaskRow* task_row = NULL;
	gint row_index = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tasks != NULL);
	task_row = NULL;
	row_index = 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			GtkListBox* _tmp2_;
			GtkListBoxRow* _tmp3_;
			TasksWidgetsTaskRow* _tmp4_;
			TasksWidgetsTaskRow* _tmp5_;
			gint _tmp16_;
			if (!_tmp0_) {
				TasksWidgetsTaskRow* _tmp1_;
				_tmp1_ = task_row;
				if (!(_tmp1_ != NULL)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp2_ = self->priv->task_list;
			_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, row_index);
			_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow));
			_g_object_unref0 (task_row);
			task_row = _tmp4_;
			_tmp5_ = task_row;
			if (_tmp5_ != NULL) {
				{
					GeeIterator* _task_it = NULL;
					GeeIterator* _tmp6_;
					_tmp6_ = gee_iterable_iterator ((GeeIterable*) tasks);
					_task_it = _tmp6_;
					while (TRUE) {
						GeeIterator* _tmp7_;
						ECalComponent* task = NULL;
						GeeIterator* _tmp8_;
						gpointer _tmp9_;
						TasksWidgetsTaskRow* _tmp10_;
						ECalComponent* _tmp11_;
						ECalComponent* _tmp12_;
						ECalComponent* _tmp13_;
						_tmp7_ = _task_it;
						if (!gee_iterator_next (_tmp7_)) {
							break;
						}
						_tmp8_ = _task_it;
						_tmp9_ = gee_iterator_get (_tmp8_);
						task = (ECalComponent*) _tmp9_;
						_tmp10_ = task_row;
						_tmp11_ = tasks_widgets_task_row_get_task (_tmp10_);
						_tmp12_ = _tmp11_;
						_tmp13_ = task;
						if (tasks_util_calcomponent_equal_func (_tmp12_, _tmp13_)) {
							TasksWidgetsTaskRow* _tmp14_;
							ECalComponent* _tmp15_;
							_tmp14_ = task_row;
							_tmp15_ = task;
							tasks_widgets_task_row_set_task (_tmp14_, _tmp15_);
							_g_object_unref0 (task);
							break;
						}
						_g_object_unref0 (task);
					}
					_g_object_unref0 (_task_it);
				}
			}
			_tmp16_ = row_index;
			row_index = _tmp16_ + 1;
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda112__gsource_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (task_row);
}

static gboolean
__lambda113_ (TasksScheduledView* self)
{
	GtkListBox* _tmp0_;
	gboolean result;
	_tmp0_ = self->priv->task_list;
	gtk_list_box_invalidate_sort (_tmp0_);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda113__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda113_ ((TasksScheduledView*) self);
	return result;
}

static void
tasks_scheduled_view_on_tasks_removed (TasksScheduledView* self,
                                       GSList* cids)
{
	TasksWidgetsTaskRow* task_row = NULL;
	gint row_index = 0;
	g_return_if_fail (self != NULL);
	task_row = NULL;
	row_index = 0;
	{
		gboolean _tmp0_ = FALSE;
		_tmp0_ = TRUE;
		while (TRUE) {
			GtkListBox* _tmp2_;
			GtkListBoxRow* _tmp3_;
			TasksWidgetsTaskRow* _tmp4_;
			gint _tmp15_;
			if (!_tmp0_) {
				TasksWidgetsTaskRow* _tmp1_;
				_tmp1_ = task_row;
				if (!(_tmp1_ != NULL)) {
					break;
				}
			}
			_tmp0_ = FALSE;
			_tmp2_ = self->priv->task_list;
			_tmp3_ = gtk_list_box_get_row_at_index (_tmp2_, row_index);
			task_row = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TASKS_WIDGETS_TYPE_TASK_ROW, TasksWidgetsTaskRow);
			_tmp4_ = task_row;
			if (_tmp4_ != NULL) {
				{
					GSList* cid_collection = NULL;
					GSList* cid_it = NULL;
					cid_collection = cids;
					for (cid_it = cid_collection; cid_it != NULL; cid_it = cid_it->next) {
						ECalComponentId* cid = NULL;
						cid = (ECalComponentId*) cid_it->data;
						{
							ECalComponentId* _tmp5_;
							_tmp5_ = cid;
							if (_tmp5_ == NULL) {
								continue;
							} else {
								ECalComponentId* _tmp6_;
								const gchar* _tmp7_;
								TasksWidgetsTaskRow* _tmp8_;
								ECalComponent* _tmp9_;
								ECalComponent* _tmp10_;
								ICalComponent* _tmp11_;
								const gchar* _tmp12_;
								_tmp6_ = cid;
								_tmp7_ = e_cal_component_id_get_uid (_tmp6_);
								_tmp8_ = task_row;
								_tmp9_ = tasks_widgets_task_row_get_task (_tmp8_);
								_tmp10_ = _tmp9_;
								_tmp11_ = e_cal_component_get_icalcomponent (_tmp10_);
								_tmp12_ = i_cal_component_get_uid (_tmp11_);
								if (g_strcmp0 (_tmp7_, _tmp12_) == 0) {
									GtkListBox* _tmp13_;
									TasksWidgetsTaskRow* _tmp14_;
									_tmp13_ = self->priv->task_list;
									_tmp14_ = task_row;
									gtk_list_box_remove (_tmp13_, (GtkWidget*) _tmp14_);
									break;
								}
							}
						}
					}
				}
			}
			_tmp15_ = row_index;
			row_index = _tmp15_ + 1;
		}
	}
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ___lambda113__gsource_func, g_object_ref (self), g_object_unref);
}

TasksTaskModel*
tasks_scheduled_view_get_model (TasksScheduledView* self)
{
	TasksTaskModel* result;
	TasksTaskModel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_model;
	result = _tmp0_;
	return result;
}

static void
tasks_scheduled_view_set_model (TasksScheduledView* self,
                                TasksTaskModel* value)
{
	TasksTaskModel* old_value;
	g_return_if_fail (self != NULL);
	old_value = tasks_scheduled_view_get_model (self);
	if (old_value != value) {
		TasksTaskModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_model);
		self->priv->_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, tasks_scheduled_view_properties[TASKS_SCHEDULED_VIEW_MODEL_PROPERTY]);
	}
}

static gint
_tasks_scheduled_view_sort_function_gtk_list_box_sort_func (GtkListBoxRow* row1,
                                                            GtkListBoxRow* row2,
                                                            gpointer self)
{
	gint result;
	result = tasks_scheduled_view_sort_function (row1, row2, (TasksScheduledView*) self);
	return result;
}

static void
_tasks_scheduled_view_header_function_gtk_list_box_update_header_func (GtkListBoxRow* row,
                                                                       GtkListBoxRow* before,
                                                                       gpointer self)
{
	tasks_scheduled_view_header_function ((TasksScheduledView*) self, row, before);
}

static void
_tasks_scheduled_view_on_row_activated_gtk_list_box_row_activated (GtkListBox* _sender,
                                                                   GtkListBoxRow* row,
                                                                   gpointer self)
{
	tasks_scheduled_view_on_row_activated ((TasksScheduledView*) self, row);
}

static void
_tasks_scheduled_view_add_task_list_tasks_task_model_task_list_added (TasksTaskModel* _sender,
                                                                      ESource* task_list,
                                                                      gpointer self)
{
	tasks_scheduled_view_add_task_list ((TasksScheduledView*) self, task_list);
}

static void
_tasks_scheduled_view_modify_task_list_tasks_task_model_task_list_modified (TasksTaskModel* _sender,
                                                                            ESource* task_list,
                                                                            gpointer self)
{
	tasks_scheduled_view_modify_task_list ((TasksScheduledView*) self, task_list);
}

static void
_tasks_scheduled_view_remove_task_list_tasks_task_model_task_list_removed (TasksTaskModel* _sender,
                                                                           ESource* task_list,
                                                                           gpointer self)
{
	tasks_scheduled_view_remove_task_list ((TasksScheduledView*) self, task_list);
}

static void
__lambda115_ (TasksScheduledView* self,
              ESource* source)
{
	g_return_if_fail (source != NULL);
	tasks_scheduled_view_add_task_list (self, source);
}

static void
___lambda115__gfunc (gconstpointer data,
                     gpointer self)
{
	__lambda115_ ((TasksScheduledView*) self, (ESource*) data);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static void
_tasks_scheduled_view___lambda114_ (TasksScheduledView* self,
                                    GObject* obj,
                                    GAsyncResult* res)
{
	ESourceRegistry* registry = NULL;
	GList* sources = NULL;
	ESourceRegistry* _tmp6_;
	GList* _tmp7_;
	GList* _tmp8_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		ESourceRegistry* _tmp0_ = NULL;
		TasksTaskModel* _tmp1_;
		ESourceRegistry* _tmp2_;
		ESourceRegistry* _tmp3_;
		_tmp1_ = self->priv->_model;
		_tmp2_ = tasks_task_model_get_registry_finish (_tmp1_, res, &_inner_error0_);
		_tmp0_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (registry);
		registry = _tmp3_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_critical ("ScheduledView.vala:118: %s", _tmp5_);
		_g_error_free0 (e);
		_g_object_unref0 (registry);
		return;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (registry);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp6_ = registry;
	_tmp7_ = e_source_registry_list_sources (_tmp6_, E_SOURCE_EXTENSION_TASK_LIST);
	sources = _tmp7_;
	_tmp8_ = sources;
	g_list_foreach (_tmp8_, ___lambda115__gfunc, self);
	(sources == NULL) ? NULL : (sources = (_g_list_free__g_object_unref0_ (sources), NULL));
	_g_object_unref0 (registry);
}

static void
__tasks_scheduled_view___lambda114__gasync_ready_callback (GObject* source_object,
                                                           GAsyncResult* res,
                                                           gpointer self)
{
	_tasks_scheduled_view___lambda114_ ((TasksScheduledView*) self, source_object, res);
	g_object_unref (self);
}

static GObject *
tasks_scheduled_view_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TasksScheduledView * self;
	GeeHashMap* _tmp0_;
	GtkLabel* _tmp1_ = NULL;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkLabel* placeholder = NULL;
	GtkLabel* _tmp4_;
	GtkLabel* _tmp5_;
	GtkLabel* _tmp6_;
	GtkListBox* _tmp7_ = NULL;
	GtkListBox* _tmp8_;
	GtkLabel* _tmp9_;
	GtkListBox* _tmp10_;
	GtkListBox* _tmp11_;
	GtkListBox* _tmp12_;
	GtkScrolledWindow* scrolled_window = NULL;
	GtkListBox* _tmp13_;
	GtkWidget* _tmp14_;
	GtkScrolledWindow* _tmp15_ = NULL;
	GtkBox* header_box = NULL;
	GtkBox* _tmp16_;
	GtkBox* _tmp17_;
	GtkLabel* _tmp18_;
	GtkBox* _tmp19_;
	GtkWindowControls* _tmp20_ = NULL;
	GtkWindowControls* _tmp21_;
	GtkBox* _tmp22_;
	AdwToolbarView* toolbar_view = NULL;
	GtkScrolledWindow* _tmp23_;
	GtkWidget* _tmp24_;
	AdwToolbarView* _tmp25_ = NULL;
	AdwToolbarView* _tmp26_;
	GtkBox* _tmp27_;
	AdwToolbarView* _tmp28_;
	GtkListBox* _tmp29_;
	TasksTaskModel* _tmp30_;
	TasksTaskModel* _tmp31_;
	TasksTaskModel* _tmp32_;
	TasksTaskModel* _tmp33_;
	parent_class = G_OBJECT_CLASS (tasks_scheduled_view_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_TYPE_SCHEDULED_VIEW, TasksScheduledView);
	_tmp0_ = gee_hash_map_new (e_source_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, e_cal_client_view_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->views);
	self->priv->views = (GeeMap*) _tmp0_;
	_tmp1_ = (GtkLabel*) gtk_label_new (_ ("Scheduled"));
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	gtk_label_set_ellipsize (_tmp1_, PANGO_ELLIPSIZE_END);
	gtk_label_set_xalign (_tmp1_, (gfloat) 0);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->scheduled_title);
	self->priv->scheduled_title = _tmp1_;
	_tmp2_ = self->priv->scheduled_title;
	gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_H1_LABEL);
	_tmp3_ = self->priv->scheduled_title;
	gtk_widget_add_css_class ((GtkWidget*) _tmp3_, GRANITE_STYLE_CLASS_ACCENT);
	_tmp4_ = (GtkLabel*) gtk_label_new (_ ("No Tasks"));
	g_object_ref_sink (_tmp4_);
	placeholder = _tmp4_;
	_tmp5_ = placeholder;
	gtk_widget_add_css_class ((GtkWidget*) _tmp5_, GRANITE_STYLE_CLASS_DIM_LABEL);
	_tmp6_ = placeholder;
	gtk_widget_add_css_class ((GtkWidget*) _tmp6_, GRANITE_STYLE_CLASS_H2_LABEL);
	_tmp7_ = (GtkListBox*) gtk_list_box_new ();
	gtk_list_box_set_selection_mode (_tmp7_, GTK_SELECTION_MULTIPLE);
	gtk_list_box_set_activate_on_single_click (_tmp7_, TRUE);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->task_list);
	self->priv->task_list = _tmp7_;
	_tmp8_ = self->priv->task_list;
	_tmp9_ = placeholder;
	gtk_list_box_set_placeholder (_tmp8_, (GtkWidget*) _tmp9_);
	_tmp10_ = self->priv->task_list;
	gtk_list_box_set_sort_func (_tmp10_, _tasks_scheduled_view_sort_function_gtk_list_box_sort_func, g_object_ref (self), g_object_unref);
	_tmp11_ = self->priv->task_list;
	gtk_list_box_set_header_func (_tmp11_, _tasks_scheduled_view_header_function_gtk_list_box_update_header_func, g_object_ref (self), g_object_unref);
	_tmp12_ = self->priv->task_list;
	gtk_widget_add_css_class ((GtkWidget*) _tmp12_, GRANITE_STYLE_CLASS_BACKGROUND);
	_tmp13_ = self->priv->task_list;
	_tmp14_ = _g_object_ref0 ((GtkWidget*) _tmp13_);
	_tmp15_ = (GtkScrolledWindow*) gtk_scrolled_window_new ();
	gtk_scrolled_window_set_child (_tmp15_, _tmp14_);
	_g_object_unref0 (_tmp14_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp15_, TRUE);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp15_, TRUE);
	g_object_set (_tmp15_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp15_);
	scrolled_window = _tmp15_;
	_tmp16_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp16_);
	header_box = _tmp16_;
	_tmp17_ = header_box;
	_tmp18_ = self->priv->scheduled_title;
	gtk_box_append (_tmp17_, (GtkWidget*) _tmp18_);
	_tmp19_ = header_box;
	_tmp20_ = (GtkWindowControls*) gtk_window_controls_new (GTK_PACK_END);
	gtk_widget_set_valign ((GtkWidget*) _tmp20_, GTK_ALIGN_START);
	g_object_ref_sink (_tmp20_);
	_tmp21_ = _tmp20_;
	gtk_box_append (_tmp19_, (GtkWidget*) _tmp21_);
	_g_object_unref0 (_tmp21_);
	_tmp22_ = header_box;
	gtk_widget_add_css_class ((GtkWidget*) _tmp22_, "titlebar");
	_tmp23_ = scrolled_window;
	_tmp24_ = _g_object_ref0 ((GtkWidget*) _tmp23_);
	_tmp25_ = (AdwToolbarView*) adw_toolbar_view_new ();
	adw_toolbar_view_set_content (_tmp25_, _tmp24_);
	_g_object_unref0 (_tmp24_);
	g_object_ref_sink (_tmp25_);
	toolbar_view = _tmp25_;
	_tmp26_ = toolbar_view;
	_tmp27_ = header_box;
	adw_toolbar_view_add_top_bar (_tmp26_, (GtkWidget*) _tmp27_);
	_tmp28_ = toolbar_view;
	granite_bin_set_child ((GraniteBin*) self, (GtkWidget*) _tmp28_);
	_tmp29_ = self->priv->task_list;
	g_signal_connect_object (_tmp29_, "row-activated", (GCallback) _tasks_scheduled_view_on_row_activated_gtk_list_box_row_activated, self, 0);
	_tmp30_ = self->priv->_model;
	g_signal_connect_object (_tmp30_, "task-list-added", (GCallback) _tasks_scheduled_view_add_task_list_tasks_task_model_task_list_added, self, 0);
	_tmp31_ = self->priv->_model;
	g_signal_connect_object (_tmp31_, "task-list-modified", (GCallback) _tasks_scheduled_view_modify_task_list_tasks_task_model_task_list_modified, self, 0);
	_tmp32_ = self->priv->_model;
	g_signal_connect_object (_tmp32_, "task-list-removed", (GCallback) _tasks_scheduled_view_remove_task_list_tasks_task_model_task_list_removed, self, 0);
	_tmp33_ = self->priv->_model;
	tasks_task_model_get_registry (_tmp33_, __tasks_scheduled_view___lambda114__gasync_ready_callback, g_object_ref (self));
	_g_object_unref0 (toolbar_view);
	_g_object_unref0 (header_box);
	_g_object_unref0 (scrolled_window);
	_g_object_unref0 (placeholder);
	return obj;
}

static void
tasks_scheduled_view_class_init (TasksScheduledViewClass * klass,
                                 gpointer klass_data)
{
	tasks_scheduled_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TasksScheduledView_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_tasks_scheduled_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tasks_scheduled_view_set_property;
	G_OBJECT_CLASS (klass)->constructor = tasks_scheduled_view_constructor;
	G_OBJECT_CLASS (klass)->finalize = tasks_scheduled_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TASKS_SCHEDULED_VIEW_MODEL_PROPERTY, tasks_scheduled_view_properties[TASKS_SCHEDULED_VIEW_MODEL_PROPERTY] = g_param_spec_object ("model", "model", "model", TASKS_TYPE_TASK_MODEL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
}

static void
tasks_scheduled_view_instance_init (TasksScheduledView * self,
                                    gpointer klass)
{
	self->priv = tasks_scheduled_view_get_instance_private (self);
	g_rec_mutex_init (&self->priv->__lock_views);
}

static void
tasks_scheduled_view_finalize (GObject * obj)
{
	TasksScheduledView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TASKS_TYPE_SCHEDULED_VIEW, TasksScheduledView);
	g_rec_mutex_clear (&self->priv->__lock_views);
	_g_object_unref0 (self->priv->views);
	_g_object_unref0 (self->priv->_model);
	_g_object_unref0 (self->priv->scheduled_title);
	_g_object_unref0 (self->priv->task_list);
	G_OBJECT_CLASS (tasks_scheduled_view_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tasks_scheduled_view_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TasksScheduledViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tasks_scheduled_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TasksScheduledView), 0, (GInstanceInitFunc) tasks_scheduled_view_instance_init, NULL };
	GType tasks_scheduled_view_type_id;
	tasks_scheduled_view_type_id = g_type_register_static (GRANITE_TYPE_BIN, "TasksScheduledView", &g_define_type_info, 0);
	TasksScheduledView_private_offset = g_type_add_instance_private (tasks_scheduled_view_type_id, sizeof (TasksScheduledViewPrivate));
	return tasks_scheduled_view_type_id;
}

GType
tasks_scheduled_view_get_type (void)
{
	static gsize tasks_scheduled_view_type_id__once = 0;
	if (g_once_init_enter (&tasks_scheduled_view_type_id__once)) {
		GType tasks_scheduled_view_type_id;
		tasks_scheduled_view_type_id = tasks_scheduled_view_get_type_once ();
		g_once_init_leave (&tasks_scheduled_view_type_id__once, tasks_scheduled_view_type_id);
	}
	return tasks_scheduled_view_type_id__once;
}

static void
_vala_tasks_scheduled_view_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	TasksScheduledView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TASKS_TYPE_SCHEDULED_VIEW, TasksScheduledView);
	switch (property_id) {
		case TASKS_SCHEDULED_VIEW_MODEL_PROPERTY:
		g_value_set_object (value, tasks_scheduled_view_get_model (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tasks_scheduled_view_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	TasksScheduledView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TASKS_TYPE_SCHEDULED_VIEW, TasksScheduledView);
	switch (property_id) {
		case TASKS_SCHEDULED_VIEW_MODEL_PROPERTY:
		tasks_scheduled_view_set_model (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

