// python wrapper for vtkEquivalenceSet
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkEquivalenceSet.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkEquivalenceSet(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkEquivalenceSet_ClassNew(); }


static PyObject *
PyvtkEquivalenceSet_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkEquivalenceSet::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkEquivalenceSet::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkEquivalenceSet *tempr = vtkEquivalenceSet::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkEquivalenceSet *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkEquivalenceSet::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkEquivalenceSet::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkEquivalenceSet::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Initialize();
    }
    else
    {
      op->vtkEquivalenceSet::Initialize();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_AddEquivalence(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddEquivalence");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddEquivalence(temp0, temp1);
    }
    else
    {
      op->vtkEquivalenceSet::AddEquivalence(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_GetNumberOfMembers(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfMembers");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfMembers() :
      op->vtkEquivalenceSet::GetNumberOfMembers());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_GetNumberOfResolvedSets(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfResolvedSets");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetNumberOfResolvedSets() :
      op->vtkEquivalenceSet::GetNumberOfResolvedSets());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_GetEquivalentSetId(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetEquivalentSetId");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetEquivalentSetId(temp0) :
      op->vtkEquivalenceSet::GetEquivalentSetId(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_ResolveEquivalences(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ResolveEquivalences");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->ResolveEquivalences() :
      op->vtkEquivalenceSet::ResolveEquivalences());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_DeepCopy(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "DeepCopy");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  vtkEquivalenceSet *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkEquivalenceSet"))
  {
    if (ap.IsBound())
    {
      op->DeepCopy(temp0);
    }
    else
    {
      op->vtkEquivalenceSet::DeepCopy(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_GetPointer(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPointer");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int *tempr = (ap.IsBound() ?
      op->GetPointer() :
      op->vtkEquivalenceSet::GetPointer());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_Squeeze(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Squeeze");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Squeeze();
    }
    else
    {
      op->vtkEquivalenceSet::Squeeze();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_Capacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Capacity");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = (ap.IsBound() ?
      op->Capacity() :
      op->vtkEquivalenceSet::Capacity());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkEquivalenceSet_GetReference(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetReference");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkEquivalenceSet *op = static_cast<vtkEquivalenceSet *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->GetReference(temp0) :
      op->vtkEquivalenceSet::GetReference(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkEquivalenceSet_Methods[] = {
  {"IsTypeOf", PyvtkEquivalenceSet_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkEquivalenceSet_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkEquivalenceSet_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkEquivalenceSet\nC++: static vtkEquivalenceSet *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkEquivalenceSet_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkEquivalenceSet\nC++: vtkEquivalenceSet *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkEquivalenceSet_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkEquivalenceSet_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"Initialize", PyvtkEquivalenceSet_Initialize, METH_VARARGS,
   "Initialize(self) -> None\nC++: void Initialize()\n\n"},
  {"AddEquivalence", PyvtkEquivalenceSet_AddEquivalence, METH_VARARGS,
   "AddEquivalence(self, id1:int, id2:int) -> None\nC++: void AddEquivalence(int id1, int id2)\n\n"},
  {"GetNumberOfMembers", PyvtkEquivalenceSet_GetNumberOfMembers, METH_VARARGS,
   "GetNumberOfMembers(self) -> int\nC++: int GetNumberOfMembers()\n\n"},
  {"GetNumberOfResolvedSets", PyvtkEquivalenceSet_GetNumberOfResolvedSets, METH_VARARGS,
   "GetNumberOfResolvedSets(self) -> int\nC++: int GetNumberOfResolvedSets()\n\n"},
  {"GetEquivalentSetId", PyvtkEquivalenceSet_GetEquivalentSetId, METH_VARARGS,
   "GetEquivalentSetId(self, memberId:int) -> int\nC++: int GetEquivalentSetId(int memberId)\n\n"},
  {"ResolveEquivalences", PyvtkEquivalenceSet_ResolveEquivalences, METH_VARARGS,
   "ResolveEquivalences(self) -> int\nC++: virtual int ResolveEquivalences()\n\n"},
  {"DeepCopy", PyvtkEquivalenceSet_DeepCopy, METH_VARARGS,
   "DeepCopy(self, in_:vtkEquivalenceSet) -> None\nC++: void DeepCopy(vtkEquivalenceSet *in)\n\n"},
  {"GetPointer", PyvtkEquivalenceSet_GetPointer, METH_VARARGS,
   "GetPointer(self) -> Pointer\nC++: int *GetPointer()\n\n"},
  {"Squeeze", PyvtkEquivalenceSet_Squeeze, METH_VARARGS,
   "Squeeze(self) -> None\nC++: void Squeeze()\n\n"},
  {"Capacity", PyvtkEquivalenceSet_Capacity, METH_VARARGS,
   "Capacity(self) -> int\nC++: vtkIdType Capacity()\n\n"},
  {"GetReference", PyvtkEquivalenceSet_GetReference, METH_VARARGS,
   "GetReference(self, memberId:int) -> int\nC++: int GetReference(int memberId)\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkEquivalenceSet_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("pointer"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkEquivalenceSet_GetPointer(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetPointer\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_members"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkEquivalenceSet_GetNumberOfMembers(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfMembers\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("number_of_resolved_sets"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkEquivalenceSet_GetNumberOfResolvedSets(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetNumberOfResolvedSets\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkEquivalenceSet_Doc =
  "vtkEquivalenceSet - records groups of integers that are equivalent.\n\n"
  "Superclass: vtkObject\n\n"
  "Useful for connectivity on multiple processes.  Run connectivity on\n"
  "each processes, then make touching fragments equivalent.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkEquivalenceSet_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersGeneral.vtkEquivalenceSet", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkEquivalenceSet_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkEquivalenceSet_StaticNew()
{
  return vtkEquivalenceSet::New();
}

PyObject *PyvtkEquivalenceSet_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkEquivalenceSet_Type, PyvtkEquivalenceSet_Methods,
    "vtkEquivalenceSet",
 &PyvtkEquivalenceSet_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("vtkObject");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkEquivalenceSet_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkEquivalenceSet(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkEquivalenceSet_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkEquivalenceSet", o) != 0)
  {
    Py_DECREF(o);
  }

}

