// python wrapper for vtkCSVExporter
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkIndent.h"
#include "vtkCSVExporter.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkCSVExporter(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkCSVExporter_ClassNew(); }

#ifndef DECLARED_PyvtkAbstractChartExporter_ClassNew
extern "C" { PyObject *PyvtkAbstractChartExporter_ClassNew(); }
#define DECLARED_PyvtkAbstractChartExporter_ClassNew
#endif

static PyObject *
PyvtkCSVExporter_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = vtkCSVExporter::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->vtkCSVExporter::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    vtkCSVExporter *tempr = vtkCSVExporter::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    vtkCSVExporter *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->vtkCSVExporter::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = vtkCSVExporter::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->vtkCSVExporter::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_SetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetFilePath(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFileName(temp0);
    }
    else
    {
      op->vtkCSVExporter::SetFileName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_GetFileName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFileName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFileName() :
      op->vtkCSVExporter::GetFileName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_SetFieldDelimiter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFieldDelimiter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFieldDelimiter(temp0);
    }
    else
    {
      op->vtkCSVExporter::SetFieldDelimiter(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_GetFieldDelimiter(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFieldDelimiter");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    char *tempr = (ap.IsBound() ?
      op->GetFieldDelimiter() :
      op->vtkCSVExporter::GetFieldDelimiter());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_SetFormatting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetFormatting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetFormatting(temp0);
    }
    else
    {
      op->vtkCSVExporter::SetFormatting(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_GetFormatting(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetFormatting");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetFormatting() :
      op->vtkCSVExporter::GetFormatting());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_SetPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetPrecision(temp0);
    }
    else
    {
      op->vtkCSVExporter::SetPrecision(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_GetPrecision(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetPrecision");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    int tempr = (ap.IsBound() ?
      op->GetPrecision() :
      op->vtkCSVExporter::GetPrecision());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_SetColumnLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetColumnLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  const char *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->SetColumnLabel(temp0, temp1);
    }
    else
    {
      op->vtkCSVExporter::SetColumnLabel(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_ClearColumnLabels(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "ClearColumnLabels");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->ClearColumnLabels();
    }
    else
    {
      op->vtkCSVExporter::ClearColumnLabels();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_GetColumnLabel(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetColumnLabel");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    const char *tempr = (ap.IsBound() ?
      op->GetColumnLabel(temp0) :
      op->vtkCSVExporter::GetColumnLabel(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_Close(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Close");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Close();
    }
    else
    {
      op->vtkCSVExporter::Close();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_Abort(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Abort");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->Abort();
    }
    else
    {
      op->vtkCSVExporter::Abort();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_WriteHeader(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteHeader");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  vtkFieldData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkFieldData"))
  {
    if (ap.IsBound())
    {
      op->WriteHeader(temp0);
    }
    else
    {
      op->vtkCSVExporter::WriteHeader(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_WriteData(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteData");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  vtkFieldData *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkFieldData"))
  {
    if (ap.IsBound())
    {
      op->WriteData(temp0);
    }
    else
    {
      op->vtkCSVExporter::WriteData(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_AddColumn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddColumn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  vtkAbstractArray *temp0 = nullptr;
  const char *temp1 = nullptr;
  vtkDataArray *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1, 3) &&
      ap.GetVTKObject(temp0, "vtkAbstractArray") &&
      (ap.NoArgsLeft() || ap.GetValue(temp1)) &&
      (ap.NoArgsLeft() || ap.GetVTKObject(temp2, "vtkDataArray")))
  {
    if (ap.IsBound())
    {
      op->AddColumn(temp0, temp1, temp2);
    }
    else
    {
      op->vtkCSVExporter::AddColumn(temp0, temp1, temp2);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_AddStyle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "AddStyle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  vtkPlot *temp0 = nullptr;
  const char *temp1 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkPlot") &&
      ap.GetValue(temp1))
  {
    if (ap.IsBound())
    {
      op->AddStyle(temp0, temp1);
    }
    else
    {
      op->vtkCSVExporter::AddStyle(temp0, temp1);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_SetGlobalStyle(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetGlobalStyle");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  vtkChart *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkChart"))
  {
    if (ap.IsBound())
    {
      op->SetGlobalStyle(temp0);
    }
    else
    {
      op->vtkCSVExporter::SetGlobalStyle(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_SetWriteToOutputString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetWriteToOutputString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  bool temp0 = false;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetWriteToOutputString(temp0);
    }
    else
    {
      op->vtkCSVExporter::SetWriteToOutputString(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_GetWriteToOutputString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetWriteToOutputString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    bool tempr = (ap.IsBound() ?
      op->GetWriteToOutputString() :
      op->vtkCSVExporter::GetWriteToOutputString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_WriteToOutputStringOn(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteToOutputStringOn");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteToOutputStringOn();
    }
    else
    {
      op->vtkCSVExporter::WriteToOutputStringOn();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_WriteToOutputStringOff(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "WriteToOutputStringOff");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    if (ap.IsBound())
    {
      op->WriteToOutputStringOff();
    }
    else
    {
      op->vtkCSVExporter::WriteToOutputStringOff();
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkCSVExporter_GetOutputString(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetOutputString");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  vtkCSVExporter *op = static_cast<vtkCSVExporter *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetOutputString() :
      op->vtkCSVExporter::GetOutputString());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkCSVExporter_Methods[] = {
  {"IsTypeOf", PyvtkCSVExporter_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyvtkCSVExporter_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyvtkCSVExporter_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> vtkCSVExporter\nC++: static vtkCSVExporter *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyvtkCSVExporter_NewInstance, METH_VARARGS,
   "NewInstance(self) -> vtkCSVExporter\nC++: vtkCSVExporter *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyvtkCSVExporter_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyvtkCSVExporter_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetFileName", PyvtkCSVExporter_SetFileName, METH_VARARGS,
   "SetFileName(self, _arg:str) -> None\nC++: virtual void SetFileName(const char *_arg)\n\nGet/Set the filename for the file.\n"},
  {"GetFileName", PyvtkCSVExporter_GetFileName, METH_VARARGS,
   "GetFileName(self) -> str\nC++: virtual char *GetFileName()\n\n"},
  {"SetFieldDelimiter", PyvtkCSVExporter_SetFieldDelimiter, METH_VARARGS,
   "SetFieldDelimiter(self, _arg:str) -> None\nC++: virtual void SetFieldDelimiter(const char *_arg)\n\nGet/Set the delimiter use to separate fields (\",\" by default.)\n"},
  {"GetFieldDelimiter", PyvtkCSVExporter_GetFieldDelimiter, METH_VARARGS,
   "GetFieldDelimiter(self) -> str\nC++: virtual char *GetFieldDelimiter()\n\n"},
  {"SetFormatting", PyvtkCSVExporter_SetFormatting, METH_VARARGS,
   "SetFormatting(self, _arg:int) -> None\nC++: virtual void SetFormatting(int _arg)\n\nSet a formatting to use when writing real numbers (aka\nfloating-point numbers) to csv. See the std::fixed doc for more\ninfo. Default is vtkVariant::DEFAULT_FORMATTING\n"},
  {"GetFormatting", PyvtkCSVExporter_GetFormatting, METH_VARARGS,
   "GetFormatting(self) -> int\nC++: virtual int GetFormatting()\n\n"},
  {"SetPrecision", PyvtkCSVExporter_SetPrecision, METH_VARARGS,
   "SetPrecision(self, _arg:int) -> None\nC++: virtual void SetPrecision(int _arg)\n\nSet a precision to use when writing real numbers (aka\nfloating-point numbers) to csv. See the std::setprecision doc for\nmore info. Default is 6\n"},
  {"GetPrecision", PyvtkCSVExporter_GetPrecision, METH_VARARGS,
   "GetPrecision(self) -> int\nC++: virtual int GetPrecision()\n\n"},
  {"SetColumnLabel", PyvtkCSVExporter_SetColumnLabel, METH_VARARGS,
   "SetColumnLabel(self, name:str, label:str) -> None\nC++: void SetColumnLabel(const char *name, const char *label)\n\nIn STREAM_ROWS mode, this API can be used to change columns\nlabels when exporting.\n"},
  {"ClearColumnLabels", PyvtkCSVExporter_ClearColumnLabels, METH_VARARGS,
   "ClearColumnLabels(self) -> None\nC++: void ClearColumnLabels()\n\n"},
  {"GetColumnLabel", PyvtkCSVExporter_GetColumnLabel, METH_VARARGS,
   "GetColumnLabel(self, name:str) -> str\nC++: const char *GetColumnLabel(const char *name)\n\n"},
  {"Close", PyvtkCSVExporter_Close, METH_VARARGS,
   "Close(self) -> None\nC++: void Close() override;\n\nCloses the file cleanly. Call this at the end to close the file\nand dump out any cached data.\n"},
  {"Abort", PyvtkCSVExporter_Abort, METH_VARARGS,
   "Abort(self) -> None\nC++: void Abort() override;\n\nSame as Close except deletes the file, if created. This is useful\nto interrupt the exporting on failure.\n"},
  {"WriteHeader", PyvtkCSVExporter_WriteHeader, METH_VARARGS,
   "WriteHeader(self, __a:vtkFieldData) -> None\nC++: void WriteHeader(vtkFieldData *) override;\n\nIn STREAM_ROWS mode, use these methods to write column headers\nonce using WriteHeader and then use WriteData as many times as\nneeded to write out rows.\n"},
  {"WriteData", PyvtkCSVExporter_WriteData, METH_VARARGS,
   "WriteData(self, __a:vtkFieldData) -> None\nC++: void WriteData(vtkFieldData *) override;\n\n"},
  {"AddColumn", PyvtkCSVExporter_AddColumn, METH_VARARGS,
   "AddColumn(self, yarray:vtkAbstractArray, yarrayname:str=...,\n    xarray:vtkDataArray=...) -> None\nC++: void AddColumn(vtkAbstractArray *yarray,\n    const char *yarrayname=nullptr, vtkDataArray *xarray=nullptr)\n    override;\n\nIn STREAM_COLUMNS mode, use this method to add a column (\nyarray). One can assign it a name different the the name of the\narray using \\c yarrayname. If xarray is not nullptr, then is used\nas the row-id. This makes it possible to add multiple columns\nwith varying number of samples. The final output will have empty\ncells for missing values.\n"},
  {"AddStyle", PyvtkCSVExporter_AddStyle, METH_VARARGS,
   "AddStyle(self, plot:vtkPlot, plotName:str) -> None\nC++: void AddStyle(vtkPlot *plot, const char *plotName) override;\n\nAttach information about the style of the plot (color,line type,\nmarker type etc. To the plot accosiated with plotName. plotName\nshould match the yarrayname used when adding the data via Add\nColumn. AddColumn needs to be called before adding the style.\n"},
  {"SetGlobalStyle", PyvtkCSVExporter_SetGlobalStyle, METH_VARARGS,
   "SetGlobalStyle(self, chart:vtkChart) -> None\nC++: void SetGlobalStyle(vtkChart *chart) override;\n\nSet Global style elements like graph and axis titles. Each\nimplementation is expected to get what it can support from the\npublic vtkChart API.\n"},
  {"SetWriteToOutputString", PyvtkCSVExporter_SetWriteToOutputString, METH_VARARGS,
   "SetWriteToOutputString(self, _arg:bool) -> None\nC++: virtual void SetWriteToOutputString(bool _arg)\n\nWhether to output to a string instead of to a file, which is the\ndefault.\n"},
  {"GetWriteToOutputString", PyvtkCSVExporter_GetWriteToOutputString, METH_VARARGS,
   "GetWriteToOutputString(self) -> bool\nC++: virtual bool GetWriteToOutputString()\n\n"},
  {"WriteToOutputStringOn", PyvtkCSVExporter_WriteToOutputStringOn, METH_VARARGS,
   "WriteToOutputStringOn(self) -> None\nC++: virtual void WriteToOutputStringOn()\n\n"},
  {"WriteToOutputStringOff", PyvtkCSVExporter_WriteToOutputStringOff, METH_VARARGS,
   "WriteToOutputStringOff(self) -> None\nC++: virtual void WriteToOutputStringOff()\n\n"},
  {"GetOutputString", PyvtkCSVExporter_GetOutputString, METH_VARARGS,
   "GetOutputString(self) -> str\nC++: std::string GetOutputString()\n\nGet the exported data as string. If WriteToOutputString is OFF,\nreturned string is empty. If Close() was not called, returned\nstring is empty.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkCSVExporter_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("file_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVExporter_GetFileName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVExporter_SetFileName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVExporter_SetFileName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFileName/SetFileName\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("field_delimiter"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVExporter_GetFieldDelimiter(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVExporter_SetFieldDelimiter(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVExporter_SetFieldDelimiter(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFieldDelimiter/SetFieldDelimiter\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("formatting"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVExporter_GetFormatting(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVExporter_SetFormatting(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVExporter_SetFormatting(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetFormatting/SetFormatting\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("precision"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVExporter_GetPrecision(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVExporter_SetPrecision(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVExporter_SetPrecision(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetPrecision/SetPrecision\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("global_style"),
    /*get=*/nullptr,
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVExporter_SetGlobalStyle(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVExporter_SetGlobalStyle(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("write-only, Calls SetGlobalStyle\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("write_to_output_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVExporter_GetWriteToOutputString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyvtkCSVExporter_SetWriteToOutputString(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyvtkCSVExporter_SetWriteToOutputString(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetWriteToOutputString/SetWriteToOutputString\n"),
    /*closure=*/nullptr,
  },
  {
    /*name=*/pystr("output_string"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyvtkCSVExporter_GetOutputString(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/nullptr,
    /*doc=*/pystr("read-only, Calls GetOutputString\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyvtkCSVExporter_Doc =
  "vtkCSVExporter - exporter used by certain views to export data as CSV.\n\n"
  "Superclass: vtkAbstractChartExporter\n\n"
  "vtkCSVExporter can be used to generate comma-separated files. Unlike\n"
  "`vtkCSVWriter`, this class can generate a single CSV from multiple\n"
  "array collections. This avoids the need to generate of single large\n"
  "appended table. The multiple arrays together represent the complete\n"
  "tabular data that gets exported. The table can be split column-wise\n"
  "or row-wise between multiple arrays. The `vtkCSVExporter` provides\n"
  "two sets of APIs to handle the two cases. They cannot be mixed.\n\n"
  "When exporting array instances split by columns, i.e. each array will\n"
  "have exactly same number of rows but different columns that are to be\n"
  "concatenated together, use the `STREAM_COLUMNS` mode. To use this\n"
  "mode, start writing by using\n"
  "`vtkCSVExporter::Open(vtkCSVExporter::STREAM_COLUMNS)` and then add\n"
  "each column using `vtkCSVExporter::AddColumn`. Finally, complete the\n"
  "export can generate the output using `vtkCSVExporter::Close`.\n\n"
  "When exporting arrays that are split by rows, use the STREAM_ROWS\n"
  "mode. The arrays are provided as a part of vtkFieldData (or\n"
  "subclass). To begin exporting in this mode, use\n"
  "`vtkCSVExporter::Open(vtkCSVExporter::STREAM_ROWS)`. Write the header\n"
  "using `vtkCSVExporter::WriteHeader(vtkFieldData*)` and the pass rows\n"
  "in order by using `vtkCSVExporter::WriteData(vtkFieldData*) multiple\n"
  "times. Finally, close using `vtkCSVExporter::Close`.\n\n"
  "In STREAM_ROWS mode, the exporter supports invalid / empty cells.\n"
  "When writing each column in `WriteData` call, for each column-name an\n"
  "vtkUnsignedCharArray with the name `__vtkValidMask__{COLUMN_NAME}` is\n"
  "looked up. If found, it's value is used to determine if that cell is\n"
  "to written out or not.\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkCSVExporter_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersRendering.vtkCSVExporter", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyvtkCSVExporter_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyvtkCSVExporter_StaticNew()
{
  return vtkCSVExporter::New();
}

PyObject *PyvtkCSVExporter_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyvtkCSVExporter_Type, PyvtkCSVExporter_Methods,
    "vtkCSVExporter",
 &PyvtkCSVExporter_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = (PyTypeObject *)PyvtkAbstractChartExporter_ClassNew();

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyvtkCSVExporter_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkCSVExporter(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkCSVExporter_ClassNew();

  if (o && PyDict_SetItemString(dict, "vtkCSVExporter", o) != 0)
  {
    Py_DECREF(o);
  }

}

