// components/services/storage/public/mojom/indexed_db_control.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/storage/public/mojom/indexed_db_control.mojom-shared.h"
#include "components/services/storage/public/mojom/indexed_db_control.mojom-forward.h"
#include "components/services/storage/public/mojom/indexed_db_control_test.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/string16.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "third_party/blink/public/mojom/indexeddb/indexeddb.mojom.h"
#include "url/mojom/origin.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace storage {
namespace mojom {

class IndexedDBObserverProxy;

template <typename ImplRefTraits>
class IndexedDBObserverStub;

class IndexedDBObserverRequestValidator;


class  IndexedDBObserver
    : public IndexedDBObserverInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = IndexedDBObserverInterfaceBase;
  using Proxy_ = IndexedDBObserverProxy;

  template <typename ImplRefTraits>
  using Stub_ = IndexedDBObserverStub<ImplRefTraits>;

  using RequestValidator_ = IndexedDBObserverRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnIndexedDBListChangedMinVersion = 0,
    kOnIndexedDBContentChangedMinVersion = 0,
  };
  virtual ~IndexedDBObserver() {}

  
  virtual void OnIndexedDBListChanged(const ::url::Origin& origin) = 0;

  
  virtual void OnIndexedDBContentChanged(const ::url::Origin& origin, const ::base::string16& database_name, const ::base::string16& object_store_name) = 0;
};

class IndexedDBControlProxy;

template <typename ImplRefTraits>
class IndexedDBControlStub;

class IndexedDBControlRequestValidator;
class IndexedDBControlResponseValidator;


class  IndexedDBControl
    : public IndexedDBControlInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = IndexedDBControlInterfaceBase;
  using Proxy_ = IndexedDBControlProxy;

  template <typename ImplRefTraits>
  using Stub_ = IndexedDBControlStub<ImplRefTraits>;

  using RequestValidator_ = IndexedDBControlRequestValidator;
  using ResponseValidator_ = IndexedDBControlResponseValidator;
  enum MethodMinVersions : uint32_t {
    kBindIndexedDBMinVersion = 0,
    kGetUsageMinVersion = 0,
    kDeleteForOriginMinVersion = 0,
    kForceCloseMinVersion = 0,
    kGetConnectionCountMinVersion = 0,
    kDownloadOriginDataMinVersion = 0,
    kGetAllOriginsDetailsMinVersion = 0,
    kSetForceKeepSessionStateMinVersion = 0,
    kAddObserverMinVersion = 0,
    kApplyPolicyUpdatesMinVersion = 0,
    kBindTestInterfaceMinVersion = 0,
  };
  virtual ~IndexedDBControl() {}

  
  virtual void BindIndexedDB(const ::url::Origin& origin, ::mojo::PendingReceiver<::blink::mojom::IDBFactory> receiver) = 0;


  using GetUsageCallback = base::OnceCallback<void(std::vector<IndexedDBStorageUsageInfoPtr>)>;
  
  virtual void GetUsage(GetUsageCallback callback) = 0;


  using DeleteForOriginCallback = base::OnceCallback<void(bool)>;
  
  virtual void DeleteForOrigin(const ::url::Origin& origin, DeleteForOriginCallback callback) = 0;


  using ForceCloseCallback = base::OnceCallback<void()>;
  
  virtual void ForceClose(const ::url::Origin& origin, ForceCloseReason reason, ForceCloseCallback callback) = 0;


  using GetConnectionCountCallback = base::OnceCallback<void(uint64_t)>;
  
  virtual void GetConnectionCount(const ::url::Origin& origin, GetConnectionCountCallback callback) = 0;


  using DownloadOriginDataCallback = base::OnceCallback<void(bool, const ::base::FilePath&, const ::base::FilePath&)>;
  
  virtual void DownloadOriginData(const ::url::Origin& origin, DownloadOriginDataCallback callback) = 0;


  using GetAllOriginsDetailsCallback = base::OnceCallback<void(bool, ::base::Value)>;
  
  virtual void GetAllOriginsDetails(GetAllOriginsDetailsCallback callback) = 0;

  
  virtual void SetForceKeepSessionState() = 0;

  
  virtual void AddObserver(::mojo::PendingRemote<IndexedDBObserver> observer) = 0;

  
  virtual void ApplyPolicyUpdates(std::vector<IndexedDBStoragePolicyUpdatePtr> policy_updates) = 0;

  
  virtual void BindTestInterface(::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest> receiver) = 0;
};



class  IndexedDBObserverProxy
    : public IndexedDBObserver {
 public:
  using InterfaceType = IndexedDBObserver;

  explicit IndexedDBObserverProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnIndexedDBListChanged(const ::url::Origin& origin) final;
  
  void OnIndexedDBContentChanged(const ::url::Origin& origin, const ::base::string16& database_name, const ::base::string16& object_store_name) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  IndexedDBControlProxy
    : public IndexedDBControl {
 public:
  using InterfaceType = IndexedDBControl;

  explicit IndexedDBControlProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void BindIndexedDB(const ::url::Origin& origin, ::mojo::PendingReceiver<::blink::mojom::IDBFactory> receiver) final;
  
  void GetUsage(GetUsageCallback callback) final;
  
  void DeleteForOrigin(const ::url::Origin& origin, DeleteForOriginCallback callback) final;
  
  void ForceClose(const ::url::Origin& origin, ForceCloseReason reason, ForceCloseCallback callback) final;
  
  void GetConnectionCount(const ::url::Origin& origin, GetConnectionCountCallback callback) final;
  
  void DownloadOriginData(const ::url::Origin& origin, DownloadOriginDataCallback callback) final;
  
  void GetAllOriginsDetails(GetAllOriginsDetailsCallback callback) final;
  
  void SetForceKeepSessionState() final;
  
  void AddObserver(::mojo::PendingRemote<IndexedDBObserver> observer) final;
  
  void ApplyPolicyUpdates(std::vector<IndexedDBStoragePolicyUpdatePtr> policy_updates) final;
  
  void BindTestInterface(::mojo::PendingReceiver<::storage::mojom::IndexedDBControlTest> receiver) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  IndexedDBObserverStubDispatch {
 public:
  static bool Accept(IndexedDBObserver* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IndexedDBObserver* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IndexedDBObserver>>
class IndexedDBObserverStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IndexedDBObserverStub() {}
  ~IndexedDBObserverStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBObserverStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBObserverStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  IndexedDBControlStubDispatch {
 public:
  static bool Accept(IndexedDBControl* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      IndexedDBControl* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<IndexedDBControl>>
class IndexedDBControlStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  IndexedDBControlStub() {}
  ~IndexedDBControlStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBControlStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return IndexedDBControlStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  IndexedDBObserverRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  IndexedDBControlRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  IndexedDBControlResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class  IndexedDBStorageUsageInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IndexedDBStorageUsageInfo, T>::value>;
  using DataView = IndexedDBStorageUsageInfoDataView;
  using Data_ = internal::IndexedDBStorageUsageInfo_Data;

  template <typename... Args>
  static IndexedDBStorageUsageInfoPtr New(Args&&... args) {
    return IndexedDBStorageUsageInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IndexedDBStorageUsageInfoPtr From(const U& u) {
    return mojo::TypeConverter<IndexedDBStorageUsageInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IndexedDBStorageUsageInfo>::Convert(*this);
  }


  IndexedDBStorageUsageInfo();

  IndexedDBStorageUsageInfo(
      const ::url::Origin& origin,
      uint64_t size_in_bytes,
      ::base::Time last_modified_time);

  ~IndexedDBStorageUsageInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IndexedDBStorageUsageInfoPtr>
  IndexedDBStorageUsageInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IndexedDBStorageUsageInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IndexedDBStorageUsageInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IndexedDBStorageUsageInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IndexedDBStorageUsageInfo_UnserializedMessageContext<
            UserType, IndexedDBStorageUsageInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<IndexedDBStorageUsageInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return IndexedDBStorageUsageInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IndexedDBStorageUsageInfo_UnserializedMessageContext<
            UserType, IndexedDBStorageUsageInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IndexedDBStorageUsageInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::url::Origin origin;
  
  uint64_t size_in_bytes;
  
  ::base::Time last_modified_time;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IndexedDBStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IndexedDBStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IndexedDBStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IndexedDBStorageUsageInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  IndexedDBStoragePolicyUpdate {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<IndexedDBStoragePolicyUpdate, T>::value>;
  using DataView = IndexedDBStoragePolicyUpdateDataView;
  using Data_ = internal::IndexedDBStoragePolicyUpdate_Data;

  template <typename... Args>
  static IndexedDBStoragePolicyUpdatePtr New(Args&&... args) {
    return IndexedDBStoragePolicyUpdatePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static IndexedDBStoragePolicyUpdatePtr From(const U& u) {
    return mojo::TypeConverter<IndexedDBStoragePolicyUpdatePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, IndexedDBStoragePolicyUpdate>::Convert(*this);
  }


  IndexedDBStoragePolicyUpdate();

  IndexedDBStoragePolicyUpdate(
      const ::url::Origin& origin,
      bool purge_on_shutdown);

  ~IndexedDBStoragePolicyUpdate();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = IndexedDBStoragePolicyUpdatePtr>
  IndexedDBStoragePolicyUpdatePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, IndexedDBStoragePolicyUpdate::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        IndexedDBStoragePolicyUpdate::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        IndexedDBStoragePolicyUpdate::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::IndexedDBStoragePolicyUpdate_UnserializedMessageContext<
            UserType, IndexedDBStoragePolicyUpdate::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<IndexedDBStoragePolicyUpdate::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return IndexedDBStoragePolicyUpdate::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::IndexedDBStoragePolicyUpdate_UnserializedMessageContext<
            UserType, IndexedDBStoragePolicyUpdate::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<IndexedDBStoragePolicyUpdate::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::url::Origin origin;
  
  bool purge_on_shutdown;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, IndexedDBStoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, IndexedDBStoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, IndexedDBStoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, IndexedDBStoragePolicyUpdate::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
IndexedDBStorageUsageInfoPtr IndexedDBStorageUsageInfo::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(size_in_bytes),
      mojo::Clone(last_modified_time)
  );
}

template <typename T, IndexedDBStorageUsageInfo::EnableIfSame<T>*>
bool IndexedDBStorageUsageInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->size_in_bytes, other_struct.size_in_bytes))
    return false;
  if (!mojo::Equals(this->last_modified_time, other_struct.last_modified_time))
    return false;
  return true;
}

template <typename T, IndexedDBStorageUsageInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.origin, rhs.origin))
    return true;
  if (std::less<>{}(rhs.origin, lhs.origin))
    return false;
  if (std::less<>{}(lhs.size_in_bytes, rhs.size_in_bytes))
    return true;
  if (std::less<>{}(rhs.size_in_bytes, lhs.size_in_bytes))
    return false;
  if (std::less<>{}(lhs.last_modified_time, rhs.last_modified_time))
    return true;
  if (std::less<>{}(rhs.last_modified_time, lhs.last_modified_time))
    return false;
  return false;
}
template <typename StructPtrType>
IndexedDBStoragePolicyUpdatePtr IndexedDBStoragePolicyUpdate::Clone() const {
  return New(
      mojo::Clone(origin),
      mojo::Clone(purge_on_shutdown)
  );
}

template <typename T, IndexedDBStoragePolicyUpdate::EnableIfSame<T>*>
bool IndexedDBStoragePolicyUpdate::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->origin, other_struct.origin))
    return false;
  if (!mojo::Equals(this->purge_on_shutdown, other_struct.purge_on_shutdown))
    return false;
  return true;
}

template <typename T, IndexedDBStoragePolicyUpdate::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.origin, rhs.origin))
    return true;
  if (std::less<>{}(rhs.origin, lhs.origin))
    return false;
  if (std::less<>{}(lhs.purge_on_shutdown, rhs.purge_on_shutdown))
    return true;
  if (std::less<>{}(rhs.purge_on_shutdown, lhs.purge_on_shutdown))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace storage

namespace mojo {


template <>
struct  StructTraits<::storage::mojom::IndexedDBStorageUsageInfo::DataView,
                                         ::storage::mojom::IndexedDBStorageUsageInfoPtr> {
  static bool IsNull(const ::storage::mojom::IndexedDBStorageUsageInfoPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::IndexedDBStorageUsageInfoPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::IndexedDBStorageUsageInfo::origin)& origin(
      const ::storage::mojom::IndexedDBStorageUsageInfoPtr& input) {
    return input->origin;
  }

  static decltype(::storage::mojom::IndexedDBStorageUsageInfo::size_in_bytes) size_in_bytes(
      const ::storage::mojom::IndexedDBStorageUsageInfoPtr& input) {
    return input->size_in_bytes;
  }

  static const decltype(::storage::mojom::IndexedDBStorageUsageInfo::last_modified_time)& last_modified_time(
      const ::storage::mojom::IndexedDBStorageUsageInfoPtr& input) {
    return input->last_modified_time;
  }

  static bool Read(::storage::mojom::IndexedDBStorageUsageInfo::DataView input, ::storage::mojom::IndexedDBStorageUsageInfoPtr* output);
};


template <>
struct  StructTraits<::storage::mojom::IndexedDBStoragePolicyUpdate::DataView,
                                         ::storage::mojom::IndexedDBStoragePolicyUpdatePtr> {
  static bool IsNull(const ::storage::mojom::IndexedDBStoragePolicyUpdatePtr& input) { return !input; }
  static void SetToNull(::storage::mojom::IndexedDBStoragePolicyUpdatePtr* output) { output->reset(); }

  static const decltype(::storage::mojom::IndexedDBStoragePolicyUpdate::origin)& origin(
      const ::storage::mojom::IndexedDBStoragePolicyUpdatePtr& input) {
    return input->origin;
  }

  static decltype(::storage::mojom::IndexedDBStoragePolicyUpdate::purge_on_shutdown) purge_on_shutdown(
      const ::storage::mojom::IndexedDBStoragePolicyUpdatePtr& input) {
    return input->purge_on_shutdown;
  }

  static bool Read(::storage::mojom::IndexedDBStoragePolicyUpdate::DataView input, ::storage::mojom::IndexedDBStoragePolicyUpdatePtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_INDEXED_DB_CONTROL_MOJOM_H_