// services/data_decoder/public/mojom/image_decoder.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_PARAMS_DATA_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace data_decoder {
namespace mojom {
namespace internal {
class  ImageDecoder_DecodeImage_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImageDecoder_DecodeImage_Params_Data));
      new (data()) ImageDecoder_DecodeImage_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImageDecoder_DecodeImage_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImageDecoder_DecodeImage_Params_Data>(index_);
    }
    ImageDecoder_DecodeImage_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> encoded_data;
  int32_t codec;
  uint8_t shrink_to_fit : 1;
  uint8_t pad2_[3];
  int64_t max_size_in_bytes;
  mojo::internal::Pointer<::gfx::mojom::internal::Size_Data> desired_image_frame_size;

 private:
  ImageDecoder_DecodeImage_Params_Data();
  ~ImageDecoder_DecodeImage_Params_Data() = delete;
};
static_assert(sizeof(ImageDecoder_DecodeImage_Params_Data) == 40,
              "Bad sizeof(ImageDecoder_DecodeImage_Params_Data)");
class  ImageDecoder_DecodeImage_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImageDecoder_DecodeImage_ResponseParams_Data));
      new (data()) ImageDecoder_DecodeImage_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImageDecoder_DecodeImage_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImageDecoder_DecodeImage_ResponseParams_Data>(index_);
    }
    ImageDecoder_DecodeImage_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::skia::mojom::internal::Bitmap_Data> decoded_image;

 private:
  ImageDecoder_DecodeImage_ResponseParams_Data();
  ~ImageDecoder_DecodeImage_ResponseParams_Data() = delete;
};
static_assert(sizeof(ImageDecoder_DecodeImage_ResponseParams_Data) == 16,
              "Bad sizeof(ImageDecoder_DecodeImage_ResponseParams_Data)");
class  ImageDecoder_DecodeAnimation_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImageDecoder_DecodeAnimation_Params_Data));
      new (data()) ImageDecoder_DecodeAnimation_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImageDecoder_DecodeAnimation_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImageDecoder_DecodeAnimation_Params_Data>(index_);
    }
    ImageDecoder_DecodeAnimation_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<uint8_t>> encoded_data;
  uint8_t shrink_to_fit : 1;
  uint8_t pad1_[7];
  int64_t max_size_in_bytes;

 private:
  ImageDecoder_DecodeAnimation_Params_Data();
  ~ImageDecoder_DecodeAnimation_Params_Data() = delete;
};
static_assert(sizeof(ImageDecoder_DecodeAnimation_Params_Data) == 32,
              "Bad sizeof(ImageDecoder_DecodeAnimation_Params_Data)");
class  ImageDecoder_DecodeAnimation_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(ImageDecoder_DecodeAnimation_ResponseParams_Data));
      new (data()) ImageDecoder_DecodeAnimation_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    ImageDecoder_DecodeAnimation_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<ImageDecoder_DecodeAnimation_ResponseParams_Data>(index_);
    }
    ImageDecoder_DecodeAnimation_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<internal::AnimationFrame_Data>>> decoded_image;

 private:
  ImageDecoder_DecodeAnimation_ResponseParams_Data();
  ~ImageDecoder_DecodeAnimation_ResponseParams_Data() = delete;
};
static_assert(sizeof(ImageDecoder_DecodeAnimation_ResponseParams_Data) == 16,
              "Bad sizeof(ImageDecoder_DecodeAnimation_ResponseParams_Data)");

}  // namespace internal


class ImageDecoder_DecodeImage_ParamsDataView {
 public:
  ImageDecoder_DecodeImage_ParamsDataView() {}

  ImageDecoder_DecodeImage_ParamsDataView(
      internal::ImageDecoder_DecodeImage_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetEncodedDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEncodedData(UserType* output) {
    
    auto* pointer = data_->encoded_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCodec(UserType* output) const {
    auto data_value = data_->codec;
    return mojo::internal::Deserialize<::data_decoder::mojom::ImageCodec>(
        data_value, output);
  }

  ImageCodec codec() const {
    return static_cast<ImageCodec>(data_->codec);
  }
  bool shrink_to_fit() const {
    return data_->shrink_to_fit;
  }
  int64_t max_size_in_bytes() const {
    return data_->max_size_in_bytes;
  }
  inline void GetDesiredImageFrameSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDesiredImageFrameSize(UserType* output) {
    
    auto* pointer = data_->desired_image_frame_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
 private:
  internal::ImageDecoder_DecodeImage_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ImageDecoder_DecodeImage_ResponseParamsDataView {
 public:
  ImageDecoder_DecodeImage_ResponseParamsDataView() {}

  ImageDecoder_DecodeImage_ResponseParamsDataView(
      internal::ImageDecoder_DecodeImage_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDecodedImageDataView(
      ::skia::mojom::BitmapDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDecodedImage(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::skia::mojom::BitmapDataView, UserType>(),
    "Attempting to read the optional `decoded_image` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadDecodedImage` instead "
    "of `ReadDecodedImage if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->decoded_image.Get();
    return mojo::internal::Deserialize<::skia::mojom::BitmapDataView>(
        pointer, output, context_);
  }
 private:
  internal::ImageDecoder_DecodeImage_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ImageDecoder_DecodeAnimation_ParamsDataView {
 public:
  ImageDecoder_DecodeAnimation_ParamsDataView() {}

  ImageDecoder_DecodeAnimation_ParamsDataView(
      internal::ImageDecoder_DecodeAnimation_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetEncodedDataDataView(
      mojo::ArrayDataView<uint8_t>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadEncodedData(UserType* output) {
    
    auto* pointer = data_->encoded_data.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<uint8_t>>(
        pointer, output, context_);
  }
  bool shrink_to_fit() const {
    return data_->shrink_to_fit;
  }
  int64_t max_size_in_bytes() const {
    return data_->max_size_in_bytes;
  }
 private:
  internal::ImageDecoder_DecodeAnimation_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class ImageDecoder_DecodeAnimation_ResponseParamsDataView {
 public:
  ImageDecoder_DecodeAnimation_ResponseParamsDataView() {}

  ImageDecoder_DecodeAnimation_ResponseParamsDataView(
      internal::ImageDecoder_DecodeAnimation_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDecodedImageDataView(
      mojo::ArrayDataView<AnimationFrameDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDecodedImage(UserType* output) {
    
    auto* pointer = data_->decoded_image.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::data_decoder::mojom::AnimationFrameDataView>>(
        pointer, output, context_);
  }
 private:
  internal::ImageDecoder_DecodeAnimation_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void ImageDecoder_DecodeImage_ParamsDataView::GetEncodedDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->encoded_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}
inline void ImageDecoder_DecodeImage_ParamsDataView::GetDesiredImageFrameSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->desired_image_frame_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}


inline void ImageDecoder_DecodeImage_ResponseParamsDataView::GetDecodedImageDataView(
    ::skia::mojom::BitmapDataView* output) {
  auto pointer = data_->decoded_image.Get();
  *output = ::skia::mojom::BitmapDataView(pointer, context_);
}


inline void ImageDecoder_DecodeAnimation_ParamsDataView::GetEncodedDataDataView(
    mojo::ArrayDataView<uint8_t>* output) {
  auto pointer = data_->encoded_data.Get();
  *output = mojo::ArrayDataView<uint8_t>(pointer, context_);
}


inline void ImageDecoder_DecodeAnimation_ResponseParamsDataView::GetDecodedImageDataView(
    mojo::ArrayDataView<AnimationFrameDataView>* output) {
  auto pointer = data_->decoded_image.Get();
  *output = mojo::ArrayDataView<AnimationFrameDataView>(pointer, context_);
}

}  // namespace mojom
}  // namespace data_decoder

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_IMAGE_DECODER_MOJOM_PARAMS_DATA_H_