// services/network/public/mojom/isolation_info.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/isolation_info.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/isolation_info.mojom-params-data.h"
#include "services/network/public/mojom/isolation_info.mojom-shared-message-ids.h"

#include "services/network/public/mojom/isolation_info.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_ISOLATION_INFO_MOJOM_JUMBO_H_
#endif
namespace network {
namespace mojom {
IsolationInfo::IsolationInfo()
    : redirect_mode(),
      top_frame_origin(),
      frame_origin(),
      opaque_and_non_transient(),
      site_for_cookies() {}

IsolationInfo::IsolationInfo(
    IsolationInfoRedirectMode redirect_mode_in,
    const base::Optional<::url::Origin>& top_frame_origin_in,
    const base::Optional<::url::Origin>& frame_origin_in,
    bool opaque_and_non_transient_in,
    const ::net::SiteForCookies& site_for_cookies_in)
    : redirect_mode(std::move(redirect_mode_in)),
      top_frame_origin(std::move(top_frame_origin_in)),
      frame_origin(std::move(frame_origin_in)),
      opaque_and_non_transient(std::move(opaque_and_non_transient_in)),
      site_for_cookies(std::move(site_for_cookies_in)) {}

IsolationInfo::~IsolationInfo() = default;

void IsolationInfo::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("redirect_mode", base::trace_event::ValueToString(this->redirect_mode));
  value->SetString("top_frame_origin", base::trace_event::ValueToString(this->top_frame_origin, "<value of type const base::Optional<::url::Origin>&>"));
  value->SetString("frame_origin", base::trace_event::ValueToString(this->frame_origin, "<value of type const base::Optional<::url::Origin>&>"));
  value->SetBoolean("opaque_and_non_transient", this->opaque_and_non_transient);
  value->SetString("site_for_cookies", base::trace_event::ValueToString(this->site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
}

bool IsolationInfo::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::IsolationInfo::DataView, ::network::mojom::IsolationInfoPtr>::Read(
    ::network::mojom::IsolationInfo::DataView input,
    ::network::mojom::IsolationInfoPtr* output) {
  bool success = true;
  ::network::mojom::IsolationInfoPtr result(::network::mojom::IsolationInfo::New());
  
      if (success && !input.ReadRedirectMode(&result->redirect_mode))
        success = false;
      if (success && !input.ReadTopFrameOrigin(&result->top_frame_origin))
        success = false;
      if (success && !input.ReadFrameOrigin(&result->frame_origin))
        success = false;
      if (success)
        result->opaque_and_non_transient = input.opaque_and_non_transient();
      if (success && !input.ReadSiteForCookies(&result->site_for_cookies))
        success = false;
  *output = std::move(result);
  return success;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif