// services/network/public/mojom/net_log.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NET_LOG_MOJOM_PARAMS_DATA_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NET_LOG_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace network {
namespace mojom {
namespace internal {
class  NetLogExporter_Start_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NetLogExporter_Start_Params_Data));
      new (data()) NetLogExporter_Start_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NetLogExporter_Start_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NetLogExporter_Start_Params_Data>(index_);
    }
    NetLogExporter_Start_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> destination;
  mojo::internal::Pointer<::mojo_base::mojom::internal::DictionaryValue_Data> extra_constants;
  int32_t capture_mode;
  uint8_t pad2_[4];
  uint64_t max_file_size;

 private:
  NetLogExporter_Start_Params_Data();
  ~NetLogExporter_Start_Params_Data() = delete;
};
static_assert(sizeof(NetLogExporter_Start_Params_Data) == 40,
              "Bad sizeof(NetLogExporter_Start_Params_Data)");
class  NetLogExporter_Start_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NetLogExporter_Start_ResponseParams_Data));
      new (data()) NetLogExporter_Start_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NetLogExporter_Start_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NetLogExporter_Start_ResponseParams_Data>(index_);
    }
    NetLogExporter_Start_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t net_error;
  uint8_t padfinal_[4];

 private:
  NetLogExporter_Start_ResponseParams_Data();
  ~NetLogExporter_Start_ResponseParams_Data() = delete;
};
static_assert(sizeof(NetLogExporter_Start_ResponseParams_Data) == 16,
              "Bad sizeof(NetLogExporter_Start_ResponseParams_Data)");
class  NetLogExporter_Stop_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NetLogExporter_Stop_Params_Data));
      new (data()) NetLogExporter_Stop_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NetLogExporter_Stop_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NetLogExporter_Stop_Params_Data>(index_);
    }
    NetLogExporter_Stop_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::DictionaryValue_Data> polled_values;

 private:
  NetLogExporter_Stop_Params_Data();
  ~NetLogExporter_Stop_Params_Data() = delete;
};
static_assert(sizeof(NetLogExporter_Stop_Params_Data) == 16,
              "Bad sizeof(NetLogExporter_Stop_Params_Data)");
class  NetLogExporter_Stop_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NetLogExporter_Stop_ResponseParams_Data));
      new (data()) NetLogExporter_Stop_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NetLogExporter_Stop_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NetLogExporter_Stop_ResponseParams_Data>(index_);
    }
    NetLogExporter_Stop_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t net_error;
  uint8_t padfinal_[4];

 private:
  NetLogExporter_Stop_ResponseParams_Data();
  ~NetLogExporter_Stop_ResponseParams_Data() = delete;
};
static_assert(sizeof(NetLogExporter_Stop_ResponseParams_Data) == 16,
              "Bad sizeof(NetLogExporter_Stop_ResponseParams_Data)");
class  NetLogProxySource_UpdateCaptureModes_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NetLogProxySource_UpdateCaptureModes_Params_Data));
      new (data()) NetLogProxySource_UpdateCaptureModes_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NetLogProxySource_UpdateCaptureModes_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NetLogProxySource_UpdateCaptureModes_Params_Data>(index_);
    }
    NetLogProxySource_UpdateCaptureModes_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t modes;
  uint8_t padfinal_[4];

 private:
  NetLogProxySource_UpdateCaptureModes_Params_Data();
  ~NetLogProxySource_UpdateCaptureModes_Params_Data() = delete;
};
static_assert(sizeof(NetLogProxySource_UpdateCaptureModes_Params_Data) == 16,
              "Bad sizeof(NetLogProxySource_UpdateCaptureModes_Params_Data)");
class  NetLogProxySink_AddEntry_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(NetLogProxySink_AddEntry_Params_Data));
      new (data()) NetLogProxySink_AddEntry_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    NetLogProxySink_AddEntry_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<NetLogProxySink_AddEntry_Params_Data>(index_);
    }
    NetLogProxySink_AddEntry_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint32_t type;
  uint32_t source_type;
  uint32_t source_id;
  int32_t phase;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> source_start_time;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeTicks_Data> time;
  ::mojo_base::mojom::internal::Value_Data params;

 private:
  NetLogProxySink_AddEntry_Params_Data();
  ~NetLogProxySink_AddEntry_Params_Data() = delete;
};
static_assert(sizeof(NetLogProxySink_AddEntry_Params_Data) == 56,
              "Bad sizeof(NetLogProxySink_AddEntry_Params_Data)");

}  // namespace internal


class NetLogExporter_Start_ParamsDataView {
 public:
  NetLogExporter_Start_ParamsDataView() {}

  NetLogExporter_Start_ParamsDataView(
      internal::NetLogExporter_Start_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetDestinationDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDestination(UserType* output) {
    
    auto* pointer = data_->destination.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, context_);
  }
  inline void GetExtraConstantsDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadExtraConstants(UserType* output) {
    
    auto* pointer = data_->extra_constants.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadCaptureMode(UserType* output) const {
    auto data_value = data_->capture_mode;
    return mojo::internal::Deserialize<::network::mojom::NetLogCaptureMode>(
        data_value, output);
  }

  NetLogCaptureMode capture_mode() const {
    return static_cast<NetLogCaptureMode>(data_->capture_mode);
  }
  uint64_t max_file_size() const {
    return data_->max_file_size;
  }
 private:
  internal::NetLogExporter_Start_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NetLogExporter_Start_ResponseParamsDataView {
 public:
  NetLogExporter_Start_ResponseParamsDataView() {}

  NetLogExporter_Start_ResponseParamsDataView(
      internal::NetLogExporter_Start_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t net_error() const {
    return data_->net_error;
  }
 private:
  internal::NetLogExporter_Start_ResponseParams_Data* data_ = nullptr;
};



class NetLogExporter_Stop_ParamsDataView {
 public:
  NetLogExporter_Stop_ParamsDataView() {}

  NetLogExporter_Stop_ParamsDataView(
      internal::NetLogExporter_Stop_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetPolledValuesDataView(
      ::mojo_base::mojom::DictionaryValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPolledValues(UserType* output) {
    
    auto* pointer = data_->polled_values.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::DictionaryValueDataView>(
        pointer, output, context_);
  }
 private:
  internal::NetLogExporter_Stop_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class NetLogExporter_Stop_ResponseParamsDataView {
 public:
  NetLogExporter_Stop_ResponseParamsDataView() {}

  NetLogExporter_Stop_ResponseParamsDataView(
      internal::NetLogExporter_Stop_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  int32_t net_error() const {
    return data_->net_error;
  }
 private:
  internal::NetLogExporter_Stop_ResponseParams_Data* data_ = nullptr;
};



class NetLogProxySource_UpdateCaptureModes_ParamsDataView {
 public:
  NetLogProxySource_UpdateCaptureModes_ParamsDataView() {}

  NetLogProxySource_UpdateCaptureModes_ParamsDataView(
      internal::NetLogProxySource_UpdateCaptureModes_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint32_t modes() const {
    return data_->modes;
  }
 private:
  internal::NetLogProxySource_UpdateCaptureModes_Params_Data* data_ = nullptr;
};



class NetLogProxySink_AddEntry_ParamsDataView {
 public:
  NetLogProxySink_AddEntry_ParamsDataView() {}

  NetLogProxySink_AddEntry_ParamsDataView(
      internal::NetLogProxySink_AddEntry_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  uint32_t type() const {
    return data_->type;
  }
  uint32_t source_type() const {
    return data_->source_type;
  }
  uint32_t source_id() const {
    return data_->source_id;
  }
  inline void GetSourceStartTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSourceStartTime(UserType* output) {
    
    auto* pointer = data_->source_start_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPhase(UserType* output) const {
    auto data_value = data_->phase;
    return mojo::internal::Deserialize<::network::mojom::NetLogEventPhase>(
        data_value, output);
  }

  NetLogEventPhase phase() const {
    return static_cast<NetLogEventPhase>(data_->phase);
  }
  inline void GetTimeDataView(
      ::mojo_base::mojom::TimeTicksDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadTime(UserType* output) {
    
    auto* pointer = data_->time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeTicksDataView>(
        pointer, output, context_);
  }
  inline void GetParamsDataView(
      ::mojo_base::mojom::ValueDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = !data_->params.is_null() ? &data_->params : nullptr;
    return mojo::internal::Deserialize<::mojo_base::mojom::ValueDataView>(
        pointer, output, context_);
  }
 private:
  internal::NetLogProxySink_AddEntry_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void NetLogExporter_Start_ParamsDataView::GetDestinationDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->destination.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, context_);
}
inline void NetLogExporter_Start_ParamsDataView::GetExtraConstantsDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->extra_constants.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, context_);
}




inline void NetLogExporter_Stop_ParamsDataView::GetPolledValuesDataView(
    ::mojo_base::mojom::DictionaryValueDataView* output) {
  auto pointer = data_->polled_values.Get();
  *output = ::mojo_base::mojom::DictionaryValueDataView(pointer, context_);
}






inline void NetLogProxySink_AddEntry_ParamsDataView::GetSourceStartTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->source_start_time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void NetLogProxySink_AddEntry_ParamsDataView::GetTimeDataView(
    ::mojo_base::mojom::TimeTicksDataView* output) {
  auto pointer = data_->time.Get();
  *output = ::mojo_base::mojom::TimeTicksDataView(pointer, context_);
}
inline void NetLogProxySink_AddEntry_ParamsDataView::GetParamsDataView(
    ::mojo_base::mojom::ValueDataView* output) {
  auto pointer = &data_->params;
  *output = ::mojo_base::mojom::ValueDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace network

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NET_LOG_MOJOM_PARAMS_DATA_H_