// services/network/public/mojom/network_context.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "services/network/public/mojom/network_context.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "services/network/public/mojom/network_context.mojom-params-data.h"
#include "services/network/public/mojom/network_context.mojom-shared-message-ids.h"

#include "services/network/public/mojom/network_context.mojom-import-headers.h"


#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_JUMBO_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_JUMBO_H_
#include "components/content_settings/core/common/content_settings_param_traits.h"
#endif
namespace network {
namespace mojom {
CustomProxyConfig::CustomProxyConfig()
    : rules(),
      should_override_existing_config(false),
      allow_non_idempotent_methods(false),
      connect_tunnel_headers() {}

CustomProxyConfig::CustomProxyConfig(
    const ::net::ProxyConfig::ProxyRules& rules_in,
    bool should_override_existing_config_in,
    bool allow_non_idempotent_methods_in,
    const ::net::HttpRequestHeaders& connect_tunnel_headers_in)
    : rules(std::move(rules_in)),
      should_override_existing_config(std::move(should_override_existing_config_in)),
      allow_non_idempotent_methods(std::move(allow_non_idempotent_methods_in)),
      connect_tunnel_headers(std::move(connect_tunnel_headers_in)) {}

CustomProxyConfig::~CustomProxyConfig() = default;

void CustomProxyConfig::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("rules", base::trace_event::ValueToString(this->rules, "<value of type const ::net::ProxyConfig::ProxyRules&>"));
  value->SetBoolean("should_override_existing_config", this->should_override_existing_config);
  value->SetBoolean("allow_non_idempotent_methods", this->allow_non_idempotent_methods);
  value->SetString("connect_tunnel_headers", base::trace_event::ValueToString(this->connect_tunnel_headers, "<value of type const ::net::HttpRequestHeaders&>"));
}

bool CustomProxyConfig::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CertVerifierCreationParams::CertVerifierCreationParams() {}

CertVerifierCreationParams::~CertVerifierCreationParams() = default;
size_t CertVerifierCreationParams::Hash(size_t seed) const {
  return seed;
}

void CertVerifierCreationParams::AsValueInto(base::trace_event::TracedValue* value) const {
}

bool CertVerifierCreationParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CertVerifierServiceRemoteParams::CertVerifierServiceRemoteParams()
    : cert_verifier_service() {}

CertVerifierServiceRemoteParams::CertVerifierServiceRemoteParams(
    ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierService> cert_verifier_service_in)
    : cert_verifier_service(std::move(cert_verifier_service_in)) {}

CertVerifierServiceRemoteParams::~CertVerifierServiceRemoteParams() = default;

void CertVerifierServiceRemoteParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("cert_verifier_service", this->cert_verifier_service.is_valid());
}

bool CertVerifierServiceRemoteParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
HttpAuthStaticNetworkContextParams::HttpAuthStaticNetworkContextParams()
    : allow_default_credentials(mojo::internal::ConvertEnumValue<::network::mojom::DefaultCredentials, ::net::HttpAuthPreferences::DefaultCredentials>(::network::mojom::DefaultCredentials::ALLOW_DEFAULT_CREDENTIALS)) {}

HttpAuthStaticNetworkContextParams::HttpAuthStaticNetworkContextParams(
    ::net::HttpAuthPreferences::DefaultCredentials allow_default_credentials_in)
    : allow_default_credentials(std::move(allow_default_credentials_in)) {}

HttpAuthStaticNetworkContextParams::~HttpAuthStaticNetworkContextParams() = default;

void HttpAuthStaticNetworkContextParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("allow_default_credentials", static_cast<int>(this->allow_default_credentials));
}

bool HttpAuthStaticNetworkContextParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CTPolicy::CTPolicy()
    : required_hosts(),
      excluded_hosts(),
      excluded_spkis(),
      excluded_legacy_spkis() {}

CTPolicy::CTPolicy(
    std::vector<std::string> required_hosts_in,
    std::vector<std::string> excluded_hosts_in,
    std::vector<std::string> excluded_spkis_in,
    std::vector<std::string> excluded_legacy_spkis_in)
    : required_hosts(std::move(required_hosts_in)),
      excluded_hosts(std::move(excluded_hosts_in)),
      excluded_spkis(std::move(excluded_spkis_in)),
      excluded_legacy_spkis(std::move(excluded_legacy_spkis_in)) {}

CTPolicy::~CTPolicy() = default;

void CTPolicy::AsValueInto(base::trace_event::TracedValue* value) const {
  value->BeginArray("required_hosts");
  for (const auto& item0 : this->required_hosts) {
    value->AppendString(item0);
  }
  value->EndArray();
  value->BeginArray("excluded_hosts");
  for (const auto& item0 : this->excluded_hosts) {
    value->AppendString(item0);
  }
  value->EndArray();
  value->BeginArray("excluded_spkis");
  for (const auto& item0 : this->excluded_spkis) {
    value->AppendString(item0);
  }
  value->EndArray();
  value->BeginArray("excluded_legacy_spkis");
  for (const auto& item0 : this->excluded_legacy_spkis) {
    value->AppendString(item0);
  }
  value->EndArray();
}

bool CTPolicy::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkContextParams::NetworkContextParams()
    : context_name(),
      user_agent(),
      accept_language(),
      enable_brotli(true),
      quic_user_agent_id(),
      enable_referrers(true),
      validate_referrer_policy_on_initial_request(true),
      proxy_resolver_factory(),
      cookie_path(),
      trust_token_path(),
      enable_encrypted_cookies(true),
      restore_old_session_cookies(false),
      persist_session_cookies(false),
      http_cache_enabled(true),
      http_cache_max_size(0),
      http_cache_path(),
      http_server_properties_path(),
      transport_security_persister_path(),
      enable_ftp_url_support(false),
      disable_idle_sockets_close_on_memory_pressure(false),
      initial_ssl_config(),
      ssl_config_client_receiver(),
      initial_proxy_config(),
      proxy_config_client_receiver(),
      initial_custom_proxy_config(),
      custom_proxy_config_client_receiver(),
      proxy_config_poller_client(),
      proxy_error_client(),
      pac_quick_check_enabled(true),
      enable_certificate_reporting(false),
      enforce_chrome_ct_policy(false),
      enable_expect_ct_reporting(false),
      enable_sct_auditing(false),
      ct_logs(),
      ct_policy(),
      ct_log_update_time(),
      cert_verifier_params(),
      cookie_manager_params(),
      cookie_manager(),
      enable_domain_reliability(false),
      domain_reliability_upload_reporter(),
      discard_domain_reliablity_uploads(false),
      reporting_delivery_interval(),
      skip_reporting_send_permission_check(false),
      cors_origin_access_list(),
      cors_exempt_header_list(),
      allow_any_cors_exempt_header_for_browser(false),
      hsts_policy_bypass_list(),
      reporting_and_nel_store_path(),
      http_auth_static_network_context_params(),
      reset_http_cache_backend(false),
      split_auth_cache_by_network_isolation_key(false),
      require_network_isolation_key(false) {}

NetworkContextParams::NetworkContextParams(
    const base::Optional<std::string>& context_name_in,
    const std::string& user_agent_in,
    const std::string& accept_language_in,
    bool enable_brotli_in,
    const std::string& quic_user_agent_id_in,
    bool enable_referrers_in,
    bool validate_referrer_policy_on_initial_request_in,
    ::mojo::PendingRemote<::proxy_resolver::mojom::ProxyResolverFactory> proxy_resolver_factory_in,
    const base::Optional<::base::FilePath>& cookie_path_in,
    const base::Optional<::base::FilePath>& trust_token_path_in,
    bool enable_encrypted_cookies_in,
    bool restore_old_session_cookies_in,
    bool persist_session_cookies_in,
    bool http_cache_enabled_in,
    int32_t http_cache_max_size_in,
    const base::Optional<::base::FilePath>& http_cache_path_in,
    const base::Optional<::base::FilePath>& http_server_properties_path_in,
    const base::Optional<::base::FilePath>& transport_security_persister_path_in,
    bool enable_ftp_url_support_in,
    bool disable_idle_sockets_close_on_memory_pressure_in,
    ::network::mojom::SSLConfigPtr initial_ssl_config_in,
    ::mojo::PendingReceiver<::network::mojom::SSLConfigClient> ssl_config_client_receiver_in,
    const base::Optional<::net::ProxyConfigWithAnnotation>& initial_proxy_config_in,
    ::mojo::PendingReceiver<::network::mojom::ProxyConfigClient> proxy_config_client_receiver_in,
    CustomProxyConfigPtr initial_custom_proxy_config_in,
    ::mojo::PendingReceiver<CustomProxyConfigClient> custom_proxy_config_client_receiver_in,
    ::mojo::PendingRemote<::network::mojom::ProxyConfigPollerClient> proxy_config_poller_client_in,
    ::mojo::PendingRemote<::network::mojom::ProxyErrorClient> proxy_error_client_in,
    bool pac_quick_check_enabled_in,
    bool enable_certificate_reporting_in,
    bool enforce_chrome_ct_policy_in,
    bool enable_expect_ct_reporting_in,
    bool enable_sct_auditing_in,
    std::vector<::network::mojom::CTLogInfoPtr> ct_logs_in,
    CTPolicyPtr ct_policy_in,
    ::base::Time ct_log_update_time_in,
    CertVerifierParamsPtr cert_verifier_params_in,
    ::network::mojom::CookieManagerParamsPtr cookie_manager_params_in,
    ::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager_in,
    bool enable_domain_reliability_in,
    const std::string& domain_reliability_upload_reporter_in,
    bool discard_domain_reliablity_uploads_in,
    base::Optional<::base::TimeDelta> reporting_delivery_interval_in,
    bool skip_reporting_send_permission_check_in,
    std::vector<::network::mojom::CorsOriginAccessPatternsPtr> cors_origin_access_list_in,
    std::vector<std::string> cors_exempt_header_list_in,
    bool allow_any_cors_exempt_header_for_browser_in,
    std::vector<std::string> hsts_policy_bypass_list_in,
    const base::Optional<::base::FilePath>& reporting_and_nel_store_path_in,
    HttpAuthStaticNetworkContextParamsPtr http_auth_static_network_context_params_in,
    bool reset_http_cache_backend_in,
    bool split_auth_cache_by_network_isolation_key_in,
    bool require_network_isolation_key_in)
    : context_name(std::move(context_name_in)),
      user_agent(std::move(user_agent_in)),
      accept_language(std::move(accept_language_in)),
      enable_brotli(std::move(enable_brotli_in)),
      quic_user_agent_id(std::move(quic_user_agent_id_in)),
      enable_referrers(std::move(enable_referrers_in)),
      validate_referrer_policy_on_initial_request(std::move(validate_referrer_policy_on_initial_request_in)),
      proxy_resolver_factory(std::move(proxy_resolver_factory_in)),
      cookie_path(std::move(cookie_path_in)),
      trust_token_path(std::move(trust_token_path_in)),
      enable_encrypted_cookies(std::move(enable_encrypted_cookies_in)),
      restore_old_session_cookies(std::move(restore_old_session_cookies_in)),
      persist_session_cookies(std::move(persist_session_cookies_in)),
      http_cache_enabled(std::move(http_cache_enabled_in)),
      http_cache_max_size(std::move(http_cache_max_size_in)),
      http_cache_path(std::move(http_cache_path_in)),
      http_server_properties_path(std::move(http_server_properties_path_in)),
      transport_security_persister_path(std::move(transport_security_persister_path_in)),
      enable_ftp_url_support(std::move(enable_ftp_url_support_in)),
      disable_idle_sockets_close_on_memory_pressure(std::move(disable_idle_sockets_close_on_memory_pressure_in)),
      initial_ssl_config(std::move(initial_ssl_config_in)),
      ssl_config_client_receiver(std::move(ssl_config_client_receiver_in)),
      initial_proxy_config(std::move(initial_proxy_config_in)),
      proxy_config_client_receiver(std::move(proxy_config_client_receiver_in)),
      initial_custom_proxy_config(std::move(initial_custom_proxy_config_in)),
      custom_proxy_config_client_receiver(std::move(custom_proxy_config_client_receiver_in)),
      proxy_config_poller_client(std::move(proxy_config_poller_client_in)),
      proxy_error_client(std::move(proxy_error_client_in)),
      pac_quick_check_enabled(std::move(pac_quick_check_enabled_in)),
      enable_certificate_reporting(std::move(enable_certificate_reporting_in)),
      enforce_chrome_ct_policy(std::move(enforce_chrome_ct_policy_in)),
      enable_expect_ct_reporting(std::move(enable_expect_ct_reporting_in)),
      enable_sct_auditing(std::move(enable_sct_auditing_in)),
      ct_logs(std::move(ct_logs_in)),
      ct_policy(std::move(ct_policy_in)),
      ct_log_update_time(std::move(ct_log_update_time_in)),
      cert_verifier_params(std::move(cert_verifier_params_in)),
      cookie_manager_params(std::move(cookie_manager_params_in)),
      cookie_manager(std::move(cookie_manager_in)),
      enable_domain_reliability(std::move(enable_domain_reliability_in)),
      domain_reliability_upload_reporter(std::move(domain_reliability_upload_reporter_in)),
      discard_domain_reliablity_uploads(std::move(discard_domain_reliablity_uploads_in)),
      reporting_delivery_interval(std::move(reporting_delivery_interval_in)),
      skip_reporting_send_permission_check(std::move(skip_reporting_send_permission_check_in)),
      cors_origin_access_list(std::move(cors_origin_access_list_in)),
      cors_exempt_header_list(std::move(cors_exempt_header_list_in)),
      allow_any_cors_exempt_header_for_browser(std::move(allow_any_cors_exempt_header_for_browser_in)),
      hsts_policy_bypass_list(std::move(hsts_policy_bypass_list_in)),
      reporting_and_nel_store_path(std::move(reporting_and_nel_store_path_in)),
      http_auth_static_network_context_params(std::move(http_auth_static_network_context_params_in)),
      reset_http_cache_backend(std::move(reset_http_cache_backend_in)),
      split_auth_cache_by_network_isolation_key(std::move(split_auth_cache_by_network_isolation_key_in)),
      require_network_isolation_key(std::move(require_network_isolation_key_in)) {}

NetworkContextParams::~NetworkContextParams() = default;

void NetworkContextParams::AsValueInto(base::trace_event::TracedValue* value) const {
  if (this->context_name.has_value()) {
    value->SetString("context_name", this->context_name.value());
  } else {
    value->SetString("context_name", "base::nullopt");
  }
  value->SetString("user_agent", this->user_agent);
  value->SetString("accept_language", this->accept_language);
  value->SetBoolean("enable_brotli", this->enable_brotli);
  value->SetString("quic_user_agent_id", this->quic_user_agent_id);
  value->SetBoolean("enable_referrers", this->enable_referrers);
  value->SetBoolean("validate_referrer_policy_on_initial_request", this->validate_referrer_policy_on_initial_request);
  value->SetBoolean("proxy_resolver_factory", this->proxy_resolver_factory.is_valid());
  value->SetString("cookie_path", base::trace_event::ValueToString(this->cookie_path, "<value of type const base::Optional<::base::FilePath>&>"));
  value->SetString("trust_token_path", base::trace_event::ValueToString(this->trust_token_path, "<value of type const base::Optional<::base::FilePath>&>"));
  value->SetBoolean("enable_encrypted_cookies", this->enable_encrypted_cookies);
  value->SetBoolean("restore_old_session_cookies", this->restore_old_session_cookies);
  value->SetBoolean("persist_session_cookies", this->persist_session_cookies);
  value->SetBoolean("http_cache_enabled", this->http_cache_enabled);
  value->SetInteger("http_cache_max_size", this->http_cache_max_size);
  value->SetString("http_cache_path", base::trace_event::ValueToString(this->http_cache_path, "<value of type const base::Optional<::base::FilePath>&>"));
  value->SetString("http_server_properties_path", base::trace_event::ValueToString(this->http_server_properties_path, "<value of type const base::Optional<::base::FilePath>&>"));
  value->SetString("transport_security_persister_path", base::trace_event::ValueToString(this->transport_security_persister_path, "<value of type const base::Optional<::base::FilePath>&>"));
  value->SetBoolean("enable_ftp_url_support", this->enable_ftp_url_support);
  value->SetBoolean("disable_idle_sockets_close_on_memory_pressure", this->disable_idle_sockets_close_on_memory_pressure);
  if (this->initial_ssl_config.is_null()) {
    value->SetString("initial_ssl_config", "nullptr");
  } else {
    value->BeginDictionary("initial_ssl_config");
    this->initial_ssl_config->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("ssl_config_client_receiver", this->ssl_config_client_receiver.is_valid());
  value->SetString("initial_proxy_config", base::trace_event::ValueToString(this->initial_proxy_config, "<value of type const base::Optional<::net::ProxyConfigWithAnnotation>&>"));
  value->SetBoolean("proxy_config_client_receiver", this->proxy_config_client_receiver.is_valid());
  if (this->initial_custom_proxy_config.is_null()) {
    value->SetString("initial_custom_proxy_config", "nullptr");
  } else {
    value->BeginDictionary("initial_custom_proxy_config");
    this->initial_custom_proxy_config->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("custom_proxy_config_client_receiver", this->custom_proxy_config_client_receiver.is_valid());
  value->SetBoolean("proxy_config_poller_client", this->proxy_config_poller_client.is_valid());
  value->SetBoolean("proxy_error_client", this->proxy_error_client.is_valid());
  value->SetBoolean("pac_quick_check_enabled", this->pac_quick_check_enabled);
  value->SetBoolean("enable_certificate_reporting", this->enable_certificate_reporting);
  value->SetBoolean("enforce_chrome_ct_policy", this->enforce_chrome_ct_policy);
  value->SetBoolean("enable_expect_ct_reporting", this->enable_expect_ct_reporting);
  value->SetBoolean("enable_sct_auditing", this->enable_sct_auditing);
  value->BeginArray("ct_logs");
  for (const auto& item0 : this->ct_logs) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  if (this->ct_policy.is_null()) {
    value->SetString("ct_policy", "nullptr");
  } else {
    value->BeginDictionary("ct_policy");
    this->ct_policy->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("ct_log_update_time", base::trace_event::ValueToString(this->ct_log_update_time, "<value of type ::base::Time>"));
  value->SetString("cert_verifier_params", base::trace_event::ValueToString(this->cert_verifier_params, "<value of type CertVerifierParamsPtr>"));
  if (this->cookie_manager_params.is_null()) {
    value->SetString("cookie_manager_params", "nullptr");
  } else {
    value->BeginDictionary("cookie_manager_params");
    this->cookie_manager_params->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("cookie_manager", this->cookie_manager.is_valid());
  value->SetBoolean("enable_domain_reliability", this->enable_domain_reliability);
  value->SetString("domain_reliability_upload_reporter", this->domain_reliability_upload_reporter);
  value->SetBoolean("discard_domain_reliablity_uploads", this->discard_domain_reliablity_uploads);
  value->SetString("reporting_delivery_interval", base::trace_event::ValueToString(this->reporting_delivery_interval, "<value of type base::Optional<::base::TimeDelta>>"));
  value->SetBoolean("skip_reporting_send_permission_check", this->skip_reporting_send_permission_check);
  value->BeginArray("cors_origin_access_list");
  for (const auto& item0 : this->cors_origin_access_list) {
    if (item0.is_null()) {
      value->AppendString("nullptr");
    } else {
      value->BeginDictionary();
      item0->AsValueInto(value);
      value->EndDictionary();
    }
  }
  value->EndArray();
  value->BeginArray("cors_exempt_header_list");
  for (const auto& item0 : this->cors_exempt_header_list) {
    value->AppendString(item0);
  }
  value->EndArray();
  value->SetBoolean("allow_any_cors_exempt_header_for_browser", this->allow_any_cors_exempt_header_for_browser);
  value->BeginArray("hsts_policy_bypass_list");
  for (const auto& item0 : this->hsts_policy_bypass_list) {
    value->AppendString(item0);
  }
  value->EndArray();
  value->SetString("reporting_and_nel_store_path", base::trace_event::ValueToString(this->reporting_and_nel_store_path, "<value of type const base::Optional<::base::FilePath>&>"));
  if (this->http_auth_static_network_context_params.is_null()) {
    value->SetString("http_auth_static_network_context_params", "nullptr");
  } else {
    value->BeginDictionary("http_auth_static_network_context_params");
    this->http_auth_static_network_context_params->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("reset_http_cache_backend", this->reset_http_cache_backend);
  value->SetBoolean("split_auth_cache_by_network_isolation_key", this->split_auth_cache_by_network_isolation_key);
  value->SetBoolean("require_network_isolation_key", this->require_network_isolation_key);
}

bool NetworkContextParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkConditions::NetworkConditions()
    : offline(),
      latency(),
      download_throughput(),
      upload_throughput() {}

NetworkConditions::NetworkConditions(
    bool offline_in,
    ::base::TimeDelta latency_in,
    double download_throughput_in,
    double upload_throughput_in)
    : offline(std::move(offline_in)),
      latency(std::move(latency_in)),
      download_throughput(std::move(download_throughput_in)),
      upload_throughput(std::move(upload_throughput_in)) {}

NetworkConditions::~NetworkConditions() = default;

void NetworkConditions::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("offline", this->offline);
  value->SetString("latency", base::trace_event::ValueToString(this->latency, "<value of type ::base::TimeDelta>"));
  value->SetDouble("download_throughput", this->download_throughput);
  value->SetDouble("upload_throughput", this->upload_throughput);
}

bool NetworkConditions::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
ClearDataFilter::ClearDataFilter()
    : type(),
      domains(),
      origins() {}

ClearDataFilter::ClearDataFilter(
    ClearDataFilter::Type type_in,
    std::vector<std::string> domains_in,
    std::vector<::url::Origin> origins_in)
    : type(std::move(type_in)),
      domains(std::move(domains_in)),
      origins(std::move(origins_in)) {}

ClearDataFilter::~ClearDataFilter() = default;

void ClearDataFilter::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetString("type", base::trace_event::ValueToString(this->type));
  value->BeginArray("domains");
  for (const auto& item0 : this->domains) {
    value->AppendString(item0);
  }
  value->EndArray();
  value->BeginArray("origins");
  for (const auto& item0 : this->origins) {
    value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::url::Origin&>"));
  }
  value->EndArray();
}

bool ClearDataFilter::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
NetworkUsage::NetworkUsage()
    : process_id(),
      routing_id(),
      total_bytes_received(),
      total_bytes_sent() {}

NetworkUsage::NetworkUsage(
    int32_t process_id_in,
    int32_t routing_id_in,
    int64_t total_bytes_received_in,
    int64_t total_bytes_sent_in)
    : process_id(std::move(process_id_in)),
      routing_id(std::move(routing_id_in)),
      total_bytes_received(std::move(total_bytes_received_in)),
      total_bytes_sent(std::move(total_bytes_sent_in)) {}

NetworkUsage::~NetworkUsage() = default;
size_t NetworkUsage::Hash(size_t seed) const {
  seed = mojo::internal::Hash(seed, this->process_id);
  seed = mojo::internal::Hash(seed, this->routing_id);
  seed = mojo::internal::Hash(seed, this->total_bytes_received);
  seed = mojo::internal::Hash(seed, this->total_bytes_sent);
  return seed;
}

void NetworkUsage::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("process_id", this->process_id);
  value->SetInteger("routing_id", this->routing_id);
  value->SetString("total_bytes_received", base::NumberToString(this->total_bytes_received));
  value->SetString("total_bytes_sent", base::NumberToString(this->total_bytes_sent));
}

bool NetworkUsage::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
SignedExchangeReport::SignedExchangeReport()
    : success(),
      type(),
      outer_url(),
      inner_url(),
      cert_url(),
      referrer(),
      server_ip_address(),
      protocol(),
      method(),
      status_code(),
      elapsed_time() {}

SignedExchangeReport::SignedExchangeReport(
    bool success_in,
    const std::string& type_in,
    const ::GURL& outer_url_in,
    const ::GURL& inner_url_in,
    const ::GURL& cert_url_in,
    const std::string& referrer_in,
    const ::net::IPAddress& server_ip_address_in,
    const std::string& protocol_in,
    const std::string& method_in,
    int32_t status_code_in,
    ::base::TimeDelta elapsed_time_in)
    : success(std::move(success_in)),
      type(std::move(type_in)),
      outer_url(std::move(outer_url_in)),
      inner_url(std::move(inner_url_in)),
      cert_url(std::move(cert_url_in)),
      referrer(std::move(referrer_in)),
      server_ip_address(std::move(server_ip_address_in)),
      protocol(std::move(protocol_in)),
      method(std::move(method_in)),
      status_code(std::move(status_code_in)),
      elapsed_time(std::move(elapsed_time_in)) {}

SignedExchangeReport::~SignedExchangeReport() = default;

void SignedExchangeReport::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("success", this->success);
  value->SetString("type", this->type);
  value->SetString("outer_url", base::trace_event::ValueToString(this->outer_url, "<value of type const ::GURL&>"));
  value->SetString("inner_url", base::trace_event::ValueToString(this->inner_url, "<value of type const ::GURL&>"));
  value->SetString("cert_url", base::trace_event::ValueToString(this->cert_url, "<value of type const ::GURL&>"));
  value->SetString("referrer", this->referrer);
  value->SetString("server_ip_address", base::trace_event::ValueToString(this->server_ip_address, "<value of type const ::net::IPAddress&>"));
  value->SetString("protocol", this->protocol);
  value->SetString("method", this->method);
  value->SetInteger("status_code", this->status_code);
  value->SetString("elapsed_time", base::trace_event::ValueToString(this->elapsed_time, "<value of type ::base::TimeDelta>"));
}

bool SignedExchangeReport::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLLoaderFactoryOverride::URLLoaderFactoryOverride()
    : overriding_factory(),
      overridden_factory_receiver(),
      skip_cors_enabled_scheme_check(false) {}

URLLoaderFactoryOverride::URLLoaderFactoryOverride(
    ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> overriding_factory_in,
    ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> overridden_factory_receiver_in,
    bool skip_cors_enabled_scheme_check_in)
    : overriding_factory(std::move(overriding_factory_in)),
      overridden_factory_receiver(std::move(overridden_factory_receiver_in)),
      skip_cors_enabled_scheme_check(std::move(skip_cors_enabled_scheme_check_in)) {}

URLLoaderFactoryOverride::~URLLoaderFactoryOverride() = default;

void URLLoaderFactoryOverride::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetBoolean("overriding_factory", this->overriding_factory.is_valid());
  value->SetBoolean("overridden_factory_receiver", this->overridden_factory_receiver.is_valid());
  value->SetBoolean("skip_cors_enabled_scheme_check", this->skip_cors_enabled_scheme_check);
}

bool URLLoaderFactoryOverride::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
URLLoaderFactoryParams::URLLoaderFactoryParams()
    : process_id(kInvalidProcessId),
      request_initiator_origin_lock(),
      is_corb_enabled(true),
      ignore_isolated_world_origin(true),
      unsafe_non_webby_initiator(false),
      disable_web_security(false),
      header_client(),
      factory_bound_access_patterns(),
      isolation_info(),
      disable_secure_dns(false),
      is_trusted(false),
      automatically_assign_isolation_info(false),
      top_frame_id(),
      factory_override(),
      client_security_state(),
      coep_reporter(),
      cookie_observer(),
      trust_token_redemption_policy(TrustTokenRedemptionPolicy::kPotentiallyPermit),
      debug_tag("<uninitialized>") {}

URLLoaderFactoryParams::URLLoaderFactoryParams(
    int32_t process_id_in,
    const base::Optional<::url::Origin>& request_initiator_origin_lock_in,
    bool is_corb_enabled_in,
    bool ignore_isolated_world_origin_in,
    bool unsafe_non_webby_initiator_in,
    bool disable_web_security_in,
    ::mojo::PendingRemote<TrustedURLLoaderHeaderClient> header_client_in,
    ::network::mojom::CorsOriginAccessPatternsPtr factory_bound_access_patterns_in,
    const ::net::IsolationInfo& isolation_info_in,
    bool disable_secure_dns_in,
    bool is_trusted_in,
    bool automatically_assign_isolation_info_in,
    const base::Optional<::base::UnguessableToken>& top_frame_id_in,
    URLLoaderFactoryOverridePtr factory_override_in,
    ::network::mojom::ClientSecurityStatePtr client_security_state_in,
    ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter_in,
    ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer_in,
    TrustTokenRedemptionPolicy trust_token_redemption_policy_in,
    const std::string& debug_tag_in)
    : process_id(std::move(process_id_in)),
      request_initiator_origin_lock(std::move(request_initiator_origin_lock_in)),
      is_corb_enabled(std::move(is_corb_enabled_in)),
      ignore_isolated_world_origin(std::move(ignore_isolated_world_origin_in)),
      unsafe_non_webby_initiator(std::move(unsafe_non_webby_initiator_in)),
      disable_web_security(std::move(disable_web_security_in)),
      header_client(std::move(header_client_in)),
      factory_bound_access_patterns(std::move(factory_bound_access_patterns_in)),
      isolation_info(std::move(isolation_info_in)),
      disable_secure_dns(std::move(disable_secure_dns_in)),
      is_trusted(std::move(is_trusted_in)),
      automatically_assign_isolation_info(std::move(automatically_assign_isolation_info_in)),
      top_frame_id(std::move(top_frame_id_in)),
      factory_override(std::move(factory_override_in)),
      client_security_state(std::move(client_security_state_in)),
      coep_reporter(std::move(coep_reporter_in)),
      cookie_observer(std::move(cookie_observer_in)),
      trust_token_redemption_policy(std::move(trust_token_redemption_policy_in)),
      debug_tag(std::move(debug_tag_in)) {}

URLLoaderFactoryParams::~URLLoaderFactoryParams() = default;

void URLLoaderFactoryParams::AsValueInto(base::trace_event::TracedValue* value) const {
  value->SetInteger("process_id", this->process_id);
  value->SetString("request_initiator_origin_lock", base::trace_event::ValueToString(this->request_initiator_origin_lock, "<value of type const base::Optional<::url::Origin>&>"));
  value->SetBoolean("is_corb_enabled", this->is_corb_enabled);
  value->SetBoolean("ignore_isolated_world_origin", this->ignore_isolated_world_origin);
  value->SetBoolean("unsafe_non_webby_initiator", this->unsafe_non_webby_initiator);
  value->SetBoolean("disable_web_security", this->disable_web_security);
  value->SetBoolean("header_client", this->header_client.is_valid());
  if (this->factory_bound_access_patterns.is_null()) {
    value->SetString("factory_bound_access_patterns", "nullptr");
  } else {
    value->BeginDictionary("factory_bound_access_patterns");
    this->factory_bound_access_patterns->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetString("isolation_info", base::trace_event::ValueToString(this->isolation_info, "<value of type const ::net::IsolationInfo&>"));
  value->SetBoolean("disable_secure_dns", this->disable_secure_dns);
  value->SetBoolean("is_trusted", this->is_trusted);
  value->SetBoolean("automatically_assign_isolation_info", this->automatically_assign_isolation_info);
  value->SetString("top_frame_id", base::trace_event::ValueToString(this->top_frame_id, "<value of type const base::Optional<::base::UnguessableToken>&>"));
  if (this->factory_override.is_null()) {
    value->SetString("factory_override", "nullptr");
  } else {
    value->BeginDictionary("factory_override");
    this->factory_override->AsValueInto(value);
    value->EndDictionary();
  }
  if (this->client_security_state.is_null()) {
    value->SetString("client_security_state", "nullptr");
  } else {
    value->BeginDictionary("client_security_state");
    this->client_security_state->AsValueInto(value);
    value->EndDictionary();
  }
  value->SetBoolean("coep_reporter", this->coep_reporter.is_valid());
  value->SetBoolean("cookie_observer", this->cookie_observer.is_valid());
  value->SetString("trust_token_redemption_policy", base::trace_event::ValueToString(this->trust_token_redemption_policy));
  value->SetString("debug_tag", this->debug_tag);
}

bool URLLoaderFactoryParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context);
}
CertVerifierParams::CertVerifierParams() : tag_(Tag::REMOTE_PARAMS) {
  data_.remote_params = new CertVerifierServiceRemoteParamsPtr;
}

CertVerifierParams::~CertVerifierParams() {
  DestroyActive();
}


void CertVerifierParams::set_remote_params(
    CertVerifierServiceRemoteParamsPtr remote_params) {
  if (tag_ == Tag::REMOTE_PARAMS) {
    *(data_.remote_params) = std::move(remote_params);
  } else {
    DestroyActive();
    tag_ = Tag::REMOTE_PARAMS;
    data_.remote_params = new CertVerifierServiceRemoteParamsPtr(
        std::move(remote_params));
  }
}
void CertVerifierParams::set_creation_params(
    CertVerifierCreationParamsPtr creation_params) {
  if (tag_ == Tag::CREATION_PARAMS) {
    *(data_.creation_params) = std::move(creation_params);
  } else {
    DestroyActive();
    tag_ = Tag::CREATION_PARAMS;
    data_.creation_params = new CertVerifierCreationParamsPtr(
        std::move(creation_params));
  }
}

void CertVerifierParams::DestroyActive() {
  switch (tag_) {

    case Tag::REMOTE_PARAMS:

      delete data_.remote_params;
      break;
    case Tag::CREATION_PARAMS:

      delete data_.creation_params;
      break;
  }
}

bool CertVerifierParams::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char CustomProxyConfigClient::Name_[] = "network.mojom.CustomProxyConfigClient";

class CustomProxyConfigClient_MarkProxiesAsBad_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  CustomProxyConfigClient_MarkProxiesAsBad_ForwardToCallback(
      CustomProxyConfigClient::MarkProxiesAsBadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  CustomProxyConfigClient::MarkProxiesAsBadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(CustomProxyConfigClient_MarkProxiesAsBad_ForwardToCallback);
};

CustomProxyConfigClientProxy::CustomProxyConfigClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CustomProxyConfigClientProxy::OnCustomProxyConfigUpdated(
    CustomProxyConfigPtr in_proxy_config) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CustomProxyConfigClient::OnCustomProxyConfigUpdated", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_proxy_config.is_null()) {
        raw_value->SetString("proxy_config", "nullptr");
      } else {
        raw_value->BeginDictionary("proxy_config");
        in_proxy_config->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCustomProxyConfigClient_OnCustomProxyConfigUpdated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->proxy_config)::BaseType::BufferWriter
      proxy_config_writer;
  mojo::internal::Serialize<::network::mojom::CustomProxyConfigDataView>(
      in_proxy_config, buffer, &proxy_config_writer, &serialization_context);
  params->proxy_config.Set(
      proxy_config_writer.is_null() ? nullptr : proxy_config_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->proxy_config.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null proxy_config in CustomProxyConfigClient.OnCustomProxyConfigUpdated request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomProxyConfigClient::Name_);
  message.set_method_name("OnCustomProxyConfigUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CustomProxyConfigClientProxy::MarkProxiesAsBad(
    ::base::TimeDelta in_bypass_duration, const ::net::ProxyList& in_bad_proxies, MarkProxiesAsBadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::CustomProxyConfigClient::MarkProxiesAsBad", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("bypass_duration", base::trace_event::ValueToString(in_bypass_duration, "<value of type ::base::TimeDelta>"));
      raw_value->SetString("bad_proxies", base::trace_event::ValueToString(in_bad_proxies, "<value of type const ::net::ProxyList&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCustomProxyConfigClient_MarkProxiesAsBad_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CustomProxyConfigClient_MarkProxiesAsBad_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->bypass_duration)::BaseType::BufferWriter
      bypass_duration_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDeltaDataView>(
      in_bypass_duration, buffer, &bypass_duration_writer, &serialization_context);
  params->bypass_duration.Set(
      bypass_duration_writer.is_null() ? nullptr : bypass_duration_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bypass_duration.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bypass_duration in CustomProxyConfigClient.MarkProxiesAsBad request");
  typename decltype(params->bad_proxies)::BaseType::BufferWriter
      bad_proxies_writer;
  mojo::internal::Serialize<::network::mojom::ProxyListDataView>(
      in_bad_proxies, buffer, &bad_proxies_writer, &serialization_context);
  params->bad_proxies.Set(
      bad_proxies_writer.is_null() ? nullptr : bad_proxies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bad_proxies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bad_proxies in CustomProxyConfigClient.MarkProxiesAsBad request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomProxyConfigClient::Name_);
  message.set_method_name("MarkProxiesAsBad");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new CustomProxyConfigClient_MarkProxiesAsBad_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void CustomProxyConfigClientProxy::ClearBadProxiesCache(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::CustomProxyConfigClient::ClearBadProxiesCache");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCustomProxyConfigClient_ClearBadProxiesCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CustomProxyConfigClient_ClearBadProxiesCache_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomProxyConfigClient::Name_);
  message.set_method_name("ClearBadProxiesCache");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class CustomProxyConfigClient_MarkProxiesAsBad_ProxyToResponder {
 public:
  static CustomProxyConfigClient::MarkProxiesAsBadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<CustomProxyConfigClient_MarkProxiesAsBad_ProxyToResponder> proxy(
        new CustomProxyConfigClient_MarkProxiesAsBad_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&CustomProxyConfigClient_MarkProxiesAsBad_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~CustomProxyConfigClient_MarkProxiesAsBad_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  CustomProxyConfigClient_MarkProxiesAsBad_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "CustomProxyConfigClient::MarkProxiesAsBadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(CustomProxyConfigClient_MarkProxiesAsBad_ProxyToResponder);
};

bool CustomProxyConfigClient_MarkProxiesAsBad_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::CustomProxyConfigClient::MarkProxiesAsBadCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::CustomProxyConfigClient_MarkProxiesAsBad_ResponseParams_Data* params =
      reinterpret_cast<
          internal::CustomProxyConfigClient_MarkProxiesAsBad_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  CustomProxyConfigClient_MarkProxiesAsBad_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        CustomProxyConfigClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void CustomProxyConfigClient_MarkProxiesAsBad_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::CustomProxyConfigClient::MarkProxiesAsBadCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCustomProxyConfigClient_MarkProxiesAsBad_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::CustomProxyConfigClient_MarkProxiesAsBad_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::CustomProxyConfigClient::MarkProxiesAsBadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CustomProxyConfigClient::Name_);
  message.set_method_name("MarkProxiesAsBad");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool CustomProxyConfigClientStubDispatch::Accept(
    CustomProxyConfigClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCustomProxyConfigClient_OnCustomProxyConfigUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CustomProxyConfigClient::OnCustomProxyConfigUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CustomProxyConfigClient::OnCustomProxyConfigUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data* params =
          reinterpret_cast<internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CustomProxyConfigPtr p_proxy_config{};
      CustomProxyConfigClient_OnCustomProxyConfigUpdated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadProxyConfig(&p_proxy_config))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomProxyConfigClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCustomProxyConfigUpdated(
std::move(p_proxy_config));
      return true;
    }
    case internal::kCustomProxyConfigClient_MarkProxiesAsBad_Name: {
      break;
    }
    case internal::kCustomProxyConfigClient_ClearBadProxiesCache_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CustomProxyConfigClient::ClearBadProxiesCache",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CustomProxyConfigClient::ClearBadProxiesCache");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CustomProxyConfigClient_ClearBadProxiesCache_Params_Data* params =
          reinterpret_cast<internal::CustomProxyConfigClient_ClearBadProxiesCache_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CustomProxyConfigClient_ClearBadProxiesCache_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomProxyConfigClient::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearBadProxiesCache();
      return true;
    }
  }
  return false;
}

// static
bool CustomProxyConfigClientStubDispatch::AcceptWithResponder(
    CustomProxyConfigClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCustomProxyConfigClient_OnCustomProxyConfigUpdated_Name: {
      break;
    }
    case internal::kCustomProxyConfigClient_MarkProxiesAsBad_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::CustomProxyConfigClient::MarkProxiesAsBad",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::CustomProxyConfigClient::MarkProxiesAsBad");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::CustomProxyConfigClient_MarkProxiesAsBad_Params_Data* params =
          reinterpret_cast<
              internal::CustomProxyConfigClient_MarkProxiesAsBad_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::TimeDelta p_bypass_duration{};
      ::net::ProxyList p_bad_proxies{};
      CustomProxyConfigClient_MarkProxiesAsBad_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadBypassDuration(&p_bypass_duration))
        success = false;
      if (success && !input_data_view.ReadBadProxies(&p_bad_proxies))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CustomProxyConfigClient::Name_, 1, false);
        return false;
      }
      CustomProxyConfigClient::MarkProxiesAsBadCallback callback =
          CustomProxyConfigClient_MarkProxiesAsBad_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->MarkProxiesAsBad(
std::move(p_bypass_duration), 
std::move(p_bad_proxies), std::move(callback));
      return true;
    }
    case internal::kCustomProxyConfigClient_ClearBadProxiesCache_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCustomProxyConfigClientValidationInfo[] = {
    {internal::kCustomProxyConfigClient_OnCustomProxyConfigUpdated_Name,
     {&internal::CustomProxyConfigClient_OnCustomProxyConfigUpdated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCustomProxyConfigClient_MarkProxiesAsBad_Name,
     {&internal::CustomProxyConfigClient_MarkProxiesAsBad_Params_Data::Validate,
      &internal::CustomProxyConfigClient_MarkProxiesAsBad_ResponseParams_Data::Validate}},
    {internal::kCustomProxyConfigClient_ClearBadProxiesCache_Name,
     {&internal::CustomProxyConfigClient_ClearBadProxiesCache_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CustomProxyConfigClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::CustomProxyConfigClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCustomProxyConfigClientValidationInfo);
}

bool CustomProxyConfigClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::CustomProxyConfigClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kCustomProxyConfigClientValidationInfo);

}
const char TrustedHeaderClient::Name_[] = "network.mojom.TrustedHeaderClient";

class TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback(
      TrustedHeaderClient::OnBeforeSendHeadersCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TrustedHeaderClient::OnBeforeSendHeadersCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback);
};

class TrustedHeaderClient_OnHeadersReceived_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  TrustedHeaderClient_OnHeadersReceived_ForwardToCallback(
      TrustedHeaderClient::OnHeadersReceivedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  TrustedHeaderClient::OnHeadersReceivedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(TrustedHeaderClient_OnHeadersReceived_ForwardToCallback);
};

TrustedHeaderClientProxy::TrustedHeaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TrustedHeaderClientProxy::OnBeforeSendHeaders(
    const ::net::HttpRequestHeaders& in_headers, OnBeforeSendHeadersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TrustedHeaderClient::OnBeforeSendHeaders", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("headers", base::trace_event::ValueToString(in_headers, "<value of type const ::net::HttpRequestHeaders&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTrustedHeaderClient_OnBeforeSendHeaders_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::TrustedHeaderClient_OnBeforeSendHeaders_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->headers)::BaseType::BufferWriter
      headers_writer;
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_headers, buffer, &headers_writer, &serialization_context);
  params->headers.Set(
      headers_writer.is_null() ? nullptr : headers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in TrustedHeaderClient.OnBeforeSendHeaders request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedHeaderClient::Name_);
  message.set_method_name("OnBeforeSendHeaders");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void TrustedHeaderClientProxy::OnHeadersReceived(
    const std::string& in_headers, const ::net::IPEndPoint& in_remote_endpoint, OnHeadersReceivedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TrustedHeaderClient::OnHeadersReceived", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("headers", in_headers);
      raw_value->SetString("remote_endpoint", base::trace_event::ValueToString(in_remote_endpoint, "<value of type const ::net::IPEndPoint&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTrustedHeaderClient_OnHeadersReceived_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::TrustedHeaderClient_OnHeadersReceived_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->headers)::BaseType::BufferWriter
      headers_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_headers, buffer, &headers_writer, &serialization_context);
  params->headers.Set(
      headers_writer.is_null() ? nullptr : headers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in TrustedHeaderClient.OnHeadersReceived request");
  typename decltype(params->remote_endpoint)::BaseType::BufferWriter
      remote_endpoint_writer;
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_remote_endpoint, buffer, &remote_endpoint_writer, &serialization_context);
  params->remote_endpoint.Set(
      remote_endpoint_writer.is_null() ? nullptr : remote_endpoint_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_endpoint.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_endpoint in TrustedHeaderClient.OnHeadersReceived request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedHeaderClient::Name_);
  message.set_method_name("OnHeadersReceived");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new TrustedHeaderClient_OnHeadersReceived_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder {
 public:
  static TrustedHeaderClient::OnBeforeSendHeadersCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder> proxy(
        new TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TrustedHeaderClient::OnBeforeSendHeadersCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const base::Optional<::net::HttpRequestHeaders>& in_headers);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder);
};

bool TrustedHeaderClient_OnBeforeSendHeaders_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::TrustedHeaderClient::OnBeforeSendHeadersCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_result{};
  base::Optional<::net::HttpRequestHeaders> p_headers{};
  TrustedHeaderClient_OnBeforeSendHeaders_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadHeaders(&p_headers))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TrustedHeaderClient::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_headers));
  return true;
}

void TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder::Run(
    int32_t in_result, const base::Optional<::net::HttpRequestHeaders>& in_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::TrustedHeaderClient::OnBeforeSendHeadersCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("result", in_result);
      raw_value->SetString("headers", base::trace_event::ValueToString(in_headers, "<value of type const base::Optional<::net::HttpRequestHeaders>&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTrustedHeaderClient_OnBeforeSendHeaders_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->result = in_result;
  typename decltype(params->headers)::BaseType::BufferWriter
      headers_writer;
  mojo::internal::Serialize<::network::mojom::HttpRequestHeadersDataView>(
      in_headers, buffer, &headers_writer, &serialization_context);
  params->headers.Set(
      headers_writer.is_null() ? nullptr : headers_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::TrustedHeaderClient::OnBeforeSendHeadersCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedHeaderClient::Name_);
  message.set_method_name("OnBeforeSendHeaders");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class TrustedHeaderClient_OnHeadersReceived_ProxyToResponder {
 public:
  static TrustedHeaderClient::OnHeadersReceivedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<TrustedHeaderClient_OnHeadersReceived_ProxyToResponder> proxy(
        new TrustedHeaderClient_OnHeadersReceived_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&TrustedHeaderClient_OnHeadersReceived_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~TrustedHeaderClient_OnHeadersReceived_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  TrustedHeaderClient_OnHeadersReceived_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "TrustedHeaderClient::OnHeadersReceivedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const base::Optional<std::string>& in_headers, const base::Optional<::GURL>& in_preserve_fragment_on_redirect_url);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(TrustedHeaderClient_OnHeadersReceived_ProxyToResponder);
};

bool TrustedHeaderClient_OnHeadersReceived_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::TrustedHeaderClient::OnHeadersReceivedCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data* params =
      reinterpret_cast<
          internal::TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_result{};
  base::Optional<std::string> p_headers{};
  base::Optional<::GURL> p_preserve_fragment_on_redirect_url{};
  TrustedHeaderClient_OnHeadersReceived_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadHeaders(&p_headers))
    success = false;
  if (success && !input_data_view.ReadPreserveFragmentOnRedirectUrl(&p_preserve_fragment_on_redirect_url))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        TrustedHeaderClient::Name_, 1, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_headers), 
std::move(p_preserve_fragment_on_redirect_url));
  return true;
}

void TrustedHeaderClient_OnHeadersReceived_ProxyToResponder::Run(
    int32_t in_result, const base::Optional<std::string>& in_headers, const base::Optional<::GURL>& in_preserve_fragment_on_redirect_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::TrustedHeaderClient::OnHeadersReceivedCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("result", in_result);
      if (in_headers.has_value()) {
        raw_value->SetString("headers", in_headers.value());
      } else {
        raw_value->SetString("headers", "base::nullopt");
      }
      raw_value->SetString("preserve_fragment_on_redirect_url", base::trace_event::ValueToString(in_preserve_fragment_on_redirect_url, "<value of type const base::Optional<::GURL>&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTrustedHeaderClient_OnHeadersReceived_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->result = in_result;
  typename decltype(params->headers)::BaseType::BufferWriter
      headers_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_headers, buffer, &headers_writer, &serialization_context);
  params->headers.Set(
      headers_writer.is_null() ? nullptr : headers_writer.data());
  typename decltype(params->preserve_fragment_on_redirect_url)::BaseType::BufferWriter
      preserve_fragment_on_redirect_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_preserve_fragment_on_redirect_url, buffer, &preserve_fragment_on_redirect_url_writer, &serialization_context);
  params->preserve_fragment_on_redirect_url.Set(
      preserve_fragment_on_redirect_url_writer.is_null() ? nullptr : preserve_fragment_on_redirect_url_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::TrustedHeaderClient::OnHeadersReceivedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedHeaderClient::Name_);
  message.set_method_name("OnHeadersReceived");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool TrustedHeaderClientStubDispatch::Accept(
    TrustedHeaderClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kTrustedHeaderClient_OnBeforeSendHeaders_Name: {
      break;
    }
    case internal::kTrustedHeaderClient_OnHeadersReceived_Name: {
      break;
    }
  }
  return false;
}

// static
bool TrustedHeaderClientStubDispatch::AcceptWithResponder(
    TrustedHeaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTrustedHeaderClient_OnBeforeSendHeaders_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TrustedHeaderClient::OnBeforeSendHeaders",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TrustedHeaderClient::OnBeforeSendHeaders");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TrustedHeaderClient_OnBeforeSendHeaders_Params_Data* params =
          reinterpret_cast<
              internal::TrustedHeaderClient_OnBeforeSendHeaders_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::HttpRequestHeaders p_headers{};
      TrustedHeaderClient_OnBeforeSendHeaders_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedHeaderClient::Name_, 0, false);
        return false;
      }
      TrustedHeaderClient::OnBeforeSendHeadersCallback callback =
          TrustedHeaderClient_OnBeforeSendHeaders_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnBeforeSendHeaders(
std::move(p_headers), std::move(callback));
      return true;
    }
    case internal::kTrustedHeaderClient_OnHeadersReceived_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TrustedHeaderClient::OnHeadersReceived",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TrustedHeaderClient::OnHeadersReceived");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::TrustedHeaderClient_OnHeadersReceived_Params_Data* params =
          reinterpret_cast<
              internal::TrustedHeaderClient_OnHeadersReceived_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_headers{};
      ::net::IPEndPoint p_remote_endpoint{};
      TrustedHeaderClient_OnHeadersReceived_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (success && !input_data_view.ReadRemoteEndpoint(&p_remote_endpoint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedHeaderClient::Name_, 1, false);
        return false;
      }
      TrustedHeaderClient::OnHeadersReceivedCallback callback =
          TrustedHeaderClient_OnHeadersReceived_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnHeadersReceived(
std::move(p_headers), 
std::move(p_remote_endpoint), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTrustedHeaderClientValidationInfo[] = {
    {internal::kTrustedHeaderClient_OnBeforeSendHeaders_Name,
     {&internal::TrustedHeaderClient_OnBeforeSendHeaders_Params_Data::Validate,
      &internal::TrustedHeaderClient_OnBeforeSendHeaders_ResponseParams_Data::Validate}},
    {internal::kTrustedHeaderClient_OnHeadersReceived_Name,
     {&internal::TrustedHeaderClient_OnHeadersReceived_Params_Data::Validate,
      &internal::TrustedHeaderClient_OnHeadersReceived_ResponseParams_Data::Validate}},
};

bool TrustedHeaderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TrustedHeaderClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTrustedHeaderClientValidationInfo);
}

bool TrustedHeaderClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TrustedHeaderClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kTrustedHeaderClientValidationInfo);

}
const char TrustedURLLoaderHeaderClient::Name_[] = "network.mojom.TrustedURLLoaderHeaderClient";

TrustedURLLoaderHeaderClientProxy::TrustedURLLoaderHeaderClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void TrustedURLLoaderHeaderClientProxy::OnLoaderCreated(
    int32_t in_request_id, ::mojo::PendingReceiver<TrustedHeaderClient> in_header_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TrustedURLLoaderHeaderClient::OnLoaderCreated", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("request_id", in_request_id);
      raw_value->SetBoolean("header_client", in_header_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTrustedURLLoaderHeaderClient_OnLoaderCreated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->request_id = in_request_id;
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TrustedHeaderClientInterfaceBase>>(
      in_header_client, &params->header_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->header_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid header_client in TrustedURLLoaderHeaderClient.OnLoaderCreated request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedURLLoaderHeaderClient::Name_);
  message.set_method_name("OnLoaderCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void TrustedURLLoaderHeaderClientProxy::OnLoaderForCorsPreflightCreated(
    const ::network::ResourceRequest& in_request, ::mojo::PendingReceiver<TrustedHeaderClient> in_header_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::TrustedURLLoaderHeaderClient::OnLoaderForCorsPreflightCreated", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("request", base::trace_event::ValueToString(in_request, "<value of type const ::network::ResourceRequest&>"));
      raw_value->SetBoolean("header_client", in_header_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kTrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->request)::BaseType::BufferWriter
      request_writer;
  mojo::internal::Serialize<::network::mojom::URLRequestDataView>(
      in_request, buffer, &request_writer, &serialization_context);
  params->request.Set(
      request_writer.is_null() ? nullptr : request_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->request.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null request in TrustedURLLoaderHeaderClient.OnLoaderForCorsPreflightCreated request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TrustedHeaderClientInterfaceBase>>(
      in_header_client, &params->header_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->header_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid header_client in TrustedURLLoaderHeaderClient.OnLoaderForCorsPreflightCreated request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(TrustedURLLoaderHeaderClient::Name_);
  message.set_method_name("OnLoaderForCorsPreflightCreated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool TrustedURLLoaderHeaderClientStubDispatch::Accept(
    TrustedURLLoaderHeaderClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kTrustedURLLoaderHeaderClient_OnLoaderCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TrustedURLLoaderHeaderClient::OnLoaderCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TrustedURLLoaderHeaderClient::OnLoaderCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data* params =
          reinterpret_cast<internal::TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_request_id{};
      ::mojo::PendingReceiver<TrustedHeaderClient> p_header_client{};
      TrustedURLLoaderHeaderClient_OnLoaderCreated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success) {
        p_header_client =
            input_data_view.TakeHeaderClient<decltype(p_header_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedURLLoaderHeaderClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLoaderCreated(
std::move(p_request_id), 
std::move(p_header_client));
      return true;
    }
    case internal::kTrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::TrustedURLLoaderHeaderClient::OnLoaderForCorsPreflightCreated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::TrustedURLLoaderHeaderClient::OnLoaderForCorsPreflightCreated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data* params =
          reinterpret_cast<internal::TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::network::ResourceRequest p_request{};
      ::mojo::PendingReceiver<TrustedHeaderClient> p_header_client{};
      TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRequest(&p_request))
        success = false;
      if (success) {
        p_header_client =
            input_data_view.TakeHeaderClient<decltype(p_header_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            TrustedURLLoaderHeaderClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnLoaderForCorsPreflightCreated(
std::move(p_request), 
std::move(p_header_client));
      return true;
    }
  }
  return false;
}

// static
bool TrustedURLLoaderHeaderClientStubDispatch::AcceptWithResponder(
    TrustedURLLoaderHeaderClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kTrustedURLLoaderHeaderClient_OnLoaderCreated_Name: {
      break;
    }
    case internal::kTrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kTrustedURLLoaderHeaderClientValidationInfo[] = {
    {internal::kTrustedURLLoaderHeaderClient_OnLoaderCreated_Name,
     {&internal::TrustedURLLoaderHeaderClient_OnLoaderCreated_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kTrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Name,
     {&internal::TrustedURLLoaderHeaderClient_OnLoaderForCorsPreflightCreated_Params_Data::Validate,
      nullptr /* no response */}},
};

bool TrustedURLLoaderHeaderClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::TrustedURLLoaderHeaderClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kTrustedURLLoaderHeaderClientValidationInfo);
}

const char AuthChallengeResponder::Name_[] = "network.mojom.AuthChallengeResponder";

AuthChallengeResponderProxy::AuthChallengeResponderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void AuthChallengeResponderProxy::OnAuthCredentials(
    const base::Optional<::net::AuthCredentials>& in_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::AuthChallengeResponder::OnAuthCredentials", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("credentials", base::trace_event::ValueToString(in_credentials, "<value of type const base::Optional<::net::AuthCredentials>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kAuthChallengeResponder_OnAuthCredentials_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::AuthChallengeResponder_OnAuthCredentials_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->credentials)::BaseType::BufferWriter
      credentials_writer;
  mojo::internal::Serialize<::network::mojom::AuthCredentialsDataView>(
      in_credentials, buffer, &credentials_writer, &serialization_context);
  params->credentials.Set(
      credentials_writer.is_null() ? nullptr : credentials_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(AuthChallengeResponder::Name_);
  message.set_method_name("OnAuthCredentials");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool AuthChallengeResponderStubDispatch::Accept(
    AuthChallengeResponder* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kAuthChallengeResponder_OnAuthCredentials_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::AuthChallengeResponder::OnAuthCredentials",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::AuthChallengeResponder::OnAuthCredentials");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::AuthChallengeResponder_OnAuthCredentials_Params_Data* params =
          reinterpret_cast<internal::AuthChallengeResponder_OnAuthCredentials_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::net::AuthCredentials> p_credentials{};
      AuthChallengeResponder_OnAuthCredentials_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCredentials(&p_credentials))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            AuthChallengeResponder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAuthCredentials(
std::move(p_credentials));
      return true;
    }
  }
  return false;
}

// static
bool AuthChallengeResponderStubDispatch::AcceptWithResponder(
    AuthChallengeResponder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kAuthChallengeResponder_OnAuthCredentials_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kAuthChallengeResponderValidationInfo[] = {
    {internal::kAuthChallengeResponder_OnAuthCredentials_Name,
     {&internal::AuthChallengeResponder_OnAuthCredentials_Params_Data::Validate,
      nullptr /* no response */}},
};

bool AuthChallengeResponderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::AuthChallengeResponder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kAuthChallengeResponderValidationInfo);
}

const char ClientCertificateResponder::Name_[] = "network.mojom.ClientCertificateResponder";

ClientCertificateResponderProxy::ClientCertificateResponderProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ClientCertificateResponderProxy::ContinueWithCertificate(
    const ::scoped_refptr<::net::X509Certificate>& in_x509_certificate, const std::string& in_provider_name, const std::vector<uint16_t>& in_algorithm_preferences, ::mojo::PendingRemote<SSLPrivateKey> in_ssl_private_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::ClientCertificateResponder::ContinueWithCertificate", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("x509_certificate", base::trace_event::ValueToString(in_x509_certificate, "<value of type const ::scoped_refptr<::net::X509Certificate>&>"));
      raw_value->SetString("provider_name", in_provider_name);
      raw_value->BeginArray("algorithm_preferences");
      for (const auto& item0 : in_algorithm_preferences) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      raw_value->SetBoolean("ssl_private_key", in_ssl_private_key.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClientCertificateResponder_ContinueWithCertificate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->x509_certificate)::BaseType::BufferWriter
      x509_certificate_writer;
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
      in_x509_certificate, buffer, &x509_certificate_writer, &serialization_context);
  params->x509_certificate.Set(
      x509_certificate_writer.is_null() ? nullptr : x509_certificate_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->x509_certificate.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null x509_certificate in ClientCertificateResponder.ContinueWithCertificate request");
  typename decltype(params->provider_name)::BaseType::BufferWriter
      provider_name_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_provider_name, buffer, &provider_name_writer, &serialization_context);
  params->provider_name.Set(
      provider_name_writer.is_null() ? nullptr : provider_name_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->provider_name.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null provider_name in ClientCertificateResponder.ContinueWithCertificate request");
  typename decltype(params->algorithm_preferences)::BaseType::BufferWriter
      algorithm_preferences_writer;
  const mojo::internal::ContainerValidateParams algorithm_preferences_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint16_t>>(
      in_algorithm_preferences, buffer, &algorithm_preferences_writer, &algorithm_preferences_validate_params,
      &serialization_context);
  params->algorithm_preferences.Set(
      algorithm_preferences_writer.is_null() ? nullptr : algorithm_preferences_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->algorithm_preferences.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null algorithm_preferences in ClientCertificateResponder.ContinueWithCertificate request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SSLPrivateKeyInterfaceBase>>(
      in_ssl_private_key, &params->ssl_private_key, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->ssl_private_key),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid ssl_private_key in ClientCertificateResponder.ContinueWithCertificate request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientCertificateResponder::Name_);
  message.set_method_name("ContinueWithCertificate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ClientCertificateResponderProxy::ContinueWithoutCertificate(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::ClientCertificateResponder::ContinueWithoutCertificate");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClientCertificateResponder_ContinueWithoutCertificate_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientCertificateResponder::Name_);
  message.set_method_name("ContinueWithoutCertificate");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ClientCertificateResponderProxy::CancelRequest(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::ClientCertificateResponder::CancelRequest");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kClientCertificateResponder_CancelRequest_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::ClientCertificateResponder_CancelRequest_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ClientCertificateResponder::Name_);
  message.set_method_name("CancelRequest");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ClientCertificateResponderStubDispatch::Accept(
    ClientCertificateResponder* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kClientCertificateResponder_ContinueWithCertificate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ClientCertificateResponder::ContinueWithCertificate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ClientCertificateResponder::ContinueWithCertificate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data* params =
          reinterpret_cast<internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<::net::X509Certificate> p_x509_certificate{};
      std::string p_provider_name{};
      std::vector<uint16_t> p_algorithm_preferences{};
      ::mojo::PendingRemote<SSLPrivateKey> p_ssl_private_key{};
      ClientCertificateResponder_ContinueWithCertificate_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadX509Certificate(&p_x509_certificate))
        success = false;
      if (success && !input_data_view.ReadProviderName(&p_provider_name))
        success = false;
      if (success && !input_data_view.ReadAlgorithmPreferences(&p_algorithm_preferences))
        success = false;
      if (success) {
        p_ssl_private_key =
            input_data_view.TakeSslPrivateKey<decltype(p_ssl_private_key)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientCertificateResponder::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContinueWithCertificate(
std::move(p_x509_certificate), 
std::move(p_provider_name), 
std::move(p_algorithm_preferences), 
std::move(p_ssl_private_key));
      return true;
    }
    case internal::kClientCertificateResponder_ContinueWithoutCertificate_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ClientCertificateResponder::ContinueWithoutCertificate",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ClientCertificateResponder::ContinueWithoutCertificate");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data* params =
          reinterpret_cast<internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ClientCertificateResponder_ContinueWithoutCertificate_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientCertificateResponder::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ContinueWithoutCertificate();
      return true;
    }
    case internal::kClientCertificateResponder_CancelRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::ClientCertificateResponder::CancelRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::ClientCertificateResponder::CancelRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ClientCertificateResponder_CancelRequest_Params_Data* params =
          reinterpret_cast<internal::ClientCertificateResponder_CancelRequest_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ClientCertificateResponder_CancelRequest_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ClientCertificateResponder::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CancelRequest();
      return true;
    }
  }
  return false;
}

// static
bool ClientCertificateResponderStubDispatch::AcceptWithResponder(
    ClientCertificateResponder* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kClientCertificateResponder_ContinueWithCertificate_Name: {
      break;
    }
    case internal::kClientCertificateResponder_ContinueWithoutCertificate_Name: {
      break;
    }
    case internal::kClientCertificateResponder_CancelRequest_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kClientCertificateResponderValidationInfo[] = {
    {internal::kClientCertificateResponder_ContinueWithCertificate_Name,
     {&internal::ClientCertificateResponder_ContinueWithCertificate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kClientCertificateResponder_ContinueWithoutCertificate_Name,
     {&internal::ClientCertificateResponder_ContinueWithoutCertificate_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kClientCertificateResponder_CancelRequest_Name,
     {&internal::ClientCertificateResponder_CancelRequest_Params_Data::Validate,
      nullptr /* no response */}},
};

bool ClientCertificateResponderRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::ClientCertificateResponder::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kClientCertificateResponderValidationInfo);
}

const char SSLPrivateKey::Name_[] = "network.mojom.SSLPrivateKey";

class SSLPrivateKey_Sign_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  SSLPrivateKey_Sign_ForwardToCallback(
      SSLPrivateKey::SignCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  SSLPrivateKey::SignCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(SSLPrivateKey_Sign_ForwardToCallback);
};

SSLPrivateKeyProxy::SSLPrivateKeyProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void SSLPrivateKeyProxy::Sign(
    uint16_t in_algorithm, const std::vector<uint8_t>& in_input, SignCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::SSLPrivateKey::Sign", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("algorithm", in_algorithm);
      raw_value->BeginArray("input");
      for (const auto& item0 : in_input) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSSLPrivateKey_Sign_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::SSLPrivateKey_Sign_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->algorithm = in_algorithm;
  typename decltype(params->input)::BaseType::BufferWriter
      input_writer;
  const mojo::internal::ContainerValidateParams input_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_input, buffer, &input_writer, &input_validate_params,
      &serialization_context);
  params->input.Set(
      input_writer.is_null() ? nullptr : input_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->input.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null input in SSLPrivateKey.Sign request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SSLPrivateKey::Name_);
  message.set_method_name("Sign");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new SSLPrivateKey_Sign_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class SSLPrivateKey_Sign_ProxyToResponder {
 public:
  static SSLPrivateKey::SignCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<SSLPrivateKey_Sign_ProxyToResponder> proxy(
        new SSLPrivateKey_Sign_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&SSLPrivateKey_Sign_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~SSLPrivateKey_Sign_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  SSLPrivateKey_Sign_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "SSLPrivateKey::SignCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, const std::vector<uint8_t>& in_signature);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(SSLPrivateKey_Sign_ProxyToResponder);
};

bool SSLPrivateKey_Sign_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::SSLPrivateKey::SignCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::SSLPrivateKey_Sign_ResponseParams_Data* params =
      reinterpret_cast<
          internal::SSLPrivateKey_Sign_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_net_error{};
  std::vector<uint8_t> p_signature{};
  SSLPrivateKey_Sign_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success && !input_data_view.ReadSignature(&p_signature))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        SSLPrivateKey::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_signature));
  return true;
}

void SSLPrivateKey_Sign_ProxyToResponder::Run(
    int32_t in_net_error, const std::vector<uint8_t>& in_signature) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::SSLPrivateKey::SignCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("net_error", in_net_error);
      raw_value->BeginArray("signature");
      for (const auto& item0 : in_signature) {
        raw_value->AppendInteger(item0);
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kSSLPrivateKey_Sign_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::SSLPrivateKey_Sign_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->net_error = in_net_error;
  typename decltype(params->signature)::BaseType::BufferWriter
      signature_writer;
  const mojo::internal::ContainerValidateParams signature_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<uint8_t>>(
      in_signature, buffer, &signature_writer, &signature_validate_params,
      &serialization_context);
  params->signature.Set(
      signature_writer.is_null() ? nullptr : signature_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->signature.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null signature in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::SSLPrivateKey::SignCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(SSLPrivateKey::Name_);
  message.set_method_name("Sign");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool SSLPrivateKeyStubDispatch::Accept(
    SSLPrivateKey* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kSSLPrivateKey_Sign_Name: {
      break;
    }
  }
  return false;
}

// static
bool SSLPrivateKeyStubDispatch::AcceptWithResponder(
    SSLPrivateKey* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kSSLPrivateKey_Sign_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::SSLPrivateKey::Sign",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::SSLPrivateKey::Sign");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::SSLPrivateKey_Sign_Params_Data* params =
          reinterpret_cast<
              internal::SSLPrivateKey_Sign_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      uint16_t p_algorithm{};
      std::vector<uint8_t> p_input{};
      SSLPrivateKey_Sign_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_algorithm = input_data_view.algorithm();
      if (success && !input_data_view.ReadInput(&p_input))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            SSLPrivateKey::Name_, 0, false);
        return false;
      }
      SSLPrivateKey::SignCallback callback =
          SSLPrivateKey_Sign_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Sign(
std::move(p_algorithm), 
std::move(p_input), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kSSLPrivateKeyValidationInfo[] = {
    {internal::kSSLPrivateKey_Sign_Name,
     {&internal::SSLPrivateKey_Sign_Params_Data::Validate,
      &internal::SSLPrivateKey_Sign_ResponseParams_Data::Validate}},
};

bool SSLPrivateKeyRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::SSLPrivateKey::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kSSLPrivateKeyValidationInfo);
}

bool SSLPrivateKeyResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::SSLPrivateKey::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kSSLPrivateKeyValidationInfo);

}
const char NetworkContextClient::Name_[] = "network.mojom.NetworkContextClient";

class NetworkContextClient_OnSSLCertificateError_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContextClient_OnSSLCertificateError_ForwardToCallback(
      NetworkContextClient::OnSSLCertificateErrorCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContextClient::OnSSLCertificateErrorCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContextClient_OnSSLCertificateError_ForwardToCallback);
};

class NetworkContextClient_OnFileUploadRequested_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContextClient_OnFileUploadRequested_ForwardToCallback(
      NetworkContextClient::OnFileUploadRequestedCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContextClient::OnFileUploadRequestedCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContextClient_OnFileUploadRequested_ForwardToCallback);
};

class NetworkContextClient_OnCanSendReportingReports_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContextClient_OnCanSendReportingReports_ForwardToCallback(
      NetworkContextClient::OnCanSendReportingReportsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContextClient::OnCanSendReportingReportsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContextClient_OnCanSendReportingReports_ForwardToCallback);
};

class NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback(
      NetworkContextClient::OnCanSendDomainReliabilityUploadCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContextClient::OnCanSendDomainReliabilityUploadCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback);
};

class NetworkContextClient_OnClearSiteData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContextClient_OnClearSiteData_ForwardToCallback(
      NetworkContextClient::OnClearSiteDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContextClient::OnClearSiteDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContextClient_OnClearSiteData_ForwardToCallback);
};

NetworkContextClientProxy::NetworkContextClientProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkContextClientProxy::OnAuthRequired(
    const base::Optional<::base::UnguessableToken>& in_window_id, int32_t in_process_id, int32_t in_routing_id, uint32_t in_request_id, const ::GURL& in_url, bool in_first_auth_attempt, const ::net::AuthChallengeInfo& in_auth_info, ::network::mojom::URLResponseHeadPtr in_head, ::mojo::PendingRemote<AuthChallengeResponder> in_auth_challenge_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContextClient::OnAuthRequired", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("window_id", base::trace_event::ValueToString(in_window_id, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      raw_value->SetInteger("process_id", in_process_id);
      raw_value->SetInteger("routing_id", in_routing_id);
      raw_value->SetString("request_id", base::NumberToString(in_request_id));
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetBoolean("first_auth_attempt", in_first_auth_attempt);
      raw_value->SetString("auth_info", base::trace_event::ValueToString(in_auth_info, "<value of type const ::net::AuthChallengeInfo&>"));
      if (in_head.is_null()) {
        raw_value->SetString("head", "nullptr");
      } else {
        raw_value->BeginDictionary("head");
        in_head->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("auth_challenge_responder", in_auth_challenge_responder.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnAuthRequired_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnAuthRequired_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->window_id)::BaseType::BufferWriter
      window_id_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_window_id, buffer, &window_id_writer, &serialization_context);
  params->window_id.Set(
      window_id_writer.is_null() ? nullptr : window_id_writer.data());
  params->process_id = in_process_id;
  params->routing_id = in_routing_id;
  params->request_id = in_request_id;
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContextClient.OnAuthRequired request");
  params->first_auth_attempt = in_first_auth_attempt;
  typename decltype(params->auth_info)::BaseType::BufferWriter
      auth_info_writer;
  mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView>(
      in_auth_info, buffer, &auth_info_writer, &serialization_context);
  params->auth_info.Set(
      auth_info_writer.is_null() ? nullptr : auth_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->auth_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null auth_info in NetworkContextClient.OnAuthRequired request");
  typename decltype(params->head)::BaseType::BufferWriter
      head_writer;
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_head, buffer, &head_writer, &serialization_context);
  params->head.Set(
      head_writer.is_null() ? nullptr : head_writer.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::AuthChallengeResponderInterfaceBase>>(
      in_auth_challenge_responder, &params->auth_challenge_responder, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->auth_challenge_responder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid auth_challenge_responder in NetworkContextClient.OnAuthRequired request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnAuthRequired");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextClientProxy::OnCertificateRequested(
    const base::Optional<::base::UnguessableToken>& in_window_id, int32_t in_process_id, int32_t in_routing_id, uint32_t in_request_id, const ::scoped_refptr<::net::SSLCertRequestInfo>& in_cert_info, ::mojo::PendingRemote<ClientCertificateResponder> in_cert_responder) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContextClient::OnCertificateRequested", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("window_id", base::trace_event::ValueToString(in_window_id, "<value of type const base::Optional<::base::UnguessableToken>&>"));
      raw_value->SetInteger("process_id", in_process_id);
      raw_value->SetInteger("routing_id", in_routing_id);
      raw_value->SetString("request_id", base::NumberToString(in_request_id));
      raw_value->SetString("cert_info", base::trace_event::ValueToString(in_cert_info, "<value of type const ::scoped_refptr<::net::SSLCertRequestInfo>&>"));
      raw_value->SetBoolean("cert_responder", in_cert_responder.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnCertificateRequested_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnCertificateRequested_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->window_id)::BaseType::BufferWriter
      window_id_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_window_id, buffer, &window_id_writer, &serialization_context);
  params->window_id.Set(
      window_id_writer.is_null() ? nullptr : window_id_writer.data());
  params->process_id = in_process_id;
  params->routing_id = in_routing_id;
  params->request_id = in_request_id;
  typename decltype(params->cert_info)::BaseType::BufferWriter
      cert_info_writer;
  mojo::internal::Serialize<::network::mojom::SSLCertRequestInfoDataView>(
      in_cert_info, buffer, &cert_info_writer, &serialization_context);
  params->cert_info.Set(
      cert_info_writer.is_null() ? nullptr : cert_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cert_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cert_info in NetworkContextClient.OnCertificateRequested request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ClientCertificateResponderInterfaceBase>>(
      in_cert_responder, &params->cert_responder, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->cert_responder),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid cert_responder in NetworkContextClient.OnCertificateRequested request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnCertificateRequested");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextClientProxy::OnSSLCertificateError(
    int32_t in_process_id, int32_t in_routing_id, const ::GURL& in_url, int32_t in_net_error, const ::net::SSLInfo& in_ssl_info, bool in_fatal, OnSSLCertificateErrorCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContextClient::OnSSLCertificateError", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("process_id", in_process_id);
      raw_value->SetInteger("routing_id", in_routing_id);
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetInteger("net_error", in_net_error);
      raw_value->SetString("ssl_info", base::trace_event::ValueToString(in_ssl_info, "<value of type const ::net::SSLInfo&>"));
      raw_value->SetBoolean("fatal", in_fatal);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnSSLCertificateError_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnSSLCertificateError_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->process_id = in_process_id;
  params->routing_id = in_routing_id;
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContextClient.OnSSLCertificateError request");
  params->net_error = in_net_error;
  typename decltype(params->ssl_info)::BaseType::BufferWriter
      ssl_info_writer;
  mojo::internal::Serialize<::network::mojom::SSLInfoDataView>(
      in_ssl_info, buffer, &ssl_info_writer, &serialization_context);
  params->ssl_info.Set(
      ssl_info_writer.is_null() ? nullptr : ssl_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ssl_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ssl_info in NetworkContextClient.OnSSLCertificateError request");
  params->fatal = in_fatal;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnSSLCertificateError");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContextClient_OnSSLCertificateError_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextClientProxy::OnFileUploadRequested(
    int32_t in_process_id, bool in_async, const std::vector<::base::FilePath>& in_file_paths, OnFileUploadRequestedCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContextClient::OnFileUploadRequested", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("process_id", in_process_id);
      raw_value->SetBoolean("async", in_async);
      raw_value->BeginArray("file_paths");
      for (const auto& item0 : in_file_paths) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::base::FilePath&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnFileUploadRequested_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnFileUploadRequested_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->process_id = in_process_id;
  params->async = in_async;
  typename decltype(params->file_paths)::BaseType::BufferWriter
      file_paths_writer;
  const mojo::internal::ContainerValidateParams file_paths_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FilePathDataView>>(
      in_file_paths, buffer, &file_paths_writer, &file_paths_validate_params,
      &serialization_context);
  params->file_paths.Set(
      file_paths_writer.is_null() ? nullptr : file_paths_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->file_paths.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null file_paths in NetworkContextClient.OnFileUploadRequested request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnFileUploadRequested");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContextClient_OnFileUploadRequested_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextClientProxy::OnCanSendReportingReports(
    const std::vector<::url::Origin>& in_origins, OnCanSendReportingReportsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContextClient::OnCanSendReportingReports", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("origins");
      for (const auto& item0 : in_origins) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::url::Origin&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnCanSendReportingReports_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnCanSendReportingReports_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origins)::BaseType::BufferWriter
      origins_writer;
  const mojo::internal::ContainerValidateParams origins_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
      in_origins, buffer, &origins_writer, &origins_validate_params,
      &serialization_context);
  params->origins.Set(
      origins_writer.is_null() ? nullptr : origins_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origins.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origins in NetworkContextClient.OnCanSendReportingReports request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnCanSendReportingReports");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContextClient_OnCanSendReportingReports_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextClientProxy::OnCanSendDomainReliabilityUpload(
    const ::GURL& in_origin, OnCanSendDomainReliabilityUploadCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContextClient::OnCanSendDomainReliabilityUpload", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::GURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnCanSendDomainReliabilityUpload_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in NetworkContextClient.OnCanSendDomainReliabilityUpload request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnCanSendDomainReliabilityUpload");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextClientProxy::OnClearSiteData(
    int32_t in_process_id, int32_t in_routing_id, const ::GURL& in_url, const std::string& in_header_value, int32_t in_load_flags, OnClearSiteDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContextClient::OnClearSiteData", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("process_id", in_process_id);
      raw_value->SetInteger("routing_id", in_routing_id);
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("header_value", in_header_value);
      raw_value->SetInteger("load_flags", in_load_flags);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnClearSiteData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnClearSiteData_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->process_id = in_process_id;
  params->routing_id = in_routing_id;
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContextClient.OnClearSiteData request");
  typename decltype(params->header_value)::BaseType::BufferWriter
      header_value_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_header_value, buffer, &header_value_writer, &serialization_context);
  params->header_value.Set(
      header_value_writer.is_null() ? nullptr : header_value_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->header_value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null header_value in NetworkContextClient.OnClearSiteData request");
  params->load_flags = in_load_flags;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnClearSiteData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContextClient_OnClearSiteData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class NetworkContextClient_OnSSLCertificateError_ProxyToResponder {
 public:
  static NetworkContextClient::OnSSLCertificateErrorCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContextClient_OnSSLCertificateError_ProxyToResponder> proxy(
        new NetworkContextClient_OnSSLCertificateError_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContextClient_OnSSLCertificateError_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContextClient_OnSSLCertificateError_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContextClient_OnSSLCertificateError_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContextClient::OnSSLCertificateErrorCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContextClient_OnSSLCertificateError_ProxyToResponder);
};

bool NetworkContextClient_OnSSLCertificateError_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContextClient::OnSSLCertificateErrorCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContextClient_OnSSLCertificateError_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContextClient_OnSSLCertificateError_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_net_error{};
  NetworkContextClient_OnSSLCertificateError_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContextClient::Name_, 2, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error));
  return true;
}

void NetworkContextClient_OnSSLCertificateError_ProxyToResponder::Run(
    int32_t in_net_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContextClient::OnSSLCertificateErrorCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("net_error", in_net_error);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnSSLCertificateError_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnSSLCertificateError_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->net_error = in_net_error;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContextClient::OnSSLCertificateErrorCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnSSLCertificateError");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContextClient_OnFileUploadRequested_ProxyToResponder {
 public:
  static NetworkContextClient::OnFileUploadRequestedCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContextClient_OnFileUploadRequested_ProxyToResponder> proxy(
        new NetworkContextClient_OnFileUploadRequested_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContextClient_OnFileUploadRequested_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContextClient_OnFileUploadRequested_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContextClient_OnFileUploadRequested_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContextClient::OnFileUploadRequestedCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_net_error, std::vector<::base::File> in_files);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContextClient_OnFileUploadRequested_ProxyToResponder);
};

bool NetworkContextClient_OnFileUploadRequested_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContextClient::OnFileUploadRequestedCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContextClient_OnFileUploadRequested_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContextClient_OnFileUploadRequested_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_net_error{};
  std::vector<::base::File> p_files{};
  NetworkContextClient_OnFileUploadRequested_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_net_error = input_data_view.net_error();
  if (success && !input_data_view.ReadFiles(&p_files))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContextClient::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_net_error), 
std::move(p_files));
  return true;
}

void NetworkContextClient_OnFileUploadRequested_ProxyToResponder::Run(
    int32_t in_net_error, std::vector<::base::File> in_files) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContextClient::OnFileUploadRequestedCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("net_error", in_net_error);
      raw_value->BeginArray("files");
      for (const auto& item0 : in_files) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type ::base::File>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnFileUploadRequested_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnFileUploadRequested_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->net_error = in_net_error;
  typename decltype(params->files)::BaseType::BufferWriter
      files_writer;
  const mojo::internal::ContainerValidateParams files_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::mojo_base::mojom::FileDataView>>(
      in_files, buffer, &files_writer, &files_validate_params,
      &serialization_context);
  params->files.Set(
      files_writer.is_null() ? nullptr : files_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->files.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null files in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContextClient::OnFileUploadRequestedCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnFileUploadRequested");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContextClient_OnCanSendReportingReports_ProxyToResponder {
 public:
  static NetworkContextClient::OnCanSendReportingReportsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContextClient_OnCanSendReportingReports_ProxyToResponder> proxy(
        new NetworkContextClient_OnCanSendReportingReports_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContextClient_OnCanSendReportingReports_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContextClient_OnCanSendReportingReports_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContextClient_OnCanSendReportingReports_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContextClient::OnCanSendReportingReportsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const std::vector<::url::Origin>& in_origins);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContextClient_OnCanSendReportingReports_ProxyToResponder);
};

bool NetworkContextClient_OnCanSendReportingReports_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContextClient::OnCanSendReportingReportsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContextClient_OnCanSendReportingReports_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContextClient_OnCanSendReportingReports_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  std::vector<::url::Origin> p_origins{};
  NetworkContextClient_OnCanSendReportingReports_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadOrigins(&p_origins))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContextClient::Name_, 4, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_origins));
  return true;
}

void NetworkContextClient_OnCanSendReportingReports_ProxyToResponder::Run(
    const std::vector<::url::Origin>& in_origins) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContextClient::OnCanSendReportingReportsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->BeginArray("origins");
      for (const auto& item0 : in_origins) {
        raw_value->AppendString(base::trace_event::ValueToString(item0, "<value of type const ::url::Origin&>"));
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnCanSendReportingReports_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnCanSendReportingReports_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origins)::BaseType::BufferWriter
      origins_writer;
  const mojo::internal::ContainerValidateParams origins_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
      in_origins, buffer, &origins_writer, &origins_validate_params,
      &serialization_context);
  params->origins.Set(
      origins_writer.is_null() ? nullptr : origins_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origins.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origins in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContextClient::OnCanSendReportingReportsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnCanSendReportingReports");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder {
 public:
  static NetworkContextClient::OnCanSendDomainReliabilityUploadCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder> proxy(
        new NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContextClient::OnCanSendDomainReliabilityUploadCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_allowed);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder);
};

bool NetworkContextClient_OnCanSendDomainReliabilityUpload_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContextClient::OnCanSendDomainReliabilityUploadCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_allowed{};
  NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_allowed = input_data_view.allowed();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContextClient::Name_, 5, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_allowed));
  return true;
}

void NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder::Run(
    bool in_allowed) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContextClient::OnCanSendDomainReliabilityUploadCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("allowed", in_allowed);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnCanSendDomainReliabilityUpload_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->allowed = in_allowed;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContextClient::OnCanSendDomainReliabilityUploadCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnCanSendDomainReliabilityUpload");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContextClient_OnClearSiteData_ProxyToResponder {
 public:
  static NetworkContextClient::OnClearSiteDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContextClient_OnClearSiteData_ProxyToResponder> proxy(
        new NetworkContextClient_OnClearSiteData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContextClient_OnClearSiteData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContextClient_OnClearSiteData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContextClient_OnClearSiteData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContextClient::OnClearSiteDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContextClient_OnClearSiteData_ProxyToResponder);
};

bool NetworkContextClient_OnClearSiteData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContextClient::OnClearSiteDataCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContextClient_OnClearSiteData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContextClient_OnClearSiteData_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContextClient_OnClearSiteData_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContextClient::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContextClient_OnClearSiteData_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContextClient::OnClearSiteDataCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContextClient_OnClearSiteData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContextClient_OnClearSiteData_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContextClient::OnClearSiteDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContextClient::Name_);
  message.set_method_name("OnClearSiteData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool NetworkContextClientStubDispatch::Accept(
    NetworkContextClient* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNetworkContextClient_OnAuthRequired_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContextClient::OnAuthRequired",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContextClient::OnAuthRequired");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContextClient_OnAuthRequired_Params_Data* params =
          reinterpret_cast<internal::NetworkContextClient_OnAuthRequired_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::base::UnguessableToken> p_window_id{};
      int32_t p_process_id{};
      int32_t p_routing_id{};
      uint32_t p_request_id{};
      ::GURL p_url{};
      bool p_first_auth_attempt{};
      ::net::AuthChallengeInfo p_auth_info{};
      ::network::mojom::URLResponseHeadPtr p_head{};
      ::mojo::PendingRemote<AuthChallengeResponder> p_auth_challenge_responder{};
      NetworkContextClient_OnAuthRequired_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadWindowId(&p_window_id))
        success = false;
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_first_auth_attempt = input_data_view.first_auth_attempt();
      if (success && !input_data_view.ReadAuthInfo(&p_auth_info))
        success = false;
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (success) {
        p_auth_challenge_responder =
            input_data_view.TakeAuthChallengeResponder<decltype(p_auth_challenge_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnAuthRequired(
std::move(p_window_id), 
std::move(p_process_id), 
std::move(p_routing_id), 
std::move(p_request_id), 
std::move(p_url), 
std::move(p_first_auth_attempt), 
std::move(p_auth_info), 
std::move(p_head), 
std::move(p_auth_challenge_responder));
      return true;
    }
    case internal::kNetworkContextClient_OnCertificateRequested_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContextClient::OnCertificateRequested",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContextClient::OnCertificateRequested");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContextClient_OnCertificateRequested_Params_Data* params =
          reinterpret_cast<internal::NetworkContextClient_OnCertificateRequested_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::base::UnguessableToken> p_window_id{};
      int32_t p_process_id{};
      int32_t p_routing_id{};
      uint32_t p_request_id{};
      ::scoped_refptr<::net::SSLCertRequestInfo> p_cert_info{};
      ::mojo::PendingRemote<ClientCertificateResponder> p_cert_responder{};
      NetworkContextClient_OnCertificateRequested_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadWindowId(&p_window_id))
        success = false;
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success)
        p_request_id = input_data_view.request_id();
      if (success && !input_data_view.ReadCertInfo(&p_cert_info))
        success = false;
      if (success) {
        p_cert_responder =
            input_data_view.TakeCertResponder<decltype(p_cert_responder)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCertificateRequested(
std::move(p_window_id), 
std::move(p_process_id), 
std::move(p_routing_id), 
std::move(p_request_id), 
std::move(p_cert_info), 
std::move(p_cert_responder));
      return true;
    }
    case internal::kNetworkContextClient_OnSSLCertificateError_Name: {
      break;
    }
    case internal::kNetworkContextClient_OnFileUploadRequested_Name: {
      break;
    }
    case internal::kNetworkContextClient_OnCanSendReportingReports_Name: {
      break;
    }
    case internal::kNetworkContextClient_OnCanSendDomainReliabilityUpload_Name: {
      break;
    }
    case internal::kNetworkContextClient_OnClearSiteData_Name: {
      break;
    }
  }
  return false;
}

// static
bool NetworkContextClientStubDispatch::AcceptWithResponder(
    NetworkContextClient* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetworkContextClient_OnAuthRequired_Name: {
      break;
    }
    case internal::kNetworkContextClient_OnCertificateRequested_Name: {
      break;
    }
    case internal::kNetworkContextClient_OnSSLCertificateError_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContextClient::OnSSLCertificateError",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContextClient::OnSSLCertificateError");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContextClient_OnSSLCertificateError_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContextClient_OnSSLCertificateError_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      int32_t p_routing_id{};
      ::GURL p_url{};
      int32_t p_net_error{};
      ::net::SSLInfo p_ssl_info{};
      bool p_fatal{};
      NetworkContextClient_OnSSLCertificateError_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_net_error = input_data_view.net_error();
      if (success && !input_data_view.ReadSslInfo(&p_ssl_info))
        success = false;
      if (success)
        p_fatal = input_data_view.fatal();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 2, false);
        return false;
      }
      NetworkContextClient::OnSSLCertificateErrorCallback callback =
          NetworkContextClient_OnSSLCertificateError_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnSSLCertificateError(
std::move(p_process_id), 
std::move(p_routing_id), 
std::move(p_url), 
std::move(p_net_error), 
std::move(p_ssl_info), 
std::move(p_fatal), std::move(callback));
      return true;
    }
    case internal::kNetworkContextClient_OnFileUploadRequested_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContextClient::OnFileUploadRequested",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContextClient::OnFileUploadRequested");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContextClient_OnFileUploadRequested_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContextClient_OnFileUploadRequested_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      bool p_async{};
      std::vector<::base::FilePath> p_file_paths{};
      NetworkContextClient_OnFileUploadRequested_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_async = input_data_view.async();
      if (success && !input_data_view.ReadFilePaths(&p_file_paths))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 3, false);
        return false;
      }
      NetworkContextClient::OnFileUploadRequestedCallback callback =
          NetworkContextClient_OnFileUploadRequested_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnFileUploadRequested(
std::move(p_process_id), 
std::move(p_async), 
std::move(p_file_paths), std::move(callback));
      return true;
    }
    case internal::kNetworkContextClient_OnCanSendReportingReports_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContextClient::OnCanSendReportingReports",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContextClient::OnCanSendReportingReports");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContextClient_OnCanSendReportingReports_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContextClient_OnCanSendReportingReports_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::vector<::url::Origin> p_origins{};
      NetworkContextClient_OnCanSendReportingReports_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigins(&p_origins))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 4, false);
        return false;
      }
      NetworkContextClient::OnCanSendReportingReportsCallback callback =
          NetworkContextClient_OnCanSendReportingReports_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCanSendReportingReports(
std::move(p_origins), std::move(callback));
      return true;
    }
    case internal::kNetworkContextClient_OnCanSendDomainReliabilityUpload_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContextClient::OnCanSendDomainReliabilityUpload",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContextClient::OnCanSendDomainReliabilityUpload");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_origin{};
      NetworkContextClient_OnCanSendDomainReliabilityUpload_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 5, false);
        return false;
      }
      NetworkContextClient::OnCanSendDomainReliabilityUploadCallback callback =
          NetworkContextClient_OnCanSendDomainReliabilityUpload_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnCanSendDomainReliabilityUpload(
std::move(p_origin), std::move(callback));
      return true;
    }
    case internal::kNetworkContextClient_OnClearSiteData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContextClient::OnClearSiteData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContextClient::OnClearSiteData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContextClient_OnClearSiteData_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContextClient_OnClearSiteData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      int32_t p_process_id{};
      int32_t p_routing_id{};
      ::GURL p_url{};
      std::string p_header_value{};
      int32_t p_load_flags{};
      NetworkContextClient_OnClearSiteData_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_routing_id = input_data_view.routing_id();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHeaderValue(&p_header_value))
        success = false;
      if (success)
        p_load_flags = input_data_view.load_flags();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContextClient::Name_, 6, false);
        return false;
      }
      NetworkContextClient::OnClearSiteDataCallback callback =
          NetworkContextClient_OnClearSiteData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->OnClearSiteData(
std::move(p_process_id), 
std::move(p_routing_id), 
std::move(p_url), 
std::move(p_header_value), 
std::move(p_load_flags), std::move(callback));
      return true;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkContextClientValidationInfo[] = {
    {internal::kNetworkContextClient_OnAuthRequired_Name,
     {&internal::NetworkContextClient_OnAuthRequired_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContextClient_OnCertificateRequested_Name,
     {&internal::NetworkContextClient_OnCertificateRequested_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContextClient_OnSSLCertificateError_Name,
     {&internal::NetworkContextClient_OnSSLCertificateError_Params_Data::Validate,
      &internal::NetworkContextClient_OnSSLCertificateError_ResponseParams_Data::Validate}},
    {internal::kNetworkContextClient_OnFileUploadRequested_Name,
     {&internal::NetworkContextClient_OnFileUploadRequested_Params_Data::Validate,
      &internal::NetworkContextClient_OnFileUploadRequested_ResponseParams_Data::Validate}},
    {internal::kNetworkContextClient_OnCanSendReportingReports_Name,
     {&internal::NetworkContextClient_OnCanSendReportingReports_Params_Data::Validate,
      &internal::NetworkContextClient_OnCanSendReportingReports_ResponseParams_Data::Validate}},
    {internal::kNetworkContextClient_OnCanSendDomainReliabilityUpload_Name,
     {&internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_Params_Data::Validate,
      &internal::NetworkContextClient_OnCanSendDomainReliabilityUpload_ResponseParams_Data::Validate}},
    {internal::kNetworkContextClient_OnClearSiteData_Name,
     {&internal::NetworkContextClient_OnClearSiteData_Params_Data::Validate,
      &internal::NetworkContextClient_OnClearSiteData_ResponseParams_Data::Validate}},
};

bool NetworkContextClientRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkContextClient::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetworkContextClientValidationInfo);
}

bool NetworkContextClientResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkContextClient::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNetworkContextClientValidationInfo);

}
const char NetworkContext::Name_[] = "network.mojom.NetworkContext";
bool NetworkContext::EnableStaticKeyPinningForTesting() {
  NOTREACHED();
  return false;
}
bool NetworkContext::VerifyCertificateForTesting(const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list, int32_t* out_error_code) {
  NOTREACHED();
  return false;
}
bool NetworkContext::AddDomainReliabilityContextForTesting(const ::GURL& origin, const ::GURL& upload_url) {
  NOTREACHED();
  return false;
}
bool NetworkContext::ForceDomainReliabilityUploadsForTesting() {
  NOTREACHED();
  return false;
}

class NetworkContext_ClearTrustTokenData_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearTrustTokenData_ForwardToCallback(
      NetworkContext::ClearTrustTokenDataCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearTrustTokenDataCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearTrustTokenData_ForwardToCallback);
};

class NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback(
      NetworkContext::ClearNetworkingHistoryBetweenCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearNetworkingHistoryBetweenCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback);
};

class NetworkContext_ClearHttpCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearHttpCache_ForwardToCallback(
      NetworkContext::ClearHttpCacheCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearHttpCacheCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearHttpCache_ForwardToCallback);
};

class NetworkContext_ComputeHttpCacheSize_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ComputeHttpCacheSize_ForwardToCallback(
      NetworkContext::ComputeHttpCacheSizeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ComputeHttpCacheSizeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ComputeHttpCacheSize_ForwardToCallback);
};

class NetworkContext_ClearHostCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearHostCache_ForwardToCallback(
      NetworkContext::ClearHostCacheCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearHostCacheCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearHostCache_ForwardToCallback);
};

class NetworkContext_ClearHttpAuthCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearHttpAuthCache_ForwardToCallback(
      NetworkContext::ClearHttpAuthCacheCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearHttpAuthCacheCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearHttpAuthCache_ForwardToCallback);
};

class NetworkContext_ClearReportingCacheReports_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearReportingCacheReports_ForwardToCallback(
      NetworkContext::ClearReportingCacheReportsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearReportingCacheReportsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearReportingCacheReports_ForwardToCallback);
};

class NetworkContext_ClearReportingCacheClients_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearReportingCacheClients_ForwardToCallback(
      NetworkContext::ClearReportingCacheClientsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearReportingCacheClientsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearReportingCacheClients_ForwardToCallback);
};

class NetworkContext_ClearNetworkErrorLogging_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearNetworkErrorLogging_ForwardToCallback(
      NetworkContext::ClearNetworkErrorLoggingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearNetworkErrorLoggingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearNetworkErrorLogging_ForwardToCallback);
};

class NetworkContext_ClearDomainReliability_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearDomainReliability_ForwardToCallback(
      NetworkContext::ClearDomainReliabilityCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearDomainReliabilityCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearDomainReliability_ForwardToCallback);
};

class NetworkContext_GetDomainReliabilityJSON_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetDomainReliabilityJSON_ForwardToCallback(
      NetworkContext::GetDomainReliabilityJSONCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::GetDomainReliabilityJSONCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_GetDomainReliabilityJSON_ForwardToCallback);
};

class NetworkContext_CloseAllConnections_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_CloseAllConnections_ForwardToCallback(
      NetworkContext::CloseAllConnectionsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::CloseAllConnectionsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_CloseAllConnections_ForwardToCallback);
};

class NetworkContext_CloseIdleConnections_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_CloseIdleConnections_ForwardToCallback(
      NetworkContext::CloseIdleConnectionsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::CloseIdleConnectionsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_CloseIdleConnections_ForwardToCallback);
};

class NetworkContext_AddExpectCT_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_AddExpectCT_ForwardToCallback(
      NetworkContext::AddExpectCTCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::AddExpectCTCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_AddExpectCT_ForwardToCallback);
};

class NetworkContext_SetExpectCTTestReport_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_SetExpectCTTestReport_ForwardToCallback(
      NetworkContext::SetExpectCTTestReportCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::SetExpectCTTestReportCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_SetExpectCTTestReport_ForwardToCallback);
};

class NetworkContext_GetExpectCTState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetExpectCTState_ForwardToCallback(
      NetworkContext::GetExpectCTStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::GetExpectCTStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_GetExpectCTState_ForwardToCallback);
};

class NetworkContext_CreateTCPServerSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_CreateTCPServerSocket_ForwardToCallback(
      NetworkContext::CreateTCPServerSocketCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::CreateTCPServerSocketCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_CreateTCPServerSocket_ForwardToCallback);
};

class NetworkContext_CreateTCPConnectedSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_CreateTCPConnectedSocket_ForwardToCallback(
      NetworkContext::CreateTCPConnectedSocketCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::CreateTCPConnectedSocketCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_CreateTCPConnectedSocket_ForwardToCallback);
};

class NetworkContext_CreateTCPBoundSocket_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_CreateTCPBoundSocket_ForwardToCallback(
      NetworkContext::CreateTCPBoundSocketCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::CreateTCPBoundSocketCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_CreateTCPBoundSocket_ForwardToCallback);
};

class NetworkContext_ForceReloadProxyConfig_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ForceReloadProxyConfig_ForwardToCallback(
      NetworkContext::ForceReloadProxyConfigCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ForceReloadProxyConfigCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ForceReloadProxyConfig_ForwardToCallback);
};

class NetworkContext_ClearBadProxiesCache_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ClearBadProxiesCache_ForwardToCallback(
      NetworkContext::ClearBadProxiesCacheCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ClearBadProxiesCacheCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearBadProxiesCache_ForwardToCallback);
};

class NetworkContext_VerifyCertForSignedExchange_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_VerifyCertForSignedExchange_ForwardToCallback(
      NetworkContext::VerifyCertForSignedExchangeCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::VerifyCertForSignedExchangeCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_VerifyCertForSignedExchange_ForwardToCallback);
};

class NetworkContext_ParseHeaders_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ParseHeaders_ForwardToCallback(
      NetworkContext::ParseHeadersCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ParseHeadersCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ParseHeaders_ForwardToCallback);
};

class NetworkContext_AddHSTS_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_AddHSTS_ForwardToCallback(
      NetworkContext::AddHSTSCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::AddHSTSCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_AddHSTS_ForwardToCallback);
};

class NetworkContext_IsHSTSActiveForHost_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_IsHSTSActiveForHost_ForwardToCallback(
      NetworkContext::IsHSTSActiveForHostCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::IsHSTSActiveForHostCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_IsHSTSActiveForHost_ForwardToCallback);
};

class NetworkContext_GetHSTSState_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_GetHSTSState_ForwardToCallback(
      NetworkContext::GetHSTSStateCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::GetHSTSStateCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_GetHSTSState_ForwardToCallback);
};

class NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback(
      NetworkContext::SetCorsOriginAccessListsForOriginCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::SetCorsOriginAccessListsForOriginCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback);
};

class NetworkContext_DeleteDynamicDataForHost_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_DeleteDynamicDataForHost_ForwardToCallback(
      NetworkContext::DeleteDynamicDataForHostCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::DeleteDynamicDataForHostCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_DeleteDynamicDataForHost_ForwardToCallback);
};

class NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback(
      NetworkContext::SaveHttpAuthCacheProxyEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::SaveHttpAuthCacheProxyEntriesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback);
};

class NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback(
      NetworkContext::LoadHttpAuthCacheProxyEntriesCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::LoadHttpAuthCacheProxyEntriesCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback);
};

class NetworkContext_AddAuthCacheEntry_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_AddAuthCacheEntry_ForwardToCallback(
      NetworkContext::AddAuthCacheEntryCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::AddAuthCacheEntryCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_AddAuthCacheEntry_ForwardToCallback);
};

class NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback(
      NetworkContext::LookupServerBasicAuthCredentialsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::LookupServerBasicAuthCredentialsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback);
};
class NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse);
};

class NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback(
      NetworkContext::EnableStaticKeyPinningForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::EnableStaticKeyPinningForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback);
};
class NetworkContext_VerifyCertificateForTesting_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkContext_VerifyCertificateForTesting_HandleSyncResponse(
      bool* result, int32_t* out_error_code)
      : result_(result), out_error_code_(out_error_code) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;
  int32_t* out_error_code_;DISALLOW_COPY_AND_ASSIGN(NetworkContext_VerifyCertificateForTesting_HandleSyncResponse);
};

class NetworkContext_VerifyCertificateForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_VerifyCertificateForTesting_ForwardToCallback(
      NetworkContext::VerifyCertificateForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::VerifyCertificateForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_VerifyCertificateForTesting_ForwardToCallback);
};
class NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse);
};

class NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback(
      NetworkContext::AddDomainReliabilityContextForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::AddDomainReliabilityContextForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback);
};
class NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse(
      bool* result)
      : result_(result) {
    DCHECK(!*result_);
  }
  bool Accept(mojo::Message* message) override;
 private:
  bool* result_;DISALLOW_COPY_AND_ASSIGN(NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse);
};

class NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback(
      NetworkContext::ForceDomainReliabilityUploadsForTestingCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  NetworkContext::ForceDomainReliabilityUploadsForTestingCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback);
};

NetworkContextProxy::NetworkContextProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void NetworkContextProxy::SetClient(
    ::mojo::PendingRemote<NetworkContextClient> in_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::SetClient", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("client", in_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetClient_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetClient_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::NetworkContextClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in NetworkContext.SetClient request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::CreateURLLoaderFactory(
    ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> in_url_loader_factory, URLLoaderFactoryParamsPtr in_params) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateURLLoaderFactory", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("url_loader_factory", in_url_loader_factory.is_valid());
      if (in_params.is_null()) {
        raw_value->SetString("params", "nullptr");
      } else {
        raw_value->BeginDictionary("params");
        in_params->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateURLLoaderFactory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateURLLoaderFactory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::URLLoaderFactoryInterfaceBase>>(
      in_url_loader_factory, &params->url_loader_factory, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->url_loader_factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid url_loader_factory in NetworkContext.CreateURLLoaderFactory request");
  typename decltype(params->params)::BaseType::BufferWriter
      params_writer;
  mojo::internal::Serialize<::network::mojom::URLLoaderFactoryParamsDataView>(
      in_params, buffer, &params_writer, &serialization_context);
  params->params.Set(
      params_writer.is_null() ? nullptr : params_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->params.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null params in NetworkContext.CreateURLLoaderFactory request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateURLLoaderFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::ResetURLLoaderFactories(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkContext::ResetURLLoaderFactories");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ResetURLLoaderFactories_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ResetURLLoaderFactories_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ResetURLLoaderFactories");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::GetCookieManager(
    ::mojo::PendingReceiver<::network::mojom::CookieManager> in_cookie_manager) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::GetCookieManager", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("cookie_manager", in_cookie_manager.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_GetCookieManager_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_GetCookieManager_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::CookieManagerInterfaceBase>>(
      in_cookie_manager, &params->cookie_manager, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->cookie_manager),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid cookie_manager in NetworkContext.GetCookieManager request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetCookieManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::GetRestrictedCookieManager(
    ::mojo::PendingReceiver<::network::mojom::RestrictedCookieManager> in_restricted_cookie_manager, ::network::mojom::RestrictedCookieManagerRole in_role, const ::url::Origin& in_origin, const ::net::SiteForCookies& in_site_for_cookies, const ::url::Origin& in_top_frame_origin, ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> in_cookie_observer) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::GetRestrictedCookieManager", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("restricted_cookie_manager", in_restricted_cookie_manager.is_valid());
      raw_value->SetString("role", base::trace_event::ValueToString(in_role));
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(in_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      raw_value->SetString("top_frame_origin", base::trace_event::ValueToString(in_top_frame_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetBoolean("cookie_observer", in_cookie_observer.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_GetRestrictedCookieManager_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_GetRestrictedCookieManager_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::RestrictedCookieManagerInterfaceBase>>(
      in_restricted_cookie_manager, &params->restricted_cookie_manager, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->restricted_cookie_manager),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid restricted_cookie_manager in NetworkContext.GetRestrictedCookieManager request");
  mojo::internal::Serialize<::network::mojom::RestrictedCookieManagerRole>(
      in_role, &params->role);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in NetworkContext.GetRestrictedCookieManager request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in NetworkContext.GetRestrictedCookieManager request");
  typename decltype(params->top_frame_origin)::BaseType::BufferWriter
      top_frame_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_frame_origin, buffer, &top_frame_origin_writer, &serialization_context);
  params->top_frame_origin.Set(
      top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in NetworkContext.GetRestrictedCookieManager request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::CookieAccessObserverInterfaceBase>>(
      in_cookie_observer, &params->cookie_observer, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetRestrictedCookieManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::GetHasTrustTokensAnswerer(
    ::mojo::PendingReceiver<::network::mojom::HasTrustTokensAnswerer> in_has_trust_tokens_answerer, const ::url::Origin& in_top_frame_origin) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::GetHasTrustTokensAnswerer", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("has_trust_tokens_answerer", in_has_trust_tokens_answerer.is_valid());
      raw_value->SetString("top_frame_origin", base::trace_event::ValueToString(in_top_frame_origin, "<value of type const ::url::Origin&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_GetHasTrustTokensAnswerer_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_GetHasTrustTokensAnswerer_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::HasTrustTokensAnswererInterfaceBase>>(
      in_has_trust_tokens_answerer, &params->has_trust_tokens_answerer, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->has_trust_tokens_answerer),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid has_trust_tokens_answerer in NetworkContext.GetHasTrustTokensAnswerer request");
  typename decltype(params->top_frame_origin)::BaseType::BufferWriter
      top_frame_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_top_frame_origin, buffer, &top_frame_origin_writer, &serialization_context);
  params->top_frame_origin.Set(
      top_frame_origin_writer.is_null() ? nullptr : top_frame_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->top_frame_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null top_frame_origin in NetworkContext.GetHasTrustTokensAnswerer request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetHasTrustTokensAnswerer");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::ClearTrustTokenData(
    ClearDataFilterPtr in_filter, ClearTrustTokenDataCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ClearTrustTokenData", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_filter.is_null()) {
        raw_value->SetString("filter", "nullptr");
      } else {
        raw_value->BeginDictionary("filter");
        in_filter->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearTrustTokenData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearTrustTokenData_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->filter)::BaseType::BufferWriter
      filter_writer;
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
      in_filter, buffer, &filter_writer, &serialization_context);
  params->filter.Set(
      filter_writer.is_null() ? nullptr : filter_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearTrustTokenData");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearTrustTokenData_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::ClearNetworkingHistoryBetween(
    ::base::Time in_start_time, ::base::Time in_end_time, ClearNetworkingHistoryBetweenCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ClearNetworkingHistoryBetween", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("start_time", base::trace_event::ValueToString(in_start_time, "<value of type ::base::Time>"));
      raw_value->SetString("end_time", base::trace_event::ValueToString(in_end_time, "<value of type ::base::Time>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearNetworkingHistoryBetween_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearNetworkingHistoryBetween_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->start_time)::BaseType::BufferWriter
      start_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_start_time, buffer, &start_time_writer, &serialization_context);
  params->start_time.Set(
      start_time_writer.is_null() ? nullptr : start_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->start_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_time in NetworkContext.ClearNetworkingHistoryBetween request");
  typename decltype(params->end_time)::BaseType::BufferWriter
      end_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_end_time, buffer, &end_time_writer, &serialization_context);
  params->end_time.Set(
      end_time_writer.is_null() ? nullptr : end_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->end_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null end_time in NetworkContext.ClearNetworkingHistoryBetween request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearNetworkingHistoryBetween");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::ClearHttpCache(
    ::base::Time in_start_time, ::base::Time in_end_time, ClearDataFilterPtr in_filter, ClearHttpCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ClearHttpCache", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("start_time", base::trace_event::ValueToString(in_start_time, "<value of type ::base::Time>"));
      raw_value->SetString("end_time", base::trace_event::ValueToString(in_end_time, "<value of type ::base::Time>"));
      if (in_filter.is_null()) {
        raw_value->SetString("filter", "nullptr");
      } else {
        raw_value->BeginDictionary("filter");
        in_filter->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearHttpCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearHttpCache_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->start_time)::BaseType::BufferWriter
      start_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_start_time, buffer, &start_time_writer, &serialization_context);
  params->start_time.Set(
      start_time_writer.is_null() ? nullptr : start_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->start_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_time in NetworkContext.ClearHttpCache request");
  typename decltype(params->end_time)::BaseType::BufferWriter
      end_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_end_time, buffer, &end_time_writer, &serialization_context);
  params->end_time.Set(
      end_time_writer.is_null() ? nullptr : end_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->end_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null end_time in NetworkContext.ClearHttpCache request");
  typename decltype(params->filter)::BaseType::BufferWriter
      filter_writer;
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
      in_filter, buffer, &filter_writer, &serialization_context);
  params->filter.Set(
      filter_writer.is_null() ? nullptr : filter_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHttpCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearHttpCache_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::ComputeHttpCacheSize(
    ::base::Time in_start_time, ::base::Time in_end_time, ComputeHttpCacheSizeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ComputeHttpCacheSize", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("start_time", base::trace_event::ValueToString(in_start_time, "<value of type ::base::Time>"));
      raw_value->SetString("end_time", base::trace_event::ValueToString(in_end_time, "<value of type ::base::Time>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ComputeHttpCacheSize_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ComputeHttpCacheSize_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->start_time)::BaseType::BufferWriter
      start_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_start_time, buffer, &start_time_writer, &serialization_context);
  params->start_time.Set(
      start_time_writer.is_null() ? nullptr : start_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->start_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_time in NetworkContext.ComputeHttpCacheSize request");
  typename decltype(params->end_time)::BaseType::BufferWriter
      end_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_end_time, buffer, &end_time_writer, &serialization_context);
  params->end_time.Set(
      end_time_writer.is_null() ? nullptr : end_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->end_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null end_time in NetworkContext.ComputeHttpCacheSize request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ComputeHttpCacheSize");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ComputeHttpCacheSize_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::NotifyExternalCacheHit(
    const ::GURL& in_url, const std::string& in_http_method, const ::net::NetworkIsolationKey& in_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::NotifyExternalCacheHit", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("http_method", in_http_method);
      raw_value->SetString("key", base::trace_event::ValueToString(in_key, "<value of type const ::net::NetworkIsolationKey&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_NotifyExternalCacheHit_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_NotifyExternalCacheHit_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContext.NotifyExternalCacheHit request");
  typename decltype(params->http_method)::BaseType::BufferWriter
      http_method_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_http_method, buffer, &http_method_writer, &serialization_context);
  params->http_method.Set(
      http_method_writer.is_null() ? nullptr : http_method_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->http_method.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null http_method in NetworkContext.NotifyExternalCacheHit request");
  typename decltype(params->key)::BaseType::BufferWriter
      key_writer;
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_key, buffer, &key_writer, &serialization_context);
  params->key.Set(
      key_writer.is_null() ? nullptr : key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null key in NetworkContext.NotifyExternalCacheHit request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("NotifyExternalCacheHit");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::ClearHostCache(
    ClearDataFilterPtr in_filter, ClearHostCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ClearHostCache", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_filter.is_null()) {
        raw_value->SetString("filter", "nullptr");
      } else {
        raw_value->BeginDictionary("filter");
        in_filter->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearHostCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearHostCache_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->filter)::BaseType::BufferWriter
      filter_writer;
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
      in_filter, buffer, &filter_writer, &serialization_context);
  params->filter.Set(
      filter_writer.is_null() ? nullptr : filter_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHostCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearHostCache_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::ClearHttpAuthCache(
    ::base::Time in_start_time, ::base::Time in_end_time, ClearHttpAuthCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ClearHttpAuthCache", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("start_time", base::trace_event::ValueToString(in_start_time, "<value of type ::base::Time>"));
      raw_value->SetString("end_time", base::trace_event::ValueToString(in_end_time, "<value of type ::base::Time>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearHttpAuthCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearHttpAuthCache_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->start_time)::BaseType::BufferWriter
      start_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_start_time, buffer, &start_time_writer, &serialization_context);
  params->start_time.Set(
      start_time_writer.is_null() ? nullptr : start_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->start_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null start_time in NetworkContext.ClearHttpAuthCache request");
  typename decltype(params->end_time)::BaseType::BufferWriter
      end_time_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_end_time, buffer, &end_time_writer, &serialization_context);
  params->end_time.Set(
      end_time_writer.is_null() ? nullptr : end_time_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->end_time.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null end_time in NetworkContext.ClearHttpAuthCache request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHttpAuthCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearHttpAuthCache_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::ClearReportingCacheReports(
    ClearDataFilterPtr in_filter, ClearReportingCacheReportsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ClearReportingCacheReports", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_filter.is_null()) {
        raw_value->SetString("filter", "nullptr");
      } else {
        raw_value->BeginDictionary("filter");
        in_filter->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearReportingCacheReports_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearReportingCacheReports_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->filter)::BaseType::BufferWriter
      filter_writer;
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
      in_filter, buffer, &filter_writer, &serialization_context);
  params->filter.Set(
      filter_writer.is_null() ? nullptr : filter_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearReportingCacheReports");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearReportingCacheReports_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::ClearReportingCacheClients(
    ClearDataFilterPtr in_filter, ClearReportingCacheClientsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ClearReportingCacheClients", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_filter.is_null()) {
        raw_value->SetString("filter", "nullptr");
      } else {
        raw_value->BeginDictionary("filter");
        in_filter->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearReportingCacheClients_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearReportingCacheClients_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->filter)::BaseType::BufferWriter
      filter_writer;
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
      in_filter, buffer, &filter_writer, &serialization_context);
  params->filter.Set(
      filter_writer.is_null() ? nullptr : filter_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearReportingCacheClients");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearReportingCacheClients_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::ClearNetworkErrorLogging(
    ClearDataFilterPtr in_filter, ClearNetworkErrorLoggingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ClearNetworkErrorLogging", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_filter.is_null()) {
        raw_value->SetString("filter", "nullptr");
      } else {
        raw_value->BeginDictionary("filter");
        in_filter->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearNetworkErrorLogging_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearNetworkErrorLogging_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->filter)::BaseType::BufferWriter
      filter_writer;
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
      in_filter, buffer, &filter_writer, &serialization_context);
  params->filter.Set(
      filter_writer.is_null() ? nullptr : filter_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearNetworkErrorLogging");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearNetworkErrorLogging_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::ClearDomainReliability(
    ClearDataFilterPtr in_filter, NetworkContext::DomainReliabilityClearMode in_mode, ClearDomainReliabilityCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ClearDomainReliability", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_filter.is_null()) {
        raw_value->SetString("filter", "nullptr");
      } else {
        raw_value->BeginDictionary("filter");
        in_filter->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("mode", base::trace_event::ValueToString(in_mode));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearDomainReliability_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearDomainReliability_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->filter)::BaseType::BufferWriter
      filter_writer;
  mojo::internal::Serialize<::network::mojom::ClearDataFilterDataView>(
      in_filter, buffer, &filter_writer, &serialization_context);
  params->filter.Set(
      filter_writer.is_null() ? nullptr : filter_writer.data());
  mojo::internal::Serialize<::network::mojom::NetworkContext_DomainReliabilityClearMode>(
      in_mode, &params->mode);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearDomainReliability");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearDomainReliability_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::GetDomainReliabilityJSON(
    GetDomainReliabilityJSONCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkContext::GetDomainReliabilityJSON");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_GetDomainReliabilityJSON_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_GetDomainReliabilityJSON_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetDomainReliabilityJSON");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetDomainReliabilityJSON_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::QueueReport(
    const std::string& in_type, const std::string& in_group, const ::GURL& in_url, const base::Optional<std::string>& in_user_agent, ::base::Value in_body) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::QueueReport", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("type", in_type);
      raw_value->SetString("group", in_group);
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      if (in_user_agent.has_value()) {
        raw_value->SetString("user_agent", in_user_agent.value());
      } else {
        raw_value->SetString("user_agent", "base::nullopt");
      }
      raw_value->SetString("body", base::trace_event::ValueToString(in_body, "<value of type ::base::Value>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_QueueReport_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_QueueReport_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->type)::BaseType::BufferWriter
      type_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_type, buffer, &type_writer, &serialization_context);
  params->type.Set(
      type_writer.is_null() ? nullptr : type_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->type.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null type in NetworkContext.QueueReport request");
  typename decltype(params->group)::BaseType::BufferWriter
      group_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_group, buffer, &group_writer, &serialization_context);
  params->group.Set(
      group_writer.is_null() ? nullptr : group_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->group.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null group in NetworkContext.QueueReport request");
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContext.QueueReport request");
  typename decltype(params->user_agent)::BaseType::BufferWriter
      user_agent_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_user_agent, buffer, &user_agent_writer, &serialization_context);
  params->user_agent.Set(
      user_agent_writer.is_null() ? nullptr : user_agent_writer.data());
  typename decltype(params->body)::BaseType::BufferWriter
      body_writer;
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_body, buffer, &body_writer, &serialization_context);
  params->body.Set(
      body_writer.is_null() ? nullptr : body_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->body.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null body in NetworkContext.QueueReport request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("QueueReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::QueueSignedExchangeReport(
    SignedExchangeReportPtr in_report) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::QueueSignedExchangeReport", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_report.is_null()) {
        raw_value->SetString("report", "nullptr");
      } else {
        raw_value->BeginDictionary("report");
        in_report->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_QueueSignedExchangeReport_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_QueueSignedExchangeReport_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->report)::BaseType::BufferWriter
      report_writer;
  mojo::internal::Serialize<::network::mojom::SignedExchangeReportDataView>(
      in_report, buffer, &report_writer, &serialization_context);
  params->report.Set(
      report_writer.is_null() ? nullptr : report_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->report.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report in NetworkContext.QueueSignedExchangeReport request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("QueueSignedExchangeReport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::CloseAllConnections(
    CloseAllConnectionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkContext::CloseAllConnections");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CloseAllConnections_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CloseAllConnections_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CloseAllConnections");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_CloseAllConnections_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::CloseIdleConnections(
    CloseIdleConnectionsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkContext::CloseIdleConnections");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CloseIdleConnections_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CloseIdleConnections_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CloseIdleConnections");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_CloseIdleConnections_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::SetNetworkConditions(
    const ::base::UnguessableToken& in_throttling_profile_id, NetworkConditionsPtr in_conditions) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::SetNetworkConditions", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("throttling_profile_id", base::trace_event::ValueToString(in_throttling_profile_id, "<value of type const ::base::UnguessableToken&>"));
      if (in_conditions.is_null()) {
        raw_value->SetString("conditions", "nullptr");
      } else {
        raw_value->BeginDictionary("conditions");
        in_conditions->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetNetworkConditions_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetNetworkConditions_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->throttling_profile_id)::BaseType::BufferWriter
      throttling_profile_id_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_throttling_profile_id, buffer, &throttling_profile_id_writer, &serialization_context);
  params->throttling_profile_id.Set(
      throttling_profile_id_writer.is_null() ? nullptr : throttling_profile_id_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->throttling_profile_id.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null throttling_profile_id in NetworkContext.SetNetworkConditions request");
  typename decltype(params->conditions)::BaseType::BufferWriter
      conditions_writer;
  mojo::internal::Serialize<::network::mojom::NetworkConditionsDataView>(
      in_conditions, buffer, &conditions_writer, &serialization_context);
  params->conditions.Set(
      conditions_writer.is_null() ? nullptr : conditions_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetNetworkConditions");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::SetAcceptLanguage(
    const std::string& in_new_accept_language) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::SetAcceptLanguage", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("new_accept_language", in_new_accept_language);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetAcceptLanguage_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetAcceptLanguage_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->new_accept_language)::BaseType::BufferWriter
      new_accept_language_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_new_accept_language, buffer, &new_accept_language_writer, &serialization_context);
  params->new_accept_language.Set(
      new_accept_language_writer.is_null() ? nullptr : new_accept_language_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_accept_language.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_accept_language in NetworkContext.SetAcceptLanguage request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetAcceptLanguage");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::SetUserAgent(
    const std::string& in_new_user_agent) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::SetUserAgent", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("new_user_agent", in_new_user_agent);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetUserAgent_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetUserAgent_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->new_user_agent)::BaseType::BufferWriter
      new_user_agent_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_new_user_agent, buffer, &new_user_agent_writer, &serialization_context);
  params->new_user_agent.Set(
      new_user_agent_writer.is_null() ? nullptr : new_user_agent_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->new_user_agent.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null new_user_agent in NetworkContext.SetUserAgent request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetUserAgent");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::SetEnableReferrers(
    bool in_enable_referrers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::SetEnableReferrers", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("enable_referrers", in_enable_referrers);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetEnableReferrers_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetEnableReferrers_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->enable_referrers = in_enable_referrers;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetEnableReferrers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::SetCTPolicy(
    CTPolicyPtr in_ct_policy) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::SetCTPolicy", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_ct_policy.is_null()) {
        raw_value->SetString("ct_policy", "nullptr");
      } else {
        raw_value->BeginDictionary("ct_policy");
        in_ct_policy->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetCTPolicy_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetCTPolicy_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->ct_policy)::BaseType::BufferWriter
      ct_policy_writer;
  mojo::internal::Serialize<::network::mojom::CTPolicyDataView>(
      in_ct_policy, buffer, &ct_policy_writer, &serialization_context);
  params->ct_policy.Set(
      ct_policy_writer.is_null() ? nullptr : ct_policy_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ct_policy.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ct_policy in NetworkContext.SetCTPolicy request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetCTPolicy");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::AddExpectCT(
    const std::string& in_host, ::base::Time in_expiry, bool in_enforce, const ::GURL& in_report_uri, const ::net::NetworkIsolationKey& in_network_isolation_key, AddExpectCTCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::AddExpectCT", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("host", in_host);
      raw_value->SetString("expiry", base::trace_event::ValueToString(in_expiry, "<value of type ::base::Time>"));
      raw_value->SetBoolean("enforce", in_enforce);
      raw_value->SetString("report_uri", base::trace_event::ValueToString(in_report_uri, "<value of type const ::GURL&>"));
      raw_value->SetString("network_isolation_key", base::trace_event::ValueToString(in_network_isolation_key, "<value of type const ::net::NetworkIsolationKey&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_AddExpectCT_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_AddExpectCT_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->host)::BaseType::BufferWriter
      host_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host, buffer, &host_writer, &serialization_context);
  params->host.Set(
      host_writer.is_null() ? nullptr : host_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in NetworkContext.AddExpectCT request");
  typename decltype(params->expiry)::BaseType::BufferWriter
      expiry_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expiry, buffer, &expiry_writer, &serialization_context);
  params->expiry.Set(
      expiry_writer.is_null() ? nullptr : expiry_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->expiry.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expiry in NetworkContext.AddExpectCT request");
  params->enforce = in_enforce;
  typename decltype(params->report_uri)::BaseType::BufferWriter
      report_uri_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_report_uri, buffer, &report_uri_writer, &serialization_context);
  params->report_uri.Set(
      report_uri_writer.is_null() ? nullptr : report_uri_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->report_uri.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report_uri in NetworkContext.AddExpectCT request");
  typename decltype(params->network_isolation_key)::BaseType::BufferWriter
      network_isolation_key_writer;
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, buffer, &network_isolation_key_writer, &serialization_context);
  params->network_isolation_key.Set(
      network_isolation_key_writer.is_null() ? nullptr : network_isolation_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in NetworkContext.AddExpectCT request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddExpectCT");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_AddExpectCT_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::SetExpectCTTestReport(
    const ::GURL& in_report_uri, SetExpectCTTestReportCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::SetExpectCTTestReport", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("report_uri", base::trace_event::ValueToString(in_report_uri, "<value of type const ::GURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetExpectCTTestReport_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetExpectCTTestReport_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->report_uri)::BaseType::BufferWriter
      report_uri_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_report_uri, buffer, &report_uri_writer, &serialization_context);
  params->report_uri.Set(
      report_uri_writer.is_null() ? nullptr : report_uri_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->report_uri.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null report_uri in NetworkContext.SetExpectCTTestReport request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetExpectCTTestReport");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_SetExpectCTTestReport_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::GetExpectCTState(
    const std::string& in_domain, const ::net::NetworkIsolationKey& in_network_isolation_key, GetExpectCTStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::GetExpectCTState", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("domain", in_domain);
      raw_value->SetString("network_isolation_key", base::trace_event::ValueToString(in_network_isolation_key, "<value of type const ::net::NetworkIsolationKey&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_GetExpectCTState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_GetExpectCTState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->domain)::BaseType::BufferWriter
      domain_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_domain, buffer, &domain_writer, &serialization_context);
  params->domain.Set(
      domain_writer.is_null() ? nullptr : domain_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->domain.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domain in NetworkContext.GetExpectCTState request");
  typename decltype(params->network_isolation_key)::BaseType::BufferWriter
      network_isolation_key_writer;
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, buffer, &network_isolation_key_writer, &serialization_context);
  params->network_isolation_key.Set(
      network_isolation_key_writer.is_null() ? nullptr : network_isolation_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in NetworkContext.GetExpectCTState request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetExpectCTState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetExpectCTState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::CreateUDPSocket(
    ::mojo::PendingReceiver<::network::mojom::UDPSocket> in_receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> in_listener) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateUDPSocket", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      raw_value->SetBoolean("listener", in_listener.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateUDPSocket_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateUDPSocket_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::UDPSocketInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in NetworkContext.CreateUDPSocket request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::UDPSocketListenerInterfaceBase>>(
      in_listener, &params->listener, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateUDPSocket");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::CreateTCPServerSocket(
    const ::net::IPEndPoint& in_local_addr, uint32_t in_backlog, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> in_socket, CreateTCPServerSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateTCPServerSocket", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("local_addr", base::trace_event::ValueToString(in_local_addr, "<value of type const ::net::IPEndPoint&>"));
      raw_value->SetString("backlog", base::NumberToString(in_backlog));
      raw_value->SetString("traffic_annotation", base::trace_event::ValueToString(in_traffic_annotation, "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>"));
      raw_value->SetBoolean("socket", in_socket.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateTCPServerSocket_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateTCPServerSocket_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->local_addr)::BaseType::BufferWriter
      local_addr_writer;
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr, buffer, &local_addr_writer, &serialization_context);
  params->local_addr.Set(
      local_addr_writer.is_null() ? nullptr : local_addr_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_addr.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_addr in NetworkContext.CreateTCPServerSocket request");
  params->backlog = in_backlog;
  typename decltype(params->traffic_annotation)::BaseType::BufferWriter
      traffic_annotation_writer;
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, buffer, &traffic_annotation_writer, &serialization_context);
  params->traffic_annotation.Set(
      traffic_annotation_writer.is_null() ? nullptr : traffic_annotation_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in NetworkContext.CreateTCPServerSocket request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPServerSocketInterfaceBase>>(
      in_socket, &params->socket, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in NetworkContext.CreateTCPServerSocket request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPServerSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_CreateTCPServerSocket_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::CreateTCPConnectedSocket(
    const base::Optional<::net::IPEndPoint>& in_local_addr, const ::net::AddressList& in_remote_addr_list, ::network::mojom::TCPConnectedSocketOptionsPtr in_tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> in_socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> in_observer, CreateTCPConnectedSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateTCPConnectedSocket", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("local_addr", base::trace_event::ValueToString(in_local_addr, "<value of type const base::Optional<::net::IPEndPoint>&>"));
      raw_value->SetString("remote_addr_list", base::trace_event::ValueToString(in_remote_addr_list, "<value of type const ::net::AddressList&>"));
      if (in_tcp_connected_socket_options.is_null()) {
        raw_value->SetString("tcp_connected_socket_options", "nullptr");
      } else {
        raw_value->BeginDictionary("tcp_connected_socket_options");
        in_tcp_connected_socket_options->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("traffic_annotation", base::trace_event::ValueToString(in_traffic_annotation, "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>"));
      raw_value->SetBoolean("socket", in_socket.is_valid());
      raw_value->SetBoolean("observer", in_observer.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateTCPConnectedSocket_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateTCPConnectedSocket_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->local_addr)::BaseType::BufferWriter
      local_addr_writer;
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr, buffer, &local_addr_writer, &serialization_context);
  params->local_addr.Set(
      local_addr_writer.is_null() ? nullptr : local_addr_writer.data());
  typename decltype(params->remote_addr_list)::BaseType::BufferWriter
      remote_addr_list_writer;
  mojo::internal::Serialize<::network::mojom::AddressListDataView>(
      in_remote_addr_list, buffer, &remote_addr_list_writer, &serialization_context);
  params->remote_addr_list.Set(
      remote_addr_list_writer.is_null() ? nullptr : remote_addr_list_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->remote_addr_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null remote_addr_list in NetworkContext.CreateTCPConnectedSocket request");
  typename decltype(params->tcp_connected_socket_options)::BaseType::BufferWriter
      tcp_connected_socket_options_writer;
  mojo::internal::Serialize<::network::mojom::TCPConnectedSocketOptionsDataView>(
      in_tcp_connected_socket_options, buffer, &tcp_connected_socket_options_writer, &serialization_context);
  params->tcp_connected_socket_options.Set(
      tcp_connected_socket_options_writer.is_null() ? nullptr : tcp_connected_socket_options_writer.data());
  typename decltype(params->traffic_annotation)::BaseType::BufferWriter
      traffic_annotation_writer;
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, buffer, &traffic_annotation_writer, &serialization_context);
  params->traffic_annotation.Set(
      traffic_annotation_writer.is_null() ? nullptr : traffic_annotation_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in NetworkContext.CreateTCPConnectedSocket request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPConnectedSocketInterfaceBase>>(
      in_socket, &params->socket, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in NetworkContext.CreateTCPConnectedSocket request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::SocketObserverInterfaceBase>>(
      in_observer, &params->observer, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPConnectedSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_CreateTCPConnectedSocket_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::CreateTCPBoundSocket(
    const ::net::IPEndPoint& in_local_addr, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> in_socket, CreateTCPBoundSocketCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateTCPBoundSocket", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("local_addr", base::trace_event::ValueToString(in_local_addr, "<value of type const ::net::IPEndPoint&>"));
      raw_value->SetString("traffic_annotation", base::trace_event::ValueToString(in_traffic_annotation, "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>"));
      raw_value->SetBoolean("socket", in_socket.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateTCPBoundSocket_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateTCPBoundSocket_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->local_addr)::BaseType::BufferWriter
      local_addr_writer;
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr, buffer, &local_addr_writer, &serialization_context);
  params->local_addr.Set(
      local_addr_writer.is_null() ? nullptr : local_addr_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->local_addr.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null local_addr in NetworkContext.CreateTCPBoundSocket request");
  typename decltype(params->traffic_annotation)::BaseType::BufferWriter
      traffic_annotation_writer;
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, buffer, &traffic_annotation_writer, &serialization_context);
  params->traffic_annotation.Set(
      traffic_annotation_writer.is_null() ? nullptr : traffic_annotation_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in NetworkContext.CreateTCPBoundSocket request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::TCPBoundSocketInterfaceBase>>(
      in_socket, &params->socket, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket in NetworkContext.CreateTCPBoundSocket request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPBoundSocket");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_CreateTCPBoundSocket_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::CreateProxyResolvingSocketFactory(
    ::mojo::PendingReceiver<::network::mojom::ProxyResolvingSocketFactory> in_factory) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateProxyResolvingSocketFactory", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("factory", in_factory.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateProxyResolvingSocketFactory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateProxyResolvingSocketFactory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::ProxyResolvingSocketFactoryInterfaceBase>>(
      in_factory, &params->factory, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid factory in NetworkContext.CreateProxyResolvingSocketFactory request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateProxyResolvingSocketFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::LookUpProxyForURL(
    const ::GURL& in_url, const ::net::NetworkIsolationKey& in_network_isolation_key, ::mojo::PendingRemote<::network::mojom::ProxyLookupClient> in_proxy_lookup_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::LookUpProxyForURL", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("network_isolation_key", base::trace_event::ValueToString(in_network_isolation_key, "<value of type const ::net::NetworkIsolationKey&>"));
      raw_value->SetBoolean("proxy_lookup_client", in_proxy_lookup_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_LookUpProxyForURL_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_LookUpProxyForURL_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContext.LookUpProxyForURL request");
  typename decltype(params->network_isolation_key)::BaseType::BufferWriter
      network_isolation_key_writer;
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, buffer, &network_isolation_key_writer, &serialization_context);
  params->network_isolation_key.Set(
      network_isolation_key_writer.is_null() ? nullptr : network_isolation_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in NetworkContext.LookUpProxyForURL request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ProxyLookupClientInterfaceBase>>(
      in_proxy_lookup_client, &params->proxy_lookup_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->proxy_lookup_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid proxy_lookup_client in NetworkContext.LookUpProxyForURL request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("LookUpProxyForURL");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::ForceReloadProxyConfig(
    ForceReloadProxyConfigCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkContext::ForceReloadProxyConfig");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ForceReloadProxyConfig_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ForceReloadProxyConfig_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ForceReloadProxyConfig");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ForceReloadProxyConfig_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::ClearBadProxiesCache(
    ClearBadProxiesCacheCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkContext::ClearBadProxiesCache");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearBadProxiesCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearBadProxiesCache_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearBadProxiesCache");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ClearBadProxiesCache_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::CreateWebSocket(
    const ::GURL& in_url, const std::vector<std::string>& in_requested_protocols, const ::net::SiteForCookies& in_site_for_cookies, const ::net::IsolationInfo& in_isolation_info, std::vector<::network::mojom::HttpHeaderPtr> in_additional_headers, int32_t in_process_id, int32_t in_render_frame_id, const ::url::Origin& in_origin, uint32_t in_options, const ::net::MutableNetworkTrafficAnnotationTag& in_traffic_annotation, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> in_handshake_client, ::mojo::PendingRemote<::network::mojom::AuthenticationHandler> in_auth_handler, ::mojo::PendingRemote<TrustedHeaderClient> in_header_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateWebSocket", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->BeginArray("requested_protocols");
      for (const auto& item0 : in_requested_protocols) {
        raw_value->AppendString(item0);
      }
      raw_value->EndArray();
      raw_value->SetString("site_for_cookies", base::trace_event::ValueToString(in_site_for_cookies, "<value of type const ::net::SiteForCookies&>"));
      raw_value->SetString("isolation_info", base::trace_event::ValueToString(in_isolation_info, "<value of type const ::net::IsolationInfo&>"));
      raw_value->BeginArray("additional_headers");
      for (const auto& item0 : in_additional_headers) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      raw_value->SetInteger("process_id", in_process_id);
      raw_value->SetInteger("render_frame_id", in_render_frame_id);
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetString("options", base::NumberToString(in_options));
      raw_value->SetString("traffic_annotation", base::trace_event::ValueToString(in_traffic_annotation, "<value of type const ::net::MutableNetworkTrafficAnnotationTag&>"));
      raw_value->SetBoolean("handshake_client", in_handshake_client.is_valid());
      raw_value->SetBoolean("auth_handler", in_auth_handler.is_valid());
      raw_value->SetBoolean("header_client", in_header_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateWebSocket_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateWebSocket_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContext.CreateWebSocket request");
  typename decltype(params->requested_protocols)::BaseType::BufferWriter
      requested_protocols_writer;
  const mojo::internal::ContainerValidateParams requested_protocols_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
      in_requested_protocols, buffer, &requested_protocols_writer, &requested_protocols_validate_params,
      &serialization_context);
  params->requested_protocols.Set(
      requested_protocols_writer.is_null() ? nullptr : requested_protocols_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->requested_protocols.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null requested_protocols in NetworkContext.CreateWebSocket request");
  typename decltype(params->site_for_cookies)::BaseType::BufferWriter
      site_for_cookies_writer;
  mojo::internal::Serialize<::network::mojom::SiteForCookiesDataView>(
      in_site_for_cookies, buffer, &site_for_cookies_writer, &serialization_context);
  params->site_for_cookies.Set(
      site_for_cookies_writer.is_null() ? nullptr : site_for_cookies_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->site_for_cookies.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null site_for_cookies in NetworkContext.CreateWebSocket request");
  typename decltype(params->isolation_info)::BaseType::BufferWriter
      isolation_info_writer;
  mojo::internal::Serialize<::network::mojom::IsolationInfoDataView>(
      in_isolation_info, buffer, &isolation_info_writer, &serialization_context);
  params->isolation_info.Set(
      isolation_info_writer.is_null() ? nullptr : isolation_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->isolation_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null isolation_info in NetworkContext.CreateWebSocket request");
  typename decltype(params->additional_headers)::BaseType::BufferWriter
      additional_headers_writer;
  const mojo::internal::ContainerValidateParams additional_headers_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::HttpHeaderDataView>>(
      in_additional_headers, buffer, &additional_headers_writer, &additional_headers_validate_params,
      &serialization_context);
  params->additional_headers.Set(
      additional_headers_writer.is_null() ? nullptr : additional_headers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->additional_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null additional_headers in NetworkContext.CreateWebSocket request");
  params->process_id = in_process_id;
  params->render_frame_id = in_render_frame_id;
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in NetworkContext.CreateWebSocket request");
  params->options = in_options;
  typename decltype(params->traffic_annotation)::BaseType::BufferWriter
      traffic_annotation_writer;
  mojo::internal::Serialize<::network::mojom::MutableNetworkTrafficAnnotationTagDataView>(
      in_traffic_annotation, buffer, &traffic_annotation_writer, &serialization_context);
  params->traffic_annotation.Set(
      traffic_annotation_writer.is_null() ? nullptr : traffic_annotation_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->traffic_annotation.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null traffic_annotation in NetworkContext.CreateWebSocket request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::WebSocketHandshakeClientInterfaceBase>>(
      in_handshake_client, &params->handshake_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->handshake_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid handshake_client in NetworkContext.CreateWebSocket request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::AuthenticationHandlerInterfaceBase>>(
      in_auth_handler, &params->auth_handler, &serialization_context);
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::TrustedHeaderClientInterfaceBase>>(
      in_header_client, &params->header_client, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateWebSocket");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::CreateQuicTransport(
    const ::GURL& in_url, const ::url::Origin& in_origin, const ::net::NetworkIsolationKey& in_network_isolation_key, std::vector<::network::mojom::QuicTransportCertificateFingerprintPtr> in_fingerprints, ::mojo::PendingRemote<::network::mojom::QuicTransportHandshakeClient> in_handshake_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateQuicTransport", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::url::Origin&>"));
      raw_value->SetString("network_isolation_key", base::trace_event::ValueToString(in_network_isolation_key, "<value of type const ::net::NetworkIsolationKey&>"));
      raw_value->BeginArray("fingerprints");
      for (const auto& item0 : in_fingerprints) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      raw_value->SetBoolean("handshake_client", in_handshake_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateQuicTransport_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateQuicTransport_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContext.CreateQuicTransport request");
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in NetworkContext.CreateQuicTransport request");
  typename decltype(params->network_isolation_key)::BaseType::BufferWriter
      network_isolation_key_writer;
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, buffer, &network_isolation_key_writer, &serialization_context);
  params->network_isolation_key.Set(
      network_isolation_key_writer.is_null() ? nullptr : network_isolation_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in NetworkContext.CreateQuicTransport request");
  typename decltype(params->fingerprints)::BaseType::BufferWriter
      fingerprints_writer;
  const mojo::internal::ContainerValidateParams fingerprints_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::QuicTransportCertificateFingerprintDataView>>(
      in_fingerprints, buffer, &fingerprints_writer, &fingerprints_validate_params,
      &serialization_context);
  params->fingerprints.Set(
      fingerprints_writer.is_null() ? nullptr : fingerprints_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->fingerprints.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null fingerprints in NetworkContext.CreateQuicTransport request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::QuicTransportHandshakeClientInterfaceBase>>(
      in_handshake_client, &params->handshake_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->handshake_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid handshake_client in NetworkContext.CreateQuicTransport request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateQuicTransport");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::CreateNetLogExporter(
    ::mojo::PendingReceiver<::network::mojom::NetLogExporter> in_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateNetLogExporter", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("receiver", in_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateNetLogExporter_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateNetLogExporter_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::NetLogExporterInterfaceBase>>(
      in_receiver, &params->receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid receiver in NetworkContext.CreateNetLogExporter request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateNetLogExporter");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::PreconnectSockets(
    uint32_t in_num_streams, const ::GURL& in_url, bool in_allow_credentials, const ::net::NetworkIsolationKey& in_network_isolation_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::PreconnectSockets", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("num_streams", base::NumberToString(in_num_streams));
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetBoolean("allow_credentials", in_allow_credentials);
      raw_value->SetString("network_isolation_key", base::trace_event::ValueToString(in_network_isolation_key, "<value of type const ::net::NetworkIsolationKey&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_PreconnectSockets_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_PreconnectSockets_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->num_streams = in_num_streams;
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContext.PreconnectSockets request");
  params->allow_credentials = in_allow_credentials;
  typename decltype(params->network_isolation_key)::BaseType::BufferWriter
      network_isolation_key_writer;
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, buffer, &network_isolation_key_writer, &serialization_context);
  params->network_isolation_key.Set(
      network_isolation_key_writer.is_null() ? nullptr : network_isolation_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in NetworkContext.PreconnectSockets request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("PreconnectSockets");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::CreateP2PSocketManager(
    const ::net::NetworkIsolationKey& in_network_isolation_key, ::mojo::PendingRemote<::network::mojom::P2PTrustedSocketManagerClient> in_client, ::mojo::PendingReceiver<::network::mojom::P2PTrustedSocketManager> in_trusted_socket_manager, ::mojo::PendingReceiver<::network::mojom::P2PSocketManager> in_socket_manager) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateP2PSocketManager", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("network_isolation_key", base::trace_event::ValueToString(in_network_isolation_key, "<value of type const ::net::NetworkIsolationKey&>"));
      raw_value->SetBoolean("client", in_client.is_valid());
      raw_value->SetBoolean("trusted_socket_manager", in_trusted_socket_manager.is_valid());
      raw_value->SetBoolean("socket_manager", in_socket_manager.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateP2PSocketManager_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateP2PSocketManager_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->network_isolation_key)::BaseType::BufferWriter
      network_isolation_key_writer;
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, buffer, &network_isolation_key_writer, &serialization_context);
  params->network_isolation_key.Set(
      network_isolation_key_writer.is_null() ? nullptr : network_isolation_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in NetworkContext.CreateP2PSocketManager request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::P2PTrustedSocketManagerClientInterfaceBase>>(
      in_client, &params->client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid client in NetworkContext.CreateP2PSocketManager request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::P2PTrustedSocketManagerInterfaceBase>>(
      in_trusted_socket_manager, &params->trusted_socket_manager, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->trusted_socket_manager),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid trusted_socket_manager in NetworkContext.CreateP2PSocketManager request");
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::P2PSocketManagerInterfaceBase>>(
      in_socket_manager, &params->socket_manager, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->socket_manager),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid socket_manager in NetworkContext.CreateP2PSocketManager request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateP2PSocketManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::CreateMdnsResponder(
    ::mojo::PendingReceiver<::network::mojom::MdnsResponder> in_responder_receiver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateMdnsResponder", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("responder_receiver", in_responder_receiver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateMdnsResponder_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateMdnsResponder_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::MdnsResponderInterfaceBase>>(
      in_responder_receiver, &params->responder_receiver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->responder_receiver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid responder_receiver in NetworkContext.CreateMdnsResponder request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateMdnsResponder");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::ResolveHost(
    const ::net::HostPortPair& in_host, const ::net::NetworkIsolationKey& in_network_isolation_key, ::network::mojom::ResolveHostParametersPtr in_optional_parameters, ::mojo::PendingRemote<::network::mojom::ResolveHostClient> in_response_client) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ResolveHost", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("host", base::trace_event::ValueToString(in_host, "<value of type const ::net::HostPortPair&>"));
      raw_value->SetString("network_isolation_key", base::trace_event::ValueToString(in_network_isolation_key, "<value of type const ::net::NetworkIsolationKey&>"));
      if (in_optional_parameters.is_null()) {
        raw_value->SetString("optional_parameters", "nullptr");
      } else {
        raw_value->BeginDictionary("optional_parameters");
        in_optional_parameters->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetBoolean("response_client", in_response_client.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ResolveHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ResolveHost_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->host)::BaseType::BufferWriter
      host_writer;
  mojo::internal::Serialize<::network::mojom::HostPortPairDataView>(
      in_host, buffer, &host_writer, &serialization_context);
  params->host.Set(
      host_writer.is_null() ? nullptr : host_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in NetworkContext.ResolveHost request");
  typename decltype(params->network_isolation_key)::BaseType::BufferWriter
      network_isolation_key_writer;
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, buffer, &network_isolation_key_writer, &serialization_context);
  params->network_isolation_key.Set(
      network_isolation_key_writer.is_null() ? nullptr : network_isolation_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in NetworkContext.ResolveHost request");
  typename decltype(params->optional_parameters)::BaseType::BufferWriter
      optional_parameters_writer;
  mojo::internal::Serialize<::network::mojom::ResolveHostParametersDataView>(
      in_optional_parameters, buffer, &optional_parameters_writer, &serialization_context);
  params->optional_parameters.Set(
      optional_parameters_writer.is_null() ? nullptr : optional_parameters_writer.data());
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::network::mojom::ResolveHostClientInterfaceBase>>(
      in_response_client, &params->response_client, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->response_client),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid response_client in NetworkContext.ResolveHost request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ResolveHost");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::CreateHostResolver(
    const base::Optional<::net::DnsConfigOverrides>& in_config_overrides, ::mojo::PendingReceiver<::network::mojom::HostResolver> in_host_resolver) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::CreateHostResolver", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("config_overrides", base::trace_event::ValueToString(in_config_overrides, "<value of type const base::Optional<::net::DnsConfigOverrides>&>"));
      raw_value->SetBoolean("host_resolver", in_host_resolver.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateHostResolver_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateHostResolver_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->config_overrides)::BaseType::BufferWriter
      config_overrides_writer;
  mojo::internal::Serialize<::network::mojom::DnsConfigOverridesDataView>(
      in_config_overrides, buffer, &config_overrides_writer, &serialization_context);
  params->config_overrides.Set(
      config_overrides_writer.is_null() ? nullptr : config_overrides_writer.data());
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::HostResolverInterfaceBase>>(
      in_host_resolver, &params->host_resolver, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host_resolver),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host_resolver in NetworkContext.CreateHostResolver request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateHostResolver");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::VerifyCertForSignedExchange(
    const ::scoped_refptr<::net::X509Certificate>& in_certificate, const ::GURL& in_url, const std::string& in_ocsp_response, const std::string& in_sct_list, VerifyCertForSignedExchangeCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::VerifyCertForSignedExchange", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("certificate", base::trace_event::ValueToString(in_certificate, "<value of type const ::scoped_refptr<::net::X509Certificate>&>"));
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("ocsp_response", in_ocsp_response);
      raw_value->SetString("sct_list", in_sct_list);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_VerifyCertForSignedExchange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_VerifyCertForSignedExchange_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->certificate)::BaseType::BufferWriter
      certificate_writer;
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
      in_certificate, buffer, &certificate_writer, &serialization_context);
  params->certificate.Set(
      certificate_writer.is_null() ? nullptr : certificate_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->certificate.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null certificate in NetworkContext.VerifyCertForSignedExchange request");
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContext.VerifyCertForSignedExchange request");
  typename decltype(params->ocsp_response)::BaseType::BufferWriter
      ocsp_response_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_ocsp_response, buffer, &ocsp_response_writer, &serialization_context);
  params->ocsp_response.Set(
      ocsp_response_writer.is_null() ? nullptr : ocsp_response_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ocsp_response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ocsp_response in NetworkContext.VerifyCertForSignedExchange request");
  typename decltype(params->sct_list)::BaseType::BufferWriter
      sct_list_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_sct_list, buffer, &sct_list_writer, &serialization_context);
  params->sct_list.Set(
      sct_list_writer.is_null() ? nullptr : sct_list_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sct_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sct_list in NetworkContext.VerifyCertForSignedExchange request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("VerifyCertForSignedExchange");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_VerifyCertForSignedExchange_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::ParseHeaders(
    const ::GURL& in_url, const ::scoped_refptr<::net::HttpResponseHeaders>& in_headers, ParseHeadersCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::ParseHeaders", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("headers", base::trace_event::ValueToString(in_headers, "<value of type const ::scoped_refptr<::net::HttpResponseHeaders>&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ParseHeaders_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ParseHeaders_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContext.ParseHeaders request");
  typename decltype(params->headers)::BaseType::BufferWriter
      headers_writer;
  mojo::internal::Serialize<::network::mojom::HttpResponseHeadersDataView>(
      in_headers, buffer, &headers_writer, &serialization_context);
  params->headers.Set(
      headers_writer.is_null() ? nullptr : headers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null headers in NetworkContext.ParseHeaders request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ParseHeaders");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ParseHeaders_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::AddHSTS(
    const std::string& in_host, ::base::Time in_expiry, bool in_include_subdomains, AddHSTSCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::AddHSTS", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("host", in_host);
      raw_value->SetString("expiry", base::trace_event::ValueToString(in_expiry, "<value of type ::base::Time>"));
      raw_value->SetBoolean("include_subdomains", in_include_subdomains);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_AddHSTS_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_AddHSTS_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->host)::BaseType::BufferWriter
      host_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host, buffer, &host_writer, &serialization_context);
  params->host.Set(
      host_writer.is_null() ? nullptr : host_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in NetworkContext.AddHSTS request");
  typename decltype(params->expiry)::BaseType::BufferWriter
      expiry_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
      in_expiry, buffer, &expiry_writer, &serialization_context);
  params->expiry.Set(
      expiry_writer.is_null() ? nullptr : expiry_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->expiry.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null expiry in NetworkContext.AddHSTS request");
  params->include_subdomains = in_include_subdomains;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddHSTS");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_AddHSTS_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::IsHSTSActiveForHost(
    const std::string& in_host, IsHSTSActiveForHostCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::IsHSTSActiveForHost", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("host", in_host);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_IsHSTSActiveForHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_IsHSTSActiveForHost_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->host)::BaseType::BufferWriter
      host_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host, buffer, &host_writer, &serialization_context);
  params->host.Set(
      host_writer.is_null() ? nullptr : host_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in NetworkContext.IsHSTSActiveForHost request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("IsHSTSActiveForHost");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_IsHSTSActiveForHost_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::GetHSTSState(
    const std::string& in_domain, GetHSTSStateCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::GetHSTSState", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("domain", in_domain);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_GetHSTSState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_GetHSTSState_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->domain)::BaseType::BufferWriter
      domain_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_domain, buffer, &domain_writer, &serialization_context);
  params->domain.Set(
      domain_writer.is_null() ? nullptr : domain_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->domain.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null domain in NetworkContext.GetHSTSState request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetHSTSState");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_GetHSTSState_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::SetCorsOriginAccessListsForOrigin(
    const ::url::Origin& in_source_origin, std::vector<::network::mojom::CorsOriginPatternPtr> in_allow_patterns, std::vector<::network::mojom::CorsOriginPatternPtr> in_block_patterns, SetCorsOriginAccessListsForOriginCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::SetCorsOriginAccessListsForOrigin", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("source_origin", base::trace_event::ValueToString(in_source_origin, "<value of type const ::url::Origin&>"));
      raw_value->BeginArray("allow_patterns");
      for (const auto& item0 : in_allow_patterns) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      raw_value->BeginArray("block_patterns");
      for (const auto& item0 : in_block_patterns) {
        if (item0.is_null()) {
          raw_value->AppendString("nullptr");
        } else {
          raw_value->BeginDictionary();
          item0->AsValueInto(raw_value);
          raw_value->EndDictionary();
        }
      }
      raw_value->EndArray();
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetCorsOriginAccessListsForOrigin_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->source_origin)::BaseType::BufferWriter
      source_origin_writer;
  mojo::internal::Serialize<::url::mojom::OriginDataView>(
      in_source_origin, buffer, &source_origin_writer, &serialization_context);
  params->source_origin.Set(
      source_origin_writer.is_null() ? nullptr : source_origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->source_origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null source_origin in NetworkContext.SetCorsOriginAccessListsForOrigin request");
  typename decltype(params->allow_patterns)::BaseType::BufferWriter
      allow_patterns_writer;
  const mojo::internal::ContainerValidateParams allow_patterns_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CorsOriginPatternDataView>>(
      in_allow_patterns, buffer, &allow_patterns_writer, &allow_patterns_validate_params,
      &serialization_context);
  params->allow_patterns.Set(
      allow_patterns_writer.is_null() ? nullptr : allow_patterns_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->allow_patterns.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null allow_patterns in NetworkContext.SetCorsOriginAccessListsForOrigin request");
  typename decltype(params->block_patterns)::BaseType::BufferWriter
      block_patterns_writer;
  const mojo::internal::ContainerValidateParams block_patterns_validate_params(
      0, false, nullptr);
  mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::CorsOriginPatternDataView>>(
      in_block_patterns, buffer, &block_patterns_writer, &block_patterns_validate_params,
      &serialization_context);
  params->block_patterns.Set(
      block_patterns_writer.is_null() ? nullptr : block_patterns_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->block_patterns.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null block_patterns in NetworkContext.SetCorsOriginAccessListsForOrigin request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetCorsOriginAccessListsForOrigin");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::DeleteDynamicDataForHost(
    const std::string& in_host, DeleteDynamicDataForHostCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::DeleteDynamicDataForHost", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("host", in_host);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_DeleteDynamicDataForHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_DeleteDynamicDataForHost_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->host)::BaseType::BufferWriter
      host_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_host, buffer, &host_writer, &serialization_context);
  params->host.Set(
      host_writer.is_null() ? nullptr : host_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->host.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null host in NetworkContext.DeleteDynamicDataForHost request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("DeleteDynamicDataForHost");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_DeleteDynamicDataForHost_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::SetSplitAuthCacheByNetworkIsolationKey(
    bool in_split_auth_cache_by_network_isolation_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::SetSplitAuthCacheByNetworkIsolationKey", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("split_auth_cache_by_network_isolation_key", in_split_auth_cache_by_network_isolation_key);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetSplitAuthCacheByNetworkIsolationKey_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetSplitAuthCacheByNetworkIsolationKey_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->split_auth_cache_by_network_isolation_key = in_split_auth_cache_by_network_isolation_key;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetSplitAuthCacheByNetworkIsolationKey");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::SaveHttpAuthCacheProxyEntries(
    SaveHttpAuthCacheProxyEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkContext::SaveHttpAuthCacheProxyEntries");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SaveHttpAuthCacheProxyEntries_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SaveHttpAuthCacheProxyEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::LoadHttpAuthCacheProxyEntries(
    const ::base::UnguessableToken& in_cache_key, LoadHttpAuthCacheProxyEntriesCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::LoadHttpAuthCacheProxyEntries", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cache_key", base::trace_event::ValueToString(in_cache_key, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_LoadHttpAuthCacheProxyEntries_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cache_key)::BaseType::BufferWriter
      cache_key_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_cache_key, buffer, &cache_key_writer, &serialization_context);
  params->cache_key.Set(
      cache_key_writer.is_null() ? nullptr : cache_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cache_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_key in NetworkContext.LoadHttpAuthCacheProxyEntries request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("LoadHttpAuthCacheProxyEntries");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::AddAuthCacheEntry(
    const ::net::AuthChallengeInfo& in_challenge, const ::net::NetworkIsolationKey& in_network_isolation_key, const ::net::AuthCredentials& in_credentials, AddAuthCacheEntryCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::AddAuthCacheEntry", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("challenge", base::trace_event::ValueToString(in_challenge, "<value of type const ::net::AuthChallengeInfo&>"));
      raw_value->SetString("network_isolation_key", base::trace_event::ValueToString(in_network_isolation_key, "<value of type const ::net::NetworkIsolationKey&>"));
      raw_value->SetString("credentials", base::trace_event::ValueToString(in_credentials, "<value of type const ::net::AuthCredentials&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_AddAuthCacheEntry_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_AddAuthCacheEntry_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->challenge)::BaseType::BufferWriter
      challenge_writer;
  mojo::internal::Serialize<::network::mojom::AuthChallengeInfoDataView>(
      in_challenge, buffer, &challenge_writer, &serialization_context);
  params->challenge.Set(
      challenge_writer.is_null() ? nullptr : challenge_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->challenge.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null challenge in NetworkContext.AddAuthCacheEntry request");
  typename decltype(params->network_isolation_key)::BaseType::BufferWriter
      network_isolation_key_writer;
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, buffer, &network_isolation_key_writer, &serialization_context);
  params->network_isolation_key.Set(
      network_isolation_key_writer.is_null() ? nullptr : network_isolation_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in NetworkContext.AddAuthCacheEntry request");
  typename decltype(params->credentials)::BaseType::BufferWriter
      credentials_writer;
  mojo::internal::Serialize<::network::mojom::AuthCredentialsDataView>(
      in_credentials, buffer, &credentials_writer, &serialization_context);
  params->credentials.Set(
      credentials_writer.is_null() ? nullptr : credentials_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->credentials.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null credentials in NetworkContext.AddAuthCacheEntry request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddAuthCacheEntry");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_AddAuthCacheEntry_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::LookupServerBasicAuthCredentials(
    const ::GURL& in_url, const ::net::NetworkIsolationKey& in_network_isolation_key, LookupServerBasicAuthCredentialsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::LookupServerBasicAuthCredentials", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("url", base::trace_event::ValueToString(in_url, "<value of type const ::GURL&>"));
      raw_value->SetString("network_isolation_key", base::trace_event::ValueToString(in_network_isolation_key, "<value of type const ::net::NetworkIsolationKey&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_LookupServerBasicAuthCredentials_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_LookupServerBasicAuthCredentials_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->url)::BaseType::BufferWriter
      url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_url, buffer, &url_writer, &serialization_context);
  params->url.Set(
      url_writer.is_null() ? nullptr : url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null url in NetworkContext.LookupServerBasicAuthCredentials request");
  typename decltype(params->network_isolation_key)::BaseType::BufferWriter
      network_isolation_key_writer;
  mojo::internal::Serialize<::network::mojom::NetworkIsolationKeyDataView>(
      in_network_isolation_key, buffer, &network_isolation_key_writer, &serialization_context);
  params->network_isolation_key.Set(
      network_isolation_key_writer.is_null() ? nullptr : network_isolation_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->network_isolation_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null network_isolation_key in NetworkContext.LookupServerBasicAuthCredentials request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("LookupServerBasicAuthCredentials");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NetworkContextProxy::EnableStaticKeyPinningForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "network::mojom::NetworkContext::EnableStaticKeyPinningForTesting");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_EnableStaticKeyPinningForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_EnableStaticKeyPinningForTesting_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("EnableStaticKeyPinningForTesting");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::NetworkContext::EnableStaticKeyPinningForTesting");
#endif
  return result;
}

void NetworkContextProxy::EnableStaticKeyPinningForTesting(
    EnableStaticKeyPinningForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkContext::EnableStaticKeyPinningForTesting");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_EnableStaticKeyPinningForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_EnableStaticKeyPinningForTesting_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("EnableStaticKeyPinningForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NetworkContextProxy::VerifyCertificateForTesting(
    const ::scoped_refptr<::net::X509Certificate>& param_certificate, const std::string& param_hostname, const std::string& param_ocsp_response, const std::string& param_sct_list, int32_t* out_param_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::NetworkContext::VerifyCertificateForTesting", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("certificate", base::trace_event::ValueToString(param_certificate, "<value of type const ::scoped_refptr<::net::X509Certificate>&>"));
      raw_value->SetString("hostname", param_hostname);
      raw_value->SetString("ocsp_response", param_ocsp_response);
      raw_value->SetString("sct_list", param_sct_list);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_VerifyCertificateForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_VerifyCertificateForTesting_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->certificate)::BaseType::BufferWriter
      certificate_writer;
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
      param_certificate, buffer, &certificate_writer, &serialization_context);
  params->certificate.Set(
      certificate_writer.is_null() ? nullptr : certificate_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->certificate.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null certificate in NetworkContext.VerifyCertificateForTesting request");
  typename decltype(params->hostname)::BaseType::BufferWriter
      hostname_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_hostname, buffer, &hostname_writer, &serialization_context);
  params->hostname.Set(
      hostname_writer.is_null() ? nullptr : hostname_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->hostname.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hostname in NetworkContext.VerifyCertificateForTesting request");
  typename decltype(params->ocsp_response)::BaseType::BufferWriter
      ocsp_response_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_ocsp_response, buffer, &ocsp_response_writer, &serialization_context);
  params->ocsp_response.Set(
      ocsp_response_writer.is_null() ? nullptr : ocsp_response_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ocsp_response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ocsp_response in NetworkContext.VerifyCertificateForTesting request");
  typename decltype(params->sct_list)::BaseType::BufferWriter
      sct_list_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      param_sct_list, buffer, &sct_list_writer, &serialization_context);
  params->sct_list.Set(
      sct_list_writer.is_null() ? nullptr : sct_list_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sct_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sct_list in NetworkContext.VerifyCertificateForTesting request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("VerifyCertificateForTesting");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_VerifyCertificateForTesting_HandleSyncResponse(
          &result, out_param_error_code));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1(
    "mojom", "network::mojom::NetworkContext::VerifyCertificateForTesting", "sync_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (out_param_error_code) {
        raw_value->SetInteger("error_code", (*out_param_error_code));
      } else {
        raw_value->SetString("error_code", "nullptr");
      }
      return value;
    }());
#endif
  return result;
}

void NetworkContextProxy::VerifyCertificateForTesting(
    const ::scoped_refptr<::net::X509Certificate>& in_certificate, const std::string& in_hostname, const std::string& in_ocsp_response, const std::string& in_sct_list, VerifyCertificateForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::VerifyCertificateForTesting", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("certificate", base::trace_event::ValueToString(in_certificate, "<value of type const ::scoped_refptr<::net::X509Certificate>&>"));
      raw_value->SetString("hostname", in_hostname);
      raw_value->SetString("ocsp_response", in_ocsp_response);
      raw_value->SetString("sct_list", in_sct_list);
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_VerifyCertificateForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_VerifyCertificateForTesting_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->certificate)::BaseType::BufferWriter
      certificate_writer;
  mojo::internal::Serialize<::network::mojom::X509CertificateDataView>(
      in_certificate, buffer, &certificate_writer, &serialization_context);
  params->certificate.Set(
      certificate_writer.is_null() ? nullptr : certificate_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->certificate.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null certificate in NetworkContext.VerifyCertificateForTesting request");
  typename decltype(params->hostname)::BaseType::BufferWriter
      hostname_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_hostname, buffer, &hostname_writer, &serialization_context);
  params->hostname.Set(
      hostname_writer.is_null() ? nullptr : hostname_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->hostname.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null hostname in NetworkContext.VerifyCertificateForTesting request");
  typename decltype(params->ocsp_response)::BaseType::BufferWriter
      ocsp_response_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_ocsp_response, buffer, &ocsp_response_writer, &serialization_context);
  params->ocsp_response.Set(
      ocsp_response_writer.is_null() ? nullptr : ocsp_response_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ocsp_response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ocsp_response in NetworkContext.VerifyCertificateForTesting request");
  typename decltype(params->sct_list)::BaseType::BufferWriter
      sct_list_writer;
  mojo::internal::Serialize<mojo::StringDataView>(
      in_sct_list, buffer, &sct_list_writer, &serialization_context);
  params->sct_list.Set(
      sct_list_writer.is_null() ? nullptr : sct_list_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sct_list.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sct_list in NetworkContext.VerifyCertificateForTesting request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("VerifyCertificateForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_VerifyCertificateForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NetworkContextProxy::AddDomainReliabilityContextForTesting(
    const ::GURL& param_origin, const ::GURL& param_upload_url) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "network::mojom::NetworkContext::AddDomainReliabilityContextForTesting", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(param_origin, "<value of type const ::GURL&>"));
      raw_value->SetString("upload_url", base::trace_event::ValueToString(param_upload_url, "<value of type const ::GURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_AddDomainReliabilityContextForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_AddDomainReliabilityContextForTesting_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in NetworkContext.AddDomainReliabilityContextForTesting request");
  typename decltype(params->upload_url)::BaseType::BufferWriter
      upload_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      param_upload_url, buffer, &upload_url_writer, &serialization_context);
  params->upload_url.Set(
      upload_url_writer.is_null() ? nullptr : upload_url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->upload_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null upload_url in NetworkContext.AddDomainReliabilityContextForTesting request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddDomainReliabilityContextForTesting");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::NetworkContext::AddDomainReliabilityContextForTesting");
#endif
  return result;
}

void NetworkContextProxy::AddDomainReliabilityContextForTesting(
    const ::GURL& in_origin, const ::GURL& in_upload_url, AddDomainReliabilityContextForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::AddDomainReliabilityContextForTesting", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("origin", base::trace_event::ValueToString(in_origin, "<value of type const ::GURL&>"));
      raw_value->SetString("upload_url", base::trace_event::ValueToString(in_upload_url, "<value of type const ::GURL&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_AddDomainReliabilityContextForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_AddDomainReliabilityContextForTesting_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->origin)::BaseType::BufferWriter
      origin_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_origin, buffer, &origin_writer, &serialization_context);
  params->origin.Set(
      origin_writer.is_null() ? nullptr : origin_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->origin.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null origin in NetworkContext.AddDomainReliabilityContextForTesting request");
  typename decltype(params->upload_url)::BaseType::BufferWriter
      upload_url_writer;
  mojo::internal::Serialize<::url::mojom::UrlDataView>(
      in_upload_url, buffer, &upload_url_writer, &serialization_context);
  params->upload_url.Set(
      upload_url_writer.is_null() ? nullptr : upload_url_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->upload_url.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null upload_url in NetworkContext.AddDomainReliabilityContextForTesting request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddDomainReliabilityContextForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
bool NetworkContextProxy::ForceDomainReliabilityUploadsForTesting(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTesting");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = true;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ForceDomainReliabilityUploadsForTesting");
#endif

  bool result = false;
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse(
          &result));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END0("mojom", "network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTesting");
#endif
  return result;
}

void NetworkContextProxy::ForceDomainReliabilityUploadsForTesting(
    ForceDomainReliabilityUploadsForTestingCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTesting");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ForceDomainReliabilityUploadsForTesting");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void NetworkContextProxy::GetOriginPolicyManager(
    ::mojo::PendingReceiver<::network::mojom::OriginPolicyManager> in_origin_policy_manager) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::GetOriginPolicyManager", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("origin_policy_manager", in_origin_policy_manager.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_GetOriginPolicyManager_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_GetOriginPolicyManager_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::network::mojom::OriginPolicyManagerInterfaceBase>>(
      in_origin_policy_manager, &params->origin_policy_manager, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->origin_policy_manager),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid origin_policy_manager in NetworkContext.GetOriginPolicyManager request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetOriginPolicyManager");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void NetworkContextProxy::SetSCTAuditingEnabled(
    bool in_enabled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "network::mojom::NetworkContext::SetSCTAuditingEnabled", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("enabled", in_enabled);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetSCTAuditingEnabled_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetSCTAuditingEnabled_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->enabled = in_enabled;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetSCTAuditingEnabled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class NetworkContext_ClearTrustTokenData_ProxyToResponder {
 public:
  static NetworkContext::ClearTrustTokenDataCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ClearTrustTokenData_ProxyToResponder> proxy(
        new NetworkContext_ClearTrustTokenData_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ClearTrustTokenData_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearTrustTokenData_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ClearTrustTokenData_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearTrustTokenDataCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearTrustTokenData_ProxyToResponder);
};

bool NetworkContext_ClearTrustTokenData_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ClearTrustTokenDataCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearTrustTokenData_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearTrustTokenData_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ClearTrustTokenData_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 6, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ClearTrustTokenData_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ClearTrustTokenDataCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearTrustTokenData_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearTrustTokenData_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ClearTrustTokenDataCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearTrustTokenData");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder {
 public:
  static NetworkContext::ClearNetworkingHistoryBetweenCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder> proxy(
        new NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearNetworkingHistoryBetweenCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder);
};

bool NetworkContext_ClearNetworkingHistoryBetween_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ClearNetworkingHistoryBetweenCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ClearNetworkingHistoryBetween_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 7, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ClearNetworkingHistoryBetweenCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearNetworkingHistoryBetween_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ClearNetworkingHistoryBetweenCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearNetworkingHistoryBetween");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearHttpCache_ProxyToResponder {
 public:
  static NetworkContext::ClearHttpCacheCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ClearHttpCache_ProxyToResponder> proxy(
        new NetworkContext_ClearHttpCache_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ClearHttpCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearHttpCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ClearHttpCache_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearHttpCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearHttpCache_ProxyToResponder);
};

bool NetworkContext_ClearHttpCache_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ClearHttpCacheCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearHttpCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearHttpCache_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ClearHttpCache_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 8, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ClearHttpCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ClearHttpCacheCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearHttpCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearHttpCache_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ClearHttpCacheCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHttpCache");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ComputeHttpCacheSize_ProxyToResponder {
 public:
  static NetworkContext::ComputeHttpCacheSizeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ComputeHttpCacheSize_ProxyToResponder> proxy(
        new NetworkContext_ComputeHttpCacheSize_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ComputeHttpCacheSize_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ComputeHttpCacheSize_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ComputeHttpCacheSize_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ComputeHttpCacheSizeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_is_upper_bound, int64_t in_size_or_error);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ComputeHttpCacheSize_ProxyToResponder);
};

bool NetworkContext_ComputeHttpCacheSize_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ComputeHttpCacheSizeCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ComputeHttpCacheSize_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ComputeHttpCacheSize_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_is_upper_bound{};
  int64_t p_size_or_error{};
  NetworkContext_ComputeHttpCacheSize_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_is_upper_bound = input_data_view.is_upper_bound();
  if (success)
    p_size_or_error = input_data_view.size_or_error();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 9, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_is_upper_bound), 
std::move(p_size_or_error));
  return true;
}

void NetworkContext_ComputeHttpCacheSize_ProxyToResponder::Run(
    bool in_is_upper_bound, int64_t in_size_or_error) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::ComputeHttpCacheSizeCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_upper_bound", in_is_upper_bound);
      raw_value->SetString("size_or_error", base::NumberToString(in_size_or_error));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ComputeHttpCacheSize_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ComputeHttpCacheSize_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_upper_bound = in_is_upper_bound;
  params->size_or_error = in_size_or_error;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ComputeHttpCacheSizeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ComputeHttpCacheSize");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearHostCache_ProxyToResponder {
 public:
  static NetworkContext::ClearHostCacheCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ClearHostCache_ProxyToResponder> proxy(
        new NetworkContext_ClearHostCache_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ClearHostCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearHostCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ClearHostCache_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearHostCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearHostCache_ProxyToResponder);
};

bool NetworkContext_ClearHostCache_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ClearHostCacheCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearHostCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearHostCache_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ClearHostCache_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 11, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ClearHostCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ClearHostCacheCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearHostCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearHostCache_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ClearHostCacheCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHostCache");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearHttpAuthCache_ProxyToResponder {
 public:
  static NetworkContext::ClearHttpAuthCacheCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ClearHttpAuthCache_ProxyToResponder> proxy(
        new NetworkContext_ClearHttpAuthCache_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ClearHttpAuthCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearHttpAuthCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ClearHttpAuthCache_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearHttpAuthCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearHttpAuthCache_ProxyToResponder);
};

bool NetworkContext_ClearHttpAuthCache_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ClearHttpAuthCacheCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearHttpAuthCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearHttpAuthCache_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ClearHttpAuthCache_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 12, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ClearHttpAuthCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ClearHttpAuthCacheCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearHttpAuthCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearHttpAuthCache_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ClearHttpAuthCacheCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearHttpAuthCache");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearReportingCacheReports_ProxyToResponder {
 public:
  static NetworkContext::ClearReportingCacheReportsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ClearReportingCacheReports_ProxyToResponder> proxy(
        new NetworkContext_ClearReportingCacheReports_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ClearReportingCacheReports_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearReportingCacheReports_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ClearReportingCacheReports_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearReportingCacheReportsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearReportingCacheReports_ProxyToResponder);
};

bool NetworkContext_ClearReportingCacheReports_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ClearReportingCacheReportsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearReportingCacheReports_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearReportingCacheReports_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ClearReportingCacheReports_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 13, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ClearReportingCacheReports_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ClearReportingCacheReportsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearReportingCacheReports_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearReportingCacheReports_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ClearReportingCacheReportsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearReportingCacheReports");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearReportingCacheClients_ProxyToResponder {
 public:
  static NetworkContext::ClearReportingCacheClientsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ClearReportingCacheClients_ProxyToResponder> proxy(
        new NetworkContext_ClearReportingCacheClients_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ClearReportingCacheClients_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearReportingCacheClients_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ClearReportingCacheClients_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearReportingCacheClientsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearReportingCacheClients_ProxyToResponder);
};

bool NetworkContext_ClearReportingCacheClients_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ClearReportingCacheClientsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearReportingCacheClients_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearReportingCacheClients_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ClearReportingCacheClients_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 14, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ClearReportingCacheClients_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ClearReportingCacheClientsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearReportingCacheClients_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearReportingCacheClients_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ClearReportingCacheClientsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearReportingCacheClients");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearNetworkErrorLogging_ProxyToResponder {
 public:
  static NetworkContext::ClearNetworkErrorLoggingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ClearNetworkErrorLogging_ProxyToResponder> proxy(
        new NetworkContext_ClearNetworkErrorLogging_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ClearNetworkErrorLogging_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearNetworkErrorLogging_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ClearNetworkErrorLogging_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearNetworkErrorLoggingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearNetworkErrorLogging_ProxyToResponder);
};

bool NetworkContext_ClearNetworkErrorLogging_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ClearNetworkErrorLoggingCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ClearNetworkErrorLogging_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 15, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ClearNetworkErrorLogging_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ClearNetworkErrorLoggingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearNetworkErrorLogging_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ClearNetworkErrorLoggingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearNetworkErrorLogging");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearDomainReliability_ProxyToResponder {
 public:
  static NetworkContext::ClearDomainReliabilityCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ClearDomainReliability_ProxyToResponder> proxy(
        new NetworkContext_ClearDomainReliability_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ClearDomainReliability_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearDomainReliability_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ClearDomainReliability_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearDomainReliabilityCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearDomainReliability_ProxyToResponder);
};

bool NetworkContext_ClearDomainReliability_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ClearDomainReliabilityCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearDomainReliability_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearDomainReliability_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ClearDomainReliability_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 16, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ClearDomainReliability_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ClearDomainReliabilityCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearDomainReliability_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearDomainReliability_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ClearDomainReliabilityCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearDomainReliability");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_GetDomainReliabilityJSON_ProxyToResponder {
 public:
  static NetworkContext::GetDomainReliabilityJSONCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_GetDomainReliabilityJSON_ProxyToResponder> proxy(
        new NetworkContext_GetDomainReliabilityJSON_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_GetDomainReliabilityJSON_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_GetDomainReliabilityJSON_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_GetDomainReliabilityJSON_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::GetDomainReliabilityJSONCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_data);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_GetDomainReliabilityJSON_ProxyToResponder);
};

bool NetworkContext_GetDomainReliabilityJSON_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::GetDomainReliabilityJSONCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_GetDomainReliabilityJSON_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_GetDomainReliabilityJSON_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::Value p_data{};
  NetworkContext_GetDomainReliabilityJSON_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadData(&p_data))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 17, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_data));
  return true;
}

void NetworkContext_GetDomainReliabilityJSON_ProxyToResponder::Run(
    ::base::Value in_data) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::GetDomainReliabilityJSONCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("data", base::trace_event::ValueToString(in_data, "<value of type ::base::Value>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_GetDomainReliabilityJSON_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_GetDomainReliabilityJSON_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->data)::BufferWriter data_writer;
  data_writer.AllocateInline(buffer, &params->data);
  mojo::internal::Serialize<::mojo_base::mojom::ValueDataView>(
      in_data, buffer, &data_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null data in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::GetDomainReliabilityJSONCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetDomainReliabilityJSON");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_CloseAllConnections_ProxyToResponder {
 public:
  static NetworkContext::CloseAllConnectionsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_CloseAllConnections_ProxyToResponder> proxy(
        new NetworkContext_CloseAllConnections_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_CloseAllConnections_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_CloseAllConnections_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_CloseAllConnections_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::CloseAllConnectionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_CloseAllConnections_ProxyToResponder);
};

bool NetworkContext_CloseAllConnections_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::CloseAllConnectionsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_CloseAllConnections_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_CloseAllConnections_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_CloseAllConnections_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 20, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_CloseAllConnections_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::CloseAllConnectionsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CloseAllConnections_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CloseAllConnections_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::CloseAllConnectionsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CloseAllConnections");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_CloseIdleConnections_ProxyToResponder {
 public:
  static NetworkContext::CloseIdleConnectionsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_CloseIdleConnections_ProxyToResponder> proxy(
        new NetworkContext_CloseIdleConnections_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_CloseIdleConnections_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_CloseIdleConnections_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_CloseIdleConnections_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::CloseIdleConnectionsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_CloseIdleConnections_ProxyToResponder);
};

bool NetworkContext_CloseIdleConnections_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::CloseIdleConnectionsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_CloseIdleConnections_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_CloseIdleConnections_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_CloseIdleConnections_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 21, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_CloseIdleConnections_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::CloseIdleConnectionsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CloseIdleConnections_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CloseIdleConnections_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::CloseIdleConnectionsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CloseIdleConnections");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_AddExpectCT_ProxyToResponder {
 public:
  static NetworkContext::AddExpectCTCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_AddExpectCT_ProxyToResponder> proxy(
        new NetworkContext_AddExpectCT_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_AddExpectCT_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_AddExpectCT_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_AddExpectCT_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::AddExpectCTCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_AddExpectCT_ProxyToResponder);
};

bool NetworkContext_AddExpectCT_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::AddExpectCTCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_AddExpectCT_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_AddExpectCT_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  NetworkContext_AddExpectCT_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 27, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void NetworkContext_AddExpectCT_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::AddExpectCTCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_AddExpectCT_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_AddExpectCT_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::AddExpectCTCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddExpectCT");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_SetExpectCTTestReport_ProxyToResponder {
 public:
  static NetworkContext::SetExpectCTTestReportCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_SetExpectCTTestReport_ProxyToResponder> proxy(
        new NetworkContext_SetExpectCTTestReport_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_SetExpectCTTestReport_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_SetExpectCTTestReport_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_SetExpectCTTestReport_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::SetExpectCTTestReportCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_success);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_SetExpectCTTestReport_ProxyToResponder);
};

bool NetworkContext_SetExpectCTTestReport_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::SetExpectCTTestReportCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_SetExpectCTTestReport_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_SetExpectCTTestReport_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_success{};
  NetworkContext_SetExpectCTTestReport_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_success = input_data_view.success();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 28, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_success));
  return true;
}

void NetworkContext_SetExpectCTTestReport_ProxyToResponder::Run(
    bool in_success) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::SetExpectCTTestReportCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("success", in_success);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetExpectCTTestReport_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetExpectCTTestReport_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->success = in_success;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::SetExpectCTTestReportCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetExpectCTTestReport");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_GetExpectCTState_ProxyToResponder {
 public:
  static NetworkContext::GetExpectCTStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_GetExpectCTState_ProxyToResponder> proxy(
        new NetworkContext_GetExpectCTState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_GetExpectCTState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_GetExpectCTState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_GetExpectCTState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::GetExpectCTStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_state);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_GetExpectCTState_ProxyToResponder);
};

bool NetworkContext_GetExpectCTState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::GetExpectCTStateCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_GetExpectCTState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_GetExpectCTState_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::Value p_state{};
  NetworkContext_GetExpectCTState_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 29, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_state));
  return true;
}

void NetworkContext_GetExpectCTState_ProxyToResponder::Run(
    ::base::Value in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::GetExpectCTStateCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("state", base::trace_event::ValueToString(in_state, "<value of type ::base::Value>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_GetExpectCTState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_GetExpectCTState_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->state)::BaseType::BufferWriter
      state_writer;
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_state, buffer, &state_writer, &serialization_context);
  params->state.Set(
      state_writer.is_null() ? nullptr : state_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::GetExpectCTStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetExpectCTState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_CreateTCPServerSocket_ProxyToResponder {
 public:
  static NetworkContext::CreateTCPServerSocketCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_CreateTCPServerSocket_ProxyToResponder> proxy(
        new NetworkContext_CreateTCPServerSocket_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_CreateTCPServerSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_CreateTCPServerSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_CreateTCPServerSocket_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::CreateTCPServerSocketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const base::Optional<::net::IPEndPoint>& in_local_addr_out);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_CreateTCPServerSocket_ProxyToResponder);
};

bool NetworkContext_CreateTCPServerSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::CreateTCPServerSocketCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_CreateTCPServerSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_CreateTCPServerSocket_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_result{};
  base::Optional<::net::IPEndPoint> p_local_addr_out{};
  NetworkContext_CreateTCPServerSocket_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddrOut(&p_local_addr_out))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 31, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr_out));
  return true;
}

void NetworkContext_CreateTCPServerSocket_ProxyToResponder::Run(
    int32_t in_result, const base::Optional<::net::IPEndPoint>& in_local_addr_out) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::CreateTCPServerSocketCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("result", in_result);
      raw_value->SetString("local_addr_out", base::trace_event::ValueToString(in_local_addr_out, "<value of type const base::Optional<::net::IPEndPoint>&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateTCPServerSocket_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateTCPServerSocket_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->result = in_result;
  typename decltype(params->local_addr_out)::BaseType::BufferWriter
      local_addr_out_writer;
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr_out, buffer, &local_addr_out_writer, &serialization_context);
  params->local_addr_out.Set(
      local_addr_out_writer.is_null() ? nullptr : local_addr_out_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::CreateTCPServerSocketCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPServerSocket");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_CreateTCPConnectedSocket_ProxyToResponder {
 public:
  static NetworkContext::CreateTCPConnectedSocketCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_CreateTCPConnectedSocket_ProxyToResponder> proxy(
        new NetworkContext_CreateTCPConnectedSocket_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_CreateTCPConnectedSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_CreateTCPConnectedSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_CreateTCPConnectedSocket_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::CreateTCPConnectedSocketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const base::Optional<::net::IPEndPoint>& in_local_addr, const base::Optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_CreateTCPConnectedSocket_ProxyToResponder);
};

bool NetworkContext_CreateTCPConnectedSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::CreateTCPConnectedSocketCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_result{};
  base::Optional<::net::IPEndPoint> p_local_addr{};
  base::Optional<::net::IPEndPoint> p_peer_addr{};
  ::mojo::ScopedDataPipeConsumerHandle p_receive_stream{};
  ::mojo::ScopedDataPipeProducerHandle p_send_stream{};
  NetworkContext_CreateTCPConnectedSocket_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (success && !input_data_view.ReadPeerAddr(&p_peer_addr))
    success = false;
  if (success)
    p_receive_stream = input_data_view.TakeReceiveStream();
  if (success)
    p_send_stream = input_data_view.TakeSendStream();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 32, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr), 
std::move(p_peer_addr), 
std::move(p_receive_stream), 
std::move(p_send_stream));
  return true;
}

void NetworkContext_CreateTCPConnectedSocket_ProxyToResponder::Run(
    int32_t in_result, const base::Optional<::net::IPEndPoint>& in_local_addr, const base::Optional<::net::IPEndPoint>& in_peer_addr, ::mojo::ScopedDataPipeConsumerHandle in_receive_stream, ::mojo::ScopedDataPipeProducerHandle in_send_stream) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::CreateTCPConnectedSocketCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("result", in_result);
      raw_value->SetString("local_addr", base::trace_event::ValueToString(in_local_addr, "<value of type const base::Optional<::net::IPEndPoint>&>"));
      raw_value->SetString("peer_addr", base::trace_event::ValueToString(in_peer_addr, "<value of type const base::Optional<::net::IPEndPoint>&>"));
      raw_value->SetBoolean("receive_stream", in_receive_stream.is_valid());
      raw_value->SetBoolean("send_stream", in_send_stream.is_valid());
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateTCPConnectedSocket_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->result = in_result;
  typename decltype(params->local_addr)::BaseType::BufferWriter
      local_addr_writer;
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr, buffer, &local_addr_writer, &serialization_context);
  params->local_addr.Set(
      local_addr_writer.is_null() ? nullptr : local_addr_writer.data());
  typename decltype(params->peer_addr)::BaseType::BufferWriter
      peer_addr_writer;
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_peer_addr, buffer, &peer_addr_writer, &serialization_context);
  params->peer_addr.Set(
      peer_addr_writer.is_null() ? nullptr : peer_addr_writer.data());
  mojo::internal::Serialize<mojo::ScopedDataPipeConsumerHandle>(
      in_receive_stream, &params->receive_stream, &serialization_context);
  mojo::internal::Serialize<mojo::ScopedDataPipeProducerHandle>(
      in_send_stream, &params->send_stream, &serialization_context);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::CreateTCPConnectedSocketCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPConnectedSocket");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_CreateTCPBoundSocket_ProxyToResponder {
 public:
  static NetworkContext::CreateTCPBoundSocketCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_CreateTCPBoundSocket_ProxyToResponder> proxy(
        new NetworkContext_CreateTCPBoundSocket_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_CreateTCPBoundSocket_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_CreateTCPBoundSocket_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_CreateTCPBoundSocket_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::CreateTCPBoundSocketCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_result, const base::Optional<::net::IPEndPoint>& in_local_addr);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_CreateTCPBoundSocket_ProxyToResponder);
};

bool NetworkContext_CreateTCPBoundSocket_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::CreateTCPBoundSocketCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_CreateTCPBoundSocket_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_CreateTCPBoundSocket_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_result{};
  base::Optional<::net::IPEndPoint> p_local_addr{};
  NetworkContext_CreateTCPBoundSocket_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_result = input_data_view.result();
  if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 33, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result), 
std::move(p_local_addr));
  return true;
}

void NetworkContext_CreateTCPBoundSocket_ProxyToResponder::Run(
    int32_t in_result, const base::Optional<::net::IPEndPoint>& in_local_addr) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::CreateTCPBoundSocketCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("result", in_result);
      raw_value->SetString("local_addr", base::trace_event::ValueToString(in_local_addr, "<value of type const base::Optional<::net::IPEndPoint>&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_CreateTCPBoundSocket_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_CreateTCPBoundSocket_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->result = in_result;
  typename decltype(params->local_addr)::BaseType::BufferWriter
      local_addr_writer;
  mojo::internal::Serialize<::network::mojom::IPEndPointDataView>(
      in_local_addr, buffer, &local_addr_writer, &serialization_context);
  params->local_addr.Set(
      local_addr_writer.is_null() ? nullptr : local_addr_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::CreateTCPBoundSocketCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("CreateTCPBoundSocket");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ForceReloadProxyConfig_ProxyToResponder {
 public:
  static NetworkContext::ForceReloadProxyConfigCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ForceReloadProxyConfig_ProxyToResponder> proxy(
        new NetworkContext_ForceReloadProxyConfig_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ForceReloadProxyConfig_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ForceReloadProxyConfig_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ForceReloadProxyConfig_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ForceReloadProxyConfigCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ForceReloadProxyConfig_ProxyToResponder);
};

bool NetworkContext_ForceReloadProxyConfig_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ForceReloadProxyConfigCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ForceReloadProxyConfig_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ForceReloadProxyConfig_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ForceReloadProxyConfig_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 36, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ForceReloadProxyConfig_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ForceReloadProxyConfigCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ForceReloadProxyConfig_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ForceReloadProxyConfig_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ForceReloadProxyConfigCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ForceReloadProxyConfig");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ClearBadProxiesCache_ProxyToResponder {
 public:
  static NetworkContext::ClearBadProxiesCacheCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ClearBadProxiesCache_ProxyToResponder> proxy(
        new NetworkContext_ClearBadProxiesCache_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ClearBadProxiesCache_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ClearBadProxiesCache_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ClearBadProxiesCache_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ClearBadProxiesCacheCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ClearBadProxiesCache_ProxyToResponder);
};

bool NetworkContext_ClearBadProxiesCache_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ClearBadProxiesCacheCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ClearBadProxiesCache_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ClearBadProxiesCache_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ClearBadProxiesCache_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 37, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ClearBadProxiesCache_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ClearBadProxiesCacheCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ClearBadProxiesCache_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ClearBadProxiesCache_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ClearBadProxiesCacheCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ClearBadProxiesCache");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_VerifyCertForSignedExchange_ProxyToResponder {
 public:
  static NetworkContext::VerifyCertForSignedExchangeCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_VerifyCertForSignedExchange_ProxyToResponder> proxy(
        new NetworkContext_VerifyCertForSignedExchange_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_VerifyCertForSignedExchange_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_VerifyCertForSignedExchange_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_VerifyCertForSignedExchange_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::VerifyCertForSignedExchangeCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_error_code, const ::net::CertVerifyResult& in_cv_result, const ::net::ct::CTVerifyResult& in_ct_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_VerifyCertForSignedExchange_ProxyToResponder);
};

bool NetworkContext_VerifyCertForSignedExchange_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::VerifyCertForSignedExchangeCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_error_code{};
  ::net::CertVerifyResult p_cv_result{};
  ::net::ct::CTVerifyResult p_ct_result{};
  NetworkContext_VerifyCertForSignedExchange_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_error_code = input_data_view.error_code();
  if (success && !input_data_view.ReadCvResult(&p_cv_result))
    success = false;
  if (success && !input_data_view.ReadCtResult(&p_ct_result))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 46, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error_code), 
std::move(p_cv_result), 
std::move(p_ct_result));
  return true;
}

void NetworkContext_VerifyCertForSignedExchange_ProxyToResponder::Run(
    int32_t in_error_code, const ::net::CertVerifyResult& in_cv_result, const ::net::ct::CTVerifyResult& in_ct_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::VerifyCertForSignedExchangeCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("error_code", in_error_code);
      raw_value->SetString("cv_result", base::trace_event::ValueToString(in_cv_result, "<value of type const ::net::CertVerifyResult&>"));
      raw_value->SetString("ct_result", base::trace_event::ValueToString(in_ct_result, "<value of type const ::net::ct::CTVerifyResult&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_VerifyCertForSignedExchange_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->error_code = in_error_code;
  typename decltype(params->cv_result)::BaseType::BufferWriter
      cv_result_writer;
  mojo::internal::Serialize<::network::mojom::CertVerifyResultDataView>(
      in_cv_result, buffer, &cv_result_writer, &serialization_context);
  params->cv_result.Set(
      cv_result_writer.is_null() ? nullptr : cv_result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cv_result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cv_result in ");
  typename decltype(params->ct_result)::BaseType::BufferWriter
      ct_result_writer;
  mojo::internal::Serialize<::network::mojom::CTVerifyResultDataView>(
      in_ct_result, buffer, &ct_result_writer, &serialization_context);
  params->ct_result.Set(
      ct_result_writer.is_null() ? nullptr : ct_result_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->ct_result.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null ct_result in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::VerifyCertForSignedExchangeCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("VerifyCertForSignedExchange");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_ParseHeaders_ProxyToResponder {
 public:
  static NetworkContext::ParseHeadersCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ParseHeaders_ProxyToResponder> proxy(
        new NetworkContext_ParseHeaders_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ParseHeaders_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ParseHeaders_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ParseHeaders_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ParseHeadersCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::network::mojom::ParsedHeadersPtr in_parsed_headers);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ParseHeaders_ProxyToResponder);
};

bool NetworkContext_ParseHeaders_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ParseHeadersCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ParseHeaders_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ParseHeaders_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::network::mojom::ParsedHeadersPtr p_parsed_headers{};
  NetworkContext_ParseHeaders_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadParsedHeaders(&p_parsed_headers))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 47, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_parsed_headers));
  return true;
}

void NetworkContext_ParseHeaders_ProxyToResponder::Run(
    ::network::mojom::ParsedHeadersPtr in_parsed_headers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::ParseHeadersCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_parsed_headers.is_null()) {
        raw_value->SetString("parsed_headers", "nullptr");
      } else {
        raw_value->BeginDictionary("parsed_headers");
        in_parsed_headers->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ParseHeaders_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ParseHeaders_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->parsed_headers)::BaseType::BufferWriter
      parsed_headers_writer;
  mojo::internal::Serialize<::network::mojom::ParsedHeadersDataView>(
      in_parsed_headers, buffer, &parsed_headers_writer, &serialization_context);
  params->parsed_headers.Set(
      parsed_headers_writer.is_null() ? nullptr : parsed_headers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parsed_headers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parsed_headers in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ParseHeadersCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ParseHeaders");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_AddHSTS_ProxyToResponder {
 public:
  static NetworkContext::AddHSTSCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_AddHSTS_ProxyToResponder> proxy(
        new NetworkContext_AddHSTS_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_AddHSTS_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_AddHSTS_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_AddHSTS_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::AddHSTSCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_AddHSTS_ProxyToResponder);
};

bool NetworkContext_AddHSTS_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::AddHSTSCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_AddHSTS_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_AddHSTS_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_AddHSTS_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 48, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_AddHSTS_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::AddHSTSCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_AddHSTS_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_AddHSTS_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::AddHSTSCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddHSTS");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_IsHSTSActiveForHost_ProxyToResponder {
 public:
  static NetworkContext::IsHSTSActiveForHostCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_IsHSTSActiveForHost_ProxyToResponder> proxy(
        new NetworkContext_IsHSTSActiveForHost_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_IsHSTSActiveForHost_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_IsHSTSActiveForHost_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_IsHSTSActiveForHost_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::IsHSTSActiveForHostCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_IsHSTSActiveForHost_ProxyToResponder);
};

bool NetworkContext_IsHSTSActiveForHost_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::IsHSTSActiveForHostCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_IsHSTSActiveForHost_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_IsHSTSActiveForHost_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_result{};
  NetworkContext_IsHSTSActiveForHost_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 49, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void NetworkContext_IsHSTSActiveForHost_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::IsHSTSActiveForHostCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("result", in_result);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_IsHSTSActiveForHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_IsHSTSActiveForHost_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->result = in_result;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::IsHSTSActiveForHostCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("IsHSTSActiveForHost");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_GetHSTSState_ProxyToResponder {
 public:
  static NetworkContext::GetHSTSStateCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_GetHSTSState_ProxyToResponder> proxy(
        new NetworkContext_GetHSTSState_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_GetHSTSState_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_GetHSTSState_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_GetHSTSState_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::GetHSTSStateCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::base::Value in_state);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_GetHSTSState_ProxyToResponder);
};

bool NetworkContext_GetHSTSState_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::GetHSTSStateCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_GetHSTSState_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_GetHSTSState_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::Value p_state{};
  NetworkContext_GetHSTSState_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadState(&p_state))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 50, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_state));
  return true;
}

void NetworkContext_GetHSTSState_ProxyToResponder::Run(
    ::base::Value in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::GetHSTSStateCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("state", base::trace_event::ValueToString(in_state, "<value of type ::base::Value>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_GetHSTSState_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_GetHSTSState_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->state)::BaseType::BufferWriter
      state_writer;
  mojo::internal::Serialize<::mojo_base::mojom::DictionaryValueDataView>(
      in_state, buffer, &state_writer, &serialization_context);
  params->state.Set(
      state_writer.is_null() ? nullptr : state_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::GetHSTSStateCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("GetHSTSState");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder {
 public:
  static NetworkContext::SetCorsOriginAccessListsForOriginCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder> proxy(
        new NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::SetCorsOriginAccessListsForOriginCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder);
};

bool NetworkContext_SetCorsOriginAccessListsForOrigin_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::SetCorsOriginAccessListsForOriginCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 51, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::SetCorsOriginAccessListsForOriginCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SetCorsOriginAccessListsForOrigin_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::SetCorsOriginAccessListsForOriginCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SetCorsOriginAccessListsForOrigin");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_DeleteDynamicDataForHost_ProxyToResponder {
 public:
  static NetworkContext::DeleteDynamicDataForHostCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_DeleteDynamicDataForHost_ProxyToResponder> proxy(
        new NetworkContext_DeleteDynamicDataForHost_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_DeleteDynamicDataForHost_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_DeleteDynamicDataForHost_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_DeleteDynamicDataForHost_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::DeleteDynamicDataForHostCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      bool in_result);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_DeleteDynamicDataForHost_ProxyToResponder);
};

bool NetworkContext_DeleteDynamicDataForHost_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::DeleteDynamicDataForHostCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  bool p_result{};
  NetworkContext_DeleteDynamicDataForHost_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_result = input_data_view.result();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 52, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_result));
  return true;
}

void NetworkContext_DeleteDynamicDataForHost_ProxyToResponder::Run(
    bool in_result) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::DeleteDynamicDataForHostCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("result", in_result);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_DeleteDynamicDataForHost_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->result = in_result;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::DeleteDynamicDataForHostCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("DeleteDynamicDataForHost");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder {
 public:
  static NetworkContext::SaveHttpAuthCacheProxyEntriesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder> proxy(
        new NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::SaveHttpAuthCacheProxyEntriesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const ::base::UnguessableToken& in_cache_key);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder);
};

bool NetworkContext_SaveHttpAuthCacheProxyEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::SaveHttpAuthCacheProxyEntriesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::base::UnguessableToken p_cache_key{};
  NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCacheKey(&p_cache_key))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 54, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_cache_key));
  return true;
}

void NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder::Run(
    const ::base::UnguessableToken& in_cache_key) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::SaveHttpAuthCacheProxyEntriesCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cache_key", base::trace_event::ValueToString(in_cache_key, "<value of type const ::base::UnguessableToken&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_SaveHttpAuthCacheProxyEntries_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cache_key)::BaseType::BufferWriter
      cache_key_writer;
  mojo::internal::Serialize<::mojo_base::mojom::UnguessableTokenDataView>(
      in_cache_key, buffer, &cache_key_writer, &serialization_context);
  params->cache_key.Set(
      cache_key_writer.is_null() ? nullptr : cache_key_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cache_key.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cache_key in ");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::SaveHttpAuthCacheProxyEntriesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("SaveHttpAuthCacheProxyEntries");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder {
 public:
  static NetworkContext::LoadHttpAuthCacheProxyEntriesCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder> proxy(
        new NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::LoadHttpAuthCacheProxyEntriesCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder);
};

bool NetworkContext_LoadHttpAuthCacheProxyEntries_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::LoadHttpAuthCacheProxyEntriesCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 55, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::LoadHttpAuthCacheProxyEntriesCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_LoadHttpAuthCacheProxyEntries_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::LoadHttpAuthCacheProxyEntriesCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("LoadHttpAuthCacheProxyEntries");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_AddAuthCacheEntry_ProxyToResponder {
 public:
  static NetworkContext::AddAuthCacheEntryCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_AddAuthCacheEntry_ProxyToResponder> proxy(
        new NetworkContext_AddAuthCacheEntry_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_AddAuthCacheEntry_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_AddAuthCacheEntry_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_AddAuthCacheEntry_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::AddAuthCacheEntryCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_AddAuthCacheEntry_ProxyToResponder);
};

bool NetworkContext_AddAuthCacheEntry_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::AddAuthCacheEntryCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_AddAuthCacheEntry_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_AddAuthCacheEntry_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_AddAuthCacheEntry_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 56, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_AddAuthCacheEntry_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::AddAuthCacheEntryCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_AddAuthCacheEntry_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_AddAuthCacheEntry_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::AddAuthCacheEntryCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddAuthCacheEntry");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder {
 public:
  static NetworkContext::LookupServerBasicAuthCredentialsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder> proxy(
        new NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::LookupServerBasicAuthCredentialsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      const base::Optional<::net::AuthCredentials>& in_credentials);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder);
};

bool NetworkContext_LookupServerBasicAuthCredentials_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::LookupServerBasicAuthCredentialsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  base::Optional<::net::AuthCredentials> p_credentials{};
  NetworkContext_LookupServerBasicAuthCredentials_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadCredentials(&p_credentials))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 57, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_credentials));
  return true;
}

void NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder::Run(
    const base::Optional<::net::AuthCredentials>& in_credentials) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::LookupServerBasicAuthCredentialsCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("credentials", base::trace_event::ValueToString(in_credentials, "<value of type const base::Optional<::net::AuthCredentials>&>"));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_LookupServerBasicAuthCredentials_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->credentials)::BaseType::BufferWriter
      credentials_writer;
  mojo::internal::Serialize<::network::mojom::AuthCredentialsDataView>(
      in_credentials, buffer, &credentials_writer, &serialization_context);
  params->credentials.Set(
      credentials_writer.is_null() ? nullptr : credentials_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::LookupServerBasicAuthCredentialsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("LookupServerBasicAuthCredentials");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder {
 public:
  static NetworkContext::EnableStaticKeyPinningForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder> proxy(
        new NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::EnableStaticKeyPinningForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder);
};

bool NetworkContext_EnableStaticKeyPinningForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::EnableStaticKeyPinningForTestingCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 58, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::EnableStaticKeyPinningForTestingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_EnableStaticKeyPinningForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::EnableStaticKeyPinningForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("EnableStaticKeyPinningForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkContext_EnableStaticKeyPinningForTesting_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_EnableStaticKeyPinningForTesting_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 58, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkContext_VerifyCertificateForTesting_ProxyToResponder {
 public:
  static NetworkContext::VerifyCertificateForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_VerifyCertificateForTesting_ProxyToResponder> proxy(
        new NetworkContext_VerifyCertificateForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_VerifyCertificateForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_VerifyCertificateForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_VerifyCertificateForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::VerifyCertificateForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      int32_t in_error_code);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_VerifyCertificateForTesting_ProxyToResponder);
};

bool NetworkContext_VerifyCertificateForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::VerifyCertificateForTestingCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_VerifyCertificateForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_VerifyCertificateForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_error_code{};
  NetworkContext_VerifyCertificateForTesting_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_error_code = input_data_view.error_code();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 59, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_error_code));
  return true;
}

void NetworkContext_VerifyCertificateForTesting_ProxyToResponder::Run(
    int32_t in_error_code) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)network::mojom::NetworkContext::VerifyCertificateForTestingCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("error_code", in_error_code);
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_VerifyCertificateForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_VerifyCertificateForTesting_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->error_code = in_error_code;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::VerifyCertificateForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("VerifyCertificateForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkContext_VerifyCertificateForTesting_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkContext_VerifyCertificateForTesting_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkContext_VerifyCertificateForTesting_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  int32_t p_error_code{};
  NetworkContext_VerifyCertificateForTesting_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success)
    p_error_code = input_data_view.error_code();
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 59, true);
    return false;
  }
  *out_error_code_ = std::move(p_error_code);
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder {
 public:
  static NetworkContext::AddDomainReliabilityContextForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder> proxy(
        new NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::AddDomainReliabilityContextForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder);
};

bool NetworkContext_AddDomainReliabilityContextForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::AddDomainReliabilityContextForTestingCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 60, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::AddDomainReliabilityContextForTestingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_AddDomainReliabilityContextForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::AddDomainReliabilityContextForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("AddDomainReliabilityContextForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkContext_AddDomainReliabilityContextForTesting_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_AddDomainReliabilityContextForTesting_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 60, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}
class NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder {
 public:
  static NetworkContext::ForceDomainReliabilityUploadsForTestingCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder> proxy(
        new NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "NetworkContext::ForceDomainReliabilityUploadsForTestingCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder);
};

bool NetworkContext_ForceDomainReliabilityUploadsForTesting_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTestingCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data* params =
      reinterpret_cast<
          internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 61, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTestingCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::network::mojom::internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTestingCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(NetworkContext::Name_);
  message.set_method_name("ForceDomainReliabilityUploadsForTesting");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
bool NetworkContext_ForceDomainReliabilityUploadsForTesting_HandleSyncResponse::Accept(
    mojo::Message* message) {

  DCHECK(message->is_serialized());
  internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data* params =
      reinterpret_cast<internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data*>(
          message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        NetworkContext::Name_, 61, true);
    return false;
  }
  mojo::internal::SyncMessageResponseSetup::SetCurrentSyncResponseMessage(
      message);
  *result_ = true;
  return true;
}

// static
bool NetworkContextStubDispatch::Accept(
    NetworkContext* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kNetworkContext_SetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::SetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::SetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_SetClient_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingRemote<NetworkContextClient> p_client{};
      NetworkContext_SetClient_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetClient(
std::move(p_client));
      return true;
    }
    case internal::kNetworkContext_CreateURLLoaderFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateURLLoaderFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateURLLoaderFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateURLLoaderFactory_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateURLLoaderFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> p_url_loader_factory{};
      URLLoaderFactoryParamsPtr p_params{};
      NetworkContext_CreateURLLoaderFactory_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_url_loader_factory =
            input_data_view.TakeUrlLoaderFactory<decltype(p_url_loader_factory)>();
      }
      if (success && !input_data_view.ReadParams(&p_params))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateURLLoaderFactory(
std::move(p_url_loader_factory), 
std::move(p_params));
      return true;
    }
    case internal::kNetworkContext_ResetURLLoaderFactories_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ResetURLLoaderFactories",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ResetURLLoaderFactories");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_ResetURLLoaderFactories_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_ResetURLLoaderFactories_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      NetworkContext_ResetURLLoaderFactories_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResetURLLoaderFactories();
      return true;
    }
    case internal::kNetworkContext_GetCookieManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::GetCookieManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::GetCookieManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_GetCookieManager_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_GetCookieManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::CookieManager> p_cookie_manager{};
      NetworkContext_GetCookieManager_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_cookie_manager =
            input_data_view.TakeCookieManager<decltype(p_cookie_manager)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetCookieManager(
std::move(p_cookie_manager));
      return true;
    }
    case internal::kNetworkContext_GetRestrictedCookieManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::GetRestrictedCookieManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::GetRestrictedCookieManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_GetRestrictedCookieManager_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_GetRestrictedCookieManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::RestrictedCookieManager> p_restricted_cookie_manager{};
      ::network::mojom::RestrictedCookieManagerRole p_role{};
      ::url::Origin p_origin{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::url::Origin p_top_frame_origin{};
      ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> p_cookie_observer{};
      NetworkContext_GetRestrictedCookieManager_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_restricted_cookie_manager =
            input_data_view.TakeRestrictedCookieManager<decltype(p_restricted_cookie_manager)>();
      }
      if (success && !input_data_view.ReadRole(&p_role))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (success) {
        p_cookie_observer =
            input_data_view.TakeCookieObserver<decltype(p_cookie_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetRestrictedCookieManager(
std::move(p_restricted_cookie_manager), 
std::move(p_role), 
std::move(p_origin), 
std::move(p_site_for_cookies), 
std::move(p_top_frame_origin), 
std::move(p_cookie_observer));
      return true;
    }
    case internal::kNetworkContext_GetHasTrustTokensAnswerer_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::GetHasTrustTokensAnswerer",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::GetHasTrustTokensAnswerer");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_GetHasTrustTokensAnswerer_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_GetHasTrustTokensAnswerer_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::HasTrustTokensAnswerer> p_has_trust_tokens_answerer{};
      ::url::Origin p_top_frame_origin{};
      NetworkContext_GetHasTrustTokensAnswerer_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_has_trust_tokens_answerer =
            input_data_view.TakeHasTrustTokensAnswerer<decltype(p_has_trust_tokens_answerer)>();
      }
      if (success && !input_data_view.ReadTopFrameOrigin(&p_top_frame_origin))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHasTrustTokensAnswerer(
std::move(p_has_trust_tokens_answerer), 
std::move(p_top_frame_origin));
      return true;
    }
    case internal::kNetworkContext_ClearTrustTokenData_Name: {
      break;
    }
    case internal::kNetworkContext_ClearNetworkingHistoryBetween_Name: {
      break;
    }
    case internal::kNetworkContext_ClearHttpCache_Name: {
      break;
    }
    case internal::kNetworkContext_ComputeHttpCacheSize_Name: {
      break;
    }
    case internal::kNetworkContext_NotifyExternalCacheHit_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::NotifyExternalCacheHit",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::NotifyExternalCacheHit");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_NotifyExternalCacheHit_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_NotifyExternalCacheHit_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      std::string p_http_method{};
      ::net::NetworkIsolationKey p_key{};
      NetworkContext_NotifyExternalCacheHit_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHttpMethod(&p_http_method))
        success = false;
      if (success && !input_data_view.ReadKey(&p_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyExternalCacheHit(
std::move(p_url), 
std::move(p_http_method), 
std::move(p_key));
      return true;
    }
    case internal::kNetworkContext_ClearHostCache_Name: {
      break;
    }
    case internal::kNetworkContext_ClearHttpAuthCache_Name: {
      break;
    }
    case internal::kNetworkContext_ClearReportingCacheReports_Name: {
      break;
    }
    case internal::kNetworkContext_ClearReportingCacheClients_Name: {
      break;
    }
    case internal::kNetworkContext_ClearNetworkErrorLogging_Name: {
      break;
    }
    case internal::kNetworkContext_ClearDomainReliability_Name: {
      break;
    }
    case internal::kNetworkContext_GetDomainReliabilityJSON_Name: {
      break;
    }
    case internal::kNetworkContext_QueueReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::QueueReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::QueueReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_QueueReport_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_QueueReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_type{};
      std::string p_group{};
      ::GURL p_url{};
      base::Optional<std::string> p_user_agent{};
      ::base::Value p_body{};
      NetworkContext_QueueReport_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadType(&p_type))
        success = false;
      if (success && !input_data_view.ReadGroup(&p_group))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadUserAgent(&p_user_agent))
        success = false;
      if (success && !input_data_view.ReadBody(&p_body))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 18, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueReport(
std::move(p_type), 
std::move(p_group), 
std::move(p_url), 
std::move(p_user_agent), 
std::move(p_body));
      return true;
    }
    case internal::kNetworkContext_QueueSignedExchangeReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::QueueSignedExchangeReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::QueueSignedExchangeReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_QueueSignedExchangeReport_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_QueueSignedExchangeReport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      SignedExchangeReportPtr p_report{};
      NetworkContext_QueueSignedExchangeReport_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadReport(&p_report))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 19, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->QueueSignedExchangeReport(
std::move(p_report));
      return true;
    }
    case internal::kNetworkContext_CloseAllConnections_Name: {
      break;
    }
    case internal::kNetworkContext_CloseIdleConnections_Name: {
      break;
    }
    case internal::kNetworkContext_SetNetworkConditions_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::SetNetworkConditions",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::SetNetworkConditions");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_SetNetworkConditions_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetNetworkConditions_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_throttling_profile_id{};
      NetworkConditionsPtr p_conditions{};
      NetworkContext_SetNetworkConditions_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadThrottlingProfileId(&p_throttling_profile_id))
        success = false;
      if (success && !input_data_view.ReadConditions(&p_conditions))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 22, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetNetworkConditions(
std::move(p_throttling_profile_id), 
std::move(p_conditions));
      return true;
    }
    case internal::kNetworkContext_SetAcceptLanguage_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::SetAcceptLanguage",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::SetAcceptLanguage");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_SetAcceptLanguage_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetAcceptLanguage_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_new_accept_language{};
      NetworkContext_SetAcceptLanguage_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadNewAcceptLanguage(&p_new_accept_language))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 23, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetAcceptLanguage(
std::move(p_new_accept_language));
      return true;
    }
    case internal::kNetworkContext_SetUserAgent_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::SetUserAgent",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::SetUserAgent");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_SetUserAgent_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetUserAgent_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      std::string p_new_user_agent{};
      NetworkContext_SetUserAgent_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadNewUserAgent(&p_new_user_agent))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 24, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetUserAgent(
std::move(p_new_user_agent));
      return true;
    }
    case internal::kNetworkContext_SetEnableReferrers_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::SetEnableReferrers",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::SetEnableReferrers");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_SetEnableReferrers_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetEnableReferrers_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_enable_referrers{};
      NetworkContext_SetEnableReferrers_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_enable_referrers = input_data_view.enable_referrers();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 25, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetEnableReferrers(
std::move(p_enable_referrers));
      return true;
    }
    case internal::kNetworkContext_SetCTPolicy_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::SetCTPolicy",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::SetCTPolicy");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_SetCTPolicy_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetCTPolicy_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      CTPolicyPtr p_ct_policy{};
      NetworkContext_SetCTPolicy_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCtPolicy(&p_ct_policy))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 26, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCTPolicy(
std::move(p_ct_policy));
      return true;
    }
    case internal::kNetworkContext_AddExpectCT_Name: {
      break;
    }
    case internal::kNetworkContext_SetExpectCTTestReport_Name: {
      break;
    }
    case internal::kNetworkContext_GetExpectCTState_Name: {
      break;
    }
    case internal::kNetworkContext_CreateUDPSocket_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateUDPSocket",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateUDPSocket");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateUDPSocket_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateUDPSocket_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::UDPSocket> p_receiver{};
      ::mojo::PendingRemote<::network::mojom::UDPSocketListener> p_listener{};
      NetworkContext_CreateUDPSocket_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (success) {
        p_listener =
            input_data_view.TakeListener<decltype(p_listener)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 30, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateUDPSocket(
std::move(p_receiver), 
std::move(p_listener));
      return true;
    }
    case internal::kNetworkContext_CreateTCPServerSocket_Name: {
      break;
    }
    case internal::kNetworkContext_CreateTCPConnectedSocket_Name: {
      break;
    }
    case internal::kNetworkContext_CreateTCPBoundSocket_Name: {
      break;
    }
    case internal::kNetworkContext_CreateProxyResolvingSocketFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateProxyResolvingSocketFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateProxyResolvingSocketFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateProxyResolvingSocketFactory_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateProxyResolvingSocketFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::ProxyResolvingSocketFactory> p_factory{};
      NetworkContext_CreateProxyResolvingSocketFactory_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 34, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateProxyResolvingSocketFactory(
std::move(p_factory));
      return true;
    }
    case internal::kNetworkContext_LookUpProxyForURL_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::LookUpProxyForURL",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::LookUpProxyForURL");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_LookUpProxyForURL_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_LookUpProxyForURL_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      ::mojo::PendingRemote<::network::mojom::ProxyLookupClient> p_proxy_lookup_client{};
      NetworkContext_LookUpProxyForURL_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (success) {
        p_proxy_lookup_client =
            input_data_view.TakeProxyLookupClient<decltype(p_proxy_lookup_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 35, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LookUpProxyForURL(
std::move(p_url), 
std::move(p_network_isolation_key), 
std::move(p_proxy_lookup_client));
      return true;
    }
    case internal::kNetworkContext_ForceReloadProxyConfig_Name: {
      break;
    }
    case internal::kNetworkContext_ClearBadProxiesCache_Name: {
      break;
    }
    case internal::kNetworkContext_CreateWebSocket_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateWebSocket",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateWebSocket");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateWebSocket_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateWebSocket_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      std::vector<std::string> p_requested_protocols{};
      ::net::SiteForCookies p_site_for_cookies{};
      ::net::IsolationInfo p_isolation_info{};
      std::vector<::network::mojom::HttpHeaderPtr> p_additional_headers{};
      int32_t p_process_id{};
      int32_t p_render_frame_id{};
      ::url::Origin p_origin{};
      uint32_t p_options{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> p_handshake_client{};
      ::mojo::PendingRemote<::network::mojom::AuthenticationHandler> p_auth_handler{};
      ::mojo::PendingRemote<TrustedHeaderClient> p_header_client{};
      NetworkContext_CreateWebSocket_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadRequestedProtocols(&p_requested_protocols))
        success = false;
      if (success && !input_data_view.ReadSiteForCookies(&p_site_for_cookies))
        success = false;
      if (success && !input_data_view.ReadIsolationInfo(&p_isolation_info))
        success = false;
      if (success && !input_data_view.ReadAdditionalHeaders(&p_additional_headers))
        success = false;
      if (success)
        p_process_id = input_data_view.process_id();
      if (success)
        p_render_frame_id = input_data_view.render_frame_id();
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success)
        p_options = input_data_view.options();
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_handshake_client =
            input_data_view.TakeHandshakeClient<decltype(p_handshake_client)>();
      }
      if (success) {
        p_auth_handler =
            input_data_view.TakeAuthHandler<decltype(p_auth_handler)>();
      }
      if (success) {
        p_header_client =
            input_data_view.TakeHeaderClient<decltype(p_header_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 38, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateWebSocket(
std::move(p_url), 
std::move(p_requested_protocols), 
std::move(p_site_for_cookies), 
std::move(p_isolation_info), 
std::move(p_additional_headers), 
std::move(p_process_id), 
std::move(p_render_frame_id), 
std::move(p_origin), 
std::move(p_options), 
std::move(p_traffic_annotation), 
std::move(p_handshake_client), 
std::move(p_auth_handler), 
std::move(p_header_client));
      return true;
    }
    case internal::kNetworkContext_CreateQuicTransport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateQuicTransport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateQuicTransport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateQuicTransport_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateQuicTransport_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::url::Origin p_origin{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      std::vector<::network::mojom::QuicTransportCertificateFingerprintPtr> p_fingerprints{};
      ::mojo::PendingRemote<::network::mojom::QuicTransportHandshakeClient> p_handshake_client{};
      NetworkContext_CreateQuicTransport_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (success && !input_data_view.ReadFingerprints(&p_fingerprints))
        success = false;
      if (success) {
        p_handshake_client =
            input_data_view.TakeHandshakeClient<decltype(p_handshake_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 39, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateQuicTransport(
std::move(p_url), 
std::move(p_origin), 
std::move(p_network_isolation_key), 
std::move(p_fingerprints), 
std::move(p_handshake_client));
      return true;
    }
    case internal::kNetworkContext_CreateNetLogExporter_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateNetLogExporter",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateNetLogExporter");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateNetLogExporter_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateNetLogExporter_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::NetLogExporter> p_receiver{};
      NetworkContext_CreateNetLogExporter_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_receiver =
            input_data_view.TakeReceiver<decltype(p_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 40, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateNetLogExporter(
std::move(p_receiver));
      return true;
    }
    case internal::kNetworkContext_PreconnectSockets_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::PreconnectSockets",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::PreconnectSockets");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_PreconnectSockets_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_PreconnectSockets_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      uint32_t p_num_streams{};
      ::GURL p_url{};
      bool p_allow_credentials{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      NetworkContext_PreconnectSockets_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_num_streams = input_data_view.num_streams();
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success)
        p_allow_credentials = input_data_view.allow_credentials();
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 41, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->PreconnectSockets(
std::move(p_num_streams), 
std::move(p_url), 
std::move(p_allow_credentials), 
std::move(p_network_isolation_key));
      return true;
    }
    case internal::kNetworkContext_CreateP2PSocketManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateP2PSocketManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateP2PSocketManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateP2PSocketManager_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateP2PSocketManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::NetworkIsolationKey p_network_isolation_key{};
      ::mojo::PendingRemote<::network::mojom::P2PTrustedSocketManagerClient> p_client{};
      ::mojo::PendingReceiver<::network::mojom::P2PTrustedSocketManager> p_trusted_socket_manager{};
      ::mojo::PendingReceiver<::network::mojom::P2PSocketManager> p_socket_manager{};
      NetworkContext_CreateP2PSocketManager_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (success) {
        p_client =
            input_data_view.TakeClient<decltype(p_client)>();
      }
      if (success) {
        p_trusted_socket_manager =
            input_data_view.TakeTrustedSocketManager<decltype(p_trusted_socket_manager)>();
      }
      if (success) {
        p_socket_manager =
            input_data_view.TakeSocketManager<decltype(p_socket_manager)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 42, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateP2PSocketManager(
std::move(p_network_isolation_key), 
std::move(p_client), 
std::move(p_trusted_socket_manager), 
std::move(p_socket_manager));
      return true;
    }
    case internal::kNetworkContext_CreateMdnsResponder_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateMdnsResponder",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateMdnsResponder");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateMdnsResponder_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateMdnsResponder_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::MdnsResponder> p_responder_receiver{};
      NetworkContext_CreateMdnsResponder_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_responder_receiver =
            input_data_view.TakeResponderReceiver<decltype(p_responder_receiver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 43, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateMdnsResponder(
std::move(p_responder_receiver));
      return true;
    }
    case internal::kNetworkContext_ResolveHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ResolveHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ResolveHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_ResolveHost_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_ResolveHost_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::HostPortPair p_host{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      ::network::mojom::ResolveHostParametersPtr p_optional_parameters{};
      ::mojo::PendingRemote<::network::mojom::ResolveHostClient> p_response_client{};
      NetworkContext_ResolveHost_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (success && !input_data_view.ReadOptionalParameters(&p_optional_parameters))
        success = false;
      if (success) {
        p_response_client =
            input_data_view.TakeResponseClient<decltype(p_response_client)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 44, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ResolveHost(
std::move(p_host), 
std::move(p_network_isolation_key), 
std::move(p_optional_parameters), 
std::move(p_response_client));
      return true;
    }
    case internal::kNetworkContext_CreateHostResolver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateHostResolver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateHostResolver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_CreateHostResolver_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_CreateHostResolver_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      base::Optional<::net::DnsConfigOverrides> p_config_overrides{};
      ::mojo::PendingReceiver<::network::mojom::HostResolver> p_host_resolver{};
      NetworkContext_CreateHostResolver_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadConfigOverrides(&p_config_overrides))
        success = false;
      if (success) {
        p_host_resolver =
            input_data_view.TakeHostResolver<decltype(p_host_resolver)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 45, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateHostResolver(
std::move(p_config_overrides), 
std::move(p_host_resolver));
      return true;
    }
    case internal::kNetworkContext_VerifyCertForSignedExchange_Name: {
      break;
    }
    case internal::kNetworkContext_ParseHeaders_Name: {
      break;
    }
    case internal::kNetworkContext_AddHSTS_Name: {
      break;
    }
    case internal::kNetworkContext_IsHSTSActiveForHost_Name: {
      break;
    }
    case internal::kNetworkContext_GetHSTSState_Name: {
      break;
    }
    case internal::kNetworkContext_SetCorsOriginAccessListsForOrigin_Name: {
      break;
    }
    case internal::kNetworkContext_DeleteDynamicDataForHost_Name: {
      break;
    }
    case internal::kNetworkContext_SetSplitAuthCacheByNetworkIsolationKey_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::SetSplitAuthCacheByNetworkIsolationKey",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::SetSplitAuthCacheByNetworkIsolationKey");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_SetSplitAuthCacheByNetworkIsolationKey_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetSplitAuthCacheByNetworkIsolationKey_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_split_auth_cache_by_network_isolation_key{};
      NetworkContext_SetSplitAuthCacheByNetworkIsolationKey_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_split_auth_cache_by_network_isolation_key = input_data_view.split_auth_cache_by_network_isolation_key();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 53, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSplitAuthCacheByNetworkIsolationKey(
std::move(p_split_auth_cache_by_network_isolation_key));
      return true;
    }
    case internal::kNetworkContext_SaveHttpAuthCacheProxyEntries_Name: {
      break;
    }
    case internal::kNetworkContext_LoadHttpAuthCacheProxyEntries_Name: {
      break;
    }
    case internal::kNetworkContext_AddAuthCacheEntry_Name: {
      break;
    }
    case internal::kNetworkContext_LookupServerBasicAuthCredentials_Name: {
      break;
    }
    case internal::kNetworkContext_EnableStaticKeyPinningForTesting_Name: {
      break;
    }
    case internal::kNetworkContext_VerifyCertificateForTesting_Name: {
      break;
    }
    case internal::kNetworkContext_AddDomainReliabilityContextForTesting_Name: {
      break;
    }
    case internal::kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name: {
      break;
    }
    case internal::kNetworkContext_GetOriginPolicyManager_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::GetOriginPolicyManager",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::GetOriginPolicyManager");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_GetOriginPolicyManager_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_GetOriginPolicyManager_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::network::mojom::OriginPolicyManager> p_origin_policy_manager{};
      NetworkContext_GetOriginPolicyManager_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_origin_policy_manager =
            input_data_view.TakeOriginPolicyManager<decltype(p_origin_policy_manager)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 62, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetOriginPolicyManager(
std::move(p_origin_policy_manager));
      return true;
    }
    case internal::kNetworkContext_SetSCTAuditingEnabled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::SetSCTAuditingEnabled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::SetSCTAuditingEnabled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::NetworkContext_SetSCTAuditingEnabled_Params_Data* params =
          reinterpret_cast<internal::NetworkContext_SetSCTAuditingEnabled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_enabled{};
      NetworkContext_SetSCTAuditingEnabled_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_enabled = input_data_view.enabled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 63, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetSCTAuditingEnabled(
std::move(p_enabled));
      return true;
    }
  }
  return false;
}

// static
bool NetworkContextStubDispatch::AcceptWithResponder(
    NetworkContext* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kNetworkContext_SetClient_Name: {
      break;
    }
    case internal::kNetworkContext_CreateURLLoaderFactory_Name: {
      break;
    }
    case internal::kNetworkContext_ResetURLLoaderFactories_Name: {
      break;
    }
    case internal::kNetworkContext_GetCookieManager_Name: {
      break;
    }
    case internal::kNetworkContext_GetRestrictedCookieManager_Name: {
      break;
    }
    case internal::kNetworkContext_GetHasTrustTokensAnswerer_Name: {
      break;
    }
    case internal::kNetworkContext_ClearTrustTokenData_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ClearTrustTokenData",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ClearTrustTokenData");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ClearTrustTokenData_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearTrustTokenData_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClearDataFilterPtr p_filter{};
      NetworkContext_ClearTrustTokenData_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 6, false);
        return false;
      }
      NetworkContext::ClearTrustTokenDataCallback callback =
          NetworkContext_ClearTrustTokenData_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearTrustTokenData(
std::move(p_filter), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_ClearNetworkingHistoryBetween_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ClearNetworkingHistoryBetween",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ClearNetworkingHistoryBetween");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ClearNetworkingHistoryBetween_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearNetworkingHistoryBetween_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::Time p_start_time{};
      ::base::Time p_end_time{};
      NetworkContext_ClearNetworkingHistoryBetween_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadEndTime(&p_end_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 7, false);
        return false;
      }
      NetworkContext::ClearNetworkingHistoryBetweenCallback callback =
          NetworkContext_ClearNetworkingHistoryBetween_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearNetworkingHistoryBetween(
std::move(p_start_time), 
std::move(p_end_time), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_ClearHttpCache_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ClearHttpCache",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ClearHttpCache");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ClearHttpCache_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearHttpCache_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::Time p_start_time{};
      ::base::Time p_end_time{};
      ClearDataFilterPtr p_filter{};
      NetworkContext_ClearHttpCache_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadEndTime(&p_end_time))
        success = false;
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 8, false);
        return false;
      }
      NetworkContext::ClearHttpCacheCallback callback =
          NetworkContext_ClearHttpCache_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearHttpCache(
std::move(p_start_time), 
std::move(p_end_time), 
std::move(p_filter), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_ComputeHttpCacheSize_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ComputeHttpCacheSize",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ComputeHttpCacheSize");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ComputeHttpCacheSize_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ComputeHttpCacheSize_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::Time p_start_time{};
      ::base::Time p_end_time{};
      NetworkContext_ComputeHttpCacheSize_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadEndTime(&p_end_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 9, false);
        return false;
      }
      NetworkContext::ComputeHttpCacheSizeCallback callback =
          NetworkContext_ComputeHttpCacheSize_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ComputeHttpCacheSize(
std::move(p_start_time), 
std::move(p_end_time), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_NotifyExternalCacheHit_Name: {
      break;
    }
    case internal::kNetworkContext_ClearHostCache_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ClearHostCache",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ClearHostCache");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ClearHostCache_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearHostCache_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClearDataFilterPtr p_filter{};
      NetworkContext_ClearHostCache_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 11, false);
        return false;
      }
      NetworkContext::ClearHostCacheCallback callback =
          NetworkContext_ClearHostCache_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearHostCache(
std::move(p_filter), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_ClearHttpAuthCache_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ClearHttpAuthCache",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ClearHttpAuthCache");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ClearHttpAuthCache_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearHttpAuthCache_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::Time p_start_time{};
      ::base::Time p_end_time{};
      NetworkContext_ClearHttpAuthCache_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadStartTime(&p_start_time))
        success = false;
      if (success && !input_data_view.ReadEndTime(&p_end_time))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 12, false);
        return false;
      }
      NetworkContext::ClearHttpAuthCacheCallback callback =
          NetworkContext_ClearHttpAuthCache_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearHttpAuthCache(
std::move(p_start_time), 
std::move(p_end_time), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_ClearReportingCacheReports_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ClearReportingCacheReports",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ClearReportingCacheReports");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ClearReportingCacheReports_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearReportingCacheReports_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClearDataFilterPtr p_filter{};
      NetworkContext_ClearReportingCacheReports_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 13, false);
        return false;
      }
      NetworkContext::ClearReportingCacheReportsCallback callback =
          NetworkContext_ClearReportingCacheReports_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearReportingCacheReports(
std::move(p_filter), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_ClearReportingCacheClients_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ClearReportingCacheClients",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ClearReportingCacheClients");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ClearReportingCacheClients_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearReportingCacheClients_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClearDataFilterPtr p_filter{};
      NetworkContext_ClearReportingCacheClients_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 14, false);
        return false;
      }
      NetworkContext::ClearReportingCacheClientsCallback callback =
          NetworkContext_ClearReportingCacheClients_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearReportingCacheClients(
std::move(p_filter), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_ClearNetworkErrorLogging_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ClearNetworkErrorLogging",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ClearNetworkErrorLogging");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ClearNetworkErrorLogging_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearNetworkErrorLogging_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClearDataFilterPtr p_filter{};
      NetworkContext_ClearNetworkErrorLogging_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 15, false);
        return false;
      }
      NetworkContext::ClearNetworkErrorLoggingCallback callback =
          NetworkContext_ClearNetworkErrorLogging_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearNetworkErrorLogging(
std::move(p_filter), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_ClearDomainReliability_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ClearDomainReliability",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ClearDomainReliability");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ClearDomainReliability_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearDomainReliability_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ClearDataFilterPtr p_filter{};
      NetworkContext::DomainReliabilityClearMode p_mode{};
      NetworkContext_ClearDomainReliability_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadFilter(&p_filter))
        success = false;
      if (success && !input_data_view.ReadMode(&p_mode))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 16, false);
        return false;
      }
      NetworkContext::ClearDomainReliabilityCallback callback =
          NetworkContext_ClearDomainReliability_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearDomainReliability(
std::move(p_filter), 
std::move(p_mode), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_GetDomainReliabilityJSON_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::GetDomainReliabilityJSON",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::GetDomainReliabilityJSON");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_GetDomainReliabilityJSON_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_GetDomainReliabilityJSON_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkContext_GetDomainReliabilityJSON_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 17, false);
        return false;
      }
      NetworkContext::GetDomainReliabilityJSONCallback callback =
          NetworkContext_GetDomainReliabilityJSON_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetDomainReliabilityJSON(std::move(callback));
      return true;
    }
    case internal::kNetworkContext_QueueReport_Name: {
      break;
    }
    case internal::kNetworkContext_QueueSignedExchangeReport_Name: {
      break;
    }
    case internal::kNetworkContext_CloseAllConnections_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CloseAllConnections",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CloseAllConnections");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_CloseAllConnections_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_CloseAllConnections_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkContext_CloseAllConnections_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 20, false);
        return false;
      }
      NetworkContext::CloseAllConnectionsCallback callback =
          NetworkContext_CloseAllConnections_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseAllConnections(std::move(callback));
      return true;
    }
    case internal::kNetworkContext_CloseIdleConnections_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CloseIdleConnections",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CloseIdleConnections");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_CloseIdleConnections_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_CloseIdleConnections_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkContext_CloseIdleConnections_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 21, false);
        return false;
      }
      NetworkContext::CloseIdleConnectionsCallback callback =
          NetworkContext_CloseIdleConnections_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CloseIdleConnections(std::move(callback));
      return true;
    }
    case internal::kNetworkContext_SetNetworkConditions_Name: {
      break;
    }
    case internal::kNetworkContext_SetAcceptLanguage_Name: {
      break;
    }
    case internal::kNetworkContext_SetUserAgent_Name: {
      break;
    }
    case internal::kNetworkContext_SetEnableReferrers_Name: {
      break;
    }
    case internal::kNetworkContext_SetCTPolicy_Name: {
      break;
    }
    case internal::kNetworkContext_AddExpectCT_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::AddExpectCT",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::AddExpectCT");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_AddExpectCT_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_AddExpectCT_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_host{};
      ::base::Time p_expiry{};
      bool p_enforce{};
      ::GURL p_report_uri{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      NetworkContext_AddExpectCT_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadExpiry(&p_expiry))
        success = false;
      if (success)
        p_enforce = input_data_view.enforce();
      if (success && !input_data_view.ReadReportUri(&p_report_uri))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 27, false);
        return false;
      }
      NetworkContext::AddExpectCTCallback callback =
          NetworkContext_AddExpectCT_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddExpectCT(
std::move(p_host), 
std::move(p_expiry), 
std::move(p_enforce), 
std::move(p_report_uri), 
std::move(p_network_isolation_key), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_SetExpectCTTestReport_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::SetExpectCTTestReport",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::SetExpectCTTestReport");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_SetExpectCTTestReport_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_SetExpectCTTestReport_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_report_uri{};
      NetworkContext_SetExpectCTTestReport_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadReportUri(&p_report_uri))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 28, false);
        return false;
      }
      NetworkContext::SetExpectCTTestReportCallback callback =
          NetworkContext_SetExpectCTTestReport_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetExpectCTTestReport(
std::move(p_report_uri), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_GetExpectCTState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::GetExpectCTState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::GetExpectCTState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_GetExpectCTState_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_GetExpectCTState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_domain{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      NetworkContext_GetExpectCTState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDomain(&p_domain))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 29, false);
        return false;
      }
      NetworkContext::GetExpectCTStateCallback callback =
          NetworkContext_GetExpectCTState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetExpectCTState(
std::move(p_domain), 
std::move(p_network_isolation_key), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_CreateUDPSocket_Name: {
      break;
    }
    case internal::kNetworkContext_CreateTCPServerSocket_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateTCPServerSocket",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateTCPServerSocket");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_CreateTCPServerSocket_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_CreateTCPServerSocket_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::IPEndPoint p_local_addr{};
      uint32_t p_backlog{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> p_socket{};
      NetworkContext_CreateTCPServerSocket_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
        success = false;
      if (success)
        p_backlog = input_data_view.backlog();
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 31, false);
        return false;
      }
      NetworkContext::CreateTCPServerSocketCallback callback =
          NetworkContext_CreateTCPServerSocket_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTCPServerSocket(
std::move(p_local_addr), 
std::move(p_backlog), 
std::move(p_traffic_annotation), 
std::move(p_socket), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_CreateTCPConnectedSocket_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateTCPConnectedSocket",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateTCPConnectedSocket");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_CreateTCPConnectedSocket_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_CreateTCPConnectedSocket_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      base::Optional<::net::IPEndPoint> p_local_addr{};
      ::net::AddressList p_remote_addr_list{};
      ::network::mojom::TCPConnectedSocketOptionsPtr p_tcp_connected_socket_options{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> p_socket{};
      ::mojo::PendingRemote<::network::mojom::SocketObserver> p_observer{};
      NetworkContext_CreateTCPConnectedSocket_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
        success = false;
      if (success && !input_data_view.ReadRemoteAddrList(&p_remote_addr_list))
        success = false;
      if (success && !input_data_view.ReadTcpConnectedSocketOptions(&p_tcp_connected_socket_options))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (success) {
        p_observer =
            input_data_view.TakeObserver<decltype(p_observer)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 32, false);
        return false;
      }
      NetworkContext::CreateTCPConnectedSocketCallback callback =
          NetworkContext_CreateTCPConnectedSocket_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTCPConnectedSocket(
std::move(p_local_addr), 
std::move(p_remote_addr_list), 
std::move(p_tcp_connected_socket_options), 
std::move(p_traffic_annotation), 
std::move(p_socket), 
std::move(p_observer), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_CreateTCPBoundSocket_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::CreateTCPBoundSocket",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::CreateTCPBoundSocket");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_CreateTCPBoundSocket_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_CreateTCPBoundSocket_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::IPEndPoint p_local_addr{};
      ::net::MutableNetworkTrafficAnnotationTag p_traffic_annotation{};
      ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> p_socket{};
      NetworkContext_CreateTCPBoundSocket_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadLocalAddr(&p_local_addr))
        success = false;
      if (success && !input_data_view.ReadTrafficAnnotation(&p_traffic_annotation))
        success = false;
      if (success) {
        p_socket =
            input_data_view.TakeSocket<decltype(p_socket)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 33, false);
        return false;
      }
      NetworkContext::CreateTCPBoundSocketCallback callback =
          NetworkContext_CreateTCPBoundSocket_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateTCPBoundSocket(
std::move(p_local_addr), 
std::move(p_traffic_annotation), 
std::move(p_socket), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_CreateProxyResolvingSocketFactory_Name: {
      break;
    }
    case internal::kNetworkContext_LookUpProxyForURL_Name: {
      break;
    }
    case internal::kNetworkContext_ForceReloadProxyConfig_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ForceReloadProxyConfig",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ForceReloadProxyConfig");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ForceReloadProxyConfig_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ForceReloadProxyConfig_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkContext_ForceReloadProxyConfig_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 36, false);
        return false;
      }
      NetworkContext::ForceReloadProxyConfigCallback callback =
          NetworkContext_ForceReloadProxyConfig_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceReloadProxyConfig(std::move(callback));
      return true;
    }
    case internal::kNetworkContext_ClearBadProxiesCache_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ClearBadProxiesCache",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ClearBadProxiesCache");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ClearBadProxiesCache_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ClearBadProxiesCache_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkContext_ClearBadProxiesCache_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 37, false);
        return false;
      }
      NetworkContext::ClearBadProxiesCacheCallback callback =
          NetworkContext_ClearBadProxiesCache_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearBadProxiesCache(std::move(callback));
      return true;
    }
    case internal::kNetworkContext_CreateWebSocket_Name: {
      break;
    }
    case internal::kNetworkContext_CreateQuicTransport_Name: {
      break;
    }
    case internal::kNetworkContext_CreateNetLogExporter_Name: {
      break;
    }
    case internal::kNetworkContext_PreconnectSockets_Name: {
      break;
    }
    case internal::kNetworkContext_CreateP2PSocketManager_Name: {
      break;
    }
    case internal::kNetworkContext_CreateMdnsResponder_Name: {
      break;
    }
    case internal::kNetworkContext_ResolveHost_Name: {
      break;
    }
    case internal::kNetworkContext_CreateHostResolver_Name: {
      break;
    }
    case internal::kNetworkContext_VerifyCertForSignedExchange_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::VerifyCertForSignedExchange",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::VerifyCertForSignedExchange");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_VerifyCertForSignedExchange_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_VerifyCertForSignedExchange_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<::net::X509Certificate> p_certificate{};
      ::GURL p_url{};
      std::string p_ocsp_response{};
      std::string p_sct_list{};
      NetworkContext_VerifyCertForSignedExchange_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCertificate(&p_certificate))
        success = false;
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadOcspResponse(&p_ocsp_response))
        success = false;
      if (success && !input_data_view.ReadSctList(&p_sct_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 46, false);
        return false;
      }
      NetworkContext::VerifyCertForSignedExchangeCallback callback =
          NetworkContext_VerifyCertForSignedExchange_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VerifyCertForSignedExchange(
std::move(p_certificate), 
std::move(p_url), 
std::move(p_ocsp_response), 
std::move(p_sct_list), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_ParseHeaders_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ParseHeaders",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ParseHeaders");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ParseHeaders_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ParseHeaders_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::scoped_refptr<::net::HttpResponseHeaders> p_headers{};
      NetworkContext_ParseHeaders_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadHeaders(&p_headers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 47, false);
        return false;
      }
      NetworkContext::ParseHeadersCallback callback =
          NetworkContext_ParseHeaders_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ParseHeaders(
std::move(p_url), 
std::move(p_headers), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_AddHSTS_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::AddHSTS",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::AddHSTS");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_AddHSTS_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_AddHSTS_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_host{};
      ::base::Time p_expiry{};
      bool p_include_subdomains{};
      NetworkContext_AddHSTS_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (success && !input_data_view.ReadExpiry(&p_expiry))
        success = false;
      if (success)
        p_include_subdomains = input_data_view.include_subdomains();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 48, false);
        return false;
      }
      NetworkContext::AddHSTSCallback callback =
          NetworkContext_AddHSTS_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddHSTS(
std::move(p_host), 
std::move(p_expiry), 
std::move(p_include_subdomains), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_IsHSTSActiveForHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::IsHSTSActiveForHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::IsHSTSActiveForHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_IsHSTSActiveForHost_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_IsHSTSActiveForHost_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_host{};
      NetworkContext_IsHSTSActiveForHost_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 49, false);
        return false;
      }
      NetworkContext::IsHSTSActiveForHostCallback callback =
          NetworkContext_IsHSTSActiveForHost_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IsHSTSActiveForHost(
std::move(p_host), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_GetHSTSState_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::GetHSTSState",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::GetHSTSState");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_GetHSTSState_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_GetHSTSState_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_domain{};
      NetworkContext_GetHSTSState_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDomain(&p_domain))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 50, false);
        return false;
      }
      NetworkContext::GetHSTSStateCallback callback =
          NetworkContext_GetHSTSState_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetHSTSState(
std::move(p_domain), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_SetCorsOriginAccessListsForOrigin_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::SetCorsOriginAccessListsForOrigin",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::SetCorsOriginAccessListsForOrigin");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::url::Origin p_source_origin{};
      std::vector<::network::mojom::CorsOriginPatternPtr> p_allow_patterns{};
      std::vector<::network::mojom::CorsOriginPatternPtr> p_block_patterns{};
      NetworkContext_SetCorsOriginAccessListsForOrigin_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSourceOrigin(&p_source_origin))
        success = false;
      if (success && !input_data_view.ReadAllowPatterns(&p_allow_patterns))
        success = false;
      if (success && !input_data_view.ReadBlockPatterns(&p_block_patterns))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 51, false);
        return false;
      }
      NetworkContext::SetCorsOriginAccessListsForOriginCallback callback =
          NetworkContext_SetCorsOriginAccessListsForOrigin_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCorsOriginAccessListsForOrigin(
std::move(p_source_origin), 
std::move(p_allow_patterns), 
std::move(p_block_patterns), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_DeleteDynamicDataForHost_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::DeleteDynamicDataForHost",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::DeleteDynamicDataForHost");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_DeleteDynamicDataForHost_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_DeleteDynamicDataForHost_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      std::string p_host{};
      NetworkContext_DeleteDynamicDataForHost_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadHost(&p_host))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 52, false);
        return false;
      }
      NetworkContext::DeleteDynamicDataForHostCallback callback =
          NetworkContext_DeleteDynamicDataForHost_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DeleteDynamicDataForHost(
std::move(p_host), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_SetSplitAuthCacheByNetworkIsolationKey_Name: {
      break;
    }
    case internal::kNetworkContext_SaveHttpAuthCacheProxyEntries_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::SaveHttpAuthCacheProxyEntries",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::SaveHttpAuthCacheProxyEntries");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkContext_SaveHttpAuthCacheProxyEntries_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 54, false);
        return false;
      }
      NetworkContext::SaveHttpAuthCacheProxyEntriesCallback callback =
          NetworkContext_SaveHttpAuthCacheProxyEntries_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SaveHttpAuthCacheProxyEntries(std::move(callback));
      return true;
    }
    case internal::kNetworkContext_LoadHttpAuthCacheProxyEntries_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::LoadHttpAuthCacheProxyEntries",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::LoadHttpAuthCacheProxyEntries");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::base::UnguessableToken p_cache_key{};
      NetworkContext_LoadHttpAuthCacheProxyEntries_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCacheKey(&p_cache_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 55, false);
        return false;
      }
      NetworkContext::LoadHttpAuthCacheProxyEntriesCallback callback =
          NetworkContext_LoadHttpAuthCacheProxyEntries_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadHttpAuthCacheProxyEntries(
std::move(p_cache_key), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_AddAuthCacheEntry_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::AddAuthCacheEntry",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::AddAuthCacheEntry");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_AddAuthCacheEntry_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_AddAuthCacheEntry_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::net::AuthChallengeInfo p_challenge{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      ::net::AuthCredentials p_credentials{};
      NetworkContext_AddAuthCacheEntry_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadChallenge(&p_challenge))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (success && !input_data_view.ReadCredentials(&p_credentials))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 56, false);
        return false;
      }
      NetworkContext::AddAuthCacheEntryCallback callback =
          NetworkContext_AddAuthCacheEntry_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddAuthCacheEntry(
std::move(p_challenge), 
std::move(p_network_isolation_key), 
std::move(p_credentials), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_LookupServerBasicAuthCredentials_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::LookupServerBasicAuthCredentials",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::LookupServerBasicAuthCredentials");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_LookupServerBasicAuthCredentials_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_LookupServerBasicAuthCredentials_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_url{};
      ::net::NetworkIsolationKey p_network_isolation_key{};
      NetworkContext_LookupServerBasicAuthCredentials_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadUrl(&p_url))
        success = false;
      if (success && !input_data_view.ReadNetworkIsolationKey(&p_network_isolation_key))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 57, false);
        return false;
      }
      NetworkContext::LookupServerBasicAuthCredentialsCallback callback =
          NetworkContext_LookupServerBasicAuthCredentials_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LookupServerBasicAuthCredentials(
std::move(p_url), 
std::move(p_network_isolation_key), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_EnableStaticKeyPinningForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::EnableStaticKeyPinningForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::EnableStaticKeyPinningForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_EnableStaticKeyPinningForTesting_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_EnableStaticKeyPinningForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkContext_EnableStaticKeyPinningForTesting_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 58, false);
        return false;
      }
      NetworkContext::EnableStaticKeyPinningForTestingCallback callback =
          NetworkContext_EnableStaticKeyPinningForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableStaticKeyPinningForTesting(std::move(callback));
      return true;
    }
    case internal::kNetworkContext_VerifyCertificateForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::VerifyCertificateForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::VerifyCertificateForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_VerifyCertificateForTesting_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_VerifyCertificateForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::scoped_refptr<::net::X509Certificate> p_certificate{};
      std::string p_hostname{};
      std::string p_ocsp_response{};
      std::string p_sct_list{};
      NetworkContext_VerifyCertificateForTesting_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCertificate(&p_certificate))
        success = false;
      if (success && !input_data_view.ReadHostname(&p_hostname))
        success = false;
      if (success && !input_data_view.ReadOcspResponse(&p_ocsp_response))
        success = false;
      if (success && !input_data_view.ReadSctList(&p_sct_list))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 59, false);
        return false;
      }
      NetworkContext::VerifyCertificateForTestingCallback callback =
          NetworkContext_VerifyCertificateForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VerifyCertificateForTesting(
std::move(p_certificate), 
std::move(p_hostname), 
std::move(p_ocsp_response), 
std::move(p_sct_list), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_AddDomainReliabilityContextForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::AddDomainReliabilityContextForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::AddDomainReliabilityContextForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_AddDomainReliabilityContextForTesting_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_AddDomainReliabilityContextForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::GURL p_origin{};
      ::GURL p_upload_url{};
      NetworkContext_AddDomainReliabilityContextForTesting_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadOrigin(&p_origin))
        success = false;
      if (success && !input_data_view.ReadUploadUrl(&p_upload_url))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 60, false);
        return false;
      }
      NetworkContext::AddDomainReliabilityContextForTestingCallback callback =
          NetworkContext_AddDomainReliabilityContextForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AddDomainReliabilityContextForTesting(
std::move(p_origin), 
std::move(p_upload_url), std::move(callback));
      return true;
    }
    case internal::kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTesting",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)network::mojom::NetworkContext::ForceDomainReliabilityUploadsForTesting");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data* params =
          reinterpret_cast<
              internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      NetworkContext_ForceDomainReliabilityUploadsForTesting_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            NetworkContext::Name_, 61, false);
        return false;
      }
      NetworkContext::ForceDomainReliabilityUploadsForTestingCallback callback =
          NetworkContext_ForceDomainReliabilityUploadsForTesting_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceDomainReliabilityUploadsForTesting(std::move(callback));
      return true;
    }
    case internal::kNetworkContext_GetOriginPolicyManager_Name: {
      break;
    }
    case internal::kNetworkContext_SetSCTAuditingEnabled_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kNetworkContextValidationInfo[] = {
    {internal::kNetworkContext_SetClient_Name,
     {&internal::NetworkContext_SetClient_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_CreateURLLoaderFactory_Name,
     {&internal::NetworkContext_CreateURLLoaderFactory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_ResetURLLoaderFactories_Name,
     {&internal::NetworkContext_ResetURLLoaderFactories_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_GetCookieManager_Name,
     {&internal::NetworkContext_GetCookieManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_GetRestrictedCookieManager_Name,
     {&internal::NetworkContext_GetRestrictedCookieManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_GetHasTrustTokensAnswerer_Name,
     {&internal::NetworkContext_GetHasTrustTokensAnswerer_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_ClearTrustTokenData_Name,
     {&internal::NetworkContext_ClearTrustTokenData_Params_Data::Validate,
      &internal::NetworkContext_ClearTrustTokenData_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_ClearNetworkingHistoryBetween_Name,
     {&internal::NetworkContext_ClearNetworkingHistoryBetween_Params_Data::Validate,
      &internal::NetworkContext_ClearNetworkingHistoryBetween_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_ClearHttpCache_Name,
     {&internal::NetworkContext_ClearHttpCache_Params_Data::Validate,
      &internal::NetworkContext_ClearHttpCache_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_ComputeHttpCacheSize_Name,
     {&internal::NetworkContext_ComputeHttpCacheSize_Params_Data::Validate,
      &internal::NetworkContext_ComputeHttpCacheSize_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_NotifyExternalCacheHit_Name,
     {&internal::NetworkContext_NotifyExternalCacheHit_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_ClearHostCache_Name,
     {&internal::NetworkContext_ClearHostCache_Params_Data::Validate,
      &internal::NetworkContext_ClearHostCache_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_ClearHttpAuthCache_Name,
     {&internal::NetworkContext_ClearHttpAuthCache_Params_Data::Validate,
      &internal::NetworkContext_ClearHttpAuthCache_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_ClearReportingCacheReports_Name,
     {&internal::NetworkContext_ClearReportingCacheReports_Params_Data::Validate,
      &internal::NetworkContext_ClearReportingCacheReports_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_ClearReportingCacheClients_Name,
     {&internal::NetworkContext_ClearReportingCacheClients_Params_Data::Validate,
      &internal::NetworkContext_ClearReportingCacheClients_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_ClearNetworkErrorLogging_Name,
     {&internal::NetworkContext_ClearNetworkErrorLogging_Params_Data::Validate,
      &internal::NetworkContext_ClearNetworkErrorLogging_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_ClearDomainReliability_Name,
     {&internal::NetworkContext_ClearDomainReliability_Params_Data::Validate,
      &internal::NetworkContext_ClearDomainReliability_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_GetDomainReliabilityJSON_Name,
     {&internal::NetworkContext_GetDomainReliabilityJSON_Params_Data::Validate,
      &internal::NetworkContext_GetDomainReliabilityJSON_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_QueueReport_Name,
     {&internal::NetworkContext_QueueReport_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_QueueSignedExchangeReport_Name,
     {&internal::NetworkContext_QueueSignedExchangeReport_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_CloseAllConnections_Name,
     {&internal::NetworkContext_CloseAllConnections_Params_Data::Validate,
      &internal::NetworkContext_CloseAllConnections_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_CloseIdleConnections_Name,
     {&internal::NetworkContext_CloseIdleConnections_Params_Data::Validate,
      &internal::NetworkContext_CloseIdleConnections_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_SetNetworkConditions_Name,
     {&internal::NetworkContext_SetNetworkConditions_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_SetAcceptLanguage_Name,
     {&internal::NetworkContext_SetAcceptLanguage_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_SetUserAgent_Name,
     {&internal::NetworkContext_SetUserAgent_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_SetEnableReferrers_Name,
     {&internal::NetworkContext_SetEnableReferrers_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_SetCTPolicy_Name,
     {&internal::NetworkContext_SetCTPolicy_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_AddExpectCT_Name,
     {&internal::NetworkContext_AddExpectCT_Params_Data::Validate,
      &internal::NetworkContext_AddExpectCT_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_SetExpectCTTestReport_Name,
     {&internal::NetworkContext_SetExpectCTTestReport_Params_Data::Validate,
      &internal::NetworkContext_SetExpectCTTestReport_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_GetExpectCTState_Name,
     {&internal::NetworkContext_GetExpectCTState_Params_Data::Validate,
      &internal::NetworkContext_GetExpectCTState_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_CreateUDPSocket_Name,
     {&internal::NetworkContext_CreateUDPSocket_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_CreateTCPServerSocket_Name,
     {&internal::NetworkContext_CreateTCPServerSocket_Params_Data::Validate,
      &internal::NetworkContext_CreateTCPServerSocket_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_CreateTCPConnectedSocket_Name,
     {&internal::NetworkContext_CreateTCPConnectedSocket_Params_Data::Validate,
      &internal::NetworkContext_CreateTCPConnectedSocket_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_CreateTCPBoundSocket_Name,
     {&internal::NetworkContext_CreateTCPBoundSocket_Params_Data::Validate,
      &internal::NetworkContext_CreateTCPBoundSocket_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_CreateProxyResolvingSocketFactory_Name,
     {&internal::NetworkContext_CreateProxyResolvingSocketFactory_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_LookUpProxyForURL_Name,
     {&internal::NetworkContext_LookUpProxyForURL_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_ForceReloadProxyConfig_Name,
     {&internal::NetworkContext_ForceReloadProxyConfig_Params_Data::Validate,
      &internal::NetworkContext_ForceReloadProxyConfig_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_ClearBadProxiesCache_Name,
     {&internal::NetworkContext_ClearBadProxiesCache_Params_Data::Validate,
      &internal::NetworkContext_ClearBadProxiesCache_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_CreateWebSocket_Name,
     {&internal::NetworkContext_CreateWebSocket_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_CreateQuicTransport_Name,
     {&internal::NetworkContext_CreateQuicTransport_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_CreateNetLogExporter_Name,
     {&internal::NetworkContext_CreateNetLogExporter_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_PreconnectSockets_Name,
     {&internal::NetworkContext_PreconnectSockets_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_CreateP2PSocketManager_Name,
     {&internal::NetworkContext_CreateP2PSocketManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_CreateMdnsResponder_Name,
     {&internal::NetworkContext_CreateMdnsResponder_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_ResolveHost_Name,
     {&internal::NetworkContext_ResolveHost_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_CreateHostResolver_Name,
     {&internal::NetworkContext_CreateHostResolver_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_VerifyCertForSignedExchange_Name,
     {&internal::NetworkContext_VerifyCertForSignedExchange_Params_Data::Validate,
      &internal::NetworkContext_VerifyCertForSignedExchange_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_ParseHeaders_Name,
     {&internal::NetworkContext_ParseHeaders_Params_Data::Validate,
      &internal::NetworkContext_ParseHeaders_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_AddHSTS_Name,
     {&internal::NetworkContext_AddHSTS_Params_Data::Validate,
      &internal::NetworkContext_AddHSTS_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_IsHSTSActiveForHost_Name,
     {&internal::NetworkContext_IsHSTSActiveForHost_Params_Data::Validate,
      &internal::NetworkContext_IsHSTSActiveForHost_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_GetHSTSState_Name,
     {&internal::NetworkContext_GetHSTSState_Params_Data::Validate,
      &internal::NetworkContext_GetHSTSState_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_SetCorsOriginAccessListsForOrigin_Name,
     {&internal::NetworkContext_SetCorsOriginAccessListsForOrigin_Params_Data::Validate,
      &internal::NetworkContext_SetCorsOriginAccessListsForOrigin_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_DeleteDynamicDataForHost_Name,
     {&internal::NetworkContext_DeleteDynamicDataForHost_Params_Data::Validate,
      &internal::NetworkContext_DeleteDynamicDataForHost_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_SetSplitAuthCacheByNetworkIsolationKey_Name,
     {&internal::NetworkContext_SetSplitAuthCacheByNetworkIsolationKey_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_SaveHttpAuthCacheProxyEntries_Name,
     {&internal::NetworkContext_SaveHttpAuthCacheProxyEntries_Params_Data::Validate,
      &internal::NetworkContext_SaveHttpAuthCacheProxyEntries_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_LoadHttpAuthCacheProxyEntries_Name,
     {&internal::NetworkContext_LoadHttpAuthCacheProxyEntries_Params_Data::Validate,
      &internal::NetworkContext_LoadHttpAuthCacheProxyEntries_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_AddAuthCacheEntry_Name,
     {&internal::NetworkContext_AddAuthCacheEntry_Params_Data::Validate,
      &internal::NetworkContext_AddAuthCacheEntry_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_LookupServerBasicAuthCredentials_Name,
     {&internal::NetworkContext_LookupServerBasicAuthCredentials_Params_Data::Validate,
      &internal::NetworkContext_LookupServerBasicAuthCredentials_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_EnableStaticKeyPinningForTesting_Name,
     {&internal::NetworkContext_EnableStaticKeyPinningForTesting_Params_Data::Validate,
      &internal::NetworkContext_EnableStaticKeyPinningForTesting_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_VerifyCertificateForTesting_Name,
     {&internal::NetworkContext_VerifyCertificateForTesting_Params_Data::Validate,
      &internal::NetworkContext_VerifyCertificateForTesting_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_AddDomainReliabilityContextForTesting_Name,
     {&internal::NetworkContext_AddDomainReliabilityContextForTesting_Params_Data::Validate,
      &internal::NetworkContext_AddDomainReliabilityContextForTesting_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_ForceDomainReliabilityUploadsForTesting_Name,
     {&internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_Params_Data::Validate,
      &internal::NetworkContext_ForceDomainReliabilityUploadsForTesting_ResponseParams_Data::Validate}},
    {internal::kNetworkContext_GetOriginPolicyManager_Name,
     {&internal::NetworkContext_GetOriginPolicyManager_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kNetworkContext_SetSCTAuditingEnabled_Name,
     {&internal::NetworkContext_SetSCTAuditingEnabled_Params_Data::Validate,
      nullptr /* no response */}},
};

bool NetworkContextRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkContext::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kNetworkContextValidationInfo);
}

bool NetworkContextResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::network::mojom::NetworkContext::Name_;
  return mojo::internal::ValidateResponseGeneric(message, name, kNetworkContextValidationInfo);

}
}  // namespace mojom
}  // namespace network

namespace mojo {


// static
bool StructTraits<::network::mojom::CustomProxyConfig::DataView, ::network::mojom::CustomProxyConfigPtr>::Read(
    ::network::mojom::CustomProxyConfig::DataView input,
    ::network::mojom::CustomProxyConfigPtr* output) {
  bool success = true;
  ::network::mojom::CustomProxyConfigPtr result(::network::mojom::CustomProxyConfig::New());
  
      if (success && !input.ReadRules(&result->rules))
        success = false;
      if (success)
        result->should_override_existing_config = input.should_override_existing_config();
      if (success)
        result->allow_non_idempotent_methods = input.allow_non_idempotent_methods();
      if (success && !input.ReadConnectTunnelHeaders(&result->connect_tunnel_headers))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CertVerifierCreationParams::DataView, ::network::mojom::CertVerifierCreationParamsPtr>::Read(
    ::network::mojom::CertVerifierCreationParams::DataView input,
    ::network::mojom::CertVerifierCreationParamsPtr* output) {
  bool success = true;
  ::network::mojom::CertVerifierCreationParamsPtr result(::network::mojom::CertVerifierCreationParams::New());
  
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CertVerifierServiceRemoteParams::DataView, ::network::mojom::CertVerifierServiceRemoteParamsPtr>::Read(
    ::network::mojom::CertVerifierServiceRemoteParams::DataView input,
    ::network::mojom::CertVerifierServiceRemoteParamsPtr* output) {
  bool success = true;
  ::network::mojom::CertVerifierServiceRemoteParamsPtr result(::network::mojom::CertVerifierServiceRemoteParams::New());
  
      if (success) {
        result->cert_verifier_service =
            input.TakeCertVerifierService<decltype(result->cert_verifier_service)>();
      }
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::HttpAuthStaticNetworkContextParams::DataView, ::network::mojom::HttpAuthStaticNetworkContextParamsPtr>::Read(
    ::network::mojom::HttpAuthStaticNetworkContextParams::DataView input,
    ::network::mojom::HttpAuthStaticNetworkContextParamsPtr* output) {
  bool success = true;
  ::network::mojom::HttpAuthStaticNetworkContextParamsPtr result(::network::mojom::HttpAuthStaticNetworkContextParams::New());
  
      if (success && !input.ReadAllowDefaultCredentials(&result->allow_default_credentials))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::CTPolicy::DataView, ::network::mojom::CTPolicyPtr>::Read(
    ::network::mojom::CTPolicy::DataView input,
    ::network::mojom::CTPolicyPtr* output) {
  bool success = true;
  ::network::mojom::CTPolicyPtr result(::network::mojom::CTPolicy::New());
  
      if (success && !input.ReadRequiredHosts(&result->required_hosts))
        success = false;
      if (success && !input.ReadExcludedHosts(&result->excluded_hosts))
        success = false;
      if (success && !input.ReadExcludedSpkis(&result->excluded_spkis))
        success = false;
      if (success && !input.ReadExcludedLegacySpkis(&result->excluded_legacy_spkis))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::NetworkContextParams::DataView, ::network::mojom::NetworkContextParamsPtr>::Read(
    ::network::mojom::NetworkContextParams::DataView input,
    ::network::mojom::NetworkContextParamsPtr* output) {
  bool success = true;
  ::network::mojom::NetworkContextParamsPtr result(::network::mojom::NetworkContextParams::New());
  
      if (success && !input.ReadContextName(&result->context_name))
        success = false;
      if (success && !input.ReadUserAgent(&result->user_agent))
        success = false;
      if (success && !input.ReadAcceptLanguage(&result->accept_language))
        success = false;
      if (success)
        result->enable_brotli = input.enable_brotli();
      if (success && !input.ReadQuicUserAgentId(&result->quic_user_agent_id))
        success = false;
      if (success)
        result->enable_referrers = input.enable_referrers();
      if (success)
        result->validate_referrer_policy_on_initial_request = input.validate_referrer_policy_on_initial_request();
      if (success) {
        result->proxy_resolver_factory =
            input.TakeProxyResolverFactory<decltype(result->proxy_resolver_factory)>();
      }
      if (success && !input.ReadCookiePath(&result->cookie_path))
        success = false;
      if (success && !input.ReadTrustTokenPath(&result->trust_token_path))
        success = false;
      if (success)
        result->enable_encrypted_cookies = input.enable_encrypted_cookies();
      if (success)
        result->restore_old_session_cookies = input.restore_old_session_cookies();
      if (success)
        result->persist_session_cookies = input.persist_session_cookies();
      if (success)
        result->http_cache_enabled = input.http_cache_enabled();
      if (success)
        result->http_cache_max_size = input.http_cache_max_size();
      if (success && !input.ReadHttpCachePath(&result->http_cache_path))
        success = false;
      if (success && !input.ReadHttpServerPropertiesPath(&result->http_server_properties_path))
        success = false;
      if (success && !input.ReadTransportSecurityPersisterPath(&result->transport_security_persister_path))
        success = false;
      if (success)
        result->enable_ftp_url_support = input.enable_ftp_url_support();
      if (success)
        result->disable_idle_sockets_close_on_memory_pressure = input.disable_idle_sockets_close_on_memory_pressure();
      if (success && !input.ReadInitialSslConfig(&result->initial_ssl_config))
        success = false;
      if (success) {
        result->ssl_config_client_receiver =
            input.TakeSslConfigClientReceiver<decltype(result->ssl_config_client_receiver)>();
      }
      if (success && !input.ReadInitialProxyConfig(&result->initial_proxy_config))
        success = false;
      if (success) {
        result->proxy_config_client_receiver =
            input.TakeProxyConfigClientReceiver<decltype(result->proxy_config_client_receiver)>();
      }
      if (success && !input.ReadInitialCustomProxyConfig(&result->initial_custom_proxy_config))
        success = false;
      if (success) {
        result->custom_proxy_config_client_receiver =
            input.TakeCustomProxyConfigClientReceiver<decltype(result->custom_proxy_config_client_receiver)>();
      }
      if (success) {
        result->proxy_config_poller_client =
            input.TakeProxyConfigPollerClient<decltype(result->proxy_config_poller_client)>();
      }
      if (success) {
        result->proxy_error_client =
            input.TakeProxyErrorClient<decltype(result->proxy_error_client)>();
      }
      if (success)
        result->pac_quick_check_enabled = input.pac_quick_check_enabled();
      if (success)
        result->enable_certificate_reporting = input.enable_certificate_reporting();
      if (success)
        result->enforce_chrome_ct_policy = input.enforce_chrome_ct_policy();
      if (success)
        result->enable_expect_ct_reporting = input.enable_expect_ct_reporting();
      if (success)
        result->enable_sct_auditing = input.enable_sct_auditing();
      if (success && !input.ReadCtLogs(&result->ct_logs))
        success = false;
      if (success && !input.ReadCtPolicy(&result->ct_policy))
        success = false;
      if (success && !input.ReadCtLogUpdateTime(&result->ct_log_update_time))
        success = false;
      if (success && !input.ReadCertVerifierParams(&result->cert_verifier_params))
        success = false;
      if (success && !input.ReadCookieManagerParams(&result->cookie_manager_params))
        success = false;
      if (success) {
        result->cookie_manager =
            input.TakeCookieManager<decltype(result->cookie_manager)>();
      }
      if (success)
        result->enable_domain_reliability = input.enable_domain_reliability();
      if (success && !input.ReadDomainReliabilityUploadReporter(&result->domain_reliability_upload_reporter))
        success = false;
      if (success)
        result->discard_domain_reliablity_uploads = input.discard_domain_reliablity_uploads();
      if (success && !input.ReadReportingDeliveryInterval(&result->reporting_delivery_interval))
        success = false;
      if (success)
        result->skip_reporting_send_permission_check = input.skip_reporting_send_permission_check();
      if (success && !input.ReadCorsOriginAccessList(&result->cors_origin_access_list))
        success = false;
      if (success && !input.ReadCorsExemptHeaderList(&result->cors_exempt_header_list))
        success = false;
      if (success)
        result->allow_any_cors_exempt_header_for_browser = input.allow_any_cors_exempt_header_for_browser();
      if (success && !input.ReadHstsPolicyBypassList(&result->hsts_policy_bypass_list))
        success = false;
      if (success && !input.ReadReportingAndNelStorePath(&result->reporting_and_nel_store_path))
        success = false;
      if (success && !input.ReadHttpAuthStaticNetworkContextParams(&result->http_auth_static_network_context_params))
        success = false;
      if (success)
        result->reset_http_cache_backend = input.reset_http_cache_backend();
      if (success)
        result->split_auth_cache_by_network_isolation_key = input.split_auth_cache_by_network_isolation_key();
      if (success)
        result->require_network_isolation_key = input.require_network_isolation_key();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::NetworkConditions::DataView, ::network::mojom::NetworkConditionsPtr>::Read(
    ::network::mojom::NetworkConditions::DataView input,
    ::network::mojom::NetworkConditionsPtr* output) {
  bool success = true;
  ::network::mojom::NetworkConditionsPtr result(::network::mojom::NetworkConditions::New());
  
      if (success)
        result->offline = input.offline();
      if (success && !input.ReadLatency(&result->latency))
        success = false;
      if (success)
        result->download_throughput = input.download_throughput();
      if (success)
        result->upload_throughput = input.upload_throughput();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::ClearDataFilter::DataView, ::network::mojom::ClearDataFilterPtr>::Read(
    ::network::mojom::ClearDataFilter::DataView input,
    ::network::mojom::ClearDataFilterPtr* output) {
  bool success = true;
  ::network::mojom::ClearDataFilterPtr result(::network::mojom::ClearDataFilter::New());
  
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadDomains(&result->domains))
        success = false;
      if (success && !input.ReadOrigins(&result->origins))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::NetworkUsage::DataView, ::network::mojom::NetworkUsagePtr>::Read(
    ::network::mojom::NetworkUsage::DataView input,
    ::network::mojom::NetworkUsagePtr* output) {
  bool success = true;
  ::network::mojom::NetworkUsagePtr result(::network::mojom::NetworkUsage::New());
  
      if (success)
        result->process_id = input.process_id();
      if (success)
        result->routing_id = input.routing_id();
      if (success)
        result->total_bytes_received = input.total_bytes_received();
      if (success)
        result->total_bytes_sent = input.total_bytes_sent();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::SignedExchangeReport::DataView, ::network::mojom::SignedExchangeReportPtr>::Read(
    ::network::mojom::SignedExchangeReport::DataView input,
    ::network::mojom::SignedExchangeReportPtr* output) {
  bool success = true;
  ::network::mojom::SignedExchangeReportPtr result(::network::mojom::SignedExchangeReport::New());
  
      if (success)
        result->success = input.success();
      if (success && !input.ReadType(&result->type))
        success = false;
      if (success && !input.ReadOuterUrl(&result->outer_url))
        success = false;
      if (success && !input.ReadInnerUrl(&result->inner_url))
        success = false;
      if (success && !input.ReadCertUrl(&result->cert_url))
        success = false;
      if (success && !input.ReadReferrer(&result->referrer))
        success = false;
      if (success && !input.ReadServerIpAddress(&result->server_ip_address))
        success = false;
      if (success && !input.ReadProtocol(&result->protocol))
        success = false;
      if (success && !input.ReadMethod(&result->method))
        success = false;
      if (success)
        result->status_code = input.status_code();
      if (success && !input.ReadElapsedTime(&result->elapsed_time))
        success = false;
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::URLLoaderFactoryOverride::DataView, ::network::mojom::URLLoaderFactoryOverridePtr>::Read(
    ::network::mojom::URLLoaderFactoryOverride::DataView input,
    ::network::mojom::URLLoaderFactoryOverridePtr* output) {
  bool success = true;
  ::network::mojom::URLLoaderFactoryOverridePtr result(::network::mojom::URLLoaderFactoryOverride::New());
  
      if (success) {
        result->overriding_factory =
            input.TakeOverridingFactory<decltype(result->overriding_factory)>();
      }
      if (success) {
        result->overridden_factory_receiver =
            input.TakeOverriddenFactoryReceiver<decltype(result->overridden_factory_receiver)>();
      }
      if (success)
        result->skip_cors_enabled_scheme_check = input.skip_cors_enabled_scheme_check();
  *output = std::move(result);
  return success;
}


// static
bool StructTraits<::network::mojom::URLLoaderFactoryParams::DataView, ::network::mojom::URLLoaderFactoryParamsPtr>::Read(
    ::network::mojom::URLLoaderFactoryParams::DataView input,
    ::network::mojom::URLLoaderFactoryParamsPtr* output) {
  bool success = true;
  ::network::mojom::URLLoaderFactoryParamsPtr result(::network::mojom::URLLoaderFactoryParams::New());
  
      if (success)
        result->process_id = input.process_id();
      if (success && !input.ReadRequestInitiatorOriginLock(&result->request_initiator_origin_lock))
        success = false;
      if (success)
        result->is_corb_enabled = input.is_corb_enabled();
      if (success)
        result->ignore_isolated_world_origin = input.ignore_isolated_world_origin();
      if (success)
        result->unsafe_non_webby_initiator = input.unsafe_non_webby_initiator();
      if (success)
        result->disable_web_security = input.disable_web_security();
      if (success) {
        result->header_client =
            input.TakeHeaderClient<decltype(result->header_client)>();
      }
      if (success && !input.ReadFactoryBoundAccessPatterns(&result->factory_bound_access_patterns))
        success = false;
      if (success && !input.ReadIsolationInfo(&result->isolation_info))
        success = false;
      if (success)
        result->disable_secure_dns = input.disable_secure_dns();
      if (success)
        result->is_trusted = input.is_trusted();
      if (success)
        result->automatically_assign_isolation_info = input.automatically_assign_isolation_info();
      if (success && !input.ReadTopFrameId(&result->top_frame_id))
        success = false;
      if (success && !input.ReadFactoryOverride(&result->factory_override))
        success = false;
      if (success && !input.ReadClientSecurityState(&result->client_security_state))
        success = false;
      if (success) {
        result->coep_reporter =
            input.TakeCoepReporter<decltype(result->coep_reporter)>();
      }
      if (success) {
        result->cookie_observer =
            input.TakeCookieObserver<decltype(result->cookie_observer)>();
      }
      if (success && !input.ReadTrustTokenRedemptionPolicy(&result->trust_token_redemption_policy))
        success = false;
      if (success && !input.ReadDebugTag(&result->debug_tag))
        success = false;
  *output = std::move(result);
  return success;
}

// static
bool UnionTraits<::network::mojom::CertVerifierParams::DataView, ::network::mojom::CertVerifierParamsPtr>::Read(
    ::network::mojom::CertVerifierParams::DataView input,
    ::network::mojom::CertVerifierParamsPtr* output) {
  using UnionType = ::network::mojom::CertVerifierParams;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::REMOTE_PARAMS: {
      ::network::mojom::CertVerifierServiceRemoteParamsPtr result_remote_params;
      if (!input.ReadRemoteParams(&result_remote_params))
        return false;

      *output = UnionType::NewRemoteParams(
          std::move(result_remote_params));
      break;
    }
    case Tag::CREATION_PARAMS: {
      ::network::mojom::CertVerifierCreationParamsPtr result_creation_params;
      if (!input.ReadCreationParams(&result_creation_params))
        return false;

      *output = UnionType::NewCreationParams(
          std::move(result_creation_params));
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif