// services/network/public/mojom/network_context.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/network_context.mojom-shared.h"
#include "services/network/public/mojom/network_context.mojom-forward.h"
#include "mojo/public/mojom/base/big_buffer.mojom-forward.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "mojo/public/mojom/base/time.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include "mojo/public/mojom/base/values.mojom.h"
#include "services/network/public/mojom/address_list.mojom.h"
#include "services/network/public/mojom/cert_verifier_service.mojom.h"
#include "services/network/public/mojom/client_security_state.mojom.h"
#include "services/network/public/mojom/cookie_access_observer.mojom.h"
#include "services/network/public/mojom/cookie_manager.mojom.h"
#include "services/network/public/mojom/cors_origin_pattern.mojom.h"
#include "services/network/public/mojom/cross_origin_embedder_policy.mojom.h"
#include "services/network/public/mojom/default_credentials.mojom.h"
#include "services/network/public/mojom/host_resolver.mojom.h"
#include "services/network/public/mojom/http_request_headers.mojom.h"
#include "services/network/public/mojom/ip_address.mojom.h"
#include "services/network/public/mojom/ip_endpoint.mojom.h"
#include "services/network/public/mojom/ip_address_space.mojom-forward.h"
#include "services/network/public/mojom/mdns_responder.mojom.h"
#include "services/network/public/mojom/mutable_network_traffic_annotation_tag.mojom.h"
#include "services/network/public/mojom/net_log.mojom.h"
#include "services/network/public/mojom/network_isolation_key.mojom.h"
#include "services/network/public/mojom/isolation_info.mojom.h"
#include "services/network/public/mojom/network_param.mojom.h"
#include "services/network/public/mojom/origin_policy_manager.mojom.h"
#include "services/network/public/mojom/parsed_headers.mojom.h"
#include "services/network/public/mojom/p2p.mojom.h"
#include "services/network/public/mojom/p2p_trusted.mojom.h"
#include "services/network/public/mojom/proxy_config.mojom.h"
#include "services/network/public/mojom/proxy_config_with_annotation.mojom.h"
#include "services/network/public/mojom/proxy_lookup_client.mojom.h"
#include "services/network/public/mojom/proxy_resolving_socket.mojom.h"
#include "services/network/public/mojom/quic_transport.mojom.h"
#include "services/network/public/mojom/restricted_cookie_manager.mojom.h"
#include "services/network/public/mojom/site_for_cookies.mojom.h"
#include "services/network/public/mojom/ssl_config.mojom.h"
#include "services/network/public/mojom/tcp_socket.mojom.h"
#include "services/network/public/mojom/trust_tokens.mojom.h"
#include "services/network/public/mojom/udp_socket.mojom.h"
#include "services/network/public/mojom/url_loader.mojom.h"
#include "services/network/public/mojom/url_loader_factory.mojom.h"
#include "services/network/public/mojom/url_response_head.mojom.h"
#include "services/network/public/mojom/websocket.mojom.h"
#include "services/proxy_resolver/public/mojom/proxy_resolver.mojom.h"
#include "url/mojom/origin.mojom.h"
#include "url/mojom/url.mojom.h"
#include "services/network/public/mojom/ct_log_info.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {

class CustomProxyConfigClientProxy;

template <typename ImplRefTraits>
class CustomProxyConfigClientStub;

class CustomProxyConfigClientRequestValidator;
class CustomProxyConfigClientResponseValidator;


class  CustomProxyConfigClient
    : public CustomProxyConfigClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = CustomProxyConfigClientInterfaceBase;
  using Proxy_ = CustomProxyConfigClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = CustomProxyConfigClientStub<ImplRefTraits>;

  using RequestValidator_ = CustomProxyConfigClientRequestValidator;
  using ResponseValidator_ = CustomProxyConfigClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnCustomProxyConfigUpdatedMinVersion = 0,
    kMarkProxiesAsBadMinVersion = 0,
    kClearBadProxiesCacheMinVersion = 0,
  };
  virtual ~CustomProxyConfigClient() {}

  
  virtual void OnCustomProxyConfigUpdated(CustomProxyConfigPtr proxy_config) = 0;


  using MarkProxiesAsBadCallback = base::OnceCallback<void()>;
  
  virtual void MarkProxiesAsBad(::base::TimeDelta bypass_duration, const ::net::ProxyList& bad_proxies, MarkProxiesAsBadCallback callback) = 0;

  
  virtual void ClearBadProxiesCache() = 0;
};

class TrustedHeaderClientProxy;

template <typename ImplRefTraits>
class TrustedHeaderClientStub;

class TrustedHeaderClientRequestValidator;
class TrustedHeaderClientResponseValidator;


class  TrustedHeaderClient
    : public TrustedHeaderClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = TrustedHeaderClientInterfaceBase;
  using Proxy_ = TrustedHeaderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = TrustedHeaderClientStub<ImplRefTraits>;

  using RequestValidator_ = TrustedHeaderClientRequestValidator;
  using ResponseValidator_ = TrustedHeaderClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnBeforeSendHeadersMinVersion = 0,
    kOnHeadersReceivedMinVersion = 0,
  };
  virtual ~TrustedHeaderClient() {}


  using OnBeforeSendHeadersCallback = base::OnceCallback<void(int32_t, const base::Optional<::net::HttpRequestHeaders>&)>;
  
  virtual void OnBeforeSendHeaders(const ::net::HttpRequestHeaders& headers, OnBeforeSendHeadersCallback callback) = 0;


  using OnHeadersReceivedCallback = base::OnceCallback<void(int32_t, const base::Optional<std::string>&, const base::Optional<::GURL>&)>;
  
  virtual void OnHeadersReceived(const std::string& headers, const ::net::IPEndPoint& remote_endpoint, OnHeadersReceivedCallback callback) = 0;
};

class TrustedURLLoaderHeaderClientProxy;

template <typename ImplRefTraits>
class TrustedURLLoaderHeaderClientStub;

class TrustedURLLoaderHeaderClientRequestValidator;


class  TrustedURLLoaderHeaderClient
    : public TrustedURLLoaderHeaderClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = TrustedURLLoaderHeaderClientInterfaceBase;
  using Proxy_ = TrustedURLLoaderHeaderClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = TrustedURLLoaderHeaderClientStub<ImplRefTraits>;

  using RequestValidator_ = TrustedURLLoaderHeaderClientRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnLoaderCreatedMinVersion = 0,
    kOnLoaderForCorsPreflightCreatedMinVersion = 0,
  };
  virtual ~TrustedURLLoaderHeaderClient() {}

  
  virtual void OnLoaderCreated(int32_t request_id, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) = 0;

  
  virtual void OnLoaderForCorsPreflightCreated(const ::network::ResourceRequest& request, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) = 0;
};

class AuthChallengeResponderProxy;

template <typename ImplRefTraits>
class AuthChallengeResponderStub;

class AuthChallengeResponderRequestValidator;


class  AuthChallengeResponder
    : public AuthChallengeResponderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = AuthChallengeResponderInterfaceBase;
  using Proxy_ = AuthChallengeResponderProxy;

  template <typename ImplRefTraits>
  using Stub_ = AuthChallengeResponderStub<ImplRefTraits>;

  using RequestValidator_ = AuthChallengeResponderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kOnAuthCredentialsMinVersion = 0,
  };
  virtual ~AuthChallengeResponder() {}

  
  virtual void OnAuthCredentials(const base::Optional<::net::AuthCredentials>& credentials) = 0;
};

class ClientCertificateResponderProxy;

template <typename ImplRefTraits>
class ClientCertificateResponderStub;

class ClientCertificateResponderRequestValidator;


class  ClientCertificateResponder
    : public ClientCertificateResponderInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = ClientCertificateResponderInterfaceBase;
  using Proxy_ = ClientCertificateResponderProxy;

  template <typename ImplRefTraits>
  using Stub_ = ClientCertificateResponderStub<ImplRefTraits>;

  using RequestValidator_ = ClientCertificateResponderRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kContinueWithCertificateMinVersion = 0,
    kContinueWithoutCertificateMinVersion = 0,
    kCancelRequestMinVersion = 0,
  };
  virtual ~ClientCertificateResponder() {}

  
  virtual void ContinueWithCertificate(const ::scoped_refptr<::net::X509Certificate>& x509_certificate, const std::string& provider_name, const std::vector<uint16_t>& algorithm_preferences, ::mojo::PendingRemote<SSLPrivateKey> ssl_private_key) = 0;

  
  virtual void ContinueWithoutCertificate() = 0;

  
  virtual void CancelRequest() = 0;
};

class SSLPrivateKeyProxy;

template <typename ImplRefTraits>
class SSLPrivateKeyStub;

class SSLPrivateKeyRequestValidator;
class SSLPrivateKeyResponseValidator;


class  SSLPrivateKey
    : public SSLPrivateKeyInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = SSLPrivateKeyInterfaceBase;
  using Proxy_ = SSLPrivateKeyProxy;

  template <typename ImplRefTraits>
  using Stub_ = SSLPrivateKeyStub<ImplRefTraits>;

  using RequestValidator_ = SSLPrivateKeyRequestValidator;
  using ResponseValidator_ = SSLPrivateKeyResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSignMinVersion = 0,
  };
  virtual ~SSLPrivateKey() {}


  using SignCallback = base::OnceCallback<void(int32_t, const std::vector<uint8_t>&)>;
  
  virtual void Sign(uint16_t algorithm, const std::vector<uint8_t>& input, SignCallback callback) = 0;
};

class NetworkContextClientProxy;

template <typename ImplRefTraits>
class NetworkContextClientStub;

class NetworkContextClientRequestValidator;
class NetworkContextClientResponseValidator;


class  NetworkContextClient
    : public NetworkContextClientInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = NetworkContextClientInterfaceBase;
  using Proxy_ = NetworkContextClientProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkContextClientStub<ImplRefTraits>;

  using RequestValidator_ = NetworkContextClientRequestValidator;
  using ResponseValidator_ = NetworkContextClientResponseValidator;
  enum MethodMinVersions : uint32_t {
    kOnAuthRequiredMinVersion = 0,
    kOnCertificateRequestedMinVersion = 0,
    kOnSSLCertificateErrorMinVersion = 0,
    kOnFileUploadRequestedMinVersion = 0,
    kOnCanSendReportingReportsMinVersion = 0,
    kOnCanSendDomainReliabilityUploadMinVersion = 0,
    kOnClearSiteDataMinVersion = 0,
  };
  virtual ~NetworkContextClient() {}

  
  virtual void OnAuthRequired(const base::Optional<::base::UnguessableToken>& window_id, int32_t process_id, int32_t routing_id, uint32_t request_id, const ::GURL& url, bool first_auth_attempt, const ::net::AuthChallengeInfo& auth_info, ::network::mojom::URLResponseHeadPtr head, ::mojo::PendingRemote<AuthChallengeResponder> auth_challenge_responder) = 0;

  
  virtual void OnCertificateRequested(const base::Optional<::base::UnguessableToken>& window_id, int32_t process_id, int32_t routing_id, uint32_t request_id, const ::scoped_refptr<::net::SSLCertRequestInfo>& cert_info, ::mojo::PendingRemote<ClientCertificateResponder> cert_responder) = 0;


  using OnSSLCertificateErrorCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void OnSSLCertificateError(int32_t process_id, int32_t routing_id, const ::GURL& url, int32_t net_error, const ::net::SSLInfo& ssl_info, bool fatal, OnSSLCertificateErrorCallback callback) = 0;


  using OnFileUploadRequestedCallback = base::OnceCallback<void(int32_t, std::vector<::base::File>)>;
  
  virtual void OnFileUploadRequested(int32_t process_id, bool async, const std::vector<::base::FilePath>& file_paths, OnFileUploadRequestedCallback callback) = 0;


  using OnCanSendReportingReportsCallback = base::OnceCallback<void(const std::vector<::url::Origin>&)>;
  
  virtual void OnCanSendReportingReports(const std::vector<::url::Origin>& origins, OnCanSendReportingReportsCallback callback) = 0;


  using OnCanSendDomainReliabilityUploadCallback = base::OnceCallback<void(bool)>;
  
  virtual void OnCanSendDomainReliabilityUpload(const ::GURL& origin, OnCanSendDomainReliabilityUploadCallback callback) = 0;


  using OnClearSiteDataCallback = base::OnceCallback<void()>;
  
  virtual void OnClearSiteData(int32_t process_id, int32_t routing_id, const ::GURL& url, const std::string& header_value, int32_t load_flags, OnClearSiteDataCallback callback) = 0;
};

class NetworkContextProxy;

template <typename ImplRefTraits>
class NetworkContextStub;

class NetworkContextRequestValidator;
class NetworkContextResponseValidator;


class  NetworkContext
    : public NetworkContextInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = NetworkContextInterfaceBase;
  using Proxy_ = NetworkContextProxy;

  template <typename ImplRefTraits>
  using Stub_ = NetworkContextStub<ImplRefTraits>;

  using RequestValidator_ = NetworkContextRequestValidator;
  using ResponseValidator_ = NetworkContextResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetClientMinVersion = 0,
    kCreateURLLoaderFactoryMinVersion = 0,
    kResetURLLoaderFactoriesMinVersion = 0,
    kGetCookieManagerMinVersion = 0,
    kGetRestrictedCookieManagerMinVersion = 0,
    kGetHasTrustTokensAnswererMinVersion = 0,
    kClearTrustTokenDataMinVersion = 0,
    kClearNetworkingHistoryBetweenMinVersion = 0,
    kClearHttpCacheMinVersion = 0,
    kComputeHttpCacheSizeMinVersion = 0,
    kNotifyExternalCacheHitMinVersion = 0,
    kClearHostCacheMinVersion = 0,
    kClearHttpAuthCacheMinVersion = 0,
    kClearReportingCacheReportsMinVersion = 0,
    kClearReportingCacheClientsMinVersion = 0,
    kClearNetworkErrorLoggingMinVersion = 0,
    kClearDomainReliabilityMinVersion = 0,
    kGetDomainReliabilityJSONMinVersion = 0,
    kQueueReportMinVersion = 0,
    kQueueSignedExchangeReportMinVersion = 0,
    kCloseAllConnectionsMinVersion = 0,
    kCloseIdleConnectionsMinVersion = 0,
    kSetNetworkConditionsMinVersion = 0,
    kSetAcceptLanguageMinVersion = 0,
    kSetUserAgentMinVersion = 0,
    kSetEnableReferrersMinVersion = 0,
    kSetCTPolicyMinVersion = 0,
    kAddExpectCTMinVersion = 0,
    kSetExpectCTTestReportMinVersion = 0,
    kGetExpectCTStateMinVersion = 0,
    kCreateUDPSocketMinVersion = 0,
    kCreateTCPServerSocketMinVersion = 0,
    kCreateTCPConnectedSocketMinVersion = 0,
    kCreateTCPBoundSocketMinVersion = 0,
    kCreateProxyResolvingSocketFactoryMinVersion = 0,
    kLookUpProxyForURLMinVersion = 0,
    kForceReloadProxyConfigMinVersion = 0,
    kClearBadProxiesCacheMinVersion = 0,
    kCreateWebSocketMinVersion = 0,
    kCreateQuicTransportMinVersion = 0,
    kCreateNetLogExporterMinVersion = 0,
    kPreconnectSocketsMinVersion = 0,
    kCreateP2PSocketManagerMinVersion = 0,
    kCreateMdnsResponderMinVersion = 0,
    kResolveHostMinVersion = 0,
    kCreateHostResolverMinVersion = 0,
    kVerifyCertForSignedExchangeMinVersion = 0,
    kParseHeadersMinVersion = 0,
    kAddHSTSMinVersion = 0,
    kIsHSTSActiveForHostMinVersion = 0,
    kGetHSTSStateMinVersion = 0,
    kSetCorsOriginAccessListsForOriginMinVersion = 0,
    kDeleteDynamicDataForHostMinVersion = 0,
    kSetSplitAuthCacheByNetworkIsolationKeyMinVersion = 0,
    kSaveHttpAuthCacheProxyEntriesMinVersion = 0,
    kLoadHttpAuthCacheProxyEntriesMinVersion = 0,
    kAddAuthCacheEntryMinVersion = 0,
    kLookupServerBasicAuthCredentialsMinVersion = 0,
    kEnableStaticKeyPinningForTestingMinVersion = 0,
    kVerifyCertificateForTestingMinVersion = 0,
    kAddDomainReliabilityContextForTestingMinVersion = 0,
    kForceDomainReliabilityUploadsForTestingMinVersion = 0,
    kGetOriginPolicyManagerMinVersion = 0,
    kSetSCTAuditingEnabledMinVersion = 0,
  };
  
  using DomainReliabilityClearMode = NetworkContext_DomainReliabilityClearMode;
  virtual ~NetworkContext() {}

  
  virtual void SetClient(::mojo::PendingRemote<NetworkContextClient> client) = 0;

  
  virtual void CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory, URLLoaderFactoryParamsPtr params) = 0;

  
  virtual void ResetURLLoaderFactories() = 0;

  
  virtual void GetCookieManager(::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager) = 0;

  
  virtual void GetRestrictedCookieManager(::mojo::PendingReceiver<::network::mojom::RestrictedCookieManager> restricted_cookie_manager, ::network::mojom::RestrictedCookieManagerRole role, const ::url::Origin& origin, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer) = 0;

  
  virtual void GetHasTrustTokensAnswerer(::mojo::PendingReceiver<::network::mojom::HasTrustTokensAnswerer> has_trust_tokens_answerer, const ::url::Origin& top_frame_origin) = 0;


  using ClearTrustTokenDataCallback = base::OnceCallback<void()>;
  
  virtual void ClearTrustTokenData(ClearDataFilterPtr filter, ClearTrustTokenDataCallback callback) = 0;


  using ClearNetworkingHistoryBetweenCallback = base::OnceCallback<void()>;
  
  virtual void ClearNetworkingHistoryBetween(::base::Time start_time, ::base::Time end_time, ClearNetworkingHistoryBetweenCallback callback) = 0;


  using ClearHttpCacheCallback = base::OnceCallback<void()>;
  
  virtual void ClearHttpCache(::base::Time start_time, ::base::Time end_time, ClearDataFilterPtr filter, ClearHttpCacheCallback callback) = 0;


  using ComputeHttpCacheSizeCallback = base::OnceCallback<void(bool, int64_t)>;
  
  virtual void ComputeHttpCacheSize(::base::Time start_time, ::base::Time end_time, ComputeHttpCacheSizeCallback callback) = 0;

  
  virtual void NotifyExternalCacheHit(const ::GURL& url, const std::string& http_method, const ::net::NetworkIsolationKey& key) = 0;


  using ClearHostCacheCallback = base::OnceCallback<void()>;
  
  virtual void ClearHostCache(ClearDataFilterPtr filter, ClearHostCacheCallback callback) = 0;


  using ClearHttpAuthCacheCallback = base::OnceCallback<void()>;
  
  virtual void ClearHttpAuthCache(::base::Time start_time, ::base::Time end_time, ClearHttpAuthCacheCallback callback) = 0;


  using ClearReportingCacheReportsCallback = base::OnceCallback<void()>;
  
  virtual void ClearReportingCacheReports(ClearDataFilterPtr filter, ClearReportingCacheReportsCallback callback) = 0;


  using ClearReportingCacheClientsCallback = base::OnceCallback<void()>;
  
  virtual void ClearReportingCacheClients(ClearDataFilterPtr filter, ClearReportingCacheClientsCallback callback) = 0;


  using ClearNetworkErrorLoggingCallback = base::OnceCallback<void()>;
  
  virtual void ClearNetworkErrorLogging(ClearDataFilterPtr filter, ClearNetworkErrorLoggingCallback callback) = 0;


  using ClearDomainReliabilityCallback = base::OnceCallback<void()>;
  
  virtual void ClearDomainReliability(ClearDataFilterPtr filter, NetworkContext::DomainReliabilityClearMode mode, ClearDomainReliabilityCallback callback) = 0;


  using GetDomainReliabilityJSONCallback = base::OnceCallback<void(::base::Value)>;
  
  virtual void GetDomainReliabilityJSON(GetDomainReliabilityJSONCallback callback) = 0;

  
  virtual void QueueReport(const std::string& type, const std::string& group, const ::GURL& url, const base::Optional<std::string>& user_agent, ::base::Value body) = 0;

  
  virtual void QueueSignedExchangeReport(SignedExchangeReportPtr report) = 0;


  using CloseAllConnectionsCallback = base::OnceCallback<void()>;
  
  virtual void CloseAllConnections(CloseAllConnectionsCallback callback) = 0;


  using CloseIdleConnectionsCallback = base::OnceCallback<void()>;
  
  virtual void CloseIdleConnections(CloseIdleConnectionsCallback callback) = 0;

  
  virtual void SetNetworkConditions(const ::base::UnguessableToken& throttling_profile_id, NetworkConditionsPtr conditions) = 0;

  
  virtual void SetAcceptLanguage(const std::string& new_accept_language) = 0;

  
  virtual void SetUserAgent(const std::string& new_user_agent) = 0;

  
  virtual void SetEnableReferrers(bool enable_referrers) = 0;

  
  virtual void SetCTPolicy(CTPolicyPtr ct_policy) = 0;


  using AddExpectCTCallback = base::OnceCallback<void(bool)>;
  
  virtual void AddExpectCT(const std::string& host, ::base::Time expiry, bool enforce, const ::GURL& report_uri, const ::net::NetworkIsolationKey& network_isolation_key, AddExpectCTCallback callback) = 0;


  using SetExpectCTTestReportCallback = base::OnceCallback<void(bool)>;
  
  virtual void SetExpectCTTestReport(const ::GURL& report_uri, SetExpectCTTestReportCallback callback) = 0;


  using GetExpectCTStateCallback = base::OnceCallback<void(::base::Value)>;
  
  virtual void GetExpectCTState(const std::string& domain, const ::net::NetworkIsolationKey& network_isolation_key, GetExpectCTStateCallback callback) = 0;

  
  virtual void CreateUDPSocket(::mojo::PendingReceiver<::network::mojom::UDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener) = 0;


  using CreateTCPServerSocketCallback = base::OnceCallback<void(int32_t, const base::Optional<::net::IPEndPoint>&)>;
  
  virtual void CreateTCPServerSocket(const ::net::IPEndPoint& local_addr, uint32_t backlog, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> socket, CreateTCPServerSocketCallback callback) = 0;


  using CreateTCPConnectedSocketCallback = base::OnceCallback<void(int32_t, const base::Optional<::net::IPEndPoint>&, const base::Optional<::net::IPEndPoint>&, ::mojo::ScopedDataPipeConsumerHandle, ::mojo::ScopedDataPipeProducerHandle)>;
  
  virtual void CreateTCPConnectedSocket(const base::Optional<::net::IPEndPoint>& local_addr, const ::net::AddressList& remote_addr_list, ::network::mojom::TCPConnectedSocketOptionsPtr tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, CreateTCPConnectedSocketCallback callback) = 0;


  using CreateTCPBoundSocketCallback = base::OnceCallback<void(int32_t, const base::Optional<::net::IPEndPoint>&)>;
  
  virtual void CreateTCPBoundSocket(const ::net::IPEndPoint& local_addr, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> socket, CreateTCPBoundSocketCallback callback) = 0;

  
  virtual void CreateProxyResolvingSocketFactory(::mojo::PendingReceiver<::network::mojom::ProxyResolvingSocketFactory> factory) = 0;

  
  virtual void LookUpProxyForURL(const ::GURL& url, const ::net::NetworkIsolationKey& network_isolation_key, ::mojo::PendingRemote<::network::mojom::ProxyLookupClient> proxy_lookup_client) = 0;


  using ForceReloadProxyConfigCallback = base::OnceCallback<void()>;
  
  virtual void ForceReloadProxyConfig(ForceReloadProxyConfigCallback callback) = 0;


  using ClearBadProxiesCacheCallback = base::OnceCallback<void()>;
  
  virtual void ClearBadProxiesCache(ClearBadProxiesCacheCallback callback) = 0;

  
  virtual void CreateWebSocket(const ::GURL& url, const std::vector<std::string>& requested_protocols, const ::net::SiteForCookies& site_for_cookies, const ::net::IsolationInfo& isolation_info, std::vector<::network::mojom::HttpHeaderPtr> additional_headers, int32_t process_id, int32_t render_frame_id, const ::url::Origin& origin, uint32_t options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> handshake_client, ::mojo::PendingRemote<::network::mojom::AuthenticationHandler> auth_handler, ::mojo::PendingRemote<TrustedHeaderClient> header_client) = 0;

  
  virtual void CreateQuicTransport(const ::GURL& url, const ::url::Origin& origin, const ::net::NetworkIsolationKey& network_isolation_key, std::vector<::network::mojom::QuicTransportCertificateFingerprintPtr> fingerprints, ::mojo::PendingRemote<::network::mojom::QuicTransportHandshakeClient> handshake_client) = 0;

  
  virtual void CreateNetLogExporter(::mojo::PendingReceiver<::network::mojom::NetLogExporter> receiver) = 0;

  
  virtual void PreconnectSockets(uint32_t num_streams, const ::GURL& url, bool allow_credentials, const ::net::NetworkIsolationKey& network_isolation_key) = 0;

  
  virtual void CreateP2PSocketManager(const ::net::NetworkIsolationKey& network_isolation_key, ::mojo::PendingRemote<::network::mojom::P2PTrustedSocketManagerClient> client, ::mojo::PendingReceiver<::network::mojom::P2PTrustedSocketManager> trusted_socket_manager, ::mojo::PendingReceiver<::network::mojom::P2PSocketManager> socket_manager) = 0;

  
  virtual void CreateMdnsResponder(::mojo::PendingReceiver<::network::mojom::MdnsResponder> responder_receiver) = 0;

  
  virtual void ResolveHost(const ::net::HostPortPair& host, const ::net::NetworkIsolationKey& network_isolation_key, ::network::mojom::ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<::network::mojom::ResolveHostClient> response_client) = 0;

  
  virtual void CreateHostResolver(const base::Optional<::net::DnsConfigOverrides>& config_overrides, ::mojo::PendingReceiver<::network::mojom::HostResolver> host_resolver) = 0;


  using VerifyCertForSignedExchangeCallback = base::OnceCallback<void(int32_t, const ::net::CertVerifyResult&, const ::net::ct::CTVerifyResult&)>;
  
  virtual void VerifyCertForSignedExchange(const ::scoped_refptr<::net::X509Certificate>& certificate, const ::GURL& url, const std::string& ocsp_response, const std::string& sct_list, VerifyCertForSignedExchangeCallback callback) = 0;


  using ParseHeadersCallback = base::OnceCallback<void(::network::mojom::ParsedHeadersPtr)>;
  
  virtual void ParseHeaders(const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, ParseHeadersCallback callback) = 0;


  using AddHSTSCallback = base::OnceCallback<void()>;
  
  virtual void AddHSTS(const std::string& host, ::base::Time expiry, bool include_subdomains, AddHSTSCallback callback) = 0;


  using IsHSTSActiveForHostCallback = base::OnceCallback<void(bool)>;
  
  virtual void IsHSTSActiveForHost(const std::string& host, IsHSTSActiveForHostCallback callback) = 0;


  using GetHSTSStateCallback = base::OnceCallback<void(::base::Value)>;
  
  virtual void GetHSTSState(const std::string& domain, GetHSTSStateCallback callback) = 0;


  using SetCorsOriginAccessListsForOriginCallback = base::OnceCallback<void()>;
  
  virtual void SetCorsOriginAccessListsForOrigin(const ::url::Origin& source_origin, std::vector<::network::mojom::CorsOriginPatternPtr> allow_patterns, std::vector<::network::mojom::CorsOriginPatternPtr> block_patterns, SetCorsOriginAccessListsForOriginCallback callback) = 0;


  using DeleteDynamicDataForHostCallback = base::OnceCallback<void(bool)>;
  
  virtual void DeleteDynamicDataForHost(const std::string& host, DeleteDynamicDataForHostCallback callback) = 0;

  
  virtual void SetSplitAuthCacheByNetworkIsolationKey(bool split_auth_cache_by_network_isolation_key) = 0;


  using SaveHttpAuthCacheProxyEntriesCallback = base::OnceCallback<void(const ::base::UnguessableToken&)>;
  
  virtual void SaveHttpAuthCacheProxyEntries(SaveHttpAuthCacheProxyEntriesCallback callback) = 0;


  using LoadHttpAuthCacheProxyEntriesCallback = base::OnceCallback<void()>;
  
  virtual void LoadHttpAuthCacheProxyEntries(const ::base::UnguessableToken& cache_key, LoadHttpAuthCacheProxyEntriesCallback callback) = 0;


  using AddAuthCacheEntryCallback = base::OnceCallback<void()>;
  
  virtual void AddAuthCacheEntry(const ::net::AuthChallengeInfo& challenge, const ::net::NetworkIsolationKey& network_isolation_key, const ::net::AuthCredentials& credentials, AddAuthCacheEntryCallback callback) = 0;


  using LookupServerBasicAuthCredentialsCallback = base::OnceCallback<void(const base::Optional<::net::AuthCredentials>&)>;
  
  virtual void LookupServerBasicAuthCredentials(const ::GURL& url, const ::net::NetworkIsolationKey& network_isolation_key, LookupServerBasicAuthCredentialsCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool EnableStaticKeyPinningForTesting();

  using EnableStaticKeyPinningForTestingCallback = base::OnceCallback<void()>;
  
  virtual void EnableStaticKeyPinningForTesting(EnableStaticKeyPinningForTestingCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool VerifyCertificateForTesting(const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list, int32_t* out_error_code);

  using VerifyCertificateForTestingCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void VerifyCertificateForTesting(const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list, VerifyCertificateForTestingCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool AddDomainReliabilityContextForTesting(const ::GURL& origin, const ::GURL& upload_url);

  using AddDomainReliabilityContextForTestingCallback = base::OnceCallback<void()>;
  
  virtual void AddDomainReliabilityContextForTesting(const ::GURL& origin, const ::GURL& upload_url, AddDomainReliabilityContextForTestingCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool ForceDomainReliabilityUploadsForTesting();

  using ForceDomainReliabilityUploadsForTestingCallback = base::OnceCallback<void()>;
  
  virtual void ForceDomainReliabilityUploadsForTesting(ForceDomainReliabilityUploadsForTestingCallback callback) = 0;

  
  virtual void GetOriginPolicyManager(::mojo::PendingReceiver<::network::mojom::OriginPolicyManager> origin_policy_manager) = 0;

  
  virtual void SetSCTAuditingEnabled(bool enabled) = 0;
};



class  CustomProxyConfigClientProxy
    : public CustomProxyConfigClient {
 public:
  using InterfaceType = CustomProxyConfigClient;

  explicit CustomProxyConfigClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnCustomProxyConfigUpdated(CustomProxyConfigPtr proxy_config) final;
  
  void MarkProxiesAsBad(::base::TimeDelta bypass_duration, const ::net::ProxyList& bad_proxies, MarkProxiesAsBadCallback callback) final;
  
  void ClearBadProxiesCache() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  TrustedHeaderClientProxy
    : public TrustedHeaderClient {
 public:
  using InterfaceType = TrustedHeaderClient;

  explicit TrustedHeaderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnBeforeSendHeaders(const ::net::HttpRequestHeaders& headers, OnBeforeSendHeadersCallback callback) final;
  
  void OnHeadersReceived(const std::string& headers, const ::net::IPEndPoint& remote_endpoint, OnHeadersReceivedCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  TrustedURLLoaderHeaderClientProxy
    : public TrustedURLLoaderHeaderClient {
 public:
  using InterfaceType = TrustedURLLoaderHeaderClient;

  explicit TrustedURLLoaderHeaderClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnLoaderCreated(int32_t request_id, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) final;
  
  void OnLoaderForCorsPreflightCreated(const ::network::ResourceRequest& request, ::mojo::PendingReceiver<TrustedHeaderClient> header_client) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  AuthChallengeResponderProxy
    : public AuthChallengeResponder {
 public:
  using InterfaceType = AuthChallengeResponder;

  explicit AuthChallengeResponderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnAuthCredentials(const base::Optional<::net::AuthCredentials>& credentials) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  ClientCertificateResponderProxy
    : public ClientCertificateResponder {
 public:
  using InterfaceType = ClientCertificateResponder;

  explicit ClientCertificateResponderProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void ContinueWithCertificate(const ::scoped_refptr<::net::X509Certificate>& x509_certificate, const std::string& provider_name, const std::vector<uint16_t>& algorithm_preferences, ::mojo::PendingRemote<SSLPrivateKey> ssl_private_key) final;
  
  void ContinueWithoutCertificate() final;
  
  void CancelRequest() final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  SSLPrivateKeyProxy
    : public SSLPrivateKey {
 public:
  using InterfaceType = SSLPrivateKey;

  explicit SSLPrivateKeyProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Sign(uint16_t algorithm, const std::vector<uint8_t>& input, SignCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NetworkContextClientProxy
    : public NetworkContextClient {
 public:
  using InterfaceType = NetworkContextClient;

  explicit NetworkContextClientProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void OnAuthRequired(const base::Optional<::base::UnguessableToken>& window_id, int32_t process_id, int32_t routing_id, uint32_t request_id, const ::GURL& url, bool first_auth_attempt, const ::net::AuthChallengeInfo& auth_info, ::network::mojom::URLResponseHeadPtr head, ::mojo::PendingRemote<AuthChallengeResponder> auth_challenge_responder) final;
  
  void OnCertificateRequested(const base::Optional<::base::UnguessableToken>& window_id, int32_t process_id, int32_t routing_id, uint32_t request_id, const ::scoped_refptr<::net::SSLCertRequestInfo>& cert_info, ::mojo::PendingRemote<ClientCertificateResponder> cert_responder) final;
  
  void OnSSLCertificateError(int32_t process_id, int32_t routing_id, const ::GURL& url, int32_t net_error, const ::net::SSLInfo& ssl_info, bool fatal, OnSSLCertificateErrorCallback callback) final;
  
  void OnFileUploadRequested(int32_t process_id, bool async, const std::vector<::base::FilePath>& file_paths, OnFileUploadRequestedCallback callback) final;
  
  void OnCanSendReportingReports(const std::vector<::url::Origin>& origins, OnCanSendReportingReportsCallback callback) final;
  
  void OnCanSendDomainReliabilityUpload(const ::GURL& origin, OnCanSendDomainReliabilityUploadCallback callback) final;
  
  void OnClearSiteData(int32_t process_id, int32_t routing_id, const ::GURL& url, const std::string& header_value, int32_t load_flags, OnClearSiteDataCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class  NetworkContextProxy
    : public NetworkContext {
 public:
  using InterfaceType = NetworkContext;

  explicit NetworkContextProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetClient(::mojo::PendingRemote<NetworkContextClient> client) final;
  
  void CreateURLLoaderFactory(::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> url_loader_factory, URLLoaderFactoryParamsPtr params) final;
  
  void ResetURLLoaderFactories() final;
  
  void GetCookieManager(::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager) final;
  
  void GetRestrictedCookieManager(::mojo::PendingReceiver<::network::mojom::RestrictedCookieManager> restricted_cookie_manager, ::network::mojom::RestrictedCookieManagerRole role, const ::url::Origin& origin, const ::net::SiteForCookies& site_for_cookies, const ::url::Origin& top_frame_origin, ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer) final;
  
  void GetHasTrustTokensAnswerer(::mojo::PendingReceiver<::network::mojom::HasTrustTokensAnswerer> has_trust_tokens_answerer, const ::url::Origin& top_frame_origin) final;
  
  void ClearTrustTokenData(ClearDataFilterPtr filter, ClearTrustTokenDataCallback callback) final;
  
  void ClearNetworkingHistoryBetween(::base::Time start_time, ::base::Time end_time, ClearNetworkingHistoryBetweenCallback callback) final;
  
  void ClearHttpCache(::base::Time start_time, ::base::Time end_time, ClearDataFilterPtr filter, ClearHttpCacheCallback callback) final;
  
  void ComputeHttpCacheSize(::base::Time start_time, ::base::Time end_time, ComputeHttpCacheSizeCallback callback) final;
  
  void NotifyExternalCacheHit(const ::GURL& url, const std::string& http_method, const ::net::NetworkIsolationKey& key) final;
  
  void ClearHostCache(ClearDataFilterPtr filter, ClearHostCacheCallback callback) final;
  
  void ClearHttpAuthCache(::base::Time start_time, ::base::Time end_time, ClearHttpAuthCacheCallback callback) final;
  
  void ClearReportingCacheReports(ClearDataFilterPtr filter, ClearReportingCacheReportsCallback callback) final;
  
  void ClearReportingCacheClients(ClearDataFilterPtr filter, ClearReportingCacheClientsCallback callback) final;
  
  void ClearNetworkErrorLogging(ClearDataFilterPtr filter, ClearNetworkErrorLoggingCallback callback) final;
  
  void ClearDomainReliability(ClearDataFilterPtr filter, NetworkContext::DomainReliabilityClearMode mode, ClearDomainReliabilityCallback callback) final;
  
  void GetDomainReliabilityJSON(GetDomainReliabilityJSONCallback callback) final;
  
  void QueueReport(const std::string& type, const std::string& group, const ::GURL& url, const base::Optional<std::string>& user_agent, ::base::Value body) final;
  
  void QueueSignedExchangeReport(SignedExchangeReportPtr report) final;
  
  void CloseAllConnections(CloseAllConnectionsCallback callback) final;
  
  void CloseIdleConnections(CloseIdleConnectionsCallback callback) final;
  
  void SetNetworkConditions(const ::base::UnguessableToken& throttling_profile_id, NetworkConditionsPtr conditions) final;
  
  void SetAcceptLanguage(const std::string& new_accept_language) final;
  
  void SetUserAgent(const std::string& new_user_agent) final;
  
  void SetEnableReferrers(bool enable_referrers) final;
  
  void SetCTPolicy(CTPolicyPtr ct_policy) final;
  
  void AddExpectCT(const std::string& host, ::base::Time expiry, bool enforce, const ::GURL& report_uri, const ::net::NetworkIsolationKey& network_isolation_key, AddExpectCTCallback callback) final;
  
  void SetExpectCTTestReport(const ::GURL& report_uri, SetExpectCTTestReportCallback callback) final;
  
  void GetExpectCTState(const std::string& domain, const ::net::NetworkIsolationKey& network_isolation_key, GetExpectCTStateCallback callback) final;
  
  void CreateUDPSocket(::mojo::PendingReceiver<::network::mojom::UDPSocket> receiver, ::mojo::PendingRemote<::network::mojom::UDPSocketListener> listener) final;
  
  void CreateTCPServerSocket(const ::net::IPEndPoint& local_addr, uint32_t backlog, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPServerSocket> socket, CreateTCPServerSocketCallback callback) final;
  
  void CreateTCPConnectedSocket(const base::Optional<::net::IPEndPoint>& local_addr, const ::net::AddressList& remote_addr_list, ::network::mojom::TCPConnectedSocketOptionsPtr tcp_connected_socket_options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPConnectedSocket> socket, ::mojo::PendingRemote<::network::mojom::SocketObserver> observer, CreateTCPConnectedSocketCallback callback) final;
  
  void CreateTCPBoundSocket(const ::net::IPEndPoint& local_addr, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingReceiver<::network::mojom::TCPBoundSocket> socket, CreateTCPBoundSocketCallback callback) final;
  
  void CreateProxyResolvingSocketFactory(::mojo::PendingReceiver<::network::mojom::ProxyResolvingSocketFactory> factory) final;
  
  void LookUpProxyForURL(const ::GURL& url, const ::net::NetworkIsolationKey& network_isolation_key, ::mojo::PendingRemote<::network::mojom::ProxyLookupClient> proxy_lookup_client) final;
  
  void ForceReloadProxyConfig(ForceReloadProxyConfigCallback callback) final;
  
  void ClearBadProxiesCache(ClearBadProxiesCacheCallback callback) final;
  
  void CreateWebSocket(const ::GURL& url, const std::vector<std::string>& requested_protocols, const ::net::SiteForCookies& site_for_cookies, const ::net::IsolationInfo& isolation_info, std::vector<::network::mojom::HttpHeaderPtr> additional_headers, int32_t process_id, int32_t render_frame_id, const ::url::Origin& origin, uint32_t options, const ::net::MutableNetworkTrafficAnnotationTag& traffic_annotation, ::mojo::PendingRemote<::network::mojom::WebSocketHandshakeClient> handshake_client, ::mojo::PendingRemote<::network::mojom::AuthenticationHandler> auth_handler, ::mojo::PendingRemote<TrustedHeaderClient> header_client) final;
  
  void CreateQuicTransport(const ::GURL& url, const ::url::Origin& origin, const ::net::NetworkIsolationKey& network_isolation_key, std::vector<::network::mojom::QuicTransportCertificateFingerprintPtr> fingerprints, ::mojo::PendingRemote<::network::mojom::QuicTransportHandshakeClient> handshake_client) final;
  
  void CreateNetLogExporter(::mojo::PendingReceiver<::network::mojom::NetLogExporter> receiver) final;
  
  void PreconnectSockets(uint32_t num_streams, const ::GURL& url, bool allow_credentials, const ::net::NetworkIsolationKey& network_isolation_key) final;
  
  void CreateP2PSocketManager(const ::net::NetworkIsolationKey& network_isolation_key, ::mojo::PendingRemote<::network::mojom::P2PTrustedSocketManagerClient> client, ::mojo::PendingReceiver<::network::mojom::P2PTrustedSocketManager> trusted_socket_manager, ::mojo::PendingReceiver<::network::mojom::P2PSocketManager> socket_manager) final;
  
  void CreateMdnsResponder(::mojo::PendingReceiver<::network::mojom::MdnsResponder> responder_receiver) final;
  
  void ResolveHost(const ::net::HostPortPair& host, const ::net::NetworkIsolationKey& network_isolation_key, ::network::mojom::ResolveHostParametersPtr optional_parameters, ::mojo::PendingRemote<::network::mojom::ResolveHostClient> response_client) final;
  
  void CreateHostResolver(const base::Optional<::net::DnsConfigOverrides>& config_overrides, ::mojo::PendingReceiver<::network::mojom::HostResolver> host_resolver) final;
  
  void VerifyCertForSignedExchange(const ::scoped_refptr<::net::X509Certificate>& certificate, const ::GURL& url, const std::string& ocsp_response, const std::string& sct_list, VerifyCertForSignedExchangeCallback callback) final;
  
  void ParseHeaders(const ::GURL& url, const ::scoped_refptr<::net::HttpResponseHeaders>& headers, ParseHeadersCallback callback) final;
  
  void AddHSTS(const std::string& host, ::base::Time expiry, bool include_subdomains, AddHSTSCallback callback) final;
  
  void IsHSTSActiveForHost(const std::string& host, IsHSTSActiveForHostCallback callback) final;
  
  void GetHSTSState(const std::string& domain, GetHSTSStateCallback callback) final;
  
  void SetCorsOriginAccessListsForOrigin(const ::url::Origin& source_origin, std::vector<::network::mojom::CorsOriginPatternPtr> allow_patterns, std::vector<::network::mojom::CorsOriginPatternPtr> block_patterns, SetCorsOriginAccessListsForOriginCallback callback) final;
  
  void DeleteDynamicDataForHost(const std::string& host, DeleteDynamicDataForHostCallback callback) final;
  
  void SetSplitAuthCacheByNetworkIsolationKey(bool split_auth_cache_by_network_isolation_key) final;
  
  void SaveHttpAuthCacheProxyEntries(SaveHttpAuthCacheProxyEntriesCallback callback) final;
  
  void LoadHttpAuthCacheProxyEntries(const ::base::UnguessableToken& cache_key, LoadHttpAuthCacheProxyEntriesCallback callback) final;
  
  void AddAuthCacheEntry(const ::net::AuthChallengeInfo& challenge, const ::net::NetworkIsolationKey& network_isolation_key, const ::net::AuthCredentials& credentials, AddAuthCacheEntryCallback callback) final;
  
  void LookupServerBasicAuthCredentials(const ::GURL& url, const ::net::NetworkIsolationKey& network_isolation_key, LookupServerBasicAuthCredentialsCallback callback) final;
  
  bool EnableStaticKeyPinningForTesting() final;
  
  void EnableStaticKeyPinningForTesting(EnableStaticKeyPinningForTestingCallback callback) final;
  
  bool VerifyCertificateForTesting(const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list, int32_t* out_error_code) final;
  
  void VerifyCertificateForTesting(const ::scoped_refptr<::net::X509Certificate>& certificate, const std::string& hostname, const std::string& ocsp_response, const std::string& sct_list, VerifyCertificateForTestingCallback callback) final;
  
  bool AddDomainReliabilityContextForTesting(const ::GURL& origin, const ::GURL& upload_url) final;
  
  void AddDomainReliabilityContextForTesting(const ::GURL& origin, const ::GURL& upload_url, AddDomainReliabilityContextForTestingCallback callback) final;
  
  bool ForceDomainReliabilityUploadsForTesting() final;
  
  void ForceDomainReliabilityUploadsForTesting(ForceDomainReliabilityUploadsForTestingCallback callback) final;
  
  void GetOriginPolicyManager(::mojo::PendingReceiver<::network::mojom::OriginPolicyManager> origin_policy_manager) final;
  
  void SetSCTAuditingEnabled(bool enabled) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  CustomProxyConfigClientStubDispatch {
 public:
  static bool Accept(CustomProxyConfigClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CustomProxyConfigClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CustomProxyConfigClient>>
class CustomProxyConfigClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CustomProxyConfigClientStub() {}
  ~CustomProxyConfigClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomProxyConfigClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CustomProxyConfigClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TrustedHeaderClientStubDispatch {
 public:
  static bool Accept(TrustedHeaderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TrustedHeaderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TrustedHeaderClient>>
class TrustedHeaderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TrustedHeaderClientStub() {}
  ~TrustedHeaderClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedHeaderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedHeaderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  TrustedURLLoaderHeaderClientStubDispatch {
 public:
  static bool Accept(TrustedURLLoaderHeaderClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      TrustedURLLoaderHeaderClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<TrustedURLLoaderHeaderClient>>
class TrustedURLLoaderHeaderClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  TrustedURLLoaderHeaderClientStub() {}
  ~TrustedURLLoaderHeaderClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedURLLoaderHeaderClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return TrustedURLLoaderHeaderClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  AuthChallengeResponderStubDispatch {
 public:
  static bool Accept(AuthChallengeResponder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      AuthChallengeResponder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<AuthChallengeResponder>>
class AuthChallengeResponderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  AuthChallengeResponderStub() {}
  ~AuthChallengeResponderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuthChallengeResponderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return AuthChallengeResponderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  ClientCertificateResponderStubDispatch {
 public:
  static bool Accept(ClientCertificateResponder* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      ClientCertificateResponder* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<ClientCertificateResponder>>
class ClientCertificateResponderStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  ClientCertificateResponderStub() {}
  ~ClientCertificateResponderStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ClientCertificateResponderStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return ClientCertificateResponderStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  SSLPrivateKeyStubDispatch {
 public:
  static bool Accept(SSLPrivateKey* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      SSLPrivateKey* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<SSLPrivateKey>>
class SSLPrivateKeyStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  SSLPrivateKeyStub() {}
  ~SSLPrivateKeyStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SSLPrivateKeyStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return SSLPrivateKeyStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkContextClientStubDispatch {
 public:
  static bool Accept(NetworkContextClient* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkContextClient* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkContextClient>>
class NetworkContextClientStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkContextClientStub() {}
  ~NetworkContextClientStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkContextClientStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkContextClientStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  NetworkContextStubDispatch {
 public:
  static bool Accept(NetworkContext* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      NetworkContext* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<NetworkContext>>
class NetworkContextStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  NetworkContextStub() {}
  ~NetworkContextStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkContextStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return NetworkContextStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  CustomProxyConfigClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TrustedHeaderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TrustedURLLoaderHeaderClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  AuthChallengeResponderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  ClientCertificateResponderRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SSLPrivateKeyRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkContextClientRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkContextRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  CustomProxyConfigClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  TrustedHeaderClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  SSLPrivateKeyResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkContextClientResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  NetworkContextResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class  CertVerifierCreationParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CertVerifierCreationParams, T>::value>;
  using DataView = CertVerifierCreationParamsDataView;
  using Data_ = internal::CertVerifierCreationParams_Data;

  template <typename... Args>
  static CertVerifierCreationParamsPtr New(Args&&... args) {
    return CertVerifierCreationParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CertVerifierCreationParamsPtr From(const U& u) {
    return mojo::TypeConverter<CertVerifierCreationParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CertVerifierCreationParams>::Convert(*this);
  }


  CertVerifierCreationParams();

  ~CertVerifierCreationParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CertVerifierCreationParamsPtr>
  CertVerifierCreationParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertVerifierCreationParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CertVerifierCreationParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CertVerifierCreationParams_UnserializedMessageContext<
            UserType, CertVerifierCreationParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CertVerifierCreationParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CertVerifierCreationParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CertVerifierCreationParams_UnserializedMessageContext<
            UserType, CertVerifierCreationParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CertVerifierCreationParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }


  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CertVerifierCreationParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  HttpAuthStaticNetworkContextParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HttpAuthStaticNetworkContextParams, T>::value>;
  using DataView = HttpAuthStaticNetworkContextParamsDataView;
  using Data_ = internal::HttpAuthStaticNetworkContextParams_Data;

  template <typename... Args>
  static HttpAuthStaticNetworkContextParamsPtr New(Args&&... args) {
    return HttpAuthStaticNetworkContextParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HttpAuthStaticNetworkContextParamsPtr From(const U& u) {
    return mojo::TypeConverter<HttpAuthStaticNetworkContextParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HttpAuthStaticNetworkContextParams>::Convert(*this);
  }


  HttpAuthStaticNetworkContextParams();

  explicit HttpAuthStaticNetworkContextParams(
      ::net::HttpAuthPreferences::DefaultCredentials allow_default_credentials);

  ~HttpAuthStaticNetworkContextParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HttpAuthStaticNetworkContextParamsPtr>
  HttpAuthStaticNetworkContextParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HttpAuthStaticNetworkContextParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HttpAuthStaticNetworkContextParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HttpAuthStaticNetworkContextParams_UnserializedMessageContext<
            UserType, HttpAuthStaticNetworkContextParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HttpAuthStaticNetworkContextParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return HttpAuthStaticNetworkContextParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HttpAuthStaticNetworkContextParams_UnserializedMessageContext<
            UserType, HttpAuthStaticNetworkContextParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HttpAuthStaticNetworkContextParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::net::HttpAuthPreferences::DefaultCredentials allow_default_credentials;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class  NetworkUsage {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkUsage, T>::value>;
  using DataView = NetworkUsageDataView;
  using Data_ = internal::NetworkUsage_Data;

  template <typename... Args>
  static NetworkUsagePtr New(Args&&... args) {
    return NetworkUsagePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkUsagePtr From(const U& u) {
    return mojo::TypeConverter<NetworkUsagePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkUsage>::Convert(*this);
  }


  NetworkUsage();

  NetworkUsage(
      int32_t process_id,
      int32_t routing_id,
      int64_t total_bytes_received,
      int64_t total_bytes_sent);

  ~NetworkUsage();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkUsagePtr>
  NetworkUsagePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkUsage::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkUsage::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkUsage::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkUsage_UnserializedMessageContext<
            UserType, NetworkUsage::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NetworkUsage::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return NetworkUsage::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkUsage_UnserializedMessageContext<
            UserType, NetworkUsage::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkUsage::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t process_id;
  
  int32_t routing_id;
  
  int64_t total_bytes_received;
  
  int64_t total_bytes_sent;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkUsage::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkUsage::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkUsage::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkUsage::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}








class  CertVerifierParams {
 public:
  using DataView = CertVerifierParamsDataView;
  using Data_ = internal::CertVerifierParams_Data;
  using Tag = Data_::CertVerifierParams_Tag;

  static CertVerifierParamsPtr New() {
    return CertVerifierParamsPtr(base::in_place);
  }
  // Construct an instance holding |remote_params|.
  static CertVerifierParamsPtr
  NewRemoteParams(
      CertVerifierServiceRemoteParamsPtr remote_params) {
    auto result = CertVerifierParamsPtr(base::in_place);
    result->set_remote_params(std::move(remote_params));
    return result;
  }
  // Construct an instance holding |creation_params|.
  static CertVerifierParamsPtr
  NewCreationParams(
      CertVerifierCreationParamsPtr creation_params) {
    auto result = CertVerifierParamsPtr(base::in_place);
    result->set_creation_params(std::move(creation_params));
    return result;
  }

  template <typename U>
  static CertVerifierParamsPtr From(const U& u) {
    return mojo::TypeConverter<CertVerifierParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CertVerifierParams>::Convert(*this);
  }

  CertVerifierParams();
  ~CertVerifierParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename UnionPtrType = CertVerifierParamsPtr>
  CertVerifierParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T,
            typename std::enable_if<std::is_same<
                T, CertVerifierParams>::value>::type* = nullptr>
  bool Equals(const T& other) const;

  Tag which() const {
    return tag_;
  }


  
  bool is_remote_params() const { return tag_ == Tag::REMOTE_PARAMS; }

  
  CertVerifierServiceRemoteParamsPtr& get_remote_params() const {
    DCHECK(tag_ == Tag::REMOTE_PARAMS);
    return *(data_.remote_params);
  }

  
  void set_remote_params(
      CertVerifierServiceRemoteParamsPtr remote_params);
  
  bool is_creation_params() const { return tag_ == Tag::CREATION_PARAMS; }

  
  CertVerifierCreationParamsPtr& get_creation_params() const {
    DCHECK(tag_ == Tag::CREATION_PARAMS);
    return *(data_.creation_params);
  }

  
  void set_creation_params(
      CertVerifierCreationParamsPtr creation_params);

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CertVerifierParams::DataView>(input);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    return mojo::internal::DeserializeImpl<CertVerifierParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

 private:
  union Union_ {
    Union_() {}
    ~Union_() {}
    CertVerifierServiceRemoteParamsPtr* remote_params;
    CertVerifierCreationParamsPtr* creation_params;
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  void DestroyActive();
  Tag tag_;
  Union_ data_;
};





class  CustomProxyConfig {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CustomProxyConfig, T>::value>;
  using DataView = CustomProxyConfigDataView;
  using Data_ = internal::CustomProxyConfig_Data;

  template <typename... Args>
  static CustomProxyConfigPtr New(Args&&... args) {
    return CustomProxyConfigPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CustomProxyConfigPtr From(const U& u) {
    return mojo::TypeConverter<CustomProxyConfigPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CustomProxyConfig>::Convert(*this);
  }


  CustomProxyConfig();

  CustomProxyConfig(
      const ::net::ProxyConfig::ProxyRules& rules,
      bool should_override_existing_config,
      bool allow_non_idempotent_methods,
      const ::net::HttpRequestHeaders& connect_tunnel_headers);

  ~CustomProxyConfig();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CustomProxyConfigPtr>
  CustomProxyConfigPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CustomProxyConfig::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CustomProxyConfig::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CustomProxyConfig_UnserializedMessageContext<
            UserType, CustomProxyConfig::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CustomProxyConfig::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CustomProxyConfig::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CustomProxyConfig_UnserializedMessageContext<
            UserType, CustomProxyConfig::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CustomProxyConfig::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::net::ProxyConfig::ProxyRules rules;
  
  bool should_override_existing_config;
  
  bool allow_non_idempotent_methods;
  
  ::net::HttpRequestHeaders connect_tunnel_headers;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CustomProxyConfig::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  CertVerifierServiceRemoteParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CertVerifierServiceRemoteParams, T>::value>;
  using DataView = CertVerifierServiceRemoteParamsDataView;
  using Data_ = internal::CertVerifierServiceRemoteParams_Data;

  template <typename... Args>
  static CertVerifierServiceRemoteParamsPtr New(Args&&... args) {
    return CertVerifierServiceRemoteParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CertVerifierServiceRemoteParamsPtr From(const U& u) {
    return mojo::TypeConverter<CertVerifierServiceRemoteParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CertVerifierServiceRemoteParams>::Convert(*this);
  }


  CertVerifierServiceRemoteParams();

  explicit CertVerifierServiceRemoteParams(
      ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierService> cert_verifier_service);

  ~CertVerifierServiceRemoteParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CertVerifierServiceRemoteParamsPtr>
  CertVerifierServiceRemoteParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CertVerifierServiceRemoteParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CertVerifierServiceRemoteParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CertVerifierServiceRemoteParams_UnserializedMessageContext<
            UserType, CertVerifierServiceRemoteParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CertVerifierServiceRemoteParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CertVerifierServiceRemoteParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CertVerifierServiceRemoteParams_UnserializedMessageContext<
            UserType, CertVerifierServiceRemoteParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CertVerifierServiceRemoteParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::PendingRemote<::cert_verifier::mojom::CertVerifierService> cert_verifier_service;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(CertVerifierServiceRemoteParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  CTPolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CTPolicy, T>::value>;
  using DataView = CTPolicyDataView;
  using Data_ = internal::CTPolicy_Data;

  template <typename... Args>
  static CTPolicyPtr New(Args&&... args) {
    return CTPolicyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CTPolicyPtr From(const U& u) {
    return mojo::TypeConverter<CTPolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CTPolicy>::Convert(*this);
  }


  CTPolicy();

  CTPolicy(
      std::vector<std::string> required_hosts,
      std::vector<std::string> excluded_hosts,
      std::vector<std::string> excluded_spkis,
      std::vector<std::string> excluded_legacy_spkis);

  ~CTPolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CTPolicyPtr>
  CTPolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CTPolicy::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CTPolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CTPolicy_UnserializedMessageContext<
            UserType, CTPolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CTPolicy::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return CTPolicy::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CTPolicy_UnserializedMessageContext<
            UserType, CTPolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CTPolicy::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  std::vector<std::string> required_hosts;
  
  std::vector<std::string> excluded_hosts;
  
  std::vector<std::string> excluded_spkis;
  
  std::vector<std::string> excluded_legacy_spkis;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CTPolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NetworkContextParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkContextParams, T>::value>;
  using DataView = NetworkContextParamsDataView;
  using Data_ = internal::NetworkContextParams_Data;

  template <typename... Args>
  static NetworkContextParamsPtr New(Args&&... args) {
    return NetworkContextParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkContextParamsPtr From(const U& u) {
    return mojo::TypeConverter<NetworkContextParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkContextParams>::Convert(*this);
  }


  NetworkContextParams();

  NetworkContextParams(
      const base::Optional<std::string>& context_name,
      const std::string& user_agent,
      const std::string& accept_language,
      bool enable_brotli,
      const std::string& quic_user_agent_id,
      bool enable_referrers,
      bool validate_referrer_policy_on_initial_request,
      ::mojo::PendingRemote<::proxy_resolver::mojom::ProxyResolverFactory> proxy_resolver_factory,
      const base::Optional<::base::FilePath>& cookie_path,
      const base::Optional<::base::FilePath>& trust_token_path,
      bool enable_encrypted_cookies,
      bool restore_old_session_cookies,
      bool persist_session_cookies,
      bool http_cache_enabled,
      int32_t http_cache_max_size,
      const base::Optional<::base::FilePath>& http_cache_path,
      const base::Optional<::base::FilePath>& http_server_properties_path,
      const base::Optional<::base::FilePath>& transport_security_persister_path,
      bool enable_ftp_url_support,
      bool disable_idle_sockets_close_on_memory_pressure,
      ::network::mojom::SSLConfigPtr initial_ssl_config,
      ::mojo::PendingReceiver<::network::mojom::SSLConfigClient> ssl_config_client_receiver,
      const base::Optional<::net::ProxyConfigWithAnnotation>& initial_proxy_config,
      ::mojo::PendingReceiver<::network::mojom::ProxyConfigClient> proxy_config_client_receiver,
      CustomProxyConfigPtr initial_custom_proxy_config,
      ::mojo::PendingReceiver<CustomProxyConfigClient> custom_proxy_config_client_receiver,
      ::mojo::PendingRemote<::network::mojom::ProxyConfigPollerClient> proxy_config_poller_client,
      ::mojo::PendingRemote<::network::mojom::ProxyErrorClient> proxy_error_client,
      bool pac_quick_check_enabled,
      bool enable_certificate_reporting,
      bool enforce_chrome_ct_policy,
      bool enable_expect_ct_reporting,
      bool enable_sct_auditing,
      std::vector<::network::mojom::CTLogInfoPtr> ct_logs,
      CTPolicyPtr ct_policy,
      ::base::Time ct_log_update_time,
      CertVerifierParamsPtr cert_verifier_params,
      ::network::mojom::CookieManagerParamsPtr cookie_manager_params,
      ::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager,
      bool enable_domain_reliability,
      const std::string& domain_reliability_upload_reporter,
      bool discard_domain_reliablity_uploads,
      base::Optional<::base::TimeDelta> reporting_delivery_interval,
      bool skip_reporting_send_permission_check,
      std::vector<::network::mojom::CorsOriginAccessPatternsPtr> cors_origin_access_list,
      std::vector<std::string> cors_exempt_header_list,
      bool allow_any_cors_exempt_header_for_browser,
      std::vector<std::string> hsts_policy_bypass_list,
      const base::Optional<::base::FilePath>& reporting_and_nel_store_path,
      HttpAuthStaticNetworkContextParamsPtr http_auth_static_network_context_params,
      bool reset_http_cache_backend,
      bool split_auth_cache_by_network_isolation_key,
      bool require_network_isolation_key);

  ~NetworkContextParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkContextParamsPtr>
  NetworkContextParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkContextParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkContextParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkContextParams_UnserializedMessageContext<
            UserType, NetworkContextParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NetworkContextParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return NetworkContextParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkContextParams_UnserializedMessageContext<
            UserType, NetworkContextParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkContextParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  base::Optional<std::string> context_name;
  
  std::string user_agent;
  
  std::string accept_language;
  
  bool enable_brotli;
  
  std::string quic_user_agent_id;
  
  bool enable_referrers;
  
  bool validate_referrer_policy_on_initial_request;
  
  ::mojo::PendingRemote<::proxy_resolver::mojom::ProxyResolverFactory> proxy_resolver_factory;
  
  base::Optional<::base::FilePath> cookie_path;
  
  base::Optional<::base::FilePath> trust_token_path;
  
  bool enable_encrypted_cookies;
  
  bool restore_old_session_cookies;
  
  bool persist_session_cookies;
  
  bool http_cache_enabled;
  
  int32_t http_cache_max_size;
  
  base::Optional<::base::FilePath> http_cache_path;
  
  base::Optional<::base::FilePath> http_server_properties_path;
  
  base::Optional<::base::FilePath> transport_security_persister_path;
  
  bool enable_ftp_url_support;
  
  bool disable_idle_sockets_close_on_memory_pressure;
  
  ::network::mojom::SSLConfigPtr initial_ssl_config;
  
  ::mojo::PendingReceiver<::network::mojom::SSLConfigClient> ssl_config_client_receiver;
  
  base::Optional<::net::ProxyConfigWithAnnotation> initial_proxy_config;
  
  ::mojo::PendingReceiver<::network::mojom::ProxyConfigClient> proxy_config_client_receiver;
  
  CustomProxyConfigPtr initial_custom_proxy_config;
  
  ::mojo::PendingReceiver<CustomProxyConfigClient> custom_proxy_config_client_receiver;
  
  ::mojo::PendingRemote<::network::mojom::ProxyConfigPollerClient> proxy_config_poller_client;
  
  ::mojo::PendingRemote<::network::mojom::ProxyErrorClient> proxy_error_client;
  
  bool pac_quick_check_enabled;
  
  bool enable_certificate_reporting;
  
  bool enforce_chrome_ct_policy;
  
  bool enable_expect_ct_reporting;
  
  bool enable_sct_auditing;
  
  std::vector<::network::mojom::CTLogInfoPtr> ct_logs;
  
  CTPolicyPtr ct_policy;
  
  ::base::Time ct_log_update_time;
  
  CertVerifierParamsPtr cert_verifier_params;
  
  ::network::mojom::CookieManagerParamsPtr cookie_manager_params;
  
  ::mojo::PendingReceiver<::network::mojom::CookieManager> cookie_manager;
  
  bool enable_domain_reliability;
  
  std::string domain_reliability_upload_reporter;
  
  bool discard_domain_reliablity_uploads;
  
  base::Optional<::base::TimeDelta> reporting_delivery_interval;
  
  bool skip_reporting_send_permission_check;
  
  std::vector<::network::mojom::CorsOriginAccessPatternsPtr> cors_origin_access_list;
  
  std::vector<std::string> cors_exempt_header_list;
  
  bool allow_any_cors_exempt_header_for_browser;
  
  std::vector<std::string> hsts_policy_bypass_list;
  
  base::Optional<::base::FilePath> reporting_and_nel_store_path;
  
  HttpAuthStaticNetworkContextParamsPtr http_auth_static_network_context_params;
  
  bool reset_http_cache_backend;
  
  bool split_auth_cache_by_network_isolation_key;
  
  bool require_network_isolation_key;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(NetworkContextParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkContextParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  NetworkConditions {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<NetworkConditions, T>::value>;
  using DataView = NetworkConditionsDataView;
  using Data_ = internal::NetworkConditions_Data;

  template <typename... Args>
  static NetworkConditionsPtr New(Args&&... args) {
    return NetworkConditionsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static NetworkConditionsPtr From(const U& u) {
    return mojo::TypeConverter<NetworkConditionsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, NetworkConditions>::Convert(*this);
  }


  NetworkConditions();

  NetworkConditions(
      bool offline,
      ::base::TimeDelta latency,
      double download_throughput,
      double upload_throughput);

  ~NetworkConditions();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = NetworkConditionsPtr>
  NetworkConditionsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        NetworkConditions::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        NetworkConditions::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::NetworkConditions_UnserializedMessageContext<
            UserType, NetworkConditions::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<NetworkConditions::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return NetworkConditions::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::NetworkConditions_UnserializedMessageContext<
            UserType, NetworkConditions::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<NetworkConditions::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool offline;
  
  ::base::TimeDelta latency;
  
  double download_throughput;
  
  double upload_throughput;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, NetworkConditions::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  ClearDataFilter {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<ClearDataFilter, T>::value>;
  using DataView = ClearDataFilterDataView;
  using Data_ = internal::ClearDataFilter_Data;
  using Type = ClearDataFilter_Type;

  template <typename... Args>
  static ClearDataFilterPtr New(Args&&... args) {
    return ClearDataFilterPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static ClearDataFilterPtr From(const U& u) {
    return mojo::TypeConverter<ClearDataFilterPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, ClearDataFilter>::Convert(*this);
  }


  ClearDataFilter();

  ClearDataFilter(
      ClearDataFilter::Type type,
      std::vector<std::string> domains,
      std::vector<::url::Origin> origins);

  ~ClearDataFilter();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = ClearDataFilterPtr>
  ClearDataFilterPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, ClearDataFilter::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        ClearDataFilter::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        ClearDataFilter::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::ClearDataFilter_UnserializedMessageContext<
            UserType, ClearDataFilter::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<ClearDataFilter::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return ClearDataFilter::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::ClearDataFilter_UnserializedMessageContext<
            UserType, ClearDataFilter::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<ClearDataFilter::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ClearDataFilter::Type type;
  
  std::vector<std::string> domains;
  
  std::vector<::url::Origin> origins;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, ClearDataFilter::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, ClearDataFilter::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, ClearDataFilter::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, ClearDataFilter::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class  SignedExchangeReport {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<SignedExchangeReport, T>::value>;
  using DataView = SignedExchangeReportDataView;
  using Data_ = internal::SignedExchangeReport_Data;

  template <typename... Args>
  static SignedExchangeReportPtr New(Args&&... args) {
    return SignedExchangeReportPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static SignedExchangeReportPtr From(const U& u) {
    return mojo::TypeConverter<SignedExchangeReportPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, SignedExchangeReport>::Convert(*this);
  }


  SignedExchangeReport();

  SignedExchangeReport(
      bool success,
      const std::string& type,
      const ::GURL& outer_url,
      const ::GURL& inner_url,
      const ::GURL& cert_url,
      const std::string& referrer,
      const ::net::IPAddress& server_ip_address,
      const std::string& protocol,
      const std::string& method,
      int32_t status_code,
      ::base::TimeDelta elapsed_time);

  ~SignedExchangeReport();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = SignedExchangeReportPtr>
  SignedExchangeReportPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        SignedExchangeReport::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        SignedExchangeReport::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::SignedExchangeReport_UnserializedMessageContext<
            UserType, SignedExchangeReport::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<SignedExchangeReport::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return SignedExchangeReport::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::SignedExchangeReport_UnserializedMessageContext<
            UserType, SignedExchangeReport::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<SignedExchangeReport::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool success;
  
  std::string type;
  
  ::GURL outer_url;
  
  ::GURL inner_url;
  
  ::GURL cert_url;
  
  std::string referrer;
  
  ::net::IPAddress server_ip_address;
  
  std::string protocol;
  
  std::string method;
  
  int32_t status_code;
  
  ::base::TimeDelta elapsed_time;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, SignedExchangeReport::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  URLLoaderFactoryOverride {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLLoaderFactoryOverride, T>::value>;
  using DataView = URLLoaderFactoryOverrideDataView;
  using Data_ = internal::URLLoaderFactoryOverride_Data;

  template <typename... Args>
  static URLLoaderFactoryOverridePtr New(Args&&... args) {
    return URLLoaderFactoryOverridePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLLoaderFactoryOverridePtr From(const U& u) {
    return mojo::TypeConverter<URLLoaderFactoryOverridePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLLoaderFactoryOverride>::Convert(*this);
  }


  URLLoaderFactoryOverride();

  URLLoaderFactoryOverride(
      ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> overriding_factory,
      ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> overridden_factory_receiver,
      bool skip_cors_enabled_scheme_check);

  ~URLLoaderFactoryOverride();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLLoaderFactoryOverridePtr>
  URLLoaderFactoryOverridePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLLoaderFactoryOverride::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLLoaderFactoryOverride::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLLoaderFactoryOverride_UnserializedMessageContext<
            UserType, URLLoaderFactoryOverride::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<URLLoaderFactoryOverride::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return URLLoaderFactoryOverride::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLLoaderFactoryOverride_UnserializedMessageContext<
            UserType, URLLoaderFactoryOverride::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLLoaderFactoryOverride::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::mojo::PendingRemote<::network::mojom::URLLoaderFactory> overriding_factory;
  
  ::mojo::PendingReceiver<::network::mojom::URLLoaderFactory> overridden_factory_receiver;
  
  bool skip_cors_enabled_scheme_check;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(URLLoaderFactoryOverride);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class  URLLoaderFactoryParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<URLLoaderFactoryParams, T>::value>;
  using DataView = URLLoaderFactoryParamsDataView;
  using Data_ = internal::URLLoaderFactoryParams_Data;

  template <typename... Args>
  static URLLoaderFactoryParamsPtr New(Args&&... args) {
    return URLLoaderFactoryParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static URLLoaderFactoryParamsPtr From(const U& u) {
    return mojo::TypeConverter<URLLoaderFactoryParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, URLLoaderFactoryParams>::Convert(*this);
  }


  URLLoaderFactoryParams();

  URLLoaderFactoryParams(
      int32_t process_id,
      const base::Optional<::url::Origin>& request_initiator_origin_lock,
      bool is_corb_enabled,
      bool ignore_isolated_world_origin,
      bool unsafe_non_webby_initiator,
      bool disable_web_security,
      ::mojo::PendingRemote<TrustedURLLoaderHeaderClient> header_client,
      ::network::mojom::CorsOriginAccessPatternsPtr factory_bound_access_patterns,
      const ::net::IsolationInfo& isolation_info,
      bool disable_secure_dns,
      bool is_trusted,
      bool automatically_assign_isolation_info,
      const base::Optional<::base::UnguessableToken>& top_frame_id,
      URLLoaderFactoryOverridePtr factory_override,
      ::network::mojom::ClientSecurityStatePtr client_security_state,
      ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter,
      ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer,
      TrustTokenRedemptionPolicy trust_token_redemption_policy,
      const std::string& debug_tag);

  ~URLLoaderFactoryParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = URLLoaderFactoryParamsPtr>
  URLLoaderFactoryParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        URLLoaderFactoryParams::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        URLLoaderFactoryParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::URLLoaderFactoryParams_UnserializedMessageContext<
            UserType, URLLoaderFactoryParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<URLLoaderFactoryParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return URLLoaderFactoryParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::URLLoaderFactoryParams_UnserializedMessageContext<
            UserType, URLLoaderFactoryParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<URLLoaderFactoryParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t process_id;
  
  base::Optional<::url::Origin> request_initiator_origin_lock;
  
  bool is_corb_enabled;
  
  bool ignore_isolated_world_origin;
  
  bool unsafe_non_webby_initiator;
  
  bool disable_web_security;
  
  ::mojo::PendingRemote<TrustedURLLoaderHeaderClient> header_client;
  
  ::network::mojom::CorsOriginAccessPatternsPtr factory_bound_access_patterns;
  
  ::net::IsolationInfo isolation_info;
  
  bool disable_secure_dns;
  
  bool is_trusted;
  
  bool automatically_assign_isolation_info;
  
  base::Optional<::base::UnguessableToken> top_frame_id;
  
  URLLoaderFactoryOverridePtr factory_override;
  
  ::network::mojom::ClientSecurityStatePtr client_security_state;
  
  ::mojo::PendingRemote<::network::mojom::CrossOriginEmbedderPolicyReporter> coep_reporter;
  
  ::mojo::PendingRemote<::network::mojom::CookieAccessObserver> cookie_observer;
  
  TrustTokenRedemptionPolicy trust_token_redemption_policy;
  
  std::string debug_tag;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(URLLoaderFactoryParams);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, URLLoaderFactoryParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename UnionPtrType>
CertVerifierParamsPtr CertVerifierParams::Clone() const {
  // Use UnionPtrType to prevent the compiler from trying to compile this
  // without being asked.
  UnionPtrType rv(New());
  switch (tag_) {
    case Tag::REMOTE_PARAMS:
      rv->set_remote_params(mojo::Clone(*data_.remote_params));
      break;
    case Tag::CREATION_PARAMS:
      rv->set_creation_params(mojo::Clone(*data_.creation_params));
      break;
  }
  return rv;
}

template <typename T,
          typename std::enable_if<std::is_same<
              T, CertVerifierParams>::value>::type*>
bool CertVerifierParams::Equals(const T& other) const {
  if (tag_ != other.which())
    return false;

  switch (tag_) {
    case Tag::REMOTE_PARAMS:
      return mojo::Equals(*(data_.remote_params), *(other.data_.remote_params));
    case Tag::CREATION_PARAMS:
      return mojo::Equals(*(data_.creation_params), *(other.data_.creation_params));
  }

  return false;
}
template <typename StructPtrType>
CustomProxyConfigPtr CustomProxyConfig::Clone() const {
  return New(
      mojo::Clone(rules),
      mojo::Clone(should_override_existing_config),
      mojo::Clone(allow_non_idempotent_methods),
      mojo::Clone(connect_tunnel_headers)
  );
}

template <typename T, CustomProxyConfig::EnableIfSame<T>*>
bool CustomProxyConfig::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->rules, other_struct.rules))
    return false;
  if (!mojo::Equals(this->should_override_existing_config, other_struct.should_override_existing_config))
    return false;
  if (!mojo::Equals(this->allow_non_idempotent_methods, other_struct.allow_non_idempotent_methods))
    return false;
  if (!mojo::Equals(this->connect_tunnel_headers, other_struct.connect_tunnel_headers))
    return false;
  return true;
}

template <typename T, CustomProxyConfig::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.rules, rhs.rules))
    return true;
  if (std::less<>{}(rhs.rules, lhs.rules))
    return false;
  if (std::less<>{}(lhs.should_override_existing_config, rhs.should_override_existing_config))
    return true;
  if (std::less<>{}(rhs.should_override_existing_config, lhs.should_override_existing_config))
    return false;
  if (std::less<>{}(lhs.allow_non_idempotent_methods, rhs.allow_non_idempotent_methods))
    return true;
  if (std::less<>{}(rhs.allow_non_idempotent_methods, lhs.allow_non_idempotent_methods))
    return false;
  if (std::less<>{}(lhs.connect_tunnel_headers, rhs.connect_tunnel_headers))
    return true;
  if (std::less<>{}(rhs.connect_tunnel_headers, lhs.connect_tunnel_headers))
    return false;
  return false;
}
template <typename StructPtrType>
CertVerifierCreationParamsPtr CertVerifierCreationParams::Clone() const {
  return New(
  );
}

template <typename T, CertVerifierCreationParams::EnableIfSame<T>*>
bool CertVerifierCreationParams::Equals(const T& other_struct) const {
  return true;
}

template <typename T, CertVerifierCreationParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  return false;
}
template <typename StructPtrType>
CertVerifierServiceRemoteParamsPtr CertVerifierServiceRemoteParams::Clone() const {
  return New(
      mojo::Clone(cert_verifier_service)
  );
}

template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>*>
bool CertVerifierServiceRemoteParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->cert_verifier_service, other_struct.cert_verifier_service))
    return false;
  return true;
}

template <typename T, CertVerifierServiceRemoteParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.cert_verifier_service, rhs.cert_verifier_service))
    return true;
  if (std::less<>{}(rhs.cert_verifier_service, lhs.cert_verifier_service))
    return false;
  return false;
}
template <typename StructPtrType>
HttpAuthStaticNetworkContextParamsPtr HttpAuthStaticNetworkContextParams::Clone() const {
  return New(
      mojo::Clone(allow_default_credentials)
  );
}

template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>*>
bool HttpAuthStaticNetworkContextParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->allow_default_credentials, other_struct.allow_default_credentials))
    return false;
  return true;
}

template <typename T, HttpAuthStaticNetworkContextParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.allow_default_credentials, rhs.allow_default_credentials))
    return true;
  if (std::less<>{}(rhs.allow_default_credentials, lhs.allow_default_credentials))
    return false;
  return false;
}
template <typename StructPtrType>
CTPolicyPtr CTPolicy::Clone() const {
  return New(
      mojo::Clone(required_hosts),
      mojo::Clone(excluded_hosts),
      mojo::Clone(excluded_spkis),
      mojo::Clone(excluded_legacy_spkis)
  );
}

template <typename T, CTPolicy::EnableIfSame<T>*>
bool CTPolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->required_hosts, other_struct.required_hosts))
    return false;
  if (!mojo::Equals(this->excluded_hosts, other_struct.excluded_hosts))
    return false;
  if (!mojo::Equals(this->excluded_spkis, other_struct.excluded_spkis))
    return false;
  if (!mojo::Equals(this->excluded_legacy_spkis, other_struct.excluded_legacy_spkis))
    return false;
  return true;
}

template <typename T, CTPolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.required_hosts, rhs.required_hosts))
    return true;
  if (std::less<>{}(rhs.required_hosts, lhs.required_hosts))
    return false;
  if (std::less<>{}(lhs.excluded_hosts, rhs.excluded_hosts))
    return true;
  if (std::less<>{}(rhs.excluded_hosts, lhs.excluded_hosts))
    return false;
  if (std::less<>{}(lhs.excluded_spkis, rhs.excluded_spkis))
    return true;
  if (std::less<>{}(rhs.excluded_spkis, lhs.excluded_spkis))
    return false;
  if (std::less<>{}(lhs.excluded_legacy_spkis, rhs.excluded_legacy_spkis))
    return true;
  if (std::less<>{}(rhs.excluded_legacy_spkis, lhs.excluded_legacy_spkis))
    return false;
  return false;
}
template <typename StructPtrType>
NetworkContextParamsPtr NetworkContextParams::Clone() const {
  return New(
      mojo::Clone(context_name),
      mojo::Clone(user_agent),
      mojo::Clone(accept_language),
      mojo::Clone(enable_brotli),
      mojo::Clone(quic_user_agent_id),
      mojo::Clone(enable_referrers),
      mojo::Clone(validate_referrer_policy_on_initial_request),
      mojo::Clone(proxy_resolver_factory),
      mojo::Clone(cookie_path),
      mojo::Clone(trust_token_path),
      mojo::Clone(enable_encrypted_cookies),
      mojo::Clone(restore_old_session_cookies),
      mojo::Clone(persist_session_cookies),
      mojo::Clone(http_cache_enabled),
      mojo::Clone(http_cache_max_size),
      mojo::Clone(http_cache_path),
      mojo::Clone(http_server_properties_path),
      mojo::Clone(transport_security_persister_path),
      mojo::Clone(enable_ftp_url_support),
      mojo::Clone(disable_idle_sockets_close_on_memory_pressure),
      mojo::Clone(initial_ssl_config),
      mojo::Clone(ssl_config_client_receiver),
      mojo::Clone(initial_proxy_config),
      mojo::Clone(proxy_config_client_receiver),
      mojo::Clone(initial_custom_proxy_config),
      mojo::Clone(custom_proxy_config_client_receiver),
      mojo::Clone(proxy_config_poller_client),
      mojo::Clone(proxy_error_client),
      mojo::Clone(pac_quick_check_enabled),
      mojo::Clone(enable_certificate_reporting),
      mojo::Clone(enforce_chrome_ct_policy),
      mojo::Clone(enable_expect_ct_reporting),
      mojo::Clone(enable_sct_auditing),
      mojo::Clone(ct_logs),
      mojo::Clone(ct_policy),
      mojo::Clone(ct_log_update_time),
      mojo::Clone(cert_verifier_params),
      mojo::Clone(cookie_manager_params),
      mojo::Clone(cookie_manager),
      mojo::Clone(enable_domain_reliability),
      mojo::Clone(domain_reliability_upload_reporter),
      mojo::Clone(discard_domain_reliablity_uploads),
      mojo::Clone(reporting_delivery_interval),
      mojo::Clone(skip_reporting_send_permission_check),
      mojo::Clone(cors_origin_access_list),
      mojo::Clone(cors_exempt_header_list),
      mojo::Clone(allow_any_cors_exempt_header_for_browser),
      mojo::Clone(hsts_policy_bypass_list),
      mojo::Clone(reporting_and_nel_store_path),
      mojo::Clone(http_auth_static_network_context_params),
      mojo::Clone(reset_http_cache_backend),
      mojo::Clone(split_auth_cache_by_network_isolation_key),
      mojo::Clone(require_network_isolation_key)
  );
}

template <typename T, NetworkContextParams::EnableIfSame<T>*>
bool NetworkContextParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->context_name, other_struct.context_name))
    return false;
  if (!mojo::Equals(this->user_agent, other_struct.user_agent))
    return false;
  if (!mojo::Equals(this->accept_language, other_struct.accept_language))
    return false;
  if (!mojo::Equals(this->enable_brotli, other_struct.enable_brotli))
    return false;
  if (!mojo::Equals(this->quic_user_agent_id, other_struct.quic_user_agent_id))
    return false;
  if (!mojo::Equals(this->enable_referrers, other_struct.enable_referrers))
    return false;
  if (!mojo::Equals(this->validate_referrer_policy_on_initial_request, other_struct.validate_referrer_policy_on_initial_request))
    return false;
  if (!mojo::Equals(this->proxy_resolver_factory, other_struct.proxy_resolver_factory))
    return false;
  if (!mojo::Equals(this->cookie_path, other_struct.cookie_path))
    return false;
  if (!mojo::Equals(this->trust_token_path, other_struct.trust_token_path))
    return false;
  if (!mojo::Equals(this->enable_encrypted_cookies, other_struct.enable_encrypted_cookies))
    return false;
  if (!mojo::Equals(this->restore_old_session_cookies, other_struct.restore_old_session_cookies))
    return false;
  if (!mojo::Equals(this->persist_session_cookies, other_struct.persist_session_cookies))
    return false;
  if (!mojo::Equals(this->http_cache_enabled, other_struct.http_cache_enabled))
    return false;
  if (!mojo::Equals(this->http_cache_max_size, other_struct.http_cache_max_size))
    return false;
  if (!mojo::Equals(this->http_cache_path, other_struct.http_cache_path))
    return false;
  if (!mojo::Equals(this->http_server_properties_path, other_struct.http_server_properties_path))
    return false;
  if (!mojo::Equals(this->transport_security_persister_path, other_struct.transport_security_persister_path))
    return false;
  if (!mojo::Equals(this->enable_ftp_url_support, other_struct.enable_ftp_url_support))
    return false;
  if (!mojo::Equals(this->disable_idle_sockets_close_on_memory_pressure, other_struct.disable_idle_sockets_close_on_memory_pressure))
    return false;
  if (!mojo::Equals(this->initial_ssl_config, other_struct.initial_ssl_config))
    return false;
  if (!mojo::Equals(this->ssl_config_client_receiver, other_struct.ssl_config_client_receiver))
    return false;
  if (!mojo::Equals(this->initial_proxy_config, other_struct.initial_proxy_config))
    return false;
  if (!mojo::Equals(this->proxy_config_client_receiver, other_struct.proxy_config_client_receiver))
    return false;
  if (!mojo::Equals(this->initial_custom_proxy_config, other_struct.initial_custom_proxy_config))
    return false;
  if (!mojo::Equals(this->custom_proxy_config_client_receiver, other_struct.custom_proxy_config_client_receiver))
    return false;
  if (!mojo::Equals(this->proxy_config_poller_client, other_struct.proxy_config_poller_client))
    return false;
  if (!mojo::Equals(this->proxy_error_client, other_struct.proxy_error_client))
    return false;
  if (!mojo::Equals(this->pac_quick_check_enabled, other_struct.pac_quick_check_enabled))
    return false;
  if (!mojo::Equals(this->enable_certificate_reporting, other_struct.enable_certificate_reporting))
    return false;
  if (!mojo::Equals(this->enforce_chrome_ct_policy, other_struct.enforce_chrome_ct_policy))
    return false;
  if (!mojo::Equals(this->enable_expect_ct_reporting, other_struct.enable_expect_ct_reporting))
    return false;
  if (!mojo::Equals(this->enable_sct_auditing, other_struct.enable_sct_auditing))
    return false;
  if (!mojo::Equals(this->ct_logs, other_struct.ct_logs))
    return false;
  if (!mojo::Equals(this->ct_policy, other_struct.ct_policy))
    return false;
  if (!mojo::Equals(this->ct_log_update_time, other_struct.ct_log_update_time))
    return false;
  if (!mojo::Equals(this->cert_verifier_params, other_struct.cert_verifier_params))
    return false;
  if (!mojo::Equals(this->cookie_manager_params, other_struct.cookie_manager_params))
    return false;
  if (!mojo::Equals(this->cookie_manager, other_struct.cookie_manager))
    return false;
  if (!mojo::Equals(this->enable_domain_reliability, other_struct.enable_domain_reliability))
    return false;
  if (!mojo::Equals(this->domain_reliability_upload_reporter, other_struct.domain_reliability_upload_reporter))
    return false;
  if (!mojo::Equals(this->discard_domain_reliablity_uploads, other_struct.discard_domain_reliablity_uploads))
    return false;
  if (!mojo::Equals(this->reporting_delivery_interval, other_struct.reporting_delivery_interval))
    return false;
  if (!mojo::Equals(this->skip_reporting_send_permission_check, other_struct.skip_reporting_send_permission_check))
    return false;
  if (!mojo::Equals(this->cors_origin_access_list, other_struct.cors_origin_access_list))
    return false;
  if (!mojo::Equals(this->cors_exempt_header_list, other_struct.cors_exempt_header_list))
    return false;
  if (!mojo::Equals(this->allow_any_cors_exempt_header_for_browser, other_struct.allow_any_cors_exempt_header_for_browser))
    return false;
  if (!mojo::Equals(this->hsts_policy_bypass_list, other_struct.hsts_policy_bypass_list))
    return false;
  if (!mojo::Equals(this->reporting_and_nel_store_path, other_struct.reporting_and_nel_store_path))
    return false;
  if (!mojo::Equals(this->http_auth_static_network_context_params, other_struct.http_auth_static_network_context_params))
    return false;
  if (!mojo::Equals(this->reset_http_cache_backend, other_struct.reset_http_cache_backend))
    return false;
  if (!mojo::Equals(this->split_auth_cache_by_network_isolation_key, other_struct.split_auth_cache_by_network_isolation_key))
    return false;
  if (!mojo::Equals(this->require_network_isolation_key, other_struct.require_network_isolation_key))
    return false;
  return true;
}

template <typename T, NetworkContextParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.context_name, rhs.context_name))
    return true;
  if (std::less<>{}(rhs.context_name, lhs.context_name))
    return false;
  if (std::less<>{}(lhs.user_agent, rhs.user_agent))
    return true;
  if (std::less<>{}(rhs.user_agent, lhs.user_agent))
    return false;
  if (std::less<>{}(lhs.accept_language, rhs.accept_language))
    return true;
  if (std::less<>{}(rhs.accept_language, lhs.accept_language))
    return false;
  if (std::less<>{}(lhs.enable_brotli, rhs.enable_brotli))
    return true;
  if (std::less<>{}(rhs.enable_brotli, lhs.enable_brotli))
    return false;
  if (std::less<>{}(lhs.quic_user_agent_id, rhs.quic_user_agent_id))
    return true;
  if (std::less<>{}(rhs.quic_user_agent_id, lhs.quic_user_agent_id))
    return false;
  if (std::less<>{}(lhs.enable_referrers, rhs.enable_referrers))
    return true;
  if (std::less<>{}(rhs.enable_referrers, lhs.enable_referrers))
    return false;
  if (std::less<>{}(lhs.validate_referrer_policy_on_initial_request, rhs.validate_referrer_policy_on_initial_request))
    return true;
  if (std::less<>{}(rhs.validate_referrer_policy_on_initial_request, lhs.validate_referrer_policy_on_initial_request))
    return false;
  if (std::less<>{}(lhs.proxy_resolver_factory, rhs.proxy_resolver_factory))
    return true;
  if (std::less<>{}(rhs.proxy_resolver_factory, lhs.proxy_resolver_factory))
    return false;
  if (std::less<>{}(lhs.cookie_path, rhs.cookie_path))
    return true;
  if (std::less<>{}(rhs.cookie_path, lhs.cookie_path))
    return false;
  if (std::less<>{}(lhs.trust_token_path, rhs.trust_token_path))
    return true;
  if (std::less<>{}(rhs.trust_token_path, lhs.trust_token_path))
    return false;
  if (std::less<>{}(lhs.enable_encrypted_cookies, rhs.enable_encrypted_cookies))
    return true;
  if (std::less<>{}(rhs.enable_encrypted_cookies, lhs.enable_encrypted_cookies))
    return false;
  if (std::less<>{}(lhs.restore_old_session_cookies, rhs.restore_old_session_cookies))
    return true;
  if (std::less<>{}(rhs.restore_old_session_cookies, lhs.restore_old_session_cookies))
    return false;
  if (std::less<>{}(lhs.persist_session_cookies, rhs.persist_session_cookies))
    return true;
  if (std::less<>{}(rhs.persist_session_cookies, lhs.persist_session_cookies))
    return false;
  if (std::less<>{}(lhs.http_cache_enabled, rhs.http_cache_enabled))
    return true;
  if (std::less<>{}(rhs.http_cache_enabled, lhs.http_cache_enabled))
    return false;
  if (std::less<>{}(lhs.http_cache_max_size, rhs.http_cache_max_size))
    return true;
  if (std::less<>{}(rhs.http_cache_max_size, lhs.http_cache_max_size))
    return false;
  if (std::less<>{}(lhs.http_cache_path, rhs.http_cache_path))
    return true;
  if (std::less<>{}(rhs.http_cache_path, lhs.http_cache_path))
    return false;
  if (std::less<>{}(lhs.http_server_properties_path, rhs.http_server_properties_path))
    return true;
  if (std::less<>{}(rhs.http_server_properties_path, lhs.http_server_properties_path))
    return false;
  if (std::less<>{}(lhs.transport_security_persister_path, rhs.transport_security_persister_path))
    return true;
  if (std::less<>{}(rhs.transport_security_persister_path, lhs.transport_security_persister_path))
    return false;
  if (std::less<>{}(lhs.enable_ftp_url_support, rhs.enable_ftp_url_support))
    return true;
  if (std::less<>{}(rhs.enable_ftp_url_support, lhs.enable_ftp_url_support))
    return false;
  if (std::less<>{}(lhs.disable_idle_sockets_close_on_memory_pressure, rhs.disable_idle_sockets_close_on_memory_pressure))
    return true;
  if (std::less<>{}(rhs.disable_idle_sockets_close_on_memory_pressure, lhs.disable_idle_sockets_close_on_memory_pressure))
    return false;
  if (std::less<>{}(lhs.initial_ssl_config, rhs.initial_ssl_config))
    return true;
  if (std::less<>{}(rhs.initial_ssl_config, lhs.initial_ssl_config))
    return false;
  if (std::less<>{}(lhs.ssl_config_client_receiver, rhs.ssl_config_client_receiver))
    return true;
  if (std::less<>{}(rhs.ssl_config_client_receiver, lhs.ssl_config_client_receiver))
    return false;
  if (std::less<>{}(lhs.initial_proxy_config, rhs.initial_proxy_config))
    return true;
  if (std::less<>{}(rhs.initial_proxy_config, lhs.initial_proxy_config))
    return false;
  if (std::less<>{}(lhs.proxy_config_client_receiver, rhs.proxy_config_client_receiver))
    return true;
  if (std::less<>{}(rhs.proxy_config_client_receiver, lhs.proxy_config_client_receiver))
    return false;
  if (std::less<>{}(lhs.initial_custom_proxy_config, rhs.initial_custom_proxy_config))
    return true;
  if (std::less<>{}(rhs.initial_custom_proxy_config, lhs.initial_custom_proxy_config))
    return false;
  if (std::less<>{}(lhs.custom_proxy_config_client_receiver, rhs.custom_proxy_config_client_receiver))
    return true;
  if (std::less<>{}(rhs.custom_proxy_config_client_receiver, lhs.custom_proxy_config_client_receiver))
    return false;
  if (std::less<>{}(lhs.proxy_config_poller_client, rhs.proxy_config_poller_client))
    return true;
  if (std::less<>{}(rhs.proxy_config_poller_client, lhs.proxy_config_poller_client))
    return false;
  if (std::less<>{}(lhs.proxy_error_client, rhs.proxy_error_client))
    return true;
  if (std::less<>{}(rhs.proxy_error_client, lhs.proxy_error_client))
    return false;
  if (std::less<>{}(lhs.pac_quick_check_enabled, rhs.pac_quick_check_enabled))
    return true;
  if (std::less<>{}(rhs.pac_quick_check_enabled, lhs.pac_quick_check_enabled))
    return false;
  if (std::less<>{}(lhs.enable_certificate_reporting, rhs.enable_certificate_reporting))
    return true;
  if (std::less<>{}(rhs.enable_certificate_reporting, lhs.enable_certificate_reporting))
    return false;
  if (std::less<>{}(lhs.enforce_chrome_ct_policy, rhs.enforce_chrome_ct_policy))
    return true;
  if (std::less<>{}(rhs.enforce_chrome_ct_policy, lhs.enforce_chrome_ct_policy))
    return false;
  if (std::less<>{}(lhs.enable_expect_ct_reporting, rhs.enable_expect_ct_reporting))
    return true;
  if (std::less<>{}(rhs.enable_expect_ct_reporting, lhs.enable_expect_ct_reporting))
    return false;
  if (std::less<>{}(lhs.enable_sct_auditing, rhs.enable_sct_auditing))
    return true;
  if (std::less<>{}(rhs.enable_sct_auditing, lhs.enable_sct_auditing))
    return false;
  if (std::less<>{}(lhs.ct_logs, rhs.ct_logs))
    return true;
  if (std::less<>{}(rhs.ct_logs, lhs.ct_logs))
    return false;
  if (std::less<>{}(lhs.ct_policy, rhs.ct_policy))
    return true;
  if (std::less<>{}(rhs.ct_policy, lhs.ct_policy))
    return false;
  if (std::less<>{}(lhs.ct_log_update_time, rhs.ct_log_update_time))
    return true;
  if (std::less<>{}(rhs.ct_log_update_time, lhs.ct_log_update_time))
    return false;
  if (std::less<>{}(lhs.cert_verifier_params, rhs.cert_verifier_params))
    return true;
  if (std::less<>{}(rhs.cert_verifier_params, lhs.cert_verifier_params))
    return false;
  if (std::less<>{}(lhs.cookie_manager_params, rhs.cookie_manager_params))
    return true;
  if (std::less<>{}(rhs.cookie_manager_params, lhs.cookie_manager_params))
    return false;
  if (std::less<>{}(lhs.cookie_manager, rhs.cookie_manager))
    return true;
  if (std::less<>{}(rhs.cookie_manager, lhs.cookie_manager))
    return false;
  if (std::less<>{}(lhs.enable_domain_reliability, rhs.enable_domain_reliability))
    return true;
  if (std::less<>{}(rhs.enable_domain_reliability, lhs.enable_domain_reliability))
    return false;
  if (std::less<>{}(lhs.domain_reliability_upload_reporter, rhs.domain_reliability_upload_reporter))
    return true;
  if (std::less<>{}(rhs.domain_reliability_upload_reporter, lhs.domain_reliability_upload_reporter))
    return false;
  if (std::less<>{}(lhs.discard_domain_reliablity_uploads, rhs.discard_domain_reliablity_uploads))
    return true;
  if (std::less<>{}(rhs.discard_domain_reliablity_uploads, lhs.discard_domain_reliablity_uploads))
    return false;
  if (std::less<>{}(lhs.reporting_delivery_interval, rhs.reporting_delivery_interval))
    return true;
  if (std::less<>{}(rhs.reporting_delivery_interval, lhs.reporting_delivery_interval))
    return false;
  if (std::less<>{}(lhs.skip_reporting_send_permission_check, rhs.skip_reporting_send_permission_check))
    return true;
  if (std::less<>{}(rhs.skip_reporting_send_permission_check, lhs.skip_reporting_send_permission_check))
    return false;
  if (std::less<>{}(lhs.cors_origin_access_list, rhs.cors_origin_access_list))
    return true;
  if (std::less<>{}(rhs.cors_origin_access_list, lhs.cors_origin_access_list))
    return false;
  if (std::less<>{}(lhs.cors_exempt_header_list, rhs.cors_exempt_header_list))
    return true;
  if (std::less<>{}(rhs.cors_exempt_header_list, lhs.cors_exempt_header_list))
    return false;
  if (std::less<>{}(lhs.allow_any_cors_exempt_header_for_browser, rhs.allow_any_cors_exempt_header_for_browser))
    return true;
  if (std::less<>{}(rhs.allow_any_cors_exempt_header_for_browser, lhs.allow_any_cors_exempt_header_for_browser))
    return false;
  if (std::less<>{}(lhs.hsts_policy_bypass_list, rhs.hsts_policy_bypass_list))
    return true;
  if (std::less<>{}(rhs.hsts_policy_bypass_list, lhs.hsts_policy_bypass_list))
    return false;
  if (std::less<>{}(lhs.reporting_and_nel_store_path, rhs.reporting_and_nel_store_path))
    return true;
  if (std::less<>{}(rhs.reporting_and_nel_store_path, lhs.reporting_and_nel_store_path))
    return false;
  if (std::less<>{}(lhs.http_auth_static_network_context_params, rhs.http_auth_static_network_context_params))
    return true;
  if (std::less<>{}(rhs.http_auth_static_network_context_params, lhs.http_auth_static_network_context_params))
    return false;
  if (std::less<>{}(lhs.reset_http_cache_backend, rhs.reset_http_cache_backend))
    return true;
  if (std::less<>{}(rhs.reset_http_cache_backend, lhs.reset_http_cache_backend))
    return false;
  if (std::less<>{}(lhs.split_auth_cache_by_network_isolation_key, rhs.split_auth_cache_by_network_isolation_key))
    return true;
  if (std::less<>{}(rhs.split_auth_cache_by_network_isolation_key, lhs.split_auth_cache_by_network_isolation_key))
    return false;
  if (std::less<>{}(lhs.require_network_isolation_key, rhs.require_network_isolation_key))
    return true;
  if (std::less<>{}(rhs.require_network_isolation_key, lhs.require_network_isolation_key))
    return false;
  return false;
}
template <typename StructPtrType>
NetworkConditionsPtr NetworkConditions::Clone() const {
  return New(
      mojo::Clone(offline),
      mojo::Clone(latency),
      mojo::Clone(download_throughput),
      mojo::Clone(upload_throughput)
  );
}

template <typename T, NetworkConditions::EnableIfSame<T>*>
bool NetworkConditions::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->offline, other_struct.offline))
    return false;
  if (!mojo::Equals(this->latency, other_struct.latency))
    return false;
  if (!mojo::Equals(this->download_throughput, other_struct.download_throughput))
    return false;
  if (!mojo::Equals(this->upload_throughput, other_struct.upload_throughput))
    return false;
  return true;
}

template <typename T, NetworkConditions::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.offline, rhs.offline))
    return true;
  if (std::less<>{}(rhs.offline, lhs.offline))
    return false;
  if (std::less<>{}(lhs.latency, rhs.latency))
    return true;
  if (std::less<>{}(rhs.latency, lhs.latency))
    return false;
  if (std::less<>{}(lhs.download_throughput, rhs.download_throughput))
    return true;
  if (std::less<>{}(rhs.download_throughput, lhs.download_throughput))
    return false;
  if (std::less<>{}(lhs.upload_throughput, rhs.upload_throughput))
    return true;
  if (std::less<>{}(rhs.upload_throughput, lhs.upload_throughput))
    return false;
  return false;
}
template <typename StructPtrType>
ClearDataFilterPtr ClearDataFilter::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(domains),
      mojo::Clone(origins)
  );
}

template <typename T, ClearDataFilter::EnableIfSame<T>*>
bool ClearDataFilter::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->domains, other_struct.domains))
    return false;
  if (!mojo::Equals(this->origins, other_struct.origins))
    return false;
  return true;
}

template <typename T, ClearDataFilter::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.domains, rhs.domains))
    return true;
  if (std::less<>{}(rhs.domains, lhs.domains))
    return false;
  if (std::less<>{}(lhs.origins, rhs.origins))
    return true;
  if (std::less<>{}(rhs.origins, lhs.origins))
    return false;
  return false;
}
template <typename StructPtrType>
NetworkUsagePtr NetworkUsage::Clone() const {
  return New(
      mojo::Clone(process_id),
      mojo::Clone(routing_id),
      mojo::Clone(total_bytes_received),
      mojo::Clone(total_bytes_sent)
  );
}

template <typename T, NetworkUsage::EnableIfSame<T>*>
bool NetworkUsage::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->process_id, other_struct.process_id))
    return false;
  if (!mojo::Equals(this->routing_id, other_struct.routing_id))
    return false;
  if (!mojo::Equals(this->total_bytes_received, other_struct.total_bytes_received))
    return false;
  if (!mojo::Equals(this->total_bytes_sent, other_struct.total_bytes_sent))
    return false;
  return true;
}

template <typename T, NetworkUsage::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.process_id, rhs.process_id))
    return true;
  if (std::less<>{}(rhs.process_id, lhs.process_id))
    return false;
  if (std::less<>{}(lhs.routing_id, rhs.routing_id))
    return true;
  if (std::less<>{}(rhs.routing_id, lhs.routing_id))
    return false;
  if (std::less<>{}(lhs.total_bytes_received, rhs.total_bytes_received))
    return true;
  if (std::less<>{}(rhs.total_bytes_received, lhs.total_bytes_received))
    return false;
  if (std::less<>{}(lhs.total_bytes_sent, rhs.total_bytes_sent))
    return true;
  if (std::less<>{}(rhs.total_bytes_sent, lhs.total_bytes_sent))
    return false;
  return false;
}
template <typename StructPtrType>
SignedExchangeReportPtr SignedExchangeReport::Clone() const {
  return New(
      mojo::Clone(success),
      mojo::Clone(type),
      mojo::Clone(outer_url),
      mojo::Clone(inner_url),
      mojo::Clone(cert_url),
      mojo::Clone(referrer),
      mojo::Clone(server_ip_address),
      mojo::Clone(protocol),
      mojo::Clone(method),
      mojo::Clone(status_code),
      mojo::Clone(elapsed_time)
  );
}

template <typename T, SignedExchangeReport::EnableIfSame<T>*>
bool SignedExchangeReport::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->success, other_struct.success))
    return false;
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->outer_url, other_struct.outer_url))
    return false;
  if (!mojo::Equals(this->inner_url, other_struct.inner_url))
    return false;
  if (!mojo::Equals(this->cert_url, other_struct.cert_url))
    return false;
  if (!mojo::Equals(this->referrer, other_struct.referrer))
    return false;
  if (!mojo::Equals(this->server_ip_address, other_struct.server_ip_address))
    return false;
  if (!mojo::Equals(this->protocol, other_struct.protocol))
    return false;
  if (!mojo::Equals(this->method, other_struct.method))
    return false;
  if (!mojo::Equals(this->status_code, other_struct.status_code))
    return false;
  if (!mojo::Equals(this->elapsed_time, other_struct.elapsed_time))
    return false;
  return true;
}

template <typename T, SignedExchangeReport::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.success, rhs.success))
    return true;
  if (std::less<>{}(rhs.success, lhs.success))
    return false;
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.outer_url, rhs.outer_url))
    return true;
  if (std::less<>{}(rhs.outer_url, lhs.outer_url))
    return false;
  if (std::less<>{}(lhs.inner_url, rhs.inner_url))
    return true;
  if (std::less<>{}(rhs.inner_url, lhs.inner_url))
    return false;
  if (std::less<>{}(lhs.cert_url, rhs.cert_url))
    return true;
  if (std::less<>{}(rhs.cert_url, lhs.cert_url))
    return false;
  if (std::less<>{}(lhs.referrer, rhs.referrer))
    return true;
  if (std::less<>{}(rhs.referrer, lhs.referrer))
    return false;
  if (std::less<>{}(lhs.server_ip_address, rhs.server_ip_address))
    return true;
  if (std::less<>{}(rhs.server_ip_address, lhs.server_ip_address))
    return false;
  if (std::less<>{}(lhs.protocol, rhs.protocol))
    return true;
  if (std::less<>{}(rhs.protocol, lhs.protocol))
    return false;
  if (std::less<>{}(lhs.method, rhs.method))
    return true;
  if (std::less<>{}(rhs.method, lhs.method))
    return false;
  if (std::less<>{}(lhs.status_code, rhs.status_code))
    return true;
  if (std::less<>{}(rhs.status_code, lhs.status_code))
    return false;
  if (std::less<>{}(lhs.elapsed_time, rhs.elapsed_time))
    return true;
  if (std::less<>{}(rhs.elapsed_time, lhs.elapsed_time))
    return false;
  return false;
}
template <typename StructPtrType>
URLLoaderFactoryOverridePtr URLLoaderFactoryOverride::Clone() const {
  return New(
      mojo::Clone(overriding_factory),
      mojo::Clone(overridden_factory_receiver),
      mojo::Clone(skip_cors_enabled_scheme_check)
  );
}

template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>*>
bool URLLoaderFactoryOverride::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->overriding_factory, other_struct.overriding_factory))
    return false;
  if (!mojo::Equals(this->overridden_factory_receiver, other_struct.overridden_factory_receiver))
    return false;
  if (!mojo::Equals(this->skip_cors_enabled_scheme_check, other_struct.skip_cors_enabled_scheme_check))
    return false;
  return true;
}

template <typename T, URLLoaderFactoryOverride::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.overriding_factory, rhs.overriding_factory))
    return true;
  if (std::less<>{}(rhs.overriding_factory, lhs.overriding_factory))
    return false;
  if (std::less<>{}(lhs.overridden_factory_receiver, rhs.overridden_factory_receiver))
    return true;
  if (std::less<>{}(rhs.overridden_factory_receiver, lhs.overridden_factory_receiver))
    return false;
  if (std::less<>{}(lhs.skip_cors_enabled_scheme_check, rhs.skip_cors_enabled_scheme_check))
    return true;
  if (std::less<>{}(rhs.skip_cors_enabled_scheme_check, lhs.skip_cors_enabled_scheme_check))
    return false;
  return false;
}
template <typename StructPtrType>
URLLoaderFactoryParamsPtr URLLoaderFactoryParams::Clone() const {
  return New(
      mojo::Clone(process_id),
      mojo::Clone(request_initiator_origin_lock),
      mojo::Clone(is_corb_enabled),
      mojo::Clone(ignore_isolated_world_origin),
      mojo::Clone(unsafe_non_webby_initiator),
      mojo::Clone(disable_web_security),
      mojo::Clone(header_client),
      mojo::Clone(factory_bound_access_patterns),
      mojo::Clone(isolation_info),
      mojo::Clone(disable_secure_dns),
      mojo::Clone(is_trusted),
      mojo::Clone(automatically_assign_isolation_info),
      mojo::Clone(top_frame_id),
      mojo::Clone(factory_override),
      mojo::Clone(client_security_state),
      mojo::Clone(coep_reporter),
      mojo::Clone(cookie_observer),
      mojo::Clone(trust_token_redemption_policy),
      mojo::Clone(debug_tag)
  );
}

template <typename T, URLLoaderFactoryParams::EnableIfSame<T>*>
bool URLLoaderFactoryParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->process_id, other_struct.process_id))
    return false;
  if (!mojo::Equals(this->request_initiator_origin_lock, other_struct.request_initiator_origin_lock))
    return false;
  if (!mojo::Equals(this->is_corb_enabled, other_struct.is_corb_enabled))
    return false;
  if (!mojo::Equals(this->ignore_isolated_world_origin, other_struct.ignore_isolated_world_origin))
    return false;
  if (!mojo::Equals(this->unsafe_non_webby_initiator, other_struct.unsafe_non_webby_initiator))
    return false;
  if (!mojo::Equals(this->disable_web_security, other_struct.disable_web_security))
    return false;
  if (!mojo::Equals(this->header_client, other_struct.header_client))
    return false;
  if (!mojo::Equals(this->factory_bound_access_patterns, other_struct.factory_bound_access_patterns))
    return false;
  if (!mojo::Equals(this->isolation_info, other_struct.isolation_info))
    return false;
  if (!mojo::Equals(this->disable_secure_dns, other_struct.disable_secure_dns))
    return false;
  if (!mojo::Equals(this->is_trusted, other_struct.is_trusted))
    return false;
  if (!mojo::Equals(this->automatically_assign_isolation_info, other_struct.automatically_assign_isolation_info))
    return false;
  if (!mojo::Equals(this->top_frame_id, other_struct.top_frame_id))
    return false;
  if (!mojo::Equals(this->factory_override, other_struct.factory_override))
    return false;
  if (!mojo::Equals(this->client_security_state, other_struct.client_security_state))
    return false;
  if (!mojo::Equals(this->coep_reporter, other_struct.coep_reporter))
    return false;
  if (!mojo::Equals(this->cookie_observer, other_struct.cookie_observer))
    return false;
  if (!mojo::Equals(this->trust_token_redemption_policy, other_struct.trust_token_redemption_policy))
    return false;
  if (!mojo::Equals(this->debug_tag, other_struct.debug_tag))
    return false;
  return true;
}

template <typename T, URLLoaderFactoryParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.process_id, rhs.process_id))
    return true;
  if (std::less<>{}(rhs.process_id, lhs.process_id))
    return false;
  if (std::less<>{}(lhs.request_initiator_origin_lock, rhs.request_initiator_origin_lock))
    return true;
  if (std::less<>{}(rhs.request_initiator_origin_lock, lhs.request_initiator_origin_lock))
    return false;
  if (std::less<>{}(lhs.is_corb_enabled, rhs.is_corb_enabled))
    return true;
  if (std::less<>{}(rhs.is_corb_enabled, lhs.is_corb_enabled))
    return false;
  if (std::less<>{}(lhs.ignore_isolated_world_origin, rhs.ignore_isolated_world_origin))
    return true;
  if (std::less<>{}(rhs.ignore_isolated_world_origin, lhs.ignore_isolated_world_origin))
    return false;
  if (std::less<>{}(lhs.unsafe_non_webby_initiator, rhs.unsafe_non_webby_initiator))
    return true;
  if (std::less<>{}(rhs.unsafe_non_webby_initiator, lhs.unsafe_non_webby_initiator))
    return false;
  if (std::less<>{}(lhs.disable_web_security, rhs.disable_web_security))
    return true;
  if (std::less<>{}(rhs.disable_web_security, lhs.disable_web_security))
    return false;
  if (std::less<>{}(lhs.header_client, rhs.header_client))
    return true;
  if (std::less<>{}(rhs.header_client, lhs.header_client))
    return false;
  if (std::less<>{}(lhs.factory_bound_access_patterns, rhs.factory_bound_access_patterns))
    return true;
  if (std::less<>{}(rhs.factory_bound_access_patterns, lhs.factory_bound_access_patterns))
    return false;
  if (std::less<>{}(lhs.isolation_info, rhs.isolation_info))
    return true;
  if (std::less<>{}(rhs.isolation_info, lhs.isolation_info))
    return false;
  if (std::less<>{}(lhs.disable_secure_dns, rhs.disable_secure_dns))
    return true;
  if (std::less<>{}(rhs.disable_secure_dns, lhs.disable_secure_dns))
    return false;
  if (std::less<>{}(lhs.is_trusted, rhs.is_trusted))
    return true;
  if (std::less<>{}(rhs.is_trusted, lhs.is_trusted))
    return false;
  if (std::less<>{}(lhs.automatically_assign_isolation_info, rhs.automatically_assign_isolation_info))
    return true;
  if (std::less<>{}(rhs.automatically_assign_isolation_info, lhs.automatically_assign_isolation_info))
    return false;
  if (std::less<>{}(lhs.top_frame_id, rhs.top_frame_id))
    return true;
  if (std::less<>{}(rhs.top_frame_id, lhs.top_frame_id))
    return false;
  if (std::less<>{}(lhs.factory_override, rhs.factory_override))
    return true;
  if (std::less<>{}(rhs.factory_override, lhs.factory_override))
    return false;
  if (std::less<>{}(lhs.client_security_state, rhs.client_security_state))
    return true;
  if (std::less<>{}(rhs.client_security_state, lhs.client_security_state))
    return false;
  if (std::less<>{}(lhs.coep_reporter, rhs.coep_reporter))
    return true;
  if (std::less<>{}(rhs.coep_reporter, lhs.coep_reporter))
    return false;
  if (std::less<>{}(lhs.cookie_observer, rhs.cookie_observer))
    return true;
  if (std::less<>{}(rhs.cookie_observer, lhs.cookie_observer))
    return false;
  if (std::less<>{}(lhs.trust_token_redemption_policy, rhs.trust_token_redemption_policy))
    return true;
  if (std::less<>{}(rhs.trust_token_redemption_policy, lhs.trust_token_redemption_policy))
    return false;
  if (std::less<>{}(lhs.debug_tag, rhs.debug_tag))
    return true;
  if (std::less<>{}(rhs.debug_tag, lhs.debug_tag))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct  StructTraits<::network::mojom::CustomProxyConfig::DataView,
                                         ::network::mojom::CustomProxyConfigPtr> {
  static bool IsNull(const ::network::mojom::CustomProxyConfigPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CustomProxyConfigPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CustomProxyConfig::rules)& rules(
      const ::network::mojom::CustomProxyConfigPtr& input) {
    return input->rules;
  }

  static decltype(::network::mojom::CustomProxyConfig::should_override_existing_config) should_override_existing_config(
      const ::network::mojom::CustomProxyConfigPtr& input) {
    return input->should_override_existing_config;
  }

  static decltype(::network::mojom::CustomProxyConfig::allow_non_idempotent_methods) allow_non_idempotent_methods(
      const ::network::mojom::CustomProxyConfigPtr& input) {
    return input->allow_non_idempotent_methods;
  }

  static const decltype(::network::mojom::CustomProxyConfig::connect_tunnel_headers)& connect_tunnel_headers(
      const ::network::mojom::CustomProxyConfigPtr& input) {
    return input->connect_tunnel_headers;
  }

  static bool Read(::network::mojom::CustomProxyConfig::DataView input, ::network::mojom::CustomProxyConfigPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CertVerifierCreationParams::DataView,
                                         ::network::mojom::CertVerifierCreationParamsPtr> {
  static bool IsNull(const ::network::mojom::CertVerifierCreationParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CertVerifierCreationParamsPtr* output) { output->reset(); }

  static bool Read(::network::mojom::CertVerifierCreationParams::DataView input, ::network::mojom::CertVerifierCreationParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CertVerifierServiceRemoteParams::DataView,
                                         ::network::mojom::CertVerifierServiceRemoteParamsPtr> {
  static bool IsNull(const ::network::mojom::CertVerifierServiceRemoteParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CertVerifierServiceRemoteParamsPtr* output) { output->reset(); }

  static  decltype(::network::mojom::CertVerifierServiceRemoteParams::cert_verifier_service)& cert_verifier_service(
       ::network::mojom::CertVerifierServiceRemoteParamsPtr& input) {
    return input->cert_verifier_service;
  }

  static bool Read(::network::mojom::CertVerifierServiceRemoteParams::DataView input, ::network::mojom::CertVerifierServiceRemoteParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::HttpAuthStaticNetworkContextParams::DataView,
                                         ::network::mojom::HttpAuthStaticNetworkContextParamsPtr> {
  static bool IsNull(const ::network::mojom::HttpAuthStaticNetworkContextParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::HttpAuthStaticNetworkContextParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::HttpAuthStaticNetworkContextParams::allow_default_credentials) allow_default_credentials(
      const ::network::mojom::HttpAuthStaticNetworkContextParamsPtr& input) {
    return input->allow_default_credentials;
  }

  static bool Read(::network::mojom::HttpAuthStaticNetworkContextParams::DataView input, ::network::mojom::HttpAuthStaticNetworkContextParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::CTPolicy::DataView,
                                         ::network::mojom::CTPolicyPtr> {
  static bool IsNull(const ::network::mojom::CTPolicyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CTPolicyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::CTPolicy::required_hosts)& required_hosts(
      const ::network::mojom::CTPolicyPtr& input) {
    return input->required_hosts;
  }

  static const decltype(::network::mojom::CTPolicy::excluded_hosts)& excluded_hosts(
      const ::network::mojom::CTPolicyPtr& input) {
    return input->excluded_hosts;
  }

  static const decltype(::network::mojom::CTPolicy::excluded_spkis)& excluded_spkis(
      const ::network::mojom::CTPolicyPtr& input) {
    return input->excluded_spkis;
  }

  static const decltype(::network::mojom::CTPolicy::excluded_legacy_spkis)& excluded_legacy_spkis(
      const ::network::mojom::CTPolicyPtr& input) {
    return input->excluded_legacy_spkis;
  }

  static bool Read(::network::mojom::CTPolicy::DataView input, ::network::mojom::CTPolicyPtr* output);
};


template <>
struct  StructTraits<::network::mojom::NetworkContextParams::DataView,
                                         ::network::mojom::NetworkContextParamsPtr> {
  static bool IsNull(const ::network::mojom::NetworkContextParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::NetworkContextParamsPtr* output) { output->reset(); }

  static const decltype(::network::mojom::NetworkContextParams::context_name)& context_name(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->context_name;
  }

  static const decltype(::network::mojom::NetworkContextParams::user_agent)& user_agent(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->user_agent;
  }

  static const decltype(::network::mojom::NetworkContextParams::accept_language)& accept_language(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->accept_language;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_brotli) enable_brotli(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_brotli;
  }

  static const decltype(::network::mojom::NetworkContextParams::quic_user_agent_id)& quic_user_agent_id(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->quic_user_agent_id;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_referrers) enable_referrers(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_referrers;
  }

  static decltype(::network::mojom::NetworkContextParams::validate_referrer_policy_on_initial_request) validate_referrer_policy_on_initial_request(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->validate_referrer_policy_on_initial_request;
  }

  static  decltype(::network::mojom::NetworkContextParams::proxy_resolver_factory)& proxy_resolver_factory(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->proxy_resolver_factory;
  }

  static const decltype(::network::mojom::NetworkContextParams::cookie_path)& cookie_path(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cookie_path;
  }

  static const decltype(::network::mojom::NetworkContextParams::trust_token_path)& trust_token_path(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->trust_token_path;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_encrypted_cookies) enable_encrypted_cookies(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_encrypted_cookies;
  }

  static decltype(::network::mojom::NetworkContextParams::restore_old_session_cookies) restore_old_session_cookies(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->restore_old_session_cookies;
  }

  static decltype(::network::mojom::NetworkContextParams::persist_session_cookies) persist_session_cookies(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->persist_session_cookies;
  }

  static decltype(::network::mojom::NetworkContextParams::http_cache_enabled) http_cache_enabled(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->http_cache_enabled;
  }

  static decltype(::network::mojom::NetworkContextParams::http_cache_max_size) http_cache_max_size(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->http_cache_max_size;
  }

  static const decltype(::network::mojom::NetworkContextParams::http_cache_path)& http_cache_path(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->http_cache_path;
  }

  static const decltype(::network::mojom::NetworkContextParams::http_server_properties_path)& http_server_properties_path(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->http_server_properties_path;
  }

  static const decltype(::network::mojom::NetworkContextParams::transport_security_persister_path)& transport_security_persister_path(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->transport_security_persister_path;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_ftp_url_support) enable_ftp_url_support(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_ftp_url_support;
  }

  static decltype(::network::mojom::NetworkContextParams::disable_idle_sockets_close_on_memory_pressure) disable_idle_sockets_close_on_memory_pressure(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->disable_idle_sockets_close_on_memory_pressure;
  }

  static const decltype(::network::mojom::NetworkContextParams::initial_ssl_config)& initial_ssl_config(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->initial_ssl_config;
  }

  static  decltype(::network::mojom::NetworkContextParams::ssl_config_client_receiver)& ssl_config_client_receiver(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->ssl_config_client_receiver;
  }

  static  decltype(::network::mojom::NetworkContextParams::initial_proxy_config)& initial_proxy_config(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->initial_proxy_config;
  }

  static  decltype(::network::mojom::NetworkContextParams::proxy_config_client_receiver)& proxy_config_client_receiver(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->proxy_config_client_receiver;
  }

  static const decltype(::network::mojom::NetworkContextParams::initial_custom_proxy_config)& initial_custom_proxy_config(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->initial_custom_proxy_config;
  }

  static  decltype(::network::mojom::NetworkContextParams::custom_proxy_config_client_receiver)& custom_proxy_config_client_receiver(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->custom_proxy_config_client_receiver;
  }

  static  decltype(::network::mojom::NetworkContextParams::proxy_config_poller_client)& proxy_config_poller_client(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->proxy_config_poller_client;
  }

  static  decltype(::network::mojom::NetworkContextParams::proxy_error_client)& proxy_error_client(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->proxy_error_client;
  }

  static decltype(::network::mojom::NetworkContextParams::pac_quick_check_enabled) pac_quick_check_enabled(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->pac_quick_check_enabled;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_certificate_reporting) enable_certificate_reporting(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_certificate_reporting;
  }

  static decltype(::network::mojom::NetworkContextParams::enforce_chrome_ct_policy) enforce_chrome_ct_policy(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enforce_chrome_ct_policy;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_expect_ct_reporting) enable_expect_ct_reporting(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_expect_ct_reporting;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_sct_auditing) enable_sct_auditing(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_sct_auditing;
  }

  static const decltype(::network::mojom::NetworkContextParams::ct_logs)& ct_logs(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->ct_logs;
  }

  static const decltype(::network::mojom::NetworkContextParams::ct_policy)& ct_policy(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->ct_policy;
  }

  static const decltype(::network::mojom::NetworkContextParams::ct_log_update_time)& ct_log_update_time(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->ct_log_update_time;
  }

  static  decltype(::network::mojom::NetworkContextParams::cert_verifier_params)& cert_verifier_params(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cert_verifier_params;
  }

  static const decltype(::network::mojom::NetworkContextParams::cookie_manager_params)& cookie_manager_params(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cookie_manager_params;
  }

  static  decltype(::network::mojom::NetworkContextParams::cookie_manager)& cookie_manager(
       ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cookie_manager;
  }

  static decltype(::network::mojom::NetworkContextParams::enable_domain_reliability) enable_domain_reliability(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->enable_domain_reliability;
  }

  static const decltype(::network::mojom::NetworkContextParams::domain_reliability_upload_reporter)& domain_reliability_upload_reporter(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->domain_reliability_upload_reporter;
  }

  static decltype(::network::mojom::NetworkContextParams::discard_domain_reliablity_uploads) discard_domain_reliablity_uploads(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->discard_domain_reliablity_uploads;
  }

  static const decltype(::network::mojom::NetworkContextParams::reporting_delivery_interval)& reporting_delivery_interval(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->reporting_delivery_interval;
  }

  static decltype(::network::mojom::NetworkContextParams::skip_reporting_send_permission_check) skip_reporting_send_permission_check(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->skip_reporting_send_permission_check;
  }

  static const decltype(::network::mojom::NetworkContextParams::cors_origin_access_list)& cors_origin_access_list(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cors_origin_access_list;
  }

  static const decltype(::network::mojom::NetworkContextParams::cors_exempt_header_list)& cors_exempt_header_list(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->cors_exempt_header_list;
  }

  static decltype(::network::mojom::NetworkContextParams::allow_any_cors_exempt_header_for_browser) allow_any_cors_exempt_header_for_browser(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->allow_any_cors_exempt_header_for_browser;
  }

  static const decltype(::network::mojom::NetworkContextParams::hsts_policy_bypass_list)& hsts_policy_bypass_list(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->hsts_policy_bypass_list;
  }

  static const decltype(::network::mojom::NetworkContextParams::reporting_and_nel_store_path)& reporting_and_nel_store_path(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->reporting_and_nel_store_path;
  }

  static const decltype(::network::mojom::NetworkContextParams::http_auth_static_network_context_params)& http_auth_static_network_context_params(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->http_auth_static_network_context_params;
  }

  static decltype(::network::mojom::NetworkContextParams::reset_http_cache_backend) reset_http_cache_backend(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->reset_http_cache_backend;
  }

  static decltype(::network::mojom::NetworkContextParams::split_auth_cache_by_network_isolation_key) split_auth_cache_by_network_isolation_key(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->split_auth_cache_by_network_isolation_key;
  }

  static decltype(::network::mojom::NetworkContextParams::require_network_isolation_key) require_network_isolation_key(
      const ::network::mojom::NetworkContextParamsPtr& input) {
    return input->require_network_isolation_key;
  }

  static bool Read(::network::mojom::NetworkContextParams::DataView input, ::network::mojom::NetworkContextParamsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::NetworkConditions::DataView,
                                         ::network::mojom::NetworkConditionsPtr> {
  static bool IsNull(const ::network::mojom::NetworkConditionsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::NetworkConditionsPtr* output) { output->reset(); }

  static decltype(::network::mojom::NetworkConditions::offline) offline(
      const ::network::mojom::NetworkConditionsPtr& input) {
    return input->offline;
  }

  static const decltype(::network::mojom::NetworkConditions::latency)& latency(
      const ::network::mojom::NetworkConditionsPtr& input) {
    return input->latency;
  }

  static decltype(::network::mojom::NetworkConditions::download_throughput) download_throughput(
      const ::network::mojom::NetworkConditionsPtr& input) {
    return input->download_throughput;
  }

  static decltype(::network::mojom::NetworkConditions::upload_throughput) upload_throughput(
      const ::network::mojom::NetworkConditionsPtr& input) {
    return input->upload_throughput;
  }

  static bool Read(::network::mojom::NetworkConditions::DataView input, ::network::mojom::NetworkConditionsPtr* output);
};


template <>
struct  StructTraits<::network::mojom::ClearDataFilter::DataView,
                                         ::network::mojom::ClearDataFilterPtr> {
  static bool IsNull(const ::network::mojom::ClearDataFilterPtr& input) { return !input; }
  static void SetToNull(::network::mojom::ClearDataFilterPtr* output) { output->reset(); }

  static decltype(::network::mojom::ClearDataFilter::type) type(
      const ::network::mojom::ClearDataFilterPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::ClearDataFilter::domains)& domains(
      const ::network::mojom::ClearDataFilterPtr& input) {
    return input->domains;
  }

  static const decltype(::network::mojom::ClearDataFilter::origins)& origins(
      const ::network::mojom::ClearDataFilterPtr& input) {
    return input->origins;
  }

  static bool Read(::network::mojom::ClearDataFilter::DataView input, ::network::mojom::ClearDataFilterPtr* output);
};


template <>
struct  StructTraits<::network::mojom::NetworkUsage::DataView,
                                         ::network::mojom::NetworkUsagePtr> {
  static bool IsNull(const ::network::mojom::NetworkUsagePtr& input) { return !input; }
  static void SetToNull(::network::mojom::NetworkUsagePtr* output) { output->reset(); }

  static decltype(::network::mojom::NetworkUsage::process_id) process_id(
      const ::network::mojom::NetworkUsagePtr& input) {
    return input->process_id;
  }

  static decltype(::network::mojom::NetworkUsage::routing_id) routing_id(
      const ::network::mojom::NetworkUsagePtr& input) {
    return input->routing_id;
  }

  static decltype(::network::mojom::NetworkUsage::total_bytes_received) total_bytes_received(
      const ::network::mojom::NetworkUsagePtr& input) {
    return input->total_bytes_received;
  }

  static decltype(::network::mojom::NetworkUsage::total_bytes_sent) total_bytes_sent(
      const ::network::mojom::NetworkUsagePtr& input) {
    return input->total_bytes_sent;
  }

  static bool Read(::network::mojom::NetworkUsage::DataView input, ::network::mojom::NetworkUsagePtr* output);
};


template <>
struct  StructTraits<::network::mojom::SignedExchangeReport::DataView,
                                         ::network::mojom::SignedExchangeReportPtr> {
  static bool IsNull(const ::network::mojom::SignedExchangeReportPtr& input) { return !input; }
  static void SetToNull(::network::mojom::SignedExchangeReportPtr* output) { output->reset(); }

  static decltype(::network::mojom::SignedExchangeReport::success) success(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->success;
  }

  static const decltype(::network::mojom::SignedExchangeReport::type)& type(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->type;
  }

  static const decltype(::network::mojom::SignedExchangeReport::outer_url)& outer_url(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->outer_url;
  }

  static const decltype(::network::mojom::SignedExchangeReport::inner_url)& inner_url(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->inner_url;
  }

  static const decltype(::network::mojom::SignedExchangeReport::cert_url)& cert_url(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->cert_url;
  }

  static const decltype(::network::mojom::SignedExchangeReport::referrer)& referrer(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->referrer;
  }

  static const decltype(::network::mojom::SignedExchangeReport::server_ip_address)& server_ip_address(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->server_ip_address;
  }

  static const decltype(::network::mojom::SignedExchangeReport::protocol)& protocol(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->protocol;
  }

  static const decltype(::network::mojom::SignedExchangeReport::method)& method(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->method;
  }

  static decltype(::network::mojom::SignedExchangeReport::status_code) status_code(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->status_code;
  }

  static const decltype(::network::mojom::SignedExchangeReport::elapsed_time)& elapsed_time(
      const ::network::mojom::SignedExchangeReportPtr& input) {
    return input->elapsed_time;
  }

  static bool Read(::network::mojom::SignedExchangeReport::DataView input, ::network::mojom::SignedExchangeReportPtr* output);
};


template <>
struct  StructTraits<::network::mojom::URLLoaderFactoryOverride::DataView,
                                         ::network::mojom::URLLoaderFactoryOverridePtr> {
  static bool IsNull(const ::network::mojom::URLLoaderFactoryOverridePtr& input) { return !input; }
  static void SetToNull(::network::mojom::URLLoaderFactoryOverridePtr* output) { output->reset(); }

  static  decltype(::network::mojom::URLLoaderFactoryOverride::overriding_factory)& overriding_factory(
       ::network::mojom::URLLoaderFactoryOverridePtr& input) {
    return input->overriding_factory;
  }

  static  decltype(::network::mojom::URLLoaderFactoryOverride::overridden_factory_receiver)& overridden_factory_receiver(
       ::network::mojom::URLLoaderFactoryOverridePtr& input) {
    return input->overridden_factory_receiver;
  }

  static decltype(::network::mojom::URLLoaderFactoryOverride::skip_cors_enabled_scheme_check) skip_cors_enabled_scheme_check(
      const ::network::mojom::URLLoaderFactoryOverridePtr& input) {
    return input->skip_cors_enabled_scheme_check;
  }

  static bool Read(::network::mojom::URLLoaderFactoryOverride::DataView input, ::network::mojom::URLLoaderFactoryOverridePtr* output);
};


template <>
struct  StructTraits<::network::mojom::URLLoaderFactoryParams::DataView,
                                         ::network::mojom::URLLoaderFactoryParamsPtr> {
  static bool IsNull(const ::network::mojom::URLLoaderFactoryParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::URLLoaderFactoryParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::URLLoaderFactoryParams::process_id) process_id(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->process_id;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::request_initiator_origin_lock)& request_initiator_origin_lock(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->request_initiator_origin_lock;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::is_corb_enabled) is_corb_enabled(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->is_corb_enabled;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::ignore_isolated_world_origin) ignore_isolated_world_origin(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->ignore_isolated_world_origin;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::unsafe_non_webby_initiator) unsafe_non_webby_initiator(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->unsafe_non_webby_initiator;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::disable_web_security) disable_web_security(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->disable_web_security;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::header_client)& header_client(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->header_client;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::factory_bound_access_patterns)& factory_bound_access_patterns(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->factory_bound_access_patterns;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::isolation_info)& isolation_info(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->isolation_info;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::disable_secure_dns) disable_secure_dns(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->disable_secure_dns;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::is_trusted) is_trusted(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->is_trusted;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::automatically_assign_isolation_info) automatically_assign_isolation_info(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->automatically_assign_isolation_info;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::top_frame_id)& top_frame_id(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->top_frame_id;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::factory_override)& factory_override(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->factory_override;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::client_security_state)& client_security_state(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->client_security_state;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::coep_reporter)& coep_reporter(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->coep_reporter;
  }

  static  decltype(::network::mojom::URLLoaderFactoryParams::cookie_observer)& cookie_observer(
       ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->cookie_observer;
  }

  static decltype(::network::mojom::URLLoaderFactoryParams::trust_token_redemption_policy) trust_token_redemption_policy(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->trust_token_redemption_policy;
  }

  static const decltype(::network::mojom::URLLoaderFactoryParams::debug_tag)& debug_tag(
      const ::network::mojom::URLLoaderFactoryParamsPtr& input) {
    return input->debug_tag;
  }

  static bool Read(::network::mojom::URLLoaderFactoryParams::DataView input, ::network::mojom::URLLoaderFactoryParamsPtr* output);
};


template <>
struct  UnionTraits<::network::mojom::CertVerifierParams::DataView,
                                        ::network::mojom::CertVerifierParamsPtr> {
  static bool IsNull(const ::network::mojom::CertVerifierParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::CertVerifierParamsPtr* output) { output->reset(); }

  static ::network::mojom::CertVerifierParams::Tag GetTag(const ::network::mojom::CertVerifierParamsPtr& input) {
    return input->which();
  }

  static  ::network::mojom::CertVerifierServiceRemoteParamsPtr& remote_params( ::network::mojom::CertVerifierParamsPtr& input) {
    return input->get_remote_params();
  }

  static const ::network::mojom::CertVerifierCreationParamsPtr& creation_params(const ::network::mojom::CertVerifierParamsPtr& input) {
    return input->get_creation_params();
  }

  static bool Read(::network::mojom::CertVerifierParams::DataView input, ::network::mojom::CertVerifierParamsPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_NETWORK_CONTEXT_MOJOM_H_