// services/network/public/mojom/trust_tokens.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared.h"
#include "services/network/public/mojom/trust_tokens.mojom-blink-forward.h"
#include "url/mojom/origin.mojom-blink.h"
#include "mojo/public/mojom/base/time.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "third_party/blink/public/platform/web_common.h"




namespace WTF {
struct network_mojom_internal_TrustTokenOperationStatus_DataHashFn {
  static unsigned GetHash(const ::network::mojom::TrustTokenOperationStatus& value) {
    using utype = std::underlying_type<::network::mojom::TrustTokenOperationStatus>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::network::mojom::TrustTokenOperationStatus& left, const ::network::mojom::TrustTokenOperationStatus& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::network::mojom::TrustTokenOperationStatus>
    : public GenericHashTraits<::network::mojom::TrustTokenOperationStatus> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::network::mojom::TrustTokenOperationStatus& value) {
    return value == static_cast<::network::mojom::TrustTokenOperationStatus>(-1000000);
  }
  static void ConstructDeletedValue(::network::mojom::TrustTokenOperationStatus& slot, bool) {
    slot = static_cast<::network::mojom::TrustTokenOperationStatus>(-1000001);
  }
  static bool IsDeletedValue(const ::network::mojom::TrustTokenOperationStatus& value) {
    return value == static_cast<::network::mojom::TrustTokenOperationStatus>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct network_mojom_internal_TrustTokenOperationType_DataHashFn {
  static unsigned GetHash(const ::network::mojom::TrustTokenOperationType& value) {
    using utype = std::underlying_type<::network::mojom::TrustTokenOperationType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::network::mojom::TrustTokenOperationType& left, const ::network::mojom::TrustTokenOperationType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::network::mojom::TrustTokenOperationType>
    : public GenericHashTraits<::network::mojom::TrustTokenOperationType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::network::mojom::TrustTokenOperationType& value) {
    return value == static_cast<::network::mojom::TrustTokenOperationType>(-1000000);
  }
  static void ConstructDeletedValue(::network::mojom::TrustTokenOperationType& slot, bool) {
    slot = static_cast<::network::mojom::TrustTokenOperationType>(-1000001);
  }
  static bool IsDeletedValue(const ::network::mojom::TrustTokenOperationType& value) {
    return value == static_cast<::network::mojom::TrustTokenOperationType>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct network_mojom_internal_TrustTokenRefreshPolicy_DataHashFn {
  static unsigned GetHash(const ::network::mojom::TrustTokenRefreshPolicy& value) {
    using utype = std::underlying_type<::network::mojom::TrustTokenRefreshPolicy>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::network::mojom::TrustTokenRefreshPolicy& left, const ::network::mojom::TrustTokenRefreshPolicy& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::network::mojom::TrustTokenRefreshPolicy>
    : public GenericHashTraits<::network::mojom::TrustTokenRefreshPolicy> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::network::mojom::TrustTokenRefreshPolicy& value) {
    return value == static_cast<::network::mojom::TrustTokenRefreshPolicy>(-1000000);
  }
  static void ConstructDeletedValue(::network::mojom::TrustTokenRefreshPolicy& slot, bool) {
    slot = static_cast<::network::mojom::TrustTokenRefreshPolicy>(-1000001);
  }
  static bool IsDeletedValue(const ::network::mojom::TrustTokenRefreshPolicy& value) {
    return value == static_cast<::network::mojom::TrustTokenRefreshPolicy>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct network_mojom_internal_TrustTokenSignRequestData_DataHashFn {
  static unsigned GetHash(const ::network::mojom::TrustTokenSignRequestData& value) {
    using utype = std::underlying_type<::network::mojom::TrustTokenSignRequestData>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::network::mojom::TrustTokenSignRequestData& left, const ::network::mojom::TrustTokenSignRequestData& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::network::mojom::TrustTokenSignRequestData>
    : public GenericHashTraits<::network::mojom::TrustTokenSignRequestData> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::network::mojom::TrustTokenSignRequestData& value) {
    return value == static_cast<::network::mojom::TrustTokenSignRequestData>(-1000000);
  }
  static void ConstructDeletedValue(::network::mojom::TrustTokenSignRequestData& slot, bool) {
    slot = static_cast<::network::mojom::TrustTokenSignRequestData>(-1000001);
  }
  static bool IsDeletedValue(const ::network::mojom::TrustTokenSignRequestData& value) {
    return value == static_cast<::network::mojom::TrustTokenSignRequestData>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {
namespace blink {

class HasTrustTokensAnswererProxy;

template <typename ImplRefTraits>
class HasTrustTokensAnswererStub;

class HasTrustTokensAnswererRequestValidator;
class HasTrustTokensAnswererResponseValidator;


class BLINK_PLATFORM_EXPORT HasTrustTokensAnswerer
    : public HasTrustTokensAnswererInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = HasTrustTokensAnswererInterfaceBase;
  using Proxy_ = HasTrustTokensAnswererProxy;

  template <typename ImplRefTraits>
  using Stub_ = HasTrustTokensAnswererStub<ImplRefTraits>;

  using RequestValidator_ = HasTrustTokensAnswererRequestValidator;
  using ResponseValidator_ = HasTrustTokensAnswererResponseValidator;
  enum MethodMinVersions : uint32_t {
    kHasTrustTokensMinVersion = 0,
  };
  virtual ~HasTrustTokensAnswerer() {}


  using HasTrustTokensCallback = base::OnceCallback<void(HasTrustTokensResultPtr)>;
  
  virtual void HasTrustTokens(const ::scoped_refptr<const ::blink::SecurityOrigin>& issuer, HasTrustTokensCallback callback) = 0;
};



class BLINK_PLATFORM_EXPORT HasTrustTokensAnswererProxy
    : public HasTrustTokensAnswerer {
 public:
  using InterfaceType = HasTrustTokensAnswerer;

  explicit HasTrustTokensAnswererProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void HasTrustTokens(const ::scoped_refptr<const ::blink::SecurityOrigin>& issuer, HasTrustTokensCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT HasTrustTokensAnswererStubDispatch {
 public:
  static bool Accept(HasTrustTokensAnswerer* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      HasTrustTokensAnswerer* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<HasTrustTokensAnswerer>>
class HasTrustTokensAnswererStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  HasTrustTokensAnswererStub() {}
  ~HasTrustTokensAnswererStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HasTrustTokensAnswererStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return HasTrustTokensAnswererStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT HasTrustTokensAnswererRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class BLINK_PLATFORM_EXPORT HasTrustTokensAnswererResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class BLINK_PLATFORM_EXPORT HasTrustTokensResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HasTrustTokensResult, T>::value>;
  using DataView = HasTrustTokensResultDataView;
  using Data_ = internal::HasTrustTokensResult_Data;

  template <typename... Args>
  static HasTrustTokensResultPtr New(Args&&... args) {
    return HasTrustTokensResultPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HasTrustTokensResultPtr From(const U& u) {
    return mojo::TypeConverter<HasTrustTokensResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HasTrustTokensResult>::Convert(*this);
  }


  HasTrustTokensResult();

  HasTrustTokensResult(
      TrustTokenOperationStatus status,
      bool has_trust_tokens);

  ~HasTrustTokensResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HasTrustTokensResultPtr>
  HasTrustTokensResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HasTrustTokensResult::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HasTrustTokensResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HasTrustTokensResult_UnserializedMessageContext<
            UserType, HasTrustTokensResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HasTrustTokensResult::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return HasTrustTokensResult::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HasTrustTokensResult_UnserializedMessageContext<
            UserType, HasTrustTokensResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HasTrustTokensResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  TrustTokenOperationStatus status;
  
  bool has_trust_tokens;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HasTrustTokensResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}









class BLINK_PLATFORM_EXPORT TrustTokenParams {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustTokenParams, T>::value>;
  using DataView = TrustTokenParamsDataView;
  using Data_ = internal::TrustTokenParams_Data;

  template <typename... Args>
  static TrustTokenParamsPtr New(Args&&... args) {
    return TrustTokenParamsPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustTokenParamsPtr From(const U& u) {
    return mojo::TypeConverter<TrustTokenParamsPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustTokenParams>::Convert(*this);
  }


  TrustTokenParams();

  TrustTokenParams(
      TrustTokenOperationType type,
      TrustTokenRefreshPolicy refresh_policy,
      TrustTokenSignRequestData sign_request_data,
      bool include_timestamp_header,
      WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> issuers,
      WTF::Vector<WTF::String> additional_signed_headers,
      const WTF::String& possibly_unsafe_additional_signing_data);

  ~TrustTokenParams();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustTokenParamsPtr>
  TrustTokenParamsPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenParams::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustTokenParams::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustTokenParams_UnserializedMessageContext<
            UserType, TrustTokenParams::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TrustTokenParams::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TrustTokenParams::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustTokenParams_UnserializedMessageContext<
            UserType, TrustTokenParams::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustTokenParams::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  TrustTokenOperationType type;
  
  TrustTokenRefreshPolicy refresh_policy;
  
  TrustTokenSignRequestData sign_request_data;
  
  bool include_timestamp_header;
  
  WTF::Vector<::scoped_refptr<const ::blink::SecurityOrigin>> issuers;
  
  WTF::Vector<WTF::String> additional_signed_headers;
  
  WTF::String possibly_unsafe_additional_signing_data;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustTokenParams::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}






class BLINK_PLATFORM_EXPORT TrustTokenVerificationKey {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustTokenVerificationKey, T>::value>;
  using DataView = TrustTokenVerificationKeyDataView;
  using Data_ = internal::TrustTokenVerificationKey_Data;

  template <typename... Args>
  static TrustTokenVerificationKeyPtr New(Args&&... args) {
    return TrustTokenVerificationKeyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustTokenVerificationKeyPtr From(const U& u) {
    return mojo::TypeConverter<TrustTokenVerificationKeyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustTokenVerificationKey>::Convert(*this);
  }


  TrustTokenVerificationKey();

  TrustTokenVerificationKey(
      const WTF::String& body,
      ::base::Time expiry);

  ~TrustTokenVerificationKey();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustTokenVerificationKeyPtr>
  TrustTokenVerificationKeyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenVerificationKey::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustTokenVerificationKey::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustTokenVerificationKey_UnserializedMessageContext<
            UserType, TrustTokenVerificationKey::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TrustTokenVerificationKey::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TrustTokenVerificationKey::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustTokenVerificationKey_UnserializedMessageContext<
            UserType, TrustTokenVerificationKey::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustTokenVerificationKey::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  WTF::String body;
  
  ::base::Time expiry;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustTokenVerificationKey::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class BLINK_PLATFORM_EXPORT TrustTokenKeyCommitmentResult {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<TrustTokenKeyCommitmentResult, T>::value>;
  using DataView = TrustTokenKeyCommitmentResultDataView;
  using Data_ = internal::TrustTokenKeyCommitmentResult_Data;

  template <typename... Args>
  static TrustTokenKeyCommitmentResultPtr New(Args&&... args) {
    return TrustTokenKeyCommitmentResultPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static TrustTokenKeyCommitmentResultPtr From(const U& u) {
    return mojo::TypeConverter<TrustTokenKeyCommitmentResultPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, TrustTokenKeyCommitmentResult>::Convert(*this);
  }


  TrustTokenKeyCommitmentResult();

  TrustTokenKeyCommitmentResult(
      int32_t batch_size,
      WTF::Vector<TrustTokenVerificationKeyPtr> keys,
      const WTF::String& signed_redemption_record_verification_key);

  ~TrustTokenKeyCommitmentResult();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = TrustTokenKeyCommitmentResultPtr>
  TrustTokenKeyCommitmentResultPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        TrustTokenKeyCommitmentResult::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        TrustTokenKeyCommitmentResult::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::TrustTokenKeyCommitmentResult_UnserializedMessageContext<
            UserType, TrustTokenKeyCommitmentResult::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<TrustTokenKeyCommitmentResult::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return TrustTokenKeyCommitmentResult::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::TrustTokenKeyCommitmentResult_UnserializedMessageContext<
            UserType, TrustTokenKeyCommitmentResult::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<TrustTokenKeyCommitmentResult::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t batch_size;
  
  WTF::Vector<TrustTokenVerificationKeyPtr> keys;
  
  WTF::String signed_redemption_record_verification_key;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
  DISALLOW_COPY_AND_ASSIGN(TrustTokenKeyCommitmentResult);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
TrustTokenParamsPtr TrustTokenParams::Clone() const {
  return New(
      mojo::Clone(type),
      mojo::Clone(refresh_policy),
      mojo::Clone(sign_request_data),
      mojo::Clone(include_timestamp_header),
      mojo::Clone(issuers),
      mojo::Clone(additional_signed_headers),
      mojo::Clone(possibly_unsafe_additional_signing_data)
  );
}

template <typename T, TrustTokenParams::EnableIfSame<T>*>
bool TrustTokenParams::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->type, other_struct.type))
    return false;
  if (!mojo::Equals(this->refresh_policy, other_struct.refresh_policy))
    return false;
  if (!mojo::Equals(this->sign_request_data, other_struct.sign_request_data))
    return false;
  if (!mojo::Equals(this->include_timestamp_header, other_struct.include_timestamp_header))
    return false;
  if (!mojo::Equals(this->issuers, other_struct.issuers))
    return false;
  if (!mojo::Equals(this->additional_signed_headers, other_struct.additional_signed_headers))
    return false;
  if (!mojo::Equals(this->possibly_unsafe_additional_signing_data, other_struct.possibly_unsafe_additional_signing_data))
    return false;
  return true;
}

template <typename T, TrustTokenParams::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.type, rhs.type))
    return true;
  if (std::less<>{}(rhs.type, lhs.type))
    return false;
  if (std::less<>{}(lhs.refresh_policy, rhs.refresh_policy))
    return true;
  if (std::less<>{}(rhs.refresh_policy, lhs.refresh_policy))
    return false;
  if (std::less<>{}(lhs.sign_request_data, rhs.sign_request_data))
    return true;
  if (std::less<>{}(rhs.sign_request_data, lhs.sign_request_data))
    return false;
  if (std::less<>{}(lhs.include_timestamp_header, rhs.include_timestamp_header))
    return true;
  if (std::less<>{}(rhs.include_timestamp_header, lhs.include_timestamp_header))
    return false;
  if (std::less<>{}(lhs.issuers, rhs.issuers))
    return true;
  if (std::less<>{}(rhs.issuers, lhs.issuers))
    return false;
  if (std::less<>{}(lhs.additional_signed_headers, rhs.additional_signed_headers))
    return true;
  if (std::less<>{}(rhs.additional_signed_headers, lhs.additional_signed_headers))
    return false;
  if (std::less<>{}(lhs.possibly_unsafe_additional_signing_data, rhs.possibly_unsafe_additional_signing_data))
    return true;
  if (std::less<>{}(rhs.possibly_unsafe_additional_signing_data, lhs.possibly_unsafe_additional_signing_data))
    return false;
  return false;
}
template <typename StructPtrType>
HasTrustTokensResultPtr HasTrustTokensResult::Clone() const {
  return New(
      mojo::Clone(status),
      mojo::Clone(has_trust_tokens)
  );
}

template <typename T, HasTrustTokensResult::EnableIfSame<T>*>
bool HasTrustTokensResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->status, other_struct.status))
    return false;
  if (!mojo::Equals(this->has_trust_tokens, other_struct.has_trust_tokens))
    return false;
  return true;
}

template <typename T, HasTrustTokensResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.status, rhs.status))
    return true;
  if (std::less<>{}(rhs.status, lhs.status))
    return false;
  if (std::less<>{}(lhs.has_trust_tokens, rhs.has_trust_tokens))
    return true;
  if (std::less<>{}(rhs.has_trust_tokens, lhs.has_trust_tokens))
    return false;
  return false;
}
template <typename StructPtrType>
TrustTokenVerificationKeyPtr TrustTokenVerificationKey::Clone() const {
  return New(
      mojo::Clone(body),
      mojo::Clone(expiry)
  );
}

template <typename T, TrustTokenVerificationKey::EnableIfSame<T>*>
bool TrustTokenVerificationKey::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->body, other_struct.body))
    return false;
  if (!mojo::Equals(this->expiry, other_struct.expiry))
    return false;
  return true;
}

template <typename T, TrustTokenVerificationKey::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.body, rhs.body))
    return true;
  if (std::less<>{}(rhs.body, lhs.body))
    return false;
  if (std::less<>{}(lhs.expiry, rhs.expiry))
    return true;
  if (std::less<>{}(rhs.expiry, lhs.expiry))
    return false;
  return false;
}
template <typename StructPtrType>
TrustTokenKeyCommitmentResultPtr TrustTokenKeyCommitmentResult::Clone() const {
  return New(
      mojo::Clone(batch_size),
      mojo::Clone(keys),
      mojo::Clone(signed_redemption_record_verification_key)
  );
}

template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>*>
bool TrustTokenKeyCommitmentResult::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->batch_size, other_struct.batch_size))
    return false;
  if (!mojo::Equals(this->keys, other_struct.keys))
    return false;
  if (!mojo::Equals(this->signed_redemption_record_verification_key, other_struct.signed_redemption_record_verification_key))
    return false;
  return true;
}

template <typename T, TrustTokenKeyCommitmentResult::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.batch_size, rhs.batch_size))
    return true;
  if (std::less<>{}(rhs.batch_size, lhs.batch_size))
    return false;
  if (std::less<>{}(lhs.keys, rhs.keys))
    return true;
  if (std::less<>{}(rhs.keys, lhs.keys))
    return false;
  if (std::less<>{}(lhs.signed_redemption_record_verification_key, rhs.signed_redemption_record_verification_key))
    return true;
  if (std::less<>{}(rhs.signed_redemption_record_verification_key, lhs.signed_redemption_record_verification_key))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::TrustTokenParams::DataView,
                                         ::network::mojom::blink::TrustTokenParamsPtr> {
  static bool IsNull(const ::network::mojom::blink::TrustTokenParamsPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::TrustTokenParamsPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::TrustTokenParams::type) type(
      const ::network::mojom::blink::TrustTokenParamsPtr& input) {
    return input->type;
  }

  static decltype(::network::mojom::blink::TrustTokenParams::refresh_policy) refresh_policy(
      const ::network::mojom::blink::TrustTokenParamsPtr& input) {
    return input->refresh_policy;
  }

  static decltype(::network::mojom::blink::TrustTokenParams::sign_request_data) sign_request_data(
      const ::network::mojom::blink::TrustTokenParamsPtr& input) {
    return input->sign_request_data;
  }

  static decltype(::network::mojom::blink::TrustTokenParams::include_timestamp_header) include_timestamp_header(
      const ::network::mojom::blink::TrustTokenParamsPtr& input) {
    return input->include_timestamp_header;
  }

  static const decltype(::network::mojom::blink::TrustTokenParams::issuers)& issuers(
      const ::network::mojom::blink::TrustTokenParamsPtr& input) {
    return input->issuers;
  }

  static const decltype(::network::mojom::blink::TrustTokenParams::additional_signed_headers)& additional_signed_headers(
      const ::network::mojom::blink::TrustTokenParamsPtr& input) {
    return input->additional_signed_headers;
  }

  static const decltype(::network::mojom::blink::TrustTokenParams::possibly_unsafe_additional_signing_data)& possibly_unsafe_additional_signing_data(
      const ::network::mojom::blink::TrustTokenParamsPtr& input) {
    return input->possibly_unsafe_additional_signing_data;
  }

  static bool Read(::network::mojom::blink::TrustTokenParams::DataView input, ::network::mojom::blink::TrustTokenParamsPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::HasTrustTokensResult::DataView,
                                         ::network::mojom::blink::HasTrustTokensResultPtr> {
  static bool IsNull(const ::network::mojom::blink::HasTrustTokensResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::HasTrustTokensResultPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::HasTrustTokensResult::status) status(
      const ::network::mojom::blink::HasTrustTokensResultPtr& input) {
    return input->status;
  }

  static decltype(::network::mojom::blink::HasTrustTokensResult::has_trust_tokens) has_trust_tokens(
      const ::network::mojom::blink::HasTrustTokensResultPtr& input) {
    return input->has_trust_tokens;
  }

  static bool Read(::network::mojom::blink::HasTrustTokensResult::DataView input, ::network::mojom::blink::HasTrustTokensResultPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::TrustTokenVerificationKey::DataView,
                                         ::network::mojom::blink::TrustTokenVerificationKeyPtr> {
  static bool IsNull(const ::network::mojom::blink::TrustTokenVerificationKeyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::TrustTokenVerificationKeyPtr* output) { output->reset(); }

  static const decltype(::network::mojom::blink::TrustTokenVerificationKey::body)& body(
      const ::network::mojom::blink::TrustTokenVerificationKeyPtr& input) {
    return input->body;
  }

  static const decltype(::network::mojom::blink::TrustTokenVerificationKey::expiry)& expiry(
      const ::network::mojom::blink::TrustTokenVerificationKeyPtr& input) {
    return input->expiry;
  }

  static bool Read(::network::mojom::blink::TrustTokenVerificationKey::DataView input, ::network::mojom::blink::TrustTokenVerificationKeyPtr* output);
};


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::TrustTokenKeyCommitmentResult::DataView,
                                         ::network::mojom::blink::TrustTokenKeyCommitmentResultPtr> {
  static bool IsNull(const ::network::mojom::blink::TrustTokenKeyCommitmentResultPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::TrustTokenKeyCommitmentResultPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::TrustTokenKeyCommitmentResult::batch_size) batch_size(
      const ::network::mojom::blink::TrustTokenKeyCommitmentResultPtr& input) {
    return input->batch_size;
  }

  static const decltype(::network::mojom::blink::TrustTokenKeyCommitmentResult::keys)& keys(
      const ::network::mojom::blink::TrustTokenKeyCommitmentResultPtr& input) {
    return input->keys;
  }

  static const decltype(::network::mojom::blink::TrustTokenKeyCommitmentResult::signed_redemption_record_verification_key)& signed_redemption_record_verification_key(
      const ::network::mojom::blink::TrustTokenKeyCommitmentResultPtr& input) {
    return input->signed_redemption_record_verification_key;
  }

  static bool Read(::network::mojom::blink::TrustTokenKeyCommitmentResult::DataView input, ::network::mojom::blink::TrustTokenKeyCommitmentResultPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_BLINK_H_