// services/network/public/mojom/trust_tokens.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SHARED_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "services/network/public/mojom/trust_tokens.mojom-shared-internal.h"
#include "url/mojom/origin.mojom-shared.h"
#include "mojo/public/mojom/base/time.mojom-shared.h"
#include "mojo/public/cpp/bindings/lib/interface_serialization.h"






namespace network {
namespace mojom {
class TrustTokenParamsDataView;

class HasTrustTokensResultDataView;

class TrustTokenVerificationKeyDataView;

class TrustTokenKeyCommitmentResultDataView;



}  // namespace mojom
}  // namespace network

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenParamsDataView> {
  using Data = ::network::mojom::internal::TrustTokenParams_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::HasTrustTokensResultDataView> {
  using Data = ::network::mojom::internal::HasTrustTokensResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenVerificationKeyDataView> {
  using Data = ::network::mojom::internal::TrustTokenVerificationKey_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::network::mojom::TrustTokenKeyCommitmentResultDataView> {
  using Data = ::network::mojom::internal::TrustTokenKeyCommitmentResult_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace network {
namespace mojom {


enum class TrustTokenOperationStatus : int32_t {
  
  kOk = 0,
  
  kInvalidArgument = 1,
  
  kFailedPrecondition = 2,
  
  kResourceExhausted = 3,
  
  kAlreadyExists = 4,
  
  kUnavailable = 5,
  
  kBadResponse = 6,
  
  kInternalError = 7,
  
  kUnknownError = 8,
  kMinValue = 0,
  kMaxValue = 8,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenOperationStatus value);
inline bool IsKnownEnumValue(TrustTokenOperationStatus value) {
  return internal::TrustTokenOperationStatus_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrustTokenOperationType : int32_t {
  
  kIssuance = 0,
  
  kRedemption = 1,
  
  kSigning = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenOperationType value);
inline bool IsKnownEnumValue(TrustTokenOperationType value) {
  return internal::TrustTokenOperationType_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrustTokenRefreshPolicy : int32_t {
  
  kUseCached = 0,
  
  kRefresh = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenRefreshPolicy value);
inline bool IsKnownEnumValue(TrustTokenRefreshPolicy value) {
  return internal::TrustTokenRefreshPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


enum class TrustTokenSignRequestData : int32_t {
  
  kOmit = 0,
  
  kHeadersOnly = 1,
  
  kInclude = 2,
  kMinValue = 0,
  kMaxValue = 2,
};

 std::ostream& operator<<(std::ostream& os, TrustTokenSignRequestData value);
inline bool IsKnownEnumValue(TrustTokenSignRequestData value) {
  return internal::TrustTokenSignRequestData_Data::IsKnownValue(
      static_cast<int32_t>(value));
}
// Interface base classes. They are used for type safety check.
class HasTrustTokensAnswererInterfaceBase {};

using HasTrustTokensAnswererPtrDataView =
    mojo::InterfacePtrDataView<HasTrustTokensAnswererInterfaceBase>;
using HasTrustTokensAnswererRequestDataView =
    mojo::InterfaceRequestDataView<HasTrustTokensAnswererInterfaceBase>;
using HasTrustTokensAnswererAssociatedPtrInfoDataView =
    mojo::AssociatedInterfacePtrInfoDataView<HasTrustTokensAnswererInterfaceBase>;
using HasTrustTokensAnswererAssociatedRequestDataView =
    mojo::AssociatedInterfaceRequestDataView<HasTrustTokensAnswererInterfaceBase>;


class TrustTokenParamsDataView {
 public:
  TrustTokenParamsDataView() {}

  TrustTokenParamsDataView(
      internal::TrustTokenParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadType(UserType* output) const {
    auto data_value = data_->type;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationType>(
        data_value, output);
  }

  TrustTokenOperationType type() const {
    return static_cast<TrustTokenOperationType>(data_->type);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRefreshPolicy(UserType* output) const {
    auto data_value = data_->refresh_policy;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenRefreshPolicy>(
        data_value, output);
  }

  TrustTokenRefreshPolicy refresh_policy() const {
    return static_cast<TrustTokenRefreshPolicy>(data_->refresh_policy);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSignRequestData(UserType* output) const {
    auto data_value = data_->sign_request_data;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenSignRequestData>(
        data_value, output);
  }

  TrustTokenSignRequestData sign_request_data() const {
    return static_cast<TrustTokenSignRequestData>(data_->sign_request_data);
  }
  bool include_timestamp_header() const {
    return data_->include_timestamp_header;
  }
  inline void GetIssuersDataView(
      mojo::ArrayDataView<::url::mojom::OriginDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadIssuers(UserType* output) {
    
    auto* pointer = data_->issuers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        pointer, output, context_);
  }
  inline void GetAdditionalSignedHeadersDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadAdditionalSignedHeaders(UserType* output) {
    
    auto* pointer = data_->additional_signed_headers.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetPossiblyUnsafeAdditionalSigningDataDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadPossiblyUnsafeAdditionalSigningData(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        mojo::StringDataView, UserType>(),
    "Attempting to read the optional `possibly_unsafe_additional_signing_data` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadPossiblyUnsafeAdditionalSigningData` instead "
    "of `ReadPossiblyUnsafeAdditionalSigningData if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->possibly_unsafe_additional_signing_data.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::TrustTokenParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class HasTrustTokensResultDataView {
 public:
  HasTrustTokensResultDataView() {}

  HasTrustTokensResultDataView(
      internal::HasTrustTokensResult_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::network::mojom::TrustTokenOperationStatus>(
        data_value, output);
  }

  TrustTokenOperationStatus status() const {
    return static_cast<TrustTokenOperationStatus>(data_->status);
  }
  bool has_trust_tokens() const {
    return data_->has_trust_tokens;
  }
 private:
  internal::HasTrustTokensResult_Data* data_ = nullptr;
};



class TrustTokenVerificationKeyDataView {
 public:
  TrustTokenVerificationKeyDataView() {}

  TrustTokenVerificationKeyDataView(
      internal::TrustTokenVerificationKey_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetBodyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadBody(UserType* output) {
    
    auto* pointer = data_->body.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  inline void GetExpiryDataView(
      ::mojo_base::mojom::TimeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadExpiry(UserType* output) {
    
    auto* pointer = data_->expiry.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDataView>(
        pointer, output, context_);
  }
 private:
  internal::TrustTokenVerificationKey_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class TrustTokenKeyCommitmentResultDataView {
 public:
  TrustTokenKeyCommitmentResultDataView() {}

  TrustTokenKeyCommitmentResultDataView(
      internal::TrustTokenKeyCommitmentResult_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  int32_t batch_size() const {
    return data_->batch_size;
  }
  inline void GetKeysDataView(
      mojo::ArrayDataView<TrustTokenVerificationKeyDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadKeys(UserType* output) {
    
    auto* pointer = data_->keys.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::network::mojom::TrustTokenVerificationKeyDataView>>(
        pointer, output, context_);
  }
  inline void GetSignedRedemptionRecordVerificationKeyDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSignedRedemptionRecordVerificationKey(UserType* output) {
    
    auto* pointer = data_->signed_redemption_record_verification_key.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
 private:
  internal::TrustTokenKeyCommitmentResult_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace network

namespace std {

template <>
struct hash<::network::mojom::TrustTokenOperationStatus>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenOperationStatus> {};

template <>
struct hash<::network::mojom::TrustTokenOperationType>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenOperationType> {};

template <>
struct hash<::network::mojom::TrustTokenRefreshPolicy>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenRefreshPolicy> {};

template <>
struct hash<::network::mojom::TrustTokenSignRequestData>
    : public mojo::internal::EnumHashImpl<::network::mojom::TrustTokenSignRequestData> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::network::mojom::TrustTokenOperationStatus, ::network::mojom::TrustTokenOperationStatus> {
  static ::network::mojom::TrustTokenOperationStatus ToMojom(::network::mojom::TrustTokenOperationStatus input) { return input; }
  static bool FromMojom(::network::mojom::TrustTokenOperationStatus input, ::network::mojom::TrustTokenOperationStatus* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenOperationStatus, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenOperationStatus, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::TrustTokenOperationStatus>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::TrustTokenOperationType, ::network::mojom::TrustTokenOperationType> {
  static ::network::mojom::TrustTokenOperationType ToMojom(::network::mojom::TrustTokenOperationType input) { return input; }
  static bool FromMojom(::network::mojom::TrustTokenOperationType input, ::network::mojom::TrustTokenOperationType* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenOperationType, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenOperationType, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::TrustTokenOperationType>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::TrustTokenRefreshPolicy, ::network::mojom::TrustTokenRefreshPolicy> {
  static ::network::mojom::TrustTokenRefreshPolicy ToMojom(::network::mojom::TrustTokenRefreshPolicy input) { return input; }
  static bool FromMojom(::network::mojom::TrustTokenRefreshPolicy input, ::network::mojom::TrustTokenRefreshPolicy* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenRefreshPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenRefreshPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::TrustTokenRefreshPolicy>(input), output);
  }
};

}  // namespace internal


template <>
struct EnumTraits<::network::mojom::TrustTokenSignRequestData, ::network::mojom::TrustTokenSignRequestData> {
  static ::network::mojom::TrustTokenSignRequestData ToMojom(::network::mojom::TrustTokenSignRequestData input) { return input; }
  static bool FromMojom(::network::mojom::TrustTokenSignRequestData input, ::network::mojom::TrustTokenSignRequestData* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenSignRequestData, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::network::mojom::TrustTokenSignRequestData, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::network::mojom::TrustTokenSignRequestData>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenParamsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenParamsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::TrustTokenParams_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::TrustTokenOperationType>(
        Traits::type(input), &(*output)->type);
    mojo::internal::Serialize<::network::mojom::TrustTokenRefreshPolicy>(
        Traits::refresh_policy(input), &(*output)->refresh_policy);
    mojo::internal::Serialize<::network::mojom::TrustTokenSignRequestData>(
        Traits::sign_request_data(input), &(*output)->sign_request_data);
    (*output)->include_timestamp_header = Traits::include_timestamp_header(input);
    decltype(Traits::issuers(input)) in_issuers = Traits::issuers(input);
    typename decltype((*output)->issuers)::BaseType::BufferWriter
        issuers_writer;
    const mojo::internal::ContainerValidateParams issuers_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::url::mojom::OriginDataView>>(
        in_issuers, buffer, &issuers_writer, &issuers_validate_params,
        context);
    (*output)->issuers.Set(
        issuers_writer.is_null() ? nullptr : issuers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->issuers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null issuers in TrustTokenParams struct");
    decltype(Traits::additional_signed_headers(input)) in_additional_signed_headers = Traits::additional_signed_headers(input);
    typename decltype((*output)->additional_signed_headers)::BaseType::BufferWriter
        additional_signed_headers_writer;
    const mojo::internal::ContainerValidateParams additional_signed_headers_validate_params(
        0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::StringDataView>>(
        in_additional_signed_headers, buffer, &additional_signed_headers_writer, &additional_signed_headers_validate_params,
        context);
    (*output)->additional_signed_headers.Set(
        additional_signed_headers_writer.is_null() ? nullptr : additional_signed_headers_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->additional_signed_headers.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null additional_signed_headers in TrustTokenParams struct");
    decltype(Traits::possibly_unsafe_additional_signing_data(input)) in_possibly_unsafe_additional_signing_data = Traits::possibly_unsafe_additional_signing_data(input);
    typename decltype((*output)->possibly_unsafe_additional_signing_data)::BaseType::BufferWriter
        possibly_unsafe_additional_signing_data_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_possibly_unsafe_additional_signing_data, buffer, &possibly_unsafe_additional_signing_data_writer, context);
    (*output)->possibly_unsafe_additional_signing_data.Set(
        possibly_unsafe_additional_signing_data_writer.is_null() ? nullptr : possibly_unsafe_additional_signing_data_writer.data());
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenParams_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenParamsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::HasTrustTokensResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::HasTrustTokensResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::HasTrustTokensResult_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::TrustTokenOperationStatus>(
        Traits::status(input), &(*output)->status);
    (*output)->has_trust_tokens = Traits::has_trust_tokens(input);
  }

  static bool Deserialize(::network::mojom::internal::HasTrustTokensResult_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::HasTrustTokensResultDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenVerificationKeyDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenVerificationKeyDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::TrustTokenVerificationKey_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::body(input)) in_body = Traits::body(input);
    typename decltype((*output)->body)::BaseType::BufferWriter
        body_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_body, buffer, &body_writer, context);
    (*output)->body.Set(
        body_writer.is_null() ? nullptr : body_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->body.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null body in TrustTokenVerificationKey struct");
    decltype(Traits::expiry(input)) in_expiry = Traits::expiry(input);
    typename decltype((*output)->expiry)::BaseType::BufferWriter
        expiry_writer;
    mojo::internal::Serialize<::mojo_base::mojom::TimeDataView>(
        in_expiry, buffer, &expiry_writer, context);
    (*output)->expiry.Set(
        expiry_writer.is_null() ? nullptr : expiry_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->expiry.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null expiry in TrustTokenVerificationKey struct");
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenVerificationKey_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenVerificationKeyDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::network::mojom::TrustTokenKeyCommitmentResultDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::network::mojom::TrustTokenKeyCommitmentResultDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::network::mojom::internal::TrustTokenKeyCommitmentResult_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->batch_size = Traits::batch_size(input);
    decltype(Traits::keys(input)) in_keys = Traits::keys(input);
    typename decltype((*output)->keys)::BaseType::BufferWriter
        keys_writer;
    const mojo::internal::ContainerValidateParams keys_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::network::mojom::TrustTokenVerificationKeyDataView>>(
        in_keys, buffer, &keys_writer, &keys_validate_params,
        context);
    (*output)->keys.Set(
        keys_writer.is_null() ? nullptr : keys_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->keys.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null keys in TrustTokenKeyCommitmentResult struct");
    decltype(Traits::signed_redemption_record_verification_key(input)) in_signed_redemption_record_verification_key = Traits::signed_redemption_record_verification_key(input);
    typename decltype((*output)->signed_redemption_record_verification_key)::BaseType::BufferWriter
        signed_redemption_record_verification_key_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_signed_redemption_record_verification_key, buffer, &signed_redemption_record_verification_key_writer, context);
    (*output)->signed_redemption_record_verification_key.Set(
        signed_redemption_record_verification_key_writer.is_null() ? nullptr : signed_redemption_record_verification_key_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->signed_redemption_record_verification_key.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null signed_redemption_record_verification_key in TrustTokenKeyCommitmentResult struct");
  }

  static bool Deserialize(::network::mojom::internal::TrustTokenKeyCommitmentResult_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::network::mojom::TrustTokenKeyCommitmentResultDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace network {
namespace mojom {

inline void TrustTokenParamsDataView::GetIssuersDataView(
    mojo::ArrayDataView<::url::mojom::OriginDataView>* output) {
  auto pointer = data_->issuers.Get();
  *output = mojo::ArrayDataView<::url::mojom::OriginDataView>(pointer, context_);
}
inline void TrustTokenParamsDataView::GetAdditionalSignedHeadersDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->additional_signed_headers.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void TrustTokenParamsDataView::GetPossiblyUnsafeAdditionalSigningDataDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->possibly_unsafe_additional_signing_data.Get();
  *output = mojo::StringDataView(pointer, context_);
}




inline void TrustTokenVerificationKeyDataView::GetBodyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->body.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void TrustTokenVerificationKeyDataView::GetExpiryDataView(
    ::mojo_base::mojom::TimeDataView* output) {
  auto pointer = data_->expiry.Get();
  *output = ::mojo_base::mojom::TimeDataView(pointer, context_);
}


inline void TrustTokenKeyCommitmentResultDataView::GetKeysDataView(
    mojo::ArrayDataView<TrustTokenVerificationKeyDataView>* output) {
  auto pointer = data_->keys.Get();
  *output = mojo::ArrayDataView<TrustTokenVerificationKeyDataView>(pointer, context_);
}
inline void TrustTokenKeyCommitmentResultDataView::GetSignedRedemptionRecordVerificationKeyDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->signed_redemption_record_verification_key.Get();
  *output = mojo::StringDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace network

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_TRUST_TOKENS_MOJOM_SHARED_H_