// third_party/blink/public/mojom/page/widget.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/page/widget.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/page/widget.mojom-params-data.h"
#include "third_party/blink/public/mojom/page/widget.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/page/widget.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_WIDGET_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_PAGE_WIDGET_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char FrameWidget::Name_[] = "blink.mojom.FrameWidget";

class FrameWidget_DragTargetDragOver_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  FrameWidget_DragTargetDragOver_ForwardToCallback(
      FrameWidget::DragTargetDragOverCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  FrameWidget::DragTargetDragOverCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(FrameWidget_DragTargetDragOver_ForwardToCallback);
};

FrameWidgetProxy::FrameWidgetProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameWidgetProxy::DragTargetDragOver(
    const ::gfx::PointF& in_point_in_viewport, const ::gfx::PointF& in_screen_point, ::blink::DragOperationsMask in_operations_allowed, uint32_t in_key_modifiers, DragTargetDragOverCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::DragTargetDragOver", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("point_in_viewport", base::trace_event::ValueToString(in_point_in_viewport, "<value of type const ::gfx::PointF&>"));
      raw_value->SetString("screen_point", base::trace_event::ValueToString(in_screen_point, "<value of type const ::gfx::PointF&>"));
      raw_value->SetString("operations_allowed", base::trace_event::ValueToString(in_operations_allowed, "<value of type ::blink::DragOperationsMask>"));
      raw_value->SetString("key_modifiers", base::NumberToString(in_key_modifiers));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_DragTargetDragOver_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_DragTargetDragOver_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->point_in_viewport)::BaseType::BufferWriter
      point_in_viewport_writer;
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_point_in_viewport, buffer, &point_in_viewport_writer, &serialization_context);
  params->point_in_viewport.Set(
      point_in_viewport_writer.is_null() ? nullptr : point_in_viewport_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point_in_viewport.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point_in_viewport in FrameWidget.DragTargetDragOver request");
  typename decltype(params->screen_point)::BaseType::BufferWriter
      screen_point_writer;
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_screen_point, buffer, &screen_point_writer, &serialization_context);
  params->screen_point.Set(
      screen_point_writer.is_null() ? nullptr : screen_point_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->screen_point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null screen_point in FrameWidget.DragTargetDragOver request");
  typename decltype(params->operations_allowed)::BaseType::BufferWriter
      operations_allowed_writer;
  mojo::internal::Serialize<::blink::mojom::AllowedDragOperationsDataView>(
      in_operations_allowed, buffer, &operations_allowed_writer, &serialization_context);
  params->operations_allowed.Set(
      operations_allowed_writer.is_null() ? nullptr : operations_allowed_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->operations_allowed.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null operations_allowed in FrameWidget.DragTargetDragOver request");
  params->key_modifiers = in_key_modifiers;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragTargetDragOver");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new FrameWidget_DragTargetDragOver_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void FrameWidgetProxy::DragTargetDragLeave(
    const ::gfx::PointF& in_point_in_viewport, const ::gfx::PointF& in_screen_point) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::DragTargetDragLeave", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("point_in_viewport", base::trace_event::ValueToString(in_point_in_viewport, "<value of type const ::gfx::PointF&>"));
      raw_value->SetString("screen_point", base::trace_event::ValueToString(in_screen_point, "<value of type const ::gfx::PointF&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_DragTargetDragLeave_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_DragTargetDragLeave_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->point_in_viewport)::BaseType::BufferWriter
      point_in_viewport_writer;
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_point_in_viewport, buffer, &point_in_viewport_writer, &serialization_context);
  params->point_in_viewport.Set(
      point_in_viewport_writer.is_null() ? nullptr : point_in_viewport_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point_in_viewport.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point_in_viewport in FrameWidget.DragTargetDragLeave request");
  typename decltype(params->screen_point)::BaseType::BufferWriter
      screen_point_writer;
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_screen_point, buffer, &screen_point_writer, &serialization_context);
  params->screen_point.Set(
      screen_point_writer.is_null() ? nullptr : screen_point_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->screen_point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null screen_point in FrameWidget.DragTargetDragLeave request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragTargetDragLeave");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::DragTargetDrop(
    ::blink::mojom::DragDataPtr in_drag_data, const ::gfx::PointF& in_point_in_viewport, const ::gfx::PointF& in_screen_point, uint32_t in_key_modifiers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::DragTargetDrop", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_drag_data.is_null()) {
        raw_value->SetString("drag_data", "nullptr");
      } else {
        raw_value->BeginDictionary("drag_data");
        in_drag_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("point_in_viewport", base::trace_event::ValueToString(in_point_in_viewport, "<value of type const ::gfx::PointF&>"));
      raw_value->SetString("screen_point", base::trace_event::ValueToString(in_screen_point, "<value of type const ::gfx::PointF&>"));
      raw_value->SetString("key_modifiers", base::NumberToString(in_key_modifiers));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_DragTargetDrop_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_DragTargetDrop_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->drag_data)::BaseType::BufferWriter
      drag_data_writer;
  mojo::internal::Serialize<::blink::mojom::DragDataDataView>(
      in_drag_data, buffer, &drag_data_writer, &serialization_context);
  params->drag_data.Set(
      drag_data_writer.is_null() ? nullptr : drag_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->drag_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null drag_data in FrameWidget.DragTargetDrop request");
  typename decltype(params->point_in_viewport)::BaseType::BufferWriter
      point_in_viewport_writer;
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_point_in_viewport, buffer, &point_in_viewport_writer, &serialization_context);
  params->point_in_viewport.Set(
      point_in_viewport_writer.is_null() ? nullptr : point_in_viewport_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point_in_viewport.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point_in_viewport in FrameWidget.DragTargetDrop request");
  typename decltype(params->screen_point)::BaseType::BufferWriter
      screen_point_writer;
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_screen_point, buffer, &screen_point_writer, &serialization_context);
  params->screen_point.Set(
      screen_point_writer.is_null() ? nullptr : screen_point_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->screen_point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null screen_point in FrameWidget.DragTargetDrop request");
  params->key_modifiers = in_key_modifiers;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragTargetDrop");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::DragSourceEndedAt(
    const ::gfx::PointF& in_point_in_viewport, const ::gfx::PointF& in_screen_point, ::blink::DragOperation in_drag_operation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::DragSourceEndedAt", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("point_in_viewport", base::trace_event::ValueToString(in_point_in_viewport, "<value of type const ::gfx::PointF&>"));
      raw_value->SetString("screen_point", base::trace_event::ValueToString(in_screen_point, "<value of type const ::gfx::PointF&>"));
      raw_value->SetInteger("drag_operation", static_cast<int>(in_drag_operation));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_DragSourceEndedAt_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_DragSourceEndedAt_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->point_in_viewport)::BaseType::BufferWriter
      point_in_viewport_writer;
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_point_in_viewport, buffer, &point_in_viewport_writer, &serialization_context);
  params->point_in_viewport.Set(
      point_in_viewport_writer.is_null() ? nullptr : point_in_viewport_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->point_in_viewport.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null point_in_viewport in FrameWidget.DragSourceEndedAt request");
  typename decltype(params->screen_point)::BaseType::BufferWriter
      screen_point_writer;
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_screen_point, buffer, &screen_point_writer, &serialization_context);
  params->screen_point.Set(
      screen_point_writer.is_null() ? nullptr : screen_point_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->screen_point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null screen_point in FrameWidget.DragSourceEndedAt request");
  mojo::internal::Serialize<::blink::mojom::DragOperation>(
      in_drag_operation, &params->drag_operation);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragSourceEndedAt");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::DragSourceSystemDragEnded(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidget::DragSourceSystemDragEnded");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_DragSourceSystemDragEnded_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_DragSourceSystemDragEnded_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragSourceSystemDragEnded");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::SetBackgroundOpaque(
    bool in_opaque) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::SetBackgroundOpaque", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("opaque", in_opaque);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_SetBackgroundOpaque_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_SetBackgroundOpaque_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->opaque = in_opaque;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("SetBackgroundOpaque");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::SetTextDirection(
    ::base::i18n::TextDirection in_direction) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::SetTextDirection", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("direction", static_cast<int>(in_direction));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_SetTextDirection_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_SetTextDirection_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
      in_direction, &params->direction);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("SetTextDirection");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::SetActive(
    bool in_active) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::SetActive", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("active", in_active);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_SetActive_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_SetActive_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->active = in_active;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("SetActive");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::SetInheritedEffectiveTouchActionForSubFrame(
    ::cc::TouchAction in_touch_action) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::SetInheritedEffectiveTouchActionForSubFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("touch_action", static_cast<int>(in_touch_action));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::cc::mojom::TouchAction>(
      in_touch_action, &params->touch_action);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("SetInheritedEffectiveTouchActionForSubFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::UpdateRenderThrottlingStatusForSubFrame(
    bool in_is_throttled, bool in_subtree_throttled) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::UpdateRenderThrottlingStatusForSubFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("is_throttled", in_is_throttled);
      raw_value->SetBoolean("subtree_throttled", in_subtree_throttled);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_UpdateRenderThrottlingStatusForSubFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->is_throttled = in_is_throttled;
  params->subtree_throttled = in_subtree_throttled;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("UpdateRenderThrottlingStatusForSubFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::SetIsInertForSubFrame(
    bool in_inert) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::SetIsInertForSubFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("inert", in_inert);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_SetIsInertForSubFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_SetIsInertForSubFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->inert = in_inert;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("SetIsInertForSubFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::ShowContextMenu(
    ::ui::MenuSourceType in_source_type, const ::gfx::Point& in_location) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::ShowContextMenu", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("source_type", static_cast<int>(in_source_type));
      raw_value->SetString("location", base::trace_event::ValueToString(in_location, "<value of type const ::gfx::Point&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_ShowContextMenu_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_ShowContextMenu_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::ui::mojom::MenuSourceType>(
      in_source_type, &params->source_type);
  typename decltype(params->location)::BaseType::BufferWriter
      location_writer;
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_location, buffer, &location_writer, &serialization_context);
  params->location.Set(
      location_writer.is_null() ? nullptr : location_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->location.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null location in FrameWidget.ShowContextMenu request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("ShowContextMenu");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::EnableDeviceEmulation(
    const ::blink::DeviceEmulationParams& in_parameters) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::EnableDeviceEmulation", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("parameters", base::trace_event::ValueToString(in_parameters, "<value of type const ::blink::DeviceEmulationParams&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_EnableDeviceEmulation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_EnableDeviceEmulation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->parameters)::BaseType::BufferWriter
      parameters_writer;
  mojo::internal::Serialize<::blink::mojom::DeviceEmulationParamsDataView>(
      in_parameters, buffer, &parameters_writer, &serialization_context);
  params->parameters.Set(
      parameters_writer.is_null() ? nullptr : parameters_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->parameters.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null parameters in FrameWidget.EnableDeviceEmulation request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("EnableDeviceEmulation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::DisableDeviceEmulation(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidget::DisableDeviceEmulation");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_DisableDeviceEmulation_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_DisableDeviceEmulation_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DisableDeviceEmulation");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::BindWidgetCompositor(
    ::mojo::PendingReceiver<WidgetCompositor> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::BindWidgetCompositor", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("host", in_host.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_BindWidgetCompositor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_BindWidgetCompositor_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::WidgetCompositorInterfaceBase>>(
      in_host, &params->host, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host in FrameWidget.BindWidgetCompositor request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("BindWidgetCompositor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetProxy::BindInputTargetClient(
    ::mojo::PendingReceiver<::viz::mojom::InputTargetClient> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidget::BindInputTargetClient", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("host", in_host.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_BindInputTargetClient_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_BindInputTargetClient_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::viz::mojom::InputTargetClientInterfaceBase>>(
      in_host, &params->host, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host in FrameWidget.BindInputTargetClient request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("BindInputTargetClient");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class FrameWidget_DragTargetDragOver_ProxyToResponder {
 public:
  static FrameWidget::DragTargetDragOverCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<FrameWidget_DragTargetDragOver_ProxyToResponder> proxy(
        new FrameWidget_DragTargetDragOver_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&FrameWidget_DragTargetDragOver_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~FrameWidget_DragTargetDragOver_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  FrameWidget_DragTargetDragOver_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "FrameWidget::DragTargetDragOverCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      ::blink::DragOperation in_operation);

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(FrameWidget_DragTargetDragOver_ProxyToResponder);
};

bool FrameWidget_DragTargetDragOver_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::FrameWidget::DragTargetDragOverCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::FrameWidget_DragTargetDragOver_ResponseParams_Data* params =
      reinterpret_cast<
          internal::FrameWidget_DragTargetDragOver_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  ::blink::DragOperation p_operation{};
  FrameWidget_DragTargetDragOver_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (success && !input_data_view.ReadOperation(&p_operation))
    success = false;
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        FrameWidget::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run(
std::move(p_operation));
  return true;
}

void FrameWidget_DragTargetDragOver_ProxyToResponder::Run(
    ::blink::DragOperation in_operation) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN1(
    "mojom", "(Impl)blink::mojom::FrameWidget::DragTargetDragOverCallback", "async_response_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("operation", static_cast<int>(in_operation));
      return value;
    }());
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidget_DragTargetDragOver_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidget_DragTargetDragOver_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<::blink::mojom::DragOperation>(
      in_operation, &params->operation);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::FrameWidget::DragTargetDragOverCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidget::Name_);
  message.set_method_name("DragTargetDragOver");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool FrameWidgetStubDispatch::Accept(
    FrameWidget* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrameWidget_DragTargetDragOver_Name: {
      break;
    }
    case internal::kFrameWidget_DragTargetDragLeave_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::DragTargetDragLeave",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::DragTargetDragLeave");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_DragTargetDragLeave_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_DragTargetDragLeave_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::PointF p_point_in_viewport{};
      ::gfx::PointF p_screen_point{};
      FrameWidget_DragTargetDragLeave_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPointInViewport(&p_point_in_viewport))
        success = false;
      if (success && !input_data_view.ReadScreenPoint(&p_screen_point))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragTargetDragLeave(
std::move(p_point_in_viewport), 
std::move(p_screen_point));
      return true;
    }
    case internal::kFrameWidget_DragTargetDrop_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::DragTargetDrop",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::DragTargetDrop");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_DragTargetDrop_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_DragTargetDrop_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::DragDataPtr p_drag_data{};
      ::gfx::PointF p_point_in_viewport{};
      ::gfx::PointF p_screen_point{};
      uint32_t p_key_modifiers{};
      FrameWidget_DragTargetDrop_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDragData(&p_drag_data))
        success = false;
      if (success && !input_data_view.ReadPointInViewport(&p_point_in_viewport))
        success = false;
      if (success && !input_data_view.ReadScreenPoint(&p_screen_point))
        success = false;
      if (success)
        p_key_modifiers = input_data_view.key_modifiers();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragTargetDrop(
std::move(p_drag_data), 
std::move(p_point_in_viewport), 
std::move(p_screen_point), 
std::move(p_key_modifiers));
      return true;
    }
    case internal::kFrameWidget_DragSourceEndedAt_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::DragSourceEndedAt",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::DragSourceEndedAt");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_DragSourceEndedAt_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_DragSourceEndedAt_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::PointF p_point_in_viewport{};
      ::gfx::PointF p_screen_point{};
      ::blink::DragOperation p_drag_operation{};
      FrameWidget_DragSourceEndedAt_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPointInViewport(&p_point_in_viewport))
        success = false;
      if (success && !input_data_view.ReadScreenPoint(&p_screen_point))
        success = false;
      if (success && !input_data_view.ReadDragOperation(&p_drag_operation))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragSourceEndedAt(
std::move(p_point_in_viewport), 
std::move(p_screen_point), 
std::move(p_drag_operation));
      return true;
    }
    case internal::kFrameWidget_DragSourceSystemDragEnded_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::DragSourceSystemDragEnded",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::DragSourceSystemDragEnded");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_DragSourceSystemDragEnded_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_DragSourceSystemDragEnded_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidget_DragSourceSystemDragEnded_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragSourceSystemDragEnded();
      return true;
    }
    case internal::kFrameWidget_SetBackgroundOpaque_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::SetBackgroundOpaque",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::SetBackgroundOpaque");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_SetBackgroundOpaque_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_SetBackgroundOpaque_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_opaque{};
      FrameWidget_SetBackgroundOpaque_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_opaque = input_data_view.opaque();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBackgroundOpaque(
std::move(p_opaque));
      return true;
    }
    case internal::kFrameWidget_SetTextDirection_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::SetTextDirection",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::SetTextDirection");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_SetTextDirection_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_SetTextDirection_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::i18n::TextDirection p_direction{};
      FrameWidget_SetTextDirection_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDirection(&p_direction))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetTextDirection(
std::move(p_direction));
      return true;
    }
    case internal::kFrameWidget_SetActive_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::SetActive",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::SetActive");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_SetActive_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_SetActive_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_active{};
      FrameWidget_SetActive_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_active = input_data_view.active();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetActive(
std::move(p_active));
      return true;
    }
    case internal::kFrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::SetInheritedEffectiveTouchActionForSubFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::SetInheritedEffectiveTouchActionForSubFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::cc::TouchAction p_touch_action{};
      FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTouchAction(&p_touch_action))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetInheritedEffectiveTouchActionForSubFrame(
std::move(p_touch_action));
      return true;
    }
    case internal::kFrameWidget_UpdateRenderThrottlingStatusForSubFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::UpdateRenderThrottlingStatusForSubFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::UpdateRenderThrottlingStatusForSubFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_is_throttled{};
      bool p_subtree_throttled{};
      FrameWidget_UpdateRenderThrottlingStatusForSubFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_is_throttled = input_data_view.is_throttled();
      if (success)
        p_subtree_throttled = input_data_view.subtree_throttled();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 9, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateRenderThrottlingStatusForSubFrame(
std::move(p_is_throttled), 
std::move(p_subtree_throttled));
      return true;
    }
    case internal::kFrameWidget_SetIsInertForSubFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::SetIsInertForSubFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::SetIsInertForSubFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_SetIsInertForSubFrame_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_SetIsInertForSubFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      bool p_inert{};
      FrameWidget_SetIsInertForSubFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_inert = input_data_view.inert();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 10, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetIsInertForSubFrame(
std::move(p_inert));
      return true;
    }
    case internal::kFrameWidget_ShowContextMenu_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::ShowContextMenu",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::ShowContextMenu");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_ShowContextMenu_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_ShowContextMenu_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::ui::MenuSourceType p_source_type{};
      ::gfx::Point p_location{};
      FrameWidget_ShowContextMenu_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSourceType(&p_source_type))
        success = false;
      if (success && !input_data_view.ReadLocation(&p_location))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 11, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ShowContextMenu(
std::move(p_source_type), 
std::move(p_location));
      return true;
    }
    case internal::kFrameWidget_EnableDeviceEmulation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::EnableDeviceEmulation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::EnableDeviceEmulation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_EnableDeviceEmulation_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_EnableDeviceEmulation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::DeviceEmulationParams p_parameters{};
      FrameWidget_EnableDeviceEmulation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadParameters(&p_parameters))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 12, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->EnableDeviceEmulation(
std::move(p_parameters));
      return true;
    }
    case internal::kFrameWidget_DisableDeviceEmulation_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::DisableDeviceEmulation",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::DisableDeviceEmulation");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_DisableDeviceEmulation_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_DisableDeviceEmulation_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidget_DisableDeviceEmulation_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 13, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DisableDeviceEmulation();
      return true;
    }
    case internal::kFrameWidget_BindWidgetCompositor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::BindWidgetCompositor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::BindWidgetCompositor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_BindWidgetCompositor_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_BindWidgetCompositor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<WidgetCompositor> p_host{};
      FrameWidget_BindWidgetCompositor_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 14, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindWidgetCompositor(
std::move(p_host));
      return true;
    }
    case internal::kFrameWidget_BindInputTargetClient_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::BindInputTargetClient",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::BindInputTargetClient");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidget_BindInputTargetClient_Params_Data* params =
          reinterpret_cast<internal::FrameWidget_BindInputTargetClient_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::viz::mojom::InputTargetClient> p_host{};
      FrameWidget_BindInputTargetClient_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 15, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->BindInputTargetClient(
std::move(p_host));
      return true;
    }
  }
  return false;
}

// static
bool FrameWidgetStubDispatch::AcceptWithResponder(
    FrameWidget* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameWidget_DragTargetDragOver_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidget::DragTargetDragOver",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidget::DragTargetDragOver");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::FrameWidget_DragTargetDragOver_Params_Data* params =
          reinterpret_cast<
              internal::FrameWidget_DragTargetDragOver_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::PointF p_point_in_viewport{};
      ::gfx::PointF p_screen_point{};
      ::blink::DragOperationsMask p_operations_allowed{};
      uint32_t p_key_modifiers{};
      FrameWidget_DragTargetDragOver_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPointInViewport(&p_point_in_viewport))
        success = false;
      if (success && !input_data_view.ReadScreenPoint(&p_screen_point))
        success = false;
      if (success && !input_data_view.ReadOperationsAllowed(&p_operations_allowed))
        success = false;
      if (success)
        p_key_modifiers = input_data_view.key_modifiers();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidget::Name_, 0, false);
        return false;
      }
      FrameWidget::DragTargetDragOverCallback callback =
          FrameWidget_DragTargetDragOver_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DragTargetDragOver(
std::move(p_point_in_viewport), 
std::move(p_screen_point), 
std::move(p_operations_allowed), 
std::move(p_key_modifiers), std::move(callback));
      return true;
    }
    case internal::kFrameWidget_DragTargetDragLeave_Name: {
      break;
    }
    case internal::kFrameWidget_DragTargetDrop_Name: {
      break;
    }
    case internal::kFrameWidget_DragSourceEndedAt_Name: {
      break;
    }
    case internal::kFrameWidget_DragSourceSystemDragEnded_Name: {
      break;
    }
    case internal::kFrameWidget_SetBackgroundOpaque_Name: {
      break;
    }
    case internal::kFrameWidget_SetTextDirection_Name: {
      break;
    }
    case internal::kFrameWidget_SetActive_Name: {
      break;
    }
    case internal::kFrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Name: {
      break;
    }
    case internal::kFrameWidget_UpdateRenderThrottlingStatusForSubFrame_Name: {
      break;
    }
    case internal::kFrameWidget_SetIsInertForSubFrame_Name: {
      break;
    }
    case internal::kFrameWidget_ShowContextMenu_Name: {
      break;
    }
    case internal::kFrameWidget_EnableDeviceEmulation_Name: {
      break;
    }
    case internal::kFrameWidget_DisableDeviceEmulation_Name: {
      break;
    }
    case internal::kFrameWidget_BindWidgetCompositor_Name: {
      break;
    }
    case internal::kFrameWidget_BindInputTargetClient_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFrameWidgetValidationInfo[] = {
    {&internal::FrameWidget_DragTargetDragOver_Params_Data::Validate,
     &internal::FrameWidget_DragTargetDragOver_ResponseParams_Data::Validate},
    {&internal::FrameWidget_DragTargetDragLeave_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_DragTargetDrop_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_DragSourceEndedAt_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_DragSourceSystemDragEnded_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_SetBackgroundOpaque_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_SetTextDirection_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_SetActive_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_SetInheritedEffectiveTouchActionForSubFrame_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_UpdateRenderThrottlingStatusForSubFrame_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_SetIsInertForSubFrame_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_ShowContextMenu_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_EnableDeviceEmulation_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_DisableDeviceEmulation_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_BindWidgetCompositor_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidget_BindInputTargetClient_Params_Data::Validate,
     nullptr /* no response */},
};

bool FrameWidgetRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FrameWidget::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFrameWidgetValidationInfo);
}

bool FrameWidgetResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FrameWidget::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kFrameWidgetValidationInfo);
}
const char FrameWidgetHost::Name_[] = "blink.mojom.FrameWidgetHost";

FrameWidgetHostProxy::FrameWidgetHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void FrameWidgetHostProxy::AnimateDoubleTapZoomInMainFrame(
    const ::gfx::Point& in_tap_point, const ::gfx::Rect& in_rect_to_zoom) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetHost::AnimateDoubleTapZoomInMainFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("tap_point", base::trace_event::ValueToString(in_tap_point, "<value of type const ::gfx::Point&>"));
      raw_value->SetString("rect_to_zoom", base::trace_event::ValueToString(in_rect_to_zoom, "<value of type const ::gfx::Rect&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->tap_point)::BaseType::BufferWriter
      tap_point_writer;
  mojo::internal::Serialize<::gfx::mojom::PointDataView>(
      in_tap_point, buffer, &tap_point_writer, &serialization_context);
  params->tap_point.Set(
      tap_point_writer.is_null() ? nullptr : tap_point_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->tap_point.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tap_point in FrameWidgetHost.AnimateDoubleTapZoomInMainFrame request");
  typename decltype(params->rect_to_zoom)::BaseType::BufferWriter
      rect_to_zoom_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect_to_zoom, buffer, &rect_to_zoom_writer, &serialization_context);
  params->rect_to_zoom.Set(
      rect_to_zoom_writer.is_null() ? nullptr : rect_to_zoom_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect_to_zoom.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect_to_zoom in FrameWidgetHost.AnimateDoubleTapZoomInMainFrame request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("AnimateDoubleTapZoomInMainFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetHostProxy::ZoomToFindInPageRectInMainFrame(
    const ::gfx::Rect& in_rect_to_zoom) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetHost::ZoomToFindInPageRectInMainFrame", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("rect_to_zoom", base::trace_event::ValueToString(in_rect_to_zoom, "<value of type const ::gfx::Rect&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidgetHost_ZoomToFindInPageRectInMainFrame_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->rect_to_zoom)::BaseType::BufferWriter
      rect_to_zoom_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_rect_to_zoom, buffer, &rect_to_zoom_writer, &serialization_context);
  params->rect_to_zoom.Set(
      rect_to_zoom_writer.is_null() ? nullptr : rect_to_zoom_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->rect_to_zoom.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null rect_to_zoom in FrameWidgetHost.ZoomToFindInPageRectInMainFrame request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("ZoomToFindInPageRectInMainFrame");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetHostProxy::SetHasTouchEventConsumers(
    ::blink::mojom::TouchEventConsumersPtr in_touch_event_consumers) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetHost::SetHasTouchEventConsumers", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_touch_event_consumers.is_null()) {
        raw_value->SetString("touch_event_consumers", "nullptr");
      } else {
        raw_value->BeginDictionary("touch_event_consumers");
        in_touch_event_consumers->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidgetHost_SetHasTouchEventConsumers_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidgetHost_SetHasTouchEventConsumers_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->touch_event_consumers)::BaseType::BufferWriter
      touch_event_consumers_writer;
  mojo::internal::Serialize<::blink::mojom::TouchEventConsumersDataView>(
      in_touch_event_consumers, buffer, &touch_event_consumers_writer, &serialization_context);
  params->touch_event_consumers.Set(
      touch_event_consumers_writer.is_null() ? nullptr : touch_event_consumers_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->touch_event_consumers.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null touch_event_consumers in FrameWidgetHost.SetHasTouchEventConsumers request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("SetHasTouchEventConsumers");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetHostProxy::IntrinsicSizingInfoChanged(
    ::blink::mojom::IntrinsicSizingInfoPtr in_sizing_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetHost::IntrinsicSizingInfoChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_sizing_info.is_null()) {
        raw_value->SetString("sizing_info", "nullptr");
      } else {
        raw_value->BeginDictionary("sizing_info");
        in_sizing_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidgetHost_IntrinsicSizingInfoChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidgetHost_IntrinsicSizingInfoChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->sizing_info)::BaseType::BufferWriter
      sizing_info_writer;
  mojo::internal::Serialize<::blink::mojom::IntrinsicSizingInfoDataView>(
      in_sizing_info, buffer, &sizing_info_writer, &serialization_context);
  params->sizing_info.Set(
      sizing_info_writer.is_null() ? nullptr : sizing_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->sizing_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null sizing_info in FrameWidgetHost.IntrinsicSizingInfoChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("IntrinsicSizingInfoChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetHostProxy::AutoscrollStart(
    const ::gfx::PointF& in_position) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetHost::AutoscrollStart", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("position", base::trace_event::ValueToString(in_position, "<value of type const ::gfx::PointF&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidgetHost_AutoscrollStart_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidgetHost_AutoscrollStart_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->position)::BaseType::BufferWriter
      position_writer;
  mojo::internal::Serialize<::gfx::mojom::PointFDataView>(
      in_position, buffer, &position_writer, &serialization_context);
  params->position.Set(
      position_writer.is_null() ? nullptr : position_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->position.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null position in FrameWidgetHost.AutoscrollStart request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("AutoscrollStart");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetHostProxy::AutoscrollFling(
    const ::gfx::Vector2dF& in_velocity) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetHost::AutoscrollFling", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("velocity", base::trace_event::ValueToString(in_velocity, "<value of type const ::gfx::Vector2dF&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidgetHost_AutoscrollFling_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidgetHost_AutoscrollFling_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->velocity)::BaseType::BufferWriter
      velocity_writer;
  mojo::internal::Serialize<::gfx::mojom::Vector2dFDataView>(
      in_velocity, buffer, &velocity_writer, &serialization_context);
  params->velocity.Set(
      velocity_writer.is_null() ? nullptr : velocity_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->velocity.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null velocity in FrameWidgetHost.AutoscrollFling request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("AutoscrollFling");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetHostProxy::AutoscrollEnd(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetHost::AutoscrollEnd");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidgetHost_AutoscrollEnd_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidgetHost_AutoscrollEnd_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("AutoscrollEnd");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetHostProxy::DidFirstVisuallyNonEmptyPaint(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::FrameWidgetHost::DidFirstVisuallyNonEmptyPaint");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidgetHost_DidFirstVisuallyNonEmptyPaint_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidgetHost_DidFirstVisuallyNonEmptyPaint_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("DidFirstVisuallyNonEmptyPaint");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void FrameWidgetHostProxy::StartDragging(
    ::blink::mojom::DragDataPtr in_drag_data, ::blink::DragOperationsMask in_operations_allowed, const ::SkBitmap& in_image, const ::gfx::Vector2d& in_bitmap_offset_in_dip, ::blink::mojom::DragEventSourceInfoPtr in_event_info) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::FrameWidgetHost::StartDragging", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_drag_data.is_null()) {
        raw_value->SetString("drag_data", "nullptr");
      } else {
        raw_value->BeginDictionary("drag_data");
        in_drag_data->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("operations_allowed", base::trace_event::ValueToString(in_operations_allowed, "<value of type ::blink::DragOperationsMask>"));
      raw_value->SetString("image", base::trace_event::ValueToString(in_image, "<value of type const ::SkBitmap&>"));
      raw_value->SetString("bitmap_offset_in_dip", base::trace_event::ValueToString(in_bitmap_offset_in_dip, "<value of type const ::gfx::Vector2d&>"));
      if (in_event_info.is_null()) {
        raw_value->SetString("event_info", "nullptr");
      } else {
        raw_value->BeginDictionary("event_info");
        in_event_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kFrameWidgetHost_StartDragging_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::FrameWidgetHost_StartDragging_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->drag_data)::BaseType::BufferWriter
      drag_data_writer;
  mojo::internal::Serialize<::blink::mojom::DragDataDataView>(
      in_drag_data, buffer, &drag_data_writer, &serialization_context);
  params->drag_data.Set(
      drag_data_writer.is_null() ? nullptr : drag_data_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->drag_data.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null drag_data in FrameWidgetHost.StartDragging request");
  typename decltype(params->operations_allowed)::BaseType::BufferWriter
      operations_allowed_writer;
  mojo::internal::Serialize<::blink::mojom::AllowedDragOperationsDataView>(
      in_operations_allowed, buffer, &operations_allowed_writer, &serialization_context);
  params->operations_allowed.Set(
      operations_allowed_writer.is_null() ? nullptr : operations_allowed_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->operations_allowed.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null operations_allowed in FrameWidgetHost.StartDragging request");
  typename decltype(params->image)::BaseType::BufferWriter
      image_writer;
  mojo::internal::Serialize<::skia::mojom::BitmapDataView>(
      in_image, buffer, &image_writer, &serialization_context);
  params->image.Set(
      image_writer.is_null() ? nullptr : image_writer.data());
  typename decltype(params->bitmap_offset_in_dip)::BaseType::BufferWriter
      bitmap_offset_in_dip_writer;
  mojo::internal::Serialize<::gfx::mojom::Vector2dDataView>(
      in_bitmap_offset_in_dip, buffer, &bitmap_offset_in_dip_writer, &serialization_context);
  params->bitmap_offset_in_dip.Set(
      bitmap_offset_in_dip_writer.is_null() ? nullptr : bitmap_offset_in_dip_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->bitmap_offset_in_dip.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null bitmap_offset_in_dip in FrameWidgetHost.StartDragging request");
  typename decltype(params->event_info)::BaseType::BufferWriter
      event_info_writer;
  mojo::internal::Serialize<::blink::mojom::DragEventSourceInfoDataView>(
      in_event_info, buffer, &event_info_writer, &serialization_context);
  params->event_info.Set(
      event_info_writer.is_null() ? nullptr : event_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->event_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null event_info in FrameWidgetHost.StartDragging request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(FrameWidgetHost::Name_);
  message.set_method_name("StartDragging");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool FrameWidgetHostStubDispatch::Accept(
    FrameWidgetHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kFrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetHost::AnimateDoubleTapZoomInMainFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetHost::AnimateDoubleTapZoomInMainFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Point p_tap_point{};
      ::gfx::Rect p_rect_to_zoom{};
      FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTapPoint(&p_tap_point))
        success = false;
      if (success && !input_data_view.ReadRectToZoom(&p_rect_to_zoom))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AnimateDoubleTapZoomInMainFrame(
std::move(p_tap_point), 
std::move(p_rect_to_zoom));
      return true;
    }
    case internal::kFrameWidgetHost_ZoomToFindInPageRectInMainFrame_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetHost::ZoomToFindInPageRectInMainFrame",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetHost::ZoomToFindInPageRectInMainFrame");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_rect_to_zoom{};
      FrameWidgetHost_ZoomToFindInPageRectInMainFrame_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRectToZoom(&p_rect_to_zoom))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ZoomToFindInPageRectInMainFrame(
std::move(p_rect_to_zoom));
      return true;
    }
    case internal::kFrameWidgetHost_SetHasTouchEventConsumers_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetHost::SetHasTouchEventConsumers",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetHost::SetHasTouchEventConsumers");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_SetHasTouchEventConsumers_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_SetHasTouchEventConsumers_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::TouchEventConsumersPtr p_touch_event_consumers{};
      FrameWidgetHost_SetHasTouchEventConsumers_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTouchEventConsumers(&p_touch_event_consumers))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetHasTouchEventConsumers(
std::move(p_touch_event_consumers));
      return true;
    }
    case internal::kFrameWidgetHost_IntrinsicSizingInfoChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetHost::IntrinsicSizingInfoChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetHost::IntrinsicSizingInfoChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_IntrinsicSizingInfoChanged_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_IntrinsicSizingInfoChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::IntrinsicSizingInfoPtr p_sizing_info{};
      FrameWidgetHost_IntrinsicSizingInfoChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadSizingInfo(&p_sizing_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->IntrinsicSizingInfoChanged(
std::move(p_sizing_info));
      return true;
    }
    case internal::kFrameWidgetHost_AutoscrollStart_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetHost::AutoscrollStart",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetHost::AutoscrollStart");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_AutoscrollStart_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_AutoscrollStart_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::PointF p_position{};
      FrameWidgetHost_AutoscrollStart_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadPosition(&p_position))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AutoscrollStart(
std::move(p_position));
      return true;
    }
    case internal::kFrameWidgetHost_AutoscrollFling_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetHost::AutoscrollFling",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetHost::AutoscrollFling");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_AutoscrollFling_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_AutoscrollFling_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Vector2dF p_velocity{};
      FrameWidgetHost_AutoscrollFling_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadVelocity(&p_velocity))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AutoscrollFling(
std::move(p_velocity));
      return true;
    }
    case internal::kFrameWidgetHost_AutoscrollEnd_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetHost::AutoscrollEnd",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetHost::AutoscrollEnd");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_AutoscrollEnd_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_AutoscrollEnd_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetHost_AutoscrollEnd_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 6, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->AutoscrollEnd();
      return true;
    }
    case internal::kFrameWidgetHost_DidFirstVisuallyNonEmptyPaint_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetHost::DidFirstVisuallyNonEmptyPaint",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetHost::DidFirstVisuallyNonEmptyPaint");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_DidFirstVisuallyNonEmptyPaint_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_DidFirstVisuallyNonEmptyPaint_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      FrameWidgetHost_DidFirstVisuallyNonEmptyPaint_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 7, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->DidFirstVisuallyNonEmptyPaint();
      return true;
    }
    case internal::kFrameWidgetHost_StartDragging_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::FrameWidgetHost::StartDragging",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::FrameWidgetHost::StartDragging");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::FrameWidgetHost_StartDragging_Params_Data* params =
          reinterpret_cast<internal::FrameWidgetHost_StartDragging_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::DragDataPtr p_drag_data{};
      ::blink::DragOperationsMask p_operations_allowed{};
      ::SkBitmap p_image{};
      ::gfx::Vector2d p_bitmap_offset_in_dip{};
      ::blink::mojom::DragEventSourceInfoPtr p_event_info{};
      FrameWidgetHost_StartDragging_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadDragData(&p_drag_data))
        success = false;
      if (success && !input_data_view.ReadOperationsAllowed(&p_operations_allowed))
        success = false;
      if (success && !input_data_view.ReadImage(&p_image))
        success = false;
      if (success && !input_data_view.ReadBitmapOffsetInDip(&p_bitmap_offset_in_dip))
        success = false;
      if (success && !input_data_view.ReadEventInfo(&p_event_info))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            FrameWidgetHost::Name_, 8, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->StartDragging(
std::move(p_drag_data), 
std::move(p_operations_allowed), 
std::move(p_image), 
std::move(p_bitmap_offset_in_dip), 
std::move(p_event_info));
      return true;
    }
  }
  return false;
}

// static
bool FrameWidgetHostStubDispatch::AcceptWithResponder(
    FrameWidgetHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kFrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Name: {
      break;
    }
    case internal::kFrameWidgetHost_ZoomToFindInPageRectInMainFrame_Name: {
      break;
    }
    case internal::kFrameWidgetHost_SetHasTouchEventConsumers_Name: {
      break;
    }
    case internal::kFrameWidgetHost_IntrinsicSizingInfoChanged_Name: {
      break;
    }
    case internal::kFrameWidgetHost_AutoscrollStart_Name: {
      break;
    }
    case internal::kFrameWidgetHost_AutoscrollFling_Name: {
      break;
    }
    case internal::kFrameWidgetHost_AutoscrollEnd_Name: {
      break;
    }
    case internal::kFrameWidgetHost_DidFirstVisuallyNonEmptyPaint_Name: {
      break;
    }
    case internal::kFrameWidgetHost_StartDragging_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kFrameWidgetHostValidationInfo[] = {
    {&internal::FrameWidgetHost_AnimateDoubleTapZoomInMainFrame_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetHost_ZoomToFindInPageRectInMainFrame_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetHost_SetHasTouchEventConsumers_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetHost_IntrinsicSizingInfoChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetHost_AutoscrollStart_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetHost_AutoscrollFling_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetHost_AutoscrollEnd_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetHost_DidFirstVisuallyNonEmptyPaint_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::FrameWidgetHost_StartDragging_Params_Data::Validate,
     nullptr /* no response */},
};

bool FrameWidgetHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::FrameWidgetHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kFrameWidgetHostValidationInfo);
}

const char Widget::Name_[] = "blink.mojom.Widget";

class Widget_ForceRedraw_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Widget_ForceRedraw_ForwardToCallback(
      Widget::ForceRedrawCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Widget::ForceRedrawCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Widget_ForceRedraw_ForwardToCallback);
};

class Widget_UpdateScreenRects_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  Widget_UpdateScreenRects_ForwardToCallback(
      Widget::UpdateScreenRectsCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  Widget::UpdateScreenRectsCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(Widget_UpdateScreenRects_ForwardToCallback);
};

WidgetProxy::WidgetProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WidgetProxy::ForceRedraw(
    ForceRedrawCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::Widget::ForceRedraw");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidget_ForceRedraw_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Widget_ForceRedraw_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("ForceRedraw");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Widget_ForceRedraw_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WidgetProxy::GetWidgetInputHandler(
    ::mojo::PendingReceiver<::blink::mojom::WidgetInputHandler> in_request, ::mojo::PendingRemote<::blink::mojom::WidgetInputHandlerHost> in_host) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Widget::GetWidgetInputHandler", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("request", in_request.is_valid());
      raw_value->SetBoolean("host", in_host.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidget_GetWidgetInputHandler_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Widget_GetWidgetInputHandler_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::WidgetInputHandlerInterfaceBase>>(
      in_request, &params->request, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->request),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid request in Widget.GetWidgetInputHandler request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::blink::mojom::WidgetInputHandlerHostInterfaceBase>>(
      in_host, &params->host, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->host),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid host in Widget.GetWidgetInputHandler request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("GetWidgetInputHandler");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetProxy::UpdateVisualProperties(
    const ::blink::VisualProperties& in_visual_properties) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Widget::UpdateVisualProperties", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("visual_properties", base::trace_event::ValueToString(in_visual_properties, "<value of type const ::blink::VisualProperties&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidget_UpdateVisualProperties_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Widget_UpdateVisualProperties_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->visual_properties)::BaseType::BufferWriter
      visual_properties_writer;
  mojo::internal::Serialize<::blink::mojom::VisualPropertiesDataView>(
      in_visual_properties, buffer, &visual_properties_writer, &serialization_context);
  params->visual_properties.Set(
      visual_properties_writer.is_null() ? nullptr : visual_properties_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->visual_properties.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null visual_properties in Widget.UpdateVisualProperties request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("UpdateVisualProperties");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetProxy::UpdateScreenRects(
    const ::gfx::Rect& in_widget_screen_rect, const ::gfx::Rect& in_window_screen_rect, UpdateScreenRectsCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Widget::UpdateScreenRects", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("widget_screen_rect", base::trace_event::ValueToString(in_widget_screen_rect, "<value of type const ::gfx::Rect&>"));
      raw_value->SetString("window_screen_rect", base::trace_event::ValueToString(in_window_screen_rect, "<value of type const ::gfx::Rect&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidget_UpdateScreenRects_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Widget_UpdateScreenRects_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->widget_screen_rect)::BaseType::BufferWriter
      widget_screen_rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_widget_screen_rect, buffer, &widget_screen_rect_writer, &serialization_context);
  params->widget_screen_rect.Set(
      widget_screen_rect_writer.is_null() ? nullptr : widget_screen_rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->widget_screen_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null widget_screen_rect in Widget.UpdateScreenRects request");
  typename decltype(params->window_screen_rect)::BaseType::BufferWriter
      window_screen_rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_window_screen_rect, buffer, &window_screen_rect_writer, &serialization_context);
  params->window_screen_rect.Set(
      window_screen_rect_writer.is_null() ? nullptr : window_screen_rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->window_screen_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null window_screen_rect in Widget.UpdateScreenRects request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("UpdateScreenRects");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new Widget_UpdateScreenRects_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}

void WidgetProxy::WasHidden(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::Widget::WasHidden");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidget_WasHidden_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Widget_WasHidden_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("WasHidden");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetProxy::WasShown(
    ::base::TimeTicks in_show_request_timestamp, bool in_was_evicted, ::blink::mojom::RecordContentToVisibleTimeRequestPtr in_record_tab_switch_time_request) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::Widget::WasShown", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("show_request_timestamp", base::trace_event::ValueToString(in_show_request_timestamp, "<value of type ::base::TimeTicks>"));
      raw_value->SetBoolean("was_evicted", in_was_evicted);
      if (in_record_tab_switch_time_request.is_null()) {
        raw_value->SetString("record_tab_switch_time_request", "nullptr");
      } else {
        raw_value->BeginDictionary("record_tab_switch_time_request");
        in_record_tab_switch_time_request->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidget_WasShown_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Widget_WasShown_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->show_request_timestamp)::BaseType::BufferWriter
      show_request_timestamp_writer;
  mojo::internal::Serialize<::mojo_base::mojom::TimeTicksDataView>(
      in_show_request_timestamp, buffer, &show_request_timestamp_writer, &serialization_context);
  params->show_request_timestamp.Set(
      show_request_timestamp_writer.is_null() ? nullptr : show_request_timestamp_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->show_request_timestamp.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null show_request_timestamp in Widget.WasShown request");
  params->was_evicted = in_was_evicted;
  typename decltype(params->record_tab_switch_time_request)::BaseType::BufferWriter
      record_tab_switch_time_request_writer;
  mojo::internal::Serialize<::blink::mojom::RecordContentToVisibleTimeRequestDataView>(
      in_record_tab_switch_time_request, buffer, &record_tab_switch_time_request_writer, &serialization_context);
  params->record_tab_switch_time_request.Set(
      record_tab_switch_time_request_writer.is_null() ? nullptr : record_tab_switch_time_request_writer.data());
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("WasShown");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}
class Widget_ForceRedraw_ProxyToResponder {
 public:
  static Widget::ForceRedrawCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Widget_ForceRedraw_ProxyToResponder> proxy(
        new Widget_ForceRedraw_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Widget_ForceRedraw_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Widget_ForceRedraw_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Widget_ForceRedraw_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Widget::ForceRedrawCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Widget_ForceRedraw_ProxyToResponder);
};

bool Widget_ForceRedraw_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Widget::ForceRedrawCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Widget_ForceRedraw_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Widget_ForceRedraw_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  Widget_ForceRedraw_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Widget::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Widget_ForceRedraw_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::Widget::ForceRedrawCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidget_ForceRedraw_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Widget_ForceRedraw_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Widget::ForceRedrawCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("ForceRedraw");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}
class Widget_UpdateScreenRects_ProxyToResponder {
 public:
  static Widget::UpdateScreenRectsCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<Widget_UpdateScreenRects_ProxyToResponder> proxy(
        new Widget_UpdateScreenRects_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&Widget_UpdateScreenRects_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~Widget_UpdateScreenRects_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  Widget_UpdateScreenRects_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "Widget::UpdateScreenRectsCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(Widget_UpdateScreenRects_ProxyToResponder);
};

bool Widget_UpdateScreenRects_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::Widget::UpdateScreenRectsCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::Widget_UpdateScreenRects_ResponseParams_Data* params =
      reinterpret_cast<
          internal::Widget_UpdateScreenRects_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  Widget_UpdateScreenRects_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        Widget::Name_, 3, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void Widget_UpdateScreenRects_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::Widget::UpdateScreenRectsCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidget_UpdateScreenRects_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::Widget_UpdateScreenRects_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::Widget::UpdateScreenRectsCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(Widget::Name_);
  message.set_method_name("UpdateScreenRects");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WidgetStubDispatch::Accept(
    Widget* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWidget_ForceRedraw_Name: {
      break;
    }
    case internal::kWidget_GetWidgetInputHandler_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Widget::GetWidgetInputHandler",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Widget::GetWidgetInputHandler");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Widget_GetWidgetInputHandler_Params_Data* params =
          reinterpret_cast<internal::Widget_GetWidgetInputHandler_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::blink::mojom::WidgetInputHandler> p_request{};
      ::mojo::PendingRemote<::blink::mojom::WidgetInputHandlerHost> p_host{};
      Widget_GetWidgetInputHandler_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_request =
            input_data_view.TakeRequest<decltype(p_request)>();
      }
      if (success) {
        p_host =
            input_data_view.TakeHost<decltype(p_host)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->GetWidgetInputHandler(
std::move(p_request), 
std::move(p_host));
      return true;
    }
    case internal::kWidget_UpdateVisualProperties_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Widget::UpdateVisualProperties",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Widget::UpdateVisualProperties");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Widget_UpdateVisualProperties_Params_Data* params =
          reinterpret_cast<internal::Widget_UpdateVisualProperties_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::VisualProperties p_visual_properties{};
      Widget_UpdateVisualProperties_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadVisualProperties(&p_visual_properties))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateVisualProperties(
std::move(p_visual_properties));
      return true;
    }
    case internal::kWidget_UpdateScreenRects_Name: {
      break;
    }
    case internal::kWidget_WasHidden_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Widget::WasHidden",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Widget::WasHidden");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Widget_WasHidden_Params_Data* params =
          reinterpret_cast<internal::Widget_WasHidden_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      Widget_WasHidden_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WasHidden();
      return true;
    }
    case internal::kWidget_WasShown_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Widget::WasShown",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Widget::WasShown");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::Widget_WasShown_Params_Data* params =
          reinterpret_cast<internal::Widget_WasShown_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::TimeTicks p_show_request_timestamp{};
      bool p_was_evicted{};
      ::blink::mojom::RecordContentToVisibleTimeRequestPtr p_record_tab_switch_time_request{};
      Widget_WasShown_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadShowRequestTimestamp(&p_show_request_timestamp))
        success = false;
      if (success)
        p_was_evicted = input_data_view.was_evicted();
      if (success && !input_data_view.ReadRecordTabSwitchTimeRequest(&p_record_tab_switch_time_request))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->WasShown(
std::move(p_show_request_timestamp), 
std::move(p_was_evicted), 
std::move(p_record_tab_switch_time_request));
      return true;
    }
  }
  return false;
}

// static
bool WidgetStubDispatch::AcceptWithResponder(
    Widget* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWidget_ForceRedraw_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Widget::ForceRedraw",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Widget::ForceRedraw");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Widget_ForceRedraw_Params_Data* params =
          reinterpret_cast<
              internal::Widget_ForceRedraw_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      Widget_ForceRedraw_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 0, false);
        return false;
      }
      Widget::ForceRedrawCallback callback =
          Widget_ForceRedraw_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ForceRedraw(std::move(callback));
      return true;
    }
    case internal::kWidget_GetWidgetInputHandler_Name: {
      break;
    }
    case internal::kWidget_UpdateVisualProperties_Name: {
      break;
    }
    case internal::kWidget_UpdateScreenRects_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::Widget::UpdateScreenRects",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::Widget::UpdateScreenRects");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::Widget_UpdateScreenRects_Params_Data* params =
          reinterpret_cast<
              internal::Widget_UpdateScreenRects_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_widget_screen_rect{};
      ::gfx::Rect p_window_screen_rect{};
      Widget_UpdateScreenRects_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadWidgetScreenRect(&p_widget_screen_rect))
        success = false;
      if (success && !input_data_view.ReadWindowScreenRect(&p_window_screen_rect))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            Widget::Name_, 3, false);
        return false;
      }
      Widget::UpdateScreenRectsCallback callback =
          Widget_UpdateScreenRects_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->UpdateScreenRects(
std::move(p_widget_screen_rect), 
std::move(p_window_screen_rect), std::move(callback));
      return true;
    }
    case internal::kWidget_WasHidden_Name: {
      break;
    }
    case internal::kWidget_WasShown_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWidgetValidationInfo[] = {
    {&internal::Widget_ForceRedraw_Params_Data::Validate,
     &internal::Widget_ForceRedraw_ResponseParams_Data::Validate},
    {&internal::Widget_GetWidgetInputHandler_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::Widget_UpdateVisualProperties_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::Widget_UpdateScreenRects_Params_Data::Validate,
     &internal::Widget_UpdateScreenRects_ResponseParams_Data::Validate},
    {&internal::Widget_WasHidden_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::Widget_WasShown_Params_Data::Validate,
     nullptr /* no response */},
};

bool WidgetRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::Widget::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWidgetValidationInfo);
}

bool WidgetResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::Widget::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kWidgetValidationInfo);
}
const char WidgetHost::Name_[] = "blink.mojom.WidgetHost";

WidgetHostProxy::WidgetHostProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WidgetHostProxy::SetCursor(
    const ::ui::Cursor& in_cursor) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetHost::SetCursor", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cursor", base::trace_event::ValueToString(in_cursor, "<value of type const ::ui::Cursor&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidgetHost_SetCursor_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::WidgetHost_SetCursor_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cursor)::BaseType::BufferWriter
      cursor_writer;
  mojo::internal::Serialize<::ui::mojom::CursorDataView>(
      in_cursor, buffer, &cursor_writer, &serialization_context);
  params->cursor.Set(
      cursor_writer.is_null() ? nullptr : cursor_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cursor.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cursor in WidgetHost.SetCursor request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("SetCursor");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetHostProxy::SetToolTipText(
    const ::base::string16& in_tooltip_text, ::base::i18n::TextDirection in_text_direction_hint) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetHost::SetToolTipText", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("tooltip_text", base::trace_event::ValueToString(in_tooltip_text, "<value of type const ::base::string16&>"));
      raw_value->SetInteger("text_direction_hint", static_cast<int>(in_text_direction_hint));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidgetHost_SetToolTipText_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::WidgetHost_SetToolTipText_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->tooltip_text)::BaseType::BufferWriter
      tooltip_text_writer;
  mojo::internal::Serialize<::mojo_base::mojom::String16DataView>(
      in_tooltip_text, buffer, &tooltip_text_writer, &serialization_context);
  params->tooltip_text.Set(
      tooltip_text_writer.is_null() ? nullptr : tooltip_text_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->tooltip_text.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null tooltip_text in WidgetHost.SetToolTipText request");
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
      in_text_direction_hint, &params->text_direction_hint);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("SetToolTipText");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetHostProxy::TextInputStateChanged(
    ::ui::mojom::TextInputStatePtr in_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetHost::TextInputStateChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_state.is_null()) {
        raw_value->SetString("state", "nullptr");
      } else {
        raw_value->BeginDictionary("state");
        in_state->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidgetHost_TextInputStateChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::WidgetHost_TextInputStateChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->state)::BaseType::BufferWriter
      state_writer;
  mojo::internal::Serialize<::ui::mojom::TextInputStateDataView>(
      in_state, buffer, &state_writer, &serialization_context);
  params->state.Set(
      state_writer.is_null() ? nullptr : state_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->state.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null state in WidgetHost.TextInputStateChanged request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("TextInputStateChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void WidgetHostProxy::SelectionBoundsChanged(
    const ::gfx::Rect& in_anchor_rect, ::base::i18n::TextDirection in_anchor_dir, const ::gfx::Rect& in_focus_rect, ::base::i18n::TextDirection in_focus_dir, bool in_is_anchor_first) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::WidgetHost::SelectionBoundsChanged", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("anchor_rect", base::trace_event::ValueToString(in_anchor_rect, "<value of type const ::gfx::Rect&>"));
      raw_value->SetInteger("anchor_dir", static_cast<int>(in_anchor_dir));
      raw_value->SetString("focus_rect", base::trace_event::ValueToString(in_focus_rect, "<value of type const ::gfx::Rect&>"));
      raw_value->SetInteger("focus_dir", static_cast<int>(in_focus_dir));
      raw_value->SetBoolean("is_anchor_first", in_is_anchor_first);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidgetHost_SelectionBoundsChanged_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::WidgetHost_SelectionBoundsChanged_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->anchor_rect)::BaseType::BufferWriter
      anchor_rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_anchor_rect, buffer, &anchor_rect_writer, &serialization_context);
  params->anchor_rect.Set(
      anchor_rect_writer.is_null() ? nullptr : anchor_rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->anchor_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null anchor_rect in WidgetHost.SelectionBoundsChanged request");
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
      in_anchor_dir, &params->anchor_dir);
  typename decltype(params->focus_rect)::BaseType::BufferWriter
      focus_rect_writer;
  mojo::internal::Serialize<::gfx::mojom::RectDataView>(
      in_focus_rect, buffer, &focus_rect_writer, &serialization_context);
  params->focus_rect.Set(
      focus_rect_writer.is_null() ? nullptr : focus_rect_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->focus_rect.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null focus_rect in WidgetHost.SelectionBoundsChanged request");
  mojo::internal::Serialize<::mojo_base::mojom::TextDirection>(
      in_focus_dir, &params->focus_dir);
  params->is_anchor_first = in_is_anchor_first;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetHost::Name_);
  message.set_method_name("SelectionBoundsChanged");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool WidgetHostStubDispatch::Accept(
    WidgetHost* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWidgetHost_SetCursor_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetHost::SetCursor",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetHost::SetCursor");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetHost_SetCursor_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_SetCursor_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::ui::Cursor p_cursor{};
      WidgetHost_SetCursor_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCursor(&p_cursor))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetCursor(
std::move(p_cursor));
      return true;
    }
    case internal::kWidgetHost_SetToolTipText_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetHost::SetToolTipText",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetHost::SetToolTipText");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetHost_SetToolTipText_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_SetToolTipText_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::string16 p_tooltip_text{};
      ::base::i18n::TextDirection p_text_direction_hint{};
      WidgetHost_SetToolTipText_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadTooltipText(&p_tooltip_text))
        success = false;
      if (success && !input_data_view.ReadTextDirectionHint(&p_text_direction_hint))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetToolTipText(
std::move(p_tooltip_text), 
std::move(p_text_direction_hint));
      return true;
    }
    case internal::kWidgetHost_TextInputStateChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetHost::TextInputStateChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetHost::TextInputStateChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetHost_TextInputStateChanged_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_TextInputStateChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::ui::mojom::TextInputStatePtr p_state{};
      WidgetHost_TextInputStateChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadState(&p_state))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->TextInputStateChanged(
std::move(p_state));
      return true;
    }
    case internal::kWidgetHost_SelectionBoundsChanged_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetHost::SelectionBoundsChanged",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetHost::SelectionBoundsChanged");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::WidgetHost_SelectionBoundsChanged_Params_Data* params =
          reinterpret_cast<internal::WidgetHost_SelectionBoundsChanged_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::gfx::Rect p_anchor_rect{};
      ::base::i18n::TextDirection p_anchor_dir{};
      ::gfx::Rect p_focus_rect{};
      ::base::i18n::TextDirection p_focus_dir{};
      bool p_is_anchor_first{};
      WidgetHost_SelectionBoundsChanged_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadAnchorRect(&p_anchor_rect))
        success = false;
      if (success && !input_data_view.ReadAnchorDir(&p_anchor_dir))
        success = false;
      if (success && !input_data_view.ReadFocusRect(&p_focus_rect))
        success = false;
      if (success && !input_data_view.ReadFocusDir(&p_focus_dir))
        success = false;
      if (success)
        p_is_anchor_first = input_data_view.is_anchor_first();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetHost::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SelectionBoundsChanged(
std::move(p_anchor_rect), 
std::move(p_anchor_dir), 
std::move(p_focus_rect), 
std::move(p_focus_dir), 
std::move(p_is_anchor_first));
      return true;
    }
  }
  return false;
}

// static
bool WidgetHostStubDispatch::AcceptWithResponder(
    WidgetHost* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWidgetHost_SetCursor_Name: {
      break;
    }
    case internal::kWidgetHost_SetToolTipText_Name: {
      break;
    }
    case internal::kWidgetHost_TextInputStateChanged_Name: {
      break;
    }
    case internal::kWidgetHost_SelectionBoundsChanged_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWidgetHostValidationInfo[] = {
    {&internal::WidgetHost_SetCursor_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetHost_SetToolTipText_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetHost_TextInputStateChanged_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::WidgetHost_SelectionBoundsChanged_Params_Data::Validate,
     nullptr /* no response */},
};

bool WidgetHostRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WidgetHost::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWidgetHostValidationInfo);
}

const char WidgetCompositor::Name_[] = "blink.mojom.WidgetCompositor";

class WidgetCompositor_VisualStateRequest_ForwardToCallback
    : public mojo::MessageReceiver {
 public:
  WidgetCompositor_VisualStateRequest_ForwardToCallback(
      WidgetCompositor::VisualStateRequestCallback callback
      ) : callback_(std::move(callback)) {
  }
  bool Accept(mojo::Message* message) override;
 private:
  WidgetCompositor::VisualStateRequestCallback callback_;
  DISALLOW_COPY_AND_ASSIGN(WidgetCompositor_VisualStateRequest_ForwardToCallback);
};

WidgetCompositorProxy::WidgetCompositorProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void WidgetCompositorProxy::VisualStateRequest(
    VisualStateRequestCallback callback) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::WidgetCompositor::VisualStateRequest");
#endif
  const bool kExpectsResponse = true;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidgetCompositor_VisualStateRequest_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::WidgetCompositor_VisualStateRequest_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetCompositor::Name_);
  message.set_method_name("VisualStateRequest");
#endif
  std::unique_ptr<mojo::MessageReceiver> responder(
      new WidgetCompositor_VisualStateRequest_ForwardToCallback(
          std::move(callback)));
  ignore_result(receiver_->AcceptWithResponder(&message, std::move(responder)));
}
class WidgetCompositor_VisualStateRequest_ProxyToResponder {
 public:
  static WidgetCompositor::VisualStateRequestCallback CreateCallback(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder) {
    std::unique_ptr<WidgetCompositor_VisualStateRequest_ProxyToResponder> proxy(
        new WidgetCompositor_VisualStateRequest_ProxyToResponder(
            request_id, is_sync, responder));
    return base::BindOnce(&WidgetCompositor_VisualStateRequest_ProxyToResponder::Run,
                          std::move(proxy));
  }

  ~WidgetCompositor_VisualStateRequest_ProxyToResponder() {
#if DCHECK_IS_ON()
    if (responder_) {
      // If we're being destroyed without being run, we want to ensure the
      // binding endpoint has been closed. This checks for that asynchronously.
      // We pass a bound generated callback to handle the response so that any
      // resulting DCHECK stack will have useful interface type information.
      responder_->IsConnectedAsync(base::BindOnce(&OnIsConnectedComplete));
    }
#endif
    // If the Callback was dropped then deleting the responder will close
    // the pipe so the calling application knows to stop waiting for a reply.
    responder_ = nullptr;
  }

 private:
  WidgetCompositor_VisualStateRequest_ProxyToResponder(
      uint64_t request_id,
      bool is_sync,
      std::unique_ptr<mojo::MessageReceiverWithStatus>* responder)
      : request_id_(request_id),
        is_sync_(is_sync),
        responder_(std::move(*responder)) {
  }

#if DCHECK_IS_ON()
  static void OnIsConnectedComplete(bool connected) {
//    DCHECK(!connected)
//        << "WidgetCompositor::VisualStateRequestCallback was destroyed without "
//        << "first either being run or its corresponding binding being closed. "
//        << "It is an error to drop response callbacks which still correspond "
//        << "to an open interface pipe.";
  }
#endif

  void Run(
      );

  uint64_t request_id_;
  bool is_sync_;
  std::unique_ptr<mojo::MessageReceiverWithStatus> responder_;

  DISALLOW_COPY_AND_ASSIGN(WidgetCompositor_VisualStateRequest_ProxyToResponder);
};

bool WidgetCompositor_VisualStateRequest_ForwardToCallback::Accept(
    mojo::Message* message) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1("mojom", "blink::mojom::WidgetCompositor::VisualStateRequestCallback",
               "message", message->name());
#endif
  mojo::internal::MessageDispatchContext dispatch_context(message);

  DCHECK(message->is_serialized());
  internal::WidgetCompositor_VisualStateRequest_ResponseParams_Data* params =
      reinterpret_cast<
          internal::WidgetCompositor_VisualStateRequest_ResponseParams_Data*>(
              message->mutable_payload());
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  
  bool success = true;
  WidgetCompositor_VisualStateRequest_ResponseParamsDataView input_data_view(params, &serialization_context);
  
  if (!success) {
    ReportValidationErrorForMessage(
        message,
        mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
        WidgetCompositor::Name_, 0, true);
    return false;
  }
  if (!callback_.is_null())
    std::move(callback_).Run();
  return true;
}

void WidgetCompositor_VisualStateRequest_ProxyToResponder::Run(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_BEGIN0("mojom", "(Impl)blink::mojom::WidgetCompositor::VisualStateRequestCallback");
#endif
  
  const uint32_t kFlags = mojo::Message::kFlagIsResponse |
      ((is_sync_) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kWidgetCompositor_VisualStateRequest_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::WidgetCompositor_VisualStateRequest_ResponseParams_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT_END1("mojom", "(Impl)blink::mojom::WidgetCompositor::VisualStateRequestCallback", "message",
                   message.name());
#endif

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(WidgetCompositor::Name_);
  message.set_method_name("VisualStateRequest");
#endif

  message.set_request_id(request_id_);
  ignore_result(responder_->Accept(&message));
  // TODO(darin): Accept() returning false indicates a malformed message, and
  // that may be good reason to close the connection. However, we don't have a
  // way to do that from here. We should add a way.
  responder_ = nullptr;
}

// static
bool WidgetCompositorStubDispatch::Accept(
    WidgetCompositor* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kWidgetCompositor_VisualStateRequest_Name: {
      break;
    }
  }
  return false;
}

// static
bool WidgetCompositorStubDispatch::AcceptWithResponder(
    WidgetCompositor* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kWidgetCompositor_VisualStateRequest_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::WidgetCompositor::VisualStateRequest",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::WidgetCompositor::VisualStateRequest");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      internal::WidgetCompositor_VisualStateRequest_Params_Data* params =
          reinterpret_cast<
              internal::WidgetCompositor_VisualStateRequest_Params_Data*>(
                  message->mutable_payload());
      
      bool success = true;
      WidgetCompositor_VisualStateRequest_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            WidgetCompositor::Name_, 0, false);
        return false;
      }
      WidgetCompositor::VisualStateRequestCallback callback =
          WidgetCompositor_VisualStateRequest_ProxyToResponder::CreateCallback(
              message->request_id(), message_is_sync, &responder);
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->VisualStateRequest(std::move(callback));
      return true;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kWidgetCompositorValidationInfo[] = {
    {&internal::WidgetCompositor_VisualStateRequest_Params_Data::Validate,
     &internal::WidgetCompositor_VisualStateRequest_ResponseParams_Data::Validate},
};

bool WidgetCompositorRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WidgetCompositor::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kWidgetCompositorValidationInfo);
}

bool WidgetCompositorResponseValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::WidgetCompositor::Name_;
  return mojo::internal::ValidateResponseGenericPacked(message, name, kWidgetCompositorValidationInfo);
}
}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif