/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1beta2

import (
	resource "k8s.io/apimachinery/pkg/api/resource"
)

// DeviceCapacityApplyConfiguration represents a declarative configuration of the DeviceCapacity type for use
// with apply.
//
// DeviceCapacity describes a quantity associated with a device.
type DeviceCapacityApplyConfiguration struct {
	// Value defines how much of a certain capacity that device has.
	//
	// This field reflects the fixed total capacity and does not change.
	// The consumed amount is tracked separately by scheduler
	// and does not affect this value.
	Value *resource.Quantity `json:"value,omitempty"`
	// RequestPolicy defines how this DeviceCapacity must be consumed
	// when the device is allowed to be shared by multiple allocations.
	//
	// The Device must have allowMultipleAllocations set to true in order to set a requestPolicy.
	//
	// If unset, capacity requests are unconstrained:
	// requests can consume any amount of capacity, as long as the total consumed
	// across all allocations does not exceed the device's defined capacity.
	// If request is also unset, default is the full capacity value.
	RequestPolicy *CapacityRequestPolicyApplyConfiguration `json:"requestPolicy,omitempty"`
}

// DeviceCapacityApplyConfiguration constructs a declarative configuration of the DeviceCapacity type for use with
// apply.
func DeviceCapacity() *DeviceCapacityApplyConfiguration {
	return &DeviceCapacityApplyConfiguration{}
}

// WithValue sets the Value field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Value field is set to the value of the last call.
func (b *DeviceCapacityApplyConfiguration) WithValue(value resource.Quantity) *DeviceCapacityApplyConfiguration {
	b.Value = &value
	return b
}

// WithRequestPolicy sets the RequestPolicy field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the RequestPolicy field is set to the value of the last call.
func (b *DeviceCapacityApplyConfiguration) WithRequestPolicy(value *CapacityRequestPolicyApplyConfiguration) *DeviceCapacityApplyConfiguration {
	b.RequestPolicy = value
	return b
}
