const char metrics_tarantool_memtx_lua[] =
"local utils = require('metrics.utils')\n"
"\n"
"local collectors_list = {}\n"
"\n"
"local function update()\n"
"    if not utils.box_is_configured() then\n"
"        return\n"
"    end\n"
"\n"
"    if box.stat.memtx == nil or box.stat.memtx.tx == nil then\n"
"        return\n"
"    end\n"
"\n"
"    local memtx_stat = box.stat.memtx.tx()\n"
"\n"
"    collectors_list.memtx_tnx_statements =\n"
"        utils.set_gauge('memtx_tnx_statements', 'Maximum number of bytes used by one transaction for statements',\n"
"            memtx_stat.txn.statements.max, {kind = \"max\"}, nil, {default = true})\n"
"    collectors_list.memtx_tnx_statements =\n"
"        utils.set_gauge('memtx_tnx_statements', 'Average bytes used by transactions for statements',\n"
"            memtx_stat.txn.statements.avg, {kind = \"average\"}, nil, {default = true})\n"
"    collectors_list.memtx_tnx_statements =\n"
"        utils.set_gauge('memtx_tnx_statements',\n"
"            'The number of bytes that are allocated for the statements of all current transactions',\n"
"            memtx_stat.txn.statements.total, {kind = \"total\"}, nil, {default = true})\n"
"\n"
"    collectors_list.memtx_tnx_user =\n"
"        utils.set_gauge('memtx_tnx_user',\n"
"            'The maximum number of bytes allocated by `box_txn_alloc()` function per transaction',\n"
"            memtx_stat.txn.user.max, {kind = \"max\"}, nil, {default = true})\n"
"    collectors_list.memtx_tnx_user =\n"
"        utils.set_gauge('memtx_tnx_user', 'Transaction average (total memory / number of all current transactions)',\n"
"            memtx_stat.txn.user.avg, {kind = \"average\"}, nil, {default = true})\n"
"    collectors_list.memtx_tnx_user =\n"
"        utils.set_gauge('memtx_tnx_user',\n"
"            'Memory allocated by the `box_txn_alloc()` function on all current transactions',\n"
"            memtx_stat.txn.user.total, {kind = \"total\"}, nil, {default = true})\n"
"\n"
"    collectors_list.memtx_tnx_system =\n"
"        utils.set_gauge('memtx_tnx_system', 'The maximum number of bytes allocated by internals per transaction',\n"
"            memtx_stat.txn.system.max, {kind = \"max\"}, nil, {default = true})\n"
"    collectors_list.memtx_tnx_system =\n"
"        utils.set_gauge('memtx_tnx_system',\n"
"            'Average allocated memory by internals (total memory / number of all current transactions)',\n"
"            memtx_stat.txn.system.avg, {kind = \"average\"}, nil, {default = true})\n"
"    collectors_list.memtx_tnx_system =\n"
"        utils.set_gauge('memtx_tnx_system', 'Memory allocated by internals on all  transactions',\n"
"            memtx_stat.txn.system.total, {kind = \"total\"}, nil, {default = true})\n"
"\n"
"    collectors_list.memtx_mvcc_trackers =\n"
"        utils.set_gauge('memtx_mvcc_trackers', 'Maximum trackers allocated per transaction',\n"
"            memtx_stat.mvcc.trackers.max, {kind = \"max\"}, nil, {default = true})\n"
"    collectors_list.memtx_mvcc_trackers =\n"
"        utils.set_gauge('memtx_mvcc_trackers',\n"
"            'Average for all current transactions (total memory / number of transactions)',\n"
"            memtx_stat.mvcc.trackers.avg, {kind = \"average\"}, nil, {default = true})\n"
"    collectors_list.memtx_mvcc_trackers =\n"
"        utils.set_gauge('memtx_mvcc_trackers', 'Trackers are allocated in total',\n"
"            memtx_stat.mvcc.trackers.total, {kind = \"total\"}, nil, {default = true})\n"
"\n"
"    collectors_list.memtx_mvcc_conflicts =\n"
"        utils.set_gauge('memtx_mvcc_conflicts', 'Maximum bytes allocated for conflicts per transaction',\n"
"            memtx_stat.mvcc.conflicts.max, {kind = \"max\"}, nil, {default = true})\n"
"    collectors_list.memtx_mvcc_conflicts =\n"
"        utils.set_gauge('memtx_mvcc_conflicts',\n"
"            'Average for all current transactions (total memory / number of transactions)',\n"
"            memtx_stat.mvcc.conflicts.avg, {kind = \"average\"}, nil, {default = true})\n"
"    collectors_list.memtx_mvcc_conflicts =\n"
"        utils.set_gauge('memtx_mvcc_conflicts', 'Bytes allocated for conflicts in total',\n"
"            memtx_stat.mvcc.conflicts.total, {kind = \"total\"}, nil, {default = true})\n"
"\n"
"\n"
"    collectors_list.memtx_mvcc_tuples_tracking_stories =\n"
"        utils.set_gauge('memtx_mvcc_tuples_tracking_stories',\n"
"            'Number of `tracking` tuples / number of tracking stories.',\n"
"            memtx_stat.mvcc.tuples.tracking.stories.count, {kind = \"count\"}, nil, {default = true})\n"
"    collectors_list.memtx_mvcc_tuples_tracking_stories =\n"
"        utils.set_gauge('memtx_mvcc_tuples_tracking_stories', 'Amount of bytes used by stories `tracking` tuples',\n"
"            memtx_stat.mvcc.tuples.tracking.stories.total, {kind = \"total\"}, nil, {default = true})\n"
"\n"
"    collectors_list.memtx_mvcc_tuples_tracking_retained =\n"
"        utils.set_gauge('memtx_mvcc_tuples_tracking_retained',\n"
"            'Number of retained `tracking` tuples / number of stories',\n"
"            memtx_stat.mvcc.tuples.tracking.retained.count, {kind = \"count\"}, nil, {default = true})\n"
"    collectors_list.memtx_mvcc_tuples_tracking_retained =\n"
"        utils.set_gauge('memtx_mvcc_tuples_tracking_retained', 'Amount of bytes used by retained `tracking` tuples',\n"
"            memtx_stat.mvcc.tuples.tracking.retained.total, {kind = \"total\"}, nil, {default = true})\n"
"\n"
"\n"
"    collectors_list.memtx_mvcc_tuples_used_stories =\n"
"        utils.set_gauge('memtx_mvcc_tuples_used_stories', 'Number of `used` tuples / number of stories',\n"
"            memtx_stat.mvcc.tuples.used.stories.count, {kind = \"count\"}, nil, {default = true})\n"
"    collectors_list.memtx_mvcc_tuples_used_stories =\n"
"        utils.set_gauge('memtx_mvcc_tuples_used_stories', 'Amount of bytes used by stories ``used`` tuples',\n"
"            memtx_stat.mvcc.tuples.used.stories.total, {kind = \"total\"}, nil, {default = true})\n"
"\n"
"    collectors_list.memtx_mvcc_tuples_used_retained =\n"
"        utils.set_gauge('memtx_mvcc_tuples_used_retained', 'Number of retained `used` tuples / number of stories',\n"
"            memtx_stat.mvcc.tuples.used.retained.count, {kind = \"count\"}, nil, {default = true})\n"
"    collectors_list.memtx_mvcc_tuples_used_retained =\n"
"        utils.set_gauge('memtx_mvcc_tuples_used_retained', 'Amount of bytes used by retained `used` tuples',\n"
"            memtx_stat.mvcc.tuples.used.retained.total, {kind = \"total\"}, nil, {default = true})\n"
"\n"
"\n"
"    collectors_list.memtx_mvcc_tuples_read_view_stories =\n"
"        utils.set_gauge('memtx_mvcc_tuples_read_view_stories',\n"
"            'Number of `read_view` tuples / number of stories',\n"
"            memtx_stat.mvcc.tuples.read_view.stories.count, {kind = \"count\"}, nil, {default = true})\n"
"    collectors_list.memtx_mvcc_tuples_read_view_stories =\n"
"        utils.set_gauge('memtx_mvcc_tuples_read_view_stories',\n"
"            'Amount of bytes used by stories `read_view` tuples',\n"
"            memtx_stat.mvcc.tuples.read_view.stories.total, {kind = \"total\"}, nil, {default = true})\n"
"\n"
"    collectors_list.memtx_mvcc_tuples_read_view_retained =\n"
"        utils.set_gauge('memtx_mvcc_tuples_read_view_retained',\n"
"            'Number of retained `read_view` tuples / number of stories',\n"
"            memtx_stat.mvcc.tuples.read_view.retained.count, {kind = \"count\"}, nil, {default = true})\n"
"    collectors_list.memtx_mvcc_tuples_read_view_retained =\n"
"        utils.set_gauge('memtx_mvcc_tuples_read_view_retained',\n"
"            'Amount of bytes used by retained `read_view` tuples',\n"
"            memtx_stat.mvcc.tuples.read_view.retained.total, {kind = \"total\"}, nil, {default = true})\n"
"\n"
"end\n"
"\n"
"return {\n"
"    update = update,\n"
"    list = collectors_list,\n"
"}\n"
""
;
