// python wrapper for ttkTrackingFromOverlap
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "ttkTrackingFromOverlap.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_ttkTrackingFromOverlap(PyObject *dict); }
extern "C" { VTK_ABI_HIDDEN PyObject *PyttkTrackingFromOverlap_ClassNew(); }


static PyObject *
PyttkTrackingFromOverlap_IsTypeOf(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "IsTypeOf");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = ttkTrackingFromOverlap::IsTypeOf(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromOverlap_IsA(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "IsA");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromOverlap *op = static_cast<ttkTrackingFromOverlap *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    int tempr = (ap.IsBound() ?
      op->IsA(temp0) :
      op->ttkTrackingFromOverlap::IsA(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromOverlap_SafeDownCast(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "SafeDownCast");

  vtkObjectBase *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetVTKObject(temp0, "vtkObjectBase"))
  {
    ttkTrackingFromOverlap *tempr = ttkTrackingFromOverlap::SafeDownCast(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromOverlap_NewInstance(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "NewInstance");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromOverlap *op = static_cast<ttkTrackingFromOverlap *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    ttkTrackingFromOverlap *tempr = (ap.IsBound() ?
      op->NewInstance() :
      op->ttkTrackingFromOverlap::NewInstance());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildVTKObject(tempr);
      if (result && PyVTKObject_Check(result))
      {
        PyVTKObject_GetObject(result)->UnRegister(nullptr);
        PyVTKObject_SetFlag(result, VTK_PYTHON_IGNORE_UNREGISTER, 1);
      }
    }
    else if (tempr != nullptr)
    {
      ap.DeleteVTKObject(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromOverlap_GetNumberOfGenerationsFromBaseType(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "GetNumberOfGenerationsFromBaseType");

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = ttkTrackingFromOverlap::GetNumberOfGenerationsFromBaseType(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromOverlap_GetNumberOfGenerationsFromBase(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfGenerationsFromBase");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromOverlap *op = static_cast<ttkTrackingFromOverlap *>(vp);

  const char *temp0 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = (ap.IsBound() ?
      op->GetNumberOfGenerationsFromBase(temp0) :
      op->ttkTrackingFromOverlap::GetNumberOfGenerationsFromBase(temp0));

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromOverlap_SetLabelFieldName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "SetLabelFieldName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromOverlap *op = static_cast<ttkTrackingFromOverlap *>(vp);

  std::string temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    if (ap.IsBound())
    {
      op->SetLabelFieldName(temp0);
    }
    else
    {
      op->ttkTrackingFromOverlap::SetLabelFieldName(temp0);
    }

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyttkTrackingFromOverlap_GetLabelFieldName(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetLabelFieldName");
  vtkObjectBase *vp = ap.GetSelfPointer(self, args);
  ttkTrackingFromOverlap *op = static_cast<ttkTrackingFromOverlap *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    std::string tempr = (ap.IsBound() ?
      op->GetLabelFieldName() :
      op->ttkTrackingFromOverlap::GetLabelFieldName());

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyttkTrackingFromOverlap_Methods[] = {
  {"IsTypeOf", PyttkTrackingFromOverlap_IsTypeOf, METH_VARARGS,
   "IsTypeOf(type:str) -> int\nC++: static vtkTypeBool IsTypeOf(const char *type)\n\nReturn 1 if this class type is the same type of (or a subclass\nof) the named class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"IsA", PyttkTrackingFromOverlap_IsA, METH_VARARGS,
   "IsA(self, type:str) -> int\nC++: vtkTypeBool IsA(const char *type) override;\n\nReturn 1 if this class is the same type of (or a subclass of) the\nnamed class. Returns 0 otherwise. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SafeDownCast", PyttkTrackingFromOverlap_SafeDownCast, METH_VARARGS,
   "SafeDownCast(o:vtkObjectBase) -> ttkTrackingFromOverlap\nC++: static ttkTrackingFromOverlap *SafeDownCast(vtkObjectBase *o)\n\n"},
  {"NewInstance", PyttkTrackingFromOverlap_NewInstance, METH_VARARGS,
   "NewInstance(self) -> ttkTrackingFromOverlap\nC++: ttkTrackingFromOverlap *NewInstance()\n\n"},
  {"GetNumberOfGenerationsFromBaseType", PyttkTrackingFromOverlap_GetNumberOfGenerationsFromBaseType, METH_VARARGS,
   "GetNumberOfGenerationsFromBaseType(type:str) -> int\nC++: static vtkIdType GetNumberOfGenerationsFromBaseType(\n    const char *type)\n\nGiven a the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"GetNumberOfGenerationsFromBase", PyttkTrackingFromOverlap_GetNumberOfGenerationsFromBase, METH_VARARGS,
   "GetNumberOfGenerationsFromBase(self, type:str) -> int\nC++: vtkIdType GetNumberOfGenerationsFromBase(const char *type)\n    override;\n\nGiven the name of a base class of this class type, return the\ndistance of inheritance between this class type and the named\nclass (how many generations of inheritance are there between this\nclass and the named class). If the named class is not in this\nclass's inheritance tree, return a negative value. Valid\nresponses will always be nonnegative. This method works in\ncombination with vtkTypeMacro found in vtkSetGet.h.\n"},
  {"SetLabelFieldName", PyttkTrackingFromOverlap_SetLabelFieldName, METH_VARARGS,
   "SetLabelFieldName(self, _arg:str) -> None\nC++: virtual void SetLabelFieldName(const std::string &_arg)\n\n"},
  {"GetLabelFieldName", PyttkTrackingFromOverlap_GetLabelFieldName, METH_VARARGS,
   "GetLabelFieldName(self) -> str\nC++: virtual std::string GetLabelFieldName()\n\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyttkTrackingFromOverlap_GetSets[] = {
  PyVTKObject_GetSet[0],
  PyVTKObject_GetSet[1],
  {
    /*name=*/pystr("label_field_name"),
    /*get=*/[](PyObject* self, void*) -> PyObject*
    {
      auto args = PyTuple_New(0); // placeholder
      auto result = PyttkTrackingFromOverlap_GetLabelFieldName(self, args);
      Py_DECREF(args);
      return result;
    },
    /*set=*/[](PyObject* self, PyObject* value, void*) -> int
    {
      if (PyTuple_Check(value))
      {
        auto result = PyttkTrackingFromOverlap_SetLabelFieldName(self, value);
        return (result == nullptr) ? -1 : 0;
      }
      else
      {
        auto args = PyTuple_Pack(1, value);
        auto result = PyttkTrackingFromOverlap_SetLabelFieldName(self, args);
        Py_DECREF(args);
        return (result == nullptr) ? -1 : 0;
      }
    },
    /*doc=*/pystr("read-write, Calls GetLabelFieldName/SetLabelFieldName\n"),
    /*closure=*/nullptr,
  },
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};
static const char *PyttkTrackingFromOverlap_Doc =
  "ttkTrackingFromOverlap - \\ingroup vtk\n\n"
  "Superclass: ttkAlgorithm\n\n"
  "\\author Jonas Lukasczyk <jl@jluk.de>\\date 01.09.2018\n\n"
  "TTK VTK-filter that computes the overlap between labeled\n"
  "vtkPointSets.\n\n"
  "VTK wrapping code for the ttk::TrackingFromOverlap package.\n\n"
  "This filter identifies and tracks labeled vtkPointSets across time\n"
  "(and optionally levels) based on spatial overlap, where two points\n"
  "overlap iff their corresponding coordinates are equal. This filter\n"
  "can be executed iteratively and can generate nested tracking graphs.\n\n"
  "This filter can be used as any other VTK filter (for instance, by\n"
  "using the sequence of calls SetInputData(), Update(), GetOutput()).\n\n"
  "See the related ParaView example state files for usage examples\n"
  "within a VTK pipeline.\n\n"
  "Related publication:\n\n"
  "'Nested Tracking Graphs'. Jonas Lukasczyk, Gunther Weber, Ross\n"
  "Maciejewski, Christoph Garth, and Heike Leitte. Computer Graphics\n"
  "Forum (Special Issue, Proceedings Eurographics / IEEE Symposium on\n"
  "Visualization). Vol. 36. No. 3. 2017.\n\n"
  "\\param Input A vtkMultiBlockDataSet that holds the labeled \\b\n"
  "vtkPointSets and has one of the following forms:\n\n"
  "{t_0,...,t_n} or {l_0:{t_0,...,t_n}, ... , l_m:{t_0,...,t_n}} where\n"
  "t_i is the \\b vtkPointSet of timestep i, and l_j is a\n"
  "vtkMultiBlockDataSet that holds all timesteps of level j. \\param\n"
  "Output A vtkUnstructuredGrid that represents the (nested) tracking\n"
  "graph embedded in the spatial domain.\n\n"
  "\\sa ttk::TrackingFromOverlap\n\n"
  "Online examples:\n\n"
  "- <a\n"
  "  href=\"https://topology-tool-kit.github.io/examples/nestedTrackingFromOverlap/\"\n"
  "  >Nested Tracking from Overlap example\\n\n\n";

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyttkTrackingFromOverlap_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "ttkTrackingFromOverlap.ttkTrackingFromOverlap", // tp_name
  sizeof(PyVTKObject), // tp_basicsize
  0, // tp_itemsize
  PyVTKObject_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  nullptr, // tp_hash
  nullptr, // tp_call
  PyVTKObject_String, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  PyObject_GenericSetAttr, // tp_setattro
  &PyVTKObject_AsBuffer, // tp_as_buffer
  Py_TPFLAGS_DEFAULT|Py_TPFLAGS_HAVE_GC|Py_TPFLAGS_BASETYPE, // tp_flags
  PyttkTrackingFromOverlap_Doc, // tp_doc
  PyVTKObject_Traverse, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  offsetof(PyVTKObject, vtk_weakreflist), // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  PyVTKObject_GetSet, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  offsetof(PyVTKObject, vtk_dict), // tp_dictoffset
  PyVTKObject_Init, // tp_init
  nullptr, // tp_alloc
  PyVTKObject_New, // tp_new
  PyObject_GC_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static vtkObjectBase *PyttkTrackingFromOverlap_StaticNew()
{
  return ttkTrackingFromOverlap::New();
}

PyObject *PyttkTrackingFromOverlap_ClassNew()
{
  PyTypeObject *pytype = PyVTKClass_Add(
    &PyttkTrackingFromOverlap_Type, PyttkTrackingFromOverlap_Methods,
    "ttkTrackingFromOverlap",
 &PyttkTrackingFromOverlap_StaticNew);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  pytype->tp_base = vtkPythonUtil::FindBaseTypeObject("ttkAlgorithm");

  PyVTKClass_AddCombinedGetSetDefinitions(pytype, PyttkTrackingFromOverlap_GetSets);
  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_ttkTrackingFromOverlap(
  PyObject *dict)
{
  PyObject *o;
  o = PyttkTrackingFromOverlap_ClassNew();

  if (o && PyDict_SetItemString(dict, "ttkTrackingFromOverlap", o) != 0)
  {
    Py_DECREF(o);
  }

}

