/* Generated by wayland-scanner 1.24.0 */

#ifndef TREELAND_VIRTUAL_OUTPUT_MANAGER_V1_SERVER_PROTOCOL_H
#define TREELAND_VIRTUAL_OUTPUT_MANAGER_V1_SERVER_PROTOCOL_H

#include <stdint.h>
#include <stddef.h>
#include "wayland-server.h"

#ifdef  __cplusplus
extern "C" {
#endif

struct wl_client;
struct wl_resource;

/**
 * @page page_treeland_virtual_output_manager_v1 The treeland_virtual_output_manager_v1 protocol
 * @section page_ifaces_treeland_virtual_output_manager_v1 Interfaces
 * - @subpage page_iface_treeland_virtual_output_manager_v1 - Manager creates virtual output
 * - @subpage page_iface_treeland_virtual_output_v1 - screen output object
 * @section page_copyright_treeland_virtual_output_manager_v1 Copyright
 * <pre>
 *
 * SPDX-FileCopyrightText: 2024 UnionTech Software Technology Co., Ltd.
 * SPDX-License-Identifier: MIT
 * </pre>
 */
struct treeland_virtual_output_manager_v1;
struct treeland_virtual_output_v1;

#ifndef TREELAND_VIRTUAL_OUTPUT_MANAGER_V1_INTERFACE
#define TREELAND_VIRTUAL_OUTPUT_MANAGER_V1_INTERFACE
/**
 * @page page_iface_treeland_virtual_output_manager_v1 treeland_virtual_output_manager_v1
 * @section page_iface_treeland_virtual_output_manager_v1_desc Description
 *
 * This interface is a manager that allows the creation of copied output.
 * @section page_iface_treeland_virtual_output_manager_v1_api API
 * See @ref iface_treeland_virtual_output_manager_v1.
 */
/**
 * @defgroup iface_treeland_virtual_output_manager_v1 The treeland_virtual_output_manager_v1 interface
 *
 * This interface is a manager that allows the creation of copied output.
 */
extern const struct wl_interface treeland_virtual_output_manager_v1_interface;
#endif
#ifndef TREELAND_VIRTUAL_OUTPUT_V1_INTERFACE
#define TREELAND_VIRTUAL_OUTPUT_V1_INTERFACE
/**
 * @page page_iface_treeland_virtual_output_v1 treeland_virtual_output_v1
 * @section page_iface_treeland_virtual_output_v1_desc Description
 *
 * A treeland_virtual_output_v1 represents a set virtual screen output object.
 * @section page_iface_treeland_virtual_output_v1_api API
 * See @ref iface_treeland_virtual_output_v1.
 */
/**
 * @defgroup iface_treeland_virtual_output_v1 The treeland_virtual_output_v1 interface
 *
 * A treeland_virtual_output_v1 represents a set virtual screen output object.
 */
extern const struct wl_interface treeland_virtual_output_v1_interface;
#endif

/**
 * @ingroup iface_treeland_virtual_output_manager_v1
 * @struct treeland_virtual_output_manager_v1_interface
 */
struct treeland_virtual_output_manager_v1_interface {
	/**
	 * Create a virtual output
	 *
	 * Create virtual output that can be used when setting screen
	 * copy mode for use on multiple screens. Virtual outputs are
	 * created to mirror multiple wl_output outputs.
	 *
	 * The element of the array is the name of the screen.
	 *
	 * The first element of the array outputs is the screen to be
	 * copied, and the subsequent elements are the screens to be
	 * mirrored.
	 *
	 * The client calling this interface will not generate an
	 * additional wl_output object on the client.
	 * @param name The name of the user readable virtual output
	 * @param outputs Screen name array
	 */
	void (*create_virtual_output)(struct wl_client *client,
				      struct wl_resource *resource,
				      uint32_t id,
				      const char *name,
				      struct wl_array *outputs);
	/**
	 * Gets a list of virtual output names
	 *
	 * Gets a list of virtual output names.
	 */
	void (*get_virtual_output_list)(struct wl_client *client,
					struct wl_resource *resource);
	/**
	 * Get virtual output
	 *
	 * The client obtains the corresponding virtual_output_v1 object
	 * through the virtual output name.
	 * @param name The name of the user readable virtual output
	 */
	void (*get_virtual_output)(struct wl_client *client,
				   struct wl_resource *resource,
				   const char *name,
				   uint32_t id);
};

#define TREELAND_VIRTUAL_OUTPUT_MANAGER_V1_VIRTUAL_OUTPUT_LIST 0

/**
 * @ingroup iface_treeland_virtual_output_manager_v1
 */
#define TREELAND_VIRTUAL_OUTPUT_MANAGER_V1_VIRTUAL_OUTPUT_LIST_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_virtual_output_manager_v1
 */
#define TREELAND_VIRTUAL_OUTPUT_MANAGER_V1_CREATE_VIRTUAL_OUTPUT_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_virtual_output_manager_v1
 */
#define TREELAND_VIRTUAL_OUTPUT_MANAGER_V1_GET_VIRTUAL_OUTPUT_LIST_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_virtual_output_manager_v1
 */
#define TREELAND_VIRTUAL_OUTPUT_MANAGER_V1_GET_VIRTUAL_OUTPUT_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_virtual_output_manager_v1
 * Sends an virtual_output_list event to the client owning the resource.
 * @param resource_ The client's resource
 * @param names List of virtual output names
 */
static inline void
treeland_virtual_output_manager_v1_send_virtual_output_list(struct wl_resource *resource_, struct wl_array *names)
{
	wl_resource_post_event(resource_, TREELAND_VIRTUAL_OUTPUT_MANAGER_V1_VIRTUAL_OUTPUT_LIST, names);
}

#ifndef TREELAND_VIRTUAL_OUTPUT_V1_ERROR_ENUM
#define TREELAND_VIRTUAL_OUTPUT_V1_ERROR_ENUM
enum treeland_virtual_output_v1_error {
	/**
	 * Group name is empty
	 */
	TREELAND_VIRTUAL_OUTPUT_V1_ERROR_INVALID_GROUP_NAME = 0,
	/**
	 * The number of screens applying for copy mode is less than 2
	 */
	TREELAND_VIRTUAL_OUTPUT_V1_ERROR_INVALID_SCREEN_NUMBER = 1,
	/**
	 * Output does not exist
	 */
	TREELAND_VIRTUAL_OUTPUT_V1_ERROR_INVALID_OUTPUT = 2,
};
#endif /* TREELAND_VIRTUAL_OUTPUT_V1_ERROR_ENUM */

#ifndef TREELAND_VIRTUAL_OUTPUT_V1_ERROR_ENUM_IS_VALID
#define TREELAND_VIRTUAL_OUTPUT_V1_ERROR_ENUM_IS_VALID
/**
 * @ingroup iface_treeland_virtual_output_v1
 * Validate a treeland_virtual_output_v1 error value.
 *
 * @return true on success, false on error.
 * @ref treeland_virtual_output_v1_error
 */
static inline bool
treeland_virtual_output_v1_error_is_valid(uint32_t value, uint32_t version) {
	switch (value) {
	case TREELAND_VIRTUAL_OUTPUT_V1_ERROR_INVALID_GROUP_NAME:
		return version >= 1;
	case TREELAND_VIRTUAL_OUTPUT_V1_ERROR_INVALID_SCREEN_NUMBER:
		return version >= 1;
	case TREELAND_VIRTUAL_OUTPUT_V1_ERROR_INVALID_OUTPUT:
		return version >= 1;
	default:
		return false;
	}
}
#endif /* TREELAND_VIRTUAL_OUTPUT_V1_ERROR_ENUM_IS_VALID */

/**
 * @ingroup iface_treeland_virtual_output_v1
 * @struct treeland_virtual_output_v1_interface
 */
struct treeland_virtual_output_v1_interface {
	/**
	 * destroy the output
	 *
	 * Destroy the output.
	 */
	void (*destroy)(struct wl_client *client,
			struct wl_resource *resource);
};

#define TREELAND_VIRTUAL_OUTPUT_V1_OUTPUTS 0
#define TREELAND_VIRTUAL_OUTPUT_V1_ERROR 1

/**
 * @ingroup iface_treeland_virtual_output_v1
 */
#define TREELAND_VIRTUAL_OUTPUT_V1_OUTPUTS_SINCE_VERSION 1
/**
 * @ingroup iface_treeland_virtual_output_v1
 */
#define TREELAND_VIRTUAL_OUTPUT_V1_ERROR_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_virtual_output_v1
 */
#define TREELAND_VIRTUAL_OUTPUT_V1_DESTROY_SINCE_VERSION 1

/**
 * @ingroup iface_treeland_virtual_output_v1
 * Sends an outputs event to the client owning the resource.
 * @param resource_ The client's resource
 * @param name The name of the user readable virtual output
 * @param outputs Screen name array
 */
static inline void
treeland_virtual_output_v1_send_outputs(struct wl_resource *resource_, const char *name, struct wl_array *outputs)
{
	wl_resource_post_event(resource_, TREELAND_VIRTUAL_OUTPUT_V1_OUTPUTS, name, outputs);
}

/**
 * @ingroup iface_treeland_virtual_output_v1
 * Sends an error event to the client owning the resource.
 * @param resource_ The client's resource
 * @param code error code
 * @param message error description
 */
static inline void
treeland_virtual_output_v1_send_error(struct wl_resource *resource_, uint32_t code, const char *message)
{
	wl_resource_post_event(resource_, TREELAND_VIRTUAL_OUTPUT_V1_ERROR, code, message);
}

#ifdef  __cplusplus
}
#endif

#endif
