/* FocusPicture.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FocusPicture.vala, do not modify */

/* Basically GtkPicture from https://gitlab.gnome.org/GNOME/gtk/-/blob/34bd3fc854a142d966cc8f2ddbfd1128fb09f446/gtk/gtkpicture.c*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <graphene-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TUBA_WIDGETS_TYPE_FOCUS_PICTURE (tuba_widgets_focus_picture_get_type ())
#define TUBA_WIDGETS_FOCUS_PICTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TUBA_WIDGETS_TYPE_FOCUS_PICTURE, TubaWidgetsFocusPicture))
#define TUBA_WIDGETS_FOCUS_PICTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TUBA_WIDGETS_TYPE_FOCUS_PICTURE, TubaWidgetsFocusPictureClass))
#define TUBA_WIDGETS_IS_FOCUS_PICTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TUBA_WIDGETS_TYPE_FOCUS_PICTURE))
#define TUBA_WIDGETS_IS_FOCUS_PICTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TUBA_WIDGETS_TYPE_FOCUS_PICTURE))
#define TUBA_WIDGETS_FOCUS_PICTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TUBA_WIDGETS_TYPE_FOCUS_PICTURE, TubaWidgetsFocusPictureClass))

typedef struct _TubaWidgetsFocusPicture TubaWidgetsFocusPicture;
typedef struct _TubaWidgetsFocusPictureClass TubaWidgetsFocusPictureClass;
typedef struct _TubaWidgetsFocusPicturePrivate TubaWidgetsFocusPicturePrivate;
enum  {
	TUBA_WIDGETS_FOCUS_PICTURE_0_PROPERTY,
	TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_X_PROPERTY,
	TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_Y_PROPERTY,
	TUBA_WIDGETS_FOCUS_PICTURE_ALTERNATIVE_TEXT_PROPERTY,
	TUBA_WIDGETS_FOCUS_PICTURE_CONTENT_FIT_PROPERTY,
	TUBA_WIDGETS_FOCUS_PICTURE_CAN_SHRINK_PROPERTY,
	TUBA_WIDGETS_FOCUS_PICTURE_PAINTABLE_PROPERTY,
	TUBA_WIDGETS_FOCUS_PICTURE_NUM_PROPERTIES
};
static GParamSpec* tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _TubaWidgetsFocusPicture {
	GtkWidget parent_instance;
	TubaWidgetsFocusPicturePrivate * priv;
};

struct _TubaWidgetsFocusPictureClass {
	GtkWidgetClass parent_class;
};

struct _TubaWidgetsFocusPicturePrivate {
	gulong paintable_invalidate_contents_signal;
	gulong paintable_invalidate_size_signal;
	gdouble _focus_x;
	gdouble _focus_y;
	gchar* _alternative_text;
	GtkContentFit _content_fit;
	gboolean _can_shrink;
	GdkPaintable* _paintable;
};

static gint TubaWidgetsFocusPicture_private_offset;
static gpointer tuba_widgets_focus_picture_parent_class = NULL;
static GtkBuildableIface * tuba_widgets_focus_picture_gtk_buildable_parent_iface = NULL;
static GtkAccessibleInterface * tuba_widgets_focus_picture_gtk_accessible_parent_iface = NULL;

VALA_EXTERN GType tuba_widgets_focus_picture_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TubaWidgetsFocusPicture, g_object_unref)
static void tuba_widgets_focus_picture_clear_paintable (TubaWidgetsFocusPicture* self);
VALA_EXTERN TubaWidgetsFocusPicture* tuba_widgets_focus_picture_new_for_paintable (GdkPaintable* t_paintable);
VALA_EXTERN TubaWidgetsFocusPicture* tuba_widgets_focus_picture_construct_for_paintable (GType object_type,
                                                                             GdkPaintable* t_paintable);
VALA_EXTERN void tuba_widgets_focus_picture_set_paintable (TubaWidgetsFocusPicture* self,
                                               GdkPaintable* value);
static GtkSizeRequestMode tuba_widgets_focus_picture_real_get_request_mode (GtkWidget* base);
static void tuba_widgets_focus_picture_real_snapshot (GtkWidget* base,
                                               GtkSnapshot* snapshot);
VALA_EXTERN gdouble tuba_widgets_focus_picture_get_focus_x (TubaWidgetsFocusPicture* self);
VALA_EXTERN gdouble tuba_widgets_focus_picture_get_focus_y (TubaWidgetsFocusPicture* self);
static void tuba_widgets_focus_picture_real_measure (GtkWidget* base,
                                              GtkOrientation orientation,
                                              gint for_size,
                                              gint* minimum,
                                              gint* natural,
                                              gint* minimum_baseline,
                                              gint* natural_baseline);
static void tuba_widgets_focus_picture_paintable_invalidate_contents (TubaWidgetsFocusPicture* self);
static void tuba_widgets_focus_picture_paintable_invalidate_size (TubaWidgetsFocusPicture* self);
static gboolean tuba_widgets_focus_picture_paintable_size_equal (TubaWidgetsFocusPicture* self,
                                                          GdkPaintable* new_paintable);
VALA_EXTERN TubaWidgetsFocusPicture* tuba_widgets_focus_picture_new (void);
VALA_EXTERN TubaWidgetsFocusPicture* tuba_widgets_focus_picture_construct (GType object_type);
VALA_EXTERN void tuba_widgets_focus_picture_set_focus_x (TubaWidgetsFocusPicture* self,
                                             gdouble value);
VALA_EXTERN void tuba_widgets_focus_picture_set_focus_y (TubaWidgetsFocusPicture* self,
                                             gdouble value);
VALA_EXTERN const gchar* tuba_widgets_focus_picture_get_alternative_text (TubaWidgetsFocusPicture* self);
VALA_EXTERN void tuba_widgets_focus_picture_set_alternative_text (TubaWidgetsFocusPicture* self,
                                                      const gchar* value);
VALA_EXTERN GtkContentFit tuba_widgets_focus_picture_get_content_fit (TubaWidgetsFocusPicture* self);
VALA_EXTERN void tuba_widgets_focus_picture_set_content_fit (TubaWidgetsFocusPicture* self,
                                                 GtkContentFit value);
VALA_EXTERN gboolean tuba_widgets_focus_picture_get_can_shrink (TubaWidgetsFocusPicture* self);
VALA_EXTERN void tuba_widgets_focus_picture_set_can_shrink (TubaWidgetsFocusPicture* self,
                                                gboolean value);
VALA_EXTERN GdkPaintable* tuba_widgets_focus_picture_get_paintable (TubaWidgetsFocusPicture* self);
static void _tuba_widgets_focus_picture_paintable_invalidate_contents_gdk_paintable_invalidate_contents (GdkPaintable* _sender,
                                                                                                  gpointer self);
static void _tuba_widgets_focus_picture_paintable_invalidate_size_gdk_paintable_invalidate_size (GdkPaintable* _sender,
                                                                                          gpointer self);
static GObject * tuba_widgets_focus_picture_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static void tuba_widgets_focus_picture_finalize (GObject * obj);
static GType tuba_widgets_focus_picture_get_type_once (void);
static void _vala_tuba_widgets_focus_picture_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_tuba_widgets_focus_picture_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
tuba_widgets_focus_picture_get_instance_private (TubaWidgetsFocusPicture* self)
{
	return G_STRUCT_MEMBER_P (self, TubaWidgetsFocusPicture_private_offset);
}

TubaWidgetsFocusPicture*
tuba_widgets_focus_picture_construct_for_paintable (GType object_type,
                                                    GdkPaintable* t_paintable)
{
	TubaWidgetsFocusPicture * self = NULL;
	self = (TubaWidgetsFocusPicture*) g_object_new (object_type, NULL);
	if (t_paintable == NULL) {
		return self;
	}
	tuba_widgets_focus_picture_set_paintable (self, t_paintable);
	return self;
}

TubaWidgetsFocusPicture*
tuba_widgets_focus_picture_new_for_paintable (GdkPaintable* t_paintable)
{
	return tuba_widgets_focus_picture_construct_for_paintable (TUBA_WIDGETS_TYPE_FOCUS_PICTURE, t_paintable);
}

static GtkSizeRequestMode
tuba_widgets_focus_picture_real_get_request_mode (GtkWidget* base)
{
	TubaWidgetsFocusPicture * self;
	GtkSizeRequestMode result;
	self = (TubaWidgetsFocusPicture*) base;
	result = GTK_SIZE_REQUEST_HEIGHT_FOR_WIDTH;
	return result;
}

static void
tuba_widgets_focus_picture_real_snapshot (GtkWidget* base,
                                          GtkSnapshot* snapshot)
{
	TubaWidgetsFocusPicture * self;
	GdkPaintable* _tmp0_;
	gint width = 0;
	gint height = 0;
	gdouble ratio = 0.0;
	GdkPaintable* _tmp1_;
	gboolean _tmp2_ = FALSE;
	self = (TubaWidgetsFocusPicture*) base;
	g_return_if_fail (snapshot != NULL);
	_tmp0_ = self->priv->_paintable;
	if (_tmp0_ == NULL) {
		return;
	}
	width = gtk_widget_get_width ((GtkWidget*) self);
	height = gtk_widget_get_height ((GtkWidget*) self);
	_tmp1_ = self->priv->_paintable;
	ratio = gdk_paintable_get_intrinsic_aspect_ratio (_tmp1_);
	if (self->priv->_content_fit == GTK_CONTENT_FIT_FILL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = ratio == ((gdouble) 0);
	}
	if (_tmp2_) {
		GdkPaintable* _tmp3_;
		_tmp3_ = self->priv->_paintable;
		gdk_paintable_snapshot (_tmp3_, (GdkSnapshot*) snapshot, (gdouble) width, (gdouble) height);
	} else {
		gdouble w = 0.0;
		gdouble h = 0.0;
		gdouble picture_ratio = 0.0;
		gint paintable_width = 0;
		GdkPaintable* _tmp4_;
		gint paintable_height = 0;
		GdkPaintable* _tmp5_;
		gboolean _tmp6_ = FALSE;
		gboolean _tmp7_ = FALSE;
		gdouble x = 0.0;
		gdouble y = 0.0;
		graphene_point_t _tmp12_ = {0};
		GdkPaintable* _tmp13_;
		w = 0.0;
		h = 0.0;
		picture_ratio = ((gdouble) width) / height;
		_tmp4_ = self->priv->_paintable;
		paintable_width = gdk_paintable_get_intrinsic_width (_tmp4_);
		_tmp5_ = self->priv->_paintable;
		paintable_height = gdk_paintable_get_intrinsic_height (_tmp5_);
		if (self->priv->_content_fit == GTK_CONTENT_FIT_SCALE_DOWN) {
			_tmp7_ = width >= paintable_width;
		} else {
			_tmp7_ = FALSE;
		}
		if (_tmp7_) {
			_tmp6_ = height >= paintable_height;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			w = (gdouble) paintable_width;
			h = (gdouble) paintable_height;
		} else {
			if (ratio > picture_ratio) {
				if (self->priv->_content_fit == GTK_CONTENT_FIT_COVER) {
					w = height * ratio;
					h = (gdouble) height;
				} else {
					w = (gdouble) width;
					h = width / ratio;
				}
			} else {
				if (self->priv->_content_fit == GTK_CONTENT_FIT_COVER) {
					w = (gdouble) width;
					h = width / ratio;
				} else {
					w = height * ratio;
					h = (gdouble) height;
				}
			}
		}
		w = ceil (w);
		h = ceil (h);
		x = (width - w) / 2;
		y = floor (height - h) / 2;
		if (self->priv->_content_fit == GTK_CONTENT_FIT_COVER) {
			gdouble _tmp8_;
			gdouble _tmp9_;
			gdouble _tmp10_;
			gdouble _tmp11_;
			_tmp8_ = tuba_widgets_focus_picture_get_focus_x (self);
			_tmp9_ = _tmp8_;
			x = x + (x * _tmp9_);
			_tmp10_ = tuba_widgets_focus_picture_get_focus_y (self);
			_tmp11_ = _tmp10_;
			y = y + ((y * _tmp11_) * -1);
		}
		gtk_snapshot_save (snapshot);
		memset (&_tmp12_, 0, sizeof (graphene_point_t));
		_tmp12_.x = (gfloat) x;
		_tmp12_.y = (gfloat) y;
		gtk_snapshot_translate (snapshot, &_tmp12_);
		_tmp13_ = self->priv->_paintable;
		gdk_paintable_snapshot (_tmp13_, (GdkSnapshot*) snapshot, w, h);
		gtk_snapshot_restore (snapshot);
	}
}

static void
tuba_widgets_focus_picture_real_measure (GtkWidget* base,
                                         GtkOrientation orientation,
                                         gint for_size,
                                         gint* minimum,
                                         gint* natural,
                                         gint* minimum_baseline,
                                         gint* natural_baseline)
{
	TubaWidgetsFocusPicture * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	gint _vala_minimum_baseline = 0;
	gint _vala_natural_baseline = 0;
	gboolean _tmp0_ = FALSE;
	GdkPaintable* _tmp1_;
	gdouble min_width = 0.0;
	gdouble min_height = 0.0;
	gdouble nat_width = 0.0;
	gdouble nat_height = 0.0;
	gdouble default_size = 0.0;
	gboolean _tmp5_ = FALSE;
	self = (TubaWidgetsFocusPicture*) base;
	_vala_minimum_baseline = -1;
	_vala_natural_baseline = -1;
	_tmp1_ = self->priv->_paintable;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = for_size == 0;
	}
	if (_tmp0_) {
		_vala_minimum = 0;
		_vala_natural = 0;
		if (minimum) {
			*minimum = _vala_minimum;
		}
		if (natural) {
			*natural = _vala_natural;
		}
		if (minimum_baseline) {
			*minimum_baseline = _vala_minimum_baseline;
		}
		if (natural_baseline) {
			*natural_baseline = _vala_natural_baseline;
		}
		return;
	}
	min_width = 0.0;
	min_height = 0.0;
	nat_width = 0.0;
	nat_height = 0.0;
	default_size = 1.0;
	if (!self->priv->_can_shrink) {
		GdkPaintable* _tmp2_;
		gdouble _tmp3_ = 0.0;
		gdouble _tmp4_ = 0.0;
		_tmp2_ = self->priv->_paintable;
		gdk_paintable_compute_concrete_size (_tmp2_, (gdouble) 0, (gdouble) 0, default_size, default_size, &_tmp3_, &_tmp4_);
		min_width = _tmp3_;
		min_height = _tmp4_;
	}
	if (for_size > 0) {
		_tmp5_ = self->priv->_content_fit == GTK_CONTENT_FIT_SCALE_DOWN;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		gint opposite_intrinsic_size = 0;
		gboolean _tmp8_ = FALSE;
		opposite_intrinsic_size = 0;
		if (orientation == GTK_ORIENTATION_HORIZONTAL) {
			GdkPaintable* _tmp6_;
			_tmp6_ = self->priv->_paintable;
			opposite_intrinsic_size = gdk_paintable_get_intrinsic_height (_tmp6_);
		} else {
			GdkPaintable* _tmp7_;
			_tmp7_ = self->priv->_paintable;
			opposite_intrinsic_size = gdk_paintable_get_intrinsic_width (_tmp7_);
		}
		if (opposite_intrinsic_size != 0) {
			_tmp8_ = opposite_intrinsic_size < for_size;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			for_size = opposite_intrinsic_size;
		}
	}
	if (orientation == GTK_ORIENTATION_HORIZONTAL) {
		gint _tmp9_ = 0;
		GdkPaintable* _tmp10_;
		gdouble _tmp11_ = 0.0;
		gdouble _tmp12_ = 0.0;
		if (for_size < 0) {
			_tmp9_ = 0;
		} else {
			_tmp9_ = for_size;
		}
		_tmp10_ = self->priv->_paintable;
		gdk_paintable_compute_concrete_size (_tmp10_, (gdouble) 0, (gdouble) _tmp9_, default_size, default_size, &_tmp11_, &_tmp12_);
		nat_width = _tmp11_;
		nat_height = _tmp12_;
		_vala_minimum = (gint) ceil (min_width);
		_vala_natural = (gint) ceil (nat_width);
	} else {
		gint _tmp13_ = 0;
		GdkPaintable* _tmp14_;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp16_ = 0.0;
		if (for_size < 0) {
			_tmp13_ = 0;
		} else {
			_tmp13_ = for_size;
		}
		_tmp14_ = self->priv->_paintable;
		gdk_paintable_compute_concrete_size (_tmp14_, (gdouble) _tmp13_, (gdouble) 0, default_size, default_size, &_tmp15_, &_tmp16_);
		nat_width = _tmp15_;
		nat_height = _tmp16_;
		_vala_minimum = (gint) ceil (min_height);
		_vala_natural = (gint) ceil (nat_height);
	}
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
	if (minimum_baseline) {
		*minimum_baseline = _vala_minimum_baseline;
	}
	if (natural_baseline) {
		*natural_baseline = _vala_natural_baseline;
	}
}

static void
tuba_widgets_focus_picture_paintable_invalidate_contents (TubaWidgetsFocusPicture* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

static void
tuba_widgets_focus_picture_paintable_invalidate_size (TubaWidgetsFocusPicture* self)
{
	g_return_if_fail (self != NULL);
	gtk_widget_queue_resize ((GtkWidget*) self);
}

static void
tuba_widgets_focus_picture_clear_paintable (TubaWidgetsFocusPicture* self)
{
	GdkPaintable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_paintable;
	if (_tmp0_ == NULL) {
		return;
	}
	if (self->priv->paintable_invalidate_contents_signal != ((gulong) 0)) {
		GdkPaintable* _tmp1_;
		_tmp1_ = self->priv->_paintable;
		g_signal_handler_disconnect ((GObject*) _tmp1_, self->priv->paintable_invalidate_contents_signal);
	}
	if (self->priv->paintable_invalidate_size_signal != ((gulong) 0)) {
		GdkPaintable* _tmp2_;
		_tmp2_ = self->priv->_paintable;
		g_signal_handler_disconnect ((GObject*) _tmp2_, self->priv->paintable_invalidate_size_signal);
	}
	self->priv->paintable_invalidate_contents_signal = (gulong) 0;
	self->priv->paintable_invalidate_size_signal = (gulong) 0;
	_g_object_unref0 (self->priv->_paintable);
	self->priv->_paintable = NULL;
}

static gboolean
tuba_widgets_focus_picture_paintable_size_equal (TubaWidgetsFocusPicture* self,
                                                 GdkPaintable* new_paintable)
{
	GdkPaintable* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GdkPaintable* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_paintable;
	if (_tmp0_ == NULL) {
		result = new_paintable == NULL;
		return result;
	} else {
		if (new_paintable == NULL) {
			result = FALSE;
			return result;
		}
	}
	_tmp3_ = self->priv->_paintable;
	if (gdk_paintable_get_intrinsic_width (_tmp3_) == gdk_paintable_get_intrinsic_width (new_paintable)) {
		GdkPaintable* _tmp4_;
		_tmp4_ = self->priv->_paintable;
		_tmp2_ = gdk_paintable_get_intrinsic_height (_tmp4_) == gdk_paintable_get_intrinsic_height (new_paintable);
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		GdkPaintable* _tmp5_;
		_tmp5_ = self->priv->_paintable;
		_tmp1_ = gdk_paintable_get_intrinsic_aspect_ratio (_tmp5_) == gdk_paintable_get_intrinsic_aspect_ratio (new_paintable);
	} else {
		_tmp1_ = FALSE;
	}
	result = _tmp1_;
	return result;
}

TubaWidgetsFocusPicture*
tuba_widgets_focus_picture_construct (GType object_type)
{
	TubaWidgetsFocusPicture * self = NULL;
	self = (TubaWidgetsFocusPicture*) g_object_new (object_type, NULL);
	return self;
}

TubaWidgetsFocusPicture*
tuba_widgets_focus_picture_new (void)
{
	return tuba_widgets_focus_picture_construct (TUBA_WIDGETS_TYPE_FOCUS_PICTURE);
}

gdouble
tuba_widgets_focus_picture_get_focus_x (TubaWidgetsFocusPicture* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_focus_x;
	return result;
}

void
tuba_widgets_focus_picture_set_focus_x (TubaWidgetsFocusPicture* self,
                                        gdouble value)
{
	GdkPaintable* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_focus_x = CLAMP (value, -1.0, 1.0);
	_tmp0_ = self->priv->_paintable;
	if (_tmp0_ != NULL) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_X_PROPERTY]);
}

gdouble
tuba_widgets_focus_picture_get_focus_y (TubaWidgetsFocusPicture* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_focus_y;
	return result;
}

void
tuba_widgets_focus_picture_set_focus_y (TubaWidgetsFocusPicture* self,
                                        gdouble value)
{
	GdkPaintable* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->_focus_y = CLAMP (value, -1.0, 1.0);
	_tmp0_ = self->priv->_paintable;
	if (_tmp0_ != NULL) {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_Y_PROPERTY]);
}

const gchar*
tuba_widgets_focus_picture_get_alternative_text (TubaWidgetsFocusPicture* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_alternative_text;
	result = _tmp0_;
	return result;
}

void
tuba_widgets_focus_picture_set_alternative_text (TubaWidgetsFocusPicture* self,
                                                 const gchar* value)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_alternative_text;
	if (g_strcmp0 (value, _tmp0_) == 0) {
		return;
	}
	_tmp1_ = g_strdup (value);
	_g_free0 (self->priv->_alternative_text);
	self->priv->_alternative_text = _tmp1_;
	if (value == NULL) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup ("");
		_g_free0 (self->priv->_alternative_text);
		self->priv->_alternative_text = _tmp2_;
	}
	_tmp3_ = self->priv->_alternative_text;
	gtk_accessible_update_property ((GtkAccessible*) self, GTK_ACCESSIBLE_PROPERTY_DESCRIPTION, _tmp3_, -1, -1);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_ALTERNATIVE_TEXT_PROPERTY]);
}

GtkContentFit
tuba_widgets_focus_picture_get_content_fit (TubaWidgetsFocusPicture* self)
{
	GtkContentFit result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_content_fit;
	return result;
}

void
tuba_widgets_focus_picture_set_content_fit (TubaWidgetsFocusPicture* self,
                                            GtkContentFit value)
{
	gboolean _tmp0_ = FALSE;
	gboolean queue_resize = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->_content_fit == value) {
		return;
	}
	if (value == GTK_CONTENT_FIT_SCALE_DOWN) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->_content_fit == GTK_CONTENT_FIT_SCALE_DOWN;
	}
	queue_resize = _tmp0_;
	self->priv->_content_fit = value;
	if (queue_resize) {
		gtk_widget_queue_resize ((GtkWidget*) self);
	} else {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_CONTENT_FIT_PROPERTY]);
}

gboolean
tuba_widgets_focus_picture_get_can_shrink (TubaWidgetsFocusPicture* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_can_shrink;
	return result;
}

void
tuba_widgets_focus_picture_set_can_shrink (TubaWidgetsFocusPicture* self,
                                           gboolean value)
{
	g_return_if_fail (self != NULL);
	if (self->priv->_can_shrink == value) {
		return;
	}
	self->priv->_can_shrink = value;
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_CAN_SHRINK_PROPERTY]);
}

GdkPaintable*
tuba_widgets_focus_picture_get_paintable (TubaWidgetsFocusPicture* self)
{
	GdkPaintable* result;
	GdkPaintable* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_paintable;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_tuba_widgets_focus_picture_paintable_invalidate_contents_gdk_paintable_invalidate_contents (GdkPaintable* _sender,
                                                                                             gpointer self)
{
	tuba_widgets_focus_picture_paintable_invalidate_contents ((TubaWidgetsFocusPicture*) self);
}

static void
_tuba_widgets_focus_picture_paintable_invalidate_size_gdk_paintable_invalidate_size (GdkPaintable* _sender,
                                                                                     gpointer self)
{
	tuba_widgets_focus_picture_paintable_invalidate_size ((TubaWidgetsFocusPicture*) self);
}

void
tuba_widgets_focus_picture_set_paintable (TubaWidgetsFocusPicture* self,
                                          GdkPaintable* value)
{
	GdkPaintable* _tmp0_;
	gboolean size_changed = FALSE;
	GdkPaintable* _tmp1_;
	GdkPaintable* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_paintable;
	if (_tmp0_ == value) {
		return;
	}
	size_changed = tuba_widgets_focus_picture_paintable_size_equal (self, value);
	tuba_widgets_focus_picture_clear_paintable (self);
	_tmp1_ = _g_object_ref0 (value);
	_g_object_unref0 (self->priv->_paintable);
	self->priv->_paintable = _tmp1_;
	_tmp2_ = self->priv->_paintable;
	if (_tmp2_ != NULL) {
		GdkPaintableFlags flags = 0U;
		GdkPaintable* _tmp3_;
		_tmp3_ = self->priv->_paintable;
		flags = gdk_paintable_get_flags (_tmp3_);
		if (!((flags & GDK_PAINTABLE_STATIC_CONTENTS) == GDK_PAINTABLE_STATIC_CONTENTS)) {
			GdkPaintable* _tmp4_;
			gulong _tmp5_;
			_tmp4_ = self->priv->_paintable;
			_tmp5_ = g_signal_connect_object (_tmp4_, "invalidate-contents", (GCallback) _tuba_widgets_focus_picture_paintable_invalidate_contents_gdk_paintable_invalidate_contents, self, 0);
			self->priv->paintable_invalidate_contents_signal = _tmp5_;
		}
		if (!((flags & GDK_PAINTABLE_STATIC_SIZE) == GDK_PAINTABLE_STATIC_SIZE)) {
			GdkPaintable* _tmp6_;
			gulong _tmp7_;
			_tmp6_ = self->priv->_paintable;
			_tmp7_ = g_signal_connect_object (_tmp6_, "invalidate-size", (GCallback) _tuba_widgets_focus_picture_paintable_invalidate_size_gdk_paintable_invalidate_size, self, 0);
			self->priv->paintable_invalidate_size_signal = _tmp7_;
		}
	}
	if (size_changed) {
		gtk_widget_queue_resize ((GtkWidget*) self);
	} else {
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
	g_object_notify_by_pspec ((GObject *) self, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_PAINTABLE_PROPERTY]);
}

static GObject *
tuba_widgets_focus_picture_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	TubaWidgetsFocusPicture * self;
	parent_class = G_OBJECT_CLASS (tuba_widgets_focus_picture_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_TYPE_FOCUS_PICTURE, TubaWidgetsFocusPicture);
	gtk_widget_set_overflow ((GtkWidget*) self, GTK_OVERFLOW_HIDDEN);
	return obj;
}

static void
tuba_widgets_focus_picture_class_init (TubaWidgetsFocusPictureClass * klass,
                                       gpointer klass_data)
{
	tuba_widgets_focus_picture_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &TubaWidgetsFocusPicture_private_offset);
	((GtkWidgetClass *) klass)->get_request_mode = (GtkSizeRequestMode (*) (GtkWidget*)) tuba_widgets_focus_picture_real_get_request_mode;
	((GtkWidgetClass *) klass)->snapshot = (void (*) (GtkWidget*, GtkSnapshot*)) tuba_widgets_focus_picture_real_snapshot;
	((GtkWidgetClass *) klass)->measure = (void (*) (GtkWidget*, GtkOrientation, gint, gint*, gint*, gint*, gint*)) tuba_widgets_focus_picture_real_measure;
	G_OBJECT_CLASS (klass)->get_property = _vala_tuba_widgets_focus_picture_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_tuba_widgets_focus_picture_set_property;
	G_OBJECT_CLASS (klass)->constructor = tuba_widgets_focus_picture_constructor;
	G_OBJECT_CLASS (klass)->finalize = tuba_widgets_focus_picture_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_X_PROPERTY, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_X_PROPERTY] = g_param_spec_double ("focus-x", "focus-x", "focus-x", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_Y_PROPERTY, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_Y_PROPERTY] = g_param_spec_double ("focus-y", "focus-y", "focus-y", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_FOCUS_PICTURE_ALTERNATIVE_TEXT_PROPERTY, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_ALTERNATIVE_TEXT_PROPERTY] = g_param_spec_string ("alternative-text", "alternative-text", "alternative-text", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_FOCUS_PICTURE_CONTENT_FIT_PROPERTY, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_CONTENT_FIT_PROPERTY] = g_param_spec_enum ("content-fit", "content-fit", "content-fit", gtk_content_fit_get_type (), 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_FOCUS_PICTURE_CAN_SHRINK_PROPERTY, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_CAN_SHRINK_PROPERTY] = g_param_spec_boolean ("can-shrink", "can-shrink", "can-shrink", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), TUBA_WIDGETS_FOCUS_PICTURE_PAINTABLE_PROPERTY, tuba_widgets_focus_picture_properties[TUBA_WIDGETS_FOCUS_PICTURE_PAINTABLE_PROPERTY] = g_param_spec_object ("paintable", "paintable", "paintable", gdk_paintable_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_css_name (GTK_WIDGET_CLASS (klass), "picture");
	gtk_widget_class_set_accessible_role (GTK_WIDGET_CLASS (klass), GTK_ACCESSIBLE_ROLE_IMG);
}

static void
tuba_widgets_focus_picture_gtk_buildable_interface_init (GtkBuildableIface * iface,
                                                         gpointer iface_data)
{
	tuba_widgets_focus_picture_gtk_buildable_parent_iface = g_type_interface_peek_parent (iface);
}

static void
tuba_widgets_focus_picture_gtk_accessible_interface_init (GtkAccessibleInterface * iface,
                                                          gpointer iface_data)
{
	tuba_widgets_focus_picture_gtk_accessible_parent_iface = g_type_interface_peek_parent (iface);
}

static void
tuba_widgets_focus_picture_instance_init (TubaWidgetsFocusPicture * self,
                                          gpointer klass)
{
	self->priv = tuba_widgets_focus_picture_get_instance_private (self);
	self->priv->paintable_invalidate_contents_signal = (gulong) 0;
	self->priv->paintable_invalidate_size_signal = (gulong) 0;
	self->priv->_focus_x = 0.0;
	self->priv->_focus_y = 0.0;
	self->priv->_alternative_text = NULL;
	self->priv->_content_fit = GTK_CONTENT_FIT_CONTAIN;
	self->priv->_can_shrink = TRUE;
	self->priv->_paintable = NULL;
}

static void
tuba_widgets_focus_picture_finalize (GObject * obj)
{
	TubaWidgetsFocusPicture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TUBA_WIDGETS_TYPE_FOCUS_PICTURE, TubaWidgetsFocusPicture);
	tuba_widgets_focus_picture_clear_paintable (self);
	_g_free0 (self->priv->_alternative_text);
	_g_object_unref0 (self->priv->_paintable);
	G_OBJECT_CLASS (tuba_widgets_focus_picture_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
tuba_widgets_focus_picture_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (TubaWidgetsFocusPictureClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) tuba_widgets_focus_picture_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (TubaWidgetsFocusPicture), 0, (GInstanceInitFunc) tuba_widgets_focus_picture_instance_init, NULL };
	static const GInterfaceInfo gtk_buildable_info = { (GInterfaceInitFunc) tuba_widgets_focus_picture_gtk_buildable_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	static const GInterfaceInfo gtk_accessible_info = { (GInterfaceInitFunc) tuba_widgets_focus_picture_gtk_accessible_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType tuba_widgets_focus_picture_type_id;
	tuba_widgets_focus_picture_type_id = g_type_register_static (gtk_widget_get_type (), "TubaWidgetsFocusPicture", &g_define_type_info, 0);
	g_type_add_interface_static (tuba_widgets_focus_picture_type_id, gtk_buildable_get_type (), &gtk_buildable_info);
	g_type_add_interface_static (tuba_widgets_focus_picture_type_id, gtk_accessible_get_type (), &gtk_accessible_info);
	TubaWidgetsFocusPicture_private_offset = g_type_add_instance_private (tuba_widgets_focus_picture_type_id, sizeof (TubaWidgetsFocusPicturePrivate));
	return tuba_widgets_focus_picture_type_id;
}

GType
tuba_widgets_focus_picture_get_type (void)
{
	static gsize tuba_widgets_focus_picture_type_id__once = 0;
	if (g_once_init_enter (&tuba_widgets_focus_picture_type_id__once)) {
		GType tuba_widgets_focus_picture_type_id;
		tuba_widgets_focus_picture_type_id = tuba_widgets_focus_picture_get_type_once ();
		g_once_init_leave (&tuba_widgets_focus_picture_type_id__once, tuba_widgets_focus_picture_type_id);
	}
	return tuba_widgets_focus_picture_type_id__once;
}

static void
_vala_tuba_widgets_focus_picture_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	TubaWidgetsFocusPicture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_TYPE_FOCUS_PICTURE, TubaWidgetsFocusPicture);
	switch (property_id) {
		case TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_X_PROPERTY:
		g_value_set_double (value, tuba_widgets_focus_picture_get_focus_x (self));
		break;
		case TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_Y_PROPERTY:
		g_value_set_double (value, tuba_widgets_focus_picture_get_focus_y (self));
		break;
		case TUBA_WIDGETS_FOCUS_PICTURE_ALTERNATIVE_TEXT_PROPERTY:
		g_value_set_string (value, tuba_widgets_focus_picture_get_alternative_text (self));
		break;
		case TUBA_WIDGETS_FOCUS_PICTURE_CONTENT_FIT_PROPERTY:
		g_value_set_enum (value, tuba_widgets_focus_picture_get_content_fit (self));
		break;
		case TUBA_WIDGETS_FOCUS_PICTURE_CAN_SHRINK_PROPERTY:
		g_value_set_boolean (value, tuba_widgets_focus_picture_get_can_shrink (self));
		break;
		case TUBA_WIDGETS_FOCUS_PICTURE_PAINTABLE_PROPERTY:
		g_value_set_object (value, tuba_widgets_focus_picture_get_paintable (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_tuba_widgets_focus_picture_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	TubaWidgetsFocusPicture * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TUBA_WIDGETS_TYPE_FOCUS_PICTURE, TubaWidgetsFocusPicture);
	switch (property_id) {
		case TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_X_PROPERTY:
		tuba_widgets_focus_picture_set_focus_x (self, g_value_get_double (value));
		break;
		case TUBA_WIDGETS_FOCUS_PICTURE_FOCUS_Y_PROPERTY:
		tuba_widgets_focus_picture_set_focus_y (self, g_value_get_double (value));
		break;
		case TUBA_WIDGETS_FOCUS_PICTURE_ALTERNATIVE_TEXT_PROPERTY:
		tuba_widgets_focus_picture_set_alternative_text (self, g_value_get_string (value));
		break;
		case TUBA_WIDGETS_FOCUS_PICTURE_CONTENT_FIT_PROPERTY:
		tuba_widgets_focus_picture_set_content_fit (self, g_value_get_enum (value));
		break;
		case TUBA_WIDGETS_FOCUS_PICTURE_CAN_SHRINK_PROPERTY:
		tuba_widgets_focus_picture_set_can_shrink (self, g_value_get_boolean (value));
		break;
		case TUBA_WIDGETS_FOCUS_PICTURE_PAINTABLE_PROPERTY:
		tuba_widgets_focus_picture_set_paintable (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

