//
// Copyright 2023 Pixar
//
// Licensed under the terms set forth in the LICENSE.txt file available at
// https://openusd.org/license.
//
////////////////////////////////////////////////////////////////////////

/* ************************************************************************** */
/* **                                                                      ** */
/* ** This file is generated by a script.                                  ** */
/* **                                                                      ** */
/* ** Do not edit it directly (unless it is within a CUSTOM CODE section)! ** */
/* ** Edit hdSchemaDefs.py instead to make changes.                        ** */
/* **                                                                      ** */
/* ************************************************************************** */

#include "pxr/imaging/hd/materialOverrideSchema.h"

#include "pxr/imaging/hd/retainedDataSource.h"

#include "pxr/base/trace/trace.h"

// --(BEGIN CUSTOM CODE: Includes)--
// --(END CUSTOM CODE: Includes)--

PXR_NAMESPACE_OPEN_SCOPE

TF_DEFINE_PUBLIC_TOKENS(HdMaterialOverrideSchemaTokens,
    HD_MATERIAL_OVERRIDE_SCHEMA_TOKENS);

// --(BEGIN CUSTOM CODE: Schema Methods)--

HdMaterialNodeParameterSchema
HdMaterialOverrideSchema::GetParameterOverride(
    const TfToken& shaderNodeName, 
    const TfToken& parameterName) const
{
    const auto paramOverrideDs = HdContainerDataSource::Get(
        _container, 
        {HdMaterialOverrideSchemaTokens->parameterValues,
        shaderNodeName, parameterName});

    return HdMaterialNodeParameterSchema(
        HdContainerDataSource::Cast(paramOverrideDs));
}

// --(END CUSTOM CODE: Schema Methods)--

HdMaterialNodeParameterContainerSchema
HdMaterialOverrideSchema::GetInterfaceValues() const
{
    return HdMaterialNodeParameterContainerSchema(_GetTypedDataSource<HdContainerDataSource>(
        HdMaterialOverrideSchemaTokens->interfaceValues));
}

HdNodeToInputToMaterialNodeParameterSchema
HdMaterialOverrideSchema::GetParameterValues() const
{
    return HdNodeToInputToMaterialNodeParameterSchema(_GetTypedDataSource<HdContainerDataSource>(
        HdMaterialOverrideSchemaTokens->parameterValues));
}

/*static*/
HdContainerDataSourceHandle
HdMaterialOverrideSchema::BuildRetained(
        const HdContainerDataSourceHandle &interfaceValues,
        const HdContainerDataSourceHandle &parameterValues
)
{
    TfToken _names[2];
    HdDataSourceBaseHandle _values[2];

    size_t _count = 0;

    if (interfaceValues) {
        _names[_count] = HdMaterialOverrideSchemaTokens->interfaceValues;
        _values[_count++] = interfaceValues;
    }

    if (parameterValues) {
        _names[_count] = HdMaterialOverrideSchemaTokens->parameterValues;
        _values[_count++] = parameterValues;
    }
    return HdRetainedContainerDataSource::New(_count, _names, _values);
}

HdMaterialOverrideSchema::Builder &
HdMaterialOverrideSchema::Builder::SetInterfaceValues(
    const HdContainerDataSourceHandle &interfaceValues)
{
    _interfaceValues = interfaceValues;
    return *this;
}

HdMaterialOverrideSchema::Builder &
HdMaterialOverrideSchema::Builder::SetParameterValues(
    const HdContainerDataSourceHandle &parameterValues)
{
    _parameterValues = parameterValues;
    return *this;
}

HdContainerDataSourceHandle
HdMaterialOverrideSchema::Builder::Build()
{
    return HdMaterialOverrideSchema::BuildRetained(
        _interfaceValues,
        _parameterValues
    );
}

/*static*/
HdMaterialOverrideSchema
HdMaterialOverrideSchema::GetFromParent(
        const HdContainerDataSourceHandle &fromParentContainer)
{
    return HdMaterialOverrideSchema(
        fromParentContainer
        ? HdContainerDataSource::Cast(fromParentContainer->Get(
                HdMaterialOverrideSchemaTokens->materialOverride))
        : nullptr);
}

/*static*/
const TfToken &
HdMaterialOverrideSchema::GetSchemaToken()
{
    return HdMaterialOverrideSchemaTokens->materialOverride;
}

/*static*/
const HdDataSourceLocator &
HdMaterialOverrideSchema::GetDefaultLocator()
{
    static const HdDataSourceLocator locator(GetSchemaToken());
    return locator;
} 

PXR_NAMESPACE_CLOSE_SCOPE