// Code generated by go-swagger; DO NOT EDIT.

package vault_service

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"

	"github.com/hashicorp/hcp-sdk-go/clients/cloud-vault-service/stable/2020-11-25/models"
)

// NewRecreateFromSnapshotParams creates a new RecreateFromSnapshotParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewRecreateFromSnapshotParams() *RecreateFromSnapshotParams {
	return &RecreateFromSnapshotParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewRecreateFromSnapshotParamsWithTimeout creates a new RecreateFromSnapshotParams object
// with the ability to set a timeout on a request.
func NewRecreateFromSnapshotParamsWithTimeout(timeout time.Duration) *RecreateFromSnapshotParams {
	return &RecreateFromSnapshotParams{
		timeout: timeout,
	}
}

// NewRecreateFromSnapshotParamsWithContext creates a new RecreateFromSnapshotParams object
// with the ability to set a context for a request.
func NewRecreateFromSnapshotParamsWithContext(ctx context.Context) *RecreateFromSnapshotParams {
	return &RecreateFromSnapshotParams{
		Context: ctx,
	}
}

// NewRecreateFromSnapshotParamsWithHTTPClient creates a new RecreateFromSnapshotParams object
// with the ability to set a custom HTTPClient for a request.
func NewRecreateFromSnapshotParamsWithHTTPClient(client *http.Client) *RecreateFromSnapshotParams {
	return &RecreateFromSnapshotParams{
		HTTPClient: client,
	}
}

/*
RecreateFromSnapshotParams contains all the parameters to send to the API endpoint

	for the recreate from snapshot operation.

	Typically these are written to a http.Request.
*/
type RecreateFromSnapshotParams struct {

	// Body.
	Body *models.HashicorpCloudVault20201125RecreateFromSnapshotRequest

	// ClusterID.
	ClusterID string

	/* LocationOrganizationID.

	   organization_id is the id of the organization.
	*/
	LocationOrganizationID string

	/* LocationProjectID.

	   project_id is the projects id.
	*/
	LocationProjectID string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the recreate from snapshot params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RecreateFromSnapshotParams) WithDefaults() *RecreateFromSnapshotParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the recreate from snapshot params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *RecreateFromSnapshotParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) WithTimeout(timeout time.Duration) *RecreateFromSnapshotParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) WithContext(ctx context.Context) *RecreateFromSnapshotParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) WithHTTPClient(client *http.Client) *RecreateFromSnapshotParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithBody adds the body to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) WithBody(body *models.HashicorpCloudVault20201125RecreateFromSnapshotRequest) *RecreateFromSnapshotParams {
	o.SetBody(body)
	return o
}

// SetBody adds the body to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) SetBody(body *models.HashicorpCloudVault20201125RecreateFromSnapshotRequest) {
	o.Body = body
}

// WithClusterID adds the clusterID to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) WithClusterID(clusterID string) *RecreateFromSnapshotParams {
	o.SetClusterID(clusterID)
	return o
}

// SetClusterID adds the clusterId to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) SetClusterID(clusterID string) {
	o.ClusterID = clusterID
}

// WithLocationOrganizationID adds the locationOrganizationID to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) WithLocationOrganizationID(locationOrganizationID string) *RecreateFromSnapshotParams {
	o.SetLocationOrganizationID(locationOrganizationID)
	return o
}

// SetLocationOrganizationID adds the locationOrganizationId to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) SetLocationOrganizationID(locationOrganizationID string) {
	o.LocationOrganizationID = locationOrganizationID
}

// WithLocationProjectID adds the locationProjectID to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) WithLocationProjectID(locationProjectID string) *RecreateFromSnapshotParams {
	o.SetLocationProjectID(locationProjectID)
	return o
}

// SetLocationProjectID adds the locationProjectId to the recreate from snapshot params
func (o *RecreateFromSnapshotParams) SetLocationProjectID(locationProjectID string) {
	o.LocationProjectID = locationProjectID
}

// WriteToRequest writes these params to a swagger request
func (o *RecreateFromSnapshotParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error
	if o.Body != nil {
		if err := r.SetBodyParam(o.Body); err != nil {
			return err
		}
	}

	// path param cluster_id
	if err := r.SetPathParam("cluster_id", o.ClusterID); err != nil {
		return err
	}

	// path param location.organization_id
	if err := r.SetPathParam("location.organization_id", o.LocationOrganizationID); err != nil {
		return err
	}

	// path param location.project_id
	if err := r.SetPathParam("location.project_id", o.LocationProjectID); err != nil {
		return err
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
