// Copyright (c) HashiCorp, Inc.
// SPDX-License-Identifier: MPL-2.0

// THIS FILE IS AUTOGENERATED USING go generate. DO NOT EDIT.
package iamutil

func GetEnabledResources() GeneratedResources {
	return generatedResources
}

var generatedResources = map[string]map[string]map[string]RestResource{
	"": {
		"iap": {
			"v1": RestResource{
				Name:                      "v1",
				TypeKey:                   "",
				Service:                   "iap",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://iap.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://iap.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "v1beta1",
				TypeKey:                   "",
				Service:                   "iap",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://iap.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://iap.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"accessPolicies": {
		"accesscontextmanager": {
			"v1": RestResource{
				Name:                      "accessPolicies",
				TypeKey:                   "accessPolicies",
				Service:                   "accesscontextmanager",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://accesscontextmanager.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://accesscontextmanager.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"b": {
		"storage": {
			"v1": RestResource{
				Name:               "buckets",
				TypeKey:            "b",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://storage.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://storage.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"b/managedFolders": {
		"storage": {
			"v1": RestResource{
				Name:               "managedFolders",
				TypeKey:            "b/managedFolders",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket", "managedFolder"},
				CollectionReplacementKeys: map[string]string{
					"b":              "bucket",
					"buckets":        "bucket",
					"managedFolders": "managedFolder",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://storage.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/managedFolders/{managedFolder}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://storage.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/managedFolders/{managedFolder}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"b/o": {
		"storage": {
			"v1": RestResource{
				Name:               "objects",
				TypeKey:            "b/o",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket", "object"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
					"o":       "object",
					"objects": "object",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://storage.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/o/{object}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://storage.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/o/{object}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"billingAccounts": {
		"cloudbilling": {
			"v1": RestResource{
				Name:                      "billingAccounts",
				TypeKey:                   "billingAccounts",
				Service:                   "cloudbilling",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudbilling.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudbilling.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"buckets": {
		"storage": {
			"v1": RestResource{
				Name:               "buckets",
				TypeKey:            "buckets",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://storage.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://storage.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"buckets/objects": {
		"storage": {
			"v1": RestResource{
				Name:               "objects",
				TypeKey:            "buckets/objects",
				Service:            "storage",
				IsPreferredVersion: true,
				Parameters:         []string{"bucket", "object"},
				CollectionReplacementKeys: map[string]string{
					"b":       "bucket",
					"buckets": "bucket",
					"o":       "object",
					"objects": "object",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://storage.googleapis.com/storage/v1/",
					Path:       "b/{bucket}/o/{object}/iam",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PUT",
					BaseURL:       "https://storage.googleapis.com/storage/v1/",
					Path:          "b/{bucket}/o/{object}/iam",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"firewallPolicies": {
		"compute": {
			"alpha": RestResource{
				Name:               "firewallPolicies",
				TypeKey:            "firewallPolicies",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"resource"},
				CollectionReplacementKeys: map[string]string{
					"firewallPolicies": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "locations/global/firewallPolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "locations/global/firewallPolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "firewallPolicies",
				TypeKey:            "firewallPolicies",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"resource"},
				CollectionReplacementKeys: map[string]string{
					"firewallPolicies": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "locations/global/firewallPolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "locations/global/firewallPolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "firewallPolicies",
				TypeKey:            "firewallPolicies",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"resource"},
				CollectionReplacementKeys: map[string]string{
					"firewallPolicies": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "locations/global/firewallPolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "locations/global/firewallPolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"folders": {
		"cloudresourcemanager": {
			"v2": RestResource{
				Name:                      "folders",
				TypeKey:                   "folders",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta1": RestResource{
				Name:                      "folders",
				TypeKey:                   "folders",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v3": RestResource{
				Name:                      "folders",
				TypeKey:                   "folders",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v3/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v3/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"folders/locations/buckets/views": {
		"logging": {
			"v2": RestResource{
				Name:                      "views",
				TypeKey:                   "folders/locations/buckets/views",
				Service:                   "logging",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://logging.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://logging.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"locations/buckets/views": {
		"logging": {
			"v2": RestResource{
				Name:                      "views",
				TypeKey:                   "locations/buckets/views",
				Service:                   "logging",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://logging.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://logging.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"locations/workforcePools": {
		"iam": {
			"v1": RestResource{
				Name:                      "workforcePools",
				TypeKey:                   "locations/workforcePools",
				Service:                   "iam",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://iam.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://iam.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"organizations": {
		"cloudresourcemanager": {
			"v1": RestResource{
				Name:                      "organizations",
				TypeKey:                   "organizations",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "organizations",
				TypeKey:                   "organizations",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v3": RestResource{
				Name:                      "organizations",
				TypeKey:                   "organizations",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v3/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v3/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"organizations/environments": {
		"apigee": {
			"v1": RestResource{
				Name:                      "environments",
				TypeKey:                   "organizations/environments",
				Service:                   "apigee",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigee.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigee.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"organizations/environments/deployments": {
		"apigee": {
			"v1": RestResource{
				Name:                      "deployments",
				TypeKey:                   "organizations/environments/deployments",
				Service:                   "apigee",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigee.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigee.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"organizations/locations/buckets/views": {
		"logging": {
			"v2": RestResource{
				Name:                      "views",
				TypeKey:                   "organizations/locations/buckets/views",
				Service:                   "logging",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://logging.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://logging.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"organizations/locations/encryptionConfigs": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "encryptionConfigs",
				TypeKey:                   "organizations/locations/encryptionConfigs",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"organizations/sources": {
		"securitycenter": {
			"v1": RestResource{
				Name:                      "sources",
				TypeKey:                   "organizations/sources",
				Service:                   "securitycenter",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://securitycenter.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://securitycenter.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "sources",
				TypeKey:                   "organizations/sources",
				Service:                   "securitycenter",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://securitycenter.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://securitycenter.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"organizations/spaces": {
		"apigee": {
			"v1": RestResource{
				Name:                      "spaces",
				TypeKey:                   "organizations/spaces",
				Service:                   "apigee",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigee.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigee.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects": {
		"cloudresourcemanager": {
			"v1": RestResource{
				Name:               "projects",
				TypeKey:            "projects",
				Service:            "cloudresourcemanager",
				IsPreferredVersion: false,
				Parameters:         []string{"resource"},
				CollectionReplacementKeys: map[string]string{
					"projects": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1/projects/{resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1/projects/{resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:               "projects",
				TypeKey:            "projects",
				Service:            "cloudresourcemanager",
				IsPreferredVersion: false,
				Parameters:         []string{"resource"},
				CollectionReplacementKeys: map[string]string{
					"projects": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v1beta1/projects/{resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v1beta1/projects/{resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v3": RestResource{
				Name:                      "projects",
				TypeKey:                   "projects",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v3/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v3/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/attestors": {
		"binaryauthorization": {
			"v1": RestResource{
				Name:                      "attestors",
				TypeKey:                   "projects/attestors",
				Service:                   "binaryauthorization",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://binaryauthorization.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://binaryauthorization.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "attestors",
				TypeKey:                   "projects/attestors",
				Service:                   "binaryauthorization",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://binaryauthorization.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://binaryauthorization.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/backendBuckets": {
		"compute": {
			"alpha": RestResource{
				Name:               "backendBuckets",
				TypeKey:            "projects/backendBuckets",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendBuckets": "resource",
					"projects":       "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/backendBuckets/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/backendBuckets/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "backendBuckets",
				TypeKey:            "projects/backendBuckets",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendBuckets": "resource",
					"projects":       "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/global/backendBuckets/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/global/backendBuckets/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "backendBuckets",
				TypeKey:            "projects/backendBuckets",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendBuckets": "resource",
					"projects":       "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/global/backendBuckets/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/global/backendBuckets/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/backendServices": {
		"compute": {
			"alpha": RestResource{
				Name:               "backendServices",
				TypeKey:            "projects/backendServices",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendServices": "resource",
					"projects":        "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/backendServices/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/backendServices/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "backendServices",
				TypeKey:            "projects/backendServices",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendServices": "resource",
					"projects":        "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/global/backendServices/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/global/backendServices/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "backendServices",
				TypeKey:            "projects/backendServices",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendServices": "resource",
					"projects":        "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/global/backendServices/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/global/backendServices/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/configs": {
		"runtimeconfig": {
			"v1beta1": RestResource{
				Name:                      "configs",
				TypeKey:                   "projects/configs",
				Service:                   "runtimeconfig",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://runtimeconfig.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://runtimeconfig.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/datasets": {
		"bigquery": {
			"v2": RestResource{
				Name:                      "datasets",
				TypeKey:                   "projects/datasets",
				Service:                   "bigquery",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://bigquery.googleapis.com",
					Path:       "bigquery/v2/{+resource}",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PATCH",
					BaseURL:       "https://bigquery.googleapis.com",
					Path:          "bigquery/v2/{+resource}",
					RequestFormat: `%s`,
				},
			},
		},
	},
	"projects/datasets/routines": {
		"bigquery": {
			"v2": RestResource{
				Name:                      "routines",
				TypeKey:                   "projects/datasets/routines",
				Service:                   "bigquery",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://bigquery.googleapis.com",
					Path:       "bigquery/v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PATCH",
					BaseURL:       "https://bigquery.googleapis.com",
					Path:          "bigquery/v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/datasets/tables": {
		"bigquery": {
			"v2": RestResource{
				Name:                      "tables",
				TypeKey:                   "projects/datasets/tables",
				Service:                   "bigquery",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://bigquery.googleapis.com",
					Path:       "bigquery/v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "PATCH",
					BaseURL:       "https://bigquery.googleapis.com",
					Path:          "bigquery/v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/deployments": {
		"deploymentmanager": {
			"alpha": RestResource{
				Name:               "deployments",
				TypeKey:            "projects/deployments",
				Service:            "deploymentmanager",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"deployments": "resource",
					"projects":    "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://deploymentmanager.googleapis.com/",
					Path:       "deploymentmanager/alpha/projects/{project}/global/deployments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://deploymentmanager.googleapis.com/",
					Path:          "deploymentmanager/alpha/projects/{project}/global/deployments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2": RestResource{
				Name:               "deployments",
				TypeKey:            "projects/deployments",
				Service:            "deploymentmanager",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"deployments": "resource",
					"projects":    "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://deploymentmanager.googleapis.com/",
					Path:       "deploymentmanager/v2/projects/{project}/global/deployments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://deploymentmanager.googleapis.com/",
					Path:          "deploymentmanager/v2/projects/{project}/global/deployments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta": RestResource{
				Name:               "deployments",
				TypeKey:            "projects/deployments",
				Service:            "deploymentmanager",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"deployments": "resource",
					"projects":    "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://deploymentmanager.googleapis.com/",
					Path:       "deploymentmanager/v2beta/projects/{project}/global/deployments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://deploymentmanager.googleapis.com/",
					Path:          "deploymentmanager/v2beta/projects/{project}/global/deployments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/firewallPolicies": {
		"compute": {
			"alpha": RestResource{
				Name:               "networkFirewallPolicies",
				TypeKey:            "projects/firewallPolicies",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"firewallPolicies": "resource",
					"projects":         "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/firewallPolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/firewallPolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "networkFirewallPolicies",
				TypeKey:            "projects/firewallPolicies",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"firewallPolicies": "resource",
					"projects":         "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/global/firewallPolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/global/firewallPolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "networkFirewallPolicies",
				TypeKey:            "projects/firewallPolicies",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"firewallPolicies": "resource",
					"projects":         "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/global/firewallPolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/global/firewallPolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/images": {
		"compute": {
			"alpha": RestResource{
				Name:               "images",
				TypeKey:            "projects/images",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"images":   "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/images/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/images/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "images",
				TypeKey:            "projects/images",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"images":   "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/global/images/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/global/images/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "images",
				TypeKey:            "projects/images",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"images":   "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/global/images/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/global/images/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instanceTemplates": {
		"compute": {
			"alpha": RestResource{
				Name:               "instanceTemplates",
				TypeKey:            "projects/instanceTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instanceTemplates": "resource",
					"projects":          "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/instanceTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/instanceTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "instanceTemplates",
				TypeKey:            "projects/instanceTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instanceTemplates": "resource",
					"projects":          "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/global/instanceTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/global/instanceTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "instanceTemplates",
				TypeKey:            "projects/instanceTemplates",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instanceTemplates": "resource",
					"projects":          "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/global/instanceTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/global/instanceTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances": {
		"bigtableadmin": {
			"v2": RestResource{
				Name:                      "instances",
				TypeKey:                   "projects/instances",
				Service:                   "bigtableadmin",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigtableadmin.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigtableadmin.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"spanner": {
			"v1": RestResource{
				Name:                      "instances",
				TypeKey:                   "projects/instances",
				Service:                   "spanner",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://spanner.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://spanner.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/backups": {
		"spanner": {
			"v1": RestResource{
				Name:                      "backups",
				TypeKey:                   "projects/instances/backups",
				Service:                   "spanner",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://spanner.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://spanner.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/clusters/backups": {
		"bigtableadmin": {
			"v2": RestResource{
				Name:                      "backups",
				TypeKey:                   "projects/instances/clusters/backups",
				Service:                   "bigtableadmin",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigtableadmin.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigtableadmin.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/databases": {
		"spanner": {
			"v1": RestResource{
				Name:                      "databases",
				TypeKey:                   "projects/instances/databases",
				Service:                   "spanner",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://spanner.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://spanner.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/databases/backupSchedules": {
		"spanner": {
			"v1": RestResource{
				Name:                      "backupSchedules",
				TypeKey:                   "projects/instances/databases/backupSchedules",
				Service:                   "spanner",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://spanner.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://spanner.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/logicalViews": {
		"bigtableadmin": {
			"v2": RestResource{
				Name:                      "logicalViews",
				TypeKey:                   "projects/instances/logicalViews",
				Service:                   "bigtableadmin",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigtableadmin.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigtableadmin.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/materializedViews": {
		"bigtableadmin": {
			"v2": RestResource{
				Name:                      "materializedViews",
				TypeKey:                   "projects/instances/materializedViews",
				Service:                   "bigtableadmin",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigtableadmin.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigtableadmin.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/tables": {
		"bigtableadmin": {
			"v2": RestResource{
				Name:                      "tables",
				TypeKey:                   "projects/instances/tables",
				Service:                   "bigtableadmin",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigtableadmin.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigtableadmin.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/instances/tables/authorizedViews": {
		"bigtableadmin": {
			"v2": RestResource{
				Name:                      "authorizedViews",
				TypeKey:                   "projects/instances/tables/authorizedViews",
				Service:                   "bigtableadmin",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigtableadmin.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigtableadmin.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/interconnectAttachmentGroups": {
		"compute": {
			"alpha": RestResource{
				Name:               "interconnectAttachmentGroups",
				TypeKey:            "projects/interconnectAttachmentGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnectAttachmentGroups": "resource",
					"projects":                     "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/interconnectAttachmentGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/interconnectAttachmentGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "interconnectAttachmentGroups",
				TypeKey:            "projects/interconnectAttachmentGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnectAttachmentGroups": "resource",
					"projects":                     "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/global/interconnectAttachmentGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/global/interconnectAttachmentGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "interconnectAttachmentGroups",
				TypeKey:            "projects/interconnectAttachmentGroups",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnectAttachmentGroups": "resource",
					"projects":                     "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/global/interconnectAttachmentGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/global/interconnectAttachmentGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/interconnectGroups": {
		"compute": {
			"alpha": RestResource{
				Name:               "interconnectGroups",
				TypeKey:            "projects/interconnectGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnectGroups": "resource",
					"projects":           "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/interconnectGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/interconnectGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "interconnectGroups",
				TypeKey:            "projects/interconnectGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnectGroups": "resource",
					"projects":           "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/global/interconnectGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/global/interconnectGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "interconnectGroups",
				TypeKey:            "projects/interconnectGroups",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnectGroups": "resource",
					"projects":           "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/global/interconnectGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/global/interconnectGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/interconnects": {
		"compute": {
			"alpha": RestResource{
				Name:               "interconnects",
				TypeKey:            "projects/interconnects",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnects": "resource",
					"projects":      "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/interconnects/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/interconnects/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/jobs": {
		"ml": {
			"v1": RestResource{
				Name:                      "jobs",
				TypeKey:                   "projects/jobs",
				Service:                   "ml",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://ml.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://ml.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/licenseCodes": {
		"compute": {
			"alpha": RestResource{
				Name:               "licenseCodes",
				TypeKey:            "projects/licenseCodes",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenseCodes": "resource",
					"projects":     "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/licenseCodes/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/licenseCodes/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/licenses": {
		"compute": {
			"alpha": RestResource{
				Name:               "licenses",
				TypeKey:            "projects/licenses",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenses": "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/licenses/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/licenses/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "licenses",
				TypeKey:            "projects/licenses",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenses": "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/global/licenses/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/global/licenses/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "licenses",
				TypeKey:            "projects/licenses",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"licenses": "resource",
					"projects": "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/global/licenses/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/global/licenses/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/addressGroups": {
		"networksecurity": {
			"v1": RestResource{
				Name:                      "addressGroups",
				TypeKey:                   "projects/locations/addressGroups",
				Service:                   "networksecurity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networksecurity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networksecurity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "addressGroups",
				TypeKey:                   "projects/locations/addressGroups",
				Service:                   "networksecurity",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networksecurity.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networksecurity.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/apis": {
		"apigateway": {
			"v1": RestResource{
				Name:                      "apis",
				TypeKey:                   "projects/locations/apis",
				Service:                   "apigateway",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigateway.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigateway.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "apis",
				TypeKey:                   "projects/locations/apis",
				Service:                   "apigateway",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigateway.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigateway.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"apigeeregistry": {
			"v1": RestResource{
				Name:                      "apis",
				TypeKey:                   "projects/locations/apis",
				Service:                   "apigeeregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigeeregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigeeregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/apis/artifacts": {
		"apigeeregistry": {
			"v1": RestResource{
				Name:                      "artifacts",
				TypeKey:                   "projects/locations/apis/artifacts",
				Service:                   "apigeeregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigeeregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigeeregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/apis/configs": {
		"apigateway": {
			"v1": RestResource{
				Name:                      "configs",
				TypeKey:                   "projects/locations/apis/configs",
				Service:                   "apigateway",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigateway.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigateway.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "configs",
				TypeKey:                   "projects/locations/apis/configs",
				Service:                   "apigateway",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigateway.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigateway.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/apis/deployments": {
		"apigeeregistry": {
			"v1": RestResource{
				Name:                      "deployments",
				TypeKey:                   "projects/locations/apis/deployments",
				Service:                   "apigeeregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigeeregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigeeregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/apis/versions": {
		"apigeeregistry": {
			"v1": RestResource{
				Name:                      "versions",
				TypeKey:                   "projects/locations/apis/versions",
				Service:                   "apigeeregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigeeregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigeeregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/apis/versions/artifacts": {
		"apigeeregistry": {
			"v1": RestResource{
				Name:                      "artifacts",
				TypeKey:                   "projects/locations/apis/versions/artifacts",
				Service:                   "apigeeregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigeeregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigeeregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/apis/versions/specs": {
		"apigeeregistry": {
			"v1": RestResource{
				Name:                      "specs",
				TypeKey:                   "projects/locations/apis/versions/specs",
				Service:                   "apigeeregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigeeregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigeeregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/apis/versions/specs/artifacts": {
		"apigeeregistry": {
			"v1": RestResource{
				Name:                      "artifacts",
				TypeKey:                   "projects/locations/apis/versions/specs/artifacts",
				Service:                   "apigeeregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigeeregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigeeregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/appConnections": {
		"beyondcorp": {
			"v1": RestResource{
				Name:                      "appConnections",
				TypeKey:                   "projects/locations/appConnections",
				Service:                   "beyondcorp",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "appConnections",
				TypeKey:                   "projects/locations/appConnections",
				Service:                   "beyondcorp",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/appConnectors": {
		"beyondcorp": {
			"v1": RestResource{
				Name:                      "appConnectors",
				TypeKey:                   "projects/locations/appConnectors",
				Service:                   "beyondcorp",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "appConnectors",
				TypeKey:                   "projects/locations/appConnectors",
				Service:                   "beyondcorp",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/appGateways": {
		"beyondcorp": {
			"v1": RestResource{
				Name:                      "appGateways",
				TypeKey:                   "projects/locations/appGateways",
				Service:                   "beyondcorp",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "appGateways",
				TypeKey:                   "projects/locations/appGateways",
				Service:                   "beyondcorp",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/applicationDomains": {
		"beyondcorp": {
			"v1alpha": RestResource{
				Name:                      "applicationDomains",
				TypeKey:                   "projects/locations/applicationDomains",
				Service:                   "beyondcorp",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/applications": {
		"apphub": {
			"v1": RestResource{
				Name:                      "applications",
				TypeKey:                   "projects/locations/applications",
				Service:                   "apphub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apphub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apphub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "applications",
				TypeKey:                   "projects/locations/applications",
				Service:                   "apphub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apphub.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apphub.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"beyondcorp": {
			"v1alpha": RestResource{
				Name:                      "applications",
				TypeKey:                   "projects/locations/applications",
				Service:                   "beyondcorp",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/artifacts": {
		"apigeeregistry": {
			"v1": RestResource{
				Name:                      "artifacts",
				TypeKey:                   "projects/locations/artifacts",
				Service:                   "apigeeregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigeeregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigeeregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/aspectTypes": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "aspectTypes",
				TypeKey:                   "projects/locations/aspectTypes",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/authorizationPolicies": {
		"networksecurity": {
			"v1": RestResource{
				Name:                      "authorizationPolicies",
				TypeKey:                   "projects/locations/authorizationPolicies",
				Service:                   "networksecurity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networksecurity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networksecurity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "authorizationPolicies",
				TypeKey:                   "projects/locations/authorizationPolicies",
				Service:                   "networksecurity",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networksecurity.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networksecurity.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/authzPolicies": {
		"networksecurity": {
			"v1": RestResource{
				Name:                      "authzPolicies",
				TypeKey:                   "projects/locations/authzPolicies",
				Service:                   "networksecurity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networksecurity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networksecurity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "authzPolicies",
				TypeKey:                   "projects/locations/authzPolicies",
				Service:                   "networksecurity",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networksecurity.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networksecurity.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/autoscalingPolicies": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "autoscalingPolicies",
				TypeKey:                   "projects/locations/autoscalingPolicies",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/backupPlans": {
		"gkebackup": {
			"v1": RestResource{
				Name:                      "backupPlans",
				TypeKey:                   "projects/locations/backupPlans",
				Service:                   "gkebackup",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkebackup.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkebackup.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/backupPlans/backups": {
		"gkebackup": {
			"v1": RestResource{
				Name:                      "backups",
				TypeKey:                   "projects/locations/backupPlans/backups",
				Service:                   "gkebackup",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkebackup.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkebackup.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/backupPlans/backups/volumeBackups": {
		"gkebackup": {
			"v1": RestResource{
				Name:                      "volumeBackups",
				TypeKey:                   "projects/locations/backupPlans/backups/volumeBackups",
				Service:                   "gkebackup",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkebackup.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkebackup.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/bareMetalAdminClusters": {
		"gkeonprem": {
			"v1": RestResource{
				Name:                      "bareMetalAdminClusters",
				TypeKey:                   "projects/locations/bareMetalAdminClusters",
				Service:                   "gkeonprem",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkeonprem.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkeonprem.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/bareMetalClusters": {
		"gkeonprem": {
			"v1": RestResource{
				Name:                      "bareMetalClusters",
				TypeKey:                   "projects/locations/bareMetalClusters",
				Service:                   "gkeonprem",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkeonprem.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkeonprem.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/bareMetalClusters/bareMetalNodePools": {
		"gkeonprem": {
			"v1": RestResource{
				Name:                      "bareMetalNodePools",
				TypeKey:                   "projects/locations/bareMetalClusters/bareMetalNodePools",
				Service:                   "gkeonprem",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkeonprem.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkeonprem.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/buckets/views": {
		"logging": {
			"v2": RestResource{
				Name:                      "views",
				TypeKey:                   "projects/locations/buckets/views",
				Service:                   "logging",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://logging.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://logging.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/caPools": {
		"privateca": {
			"v1": RestResource{
				Name:                      "caPools",
				TypeKey:                   "projects/locations/caPools",
				Service:                   "privateca",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://privateca.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://privateca.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/caPools/certificateAuthorities/certificateRevocationLists": {
		"privateca": {
			"v1": RestResource{
				Name:                      "certificateRevocationLists",
				TypeKey:                   "projects/locations/caPools/certificateAuthorities/certificateRevocationLists",
				Service:                   "privateca",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://privateca.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://privateca.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/certificateAuthorities": {
		"privateca": {
			"v1beta1": RestResource{
				Name:                      "certificateAuthorities",
				TypeKey:                   "projects/locations/certificateAuthorities",
				Service:                   "privateca",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://privateca.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://privateca.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/certificateAuthorities/certificateRevocationLists": {
		"privateca": {
			"v1beta1": RestResource{
				Name:                      "certificateRevocationLists",
				TypeKey:                   "projects/locations/certificateAuthorities/certificateRevocationLists",
				Service:                   "privateca",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://privateca.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://privateca.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/certificateTemplates": {
		"privateca": {
			"v1": RestResource{
				Name:                      "certificateTemplates",
				TypeKey:                   "projects/locations/certificateTemplates",
				Service:                   "privateca",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://privateca.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://privateca.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/channelConnections": {
		"eventarc": {
			"v1": RestResource{
				Name:                      "channelConnections",
				TypeKey:                   "projects/locations/channelConnections",
				Service:                   "eventarc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://eventarc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://eventarc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/channels": {
		"eventarc": {
			"v1": RestResource{
				Name:                      "channels",
				TypeKey:                   "projects/locations/channels",
				Service:                   "eventarc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://eventarc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://eventarc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/clientConnectorServices": {
		"beyondcorp": {
			"v1": RestResource{
				Name:                      "clientConnectorServices",
				TypeKey:                   "projects/locations/clientConnectorServices",
				Service:                   "beyondcorp",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "clientConnectorServices",
				TypeKey:                   "projects/locations/clientConnectorServices",
				Service:                   "beyondcorp",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/clientTlsPolicies": {
		"networksecurity": {
			"v1": RestResource{
				Name:                      "clientTlsPolicies",
				TypeKey:                   "projects/locations/clientTlsPolicies",
				Service:                   "networksecurity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networksecurity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networksecurity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "clientTlsPolicies",
				TypeKey:                   "projects/locations/clientTlsPolicies",
				Service:                   "networksecurity",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networksecurity.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networksecurity.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/connectionProfiles": {
		"datamigration": {
			"v1": RestResource{
				Name:                      "connectionProfiles",
				TypeKey:                   "projects/locations/connectionProfiles",
				Service:                   "datamigration",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://datamigration.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datamigration.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "connectionProfiles",
				TypeKey:                   "projects/locations/connectionProfiles",
				Service:                   "datamigration",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://datamigration.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datamigration.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/connections": {
		"beyondcorp": {
			"v1alpha": RestResource{
				Name:                      "connections",
				TypeKey:                   "projects/locations/connections",
				Service:                   "beyondcorp",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"bigqueryconnection": {
			"v1": RestResource{
				Name:                      "connections",
				TypeKey:                   "projects/locations/connections",
				Service:                   "bigqueryconnection",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigqueryconnection.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigqueryconnection.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "connections",
				TypeKey:                   "projects/locations/connections",
				Service:                   "bigqueryconnection",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigqueryconnection.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigqueryconnection.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"cloudbuild": {
			"v2": RestResource{
				Name:                      "connections",
				TypeKey:                   "projects/locations/connections",
				Service:                   "cloudbuild",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudbuild.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudbuild.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"connectors": {
			"v1": RestResource{
				Name:                      "connections",
				TypeKey:                   "projects/locations/connections",
				Service:                   "connectors",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://connectors.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://connectors.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/connectivityTests": {
		"networkmanagement": {
			"v1": RestResource{
				Name:                      "connectivityTests",
				TypeKey:                   "projects/locations/connectivityTests",
				Service:                   "networkmanagement",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkmanagement.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkmanagement.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "connectivityTests",
				TypeKey:                   "projects/locations/connectivityTests",
				Service:                   "networkmanagement",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkmanagement.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkmanagement.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/connectors": {
		"beyondcorp": {
			"v1alpha": RestResource{
				Name:                      "connectors",
				TypeKey:                   "projects/locations/connectors",
				Service:                   "beyondcorp",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/conversionWorkspaces": {
		"datamigration": {
			"v1": RestResource{
				Name:                      "conversionWorkspaces",
				TypeKey:                   "projects/locations/conversionWorkspaces",
				Service:                   "datamigration",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://datamigration.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datamigration.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/customTargetTypes": {
		"clouddeploy": {
			"v1": RestResource{
				Name:                      "customTargetTypes",
				TypeKey:                   "projects/locations/customTargetTypes",
				Service:                   "clouddeploy",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://clouddeploy.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://clouddeploy.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/dataAttributeBindings": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "dataAttributeBindings",
				TypeKey:                   "projects/locations/dataAttributeBindings",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/dataExchanges": {
		"analyticshub": {
			"v1": RestResource{
				Name:                      "dataExchanges",
				TypeKey:                   "projects/locations/dataExchanges",
				Service:                   "analyticshub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://analyticshub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://analyticshub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "dataExchanges",
				TypeKey:                   "projects/locations/dataExchanges",
				Service:                   "analyticshub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://analyticshub.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://analyticshub.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/dataExchanges/listings": {
		"analyticshub": {
			"v1": RestResource{
				Name:                      "listings",
				TypeKey:                   "projects/locations/dataExchanges/listings",
				Service:                   "analyticshub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://analyticshub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://analyticshub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "listings",
				TypeKey:                   "projects/locations/dataExchanges/listings",
				Service:                   "analyticshub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://analyticshub.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://analyticshub.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/dataPolicies": {
		"bigquerydatapolicy": {
			"v1": RestResource{
				Name:                      "dataPolicies",
				TypeKey:                   "projects/locations/dataPolicies",
				Service:                   "bigquerydatapolicy",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://bigquerydatapolicy.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigquerydatapolicy.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/dataScans": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "dataScans",
				TypeKey:                   "projects/locations/dataScans",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/dataTaxonomies": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "dataTaxonomies",
				TypeKey:                   "projects/locations/dataTaxonomies",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/dataTaxonomies/attributes": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "attributes",
				TypeKey:                   "projects/locations/dataTaxonomies/attributes",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets": {
		"healthcare": {
			"v1": RestResource{
				Name:                      "datasets",
				TypeKey:                   "projects/locations/datasets",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "datasets",
				TypeKey:                   "projects/locations/datasets",
				Service:                   "healthcare",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/annotationStores": {
		"healthcare": {
			"v1beta1": RestResource{
				Name:                      "annotationStores",
				TypeKey:                   "projects/locations/datasets/annotationStores",
				Service:                   "healthcare",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/consentStores": {
		"healthcare": {
			"v1": RestResource{
				Name:                      "consentStores",
				TypeKey:                   "projects/locations/datasets/consentStores",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "consentStores",
				TypeKey:                   "projects/locations/datasets/consentStores",
				Service:                   "healthcare",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/dataMapperWorkspaces": {
		"healthcare": {
			"v1": RestResource{
				Name:                      "dataMapperWorkspaces",
				TypeKey:                   "projects/locations/datasets/dataMapperWorkspaces",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "dataMapperWorkspaces",
				TypeKey:                   "projects/locations/datasets/dataMapperWorkspaces",
				Service:                   "healthcare",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/dicomStores": {
		"healthcare": {
			"v1": RestResource{
				Name:                      "dicomStores",
				TypeKey:                   "projects/locations/datasets/dicomStores",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "dicomStores",
				TypeKey:                   "projects/locations/datasets/dicomStores",
				Service:                   "healthcare",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/datasets/fhirStores": {
		"healthcare": {
			"v1": RestResource{
				Name:                      "fhirStores",
				TypeKey:                   "projects/locations/datasets/fhirStores",
				Service:                   "healthcare",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "fhirStores",
				TypeKey:                   "projects/locations/datasets/fhirStores",
				Service:                   "healthcare",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://healthcare.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://healthcare.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/deliveryPipelines": {
		"clouddeploy": {
			"v1": RestResource{
				Name:                      "deliveryPipelines",
				TypeKey:                   "projects/locations/deliveryPipelines",
				Service:                   "clouddeploy",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://clouddeploy.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://clouddeploy.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/deployPolicies": {
		"clouddeploy": {
			"v1": RestResource{
				Name:                      "deployPolicies",
				TypeKey:                   "projects/locations/deployPolicies",
				Service:                   "clouddeploy",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://clouddeploy.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://clouddeploy.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/deployments": {
		"config": {
			"v1": RestResource{
				Name:                      "deployments",
				TypeKey:                   "projects/locations/deployments",
				Service:                   "config",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://config.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://config.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/documents": {
		"apigeeregistry": {
			"v1": RestResource{
				Name:                      "documents",
				TypeKey:                   "projects/locations/documents",
				Service:                   "apigeeregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigeeregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigeeregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/domains": {
		"managedidentities": {
			"v1": RestResource{
				Name:                      "domains",
				TypeKey:                   "projects/locations/domains",
				Service:                   "managedidentities",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha1": RestResource{
				Name:                      "domains",
				TypeKey:                   "projects/locations/domains",
				Service:                   "managedidentities",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "domains",
				TypeKey:                   "projects/locations/domains",
				Service:                   "managedidentities",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/domains/backups": {
		"managedidentities": {
			"v1": RestResource{
				Name:                      "backups",
				TypeKey:                   "projects/locations/domains/backups",
				Service:                   "managedidentities",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha1": RestResource{
				Name:                      "backups",
				TypeKey:                   "projects/locations/domains/backups",
				Service:                   "managedidentities",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "backups",
				TypeKey:                   "projects/locations/domains/backups",
				Service:                   "managedidentities",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/edgeCacheKeysets": {
		"networkservices": {
			"v1": RestResource{
				Name:                      "edgeCacheKeysets",
				TypeKey:                   "projects/locations/edgeCacheKeysets",
				Service:                   "networkservices",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkservices.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkservices.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/edgeCacheOrigins": {
		"networkservices": {
			"v1": RestResource{
				Name:                      "edgeCacheOrigins",
				TypeKey:                   "projects/locations/edgeCacheOrigins",
				Service:                   "networkservices",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkservices.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkservices.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/edgeCacheServices": {
		"networkservices": {
			"v1": RestResource{
				Name:                      "edgeCacheServices",
				TypeKey:                   "projects/locations/edgeCacheServices",
				Service:                   "networkservices",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkservices.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkservices.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/ekmConfig": {
		"cloudkms": {
			"v1": RestResource{
				Name:                      "ekmConfig",
				TypeKey:                   "projects/locations/ekmConfig",
				Service:                   "cloudkms",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudkms.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudkms.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/ekmConnections": {
		"cloudkms": {
			"v1": RestResource{
				Name:                      "ekmConnections",
				TypeKey:                   "projects/locations/ekmConnections",
				Service:                   "cloudkms",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudkms.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudkms.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/endpoints": {
		"aiplatform": {
			"v1beta1": RestResource{
				Name:                      "endpoints",
				TypeKey:                   "projects/locations/endpoints",
				Service:                   "aiplatform",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/enrollments": {
		"eventarc": {
			"v1": RestResource{
				Name:                      "enrollments",
				TypeKey:                   "projects/locations/enrollments",
				Service:                   "eventarc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://eventarc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://eventarc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/entryGroups": {
		"datacatalog": {
			"v1": RestResource{
				Name:                      "entryGroups",
				TypeKey:                   "projects/locations/entryGroups",
				Service:                   "datacatalog",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "entryGroups",
				TypeKey:                   "projects/locations/entryGroups",
				Service:                   "datacatalog",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"dataplex": {
			"v1": RestResource{
				Name:                      "entryGroups",
				TypeKey:                   "projects/locations/entryGroups",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/entryLinkTypes": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "entryLinkTypes",
				TypeKey:                   "projects/locations/entryLinkTypes",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/entryTypes": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "entryTypes",
				TypeKey:                   "projects/locations/entryTypes",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/featureGroups": {
		"aiplatform": {
			"v1": RestResource{
				Name:                      "featureGroups",
				TypeKey:                   "projects/locations/featureGroups",
				Service:                   "aiplatform",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "featureGroups",
				TypeKey:                   "projects/locations/featureGroups",
				Service:                   "aiplatform",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/featureOnlineStores": {
		"aiplatform": {
			"v1": RestResource{
				Name:                      "featureOnlineStores",
				TypeKey:                   "projects/locations/featureOnlineStores",
				Service:                   "aiplatform",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "featureOnlineStores",
				TypeKey:                   "projects/locations/featureOnlineStores",
				Service:                   "aiplatform",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/featureOnlineStores/featureViews": {
		"aiplatform": {
			"v1": RestResource{
				Name:                      "featureViews",
				TypeKey:                   "projects/locations/featureOnlineStores/featureViews",
				Service:                   "aiplatform",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "featureViews",
				TypeKey:                   "projects/locations/featureOnlineStores/featureViews",
				Service:                   "aiplatform",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/features": {
		"gkehub": {
			"v1": RestResource{
				Name:                      "features",
				TypeKey:                   "projects/locations/features",
				Service:                   "gkehub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkehub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkehub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "features",
				TypeKey:                   "projects/locations/features",
				Service:                   "gkehub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkehub.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkehub.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "features",
				TypeKey:                   "projects/locations/features",
				Service:                   "gkehub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkehub.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkehub.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/featurestores": {
		"aiplatform": {
			"v1": RestResource{
				Name:                      "featurestores",
				TypeKey:                   "projects/locations/featurestores",
				Service:                   "aiplatform",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "featurestores",
				TypeKey:                   "projects/locations/featurestores",
				Service:                   "aiplatform",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/featurestores/entityTypes": {
		"aiplatform": {
			"v1": RestResource{
				Name:                      "entityTypes",
				TypeKey:                   "projects/locations/featurestores/entityTypes",
				Service:                   "aiplatform",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "entityTypes",
				TypeKey:                   "projects/locations/featurestores/entityTypes",
				Service:                   "aiplatform",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/federations": {
		"metastore": {
			"v1": RestResource{
				Name:                      "federations",
				TypeKey:                   "projects/locations/federations",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "federations",
				TypeKey:                   "projects/locations/federations",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "federations",
				TypeKey:                   "projects/locations/federations",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/functions": {
		"cloudfunctions": {
			"v1": RestResource{
				Name:                      "functions",
				TypeKey:                   "projects/locations/functions",
				Service:                   "cloudfunctions",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudfunctions.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudfunctions.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2": RestResource{
				Name:                      "functions",
				TypeKey:                   "projects/locations/functions",
				Service:                   "cloudfunctions",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudfunctions.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudfunctions.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2alpha": RestResource{
				Name:                      "functions",
				TypeKey:                   "projects/locations/functions",
				Service:                   "cloudfunctions",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudfunctions.googleapis.com/",
					Path:       "v2alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudfunctions.googleapis.com/",
					Path:          "v2alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta": RestResource{
				Name:                      "functions",
				TypeKey:                   "projects/locations/functions",
				Service:                   "cloudfunctions",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudfunctions.googleapis.com/",
					Path:       "v2beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudfunctions.googleapis.com/",
					Path:          "v2beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/gateways": {
		"apigateway": {
			"v1": RestResource{
				Name:                      "gateways",
				TypeKey:                   "projects/locations/gateways",
				Service:                   "apigateway",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigateway.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigateway.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "gateways",
				TypeKey:                   "projects/locations/gateways",
				Service:                   "apigateway",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigateway.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigateway.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/glossaries": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "glossaries",
				TypeKey:                   "projects/locations/glossaries",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/glossaries/categories": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "categories",
				TypeKey:                   "projects/locations/glossaries/categories",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/glossaries/terms": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "terms",
				TypeKey:                   "projects/locations/glossaries/terms",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/googleApiSources": {
		"eventarc": {
			"v1": RestResource{
				Name:                      "googleApiSources",
				TypeKey:                   "projects/locations/googleApiSources",
				Service:                   "eventarc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://eventarc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://eventarc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/governanceRules": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "governanceRules",
				TypeKey:                   "projects/locations/governanceRules",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/hubs": {
		"networkconnectivity": {
			"v1": RestResource{
				Name:                      "hubs",
				TypeKey:                   "projects/locations/hubs",
				Service:                   "networkconnectivity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkconnectivity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkconnectivity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha1": RestResource{
				Name:                      "hubs",
				TypeKey:                   "projects/locations/hubs",
				Service:                   "networkconnectivity",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkconnectivity.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkconnectivity.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/hubs/groups": {
		"networkconnectivity": {
			"v1": RestResource{
				Name:                      "groups",
				TypeKey:                   "projects/locations/hubs/groups",
				Service:                   "networkconnectivity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkconnectivity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkconnectivity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/instances": {
		"apigeeregistry": {
			"v1": RestResource{
				Name:                      "instances",
				TypeKey:                   "projects/locations/instances",
				Service:                   "apigeeregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigeeregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigeeregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"datafusion": {
			"v1": RestResource{
				Name:                      "instances",
				TypeKey:                   "projects/locations/instances",
				Service:                   "datafusion",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://datafusion.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datafusion.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "instances",
				TypeKey:                   "projects/locations/instances",
				Service:                   "datafusion",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://datafusion.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datafusion.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"notebooks": {
			"v1": RestResource{
				Name:                      "instances",
				TypeKey:                   "projects/locations/instances",
				Service:                   "notebooks",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://notebooks.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://notebooks.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2": RestResource{
				Name:                      "instances",
				TypeKey:                   "projects/locations/instances",
				Service:                   "notebooks",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://notebooks.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://notebooks.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/instances/namespaces": {
		"datafusion": {
			"v1beta1": RestResource{
				Name:                      "namespaces",
				TypeKey:                   "projects/locations/instances/namespaces",
				Service:                   "datafusion",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://datafusion.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datafusion.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/internalRanges": {
		"networkconnectivity": {
			"v1": RestResource{
				Name:                      "internalRanges",
				TypeKey:                   "projects/locations/internalRanges",
				Service:                   "networkconnectivity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkconnectivity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkconnectivity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha1": RestResource{
				Name:                      "internalRanges",
				TypeKey:                   "projects/locations/internalRanges",
				Service:                   "networkconnectivity",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkconnectivity.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkconnectivity.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/jobs": {
		"run": {
			"v1": RestResource{
				Name:                      "jobs",
				TypeKey:                   "projects/locations/jobs",
				Service:                   "run",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://run.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://run.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2": RestResource{
				Name:                      "jobs",
				TypeKey:                   "projects/locations/jobs",
				Service:                   "run",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://run.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://run.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/kafkaSources": {
		"eventarc": {
			"v1": RestResource{
				Name:                      "kafkaSources",
				TypeKey:                   "projects/locations/kafkaSources",
				Service:                   "eventarc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://eventarc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://eventarc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/keyRings": {
		"cloudkms": {
			"v1": RestResource{
				Name:                      "keyRings",
				TypeKey:                   "projects/locations/keyRings",
				Service:                   "cloudkms",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudkms.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudkms.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/keyRings/cryptoKeys": {
		"cloudkms": {
			"v1": RestResource{
				Name:                      "cryptoKeys",
				TypeKey:                   "projects/locations/keyRings/cryptoKeys",
				Service:                   "cloudkms",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudkms.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudkms.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/keyRings/importJobs": {
		"cloudkms": {
			"v1": RestResource{
				Name:                      "importJobs",
				TypeKey:                   "projects/locations/keyRings/importJobs",
				Service:                   "cloudkms",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://cloudkms.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudkms.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/lakes": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "lakes",
				TypeKey:                   "projects/locations/lakes",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/lakes/content": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "content",
				TypeKey:                   "projects/locations/lakes/content",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/lakes/contentitems": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "contentitems",
				TypeKey:                   "projects/locations/lakes/contentitems",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/lakes/environments": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "environments",
				TypeKey:                   "projects/locations/lakes/environments",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/lakes/tasks": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "tasks",
				TypeKey:                   "projects/locations/lakes/tasks",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/lakes/zones": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "zones",
				TypeKey:                   "projects/locations/lakes/zones",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/lakes/zones/assets": {
		"dataplex": {
			"v1": RestResource{
				Name:                      "assets",
				TypeKey:                   "projects/locations/lakes/zones/assets",
				Service:                   "dataplex",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataplex.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataplex.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/managementServers": {
		"backupdr": {
			"v1": RestResource{
				Name:                      "managementServers",
				TypeKey:                   "projects/locations/managementServers",
				Service:                   "backupdr",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://backupdr.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://backupdr.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/memberships": {
		"gkehub": {
			"v1": RestResource{
				Name:                      "memberships",
				TypeKey:                   "projects/locations/memberships",
				Service:                   "gkehub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkehub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkehub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "memberships",
				TypeKey:                   "projects/locations/memberships",
				Service:                   "gkehub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkehub.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkehub.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "memberships",
				TypeKey:                   "projects/locations/memberships",
				Service:                   "gkehub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkehub.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkehub.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "memberships",
				TypeKey:                   "projects/locations/memberships",
				Service:                   "gkehub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkehub.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkehub.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/messageBuses": {
		"eventarc": {
			"v1": RestResource{
				Name:                      "messageBuses",
				TypeKey:                   "projects/locations/messageBuses",
				Service:                   "eventarc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://eventarc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://eventarc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/migrationJobs": {
		"datamigration": {
			"v1": RestResource{
				Name:                      "migrationJobs",
				TypeKey:                   "projects/locations/migrationJobs",
				Service:                   "datamigration",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://datamigration.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datamigration.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "migrationJobs",
				TypeKey:                   "projects/locations/migrationJobs",
				Service:                   "datamigration",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://datamigration.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datamigration.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/migrationJobs/objects": {
		"datamigration": {
			"v1": RestResource{
				Name:                      "objects",
				TypeKey:                   "projects/locations/migrationJobs/objects",
				Service:                   "datamigration",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://datamigration.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datamigration.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/models": {
		"aiplatform": {
			"v1": RestResource{
				Name:                      "models",
				TypeKey:                   "projects/locations/models",
				Service:                   "aiplatform",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "models",
				TypeKey:                   "projects/locations/models",
				Service:                   "aiplatform",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/namespaces": {
		"servicedirectory": {
			"v1": RestResource{
				Name:                      "namespaces",
				TypeKey:                   "projects/locations/namespaces",
				Service:                   "servicedirectory",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicedirectory.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicedirectory.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "namespaces",
				TypeKey:                   "projects/locations/namespaces",
				Service:                   "servicedirectory",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicedirectory.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicedirectory.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/namespaces/services": {
		"servicedirectory": {
			"v1": RestResource{
				Name:                      "services",
				TypeKey:                   "projects/locations/namespaces/services",
				Service:                   "servicedirectory",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicedirectory.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicedirectory.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "services",
				TypeKey:                   "projects/locations/namespaces/services",
				Service:                   "servicedirectory",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicedirectory.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicedirectory.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/namespaces/workloads": {
		"servicedirectory": {
			"v1beta1": RestResource{
				Name:                      "workloads",
				TypeKey:                   "projects/locations/namespaces/workloads",
				Service:                   "servicedirectory",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicedirectory.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicedirectory.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/notebookRuntimeTemplates": {
		"aiplatform": {
			"v1": RestResource{
				Name:                      "notebookRuntimeTemplates",
				TypeKey:                   "projects/locations/notebookRuntimeTemplates",
				Service:                   "aiplatform",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "notebookRuntimeTemplates",
				TypeKey:                   "projects/locations/notebookRuntimeTemplates",
				Service:                   "aiplatform",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://aiplatform.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://aiplatform.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/notes": {
		"containeranalysis": {
			"v1": RestResource{
				Name:                      "notes",
				TypeKey:                   "projects/locations/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "notes",
				TypeKey:                   "projects/locations/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/occurrences": {
		"containeranalysis": {
			"v1": RestResource{
				Name:                      "occurrences",
				TypeKey:                   "projects/locations/occurrences",
				Service:                   "containeranalysis",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "occurrences",
				TypeKey:                   "projects/locations/occurrences",
				Service:                   "containeranalysis",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/peerings": {
		"managedidentities": {
			"v1": RestResource{
				Name:                      "peerings",
				TypeKey:                   "projects/locations/peerings",
				Service:                   "managedidentities",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha1": RestResource{
				Name:                      "peerings",
				TypeKey:                   "projects/locations/peerings",
				Service:                   "managedidentities",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "peerings",
				TypeKey:                   "projects/locations/peerings",
				Service:                   "managedidentities",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://managedidentities.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://managedidentities.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/pipelines": {
		"eventarc": {
			"v1": RestResource{
				Name:                      "pipelines",
				TypeKey:                   "projects/locations/pipelines",
				Service:                   "eventarc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://eventarc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://eventarc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/policyBasedRoutes": {
		"networkconnectivity": {
			"v1": RestResource{
				Name:                      "policyBasedRoutes",
				TypeKey:                   "projects/locations/policyBasedRoutes",
				Service:                   "networkconnectivity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkconnectivity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkconnectivity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/privateClouds": {
		"vmwareengine": {
			"v1": RestResource{
				Name:                      "privateClouds",
				TypeKey:                   "projects/locations/privateClouds",
				Service:                   "vmwareengine",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://vmwareengine.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://vmwareengine.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/privateClouds/clusters": {
		"vmwareengine": {
			"v1": RestResource{
				Name:                      "clusters",
				TypeKey:                   "projects/locations/privateClouds/clusters",
				Service:                   "vmwareengine",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://vmwareengine.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://vmwareengine.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/privateClouds/hcxActivationKeys": {
		"vmwareengine": {
			"v1": RestResource{
				Name:                      "hcxActivationKeys",
				TypeKey:                   "projects/locations/privateClouds/hcxActivationKeys",
				Service:                   "vmwareengine",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://vmwareengine.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://vmwareengine.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/privateConnections": {
		"datamigration": {
			"v1": RestResource{
				Name:                      "privateConnections",
				TypeKey:                   "projects/locations/privateConnections",
				Service:                   "datamigration",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://datamigration.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datamigration.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/providers": {
		"connectors": {
			"v1": RestResource{
				Name:                      "providers",
				TypeKey:                   "projects/locations/providers",
				Service:                   "connectors",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://connectors.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://connectors.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/queues": {
		"cloudtasks": {
			"v2": RestResource{
				Name:                      "queues",
				TypeKey:                   "projects/locations/queues",
				Service:                   "cloudtasks",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudtasks.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudtasks.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta2": RestResource{
				Name:                      "queues",
				TypeKey:                   "projects/locations/queues",
				Service:                   "cloudtasks",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudtasks.googleapis.com/",
					Path:       "v2beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudtasks.googleapis.com/",
					Path:          "v2beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2beta3": RestResource{
				Name:                      "queues",
				TypeKey:                   "projects/locations/queues",
				Service:                   "cloudtasks",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudtasks.googleapis.com/",
					Path:       "v2beta3/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudtasks.googleapis.com/",
					Path:          "v2beta3/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/registrations": {
		"domains": {
			"v1": RestResource{
				Name:                      "registrations",
				TypeKey:                   "projects/locations/registrations",
				Service:                   "domains",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://domains.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://domains.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha2": RestResource{
				Name:                      "registrations",
				TypeKey:                   "projects/locations/registrations",
				Service:                   "domains",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://domains.googleapis.com/",
					Path:       "v1alpha2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://domains.googleapis.com/",
					Path:          "v1alpha2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "registrations",
				TypeKey:                   "projects/locations/registrations",
				Service:                   "domains",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://domains.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://domains.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/repositories": {
		"artifactregistry": {
			"v1": RestResource{
				Name:                      "repositories",
				TypeKey:                   "projects/locations/repositories",
				Service:                   "artifactregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://artifactregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://artifactregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "repositories",
				TypeKey:                   "projects/locations/repositories",
				Service:                   "artifactregistry",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://artifactregistry.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://artifactregistry.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "repositories",
				TypeKey:                   "projects/locations/repositories",
				Service:                   "artifactregistry",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://artifactregistry.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://artifactregistry.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"dataform": {
			"v1beta1": RestResource{
				Name:                      "repositories",
				TypeKey:                   "projects/locations/repositories",
				Service:                   "dataform",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataform.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataform.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/repositories/workspaces": {
		"dataform": {
			"v1beta1": RestResource{
				Name:                      "workspaces",
				TypeKey:                   "projects/locations/repositories/workspaces",
				Service:                   "dataform",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://dataform.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataform.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/reservations": {
		"bigqueryreservation": {
			"v1": RestResource{
				Name:                      "reservations",
				TypeKey:                   "projects/locations/reservations",
				Service:                   "bigqueryreservation",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://bigqueryreservation.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigqueryreservation.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/reservations/assignments": {
		"bigqueryreservation": {
			"v1": RestResource{
				Name:                      "assignments",
				TypeKey:                   "projects/locations/reservations/assignments",
				Service:                   "bigqueryreservation",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://bigqueryreservation.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://bigqueryreservation.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/restorePlans": {
		"gkebackup": {
			"v1": RestResource{
				Name:                      "restorePlans",
				TypeKey:                   "projects/locations/restorePlans",
				Service:                   "gkebackup",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkebackup.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkebackup.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/restorePlans/restores": {
		"gkebackup": {
			"v1": RestResource{
				Name:                      "restores",
				TypeKey:                   "projects/locations/restorePlans/restores",
				Service:                   "gkebackup",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkebackup.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkebackup.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/restorePlans/restores/volumeRestores": {
		"gkebackup": {
			"v1": RestResource{
				Name:                      "volumeRestores",
				TypeKey:                   "projects/locations/restorePlans/restores/volumeRestores",
				Service:                   "gkebackup",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkebackup.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkebackup.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/reusableConfigs": {
		"privateca": {
			"v1beta1": RestResource{
				Name:                      "reusableConfigs",
				TypeKey:                   "projects/locations/reusableConfigs",
				Service:                   "privateca",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://privateca.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://privateca.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/runtime": {
		"apigeeregistry": {
			"v1": RestResource{
				Name:                      "runtime",
				TypeKey:                   "projects/locations/runtime",
				Service:                   "apigeeregistry",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://apigeeregistry.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://apigeeregistry.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/runtimes": {
		"notebooks": {
			"v1": RestResource{
				Name:                      "runtimes",
				TypeKey:                   "projects/locations/runtimes",
				Service:                   "notebooks",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://notebooks.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://notebooks.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/scopes": {
		"gkehub": {
			"v1": RestResource{
				Name:                      "scopes",
				TypeKey:                   "projects/locations/scopes",
				Service:                   "gkehub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkehub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkehub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "scopes",
				TypeKey:                   "projects/locations/scopes",
				Service:                   "gkehub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkehub.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkehub.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "scopes",
				TypeKey:                   "projects/locations/scopes",
				Service:                   "gkehub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkehub.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkehub.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/secrets": {
		"secretmanager": {
			"v1": RestResource{
				Name:                      "secrets",
				TypeKey:                   "projects/locations/secrets",
				Service:                   "secretmanager",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://secretmanager.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://secretmanager.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "secrets",
				TypeKey:                   "projects/locations/secrets",
				Service:                   "secretmanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://secretmanager.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://secretmanager.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/securityGateways": {
		"beyondcorp": {
			"v1": RestResource{
				Name:                      "securityGateways",
				TypeKey:                   "projects/locations/securityGateways",
				Service:                   "beyondcorp",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "securityGateways",
				TypeKey:                   "projects/locations/securityGateways",
				Service:                   "beyondcorp",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/securityGateways/applications": {
		"beyondcorp": {
			"v1": RestResource{
				Name:                      "applications",
				TypeKey:                   "projects/locations/securityGateways/applications",
				Service:                   "beyondcorp",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "applications",
				TypeKey:                   "projects/locations/securityGateways/applications",
				Service:                   "beyondcorp",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://beyondcorp.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://beyondcorp.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/serverTlsPolicies": {
		"networksecurity": {
			"v1": RestResource{
				Name:                      "serverTlsPolicies",
				TypeKey:                   "projects/locations/serverTlsPolicies",
				Service:                   "networksecurity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networksecurity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networksecurity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "serverTlsPolicies",
				TypeKey:                   "projects/locations/serverTlsPolicies",
				Service:                   "networksecurity",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networksecurity.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networksecurity.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/serviceClasses": {
		"networkconnectivity": {
			"v1": RestResource{
				Name:                      "serviceClasses",
				TypeKey:                   "projects/locations/serviceClasses",
				Service:                   "networkconnectivity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkconnectivity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkconnectivity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/serviceConnectionMaps": {
		"networkconnectivity": {
			"v1": RestResource{
				Name:                      "serviceConnectionMaps",
				TypeKey:                   "projects/locations/serviceConnectionMaps",
				Service:                   "networkconnectivity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkconnectivity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkconnectivity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/serviceConnectionPolicies": {
		"networkconnectivity": {
			"v1": RestResource{
				Name:                      "serviceConnectionPolicies",
				TypeKey:                   "projects/locations/serviceConnectionPolicies",
				Service:                   "networkconnectivity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkconnectivity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkconnectivity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/services": {
		"metastore": {
			"v1": RestResource{
				Name:                      "services",
				TypeKey:                   "projects/locations/services",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "services",
				TypeKey:                   "projects/locations/services",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "services",
				TypeKey:                   "projects/locations/services",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"run": {
			"v1": RestResource{
				Name:                      "services",
				TypeKey:                   "projects/locations/services",
				Service:                   "run",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://run.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://run.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v2": RestResource{
				Name:                      "services",
				TypeKey:                   "projects/locations/services",
				Service:                   "run",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://run.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://run.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/services/backups": {
		"metastore": {
			"v1": RestResource{
				Name:                      "backups",
				TypeKey:                   "projects/locations/services/backups",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "backups",
				TypeKey:                   "projects/locations/services/backups",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "backups",
				TypeKey:                   "projects/locations/services/backups",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/services/databases": {
		"metastore": {
			"v1": RestResource{
				Name:                      "databases",
				TypeKey:                   "projects/locations/services/databases",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "databases",
				TypeKey:                   "projects/locations/services/databases",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "databases",
				TypeKey:                   "projects/locations/services/databases",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/services/databases/tables": {
		"metastore": {
			"v1": RestResource{
				Name:                      "tables",
				TypeKey:                   "projects/locations/services/databases/tables",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha": RestResource{
				Name:                      "tables",
				TypeKey:                   "projects/locations/services/databases/tables",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1alpha/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1alpha/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "tables",
				TypeKey:                   "projects/locations/services/databases/tables",
				Service:                   "metastore",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://metastore.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://metastore.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/spokes": {
		"networkconnectivity": {
			"v1": RestResource{
				Name:                      "spokes",
				TypeKey:                   "projects/locations/spokes",
				Service:                   "networkconnectivity",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkconnectivity.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkconnectivity.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha1": RestResource{
				Name:                      "spokes",
				TypeKey:                   "projects/locations/spokes",
				Service:                   "networkconnectivity",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://networkconnectivity.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://networkconnectivity.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/subscriptions": {
		"analyticshub": {
			"v1": RestResource{
				Name:                      "subscriptions",
				TypeKey:                   "projects/locations/subscriptions",
				Service:                   "analyticshub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://analyticshub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://analyticshub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/tagTemplates": {
		"datacatalog": {
			"v1": RestResource{
				Name:                      "tagTemplates",
				TypeKey:                   "projects/locations/tagTemplates",
				Service:                   "datacatalog",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "tagTemplates",
				TypeKey:                   "projects/locations/tagTemplates",
				Service:                   "datacatalog",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/targets": {
		"clouddeploy": {
			"v1": RestResource{
				Name:                      "targets",
				TypeKey:                   "projects/locations/targets",
				Service:                   "clouddeploy",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://clouddeploy.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://clouddeploy.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/taxonomies": {
		"datacatalog": {
			"v1": RestResource{
				Name:                      "taxonomies",
				TypeKey:                   "projects/locations/taxonomies",
				Service:                   "datacatalog",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "taxonomies",
				TypeKey:                   "projects/locations/taxonomies",
				Service:                   "datacatalog",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/taxonomies/policyTags": {
		"datacatalog": {
			"v1": RestResource{
				Name:                      "policyTags",
				TypeKey:                   "projects/locations/taxonomies/policyTags",
				Service:                   "datacatalog",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "policyTags",
				TypeKey:                   "projects/locations/taxonomies/policyTags",
				Service:                   "datacatalog",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://datacatalog.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://datacatalog.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/triggers": {
		"eventarc": {
			"v1": RestResource{
				Name:                      "triggers",
				TypeKey:                   "projects/locations/triggers",
				Service:                   "eventarc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://eventarc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://eventarc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/vmwareAdminClusters": {
		"gkeonprem": {
			"v1": RestResource{
				Name:                      "vmwareAdminClusters",
				TypeKey:                   "projects/locations/vmwareAdminClusters",
				Service:                   "gkeonprem",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkeonprem.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkeonprem.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/vmwareClusters": {
		"gkeonprem": {
			"v1": RestResource{
				Name:                      "vmwareClusters",
				TypeKey:                   "projects/locations/vmwareClusters",
				Service:                   "gkeonprem",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkeonprem.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkeonprem.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/vmwareClusters/vmwareNodePools": {
		"gkeonprem": {
			"v1": RestResource{
				Name:                      "vmwareNodePools",
				TypeKey:                   "projects/locations/vmwareClusters/vmwareNodePools",
				Service:                   "gkeonprem",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://gkeonprem.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://gkeonprem.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/workerPools": {
		"run": {
			"v2": RestResource{
				Name:                      "workerPools",
				TypeKey:                   "projects/locations/workerPools",
				Service:                   "run",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://run.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://run.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/workerpools": {
		"run": {
			"v1": RestResource{
				Name:                      "workerpools",
				TypeKey:                   "projects/locations/workerpools",
				Service:                   "run",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://run.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://run.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/workflowTemplates": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "workflowTemplates",
				TypeKey:                   "projects/locations/workflowTemplates",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/workloadIdentityPools": {
		"iam": {
			"v1": RestResource{
				Name:                      "workloadIdentityPools",
				TypeKey:                   "projects/locations/workloadIdentityPools",
				Service:                   "iam",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://iam.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://iam.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/workstationClusters/workstationConfigs": {
		"workstations": {
			"v1": RestResource{
				Name:                      "workstationConfigs",
				TypeKey:                   "projects/locations/workstationClusters/workstationConfigs",
				Service:                   "workstations",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://workstations.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://workstations.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "workstationConfigs",
				TypeKey:                   "projects/locations/workstationClusters/workstationConfigs",
				Service:                   "workstations",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://workstations.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://workstations.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/locations/workstationClusters/workstationConfigs/workstations": {
		"workstations": {
			"v1": RestResource{
				Name:                      "workstations",
				TypeKey:                   "projects/locations/workstationClusters/workstationConfigs/workstations",
				Service:                   "workstations",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://workstations.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://workstations.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta": RestResource{
				Name:                      "workstations",
				TypeKey:                   "projects/locations/workstationClusters/workstationConfigs/workstations",
				Service:                   "workstations",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://workstations.googleapis.com/",
					Path:       "v1beta/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://workstations.googleapis.com/",
					Path:          "v1beta/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/machineImages": {
		"compute": {
			"alpha": RestResource{
				Name:               "machineImages",
				TypeKey:            "projects/machineImages",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"machineImages": "resource",
					"projects":      "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/machineImages/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/machineImages/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "machineImages",
				TypeKey:            "projects/machineImages",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"machineImages": "resource",
					"projects":      "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/global/machineImages/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/global/machineImages/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "machineImages",
				TypeKey:            "projects/machineImages",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"machineImages": "resource",
					"projects":      "project",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/global/machineImages/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/global/machineImages/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/managedZones": {
		"dns": {
			"v1": RestResource{
				Name:                      "managedZones",
				TypeKey:                   "projects/managedZones",
				Service:                   "dns",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dns.googleapis.com/",
					Path:       "dns/v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dns.googleapis.com/",
					Path:          "dns/v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "managedZones",
				TypeKey:                   "projects/managedZones",
				Service:                   "dns",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dns.googleapis.com/",
					Path:       "dns/v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dns.googleapis.com/",
					Path:          "dns/v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/models": {
		"ml": {
			"v1": RestResource{
				Name:                      "models",
				TypeKey:                   "projects/models",
				Service:                   "ml",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://ml.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://ml.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/notes": {
		"containeranalysis": {
			"v1": RestResource{
				Name:                      "notes",
				TypeKey:                   "projects/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha1": RestResource{
				Name:                      "notes",
				TypeKey:                   "projects/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "notes",
				TypeKey:                   "projects/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/occurrences": {
		"containeranalysis": {
			"v1": RestResource{
				Name:                      "occurrences",
				TypeKey:                   "projects/occurrences",
				Service:                   "containeranalysis",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1alpha1": RestResource{
				Name:                      "occurrences",
				TypeKey:                   "projects/occurrences",
				Service:                   "containeranalysis",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "occurrences",
				TypeKey:                   "projects/occurrences",
				Service:                   "containeranalysis",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/policy": {
		"binaryauthorization": {
			"v1": RestResource{
				Name:                      "policy",
				TypeKey:                   "projects/policy",
				Service:                   "binaryauthorization",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://binaryauthorization.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://binaryauthorization.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "policy",
				TypeKey:                   "projects/policy",
				Service:                   "binaryauthorization",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://binaryauthorization.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://binaryauthorization.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/autoscalingPolicies": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "autoscalingPolicies",
				TypeKey:                   "projects/regions/autoscalingPolicies",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/backendBuckets": {
		"compute": {
			"alpha": RestResource{
				Name:               "regionBackendBuckets",
				TypeKey:            "projects/regions/backendBuckets",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendBuckets": "resource",
					"projects":       "project",
					"regions":        "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/backendBuckets/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/backendBuckets/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/backendServices": {
		"compute": {
			"alpha": RestResource{
				Name:               "regionBackendServices",
				TypeKey:            "projects/regions/backendServices",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendServices": "resource",
					"projects":        "project",
					"regions":         "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/backendServices/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/backendServices/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "regionBackendServices",
				TypeKey:            "projects/regions/backendServices",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendServices": "resource",
					"projects":        "project",
					"regions":         "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/regions/{region}/backendServices/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/regions/{region}/backendServices/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "regionBackendServices",
				TypeKey:            "projects/regions/backendServices",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"backendServices": "resource",
					"projects":        "project",
					"regions":         "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/regions/{region}/backendServices/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/regions/{region}/backendServices/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/clusters": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "clusters",
				TypeKey:                   "projects/regions/clusters",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/disks": {
		"compute": {
			"alpha": RestResource{
				Name:               "regionDisks",
				TypeKey:            "projects/regions/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"regions":  "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "regionDisks",
				TypeKey:            "projects/regions/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"regions":  "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/regions/{region}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/regions/{region}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "regionDisks",
				TypeKey:            "projects/regions/disks",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"regions":  "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/regions/{region}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/regions/{region}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/firewallPolicies": {
		"compute": {
			"alpha": RestResource{
				Name:               "regionNetworkFirewallPolicies",
				TypeKey:            "projects/regions/firewallPolicies",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"firewallPolicies": "resource",
					"projects":         "project",
					"regions":          "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/firewallPolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/firewallPolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "regionNetworkFirewallPolicies",
				TypeKey:            "projects/regions/firewallPolicies",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"firewallPolicies": "resource",
					"projects":         "project",
					"regions":          "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/regions/{region}/firewallPolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/regions/{region}/firewallPolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "regionNetworkFirewallPolicies",
				TypeKey:            "projects/regions/firewallPolicies",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"firewallPolicies": "resource",
					"projects":         "project",
					"regions":          "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/regions/{region}/firewallPolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/regions/{region}/firewallPolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/instantSnapshotGroups": {
		"compute": {
			"alpha": RestResource{
				Name:               "regionInstantSnapshotGroups",
				TypeKey:            "projects/regions/instantSnapshotGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instantSnapshotGroups": "resource",
					"projects":              "project",
					"regions":               "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/instantSnapshotGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/instantSnapshotGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/instantSnapshots": {
		"compute": {
			"alpha": RestResource{
				Name:               "regionInstantSnapshots",
				TypeKey:            "projects/regions/instantSnapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instantSnapshots": "resource",
					"projects":         "project",
					"regions":          "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/instantSnapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/instantSnapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "regionInstantSnapshots",
				TypeKey:            "projects/regions/instantSnapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instantSnapshots": "resource",
					"projects":         "project",
					"regions":          "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/regions/{region}/instantSnapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/regions/{region}/instantSnapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "regionInstantSnapshots",
				TypeKey:            "projects/regions/instantSnapshots",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instantSnapshots": "resource",
					"projects":         "project",
					"regions":          "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/regions/{region}/instantSnapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/regions/{region}/instantSnapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/interconnectAttachments": {
		"compute": {
			"alpha": RestResource{
				Name:               "interconnectAttachments",
				TypeKey:            "projects/regions/interconnectAttachments",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"interconnectAttachments": "resource",
					"projects":                "project",
					"regions":                 "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/interconnectAttachments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/interconnectAttachments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/jobs": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "jobs",
				TypeKey:                   "projects/regions/jobs",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/networkAttachments": {
		"compute": {
			"alpha": RestResource{
				Name:               "networkAttachments",
				TypeKey:            "projects/regions/networkAttachments",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"networkAttachments": "resource",
					"projects":           "project",
					"regions":            "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/networkAttachments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/networkAttachments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "networkAttachments",
				TypeKey:            "projects/regions/networkAttachments",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"networkAttachments": "resource",
					"projects":           "project",
					"regions":            "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/regions/{region}/networkAttachments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/regions/{region}/networkAttachments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "networkAttachments",
				TypeKey:            "projects/regions/networkAttachments",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"networkAttachments": "resource",
					"projects":           "project",
					"regions":            "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/regions/{region}/networkAttachments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/regions/{region}/networkAttachments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/nodeTemplates": {
		"compute": {
			"alpha": RestResource{
				Name:               "nodeTemplates",
				TypeKey:            "projects/regions/nodeTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeTemplates": "resource",
					"projects":      "project",
					"regions":       "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "nodeTemplates",
				TypeKey:            "projects/regions/nodeTemplates",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeTemplates": "resource",
					"projects":      "project",
					"regions":       "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "nodeTemplates",
				TypeKey:            "projects/regions/nodeTemplates",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeTemplates": "resource",
					"projects":      "project",
					"regions":       "region",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/regions/{region}/nodeTemplates/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/regions/{region}/nodeTemplates/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/operations": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "operations",
				TypeKey:                   "projects/regions/operations",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/resourcePolicies": {
		"compute": {
			"alpha": RestResource{
				Name:               "resourcePolicies",
				TypeKey:            "projects/regions/resourcePolicies",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":         "project",
					"regions":          "region",
					"resourcePolicies": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "resourcePolicies",
				TypeKey:            "projects/regions/resourcePolicies",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":         "project",
					"regions":          "region",
					"resourcePolicies": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "resourcePolicies",
				TypeKey:            "projects/regions/resourcePolicies",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":         "project",
					"regions":          "region",
					"resourcePolicies": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/regions/{region}/resourcePolicies/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/regions/{region}/resourcePolicies/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/serviceAttachments": {
		"compute": {
			"alpha": RestResource{
				Name:               "serviceAttachments",
				TypeKey:            "projects/regions/serviceAttachments",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":           "project",
					"regions":            "region",
					"serviceAttachments": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/serviceAttachments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/serviceAttachments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "serviceAttachments",
				TypeKey:            "projects/regions/serviceAttachments",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":           "project",
					"regions":            "region",
					"serviceAttachments": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/regions/{region}/serviceAttachments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/regions/{region}/serviceAttachments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "serviceAttachments",
				TypeKey:            "projects/regions/serviceAttachments",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":           "project",
					"regions":            "region",
					"serviceAttachments": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/regions/{region}/serviceAttachments/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/regions/{region}/serviceAttachments/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/snapshots": {
		"compute": {
			"alpha": RestResource{
				Name:               "regionSnapshots",
				TypeKey:            "projects/regions/snapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":  "project",
					"regions":   "region",
					"snapshots": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/snapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/snapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "regionSnapshots",
				TypeKey:            "projects/regions/snapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":  "project",
					"regions":   "region",
					"snapshots": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/regions/{region}/snapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/regions/{region}/snapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/subnetworks": {
		"compute": {
			"alpha": RestResource{
				Name:               "subnetworks",
				TypeKey:            "projects/regions/subnetworks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":    "project",
					"regions":     "region",
					"subnetworks": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/regions/{region}/subnetworks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/regions/{region}/subnetworks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "subnetworks",
				TypeKey:            "projects/regions/subnetworks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":    "project",
					"regions":     "region",
					"subnetworks": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/regions/{region}/subnetworks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/regions/{region}/subnetworks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "subnetworks",
				TypeKey:            "projects/regions/subnetworks",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "region", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":    "project",
					"regions":     "region",
					"subnetworks": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/regions/{region}/subnetworks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/regions/{region}/subnetworks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/regions/workflowTemplates": {
		"dataproc": {
			"v1": RestResource{
				Name:                      "workflowTemplates",
				TypeKey:                   "projects/regions/workflowTemplates",
				Service:                   "dataproc",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://dataproc.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://dataproc.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/schemas": {
		"pubsub": {
			"v1": RestResource{
				Name:                      "schemas",
				TypeKey:                   "projects/schemas",
				Service:                   "pubsub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/secrets": {
		"secretmanager": {
			"v1": RestResource{
				Name:                      "secrets",
				TypeKey:                   "projects/secrets",
				Service:                   "secretmanager",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://secretmanager.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://secretmanager.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta1": RestResource{
				Name:                      "secrets",
				TypeKey:                   "projects/secrets",
				Service:                   "secretmanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://secretmanager.googleapis.com/",
					Path:       "v1beta1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://secretmanager.googleapis.com/",
					Path:          "v1beta1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "secrets",
				TypeKey:                   "projects/secrets",
				Service:                   "secretmanager",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://secretmanager.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://secretmanager.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/serviceAccounts": {
		"iam": {
			"v1": RestResource{
				Name:                      "serviceAccounts",
				TypeKey:                   "projects/serviceAccounts",
				Service:                   "iam",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://iam.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://iam.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/snapshotGroups": {
		"compute": {
			"alpha": RestResource{
				Name:               "snapshotGroups",
				TypeKey:            "projects/snapshotGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":       "project",
					"snapshotGroups": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/snapshotGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/snapshotGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/snapshots": {
		"compute": {
			"alpha": RestResource{
				Name:               "snapshots",
				TypeKey:            "projects/snapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":  "project",
					"snapshots": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/global/snapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/global/snapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "snapshots",
				TypeKey:            "projects/snapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":  "project",
					"snapshots": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/global/snapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/global/snapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "snapshots",
				TypeKey:            "projects/snapshots",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":  "project",
					"snapshots": "resource",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/global/snapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/global/snapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
		"pubsub": {
			"v1": RestResource{
				Name:                      "snapshots",
				TypeKey:                   "projects/snapshots",
				Service:                   "pubsub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/subscriptions": {
		"pubsub": {
			"v1": RestResource{
				Name:                      "subscriptions",
				TypeKey:                   "projects/subscriptions",
				Service:                   "pubsub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "subscriptions",
				TypeKey:                   "projects/subscriptions",
				Service:                   "pubsub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/tenants": {
		"identitytoolkit": {
			"v2": RestResource{
				Name:                      "tenants",
				TypeKey:                   "projects/tenants",
				Service:                   "identitytoolkit",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://identitytoolkit.googleapis.com/",
					Path:       "v2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://identitytoolkit.googleapis.com/",
					Path:          "v2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/topics": {
		"pubsub": {
			"v1": RestResource{
				Name:                      "topics",
				TypeKey:                   "projects/topics",
				Service:                   "pubsub",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1beta2": RestResource{
				Name:                      "topics",
				TypeKey:                   "projects/topics",
				Service:                   "pubsub",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://pubsub.googleapis.com/",
					Path:       "v1beta2/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://pubsub.googleapis.com/",
					Path:          "v1beta2/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/disks": {
		"compute": {
			"alpha": RestResource{
				Name:               "disks",
				TypeKey:            "projects/zones/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"zones":    "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/zones/{zone}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/zones/{zone}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "disks",
				TypeKey:            "projects/zones/disks",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"zones":    "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/zones/{zone}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/zones/{zone}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "disks",
				TypeKey:            "projects/zones/disks",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"disks":    "resource",
					"projects": "project",
					"zones":    "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/zones/{zone}/disks/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/zones/{zone}/disks/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/instances": {
		"compute": {
			"alpha": RestResource{
				Name:               "instances",
				TypeKey:            "projects/zones/instances",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instances": "resource",
					"projects":  "project",
					"zones":     "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/zones/{zone}/instances/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/zones/{zone}/instances/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "instances",
				TypeKey:            "projects/zones/instances",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instances": "resource",
					"projects":  "project",
					"zones":     "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/zones/{zone}/instances/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/zones/{zone}/instances/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "instances",
				TypeKey:            "projects/zones/instances",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instances": "resource",
					"projects":  "project",
					"zones":     "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/zones/{zone}/instances/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/zones/{zone}/instances/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/instantSnapshotGroups": {
		"compute": {
			"alpha": RestResource{
				Name:               "instantSnapshotGroups",
				TypeKey:            "projects/zones/instantSnapshotGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instantSnapshotGroups": "resource",
					"projects":              "project",
					"zones":                 "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/zones/{zone}/instantSnapshotGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/zones/{zone}/instantSnapshotGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/instantSnapshots": {
		"compute": {
			"alpha": RestResource{
				Name:               "instantSnapshots",
				TypeKey:            "projects/zones/instantSnapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instantSnapshots": "resource",
					"projects":         "project",
					"zones":            "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/zones/{zone}/instantSnapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/zones/{zone}/instantSnapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "instantSnapshots",
				TypeKey:            "projects/zones/instantSnapshots",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instantSnapshots": "resource",
					"projects":         "project",
					"zones":            "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/zones/{zone}/instantSnapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/zones/{zone}/instantSnapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "instantSnapshots",
				TypeKey:            "projects/zones/instantSnapshots",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"instantSnapshots": "resource",
					"projects":         "project",
					"zones":            "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/zones/{zone}/instantSnapshots/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/zones/{zone}/instantSnapshots/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/nodeGroups": {
		"compute": {
			"alpha": RestResource{
				Name:               "nodeGroups",
				TypeKey:            "projects/zones/nodeGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeGroups": "resource",
					"projects":   "project",
					"zones":      "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "nodeGroups",
				TypeKey:            "projects/zones/nodeGroups",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeGroups": "resource",
					"projects":   "project",
					"zones":      "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "nodeGroups",
				TypeKey:            "projects/zones/nodeGroups",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"nodeGroups": "resource",
					"projects":   "project",
					"zones":      "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/zones/{zone}/nodeGroups/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/zones/{zone}/nodeGroups/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/reservations": {
		"compute": {
			"alpha": RestResource{
				Name:               "reservations",
				TypeKey:            "projects/zones/reservations",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":     "project",
					"reservations": "resource",
					"zones":        "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/zones/{zone}/reservations/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/zones/{zone}/reservations/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "reservations",
				TypeKey:            "projects/zones/reservations",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":     "project",
					"reservations": "resource",
					"zones":        "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/zones/{zone}/reservations/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/zones/{zone}/reservations/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "reservations",
				TypeKey:            "projects/zones/reservations",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":     "project",
					"reservations": "resource",
					"zones":        "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/zones/{zone}/reservations/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/zones/{zone}/reservations/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"projects/zones/storagePools": {
		"compute": {
			"alpha": RestResource{
				Name:               "storagePools",
				TypeKey:            "projects/zones/storagePools",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":     "project",
					"storagePools": "resource",
					"zones":        "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/alpha/",
					Path:       "projects/{project}/zones/{zone}/storagePools/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/alpha/",
					Path:          "projects/{project}/zones/{zone}/storagePools/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"beta": RestResource{
				Name:               "storagePools",
				TypeKey:            "projects/zones/storagePools",
				Service:            "compute",
				IsPreferredVersion: false,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":     "project",
					"storagePools": "resource",
					"zones":        "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/beta/",
					Path:       "projects/{project}/zones/{zone}/storagePools/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/beta/",
					Path:          "projects/{project}/zones/{zone}/storagePools/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
			"v1": RestResource{
				Name:               "storagePools",
				TypeKey:            "projects/zones/storagePools",
				Service:            "compute",
				IsPreferredVersion: true,
				Parameters:         []string{"project", "zone", "resource"},
				CollectionReplacementKeys: map[string]string{
					"projects":     "project",
					"storagePools": "resource",
					"zones":        "zone",
				},
				GetMethod: RestMethod{
					HttpMethod: "GET",
					BaseURL:    "https://compute.googleapis.com/compute/v1/",
					Path:       "projects/{project}/zones/{zone}/storagePools/{resource}/getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://compute.googleapis.com/compute/v1/",
					Path:          "projects/{project}/zones/{zone}/storagePools/{resource}/setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"providers/notes": {
		"containeranalysis": {
			"v1alpha1": RestResource{
				Name:                      "notes",
				TypeKey:                   "providers/notes",
				Service:                   "containeranalysis",
				IsPreferredVersion:        false,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://containeranalysis.googleapis.com/",
					Path:       "v1alpha1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://containeranalysis.googleapis.com/",
					Path:          "v1alpha1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"services": {
		"servicemanagement": {
			"v1": RestResource{
				Name:                      "services",
				TypeKey:                   "services",
				Service:                   "servicemanagement",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicemanagement.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicemanagement.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"services/consumers": {
		"servicemanagement": {
			"v1": RestResource{
				Name:                      "consumers",
				TypeKey:                   "services/consumers",
				Service:                   "servicemanagement",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://servicemanagement.googleapis.com/",
					Path:       "v1/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://servicemanagement.googleapis.com/",
					Path:          "v1/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"tagKeys": {
		"cloudresourcemanager": {
			"v3": RestResource{
				Name:                      "tagKeys",
				TypeKey:                   "tagKeys",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v3/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v3/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
	"tagValues": {
		"cloudresourcemanager": {
			"v3": RestResource{
				Name:                      "tagValues",
				TypeKey:                   "tagValues",
				Service:                   "cloudresourcemanager",
				IsPreferredVersion:        true,
				Parameters:                []string{"resource"},
				CollectionReplacementKeys: map[string]string{},
				GetMethod: RestMethod{
					HttpMethod: "POST",
					BaseURL:    "https://cloudresourcemanager.googleapis.com/",
					Path:       "v3/{+resource}:getIamPolicy",
				},
				SetMethod: RestMethod{
					HttpMethod:    "POST",
					BaseURL:       "https://cloudresourcemanager.googleapis.com/",
					Path:          "v3/{+resource}:setIamPolicy",
					RequestFormat: `{"policy": %s}`,
				},
			},
		},
	},
}
