/*
 * DO NOT EDIT! This is a generated file.
 *
 * Qt-based wrapper declaration for VirtualBox Main API (COM) interface.
 * Generated from XIDL (XML interface definition).
 *
 * Source    : src/VBox/Main/idl/VirtualBox.xidl
 * Generator : src/VBox/Frontends/VirtualBox/src/globals/COMWrappers.xsl
 */

#ifndef __CMachine_h__
#define __CMachine_h__

/* Qt includes: */
#include <QList>
#include <QRect>
#include <QStringList>

/* GUI includes: */
#include "COMDefs.h"
#include "UILibraryDefs.h"

/* VirtualBox interface declarations: */
#ifndef VBOX_WITH_LESS_VIRTUALBOX_INCLUDING
# include <VBox/com/VirtualBox.h>
#else
COM_STRUCT_OR_CLASS(IMachine);
#endif

#include "KPointingHIDType.h"
#include "KKeyboardHIDType.h"
#include "KSessionState.h"
#include "KMachineState.h"
#include "KClipboardMode.h"
#include "KDnDMode.h"
#include "KParavirtProvider.h"
#include "KAutostopType.h"
#include "KVMProcPriority.h"
#include "KVMExecutionEngine.h"
#include "KLockType.h"
#include "KDeviceType.h"
#include "KDeviceType.h"
#include "KDeviceType.h"
#include "KDeviceType.h"
#include "KStorageBus.h"
#include "KStorageBus.h"
#include "KUSBControllerType.h"
#include "KUSBControllerType.h"
#include "KCleanupMode.h"
#include "KBitmapFormat.h"
#include "KBitmapFormat.h"
#include "KBitmapFormat.h"
#include "KParavirtProvider.h"
#include "KCloneMode.h"
#include "KCloneOptions.h"


/* Forward declarations: */
class CVirtualBoxErrorInfo;
class CNATNetwork;
class CCloudNetwork;
class CHostOnlyNetwork;
class CDHCPServer;
class CDHCPConfig;
class CDHCPGlobalConfig;
class CDHCPGroupCondition;
class CDHCPGroupConfig;
class CDHCPIndividualConfig;
class CVirtualBox;
class CVFSExplorer;
class CCertificate;
class CAppliance;
class CVirtualSystemDescription;
class CUnattended;
class CGraphicsAdapter;
class CFirmwareSettings;
class CTrustedPlatformModule;
class CRecordingScreenSettings;
class CRecordingSettings;
class CPCIAddress;
class CPCIDeviceAttachment;
class CUefiVariableStore;
class CNvramStore;
class CResourceStore;
class CPlatform;
class CPlatformX86;
class CPlatformARM;
class CMachine;
class CEmulatedUSB;
class CVRDEServerInfo;
class CConsole;
class CHostNetworkInterface;
class CHostVideoInputDevice;
class CUpdateAgent;
class CHostUpdateAgent;
class CHostDrivePartition;
class CHostDrive;
class CHostX86;
class CHost;
class CCPUProfile;
class CPlatformProperties;
class CSystemProperties;
class CGuestOSType;
class CAdditionsFacility;
class CDnDBase;
class CDnDSource;
class CGuestDnDSource;
class CDnDTarget;
class CGuestDnDTarget;
class CGuestSession;
class CProcess;
class CGuestProcess;
class CDirectory;
class CGuestDirectory;
class CFile;
class CGuestFile;
class CFsInfo;
class CFsObjInfo;
class CGuestFsInfo;
class CGuestFsObjInfo;
class CGuest;
class CProgress;
class CSnapshot;
class CMediumAttachment;
class CMedium;
class CMediumFormat;
class CDataStream;
class CMediumIO;
class CToken;
class CKeyboard;
class CMousePointerShape;
class CMouse;
class CDisplaySourceBitmap;
class CFramebuffer;
class CFramebufferOverlay;
class CGuestScreenInfo;
class CDisplay;
class CNetworkAdapter;
class CSerialPort;
class CParallelPort;
class CMachineDebugger;
class CUSBDeviceFilters;
class CUSBController;
class CUSBDevice;
class CUSBDeviceFilter;
class CHostUSBDevice;
class CHostUSBDeviceFilter;
class CUSBProxyBackend;
class CAudioAdapter;
class CHostAudioDevice;
class CAudioSettings;
class CVRDEServer;
class CSharedFolder;
class CSession;
class CStorageController;
class CPerformanceMetric;
class CPerformanceCollector;
class CNATEngine;
class CExtPackPlugIn;
class CExtPackBase;
class CExtPack;
class CExtPackFile;
class CExtPackManager;
class CBandwidthGroup;
class CBandwidthControl;
class CGuestDebugControl;
class CVirtualBoxClient;
class CEventSource;
class CEventListener;
class CEvent;
class CReusableEvent;
class CMachineEvent;
class CMachineStateChangedEvent;
class CExtPackInstalledEvent;
class CExtPackUninstalledEvent;
class CMachineDataChangedEvent;
class CMediumRegisteredEvent;
class CMediumConfigChangedEvent;
class CMachineRegisteredEvent;
class CSessionStateChangedEvent;
class CGuestPropertyChangedEvent;
class CSnapshotEvent;
class CSnapshotTakenEvent;
class CSnapshotDeletedEvent;
class CSnapshotRestoredEvent;
class CSnapshotChangedEvent;
class CMousePointerShapeChangedEvent;
class CMouseCapabilityChangedEvent;
class CKeyboardLedsChangedEvent;
class CStateChangedEvent;
class CAdditionsStateChangedEvent;
class CNetworkAdapterChangedEvent;
class CAudioAdapterChangedEvent;
class CSerialPortChangedEvent;
class CParallelPortChangedEvent;
class CStorageControllerChangedEvent;
class CMediumChangedEvent;
class CClipboardModeChangedEvent;
class CClipboardFileTransferModeChangedEvent;
class CClipboardEvent;
class CClipboardErrorEvent;
class CDnDModeChangedEvent;
class CCPUChangedEvent;
class CCPUExecutionCapChangedEvent;
class CGuestKeyboardEvent;
class CGuestMouseEvent;
class CGuestMultiTouchEvent;
class CGuestSessionEvent;
class CGuestSessionStateChangedEvent;
class CGuestSessionRegisteredEvent;
class CGuestProcessEvent;
class CGuestProcessRegisteredEvent;
class CGuestProcessStateChangedEvent;
class CGuestProcessIOEvent;
class CGuestProcessInputNotifyEvent;
class CGuestProcessOutputEvent;
class CGuestDirectoryEvent;
class CGuestDirectoryRegisteredEvent;
class CGuestDirectoryStateChangedEvent;
class CGuestDirectoryReadEvent;
class CGuestFileEvent;
class CGuestFileRegisteredEvent;
class CGuestFileStateChangedEvent;
class CGuestFileIOEvent;
class CGuestFileOffsetChangedEvent;
class CGuestFileSizeChangedEvent;
class CGuestFileReadEvent;
class CGuestFileWriteEvent;
class CVRDEServerChangedEvent;
class CVRDEServerInfoChangedEvent;
class CRecordingStateChangedEvent;
class CRecordingScreenStateChangedEvent;
class CUSBControllerChangedEvent;
class CUSBDeviceStateChangedEvent;
class CSharedFolderChangedEvent;
class CRuntimeErrorEvent;
class CEventSourceChangedEvent;
class CExtraDataChangedEvent;
class CVetoEvent;
class CExtraDataCanChangeEvent;
class CCanShowWindowEvent;
class CShowWindowEvent;
class CNATRedirectEvent;
class CHostAudioDeviceChangedEvent;
class CHostPCIDevicePlugEvent;
class CVBoxSVCAvailabilityChangedEvent;
class CBandwidthGroupChangedEvent;
class CGuestMonitorChangedEvent;
class CGuestUserStateChangedEvent;
class CStorageDeviceChangedEvent;
class CNATNetworkChangedEvent;
class CNATNetworkStartStopEvent;
class CNATNetworkAlterEvent;
class CNATNetworkCreationDeletionEvent;
class CNATNetworkSettingEvent;
class CNATNetworkPortForwardEvent;
class CHostNameResolutionConfigurationChangeEvent;
class CProgressEvent;
class CProgressCreatedEvent;
class CProgressPercentageChangedEvent;
class CProgressTaskCompletedEvent;
class CCursorPositionChangedEvent;
class CGuestAdditionsStatusChangedEvent;
class CGuestMonitorInfoChangedEvent;
class CUpdateAgentEvent;
class CUpdateAgentSettingsChangedEvent;
class CUpdateAgentErrorEvent;
class CUpdateAgentAvailableEvent;
class CUpdateAgentStateChangedEvent;
class CGuestDebugControlChangedEvent;
class CMachineGroupsChangedEvent;
class CStringArray;
class CFormValue;
class CBooleanFormValue;
class CRangedIntegerFormValue;
class CRangedInteger64FormValue;
class CStringFormValue;
class CChoiceFormValue;
class CForm;
class CVirtualSystemDescriptionForm;
class CCloudNetworkGatewayInfo;
class CCloudNetworkEnvironmentInfo;
class CCloudMachine;
class CCloudClient;
class CCloudProfile;
class CCloudProvider;
class CCloudProviderManager;
class CCloudProviderListChangedEvent;
class CCloudProviderRegisteredEvent;
class CCloudProviderUninstallEvent;
class CCloudProfileRegisteredEvent;
class CCloudProfileChangedEvent;
class CLanguageChangedEvent;
class CVirtualBox;
class CVirtualBoxClient;
class CSession;
class CVirtualBoxSDS;

/* Interface forward declaration: */
COM_STRUCT_OR_CLASS(IMachine);

/* Interface wrapper declaration: */
class SHARED_LIBRARY_STUFF CMachine : public CInterface<IMachine, COMBaseWithEI>
{
public:

    typedef CInterface<IMachine, COMBaseWithEI> Base;

    /* Constructors and assignments taking CUnknown and raw iface pointer: */

    CMachine();
    ~CMachine();

    template<class OI, class OB> explicit CMachine(const CInterface<OI, OB> & that)
    {
        attach(that.raw());
        if (SUCCEEDED(mRC))
        {
            mRC = that.lastRC();
            setErrorInfo(that.errorInfo());
        }
    }

    CMachine(const CMachine & that);

    template<class OI> explicit CMachine(OI * aIface) { attach(aIface); }

    explicit CMachine(IMachine * aIface);

    template<class OI, class OB> CMachine & operator=(const CInterface<OI, OB> & that)
    {
        attach(that.raw());
        if (SUCCEEDED(mRC))
        {
            mRC = that.lastRC();
            setErrorInfo(that.errorInfo());
        }
        return *this;
    }

    CMachine & operator=(const CMachine & that);

    template<class OI> CMachine & operator=(OI * aIface)
    {
        attach(aIface);
        return *this;
    }

    CMachine & operator=(IMachine * aIface);

#ifdef VBOX_WITH_LESS_VIRTUALBOX_INCLUDING
const IID &getIID() const RT_OVERRIDE;
#endif

    /* Attributes (properties): */
    CVirtualBox GetParent() const;
    QVector<BYTE> GetIcon() const;
    void SetIcon(const QVector<BYTE> & aIcon);
    BOOL GetAccessible() const;
    CVirtualBoxErrorInfo GetAccessError() const;
    QString GetName() const;
    void SetName(const QString & aName);
    QString GetDescription() const;
    void SetDescription(const QString & aDescription);
    QUuid GetId() const;
    QVector<QString> GetGroups() const;
    void SetGroups(const QVector<QString> & aGroups);
    QString GetOSTypeId() const;
    void SetOSTypeId(const QString & aOSTypeId);
    QString GetHardwareVersion() const;
    void SetHardwareVersion(const QString & aHardwareVersion);
    QUuid GetHardwareUUID() const;
    void SetHardwareUUID(QUuid aHardwareUUID);
    ULONG GetCPUCount() const;
    void SetCPUCount(ULONG aCPUCount);
    BOOL GetCPUHotPlugEnabled() const;
    void SetCPUHotPlugEnabled(BOOL aCPUHotPlugEnabled);
    ULONG GetCPUExecutionCap() const;
    void SetCPUExecutionCap(ULONG aCPUExecutionCap);
    ULONG GetCPUIDPortabilityLevel() const;
    void SetCPUIDPortabilityLevel(ULONG aCPUIDPortabilityLevel);
    ULONG GetMemorySize() const;
    void SetMemorySize(ULONG aMemorySize);
    ULONG GetMemoryBalloonSize() const;
    void SetMemoryBalloonSize(ULONG aMemoryBalloonSize);
    BOOL GetPageFusionEnabled() const;
    void SetPageFusionEnabled(BOOL aPageFusionEnabled);
    CGraphicsAdapter GetGraphicsAdapter() const;
    CPlatform GetPlatform() const;
    CFirmwareSettings GetFirmwareSettings() const;
    CTrustedPlatformModule GetTrustedPlatformModule() const;
    CNvramStore GetNonVolatileStore() const;
    CRecordingSettings GetRecordingSettings() const;
    KPointingHIDType GetPointingHIDType() const;
    void SetPointingHIDType(KPointingHIDType aPointingHIDType);
    KKeyboardHIDType GetKeyboardHIDType() const;
    void SetKeyboardHIDType(KKeyboardHIDType aKeyboardHIDType);
    QString GetSnapshotFolder() const;
    void SetSnapshotFolder(const QString & aSnapshotFolder);
    CVRDEServer GetVRDEServer() const;
    BOOL GetEmulatedUSBCardReaderEnabled() const;
    void SetEmulatedUSBCardReaderEnabled(BOOL aEmulatedUSBCardReaderEnabled);
    QVector<CMediumAttachment> GetMediumAttachments() const;
    QVector<CUSBController> GetUSBControllers() const;
    CUSBDeviceFilters GetUSBDeviceFilters() const;
    CAudioSettings GetAudioSettings() const;
    QVector<CStorageController> GetStorageControllers() const;
    QString GetSettingsFilePath() const;
    QString GetSettingsAuxFilePath() const;
    BOOL GetSettingsModified() const;
    KSessionState GetSessionState() const;
    QString GetSessionName() const;
    ULONG GetSessionPID() const;
    KMachineState GetState() const;
    LONG64 GetLastStateChange() const;
    QString GetStateFilePath() const;
    QString GetLogFolder() const;
    CSnapshot GetCurrentSnapshot() const;
    ULONG GetSnapshotCount() const;
    BOOL GetCurrentStateModified() const;
    QVector<CSharedFolder> GetSharedFolders() const;
    KClipboardMode GetClipboardMode() const;
    void SetClipboardMode(KClipboardMode aClipboardMode);
    BOOL GetClipboardFileTransfersEnabled() const;
    void SetClipboardFileTransfersEnabled(BOOL aClipboardFileTransfersEnabled);
    KDnDMode GetDnDMode() const;
    void SetDnDMode(KDnDMode aDnDMode);
    BOOL GetTeleporterEnabled() const;
    void SetTeleporterEnabled(BOOL aTeleporterEnabled);
    ULONG GetTeleporterPort() const;
    void SetTeleporterPort(ULONG aTeleporterPort);
    QString GetTeleporterAddress() const;
    void SetTeleporterAddress(const QString & aTeleporterAddress);
    QString GetTeleporterPassword() const;
    void SetTeleporterPassword(const QString & aTeleporterPassword);
    KParavirtProvider GetParavirtProvider() const;
    void SetParavirtProvider(KParavirtProvider aParavirtProvider);
    BOOL GetIOCacheEnabled() const;
    void SetIOCacheEnabled(BOOL aIOCacheEnabled);
    ULONG GetIOCacheSize() const;
    void SetIOCacheSize(ULONG aIOCacheSize);
    QVector<CPCIDeviceAttachment> GetPCIDeviceAssignments() const;
    CBandwidthControl GetBandwidthControl() const;
    BOOL GetTracingEnabled() const;
    void SetTracingEnabled(BOOL aTracingEnabled);
    QString GetTracingConfig() const;
    void SetTracingConfig(const QString & aTracingConfig);
    BOOL GetAllowTracingToAccessVM() const;
    void SetAllowTracingToAccessVM(BOOL aAllowTracingToAccessVM);
    BOOL GetAutostartEnabled() const;
    void SetAutostartEnabled(BOOL aAutostartEnabled);
    ULONG GetAutostartDelay() const;
    void SetAutostartDelay(ULONG aAutostartDelay);
    KAutostopType GetAutostopType() const;
    void SetAutostopType(KAutostopType aAutostopType);
    QString GetDefaultFrontend() const;
    void SetDefaultFrontend(const QString & aDefaultFrontend);
    BOOL GetUSBProxyAvailable() const;
    KVMProcPriority GetVMProcessPriority() const;
    void SetVMProcessPriority(KVMProcPriority aVMProcessPriority);
    KVMExecutionEngine GetVMExecutionEngine() const;
    void SetVMExecutionEngine(KVMExecutionEngine aVMExecutionEngine);
    QString GetParavirtDebug() const;
    void SetParavirtDebug(const QString & aParavirtDebug);
    QString GetCPUProfile() const;
    void SetCPUProfile(const QString & aCPUProfile);
    QString GetStateKeyId() const;
    QString GetStateKeyStore() const;
    QString GetLogKeyId() const;
    QString GetLogKeyStore() const;
    CGuestDebugControl GetGuestDebugControl() const;

    /* Methods: */
    void LockMachine(const CSession & aSession, KLockType aLockType);
    CProgress LaunchVMProcess(const CSession & aSession, const QString & aName, const QVector<QString> & aEnvironmentChanges);
    void SetBootOrder(ULONG aPosition, KDeviceType aDevice);
    KDeviceType GetBootOrder(ULONG aPosition) const;
    void AttachDevice(const QString & aName, LONG aControllerPort, LONG aDevice, KDeviceType aType, const CMedium & aMedium);
    void AttachDeviceWithoutMedium(const QString & aName, LONG aControllerPort, LONG aDevice, KDeviceType aType);
    void DetachDevice(const QString & aName, LONG aControllerPort, LONG aDevice);
    void PassthroughDevice(const QString & aName, LONG aControllerPort, LONG aDevice, BOOL aPassthrough);
    void TemporaryEjectDevice(const QString & aName, LONG aControllerPort, LONG aDevice, BOOL aTemporaryEject);
    void NonRotationalDevice(const QString & aName, LONG aControllerPort, LONG aDevice, BOOL aNonRotational);
    void SetAutoDiscardForDevice(const QString & aName, LONG aControllerPort, LONG aDevice, BOOL aDiscard);
    void SetHotPluggableForDevice(const QString & aName, LONG aControllerPort, LONG aDevice, BOOL aHotPluggable);
    void SetBandwidthGroupForDevice(const QString & aName, LONG aControllerPort, LONG aDevice, const CBandwidthGroup & aBandwidthGroup);
    void SetNoBandwidthGroupForDevice(const QString & aName, LONG aControllerPort, LONG aDevice);
    void UnmountMedium(const QString & aName, LONG aControllerPort, LONG aDevice, BOOL aForce);
    void MountMedium(const QString & aName, LONG aControllerPort, LONG aDevice, const CMedium & aMedium, BOOL aForce);
    CMedium GetMedium(const QString & aName, LONG aControllerPort, LONG aDevice) const;
    QVector<CMediumAttachment> GetMediumAttachmentsOfController(const QString & aName) const;
    CMediumAttachment GetMediumAttachment(const QString & aName, LONG aControllerPort, LONG aDevice) const;
    void AttachHostPCIDevice(LONG aHostAddress, LONG aDesiredGuestAddress, BOOL aTryToUnbind);
    void DetachHostPCIDevice(LONG aHostAddress);
    CNetworkAdapter GetNetworkAdapter(ULONG aSlot) const;
    CStorageController AddStorageController(const QString & aName, KStorageBus aConnectionType);
    CStorageController GetStorageControllerByName(const QString & aName) const;
    CStorageController GetStorageControllerByInstance(KStorageBus aConnectionType, ULONG aInstance) const;
    void RemoveStorageController(const QString & aName);
    void SetStorageControllerBootable(const QString & aName, BOOL aBootable);
    CUSBController AddUSBController(const QString & aName, KUSBControllerType aType);
    void RemoveUSBController(const QString & aName);
    CUSBController GetUSBControllerByName(const QString & aName) const;
    ULONG GetUSBControllerCountByType(KUSBControllerType aType) const;
    CSerialPort GetSerialPort(ULONG aSlot) const;
    CParallelPort GetParallelPort(ULONG aSlot) const;
    QVector<QString> GetExtraDataKeys();
    QString GetExtraData(const QString & aKey);
    void SetExtraData(const QString & aKey, const QString & aValue);
    CProgress SetSettingsFilePath(const QString & aSettingsFilePath);
    void SaveSettings();
    void DiscardSettings();
    QVector<CMedium> Unregister(KCleanupMode aCleanupMode);
    CProgress DeleteConfig(const QVector<CMedium> & aMedia);
    CVirtualSystemDescription ExportTo(const CAppliance & aAppliance, const QString & aLocation);
    CSnapshot FindSnapshot(const QString & aNameOrId);
    void CreateSharedFolder(const QString & aName, const QString & aHostPath, BOOL aWritable, BOOL aAutomount, const QString & aAutoMountPoint);
    void RemoveSharedFolder(const QString & aName);
    BOOL CanShowConsoleWindow();
    LONG64 ShowConsoleWindow();
    void GetGuestProperty(const QString & aName, QString & aValue, LONG64 & aTimestamp, QString & aFlags) const;
    QString GetGuestPropertyValue(const QString & aProperty) const;
    LONG64 GetGuestPropertyTimestamp(const QString & aProperty) const;
    void SetGuestProperty(const QString & aProperty, const QString & aValue, const QString & aFlags);
    void SetGuestPropertyValue(const QString & aProperty, const QString & aValue);
    void DeleteGuestProperty(const QString & aName) const;
    void EnumerateGuestProperties(const QString & aPatterns, QVector<QString> & aNames, QVector<QString> & aValues, QVector<LONG64> & aTimestamps, QVector<QString> & aFlags) const;
    void QuerySavedGuestScreenInfo(ULONG aScreenId, ULONG & aOriginX, ULONG & aOriginY, ULONG & aWidth, ULONG & aHeight, BOOL & aEnabled) const;
    QVector<BYTE> ReadSavedThumbnailToArray(ULONG aScreenId, KBitmapFormat aBitmapFormat, ULONG & aWidth, ULONG & aHeight);
    QVector<KBitmapFormat> QuerySavedScreenshotInfo(ULONG aScreenId, ULONG & aWidth, ULONG & aHeight);
    QVector<BYTE> ReadSavedScreenshotToArray(ULONG aScreenId, KBitmapFormat aBitmapFormat, ULONG & aWidth, ULONG & aHeight);
    void HotPlugCPU(ULONG aCpu);
    void HotUnplugCPU(ULONG aCpu);
    BOOL GetCPUStatus(ULONG aCpu);
    KParavirtProvider GetEffectiveParavirtProvider() const;
    QString QueryLogFilename(ULONG aIdx);
    QVector<BYTE> ReadLog(ULONG aIdx, LONG64 aOffset, LONG64 aSize);
    CProgress CloneTo(const CMachine & aTarget, KCloneMode aMode, const QVector<KCloneOptions> & aOptions);
    CProgress MoveTo(const QString & aFolder, const QString & aType);
    CProgress SaveState();
    void AdoptSavedState(const QString & aSavedStateFile);
    void DiscardSavedState(BOOL aFRemoveFile);
    CProgress TakeSnapshot(const QString & aName, const QString & aDescription, BOOL aPause, QUuid & aId);
    CProgress DeleteSnapshot(QUuid aId);
    CProgress DeleteSnapshotAndAllChildren(QUuid aId);
    CProgress DeleteSnapshotRange(QUuid aStartId, QUuid aEndId);
    CProgress RestoreSnapshot(const CSnapshot & aSnapshot);
    void ApplyDefaults(const QString & aFlags);
    CProgress ChangeEncryption(const QString & aCurrentPassword, const QString & aCipher, const QString & aNewPassword, const QString & aNewPasswordId, BOOL aForce);
    void GetEncryptionSettings(QString & aCipher, QString & aPasswordId) const;
    void CheckEncryptionPassword(const QString & aPassword) const;
    void AddEncryptionPassword(const QString & aId, const QString & aPassword);
    void AddEncryptionPasswords(const QVector<QString> & aIds, const QVector<QString> & aPasswords);
    void RemoveEncryptionPassword(const QString & aId);
    void ClearAllEncryptionPasswords();

    /* ExtraData helpers: */
    void SetExtraDataBool(const QString &strKey, bool fValue);
    bool GetExtraDataBool(const QString &strKey, bool fDef = true);
    void SetExtraDataInt(const QString &strKey, int value);
    int GetExtraDataInt(const QString &strKey, int def = 0);
    void SetExtraDataRect(const QString &strKey, const QRect &value);
    QRect GetExtraDataRect(const QString &strKey, const QRect &def = QRect());
    void SetExtraDataStringList(const QString &strKey, const QStringList &value);
    QStringList GetExtraDataStringList(const QString &strKey, QStringList def = QStringList());
    void SetExtraDataIntList(const QString &strKey, const QList<int> &value);
    QList<int> GetExtraDataIntList(const QString &strKey, QList<int> def = QList<int>());

    /* Friend wrappers: */
    friend class CUnknown;
    friend class CVirtualBox;
    friend class CUnattended;
    friend class CConsole;
    friend class CSnapshot;
    friend class CMediumAttachment;
    friend class CInternalSessionControl;
    friend class CSession;
    friend class CVirtualBoxClient;
};

/* Let QMetaType know about generated interface: */
Q_DECLARE_METATYPE(CMachine);

/* Declare safe-array: */
typedef QVector<CMachine> CMachineVector;

#endif /* __CMachine_h__ */

