/* IndicatorManager.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from IndicatorManager.vala, do not modify */

/*
 * Copyright (c) 2011-2015 Wingpanel Developers (http://launchpad.net/wingpanel)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA.
 */

#include "wingpanel.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include "config.h"
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	WINGPANEL_INDICATOR_MANAGER_0_PROPERTY,
	WINGPANEL_INDICATOR_MANAGER_NUM_PROPERTIES
};
static GParamSpec* wingpanel_indicator_manager_properties[WINGPANEL_INDICATOR_MANAGER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_module_close0(var) ((var == NULL) ? NULL : (var = (g_module_close (var), NULL)))
typedef WingpanelIndicator* (*WingpanelIndicatorManagerRegisterPluginFunction) (GModule* module, WingpanelIndicatorManagerServerType server_type);
typedef struct _Block1Data Block1Data;
enum  {
	WINGPANEL_INDICATOR_MANAGER_INDICATOR_ADDED_SIGNAL,
	WINGPANEL_INDICATOR_MANAGER_INDICATOR_REMOVED_SIGNAL,
	WINGPANEL_INDICATOR_MANAGER_NUM_SIGNALS
};
static guint wingpanel_indicator_manager_signals[WINGPANEL_INDICATOR_MANAGER_NUM_SIGNALS] = {0};

struct _WingpanelIndicatorManagerPrivate {
	GeeHashMap* indicators;
	GFileMonitor* monitor;
	WingpanelIndicatorManagerServerType server_type;
};

struct _Block1Data {
	int _ref_count_;
	WingpanelIndicatorManager* self;
	GeeHashMap* deregister_map;
	WingpanelIndicator* indicator;
};

static gint WingpanelIndicatorManager_private_offset;
static gpointer wingpanel_indicator_manager_parent_class = NULL;
static WingpanelIndicatorManager* wingpanel_indicator_manager_indicator_manager;
static WingpanelIndicatorManager* wingpanel_indicator_manager_indicator_manager = NULL;

static WingpanelIndicatorManager* wingpanel_indicator_manager_new (void);
static WingpanelIndicatorManager* wingpanel_indicator_manager_construct (GType object_type);
static void ___lambda4_ (WingpanelIndicatorManager* self,
                  GFile* file,
                  GFile* trash,
                  GFileMonitorEvent event);
static void wingpanel_indicator_manager_load (WingpanelIndicatorManager* self,
                                       const gchar* path);
static void ____lambda4__g_file_monitor_changed (GFileMonitor* _sender,
                                          GFile* file,
                                          GFile* other_file,
                                          GFileMonitorEvent event_type,
                                          gpointer self);
static void wingpanel_indicator_manager_find_plugins (WingpanelIndicatorManager* self,
                                               GFile* base_folder);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static gboolean __lambda5_ (Block1Data* _data1_,
                     GeeMapEntry* entry);
static gboolean ___lambda5__gee_forall_func (gpointer g,
                                      gpointer self);
static gboolean __lambda6_ (WingpanelIndicatorManager* self,
                     GeeMapEntry* entry);
static gboolean ___lambda6__gee_forall_func (gpointer g,
                                      gpointer self);
static void wingpanel_indicator_manager_finalize (GObject * obj);
static GType wingpanel_indicator_manager_get_type_once (void);

static inline gpointer
wingpanel_indicator_manager_get_instance_private (WingpanelIndicatorManager* self)
{
	return G_STRUCT_MEMBER_P (self, WingpanelIndicatorManager_private_offset);
}

/**
     * The type of the server displaying the indicator.
     */
gchar*
wingpanel_indicator_manager_server_type_restrictions_file_name (WingpanelIndicatorManagerServerType self)
{
	gchar* result;
	switch (self) {
		case WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("default");
			result = _tmp0_;
			return result;
		}
		case WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_GREETER:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("greeter");
			result = _tmp1_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
wingpanel_indicator_manager_server_type_get_type_once (void)
{
	static const GEnumValue values[] = {{WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION, "WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_SESSION", "session"}, {WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_GREETER, "WINGPANEL_INDICATOR_MANAGER_SERVER_TYPE_GREETER", "greeter"}, {0, NULL, NULL}};
	GType wingpanel_indicator_manager_server_type_type_id;
	wingpanel_indicator_manager_server_type_type_id = g_enum_register_static ("WingpanelIndicatorManagerServerType", values);
	return wingpanel_indicator_manager_server_type_type_id;
}

GType
wingpanel_indicator_manager_server_type_get_type (void)
{
	static volatile gsize wingpanel_indicator_manager_server_type_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_indicator_manager_server_type_type_id__once)) {
		GType wingpanel_indicator_manager_server_type_type_id;
		wingpanel_indicator_manager_server_type_type_id = wingpanel_indicator_manager_server_type_get_type_once ();
		g_once_init_leave (&wingpanel_indicator_manager_server_type_type_id__once, wingpanel_indicator_manager_server_type_type_id);
	}
	return wingpanel_indicator_manager_server_type_type_id__once;
}

WingpanelIndicatorManager*
wingpanel_indicator_manager_get_default (void)
{
	WingpanelIndicatorManager* _tmp0_;
	WingpanelIndicatorManager* _tmp2_;
	WingpanelIndicatorManager* result;
	_tmp0_ = wingpanel_indicator_manager_indicator_manager;
	if (_tmp0_ == NULL) {
		WingpanelIndicatorManager* _tmp1_;
		_tmp1_ = wingpanel_indicator_manager_new ();
		_g_object_unref0 (wingpanel_indicator_manager_indicator_manager);
		wingpanel_indicator_manager_indicator_manager = _tmp1_;
	}
	_tmp2_ = wingpanel_indicator_manager_indicator_manager;
	result = _tmp2_;
	return result;
}

static WingpanelIndicatorManager*
wingpanel_indicator_manager_construct (GType object_type)
{
	WingpanelIndicatorManager * self = NULL;
	GeeHashMap* _tmp0_;
	self = (WingpanelIndicatorManager*) g_object_new (object_type, NULL);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, WINGPANEL_TYPE_INDICATOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->indicators);
	self->priv->indicators = _tmp0_;
	return self;
}

static WingpanelIndicatorManager*
wingpanel_indicator_manager_new (void)
{
	return wingpanel_indicator_manager_construct (WINGPANEL_TYPE_INDICATOR_MANAGER);
}

/**
     * Run this method to initialize the indicator manager.
     *
     * @param server_type The server the indicators will be displayed on.
     */
static void
___lambda4_ (WingpanelIndicatorManager* self,
             GFile* file,
             GFile* trash,
             GFileMonitorEvent event)
{
	gchar* plugin_path = NULL;
	gchar* _tmp0_;
	g_return_if_fail (file != NULL);
	_tmp0_ = g_file_get_path (file);
	plugin_path = _tmp0_;
	if (event == G_FILE_MONITOR_EVENT_CHANGES_DONE_HINT) {
		const gchar* _tmp1_;
		_tmp1_ = plugin_path;
		wingpanel_indicator_manager_load (self, _tmp1_);
	} else {
		if (event == G_FILE_MONITOR_EVENT_DELETED) {
			WingpanelIndicator* indicator = NULL;
			GeeHashMap* _tmp2_;
			const gchar* _tmp3_;
			gpointer _tmp4_;
			WingpanelIndicator* _tmp5_;
			_tmp2_ = self->priv->indicators;
			_tmp3_ = plugin_path;
			_tmp4_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp2_, _tmp3_);
			indicator = (WingpanelIndicator*) _tmp4_;
			_tmp5_ = indicator;
			if (_tmp5_ != NULL) {
				const gchar* _tmp6_;
				WingpanelIndicator* _tmp7_;
				_tmp6_ = plugin_path;
				_tmp7_ = indicator;
				wingpanel_indicator_manager_deregister_indicator (self, _tmp6_, _tmp7_);
			}
			_g_object_unref0 (indicator);
		}
	}
	_g_free0 (plugin_path);
}

static void
____lambda4__g_file_monitor_changed (GFileMonitor* _sender,
                                     GFile* file,
                                     GFile* other_file,
                                     GFileMonitorEvent event_type,
                                     gpointer self)
{
	___lambda4_ ((WingpanelIndicatorManager*) self, file, other_file, event_type);
}

void
wingpanel_indicator_manager_initialize (WingpanelIndicatorManager* self,
                                        WingpanelIndicatorManagerServerType server_type)
{
	GFile* base_folder = NULL;
	GFile* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->server_type = server_type;
	_tmp0_ = g_file_new_for_path (INDICATORS_DIR);
	base_folder = _tmp0_;
	{
		GFileMonitor* _tmp1_ = NULL;
		GFileMonitor* _tmp2_;
		GFileMonitor* _tmp3_;
		GFileMonitor* _tmp4_;
		_tmp2_ = g_file_monitor_directory (base_folder, G_FILE_MONITOR_NONE, NULL, &_inner_error0_);
		_tmp1_ = _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp3_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (self->priv->monitor);
		self->priv->monitor = _tmp3_;
		_tmp4_ = self->priv->monitor;
		g_signal_connect_object (_tmp4_, "changed", (GCallback) ____lambda4__g_file_monitor_changed, self, 0);
		_g_object_unref0 (_tmp1_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GError* _tmp7_;
		const gchar* _tmp8_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = g_file_get_path (base_folder);
		_tmp6_ = _tmp5_;
		_tmp7_ = _error_;
		_tmp8_ = _tmp7_->message;
		g_warning ("IndicatorManager.vala:105: Creating monitor for %s failed: %s\n", _tmp6_, _tmp8_);
		_g_free0 (_tmp6_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (base_folder);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	wingpanel_indicator_manager_find_plugins (self, base_folder);
	_g_object_unref0 (base_folder);
}

static void
wingpanel_indicator_manager_load (WingpanelIndicatorManager* self,
                                  const gchar* path)
{
	GeeHashMap* _tmp0_;
	GModule* module = NULL;
	GModule* _tmp1_;
	GModule* _tmp2_;
	void* function = NULL;
	GModule* _tmp4_;
	void* _tmp5_ = NULL;
	gboolean _tmp6_;
	void* _tmp7_;
	WingpanelIndicatorManagerRegisterPluginFunction register_plugin = NULL;
	void* _tmp8_;
	WingpanelIndicator* indicator = NULL;
	WingpanelIndicatorManagerRegisterPluginFunction _tmp9_;
	GModule* _tmp10_;
	WingpanelIndicator* _tmp11_;
	WingpanelIndicator* _tmp12_;
	GModule* _tmp13_;
	WingpanelIndicator* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	if (!g_module_supported ()) {
		g_error ("IndicatorManager.vala:113: Wingpanel is not supported by this system!");
	}
	_tmp0_ = self->priv->indicators;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, path)) {
		return;
	}
	_tmp1_ = g_module_open (path, G_MODULE_BIND_LAZY);
	module = _tmp1_;
	_tmp2_ = module;
	if (_tmp2_ == NULL) {
		const gchar* _tmp3_;
		_tmp3_ = g_module_error ();
		g_critical ("IndicatorManager.vala:123: %s", _tmp3_);
		_g_module_close0 (module);
		return;
	}
	_tmp4_ = module;
	_tmp6_ = g_module_symbol (_tmp4_, "get_indicator", &_tmp5_);
	function = _tmp5_;
	if (!_tmp6_) {
		_g_module_close0 (module);
		return;
	}
	_tmp7_ = function;
	if (_tmp7_ == NULL) {
		g_critical ("IndicatorManager.vala:135: get_indicator () not found in %s", path);
		_g_module_close0 (module);
		return;
	}
	_tmp8_ = function;
	register_plugin = (WingpanelIndicatorManagerRegisterPluginFunction) _tmp8_;
	_tmp9_ = register_plugin;
	_tmp10_ = module;
	_tmp11_ = _tmp9_ (_tmp10_, self->priv->server_type);
	indicator = _tmp11_;
	_tmp12_ = indicator;
	if (_tmp12_ == NULL) {
		g_debug ("IndicatorManager.vala:144: Unknown plugin type for %s or indicator is " \
"hidden on this server!", path);
		_g_object_unref0 (indicator);
		_g_module_close0 (module);
		return;
	}
	_tmp13_ = module;
	g_module_make_resident (_tmp13_);
	_tmp14_ = indicator;
	wingpanel_indicator_manager_register_indicator (self, path, _tmp14_);
	_g_object_unref0 (indicator);
	_g_module_close0 (module);
}

static void
wingpanel_indicator_manager_find_plugins (WingpanelIndicatorManager* self,
                                          GFile* base_folder)
{
	GFileInfo* file_info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (base_folder != NULL);
	file_info = NULL;
	{
		GFileEnumerator* enumerator = NULL;
		GFileEnumerator* _tmp0_;
		_tmp0_ = g_file_enumerate_children (base_folder, G_FILE_ATTRIBUTE_STANDARD_NAME "," G_FILE_ATTRIBUTE_STANDARD_TYPE "," G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, 0, NULL, &_inner_error0_);
		enumerator = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		while (TRUE) {
			GFileInfo* _tmp1_ = NULL;
			GFileEnumerator* _tmp2_;
			GFileInfo* _tmp3_;
			GFileInfo* _tmp4_;
			GFileInfo* _tmp5_;
			GFile* file = NULL;
			GFileInfo* _tmp6_;
			const gchar* _tmp7_;
			GFile* _tmp8_;
			gboolean _tmp9_ = FALSE;
			GFileInfo* _tmp10_;
			_tmp2_ = enumerator;
			_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error0_);
			_tmp1_ = _tmp3_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (enumerator);
				goto __catch0_g_error;
			}
			_tmp4_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (file_info);
			file_info = _tmp4_;
			_tmp5_ = file_info;
			if (!(_tmp5_ != NULL)) {
				_g_object_unref0 (_tmp1_);
				break;
			}
			_tmp6_ = file_info;
			_tmp7_ = g_file_info_get_name (_tmp6_);
			_tmp8_ = g_file_get_child (base_folder, _tmp7_);
			file = _tmp8_;
			_tmp10_ = file_info;
			if (g_file_info_get_file_type (_tmp10_) == G_FILE_TYPE_REGULAR) {
				GFileInfo* _tmp11_;
				const gchar* _tmp12_;
				_tmp11_ = file_info;
				_tmp12_ = g_file_info_get_content_type (_tmp11_);
				_tmp9_ = g_content_type_equals (_tmp12_, "application/x-sharedlib");
			} else {
				_tmp9_ = FALSE;
			}
			if (_tmp9_) {
				GFile* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				_tmp13_ = file;
				_tmp14_ = g_file_get_path (_tmp13_);
				_tmp15_ = _tmp14_;
				wingpanel_indicator_manager_load (self, _tmp15_);
				_g_free0 (_tmp15_);
			} else {
				GFileInfo* _tmp16_;
				_tmp16_ = file_info;
				if (g_file_info_get_file_type (_tmp16_) == G_FILE_TYPE_DIRECTORY) {
					GFile* _tmp17_;
					_tmp17_ = file;
					wingpanel_indicator_manager_find_plugins (self, _tmp17_);
				}
			}
			_g_object_unref0 (file);
			_g_object_unref0 (_tmp1_);
		}
		_g_object_unref0 (enumerator);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* _error_ = NULL;
		gchar* _tmp18_;
		gchar* _tmp19_;
		GError* _tmp20_;
		const gchar* _tmp21_;
		_error_ = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp18_ = g_file_get_path (base_folder);
		_tmp19_ = _tmp18_;
		_tmp20_ = _error_;
		_tmp21_ = _tmp20_->message;
		g_warning ("IndicatorManager.vala:169: Unable to scan indicators folder %s: %s\n", _tmp19_, _tmp21_);
		_g_free0 (_tmp19_);
		_g_error_free0 (_error_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (file_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_object_unref0 (file_info);
}

/**
     * Register a new indicator.
     *
     * @param path The path to the plugin file. (Used to identify the indicator)
     * @param indicator The indicator.
     */
static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		WingpanelIndicatorManager* self;
		self = _data1_->self;
		_g_object_unref0 (_data1_->deregister_map);
		_g_object_unref0 (_data1_->indicator);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static gboolean
__lambda5_ (Block1Data* _data1_,
            GeeMapEntry* entry)
{
	WingpanelIndicatorManager* self;
	WingpanelIndicator* val = NULL;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	WingpanelIndicator* _tmp2_;
	WingpanelIndicator* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gboolean result;
	self = _data1_->self;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = gee_map_entry_get_value (entry);
	_tmp1_ = _tmp0_;
	_tmp2_ = _g_object_ref0 ((WingpanelIndicator*) _tmp1_);
	val = _tmp2_;
	_tmp3_ = val;
	_tmp4_ = wingpanel_indicator_get_code_name (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = wingpanel_indicator_get_code_name (_data1_->indicator);
	_tmp7_ = _tmp6_;
	if (g_strcmp0 (_tmp5_, _tmp7_) == 0) {
		gconstpointer _tmp8_;
		gconstpointer _tmp9_;
		WingpanelIndicator* _tmp10_;
		_tmp8_ = gee_map_entry_get_key (entry);
		_tmp9_ = _tmp8_;
		_tmp10_ = val;
		gee_abstract_map_set ((GeeAbstractMap*) _data1_->deregister_map, (const gchar*) _tmp9_, _tmp10_);
	}
	result = TRUE;
	_g_object_unref0 (val);
	_g_object_unref0 (entry);
	return result;
}

static gboolean
___lambda5__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda5_ (self, (GeeMapEntry*) g);
	return result;
}

static gboolean
__lambda6_ (WingpanelIndicatorManager* self,
            GeeMapEntry* entry)
{
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	gconstpointer _tmp2_;
	gconstpointer _tmp3_;
	gboolean result;
	g_return_val_if_fail (entry != NULL, FALSE);
	_tmp0_ = gee_map_entry_get_key (entry);
	_tmp1_ = _tmp0_;
	_tmp2_ = gee_map_entry_get_value (entry);
	_tmp3_ = _tmp2_;
	wingpanel_indicator_manager_deregister_indicator (self, (const gchar*) _tmp1_, (WingpanelIndicator*) _tmp3_);
	result = TRUE;
	_g_object_unref0 (entry);
	return result;
}

static gboolean
___lambda6__gee_forall_func (gpointer g,
                             gpointer self)
{
	gboolean result;
	result = __lambda6_ ((WingpanelIndicatorManager*) self, (GeeMapEntry*) g);
	return result;
}

void
wingpanel_indicator_manager_register_indicator (WingpanelIndicatorManager* self,
                                                const gchar* path,
                                                WingpanelIndicator* indicator)
{
	Block1Data* _data1_;
	WingpanelIndicator* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeHashMap* _tmp4_;
	GeeHashMap* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (indicator != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (indicator);
	_g_object_unref0 (_data1_->indicator);
	_data1_->indicator = _tmp0_;
	_tmp1_ = wingpanel_indicator_get_code_name (_data1_->indicator);
	_tmp2_ = _tmp1_;
	g_debug ("IndicatorManager.vala:180: %s registered", _tmp2_);
	_tmp3_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, WINGPANEL_TYPE_INDICATOR, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_data1_->deregister_map = _tmp3_;
	_tmp4_ = self->priv->indicators;
	gee_abstract_map_foreach ((GeeAbstractMap*) _tmp4_, ___lambda5__gee_forall_func, _data1_);
	gee_abstract_map_foreach ((GeeAbstractMap*) _data1_->deregister_map, ___lambda6__gee_forall_func, self);
	_tmp5_ = self->priv->indicators;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp5_, path, _data1_->indicator);
	g_signal_emit (self, wingpanel_indicator_manager_signals[WINGPANEL_INDICATOR_MANAGER_INDICATOR_ADDED_SIGNAL], 0, _data1_->indicator);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

/**
     * Deregisters an indicator.
     *
     * @param path The path to the plugin file. (Used to identify the indicator)
     * @param indicator The indicator.
     */
void
wingpanel_indicator_manager_deregister_indicator (WingpanelIndicatorManager* self,
                                                  const gchar* path,
                                                  WingpanelIndicator* indicator)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GeeHashMap* _tmp2_;
	GeeHashMap* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	g_return_if_fail (indicator != NULL);
	_tmp0_ = wingpanel_indicator_get_code_name (indicator);
	_tmp1_ = _tmp0_;
	g_debug ("IndicatorManager.vala:209: %s deregistered", _tmp1_);
	_tmp2_ = self->priv->indicators;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, path)) {
		return;
	}
	_tmp3_ = self->priv->indicators;
	if (gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, path, NULL)) {
		g_signal_emit (self, wingpanel_indicator_manager_signals[WINGPANEL_INDICATOR_MANAGER_INDICATOR_REMOVED_SIGNAL], 0, indicator);
	}
}

/**
     * Checks if indicators are loaded.
     *
     * @return True if there are any indicators loaded.
     */
gboolean
wingpanel_indicator_manager_has_indicators (WingpanelIndicatorManager* self)
{
	GeeHashMap* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->indicators;
	_tmp1_ = gee_map_get_is_empty ((GeeMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = !_tmp2_;
	return result;
}

/**
     * Gets the list of loaded indicators.
     *
     * @return a {@link Gee.Collection} containing the indicators.
     */
GeeCollection*
wingpanel_indicator_manager_get_indicators (WingpanelIndicatorManager* self)
{
	GeeHashMap* _tmp0_;
	GeeCollection* _tmp1_;
	GeeCollection* _tmp2_;
	GeeCollection* _tmp3_;
	GeeCollection* _tmp4_;
	GeeCollection* _tmp5_;
	GeeCollection* _tmp6_;
	GeeCollection* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->indicators;
	_tmp1_ = gee_abstract_map_get_values ((GeeAbstractMap*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp4_ = gee_collection_get_read_only_view (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_;
	_g_object_unref0 (_tmp3_);
	result = _tmp6_;
	return result;
}

static void
wingpanel_indicator_manager_class_init (WingpanelIndicatorManagerClass * klass,
                                        gpointer klass_data)
{
	wingpanel_indicator_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WingpanelIndicatorManager_private_offset);
	G_OBJECT_CLASS (klass)->finalize = wingpanel_indicator_manager_finalize;
	/**
	     * Called when a new indicator was added.
	     */
	wingpanel_indicator_manager_signals[WINGPANEL_INDICATOR_MANAGER_INDICATOR_ADDED_SIGNAL] = g_signal_new ("indicator-added", WINGPANEL_TYPE_INDICATOR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, WINGPANEL_TYPE_INDICATOR);
	/**
	     * Called when an indicator was removed.
	     */
	wingpanel_indicator_manager_signals[WINGPANEL_INDICATOR_MANAGER_INDICATOR_REMOVED_SIGNAL] = g_signal_new ("indicator-removed", WINGPANEL_TYPE_INDICATOR_MANAGER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, WINGPANEL_TYPE_INDICATOR);
}

static void
wingpanel_indicator_manager_instance_init (WingpanelIndicatorManager * self,
                                           gpointer klass)
{
	self->priv = wingpanel_indicator_manager_get_instance_private (self);
	self->priv->monitor = NULL;
}

static void
wingpanel_indicator_manager_finalize (GObject * obj)
{
	WingpanelIndicatorManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WINGPANEL_TYPE_INDICATOR_MANAGER, WingpanelIndicatorManager);
	_g_object_unref0 (self->priv->indicators);
	_g_object_unref0 (self->priv->monitor);
	G_OBJECT_CLASS (wingpanel_indicator_manager_parent_class)->finalize (obj);
}

static GType
wingpanel_indicator_manager_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WingpanelIndicatorManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) wingpanel_indicator_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WingpanelIndicatorManager), 0, (GInstanceInitFunc) wingpanel_indicator_manager_instance_init, NULL };
	GType wingpanel_indicator_manager_type_id;
	wingpanel_indicator_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "WingpanelIndicatorManager", &g_define_type_info, 0);
	WingpanelIndicatorManager_private_offset = g_type_add_instance_private (wingpanel_indicator_manager_type_id, sizeof (WingpanelIndicatorManagerPrivate));
	return wingpanel_indicator_manager_type_id;
}

GType
wingpanel_indicator_manager_get_type (void)
{
	static volatile gsize wingpanel_indicator_manager_type_id__once = 0;
	if (g_once_init_enter (&wingpanel_indicator_manager_type_id__once)) {
		GType wingpanel_indicator_manager_type_id;
		wingpanel_indicator_manager_type_id = wingpanel_indicator_manager_get_type_once ();
		g_once_init_leave (&wingpanel_indicator_manager_type_id__once, wingpanel_indicator_manager_type_id);
	}
	return wingpanel_indicator_manager_type_id__once;
}

