// generated by Fast Light User Interface Designer (fluid) version 1.0404

#include "ConfigUI.h"
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2014 -2024, Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is derivative of ZynAddSubFX original code.


#include "Misc/SynthEngine.h"
#include "Misc/Bank.h"
#include "MasterUI.h"
#include "Misc/FileMgrFuncs.h"
#include "Misc/NumericFuncs.h"
#include "Misc/FormatFuncs.h"
#include "Misc/TextMsgBuffer.h"

    namespace { // Implementation details...
        TextMsgBuffer& textMsgBuffer = TextMsgBuffer::instance();
    }

void ConfigUI::cb_configwindow_i(ScaleTrackedWindow*, void*) {
  close->do_callback();
}
void ConfigUI::cb_configwindow(ScaleTrackedWindow* o, void* v) {
  ((ConfigUI*)(o->user_data()))->cb_configwindow_i(o,v);
}

void ConfigUI::cb_Tab1_i(Fl_Button*, void*) {
  mainTab->show();
  patch1->show();
  patch2->hide();
  patch3->hide();
  patch4->hide();
  patch5->hide();
  patch6->hide();
  switchesTab->hide();
  jackTab->hide();
  alsaTab->hide();
  midiTab->hide();
  themeTab->hide();
}
void ConfigUI::cb_Tab1(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Tab1_i(o,v);
}

void ConfigUI::cb_Tab2_i(Fl_Button*, void*) {
  switchesTab->show();
  patch2->show();
  patch1->hide();
  patch3->hide();
  patch4->hide();
  patch5->hide();
  patch6->hide();
  mainTab->hide();
  jackTab->hide();
  alsaTab->hide();
  midiTab->hide();
  themeTab->hide();
}
void ConfigUI::cb_Tab2(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Tab2_i(o,v);
}

void ConfigUI::cb_Tab3_i(Fl_Button*, void*) {
  jackTab->show();
  patch3->show();
  patch1->hide();
  patch2->hide();
  patch4->hide();
  patch5->hide();
  patch6->hide();
  mainTab->hide();
  switchesTab->hide();
  alsaTab->hide();
  midiTab->hide();
  themeTab->hide();
}
void ConfigUI::cb_Tab3(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Tab3_i(o,v);
}

void ConfigUI::cb_Tab4_i(Fl_Button*, void*) {
  alsaTab->show();
  patch4->show();
  patch1->hide();
  patch2->hide();
  patch3->hide();
  patch5->hide();
  patch6->hide();
  mainTab->hide();
  switchesTab->hide();
  jackTab->hide();
  midiTab->hide();
  themeTab->hide();
}
void ConfigUI::cb_Tab4(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Tab4_i(o,v);
}

void ConfigUI::cb_Tab5_i(Fl_Button*, void*) {
  midiTab->show();
  patch5->show();
  patch1->hide();
  patch2->hide();
  patch3->hide();
  patch4->hide();
  patch6->hide();
  mainTab->hide();
  switchesTab->hide();
  jackTab->hide();
  alsaTab->hide();
  themeTab->hide();
}
void ConfigUI::cb_Tab5(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Tab5_i(o,v);
}

void ConfigUI::cb_Tab6_i(Fl_Button*, void*) {
  themeTab->show();
  patch6->show();
  patch1->hide();
  patch2->hide();
  patch3->hide();
  patch4->hide();
  patch5->hide();
  mainTab->hide();
  switchesTab->hide();
  jackTab->hide();
  alsaTab->hide();
  midiTab->hide();
  fillThemes();
  ;
}
void ConfigUI::cb_Tab6(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_Tab6_i(o,v);
}

void ConfigUI::cb_buff_size_i(Fl_Choice* o, void*) {
  //
                          send_data(0, CONFIG::control::bufferSize, 16 << o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_buff_size(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_buff_size_i(o,v);
}

void ConfigUI::cb_osc_size_i(Fl_Choice* o, void*) {
  //
                          send_data(0, CONFIG::control::oscillatorSize, 256 << o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_osc_size(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_osc_size_i(o,v);
}

void ConfigUI::cb_pad_interpol_i(Fl_Choice* o, void*) {
  //
                          send_data(0, CONFIG::control::padSynthInterpolation, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_pad_interpol(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_pad_interpol_i(o,v);
}

void ConfigUI::cb_handlePadSynthBuild_i(Fl_Choice* o, void*) {
  //
                          send_data(0, CONFIG::control::handlePadSynthBuild, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_handlePadSynthBuild(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_handlePadSynthBuild_i(o,v);
}

void ConfigUI::cb_v_keyboard_i(Fl_Choice* o, void*) {
  //
                          send_data(0, CONFIG::control::virtualKeyboardLayout, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_v_keyboard(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_v_keyboard_i(o,v);
}

void ConfigUI::cb_reports_i(Fl_Choice* o, void*) {
  //
                          send_data(TOPLEVEL::action::forceUpdate, CONFIG::control::reportsDestination, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_reports(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_reports_i(o,v);
}

void ConfigUI::cb_logText_i(Fl_Counter* o, void*) {
  //
                          send_data(0, CONFIG::control::logTextSize, o->value(), TOPLEVEL::type::Integer);
                          synth->getGuiMaster()->yoshiLog->setLogText(o->value());
}
void ConfigUI::cb_logText(Fl_Counter* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_logText_i(o,v);
}

void ConfigUI::cb_compression_i(Fl_Counter* o, void*) {
  //
                          send_data(0, CONFIG::control::XMLcompressionLevel, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_compression(Fl_Counter* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_compression_i(o,v);
}

void ConfigUI::cb_instrument_i(Fl_Choice* o, void*) {
  //
                          send_data(0, CONFIG::control::savedInstrumentFormat, o->value() + 1, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_instrument(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_instrument_i(o,v);
}

void ConfigUI::cb_PanelLayout_i(Fl_Choice* o, void*) {
  //
              int style = 2 - int(o->value());
              synth->getGuiMaster()->changepanelstyle(style, true);
}
void ConfigUI::cb_PanelLayout(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_PanelLayout_i(o,v);
}

void ConfigUI::cb_bankHighlight_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::enableHighlight, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_bankHighlight(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_bankHighlight_i(o,v);
}

void ConfigUI::cb_partReports_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::enablePartReports, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_partReports(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_partReports_i(o,v);
}

void ConfigUI::cb_nonFatal_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::hideNonFatalErrors, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_nonFatal(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_nonFatal_i(o,v);
}

void ConfigUI::cb_showSplash_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::showSplash, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_showSplash(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_showSplash_i(o,v);
}

void ConfigUI::cb_logXML_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::logXMLheaders, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_logXML(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_logXML_i(o,v);
}

void ConfigUI::cb_logTimes_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::logInstrumentLoadTimes, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_logTimes(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_logTimes_i(o,v);
}

void ConfigUI::cb_saveAllXML_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::saveAllXMLdata, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_saveAllXML(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_saveAllXML_i(o,v);
}

void ConfigUI::cb_enableGUI_i(Fl_Check_Button2* o, void*) {
  //
                          int tmp = o->value();
                          int doit = true;
                          if (tmp == 0)
                              doit = choice(synth, "", "Yes", "No", "Are you sure you want to disable the GUI?\nThis can only be restored via the command line.") > 1;
                          if (doit)
                              send_data(0, CONFIG::control::enableGUI, o->value(), TOPLEVEL::type::Integer);
                          else
                              o->value(1);
}
void ConfigUI::cb_enableGUI(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_enableGUI_i(o,v);
}

void ConfigUI::cb_enableCLI_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::enableCLI, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_enableCLI(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_enableCLI_i(o,v);
}

void ConfigUI::cb_enableAuto_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::enableAutoInstance, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_enableAuto(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_enableAuto_i(o,v);
}

void ConfigUI::cb_singleMaster_i(Fl_Check_Button2* o, void*) {
  //
            send_data(0, CONFIG::control::enableSinglePath, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_singleMaster(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_singleMaster_i(o,v);
}

void ConfigUI::cb_setDefaultState_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::defaultStateStart, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_setDefaultState(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_setDefaultState_i(o,v);
}

void ConfigUI::cb_H_instrument_i(Fl_Check_Button2* o, void*) {
  //
                         send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::Instrument);
}
void ConfigUI::cb_H_instrument(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_instrument_i(o,v);
}

void ConfigUI::cb_H_patchset_i(Fl_Check_Button2* o, void*) {
  //
                         send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::Patch);
}
void ConfigUI::cb_H_patchset(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_patchset_i(o,v);
}

void ConfigUI::cb_H_scale_i(Fl_Check_Button2* o, void*) {
  //
                         send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::Scale);
}
void ConfigUI::cb_H_scale(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_scale_i(o,v);
}

void ConfigUI::cb_H_state_i(Fl_Check_Button2* o, void*) {
  //
                         send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::State);
}
void ConfigUI::cb_H_state(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_state_i(o,v);
}

void ConfigUI::cb_H_vector_i(Fl_Check_Button2* o, void*) {
  //
                         send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::Vector);
}
void ConfigUI::cb_H_vector(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_vector_i(o,v);
}

void ConfigUI::cb_H_mlearn_i(Fl_Check_Button2* o, void*) {
  //
                         send_data(TOPLEVEL::action::lowPrio, CONFIG::control::historyLock, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config,TOPLEVEL::XML::MLearn);
}
void ConfigUI::cb_H_mlearn(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_H_mlearn_i(o,v);
}

void ConfigUI::cb_jackSource_i(Fl_Input* o, void*) {
  //
                          string tmp = string(o->value());
                          send_data(TOPLEVEL::action::lowPrio, CONFIG::control::jackMidiSource, 0, TOPLEVEL::type::Integer, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(tmp));
}
void ConfigUI::cb_jackSource(Fl_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_jackSource_i(o,v);
}

void ConfigUI::cb_jackMidi_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(TOPLEVEL::action::forceUpdate, CONFIG::control::jackPreferredMidi, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_jackMidi(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_jackMidi_i(o,v);
}

void ConfigUI::cb_jackServer_i(Fl_Input* o, void*) {
  //
                          string tmp = string(o->value());
                          send_data(TOPLEVEL::action::lowPrio, CONFIG::control::jackServer, 0, TOPLEVEL::type::Integer, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(tmp));
}
void ConfigUI::cb_jackServer(Fl_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_jackServer_i(o,v);
}

void ConfigUI::cb_jackAudio_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(TOPLEVEL::action::forceUpdate, CONFIG::control::jackPreferredAudio, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_jackAudio(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_jackAudio_i(o,v);
}

void ConfigUI::cb_connectJackAudio_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::jackAutoConnectAudio, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_connectJackAudio(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_connectJackAudio_i(o,v);
}

void ConfigUI::cb_alsaType_i(Fl_Choice* o, void*) {
  if (o->value() == 0) // fixed
      alsaSource->activate();
  else
       alsaSource->deactivate();


  send_data (0, CONFIG::control::alsaMidiType, o->value(), TOPLEVEL::type::Integer, TOPLEVEL::section::config);
}
void ConfigUI::cb_alsaType(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaType_i(o,v);
}

void ConfigUI::cb_alsaSource_i(Fl_Input* o, void*) {
  //
                          string tmp = string(o->value());
                          send_data(TOPLEVEL::action::lowPrio, CONFIG::control::alsaMidiSource, 0, TOPLEVEL::type::Integer, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(tmp));
}
void ConfigUI::cb_alsaSource(Fl_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaSource_i(o,v);
}

void ConfigUI::cb_alsaMidi_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(TOPLEVEL::action::forceUpdate, CONFIG::control::alsaPreferredMidi, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_alsaMidi(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaMidi_i(o,v);
}

void ConfigUI::cb_alsaDevice_i(Fl_Input* o, void*) {
  //
                          string tmp = string(o->value());
                          send_data(TOPLEVEL::action::lowPrio, CONFIG::control::alsaAudioDevice, 0, TOPLEVEL::type::Integer, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(tmp));
}
void ConfigUI::cb_alsaDevice(Fl_Input* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaDevice_i(o,v);
}

void ConfigUI::cb_alsaSamplerate_i(Fl_Choice* o, void*) {
  //
      send_data(0, CONFIG::control::alsaSampleRate, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_alsaSamplerate(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaSamplerate_i(o,v);
}

void ConfigUI::cb_alsaAudio_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(TOPLEVEL::action::forceUpdate, CONFIG::control::alsaPreferredAudio, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_alsaAudio(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_alsaAudio_i(o,v);
}

void ConfigUI::cb_midiTab_i(Fl_Group*, void*) {
  //
                          EPCvalue = synth->getRuntime().midi_upper_voice_C;
                          if (EPCvalue >= 128)
                          {
                              EPCspinner->value(110);
                              EPCspinner->deactivate();
                          }
                          else
                          {
                              EPCspinner->value(EPCvalue);
                              EPCspinner->activate();
                          }
                          /*BankRootvalue = synth->getRuntime().midi_bank_root;
                          if (BankRootvalue >= 128)
                          {
                              BankRoot->value(0);
                              BankRoot->deactivate();
                          }
                          else
                          {
                              BankRoot->value(BankRootvalue);
                              BankRoot->activate();
                          }*/;
}
void ConfigUI::cb_midiTab(Fl_Group* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->user_data()))->cb_midiTab_i(o,v);
}

void ConfigUI::cb_bankrootchange_i(Fl_Choice* o, void*) {
  //
                          int candidate;
                          switch (o->value())
                          {
                              case 0:
                                  candidate = 32;
                                  break;
                              case 1:
                                  candidate = 0;
                                  break;
                              default:
                                  candidate = 128;
                                  break;
                          }
                          string name = testCC(candidate, CONFIG::control::bankRootCC);
                          if (!name.empty())
                          {
                              o->value(oldBank);
                              o->redraw();
                              switch(oldBank)
                              {
                                  case 0:
                                      candidate = 32;
                                      break;
                                  case 1:
                                      candidate = 0;
                                      break;
                                  default:
                                      candidate = 128;
                                      break;
                              }
                              alert(synth, "In use for " + name);
                          }
                          send_data(0, CONFIG::control::bankRootCC, candidate, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_bankrootchange(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_bankrootchange_i(o,v);
}

void ConfigUI::cb_bankchange_i(Fl_Choice* o, void*) {
  //
                          int candidate;
                          switch (o->value())
                          {
                              case 0:
                                  candidate = 32;
                                  break;
                              case 1:
                                  candidate = 0;
                                  break;
                              default:
                                  candidate = 128;
                                  break;
                          }
                          string name = testCC(candidate, CONFIG::control::bankCC);
                          if (!name.empty())
                          {
                              o->value(oldBank);
                              o->redraw();
                              switch(oldBank)
                              {
                                  case 0:
                                      candidate = 32;
                                      break;
                                  case 1:
                                      candidate = 0;
                                      break;
                                  default:
                                      candidate = 128;
                                      break;
                              }
                              alert(synth, "In use for " + name);
                          }
                          send_data(0, CONFIG::control::bankCC, candidate, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_bankchange(Fl_Choice* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_bankchange_i(o,v);
}

void ConfigUI::cb_progenable_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::enableProgramChange, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_progenable(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_progenable_i(o,v);
}

void ConfigUI::cb_EPCspinner_i(WidgetSpinner*, void*) {
  //
                          Epend->show();
}
void ConfigUI::cb_EPCspinner(WidgetSpinner* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_EPCspinner_i(o,v);
}

void ConfigUI::cb_Epend_i(Fl_Button* o, void*) {
  //
                          int candidate = EPCspinner->value();
                          if (candidate == EPCvalue)
                          {
                              o->hide();
                              return;
                          }
                          string name = testCC(candidate, CONFIG::control::extendedProgramChangeCC);
                          if (!name.empty())
                          {
                              alert(synth, "In use for " + name);
                              if (EPCvalue < 128)
                              {
                                  EPCspinner->value(EPCvalue);
                                  EPCspinner->redraw();
                              }
                              return;
                          }
                          EPCvalue = candidate;
                          o->hide();
                          send_data(0, CONFIG::control::extendedProgramChangeCC, EPCvalue, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_Epend(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_Epend_i(o,v);
}

void ConfigUI::cb_Epcheck_i(Fl_Check_Button2* o, void*) {
  // for some weird reason this *must* be the last item in the group
                          if (o->value() == 0)
                          {
                              EPCspinner->value(110);
                              EPCspinner->deactivate();
                              Epend->hide();
                              send_data(0, CONFIG::control::extendedProgramChangeCC, 128, TOPLEVEL::type::Integer);
                          }
                          else
                          {
                              EPCspinner->activate();
                              Epend->show();
                              EPCspinner->value(110);
                              EPCvalue = 128;
                          }
                          EPCspinner->redraw();
}
void ConfigUI::cb_Epcheck(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_Epcheck_i(o,v);
}

void ConfigUI::cb_enableOmniChange_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::enableOmni, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_enableOmniChange(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_enableOmniChange_i(o,v);
}

void ConfigUI::cb_enableNRPN_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::enableNRPNs, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_enableNRPN(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_enableNRPN_i(o,v);
}

void ConfigUI::cb_ignoreReset_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::ignoreResetAllCCs, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_ignoreReset(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_ignoreReset_i(o,v);
}

void ConfigUI::cb_midiMon_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::logIncomingCCs, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_midiMon(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_midiMon_i(o,v);
}

void ConfigUI::cb_midiLearned_i(Fl_Check_Button2* o, void*) {
  //
                          send_data(0, CONFIG::control::showLearnEditor, o->value(), TOPLEVEL::type::Integer);
}
void ConfigUI::cb_midiLearned(Fl_Check_Button2* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_midiLearned_i(o,v);
}

void ConfigUI::cb_themeTab_i(Fl_Group*, void*) {
  //;
}
void ConfigUI::cb_themeTab(Fl_Group* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->user_data()))->cb_themeTab_i(o,v);
}

void ConfigUI::cb_theme_browser_i(Fl_Browser* o, void*) {
  //
          if (!o->value())
              return;
          int result = o->value();
          if (result < 0)
              return;
          string line = string(o->text(result));
          if (line == "classic")
          {
              setClassicTable();
          }
          else
          {
              string fileName = file::localDir()+ "/themes/" + line + EXTEN::theme;
              int errLine = setUserTable(fileName);
              if (errLine != -1)
                  themeError(errLine);

              //synth->getRuntime().remoteGuiTheme = file::localDir()+ "/themes/" + line + ".clr";
          }
          selectedTheme->copy_label(line.c_str());
          currentTheme = line;
          while (defaultTheme.at(defaultTheme.length() - 1) < '!') // tidy up
              defaultTheme.pop_back(); // deals with spurious trailing whitespace

         if (line == defaultTheme)
          {
              nuTheme->deactivate();
          }
          else
          {
              nuTheme->activate();
          }
          synth->getGuiMaster()->themeTrigger = true;
          //send_data(TOPLEVEL::action::muteAndLoop | TOPLEVEL::action::forceUpdate, MAIN::control::masterResetAndMlearn, 0, TOPLEVEL::type::Integer, TOPLEVEL::section::main);
}
void ConfigUI::cb_theme_browser(Fl_Browser* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_theme_browser_i(o,v);
}

void ConfigUI::cb_themeImport_i(Fl_Button*, void*) {
  //
          string filename = setfiler(synth,"", "", false, TOPLEVEL::XML::Themes);
          if (filename.empty())
          {
              //synth->getRuntime().Log("Can't find " + filename);
              return;
          }
          filename += EXTEN::theme;
          string newfile = file::localDir() + "/themes/" + file::findLeafName(filename) + EXTEN::theme;
          int result = file::copyFile(filename, newfile,1);
          if (result == 0)
          {
              fillThemes();
          }
          else
          {
             synth->getRuntime().Log("Failed to install " + filename);
          }
}
void ConfigUI::cb_themeImport(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_themeImport_i(o,v);
}

void ConfigUI::cb_themeExport_i(Fl_Button*, void*) {
  //
              string source = file::localDir() + "/themes/" + currentTheme + EXTEN::theme;
              string filename = setfiler(synth,"", currentTheme, true, TOPLEVEL::XML::Themes);
              size_t found = filename.find(file::localDir());
              if (found!=std::string::npos)
              {
                  alert(synth, "Can't export on top of internal themes");
                  return;
              }
              if (filename.empty())
              {
                  //synth->getRuntime().Log("Nothing to export " + filename);
                  return;
              }
              filename += EXTEN::theme;
              if (file::copyFile(source, filename, 0))
              {
                  synth->getRuntime().Log("Failed to export " + filename);
              }
          ;
}
void ConfigUI::cb_themeExport(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_themeExport_i(o,v);
}

void ConfigUI::cb_setAsStored_i(Fl_Button*, void*) {
  //
                      string name = currentTheme + EXTEN::theme;
                      string file = file::localDir() + "/themes/ID/current.txt";
                      file::saveText(name, file);
                      defaultTheme = currentTheme;
                      storedTheme->copy_label(defaultTheme.c_str());
                      nuTheme->deactivate();
                      ;
}
void ConfigUI::cb_setAsStored(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->parent()->user_data()))->cb_setAsStored_i(o,v);
}

void ConfigUI::cb_monochrome_i(Fl_Check_Button* o, void*) {
  //
                  monoChrome = o->value();
                  if (currentTheme == "classic")
                  {
                      setClassicTable();
                  }
                  else
                  {
                      string fileName = file::localDir()+ "/themes/" + currentTheme + EXTEN::theme;
                      int errLine = setUserTable(fileName);
                      if (errLine != -1)
                          themeError(errLine);

                      //synth->getRuntime().remoteGuiTheme = file::localDir()+ "/themes/" + line + ".clr";
                  }
                  o->parent()->parent()->parent()->damage(1);
                  o->parent()->parent()->parent()->redraw();
                  synth->getGuiMaster()->themeTrigger = true;
                  ;
}
void ConfigUI::cb_monochrome(Fl_Check_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->parent()->parent()->user_data()))->cb_monochrome_i(o,v);
}

void ConfigUI::cb_close_i(Fl_Button*, void*) {
  //
           configwindow->hide();
           configSeen = false;
           saveWin(synth, configwindow->w(), configwindow->h(),configwindow->x(), configwindow->y(), false, "Config");
}
void ConfigUI::cb_close(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_close_i(o,v);
}

void ConfigUI::cb_presets_i(ScaleTrackedWindow*, void*) {
  pClose->do_callback();
}
void ConfigUI::cb_presets(ScaleTrackedWindow* o, void* v) {
  ((ConfigUI*)(o->user_data()))->cb_presets_i(o,v);
}

void ConfigUI::cb_presetbrowse_i(Fl_Browser* o, void*) {
  //
                      activatebutton_presetdir(o->value() != 0);
}
void ConfigUI::cb_presetbrowse(Fl_Browser* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_presetbrowse_i(o,v);
}

void ConfigUI::cb_addpreset_i(Fl_Button* o, void*) {
  //
                      string dirname = setfiler(synth,"Path for Presets dir", "", false, TOPLEVEL::XML::Dir);
                      if (dirname.length() < 3)
                          return;

                      send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate,CONFIG::control::addPresetRootDir, 0, TOPLEVEL::type::Integer, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, textMsgBuffer.push(dirname));
                      if (presetbrowse->size() >= MAX_PRESET_DIRS)
                          o->deactivate();
}
void ConfigUI::cb_addpreset(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_addpreset_i(o,v);
}

void ConfigUI::cb_removepresetbutton_i(Fl_Button*, void*) {
  //
                      if (presetbrowse->value() != 0)
                          send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate,CONFIG::control::removePresetRootDir, presetbrowse->value() - 1, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_removepresetbutton(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_removepresetbutton_i(o,v);
}

void ConfigUI::cb_makedefaultpresetbutton_i(Fl_Button*, void*) {
  //
                      send_data(TOPLEVEL::action::lowPrio | TOPLEVEL::action::forceUpdate,CONFIG::control::currentPresetRoot, presetbrowse->value() - 1, TOPLEVEL::type::Integer);
}
void ConfigUI::cb_makedefaultpresetbutton(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_makedefaultpresetbutton_i(o,v);
}

void ConfigUI::cb_pClose_i(Fl_Button*, void*) {
  //
          saveWin(synth, presets->w(), presets->h(), presets->x(), presets->y(), false, "Config-presets");
          presetsSeen = false;
          presets->hide();
}
void ConfigUI::cb_pClose(Fl_Button* o, void* v) {
  ((ConfigUI*)(o->parent()->user_data()))->cb_pClose_i(o,v);
}

bool ConfigUI::isLV2() {
  return synth->getRuntime().isLV2;
}

ScaleTrackedWindow* ConfigUI::make_window() {
  { ScaleTrackedWindow* o = configwindow = new ScaleTrackedWindow(390, 330, "Yoshimi Settings");
    configwindow->box(FL_FLAT_BOX);
    configwindow->color(FL_BACKGROUND_COLOR);
    configwindow->selection_color(FL_BACKGROUND_COLOR);
    configwindow->labeltype(FL_NO_LABEL);
    configwindow->labelfont(0);
    configwindow->labelsize(14);
    configwindow->labelcolor(FL_FOREGROUND_COLOR);
    configwindow->callback((Fl_Callback*)cb_configwindow, (void*)(this));
    configwindow->align(Fl_Align(FL_ALIGN_TOP));
    configwindow->when(FL_WHEN_RELEASE);
    { Tab1 = new Fl_Button(5, 5, 91, 22, "&Main Settings");
      Tab1->box(FL_THIN_UP_FRAME);
      Tab1->selection_color(FL_DARK1);
      Tab1->labelsize(12);
      Tab1->labelcolor((Fl_Color)64);
      Tab1->callback((Fl_Callback*)cb_Tab1);
    } // Fl_Button* Tab1
    { Tab2 = new Fl_Button(98, 5, 66, 22, "&Switches");
      Tab2->box(FL_THIN_UP_FRAME);
      Tab2->selection_color(FL_DARK1);
      Tab2->labelsize(12);
      Tab2->labelcolor((Fl_Color)64);
      Tab2->callback((Fl_Callback*)cb_Tab2);
    } // Fl_Button* Tab2
    { Tab3 = new Fl_Button(166, 5, 38, 22, "&Jack");
      Tab3->box(FL_THIN_UP_FRAME);
      Tab3->selection_color(FL_DARK1);
      Tab3->labelsize(12);
      Tab3->labelcolor((Fl_Color)64);
      Tab3->callback((Fl_Callback*)cb_Tab3);
    } // Fl_Button* Tab3
    { Tab4 = new Fl_Button(206, 5, 38, 22, "&Alsa");
      Tab4->box(FL_THIN_UP_FRAME);
      Tab4->selection_color(FL_DARK1);
      Tab4->labelsize(12);
      Tab4->labelcolor((Fl_Color)64);
      Tab4->callback((Fl_Callback*)cb_Tab4);
    } // Fl_Button* Tab4
    { Tab5 = new Fl_Button(246, 5, 58, 22, "MIDI &CCs");
      Tab5->box(FL_THIN_UP_FRAME);
      Tab5->selection_color(FL_DARK1);
      Tab5->labelsize(12);
      Tab5->labelcolor((Fl_Color)64);
      Tab5->callback((Fl_Callback*)cb_Tab5);
    } // Fl_Button* Tab5
    { Tab6 = new Fl_Button(305, 5, 58, 22, "&Theme");
      Tab6->box(FL_THIN_UP_FRAME);
      Tab6->selection_color(FL_DARK1);
      Tab6->labelsize(12);
      Tab6->labelcolor((Fl_Color)64);
      Tab6->callback((Fl_Callback*)cb_Tab6);
    } // Fl_Button* Tab6
    { configTabs = new Fl_Group(5, 5, 385, 298);
      configTabs->labelcolor((Fl_Color)64);
      { mainTab = new Fl_Group(5, 25, 382, 277);
        mainTab->box(FL_THIN_UP_BOX);
        mainTab->labelsize(12);
        mainTab->labelcolor((Fl_Color)64);
        mainTab->hide();
        { Fl_Choice* o = buff_size = new Fl_Choice(245, 34, 105, 20, "* Internal Buffer Size");
          buff_size->tooltip("Number of samples. Smaller has more accurate internal timings but this may ch"
"ange some sounds.");
          buff_size->down_box(FL_BORDER_BOX);
          buff_size->labelsize(12);
          buff_size->labelcolor((Fl_Color)64);
          buff_size->textfont(1);
          buff_size->textsize(12);
          buff_size->textcolor((Fl_Color)64);
          buff_size->callback((Fl_Callback*)cb_buff_size);
          o->add("16");o->add("32");o->add("64");o->add("128");o->add("256");o->add("512");o->add("1024");o->add("2048");o->add("4096");o->add("8192");
          o->value(func::bitFindHigh(synth->getRuntime().buffersize) - 4);
          //if (isLV2()) o->deactivate();
        } // Fl_Choice* buff_size
        { Fl_Choice* o = osc_size = new Fl_Choice(245, 58, 105, 20, "* AddSynth Oscillator Size");
          osc_size->tooltip("ADSynth Oscillator Size (samples)");
          osc_size->down_box(FL_BORDER_BOX);
          osc_size->labelsize(12);
          osc_size->labelcolor((Fl_Color)64);
          osc_size->textfont(1);
          osc_size->textsize(12);
          osc_size->textcolor((Fl_Color)64);
          osc_size->callback((Fl_Callback*)cb_osc_size);
          o->add("256");o->add("512");o->add("1024");o->add("2048");o->add("4096");o->add("8192");o->add("16384");
          o->value(func::bitFindHigh(synth->getRuntime().oscilsize) - 8);
        } // Fl_Choice* osc_size
        { Fl_Choice* o = pad_interpol = new Fl_Choice(245, 82, 105, 20, "PadSynth Interpolation");
          pad_interpol->down_box(FL_BORDER_BOX);
          pad_interpol->labelsize(12);
          pad_interpol->labelcolor((Fl_Color)64);
          pad_interpol->textfont(1);
          pad_interpol->textsize(12);
          pad_interpol->textcolor((Fl_Color)64);
          pad_interpol->callback((Fl_Callback*)cb_pad_interpol);
          o->add("Linear(fast)");o->add("Cubic(slow)");
          o->value(synth->getRuntime().Interpolation);
        } // Fl_Choice* pad_interpol
        { Fl_Choice* o = handlePadSynthBuild = new Fl_Choice(245, 106, 105, 20, "PadSynth Wavetable Build Mode");
          handlePadSynthBuild->tooltip("How to rebuild wavetable after changes: Trigger manually and mute part (legac"
"y), build in background and activate when ready, or automatically trigger back"
"ground build on each parameter change (expensive)");
          handlePadSynthBuild->down_box(FL_BORDER_BOX);
          handlePadSynthBuild->labelsize(12);
          handlePadSynthBuild->labelcolor((Fl_Color)64);
          handlePadSynthBuild->textfont(1);
          handlePadSynthBuild->textsize(12);
          handlePadSynthBuild->textcolor((Fl_Color)64);
          handlePadSynthBuild->callback((Fl_Callback*)cb_handlePadSynthBuild);
          o->add("Muted");o->add("Background");o->add("Auto-Apply");
          o->value(synth->getRuntime().handlePadSynthBuild);
        } // Fl_Choice* handlePadSynthBuild
        { Fl_Choice* o = v_keyboard = new Fl_Choice(245, 130, 105, 20, "Virtual Keyboard Layout");
          v_keyboard->down_box(FL_BORDER_BOX);
          v_keyboard->labelsize(12);
          v_keyboard->labelcolor((Fl_Color)64);
          v_keyboard->textfont(1);
          v_keyboard->textsize(12);
          v_keyboard->textcolor((Fl_Color)64);
          v_keyboard->callback((Fl_Callback*)cb_v_keyboard);
          o->add("QWERTY");o->add("Dvorak");o->add("QWERTZ");o->add("AZERTY");
          o->value(synth->getRuntime().virKeybLayout);
        } // Fl_Choice* v_keyboard
        { Fl_Choice* o = reports = new Fl_Choice(200, 178, 150, 20, "Send reports to:");
          reports->tooltip("Some system errors always go to stdout");
          reports->down_box(FL_BORDER_BOX);
          reports->labelsize(12);
          reports->labelcolor((Fl_Color)64);
          reports->textfont(1);
          reports->textsize(12);
          reports->textcolor((Fl_Color)64);
          reports->callback((Fl_Callback*)cb_reports);
          o->add("stdout");o->add("Console Window");
          o->value(synth->getRuntime().toConsole);
        } // Fl_Choice* reports
        { Fl_Counter* o = logText = new Fl_Counter(260, 202, 90, 20, "Console text Size");
          logText->tooltip("Console Font Size");
          logText->type(1);
          logText->labelsize(12);
          logText->labelcolor((Fl_Color)64);
          logText->minimum(11);
          logText->maximum(100);
          logText->step(1);
          logText->value(12);
          logText->textfont(1);
          logText->textsize(12);
          logText->textcolor((Fl_Color)64);
          logText->callback((Fl_Callback*)cb_logText);
          logText->align(Fl_Align(FL_ALIGN_LEFT));
          o->value(synth->getRuntime().consoleTextSize);
          if (synth->getRuntime().toConsole) o->activate(); else o->deactivate();
        } // Fl_Counter* logText
        { Fl_Counter* o = compression = new Fl_Counter(260, 154, 90, 20, "XML Compression Level");
          compression->tooltip("gzip compression level (0 - uncompressed)");
          compression->type(1);
          compression->labelsize(12);
          compression->labelcolor((Fl_Color)64);
          compression->minimum(0);
          compression->maximum(9);
          compression->step(1);
          compression->textfont(1);
          compression->textsize(12);
          compression->textcolor((Fl_Color)64);
          compression->callback((Fl_Callback*)cb_compression);
          compression->align(Fl_Align(FL_ALIGN_LEFT));
          o->value(synth->getRuntime().gzipCompression);
          if (current_ID != 0) o->hide();
        } // Fl_Counter* compression
        { Fl_Choice* o = instrument = new Fl_Choice(200, 226, 150, 20, "Saved Instrument Format");
          instrument->tooltip("Yoshimi format includes Controllers and Humanise");
          instrument->down_box(FL_BORDER_BOX);
          instrument->labelsize(12);
          instrument->labelcolor((Fl_Color)64);
          instrument->textfont(1);
          instrument->textsize(12);
          instrument->textcolor((Fl_Color)64);
          instrument->callback((Fl_Callback*)cb_instrument);
          o->add("Legacy");o->add("Yoshimi");o->add("Both");
          o->value(synth->getRuntime().instrumentFormat - 1);
        } // Fl_Choice* instrument
        { Fl_Choice* o = PanelLayout = new Fl_Choice(200, 250, 150, 20, "Mixer Panel Layout");
          PanelLayout->tooltip("Select single row or compact format");
          PanelLayout->down_box(FL_BORDER_BOX);
          PanelLayout->labelsize(12);
          PanelLayout->labelcolor((Fl_Color)64);
          PanelLayout->textfont(1);
          PanelLayout->textsize(12);
          PanelLayout->textcolor((Fl_Color)64);
          PanelLayout->callback((Fl_Callback*)cb_PanelLayout);
          o->add("2 row x 8 entries");o->add("1 row x 16 entries");
        } // Fl_Choice* PanelLayout
        { Fl_Box* o = settingsNote = new Fl_Box(38, 276, 306, 17, "* Changing these settings requires a restart");
          settingsNote->labelfont(1);
          settingsNote->labelsize(12);
          settingsNote->labelcolor((Fl_Color)64);
          settingsNote->align(Fl_Align(FL_ALIGN_WRAP));
          if (current_ID != 0) o->hide();
        } // Fl_Box* settingsNote
        mainTab->end();
      } // Fl_Group* mainTab
      { switchesTab = new Fl_Group(5, 25, 382, 277);
        switchesTab->box(FL_THIN_UP_BOX);
        switchesTab->labelsize(12);
        switchesTab->labelcolor((Fl_Color)64);
        { Fl_Check_Button2* o = bankHighlight = new Fl_Check_Button2(190, 40, 27, 25, "Enable Bank Highlight");
          bankHighlight->tooltip("Show the last patch fetched from or saved to a bank");
          bankHighlight->box(FL_NO_BOX);
          bankHighlight->down_box(FL_DOWN_BOX);
          bankHighlight->color(FL_BACKGROUND_COLOR);
          bankHighlight->selection_color((Fl_Color)64);
          bankHighlight->labeltype(FL_NORMAL_LABEL);
          bankHighlight->labelfont(0);
          bankHighlight->labelsize(12);
          bankHighlight->labelcolor((Fl_Color)64);
          bankHighlight->callback((Fl_Callback*)cb_bankHighlight);
          bankHighlight->align(Fl_Align(FL_ALIGN_LEFT));
          bankHighlight->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().bankHighlight);
        } // Fl_Check_Button2* bankHighlight
        { Fl_Check_Button2* o = partReports = new Fl_Check_Button2(220, 40, 27, 25, "Enable Part  Reports");
          partReports->tooltip("Warn if any instrument could be accidentally changed");
          partReports->box(FL_NO_BOX);
          partReports->down_box(FL_DOWN_BOX);
          partReports->color(FL_BACKGROUND_COLOR);
          partReports->selection_color((Fl_Color)64);
          partReports->labeltype(FL_NORMAL_LABEL);
          partReports->labelfont(0);
          partReports->labelsize(12);
          partReports->labelcolor((Fl_Color)64);
          partReports->callback((Fl_Callback*)cb_partReports);
          partReports->align(Fl_Align(FL_ALIGN_RIGHT));
          partReports->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().enablePartReports);
        } // Fl_Check_Button2* partReports
        { Fl_Check_Button2* o = nonFatal = new Fl_Check_Button2(190, 60, 27, 25, "Hide Non-essential Reports");
          nonFatal->box(FL_NO_BOX);
          nonFatal->down_box(FL_DOWN_BOX);
          nonFatal->color(FL_BACKGROUND_COLOR);
          nonFatal->selection_color((Fl_Color)64);
          nonFatal->labeltype(FL_NORMAL_LABEL);
          nonFatal->labelfont(0);
          nonFatal->labelsize(12);
          nonFatal->labelcolor((Fl_Color)64);
          nonFatal->callback((Fl_Callback*)cb_nonFatal);
          nonFatal->align(Fl_Align(FL_ALIGN_LEFT));
          nonFatal->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().hideErrors);
          if (isLV2()) o->deactivate();
        } // Fl_Check_Button2* nonFatal
        { Fl_Check_Button2* o = showSplash = new Fl_Check_Button2(190, 80, 27, 25, "Show Splash Screen");
          showSplash->box(FL_NO_BOX);
          showSplash->down_box(FL_DOWN_BOX);
          showSplash->color(FL_BACKGROUND_COLOR);
          showSplash->selection_color((Fl_Color)64);
          showSplash->labeltype(FL_NORMAL_LABEL);
          showSplash->labelfont(0);
          showSplash->labelsize(12);
          showSplash->labelcolor((Fl_Color)64);
          showSplash->callback((Fl_Callback*)cb_showSplash);
          showSplash->align(Fl_Align(FL_ALIGN_LEFT));
          showSplash->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().showSplash);
          if (current_ID != 0) o->hide(); else if (isLV2()) o->deactivate();
        } // Fl_Check_Button2* showSplash
        { Fl_Check_Button2* o = logXML = new Fl_Check_Button2(190, 100, 27, 25, "Log XML Headers");
          logXML->box(FL_NO_BOX);
          logXML->down_box(FL_DOWN_BOX);
          logXML->color(FL_BACKGROUND_COLOR);
          logXML->selection_color((Fl_Color)64);
          logXML->labeltype(FL_NORMAL_LABEL);
          logXML->labelfont(0);
          logXML->labelsize(12);
          logXML->labelcolor((Fl_Color)64);
          logXML->callback((Fl_Callback*)cb_logXML);
          logXML->align(Fl_Align(FL_ALIGN_LEFT));
          logXML->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().logXMLheaders);
          if (isLV2()) o->deactivate();
        } // Fl_Check_Button2* logXML
        { Fl_Check_Button2* o = logTimes = new Fl_Check_Button2(190, 120, 27, 25, "Log Load times");
          logTimes->box(FL_NO_BOX);
          logTimes->down_box(FL_DOWN_BOX);
          logTimes->color(FL_BACKGROUND_COLOR);
          logTimes->selection_color((Fl_Color)64);
          logTimes->labeltype(FL_NORMAL_LABEL);
          logTimes->labelfont(0);
          logTimes->labelsize(12);
          logTimes->labelcolor((Fl_Color)64);
          logTimes->callback((Fl_Callback*)cb_logTimes);
          logTimes->align(Fl_Align(FL_ALIGN_LEFT));
          logTimes->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().showTimes);
        } // Fl_Check_Button2* logTimes
        { Fl_Check_Button2* o = saveAllXML = new Fl_Check_Button2(190, 140, 27, 25, "Retain all Data");
          saveAllXML->tooltip("Include all data in XML files, even inactive settings");
          saveAllXML->box(FL_NO_BOX);
          saveAllXML->down_box(FL_DOWN_BOX);
          saveAllXML->color(FL_BACKGROUND_COLOR);
          saveAllXML->selection_color((Fl_Color)64);
          saveAllXML->labeltype(FL_NORMAL_LABEL);
          saveAllXML->labelfont(0);
          saveAllXML->labelsize(12);
          saveAllXML->labelcolor((Fl_Color)64);
          saveAllXML->callback((Fl_Callback*)cb_saveAllXML);
          saveAllXML->align(Fl_Align(FL_ALIGN_LEFT));
          saveAllXML->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().xmlmax);
        } // Fl_Check_Button2* saveAllXML
        { Fl_Check_Button2* o = enableGUI = new Fl_Check_Button2(190, 160, 27, 25, "* Enable GUI");
          enableGUI->tooltip("Enable starting with this graphical interface");
          enableGUI->box(FL_NO_BOX);
          enableGUI->down_box(FL_DOWN_BOX);
          enableGUI->color(FL_BACKGROUND_COLOR);
          enableGUI->selection_color((Fl_Color)64);
          enableGUI->labeltype(FL_NORMAL_LABEL);
          enableGUI->labelfont(0);
          enableGUI->labelsize(12);
          enableGUI->labelcolor((Fl_Color)64);
          enableGUI->callback((Fl_Callback*)cb_enableGUI);
          enableGUI->align(Fl_Align(FL_ALIGN_LEFT));
          enableGUI->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().storedGui);
          if (current_ID != 0) o->hide(); else if (isLV2()) o->deactivate();
        } // Fl_Check_Button2* enableGUI
        { Fl_Check_Button2* o = enableCLI = new Fl_Check_Button2(190, 180, 27, 25, "* Enable CLI");
          enableCLI->tooltip("Enable starting with interactive command line interface");
          enableCLI->box(FL_NO_BOX);
          enableCLI->down_box(FL_DOWN_BOX);
          enableCLI->color(FL_BACKGROUND_COLOR);
          enableCLI->selection_color((Fl_Color)64);
          enableCLI->labeltype(FL_NORMAL_LABEL);
          enableCLI->labelfont(0);
          enableCLI->labelsize(12);
          enableCLI->labelcolor((Fl_Color)64);
          enableCLI->callback((Fl_Callback*)cb_enableCLI);
          enableCLI->align(Fl_Align(FL_ALIGN_LEFT));
          enableCLI->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().storedCli);
          if (current_ID != 0) o->hide(); else if (isLV2()) o->deactivate();
        } // Fl_Check_Button2* enableCLI
        { Fl_Check_Button2* o = enableAuto = new Fl_Check_Button2(190, 200, 27, 25, "Enable Auto Instance");
          enableAuto->tooltip("Allow main instance to start all those open when last closed.");
          enableAuto->box(FL_NO_BOX);
          enableAuto->down_box(FL_DOWN_BOX);
          enableAuto->color(FL_BACKGROUND_COLOR);
          enableAuto->selection_color((Fl_Color)64);
          enableAuto->labeltype(FL_NORMAL_LABEL);
          enableAuto->labelfont(0);
          enableAuto->labelsize(12);
          enableAuto->labelcolor((Fl_Color)64);
          enableAuto->callback((Fl_Callback*)cb_enableAuto);
          enableAuto->align(Fl_Align(FL_ALIGN_LEFT));
          enableAuto->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().autoInstance);
          if (current_ID != 0) o->hide(); else if (isLV2()) o->deactivate();
        } // Fl_Check_Button2* enableAuto
        { Fl_Check_Button2* o = singleMaster = new Fl_Check_Button2(190, 220, 27, 25, "* Enable Single Master");
          singleMaster->tooltip("Redirect new start from desktop to create new instance instead.");
          singleMaster->box(FL_NO_BOX);
          singleMaster->down_box(FL_DOWN_BOX);
          singleMaster->color(FL_BACKGROUND_COLOR);
          singleMaster->selection_color((Fl_Color)64);
          singleMaster->labeltype(FL_NORMAL_LABEL);
          singleMaster->labelfont(0);
          singleMaster->labelsize(12);
          singleMaster->labelcolor((Fl_Color)64);
          singleMaster->callback((Fl_Callback*)cb_singleMaster);
          singleMaster->align(Fl_Align(FL_ALIGN_LEFT));
          singleMaster->when(FL_WHEN_RELEASE);
          o->value(fetchData(0, CONFIG::control::enableSinglePath, TOPLEVEL::section::config));
          if (current_ID != 0) o->hide(); else if (isLV2()) o->deactivate();
        } // Fl_Check_Button2* singleMaster
        { Fl_Check_Button2* o = setDefaultState = new Fl_Check_Button2(190, 250, 27, 25, "* Start With Default State");
          setDefaultState->tooltip("If you change this you must re-save the default state\nor when that loads it "
"will revert to the previous value");
          setDefaultState->box(FL_NO_BOX);
          setDefaultState->down_box(FL_DOWN_BOX);
          setDefaultState->color(FL_BACKGROUND_COLOR);
          setDefaultState->selection_color((Fl_Color)64);
          setDefaultState->labeltype(FL_NORMAL_LABEL);
          setDefaultState->labelfont(0);
          setDefaultState->labelsize(12);
          setDefaultState->labelcolor((Fl_Color)64);
          setDefaultState->callback((Fl_Callback*)cb_setDefaultState);
          setDefaultState->align(Fl_Align(FL_ALIGN_LEFT));
          setDefaultState->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().loadDefaultState);
          if (isLV2()) o->deactivate();
        } // Fl_Check_Button2* setDefaultState
        { Fl_Group* o = new Fl_Group(230, 70, 130, 180);
          o->tooltip("When locked new entries will not not be added or change the list order");
          o->box(FL_EMBOSSED_FRAME);
          { historyLocks = new Fl_Text_Display(278, 110, 50, 1, "History Locks");
            historyLocks->box(FL_NO_BOX);
            historyLocks->labelsize(12);
            historyLocks->labelcolor((Fl_Color)64);
            historyLocks->textsize(12);
            historyLocks->textcolor((Fl_Color)64);
            historyLocks->align(Fl_Align(129));
          } // Fl_Text_Display* historyLocks
          { Fl_Check_Button2* o = H_instrument = new Fl_Check_Button2(240, 120, 27, 25, "Instrument");
            H_instrument->box(FL_NO_BOX);
            H_instrument->down_box(FL_DOWN_BOX);
            H_instrument->color(FL_BACKGROUND_COLOR);
            H_instrument->selection_color((Fl_Color)64);
            H_instrument->labeltype(FL_NORMAL_LABEL);
            H_instrument->labelfont(0);
            H_instrument->labelsize(12);
            H_instrument->labelcolor((Fl_Color)64);
            H_instrument->callback((Fl_Callback*)cb_H_instrument);
            H_instrument->align(Fl_Align(FL_ALIGN_RIGHT));
            H_instrument->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::Instrument, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_instrument
          { Fl_Check_Button2* o = H_patchset = new Fl_Check_Button2(240, 140, 27, 25, "Patch Set");
            H_patchset->box(FL_NO_BOX);
            H_patchset->down_box(FL_DOWN_BOX);
            H_patchset->color(FL_BACKGROUND_COLOR);
            H_patchset->selection_color((Fl_Color)64);
            H_patchset->labeltype(FL_NORMAL_LABEL);
            H_patchset->labelfont(0);
            H_patchset->labelsize(12);
            H_patchset->labelcolor((Fl_Color)64);
            H_patchset->callback((Fl_Callback*)cb_H_patchset);
            H_patchset->align(Fl_Align(FL_ALIGN_RIGHT));
            H_patchset->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::Patch, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_patchset
          { Fl_Check_Button2* o = H_scale = new Fl_Check_Button2(240, 160, 27, 25, "Scale");
            H_scale->box(FL_NO_BOX);
            H_scale->down_box(FL_DOWN_BOX);
            H_scale->color(FL_BACKGROUND_COLOR);
            H_scale->selection_color((Fl_Color)64);
            H_scale->labeltype(FL_NORMAL_LABEL);
            H_scale->labelfont(0);
            H_scale->labelsize(12);
            H_scale->labelcolor((Fl_Color)64);
            H_scale->callback((Fl_Callback*)cb_H_scale);
            H_scale->align(Fl_Align(FL_ALIGN_RIGHT));
            H_scale->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::Scale, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_scale
          { Fl_Check_Button2* o = H_state = new Fl_Check_Button2(240, 180, 27, 25, "State");
            H_state->box(FL_NO_BOX);
            H_state->down_box(FL_DOWN_BOX);
            H_state->color(FL_BACKGROUND_COLOR);
            H_state->selection_color((Fl_Color)64);
            H_state->labeltype(FL_NORMAL_LABEL);
            H_state->labelfont(0);
            H_state->labelsize(12);
            H_state->labelcolor((Fl_Color)64);
            H_state->callback((Fl_Callback*)cb_H_state);
            H_state->align(Fl_Align(FL_ALIGN_RIGHT));
            H_state->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::State, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_state
          { Fl_Check_Button2* o = H_vector = new Fl_Check_Button2(240, 200, 27, 25, "Vector");
            H_vector->box(FL_NO_BOX);
            H_vector->down_box(FL_DOWN_BOX);
            H_vector->color(FL_BACKGROUND_COLOR);
            H_vector->selection_color((Fl_Color)64);
            H_vector->labeltype(FL_NORMAL_LABEL);
            H_vector->labelfont(0);
            H_vector->labelsize(12);
            H_vector->labelcolor((Fl_Color)64);
            H_vector->callback((Fl_Callback*)cb_H_vector);
            H_vector->align(Fl_Align(FL_ALIGN_RIGHT));
            H_vector->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::Vector, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_vector
          { Fl_Check_Button2* o = H_mlearn = new Fl_Check_Button2(240, 220, 27, 25, "Midi Learn");
            H_mlearn->box(FL_NO_BOX);
            H_mlearn->down_box(FL_DOWN_BOX);
            H_mlearn->color(FL_BACKGROUND_COLOR);
            H_mlearn->selection_color((Fl_Color)64);
            H_mlearn->labeltype(FL_NORMAL_LABEL);
            H_mlearn->labelfont(0);
            H_mlearn->labelsize(12);
            H_mlearn->labelcolor((Fl_Color)64);
            H_mlearn->callback((Fl_Callback*)cb_H_mlearn);
            H_mlearn->align(Fl_Align(FL_ALIGN_RIGHT));
            H_mlearn->when(FL_WHEN_RELEASE);
            o->value(_SYS_::F2B(fetchData(0, CONFIG::control::historyLock, TOPLEVEL::section::config, TOPLEVEL::XML::MLearn, UNUSED, UNUSED, UNUSED, UNUSED, UNUSED, TOPLEVEL::action::lowPrio)));
          } // Fl_Check_Button2* H_mlearn
          o->end();
        } // Fl_Group* o
        { switchesNote = new Fl_Box(38, 276, 306, 17, "* Changing these settings requires a restart");
          switchesNote->labelfont(1);
          switchesNote->labelsize(12);
          switchesNote->labelcolor((Fl_Color)64);
          switchesNote->align(Fl_Align(FL_ALIGN_WRAP));
        } // Fl_Box* switchesNote
        switchesTab->end();
      } // Fl_Group* switchesTab
      { jackTab = new Fl_Group(5, 25, 382, 277);
        jackTab->box(FL_THIN_UP_BOX);
        jackTab->labelsize(12);
        jackTab->labelcolor((Fl_Color)64);
        jackTab->hide();
        { Fl_Input* o = jackSource = new Fl_Input(195, 62, 120, 22, "Jack MIDI Source");
          jackSource->tooltip("Device Jack tries to connect to for input.");
          jackSource->labelsize(12);
          jackSource->labelcolor((Fl_Color)64);
          jackSource->textfont(1);
          jackSource->textsize(12);
          jackSource->textcolor((Fl_Color)64);
          jackSource->callback((Fl_Callback*)cb_jackSource);
          o->value(synth->getRuntime().jackMidiDevice.c_str());
        } // Fl_Input* jackSource
        { Fl_Check_Button2* o = jackMidi = new Fl_Check_Button2(195, 88, 37, 26, "Set as preferred MIDI");
          jackMidi->box(FL_NO_BOX);
          jackMidi->down_box(FL_DOWN_BOX);
          jackMidi->color(FL_BACKGROUND_COLOR);
          jackMidi->selection_color((Fl_Color)64);
          jackMidi->labeltype(FL_NORMAL_LABEL);
          jackMidi->labelfont(0);
          jackMidi->labelsize(12);
          jackMidi->labelcolor((Fl_Color)64);
          jackMidi->callback((Fl_Callback*)cb_jackMidi);
          jackMidi->align(Fl_Align(FL_ALIGN_LEFT));
          jackMidi->when(FL_WHEN_RELEASE);
          if (synth->getRuntime().midiEngine == jack_midi) o->value(1);
        } // Fl_Check_Button2* jackMidi
        { Fl_Input* o = jackServer = new Fl_Input(195, 182, 120, 22, "Jack Server");
          jackServer->tooltip("Name of the jack server to connect to - default, ...");
          jackServer->labelsize(12);
          jackServer->labelcolor((Fl_Color)64);
          jackServer->textfont(1);
          jackServer->textsize(12);
          jackServer->textcolor((Fl_Color)64);
          jackServer->callback((Fl_Callback*)cb_jackServer);
          o->value(synth->getRuntime().jackServer.c_str());
        } // Fl_Input* jackServer
        { Fl_Check_Button2* o = jackAudio = new Fl_Check_Button2(195, 209, 37, 26, "Set as preferred audio");
          jackAudio->box(FL_NO_BOX);
          jackAudio->down_box(FL_DOWN_BOX);
          jackAudio->color(FL_BACKGROUND_COLOR);
          jackAudio->selection_color((Fl_Color)64);
          jackAudio->labeltype(FL_NORMAL_LABEL);
          jackAudio->labelfont(0);
          jackAudio->labelsize(12);
          jackAudio->labelcolor((Fl_Color)64);
          jackAudio->callback((Fl_Callback*)cb_jackAudio);
          jackAudio->align(Fl_Align(FL_ALIGN_LEFT));
          jackAudio->when(FL_WHEN_RELEASE);
          if (synth->getRuntime().audioEngine == jack_audio) o->value(1);
        } // Fl_Check_Button2* jackAudio
        { Fl_Check_Button2* o = connectJackAudio = new Fl_Check_Button2(195, 233, 37, 26, "Autoconnect audio");
          connectJackAudio->box(FL_NO_BOX);
          connectJackAudio->down_box(FL_DOWN_BOX);
          connectJackAudio->color(FL_BACKGROUND_COLOR);
          connectJackAudio->selection_color((Fl_Color)64);
          connectJackAudio->labeltype(FL_NORMAL_LABEL);
          connectJackAudio->labelfont(0);
          connectJackAudio->labelsize(12);
          connectJackAudio->labelcolor((Fl_Color)64);
          connectJackAudio->callback((Fl_Callback*)cb_connectJackAudio);
          connectJackAudio->align(Fl_Align(FL_ALIGN_LEFT));
          connectJackAudio->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().connectJackaudio);
        } // Fl_Check_Button2* connectJackAudio
        { jackNote = new Fl_Box(60, 276, 267, 17, "Changing settings requires a restart");
          jackNote->labelfont(1);
          jackNote->labelsize(12);
          jackNote->labelcolor((Fl_Color)64);
          jackNote->align(Fl_Align(FL_ALIGN_WRAP));
        } // Fl_Box* jackNote
        jackTab->end();
      } // Fl_Group* jackTab
      { alsaTab = new Fl_Group(5, 25, 382, 277);
        alsaTab->box(FL_THIN_UP_BOX);
        alsaTab->labelsize(12);
        alsaTab->labelcolor((Fl_Color)64);
        alsaTab->hide();
        { Fl_Choice* o = alsaType = new Fl_Choice(195, 45, 120, 22, "Alsa Connection Type");
          alsaType->box(FL_DOWN_BOX);
          alsaType->down_box(FL_BORDER_BOX);
          alsaType->labelsize(12);
          alsaType->labelcolor((Fl_Color)64);
          alsaType->textfont(1);
          alsaType->textsize(12);
          alsaType->textcolor((Fl_Color)64);
          alsaType->callback((Fl_Callback*)cb_alsaType);
          o->add("Fixed");o->add("Search");o->add("External");
        } // Fl_Choice* alsaType
        { Fl_Input* o = alsaSource = new Fl_Input(195, 80, 120, 22, "Alsa MIDI Source");
          alsaSource->tooltip("Device Alsa tries to connect to for input.");
          alsaSource->labelsize(12);
          alsaSource->labelcolor((Fl_Color)64);
          alsaSource->textfont(1);
          alsaSource->textsize(12);
          alsaSource->textcolor((Fl_Color)64);
          alsaSource->callback((Fl_Callback*)cb_alsaSource);
          o->value(synth->getRuntime().alsaMidiDevice.c_str());
        } // Fl_Input* alsaSource
        { Fl_Check_Button2* o = alsaMidi = new Fl_Check_Button2(195, 110, 37, 26, "Set as preferred MIDI");
          alsaMidi->box(FL_NO_BOX);
          alsaMidi->down_box(FL_DOWN_BOX);
          alsaMidi->color(FL_BACKGROUND_COLOR);
          alsaMidi->selection_color((Fl_Color)64);
          alsaMidi->labeltype(FL_NORMAL_LABEL);
          alsaMidi->labelfont(0);
          alsaMidi->labelsize(12);
          alsaMidi->labelcolor((Fl_Color)64);
          alsaMidi->callback((Fl_Callback*)cb_alsaMidi);
          alsaMidi->align(Fl_Align(FL_ALIGN_LEFT));
          alsaMidi->when(FL_WHEN_RELEASE);
          if (synth->getRuntime().midiEngine == alsa_midi) o->value(1);
        } // Fl_Check_Button2* alsaMidi
        { Fl_Input* o = alsaDevice = new Fl_Input(195, 143, 120, 22, "Alsa Audio Device");
          alsaDevice->tooltip("Alsa audio device - default, hw:0, ...");
          alsaDevice->labelsize(12);
          alsaDevice->labelcolor((Fl_Color)64);
          alsaDevice->textfont(1);
          alsaDevice->textsize(12);
          alsaDevice->textcolor((Fl_Color)64);
          alsaDevice->callback((Fl_Callback*)cb_alsaDevice);
          o->value(synth->getRuntime().alsaAudioDevice.c_str());
        } // Fl_Input* alsaDevice
        { Fl_Choice* o = alsaSamplerate = new Fl_Choice(195, 199, 80, 22, "Sample Rate");
          alsaSamplerate->down_box(FL_BORDER_BOX);
          alsaSamplerate->labelsize(12);
          alsaSamplerate->labelcolor((Fl_Color)64);
          alsaSamplerate->textfont(1);
          alsaSamplerate->textsize(12);
          alsaSamplerate->textcolor((Fl_Color)64);
          alsaSamplerate->callback((Fl_Callback*)cb_alsaSamplerate);
          o->add("192000");o->add("96000");o->add("48000");o->add("44100");
          o->value(convertSrate(synth->getRuntime().samplerate));
        } // Fl_Choice* alsaSamplerate
        { Fl_Check_Button2* o = alsaAudio = new Fl_Check_Button2(195, 169, 37, 26, "Set as preferred audio");
          alsaAudio->box(FL_NO_BOX);
          alsaAudio->down_box(FL_DOWN_BOX);
          alsaAudio->color(FL_BACKGROUND_COLOR);
          alsaAudio->selection_color((Fl_Color)64);
          alsaAudio->labeltype(FL_NORMAL_LABEL);
          alsaAudio->labelfont(0);
          alsaAudio->labelsize(12);
          alsaAudio->labelcolor((Fl_Color)64);
          alsaAudio->callback((Fl_Callback*)cb_alsaAudio);
          alsaAudio->align(Fl_Align(FL_ALIGN_LEFT));
          alsaAudio->when(FL_WHEN_RELEASE);
          if (synth->getRuntime().audioEngine == alsa_audio) o->value(1);
        } // Fl_Check_Button2* alsaAudio
        { alsaNote = new Fl_Box(60, 276, 267, 17, "Changing settings requires a restart");
          alsaNote->labelfont(1);
          alsaNote->labelsize(12);
          alsaNote->labelcolor((Fl_Color)64);
          alsaNote->align(Fl_Align(FL_ALIGN_WRAP));
        } // Fl_Box* alsaNote
        alsaTab->end();
      } // Fl_Group* alsaTab
      { midiTab = new Fl_Group(5, 25, 382, 277);
        midiTab->tooltip("MIDI CC preferences");
        midiTab->box(FL_THIN_UP_BOX);
        midiTab->labelsize(12);
        midiTab->callback((Fl_Callback*)cb_midiTab);
        midiTab->hide();
        { Fl_Choice* o = bankrootchange = new Fl_Choice(234, 57, 53, 18, "Bank Root Change");
          bankrootchange->tooltip("CC0 = msb, CC32 = lsb");
          bankrootchange->down_box(FL_BORDER_BOX);
          bankrootchange->labelsize(12);
          bankrootchange->labelcolor((Fl_Color)64);
          bankrootchange->textfont(1);
          bankrootchange->textsize(12);
          bankrootchange->textcolor((Fl_Color)64);
          bankrootchange->callback((Fl_Callback*)cb_bankrootchange);
          bankrootchange->align(Fl_Align(132));
          o->add("LSB");o->add("MSB");o->add("Off");
          int bankRoot = synth->getRuntime().midi_bank_root;
          if (bankRoot == 32) o->value(0); else if (bankRoot == 0) o->value(1); else o->value(2);
          oldBank = o->value();
        } // Fl_Choice* bankrootchange
        { Fl_Choice* o = bankchange = new Fl_Choice(235, 80, 53, 18, "Bank Change");
          bankchange->tooltip("CC0 = msb, CC32 = lsb");
          bankchange->down_box(FL_BORDER_BOX);
          bankchange->labelsize(12);
          bankchange->labelcolor((Fl_Color)64);
          bankchange->textfont(1);
          bankchange->textsize(12);
          bankchange->textcolor((Fl_Color)64);
          bankchange->callback((Fl_Callback*)cb_bankchange);
          bankchange->align(Fl_Align(132));
          o->add("LSB");o->add("MSB");o->add("Off");
          if (synth->getRuntime().midi_bank_C == 32) o->value(0); else if (synth->getRuntime().midi_bank_C == 0) o->value(1); else o->value(2);
          oldBank = o->value();
        } // Fl_Choice* bankchange
        { Fl_Check_Button2* o = progenable = new Fl_Check_Button2(234, 110, 18, 18, "Enable Program Change");
          progenable->tooltip("MIDI program change enable/disable.");
          progenable->box(FL_NO_BOX);
          progenable->down_box(FL_DOWN_BOX);
          progenable->value(1);
          progenable->color(FL_BACKGROUND_COLOR);
          progenable->selection_color((Fl_Color)64);
          progenable->labeltype(FL_NORMAL_LABEL);
          progenable->labelfont(0);
          progenable->labelsize(12);
          progenable->labelcolor((Fl_Color)64);
          progenable->callback((Fl_Callback*)cb_progenable);
          progenable->align(Fl_Align(FL_ALIGN_LEFT));
          progenable->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().enableProgChange);
        } // Fl_Check_Button2* progenable
        { WidgetSpinner* o = EPCspinner = new WidgetSpinner(235, 150, 50, 18, "Extended Program Change CC");
          EPCspinner->box(FL_NO_BOX);
          EPCspinner->color(FL_BACKGROUND_COLOR);
          EPCspinner->selection_color(FL_BACKGROUND_COLOR);
          EPCspinner->labeltype(FL_NORMAL_LABEL);
          EPCspinner->labelfont(0);
          EPCspinner->labelsize(12);
          EPCspinner->labelcolor((Fl_Color)64);
          EPCspinner->minimum(0);
          EPCspinner->maximum(119);
          EPCspinner->value(110);
          EPCspinner->textfont(1);
          EPCspinner->textsize(12);
          EPCspinner->textcolor((Fl_Color)64);
          EPCspinner->callback((Fl_Callback*)cb_EPCspinner);
          EPCspinner->align(Fl_Align(FL_ALIGN_LEFT));
          EPCspinner->when(FL_WHEN_RELEASE);
          EPCvalue = synth->getRuntime().midi_upper_voice_C;
          if (EPCvalue < 128) o->value(EPCvalue); else o->value(110);
        } // WidgetSpinner* EPCspinner
        { Epend = new Fl_Button(300, 150, 70, 20, "Pending");
          Epend->tooltip("Click to set");
          Epend->box(FL_PLASTIC_UP_BOX);
          Epend->color((Fl_Color)90);
          Epend->labelsize(12);
          Epend->labelcolor((Fl_Color)64);
          Epend->callback((Fl_Callback*)cb_Epend);
          Epend->hide();
        } // Fl_Button* Epend
        { Fl_Check_Button2* o = Epcheck = new Fl_Check_Button2(234, 130, 18, 18, "Enable Extended Program Change");
          Epcheck->box(FL_NO_BOX);
          Epcheck->down_box(FL_DOWN_BOX);
          Epcheck->color(FL_BACKGROUND_COLOR);
          Epcheck->selection_color((Fl_Color)64);
          Epcheck->labeltype(FL_NORMAL_LABEL);
          Epcheck->labelfont(0);
          Epcheck->labelsize(12);
          Epcheck->labelcolor((Fl_Color)64);
          Epcheck->callback((Fl_Callback*)cb_Epcheck);
          Epcheck->align(Fl_Align(FL_ALIGN_LEFT));
          Epcheck->when(FL_WHEN_RELEASE);
          o->value((synth->getRuntime().midi_upper_voice_C < 128));
          if (o->value() == 0) EPCspinner->deactivate();
        } // Fl_Check_Button2* Epcheck
        { Fl_Check_Button2* o = enableOmniChange = new Fl_Check_Button2(234, 180, 18, 18, "Enable Omni Mode Change");
          enableOmniChange->tooltip("Enable receipt of Omni Mode change messages on CC 124 (Off) and CC 125 (On).");
          enableOmniChange->box(FL_NO_BOX);
          enableOmniChange->down_box(FL_DOWN_BOX);
          enableOmniChange->color(FL_BACKGROUND_COLOR);
          enableOmniChange->selection_color((Fl_Color)64);
          enableOmniChange->labeltype(FL_NORMAL_LABEL);
          enableOmniChange->labelfont(0);
          enableOmniChange->labelsize(12);
          enableOmniChange->labelcolor((Fl_Color)64);
          enableOmniChange->callback((Fl_Callback*)cb_enableOmniChange);
          enableOmniChange->align(Fl_Align(FL_ALIGN_LEFT));
          enableOmniChange->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().enableOmni);
        } // Fl_Check_Button2* enableOmniChange
        { Fl_Check_Button2* o = enableNRPN = new Fl_Check_Button2(234, 210, 18, 18, "Enable Incoming NRPNs");
          enableNRPN->box(FL_NO_BOX);
          enableNRPN->down_box(FL_DOWN_BOX);
          enableNRPN->color(FL_BACKGROUND_COLOR);
          enableNRPN->selection_color((Fl_Color)64);
          enableNRPN->labeltype(FL_NORMAL_LABEL);
          enableNRPN->labelfont(0);
          enableNRPN->labelsize(12);
          enableNRPN->labelcolor((Fl_Color)64);
          enableNRPN->callback((Fl_Callback*)cb_enableNRPN);
          enableNRPN->align(Fl_Align(FL_ALIGN_LEFT));
          enableNRPN->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().enable_NRPN);
        } // Fl_Check_Button2* enableNRPN
        { Fl_Check_Button2* o = ignoreReset = new Fl_Check_Button2(234, 230, 18, 18, "Ignore Reset all CCs");
          ignoreReset->box(FL_NO_BOX);
          ignoreReset->down_box(FL_DOWN_BOX);
          ignoreReset->color(FL_BACKGROUND_COLOR);
          ignoreReset->selection_color((Fl_Color)64);
          ignoreReset->labeltype(FL_NORMAL_LABEL);
          ignoreReset->labelfont(0);
          ignoreReset->labelsize(12);
          ignoreReset->labelcolor((Fl_Color)64);
          ignoreReset->callback((Fl_Callback*)cb_ignoreReset);
          ignoreReset->align(Fl_Align(FL_ALIGN_LEFT));
          ignoreReset->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().ignoreResetCCs);
        } // Fl_Check_Button2* ignoreReset
        { Fl_Check_Button2* o = midiMon = new Fl_Check_Button2(234, 250, 18, 18, "Log Incoming Events");
          midiMon->box(FL_NO_BOX);
          midiMon->down_box(FL_DOWN_BOX);
          midiMon->color(FL_BACKGROUND_COLOR);
          midiMon->selection_color((Fl_Color)64);
          midiMon->labeltype(FL_NORMAL_LABEL);
          midiMon->labelfont(0);
          midiMon->labelsize(12);
          midiMon->labelcolor((Fl_Color)64);
          midiMon->callback((Fl_Callback*)cb_midiMon);
          midiMon->align(Fl_Align(FL_ALIGN_LEFT));
          midiMon->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().monitorCCin);
        } // Fl_Check_Button2* midiMon
        { Fl_Check_Button2* o = midiLearned = new Fl_Check_Button2(234, 270, 18, 18, "Show Learn Editor");
          midiLearned->tooltip("Open the MIDI learn window for editing when a new CC has been learned");
          midiLearned->box(FL_NO_BOX);
          midiLearned->down_box(FL_DOWN_BOX);
          midiLearned->color(FL_BACKGROUND_COLOR);
          midiLearned->selection_color((Fl_Color)64);
          midiLearned->labeltype(FL_NORMAL_LABEL);
          midiLearned->labelfont(0);
          midiLearned->labelsize(12);
          midiLearned->labelcolor((Fl_Color)64);
          midiLearned->callback((Fl_Callback*)cb_midiLearned);
          midiLearned->align(Fl_Align(FL_ALIGN_LEFT));
          midiLearned->when(FL_WHEN_RELEASE);
          o->value(synth->getRuntime().showLearnedCC);
        } // Fl_Check_Button2* midiLearned
        EPCvalue = synth->getRuntime().midi_upper_voice_C;
        BankRootvalue = synth->getRuntime().midi_bank_root;
        midiTab->end();
      } // Fl_Group* midiTab
      { themeTab = new Fl_Group(5, 25, 382, 277);
        themeTab->box(FL_THIN_UP_BOX);
        themeTab->callback((Fl_Callback*)cb_themeTab);
        themeTab->hide();
        { theme_browser = new Fl_Browser(40, 50, 190, 215, "Themes");
          theme_browser->type(1);
          theme_browser->labelcolor((Fl_Color)64);
          theme_browser->textcolor((Fl_Color)64);
          theme_browser->callback((Fl_Callback*)cb_theme_browser);
          theme_browser->align(Fl_Align(FL_ALIGN_TOP));
        } // Fl_Browser* theme_browser
        { themeImport = new Fl_Button(255, 51, 100, 20, "Import Theme");
          themeImport->box(FL_GTK_THIN_UP_BOX);
          themeImport->color((Fl_Color)198);
          themeImport->labelsize(12);
          themeImport->labelcolor((Fl_Color)64);
          themeImport->callback((Fl_Callback*)cb_themeImport);
        } // Fl_Button* themeImport
        { themeExport = new Fl_Button(255, 89, 100, 20, "Export Theme");
          themeExport->box(FL_GTK_THIN_UP_BOX);
          themeExport->color((Fl_Color)198);
          themeExport->labelsize(12);
          themeExport->labelcolor((Fl_Color)64);
          themeExport->callback((Fl_Callback*)cb_themeExport);
        } // Fl_Button* themeExport
        { storedLabel = new Fl_Box(288, 115, 35, 17, "Default Theme");
          storedLabel->labelsize(12);
          storedLabel->labelcolor((Fl_Color)64);
        } // Fl_Box* storedLabel
        { storedTheme = new Fl_Button(255, 132, 100, 20, "Default Theme");
          storedTheme->box(FL_THIN_DOWN_BOX);
          storedTheme->color(FL_BACKGROUND2_COLOR);
          storedTheme->selection_color((Fl_Color)64);
          storedTheme->labelsize(12);
          storedTheme->labelcolor((Fl_Color)64);
          storedTheme->align(Fl_Align(FL_ALIGN_CLIP));
        } // Fl_Button* storedTheme
        { nuTheme = new Fl_Group(242, 158, 123, 86);
          nuTheme->deactivate();
          { currentLabel = new Fl_Box(288, 168, 35, 17, "Current Theme");
            currentLabel->labelsize(12);
            currentLabel->labelcolor((Fl_Color)64);
          } // Fl_Box* currentLabel
          { setAsStored = new Fl_Button(255, 220, 100, 20, "Make Default");
            setAsStored->box(FL_PLASTIC_THIN_UP_BOX);
            setAsStored->color((Fl_Color)228);
            setAsStored->labelsize(12);
            setAsStored->labelcolor((Fl_Color)64);
            setAsStored->callback((Fl_Callback*)cb_setAsStored);
          } // Fl_Button* setAsStored
          { selectedTheme = new Fl_Button(255, 187, 100, 20, "Current Theme");
            selectedTheme->box(FL_THIN_DOWN_BOX);
            selectedTheme->color(FL_BACKGROUND2_COLOR);
            selectedTheme->selection_color(FL_BACKGROUND2_COLOR);
            selectedTheme->labelsize(12);
            selectedTheme->labelcolor((Fl_Color)64);
            selectedTheme->align(Fl_Align(FL_ALIGN_CLIP));
          } // Fl_Button* selectedTheme
          nuTheme->end();
        } // Fl_Group* nuTheme
        { Fl_Check_Button* o = monochrome = new Fl_Check_Button(256, 250, 102, 20, "Monochrome");
          monochrome->down_box(FL_DOWN_BOX);
          monochrome->selection_color((Fl_Color)64);
          monochrome->labelsize(12);
          monochrome->labelcolor((Fl_Color)64);
          monochrome->callback((Fl_Callback*)cb_monochrome);
          o->value(0);
        } // Fl_Check_Button* monochrome
        themeTab->end();
      } // Fl_Group* themeTab
      { patch1 = new Fl_Box(6, 24, 89, 3);
        patch1->box(FL_FLAT_BOX);
        patch1->labelcolor((Fl_Color)64);
      } // Fl_Box* patch1
      { patch2 = new Fl_Box(98, 24, 65, 3);
        patch2->box(FL_FLAT_BOX);
        patch2->labelcolor((Fl_Color)64);
      } // Fl_Box* patch2
      { patch3 = new Fl_Box(166, 24, 37, 3);
        patch3->box(FL_FLAT_BOX);
        patch3->labelcolor((Fl_Color)64);
      } // Fl_Box* patch3
      { patch4 = new Fl_Box(206, 24, 37, 3);
        patch4->box(FL_FLAT_BOX);
        patch4->labelcolor((Fl_Color)64);
      } // Fl_Box* patch4
      { patch5 = new Fl_Box(246, 24, 57, 3);
        patch5->box(FL_FLAT_BOX);
        patch5->labelcolor((Fl_Color)64);
      } // Fl_Box* patch5
      { patch6 = new Fl_Box(305, 24, 57, 3);
        patch6->box(FL_FLAT_BOX);
        patch6->labelcolor((Fl_Color)64);
      } // Fl_Box* patch6
      configTabs->end();
    } // Fl_Group* configTabs
    { close = new Fl_Button(300, 306, 60, 20, "Close");
      close->box(FL_THIN_UP_BOX);
      close->color((Fl_Color)196);
      close->labelsize(12);
      close->labelcolor((Fl_Color)64);
      close->callback((Fl_Callback*)cb_close);
    } // Fl_Button* close
    configwindow->resizable(configwindow);
    o->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("Settings"), UNUSED, TOPLEVEL::windowTitle)).c_str());
    if (isLV2()){jackTab->deactivate();alsaTab->deactivate();}
    confDW = o->w();confDH = o->h();
    o->size_range(confDW, confDH, 0, 0, 0, 0, 1);
    configwindow->end();
  } // ScaleTrackedWindow* configwindow
  { ScaleTrackedWindow* o = presets = new ScaleTrackedWindow(460, 270, "Presets");
    presets->box(FL_FLAT_BOX);
    presets->color(FL_BACKGROUND_COLOR);
    presets->selection_color(FL_BACKGROUND_COLOR);
    presets->labeltype(FL_NO_LABEL);
    presets->labelfont(0);
    presets->labelsize(14);
    presets->labelcolor(FL_FOREGROUND_COLOR);
    presets->callback((Fl_Callback*)cb_presets, (void*)(this));
    presets->align(Fl_Align(FL_ALIGN_TOP));
    presets->when(FL_WHEN_RELEASE);
    { presetbrowse = new Fl_Browser(5, 5, 450, 200);
      presetbrowse->tooltip("Click on an entry to make it the readable one.");
      presetbrowse->type(2);
      presetbrowse->labelsize(12);
      presetbrowse->labelcolor((Fl_Color)64);
      presetbrowse->textsize(12);
      presetbrowse->textcolor((Fl_Color)64);
      presetbrowse->callback((Fl_Callback*)cb_presetbrowse);
    } // Fl_Browser* presetbrowse
    { addpreset = new Fl_Button(10, 220, 85, 35, "Add preset directory...");
      addpreset->box(FL_GTK_THIN_UP_BOX);
      addpreset->color((Fl_Color)198);
      addpreset->labelsize(12);
      addpreset->labelcolor((Fl_Color)64);
      addpreset->callback((Fl_Callback*)cb_addpreset);
      addpreset->align(Fl_Align(FL_ALIGN_WRAP));
    } // Fl_Button* addpreset
    { Fl_Button* o = removepresetbutton = new Fl_Button(115, 220, 85, 35, "Remove preset dir...");
      removepresetbutton->box(FL_PLASTIC_UP_BOX);
      removepresetbutton->color((Fl_Color)228);
      removepresetbutton->labelsize(12);
      removepresetbutton->labelcolor((Fl_Color)64);
      removepresetbutton->callback((Fl_Callback*)cb_removepresetbutton);
      removepresetbutton->align(Fl_Align(FL_ALIGN_WRAP));
      o->deactivate();
    } // Fl_Button* removepresetbutton
    { Fl_Button* o = makedefaultpresetbutton = new Fl_Button(220, 220, 85, 35, "Make Current");
      makedefaultpresetbutton->box(FL_PLASTIC_UP_BOX);
      makedefaultpresetbutton->color((Fl_Color)228);
      makedefaultpresetbutton->labelsize(12);
      makedefaultpresetbutton->labelcolor((Fl_Color)64);
      makedefaultpresetbutton->callback((Fl_Callback*)cb_makedefaultpresetbutton);
      makedefaultpresetbutton->align(Fl_Align(FL_ALIGN_WRAP));
      o->deactivate();
    } // Fl_Button* makedefaultpresetbutton
    { pClose = new Fl_Button(362, 220, 85, 35, "Close");
      pClose->box(FL_THIN_UP_BOX);
      pClose->color((Fl_Color)196);
      pClose->labelsize(12);
      pClose->labelcolor((Fl_Color)64);
      pClose->callback((Fl_Callback*)cb_pClose);
    } // Fl_Button* pClose
    presets->resizable(presets);
    o->copy_label(textMsgBuffer.fetch(collect_readData(synth, textMsgBuffer.push("Presets"), UNUSED, TOPLEVEL::windowTitle)).c_str());
    preDW = o->w();preDH = o->h();
    o->size_range(preDW, preDH, 0, 0, 0, 0, 1);
    presets->end();
  } // ScaleTrackedWindow* presets
  return presets;
}

void ConfigUI::send_data(int action, int control, float value, int type, int part , int kit , int engine , int insert , int par , int miscmsg ) {
  //
              type |= TOPLEVEL::type::Write;
              if (part == UNUSED)
                  part = TOPLEVEL::section::config;
              collect_writeData(synth, value, action, type, control, part, kit, engine, insert, par, UNUSED, miscmsg);
}

float ConfigUI::fetchData(float value, int control, int part, int kititem , int engine , int insert , int parameter , int offset , int miscmsg , int request ) {
  //
          return collect_readData(synth, value, control, part, kititem, engine, insert, parameter, offset, miscmsg, request);
}

void ConfigUI::returns_update(CommandBlock *getData) {
  //
              int value_int = lrint(getData->data.value);
              bool wasFromHere = ((getData->data.source & TOPLEVEL::action::noAction) == TOPLEVEL::action::fromGUI);
              unsigned char control = getData->data.control;
              unsigned char kititem = getData->data.kit;
              unsigned char miscmsg = getData->data.miscmsg;
              string msg = textMsgBuffer.fetch(miscmsg);

              bool value_bool = value_int > 0;
              int tmp;
              string name;
              switch (control)
              {
                  case CONFIG::control::oscillatorSize:
                      tmp = 0;
                      while (value_int > 256)
                      {
                          value_int = value_int >> 1;
                          ++ tmp; // count the bits for switch number
                      }
                      osc_size->value(tmp);
                      break;
                  case CONFIG::control::bufferSize:
                      tmp = CONFIG::control::bufferSize;
                      while (value_int > 16)
                      {
                          value_int = value_int >> 1;
                          ++ tmp; // count the bits for switch number
                      }
                      buff_size->value(tmp - 1);
                      break;
                  case CONFIG::control::padSynthInterpolation:
                      pad_interpol->value(value_int);
                      break;
                  case CONFIG::control::virtualKeyboardLayout:
                      v_keyboard->value(value_int);
                      break;
                  case CONFIG::control::XMLcompressionLevel:
                      compression->value(value_int);
                      break;
                  case CONFIG::control::reportsDestination:
                      if(!wasFromHere)
                          reports->value(value_bool);
                      synth->getGuiMaster()->setLogging(value_bool);
                      if (value_bool)
                          logText->activate();
                      else
                          logText->deactivate();
                      break;
                  case CONFIG::control::logTextSize:
                      logText->value(value_int);
                      //synth->getGuiMaster()->yoshiLog->logConsole->setLogText(value_int);
                      break;
                  case CONFIG::control::savedInstrumentFormat:
                      instrument->value(value_int - 1);
                      break;

                  case CONFIG::control::defaultStateStart:
                      setDefaultState->value(value_bool);
                      break;
                  case CONFIG::control::handlePadSynthBuild:
                      handlePadSynthBuild->value(value_int);
                      break;
                  case CONFIG::control::hideNonFatalErrors:
                      nonFatal->value(value_bool);
                      break;
                  case CONFIG::control::showSplash:
                      showSplash->value(value_bool);
                      break;
                  case CONFIG::control::logInstrumentLoadTimes:
                      logTimes->value(value_bool);
                      break;
                  case CONFIG::control::logXMLheaders:
                      logXML->value(value_bool);
                      break;
                  case CONFIG::control::saveAllXMLdata:
                      saveAllXML->value(value_bool);
                      break;
                  case CONFIG::control::enableGUI:
                      enableGUI->value(value_bool);
                      break;
                  case CONFIG::control::enableCLI:
                      enableCLI->value(value_bool);
                      break;
                  case CONFIG::control::enableAutoInstance:
                      enableAuto->value(value_bool);
                      break;
                  case CONFIG::control::enableSinglePath:
                      singleMaster->value(value_bool);
                      break;
                  case CONFIG::control::enableHighlight:
                      bankHighlight->value(value_bool);
                      break;
                  case CONFIG::control::enablePartReports:
                      partReports->value(value_bool);
                      break;

                  case CONFIG::control::historyLock:
                      if (!wasFromHere)
                      {
                          switch (kititem)
                          {
                              case TOPLEVEL::XML::Instrument:
                                  H_instrument->value(value_int);
                                  break;
                              case TOPLEVEL::XML::Patch:
                                  H_patchset->value(value_int);
                                  break;
                              case TOPLEVEL::XML::Scale:
                                  H_scale->value(value_int);
                                  break;
                              case TOPLEVEL::XML::State:
                                  H_state->value(value_int);
                                  break;
                              case TOPLEVEL::XML::Vector:
                                  H_vector->value(value_int);
                                  break;
                              case TOPLEVEL::XML::MLearn:
                                  H_mlearn->value(value_int);
                                  break;
                              default:
                                  break;
                          }
                      }
                      break;

                  case CONFIG::control::jackMidiSource:
                      jackSource->value(msg.c_str());
                      break;
                  case CONFIG::control::jackPreferredMidi:
                      jackMidi->value(value_bool);
                      alsaMidi->value(!value_bool);
                      break;
                  case CONFIG::control::jackServer:
                      jackServer->value(msg.c_str());
                      break;
                  case CONFIG::control::jackPreferredAudio:
                      jackAudio->value(value_bool);
                      alsaAudio->value(!value_bool);
                      break;
                  case CONFIG::control::jackAutoConnectAudio:
                      connectJackAudio->value(value_bool);
                      break;

                  case CONFIG::control::alsaMidiSource:
                      alsaSource->value(msg.c_str());
                      break;
                  case CONFIG::control::alsaPreferredMidi:
                      alsaMidi->value(value_bool);
                      jackMidi->value(!value_bool);
                      break;
                  case CONFIG::control::alsaMidiType:
                      alsaType->value(value_int);
                      if (value_int == 0) // fixed
                          alsaSource->activate();
                      else
                          alsaSource->deactivate();
                      break;
                  case CONFIG::control::alsaAudioDevice:
                      alsaDevice->value(msg.c_str());
                      break;
                  case CONFIG::control::alsaPreferredAudio:
                      alsaAudio->value(value_bool);
                      jackAudio->value(!value_bool);
                      break;
                  case CONFIG::control::alsaSampleRate:
                      alsaSamplerate->value(convertSrate(value_int));
                      break;
                  case CONFIG::control::addPresetRootDir:
                  case CONFIG::control::removePresetRootDir:
                  case CONFIG::control::currentPresetRoot:
                  {
                      if (msg.find("FAILED") == 1)
                      {
                          if (wasFromHere)
                              alert(synth, msg);
                      }
                      else
                          readpresetcfg();
                      break;
                  }
                  case CONFIG::control::bankRootCC:
                      switch (value_int)
                      {
                          case 0:
                              bankrootchange->value(1);
                              break;
                          case 32:
                              bankrootchange->value(0);
                              break;
                          default:
                              bankrootchange->value(2);
                              break;
                      }
                      break;

                  case CONFIG::control::bankCC:
                      switch (value_int)
                      {
                          case 0:
                              bankchange->value(1);
                              break;
                          case 32:
                              bankchange->value(0);
                              break;
                          default:
                              bankchange->value(2);
                              break;
                      }
                      break;
                  case CONFIG::control::enableProgramChange:
                      progenable->value(value_bool);
                      break;
                  case CONFIG::control::extendedProgramChangeCC:
                      if (value_int > 119)
                      {
                          EPCspinner->value(110);
                          EPCspinner->deactivate();
                          Epcheck->value(0);
                      }
                      else
                      {
                          EPCspinner->value(value_int);
                          EPCspinner->activate();
                          Epcheck->value(1);
                      }
                      break;
                  case CONFIG::control::ignoreResetAllCCs:
                      ignoreReset->value(value_bool);
                      break;
                  case CONFIG::control::logIncomingCCs:
                      midiMon->value(value_bool);
                      break;
                  case CONFIG::control::showLearnEditor:
                      midiLearned->value(value_bool);
                      break;
                  case CONFIG::control::enableOmni:
                      enableOmniChange->value(value_bool);
                      break;
                  case CONFIG::control::enableNRPNs:
                      enableNRPN->value(value_bool);
                      break;

                  case CONFIG::control::saveCurrentConfig:
                      name = msg;
                      if (wasFromHere && name.find("FAILED") == 1)
                          alert(synth, name);
                      break;
      }
}

ConfigUI::ConfigUI(SynthEngine *_synth, int _current_ID) {
  //
              synth = _synth;
              current_ID = _current_ID;
              manageThemes();
              make_window();
              readpresetcfg();
              configSeen = false;
              presetsSeen = false;
              selectedRootID = -1;
              Tab1->do_callback();
              string themeDir = file::localDir() + "/themes/";
              string name = file::loadText(themeDir + "ID/current.txt");
              string fullName = themeDir + name;

              while (fullName.at(fullName.length() - 1) < '!') // tidy up
              fullName.pop_back(); // deals with spurious trailing whitespace

              themeTime = file::isRegularFile(fullName);
              if (themeTime == 0)
              {
                  defaultTheme = "classic";
                  currentTheme = defaultTheme;
                  themeDirTime = 1;
              }
              else
              {
                  size_t pos = name.rfind('.');
                  defaultTheme = name.substr(0, pos);
                  currentTheme = defaultTheme;
              }
              monoChrome = 0;
              themeDirTime = 1;
}

ConfigUI::~ConfigUI() {
  //
          if (presetsSeen)
              saveWin(synth, presets->w(), presets->h(), presets->x(), presets->y(), true, "Config-presets");
          presets->hide();
          delete presets;

          if (configSeen)
              saveWin(synth, configwindow->w(), configwindow->h(),configwindow->x(), configwindow->y(), true, "Config");
          configwindow->hide();
          delete configwindow;
}

void ConfigUI::halfSecTimer() {
  //
          if (themeTab->visible())
          {
              string themeDir = file::localDir() + "/themes/";
              bool changed = false;
              if (currentTheme != "classic")
              {
                  string fileName = themeDir + currentTheme +".clr";
                  size_t testTime = file::isRegularFile(fileName);
                  if (testTime != themeTime)
                  {
                      //std::cout << "test " << testTime << "  theme " << themeTime << std::endl;
                      setUserTable(fileName);
                      synth->getGuiMaster()->theme();
                      changed = true;
                      themeTime = testTime;
                  }
              }
              if (!changed) // we don't want to rebuild the menu if it's just a theme change
              {
                  size_t testDirTime = file::isDirectory(themeDir);
                  if (testDirTime != themeDirTime)
                  {
                      //std::cout << "test " << testDirTime << "  theme dir " << themeDirTime << std::endl;
                      fillThemes();
                      themeDirTime = testDirTime;
                  }
              }
          }
}

void ConfigUI::fillNative() {
  //
          for (int i = 0; i < 256; ++i)
          {
              getNativeLine(i);
          }
          ;
}

void ConfigUI::getNativeLine(int line) {
  //
          unsigned char rt, gt, bt;
          Fl::get_color(line, rt, gt, bt);
          nativeTable[line] = int(rt);
          nativeTable[line + 256] = int(gt);
          nativeTable[line + 512] = int(bt);
          ;
}

int ConfigUI::fillThemes() {
  //
          string sourceDir = file::localDir() + "/themes/";
          std::list<string> themes;
          int count = file::listDir(&themes, sourceDir);
          if (count == 0)
              return 0;
          themes.sort();
          theme_browser->clear();
          std::list<string>::iterator itr = themes.begin();
          while (itr != themes.end())
          {
              string text = file::findExtension(*itr);
              if (text == ".clr")
              {
                  text = *itr;
                  size_t pos = text.find(".clr");
                  text = text.substr(0, pos);
                  theme_browser->add(text.c_str());
              }
              ++itr;
          }
          storedTheme->copy_label(defaultTheme.c_str());
          selectedTheme->copy_label(currentTheme.c_str());
          return count;
          ;
}

void ConfigUI::manageThemes() {
  //
          static bool seen = false;
          if (!seen)
          {
              fillNative();
              seen = true;

              if (!file::isRegularFile(file::localDir() + "/themes/demo.clr"))
              {
                  string demo = file::findExampleFile("themes/demo.clr");
                  if (!demo.empty())
                      file::copyFile(demo, file::localDir() + "/themes/demo.clr", 1);
              }

          }

         /*
          * Note: Fluid screws up text with control values and @
          * so we enter them as char(n)
          */

        // prints the native colour table
        /*unsigned char RR,GG,BB;
        for (int i = 0; i < 256; ++i)
        {
            Fl::get_color(i, RR, GG, BB);
            std::cout << '"'<< int(RR) << "," << int(GG) << "," << int(BB) << '"' << "," << std::endl;
        }*/

        int colour2find = 0;
        if (colour2find > 0) // for testing
        {
            unsigned char rt,gt,bt;
            Fl::get_color(colour2find, rt, gt, bt);
            std::cout << "r " << int(rt) << " g " << int(gt) << " b " << int(bt) << std::endl;
        }
        if (!checkVersions())
        {
            setClassicTable();
            themeTime = 1;
            return;
        }

        if (findRemote()) // externally CLI sourced
            return;

        string themeDir = file::localDir() + "/themes/";

        string selectedTheme = file::loadText(themeDir+"ID/current.txt");
        while (selectedTheme.at(selectedTheme.length() - 1) < '!') // tidy up
            selectedTheme.pop_back(); // deals with spurious trailing whitespace

        if (selectedTheme != "classic.clr")
        {
            string fileName = themeDir+ selectedTheme;
            themeTime = file::isRegularFile(fileName);
            if (themeTime != 0)
            {
                  int errLine = setUserTable(fileName);
                  if (errLine != -1)
                      themeError(errLine);
                  return;
            }
        }
        setClassicTable();

        //Fl::set_color(196, 127, 145, 191); // for testing

        ;
}

bool ConfigUI::checkVersions() {
  //
          string themeDir = file::localDir() + "/themes/";
          file::createDir(themeDir);
          file::createDir(themeDir + "ID");
          int build_ID = synth->getRuntime().build_ID;
          int theme_ID = 0;
          string defaultName = "classic.clr";
          bool ok = true;
          if (!file::isRegularFile(themeDir + defaultName))
              ok = false;
          if (ok)
          {
              if(!file::isRegularFile(themeDir +"ID/version"))
                  ok = false;
              else
                  theme_ID = func::string2int(file::loadText(themeDir + "ID/version"));
          }
          if (ok)
          {
              if (build_ID > theme_ID)
                  ok = false;
          }
          if (ok)
          {
              string filename = themeDir +"ID/" + "current.txt";
              if(!file::isRegularFile(filename))
                  ok = false;
          }

          if (ok)
              return true;

          file::saveText(to_string(build_ID), themeDir + "ID/version");
          string res = themeDir + "ID/version";
          //std::cout << "version>" << res << std::endl;
          string colourText;
          int info = 0;
          do {
              colourText += (colourPreamble[info] + char(10));
              ++info;
              if (info > 100)
              {
                  std::cout << "failed preamble" << std::endl;
              }
          } while(colourPreamble[info] != "END");

          int data = 0;
          do {
              colourText += (colourData[data] + char(10));
              ++data;
              if (data > 200)
              {
                  std::cout << "failed data" << std::endl;
              }
          }  while(colourData[data] != "END");

          file::saveText(defaultName + char(10), themeDir + "ID/current.txt");
          file::saveText(colourText, themeDir + defaultName);
          return false;
}

bool ConfigUI::findRemote() {
  //
         bool ok = true;
         string selectedTheme = synth->getRuntime().remoteGuiTheme;
         if ((!file::isRegularFile(selectedTheme)))
         {
             return false;
         }
         if (!selectedTheme.empty())
         {
             int errLine = setUserTable(selectedTheme);
             if (errLine != -1)
             {
                 themeError(errLine);
                 ok = false;
             }
         }
         return ok;
}

void ConfigUI::setNativeTable() {
  //
          for (int i = 0; i < 256; ++i)
              setNativeLine(i);
          ;
}

void ConfigUI::setNativeLine(int line) {
  //;
          unsigned char R, G, B;
          R = nativeTable[line];
          G = nativeTable[line + 256];
          B = nativeTable[line + 512];
          Fl::set_color(line, R, G, B);
          ;
}

bool ConfigUI::setClassicTable() {
  //
          setGreyScale(colourData[0]);
          for (int lineCount = 0; lineCount < COLOURLIST; ++ lineCount)
          {
              if (setColourLine(colourData[lineCount + 1], lineCount) != 0) // we don't want the greyscale line!
              {
                  synth->getRuntime().Log("Corrupted Classic theme data.");
                  return false;
              }
          }
          return true;
}

int ConfigUI::setUserTable(string table) {
  //
          string colourText = file::loadText(table);
          themeTime = file::isRegularFile(table);
          std::size_t nextPos;

          // strip out preamble text
          string text = "";
          int lineCount = 0;
          int totalCount = 1;
          while (text.substr(0, 7) != "-------")
          {
              nextPos = colourText.find(char(10));
              if (nextPos == std::string::npos)
              {
                  return -2;
              }

              text = colourText.substr(0, nextPos);
              colourText = colourText.substr(nextPos + 1);
              ++lineCount;
              ++totalCount;
          }
          if (text.substr(0, 7) != "-------")
          {
              return -2;
          }

          int dataStart = totalCount;
          if (colourText.at(0) == char(64)) // all native colour table
          {
              setNativeTable();
              return -1; // doesn't matter if there's no more to the file
          }

          nextPos = colourText.find(char(10));
          int scaletype = setGreyScale(colourText.substr(0, nextPos));
          if (scaletype == 0)
          {
              return totalCount;
          }

          ++totalCount; // allow for greyscale line
          colourText = colourText.substr(nextPos + 1);
          lineCount = 0;
          int test = 0;
          do {
              if ((totalCount - dataStart) > COLOURLIST && colourText.substr(0, 7) != "=======")
              {
                  return -3; // missing marker
              }

              nextPos = colourText.find(char(10));
              if (nextPos == std::string::npos)
              {
                  return -4; // too short
              }

              text = colourText.substr(0, nextPos);
              if (text.at(0) == char(64))
              {
                  int actual_line = colourNumbers[lineCount];
                  setNativeLine(actual_line);
              }
              else
              {
                  string lineText = colourText.substr(0, nextPos);
                  if (lineText.find("RESERVED") != std::string::npos)
                  {
                      // use actual default value, stepping over greyscale line
                      test = setColourLine(colourData[lineCount + 1], lineCount);
                  }
                  else
                      test = setColourLine(lineText, lineCount);
              }

              if (test == -1)
              {
                  if (colourText.substr(0, 7) == "-------")
                      return -4; // old style too short
                  return totalCount;
              }

              ++lineCount;
              ++totalCount;
              colourText = colourText.substr(nextPos + 1);
          } while(colourText.substr(0, 7) != "=======");

          //std::cout << "lines " << lineCount << std::endl;

          if ((totalCount - dataStart) <= COLOURLIST)
          {
              return -4; // too short
          }
          return -1;
          ;
}

bool ConfigUI::setGreyTint(string text, float &R, float &G, float &B) {
  //
          float r,g,b;
          if (!isdigit(text.at(0)))
          {
              return false;
          }
          size_t nextPos = text.find(",");
          r = string2int(text.substr(0, nextPos));
          if (r > 255 || r < 0)
              return false;
          r = (r-127) / 511.0f;

          text = text.substr(nextPos + 1);
          nextPos = text.find(",");
          if (nextPos == std::string::npos)
          {
              return false;
          }
          if (!isdigit(text.at(0)))
          {
              return false;
          }
          g = string2int(text.substr(0, nextPos));
          if (g > 255 || g < 0)
              return false;
          g = (g-127) / 511.0f;

          text = text.substr(nextPos + 1);
          nextPos = text.find(",");
          if (nextPos == std::string::npos)
          {
              return false;
          }
          if (!isdigit(text.at(0)))
          {
              return false;
          }
          b = string2int(text.substr(0, nextPos));
          if (b > 255 || b < 0)
              return false;
          b = (b-127) / 511.0;

          float offset = (r+g+b) / 3;
          R = 1+r - offset;
          if (R < 0)
              R = 0;
          G = 1+g - offset;
          if (G < 0)
              G = 0;
          B = 1+b - offset;
          if (B < 0)
              B = 0;
          return true;
}

int ConfigUI::setGreyScale(string text) {
  //
          size_t nextPos = text.find(",");
          if (nextPos == std::string::npos)
          {
              return 0;
          }

          if (!isdigit(text.at(0)))
          {
              return 0;
          }

          int min = string2int(text.substr(0, nextPos));
          if (min < 0 || min > 255)
          {
              return 0;
          }

          text = text.substr(nextPos + 1);
          nextPos = text.find(",");
          if (nextPos == std::string::npos)
          {
              return 0;
          }

          if (!isdigit(text.at(0)))
          {
              return 0;
          }

          int max = string2int(text.substr(0, nextPos));

          if (max < 0 || max > 255)
          {
              return 0;
          }

          if (min == 127 && max == 127)
              return 2; // this sets a totally grey colourmap
                        // useful for testing contrast

          float Rmult, Gmult, Bmult = 1;
          bool useTint = false;
          if(!monoChrome)
          {
              text = text.substr(nextPos + 1);
              if(isdigit(text.at(0)))
              {
                  if (setGreyTint(text,Rmult,Gmult,Bmult))
                      useTint = true;
                  else
                      synth->getRuntime().Log("Invalid grey tint");
              }
          }

          float greyRange;
          if (max > min)
          {
             greyRange =  (max - min) / 23;
             for (int i = 0; i < 24; ++i)
             {
                  int diff = (min + int(i * greyRange)) + 1;
                  if (useTint)
                  {
                      int r = diff*Rmult;
                      if (r > 255)
                          r = 255;
                      else if (r < 0)
                          r = 0;
                      int g = diff*Gmult;
                      if (g > 255)
                          g = 255;
                      else if (g < 0)
                          g = 0;
                      int b = diff*Bmult;
                      if (b > 255)
                          b = 255;
                      else if (b < 0)
                          b = 0;
                      Fl::set_color(i + 32, r, g, b);
                  }
                  else
                      Fl::set_color(i + 32, diff, diff, diff);
             }
          }
          else
          {
             greyRange = (min - max) / 23;
             for (int i = 0; i < 24; ++i)
             {
                 int diff = (min - int(i * greyRange)) - 1 ;
                 if (useTint)
                  {
                      int r = diff*Rmult;
                      if (r > 255)
                          r = 255;
                      else if (r < 0)
                          r = 0;
                      int g = diff*Gmult;
                      if (g > 255)
                          g = 255;
                      else if (g < 0)
                          g = 0;
                      int b = diff*Bmult;
                      if (b > 255)
                          b = 255;
                      else if (b < 0)
                          b = 0;
                      Fl::set_color(i + 32, r, g, b);
                  }
                  else
                      Fl::set_color(i + 32, diff, diff, diff);
             }
         }
    return 1;
    ;
}

int ConfigUI::setColourLine(string text, int item) {
  //
          size_t nextPos = text.find(",");
          if (nextPos == std::string::npos)
              return -1;
          if (text.at(0) == char(35))
          {
              text = text.substr(1,nextPos);
              unsigned int hexNumber;
              sscanf(text.c_str(), "%x", &hexNumber);
              Fl::set_color(colourNumbers[item],hexNumber * 256);
              return 0;
          }
          if (!isdigit(text.at(0)))
              return -1;
          int red = string2int(text.substr(0, nextPos));
          if (red < 0 || red > 255)
              return -1;

          text = text.substr(nextPos + 1);
          nextPos = text.find(",");
          if (nextPos == std::string::npos)
              return -1;
          if (!isdigit(text.at(0)))
              return -1;
          int green = string2int(text.substr(0, nextPos));
          if (green < 0 || green > 255)
              return -1;

          text = text.substr(nextPos + 1);
          if (!isdigit(text.at(0)))
              return -1;
          int blue = string2int(text); // don't need comma test here
          if (blue < 0 || blue > 255)
              return -1;
          if (monoChrome == 1)
          {
              int allGrey = (red+green+blue)/3;
              red = green = blue = allGrey;
          }
          Fl::set_color(colourNumbers[item], red, green, blue);
          return 0;
          ;
}

void ConfigUI::activatebutton_presetdir(bool active) {
  //
              if (active)
              {
                  removepresetbutton->activate();
                  makedefaultpresetbutton->activate();
              }
              else
              {
                  removepresetbutton->deactivate();
                  makedefaultpresetbutton->deactivate();
              }
}

void ConfigUI::themeError(int errLine) {
  //
          themeTime = 1;
          if (errLine == -2)
              synth->getRuntime().Log("Theme: Missing data start marker");
          else if (errLine == -3)
              synth->getRuntime().Log("Theme: Missing data end marker");
          else if (errLine == -4)
              synth->getRuntime().Log("Theme: Short file");
          else
              synth->getRuntime().Log("Theme: Failed at line " + std::to_string(errLine));
          ;
}

int ConfigUI::recoverID() {
  // No longer using this. Why not?
              if (selectedRootID >= 0)
              {
                  return selectedRootID;
              }
              return 0;
}

void ConfigUI::readpresetcfg() {
  //
              presetbrowse->clear();
              for (int i = 0; i < MAX_PRESET_DIRS; ++i)
                  if (synth->getRuntime().presetsDirlist[i].size())
                  {
                      string name;
                      if (i == synth->getRuntime().presetsRootID)
                          name = "* ";
                      else
                          name = "  ";
                      name += synth->getRuntime().presetsDirlist[i];
                      presetbrowse->add(name.c_str());
                  }
}

int ConfigUI::convertSrate(int source) {
  //
      int result = 2;
      switch (source)
      {
          case 0:
              result = 192000;
              break;
          case 1:
              result = 96000;
              break;
          case 2:
              result = 48000;
              break;
          case 3:
              result = 44100;
              break;
          case 192000:
              result = 0;
              break;
          case 96000:
              result = 1;
              break;
          case 48000:
              result = 2;
              break;
          case 44100:
              result = 3;
              break;
      }
      return result;
}

void ConfigUI::update_config(int tabnumber) {
  //
              int tmp;
              switch (tabnumber)
              {
                  case 1 : // Main
                      osc_size->value( (int)(logf(synth->getRuntime().oscilsize / 256.0f - 1.0f) / logf(2.0f)) + 1);
                      buff_size->value( (int)(logf(synth->getRuntime().buffersize / 16.0f - 1.0f) / logf(2.0f)) + 1);
                      pad_interpol->value(synth->getRuntime().Interpolation);
                      v_keyboard->value(synth->getRuntime().virKeybLayout);
                      compression->value(synth->getRuntime().gzipCompression);
                      reports->value(synth->getRuntime().toConsole);
                      instrument->value(synth->getRuntime().instrumentFormat - 1);
                      break;

                  case 2 : // Jack
                      jackSource->value(synth->getRuntime().jackMidiDevice.c_str());
                      if (synth->getRuntime().midiEngine == jack_midi)
                      {
                          jackMidi->value(1);
                          alsaMidi->value(0);
                      }
                      jackServer->value(synth->getRuntime().jackServer.c_str());
                      if (synth->getRuntime().audioEngine == jack_audio)
                      {
                          jackAudio->value(1);
                          alsaAudio->value(0);
                      }
                      break;

                  case 3 : // Alsa
                      {
                          alsaSource->value(synth->getRuntime().alsaMidiDevice.c_str());
                          if (synth->getRuntime().midiEngine == alsa_midi)
                          {
                              alsaMidi->value(1);
                              jackMidi->value(0);
                          }
                          alsaDevice->value(synth->getRuntime().alsaAudioDevice.c_str());
                          if (synth->getRuntime().audioEngine == alsa_audio)
                          {
                              alsaAudio->value(1);
                              jackAudio->value(0);
                          }
                          alsaSamplerate->value(convertSrate(synth->getRuntime().samplerate));
                      }
                      break;

                  case 4 : // MIDI
                      switch (synth->getRuntime().midi_bank_root)
                      {
                          case 32:
                              bankrootchange->value(0);
                              break;
                          case 0:
                              bankrootchange->value(1);
                              break;
                          default:
                              bankrootchange->value(2);
                              break;
                      }

                      switch (synth->getRuntime().midi_bank_C)
                      {
                          case 32:
                              bankchange->value(0);
                              break;
                          case 0:
                              bankchange->value(1);
                              break;
                          default:
                              bankchange->value(2);
                              break;
                      }
                      progenable->value(synth->getRuntime().enableProgChange);

                      tmp = synth->getRuntime().midi_upper_voice_C;
                      if (tmp == 128)
                      {
                          EPCspinner->value(110);
                          EPCspinner->deactivate();
                          Epcheck->value(0);
                      }
                      else
                      {
                          EPCspinner->value(tmp);
                          EPCspinner->activate();
                          Epcheck->value(1);
                      }
                      Epend->hide();
                      enableOmniChange->value(synth->getRuntime().enableOmni);
                      enableNRPN->value(synth->getRuntime().enable_NRPN);
                      ignoreReset->value(synth->getRuntime().ignoreResetCCs);
                      midiMon->value(synth->getRuntime().monitorCCin);
                      midiLearned->value(synth->getRuntime().showLearnedCC);
                      break;

                  case 5 : // Switches
                      handlePadSynthBuild->value(synth->getRuntime().handlePadSynthBuild);
                      setDefaultState->value(synth->getRuntime().loadDefaultState > 0);
                      nonFatal->value(synth->getRuntime().hideErrors);
                      showSplash->value(synth->getRuntime().showSplash);
                      logTimes->value(synth->getRuntime().showTimes);
                      logXML->value(synth->getRuntime().logXMLheaders);
                      saveAllXML->value(synth->getRuntime().xmlmax);
                      enableGUI->value(synth->getRuntime().storedGui);
                      enableCLI->value(synth->getRuntime().storedCli);
                      break;
      }
}

void ConfigUI::Show(SynthEngine *synth) {
  //
                      if (isLV2() == false && synth->getUniqueId() == 0)
                          singleMaster->show();
                      int tmp = fetchData (0, CONFIG::control::alsaMidiType,TOPLEVEL::section::config);
                      alsaType->value(tmp);
                      if (tmp == 0)
                          alsaSource->activate();
                      else
                          alsaSource->deactivate();

                      int fetchW, fetchH, fetchX, fetchY, fetchO;
                      loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Config");
                      if (fetchW < confDW || fetchH < confDH)
                      {
                          fetchW = confDW;
                          fetchH = confDH;
                      }
                      checkSane(fetchX, fetchY, fetchW, fetchH, confDW, confDH);
                      configwindow->resize(fetchX, fetchY, fetchW, fetchH);
                      lastconfigW = 0;
                      configSeen = true;
                      configwindow->show();
}

void ConfigUI::Showpresets(SynthEngine *synth) {
  //
                  int fetchW, fetchH, fetchX, fetchY, fetchO;
                  loadWin(synth, fetchW, fetchH, fetchX, fetchY, fetchO, "Config-presets");

                  if (fetchW < preDW || fetchH < preDH)
                  {
                      fetchW = preDW;
                      fetchH = preDH;
                  }
                  presets->resize(fetchX, fetchY, fetchW, fetchH);
                  presets->resizable();
                  lastpresetW = 0;
                  presetsSeen = true;
                  presets->show();
}

void ConfigUI::configRtext() {
  //
      if (lastconfigW == configwindow->w())
          return;
      lastconfigW = configwindow->w();

      float dScale =  configwindow->w() / confDW;

      int size = int(dScale * 12);

      Tab1->labelsize(size);
      osc_size->labelsize(size);
          osc_size->textsize(size);

      buff_size->labelsize(size);
          buff_size->textsize(size);

      pad_interpol->labelsize(size);
          pad_interpol->textsize(size);

      handlePadSynthBuild->labelsize(size);
          handlePadSynthBuild->textsize(size);

      v_keyboard->labelsize(size);
          v_keyboard->textsize(size);

      compression->labelsize(size);
          compression->textsize(size);
      reports->labelsize(size);
          reports->textsize(size);
      logText->labelsize(size);
          logText->textsize(size);

      instrument->labelsize(size);
          instrument->textsize(size);

      PanelLayout->labelsize(size);
          PanelLayout->textsize(size);

      settingsNote->labelsize(size);

  //
      Tab2->labelsize(size);
      handlePadSynthBuild->labelsize(size);
      bankHighlight->labelsize(size);
      partReports->labelsize(size);
      setDefaultState->labelsize(size);
      nonFatal->labelsize(size);
      showSplash->labelsize(size);
      logTimes->labelsize(size);
      logXML->labelsize(size);
      saveAllXML->labelsize(size);
      enableGUI->labelsize(size);
      enableCLI->labelsize(size);
      enableAuto->labelsize(size);
      singleMaster->labelsize(size);

      historyLocks->labelsize(size);
      H_instrument->labelsize(size);
      H_patchset->labelsize(size);
      H_scale->labelsize(size);
      H_state->labelsize(size);
      H_vector->labelsize(size);
      H_mlearn->labelsize(size);

      switchesNote->labelsize(size);
  //
      Tab3->labelsize(size);
      jackSource->labelsize(size);
          jackSource->textsize(size);
      jackMidi->labelsize(size);
      jackServer->labelsize(size);
          jackServer->textsize(size);
      jackAudio->labelsize(size);
      connectJackAudio->labelsize(size);

      jackNote->labelsize(size);
  //
      Tab4->labelsize(size);
      alsaType->labelsize(size);
          alsaType->textsize(size);

      alsaSource->labelsize(size);
          alsaSource->textsize(size);
      alsaMidi->labelsize(size);
      alsaDevice->labelsize(size);
      alsaDevice->textsize(size);

      alsaAudio->labelsize(size);
      alsaSamplerate->labelsize(size);
          alsaSamplerate->textsize(size);

      alsaNote->labelsize(size);

  //
      Tab5->labelsize(size);
      bankrootchange->labelsize(size);
          bankrootchange->textsize(size);

      bankchange->labelsize(size);
          bankchange->textsize(size);

      progenable->labelsize(size);
      EPCspinner->labelsize(size);
          EPCspinner->textsize(size);
      Epend->labelsize(size);
      Epcheck->labelsize(size);
      enableOmniChange->labelsize(size);
      enableNRPN->labelsize(size);
      ignoreReset->labelsize(size);
      midiMon->labelsize(size);
      midiLearned->labelsize(size);
  //
      Tab6->labelsize(size);
      themeImport->labelsize(size);
      themeExport->labelsize(size);
      theme_browser->labelsize(size);
          theme_browser->textsize(size);
      themeImport->labelsize(size);
      storedLabel->labelsize(size);
      storedTheme->labelsize(size);
      currentLabel->labelsize(size);
      selectedTheme->labelsize(size);
      setAsStored->labelsize(size);
      monochrome->labelsize(size);
  //
      close->labelsize(size);

      configwindow->redraw();
}

void ConfigUI::presetsRtext() {
  //
      if (lastpresetW == presets->w())
          return;

      lastpresetW = presets->w();

      float dScale = presets->w() / preDW;

      int size = int(12 * dScale);

      addpreset->labelsize(size);
      removepresetbutton->labelsize(size);
      makedefaultpresetbutton->labelsize(size);
      pClose->labelsize(size);

      presetbrowse->textsize(size);

      presets->redraw();
}

string ConfigUI::testCC(int value, int control) {
  //
              CommandBlock getData;
              getData.data.value = value;
              getData.data.control = control;
              getData.data.part = 248;
              synth->interchange.testLimits(getData);
              return textMsgBuffer.fetch(getData.data.miscmsg);
}
