// MasterUI.h
// generated by Fast Light User Interface Designer (fluid) version 1.0404

#ifndef MasterMiscUI_h
#define MasterMiscUI_h
#include <FL/Fl.H>
// Original ZynAddSubFX author Nasca Octavian Paul
// Copyright (C) 2002-2005 Nasca Octavian Paul
// Copyright 2009-2011, Alan Calvert
// Copyright 2014-2025, Will Godfrey

// This file is part of yoshimi, which is free software: you can redistribute
// it and/or modify it under the terms of the GNU General Public
// License as published by the Free Software Foundation; either version 2 of
// the License, or (at your option) any later version.

// yoshimi is distributed in the hope that it will be useful, but WITHOUT ANY
// WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS
// FOR A PARTICULAR PURPOSE.   See the GNU General Public License (version 2 or
// later) for more details.

// You should have received a copy of the GNU General Public License along with
// yoshimi; if not, write to the Free Software Foundation, Inc., 51 Franklin
// Street, Fifth Floor, Boston, MA  02110-1301, USA.

// This file is a derivative of the ZynAddSubFX original.


#include <string>
#include <iostream>
#include "UI/MiscGui.h"
#include "UI/WidgetCheckButton.h"
#include "ADnoteUI.h"
#include "SUBnoteUI.h"
#include "EffUI.h"
#include "VirKeyboardUI.h"
#include "ConfigUI.h"
#include "BankUI.h"
#include "PartUI.h"
#include "MicrotonalUI.h"
#include "PresetsUI.h"
#include "ParametersUI.h"
#include "ConsoleUI.h"
#include "Misc/SynthEngine.h"
#include <FL/Fl_Menu_Bar.H>
#define MIN_DB -48.0
#define NO_DB -68.0

class VUMeter : public Fl_Box {
public:
  VUMeter(int x,int y, int w, int h, const char *label=0);
  void init(int part_, SynthEngine *_synth);
  float fetchData(float value, int control, int part, int kititem = UNUSED, int engine = UNUSED, int insert = UNUSED, int parameter = UNUSED, int offset = UNUSED, int miscmsg = UNUSED);
  void draw_master();
  void draw_part();
  void draw();
  static void tickdraw(VUMeter *o);
  static void tick(void *v);
  int handle(int event);
private:
  int tick500;
  int npart;
  float oldrmsdbl;
  float oldrmsdbr;
  float maxdbl;
  float maxdbr;
  int oldpeakl;
  int oldpeakr;
  int clipped;
public:
  int *plgroup;
private:
  SynthEngine *synth;
public:
  struct{
 int oldpeak[NUM_MIDI_PARTS]; int oldpeakR[NUM_MIDI_PARTS];
  bool clip[NUM_MIDI_PARTS];
 bool clipR[NUM_MIDI_PARTS]; } panelpart;
  void resetPart(bool clipOnly = false);
};

class SysEffSend : public WidgetPDial {
public:
  SysEffSend(int x,int y, int w, int h, const char *label=0);
  void init(int neff1_, int neff2_, SynthEngine *_synth);
  ~SysEffSend();
  int handle(int event);
private:
  int neff1;
  int neff2;
  SynthEngine *synth;
};
#include <FL/Fl_Group.H>
#include <FL/Fl_Button.H>
#include <FL/Fl_Box.H>
#include <FL/Fl_Choice.H>

class Panellistitem : public Fl_Group {
public:
  Fl_Group* make_window();
  Fl_Group *panellistitem;
  Fl_Group *panellistitemgroup;
  VUMeter *partVUMeter;
private:
  inline void cb__i(Fl_Button*, void*);
  static void cb_(Fl_Button*, void*);
public:
  Fl_Button *partEdit;
private:
  inline void cb_partEdit_i(Fl_Button*, void*);
  static void cb_partEdit(Fl_Button*, void*);
public:
  Fl_Box *partadd;
  Fl_Box *partsub;
  Fl_Box *partpad;
  Fl_Button *partname;
  Fl_Button *buttontop;
private:
  inline void cb_buttontop_i(Fl_Button*, void*);
  static void cb_buttontop(Fl_Button*, void*);
public:
  mwheel_slider *partvolume;
private:
  inline void cb_partvolume_i(mwheel_slider*, void*);
  static void cb_partvolume(mwheel_slider*, void*);
public:
  WidgetPDial *partpanning;
private:
  inline void cb_partpanning_i(WidgetPDial*, void*);
  static void cb_partpanning(WidgetPDial*, void*);
public:
  Fl_Choice *partrcv;
private:
  inline void cb_partrcv_i(Fl_Choice*, void*);
  static void cb_partrcv(Fl_Choice*, void*);
public:
  Fl_Choice *audiosend;
private:
  inline void cb_audiosend_i(Fl_Choice*, void*);
  static void cb_audiosend(Fl_Choice*, void*);
public:
  Fl_Check_Button2 *partenabled;
private:
  inline void cb_partenabled_i(Fl_Check_Button2*, void*);
  static void cb_partenabled(Fl_Check_Button2*, void*);
public:
  void send_data(int action, int control, float value, int type, int parameter = UNUSED);
  Panellistitem(int x,int y, int w, int h, const char *label=0);
  void init(int npart_, BankUI *bankui_, SynthEngine *_synth);
  void refresh();
  void setPartLabel(int npart);
  unsigned int findengines(int npart);
  ~Panellistitem();
private:
  int npart;
  BankUI *bankui;
  SynthEngine *synth;
public:
  int *plgroup;
  void itemRtext(float dScale);
};
#endif
