/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.diagnostic;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import javax.naming.spi.NamingManager;
import net.snowflake.client.jdbc.diagnostic.DiagnosticCheck;
import net.snowflake.client.jdbc.diagnostic.ProxyConfig;
import net.snowflake.client.jdbc.diagnostic.SnowflakeEndpoint;
import net.snowflake.client.log.SFLogger;
import net.snowflake.client.log.SFLoggerFactory;

class DnsDiagnosticCheck
extends DiagnosticCheck {
    private static final SFLogger logger = SFLoggerFactory.getLogger(DnsDiagnosticCheck.class);
    private final String INITIAL_DNS_CONTEXT = "com.sun.jndi.dns.DnsContextFactory";

    DnsDiagnosticCheck(ProxyConfig proxyConfig) {
        super("DNS Lookup Test", proxyConfig);
    }

    @Override
    protected void doCheck(SnowflakeEndpoint snowflakeEndpoint) {
        this.getCnameRecords(snowflakeEndpoint);
        this.getArecords(snowflakeEndpoint);
    }

    private void getCnameRecords(SnowflakeEndpoint snowflakeEndpoint) {
        String hostname = snowflakeEndpoint.getHost();
        try {
            Hashtable<String, String> env = new Hashtable<String, String>();
            env.put("java.naming.factory.initial", "com.sun.jndi.dns.DnsContextFactory");
            DirContext dirCtx = (DirContext)NamingManager.getInitialContext(env);
            Attributes attrs1 = dirCtx.getAttributes(snowflakeEndpoint.getHost(), new String[]{"CNAME"});
            NamingEnumeration<? extends Attribute> attrs = attrs1.getAll();
            StringBuilder sb = new StringBuilder();
            sb.append("\nCNAME:\n");
            while (attrs.hasMore()) {
                Attribute a = attrs.next();
                NamingEnumeration<?> values = a.getAll();
                while (values.hasMore()) {
                    sb.append(values.next());
                    sb.append("\n");
                }
            }
            logger.info(sb.toString(), new Object[0]);
        }
        catch (NamingException e) {
            logger.error("Error occurred when getting CNAME record for host " + hostname, e);
        }
        catch (Exception e) {
            logger.error("Unexpected error occurred when getting CNAME record for host " + hostname, e);
        }
    }

    private void getArecords(SnowflakeEndpoint snowflakeEndpoint) {
        String hostname = snowflakeEndpoint.getHost();
        try {
            InetAddress[] addresses = InetAddress.getAllByName(hostname);
            StringBuilder sb = new StringBuilder();
            sb.append("\nA Records:\n");
            for (InetAddress ip : addresses) {
                if (ip instanceof Inet4Address) {
                    sb.append(ip.getHostAddress());
                    sb.append("\n");
                }
                if (!snowflakeEndpoint.isPrivateLink() || ip.isSiteLocalAddress()) continue;
                logger.error("Public IP address was returned for {}. Please review your DNS configurations.", hostname);
            }
            logger.info(sb.toString(), new Object[0]);
        }
        catch (UnknownHostException e) {
            logger.error("DNS query failed for host: " + snowflakeEndpoint.getHost(), e);
        }
    }
}

