/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.google.common.collect;

import java.util.Map;
import java.util.function.BiConsumer;
import net.snowflake.client.jdbc.internal.google.common.annotations.GwtCompatible;
import net.snowflake.client.jdbc.internal.google.common.annotations.GwtIncompatible;
import net.snowflake.client.jdbc.internal.google.common.annotations.J2ktIncompatible;
import net.snowflake.client.jdbc.internal.google.common.base.Preconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.CollectPreconditions;
import net.snowflake.client.jdbc.internal.google.common.collect.ElementTypesAreNonnullByDefault;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableBiMap;
import net.snowflake.client.jdbc.internal.google.common.collect.ImmutableSet;
import net.snowflake.client.jdbc.internal.google.common.collect.Maps;
import net.snowflake.client.jdbc.internal.google.errorprone.annotations.concurrent.LazyInit;
import net.snowflake.client.jdbc.internal.google.j2objc.annotations.RetainedWith;
import net.snowflake.client.jdbc.internal.javax.annotation.CheckForNull;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class SingletonImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    final transient K singleKey;
    final transient V singleValue;
    @CheckForNull
    private final transient ImmutableBiMap<V, K> inverse;
    @LazyInit
    @CheckForNull
    @RetainedWith
    private transient ImmutableBiMap<V, K> lazyInverse;

    SingletonImmutableBiMap(K singleKey, V singleValue) {
        CollectPreconditions.checkEntryNotNull(singleKey, singleValue);
        this.singleKey = singleKey;
        this.singleValue = singleValue;
        this.inverse = null;
    }

    private SingletonImmutableBiMap(K singleKey, V singleValue, ImmutableBiMap<V, K> inverse) {
        this.singleKey = singleKey;
        this.singleValue = singleValue;
        this.inverse = inverse;
    }

    @Override
    @CheckForNull
    public V get(@CheckForNull Object key) {
        return this.singleKey.equals(key) ? (V)this.singleValue : null;
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action).accept(this.singleKey, this.singleValue);
    }

    @Override
    public boolean containsKey(@CheckForNull Object key) {
        return this.singleKey.equals(key);
    }

    @Override
    public boolean containsValue(@CheckForNull Object value) {
        return this.singleValue.equals(value);
    }

    @Override
    boolean isPartialView() {
        return false;
    }

    @Override
    ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        return ImmutableSet.of(Maps.immutableEntry(this.singleKey, this.singleValue));
    }

    @Override
    ImmutableSet<K> createKeySet() {
        return ImmutableSet.of(this.singleKey);
    }

    @Override
    public ImmutableBiMap<V, K> inverse() {
        if (this.inverse != null) {
            return this.inverse;
        }
        ImmutableBiMap<V, K> result = this.lazyInverse;
        if (result == null) {
            this.lazyInverse = new SingletonImmutableBiMap<K, V>(this.singleValue, this.singleKey, this);
            return this.lazyInverse;
        }
        return result;
    }

    @Override
    @J2ktIncompatible
    @GwtIncompatible
    Object writeReplace() {
        return super.writeReplace();
    }
}

