/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.builtins.temporal;

import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.js.builtins.JSBuiltinsContainer;
import com.oracle.truffle.js.builtins.temporal.JSTemporalBuiltinOperation;
import com.oracle.truffle.js.builtins.temporal.TemporalPlainTimeFunctionBuiltinsFactory;
import com.oracle.truffle.js.nodes.function.JSBuiltin;
import com.oracle.truffle.js.nodes.temporal.ToTemporalTimeNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.builtins.BuiltinEnum;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTimeObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalUtil;

public class TemporalPlainTimeFunctionBuiltins
extends JSBuiltinsContainer.SwitchEnum<TemporalPlainTimeFunction> {
    public static final JSBuiltinsContainer BUILTINS = new TemporalPlainTimeFunctionBuiltins();

    protected TemporalPlainTimeFunctionBuiltins() {
        super(JSTemporalPlainTime.CLASS_NAME, TemporalPlainTimeFunction.class);
    }

    @Override
    protected Object createNode(JSContext context, JSBuiltin builtin, boolean construct, boolean newTarget, TemporalPlainTimeFunction builtinEnum) {
        switch (builtinEnum.ordinal()) {
            case 0: {
                return TemporalPlainTimeFunctionBuiltinsFactory.JSTemporalPlainTimeFromNodeGen.create(context, builtin, TemporalPlainTimeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
            case 1: {
                return TemporalPlainTimeFunctionBuiltinsFactory.JSTemporalPlainTimeCompareNodeGen.create(context, builtin, TemporalPlainTimeFunctionBuiltins.args().fixedArgs(2).createArgumentNodes(context));
            }
        }
        return null;
    }

    public static enum TemporalPlainTimeFunction implements BuiltinEnum<TemporalPlainTimeFunction>
    {
        from(1),
        compare(2);

        private final int length;

        private TemporalPlainTimeFunction(int length) {
            this.length = length;
        }

        @Override
        public int getLength() {
            return this.length;
        }
    }

    public static abstract class JSTemporalPlainTimeFromNode
    extends JSTemporalBuiltinOperation {
        public JSTemporalPlainTimeFromNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected JSTemporalPlainTimeObject from(Object item, Object options, @Cached ToTemporalTimeNode toTemporalTime) {
            return toTemporalTime.execute(item, options);
        }
    }

    public static abstract class JSTemporalPlainTimeCompareNode
    extends JSTemporalBuiltinOperation {
        public JSTemporalPlainTimeCompareNode(JSContext context, JSBuiltin builtin) {
            super(context, builtin);
        }

        @Specialization
        protected int compare(Object obj1, Object obj2, @Cached ToTemporalTimeNode toTemporalTime) {
            JSTemporalPlainTimeObject time1 = toTemporalTime.execute(obj1, (Object)Undefined.instance);
            JSTemporalPlainTimeObject time2 = toTemporalTime.execute(obj2, (Object)Undefined.instance);
            return TemporalUtil.compareTemporalTime(time1.getHour(), time1.getMinute(), time1.getSecond(), time1.getMillisecond(), time1.getMicrosecond(), time1.getNanosecond(), time2.getHour(), time2.getMinute(), time2.getSecond(), time2.getMillisecond(), time2.getMicrosecond(), time2.getNanosecond());
        }
    }
}

