/*
 * Decompiled with CFR 0.152.
 */
package net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor;

import java.util.ArrayList;
import java.util.List;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonServiceException;
import net.snowflake.client.jdbc.internal.amazonaws.AmazonWebServiceResponse;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.SdkProtectedApi;
import net.snowflake.client.jdbc.internal.amazonaws.annotation.ThreadSafe;
import net.snowflake.client.jdbc.internal.amazonaws.http.HttpResponseHandler;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.OperationInfo;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.Protocol;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.ProtocolRequestMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.RpcV2CborClientMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.RpcV2CborErrorResponseMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.RpcV2CborErrorShapeMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.RpcV2CborOperationMetadata;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.RpcV2CborProtocolMarshallerBuilder;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.SdkStructuredCborFactory;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.SdkStructuredRpcV2CborFactory;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.StructuredRpcV2CborGenerator;
import net.snowflake.client.jdbc.internal.amazonaws.protocol.rpcv2cbor.internal.EmptyBodyRpcV2CborMarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.transform.JsonErrorUnmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.transform.Unmarshaller;
import net.snowflake.client.jdbc.internal.amazonaws.transform.rpcv2cbor.RpcV2CborUnmarshallerContext;

@ThreadSafe
@SdkProtectedApi
public class SdkRpcV2CborProtocolFactory {
    private static String RPCV2CBOR = "application/cbor";
    private final RpcV2CborClientMetadata metadata;
    private final List<JsonErrorUnmarshaller> errorUnmarshallers = new ArrayList<JsonErrorUnmarshaller>();

    public SdkRpcV2CborProtocolFactory(RpcV2CborClientMetadata metadata) {
        this.metadata = metadata;
        this.createErrorUnmarshallers();
    }

    public StructuredRpcV2CborGenerator createGenerator() {
        return this.getSdkFactory().createWriter(this.getContentType());
    }

    public String getContentType() {
        return RPCV2CBOR;
    }

    public <T> ProtocolRequestMarshaller<T> createProtocolMarshaller(OperationInfo operationInfo, T origRequest) {
        return RpcV2CborProtocolMarshallerBuilder.standard().rpcv2cborGenerator(this.createGenerator(operationInfo)).contentType(this.getContentType()).operationInfo(operationInfo).originalRequest(origRequest).emptyBodyMarshaller(this.createEmptyBodyMarshaller(operationInfo)).withAwsQueryCompatible(this.metadata.getAwsQueryCompatible()).build();
    }

    private StructuredRpcV2CborGenerator createGenerator(OperationInfo operationInfo) {
        if (operationInfo.hasPayloadMembers() || operationInfo.protocol() == Protocol.RPCV2_CBOR) {
            return this.createGenerator();
        }
        return StructuredRpcV2CborGenerator.NO_OP;
    }

    private EmptyBodyRpcV2CborMarshaller createEmptyBodyMarshaller(OperationInfo operationInfo) {
        if (operationInfo.protocol() == Protocol.API_GATEWAY) {
            throw new IllegalStateException("Detected the API_GATEWAY protocol which should not be used with this protocol factory.");
        }
        if (!operationInfo.hasPayloadMembers() || operationInfo.protocol() == Protocol.API_GATEWAY) {
            return EmptyBodyRpcV2CborMarshaller.NULL;
        }
        return EmptyBodyRpcV2CborMarshaller.EMPTY;
    }

    public <T> HttpResponseHandler<AmazonWebServiceResponse<T>> createResponseHandler(RpcV2CborOperationMetadata operationMetadata, Unmarshaller<T, RpcV2CborUnmarshallerContext> responseUnmarshaller) {
        return this.getSdkFactory().createResponseHandler(operationMetadata, responseUnmarshaller);
    }

    public HttpResponseHandler<AmazonServiceException> createErrorResponseHandler(RpcV2CborErrorResponseMetadata errorResponsMetadata) {
        return this.getSdkFactory().createErrorResponseHandler(errorResponsMetadata, this.errorUnmarshallers);
    }

    private void createErrorUnmarshallers() {
        for (RpcV2CborErrorShapeMetadata errorMetadata : this.metadata.getErrorShapeMetadata()) {
            if (errorMetadata.getExceptionUnmarshaller() != null) {
                this.errorUnmarshallers.add(errorMetadata.getExceptionUnmarshaller());
                continue;
            }
            if (errorMetadata.getModeledClass() == null) continue;
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(errorMetadata.getModeledClass(), errorMetadata.getErrorCode()));
        }
        if (this.metadata.getBaseServiceExceptionClass() != null) {
            this.errorUnmarshallers.add(new JsonErrorUnmarshaller(this.metadata.getBaseServiceExceptionClass(), null));
        }
    }

    private SdkStructuredRpcV2CborFactory getSdkFactory() {
        return SdkStructuredCborFactory.SDK_CBOR_FACTORY;
    }
}

